/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datacatalog/v1/datacatalog.proto

package com.google.cloud.datacatalog.v1;

/**
 *
 *
 * <pre>
 * Metadata message for [long-running operation][google.longrunning.Operation]
 * returned by the
 * [ImportEntries][google.cloud.datacatalog.v1.DataCatalog.ImportEntries].
 * </pre>
 *
 * Protobuf type {@code google.cloud.datacatalog.v1.ImportEntriesMetadata}
 */
public final class ImportEntriesMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datacatalog.v1.ImportEntriesMetadata)
    ImportEntriesMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ImportEntriesMetadata.newBuilder() to construct.
  private ImportEntriesMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ImportEntriesMetadata() {
    state_ = 0;
    errors_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ImportEntriesMetadata();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datacatalog.v1.Datacatalog
        .internal_static_google_cloud_datacatalog_v1_ImportEntriesMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datacatalog.v1.Datacatalog
        .internal_static_google_cloud_datacatalog_v1_ImportEntriesMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datacatalog.v1.ImportEntriesMetadata.class,
            com.google.cloud.datacatalog.v1.ImportEntriesMetadata.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Enum holding possible states of the import operation.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.datacatalog.v1.ImportEntriesMetadata.ImportState}
   */
  public enum ImportState implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value. This value is unused.
     * </pre>
     *
     * <code>IMPORT_STATE_UNSPECIFIED = 0;</code>
     */
    IMPORT_STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The dump with entries has been queued for import.
     * </pre>
     *
     * <code>IMPORT_QUEUED = 1;</code>
     */
    IMPORT_QUEUED(1),
    /**
     *
     *
     * <pre>
     * The import of entries is in progress.
     * </pre>
     *
     * <code>IMPORT_IN_PROGRESS = 2;</code>
     */
    IMPORT_IN_PROGRESS(2),
    /**
     *
     *
     * <pre>
     * The import of entries has been finished.
     * </pre>
     *
     * <code>IMPORT_DONE = 3;</code>
     */
    IMPORT_DONE(3),
    /**
     *
     *
     * <pre>
     * The import of entries has been abandoned in favor of a newer request.
     * </pre>
     *
     * <code>IMPORT_OBSOLETE = 4;</code>
     */
    IMPORT_OBSOLETE(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value. This value is unused.
     * </pre>
     *
     * <code>IMPORT_STATE_UNSPECIFIED = 0;</code>
     */
    public static final int IMPORT_STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The dump with entries has been queued for import.
     * </pre>
     *
     * <code>IMPORT_QUEUED = 1;</code>
     */
    public static final int IMPORT_QUEUED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The import of entries is in progress.
     * </pre>
     *
     * <code>IMPORT_IN_PROGRESS = 2;</code>
     */
    public static final int IMPORT_IN_PROGRESS_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The import of entries has been finished.
     * </pre>
     *
     * <code>IMPORT_DONE = 3;</code>
     */
    public static final int IMPORT_DONE_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The import of entries has been abandoned in favor of a newer request.
     * </pre>
     *
     * <code>IMPORT_OBSOLETE = 4;</code>
     */
    public static final int IMPORT_OBSOLETE_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ImportState valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ImportState forNumber(int value) {
      switch (value) {
        case 0:
          return IMPORT_STATE_UNSPECIFIED;
        case 1:
          return IMPORT_QUEUED;
        case 2:
          return IMPORT_IN_PROGRESS;
        case 3:
          return IMPORT_DONE;
        case 4:
          return IMPORT_OBSOLETE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ImportState> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ImportState> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ImportState>() {
          public ImportState findValueByNumber(int number) {
            return ImportState.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.datacatalog.v1.ImportEntriesMetadata.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final ImportState[] VALUES = values();

    public static ImportState valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ImportState(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.datacatalog.v1.ImportEntriesMetadata.ImportState)
  }

  public static final int STATE_FIELD_NUMBER = 1;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * State of the import operation.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.ImportEntriesMetadata.ImportState state = 1;</code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * State of the import operation.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.ImportEntriesMetadata.ImportState state = 1;</code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.ImportEntriesMetadata.ImportState getState() {
    com.google.cloud.datacatalog.v1.ImportEntriesMetadata.ImportState result =
        com.google.cloud.datacatalog.v1.ImportEntriesMetadata.ImportState.forNumber(state_);
    return result == null
        ? com.google.cloud.datacatalog.v1.ImportEntriesMetadata.ImportState.UNRECOGNIZED
        : result;
  }

  public static final int ERRORS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.rpc.Status> errors_;
  /**
   *
   *
   * <pre>
   * Partial errors that are encountered during the ImportEntries operation.
   * There is no guarantee that all the encountered errors are reported.
   * However, if no errors are reported, it means that no errors were
   * encountered.
   * </pre>
   *
   * <code>repeated .google.rpc.Status errors = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.rpc.Status> getErrorsList() {
    return errors_;
  }
  /**
   *
   *
   * <pre>
   * Partial errors that are encountered during the ImportEntries operation.
   * There is no guarantee that all the encountered errors are reported.
   * However, if no errors are reported, it means that no errors were
   * encountered.
   * </pre>
   *
   * <code>repeated .google.rpc.Status errors = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.rpc.StatusOrBuilder> getErrorsOrBuilderList() {
    return errors_;
  }
  /**
   *
   *
   * <pre>
   * Partial errors that are encountered during the ImportEntries operation.
   * There is no guarantee that all the encountered errors are reported.
   * However, if no errors are reported, it means that no errors were
   * encountered.
   * </pre>
   *
   * <code>repeated .google.rpc.Status errors = 2;</code>
   */
  @java.lang.Override
  public int getErrorsCount() {
    return errors_.size();
  }
  /**
   *
   *
   * <pre>
   * Partial errors that are encountered during the ImportEntries operation.
   * There is no guarantee that all the encountered errors are reported.
   * However, if no errors are reported, it means that no errors were
   * encountered.
   * </pre>
   *
   * <code>repeated .google.rpc.Status errors = 2;</code>
   */
  @java.lang.Override
  public com.google.rpc.Status getErrors(int index) {
    return errors_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Partial errors that are encountered during the ImportEntries operation.
   * There is no guarantee that all the encountered errors are reported.
   * However, if no errors are reported, it means that no errors were
   * encountered.
   * </pre>
   *
   * <code>repeated .google.rpc.Status errors = 2;</code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getErrorsOrBuilder(int index) {
    return errors_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (state_
        != com.google.cloud.datacatalog.v1.ImportEntriesMetadata.ImportState
            .IMPORT_STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(1, state_);
    }
    for (int i = 0; i < errors_.size(); i++) {
      output.writeMessage(2, errors_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (state_
        != com.google.cloud.datacatalog.v1.ImportEntriesMetadata.ImportState
            .IMPORT_STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, state_);
    }
    for (int i = 0; i < errors_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, errors_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datacatalog.v1.ImportEntriesMetadata)) {
      return super.equals(obj);
    }
    com.google.cloud.datacatalog.v1.ImportEntriesMetadata other =
        (com.google.cloud.datacatalog.v1.ImportEntriesMetadata) obj;

    if (state_ != other.state_) return false;
    if (!getErrorsList().equals(other.getErrorsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (getErrorsCount() > 0) {
      hash = (37 * hash) + ERRORS_FIELD_NUMBER;
      hash = (53 * hash) + getErrorsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datacatalog.v1.ImportEntriesMetadata parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1.ImportEntriesMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.ImportEntriesMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1.ImportEntriesMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.ImportEntriesMetadata parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1.ImportEntriesMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.ImportEntriesMetadata parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1.ImportEntriesMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.ImportEntriesMetadata parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1.ImportEntriesMetadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.ImportEntriesMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1.ImportEntriesMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.datacatalog.v1.ImportEntriesMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Metadata message for [long-running operation][google.longrunning.Operation]
   * returned by the
   * [ImportEntries][google.cloud.datacatalog.v1.DataCatalog.ImportEntries].
   * </pre>
   *
   * Protobuf type {@code google.cloud.datacatalog.v1.ImportEntriesMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datacatalog.v1.ImportEntriesMetadata)
      com.google.cloud.datacatalog.v1.ImportEntriesMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datacatalog.v1.Datacatalog
          .internal_static_google_cloud_datacatalog_v1_ImportEntriesMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datacatalog.v1.Datacatalog
          .internal_static_google_cloud_datacatalog_v1_ImportEntriesMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datacatalog.v1.ImportEntriesMetadata.class,
              com.google.cloud.datacatalog.v1.ImportEntriesMetadata.Builder.class);
    }

    // Construct using com.google.cloud.datacatalog.v1.ImportEntriesMetadata.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      state_ = 0;
      if (errorsBuilder_ == null) {
        errors_ = java.util.Collections.emptyList();
      } else {
        errors_ = null;
        errorsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datacatalog.v1.Datacatalog
          .internal_static_google_cloud_datacatalog_v1_ImportEntriesMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.ImportEntriesMetadata getDefaultInstanceForType() {
      return com.google.cloud.datacatalog.v1.ImportEntriesMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.ImportEntriesMetadata build() {
      com.google.cloud.datacatalog.v1.ImportEntriesMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.ImportEntriesMetadata buildPartial() {
      com.google.cloud.datacatalog.v1.ImportEntriesMetadata result =
          new com.google.cloud.datacatalog.v1.ImportEntriesMetadata(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.datacatalog.v1.ImportEntriesMetadata result) {
      if (errorsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          errors_ = java.util.Collections.unmodifiableList(errors_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.errors_ = errors_;
      } else {
        result.errors_ = errorsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.datacatalog.v1.ImportEntriesMetadata result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.state_ = state_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datacatalog.v1.ImportEntriesMetadata) {
        return mergeFrom((com.google.cloud.datacatalog.v1.ImportEntriesMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datacatalog.v1.ImportEntriesMetadata other) {
      if (other == com.google.cloud.datacatalog.v1.ImportEntriesMetadata.getDefaultInstance())
        return this;
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (errorsBuilder_ == null) {
        if (!other.errors_.isEmpty()) {
          if (errors_.isEmpty()) {
            errors_ = other.errors_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureErrorsIsMutable();
            errors_.addAll(other.errors_);
          }
          onChanged();
        }
      } else {
        if (!other.errors_.isEmpty()) {
          if (errorsBuilder_.isEmpty()) {
            errorsBuilder_.dispose();
            errorsBuilder_ = null;
            errors_ = other.errors_;
            bitField0_ = (bitField0_ & ~0x00000002);
            errorsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getErrorsFieldBuilder()
                    : null;
          } else {
            errorsBuilder_.addAllMessages(other.errors_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                com.google.rpc.Status m =
                    input.readMessage(com.google.rpc.Status.parser(), extensionRegistry);
                if (errorsBuilder_ == null) {
                  ensureErrorsIsMutable();
                  errors_.add(m);
                } else {
                  errorsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * State of the import operation.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.ImportEntriesMetadata.ImportState state = 1;</code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * State of the import operation.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.ImportEntriesMetadata.ImportState state = 1;</code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * State of the import operation.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.ImportEntriesMetadata.ImportState state = 1;</code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1.ImportEntriesMetadata.ImportState getState() {
      com.google.cloud.datacatalog.v1.ImportEntriesMetadata.ImportState result =
          com.google.cloud.datacatalog.v1.ImportEntriesMetadata.ImportState.forNumber(state_);
      return result == null
          ? com.google.cloud.datacatalog.v1.ImportEntriesMetadata.ImportState.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * State of the import operation.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.ImportEntriesMetadata.ImportState state = 1;</code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(
        com.google.cloud.datacatalog.v1.ImportEntriesMetadata.ImportState value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * State of the import operation.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.ImportEntriesMetadata.ImportState state = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000001);
      state_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.rpc.Status> errors_ = java.util.Collections.emptyList();

    private void ensureErrorsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        errors_ = new java.util.ArrayList<com.google.rpc.Status>(errors_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        errorsBuilder_;

    /**
     *
     *
     * <pre>
     * Partial errors that are encountered during the ImportEntries operation.
     * There is no guarantee that all the encountered errors are reported.
     * However, if no errors are reported, it means that no errors were
     * encountered.
     * </pre>
     *
     * <code>repeated .google.rpc.Status errors = 2;</code>
     */
    public java.util.List<com.google.rpc.Status> getErrorsList() {
      if (errorsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(errors_);
      } else {
        return errorsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Partial errors that are encountered during the ImportEntries operation.
     * There is no guarantee that all the encountered errors are reported.
     * However, if no errors are reported, it means that no errors were
     * encountered.
     * </pre>
     *
     * <code>repeated .google.rpc.Status errors = 2;</code>
     */
    public int getErrorsCount() {
      if (errorsBuilder_ == null) {
        return errors_.size();
      } else {
        return errorsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Partial errors that are encountered during the ImportEntries operation.
     * There is no guarantee that all the encountered errors are reported.
     * However, if no errors are reported, it means that no errors were
     * encountered.
     * </pre>
     *
     * <code>repeated .google.rpc.Status errors = 2;</code>
     */
    public com.google.rpc.Status getErrors(int index) {
      if (errorsBuilder_ == null) {
        return errors_.get(index);
      } else {
        return errorsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Partial errors that are encountered during the ImportEntries operation.
     * There is no guarantee that all the encountered errors are reported.
     * However, if no errors are reported, it means that no errors were
     * encountered.
     * </pre>
     *
     * <code>repeated .google.rpc.Status errors = 2;</code>
     */
    public Builder setErrors(int index, com.google.rpc.Status value) {
      if (errorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureErrorsIsMutable();
        errors_.set(index, value);
        onChanged();
      } else {
        errorsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partial errors that are encountered during the ImportEntries operation.
     * There is no guarantee that all the encountered errors are reported.
     * However, if no errors are reported, it means that no errors were
     * encountered.
     * </pre>
     *
     * <code>repeated .google.rpc.Status errors = 2;</code>
     */
    public Builder setErrors(int index, com.google.rpc.Status.Builder builderForValue) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        errors_.set(index, builderForValue.build());
        onChanged();
      } else {
        errorsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partial errors that are encountered during the ImportEntries operation.
     * There is no guarantee that all the encountered errors are reported.
     * However, if no errors are reported, it means that no errors were
     * encountered.
     * </pre>
     *
     * <code>repeated .google.rpc.Status errors = 2;</code>
     */
    public Builder addErrors(com.google.rpc.Status value) {
      if (errorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureErrorsIsMutable();
        errors_.add(value);
        onChanged();
      } else {
        errorsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partial errors that are encountered during the ImportEntries operation.
     * There is no guarantee that all the encountered errors are reported.
     * However, if no errors are reported, it means that no errors were
     * encountered.
     * </pre>
     *
     * <code>repeated .google.rpc.Status errors = 2;</code>
     */
    public Builder addErrors(int index, com.google.rpc.Status value) {
      if (errorsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureErrorsIsMutable();
        errors_.add(index, value);
        onChanged();
      } else {
        errorsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partial errors that are encountered during the ImportEntries operation.
     * There is no guarantee that all the encountered errors are reported.
     * However, if no errors are reported, it means that no errors were
     * encountered.
     * </pre>
     *
     * <code>repeated .google.rpc.Status errors = 2;</code>
     */
    public Builder addErrors(com.google.rpc.Status.Builder builderForValue) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        errors_.add(builderForValue.build());
        onChanged();
      } else {
        errorsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partial errors that are encountered during the ImportEntries operation.
     * There is no guarantee that all the encountered errors are reported.
     * However, if no errors are reported, it means that no errors were
     * encountered.
     * </pre>
     *
     * <code>repeated .google.rpc.Status errors = 2;</code>
     */
    public Builder addErrors(int index, com.google.rpc.Status.Builder builderForValue) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        errors_.add(index, builderForValue.build());
        onChanged();
      } else {
        errorsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partial errors that are encountered during the ImportEntries operation.
     * There is no guarantee that all the encountered errors are reported.
     * However, if no errors are reported, it means that no errors were
     * encountered.
     * </pre>
     *
     * <code>repeated .google.rpc.Status errors = 2;</code>
     */
    public Builder addAllErrors(java.lang.Iterable<? extends com.google.rpc.Status> values) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, errors_);
        onChanged();
      } else {
        errorsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partial errors that are encountered during the ImportEntries operation.
     * There is no guarantee that all the encountered errors are reported.
     * However, if no errors are reported, it means that no errors were
     * encountered.
     * </pre>
     *
     * <code>repeated .google.rpc.Status errors = 2;</code>
     */
    public Builder clearErrors() {
      if (errorsBuilder_ == null) {
        errors_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        errorsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partial errors that are encountered during the ImportEntries operation.
     * There is no guarantee that all the encountered errors are reported.
     * However, if no errors are reported, it means that no errors were
     * encountered.
     * </pre>
     *
     * <code>repeated .google.rpc.Status errors = 2;</code>
     */
    public Builder removeErrors(int index) {
      if (errorsBuilder_ == null) {
        ensureErrorsIsMutable();
        errors_.remove(index);
        onChanged();
      } else {
        errorsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Partial errors that are encountered during the ImportEntries operation.
     * There is no guarantee that all the encountered errors are reported.
     * However, if no errors are reported, it means that no errors were
     * encountered.
     * </pre>
     *
     * <code>repeated .google.rpc.Status errors = 2;</code>
     */
    public com.google.rpc.Status.Builder getErrorsBuilder(int index) {
      return getErrorsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Partial errors that are encountered during the ImportEntries operation.
     * There is no guarantee that all the encountered errors are reported.
     * However, if no errors are reported, it means that no errors were
     * encountered.
     * </pre>
     *
     * <code>repeated .google.rpc.Status errors = 2;</code>
     */
    public com.google.rpc.StatusOrBuilder getErrorsOrBuilder(int index) {
      if (errorsBuilder_ == null) {
        return errors_.get(index);
      } else {
        return errorsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Partial errors that are encountered during the ImportEntries operation.
     * There is no guarantee that all the encountered errors are reported.
     * However, if no errors are reported, it means that no errors were
     * encountered.
     * </pre>
     *
     * <code>repeated .google.rpc.Status errors = 2;</code>
     */
    public java.util.List<? extends com.google.rpc.StatusOrBuilder> getErrorsOrBuilderList() {
      if (errorsBuilder_ != null) {
        return errorsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(errors_);
      }
    }
    /**
     *
     *
     * <pre>
     * Partial errors that are encountered during the ImportEntries operation.
     * There is no guarantee that all the encountered errors are reported.
     * However, if no errors are reported, it means that no errors were
     * encountered.
     * </pre>
     *
     * <code>repeated .google.rpc.Status errors = 2;</code>
     */
    public com.google.rpc.Status.Builder addErrorsBuilder() {
      return getErrorsFieldBuilder().addBuilder(com.google.rpc.Status.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Partial errors that are encountered during the ImportEntries operation.
     * There is no guarantee that all the encountered errors are reported.
     * However, if no errors are reported, it means that no errors were
     * encountered.
     * </pre>
     *
     * <code>repeated .google.rpc.Status errors = 2;</code>
     */
    public com.google.rpc.Status.Builder addErrorsBuilder(int index) {
      return getErrorsFieldBuilder().addBuilder(index, com.google.rpc.Status.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Partial errors that are encountered during the ImportEntries operation.
     * There is no guarantee that all the encountered errors are reported.
     * However, if no errors are reported, it means that no errors were
     * encountered.
     * </pre>
     *
     * <code>repeated .google.rpc.Status errors = 2;</code>
     */
    public java.util.List<com.google.rpc.Status.Builder> getErrorsBuilderList() {
      return getErrorsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getErrorsFieldBuilder() {
      if (errorsBuilder_ == null) {
        errorsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(
                errors_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        errors_ = null;
      }
      return errorsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datacatalog.v1.ImportEntriesMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datacatalog.v1.ImportEntriesMetadata)
  private static final com.google.cloud.datacatalog.v1.ImportEntriesMetadata DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datacatalog.v1.ImportEntriesMetadata();
  }

  public static com.google.cloud.datacatalog.v1.ImportEntriesMetadata getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ImportEntriesMetadata> PARSER =
      new com.google.protobuf.AbstractParser<ImportEntriesMetadata>() {
        @java.lang.Override
        public ImportEntriesMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ImportEntriesMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ImportEntriesMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datacatalog.v1.ImportEntriesMetadata getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
