/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datacatalog/v1/data_source.proto

package com.google.cloud.datacatalog.v1;

/**
 *
 *
 * <pre>
 * Details the properties of the underlying storage.
 * </pre>
 *
 * Protobuf type {@code google.cloud.datacatalog.v1.StorageProperties}
 */
public final class StorageProperties extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datacatalog.v1.StorageProperties)
    StoragePropertiesOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use StorageProperties.newBuilder() to construct.
  private StorageProperties(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private StorageProperties() {
    filePattern_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    fileType_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new StorageProperties();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datacatalog.v1.DataSourceProto
        .internal_static_google_cloud_datacatalog_v1_StorageProperties_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datacatalog.v1.DataSourceProto
        .internal_static_google_cloud_datacatalog_v1_StorageProperties_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datacatalog.v1.StorageProperties.class,
            com.google.cloud.datacatalog.v1.StorageProperties.Builder.class);
  }

  public static final int FILE_PATTERN_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringList filePattern_;
  /**
   *
   *
   * <pre>
   * Patterns to identify a set of files for this fileset.
   * Examples of a valid `file_pattern`:
   *  * `gs://bucket_name/dir/&#42;`: matches all files in the `bucket_name/dir`
   *                              directory
   *  * `gs://bucket_name/dir/&#42;*`: matches all files in the `bucket_name/dir`
   *                               and all subdirectories recursively
   *  * `gs://bucket_name/file*`: matches files prefixed by `file` in
   *                              `bucket_name`
   *  * `gs://bucket_name/??.txt`: matches files with two characters followed by
   *                               `.txt` in `bucket_name`
   *  * `gs://bucket_name/[aeiou].txt`: matches files that contain a single
   *                                    vowel character followed by `.txt` in
   *                                    `bucket_name`
   *  * `gs://bucket_name/[a-m].txt`: matches files that contain `a`, `b`, ...
   *                                  or `m` followed by `.txt` in `bucket_name`
   *  * `gs://bucket_name/a/&#42;&#47;b`: matches all files in `bucket_name` that match
   *                              the `a/&#42;&#47;b` pattern, such as `a/c/b`, `a/d/b`
   *  * `gs://another_bucket/a.txt`: matches `gs://another_bucket/a.txt`
   * </pre>
   *
   * <code>repeated string file_pattern = 1;</code>
   *
   * @return A list containing the filePattern.
   */
  public com.google.protobuf.ProtocolStringList getFilePatternList() {
    return filePattern_;
  }
  /**
   *
   *
   * <pre>
   * Patterns to identify a set of files for this fileset.
   * Examples of a valid `file_pattern`:
   *  * `gs://bucket_name/dir/&#42;`: matches all files in the `bucket_name/dir`
   *                              directory
   *  * `gs://bucket_name/dir/&#42;*`: matches all files in the `bucket_name/dir`
   *                               and all subdirectories recursively
   *  * `gs://bucket_name/file*`: matches files prefixed by `file` in
   *                              `bucket_name`
   *  * `gs://bucket_name/??.txt`: matches files with two characters followed by
   *                               `.txt` in `bucket_name`
   *  * `gs://bucket_name/[aeiou].txt`: matches files that contain a single
   *                                    vowel character followed by `.txt` in
   *                                    `bucket_name`
   *  * `gs://bucket_name/[a-m].txt`: matches files that contain `a`, `b`, ...
   *                                  or `m` followed by `.txt` in `bucket_name`
   *  * `gs://bucket_name/a/&#42;&#47;b`: matches all files in `bucket_name` that match
   *                              the `a/&#42;&#47;b` pattern, such as `a/c/b`, `a/d/b`
   *  * `gs://another_bucket/a.txt`: matches `gs://another_bucket/a.txt`
   * </pre>
   *
   * <code>repeated string file_pattern = 1;</code>
   *
   * @return The count of filePattern.
   */
  public int getFilePatternCount() {
    return filePattern_.size();
  }
  /**
   *
   *
   * <pre>
   * Patterns to identify a set of files for this fileset.
   * Examples of a valid `file_pattern`:
   *  * `gs://bucket_name/dir/&#42;`: matches all files in the `bucket_name/dir`
   *                              directory
   *  * `gs://bucket_name/dir/&#42;*`: matches all files in the `bucket_name/dir`
   *                               and all subdirectories recursively
   *  * `gs://bucket_name/file*`: matches files prefixed by `file` in
   *                              `bucket_name`
   *  * `gs://bucket_name/??.txt`: matches files with two characters followed by
   *                               `.txt` in `bucket_name`
   *  * `gs://bucket_name/[aeiou].txt`: matches files that contain a single
   *                                    vowel character followed by `.txt` in
   *                                    `bucket_name`
   *  * `gs://bucket_name/[a-m].txt`: matches files that contain `a`, `b`, ...
   *                                  or `m` followed by `.txt` in `bucket_name`
   *  * `gs://bucket_name/a/&#42;&#47;b`: matches all files in `bucket_name` that match
   *                              the `a/&#42;&#47;b` pattern, such as `a/c/b`, `a/d/b`
   *  * `gs://another_bucket/a.txt`: matches `gs://another_bucket/a.txt`
   * </pre>
   *
   * <code>repeated string file_pattern = 1;</code>
   *
   * @param index The index of the element to return.
   * @return The filePattern at the given index.
   */
  public java.lang.String getFilePattern(int index) {
    return filePattern_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Patterns to identify a set of files for this fileset.
   * Examples of a valid `file_pattern`:
   *  * `gs://bucket_name/dir/&#42;`: matches all files in the `bucket_name/dir`
   *                              directory
   *  * `gs://bucket_name/dir/&#42;*`: matches all files in the `bucket_name/dir`
   *                               and all subdirectories recursively
   *  * `gs://bucket_name/file*`: matches files prefixed by `file` in
   *                              `bucket_name`
   *  * `gs://bucket_name/??.txt`: matches files with two characters followed by
   *                               `.txt` in `bucket_name`
   *  * `gs://bucket_name/[aeiou].txt`: matches files that contain a single
   *                                    vowel character followed by `.txt` in
   *                                    `bucket_name`
   *  * `gs://bucket_name/[a-m].txt`: matches files that contain `a`, `b`, ...
   *                                  or `m` followed by `.txt` in `bucket_name`
   *  * `gs://bucket_name/a/&#42;&#47;b`: matches all files in `bucket_name` that match
   *                              the `a/&#42;&#47;b` pattern, such as `a/c/b`, `a/d/b`
   *  * `gs://another_bucket/a.txt`: matches `gs://another_bucket/a.txt`
   * </pre>
   *
   * <code>repeated string file_pattern = 1;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the filePattern at the given index.
   */
  public com.google.protobuf.ByteString getFilePatternBytes(int index) {
    return filePattern_.getByteString(index);
  }

  public static final int FILE_TYPE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object fileType_ = "";
  /**
   *
   *
   * <pre>
   * File type in MIME format, for example, `text/plain`.
   * </pre>
   *
   * <code>string file_type = 2;</code>
   *
   * @return The fileType.
   */
  @java.lang.Override
  public java.lang.String getFileType() {
    java.lang.Object ref = fileType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      fileType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * File type in MIME format, for example, `text/plain`.
   * </pre>
   *
   * <code>string file_type = 2;</code>
   *
   * @return The bytes for fileType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFileTypeBytes() {
    java.lang.Object ref = fileType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      fileType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < filePattern_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, filePattern_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fileType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, fileType_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < filePattern_.size(); i++) {
        dataSize += computeStringSizeNoTag(filePattern_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getFilePatternList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fileType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, fileType_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datacatalog.v1.StorageProperties)) {
      return super.equals(obj);
    }
    com.google.cloud.datacatalog.v1.StorageProperties other =
        (com.google.cloud.datacatalog.v1.StorageProperties) obj;

    if (!getFilePatternList().equals(other.getFilePatternList())) return false;
    if (!getFileType().equals(other.getFileType())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getFilePatternCount() > 0) {
      hash = (37 * hash) + FILE_PATTERN_FIELD_NUMBER;
      hash = (53 * hash) + getFilePatternList().hashCode();
    }
    hash = (37 * hash) + FILE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getFileType().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datacatalog.v1.StorageProperties parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1.StorageProperties parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.StorageProperties parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1.StorageProperties parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.StorageProperties parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1.StorageProperties parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.StorageProperties parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1.StorageProperties parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.StorageProperties parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1.StorageProperties parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.StorageProperties parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1.StorageProperties parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.datacatalog.v1.StorageProperties prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Details the properties of the underlying storage.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datacatalog.v1.StorageProperties}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datacatalog.v1.StorageProperties)
      com.google.cloud.datacatalog.v1.StoragePropertiesOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datacatalog.v1.DataSourceProto
          .internal_static_google_cloud_datacatalog_v1_StorageProperties_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datacatalog.v1.DataSourceProto
          .internal_static_google_cloud_datacatalog_v1_StorageProperties_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datacatalog.v1.StorageProperties.class,
              com.google.cloud.datacatalog.v1.StorageProperties.Builder.class);
    }

    // Construct using com.google.cloud.datacatalog.v1.StorageProperties.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      filePattern_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      fileType_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datacatalog.v1.DataSourceProto
          .internal_static_google_cloud_datacatalog_v1_StorageProperties_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.StorageProperties getDefaultInstanceForType() {
      return com.google.cloud.datacatalog.v1.StorageProperties.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.StorageProperties build() {
      com.google.cloud.datacatalog.v1.StorageProperties result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.StorageProperties buildPartial() {
      com.google.cloud.datacatalog.v1.StorageProperties result =
          new com.google.cloud.datacatalog.v1.StorageProperties(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.datacatalog.v1.StorageProperties result) {
      if (((bitField0_ & 0x00000001) != 0)) {
        filePattern_ = filePattern_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.filePattern_ = filePattern_;
    }

    private void buildPartial0(com.google.cloud.datacatalog.v1.StorageProperties result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.fileType_ = fileType_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datacatalog.v1.StorageProperties) {
        return mergeFrom((com.google.cloud.datacatalog.v1.StorageProperties) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datacatalog.v1.StorageProperties other) {
      if (other == com.google.cloud.datacatalog.v1.StorageProperties.getDefaultInstance())
        return this;
      if (!other.filePattern_.isEmpty()) {
        if (filePattern_.isEmpty()) {
          filePattern_ = other.filePattern_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureFilePatternIsMutable();
          filePattern_.addAll(other.filePattern_);
        }
        onChanged();
      }
      if (!other.getFileType().isEmpty()) {
        fileType_ = other.fileType_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureFilePatternIsMutable();
                filePattern_.add(s);
                break;
              } // case 10
            case 18:
              {
                fileType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.LazyStringList filePattern_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureFilePatternIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        filePattern_ = new com.google.protobuf.LazyStringArrayList(filePattern_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * Patterns to identify a set of files for this fileset.
     * Examples of a valid `file_pattern`:
     *  * `gs://bucket_name/dir/&#42;`: matches all files in the `bucket_name/dir`
     *                              directory
     *  * `gs://bucket_name/dir/&#42;*`: matches all files in the `bucket_name/dir`
     *                               and all subdirectories recursively
     *  * `gs://bucket_name/file*`: matches files prefixed by `file` in
     *                              `bucket_name`
     *  * `gs://bucket_name/??.txt`: matches files with two characters followed by
     *                               `.txt` in `bucket_name`
     *  * `gs://bucket_name/[aeiou].txt`: matches files that contain a single
     *                                    vowel character followed by `.txt` in
     *                                    `bucket_name`
     *  * `gs://bucket_name/[a-m].txt`: matches files that contain `a`, `b`, ...
     *                                  or `m` followed by `.txt` in `bucket_name`
     *  * `gs://bucket_name/a/&#42;&#47;b`: matches all files in `bucket_name` that match
     *                              the `a/&#42;&#47;b` pattern, such as `a/c/b`, `a/d/b`
     *  * `gs://another_bucket/a.txt`: matches `gs://another_bucket/a.txt`
     * </pre>
     *
     * <code>repeated string file_pattern = 1;</code>
     *
     * @return A list containing the filePattern.
     */
    public com.google.protobuf.ProtocolStringList getFilePatternList() {
      return filePattern_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * Patterns to identify a set of files for this fileset.
     * Examples of a valid `file_pattern`:
     *  * `gs://bucket_name/dir/&#42;`: matches all files in the `bucket_name/dir`
     *                              directory
     *  * `gs://bucket_name/dir/&#42;*`: matches all files in the `bucket_name/dir`
     *                               and all subdirectories recursively
     *  * `gs://bucket_name/file*`: matches files prefixed by `file` in
     *                              `bucket_name`
     *  * `gs://bucket_name/??.txt`: matches files with two characters followed by
     *                               `.txt` in `bucket_name`
     *  * `gs://bucket_name/[aeiou].txt`: matches files that contain a single
     *                                    vowel character followed by `.txt` in
     *                                    `bucket_name`
     *  * `gs://bucket_name/[a-m].txt`: matches files that contain `a`, `b`, ...
     *                                  or `m` followed by `.txt` in `bucket_name`
     *  * `gs://bucket_name/a/&#42;&#47;b`: matches all files in `bucket_name` that match
     *                              the `a/&#42;&#47;b` pattern, such as `a/c/b`, `a/d/b`
     *  * `gs://another_bucket/a.txt`: matches `gs://another_bucket/a.txt`
     * </pre>
     *
     * <code>repeated string file_pattern = 1;</code>
     *
     * @return The count of filePattern.
     */
    public int getFilePatternCount() {
      return filePattern_.size();
    }
    /**
     *
     *
     * <pre>
     * Patterns to identify a set of files for this fileset.
     * Examples of a valid `file_pattern`:
     *  * `gs://bucket_name/dir/&#42;`: matches all files in the `bucket_name/dir`
     *                              directory
     *  * `gs://bucket_name/dir/&#42;*`: matches all files in the `bucket_name/dir`
     *                               and all subdirectories recursively
     *  * `gs://bucket_name/file*`: matches files prefixed by `file` in
     *                              `bucket_name`
     *  * `gs://bucket_name/??.txt`: matches files with two characters followed by
     *                               `.txt` in `bucket_name`
     *  * `gs://bucket_name/[aeiou].txt`: matches files that contain a single
     *                                    vowel character followed by `.txt` in
     *                                    `bucket_name`
     *  * `gs://bucket_name/[a-m].txt`: matches files that contain `a`, `b`, ...
     *                                  or `m` followed by `.txt` in `bucket_name`
     *  * `gs://bucket_name/a/&#42;&#47;b`: matches all files in `bucket_name` that match
     *                              the `a/&#42;&#47;b` pattern, such as `a/c/b`, `a/d/b`
     *  * `gs://another_bucket/a.txt`: matches `gs://another_bucket/a.txt`
     * </pre>
     *
     * <code>repeated string file_pattern = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The filePattern at the given index.
     */
    public java.lang.String getFilePattern(int index) {
      return filePattern_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Patterns to identify a set of files for this fileset.
     * Examples of a valid `file_pattern`:
     *  * `gs://bucket_name/dir/&#42;`: matches all files in the `bucket_name/dir`
     *                              directory
     *  * `gs://bucket_name/dir/&#42;*`: matches all files in the `bucket_name/dir`
     *                               and all subdirectories recursively
     *  * `gs://bucket_name/file*`: matches files prefixed by `file` in
     *                              `bucket_name`
     *  * `gs://bucket_name/??.txt`: matches files with two characters followed by
     *                               `.txt` in `bucket_name`
     *  * `gs://bucket_name/[aeiou].txt`: matches files that contain a single
     *                                    vowel character followed by `.txt` in
     *                                    `bucket_name`
     *  * `gs://bucket_name/[a-m].txt`: matches files that contain `a`, `b`, ...
     *                                  or `m` followed by `.txt` in `bucket_name`
     *  * `gs://bucket_name/a/&#42;&#47;b`: matches all files in `bucket_name` that match
     *                              the `a/&#42;&#47;b` pattern, such as `a/c/b`, `a/d/b`
     *  * `gs://another_bucket/a.txt`: matches `gs://another_bucket/a.txt`
     * </pre>
     *
     * <code>repeated string file_pattern = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the filePattern at the given index.
     */
    public com.google.protobuf.ByteString getFilePatternBytes(int index) {
      return filePattern_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Patterns to identify a set of files for this fileset.
     * Examples of a valid `file_pattern`:
     *  * `gs://bucket_name/dir/&#42;`: matches all files in the `bucket_name/dir`
     *                              directory
     *  * `gs://bucket_name/dir/&#42;*`: matches all files in the `bucket_name/dir`
     *                               and all subdirectories recursively
     *  * `gs://bucket_name/file*`: matches files prefixed by `file` in
     *                              `bucket_name`
     *  * `gs://bucket_name/??.txt`: matches files with two characters followed by
     *                               `.txt` in `bucket_name`
     *  * `gs://bucket_name/[aeiou].txt`: matches files that contain a single
     *                                    vowel character followed by `.txt` in
     *                                    `bucket_name`
     *  * `gs://bucket_name/[a-m].txt`: matches files that contain `a`, `b`, ...
     *                                  or `m` followed by `.txt` in `bucket_name`
     *  * `gs://bucket_name/a/&#42;&#47;b`: matches all files in `bucket_name` that match
     *                              the `a/&#42;&#47;b` pattern, such as `a/c/b`, `a/d/b`
     *  * `gs://another_bucket/a.txt`: matches `gs://another_bucket/a.txt`
     * </pre>
     *
     * <code>repeated string file_pattern = 1;</code>
     *
     * @param index The index to set the value at.
     * @param value The filePattern to set.
     * @return This builder for chaining.
     */
    public Builder setFilePattern(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureFilePatternIsMutable();
      filePattern_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Patterns to identify a set of files for this fileset.
     * Examples of a valid `file_pattern`:
     *  * `gs://bucket_name/dir/&#42;`: matches all files in the `bucket_name/dir`
     *                              directory
     *  * `gs://bucket_name/dir/&#42;*`: matches all files in the `bucket_name/dir`
     *                               and all subdirectories recursively
     *  * `gs://bucket_name/file*`: matches files prefixed by `file` in
     *                              `bucket_name`
     *  * `gs://bucket_name/??.txt`: matches files with two characters followed by
     *                               `.txt` in `bucket_name`
     *  * `gs://bucket_name/[aeiou].txt`: matches files that contain a single
     *                                    vowel character followed by `.txt` in
     *                                    `bucket_name`
     *  * `gs://bucket_name/[a-m].txt`: matches files that contain `a`, `b`, ...
     *                                  or `m` followed by `.txt` in `bucket_name`
     *  * `gs://bucket_name/a/&#42;&#47;b`: matches all files in `bucket_name` that match
     *                              the `a/&#42;&#47;b` pattern, such as `a/c/b`, `a/d/b`
     *  * `gs://another_bucket/a.txt`: matches `gs://another_bucket/a.txt`
     * </pre>
     *
     * <code>repeated string file_pattern = 1;</code>
     *
     * @param value The filePattern to add.
     * @return This builder for chaining.
     */
    public Builder addFilePattern(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureFilePatternIsMutable();
      filePattern_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Patterns to identify a set of files for this fileset.
     * Examples of a valid `file_pattern`:
     *  * `gs://bucket_name/dir/&#42;`: matches all files in the `bucket_name/dir`
     *                              directory
     *  * `gs://bucket_name/dir/&#42;*`: matches all files in the `bucket_name/dir`
     *                               and all subdirectories recursively
     *  * `gs://bucket_name/file*`: matches files prefixed by `file` in
     *                              `bucket_name`
     *  * `gs://bucket_name/??.txt`: matches files with two characters followed by
     *                               `.txt` in `bucket_name`
     *  * `gs://bucket_name/[aeiou].txt`: matches files that contain a single
     *                                    vowel character followed by `.txt` in
     *                                    `bucket_name`
     *  * `gs://bucket_name/[a-m].txt`: matches files that contain `a`, `b`, ...
     *                                  or `m` followed by `.txt` in `bucket_name`
     *  * `gs://bucket_name/a/&#42;&#47;b`: matches all files in `bucket_name` that match
     *                              the `a/&#42;&#47;b` pattern, such as `a/c/b`, `a/d/b`
     *  * `gs://another_bucket/a.txt`: matches `gs://another_bucket/a.txt`
     * </pre>
     *
     * <code>repeated string file_pattern = 1;</code>
     *
     * @param values The filePattern to add.
     * @return This builder for chaining.
     */
    public Builder addAllFilePattern(java.lang.Iterable<java.lang.String> values) {
      ensureFilePatternIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, filePattern_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Patterns to identify a set of files for this fileset.
     * Examples of a valid `file_pattern`:
     *  * `gs://bucket_name/dir/&#42;`: matches all files in the `bucket_name/dir`
     *                              directory
     *  * `gs://bucket_name/dir/&#42;*`: matches all files in the `bucket_name/dir`
     *                               and all subdirectories recursively
     *  * `gs://bucket_name/file*`: matches files prefixed by `file` in
     *                              `bucket_name`
     *  * `gs://bucket_name/??.txt`: matches files with two characters followed by
     *                               `.txt` in `bucket_name`
     *  * `gs://bucket_name/[aeiou].txt`: matches files that contain a single
     *                                    vowel character followed by `.txt` in
     *                                    `bucket_name`
     *  * `gs://bucket_name/[a-m].txt`: matches files that contain `a`, `b`, ...
     *                                  or `m` followed by `.txt` in `bucket_name`
     *  * `gs://bucket_name/a/&#42;&#47;b`: matches all files in `bucket_name` that match
     *                              the `a/&#42;&#47;b` pattern, such as `a/c/b`, `a/d/b`
     *  * `gs://another_bucket/a.txt`: matches `gs://another_bucket/a.txt`
     * </pre>
     *
     * <code>repeated string file_pattern = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFilePattern() {
      filePattern_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Patterns to identify a set of files for this fileset.
     * Examples of a valid `file_pattern`:
     *  * `gs://bucket_name/dir/&#42;`: matches all files in the `bucket_name/dir`
     *                              directory
     *  * `gs://bucket_name/dir/&#42;*`: matches all files in the `bucket_name/dir`
     *                               and all subdirectories recursively
     *  * `gs://bucket_name/file*`: matches files prefixed by `file` in
     *                              `bucket_name`
     *  * `gs://bucket_name/??.txt`: matches files with two characters followed by
     *                               `.txt` in `bucket_name`
     *  * `gs://bucket_name/[aeiou].txt`: matches files that contain a single
     *                                    vowel character followed by `.txt` in
     *                                    `bucket_name`
     *  * `gs://bucket_name/[a-m].txt`: matches files that contain `a`, `b`, ...
     *                                  or `m` followed by `.txt` in `bucket_name`
     *  * `gs://bucket_name/a/&#42;&#47;b`: matches all files in `bucket_name` that match
     *                              the `a/&#42;&#47;b` pattern, such as `a/c/b`, `a/d/b`
     *  * `gs://another_bucket/a.txt`: matches `gs://another_bucket/a.txt`
     * </pre>
     *
     * <code>repeated string file_pattern = 1;</code>
     *
     * @param value The bytes of the filePattern to add.
     * @return This builder for chaining.
     */
    public Builder addFilePatternBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureFilePatternIsMutable();
      filePattern_.add(value);
      onChanged();
      return this;
    }

    private java.lang.Object fileType_ = "";
    /**
     *
     *
     * <pre>
     * File type in MIME format, for example, `text/plain`.
     * </pre>
     *
     * <code>string file_type = 2;</code>
     *
     * @return The fileType.
     */
    public java.lang.String getFileType() {
      java.lang.Object ref = fileType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fileType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * File type in MIME format, for example, `text/plain`.
     * </pre>
     *
     * <code>string file_type = 2;</code>
     *
     * @return The bytes for fileType.
     */
    public com.google.protobuf.ByteString getFileTypeBytes() {
      java.lang.Object ref = fileType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        fileType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * File type in MIME format, for example, `text/plain`.
     * </pre>
     *
     * <code>string file_type = 2;</code>
     *
     * @param value The fileType to set.
     * @return This builder for chaining.
     */
    public Builder setFileType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      fileType_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * File type in MIME format, for example, `text/plain`.
     * </pre>
     *
     * <code>string file_type = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFileType() {
      fileType_ = getDefaultInstance().getFileType();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * File type in MIME format, for example, `text/plain`.
     * </pre>
     *
     * <code>string file_type = 2;</code>
     *
     * @param value The bytes for fileType to set.
     * @return This builder for chaining.
     */
    public Builder setFileTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      fileType_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datacatalog.v1.StorageProperties)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datacatalog.v1.StorageProperties)
  private static final com.google.cloud.datacatalog.v1.StorageProperties DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datacatalog.v1.StorageProperties();
  }

  public static com.google.cloud.datacatalog.v1.StorageProperties getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<StorageProperties> PARSER =
      new com.google.protobuf.AbstractParser<StorageProperties>() {
        @java.lang.Override
        public StorageProperties parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<StorageProperties> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<StorageProperties> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datacatalog.v1.StorageProperties getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
