/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datacatalog/v1/datacatalog.proto

package com.google.cloud.datacatalog.v1;

/**
 *
 *
 * <pre>
 * Specification that applies to a routine. Valid only for
 * entries with the `ROUTINE` type.
 * </pre>
 *
 * Protobuf type {@code google.cloud.datacatalog.v1.RoutineSpec}
 */
public final class RoutineSpec extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datacatalog.v1.RoutineSpec)
    RoutineSpecOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RoutineSpec.newBuilder() to construct.
  private RoutineSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RoutineSpec() {
    routineType_ = 0;
    language_ = "";
    routineArguments_ = java.util.Collections.emptyList();
    returnType_ = "";
    definitionBody_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RoutineSpec();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datacatalog.v1.Datacatalog
        .internal_static_google_cloud_datacatalog_v1_RoutineSpec_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datacatalog.v1.Datacatalog
        .internal_static_google_cloud_datacatalog_v1_RoutineSpec_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datacatalog.v1.RoutineSpec.class,
            com.google.cloud.datacatalog.v1.RoutineSpec.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The fine-grained type of the routine.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.datacatalog.v1.RoutineSpec.RoutineType}
   */
  public enum RoutineType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified type.
     * </pre>
     *
     * <code>ROUTINE_TYPE_UNSPECIFIED = 0;</code>
     */
    ROUTINE_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Non-builtin permanent scalar function.
     * </pre>
     *
     * <code>SCALAR_FUNCTION = 1;</code>
     */
    SCALAR_FUNCTION(1),
    /**
     *
     *
     * <pre>
     * Stored procedure.
     * </pre>
     *
     * <code>PROCEDURE = 2;</code>
     */
    PROCEDURE(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified type.
     * </pre>
     *
     * <code>ROUTINE_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int ROUTINE_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Non-builtin permanent scalar function.
     * </pre>
     *
     * <code>SCALAR_FUNCTION = 1;</code>
     */
    public static final int SCALAR_FUNCTION_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Stored procedure.
     * </pre>
     *
     * <code>PROCEDURE = 2;</code>
     */
    public static final int PROCEDURE_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RoutineType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static RoutineType forNumber(int value) {
      switch (value) {
        case 0:
          return ROUTINE_TYPE_UNSPECIFIED;
        case 1:
          return SCALAR_FUNCTION;
        case 2:
          return PROCEDURE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<RoutineType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<RoutineType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<RoutineType>() {
          public RoutineType findValueByNumber(int number) {
            return RoutineType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.datacatalog.v1.RoutineSpec.getDescriptor().getEnumTypes().get(0);
    }

    private static final RoutineType[] VALUES = values();

    public static RoutineType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private RoutineType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.datacatalog.v1.RoutineSpec.RoutineType)
  }

  public interface ArgumentOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.datacatalog.v1.RoutineSpec.Argument)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The name of the argument. A return argument of a function might not have
     * a name.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * The name of the argument. A return argument of a function might not have
     * a name.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();

    /**
     *
     *
     * <pre>
     * Specifies whether the argument is input or output.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.RoutineSpec.Argument.Mode mode = 2;</code>
     *
     * @return The enum numeric value on the wire for mode.
     */
    int getModeValue();
    /**
     *
     *
     * <pre>
     * Specifies whether the argument is input or output.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.RoutineSpec.Argument.Mode mode = 2;</code>
     *
     * @return The mode.
     */
    com.google.cloud.datacatalog.v1.RoutineSpec.Argument.Mode getMode();

    /**
     *
     *
     * <pre>
     * Type of the argument. The exact value depends on the source system and
     * the language.
     * </pre>
     *
     * <code>string type = 3;</code>
     *
     * @return The type.
     */
    java.lang.String getType();
    /**
     *
     *
     * <pre>
     * Type of the argument. The exact value depends on the source system and
     * the language.
     * </pre>
     *
     * <code>string type = 3;</code>
     *
     * @return The bytes for type.
     */
    com.google.protobuf.ByteString getTypeBytes();
  }
  /**
   *
   *
   * <pre>
   * Input or output argument of a function or stored procedure.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datacatalog.v1.RoutineSpec.Argument}
   */
  public static final class Argument extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.datacatalog.v1.RoutineSpec.Argument)
      ArgumentOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Argument.newBuilder() to construct.
    private Argument(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Argument() {
      name_ = "";
      mode_ = 0;
      type_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Argument();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datacatalog.v1.Datacatalog
          .internal_static_google_cloud_datacatalog_v1_RoutineSpec_Argument_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datacatalog.v1.Datacatalog
          .internal_static_google_cloud_datacatalog_v1_RoutineSpec_Argument_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datacatalog.v1.RoutineSpec.Argument.class,
              com.google.cloud.datacatalog.v1.RoutineSpec.Argument.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * The input or output mode of the argument.
     * </pre>
     *
     * Protobuf enum {@code google.cloud.datacatalog.v1.RoutineSpec.Argument.Mode}
     */
    public enum Mode implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Unspecified mode.
       * </pre>
       *
       * <code>MODE_UNSPECIFIED = 0;</code>
       */
      MODE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * The argument is input-only.
       * </pre>
       *
       * <code>IN = 1;</code>
       */
      IN(1),
      /**
       *
       *
       * <pre>
       * The argument is output-only.
       * </pre>
       *
       * <code>OUT = 2;</code>
       */
      OUT(2),
      /**
       *
       *
       * <pre>
       * The argument is both an input and an output.
       * </pre>
       *
       * <code>INOUT = 3;</code>
       */
      INOUT(3),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Unspecified mode.
       * </pre>
       *
       * <code>MODE_UNSPECIFIED = 0;</code>
       */
      public static final int MODE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * The argument is input-only.
       * </pre>
       *
       * <code>IN = 1;</code>
       */
      public static final int IN_VALUE = 1;
      /**
       *
       *
       * <pre>
       * The argument is output-only.
       * </pre>
       *
       * <code>OUT = 2;</code>
       */
      public static final int OUT_VALUE = 2;
      /**
       *
       *
       * <pre>
       * The argument is both an input and an output.
       * </pre>
       *
       * <code>INOUT = 3;</code>
       */
      public static final int INOUT_VALUE = 3;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Mode valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Mode forNumber(int value) {
        switch (value) {
          case 0:
            return MODE_UNSPECIFIED;
          case 1:
            return IN;
          case 2:
            return OUT;
          case 3:
            return INOUT;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Mode> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<Mode> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Mode>() {
            public Mode findValueByNumber(int number) {
              return Mode.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.datacatalog.v1.RoutineSpec.Argument.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final Mode[] VALUES = values();

      public static Mode valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Mode(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.datacatalog.v1.RoutineSpec.Argument.Mode)
    }

    public static final int NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The name of the argument. A return argument of a function might not have
     * a name.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the argument. A return argument of a function might not have
     * a name.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int MODE_FIELD_NUMBER = 2;
    private int mode_ = 0;
    /**
     *
     *
     * <pre>
     * Specifies whether the argument is input or output.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.RoutineSpec.Argument.Mode mode = 2;</code>
     *
     * @return The enum numeric value on the wire for mode.
     */
    @java.lang.Override
    public int getModeValue() {
      return mode_;
    }
    /**
     *
     *
     * <pre>
     * Specifies whether the argument is input or output.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.RoutineSpec.Argument.Mode mode = 2;</code>
     *
     * @return The mode.
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1.RoutineSpec.Argument.Mode getMode() {
      com.google.cloud.datacatalog.v1.RoutineSpec.Argument.Mode result =
          com.google.cloud.datacatalog.v1.RoutineSpec.Argument.Mode.forNumber(mode_);
      return result == null
          ? com.google.cloud.datacatalog.v1.RoutineSpec.Argument.Mode.UNRECOGNIZED
          : result;
    }

    public static final int TYPE_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object type_ = "";
    /**
     *
     *
     * <pre>
     * Type of the argument. The exact value depends on the source system and
     * the language.
     * </pre>
     *
     * <code>string type = 3;</code>
     *
     * @return The type.
     */
    @java.lang.Override
    public java.lang.String getType() {
      java.lang.Object ref = type_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        type_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Type of the argument. The exact value depends on the source system and
     * the language.
     * </pre>
     *
     * <code>string type = 3;</code>
     *
     * @return The bytes for type.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTypeBytes() {
      java.lang.Object ref = type_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        type_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      if (mode_
          != com.google.cloud.datacatalog.v1.RoutineSpec.Argument.Mode.MODE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(2, mode_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, type_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      if (mode_
          != com.google.cloud.datacatalog.v1.RoutineSpec.Argument.Mode.MODE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, mode_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(type_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, type_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.datacatalog.v1.RoutineSpec.Argument)) {
        return super.equals(obj);
      }
      com.google.cloud.datacatalog.v1.RoutineSpec.Argument other =
          (com.google.cloud.datacatalog.v1.RoutineSpec.Argument) obj;

      if (!getName().equals(other.getName())) return false;
      if (mode_ != other.mode_) return false;
      if (!getType().equals(other.getType())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (37 * hash) + MODE_FIELD_NUMBER;
      hash = (53 * hash) + mode_;
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getType().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.datacatalog.v1.RoutineSpec.Argument parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datacatalog.v1.RoutineSpec.Argument parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.RoutineSpec.Argument parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datacatalog.v1.RoutineSpec.Argument parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.RoutineSpec.Argument parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datacatalog.v1.RoutineSpec.Argument parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.RoutineSpec.Argument parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.datacatalog.v1.RoutineSpec.Argument parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.RoutineSpec.Argument parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.datacatalog.v1.RoutineSpec.Argument parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.RoutineSpec.Argument parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.datacatalog.v1.RoutineSpec.Argument parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.datacatalog.v1.RoutineSpec.Argument prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Input or output argument of a function or stored procedure.
     * </pre>
     *
     * Protobuf type {@code google.cloud.datacatalog.v1.RoutineSpec.Argument}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.datacatalog.v1.RoutineSpec.Argument)
        com.google.cloud.datacatalog.v1.RoutineSpec.ArgumentOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.datacatalog.v1.Datacatalog
            .internal_static_google_cloud_datacatalog_v1_RoutineSpec_Argument_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.datacatalog.v1.Datacatalog
            .internal_static_google_cloud_datacatalog_v1_RoutineSpec_Argument_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.datacatalog.v1.RoutineSpec.Argument.class,
                com.google.cloud.datacatalog.v1.RoutineSpec.Argument.Builder.class);
      }

      // Construct using com.google.cloud.datacatalog.v1.RoutineSpec.Argument.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        name_ = "";
        mode_ = 0;
        type_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.datacatalog.v1.Datacatalog
            .internal_static_google_cloud_datacatalog_v1_RoutineSpec_Argument_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.datacatalog.v1.RoutineSpec.Argument getDefaultInstanceForType() {
        return com.google.cloud.datacatalog.v1.RoutineSpec.Argument.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.datacatalog.v1.RoutineSpec.Argument build() {
        com.google.cloud.datacatalog.v1.RoutineSpec.Argument result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.datacatalog.v1.RoutineSpec.Argument buildPartial() {
        com.google.cloud.datacatalog.v1.RoutineSpec.Argument result =
            new com.google.cloud.datacatalog.v1.RoutineSpec.Argument(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.datacatalog.v1.RoutineSpec.Argument result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.name_ = name_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.mode_ = mode_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.type_ = type_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.datacatalog.v1.RoutineSpec.Argument) {
          return mergeFrom((com.google.cloud.datacatalog.v1.RoutineSpec.Argument) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.datacatalog.v1.RoutineSpec.Argument other) {
        if (other == com.google.cloud.datacatalog.v1.RoutineSpec.Argument.getDefaultInstance())
          return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.mode_ != 0) {
          setModeValue(other.getModeValue());
        }
        if (!other.getType().isEmpty()) {
          type_ = other.type_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  name_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  mode_ = input.readEnum();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 26:
                {
                  type_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * The name of the argument. A return argument of a function might not have
       * a name.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the argument. A return argument of a function might not have
       * a name.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The name of the argument. A return argument of a function might not have
       * a name.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the argument. A return argument of a function might not have
       * a name.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {
        name_ = getDefaultInstance().getName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The name of the argument. A return argument of a function might not have
       * a name.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private int mode_ = 0;
      /**
       *
       *
       * <pre>
       * Specifies whether the argument is input or output.
       * </pre>
       *
       * <code>.google.cloud.datacatalog.v1.RoutineSpec.Argument.Mode mode = 2;</code>
       *
       * @return The enum numeric value on the wire for mode.
       */
      @java.lang.Override
      public int getModeValue() {
        return mode_;
      }
      /**
       *
       *
       * <pre>
       * Specifies whether the argument is input or output.
       * </pre>
       *
       * <code>.google.cloud.datacatalog.v1.RoutineSpec.Argument.Mode mode = 2;</code>
       *
       * @param value The enum numeric value on the wire for mode to set.
       * @return This builder for chaining.
       */
      public Builder setModeValue(int value) {
        mode_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies whether the argument is input or output.
       * </pre>
       *
       * <code>.google.cloud.datacatalog.v1.RoutineSpec.Argument.Mode mode = 2;</code>
       *
       * @return The mode.
       */
      @java.lang.Override
      public com.google.cloud.datacatalog.v1.RoutineSpec.Argument.Mode getMode() {
        com.google.cloud.datacatalog.v1.RoutineSpec.Argument.Mode result =
            com.google.cloud.datacatalog.v1.RoutineSpec.Argument.Mode.forNumber(mode_);
        return result == null
            ? com.google.cloud.datacatalog.v1.RoutineSpec.Argument.Mode.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Specifies whether the argument is input or output.
       * </pre>
       *
       * <code>.google.cloud.datacatalog.v1.RoutineSpec.Argument.Mode mode = 2;</code>
       *
       * @param value The mode to set.
       * @return This builder for chaining.
       */
      public Builder setMode(com.google.cloud.datacatalog.v1.RoutineSpec.Argument.Mode value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        mode_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specifies whether the argument is input or output.
       * </pre>
       *
       * <code>.google.cloud.datacatalog.v1.RoutineSpec.Argument.Mode mode = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMode() {
        bitField0_ = (bitField0_ & ~0x00000002);
        mode_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object type_ = "";
      /**
       *
       *
       * <pre>
       * Type of the argument. The exact value depends on the source system and
       * the language.
       * </pre>
       *
       * <code>string type = 3;</code>
       *
       * @return The type.
       */
      public java.lang.String getType() {
        java.lang.Object ref = type_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          type_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Type of the argument. The exact value depends on the source system and
       * the language.
       * </pre>
       *
       * <code>string type = 3;</code>
       *
       * @return The bytes for type.
       */
      public com.google.protobuf.ByteString getTypeBytes() {
        java.lang.Object ref = type_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          type_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Type of the argument. The exact value depends on the source system and
       * the language.
       * </pre>
       *
       * <code>string type = 3;</code>
       *
       * @param value The type to set.
       * @return This builder for chaining.
       */
      public Builder setType(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        type_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Type of the argument. The exact value depends on the source system and
       * the language.
       * </pre>
       *
       * <code>string type = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearType() {
        type_ = getDefaultInstance().getType();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Type of the argument. The exact value depends on the source system and
       * the language.
       * </pre>
       *
       * <code>string type = 3;</code>
       *
       * @param value The bytes for type to set.
       * @return This builder for chaining.
       */
      public Builder setTypeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        type_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.datacatalog.v1.RoutineSpec.Argument)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.datacatalog.v1.RoutineSpec.Argument)
    private static final com.google.cloud.datacatalog.v1.RoutineSpec.Argument DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.datacatalog.v1.RoutineSpec.Argument();
    }

    public static com.google.cloud.datacatalog.v1.RoutineSpec.Argument getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Argument> PARSER =
        new com.google.protobuf.AbstractParser<Argument>() {
          @java.lang.Override
          public Argument parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Argument> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Argument> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.RoutineSpec.Argument getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int systemSpecCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object systemSpec_;

  public enum SystemSpecCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    BIGQUERY_ROUTINE_SPEC(6),
    SYSTEMSPEC_NOT_SET(0);
    private final int value;

    private SystemSpecCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SystemSpecCase valueOf(int value) {
      return forNumber(value);
    }

    public static SystemSpecCase forNumber(int value) {
      switch (value) {
        case 6:
          return BIGQUERY_ROUTINE_SPEC;
        case 0:
          return SYSTEMSPEC_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SystemSpecCase getSystemSpecCase() {
    return SystemSpecCase.forNumber(systemSpecCase_);
  }

  public static final int ROUTINE_TYPE_FIELD_NUMBER = 1;
  private int routineType_ = 0;
  /**
   *
   *
   * <pre>
   * The type of the routine.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.RoutineSpec.RoutineType routine_type = 1;</code>
   *
   * @return The enum numeric value on the wire for routineType.
   */
  @java.lang.Override
  public int getRoutineTypeValue() {
    return routineType_;
  }
  /**
   *
   *
   * <pre>
   * The type of the routine.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.RoutineSpec.RoutineType routine_type = 1;</code>
   *
   * @return The routineType.
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.RoutineSpec.RoutineType getRoutineType() {
    com.google.cloud.datacatalog.v1.RoutineSpec.RoutineType result =
        com.google.cloud.datacatalog.v1.RoutineSpec.RoutineType.forNumber(routineType_);
    return result == null
        ? com.google.cloud.datacatalog.v1.RoutineSpec.RoutineType.UNRECOGNIZED
        : result;
  }

  public static final int LANGUAGE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object language_ = "";
  /**
   *
   *
   * <pre>
   * The language the routine is written in. The exact value depends on the
   * source system. For BigQuery routines, possible values are:
   *
   * * `SQL`
   * * `JAVASCRIPT`
   * </pre>
   *
   * <code>string language = 2;</code>
   *
   * @return The language.
   */
  @java.lang.Override
  public java.lang.String getLanguage() {
    java.lang.Object ref = language_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      language_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The language the routine is written in. The exact value depends on the
   * source system. For BigQuery routines, possible values are:
   *
   * * `SQL`
   * * `JAVASCRIPT`
   * </pre>
   *
   * <code>string language = 2;</code>
   *
   * @return The bytes for language.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLanguageBytes() {
    java.lang.Object ref = language_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      language_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ROUTINE_ARGUMENTS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.datacatalog.v1.RoutineSpec.Argument> routineArguments_;
  /**
   *
   *
   * <pre>
   * Arguments of the routine.
   * </pre>
   *
   * <code>repeated .google.cloud.datacatalog.v1.RoutineSpec.Argument routine_arguments = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.datacatalog.v1.RoutineSpec.Argument>
      getRoutineArgumentsList() {
    return routineArguments_;
  }
  /**
   *
   *
   * <pre>
   * Arguments of the routine.
   * </pre>
   *
   * <code>repeated .google.cloud.datacatalog.v1.RoutineSpec.Argument routine_arguments = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.datacatalog.v1.RoutineSpec.ArgumentOrBuilder>
      getRoutineArgumentsOrBuilderList() {
    return routineArguments_;
  }
  /**
   *
   *
   * <pre>
   * Arguments of the routine.
   * </pre>
   *
   * <code>repeated .google.cloud.datacatalog.v1.RoutineSpec.Argument routine_arguments = 3;</code>
   */
  @java.lang.Override
  public int getRoutineArgumentsCount() {
    return routineArguments_.size();
  }
  /**
   *
   *
   * <pre>
   * Arguments of the routine.
   * </pre>
   *
   * <code>repeated .google.cloud.datacatalog.v1.RoutineSpec.Argument routine_arguments = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.RoutineSpec.Argument getRoutineArguments(int index) {
    return routineArguments_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Arguments of the routine.
   * </pre>
   *
   * <code>repeated .google.cloud.datacatalog.v1.RoutineSpec.Argument routine_arguments = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.RoutineSpec.ArgumentOrBuilder getRoutineArgumentsOrBuilder(
      int index) {
    return routineArguments_.get(index);
  }

  public static final int RETURN_TYPE_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object returnType_ = "";
  /**
   *
   *
   * <pre>
   * Return type of the argument. The exact value depends on the source system
   * and the language.
   * </pre>
   *
   * <code>string return_type = 4;</code>
   *
   * @return The returnType.
   */
  @java.lang.Override
  public java.lang.String getReturnType() {
    java.lang.Object ref = returnType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      returnType_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Return type of the argument. The exact value depends on the source system
   * and the language.
   * </pre>
   *
   * <code>string return_type = 4;</code>
   *
   * @return The bytes for returnType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getReturnTypeBytes() {
    java.lang.Object ref = returnType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      returnType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DEFINITION_BODY_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object definitionBody_ = "";
  /**
   *
   *
   * <pre>
   * The body of the routine.
   * </pre>
   *
   * <code>string definition_body = 5;</code>
   *
   * @return The definitionBody.
   */
  @java.lang.Override
  public java.lang.String getDefinitionBody() {
    java.lang.Object ref = definitionBody_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      definitionBody_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The body of the routine.
   * </pre>
   *
   * <code>string definition_body = 5;</code>
   *
   * @return The bytes for definitionBody.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDefinitionBodyBytes() {
    java.lang.Object ref = definitionBody_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      definitionBody_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BIGQUERY_ROUTINE_SPEC_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * Fields specific for BigQuery routines.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.BigQueryRoutineSpec bigquery_routine_spec = 6;</code>
   *
   * @return Whether the bigqueryRoutineSpec field is set.
   */
  @java.lang.Override
  public boolean hasBigqueryRoutineSpec() {
    return systemSpecCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * Fields specific for BigQuery routines.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.BigQueryRoutineSpec bigquery_routine_spec = 6;</code>
   *
   * @return The bigqueryRoutineSpec.
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.BigQueryRoutineSpec getBigqueryRoutineSpec() {
    if (systemSpecCase_ == 6) {
      return (com.google.cloud.datacatalog.v1.BigQueryRoutineSpec) systemSpec_;
    }
    return com.google.cloud.datacatalog.v1.BigQueryRoutineSpec.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Fields specific for BigQuery routines.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.BigQueryRoutineSpec bigquery_routine_spec = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.BigQueryRoutineSpecOrBuilder
      getBigqueryRoutineSpecOrBuilder() {
    if (systemSpecCase_ == 6) {
      return (com.google.cloud.datacatalog.v1.BigQueryRoutineSpec) systemSpec_;
    }
    return com.google.cloud.datacatalog.v1.BigQueryRoutineSpec.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (routineType_
        != com.google.cloud.datacatalog.v1.RoutineSpec.RoutineType.ROUTINE_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(1, routineType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(language_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, language_);
    }
    for (int i = 0; i < routineArguments_.size(); i++) {
      output.writeMessage(3, routineArguments_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(returnType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, returnType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(definitionBody_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, definitionBody_);
    }
    if (systemSpecCase_ == 6) {
      output.writeMessage(6, (com.google.cloud.datacatalog.v1.BigQueryRoutineSpec) systemSpec_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (routineType_
        != com.google.cloud.datacatalog.v1.RoutineSpec.RoutineType.ROUTINE_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, routineType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(language_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, language_);
    }
    for (int i = 0; i < routineArguments_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, routineArguments_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(returnType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, returnType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(definitionBody_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, definitionBody_);
    }
    if (systemSpecCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloud.datacatalog.v1.BigQueryRoutineSpec) systemSpec_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datacatalog.v1.RoutineSpec)) {
      return super.equals(obj);
    }
    com.google.cloud.datacatalog.v1.RoutineSpec other =
        (com.google.cloud.datacatalog.v1.RoutineSpec) obj;

    if (routineType_ != other.routineType_) return false;
    if (!getLanguage().equals(other.getLanguage())) return false;
    if (!getRoutineArgumentsList().equals(other.getRoutineArgumentsList())) return false;
    if (!getReturnType().equals(other.getReturnType())) return false;
    if (!getDefinitionBody().equals(other.getDefinitionBody())) return false;
    if (!getSystemSpecCase().equals(other.getSystemSpecCase())) return false;
    switch (systemSpecCase_) {
      case 6:
        if (!getBigqueryRoutineSpec().equals(other.getBigqueryRoutineSpec())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ROUTINE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + routineType_;
    hash = (37 * hash) + LANGUAGE_FIELD_NUMBER;
    hash = (53 * hash) + getLanguage().hashCode();
    if (getRoutineArgumentsCount() > 0) {
      hash = (37 * hash) + ROUTINE_ARGUMENTS_FIELD_NUMBER;
      hash = (53 * hash) + getRoutineArgumentsList().hashCode();
    }
    hash = (37 * hash) + RETURN_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getReturnType().hashCode();
    hash = (37 * hash) + DEFINITION_BODY_FIELD_NUMBER;
    hash = (53 * hash) + getDefinitionBody().hashCode();
    switch (systemSpecCase_) {
      case 6:
        hash = (37 * hash) + BIGQUERY_ROUTINE_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getBigqueryRoutineSpec().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datacatalog.v1.RoutineSpec parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1.RoutineSpec parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.RoutineSpec parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1.RoutineSpec parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.RoutineSpec parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1.RoutineSpec parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.RoutineSpec parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1.RoutineSpec parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.RoutineSpec parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1.RoutineSpec parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.RoutineSpec parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1.RoutineSpec parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.datacatalog.v1.RoutineSpec prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Specification that applies to a routine. Valid only for
   * entries with the `ROUTINE` type.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datacatalog.v1.RoutineSpec}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datacatalog.v1.RoutineSpec)
      com.google.cloud.datacatalog.v1.RoutineSpecOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datacatalog.v1.Datacatalog
          .internal_static_google_cloud_datacatalog_v1_RoutineSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datacatalog.v1.Datacatalog
          .internal_static_google_cloud_datacatalog_v1_RoutineSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datacatalog.v1.RoutineSpec.class,
              com.google.cloud.datacatalog.v1.RoutineSpec.Builder.class);
    }

    // Construct using com.google.cloud.datacatalog.v1.RoutineSpec.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      routineType_ = 0;
      language_ = "";
      if (routineArgumentsBuilder_ == null) {
        routineArguments_ = java.util.Collections.emptyList();
      } else {
        routineArguments_ = null;
        routineArgumentsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      returnType_ = "";
      definitionBody_ = "";
      if (bigqueryRoutineSpecBuilder_ != null) {
        bigqueryRoutineSpecBuilder_.clear();
      }
      systemSpecCase_ = 0;
      systemSpec_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datacatalog.v1.Datacatalog
          .internal_static_google_cloud_datacatalog_v1_RoutineSpec_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.RoutineSpec getDefaultInstanceForType() {
      return com.google.cloud.datacatalog.v1.RoutineSpec.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.RoutineSpec build() {
      com.google.cloud.datacatalog.v1.RoutineSpec result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.RoutineSpec buildPartial() {
      com.google.cloud.datacatalog.v1.RoutineSpec result =
          new com.google.cloud.datacatalog.v1.RoutineSpec(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.datacatalog.v1.RoutineSpec result) {
      if (routineArgumentsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          routineArguments_ = java.util.Collections.unmodifiableList(routineArguments_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.routineArguments_ = routineArguments_;
      } else {
        result.routineArguments_ = routineArgumentsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.datacatalog.v1.RoutineSpec result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.routineType_ = routineType_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.language_ = language_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.returnType_ = returnType_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.definitionBody_ = definitionBody_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.datacatalog.v1.RoutineSpec result) {
      result.systemSpecCase_ = systemSpecCase_;
      result.systemSpec_ = this.systemSpec_;
      if (systemSpecCase_ == 6 && bigqueryRoutineSpecBuilder_ != null) {
        result.systemSpec_ = bigqueryRoutineSpecBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datacatalog.v1.RoutineSpec) {
        return mergeFrom((com.google.cloud.datacatalog.v1.RoutineSpec) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datacatalog.v1.RoutineSpec other) {
      if (other == com.google.cloud.datacatalog.v1.RoutineSpec.getDefaultInstance()) return this;
      if (other.routineType_ != 0) {
        setRoutineTypeValue(other.getRoutineTypeValue());
      }
      if (!other.getLanguage().isEmpty()) {
        language_ = other.language_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (routineArgumentsBuilder_ == null) {
        if (!other.routineArguments_.isEmpty()) {
          if (routineArguments_.isEmpty()) {
            routineArguments_ = other.routineArguments_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureRoutineArgumentsIsMutable();
            routineArguments_.addAll(other.routineArguments_);
          }
          onChanged();
        }
      } else {
        if (!other.routineArguments_.isEmpty()) {
          if (routineArgumentsBuilder_.isEmpty()) {
            routineArgumentsBuilder_.dispose();
            routineArgumentsBuilder_ = null;
            routineArguments_ = other.routineArguments_;
            bitField0_ = (bitField0_ & ~0x00000004);
            routineArgumentsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getRoutineArgumentsFieldBuilder()
                    : null;
          } else {
            routineArgumentsBuilder_.addAllMessages(other.routineArguments_);
          }
        }
      }
      if (!other.getReturnType().isEmpty()) {
        returnType_ = other.returnType_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getDefinitionBody().isEmpty()) {
        definitionBody_ = other.definitionBody_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      switch (other.getSystemSpecCase()) {
        case BIGQUERY_ROUTINE_SPEC:
          {
            mergeBigqueryRoutineSpec(other.getBigqueryRoutineSpec());
            break;
          }
        case SYSTEMSPEC_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                routineType_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                language_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                com.google.cloud.datacatalog.v1.RoutineSpec.Argument m =
                    input.readMessage(
                        com.google.cloud.datacatalog.v1.RoutineSpec.Argument.parser(),
                        extensionRegistry);
                if (routineArgumentsBuilder_ == null) {
                  ensureRoutineArgumentsIsMutable();
                  routineArguments_.add(m);
                } else {
                  routineArgumentsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 34:
              {
                returnType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                definitionBody_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    getBigqueryRoutineSpecFieldBuilder().getBuilder(), extensionRegistry);
                systemSpecCase_ = 6;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int systemSpecCase_ = 0;
    private java.lang.Object systemSpec_;

    public SystemSpecCase getSystemSpecCase() {
      return SystemSpecCase.forNumber(systemSpecCase_);
    }

    public Builder clearSystemSpec() {
      systemSpecCase_ = 0;
      systemSpec_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private int routineType_ = 0;
    /**
     *
     *
     * <pre>
     * The type of the routine.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.RoutineSpec.RoutineType routine_type = 1;</code>
     *
     * @return The enum numeric value on the wire for routineType.
     */
    @java.lang.Override
    public int getRoutineTypeValue() {
      return routineType_;
    }
    /**
     *
     *
     * <pre>
     * The type of the routine.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.RoutineSpec.RoutineType routine_type = 1;</code>
     *
     * @param value The enum numeric value on the wire for routineType to set.
     * @return This builder for chaining.
     */
    public Builder setRoutineTypeValue(int value) {
      routineType_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of the routine.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.RoutineSpec.RoutineType routine_type = 1;</code>
     *
     * @return The routineType.
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1.RoutineSpec.RoutineType getRoutineType() {
      com.google.cloud.datacatalog.v1.RoutineSpec.RoutineType result =
          com.google.cloud.datacatalog.v1.RoutineSpec.RoutineType.forNumber(routineType_);
      return result == null
          ? com.google.cloud.datacatalog.v1.RoutineSpec.RoutineType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The type of the routine.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.RoutineSpec.RoutineType routine_type = 1;</code>
     *
     * @param value The routineType to set.
     * @return This builder for chaining.
     */
    public Builder setRoutineType(com.google.cloud.datacatalog.v1.RoutineSpec.RoutineType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      routineType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of the routine.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.RoutineSpec.RoutineType routine_type = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRoutineType() {
      bitField0_ = (bitField0_ & ~0x00000001);
      routineType_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object language_ = "";
    /**
     *
     *
     * <pre>
     * The language the routine is written in. The exact value depends on the
     * source system. For BigQuery routines, possible values are:
     *
     * * `SQL`
     * * `JAVASCRIPT`
     * </pre>
     *
     * <code>string language = 2;</code>
     *
     * @return The language.
     */
    public java.lang.String getLanguage() {
      java.lang.Object ref = language_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        language_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The language the routine is written in. The exact value depends on the
     * source system. For BigQuery routines, possible values are:
     *
     * * `SQL`
     * * `JAVASCRIPT`
     * </pre>
     *
     * <code>string language = 2;</code>
     *
     * @return The bytes for language.
     */
    public com.google.protobuf.ByteString getLanguageBytes() {
      java.lang.Object ref = language_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        language_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The language the routine is written in. The exact value depends on the
     * source system. For BigQuery routines, possible values are:
     *
     * * `SQL`
     * * `JAVASCRIPT`
     * </pre>
     *
     * <code>string language = 2;</code>
     *
     * @param value The language to set.
     * @return This builder for chaining.
     */
    public Builder setLanguage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      language_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The language the routine is written in. The exact value depends on the
     * source system. For BigQuery routines, possible values are:
     *
     * * `SQL`
     * * `JAVASCRIPT`
     * </pre>
     *
     * <code>string language = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLanguage() {
      language_ = getDefaultInstance().getLanguage();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The language the routine is written in. The exact value depends on the
     * source system. For BigQuery routines, possible values are:
     *
     * * `SQL`
     * * `JAVASCRIPT`
     * </pre>
     *
     * <code>string language = 2;</code>
     *
     * @param value The bytes for language to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      language_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.datacatalog.v1.RoutineSpec.Argument> routineArguments_ =
        java.util.Collections.emptyList();

    private void ensureRoutineArgumentsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        routineArguments_ =
            new java.util.ArrayList<com.google.cloud.datacatalog.v1.RoutineSpec.Argument>(
                routineArguments_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.datacatalog.v1.RoutineSpec.Argument,
            com.google.cloud.datacatalog.v1.RoutineSpec.Argument.Builder,
            com.google.cloud.datacatalog.v1.RoutineSpec.ArgumentOrBuilder>
        routineArgumentsBuilder_;

    /**
     *
     *
     * <pre>
     * Arguments of the routine.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.RoutineSpec.Argument routine_arguments = 3;
     * </code>
     */
    public java.util.List<com.google.cloud.datacatalog.v1.RoutineSpec.Argument>
        getRoutineArgumentsList() {
      if (routineArgumentsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(routineArguments_);
      } else {
        return routineArgumentsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Arguments of the routine.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.RoutineSpec.Argument routine_arguments = 3;
     * </code>
     */
    public int getRoutineArgumentsCount() {
      if (routineArgumentsBuilder_ == null) {
        return routineArguments_.size();
      } else {
        return routineArgumentsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Arguments of the routine.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.RoutineSpec.Argument routine_arguments = 3;
     * </code>
     */
    public com.google.cloud.datacatalog.v1.RoutineSpec.Argument getRoutineArguments(int index) {
      if (routineArgumentsBuilder_ == null) {
        return routineArguments_.get(index);
      } else {
        return routineArgumentsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Arguments of the routine.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.RoutineSpec.Argument routine_arguments = 3;
     * </code>
     */
    public Builder setRoutineArguments(
        int index, com.google.cloud.datacatalog.v1.RoutineSpec.Argument value) {
      if (routineArgumentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRoutineArgumentsIsMutable();
        routineArguments_.set(index, value);
        onChanged();
      } else {
        routineArgumentsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Arguments of the routine.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.RoutineSpec.Argument routine_arguments = 3;
     * </code>
     */
    public Builder setRoutineArguments(
        int index, com.google.cloud.datacatalog.v1.RoutineSpec.Argument.Builder builderForValue) {
      if (routineArgumentsBuilder_ == null) {
        ensureRoutineArgumentsIsMutable();
        routineArguments_.set(index, builderForValue.build());
        onChanged();
      } else {
        routineArgumentsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Arguments of the routine.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.RoutineSpec.Argument routine_arguments = 3;
     * </code>
     */
    public Builder addRoutineArguments(com.google.cloud.datacatalog.v1.RoutineSpec.Argument value) {
      if (routineArgumentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRoutineArgumentsIsMutable();
        routineArguments_.add(value);
        onChanged();
      } else {
        routineArgumentsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Arguments of the routine.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.RoutineSpec.Argument routine_arguments = 3;
     * </code>
     */
    public Builder addRoutineArguments(
        int index, com.google.cloud.datacatalog.v1.RoutineSpec.Argument value) {
      if (routineArgumentsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRoutineArgumentsIsMutable();
        routineArguments_.add(index, value);
        onChanged();
      } else {
        routineArgumentsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Arguments of the routine.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.RoutineSpec.Argument routine_arguments = 3;
     * </code>
     */
    public Builder addRoutineArguments(
        com.google.cloud.datacatalog.v1.RoutineSpec.Argument.Builder builderForValue) {
      if (routineArgumentsBuilder_ == null) {
        ensureRoutineArgumentsIsMutable();
        routineArguments_.add(builderForValue.build());
        onChanged();
      } else {
        routineArgumentsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Arguments of the routine.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.RoutineSpec.Argument routine_arguments = 3;
     * </code>
     */
    public Builder addRoutineArguments(
        int index, com.google.cloud.datacatalog.v1.RoutineSpec.Argument.Builder builderForValue) {
      if (routineArgumentsBuilder_ == null) {
        ensureRoutineArgumentsIsMutable();
        routineArguments_.add(index, builderForValue.build());
        onChanged();
      } else {
        routineArgumentsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Arguments of the routine.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.RoutineSpec.Argument routine_arguments = 3;
     * </code>
     */
    public Builder addAllRoutineArguments(
        java.lang.Iterable<? extends com.google.cloud.datacatalog.v1.RoutineSpec.Argument> values) {
      if (routineArgumentsBuilder_ == null) {
        ensureRoutineArgumentsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, routineArguments_);
        onChanged();
      } else {
        routineArgumentsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Arguments of the routine.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.RoutineSpec.Argument routine_arguments = 3;
     * </code>
     */
    public Builder clearRoutineArguments() {
      if (routineArgumentsBuilder_ == null) {
        routineArguments_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        routineArgumentsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Arguments of the routine.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.RoutineSpec.Argument routine_arguments = 3;
     * </code>
     */
    public Builder removeRoutineArguments(int index) {
      if (routineArgumentsBuilder_ == null) {
        ensureRoutineArgumentsIsMutable();
        routineArguments_.remove(index);
        onChanged();
      } else {
        routineArgumentsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Arguments of the routine.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.RoutineSpec.Argument routine_arguments = 3;
     * </code>
     */
    public com.google.cloud.datacatalog.v1.RoutineSpec.Argument.Builder getRoutineArgumentsBuilder(
        int index) {
      return getRoutineArgumentsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Arguments of the routine.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.RoutineSpec.Argument routine_arguments = 3;
     * </code>
     */
    public com.google.cloud.datacatalog.v1.RoutineSpec.ArgumentOrBuilder
        getRoutineArgumentsOrBuilder(int index) {
      if (routineArgumentsBuilder_ == null) {
        return routineArguments_.get(index);
      } else {
        return routineArgumentsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Arguments of the routine.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.RoutineSpec.Argument routine_arguments = 3;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.datacatalog.v1.RoutineSpec.ArgumentOrBuilder>
        getRoutineArgumentsOrBuilderList() {
      if (routineArgumentsBuilder_ != null) {
        return routineArgumentsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(routineArguments_);
      }
    }
    /**
     *
     *
     * <pre>
     * Arguments of the routine.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.RoutineSpec.Argument routine_arguments = 3;
     * </code>
     */
    public com.google.cloud.datacatalog.v1.RoutineSpec.Argument.Builder
        addRoutineArgumentsBuilder() {
      return getRoutineArgumentsFieldBuilder()
          .addBuilder(com.google.cloud.datacatalog.v1.RoutineSpec.Argument.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Arguments of the routine.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.RoutineSpec.Argument routine_arguments = 3;
     * </code>
     */
    public com.google.cloud.datacatalog.v1.RoutineSpec.Argument.Builder addRoutineArgumentsBuilder(
        int index) {
      return getRoutineArgumentsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.datacatalog.v1.RoutineSpec.Argument.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Arguments of the routine.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.RoutineSpec.Argument routine_arguments = 3;
     * </code>
     */
    public java.util.List<com.google.cloud.datacatalog.v1.RoutineSpec.Argument.Builder>
        getRoutineArgumentsBuilderList() {
      return getRoutineArgumentsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.datacatalog.v1.RoutineSpec.Argument,
            com.google.cloud.datacatalog.v1.RoutineSpec.Argument.Builder,
            com.google.cloud.datacatalog.v1.RoutineSpec.ArgumentOrBuilder>
        getRoutineArgumentsFieldBuilder() {
      if (routineArgumentsBuilder_ == null) {
        routineArgumentsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.datacatalog.v1.RoutineSpec.Argument,
                com.google.cloud.datacatalog.v1.RoutineSpec.Argument.Builder,
                com.google.cloud.datacatalog.v1.RoutineSpec.ArgumentOrBuilder>(
                routineArguments_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        routineArguments_ = null;
      }
      return routineArgumentsBuilder_;
    }

    private java.lang.Object returnType_ = "";
    /**
     *
     *
     * <pre>
     * Return type of the argument. The exact value depends on the source system
     * and the language.
     * </pre>
     *
     * <code>string return_type = 4;</code>
     *
     * @return The returnType.
     */
    public java.lang.String getReturnType() {
      java.lang.Object ref = returnType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        returnType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Return type of the argument. The exact value depends on the source system
     * and the language.
     * </pre>
     *
     * <code>string return_type = 4;</code>
     *
     * @return The bytes for returnType.
     */
    public com.google.protobuf.ByteString getReturnTypeBytes() {
      java.lang.Object ref = returnType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        returnType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Return type of the argument. The exact value depends on the source system
     * and the language.
     * </pre>
     *
     * <code>string return_type = 4;</code>
     *
     * @param value The returnType to set.
     * @return This builder for chaining.
     */
    public Builder setReturnType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      returnType_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Return type of the argument. The exact value depends on the source system
     * and the language.
     * </pre>
     *
     * <code>string return_type = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReturnType() {
      returnType_ = getDefaultInstance().getReturnType();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Return type of the argument. The exact value depends on the source system
     * and the language.
     * </pre>
     *
     * <code>string return_type = 4;</code>
     *
     * @param value The bytes for returnType to set.
     * @return This builder for chaining.
     */
    public Builder setReturnTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      returnType_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object definitionBody_ = "";
    /**
     *
     *
     * <pre>
     * The body of the routine.
     * </pre>
     *
     * <code>string definition_body = 5;</code>
     *
     * @return The definitionBody.
     */
    public java.lang.String getDefinitionBody() {
      java.lang.Object ref = definitionBody_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        definitionBody_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The body of the routine.
     * </pre>
     *
     * <code>string definition_body = 5;</code>
     *
     * @return The bytes for definitionBody.
     */
    public com.google.protobuf.ByteString getDefinitionBodyBytes() {
      java.lang.Object ref = definitionBody_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        definitionBody_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The body of the routine.
     * </pre>
     *
     * <code>string definition_body = 5;</code>
     *
     * @param value The definitionBody to set.
     * @return This builder for chaining.
     */
    public Builder setDefinitionBody(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      definitionBody_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The body of the routine.
     * </pre>
     *
     * <code>string definition_body = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDefinitionBody() {
      definitionBody_ = getDefaultInstance().getDefinitionBody();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The body of the routine.
     * </pre>
     *
     * <code>string definition_body = 5;</code>
     *
     * @param value The bytes for definitionBody to set.
     * @return This builder for chaining.
     */
    public Builder setDefinitionBodyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      definitionBody_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.BigQueryRoutineSpec,
            com.google.cloud.datacatalog.v1.BigQueryRoutineSpec.Builder,
            com.google.cloud.datacatalog.v1.BigQueryRoutineSpecOrBuilder>
        bigqueryRoutineSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Fields specific for BigQuery routines.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.BigQueryRoutineSpec bigquery_routine_spec = 6;</code>
     *
     * @return Whether the bigqueryRoutineSpec field is set.
     */
    @java.lang.Override
    public boolean hasBigqueryRoutineSpec() {
      return systemSpecCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * Fields specific for BigQuery routines.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.BigQueryRoutineSpec bigquery_routine_spec = 6;</code>
     *
     * @return The bigqueryRoutineSpec.
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1.BigQueryRoutineSpec getBigqueryRoutineSpec() {
      if (bigqueryRoutineSpecBuilder_ == null) {
        if (systemSpecCase_ == 6) {
          return (com.google.cloud.datacatalog.v1.BigQueryRoutineSpec) systemSpec_;
        }
        return com.google.cloud.datacatalog.v1.BigQueryRoutineSpec.getDefaultInstance();
      } else {
        if (systemSpecCase_ == 6) {
          return bigqueryRoutineSpecBuilder_.getMessage();
        }
        return com.google.cloud.datacatalog.v1.BigQueryRoutineSpec.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Fields specific for BigQuery routines.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.BigQueryRoutineSpec bigquery_routine_spec = 6;</code>
     */
    public Builder setBigqueryRoutineSpec(
        com.google.cloud.datacatalog.v1.BigQueryRoutineSpec value) {
      if (bigqueryRoutineSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        systemSpec_ = value;
        onChanged();
      } else {
        bigqueryRoutineSpecBuilder_.setMessage(value);
      }
      systemSpecCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fields specific for BigQuery routines.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.BigQueryRoutineSpec bigquery_routine_spec = 6;</code>
     */
    public Builder setBigqueryRoutineSpec(
        com.google.cloud.datacatalog.v1.BigQueryRoutineSpec.Builder builderForValue) {
      if (bigqueryRoutineSpecBuilder_ == null) {
        systemSpec_ = builderForValue.build();
        onChanged();
      } else {
        bigqueryRoutineSpecBuilder_.setMessage(builderForValue.build());
      }
      systemSpecCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fields specific for BigQuery routines.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.BigQueryRoutineSpec bigquery_routine_spec = 6;</code>
     */
    public Builder mergeBigqueryRoutineSpec(
        com.google.cloud.datacatalog.v1.BigQueryRoutineSpec value) {
      if (bigqueryRoutineSpecBuilder_ == null) {
        if (systemSpecCase_ == 6
            && systemSpec_
                != com.google.cloud.datacatalog.v1.BigQueryRoutineSpec.getDefaultInstance()) {
          systemSpec_ =
              com.google.cloud.datacatalog.v1.BigQueryRoutineSpec.newBuilder(
                      (com.google.cloud.datacatalog.v1.BigQueryRoutineSpec) systemSpec_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          systemSpec_ = value;
        }
        onChanged();
      } else {
        if (systemSpecCase_ == 6) {
          bigqueryRoutineSpecBuilder_.mergeFrom(value);
        } else {
          bigqueryRoutineSpecBuilder_.setMessage(value);
        }
      }
      systemSpecCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fields specific for BigQuery routines.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.BigQueryRoutineSpec bigquery_routine_spec = 6;</code>
     */
    public Builder clearBigqueryRoutineSpec() {
      if (bigqueryRoutineSpecBuilder_ == null) {
        if (systemSpecCase_ == 6) {
          systemSpecCase_ = 0;
          systemSpec_ = null;
          onChanged();
        }
      } else {
        if (systemSpecCase_ == 6) {
          systemSpecCase_ = 0;
          systemSpec_ = null;
        }
        bigqueryRoutineSpecBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fields specific for BigQuery routines.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.BigQueryRoutineSpec bigquery_routine_spec = 6;</code>
     */
    public com.google.cloud.datacatalog.v1.BigQueryRoutineSpec.Builder
        getBigqueryRoutineSpecBuilder() {
      return getBigqueryRoutineSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Fields specific for BigQuery routines.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.BigQueryRoutineSpec bigquery_routine_spec = 6;</code>
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1.BigQueryRoutineSpecOrBuilder
        getBigqueryRoutineSpecOrBuilder() {
      if ((systemSpecCase_ == 6) && (bigqueryRoutineSpecBuilder_ != null)) {
        return bigqueryRoutineSpecBuilder_.getMessageOrBuilder();
      } else {
        if (systemSpecCase_ == 6) {
          return (com.google.cloud.datacatalog.v1.BigQueryRoutineSpec) systemSpec_;
        }
        return com.google.cloud.datacatalog.v1.BigQueryRoutineSpec.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Fields specific for BigQuery routines.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.BigQueryRoutineSpec bigquery_routine_spec = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.BigQueryRoutineSpec,
            com.google.cloud.datacatalog.v1.BigQueryRoutineSpec.Builder,
            com.google.cloud.datacatalog.v1.BigQueryRoutineSpecOrBuilder>
        getBigqueryRoutineSpecFieldBuilder() {
      if (bigqueryRoutineSpecBuilder_ == null) {
        if (!(systemSpecCase_ == 6)) {
          systemSpec_ = com.google.cloud.datacatalog.v1.BigQueryRoutineSpec.getDefaultInstance();
        }
        bigqueryRoutineSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datacatalog.v1.BigQueryRoutineSpec,
                com.google.cloud.datacatalog.v1.BigQueryRoutineSpec.Builder,
                com.google.cloud.datacatalog.v1.BigQueryRoutineSpecOrBuilder>(
                (com.google.cloud.datacatalog.v1.BigQueryRoutineSpec) systemSpec_,
                getParentForChildren(),
                isClean());
        systemSpec_ = null;
      }
      systemSpecCase_ = 6;
      onChanged();
      return bigqueryRoutineSpecBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datacatalog.v1.RoutineSpec)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datacatalog.v1.RoutineSpec)
  private static final com.google.cloud.datacatalog.v1.RoutineSpec DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datacatalog.v1.RoutineSpec();
  }

  public static com.google.cloud.datacatalog.v1.RoutineSpec getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RoutineSpec> PARSER =
      new com.google.protobuf.AbstractParser<RoutineSpec>() {
        @java.lang.Override
        public RoutineSpec parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RoutineSpec> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RoutineSpec> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datacatalog.v1.RoutineSpec getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
