/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datacatalog/v1/datacatalog.proto

package com.google.cloud.datacatalog.v1;

/**
 *
 *
 * <pre>
 * Specification that applies to a table resource. Valid only
 * for entries with the `TABLE` type.
 * </pre>
 *
 * Protobuf type {@code google.cloud.datacatalog.v1.DatabaseTableSpec}
 */
public final class DatabaseTableSpec extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datacatalog.v1.DatabaseTableSpec)
    DatabaseTableSpecOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DatabaseTableSpec.newBuilder() to construct.
  private DatabaseTableSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DatabaseTableSpec() {
    type_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DatabaseTableSpec();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datacatalog.v1.Datacatalog
        .internal_static_google_cloud_datacatalog_v1_DatabaseTableSpec_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datacatalog.v1.Datacatalog
        .internal_static_google_cloud_datacatalog_v1_DatabaseTableSpec_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datacatalog.v1.DatabaseTableSpec.class,
            com.google.cloud.datacatalog.v1.DatabaseTableSpec.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Type of the table.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.datacatalog.v1.DatabaseTableSpec.TableType}
   */
  public enum TableType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default unknown table type.
     * </pre>
     *
     * <code>TABLE_TYPE_UNSPECIFIED = 0;</code>
     */
    TABLE_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Native table.
     * </pre>
     *
     * <code>NATIVE = 1;</code>
     */
    NATIVE(1),
    /**
     *
     *
     * <pre>
     * External table.
     * </pre>
     *
     * <code>EXTERNAL = 2;</code>
     */
    EXTERNAL(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default unknown table type.
     * </pre>
     *
     * <code>TABLE_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int TABLE_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Native table.
     * </pre>
     *
     * <code>NATIVE = 1;</code>
     */
    public static final int NATIVE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * External table.
     * </pre>
     *
     * <code>EXTERNAL = 2;</code>
     */
    public static final int EXTERNAL_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TableType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static TableType forNumber(int value) {
      switch (value) {
        case 0:
          return TABLE_TYPE_UNSPECIFIED;
        case 1:
          return NATIVE;
        case 2:
          return EXTERNAL;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<TableType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<TableType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<TableType>() {
          public TableType findValueByNumber(int number) {
            return TableType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.datacatalog.v1.DatabaseTableSpec.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final TableType[] VALUES = values();

    public static TableType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private TableType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.datacatalog.v1.DatabaseTableSpec.TableType)
  }

  public interface DatabaseViewSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Type of this view.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec.ViewType view_type = 1;
     * </code>
     *
     * @return The enum numeric value on the wire for viewType.
     */
    int getViewTypeValue();
    /**
     *
     *
     * <pre>
     * Type of this view.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec.ViewType view_type = 1;
     * </code>
     *
     * @return The viewType.
     */
    com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec.ViewType getViewType();

    /**
     *
     *
     * <pre>
     * Name of a singular table this view reflects one to one.
     * </pre>
     *
     * <code>string base_table = 2;</code>
     *
     * @return Whether the baseTable field is set.
     */
    boolean hasBaseTable();
    /**
     *
     *
     * <pre>
     * Name of a singular table this view reflects one to one.
     * </pre>
     *
     * <code>string base_table = 2;</code>
     *
     * @return The baseTable.
     */
    java.lang.String getBaseTable();
    /**
     *
     *
     * <pre>
     * Name of a singular table this view reflects one to one.
     * </pre>
     *
     * <code>string base_table = 2;</code>
     *
     * @return The bytes for baseTable.
     */
    com.google.protobuf.ByteString getBaseTableBytes();

    /**
     *
     *
     * <pre>
     * SQL query used to generate this view.
     * </pre>
     *
     * <code>string sql_query = 3;</code>
     *
     * @return Whether the sqlQuery field is set.
     */
    boolean hasSqlQuery();
    /**
     *
     *
     * <pre>
     * SQL query used to generate this view.
     * </pre>
     *
     * <code>string sql_query = 3;</code>
     *
     * @return The sqlQuery.
     */
    java.lang.String getSqlQuery();
    /**
     *
     *
     * <pre>
     * SQL query used to generate this view.
     * </pre>
     *
     * <code>string sql_query = 3;</code>
     *
     * @return The bytes for sqlQuery.
     */
    com.google.protobuf.ByteString getSqlQueryBytes();

    com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec.SourceDefinitionCase
        getSourceDefinitionCase();
  }
  /**
   *
   *
   * <pre>
   * Specification that applies to database view.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec}
   */
  public static final class DatabaseViewSpec extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec)
      DatabaseViewSpecOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DatabaseViewSpec.newBuilder() to construct.
    private DatabaseViewSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DatabaseViewSpec() {
      viewType_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new DatabaseViewSpec();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datacatalog.v1.Datacatalog
          .internal_static_google_cloud_datacatalog_v1_DatabaseTableSpec_DatabaseViewSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datacatalog.v1.Datacatalog
          .internal_static_google_cloud_datacatalog_v1_DatabaseTableSpec_DatabaseViewSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec.class,
              com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Concrete type of the view.
     * </pre>
     *
     * Protobuf enum {@code google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec.ViewType}
     */
    public enum ViewType implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Default unknown view type.
       * </pre>
       *
       * <code>VIEW_TYPE_UNSPECIFIED = 0;</code>
       */
      VIEW_TYPE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Standard view.
       * </pre>
       *
       * <code>STANDARD_VIEW = 1;</code>
       */
      STANDARD_VIEW(1),
      /**
       *
       *
       * <pre>
       * Materialized view.
       * </pre>
       *
       * <code>MATERIALIZED_VIEW = 2;</code>
       */
      MATERIALIZED_VIEW(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Default unknown view type.
       * </pre>
       *
       * <code>VIEW_TYPE_UNSPECIFIED = 0;</code>
       */
      public static final int VIEW_TYPE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Standard view.
       * </pre>
       *
       * <code>STANDARD_VIEW = 1;</code>
       */
      public static final int STANDARD_VIEW_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Materialized view.
       * </pre>
       *
       * <code>MATERIALIZED_VIEW = 2;</code>
       */
      public static final int MATERIALIZED_VIEW_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ViewType valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static ViewType forNumber(int value) {
        switch (value) {
          case 0:
            return VIEW_TYPE_UNSPECIFIED;
          case 1:
            return STANDARD_VIEW;
          case 2:
            return MATERIALIZED_VIEW;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<ViewType> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<ViewType> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<ViewType>() {
            public ViewType findValueByNumber(int number) {
              return ViewType.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final ViewType[] VALUES = values();

      public static ViewType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private ViewType(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec.ViewType)
    }

    private int sourceDefinitionCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object sourceDefinition_;

    public enum SourceDefinitionCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      BASE_TABLE(2),
      SQL_QUERY(3),
      SOURCEDEFINITION_NOT_SET(0);
      private final int value;

      private SourceDefinitionCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static SourceDefinitionCase valueOf(int value) {
        return forNumber(value);
      }

      public static SourceDefinitionCase forNumber(int value) {
        switch (value) {
          case 2:
            return BASE_TABLE;
          case 3:
            return SQL_QUERY;
          case 0:
            return SOURCEDEFINITION_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public SourceDefinitionCase getSourceDefinitionCase() {
      return SourceDefinitionCase.forNumber(sourceDefinitionCase_);
    }

    public static final int VIEW_TYPE_FIELD_NUMBER = 1;
    private int viewType_ = 0;
    /**
     *
     *
     * <pre>
     * Type of this view.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec.ViewType view_type = 1;
     * </code>
     *
     * @return The enum numeric value on the wire for viewType.
     */
    @java.lang.Override
    public int getViewTypeValue() {
      return viewType_;
    }
    /**
     *
     *
     * <pre>
     * Type of this view.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec.ViewType view_type = 1;
     * </code>
     *
     * @return The viewType.
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec.ViewType
        getViewType() {
      com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec.ViewType result =
          com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec.ViewType.forNumber(
              viewType_);
      return result == null
          ? com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec.ViewType.UNRECOGNIZED
          : result;
    }

    public static final int BASE_TABLE_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * Name of a singular table this view reflects one to one.
     * </pre>
     *
     * <code>string base_table = 2;</code>
     *
     * @return Whether the baseTable field is set.
     */
    public boolean hasBaseTable() {
      return sourceDefinitionCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Name of a singular table this view reflects one to one.
     * </pre>
     *
     * <code>string base_table = 2;</code>
     *
     * @return The baseTable.
     */
    public java.lang.String getBaseTable() {
      java.lang.Object ref = "";
      if (sourceDefinitionCase_ == 2) {
        ref = sourceDefinition_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (sourceDefinitionCase_ == 2) {
          sourceDefinition_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Name of a singular table this view reflects one to one.
     * </pre>
     *
     * <code>string base_table = 2;</code>
     *
     * @return The bytes for baseTable.
     */
    public com.google.protobuf.ByteString getBaseTableBytes() {
      java.lang.Object ref = "";
      if (sourceDefinitionCase_ == 2) {
        ref = sourceDefinition_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (sourceDefinitionCase_ == 2) {
          sourceDefinition_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SQL_QUERY_FIELD_NUMBER = 3;
    /**
     *
     *
     * <pre>
     * SQL query used to generate this view.
     * </pre>
     *
     * <code>string sql_query = 3;</code>
     *
     * @return Whether the sqlQuery field is set.
     */
    public boolean hasSqlQuery() {
      return sourceDefinitionCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * SQL query used to generate this view.
     * </pre>
     *
     * <code>string sql_query = 3;</code>
     *
     * @return The sqlQuery.
     */
    public java.lang.String getSqlQuery() {
      java.lang.Object ref = "";
      if (sourceDefinitionCase_ == 3) {
        ref = sourceDefinition_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (sourceDefinitionCase_ == 3) {
          sourceDefinition_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * SQL query used to generate this view.
     * </pre>
     *
     * <code>string sql_query = 3;</code>
     *
     * @return The bytes for sqlQuery.
     */
    public com.google.protobuf.ByteString getSqlQueryBytes() {
      java.lang.Object ref = "";
      if (sourceDefinitionCase_ == 3) {
        ref = sourceDefinition_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (sourceDefinitionCase_ == 3) {
          sourceDefinition_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (viewType_
          != com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec.ViewType
              .VIEW_TYPE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, viewType_);
      }
      if (sourceDefinitionCase_ == 2) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, sourceDefinition_);
      }
      if (sourceDefinitionCase_ == 3) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, sourceDefinition_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (viewType_
          != com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec.ViewType
              .VIEW_TYPE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, viewType_);
      }
      if (sourceDefinitionCase_ == 2) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, sourceDefinition_);
      }
      if (sourceDefinitionCase_ == 3) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, sourceDefinition_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec)) {
        return super.equals(obj);
      }
      com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec other =
          (com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec) obj;

      if (viewType_ != other.viewType_) return false;
      if (!getSourceDefinitionCase().equals(other.getSourceDefinitionCase())) return false;
      switch (sourceDefinitionCase_) {
        case 2:
          if (!getBaseTable().equals(other.getBaseTable())) return false;
          break;
        case 3:
          if (!getSqlQuery().equals(other.getSqlQuery())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + VIEW_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + viewType_;
      switch (sourceDefinitionCase_) {
        case 2:
          hash = (37 * hash) + BASE_TABLE_FIELD_NUMBER;
          hash = (53 * hash) + getBaseTable().hashCode();
          break;
        case 3:
          hash = (37 * hash) + SQL_QUERY_FIELD_NUMBER;
          hash = (53 * hash) + getSqlQuery().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to database view.
     * </pre>
     *
     * Protobuf type {@code google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec)
        com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.datacatalog.v1.Datacatalog
            .internal_static_google_cloud_datacatalog_v1_DatabaseTableSpec_DatabaseViewSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.datacatalog.v1.Datacatalog
            .internal_static_google_cloud_datacatalog_v1_DatabaseTableSpec_DatabaseViewSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec.class,
                com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec.Builder.class);
      }

      // Construct using
      // com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        viewType_ = 0;
        sourceDefinitionCase_ = 0;
        sourceDefinition_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.datacatalog.v1.Datacatalog
            .internal_static_google_cloud_datacatalog_v1_DatabaseTableSpec_DatabaseViewSpec_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec
          getDefaultInstanceForType() {
        return com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec build() {
        com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec buildPartial() {
        com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec result =
            new com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.viewType_ = viewType_;
        }
      }

      private void buildPartialOneofs(
          com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec result) {
        result.sourceDefinitionCase_ = sourceDefinitionCase_;
        result.sourceDefinition_ = this.sourceDefinition_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec) {
          return mergeFrom(
              (com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec other) {
        if (other
            == com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec
                .getDefaultInstance()) return this;
        if (other.viewType_ != 0) {
          setViewTypeValue(other.getViewTypeValue());
        }
        switch (other.getSourceDefinitionCase()) {
          case BASE_TABLE:
            {
              sourceDefinitionCase_ = 2;
              sourceDefinition_ = other.sourceDefinition_;
              onChanged();
              break;
            }
          case SQL_QUERY:
            {
              sourceDefinitionCase_ = 3;
              sourceDefinition_ = other.sourceDefinition_;
              onChanged();
              break;
            }
          case SOURCEDEFINITION_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  viewType_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  sourceDefinitionCase_ = 2;
                  sourceDefinition_ = s;
                  break;
                } // case 18
              case 26:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  sourceDefinitionCase_ = 3;
                  sourceDefinition_ = s;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int sourceDefinitionCase_ = 0;
      private java.lang.Object sourceDefinition_;

      public SourceDefinitionCase getSourceDefinitionCase() {
        return SourceDefinitionCase.forNumber(sourceDefinitionCase_);
      }

      public Builder clearSourceDefinition() {
        sourceDefinitionCase_ = 0;
        sourceDefinition_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private int viewType_ = 0;
      /**
       *
       *
       * <pre>
       * Type of this view.
       * </pre>
       *
       * <code>
       * .google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec.ViewType view_type = 1;
       * </code>
       *
       * @return The enum numeric value on the wire for viewType.
       */
      @java.lang.Override
      public int getViewTypeValue() {
        return viewType_;
      }
      /**
       *
       *
       * <pre>
       * Type of this view.
       * </pre>
       *
       * <code>
       * .google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec.ViewType view_type = 1;
       * </code>
       *
       * @param value The enum numeric value on the wire for viewType to set.
       * @return This builder for chaining.
       */
      public Builder setViewTypeValue(int value) {
        viewType_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Type of this view.
       * </pre>
       *
       * <code>
       * .google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec.ViewType view_type = 1;
       * </code>
       *
       * @return The viewType.
       */
      @java.lang.Override
      public com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec.ViewType
          getViewType() {
        com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec.ViewType result =
            com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec.ViewType.forNumber(
                viewType_);
        return result == null
            ? com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec.ViewType
                .UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Type of this view.
       * </pre>
       *
       * <code>
       * .google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec.ViewType view_type = 1;
       * </code>
       *
       * @param value The viewType to set.
       * @return This builder for chaining.
       */
      public Builder setViewType(
          com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec.ViewType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        viewType_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Type of this view.
       * </pre>
       *
       * <code>
       * .google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec.ViewType view_type = 1;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearViewType() {
        bitField0_ = (bitField0_ & ~0x00000001);
        viewType_ = 0;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Name of a singular table this view reflects one to one.
       * </pre>
       *
       * <code>string base_table = 2;</code>
       *
       * @return Whether the baseTable field is set.
       */
      @java.lang.Override
      public boolean hasBaseTable() {
        return sourceDefinitionCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * Name of a singular table this view reflects one to one.
       * </pre>
       *
       * <code>string base_table = 2;</code>
       *
       * @return The baseTable.
       */
      @java.lang.Override
      public java.lang.String getBaseTable() {
        java.lang.Object ref = "";
        if (sourceDefinitionCase_ == 2) {
          ref = sourceDefinition_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (sourceDefinitionCase_ == 2) {
            sourceDefinition_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Name of a singular table this view reflects one to one.
       * </pre>
       *
       * <code>string base_table = 2;</code>
       *
       * @return The bytes for baseTable.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getBaseTableBytes() {
        java.lang.Object ref = "";
        if (sourceDefinitionCase_ == 2) {
          ref = sourceDefinition_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (sourceDefinitionCase_ == 2) {
            sourceDefinition_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Name of a singular table this view reflects one to one.
       * </pre>
       *
       * <code>string base_table = 2;</code>
       *
       * @param value The baseTable to set.
       * @return This builder for chaining.
       */
      public Builder setBaseTable(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        sourceDefinitionCase_ = 2;
        sourceDefinition_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Name of a singular table this view reflects one to one.
       * </pre>
       *
       * <code>string base_table = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearBaseTable() {
        if (sourceDefinitionCase_ == 2) {
          sourceDefinitionCase_ = 0;
          sourceDefinition_ = null;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Name of a singular table this view reflects one to one.
       * </pre>
       *
       * <code>string base_table = 2;</code>
       *
       * @param value The bytes for baseTable to set.
       * @return This builder for chaining.
       */
      public Builder setBaseTableBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        sourceDefinitionCase_ = 2;
        sourceDefinition_ = value;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * SQL query used to generate this view.
       * </pre>
       *
       * <code>string sql_query = 3;</code>
       *
       * @return Whether the sqlQuery field is set.
       */
      @java.lang.Override
      public boolean hasSqlQuery() {
        return sourceDefinitionCase_ == 3;
      }
      /**
       *
       *
       * <pre>
       * SQL query used to generate this view.
       * </pre>
       *
       * <code>string sql_query = 3;</code>
       *
       * @return The sqlQuery.
       */
      @java.lang.Override
      public java.lang.String getSqlQuery() {
        java.lang.Object ref = "";
        if (sourceDefinitionCase_ == 3) {
          ref = sourceDefinition_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (sourceDefinitionCase_ == 3) {
            sourceDefinition_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * SQL query used to generate this view.
       * </pre>
       *
       * <code>string sql_query = 3;</code>
       *
       * @return The bytes for sqlQuery.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getSqlQueryBytes() {
        java.lang.Object ref = "";
        if (sourceDefinitionCase_ == 3) {
          ref = sourceDefinition_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          if (sourceDefinitionCase_ == 3) {
            sourceDefinition_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * SQL query used to generate this view.
       * </pre>
       *
       * <code>string sql_query = 3;</code>
       *
       * @param value The sqlQuery to set.
       * @return This builder for chaining.
       */
      public Builder setSqlQuery(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        sourceDefinitionCase_ = 3;
        sourceDefinition_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * SQL query used to generate this view.
       * </pre>
       *
       * <code>string sql_query = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSqlQuery() {
        if (sourceDefinitionCase_ == 3) {
          sourceDefinitionCase_ = 0;
          sourceDefinition_ = null;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * SQL query used to generate this view.
       * </pre>
       *
       * <code>string sql_query = 3;</code>
       *
       * @param value The bytes for sqlQuery to set.
       * @return This builder for chaining.
       */
      public Builder setSqlQueryBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        sourceDefinitionCase_ = 3;
        sourceDefinition_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec)
    private static final com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec();
    }

    public static com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DatabaseViewSpec> PARSER =
        new com.google.protobuf.AbstractParser<DatabaseViewSpec>() {
          @java.lang.Override
          public DatabaseViewSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<DatabaseViewSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DatabaseViewSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int TYPE_FIELD_NUMBER = 1;
  private int type_ = 0;
  /**
   *
   *
   * <pre>
   * Type of this table.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.DatabaseTableSpec.TableType type = 1;</code>
   *
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Override
  public int getTypeValue() {
    return type_;
  }
  /**
   *
   *
   * <pre>
   * Type of this table.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.DatabaseTableSpec.TableType type = 1;</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.DatabaseTableSpec.TableType getType() {
    com.google.cloud.datacatalog.v1.DatabaseTableSpec.TableType result =
        com.google.cloud.datacatalog.v1.DatabaseTableSpec.TableType.forNumber(type_);
    return result == null
        ? com.google.cloud.datacatalog.v1.DatabaseTableSpec.TableType.UNRECOGNIZED
        : result;
  }

  public static final int DATAPLEX_TABLE_FIELD_NUMBER = 2;
  private com.google.cloud.datacatalog.v1.DataplexTableSpec dataplexTable_;
  /**
   *
   *
   * <pre>
   * Output only. Fields specific to a Dataplex table and present only in the
   * Dataplex table entries.
   * </pre>
   *
   * <code>
   * .google.cloud.datacatalog.v1.DataplexTableSpec dataplex_table = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the dataplexTable field is set.
   */
  @java.lang.Override
  public boolean hasDataplexTable() {
    return dataplexTable_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Fields specific to a Dataplex table and present only in the
   * Dataplex table entries.
   * </pre>
   *
   * <code>
   * .google.cloud.datacatalog.v1.DataplexTableSpec dataplex_table = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The dataplexTable.
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.DataplexTableSpec getDataplexTable() {
    return dataplexTable_ == null
        ? com.google.cloud.datacatalog.v1.DataplexTableSpec.getDefaultInstance()
        : dataplexTable_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Fields specific to a Dataplex table and present only in the
   * Dataplex table entries.
   * </pre>
   *
   * <code>
   * .google.cloud.datacatalog.v1.DataplexTableSpec dataplex_table = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.DataplexTableSpecOrBuilder getDataplexTableOrBuilder() {
    return dataplexTable_ == null
        ? com.google.cloud.datacatalog.v1.DataplexTableSpec.getDefaultInstance()
        : dataplexTable_;
  }

  public static final int DATABASE_VIEW_SPEC_FIELD_NUMBER = 3;
  private com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec databaseViewSpec_;
  /**
   *
   *
   * <pre>
   * Spec what aplies to tables that are actually views.
   * Not set for "real" tables.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec database_view_spec = 3;
   * </code>
   *
   * @return Whether the databaseViewSpec field is set.
   */
  @java.lang.Override
  public boolean hasDatabaseViewSpec() {
    return databaseViewSpec_ != null;
  }
  /**
   *
   *
   * <pre>
   * Spec what aplies to tables that are actually views.
   * Not set for "real" tables.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec database_view_spec = 3;
   * </code>
   *
   * @return The databaseViewSpec.
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec getDatabaseViewSpec() {
    return databaseViewSpec_ == null
        ? com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec.getDefaultInstance()
        : databaseViewSpec_;
  }
  /**
   *
   *
   * <pre>
   * Spec what aplies to tables that are actually views.
   * Not set for "real" tables.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec database_view_spec = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpecOrBuilder
      getDatabaseViewSpecOrBuilder() {
    return databaseViewSpec_ == null
        ? com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec.getDefaultInstance()
        : databaseViewSpec_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (type_
        != com.google.cloud.datacatalog.v1.DatabaseTableSpec.TableType.TABLE_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(1, type_);
    }
    if (dataplexTable_ != null) {
      output.writeMessage(2, getDataplexTable());
    }
    if (databaseViewSpec_ != null) {
      output.writeMessage(3, getDatabaseViewSpec());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (type_
        != com.google.cloud.datacatalog.v1.DatabaseTableSpec.TableType.TABLE_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, type_);
    }
    if (dataplexTable_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getDataplexTable());
    }
    if (databaseViewSpec_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getDatabaseViewSpec());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datacatalog.v1.DatabaseTableSpec)) {
      return super.equals(obj);
    }
    com.google.cloud.datacatalog.v1.DatabaseTableSpec other =
        (com.google.cloud.datacatalog.v1.DatabaseTableSpec) obj;

    if (type_ != other.type_) return false;
    if (hasDataplexTable() != other.hasDataplexTable()) return false;
    if (hasDataplexTable()) {
      if (!getDataplexTable().equals(other.getDataplexTable())) return false;
    }
    if (hasDatabaseViewSpec() != other.hasDatabaseViewSpec()) return false;
    if (hasDatabaseViewSpec()) {
      if (!getDatabaseViewSpec().equals(other.getDatabaseViewSpec())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    if (hasDataplexTable()) {
      hash = (37 * hash) + DATAPLEX_TABLE_FIELD_NUMBER;
      hash = (53 * hash) + getDataplexTable().hashCode();
    }
    if (hasDatabaseViewSpec()) {
      hash = (37 * hash) + DATABASE_VIEW_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getDatabaseViewSpec().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datacatalog.v1.DatabaseTableSpec parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1.DatabaseTableSpec parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.DatabaseTableSpec parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1.DatabaseTableSpec parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.DatabaseTableSpec parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1.DatabaseTableSpec parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.DatabaseTableSpec parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1.DatabaseTableSpec parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.DatabaseTableSpec parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1.DatabaseTableSpec parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.DatabaseTableSpec parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1.DatabaseTableSpec parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.datacatalog.v1.DatabaseTableSpec prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Specification that applies to a table resource. Valid only
   * for entries with the `TABLE` type.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datacatalog.v1.DatabaseTableSpec}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datacatalog.v1.DatabaseTableSpec)
      com.google.cloud.datacatalog.v1.DatabaseTableSpecOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datacatalog.v1.Datacatalog
          .internal_static_google_cloud_datacatalog_v1_DatabaseTableSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datacatalog.v1.Datacatalog
          .internal_static_google_cloud_datacatalog_v1_DatabaseTableSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datacatalog.v1.DatabaseTableSpec.class,
              com.google.cloud.datacatalog.v1.DatabaseTableSpec.Builder.class);
    }

    // Construct using com.google.cloud.datacatalog.v1.DatabaseTableSpec.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      type_ = 0;
      dataplexTable_ = null;
      if (dataplexTableBuilder_ != null) {
        dataplexTableBuilder_.dispose();
        dataplexTableBuilder_ = null;
      }
      databaseViewSpec_ = null;
      if (databaseViewSpecBuilder_ != null) {
        databaseViewSpecBuilder_.dispose();
        databaseViewSpecBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datacatalog.v1.Datacatalog
          .internal_static_google_cloud_datacatalog_v1_DatabaseTableSpec_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.DatabaseTableSpec getDefaultInstanceForType() {
      return com.google.cloud.datacatalog.v1.DatabaseTableSpec.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.DatabaseTableSpec build() {
      com.google.cloud.datacatalog.v1.DatabaseTableSpec result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.DatabaseTableSpec buildPartial() {
      com.google.cloud.datacatalog.v1.DatabaseTableSpec result =
          new com.google.cloud.datacatalog.v1.DatabaseTableSpec(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.datacatalog.v1.DatabaseTableSpec result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.type_ = type_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.dataplexTable_ =
            dataplexTableBuilder_ == null ? dataplexTable_ : dataplexTableBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.databaseViewSpec_ =
            databaseViewSpecBuilder_ == null ? databaseViewSpec_ : databaseViewSpecBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datacatalog.v1.DatabaseTableSpec) {
        return mergeFrom((com.google.cloud.datacatalog.v1.DatabaseTableSpec) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datacatalog.v1.DatabaseTableSpec other) {
      if (other == com.google.cloud.datacatalog.v1.DatabaseTableSpec.getDefaultInstance())
        return this;
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      if (other.hasDataplexTable()) {
        mergeDataplexTable(other.getDataplexTable());
      }
      if (other.hasDatabaseViewSpec()) {
        mergeDatabaseViewSpec(other.getDatabaseViewSpec());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                type_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                input.readMessage(getDataplexTableFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getDatabaseViewSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int type_ = 0;
    /**
     *
     *
     * <pre>
     * Type of this table.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.DatabaseTableSpec.TableType type = 1;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }
    /**
     *
     *
     * <pre>
     * Type of this table.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.DatabaseTableSpec.TableType type = 1;</code>
     *
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeValue(int value) {
      type_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of this table.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.DatabaseTableSpec.TableType type = 1;</code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1.DatabaseTableSpec.TableType getType() {
      com.google.cloud.datacatalog.v1.DatabaseTableSpec.TableType result =
          com.google.cloud.datacatalog.v1.DatabaseTableSpec.TableType.forNumber(type_);
      return result == null
          ? com.google.cloud.datacatalog.v1.DatabaseTableSpec.TableType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Type of this table.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.DatabaseTableSpec.TableType type = 1;</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(com.google.cloud.datacatalog.v1.DatabaseTableSpec.TableType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of this table.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.DatabaseTableSpec.TableType type = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      bitField0_ = (bitField0_ & ~0x00000001);
      type_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.datacatalog.v1.DataplexTableSpec dataplexTable_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.DataplexTableSpec,
            com.google.cloud.datacatalog.v1.DataplexTableSpec.Builder,
            com.google.cloud.datacatalog.v1.DataplexTableSpecOrBuilder>
        dataplexTableBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Fields specific to a Dataplex table and present only in the
     * Dataplex table entries.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.DataplexTableSpec dataplex_table = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the dataplexTable field is set.
     */
    public boolean hasDataplexTable() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Fields specific to a Dataplex table and present only in the
     * Dataplex table entries.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.DataplexTableSpec dataplex_table = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The dataplexTable.
     */
    public com.google.cloud.datacatalog.v1.DataplexTableSpec getDataplexTable() {
      if (dataplexTableBuilder_ == null) {
        return dataplexTable_ == null
            ? com.google.cloud.datacatalog.v1.DataplexTableSpec.getDefaultInstance()
            : dataplexTable_;
      } else {
        return dataplexTableBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Fields specific to a Dataplex table and present only in the
     * Dataplex table entries.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.DataplexTableSpec dataplex_table = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDataplexTable(com.google.cloud.datacatalog.v1.DataplexTableSpec value) {
      if (dataplexTableBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dataplexTable_ = value;
      } else {
        dataplexTableBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Fields specific to a Dataplex table and present only in the
     * Dataplex table entries.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.DataplexTableSpec dataplex_table = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDataplexTable(
        com.google.cloud.datacatalog.v1.DataplexTableSpec.Builder builderForValue) {
      if (dataplexTableBuilder_ == null) {
        dataplexTable_ = builderForValue.build();
      } else {
        dataplexTableBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Fields specific to a Dataplex table and present only in the
     * Dataplex table entries.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.DataplexTableSpec dataplex_table = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeDataplexTable(com.google.cloud.datacatalog.v1.DataplexTableSpec value) {
      if (dataplexTableBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && dataplexTable_ != null
            && dataplexTable_
                != com.google.cloud.datacatalog.v1.DataplexTableSpec.getDefaultInstance()) {
          getDataplexTableBuilder().mergeFrom(value);
        } else {
          dataplexTable_ = value;
        }
      } else {
        dataplexTableBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Fields specific to a Dataplex table and present only in the
     * Dataplex table entries.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.DataplexTableSpec dataplex_table = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearDataplexTable() {
      bitField0_ = (bitField0_ & ~0x00000002);
      dataplexTable_ = null;
      if (dataplexTableBuilder_ != null) {
        dataplexTableBuilder_.dispose();
        dataplexTableBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Fields specific to a Dataplex table and present only in the
     * Dataplex table entries.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.DataplexTableSpec dataplex_table = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.datacatalog.v1.DataplexTableSpec.Builder getDataplexTableBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getDataplexTableFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Fields specific to a Dataplex table and present only in the
     * Dataplex table entries.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.DataplexTableSpec dataplex_table = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.datacatalog.v1.DataplexTableSpecOrBuilder getDataplexTableOrBuilder() {
      if (dataplexTableBuilder_ != null) {
        return dataplexTableBuilder_.getMessageOrBuilder();
      } else {
        return dataplexTable_ == null
            ? com.google.cloud.datacatalog.v1.DataplexTableSpec.getDefaultInstance()
            : dataplexTable_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Fields specific to a Dataplex table and present only in the
     * Dataplex table entries.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.DataplexTableSpec dataplex_table = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.DataplexTableSpec,
            com.google.cloud.datacatalog.v1.DataplexTableSpec.Builder,
            com.google.cloud.datacatalog.v1.DataplexTableSpecOrBuilder>
        getDataplexTableFieldBuilder() {
      if (dataplexTableBuilder_ == null) {
        dataplexTableBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datacatalog.v1.DataplexTableSpec,
                com.google.cloud.datacatalog.v1.DataplexTableSpec.Builder,
                com.google.cloud.datacatalog.v1.DataplexTableSpecOrBuilder>(
                getDataplexTable(), getParentForChildren(), isClean());
        dataplexTable_ = null;
      }
      return dataplexTableBuilder_;
    }

    private com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec databaseViewSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec,
            com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec.Builder,
            com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpecOrBuilder>
        databaseViewSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Spec what aplies to tables that are actually views.
     * Not set for "real" tables.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec database_view_spec = 3;
     * </code>
     *
     * @return Whether the databaseViewSpec field is set.
     */
    public boolean hasDatabaseViewSpec() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Spec what aplies to tables that are actually views.
     * Not set for "real" tables.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec database_view_spec = 3;
     * </code>
     *
     * @return The databaseViewSpec.
     */
    public com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec
        getDatabaseViewSpec() {
      if (databaseViewSpecBuilder_ == null) {
        return databaseViewSpec_ == null
            ? com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec
                .getDefaultInstance()
            : databaseViewSpec_;
      } else {
        return databaseViewSpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Spec what aplies to tables that are actually views.
     * Not set for "real" tables.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec database_view_spec = 3;
     * </code>
     */
    public Builder setDatabaseViewSpec(
        com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec value) {
      if (databaseViewSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        databaseViewSpec_ = value;
      } else {
        databaseViewSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Spec what aplies to tables that are actually views.
     * Not set for "real" tables.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec database_view_spec = 3;
     * </code>
     */
    public Builder setDatabaseViewSpec(
        com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec.Builder
            builderForValue) {
      if (databaseViewSpecBuilder_ == null) {
        databaseViewSpec_ = builderForValue.build();
      } else {
        databaseViewSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Spec what aplies to tables that are actually views.
     * Not set for "real" tables.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec database_view_spec = 3;
     * </code>
     */
    public Builder mergeDatabaseViewSpec(
        com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec value) {
      if (databaseViewSpecBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && databaseViewSpec_ != null
            && databaseViewSpec_
                != com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec
                    .getDefaultInstance()) {
          getDatabaseViewSpecBuilder().mergeFrom(value);
        } else {
          databaseViewSpec_ = value;
        }
      } else {
        databaseViewSpecBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Spec what aplies to tables that are actually views.
     * Not set for "real" tables.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec database_view_spec = 3;
     * </code>
     */
    public Builder clearDatabaseViewSpec() {
      bitField0_ = (bitField0_ & ~0x00000004);
      databaseViewSpec_ = null;
      if (databaseViewSpecBuilder_ != null) {
        databaseViewSpecBuilder_.dispose();
        databaseViewSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Spec what aplies to tables that are actually views.
     * Not set for "real" tables.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec database_view_spec = 3;
     * </code>
     */
    public com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec.Builder
        getDatabaseViewSpecBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getDatabaseViewSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Spec what aplies to tables that are actually views.
     * Not set for "real" tables.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec database_view_spec = 3;
     * </code>
     */
    public com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpecOrBuilder
        getDatabaseViewSpecOrBuilder() {
      if (databaseViewSpecBuilder_ != null) {
        return databaseViewSpecBuilder_.getMessageOrBuilder();
      } else {
        return databaseViewSpec_ == null
            ? com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec
                .getDefaultInstance()
            : databaseViewSpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * Spec what aplies to tables that are actually views.
     * Not set for "real" tables.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec database_view_spec = 3;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec,
            com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec.Builder,
            com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpecOrBuilder>
        getDatabaseViewSpecFieldBuilder() {
      if (databaseViewSpecBuilder_ == null) {
        databaseViewSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec,
                com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpec.Builder,
                com.google.cloud.datacatalog.v1.DatabaseTableSpec.DatabaseViewSpecOrBuilder>(
                getDatabaseViewSpec(), getParentForChildren(), isClean());
        databaseViewSpec_ = null;
      }
      return databaseViewSpecBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datacatalog.v1.DatabaseTableSpec)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datacatalog.v1.DatabaseTableSpec)
  private static final com.google.cloud.datacatalog.v1.DatabaseTableSpec DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datacatalog.v1.DatabaseTableSpec();
  }

  public static com.google.cloud.datacatalog.v1.DatabaseTableSpec getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DatabaseTableSpec> PARSER =
      new com.google.protobuf.AbstractParser<DatabaseTableSpec>() {
        @java.lang.Override
        public DatabaseTableSpec parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DatabaseTableSpec> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DatabaseTableSpec> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datacatalog.v1.DatabaseTableSpec getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
