/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datacatalog/v1/datacatalog.proto

package com.google.cloud.datacatalog.v1;

/**
 *
 *
 * <pre>
 * Specification that applies to a Service resource. Valid only
 * for entries with the `SERVICE` type.
 * </pre>
 *
 * Protobuf type {@code google.cloud.datacatalog.v1.ServiceSpec}
 */
public final class ServiceSpec extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datacatalog.v1.ServiceSpec)
    ServiceSpecOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ServiceSpec.newBuilder() to construct.
  private ServiceSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ServiceSpec() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ServiceSpec();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datacatalog.v1.Datacatalog
        .internal_static_google_cloud_datacatalog_v1_ServiceSpec_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datacatalog.v1.Datacatalog
        .internal_static_google_cloud_datacatalog_v1_ServiceSpec_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datacatalog.v1.ServiceSpec.class,
            com.google.cloud.datacatalog.v1.ServiceSpec.Builder.class);
  }

  private int systemSpecCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object systemSpec_;

  public enum SystemSpecCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    CLOUD_BIGTABLE_INSTANCE_SPEC(1),
    SYSTEMSPEC_NOT_SET(0);
    private final int value;

    private SystemSpecCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SystemSpecCase valueOf(int value) {
      return forNumber(value);
    }

    public static SystemSpecCase forNumber(int value) {
      switch (value) {
        case 1:
          return CLOUD_BIGTABLE_INSTANCE_SPEC;
        case 0:
          return SYSTEMSPEC_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SystemSpecCase getSystemSpecCase() {
    return SystemSpecCase.forNumber(systemSpecCase_);
  }

  public static final int CLOUD_BIGTABLE_INSTANCE_SPEC_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Specification that applies to Instance entries of `CLOUD_BIGTABLE`
   * system.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec cloud_bigtable_instance_spec = 1;
   * </code>
   *
   * @return Whether the cloudBigtableInstanceSpec field is set.
   */
  @java.lang.Override
  public boolean hasCloudBigtableInstanceSpec() {
    return systemSpecCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Specification that applies to Instance entries of `CLOUD_BIGTABLE`
   * system.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec cloud_bigtable_instance_spec = 1;
   * </code>
   *
   * @return The cloudBigtableInstanceSpec.
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec getCloudBigtableInstanceSpec() {
    if (systemSpecCase_ == 1) {
      return (com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec) systemSpec_;
    }
    return com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Specification that applies to Instance entries of `CLOUD_BIGTABLE`
   * system.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec cloud_bigtable_instance_spec = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpecOrBuilder
      getCloudBigtableInstanceSpecOrBuilder() {
    if (systemSpecCase_ == 1) {
      return (com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec) systemSpec_;
    }
    return com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (systemSpecCase_ == 1) {
      output.writeMessage(
          1, (com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec) systemSpec_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (systemSpecCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec) systemSpec_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datacatalog.v1.ServiceSpec)) {
      return super.equals(obj);
    }
    com.google.cloud.datacatalog.v1.ServiceSpec other =
        (com.google.cloud.datacatalog.v1.ServiceSpec) obj;

    if (!getSystemSpecCase().equals(other.getSystemSpecCase())) return false;
    switch (systemSpecCase_) {
      case 1:
        if (!getCloudBigtableInstanceSpec().equals(other.getCloudBigtableInstanceSpec()))
          return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (systemSpecCase_) {
      case 1:
        hash = (37 * hash) + CLOUD_BIGTABLE_INSTANCE_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getCloudBigtableInstanceSpec().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datacatalog.v1.ServiceSpec parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1.ServiceSpec parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.ServiceSpec parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1.ServiceSpec parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.ServiceSpec parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1.ServiceSpec parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.ServiceSpec parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1.ServiceSpec parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.ServiceSpec parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1.ServiceSpec parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.ServiceSpec parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1.ServiceSpec parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.datacatalog.v1.ServiceSpec prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Specification that applies to a Service resource. Valid only
   * for entries with the `SERVICE` type.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datacatalog.v1.ServiceSpec}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datacatalog.v1.ServiceSpec)
      com.google.cloud.datacatalog.v1.ServiceSpecOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datacatalog.v1.Datacatalog
          .internal_static_google_cloud_datacatalog_v1_ServiceSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datacatalog.v1.Datacatalog
          .internal_static_google_cloud_datacatalog_v1_ServiceSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datacatalog.v1.ServiceSpec.class,
              com.google.cloud.datacatalog.v1.ServiceSpec.Builder.class);
    }

    // Construct using com.google.cloud.datacatalog.v1.ServiceSpec.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (cloudBigtableInstanceSpecBuilder_ != null) {
        cloudBigtableInstanceSpecBuilder_.clear();
      }
      systemSpecCase_ = 0;
      systemSpec_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datacatalog.v1.Datacatalog
          .internal_static_google_cloud_datacatalog_v1_ServiceSpec_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.ServiceSpec getDefaultInstanceForType() {
      return com.google.cloud.datacatalog.v1.ServiceSpec.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.ServiceSpec build() {
      com.google.cloud.datacatalog.v1.ServiceSpec result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.ServiceSpec buildPartial() {
      com.google.cloud.datacatalog.v1.ServiceSpec result =
          new com.google.cloud.datacatalog.v1.ServiceSpec(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.datacatalog.v1.ServiceSpec result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.datacatalog.v1.ServiceSpec result) {
      result.systemSpecCase_ = systemSpecCase_;
      result.systemSpec_ = this.systemSpec_;
      if (systemSpecCase_ == 1 && cloudBigtableInstanceSpecBuilder_ != null) {
        result.systemSpec_ = cloudBigtableInstanceSpecBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datacatalog.v1.ServiceSpec) {
        return mergeFrom((com.google.cloud.datacatalog.v1.ServiceSpec) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datacatalog.v1.ServiceSpec other) {
      if (other == com.google.cloud.datacatalog.v1.ServiceSpec.getDefaultInstance()) return this;
      switch (other.getSystemSpecCase()) {
        case CLOUD_BIGTABLE_INSTANCE_SPEC:
          {
            mergeCloudBigtableInstanceSpec(other.getCloudBigtableInstanceSpec());
            break;
          }
        case SYSTEMSPEC_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(
                    getCloudBigtableInstanceSpecFieldBuilder().getBuilder(), extensionRegistry);
                systemSpecCase_ = 1;
                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int systemSpecCase_ = 0;
    private java.lang.Object systemSpec_;

    public SystemSpecCase getSystemSpecCase() {
      return SystemSpecCase.forNumber(systemSpecCase_);
    }

    public Builder clearSystemSpec() {
      systemSpecCase_ = 0;
      systemSpec_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec,
            com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.Builder,
            com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpecOrBuilder>
        cloudBigtableInstanceSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Specification that applies to Instance entries of `CLOUD_BIGTABLE`
     * system.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.CloudBigtableInstanceSpec cloud_bigtable_instance_spec = 1;
     * </code>
     *
     * @return Whether the cloudBigtableInstanceSpec field is set.
     */
    @java.lang.Override
    public boolean hasCloudBigtableInstanceSpec() {
      return systemSpecCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to Instance entries of `CLOUD_BIGTABLE`
     * system.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.CloudBigtableInstanceSpec cloud_bigtable_instance_spec = 1;
     * </code>
     *
     * @return The cloudBigtableInstanceSpec.
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec
        getCloudBigtableInstanceSpec() {
      if (cloudBigtableInstanceSpecBuilder_ == null) {
        if (systemSpecCase_ == 1) {
          return (com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec) systemSpec_;
        }
        return com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.getDefaultInstance();
      } else {
        if (systemSpecCase_ == 1) {
          return cloudBigtableInstanceSpecBuilder_.getMessage();
        }
        return com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to Instance entries of `CLOUD_BIGTABLE`
     * system.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.CloudBigtableInstanceSpec cloud_bigtable_instance_spec = 1;
     * </code>
     */
    public Builder setCloudBigtableInstanceSpec(
        com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec value) {
      if (cloudBigtableInstanceSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        systemSpec_ = value;
        onChanged();
      } else {
        cloudBigtableInstanceSpecBuilder_.setMessage(value);
      }
      systemSpecCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to Instance entries of `CLOUD_BIGTABLE`
     * system.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.CloudBigtableInstanceSpec cloud_bigtable_instance_spec = 1;
     * </code>
     */
    public Builder setCloudBigtableInstanceSpec(
        com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.Builder builderForValue) {
      if (cloudBigtableInstanceSpecBuilder_ == null) {
        systemSpec_ = builderForValue.build();
        onChanged();
      } else {
        cloudBigtableInstanceSpecBuilder_.setMessage(builderForValue.build());
      }
      systemSpecCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to Instance entries of `CLOUD_BIGTABLE`
     * system.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.CloudBigtableInstanceSpec cloud_bigtable_instance_spec = 1;
     * </code>
     */
    public Builder mergeCloudBigtableInstanceSpec(
        com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec value) {
      if (cloudBigtableInstanceSpecBuilder_ == null) {
        if (systemSpecCase_ == 1
            && systemSpec_
                != com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.getDefaultInstance()) {
          systemSpec_ =
              com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.newBuilder(
                      (com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec) systemSpec_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          systemSpec_ = value;
        }
        onChanged();
      } else {
        if (systemSpecCase_ == 1) {
          cloudBigtableInstanceSpecBuilder_.mergeFrom(value);
        } else {
          cloudBigtableInstanceSpecBuilder_.setMessage(value);
        }
      }
      systemSpecCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to Instance entries of `CLOUD_BIGTABLE`
     * system.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.CloudBigtableInstanceSpec cloud_bigtable_instance_spec = 1;
     * </code>
     */
    public Builder clearCloudBigtableInstanceSpec() {
      if (cloudBigtableInstanceSpecBuilder_ == null) {
        if (systemSpecCase_ == 1) {
          systemSpecCase_ = 0;
          systemSpec_ = null;
          onChanged();
        }
      } else {
        if (systemSpecCase_ == 1) {
          systemSpecCase_ = 0;
          systemSpec_ = null;
        }
        cloudBigtableInstanceSpecBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to Instance entries of `CLOUD_BIGTABLE`
     * system.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.CloudBigtableInstanceSpec cloud_bigtable_instance_spec = 1;
     * </code>
     */
    public com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.Builder
        getCloudBigtableInstanceSpecBuilder() {
      return getCloudBigtableInstanceSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to Instance entries of `CLOUD_BIGTABLE`
     * system.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.CloudBigtableInstanceSpec cloud_bigtable_instance_spec = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpecOrBuilder
        getCloudBigtableInstanceSpecOrBuilder() {
      if ((systemSpecCase_ == 1) && (cloudBigtableInstanceSpecBuilder_ != null)) {
        return cloudBigtableInstanceSpecBuilder_.getMessageOrBuilder();
      } else {
        if (systemSpecCase_ == 1) {
          return (com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec) systemSpec_;
        }
        return com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to Instance entries of `CLOUD_BIGTABLE`
     * system.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.CloudBigtableInstanceSpec cloud_bigtable_instance_spec = 1;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec,
            com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.Builder,
            com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpecOrBuilder>
        getCloudBigtableInstanceSpecFieldBuilder() {
      if (cloudBigtableInstanceSpecBuilder_ == null) {
        if (!(systemSpecCase_ == 1)) {
          systemSpec_ =
              com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.getDefaultInstance();
        }
        cloudBigtableInstanceSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec,
                com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec.Builder,
                com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpecOrBuilder>(
                (com.google.cloud.datacatalog.v1.CloudBigtableInstanceSpec) systemSpec_,
                getParentForChildren(),
                isClean());
        systemSpec_ = null;
      }
      systemSpecCase_ = 1;
      onChanged();
      return cloudBigtableInstanceSpecBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datacatalog.v1.ServiceSpec)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datacatalog.v1.ServiceSpec)
  private static final com.google.cloud.datacatalog.v1.ServiceSpec DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datacatalog.v1.ServiceSpec();
  }

  public static com.google.cloud.datacatalog.v1.ServiceSpec getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ServiceSpec> PARSER =
      new com.google.protobuf.AbstractParser<ServiceSpec>() {
        @java.lang.Override
        public ServiceSpec parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ServiceSpec> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ServiceSpec> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datacatalog.v1.ServiceSpec getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
