/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datacatalog/v1/dump_content.proto

package com.google.cloud.datacatalog.v1;

/**
 *
 *
 * <pre>
 * Wrapper containing Entry and information about Tags
 * that should and should not be attached to it.
 * </pre>
 *
 * Protobuf type {@code google.cloud.datacatalog.v1.TaggedEntry}
 */
public final class TaggedEntry extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datacatalog.v1.TaggedEntry)
    TaggedEntryOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TaggedEntry.newBuilder() to construct.
  private TaggedEntry(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TaggedEntry() {
    presentTags_ = java.util.Collections.emptyList();
    absentTags_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TaggedEntry();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datacatalog.v1.DumpContentProto
        .internal_static_google_cloud_datacatalog_v1_TaggedEntry_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datacatalog.v1.DumpContentProto
        .internal_static_google_cloud_datacatalog_v1_TaggedEntry_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datacatalog.v1.TaggedEntry.class,
            com.google.cloud.datacatalog.v1.TaggedEntry.Builder.class);
  }

  private int entryCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object entry_;

  public enum EntryCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    V1_ENTRY(1),
    ENTRY_NOT_SET(0);
    private final int value;

    private EntryCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static EntryCase valueOf(int value) {
      return forNumber(value);
    }

    public static EntryCase forNumber(int value) {
      switch (value) {
        case 1:
          return V1_ENTRY;
        case 0:
          return ENTRY_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public EntryCase getEntryCase() {
    return EntryCase.forNumber(entryCase_);
  }

  public static final int V1_ENTRY_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Non-encrypted Data Catalog v1 Entry.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.Entry v1_entry = 1;</code>
   *
   * @return Whether the v1Entry field is set.
   */
  @java.lang.Override
  public boolean hasV1Entry() {
    return entryCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Non-encrypted Data Catalog v1 Entry.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.Entry v1_entry = 1;</code>
   *
   * @return The v1Entry.
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.Entry getV1Entry() {
    if (entryCase_ == 1) {
      return (com.google.cloud.datacatalog.v1.Entry) entry_;
    }
    return com.google.cloud.datacatalog.v1.Entry.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Non-encrypted Data Catalog v1 Entry.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.Entry v1_entry = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.EntryOrBuilder getV1EntryOrBuilder() {
    if (entryCase_ == 1) {
      return (com.google.cloud.datacatalog.v1.Entry) entry_;
    }
    return com.google.cloud.datacatalog.v1.Entry.getDefaultInstance();
  }

  public static final int PRESENT_TAGS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.datacatalog.v1.Tag> presentTags_;
  /**
   *
   *
   * <pre>
   * Optional. Tags that should be ingested into the Data Catalog.
   * Caller should populate template name, column and fields.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datacatalog.v1.Tag present_tags = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.datacatalog.v1.Tag> getPresentTagsList() {
    return presentTags_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Tags that should be ingested into the Data Catalog.
   * Caller should populate template name, column and fields.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datacatalog.v1.Tag present_tags = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.datacatalog.v1.TagOrBuilder>
      getPresentTagsOrBuilderList() {
    return presentTags_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Tags that should be ingested into the Data Catalog.
   * Caller should populate template name, column and fields.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datacatalog.v1.Tag present_tags = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getPresentTagsCount() {
    return presentTags_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Tags that should be ingested into the Data Catalog.
   * Caller should populate template name, column and fields.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datacatalog.v1.Tag present_tags = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.Tag getPresentTags(int index) {
    return presentTags_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. Tags that should be ingested into the Data Catalog.
   * Caller should populate template name, column and fields.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datacatalog.v1.Tag present_tags = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.TagOrBuilder getPresentTagsOrBuilder(int index) {
    return presentTags_.get(index);
  }

  public static final int ABSENT_TAGS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.datacatalog.v1.Tag> absentTags_;
  /**
   *
   *
   * <pre>
   * Optional. Tags that should be deleted from the Data Catalog.
   * Caller should populate template name and column only.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datacatalog.v1.Tag absent_tags = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.datacatalog.v1.Tag> getAbsentTagsList() {
    return absentTags_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Tags that should be deleted from the Data Catalog.
   * Caller should populate template name and column only.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datacatalog.v1.Tag absent_tags = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.datacatalog.v1.TagOrBuilder>
      getAbsentTagsOrBuilderList() {
    return absentTags_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Tags that should be deleted from the Data Catalog.
   * Caller should populate template name and column only.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datacatalog.v1.Tag absent_tags = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getAbsentTagsCount() {
    return absentTags_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Tags that should be deleted from the Data Catalog.
   * Caller should populate template name and column only.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datacatalog.v1.Tag absent_tags = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.Tag getAbsentTags(int index) {
    return absentTags_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. Tags that should be deleted from the Data Catalog.
   * Caller should populate template name and column only.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datacatalog.v1.Tag absent_tags = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.TagOrBuilder getAbsentTagsOrBuilder(int index) {
    return absentTags_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (entryCase_ == 1) {
      output.writeMessage(1, (com.google.cloud.datacatalog.v1.Entry) entry_);
    }
    for (int i = 0; i < presentTags_.size(); i++) {
      output.writeMessage(2, presentTags_.get(i));
    }
    for (int i = 0; i < absentTags_.size(); i++) {
      output.writeMessage(3, absentTags_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (entryCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.cloud.datacatalog.v1.Entry) entry_);
    }
    for (int i = 0; i < presentTags_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, presentTags_.get(i));
    }
    for (int i = 0; i < absentTags_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, absentTags_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datacatalog.v1.TaggedEntry)) {
      return super.equals(obj);
    }
    com.google.cloud.datacatalog.v1.TaggedEntry other =
        (com.google.cloud.datacatalog.v1.TaggedEntry) obj;

    if (!getPresentTagsList().equals(other.getPresentTagsList())) return false;
    if (!getAbsentTagsList().equals(other.getAbsentTagsList())) return false;
    if (!getEntryCase().equals(other.getEntryCase())) return false;
    switch (entryCase_) {
      case 1:
        if (!getV1Entry().equals(other.getV1Entry())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getPresentTagsCount() > 0) {
      hash = (37 * hash) + PRESENT_TAGS_FIELD_NUMBER;
      hash = (53 * hash) + getPresentTagsList().hashCode();
    }
    if (getAbsentTagsCount() > 0) {
      hash = (37 * hash) + ABSENT_TAGS_FIELD_NUMBER;
      hash = (53 * hash) + getAbsentTagsList().hashCode();
    }
    switch (entryCase_) {
      case 1:
        hash = (37 * hash) + V1_ENTRY_FIELD_NUMBER;
        hash = (53 * hash) + getV1Entry().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datacatalog.v1.TaggedEntry parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1.TaggedEntry parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.TaggedEntry parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1.TaggedEntry parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.TaggedEntry parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1.TaggedEntry parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.TaggedEntry parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1.TaggedEntry parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.TaggedEntry parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1.TaggedEntry parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.TaggedEntry parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1.TaggedEntry parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.datacatalog.v1.TaggedEntry prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Wrapper containing Entry and information about Tags
   * that should and should not be attached to it.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datacatalog.v1.TaggedEntry}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datacatalog.v1.TaggedEntry)
      com.google.cloud.datacatalog.v1.TaggedEntryOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datacatalog.v1.DumpContentProto
          .internal_static_google_cloud_datacatalog_v1_TaggedEntry_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datacatalog.v1.DumpContentProto
          .internal_static_google_cloud_datacatalog_v1_TaggedEntry_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datacatalog.v1.TaggedEntry.class,
              com.google.cloud.datacatalog.v1.TaggedEntry.Builder.class);
    }

    // Construct using com.google.cloud.datacatalog.v1.TaggedEntry.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (v1EntryBuilder_ != null) {
        v1EntryBuilder_.clear();
      }
      if (presentTagsBuilder_ == null) {
        presentTags_ = java.util.Collections.emptyList();
      } else {
        presentTags_ = null;
        presentTagsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      if (absentTagsBuilder_ == null) {
        absentTags_ = java.util.Collections.emptyList();
      } else {
        absentTags_ = null;
        absentTagsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      entryCase_ = 0;
      entry_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datacatalog.v1.DumpContentProto
          .internal_static_google_cloud_datacatalog_v1_TaggedEntry_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.TaggedEntry getDefaultInstanceForType() {
      return com.google.cloud.datacatalog.v1.TaggedEntry.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.TaggedEntry build() {
      com.google.cloud.datacatalog.v1.TaggedEntry result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.TaggedEntry buildPartial() {
      com.google.cloud.datacatalog.v1.TaggedEntry result =
          new com.google.cloud.datacatalog.v1.TaggedEntry(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.datacatalog.v1.TaggedEntry result) {
      if (presentTagsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          presentTags_ = java.util.Collections.unmodifiableList(presentTags_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.presentTags_ = presentTags_;
      } else {
        result.presentTags_ = presentTagsBuilder_.build();
      }
      if (absentTagsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          absentTags_ = java.util.Collections.unmodifiableList(absentTags_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.absentTags_ = absentTags_;
      } else {
        result.absentTags_ = absentTagsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.datacatalog.v1.TaggedEntry result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.datacatalog.v1.TaggedEntry result) {
      result.entryCase_ = entryCase_;
      result.entry_ = this.entry_;
      if (entryCase_ == 1 && v1EntryBuilder_ != null) {
        result.entry_ = v1EntryBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datacatalog.v1.TaggedEntry) {
        return mergeFrom((com.google.cloud.datacatalog.v1.TaggedEntry) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datacatalog.v1.TaggedEntry other) {
      if (other == com.google.cloud.datacatalog.v1.TaggedEntry.getDefaultInstance()) return this;
      if (presentTagsBuilder_ == null) {
        if (!other.presentTags_.isEmpty()) {
          if (presentTags_.isEmpty()) {
            presentTags_ = other.presentTags_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensurePresentTagsIsMutable();
            presentTags_.addAll(other.presentTags_);
          }
          onChanged();
        }
      } else {
        if (!other.presentTags_.isEmpty()) {
          if (presentTagsBuilder_.isEmpty()) {
            presentTagsBuilder_.dispose();
            presentTagsBuilder_ = null;
            presentTags_ = other.presentTags_;
            bitField0_ = (bitField0_ & ~0x00000002);
            presentTagsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPresentTagsFieldBuilder()
                    : null;
          } else {
            presentTagsBuilder_.addAllMessages(other.presentTags_);
          }
        }
      }
      if (absentTagsBuilder_ == null) {
        if (!other.absentTags_.isEmpty()) {
          if (absentTags_.isEmpty()) {
            absentTags_ = other.absentTags_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureAbsentTagsIsMutable();
            absentTags_.addAll(other.absentTags_);
          }
          onChanged();
        }
      } else {
        if (!other.absentTags_.isEmpty()) {
          if (absentTagsBuilder_.isEmpty()) {
            absentTagsBuilder_.dispose();
            absentTagsBuilder_ = null;
            absentTags_ = other.absentTags_;
            bitField0_ = (bitField0_ & ~0x00000004);
            absentTagsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAbsentTagsFieldBuilder()
                    : null;
          } else {
            absentTagsBuilder_.addAllMessages(other.absentTags_);
          }
        }
      }
      switch (other.getEntryCase()) {
        case V1_ENTRY:
          {
            mergeV1Entry(other.getV1Entry());
            break;
          }
        case ENTRY_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getV1EntryFieldBuilder().getBuilder(), extensionRegistry);
                entryCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.datacatalog.v1.Tag m =
                    input.readMessage(
                        com.google.cloud.datacatalog.v1.Tag.parser(), extensionRegistry);
                if (presentTagsBuilder_ == null) {
                  ensurePresentTagsIsMutable();
                  presentTags_.add(m);
                } else {
                  presentTagsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                com.google.cloud.datacatalog.v1.Tag m =
                    input.readMessage(
                        com.google.cloud.datacatalog.v1.Tag.parser(), extensionRegistry);
                if (absentTagsBuilder_ == null) {
                  ensureAbsentTagsIsMutable();
                  absentTags_.add(m);
                } else {
                  absentTagsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int entryCase_ = 0;
    private java.lang.Object entry_;

    public EntryCase getEntryCase() {
      return EntryCase.forNumber(entryCase_);
    }

    public Builder clearEntry() {
      entryCase_ = 0;
      entry_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.Entry,
            com.google.cloud.datacatalog.v1.Entry.Builder,
            com.google.cloud.datacatalog.v1.EntryOrBuilder>
        v1EntryBuilder_;
    /**
     *
     *
     * <pre>
     * Non-encrypted Data Catalog v1 Entry.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.Entry v1_entry = 1;</code>
     *
     * @return Whether the v1Entry field is set.
     */
    @java.lang.Override
    public boolean hasV1Entry() {
      return entryCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Non-encrypted Data Catalog v1 Entry.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.Entry v1_entry = 1;</code>
     *
     * @return The v1Entry.
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1.Entry getV1Entry() {
      if (v1EntryBuilder_ == null) {
        if (entryCase_ == 1) {
          return (com.google.cloud.datacatalog.v1.Entry) entry_;
        }
        return com.google.cloud.datacatalog.v1.Entry.getDefaultInstance();
      } else {
        if (entryCase_ == 1) {
          return v1EntryBuilder_.getMessage();
        }
        return com.google.cloud.datacatalog.v1.Entry.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Non-encrypted Data Catalog v1 Entry.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.Entry v1_entry = 1;</code>
     */
    public Builder setV1Entry(com.google.cloud.datacatalog.v1.Entry value) {
      if (v1EntryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        entry_ = value;
        onChanged();
      } else {
        v1EntryBuilder_.setMessage(value);
      }
      entryCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Non-encrypted Data Catalog v1 Entry.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.Entry v1_entry = 1;</code>
     */
    public Builder setV1Entry(com.google.cloud.datacatalog.v1.Entry.Builder builderForValue) {
      if (v1EntryBuilder_ == null) {
        entry_ = builderForValue.build();
        onChanged();
      } else {
        v1EntryBuilder_.setMessage(builderForValue.build());
      }
      entryCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Non-encrypted Data Catalog v1 Entry.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.Entry v1_entry = 1;</code>
     */
    public Builder mergeV1Entry(com.google.cloud.datacatalog.v1.Entry value) {
      if (v1EntryBuilder_ == null) {
        if (entryCase_ == 1
            && entry_ != com.google.cloud.datacatalog.v1.Entry.getDefaultInstance()) {
          entry_ =
              com.google.cloud.datacatalog.v1.Entry.newBuilder(
                      (com.google.cloud.datacatalog.v1.Entry) entry_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          entry_ = value;
        }
        onChanged();
      } else {
        if (entryCase_ == 1) {
          v1EntryBuilder_.mergeFrom(value);
        } else {
          v1EntryBuilder_.setMessage(value);
        }
      }
      entryCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Non-encrypted Data Catalog v1 Entry.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.Entry v1_entry = 1;</code>
     */
    public Builder clearV1Entry() {
      if (v1EntryBuilder_ == null) {
        if (entryCase_ == 1) {
          entryCase_ = 0;
          entry_ = null;
          onChanged();
        }
      } else {
        if (entryCase_ == 1) {
          entryCase_ = 0;
          entry_ = null;
        }
        v1EntryBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Non-encrypted Data Catalog v1 Entry.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.Entry v1_entry = 1;</code>
     */
    public com.google.cloud.datacatalog.v1.Entry.Builder getV1EntryBuilder() {
      return getV1EntryFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Non-encrypted Data Catalog v1 Entry.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.Entry v1_entry = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1.EntryOrBuilder getV1EntryOrBuilder() {
      if ((entryCase_ == 1) && (v1EntryBuilder_ != null)) {
        return v1EntryBuilder_.getMessageOrBuilder();
      } else {
        if (entryCase_ == 1) {
          return (com.google.cloud.datacatalog.v1.Entry) entry_;
        }
        return com.google.cloud.datacatalog.v1.Entry.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Non-encrypted Data Catalog v1 Entry.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.Entry v1_entry = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.Entry,
            com.google.cloud.datacatalog.v1.Entry.Builder,
            com.google.cloud.datacatalog.v1.EntryOrBuilder>
        getV1EntryFieldBuilder() {
      if (v1EntryBuilder_ == null) {
        if (!(entryCase_ == 1)) {
          entry_ = com.google.cloud.datacatalog.v1.Entry.getDefaultInstance();
        }
        v1EntryBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datacatalog.v1.Entry,
                com.google.cloud.datacatalog.v1.Entry.Builder,
                com.google.cloud.datacatalog.v1.EntryOrBuilder>(
                (com.google.cloud.datacatalog.v1.Entry) entry_, getParentForChildren(), isClean());
        entry_ = null;
      }
      entryCase_ = 1;
      onChanged();
      return v1EntryBuilder_;
    }

    private java.util.List<com.google.cloud.datacatalog.v1.Tag> presentTags_ =
        java.util.Collections.emptyList();

    private void ensurePresentTagsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        presentTags_ = new java.util.ArrayList<com.google.cloud.datacatalog.v1.Tag>(presentTags_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.datacatalog.v1.Tag,
            com.google.cloud.datacatalog.v1.Tag.Builder,
            com.google.cloud.datacatalog.v1.TagOrBuilder>
        presentTagsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Tags that should be ingested into the Data Catalog.
     * Caller should populate template name, column and fields.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.Tag present_tags = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.datacatalog.v1.Tag> getPresentTagsList() {
      if (presentTagsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(presentTags_);
      } else {
        return presentTagsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Tags that should be ingested into the Data Catalog.
     * Caller should populate template name, column and fields.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.Tag present_tags = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getPresentTagsCount() {
      if (presentTagsBuilder_ == null) {
        return presentTags_.size();
      } else {
        return presentTagsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Tags that should be ingested into the Data Catalog.
     * Caller should populate template name, column and fields.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.Tag present_tags = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.datacatalog.v1.Tag getPresentTags(int index) {
      if (presentTagsBuilder_ == null) {
        return presentTags_.get(index);
      } else {
        return presentTagsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Tags that should be ingested into the Data Catalog.
     * Caller should populate template name, column and fields.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.Tag present_tags = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPresentTags(int index, com.google.cloud.datacatalog.v1.Tag value) {
      if (presentTagsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePresentTagsIsMutable();
        presentTags_.set(index, value);
        onChanged();
      } else {
        presentTagsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Tags that should be ingested into the Data Catalog.
     * Caller should populate template name, column and fields.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.Tag present_tags = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPresentTags(
        int index, com.google.cloud.datacatalog.v1.Tag.Builder builderForValue) {
      if (presentTagsBuilder_ == null) {
        ensurePresentTagsIsMutable();
        presentTags_.set(index, builderForValue.build());
        onChanged();
      } else {
        presentTagsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Tags that should be ingested into the Data Catalog.
     * Caller should populate template name, column and fields.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.Tag present_tags = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addPresentTags(com.google.cloud.datacatalog.v1.Tag value) {
      if (presentTagsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePresentTagsIsMutable();
        presentTags_.add(value);
        onChanged();
      } else {
        presentTagsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Tags that should be ingested into the Data Catalog.
     * Caller should populate template name, column and fields.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.Tag present_tags = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addPresentTags(int index, com.google.cloud.datacatalog.v1.Tag value) {
      if (presentTagsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePresentTagsIsMutable();
        presentTags_.add(index, value);
        onChanged();
      } else {
        presentTagsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Tags that should be ingested into the Data Catalog.
     * Caller should populate template name, column and fields.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.Tag present_tags = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addPresentTags(com.google.cloud.datacatalog.v1.Tag.Builder builderForValue) {
      if (presentTagsBuilder_ == null) {
        ensurePresentTagsIsMutable();
        presentTags_.add(builderForValue.build());
        onChanged();
      } else {
        presentTagsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Tags that should be ingested into the Data Catalog.
     * Caller should populate template name, column and fields.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.Tag present_tags = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addPresentTags(
        int index, com.google.cloud.datacatalog.v1.Tag.Builder builderForValue) {
      if (presentTagsBuilder_ == null) {
        ensurePresentTagsIsMutable();
        presentTags_.add(index, builderForValue.build());
        onChanged();
      } else {
        presentTagsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Tags that should be ingested into the Data Catalog.
     * Caller should populate template name, column and fields.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.Tag present_tags = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllPresentTags(
        java.lang.Iterable<? extends com.google.cloud.datacatalog.v1.Tag> values) {
      if (presentTagsBuilder_ == null) {
        ensurePresentTagsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, presentTags_);
        onChanged();
      } else {
        presentTagsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Tags that should be ingested into the Data Catalog.
     * Caller should populate template name, column and fields.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.Tag present_tags = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearPresentTags() {
      if (presentTagsBuilder_ == null) {
        presentTags_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        presentTagsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Tags that should be ingested into the Data Catalog.
     * Caller should populate template name, column and fields.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.Tag present_tags = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removePresentTags(int index) {
      if (presentTagsBuilder_ == null) {
        ensurePresentTagsIsMutable();
        presentTags_.remove(index);
        onChanged();
      } else {
        presentTagsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Tags that should be ingested into the Data Catalog.
     * Caller should populate template name, column and fields.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.Tag present_tags = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.datacatalog.v1.Tag.Builder getPresentTagsBuilder(int index) {
      return getPresentTagsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Tags that should be ingested into the Data Catalog.
     * Caller should populate template name, column and fields.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.Tag present_tags = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.datacatalog.v1.TagOrBuilder getPresentTagsOrBuilder(int index) {
      if (presentTagsBuilder_ == null) {
        return presentTags_.get(index);
      } else {
        return presentTagsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Tags that should be ingested into the Data Catalog.
     * Caller should populate template name, column and fields.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.Tag present_tags = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.datacatalog.v1.TagOrBuilder>
        getPresentTagsOrBuilderList() {
      if (presentTagsBuilder_ != null) {
        return presentTagsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(presentTags_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Tags that should be ingested into the Data Catalog.
     * Caller should populate template name, column and fields.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.Tag present_tags = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.datacatalog.v1.Tag.Builder addPresentTagsBuilder() {
      return getPresentTagsFieldBuilder()
          .addBuilder(com.google.cloud.datacatalog.v1.Tag.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Tags that should be ingested into the Data Catalog.
     * Caller should populate template name, column and fields.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.Tag present_tags = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.datacatalog.v1.Tag.Builder addPresentTagsBuilder(int index) {
      return getPresentTagsFieldBuilder()
          .addBuilder(index, com.google.cloud.datacatalog.v1.Tag.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Tags that should be ingested into the Data Catalog.
     * Caller should populate template name, column and fields.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.Tag present_tags = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.datacatalog.v1.Tag.Builder> getPresentTagsBuilderList() {
      return getPresentTagsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.datacatalog.v1.Tag,
            com.google.cloud.datacatalog.v1.Tag.Builder,
            com.google.cloud.datacatalog.v1.TagOrBuilder>
        getPresentTagsFieldBuilder() {
      if (presentTagsBuilder_ == null) {
        presentTagsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.datacatalog.v1.Tag,
                com.google.cloud.datacatalog.v1.Tag.Builder,
                com.google.cloud.datacatalog.v1.TagOrBuilder>(
                presentTags_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        presentTags_ = null;
      }
      return presentTagsBuilder_;
    }

    private java.util.List<com.google.cloud.datacatalog.v1.Tag> absentTags_ =
        java.util.Collections.emptyList();

    private void ensureAbsentTagsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        absentTags_ = new java.util.ArrayList<com.google.cloud.datacatalog.v1.Tag>(absentTags_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.datacatalog.v1.Tag,
            com.google.cloud.datacatalog.v1.Tag.Builder,
            com.google.cloud.datacatalog.v1.TagOrBuilder>
        absentTagsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Tags that should be deleted from the Data Catalog.
     * Caller should populate template name and column only.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.Tag absent_tags = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.datacatalog.v1.Tag> getAbsentTagsList() {
      if (absentTagsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(absentTags_);
      } else {
        return absentTagsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Tags that should be deleted from the Data Catalog.
     * Caller should populate template name and column only.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.Tag absent_tags = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getAbsentTagsCount() {
      if (absentTagsBuilder_ == null) {
        return absentTags_.size();
      } else {
        return absentTagsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Tags that should be deleted from the Data Catalog.
     * Caller should populate template name and column only.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.Tag absent_tags = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.datacatalog.v1.Tag getAbsentTags(int index) {
      if (absentTagsBuilder_ == null) {
        return absentTags_.get(index);
      } else {
        return absentTagsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Tags that should be deleted from the Data Catalog.
     * Caller should populate template name and column only.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.Tag absent_tags = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAbsentTags(int index, com.google.cloud.datacatalog.v1.Tag value) {
      if (absentTagsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAbsentTagsIsMutable();
        absentTags_.set(index, value);
        onChanged();
      } else {
        absentTagsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Tags that should be deleted from the Data Catalog.
     * Caller should populate template name and column only.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.Tag absent_tags = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAbsentTags(
        int index, com.google.cloud.datacatalog.v1.Tag.Builder builderForValue) {
      if (absentTagsBuilder_ == null) {
        ensureAbsentTagsIsMutable();
        absentTags_.set(index, builderForValue.build());
        onChanged();
      } else {
        absentTagsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Tags that should be deleted from the Data Catalog.
     * Caller should populate template name and column only.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.Tag absent_tags = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAbsentTags(com.google.cloud.datacatalog.v1.Tag value) {
      if (absentTagsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAbsentTagsIsMutable();
        absentTags_.add(value);
        onChanged();
      } else {
        absentTagsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Tags that should be deleted from the Data Catalog.
     * Caller should populate template name and column only.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.Tag absent_tags = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAbsentTags(int index, com.google.cloud.datacatalog.v1.Tag value) {
      if (absentTagsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAbsentTagsIsMutable();
        absentTags_.add(index, value);
        onChanged();
      } else {
        absentTagsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Tags that should be deleted from the Data Catalog.
     * Caller should populate template name and column only.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.Tag absent_tags = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAbsentTags(com.google.cloud.datacatalog.v1.Tag.Builder builderForValue) {
      if (absentTagsBuilder_ == null) {
        ensureAbsentTagsIsMutable();
        absentTags_.add(builderForValue.build());
        onChanged();
      } else {
        absentTagsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Tags that should be deleted from the Data Catalog.
     * Caller should populate template name and column only.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.Tag absent_tags = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAbsentTags(
        int index, com.google.cloud.datacatalog.v1.Tag.Builder builderForValue) {
      if (absentTagsBuilder_ == null) {
        ensureAbsentTagsIsMutable();
        absentTags_.add(index, builderForValue.build());
        onChanged();
      } else {
        absentTagsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Tags that should be deleted from the Data Catalog.
     * Caller should populate template name and column only.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.Tag absent_tags = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllAbsentTags(
        java.lang.Iterable<? extends com.google.cloud.datacatalog.v1.Tag> values) {
      if (absentTagsBuilder_ == null) {
        ensureAbsentTagsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, absentTags_);
        onChanged();
      } else {
        absentTagsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Tags that should be deleted from the Data Catalog.
     * Caller should populate template name and column only.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.Tag absent_tags = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearAbsentTags() {
      if (absentTagsBuilder_ == null) {
        absentTags_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        absentTagsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Tags that should be deleted from the Data Catalog.
     * Caller should populate template name and column only.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.Tag absent_tags = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeAbsentTags(int index) {
      if (absentTagsBuilder_ == null) {
        ensureAbsentTagsIsMutable();
        absentTags_.remove(index);
        onChanged();
      } else {
        absentTagsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Tags that should be deleted from the Data Catalog.
     * Caller should populate template name and column only.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.Tag absent_tags = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.datacatalog.v1.Tag.Builder getAbsentTagsBuilder(int index) {
      return getAbsentTagsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. Tags that should be deleted from the Data Catalog.
     * Caller should populate template name and column only.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.Tag absent_tags = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.datacatalog.v1.TagOrBuilder getAbsentTagsOrBuilder(int index) {
      if (absentTagsBuilder_ == null) {
        return absentTags_.get(index);
      } else {
        return absentTagsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Tags that should be deleted from the Data Catalog.
     * Caller should populate template name and column only.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.Tag absent_tags = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.datacatalog.v1.TagOrBuilder>
        getAbsentTagsOrBuilderList() {
      if (absentTagsBuilder_ != null) {
        return absentTagsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(absentTags_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Tags that should be deleted from the Data Catalog.
     * Caller should populate template name and column only.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.Tag absent_tags = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.datacatalog.v1.Tag.Builder addAbsentTagsBuilder() {
      return getAbsentTagsFieldBuilder()
          .addBuilder(com.google.cloud.datacatalog.v1.Tag.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Tags that should be deleted from the Data Catalog.
     * Caller should populate template name and column only.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.Tag absent_tags = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.datacatalog.v1.Tag.Builder addAbsentTagsBuilder(int index) {
      return getAbsentTagsFieldBuilder()
          .addBuilder(index, com.google.cloud.datacatalog.v1.Tag.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. Tags that should be deleted from the Data Catalog.
     * Caller should populate template name and column only.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1.Tag absent_tags = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.datacatalog.v1.Tag.Builder> getAbsentTagsBuilderList() {
      return getAbsentTagsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.datacatalog.v1.Tag,
            com.google.cloud.datacatalog.v1.Tag.Builder,
            com.google.cloud.datacatalog.v1.TagOrBuilder>
        getAbsentTagsFieldBuilder() {
      if (absentTagsBuilder_ == null) {
        absentTagsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.datacatalog.v1.Tag,
                com.google.cloud.datacatalog.v1.Tag.Builder,
                com.google.cloud.datacatalog.v1.TagOrBuilder>(
                absentTags_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        absentTags_ = null;
      }
      return absentTagsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datacatalog.v1.TaggedEntry)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datacatalog.v1.TaggedEntry)
  private static final com.google.cloud.datacatalog.v1.TaggedEntry DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datacatalog.v1.TaggedEntry();
  }

  public static com.google.cloud.datacatalog.v1.TaggedEntry getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TaggedEntry> PARSER =
      new com.google.protobuf.AbstractParser<TaggedEntry>() {
        @java.lang.Override
        public TaggedEntry parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TaggedEntry> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TaggedEntry> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datacatalog.v1.TaggedEntry getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
