/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datacatalog/v1/datacatalog.proto

package com.google.cloud.datacatalog.v1;

/**
 *
 *
 * <pre>
 * Specification for vertex model resources.
 * </pre>
 *
 * Protobuf type {@code google.cloud.datacatalog.v1.VertexModelSpec}
 */
public final class VertexModelSpec extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datacatalog.v1.VertexModelSpec)
    VertexModelSpecOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use VertexModelSpec.newBuilder() to construct.
  private VertexModelSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private VertexModelSpec() {
    versionId_ = "";
    versionAliases_ = com.google.protobuf.LazyStringArrayList.emptyList();
    versionDescription_ = "";
    containerImageUri_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new VertexModelSpec();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datacatalog.v1.Datacatalog
        .internal_static_google_cloud_datacatalog_v1_VertexModelSpec_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datacatalog.v1.Datacatalog
        .internal_static_google_cloud_datacatalog_v1_VertexModelSpec_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datacatalog.v1.VertexModelSpec.class,
            com.google.cloud.datacatalog.v1.VertexModelSpec.Builder.class);
  }

  public static final int VERSION_ID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object versionId_ = "";
  /**
   *
   *
   * <pre>
   * The version ID of the model.
   * </pre>
   *
   * <code>string version_id = 1;</code>
   *
   * @return The versionId.
   */
  @java.lang.Override
  public java.lang.String getVersionId() {
    java.lang.Object ref = versionId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      versionId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The version ID of the model.
   * </pre>
   *
   * <code>string version_id = 1;</code>
   *
   * @return The bytes for versionId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getVersionIdBytes() {
    java.lang.Object ref = versionId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      versionId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VERSION_ALIASES_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList versionAliases_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * User provided version aliases so that a model version can be referenced via
   * alias
   * </pre>
   *
   * <code>repeated string version_aliases = 2;</code>
   *
   * @return A list containing the versionAliases.
   */
  public com.google.protobuf.ProtocolStringList getVersionAliasesList() {
    return versionAliases_;
  }
  /**
   *
   *
   * <pre>
   * User provided version aliases so that a model version can be referenced via
   * alias
   * </pre>
   *
   * <code>repeated string version_aliases = 2;</code>
   *
   * @return The count of versionAliases.
   */
  public int getVersionAliasesCount() {
    return versionAliases_.size();
  }
  /**
   *
   *
   * <pre>
   * User provided version aliases so that a model version can be referenced via
   * alias
   * </pre>
   *
   * <code>repeated string version_aliases = 2;</code>
   *
   * @param index The index of the element to return.
   * @return The versionAliases at the given index.
   */
  public java.lang.String getVersionAliases(int index) {
    return versionAliases_.get(index);
  }
  /**
   *
   *
   * <pre>
   * User provided version aliases so that a model version can be referenced via
   * alias
   * </pre>
   *
   * <code>repeated string version_aliases = 2;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the versionAliases at the given index.
   */
  public com.google.protobuf.ByteString getVersionAliasesBytes(int index) {
    return versionAliases_.getByteString(index);
  }

  public static final int VERSION_DESCRIPTION_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object versionDescription_ = "";
  /**
   *
   *
   * <pre>
   * The description of this version.
   * </pre>
   *
   * <code>string version_description = 3;</code>
   *
   * @return The versionDescription.
   */
  @java.lang.Override
  public java.lang.String getVersionDescription() {
    java.lang.Object ref = versionDescription_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      versionDescription_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The description of this version.
   * </pre>
   *
   * <code>string version_description = 3;</code>
   *
   * @return The bytes for versionDescription.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getVersionDescriptionBytes() {
    java.lang.Object ref = versionDescription_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      versionDescription_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VERTEX_MODEL_SOURCE_INFO_FIELD_NUMBER = 4;
  private com.google.cloud.datacatalog.v1.VertexModelSourceInfo vertexModelSourceInfo_;
  /**
   *
   *
   * <pre>
   * Source of a Vertex model.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.VertexModelSourceInfo vertex_model_source_info = 4;</code>
   *
   * @return Whether the vertexModelSourceInfo field is set.
   */
  @java.lang.Override
  public boolean hasVertexModelSourceInfo() {
    return vertexModelSourceInfo_ != null;
  }
  /**
   *
   *
   * <pre>
   * Source of a Vertex model.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.VertexModelSourceInfo vertex_model_source_info = 4;</code>
   *
   * @return The vertexModelSourceInfo.
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.VertexModelSourceInfo getVertexModelSourceInfo() {
    return vertexModelSourceInfo_ == null
        ? com.google.cloud.datacatalog.v1.VertexModelSourceInfo.getDefaultInstance()
        : vertexModelSourceInfo_;
  }
  /**
   *
   *
   * <pre>
   * Source of a Vertex model.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.VertexModelSourceInfo vertex_model_source_info = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.VertexModelSourceInfoOrBuilder
      getVertexModelSourceInfoOrBuilder() {
    return vertexModelSourceInfo_ == null
        ? com.google.cloud.datacatalog.v1.VertexModelSourceInfo.getDefaultInstance()
        : vertexModelSourceInfo_;
  }

  public static final int CONTAINER_IMAGE_URI_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object containerImageUri_ = "";
  /**
   *
   *
   * <pre>
   * URI of the Docker image to be used as the custom container for serving
   * predictions.
   * </pre>
   *
   * <code>string container_image_uri = 5;</code>
   *
   * @return The containerImageUri.
   */
  @java.lang.Override
  public java.lang.String getContainerImageUri() {
    java.lang.Object ref = containerImageUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      containerImageUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * URI of the Docker image to be used as the custom container for serving
   * predictions.
   * </pre>
   *
   * <code>string container_image_uri = 5;</code>
   *
   * @return The bytes for containerImageUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getContainerImageUriBytes() {
    java.lang.Object ref = containerImageUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      containerImageUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(versionId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, versionId_);
    }
    for (int i = 0; i < versionAliases_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, versionAliases_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(versionDescription_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, versionDescription_);
    }
    if (vertexModelSourceInfo_ != null) {
      output.writeMessage(4, getVertexModelSourceInfo());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(containerImageUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, containerImageUri_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(versionId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, versionId_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < versionAliases_.size(); i++) {
        dataSize += computeStringSizeNoTag(versionAliases_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getVersionAliasesList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(versionDescription_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, versionDescription_);
    }
    if (vertexModelSourceInfo_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(4, getVertexModelSourceInfo());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(containerImageUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, containerImageUri_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datacatalog.v1.VertexModelSpec)) {
      return super.equals(obj);
    }
    com.google.cloud.datacatalog.v1.VertexModelSpec other =
        (com.google.cloud.datacatalog.v1.VertexModelSpec) obj;

    if (!getVersionId().equals(other.getVersionId())) return false;
    if (!getVersionAliasesList().equals(other.getVersionAliasesList())) return false;
    if (!getVersionDescription().equals(other.getVersionDescription())) return false;
    if (hasVertexModelSourceInfo() != other.hasVertexModelSourceInfo()) return false;
    if (hasVertexModelSourceInfo()) {
      if (!getVertexModelSourceInfo().equals(other.getVertexModelSourceInfo())) return false;
    }
    if (!getContainerImageUri().equals(other.getContainerImageUri())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + VERSION_ID_FIELD_NUMBER;
    hash = (53 * hash) + getVersionId().hashCode();
    if (getVersionAliasesCount() > 0) {
      hash = (37 * hash) + VERSION_ALIASES_FIELD_NUMBER;
      hash = (53 * hash) + getVersionAliasesList().hashCode();
    }
    hash = (37 * hash) + VERSION_DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getVersionDescription().hashCode();
    if (hasVertexModelSourceInfo()) {
      hash = (37 * hash) + VERTEX_MODEL_SOURCE_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getVertexModelSourceInfo().hashCode();
    }
    hash = (37 * hash) + CONTAINER_IMAGE_URI_FIELD_NUMBER;
    hash = (53 * hash) + getContainerImageUri().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datacatalog.v1.VertexModelSpec parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1.VertexModelSpec parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.VertexModelSpec parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1.VertexModelSpec parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.VertexModelSpec parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1.VertexModelSpec parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.VertexModelSpec parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1.VertexModelSpec parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.VertexModelSpec parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1.VertexModelSpec parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.VertexModelSpec parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1.VertexModelSpec parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.datacatalog.v1.VertexModelSpec prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Specification for vertex model resources.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datacatalog.v1.VertexModelSpec}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datacatalog.v1.VertexModelSpec)
      com.google.cloud.datacatalog.v1.VertexModelSpecOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datacatalog.v1.Datacatalog
          .internal_static_google_cloud_datacatalog_v1_VertexModelSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datacatalog.v1.Datacatalog
          .internal_static_google_cloud_datacatalog_v1_VertexModelSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datacatalog.v1.VertexModelSpec.class,
              com.google.cloud.datacatalog.v1.VertexModelSpec.Builder.class);
    }

    // Construct using com.google.cloud.datacatalog.v1.VertexModelSpec.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      versionId_ = "";
      versionAliases_ = com.google.protobuf.LazyStringArrayList.emptyList();
      versionDescription_ = "";
      vertexModelSourceInfo_ = null;
      if (vertexModelSourceInfoBuilder_ != null) {
        vertexModelSourceInfoBuilder_.dispose();
        vertexModelSourceInfoBuilder_ = null;
      }
      containerImageUri_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datacatalog.v1.Datacatalog
          .internal_static_google_cloud_datacatalog_v1_VertexModelSpec_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.VertexModelSpec getDefaultInstanceForType() {
      return com.google.cloud.datacatalog.v1.VertexModelSpec.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.VertexModelSpec build() {
      com.google.cloud.datacatalog.v1.VertexModelSpec result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.VertexModelSpec buildPartial() {
      com.google.cloud.datacatalog.v1.VertexModelSpec result =
          new com.google.cloud.datacatalog.v1.VertexModelSpec(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.datacatalog.v1.VertexModelSpec result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.versionId_ = versionId_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        versionAliases_.makeImmutable();
        result.versionAliases_ = versionAliases_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.versionDescription_ = versionDescription_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.vertexModelSourceInfo_ =
            vertexModelSourceInfoBuilder_ == null
                ? vertexModelSourceInfo_
                : vertexModelSourceInfoBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.containerImageUri_ = containerImageUri_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datacatalog.v1.VertexModelSpec) {
        return mergeFrom((com.google.cloud.datacatalog.v1.VertexModelSpec) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datacatalog.v1.VertexModelSpec other) {
      if (other == com.google.cloud.datacatalog.v1.VertexModelSpec.getDefaultInstance())
        return this;
      if (!other.getVersionId().isEmpty()) {
        versionId_ = other.versionId_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.versionAliases_.isEmpty()) {
        if (versionAliases_.isEmpty()) {
          versionAliases_ = other.versionAliases_;
          bitField0_ |= 0x00000002;
        } else {
          ensureVersionAliasesIsMutable();
          versionAliases_.addAll(other.versionAliases_);
        }
        onChanged();
      }
      if (!other.getVersionDescription().isEmpty()) {
        versionDescription_ = other.versionDescription_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasVertexModelSourceInfo()) {
        mergeVertexModelSourceInfo(other.getVertexModelSourceInfo());
      }
      if (!other.getContainerImageUri().isEmpty()) {
        containerImageUri_ = other.containerImageUri_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                versionId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureVersionAliasesIsMutable();
                versionAliases_.add(s);
                break;
              } // case 18
            case 26:
              {
                versionDescription_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getVertexModelSourceInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                containerImageUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object versionId_ = "";
    /**
     *
     *
     * <pre>
     * The version ID of the model.
     * </pre>
     *
     * <code>string version_id = 1;</code>
     *
     * @return The versionId.
     */
    public java.lang.String getVersionId() {
      java.lang.Object ref = versionId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        versionId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The version ID of the model.
     * </pre>
     *
     * <code>string version_id = 1;</code>
     *
     * @return The bytes for versionId.
     */
    public com.google.protobuf.ByteString getVersionIdBytes() {
      java.lang.Object ref = versionId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        versionId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The version ID of the model.
     * </pre>
     *
     * <code>string version_id = 1;</code>
     *
     * @param value The versionId to set.
     * @return This builder for chaining.
     */
    public Builder setVersionId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      versionId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The version ID of the model.
     * </pre>
     *
     * <code>string version_id = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVersionId() {
      versionId_ = getDefaultInstance().getVersionId();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The version ID of the model.
     * </pre>
     *
     * <code>string version_id = 1;</code>
     *
     * @param value The bytes for versionId to set.
     * @return This builder for chaining.
     */
    public Builder setVersionIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      versionId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList versionAliases_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureVersionAliasesIsMutable() {
      if (!versionAliases_.isModifiable()) {
        versionAliases_ = new com.google.protobuf.LazyStringArrayList(versionAliases_);
      }
      bitField0_ |= 0x00000002;
    }
    /**
     *
     *
     * <pre>
     * User provided version aliases so that a model version can be referenced via
     * alias
     * </pre>
     *
     * <code>repeated string version_aliases = 2;</code>
     *
     * @return A list containing the versionAliases.
     */
    public com.google.protobuf.ProtocolStringList getVersionAliasesList() {
      versionAliases_.makeImmutable();
      return versionAliases_;
    }
    /**
     *
     *
     * <pre>
     * User provided version aliases so that a model version can be referenced via
     * alias
     * </pre>
     *
     * <code>repeated string version_aliases = 2;</code>
     *
     * @return The count of versionAliases.
     */
    public int getVersionAliasesCount() {
      return versionAliases_.size();
    }
    /**
     *
     *
     * <pre>
     * User provided version aliases so that a model version can be referenced via
     * alias
     * </pre>
     *
     * <code>repeated string version_aliases = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The versionAliases at the given index.
     */
    public java.lang.String getVersionAliases(int index) {
      return versionAliases_.get(index);
    }
    /**
     *
     *
     * <pre>
     * User provided version aliases so that a model version can be referenced via
     * alias
     * </pre>
     *
     * <code>repeated string version_aliases = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the versionAliases at the given index.
     */
    public com.google.protobuf.ByteString getVersionAliasesBytes(int index) {
      return versionAliases_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * User provided version aliases so that a model version can be referenced via
     * alias
     * </pre>
     *
     * <code>repeated string version_aliases = 2;</code>
     *
     * @param index The index to set the value at.
     * @param value The versionAliases to set.
     * @return This builder for chaining.
     */
    public Builder setVersionAliases(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureVersionAliasesIsMutable();
      versionAliases_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User provided version aliases so that a model version can be referenced via
     * alias
     * </pre>
     *
     * <code>repeated string version_aliases = 2;</code>
     *
     * @param value The versionAliases to add.
     * @return This builder for chaining.
     */
    public Builder addVersionAliases(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureVersionAliasesIsMutable();
      versionAliases_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User provided version aliases so that a model version can be referenced via
     * alias
     * </pre>
     *
     * <code>repeated string version_aliases = 2;</code>
     *
     * @param values The versionAliases to add.
     * @return This builder for chaining.
     */
    public Builder addAllVersionAliases(java.lang.Iterable<java.lang.String> values) {
      ensureVersionAliasesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, versionAliases_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User provided version aliases so that a model version can be referenced via
     * alias
     * </pre>
     *
     * <code>repeated string version_aliases = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVersionAliases() {
      versionAliases_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * User provided version aliases so that a model version can be referenced via
     * alias
     * </pre>
     *
     * <code>repeated string version_aliases = 2;</code>
     *
     * @param value The bytes of the versionAliases to add.
     * @return This builder for chaining.
     */
    public Builder addVersionAliasesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureVersionAliasesIsMutable();
      versionAliases_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object versionDescription_ = "";
    /**
     *
     *
     * <pre>
     * The description of this version.
     * </pre>
     *
     * <code>string version_description = 3;</code>
     *
     * @return The versionDescription.
     */
    public java.lang.String getVersionDescription() {
      java.lang.Object ref = versionDescription_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        versionDescription_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The description of this version.
     * </pre>
     *
     * <code>string version_description = 3;</code>
     *
     * @return The bytes for versionDescription.
     */
    public com.google.protobuf.ByteString getVersionDescriptionBytes() {
      java.lang.Object ref = versionDescription_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        versionDescription_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The description of this version.
     * </pre>
     *
     * <code>string version_description = 3;</code>
     *
     * @param value The versionDescription to set.
     * @return This builder for chaining.
     */
    public Builder setVersionDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      versionDescription_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The description of this version.
     * </pre>
     *
     * <code>string version_description = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVersionDescription() {
      versionDescription_ = getDefaultInstance().getVersionDescription();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The description of this version.
     * </pre>
     *
     * <code>string version_description = 3;</code>
     *
     * @param value The bytes for versionDescription to set.
     * @return This builder for chaining.
     */
    public Builder setVersionDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      versionDescription_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.cloud.datacatalog.v1.VertexModelSourceInfo vertexModelSourceInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.VertexModelSourceInfo,
            com.google.cloud.datacatalog.v1.VertexModelSourceInfo.Builder,
            com.google.cloud.datacatalog.v1.VertexModelSourceInfoOrBuilder>
        vertexModelSourceInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Source of a Vertex model.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.VertexModelSourceInfo vertex_model_source_info = 4;</code>
     *
     * @return Whether the vertexModelSourceInfo field is set.
     */
    public boolean hasVertexModelSourceInfo() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Source of a Vertex model.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.VertexModelSourceInfo vertex_model_source_info = 4;</code>
     *
     * @return The vertexModelSourceInfo.
     */
    public com.google.cloud.datacatalog.v1.VertexModelSourceInfo getVertexModelSourceInfo() {
      if (vertexModelSourceInfoBuilder_ == null) {
        return vertexModelSourceInfo_ == null
            ? com.google.cloud.datacatalog.v1.VertexModelSourceInfo.getDefaultInstance()
            : vertexModelSourceInfo_;
      } else {
        return vertexModelSourceInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Source of a Vertex model.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.VertexModelSourceInfo vertex_model_source_info = 4;</code>
     */
    public Builder setVertexModelSourceInfo(
        com.google.cloud.datacatalog.v1.VertexModelSourceInfo value) {
      if (vertexModelSourceInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        vertexModelSourceInfo_ = value;
      } else {
        vertexModelSourceInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source of a Vertex model.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.VertexModelSourceInfo vertex_model_source_info = 4;</code>
     */
    public Builder setVertexModelSourceInfo(
        com.google.cloud.datacatalog.v1.VertexModelSourceInfo.Builder builderForValue) {
      if (vertexModelSourceInfoBuilder_ == null) {
        vertexModelSourceInfo_ = builderForValue.build();
      } else {
        vertexModelSourceInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source of a Vertex model.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.VertexModelSourceInfo vertex_model_source_info = 4;</code>
     */
    public Builder mergeVertexModelSourceInfo(
        com.google.cloud.datacatalog.v1.VertexModelSourceInfo value) {
      if (vertexModelSourceInfoBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && vertexModelSourceInfo_ != null
            && vertexModelSourceInfo_
                != com.google.cloud.datacatalog.v1.VertexModelSourceInfo.getDefaultInstance()) {
          getVertexModelSourceInfoBuilder().mergeFrom(value);
        } else {
          vertexModelSourceInfo_ = value;
        }
      } else {
        vertexModelSourceInfoBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source of a Vertex model.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.VertexModelSourceInfo vertex_model_source_info = 4;</code>
     */
    public Builder clearVertexModelSourceInfo() {
      bitField0_ = (bitField0_ & ~0x00000008);
      vertexModelSourceInfo_ = null;
      if (vertexModelSourceInfoBuilder_ != null) {
        vertexModelSourceInfoBuilder_.dispose();
        vertexModelSourceInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source of a Vertex model.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.VertexModelSourceInfo vertex_model_source_info = 4;</code>
     */
    public com.google.cloud.datacatalog.v1.VertexModelSourceInfo.Builder
        getVertexModelSourceInfoBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getVertexModelSourceInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Source of a Vertex model.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.VertexModelSourceInfo vertex_model_source_info = 4;</code>
     */
    public com.google.cloud.datacatalog.v1.VertexModelSourceInfoOrBuilder
        getVertexModelSourceInfoOrBuilder() {
      if (vertexModelSourceInfoBuilder_ != null) {
        return vertexModelSourceInfoBuilder_.getMessageOrBuilder();
      } else {
        return vertexModelSourceInfo_ == null
            ? com.google.cloud.datacatalog.v1.VertexModelSourceInfo.getDefaultInstance()
            : vertexModelSourceInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Source of a Vertex model.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.VertexModelSourceInfo vertex_model_source_info = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.VertexModelSourceInfo,
            com.google.cloud.datacatalog.v1.VertexModelSourceInfo.Builder,
            com.google.cloud.datacatalog.v1.VertexModelSourceInfoOrBuilder>
        getVertexModelSourceInfoFieldBuilder() {
      if (vertexModelSourceInfoBuilder_ == null) {
        vertexModelSourceInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datacatalog.v1.VertexModelSourceInfo,
                com.google.cloud.datacatalog.v1.VertexModelSourceInfo.Builder,
                com.google.cloud.datacatalog.v1.VertexModelSourceInfoOrBuilder>(
                getVertexModelSourceInfo(), getParentForChildren(), isClean());
        vertexModelSourceInfo_ = null;
      }
      return vertexModelSourceInfoBuilder_;
    }

    private java.lang.Object containerImageUri_ = "";
    /**
     *
     *
     * <pre>
     * URI of the Docker image to be used as the custom container for serving
     * predictions.
     * </pre>
     *
     * <code>string container_image_uri = 5;</code>
     *
     * @return The containerImageUri.
     */
    public java.lang.String getContainerImageUri() {
      java.lang.Object ref = containerImageUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        containerImageUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of the Docker image to be used as the custom container for serving
     * predictions.
     * </pre>
     *
     * <code>string container_image_uri = 5;</code>
     *
     * @return The bytes for containerImageUri.
     */
    public com.google.protobuf.ByteString getContainerImageUriBytes() {
      java.lang.Object ref = containerImageUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        containerImageUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URI of the Docker image to be used as the custom container for serving
     * predictions.
     * </pre>
     *
     * <code>string container_image_uri = 5;</code>
     *
     * @param value The containerImageUri to set.
     * @return This builder for chaining.
     */
    public Builder setContainerImageUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      containerImageUri_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of the Docker image to be used as the custom container for serving
     * predictions.
     * </pre>
     *
     * <code>string container_image_uri = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearContainerImageUri() {
      containerImageUri_ = getDefaultInstance().getContainerImageUri();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI of the Docker image to be used as the custom container for serving
     * predictions.
     * </pre>
     *
     * <code>string container_image_uri = 5;</code>
     *
     * @param value The bytes for containerImageUri to set.
     * @return This builder for chaining.
     */
    public Builder setContainerImageUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      containerImageUri_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datacatalog.v1.VertexModelSpec)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datacatalog.v1.VertexModelSpec)
  private static final com.google.cloud.datacatalog.v1.VertexModelSpec DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datacatalog.v1.VertexModelSpec();
  }

  public static com.google.cloud.datacatalog.v1.VertexModelSpec getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<VertexModelSpec> PARSER =
      new com.google.protobuf.AbstractParser<VertexModelSpec>() {
        @java.lang.Override
        public VertexModelSpec parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<VertexModelSpec> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<VertexModelSpec> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datacatalog.v1.VertexModelSpec getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
