/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datacatalog/v1/datacatalog.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.datacatalog.v1;

/**
 *
 *
 * <pre>
 * Request message for
 * [ReconcileTags][google.cloud.datacatalog.v1.DataCatalog.ReconcileTags].
 * </pre>
 *
 * Protobuf type {@code google.cloud.datacatalog.v1.ReconcileTagsRequest}
 */
public final class ReconcileTagsRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datacatalog.v1.ReconcileTagsRequest)
    ReconcileTagsRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ReconcileTagsRequest.newBuilder() to construct.
  private ReconcileTagsRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ReconcileTagsRequest() {
    parent_ = "";
    tagTemplate_ = "";
    tags_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ReconcileTagsRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datacatalog.v1.Datacatalog
        .internal_static_google_cloud_datacatalog_v1_ReconcileTagsRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datacatalog.v1.Datacatalog
        .internal_static_google_cloud_datacatalog_v1_ReconcileTagsRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datacatalog.v1.ReconcileTagsRequest.class,
            com.google.cloud.datacatalog.v1.ReconcileTagsRequest.Builder.class);
  }

  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. Name of [Entry][google.cloud.datacatalog.v1.Entry] to be tagged.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Name of [Entry][google.cloud.datacatalog.v1.Entry] to be tagged.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TAG_TEMPLATE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object tagTemplate_ = "";
  /**
   *
   *
   * <pre>
   * Required. The name of the tag template, which is used for reconciliation.
   * </pre>
   *
   * <code>
   * string tag_template = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The tagTemplate.
   */
  @java.lang.Override
  public java.lang.String getTagTemplate() {
    java.lang.Object ref = tagTemplate_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      tagTemplate_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the tag template, which is used for reconciliation.
   * </pre>
   *
   * <code>
   * string tag_template = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for tagTemplate.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTagTemplateBytes() {
    java.lang.Object ref = tagTemplate_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      tagTemplate_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FORCE_DELETE_MISSING_FIELD_NUMBER = 3;
  private boolean forceDeleteMissing_ = false;
  /**
   *
   *
   * <pre>
   * If set to `true`, deletes entry tags related to a tag template
   * not listed in the tags source from an entry. If set to `false`,
   * unlisted tags are retained.
   * </pre>
   *
   * <code>bool force_delete_missing = 3;</code>
   *
   * @return The forceDeleteMissing.
   */
  @java.lang.Override
  public boolean getForceDeleteMissing() {
    return forceDeleteMissing_;
  }

  public static final int TAGS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.datacatalog.v1.Tag> tags_;
  /**
   *
   *
   * <pre>
   * A list of tags to apply to an entry. A tag can specify a
   * tag template, which must be the template specified in the
   * `ReconcileTagsRequest`.
   * The sole entry and each of its columns must be mentioned at most once.
   * </pre>
   *
   * <code>repeated .google.cloud.datacatalog.v1.Tag tags = 4;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.datacatalog.v1.Tag> getTagsList() {
    return tags_;
  }
  /**
   *
   *
   * <pre>
   * A list of tags to apply to an entry. A tag can specify a
   * tag template, which must be the template specified in the
   * `ReconcileTagsRequest`.
   * The sole entry and each of its columns must be mentioned at most once.
   * </pre>
   *
   * <code>repeated .google.cloud.datacatalog.v1.Tag tags = 4;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.datacatalog.v1.TagOrBuilder>
      getTagsOrBuilderList() {
    return tags_;
  }
  /**
   *
   *
   * <pre>
   * A list of tags to apply to an entry. A tag can specify a
   * tag template, which must be the template specified in the
   * `ReconcileTagsRequest`.
   * The sole entry and each of its columns must be mentioned at most once.
   * </pre>
   *
   * <code>repeated .google.cloud.datacatalog.v1.Tag tags = 4;</code>
   */
  @java.lang.Override
  public int getTagsCount() {
    return tags_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of tags to apply to an entry. A tag can specify a
   * tag template, which must be the template specified in the
   * `ReconcileTagsRequest`.
   * The sole entry and each of its columns must be mentioned at most once.
   * </pre>
   *
   * <code>repeated .google.cloud.datacatalog.v1.Tag tags = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.Tag getTags(int index) {
    return tags_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A list of tags to apply to an entry. A tag can specify a
   * tag template, which must be the template specified in the
   * `ReconcileTagsRequest`.
   * The sole entry and each of its columns must be mentioned at most once.
   * </pre>
   *
   * <code>repeated .google.cloud.datacatalog.v1.Tag tags = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.TagOrBuilder getTagsOrBuilder(int index) {
    return tags_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tagTemplate_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, tagTemplate_);
    }
    if (forceDeleteMissing_ != false) {
      output.writeBool(3, forceDeleteMissing_);
    }
    for (int i = 0; i < tags_.size(); i++) {
      output.writeMessage(4, tags_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tagTemplate_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, tagTemplate_);
    }
    if (forceDeleteMissing_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, forceDeleteMissing_);
    }
    for (int i = 0; i < tags_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, tags_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datacatalog.v1.ReconcileTagsRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.datacatalog.v1.ReconcileTagsRequest other =
        (com.google.cloud.datacatalog.v1.ReconcileTagsRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getTagTemplate().equals(other.getTagTemplate())) return false;
    if (getForceDeleteMissing() != other.getForceDeleteMissing()) return false;
    if (!getTagsList().equals(other.getTagsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + TAG_TEMPLATE_FIELD_NUMBER;
    hash = (53 * hash) + getTagTemplate().hashCode();
    hash = (37 * hash) + FORCE_DELETE_MISSING_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getForceDeleteMissing());
    if (getTagsCount() > 0) {
      hash = (37 * hash) + TAGS_FIELD_NUMBER;
      hash = (53 * hash) + getTagsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datacatalog.v1.ReconcileTagsRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1.ReconcileTagsRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.ReconcileTagsRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1.ReconcileTagsRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.ReconcileTagsRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1.ReconcileTagsRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.ReconcileTagsRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1.ReconcileTagsRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.ReconcileTagsRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1.ReconcileTagsRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.ReconcileTagsRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1.ReconcileTagsRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.datacatalog.v1.ReconcileTagsRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for
   * [ReconcileTags][google.cloud.datacatalog.v1.DataCatalog.ReconcileTags].
   * </pre>
   *
   * Protobuf type {@code google.cloud.datacatalog.v1.ReconcileTagsRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datacatalog.v1.ReconcileTagsRequest)
      com.google.cloud.datacatalog.v1.ReconcileTagsRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datacatalog.v1.Datacatalog
          .internal_static_google_cloud_datacatalog_v1_ReconcileTagsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datacatalog.v1.Datacatalog
          .internal_static_google_cloud_datacatalog_v1_ReconcileTagsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datacatalog.v1.ReconcileTagsRequest.class,
              com.google.cloud.datacatalog.v1.ReconcileTagsRequest.Builder.class);
    }

    // Construct using com.google.cloud.datacatalog.v1.ReconcileTagsRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      tagTemplate_ = "";
      forceDeleteMissing_ = false;
      if (tagsBuilder_ == null) {
        tags_ = java.util.Collections.emptyList();
      } else {
        tags_ = null;
        tagsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datacatalog.v1.Datacatalog
          .internal_static_google_cloud_datacatalog_v1_ReconcileTagsRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.ReconcileTagsRequest getDefaultInstanceForType() {
      return com.google.cloud.datacatalog.v1.ReconcileTagsRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.ReconcileTagsRequest build() {
      com.google.cloud.datacatalog.v1.ReconcileTagsRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.ReconcileTagsRequest buildPartial() {
      com.google.cloud.datacatalog.v1.ReconcileTagsRequest result =
          new com.google.cloud.datacatalog.v1.ReconcileTagsRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.datacatalog.v1.ReconcileTagsRequest result) {
      if (tagsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          tags_ = java.util.Collections.unmodifiableList(tags_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.tags_ = tags_;
      } else {
        result.tags_ = tagsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.datacatalog.v1.ReconcileTagsRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.tagTemplate_ = tagTemplate_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.forceDeleteMissing_ = forceDeleteMissing_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datacatalog.v1.ReconcileTagsRequest) {
        return mergeFrom((com.google.cloud.datacatalog.v1.ReconcileTagsRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datacatalog.v1.ReconcileTagsRequest other) {
      if (other == com.google.cloud.datacatalog.v1.ReconcileTagsRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getTagTemplate().isEmpty()) {
        tagTemplate_ = other.tagTemplate_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.getForceDeleteMissing() != false) {
        setForceDeleteMissing(other.getForceDeleteMissing());
      }
      if (tagsBuilder_ == null) {
        if (!other.tags_.isEmpty()) {
          if (tags_.isEmpty()) {
            tags_ = other.tags_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureTagsIsMutable();
            tags_.addAll(other.tags_);
          }
          onChanged();
        }
      } else {
        if (!other.tags_.isEmpty()) {
          if (tagsBuilder_.isEmpty()) {
            tagsBuilder_.dispose();
            tagsBuilder_ = null;
            tags_ = other.tags_;
            bitField0_ = (bitField0_ & ~0x00000008);
            tagsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTagsFieldBuilder()
                    : null;
          } else {
            tagsBuilder_.addAllMessages(other.tags_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                tagTemplate_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                forceDeleteMissing_ = input.readBool();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                com.google.cloud.datacatalog.v1.Tag m =
                    input.readMessage(
                        com.google.cloud.datacatalog.v1.Tag.parser(), extensionRegistry);
                if (tagsBuilder_ == null) {
                  ensureTagsIsMutable();
                  tags_.add(m);
                } else {
                  tagsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. Name of [Entry][google.cloud.datacatalog.v1.Entry] to be tagged.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of [Entry][google.cloud.datacatalog.v1.Entry] to be tagged.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of [Entry][google.cloud.datacatalog.v1.Entry] to be tagged.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Name of [Entry][google.cloud.datacatalog.v1.Entry] to be tagged.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Name of [Entry][google.cloud.datacatalog.v1.Entry] to be tagged.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object tagTemplate_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the tag template, which is used for reconciliation.
     * </pre>
     *
     * <code>
     * string tag_template = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The tagTemplate.
     */
    public java.lang.String getTagTemplate() {
      java.lang.Object ref = tagTemplate_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        tagTemplate_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the tag template, which is used for reconciliation.
     * </pre>
     *
     * <code>
     * string tag_template = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for tagTemplate.
     */
    public com.google.protobuf.ByteString getTagTemplateBytes() {
      java.lang.Object ref = tagTemplate_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        tagTemplate_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the tag template, which is used for reconciliation.
     * </pre>
     *
     * <code>
     * string tag_template = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The tagTemplate to set.
     * @return This builder for chaining.
     */
    public Builder setTagTemplate(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      tagTemplate_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the tag template, which is used for reconciliation.
     * </pre>
     *
     * <code>
     * string tag_template = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTagTemplate() {
      tagTemplate_ = getDefaultInstance().getTagTemplate();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the tag template, which is used for reconciliation.
     * </pre>
     *
     * <code>
     * string tag_template = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for tagTemplate to set.
     * @return This builder for chaining.
     */
    public Builder setTagTemplateBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      tagTemplate_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private boolean forceDeleteMissing_;
    /**
     *
     *
     * <pre>
     * If set to `true`, deletes entry tags related to a tag template
     * not listed in the tags source from an entry. If set to `false`,
     * unlisted tags are retained.
     * </pre>
     *
     * <code>bool force_delete_missing = 3;</code>
     *
     * @return The forceDeleteMissing.
     */
    @java.lang.Override
    public boolean getForceDeleteMissing() {
      return forceDeleteMissing_;
    }
    /**
     *
     *
     * <pre>
     * If set to `true`, deletes entry tags related to a tag template
     * not listed in the tags source from an entry. If set to `false`,
     * unlisted tags are retained.
     * </pre>
     *
     * <code>bool force_delete_missing = 3;</code>
     *
     * @param value The forceDeleteMissing to set.
     * @return This builder for chaining.
     */
    public Builder setForceDeleteMissing(boolean value) {

      forceDeleteMissing_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set to `true`, deletes entry tags related to a tag template
     * not listed in the tags source from an entry. If set to `false`,
     * unlisted tags are retained.
     * </pre>
     *
     * <code>bool force_delete_missing = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearForceDeleteMissing() {
      bitField0_ = (bitField0_ & ~0x00000004);
      forceDeleteMissing_ = false;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.datacatalog.v1.Tag> tags_ =
        java.util.Collections.emptyList();

    private void ensureTagsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        tags_ = new java.util.ArrayList<com.google.cloud.datacatalog.v1.Tag>(tags_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.datacatalog.v1.Tag,
            com.google.cloud.datacatalog.v1.Tag.Builder,
            com.google.cloud.datacatalog.v1.TagOrBuilder>
        tagsBuilder_;

    /**
     *
     *
     * <pre>
     * A list of tags to apply to an entry. A tag can specify a
     * tag template, which must be the template specified in the
     * `ReconcileTagsRequest`.
     * The sole entry and each of its columns must be mentioned at most once.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.Tag tags = 4;</code>
     */
    public java.util.List<com.google.cloud.datacatalog.v1.Tag> getTagsList() {
      if (tagsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(tags_);
      } else {
        return tagsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of tags to apply to an entry. A tag can specify a
     * tag template, which must be the template specified in the
     * `ReconcileTagsRequest`.
     * The sole entry and each of its columns must be mentioned at most once.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.Tag tags = 4;</code>
     */
    public int getTagsCount() {
      if (tagsBuilder_ == null) {
        return tags_.size();
      } else {
        return tagsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A list of tags to apply to an entry. A tag can specify a
     * tag template, which must be the template specified in the
     * `ReconcileTagsRequest`.
     * The sole entry and each of its columns must be mentioned at most once.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.Tag tags = 4;</code>
     */
    public com.google.cloud.datacatalog.v1.Tag getTags(int index) {
      if (tagsBuilder_ == null) {
        return tags_.get(index);
      } else {
        return tagsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of tags to apply to an entry. A tag can specify a
     * tag template, which must be the template specified in the
     * `ReconcileTagsRequest`.
     * The sole entry and each of its columns must be mentioned at most once.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.Tag tags = 4;</code>
     */
    public Builder setTags(int index, com.google.cloud.datacatalog.v1.Tag value) {
      if (tagsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTagsIsMutable();
        tags_.set(index, value);
        onChanged();
      } else {
        tagsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of tags to apply to an entry. A tag can specify a
     * tag template, which must be the template specified in the
     * `ReconcileTagsRequest`.
     * The sole entry and each of its columns must be mentioned at most once.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.Tag tags = 4;</code>
     */
    public Builder setTags(int index, com.google.cloud.datacatalog.v1.Tag.Builder builderForValue) {
      if (tagsBuilder_ == null) {
        ensureTagsIsMutable();
        tags_.set(index, builderForValue.build());
        onChanged();
      } else {
        tagsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of tags to apply to an entry. A tag can specify a
     * tag template, which must be the template specified in the
     * `ReconcileTagsRequest`.
     * The sole entry and each of its columns must be mentioned at most once.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.Tag tags = 4;</code>
     */
    public Builder addTags(com.google.cloud.datacatalog.v1.Tag value) {
      if (tagsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTagsIsMutable();
        tags_.add(value);
        onChanged();
      } else {
        tagsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of tags to apply to an entry. A tag can specify a
     * tag template, which must be the template specified in the
     * `ReconcileTagsRequest`.
     * The sole entry and each of its columns must be mentioned at most once.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.Tag tags = 4;</code>
     */
    public Builder addTags(int index, com.google.cloud.datacatalog.v1.Tag value) {
      if (tagsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTagsIsMutable();
        tags_.add(index, value);
        onChanged();
      } else {
        tagsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of tags to apply to an entry. A tag can specify a
     * tag template, which must be the template specified in the
     * `ReconcileTagsRequest`.
     * The sole entry and each of its columns must be mentioned at most once.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.Tag tags = 4;</code>
     */
    public Builder addTags(com.google.cloud.datacatalog.v1.Tag.Builder builderForValue) {
      if (tagsBuilder_ == null) {
        ensureTagsIsMutable();
        tags_.add(builderForValue.build());
        onChanged();
      } else {
        tagsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of tags to apply to an entry. A tag can specify a
     * tag template, which must be the template specified in the
     * `ReconcileTagsRequest`.
     * The sole entry and each of its columns must be mentioned at most once.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.Tag tags = 4;</code>
     */
    public Builder addTags(int index, com.google.cloud.datacatalog.v1.Tag.Builder builderForValue) {
      if (tagsBuilder_ == null) {
        ensureTagsIsMutable();
        tags_.add(index, builderForValue.build());
        onChanged();
      } else {
        tagsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of tags to apply to an entry. A tag can specify a
     * tag template, which must be the template specified in the
     * `ReconcileTagsRequest`.
     * The sole entry and each of its columns must be mentioned at most once.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.Tag tags = 4;</code>
     */
    public Builder addAllTags(
        java.lang.Iterable<? extends com.google.cloud.datacatalog.v1.Tag> values) {
      if (tagsBuilder_ == null) {
        ensureTagsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, tags_);
        onChanged();
      } else {
        tagsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of tags to apply to an entry. A tag can specify a
     * tag template, which must be the template specified in the
     * `ReconcileTagsRequest`.
     * The sole entry and each of its columns must be mentioned at most once.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.Tag tags = 4;</code>
     */
    public Builder clearTags() {
      if (tagsBuilder_ == null) {
        tags_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        tagsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of tags to apply to an entry. A tag can specify a
     * tag template, which must be the template specified in the
     * `ReconcileTagsRequest`.
     * The sole entry and each of its columns must be mentioned at most once.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.Tag tags = 4;</code>
     */
    public Builder removeTags(int index) {
      if (tagsBuilder_ == null) {
        ensureTagsIsMutable();
        tags_.remove(index);
        onChanged();
      } else {
        tagsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of tags to apply to an entry. A tag can specify a
     * tag template, which must be the template specified in the
     * `ReconcileTagsRequest`.
     * The sole entry and each of its columns must be mentioned at most once.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.Tag tags = 4;</code>
     */
    public com.google.cloud.datacatalog.v1.Tag.Builder getTagsBuilder(int index) {
      return getTagsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A list of tags to apply to an entry. A tag can specify a
     * tag template, which must be the template specified in the
     * `ReconcileTagsRequest`.
     * The sole entry and each of its columns must be mentioned at most once.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.Tag tags = 4;</code>
     */
    public com.google.cloud.datacatalog.v1.TagOrBuilder getTagsOrBuilder(int index) {
      if (tagsBuilder_ == null) {
        return tags_.get(index);
      } else {
        return tagsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of tags to apply to an entry. A tag can specify a
     * tag template, which must be the template specified in the
     * `ReconcileTagsRequest`.
     * The sole entry and each of its columns must be mentioned at most once.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.Tag tags = 4;</code>
     */
    public java.util.List<? extends com.google.cloud.datacatalog.v1.TagOrBuilder>
        getTagsOrBuilderList() {
      if (tagsBuilder_ != null) {
        return tagsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(tags_);
      }
    }
    /**
     *
     *
     * <pre>
     * A list of tags to apply to an entry. A tag can specify a
     * tag template, which must be the template specified in the
     * `ReconcileTagsRequest`.
     * The sole entry and each of its columns must be mentioned at most once.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.Tag tags = 4;</code>
     */
    public com.google.cloud.datacatalog.v1.Tag.Builder addTagsBuilder() {
      return getTagsFieldBuilder()
          .addBuilder(com.google.cloud.datacatalog.v1.Tag.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of tags to apply to an entry. A tag can specify a
     * tag template, which must be the template specified in the
     * `ReconcileTagsRequest`.
     * The sole entry and each of its columns must be mentioned at most once.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.Tag tags = 4;</code>
     */
    public com.google.cloud.datacatalog.v1.Tag.Builder addTagsBuilder(int index) {
      return getTagsFieldBuilder()
          .addBuilder(index, com.google.cloud.datacatalog.v1.Tag.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A list of tags to apply to an entry. A tag can specify a
     * tag template, which must be the template specified in the
     * `ReconcileTagsRequest`.
     * The sole entry and each of its columns must be mentioned at most once.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.Tag tags = 4;</code>
     */
    public java.util.List<com.google.cloud.datacatalog.v1.Tag.Builder> getTagsBuilderList() {
      return getTagsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.datacatalog.v1.Tag,
            com.google.cloud.datacatalog.v1.Tag.Builder,
            com.google.cloud.datacatalog.v1.TagOrBuilder>
        getTagsFieldBuilder() {
      if (tagsBuilder_ == null) {
        tagsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.datacatalog.v1.Tag,
                com.google.cloud.datacatalog.v1.Tag.Builder,
                com.google.cloud.datacatalog.v1.TagOrBuilder>(
                tags_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
        tags_ = null;
      }
      return tagsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datacatalog.v1.ReconcileTagsRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datacatalog.v1.ReconcileTagsRequest)
  private static final com.google.cloud.datacatalog.v1.ReconcileTagsRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datacatalog.v1.ReconcileTagsRequest();
  }

  public static com.google.cloud.datacatalog.v1.ReconcileTagsRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ReconcileTagsRequest> PARSER =
      new com.google.protobuf.AbstractParser<ReconcileTagsRequest>() {
        @java.lang.Override
        public ReconcileTagsRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ReconcileTagsRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ReconcileTagsRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datacatalog.v1.ReconcileTagsRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
