/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datacatalog/v1/search.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.datacatalog.v1;

/**
 *
 *
 * <pre>
 * Result in the response to a search request.
 *
 * Each result captures details of one entry that matches the search.
 * </pre>
 *
 * Protobuf type {@code google.cloud.datacatalog.v1.SearchCatalogResult}
 */
public final class SearchCatalogResult extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datacatalog.v1.SearchCatalogResult)
    SearchCatalogResultOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SearchCatalogResult.newBuilder() to construct.
  private SearchCatalogResult(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SearchCatalogResult() {
    searchResultType_ = 0;
    searchResultSubtype_ = "";
    relativeResourceName_ = "";
    linkedResource_ = "";
    fullyQualifiedName_ = "";
    displayName_ = "";
    description_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SearchCatalogResult();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datacatalog.v1.Search
        .internal_static_google_cloud_datacatalog_v1_SearchCatalogResult_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datacatalog.v1.Search
        .internal_static_google_cloud_datacatalog_v1_SearchCatalogResult_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datacatalog.v1.SearchCatalogResult.class,
            com.google.cloud.datacatalog.v1.SearchCatalogResult.Builder.class);
  }

  private int bitField0_;
  private int systemCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object system_;

  public enum SystemCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    INTEGRATED_SYSTEM(8),
    USER_SPECIFIED_SYSTEM(9),
    SYSTEM_NOT_SET(0);
    private final int value;

    private SystemCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SystemCase valueOf(int value) {
      return forNumber(value);
    }

    public static SystemCase forNumber(int value) {
      switch (value) {
        case 8:
          return INTEGRATED_SYSTEM;
        case 9:
          return USER_SPECIFIED_SYSTEM;
        case 0:
          return SYSTEM_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SystemCase getSystemCase() {
    return SystemCase.forNumber(systemCase_);
  }

  public static final int SEARCH_RESULT_TYPE_FIELD_NUMBER = 1;
  private int searchResultType_ = 0;
  /**
   *
   *
   * <pre>
   * Type of the search result.
   *
   * You can use this field to determine which get method to call to fetch the
   * full resource.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.SearchResultType search_result_type = 1;</code>
   *
   * @return The enum numeric value on the wire for searchResultType.
   */
  @java.lang.Override
  public int getSearchResultTypeValue() {
    return searchResultType_;
  }
  /**
   *
   *
   * <pre>
   * Type of the search result.
   *
   * You can use this field to determine which get method to call to fetch the
   * full resource.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.SearchResultType search_result_type = 1;</code>
   *
   * @return The searchResultType.
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.SearchResultType getSearchResultType() {
    com.google.cloud.datacatalog.v1.SearchResultType result =
        com.google.cloud.datacatalog.v1.SearchResultType.forNumber(searchResultType_);
    return result == null ? com.google.cloud.datacatalog.v1.SearchResultType.UNRECOGNIZED : result;
  }

  public static final int SEARCH_RESULT_SUBTYPE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object searchResultSubtype_ = "";
  /**
   *
   *
   * <pre>
   * Sub-type of the search result.
   *
   * A dot-delimited full type of the resource. The same type you
   * specify in the `type` search predicate.
   *
   * Examples: `entry.table`, `entry.dataStream`, `tagTemplate`.
   * </pre>
   *
   * <code>string search_result_subtype = 2;</code>
   *
   * @return The searchResultSubtype.
   */
  @java.lang.Override
  public java.lang.String getSearchResultSubtype() {
    java.lang.Object ref = searchResultSubtype_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      searchResultSubtype_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Sub-type of the search result.
   *
   * A dot-delimited full type of the resource. The same type you
   * specify in the `type` search predicate.
   *
   * Examples: `entry.table`, `entry.dataStream`, `tagTemplate`.
   * </pre>
   *
   * <code>string search_result_subtype = 2;</code>
   *
   * @return The bytes for searchResultSubtype.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSearchResultSubtypeBytes() {
    java.lang.Object ref = searchResultSubtype_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      searchResultSubtype_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RELATIVE_RESOURCE_NAME_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object relativeResourceName_ = "";
  /**
   *
   *
   * <pre>
   * The relative name of the resource in URL format.
   *
   * Examples:
   *
   *  * `projects/{PROJECT_ID}/locations/{LOCATION_ID}/entryGroups/{ENTRY_GROUP_ID}/entries/{ENTRY_ID}`
   *  * `projects/{PROJECT_ID}/tagTemplates/{TAG_TEMPLATE_ID}`
   * </pre>
   *
   * <code>string relative_resource_name = 3;</code>
   *
   * @return The relativeResourceName.
   */
  @java.lang.Override
  public java.lang.String getRelativeResourceName() {
    java.lang.Object ref = relativeResourceName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      relativeResourceName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The relative name of the resource in URL format.
   *
   * Examples:
   *
   *  * `projects/{PROJECT_ID}/locations/{LOCATION_ID}/entryGroups/{ENTRY_GROUP_ID}/entries/{ENTRY_ID}`
   *  * `projects/{PROJECT_ID}/tagTemplates/{TAG_TEMPLATE_ID}`
   * </pre>
   *
   * <code>string relative_resource_name = 3;</code>
   *
   * @return The bytes for relativeResourceName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRelativeResourceNameBytes() {
    java.lang.Object ref = relativeResourceName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      relativeResourceName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LINKED_RESOURCE_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object linkedResource_ = "";
  /**
   *
   *
   * <pre>
   * The full name of the Google Cloud resource the entry belongs to.
   *
   * For more information, see [Full Resource Name]
   * (/apis/design/resource_names#full_resource_name).
   *
   * Example:
   *
   * `//bigquery.googleapis.com/projects/PROJECT_ID/datasets/DATASET_ID/tables/TABLE_ID`
   * </pre>
   *
   * <code>string linked_resource = 4;</code>
   *
   * @return The linkedResource.
   */
  @java.lang.Override
  public java.lang.String getLinkedResource() {
    java.lang.Object ref = linkedResource_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      linkedResource_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The full name of the Google Cloud resource the entry belongs to.
   *
   * For more information, see [Full Resource Name]
   * (/apis/design/resource_names#full_resource_name).
   *
   * Example:
   *
   * `//bigquery.googleapis.com/projects/PROJECT_ID/datasets/DATASET_ID/tables/TABLE_ID`
   * </pre>
   *
   * <code>string linked_resource = 4;</code>
   *
   * @return The bytes for linkedResource.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLinkedResourceBytes() {
    java.lang.Object ref = linkedResource_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      linkedResource_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MODIFY_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp modifyTime_;
  /**
   *
   *
   * <pre>
   * The last modification timestamp of the entry in the source system.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp modify_time = 7;</code>
   *
   * @return Whether the modifyTime field is set.
   */
  @java.lang.Override
  public boolean hasModifyTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The last modification timestamp of the entry in the source system.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp modify_time = 7;</code>
   *
   * @return The modifyTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getModifyTime() {
    return modifyTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : modifyTime_;
  }
  /**
   *
   *
   * <pre>
   * The last modification timestamp of the entry in the source system.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp modify_time = 7;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getModifyTimeOrBuilder() {
    return modifyTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : modifyTime_;
  }

  public static final int INTEGRATED_SYSTEM_FIELD_NUMBER = 8;
  /**
   *
   *
   * <pre>
   * Output only. The source system that Data Catalog automatically integrates
   * with, such as BigQuery, Cloud Pub/Sub, or Dataproc Metastore.
   * </pre>
   *
   * <code>
   * .google.cloud.datacatalog.v1.IntegratedSystem integrated_system = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the integratedSystem field is set.
   */
  public boolean hasIntegratedSystem() {
    return systemCase_ == 8;
  }
  /**
   *
   *
   * <pre>
   * Output only. The source system that Data Catalog automatically integrates
   * with, such as BigQuery, Cloud Pub/Sub, or Dataproc Metastore.
   * </pre>
   *
   * <code>
   * .google.cloud.datacatalog.v1.IntegratedSystem integrated_system = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for integratedSystem.
   */
  public int getIntegratedSystemValue() {
    if (systemCase_ == 8) {
      return (java.lang.Integer) system_;
    }
    return 0;
  }
  /**
   *
   *
   * <pre>
   * Output only. The source system that Data Catalog automatically integrates
   * with, such as BigQuery, Cloud Pub/Sub, or Dataproc Metastore.
   * </pre>
   *
   * <code>
   * .google.cloud.datacatalog.v1.IntegratedSystem integrated_system = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The integratedSystem.
   */
  public com.google.cloud.datacatalog.v1.IntegratedSystem getIntegratedSystem() {
    if (systemCase_ == 8) {
      com.google.cloud.datacatalog.v1.IntegratedSystem result =
          com.google.cloud.datacatalog.v1.IntegratedSystem.forNumber((java.lang.Integer) system_);
      return result == null
          ? com.google.cloud.datacatalog.v1.IntegratedSystem.UNRECOGNIZED
          : result;
    }
    return com.google.cloud.datacatalog.v1.IntegratedSystem.INTEGRATED_SYSTEM_UNSPECIFIED;
  }

  public static final int USER_SPECIFIED_SYSTEM_FIELD_NUMBER = 9;
  /**
   *
   *
   * <pre>
   * Custom source system that you can manually integrate Data Catalog with.
   * </pre>
   *
   * <code>string user_specified_system = 9;</code>
   *
   * @return Whether the userSpecifiedSystem field is set.
   */
  public boolean hasUserSpecifiedSystem() {
    return systemCase_ == 9;
  }
  /**
   *
   *
   * <pre>
   * Custom source system that you can manually integrate Data Catalog with.
   * </pre>
   *
   * <code>string user_specified_system = 9;</code>
   *
   * @return The userSpecifiedSystem.
   */
  public java.lang.String getUserSpecifiedSystem() {
    java.lang.Object ref = "";
    if (systemCase_ == 9) {
      ref = system_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (systemCase_ == 9) {
        system_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Custom source system that you can manually integrate Data Catalog with.
   * </pre>
   *
   * <code>string user_specified_system = 9;</code>
   *
   * @return The bytes for userSpecifiedSystem.
   */
  public com.google.protobuf.ByteString getUserSpecifiedSystemBytes() {
    java.lang.Object ref = "";
    if (systemCase_ == 9) {
      ref = system_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (systemCase_ == 9) {
        system_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FULLY_QUALIFIED_NAME_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object fullyQualifiedName_ = "";
  /**
   *
   *
   * <pre>
   * Fully qualified name (FQN) of the resource.
   *
   * FQNs take two forms:
   *
   * * For non-regionalized resources:
   *
   *   `{SYSTEM}:{PROJECT}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}`
   *
   * * For regionalized resources:
   *
   *   `{SYSTEM}:{PROJECT}.{LOCATION_ID}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}`
   *
   * Example for a DPMS table:
   *
   * `dataproc_metastore:PROJECT_ID.LOCATION_ID.INSTANCE_ID.DATABASE_ID.TABLE_ID`
   * </pre>
   *
   * <code>string fully_qualified_name = 10;</code>
   *
   * @return The fullyQualifiedName.
   */
  @java.lang.Override
  public java.lang.String getFullyQualifiedName() {
    java.lang.Object ref = fullyQualifiedName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      fullyQualifiedName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Fully qualified name (FQN) of the resource.
   *
   * FQNs take two forms:
   *
   * * For non-regionalized resources:
   *
   *   `{SYSTEM}:{PROJECT}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}`
   *
   * * For regionalized resources:
   *
   *   `{SYSTEM}:{PROJECT}.{LOCATION_ID}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}`
   *
   * Example for a DPMS table:
   *
   * `dataproc_metastore:PROJECT_ID.LOCATION_ID.INSTANCE_ID.DATABASE_ID.TABLE_ID`
   * </pre>
   *
   * <code>string fully_qualified_name = 10;</code>
   *
   * @return The bytes for fullyQualifiedName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFullyQualifiedNameBytes() {
    java.lang.Object ref = fullyQualifiedName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      fullyQualifiedName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * The display name of the result.
   * </pre>
   *
   * <code>string display_name = 12;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The display name of the result.
   * </pre>
   *
   * <code>string display_name = 12;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Entry description that can consist of several sentences or paragraphs that
   * describe entry contents.
   * </pre>
   *
   * <code>string description = 13;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Entry description that can consist of several sentences or paragraphs that
   * describe entry contents.
   * </pre>
   *
   * <code>string description = 13;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (searchResultType_
        != com.google.cloud.datacatalog.v1.SearchResultType.SEARCH_RESULT_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(1, searchResultType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(searchResultSubtype_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, searchResultSubtype_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(relativeResourceName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, relativeResourceName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(linkedResource_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, linkedResource_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(7, getModifyTime());
    }
    if (systemCase_ == 8) {
      output.writeEnum(8, ((java.lang.Integer) system_));
    }
    if (systemCase_ == 9) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, system_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fullyQualifiedName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, fullyQualifiedName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, description_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (searchResultType_
        != com.google.cloud.datacatalog.v1.SearchResultType.SEARCH_RESULT_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, searchResultType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(searchResultSubtype_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, searchResultSubtype_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(relativeResourceName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, relativeResourceName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(linkedResource_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, linkedResource_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getModifyTime());
    }
    if (systemCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeEnumSize(8, ((java.lang.Integer) system_));
    }
    if (systemCase_ == 9) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, system_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fullyQualifiedName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, fullyQualifiedName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(13, description_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datacatalog.v1.SearchCatalogResult)) {
      return super.equals(obj);
    }
    com.google.cloud.datacatalog.v1.SearchCatalogResult other =
        (com.google.cloud.datacatalog.v1.SearchCatalogResult) obj;

    if (searchResultType_ != other.searchResultType_) return false;
    if (!getSearchResultSubtype().equals(other.getSearchResultSubtype())) return false;
    if (!getRelativeResourceName().equals(other.getRelativeResourceName())) return false;
    if (!getLinkedResource().equals(other.getLinkedResource())) return false;
    if (hasModifyTime() != other.hasModifyTime()) return false;
    if (hasModifyTime()) {
      if (!getModifyTime().equals(other.getModifyTime())) return false;
    }
    if (!getFullyQualifiedName().equals(other.getFullyQualifiedName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getSystemCase().equals(other.getSystemCase())) return false;
    switch (systemCase_) {
      case 8:
        if (getIntegratedSystemValue() != other.getIntegratedSystemValue()) return false;
        break;
      case 9:
        if (!getUserSpecifiedSystem().equals(other.getUserSpecifiedSystem())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SEARCH_RESULT_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + searchResultType_;
    hash = (37 * hash) + SEARCH_RESULT_SUBTYPE_FIELD_NUMBER;
    hash = (53 * hash) + getSearchResultSubtype().hashCode();
    hash = (37 * hash) + RELATIVE_RESOURCE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getRelativeResourceName().hashCode();
    hash = (37 * hash) + LINKED_RESOURCE_FIELD_NUMBER;
    hash = (53 * hash) + getLinkedResource().hashCode();
    if (hasModifyTime()) {
      hash = (37 * hash) + MODIFY_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getModifyTime().hashCode();
    }
    hash = (37 * hash) + FULLY_QUALIFIED_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getFullyQualifiedName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    switch (systemCase_) {
      case 8:
        hash = (37 * hash) + INTEGRATED_SYSTEM_FIELD_NUMBER;
        hash = (53 * hash) + getIntegratedSystemValue();
        break;
      case 9:
        hash = (37 * hash) + USER_SPECIFIED_SYSTEM_FIELD_NUMBER;
        hash = (53 * hash) + getUserSpecifiedSystem().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datacatalog.v1.SearchCatalogResult parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1.SearchCatalogResult parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.SearchCatalogResult parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1.SearchCatalogResult parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.SearchCatalogResult parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1.SearchCatalogResult parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.SearchCatalogResult parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1.SearchCatalogResult parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.SearchCatalogResult parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1.SearchCatalogResult parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.SearchCatalogResult parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1.SearchCatalogResult parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.datacatalog.v1.SearchCatalogResult prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Result in the response to a search request.
   *
   * Each result captures details of one entry that matches the search.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datacatalog.v1.SearchCatalogResult}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datacatalog.v1.SearchCatalogResult)
      com.google.cloud.datacatalog.v1.SearchCatalogResultOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datacatalog.v1.Search
          .internal_static_google_cloud_datacatalog_v1_SearchCatalogResult_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datacatalog.v1.Search
          .internal_static_google_cloud_datacatalog_v1_SearchCatalogResult_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datacatalog.v1.SearchCatalogResult.class,
              com.google.cloud.datacatalog.v1.SearchCatalogResult.Builder.class);
    }

    // Construct using com.google.cloud.datacatalog.v1.SearchCatalogResult.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getModifyTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      searchResultType_ = 0;
      searchResultSubtype_ = "";
      relativeResourceName_ = "";
      linkedResource_ = "";
      modifyTime_ = null;
      if (modifyTimeBuilder_ != null) {
        modifyTimeBuilder_.dispose();
        modifyTimeBuilder_ = null;
      }
      fullyQualifiedName_ = "";
      displayName_ = "";
      description_ = "";
      systemCase_ = 0;
      system_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datacatalog.v1.Search
          .internal_static_google_cloud_datacatalog_v1_SearchCatalogResult_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.SearchCatalogResult getDefaultInstanceForType() {
      return com.google.cloud.datacatalog.v1.SearchCatalogResult.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.SearchCatalogResult build() {
      com.google.cloud.datacatalog.v1.SearchCatalogResult result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.SearchCatalogResult buildPartial() {
      com.google.cloud.datacatalog.v1.SearchCatalogResult result =
          new com.google.cloud.datacatalog.v1.SearchCatalogResult(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.datacatalog.v1.SearchCatalogResult result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.searchResultType_ = searchResultType_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.searchResultSubtype_ = searchResultSubtype_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.relativeResourceName_ = relativeResourceName_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.linkedResource_ = linkedResource_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.modifyTime_ = modifyTimeBuilder_ == null ? modifyTime_ : modifyTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.fullyQualifiedName_ = fullyQualifiedName_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.description_ = description_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.datacatalog.v1.SearchCatalogResult result) {
      result.systemCase_ = systemCase_;
      result.system_ = this.system_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datacatalog.v1.SearchCatalogResult) {
        return mergeFrom((com.google.cloud.datacatalog.v1.SearchCatalogResult) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datacatalog.v1.SearchCatalogResult other) {
      if (other == com.google.cloud.datacatalog.v1.SearchCatalogResult.getDefaultInstance())
        return this;
      if (other.searchResultType_ != 0) {
        setSearchResultTypeValue(other.getSearchResultTypeValue());
      }
      if (!other.getSearchResultSubtype().isEmpty()) {
        searchResultSubtype_ = other.searchResultSubtype_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getRelativeResourceName().isEmpty()) {
        relativeResourceName_ = other.relativeResourceName_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getLinkedResource().isEmpty()) {
        linkedResource_ = other.linkedResource_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasModifyTime()) {
        mergeModifyTime(other.getModifyTime());
      }
      if (!other.getFullyQualifiedName().isEmpty()) {
        fullyQualifiedName_ = other.fullyQualifiedName_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      switch (other.getSystemCase()) {
        case INTEGRATED_SYSTEM:
          {
            setIntegratedSystemValue(other.getIntegratedSystemValue());
            break;
          }
        case USER_SPECIFIED_SYSTEM:
          {
            systemCase_ = 9;
            system_ = other.system_;
            onChanged();
            break;
          }
        case SYSTEM_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                searchResultType_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                searchResultSubtype_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                relativeResourceName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                linkedResource_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 58:
              {
                input.readMessage(getModifyTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 58
            case 64:
              {
                int rawValue = input.readEnum();
                systemCase_ = 8;
                system_ = rawValue;
                break;
              } // case 64
            case 74:
              {
                java.lang.String s = input.readStringRequireUtf8();
                systemCase_ = 9;
                system_ = s;
                break;
              } // case 74
            case 82:
              {
                fullyQualifiedName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 82
            case 98:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 98
            case 106:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 106
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int systemCase_ = 0;
    private java.lang.Object system_;

    public SystemCase getSystemCase() {
      return SystemCase.forNumber(systemCase_);
    }

    public Builder clearSystem() {
      systemCase_ = 0;
      system_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private int searchResultType_ = 0;
    /**
     *
     *
     * <pre>
     * Type of the search result.
     *
     * You can use this field to determine which get method to call to fetch the
     * full resource.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.SearchResultType search_result_type = 1;</code>
     *
     * @return The enum numeric value on the wire for searchResultType.
     */
    @java.lang.Override
    public int getSearchResultTypeValue() {
      return searchResultType_;
    }
    /**
     *
     *
     * <pre>
     * Type of the search result.
     *
     * You can use this field to determine which get method to call to fetch the
     * full resource.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.SearchResultType search_result_type = 1;</code>
     *
     * @param value The enum numeric value on the wire for searchResultType to set.
     * @return This builder for chaining.
     */
    public Builder setSearchResultTypeValue(int value) {
      searchResultType_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of the search result.
     *
     * You can use this field to determine which get method to call to fetch the
     * full resource.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.SearchResultType search_result_type = 1;</code>
     *
     * @return The searchResultType.
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1.SearchResultType getSearchResultType() {
      com.google.cloud.datacatalog.v1.SearchResultType result =
          com.google.cloud.datacatalog.v1.SearchResultType.forNumber(searchResultType_);
      return result == null
          ? com.google.cloud.datacatalog.v1.SearchResultType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Type of the search result.
     *
     * You can use this field to determine which get method to call to fetch the
     * full resource.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.SearchResultType search_result_type = 1;</code>
     *
     * @param value The searchResultType to set.
     * @return This builder for chaining.
     */
    public Builder setSearchResultType(com.google.cloud.datacatalog.v1.SearchResultType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      searchResultType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of the search result.
     *
     * You can use this field to determine which get method to call to fetch the
     * full resource.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.SearchResultType search_result_type = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSearchResultType() {
      bitField0_ = (bitField0_ & ~0x00000001);
      searchResultType_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object searchResultSubtype_ = "";
    /**
     *
     *
     * <pre>
     * Sub-type of the search result.
     *
     * A dot-delimited full type of the resource. The same type you
     * specify in the `type` search predicate.
     *
     * Examples: `entry.table`, `entry.dataStream`, `tagTemplate`.
     * </pre>
     *
     * <code>string search_result_subtype = 2;</code>
     *
     * @return The searchResultSubtype.
     */
    public java.lang.String getSearchResultSubtype() {
      java.lang.Object ref = searchResultSubtype_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        searchResultSubtype_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Sub-type of the search result.
     *
     * A dot-delimited full type of the resource. The same type you
     * specify in the `type` search predicate.
     *
     * Examples: `entry.table`, `entry.dataStream`, `tagTemplate`.
     * </pre>
     *
     * <code>string search_result_subtype = 2;</code>
     *
     * @return The bytes for searchResultSubtype.
     */
    public com.google.protobuf.ByteString getSearchResultSubtypeBytes() {
      java.lang.Object ref = searchResultSubtype_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        searchResultSubtype_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Sub-type of the search result.
     *
     * A dot-delimited full type of the resource. The same type you
     * specify in the `type` search predicate.
     *
     * Examples: `entry.table`, `entry.dataStream`, `tagTemplate`.
     * </pre>
     *
     * <code>string search_result_subtype = 2;</code>
     *
     * @param value The searchResultSubtype to set.
     * @return This builder for chaining.
     */
    public Builder setSearchResultSubtype(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      searchResultSubtype_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sub-type of the search result.
     *
     * A dot-delimited full type of the resource. The same type you
     * specify in the `type` search predicate.
     *
     * Examples: `entry.table`, `entry.dataStream`, `tagTemplate`.
     * </pre>
     *
     * <code>string search_result_subtype = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSearchResultSubtype() {
      searchResultSubtype_ = getDefaultInstance().getSearchResultSubtype();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sub-type of the search result.
     *
     * A dot-delimited full type of the resource. The same type you
     * specify in the `type` search predicate.
     *
     * Examples: `entry.table`, `entry.dataStream`, `tagTemplate`.
     * </pre>
     *
     * <code>string search_result_subtype = 2;</code>
     *
     * @param value The bytes for searchResultSubtype to set.
     * @return This builder for chaining.
     */
    public Builder setSearchResultSubtypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      searchResultSubtype_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object relativeResourceName_ = "";
    /**
     *
     *
     * <pre>
     * The relative name of the resource in URL format.
     *
     * Examples:
     *
     *  * `projects/{PROJECT_ID}/locations/{LOCATION_ID}/entryGroups/{ENTRY_GROUP_ID}/entries/{ENTRY_ID}`
     *  * `projects/{PROJECT_ID}/tagTemplates/{TAG_TEMPLATE_ID}`
     * </pre>
     *
     * <code>string relative_resource_name = 3;</code>
     *
     * @return The relativeResourceName.
     */
    public java.lang.String getRelativeResourceName() {
      java.lang.Object ref = relativeResourceName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        relativeResourceName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The relative name of the resource in URL format.
     *
     * Examples:
     *
     *  * `projects/{PROJECT_ID}/locations/{LOCATION_ID}/entryGroups/{ENTRY_GROUP_ID}/entries/{ENTRY_ID}`
     *  * `projects/{PROJECT_ID}/tagTemplates/{TAG_TEMPLATE_ID}`
     * </pre>
     *
     * <code>string relative_resource_name = 3;</code>
     *
     * @return The bytes for relativeResourceName.
     */
    public com.google.protobuf.ByteString getRelativeResourceNameBytes() {
      java.lang.Object ref = relativeResourceName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        relativeResourceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The relative name of the resource in URL format.
     *
     * Examples:
     *
     *  * `projects/{PROJECT_ID}/locations/{LOCATION_ID}/entryGroups/{ENTRY_GROUP_ID}/entries/{ENTRY_ID}`
     *  * `projects/{PROJECT_ID}/tagTemplates/{TAG_TEMPLATE_ID}`
     * </pre>
     *
     * <code>string relative_resource_name = 3;</code>
     *
     * @param value The relativeResourceName to set.
     * @return This builder for chaining.
     */
    public Builder setRelativeResourceName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      relativeResourceName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The relative name of the resource in URL format.
     *
     * Examples:
     *
     *  * `projects/{PROJECT_ID}/locations/{LOCATION_ID}/entryGroups/{ENTRY_GROUP_ID}/entries/{ENTRY_ID}`
     *  * `projects/{PROJECT_ID}/tagTemplates/{TAG_TEMPLATE_ID}`
     * </pre>
     *
     * <code>string relative_resource_name = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRelativeResourceName() {
      relativeResourceName_ = getDefaultInstance().getRelativeResourceName();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The relative name of the resource in URL format.
     *
     * Examples:
     *
     *  * `projects/{PROJECT_ID}/locations/{LOCATION_ID}/entryGroups/{ENTRY_GROUP_ID}/entries/{ENTRY_ID}`
     *  * `projects/{PROJECT_ID}/tagTemplates/{TAG_TEMPLATE_ID}`
     * </pre>
     *
     * <code>string relative_resource_name = 3;</code>
     *
     * @param value The bytes for relativeResourceName to set.
     * @return This builder for chaining.
     */
    public Builder setRelativeResourceNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      relativeResourceName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object linkedResource_ = "";
    /**
     *
     *
     * <pre>
     * The full name of the Google Cloud resource the entry belongs to.
     *
     * For more information, see [Full Resource Name]
     * (/apis/design/resource_names#full_resource_name).
     *
     * Example:
     *
     * `//bigquery.googleapis.com/projects/PROJECT_ID/datasets/DATASET_ID/tables/TABLE_ID`
     * </pre>
     *
     * <code>string linked_resource = 4;</code>
     *
     * @return The linkedResource.
     */
    public java.lang.String getLinkedResource() {
      java.lang.Object ref = linkedResource_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        linkedResource_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The full name of the Google Cloud resource the entry belongs to.
     *
     * For more information, see [Full Resource Name]
     * (/apis/design/resource_names#full_resource_name).
     *
     * Example:
     *
     * `//bigquery.googleapis.com/projects/PROJECT_ID/datasets/DATASET_ID/tables/TABLE_ID`
     * </pre>
     *
     * <code>string linked_resource = 4;</code>
     *
     * @return The bytes for linkedResource.
     */
    public com.google.protobuf.ByteString getLinkedResourceBytes() {
      java.lang.Object ref = linkedResource_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        linkedResource_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The full name of the Google Cloud resource the entry belongs to.
     *
     * For more information, see [Full Resource Name]
     * (/apis/design/resource_names#full_resource_name).
     *
     * Example:
     *
     * `//bigquery.googleapis.com/projects/PROJECT_ID/datasets/DATASET_ID/tables/TABLE_ID`
     * </pre>
     *
     * <code>string linked_resource = 4;</code>
     *
     * @param value The linkedResource to set.
     * @return This builder for chaining.
     */
    public Builder setLinkedResource(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      linkedResource_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The full name of the Google Cloud resource the entry belongs to.
     *
     * For more information, see [Full Resource Name]
     * (/apis/design/resource_names#full_resource_name).
     *
     * Example:
     *
     * `//bigquery.googleapis.com/projects/PROJECT_ID/datasets/DATASET_ID/tables/TABLE_ID`
     * </pre>
     *
     * <code>string linked_resource = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLinkedResource() {
      linkedResource_ = getDefaultInstance().getLinkedResource();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The full name of the Google Cloud resource the entry belongs to.
     *
     * For more information, see [Full Resource Name]
     * (/apis/design/resource_names#full_resource_name).
     *
     * Example:
     *
     * `//bigquery.googleapis.com/projects/PROJECT_ID/datasets/DATASET_ID/tables/TABLE_ID`
     * </pre>
     *
     * <code>string linked_resource = 4;</code>
     *
     * @param value The bytes for linkedResource to set.
     * @return This builder for chaining.
     */
    public Builder setLinkedResourceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      linkedResource_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp modifyTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        modifyTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The last modification timestamp of the entry in the source system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp modify_time = 7;</code>
     *
     * @return Whether the modifyTime field is set.
     */
    public boolean hasModifyTime() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * The last modification timestamp of the entry in the source system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp modify_time = 7;</code>
     *
     * @return The modifyTime.
     */
    public com.google.protobuf.Timestamp getModifyTime() {
      if (modifyTimeBuilder_ == null) {
        return modifyTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : modifyTime_;
      } else {
        return modifyTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The last modification timestamp of the entry in the source system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp modify_time = 7;</code>
     */
    public Builder setModifyTime(com.google.protobuf.Timestamp value) {
      if (modifyTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        modifyTime_ = value;
      } else {
        modifyTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The last modification timestamp of the entry in the source system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp modify_time = 7;</code>
     */
    public Builder setModifyTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (modifyTimeBuilder_ == null) {
        modifyTime_ = builderForValue.build();
      } else {
        modifyTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The last modification timestamp of the entry in the source system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp modify_time = 7;</code>
     */
    public Builder mergeModifyTime(com.google.protobuf.Timestamp value) {
      if (modifyTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && modifyTime_ != null
            && modifyTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getModifyTimeBuilder().mergeFrom(value);
        } else {
          modifyTime_ = value;
        }
      } else {
        modifyTimeBuilder_.mergeFrom(value);
      }
      if (modifyTime_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The last modification timestamp of the entry in the source system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp modify_time = 7;</code>
     */
    public Builder clearModifyTime() {
      bitField0_ = (bitField0_ & ~0x00000010);
      modifyTime_ = null;
      if (modifyTimeBuilder_ != null) {
        modifyTimeBuilder_.dispose();
        modifyTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The last modification timestamp of the entry in the source system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp modify_time = 7;</code>
     */
    public com.google.protobuf.Timestamp.Builder getModifyTimeBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getModifyTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The last modification timestamp of the entry in the source system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp modify_time = 7;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getModifyTimeOrBuilder() {
      if (modifyTimeBuilder_ != null) {
        return modifyTimeBuilder_.getMessageOrBuilder();
      } else {
        return modifyTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : modifyTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The last modification timestamp of the entry in the source system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp modify_time = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getModifyTimeFieldBuilder() {
      if (modifyTimeBuilder_ == null) {
        modifyTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getModifyTime(), getParentForChildren(), isClean());
        modifyTime_ = null;
      }
      return modifyTimeBuilder_;
    }

    /**
     *
     *
     * <pre>
     * Output only. The source system that Data Catalog automatically integrates
     * with, such as BigQuery, Cloud Pub/Sub, or Dataproc Metastore.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.IntegratedSystem integrated_system = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the integratedSystem field is set.
     */
    @java.lang.Override
    public boolean hasIntegratedSystem() {
      return systemCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * Output only. The source system that Data Catalog automatically integrates
     * with, such as BigQuery, Cloud Pub/Sub, or Dataproc Metastore.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.IntegratedSystem integrated_system = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for integratedSystem.
     */
    @java.lang.Override
    public int getIntegratedSystemValue() {
      if (systemCase_ == 8) {
        return ((java.lang.Integer) system_).intValue();
      }
      return 0;
    }
    /**
     *
     *
     * <pre>
     * Output only. The source system that Data Catalog automatically integrates
     * with, such as BigQuery, Cloud Pub/Sub, or Dataproc Metastore.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.IntegratedSystem integrated_system = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for integratedSystem to set.
     * @return This builder for chaining.
     */
    public Builder setIntegratedSystemValue(int value) {
      systemCase_ = 8;
      system_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The source system that Data Catalog automatically integrates
     * with, such as BigQuery, Cloud Pub/Sub, or Dataproc Metastore.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.IntegratedSystem integrated_system = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The integratedSystem.
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1.IntegratedSystem getIntegratedSystem() {
      if (systemCase_ == 8) {
        com.google.cloud.datacatalog.v1.IntegratedSystem result =
            com.google.cloud.datacatalog.v1.IntegratedSystem.forNumber((java.lang.Integer) system_);
        return result == null
            ? com.google.cloud.datacatalog.v1.IntegratedSystem.UNRECOGNIZED
            : result;
      }
      return com.google.cloud.datacatalog.v1.IntegratedSystem.INTEGRATED_SYSTEM_UNSPECIFIED;
    }
    /**
     *
     *
     * <pre>
     * Output only. The source system that Data Catalog automatically integrates
     * with, such as BigQuery, Cloud Pub/Sub, or Dataproc Metastore.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.IntegratedSystem integrated_system = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The integratedSystem to set.
     * @return This builder for chaining.
     */
    public Builder setIntegratedSystem(com.google.cloud.datacatalog.v1.IntegratedSystem value) {
      if (value == null) {
        throw new NullPointerException();
      }
      systemCase_ = 8;
      system_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The source system that Data Catalog automatically integrates
     * with, such as BigQuery, Cloud Pub/Sub, or Dataproc Metastore.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1.IntegratedSystem integrated_system = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIntegratedSystem() {
      if (systemCase_ == 8) {
        systemCase_ = 0;
        system_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Custom source system that you can manually integrate Data Catalog with.
     * </pre>
     *
     * <code>string user_specified_system = 9;</code>
     *
     * @return Whether the userSpecifiedSystem field is set.
     */
    @java.lang.Override
    public boolean hasUserSpecifiedSystem() {
      return systemCase_ == 9;
    }
    /**
     *
     *
     * <pre>
     * Custom source system that you can manually integrate Data Catalog with.
     * </pre>
     *
     * <code>string user_specified_system = 9;</code>
     *
     * @return The userSpecifiedSystem.
     */
    @java.lang.Override
    public java.lang.String getUserSpecifiedSystem() {
      java.lang.Object ref = "";
      if (systemCase_ == 9) {
        ref = system_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (systemCase_ == 9) {
          system_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Custom source system that you can manually integrate Data Catalog with.
     * </pre>
     *
     * <code>string user_specified_system = 9;</code>
     *
     * @return The bytes for userSpecifiedSystem.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getUserSpecifiedSystemBytes() {
      java.lang.Object ref = "";
      if (systemCase_ == 9) {
        ref = system_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (systemCase_ == 9) {
          system_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Custom source system that you can manually integrate Data Catalog with.
     * </pre>
     *
     * <code>string user_specified_system = 9;</code>
     *
     * @param value The userSpecifiedSystem to set.
     * @return This builder for chaining.
     */
    public Builder setUserSpecifiedSystem(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      systemCase_ = 9;
      system_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Custom source system that you can manually integrate Data Catalog with.
     * </pre>
     *
     * <code>string user_specified_system = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUserSpecifiedSystem() {
      if (systemCase_ == 9) {
        systemCase_ = 0;
        system_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Custom source system that you can manually integrate Data Catalog with.
     * </pre>
     *
     * <code>string user_specified_system = 9;</code>
     *
     * @param value The bytes for userSpecifiedSystem to set.
     * @return This builder for chaining.
     */
    public Builder setUserSpecifiedSystemBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      systemCase_ = 9;
      system_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object fullyQualifiedName_ = "";
    /**
     *
     *
     * <pre>
     * Fully qualified name (FQN) of the resource.
     *
     * FQNs take two forms:
     *
     * * For non-regionalized resources:
     *
     *   `{SYSTEM}:{PROJECT}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}`
     *
     * * For regionalized resources:
     *
     *   `{SYSTEM}:{PROJECT}.{LOCATION_ID}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}`
     *
     * Example for a DPMS table:
     *
     * `dataproc_metastore:PROJECT_ID.LOCATION_ID.INSTANCE_ID.DATABASE_ID.TABLE_ID`
     * </pre>
     *
     * <code>string fully_qualified_name = 10;</code>
     *
     * @return The fullyQualifiedName.
     */
    public java.lang.String getFullyQualifiedName() {
      java.lang.Object ref = fullyQualifiedName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fullyQualifiedName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Fully qualified name (FQN) of the resource.
     *
     * FQNs take two forms:
     *
     * * For non-regionalized resources:
     *
     *   `{SYSTEM}:{PROJECT}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}`
     *
     * * For regionalized resources:
     *
     *   `{SYSTEM}:{PROJECT}.{LOCATION_ID}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}`
     *
     * Example for a DPMS table:
     *
     * `dataproc_metastore:PROJECT_ID.LOCATION_ID.INSTANCE_ID.DATABASE_ID.TABLE_ID`
     * </pre>
     *
     * <code>string fully_qualified_name = 10;</code>
     *
     * @return The bytes for fullyQualifiedName.
     */
    public com.google.protobuf.ByteString getFullyQualifiedNameBytes() {
      java.lang.Object ref = fullyQualifiedName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        fullyQualifiedName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Fully qualified name (FQN) of the resource.
     *
     * FQNs take two forms:
     *
     * * For non-regionalized resources:
     *
     *   `{SYSTEM}:{PROJECT}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}`
     *
     * * For regionalized resources:
     *
     *   `{SYSTEM}:{PROJECT}.{LOCATION_ID}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}`
     *
     * Example for a DPMS table:
     *
     * `dataproc_metastore:PROJECT_ID.LOCATION_ID.INSTANCE_ID.DATABASE_ID.TABLE_ID`
     * </pre>
     *
     * <code>string fully_qualified_name = 10;</code>
     *
     * @param value The fullyQualifiedName to set.
     * @return This builder for chaining.
     */
    public Builder setFullyQualifiedName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      fullyQualifiedName_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fully qualified name (FQN) of the resource.
     *
     * FQNs take two forms:
     *
     * * For non-regionalized resources:
     *
     *   `{SYSTEM}:{PROJECT}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}`
     *
     * * For regionalized resources:
     *
     *   `{SYSTEM}:{PROJECT}.{LOCATION_ID}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}`
     *
     * Example for a DPMS table:
     *
     * `dataproc_metastore:PROJECT_ID.LOCATION_ID.INSTANCE_ID.DATABASE_ID.TABLE_ID`
     * </pre>
     *
     * <code>string fully_qualified_name = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFullyQualifiedName() {
      fullyQualifiedName_ = getDefaultInstance().getFullyQualifiedName();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Fully qualified name (FQN) of the resource.
     *
     * FQNs take two forms:
     *
     * * For non-regionalized resources:
     *
     *   `{SYSTEM}:{PROJECT}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}`
     *
     * * For regionalized resources:
     *
     *   `{SYSTEM}:{PROJECT}.{LOCATION_ID}.{PATH_TO_RESOURCE_SEPARATED_WITH_DOTS}`
     *
     * Example for a DPMS table:
     *
     * `dataproc_metastore:PROJECT_ID.LOCATION_ID.INSTANCE_ID.DATABASE_ID.TABLE_ID`
     * </pre>
     *
     * <code>string fully_qualified_name = 10;</code>
     *
     * @param value The bytes for fullyQualifiedName to set.
     * @return This builder for chaining.
     */
    public Builder setFullyQualifiedNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      fullyQualifiedName_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * The display name of the result.
     * </pre>
     *
     * <code>string display_name = 12;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The display name of the result.
     * </pre>
     *
     * <code>string display_name = 12;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The display name of the result.
     * </pre>
     *
     * <code>string display_name = 12;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The display name of the result.
     * </pre>
     *
     * <code>string display_name = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The display name of the result.
     * </pre>
     *
     * <code>string display_name = 12;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Entry description that can consist of several sentences or paragraphs that
     * describe entry contents.
     * </pre>
     *
     * <code>string description = 13;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Entry description that can consist of several sentences or paragraphs that
     * describe entry contents.
     * </pre>
     *
     * <code>string description = 13;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Entry description that can consist of several sentences or paragraphs that
     * describe entry contents.
     * </pre>
     *
     * <code>string description = 13;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Entry description that can consist of several sentences or paragraphs that
     * describe entry contents.
     * </pre>
     *
     * <code>string description = 13;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Entry description that can consist of several sentences or paragraphs that
     * describe entry contents.
     * </pre>
     *
     * <code>string description = 13;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datacatalog.v1.SearchCatalogResult)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datacatalog.v1.SearchCatalogResult)
  private static final com.google.cloud.datacatalog.v1.SearchCatalogResult DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datacatalog.v1.SearchCatalogResult();
  }

  public static com.google.cloud.datacatalog.v1.SearchCatalogResult getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SearchCatalogResult> PARSER =
      new com.google.protobuf.AbstractParser<SearchCatalogResult>() {
        @java.lang.Override
        public SearchCatalogResult parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SearchCatalogResult> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SearchCatalogResult> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datacatalog.v1.SearchCatalogResult getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
