/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datacatalog/v1/policytagmanagerserialization.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.datacatalog.v1;

/**
 *
 *
 * <pre>
 * A nested protocol buffer that represents a taxonomy and the hierarchy of its
 * policy tags. Used for taxonomy replacement, import, and
 * export.
 * </pre>
 *
 * Protobuf type {@code google.cloud.datacatalog.v1.SerializedTaxonomy}
 */
public final class SerializedTaxonomy extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datacatalog.v1.SerializedTaxonomy)
    SerializedTaxonomyOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SerializedTaxonomy.newBuilder() to construct.
  private SerializedTaxonomy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SerializedTaxonomy() {
    displayName_ = "";
    description_ = "";
    policyTags_ = java.util.Collections.emptyList();
    activatedPolicyTypes_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SerializedTaxonomy();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datacatalog.v1.PolicyTagManagerSerializationProto
        .internal_static_google_cloud_datacatalog_v1_SerializedTaxonomy_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datacatalog.v1.PolicyTagManagerSerializationProto
        .internal_static_google_cloud_datacatalog_v1_SerializedTaxonomy_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datacatalog.v1.SerializedTaxonomy.class,
            com.google.cloud.datacatalog.v1.SerializedTaxonomy.Builder.class);
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Required. Display name of the taxonomy. At most 200 bytes when encoded in
   * UTF-8.
   * </pre>
   *
   * <code>string display_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Display name of the taxonomy. At most 200 bytes when encoded in
   * UTF-8.
   * </pre>
   *
   * <code>string display_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Description of the serialized taxonomy. At most 2000 bytes when
   * encoded in UTF-8. If not set, defaults to an empty description.
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Description of the serialized taxonomy. At most 2000 bytes when
   * encoded in UTF-8. If not set, defaults to an empty description.
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int POLICY_TAGS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.datacatalog.v1.SerializedPolicyTag> policyTags_;
  /**
   *
   *
   * <pre>
   * Top level policy tags associated with the taxonomy, if any.
   * </pre>
   *
   * <code>repeated .google.cloud.datacatalog.v1.SerializedPolicyTag policy_tags = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.datacatalog.v1.SerializedPolicyTag> getPolicyTagsList() {
    return policyTags_;
  }
  /**
   *
   *
   * <pre>
   * Top level policy tags associated with the taxonomy, if any.
   * </pre>
   *
   * <code>repeated .google.cloud.datacatalog.v1.SerializedPolicyTag policy_tags = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.datacatalog.v1.SerializedPolicyTagOrBuilder>
      getPolicyTagsOrBuilderList() {
    return policyTags_;
  }
  /**
   *
   *
   * <pre>
   * Top level policy tags associated with the taxonomy, if any.
   * </pre>
   *
   * <code>repeated .google.cloud.datacatalog.v1.SerializedPolicyTag policy_tags = 3;</code>
   */
  @java.lang.Override
  public int getPolicyTagsCount() {
    return policyTags_.size();
  }
  /**
   *
   *
   * <pre>
   * Top level policy tags associated with the taxonomy, if any.
   * </pre>
   *
   * <code>repeated .google.cloud.datacatalog.v1.SerializedPolicyTag policy_tags = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.SerializedPolicyTag getPolicyTags(int index) {
    return policyTags_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Top level policy tags associated with the taxonomy, if any.
   * </pre>
   *
   * <code>repeated .google.cloud.datacatalog.v1.SerializedPolicyTag policy_tags = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.SerializedPolicyTagOrBuilder getPolicyTagsOrBuilder(
      int index) {
    return policyTags_.get(index);
  }

  public static final int ACTIVATED_POLICY_TYPES_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> activatedPolicyTypes_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.cloud.datacatalog.v1.Taxonomy.PolicyType>
      activatedPolicyTypes_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.cloud.datacatalog.v1.Taxonomy.PolicyType>() {
            public com.google.cloud.datacatalog.v1.Taxonomy.PolicyType convert(
                java.lang.Integer from) {
              com.google.cloud.datacatalog.v1.Taxonomy.PolicyType result =
                  com.google.cloud.datacatalog.v1.Taxonomy.PolicyType.forNumber(from);
              return result == null
                  ? com.google.cloud.datacatalog.v1.Taxonomy.PolicyType.UNRECOGNIZED
                  : result;
            }
          };
  /**
   *
   *
   * <pre>
   * A list of policy types that are activated per taxonomy.
   * </pre>
   *
   * <code>repeated .google.cloud.datacatalog.v1.Taxonomy.PolicyType activated_policy_types = 4;
   * </code>
   *
   * @return A list containing the activatedPolicyTypes.
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.datacatalog.v1.Taxonomy.PolicyType>
      getActivatedPolicyTypesList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.cloud.datacatalog.v1.Taxonomy.PolicyType>(
        activatedPolicyTypes_, activatedPolicyTypes_converter_);
  }
  /**
   *
   *
   * <pre>
   * A list of policy types that are activated per taxonomy.
   * </pre>
   *
   * <code>repeated .google.cloud.datacatalog.v1.Taxonomy.PolicyType activated_policy_types = 4;
   * </code>
   *
   * @return The count of activatedPolicyTypes.
   */
  @java.lang.Override
  public int getActivatedPolicyTypesCount() {
    return activatedPolicyTypes_.size();
  }
  /**
   *
   *
   * <pre>
   * A list of policy types that are activated per taxonomy.
   * </pre>
   *
   * <code>repeated .google.cloud.datacatalog.v1.Taxonomy.PolicyType activated_policy_types = 4;
   * </code>
   *
   * @param index The index of the element to return.
   * @return The activatedPolicyTypes at the given index.
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.Taxonomy.PolicyType getActivatedPolicyTypes(int index) {
    return activatedPolicyTypes_converter_.convert(activatedPolicyTypes_.get(index));
  }
  /**
   *
   *
   * <pre>
   * A list of policy types that are activated per taxonomy.
   * </pre>
   *
   * <code>repeated .google.cloud.datacatalog.v1.Taxonomy.PolicyType activated_policy_types = 4;
   * </code>
   *
   * @return A list containing the enum numeric values on the wire for activatedPolicyTypes.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getActivatedPolicyTypesValueList() {
    return activatedPolicyTypes_;
  }
  /**
   *
   *
   * <pre>
   * A list of policy types that are activated per taxonomy.
   * </pre>
   *
   * <code>repeated .google.cloud.datacatalog.v1.Taxonomy.PolicyType activated_policy_types = 4;
   * </code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of activatedPolicyTypes at the given index.
   */
  @java.lang.Override
  public int getActivatedPolicyTypesValue(int index) {
    return activatedPolicyTypes_.get(index);
  }

  private int activatedPolicyTypesMemoizedSerializedSize;

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, description_);
    }
    for (int i = 0; i < policyTags_.size(); i++) {
      output.writeMessage(3, policyTags_.get(i));
    }
    if (getActivatedPolicyTypesList().size() > 0) {
      output.writeUInt32NoTag(34);
      output.writeUInt32NoTag(activatedPolicyTypesMemoizedSerializedSize);
    }
    for (int i = 0; i < activatedPolicyTypes_.size(); i++) {
      output.writeEnumNoTag(activatedPolicyTypes_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, description_);
    }
    for (int i = 0; i < policyTags_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, policyTags_.get(i));
    }
    {
      int dataSize = 0;
      for (int i = 0; i < activatedPolicyTypes_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(
                activatedPolicyTypes_.get(i));
      }
      size += dataSize;
      if (!getActivatedPolicyTypesList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      activatedPolicyTypesMemoizedSerializedSize = dataSize;
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datacatalog.v1.SerializedTaxonomy)) {
      return super.equals(obj);
    }
    com.google.cloud.datacatalog.v1.SerializedTaxonomy other =
        (com.google.cloud.datacatalog.v1.SerializedTaxonomy) obj;

    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getPolicyTagsList().equals(other.getPolicyTagsList())) return false;
    if (!activatedPolicyTypes_.equals(other.activatedPolicyTypes_)) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (getPolicyTagsCount() > 0) {
      hash = (37 * hash) + POLICY_TAGS_FIELD_NUMBER;
      hash = (53 * hash) + getPolicyTagsList().hashCode();
    }
    if (getActivatedPolicyTypesCount() > 0) {
      hash = (37 * hash) + ACTIVATED_POLICY_TYPES_FIELD_NUMBER;
      hash = (53 * hash) + activatedPolicyTypes_.hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datacatalog.v1.SerializedTaxonomy parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1.SerializedTaxonomy parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.SerializedTaxonomy parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1.SerializedTaxonomy parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.SerializedTaxonomy parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1.SerializedTaxonomy parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.SerializedTaxonomy parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1.SerializedTaxonomy parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.SerializedTaxonomy parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1.SerializedTaxonomy parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.SerializedTaxonomy parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1.SerializedTaxonomy parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.datacatalog.v1.SerializedTaxonomy prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A nested protocol buffer that represents a taxonomy and the hierarchy of its
   * policy tags. Used for taxonomy replacement, import, and
   * export.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datacatalog.v1.SerializedTaxonomy}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datacatalog.v1.SerializedTaxonomy)
      com.google.cloud.datacatalog.v1.SerializedTaxonomyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datacatalog.v1.PolicyTagManagerSerializationProto
          .internal_static_google_cloud_datacatalog_v1_SerializedTaxonomy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datacatalog.v1.PolicyTagManagerSerializationProto
          .internal_static_google_cloud_datacatalog_v1_SerializedTaxonomy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datacatalog.v1.SerializedTaxonomy.class,
              com.google.cloud.datacatalog.v1.SerializedTaxonomy.Builder.class);
    }

    // Construct using com.google.cloud.datacatalog.v1.SerializedTaxonomy.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      displayName_ = "";
      description_ = "";
      if (policyTagsBuilder_ == null) {
        policyTags_ = java.util.Collections.emptyList();
      } else {
        policyTags_ = null;
        policyTagsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      activatedPolicyTypes_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datacatalog.v1.PolicyTagManagerSerializationProto
          .internal_static_google_cloud_datacatalog_v1_SerializedTaxonomy_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.SerializedTaxonomy getDefaultInstanceForType() {
      return com.google.cloud.datacatalog.v1.SerializedTaxonomy.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.SerializedTaxonomy build() {
      com.google.cloud.datacatalog.v1.SerializedTaxonomy result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.SerializedTaxonomy buildPartial() {
      com.google.cloud.datacatalog.v1.SerializedTaxonomy result =
          new com.google.cloud.datacatalog.v1.SerializedTaxonomy(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.datacatalog.v1.SerializedTaxonomy result) {
      if (policyTagsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          policyTags_ = java.util.Collections.unmodifiableList(policyTags_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.policyTags_ = policyTags_;
      } else {
        result.policyTags_ = policyTagsBuilder_.build();
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        activatedPolicyTypes_ = java.util.Collections.unmodifiableList(activatedPolicyTypes_);
        bitField0_ = (bitField0_ & ~0x00000008);
      }
      result.activatedPolicyTypes_ = activatedPolicyTypes_;
    }

    private void buildPartial0(com.google.cloud.datacatalog.v1.SerializedTaxonomy result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.description_ = description_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datacatalog.v1.SerializedTaxonomy) {
        return mergeFrom((com.google.cloud.datacatalog.v1.SerializedTaxonomy) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datacatalog.v1.SerializedTaxonomy other) {
      if (other == com.google.cloud.datacatalog.v1.SerializedTaxonomy.getDefaultInstance())
        return this;
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (policyTagsBuilder_ == null) {
        if (!other.policyTags_.isEmpty()) {
          if (policyTags_.isEmpty()) {
            policyTags_ = other.policyTags_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensurePolicyTagsIsMutable();
            policyTags_.addAll(other.policyTags_);
          }
          onChanged();
        }
      } else {
        if (!other.policyTags_.isEmpty()) {
          if (policyTagsBuilder_.isEmpty()) {
            policyTagsBuilder_.dispose();
            policyTagsBuilder_ = null;
            policyTags_ = other.policyTags_;
            bitField0_ = (bitField0_ & ~0x00000004);
            policyTagsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPolicyTagsFieldBuilder()
                    : null;
          } else {
            policyTagsBuilder_.addAllMessages(other.policyTags_);
          }
        }
      }
      if (!other.activatedPolicyTypes_.isEmpty()) {
        if (activatedPolicyTypes_.isEmpty()) {
          activatedPolicyTypes_ = other.activatedPolicyTypes_;
          bitField0_ = (bitField0_ & ~0x00000008);
        } else {
          ensureActivatedPolicyTypesIsMutable();
          activatedPolicyTypes_.addAll(other.activatedPolicyTypes_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                com.google.cloud.datacatalog.v1.SerializedPolicyTag m =
                    input.readMessage(
                        com.google.cloud.datacatalog.v1.SerializedPolicyTag.parser(),
                        extensionRegistry);
                if (policyTagsBuilder_ == null) {
                  ensurePolicyTagsIsMutable();
                  policyTags_.add(m);
                } else {
                  policyTagsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 32:
              {
                int tmpRaw = input.readEnum();
                ensureActivatedPolicyTypesIsMutable();
                activatedPolicyTypes_.add(tmpRaw);
                break;
              } // case 32
            case 34:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureActivatedPolicyTypesIsMutable();
                  activatedPolicyTypes_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. Display name of the taxonomy. At most 200 bytes when encoded in
     * UTF-8.
     * </pre>
     *
     * <code>string display_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Display name of the taxonomy. At most 200 bytes when encoded in
     * UTF-8.
     * </pre>
     *
     * <code>string display_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Display name of the taxonomy. At most 200 bytes when encoded in
     * UTF-8.
     * </pre>
     *
     * <code>string display_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Display name of the taxonomy. At most 200 bytes when encoded in
     * UTF-8.
     * </pre>
     *
     * <code>string display_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Display name of the taxonomy. At most 200 bytes when encoded in
     * UTF-8.
     * </pre>
     *
     * <code>string display_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Description of the serialized taxonomy. At most 2000 bytes when
     * encoded in UTF-8. If not set, defaults to an empty description.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Description of the serialized taxonomy. At most 2000 bytes when
     * encoded in UTF-8. If not set, defaults to an empty description.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Description of the serialized taxonomy. At most 2000 bytes when
     * encoded in UTF-8. If not set, defaults to an empty description.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Description of the serialized taxonomy. At most 2000 bytes when
     * encoded in UTF-8. If not set, defaults to an empty description.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Description of the serialized taxonomy. At most 2000 bytes when
     * encoded in UTF-8. If not set, defaults to an empty description.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.datacatalog.v1.SerializedPolicyTag> policyTags_ =
        java.util.Collections.emptyList();

    private void ensurePolicyTagsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        policyTags_ =
            new java.util.ArrayList<com.google.cloud.datacatalog.v1.SerializedPolicyTag>(
                policyTags_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.datacatalog.v1.SerializedPolicyTag,
            com.google.cloud.datacatalog.v1.SerializedPolicyTag.Builder,
            com.google.cloud.datacatalog.v1.SerializedPolicyTagOrBuilder>
        policyTagsBuilder_;

    /**
     *
     *
     * <pre>
     * Top level policy tags associated with the taxonomy, if any.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.SerializedPolicyTag policy_tags = 3;</code>
     */
    public java.util.List<com.google.cloud.datacatalog.v1.SerializedPolicyTag> getPolicyTagsList() {
      if (policyTagsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(policyTags_);
      } else {
        return policyTagsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Top level policy tags associated with the taxonomy, if any.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.SerializedPolicyTag policy_tags = 3;</code>
     */
    public int getPolicyTagsCount() {
      if (policyTagsBuilder_ == null) {
        return policyTags_.size();
      } else {
        return policyTagsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Top level policy tags associated with the taxonomy, if any.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.SerializedPolicyTag policy_tags = 3;</code>
     */
    public com.google.cloud.datacatalog.v1.SerializedPolicyTag getPolicyTags(int index) {
      if (policyTagsBuilder_ == null) {
        return policyTags_.get(index);
      } else {
        return policyTagsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Top level policy tags associated with the taxonomy, if any.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.SerializedPolicyTag policy_tags = 3;</code>
     */
    public Builder setPolicyTags(
        int index, com.google.cloud.datacatalog.v1.SerializedPolicyTag value) {
      if (policyTagsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePolicyTagsIsMutable();
        policyTags_.set(index, value);
        onChanged();
      } else {
        policyTagsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Top level policy tags associated with the taxonomy, if any.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.SerializedPolicyTag policy_tags = 3;</code>
     */
    public Builder setPolicyTags(
        int index, com.google.cloud.datacatalog.v1.SerializedPolicyTag.Builder builderForValue) {
      if (policyTagsBuilder_ == null) {
        ensurePolicyTagsIsMutable();
        policyTags_.set(index, builderForValue.build());
        onChanged();
      } else {
        policyTagsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Top level policy tags associated with the taxonomy, if any.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.SerializedPolicyTag policy_tags = 3;</code>
     */
    public Builder addPolicyTags(com.google.cloud.datacatalog.v1.SerializedPolicyTag value) {
      if (policyTagsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePolicyTagsIsMutable();
        policyTags_.add(value);
        onChanged();
      } else {
        policyTagsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Top level policy tags associated with the taxonomy, if any.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.SerializedPolicyTag policy_tags = 3;</code>
     */
    public Builder addPolicyTags(
        int index, com.google.cloud.datacatalog.v1.SerializedPolicyTag value) {
      if (policyTagsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePolicyTagsIsMutable();
        policyTags_.add(index, value);
        onChanged();
      } else {
        policyTagsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Top level policy tags associated with the taxonomy, if any.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.SerializedPolicyTag policy_tags = 3;</code>
     */
    public Builder addPolicyTags(
        com.google.cloud.datacatalog.v1.SerializedPolicyTag.Builder builderForValue) {
      if (policyTagsBuilder_ == null) {
        ensurePolicyTagsIsMutable();
        policyTags_.add(builderForValue.build());
        onChanged();
      } else {
        policyTagsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Top level policy tags associated with the taxonomy, if any.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.SerializedPolicyTag policy_tags = 3;</code>
     */
    public Builder addPolicyTags(
        int index, com.google.cloud.datacatalog.v1.SerializedPolicyTag.Builder builderForValue) {
      if (policyTagsBuilder_ == null) {
        ensurePolicyTagsIsMutable();
        policyTags_.add(index, builderForValue.build());
        onChanged();
      } else {
        policyTagsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Top level policy tags associated with the taxonomy, if any.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.SerializedPolicyTag policy_tags = 3;</code>
     */
    public Builder addAllPolicyTags(
        java.lang.Iterable<? extends com.google.cloud.datacatalog.v1.SerializedPolicyTag> values) {
      if (policyTagsBuilder_ == null) {
        ensurePolicyTagsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, policyTags_);
        onChanged();
      } else {
        policyTagsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Top level policy tags associated with the taxonomy, if any.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.SerializedPolicyTag policy_tags = 3;</code>
     */
    public Builder clearPolicyTags() {
      if (policyTagsBuilder_ == null) {
        policyTags_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        policyTagsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Top level policy tags associated with the taxonomy, if any.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.SerializedPolicyTag policy_tags = 3;</code>
     */
    public Builder removePolicyTags(int index) {
      if (policyTagsBuilder_ == null) {
        ensurePolicyTagsIsMutable();
        policyTags_.remove(index);
        onChanged();
      } else {
        policyTagsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Top level policy tags associated with the taxonomy, if any.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.SerializedPolicyTag policy_tags = 3;</code>
     */
    public com.google.cloud.datacatalog.v1.SerializedPolicyTag.Builder getPolicyTagsBuilder(
        int index) {
      return getPolicyTagsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Top level policy tags associated with the taxonomy, if any.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.SerializedPolicyTag policy_tags = 3;</code>
     */
    public com.google.cloud.datacatalog.v1.SerializedPolicyTagOrBuilder getPolicyTagsOrBuilder(
        int index) {
      if (policyTagsBuilder_ == null) {
        return policyTags_.get(index);
      } else {
        return policyTagsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Top level policy tags associated with the taxonomy, if any.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.SerializedPolicyTag policy_tags = 3;</code>
     */
    public java.util.List<? extends com.google.cloud.datacatalog.v1.SerializedPolicyTagOrBuilder>
        getPolicyTagsOrBuilderList() {
      if (policyTagsBuilder_ != null) {
        return policyTagsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(policyTags_);
      }
    }
    /**
     *
     *
     * <pre>
     * Top level policy tags associated with the taxonomy, if any.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.SerializedPolicyTag policy_tags = 3;</code>
     */
    public com.google.cloud.datacatalog.v1.SerializedPolicyTag.Builder addPolicyTagsBuilder() {
      return getPolicyTagsFieldBuilder()
          .addBuilder(com.google.cloud.datacatalog.v1.SerializedPolicyTag.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Top level policy tags associated with the taxonomy, if any.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.SerializedPolicyTag policy_tags = 3;</code>
     */
    public com.google.cloud.datacatalog.v1.SerializedPolicyTag.Builder addPolicyTagsBuilder(
        int index) {
      return getPolicyTagsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.datacatalog.v1.SerializedPolicyTag.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Top level policy tags associated with the taxonomy, if any.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.SerializedPolicyTag policy_tags = 3;</code>
     */
    public java.util.List<com.google.cloud.datacatalog.v1.SerializedPolicyTag.Builder>
        getPolicyTagsBuilderList() {
      return getPolicyTagsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.datacatalog.v1.SerializedPolicyTag,
            com.google.cloud.datacatalog.v1.SerializedPolicyTag.Builder,
            com.google.cloud.datacatalog.v1.SerializedPolicyTagOrBuilder>
        getPolicyTagsFieldBuilder() {
      if (policyTagsBuilder_ == null) {
        policyTagsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.datacatalog.v1.SerializedPolicyTag,
                com.google.cloud.datacatalog.v1.SerializedPolicyTag.Builder,
                com.google.cloud.datacatalog.v1.SerializedPolicyTagOrBuilder>(
                policyTags_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        policyTags_ = null;
      }
      return policyTagsBuilder_;
    }

    private java.util.List<java.lang.Integer> activatedPolicyTypes_ =
        java.util.Collections.emptyList();

    private void ensureActivatedPolicyTypesIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        activatedPolicyTypes_ = new java.util.ArrayList<java.lang.Integer>(activatedPolicyTypes_);
        bitField0_ |= 0x00000008;
      }
    }
    /**
     *
     *
     * <pre>
     * A list of policy types that are activated per taxonomy.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.Taxonomy.PolicyType activated_policy_types = 4;
     * </code>
     *
     * @return A list containing the activatedPolicyTypes.
     */
    public java.util.List<com.google.cloud.datacatalog.v1.Taxonomy.PolicyType>
        getActivatedPolicyTypesList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.datacatalog.v1.Taxonomy.PolicyType>(
          activatedPolicyTypes_, activatedPolicyTypes_converter_);
    }
    /**
     *
     *
     * <pre>
     * A list of policy types that are activated per taxonomy.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.Taxonomy.PolicyType activated_policy_types = 4;
     * </code>
     *
     * @return The count of activatedPolicyTypes.
     */
    public int getActivatedPolicyTypesCount() {
      return activatedPolicyTypes_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of policy types that are activated per taxonomy.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.Taxonomy.PolicyType activated_policy_types = 4;
     * </code>
     *
     * @param index The index of the element to return.
     * @return The activatedPolicyTypes at the given index.
     */
    public com.google.cloud.datacatalog.v1.Taxonomy.PolicyType getActivatedPolicyTypes(int index) {
      return activatedPolicyTypes_converter_.convert(activatedPolicyTypes_.get(index));
    }
    /**
     *
     *
     * <pre>
     * A list of policy types that are activated per taxonomy.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.Taxonomy.PolicyType activated_policy_types = 4;
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The activatedPolicyTypes to set.
     * @return This builder for chaining.
     */
    public Builder setActivatedPolicyTypes(
        int index, com.google.cloud.datacatalog.v1.Taxonomy.PolicyType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureActivatedPolicyTypesIsMutable();
      activatedPolicyTypes_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of policy types that are activated per taxonomy.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.Taxonomy.PolicyType activated_policy_types = 4;
     * </code>
     *
     * @param value The activatedPolicyTypes to add.
     * @return This builder for chaining.
     */
    public Builder addActivatedPolicyTypes(
        com.google.cloud.datacatalog.v1.Taxonomy.PolicyType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureActivatedPolicyTypesIsMutable();
      activatedPolicyTypes_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of policy types that are activated per taxonomy.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.Taxonomy.PolicyType activated_policy_types = 4;
     * </code>
     *
     * @param values The activatedPolicyTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAllActivatedPolicyTypes(
        java.lang.Iterable<? extends com.google.cloud.datacatalog.v1.Taxonomy.PolicyType> values) {
      ensureActivatedPolicyTypesIsMutable();
      for (com.google.cloud.datacatalog.v1.Taxonomy.PolicyType value : values) {
        activatedPolicyTypes_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of policy types that are activated per taxonomy.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.Taxonomy.PolicyType activated_policy_types = 4;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearActivatedPolicyTypes() {
      activatedPolicyTypes_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of policy types that are activated per taxonomy.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.Taxonomy.PolicyType activated_policy_types = 4;
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for activatedPolicyTypes.
     */
    public java.util.List<java.lang.Integer> getActivatedPolicyTypesValueList() {
      return java.util.Collections.unmodifiableList(activatedPolicyTypes_);
    }
    /**
     *
     *
     * <pre>
     * A list of policy types that are activated per taxonomy.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.Taxonomy.PolicyType activated_policy_types = 4;
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of activatedPolicyTypes at the given index.
     */
    public int getActivatedPolicyTypesValue(int index) {
      return activatedPolicyTypes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of policy types that are activated per taxonomy.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.Taxonomy.PolicyType activated_policy_types = 4;
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for activatedPolicyTypes to set.
     * @return This builder for chaining.
     */
    public Builder setActivatedPolicyTypesValue(int index, int value) {
      ensureActivatedPolicyTypesIsMutable();
      activatedPolicyTypes_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of policy types that are activated per taxonomy.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.Taxonomy.PolicyType activated_policy_types = 4;
     * </code>
     *
     * @param value The enum numeric value on the wire for activatedPolicyTypes to add.
     * @return This builder for chaining.
     */
    public Builder addActivatedPolicyTypesValue(int value) {
      ensureActivatedPolicyTypesIsMutable();
      activatedPolicyTypes_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of policy types that are activated per taxonomy.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1.Taxonomy.PolicyType activated_policy_types = 4;
     * </code>
     *
     * @param values The enum numeric values on the wire for activatedPolicyTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAllActivatedPolicyTypesValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureActivatedPolicyTypesIsMutable();
      for (int value : values) {
        activatedPolicyTypes_.add(value);
      }
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datacatalog.v1.SerializedTaxonomy)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datacatalog.v1.SerializedTaxonomy)
  private static final com.google.cloud.datacatalog.v1.SerializedTaxonomy DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datacatalog.v1.SerializedTaxonomy();
  }

  public static com.google.cloud.datacatalog.v1.SerializedTaxonomy getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SerializedTaxonomy> PARSER =
      new com.google.protobuf.AbstractParser<SerializedTaxonomy>() {
        @java.lang.Override
        public SerializedTaxonomy parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SerializedTaxonomy> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SerializedTaxonomy> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datacatalog.v1.SerializedTaxonomy getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
