/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datacatalog/v1/tags.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.datacatalog.v1;

/**
 *
 *
 * <pre>
 * Contains the value and additional information on a field within
 * a [Tag][google.cloud.datacatalog.v1.Tag].
 * </pre>
 *
 * Protobuf type {@code google.cloud.datacatalog.v1.TagField}
 */
public final class TagField extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datacatalog.v1.TagField)
    TagFieldOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TagField.newBuilder() to construct.
  private TagField(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TagField() {
    displayName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TagField();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datacatalog.v1.Tags
        .internal_static_google_cloud_datacatalog_v1_TagField_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datacatalog.v1.Tags
        .internal_static_google_cloud_datacatalog_v1_TagField_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datacatalog.v1.TagField.class,
            com.google.cloud.datacatalog.v1.TagField.Builder.class);
  }

  public interface EnumValueOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.datacatalog.v1.TagField.EnumValue)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The display name of the enum value.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @return The displayName.
     */
    java.lang.String getDisplayName();
    /**
     *
     *
     * <pre>
     * The display name of the enum value.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @return The bytes for displayName.
     */
    com.google.protobuf.ByteString getDisplayNameBytes();
  }
  /**
   *
   *
   * <pre>
   * An enum value.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datacatalog.v1.TagField.EnumValue}
   */
  public static final class EnumValue extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.datacatalog.v1.TagField.EnumValue)
      EnumValueOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use EnumValue.newBuilder() to construct.
    private EnumValue(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private EnumValue() {
      displayName_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new EnumValue();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datacatalog.v1.Tags
          .internal_static_google_cloud_datacatalog_v1_TagField_EnumValue_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datacatalog.v1.Tags
          .internal_static_google_cloud_datacatalog_v1_TagField_EnumValue_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datacatalog.v1.TagField.EnumValue.class,
              com.google.cloud.datacatalog.v1.TagField.EnumValue.Builder.class);
    }

    public static final int DISPLAY_NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * The display name of the enum value.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @return The displayName.
     */
    @java.lang.Override
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The display name of the enum value.
     * </pre>
     *
     * <code>string display_name = 1;</code>
     *
     * @return The bytes for displayName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, displayName_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, displayName_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.datacatalog.v1.TagField.EnumValue)) {
        return super.equals(obj);
      }
      com.google.cloud.datacatalog.v1.TagField.EnumValue other =
          (com.google.cloud.datacatalog.v1.TagField.EnumValue) obj;

      if (!getDisplayName().equals(other.getDisplayName())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getDisplayName().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.datacatalog.v1.TagField.EnumValue parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datacatalog.v1.TagField.EnumValue parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.TagField.EnumValue parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datacatalog.v1.TagField.EnumValue parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.TagField.EnumValue parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datacatalog.v1.TagField.EnumValue parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.TagField.EnumValue parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.datacatalog.v1.TagField.EnumValue parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.TagField.EnumValue parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.datacatalog.v1.TagField.EnumValue parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1.TagField.EnumValue parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.datacatalog.v1.TagField.EnumValue parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloud.datacatalog.v1.TagField.EnumValue prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * An enum value.
     * </pre>
     *
     * Protobuf type {@code google.cloud.datacatalog.v1.TagField.EnumValue}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.datacatalog.v1.TagField.EnumValue)
        com.google.cloud.datacatalog.v1.TagField.EnumValueOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.datacatalog.v1.Tags
            .internal_static_google_cloud_datacatalog_v1_TagField_EnumValue_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.datacatalog.v1.Tags
            .internal_static_google_cloud_datacatalog_v1_TagField_EnumValue_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.datacatalog.v1.TagField.EnumValue.class,
                com.google.cloud.datacatalog.v1.TagField.EnumValue.Builder.class);
      }

      // Construct using com.google.cloud.datacatalog.v1.TagField.EnumValue.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        displayName_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.datacatalog.v1.Tags
            .internal_static_google_cloud_datacatalog_v1_TagField_EnumValue_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.datacatalog.v1.TagField.EnumValue getDefaultInstanceForType() {
        return com.google.cloud.datacatalog.v1.TagField.EnumValue.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.datacatalog.v1.TagField.EnumValue build() {
        com.google.cloud.datacatalog.v1.TagField.EnumValue result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.datacatalog.v1.TagField.EnumValue buildPartial() {
        com.google.cloud.datacatalog.v1.TagField.EnumValue result =
            new com.google.cloud.datacatalog.v1.TagField.EnumValue(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.datacatalog.v1.TagField.EnumValue result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.displayName_ = displayName_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.datacatalog.v1.TagField.EnumValue) {
          return mergeFrom((com.google.cloud.datacatalog.v1.TagField.EnumValue) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.datacatalog.v1.TagField.EnumValue other) {
        if (other == com.google.cloud.datacatalog.v1.TagField.EnumValue.getDefaultInstance())
          return this;
        if (!other.getDisplayName().isEmpty()) {
          displayName_ = other.displayName_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  displayName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object displayName_ = "";
      /**
       *
       *
       * <pre>
       * The display name of the enum value.
       * </pre>
       *
       * <code>string display_name = 1;</code>
       *
       * @return The displayName.
       */
      public java.lang.String getDisplayName() {
        java.lang.Object ref = displayName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          displayName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The display name of the enum value.
       * </pre>
       *
       * <code>string display_name = 1;</code>
       *
       * @return The bytes for displayName.
       */
      public com.google.protobuf.ByteString getDisplayNameBytes() {
        java.lang.Object ref = displayName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          displayName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The display name of the enum value.
       * </pre>
       *
       * <code>string display_name = 1;</code>
       *
       * @param value The displayName to set.
       * @return This builder for chaining.
       */
      public Builder setDisplayName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        displayName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The display name of the enum value.
       * </pre>
       *
       * <code>string display_name = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDisplayName() {
        displayName_ = getDefaultInstance().getDisplayName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The display name of the enum value.
       * </pre>
       *
       * <code>string display_name = 1;</code>
       *
       * @param value The bytes for displayName to set.
       * @return This builder for chaining.
       */
      public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        displayName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.datacatalog.v1.TagField.EnumValue)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.datacatalog.v1.TagField.EnumValue)
    private static final com.google.cloud.datacatalog.v1.TagField.EnumValue DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.datacatalog.v1.TagField.EnumValue();
    }

    public static com.google.cloud.datacatalog.v1.TagField.EnumValue getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<EnumValue> PARSER =
        new com.google.protobuf.AbstractParser<EnumValue>() {
          @java.lang.Override
          public EnumValue parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<EnumValue> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<EnumValue> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.TagField.EnumValue getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int kindCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object kind_;

  public enum KindCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    DOUBLE_VALUE(2),
    STRING_VALUE(3),
    BOOL_VALUE(4),
    TIMESTAMP_VALUE(5),
    ENUM_VALUE(6),
    RICHTEXT_VALUE(8),
    KIND_NOT_SET(0);
    private final int value;

    private KindCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static KindCase valueOf(int value) {
      return forNumber(value);
    }

    public static KindCase forNumber(int value) {
      switch (value) {
        case 2:
          return DOUBLE_VALUE;
        case 3:
          return STRING_VALUE;
        case 4:
          return BOOL_VALUE;
        case 5:
          return TIMESTAMP_VALUE;
        case 6:
          return ENUM_VALUE;
        case 8:
          return RICHTEXT_VALUE;
        case 0:
          return KIND_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public KindCase getKindCase() {
    return KindCase.forNumber(kindCase_);
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The display name of this field.
   * </pre>
   *
   * <code>string display_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The display name of this field.
   * </pre>
   *
   * <code>string display_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DOUBLE_VALUE_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * The value of a tag field with a double type.
   * </pre>
   *
   * <code>double double_value = 2;</code>
   *
   * @return Whether the doubleValue field is set.
   */
  @java.lang.Override
  public boolean hasDoubleValue() {
    return kindCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * The value of a tag field with a double type.
   * </pre>
   *
   * <code>double double_value = 2;</code>
   *
   * @return The doubleValue.
   */
  @java.lang.Override
  public double getDoubleValue() {
    if (kindCase_ == 2) {
      return (java.lang.Double) kind_;
    }
    return 0D;
  }

  public static final int STRING_VALUE_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * The value of a tag field with a string type.
   *
   * The maximum length is 2000 UTF-8 characters.
   * </pre>
   *
   * <code>string string_value = 3;</code>
   *
   * @return Whether the stringValue field is set.
   */
  public boolean hasStringValue() {
    return kindCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * The value of a tag field with a string type.
   *
   * The maximum length is 2000 UTF-8 characters.
   * </pre>
   *
   * <code>string string_value = 3;</code>
   *
   * @return The stringValue.
   */
  public java.lang.String getStringValue() {
    java.lang.Object ref = "";
    if (kindCase_ == 3) {
      ref = kind_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (kindCase_ == 3) {
        kind_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The value of a tag field with a string type.
   *
   * The maximum length is 2000 UTF-8 characters.
   * </pre>
   *
   * <code>string string_value = 3;</code>
   *
   * @return The bytes for stringValue.
   */
  public com.google.protobuf.ByteString getStringValueBytes() {
    java.lang.Object ref = "";
    if (kindCase_ == 3) {
      ref = kind_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (kindCase_ == 3) {
        kind_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BOOL_VALUE_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * The value of a tag field with a boolean type.
   * </pre>
   *
   * <code>bool bool_value = 4;</code>
   *
   * @return Whether the boolValue field is set.
   */
  @java.lang.Override
  public boolean hasBoolValue() {
    return kindCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * The value of a tag field with a boolean type.
   * </pre>
   *
   * <code>bool bool_value = 4;</code>
   *
   * @return The boolValue.
   */
  @java.lang.Override
  public boolean getBoolValue() {
    if (kindCase_ == 4) {
      return (java.lang.Boolean) kind_;
    }
    return false;
  }

  public static final int TIMESTAMP_VALUE_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * The value of a tag field with a timestamp type.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp timestamp_value = 5;</code>
   *
   * @return Whether the timestampValue field is set.
   */
  @java.lang.Override
  public boolean hasTimestampValue() {
    return kindCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * The value of a tag field with a timestamp type.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp timestamp_value = 5;</code>
   *
   * @return The timestampValue.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getTimestampValue() {
    if (kindCase_ == 5) {
      return (com.google.protobuf.Timestamp) kind_;
    }
    return com.google.protobuf.Timestamp.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The value of a tag field with a timestamp type.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp timestamp_value = 5;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getTimestampValueOrBuilder() {
    if (kindCase_ == 5) {
      return (com.google.protobuf.Timestamp) kind_;
    }
    return com.google.protobuf.Timestamp.getDefaultInstance();
  }

  public static final int ENUM_VALUE_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * The value of a tag field with an enum type.
   *
   * This value must be one of the allowed values listed in this enum.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.TagField.EnumValue enum_value = 6;</code>
   *
   * @return Whether the enumValue field is set.
   */
  @java.lang.Override
  public boolean hasEnumValue() {
    return kindCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * The value of a tag field with an enum type.
   *
   * This value must be one of the allowed values listed in this enum.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.TagField.EnumValue enum_value = 6;</code>
   *
   * @return The enumValue.
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.TagField.EnumValue getEnumValue() {
    if (kindCase_ == 6) {
      return (com.google.cloud.datacatalog.v1.TagField.EnumValue) kind_;
    }
    return com.google.cloud.datacatalog.v1.TagField.EnumValue.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The value of a tag field with an enum type.
   *
   * This value must be one of the allowed values listed in this enum.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1.TagField.EnumValue enum_value = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1.TagField.EnumValueOrBuilder getEnumValueOrBuilder() {
    if (kindCase_ == 6) {
      return (com.google.cloud.datacatalog.v1.TagField.EnumValue) kind_;
    }
    return com.google.cloud.datacatalog.v1.TagField.EnumValue.getDefaultInstance();
  }

  public static final int RICHTEXT_VALUE_FIELD_NUMBER = 8;
  /**
   *
   *
   * <pre>
   * The value of a tag field with a rich text type.
   *
   * The maximum length is 10 MiB as this value holds HTML descriptions
   * including encoded images. The maximum length of the text without images
   * is 100 KiB.
   * </pre>
   *
   * <code>string richtext_value = 8;</code>
   *
   * @return Whether the richtextValue field is set.
   */
  public boolean hasRichtextValue() {
    return kindCase_ == 8;
  }
  /**
   *
   *
   * <pre>
   * The value of a tag field with a rich text type.
   *
   * The maximum length is 10 MiB as this value holds HTML descriptions
   * including encoded images. The maximum length of the text without images
   * is 100 KiB.
   * </pre>
   *
   * <code>string richtext_value = 8;</code>
   *
   * @return The richtextValue.
   */
  public java.lang.String getRichtextValue() {
    java.lang.Object ref = "";
    if (kindCase_ == 8) {
      ref = kind_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (kindCase_ == 8) {
        kind_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The value of a tag field with a rich text type.
   *
   * The maximum length is 10 MiB as this value holds HTML descriptions
   * including encoded images. The maximum length of the text without images
   * is 100 KiB.
   * </pre>
   *
   * <code>string richtext_value = 8;</code>
   *
   * @return The bytes for richtextValue.
   */
  public com.google.protobuf.ByteString getRichtextValueBytes() {
    java.lang.Object ref = "";
    if (kindCase_ == 8) {
      ref = kind_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (kindCase_ == 8) {
        kind_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ORDER_FIELD_NUMBER = 7;
  private int order_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The order of this field with respect to other fields in this
   * tag. Can be set by
   * [Tag][google.cloud.datacatalog.v1.TagTemplateField.order].
   *
   * For example, a higher value can indicate a more important field.
   * The value can be negative. Multiple fields can have the same order, and
   * field orders within a tag don't have to be sequential.
   * </pre>
   *
   * <code>int32 order = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The order.
   */
  @java.lang.Override
  public int getOrder() {
    return order_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, displayName_);
    }
    if (kindCase_ == 2) {
      output.writeDouble(2, (double) ((java.lang.Double) kind_));
    }
    if (kindCase_ == 3) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, kind_);
    }
    if (kindCase_ == 4) {
      output.writeBool(4, (boolean) ((java.lang.Boolean) kind_));
    }
    if (kindCase_ == 5) {
      output.writeMessage(5, (com.google.protobuf.Timestamp) kind_);
    }
    if (kindCase_ == 6) {
      output.writeMessage(6, (com.google.cloud.datacatalog.v1.TagField.EnumValue) kind_);
    }
    if (order_ != 0) {
      output.writeInt32(7, order_);
    }
    if (kindCase_ == 8) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, kind_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, displayName_);
    }
    if (kindCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeDoubleSize(
              2, (double) ((java.lang.Double) kind_));
    }
    if (kindCase_ == 3) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, kind_);
    }
    if (kindCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(
              4, (boolean) ((java.lang.Boolean) kind_));
    }
    if (kindCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.protobuf.Timestamp) kind_);
    }
    if (kindCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloud.datacatalog.v1.TagField.EnumValue) kind_);
    }
    if (order_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(7, order_);
    }
    if (kindCase_ == 8) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, kind_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datacatalog.v1.TagField)) {
      return super.equals(obj);
    }
    com.google.cloud.datacatalog.v1.TagField other = (com.google.cloud.datacatalog.v1.TagField) obj;

    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (getOrder() != other.getOrder()) return false;
    if (!getKindCase().equals(other.getKindCase())) return false;
    switch (kindCase_) {
      case 2:
        if (java.lang.Double.doubleToLongBits(getDoubleValue())
            != java.lang.Double.doubleToLongBits(other.getDoubleValue())) return false;
        break;
      case 3:
        if (!getStringValue().equals(other.getStringValue())) return false;
        break;
      case 4:
        if (getBoolValue() != other.getBoolValue()) return false;
        break;
      case 5:
        if (!getTimestampValue().equals(other.getTimestampValue())) return false;
        break;
      case 6:
        if (!getEnumValue().equals(other.getEnumValue())) return false;
        break;
      case 8:
        if (!getRichtextValue().equals(other.getRichtextValue())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + ORDER_FIELD_NUMBER;
    hash = (53 * hash) + getOrder();
    switch (kindCase_) {
      case 2:
        hash = (37 * hash) + DOUBLE_VALUE_FIELD_NUMBER;
        hash =
            (53 * hash)
                + com.google.protobuf.Internal.hashLong(
                    java.lang.Double.doubleToLongBits(getDoubleValue()));
        break;
      case 3:
        hash = (37 * hash) + STRING_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getStringValue().hashCode();
        break;
      case 4:
        hash = (37 * hash) + BOOL_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getBoolValue());
        break;
      case 5:
        hash = (37 * hash) + TIMESTAMP_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getTimestampValue().hashCode();
        break;
      case 6:
        hash = (37 * hash) + ENUM_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getEnumValue().hashCode();
        break;
      case 8:
        hash = (37 * hash) + RICHTEXT_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getRichtextValue().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datacatalog.v1.TagField parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1.TagField parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.TagField parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1.TagField parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.TagField parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1.TagField parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.TagField parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1.TagField parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.TagField parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1.TagField parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1.TagField parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1.TagField parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.datacatalog.v1.TagField prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Contains the value and additional information on a field within
   * a [Tag][google.cloud.datacatalog.v1.Tag].
   * </pre>
   *
   * Protobuf type {@code google.cloud.datacatalog.v1.TagField}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datacatalog.v1.TagField)
      com.google.cloud.datacatalog.v1.TagFieldOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datacatalog.v1.Tags
          .internal_static_google_cloud_datacatalog_v1_TagField_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datacatalog.v1.Tags
          .internal_static_google_cloud_datacatalog_v1_TagField_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datacatalog.v1.TagField.class,
              com.google.cloud.datacatalog.v1.TagField.Builder.class);
    }

    // Construct using com.google.cloud.datacatalog.v1.TagField.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      displayName_ = "";
      if (timestampValueBuilder_ != null) {
        timestampValueBuilder_.clear();
      }
      if (enumValueBuilder_ != null) {
        enumValueBuilder_.clear();
      }
      order_ = 0;
      kindCase_ = 0;
      kind_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datacatalog.v1.Tags
          .internal_static_google_cloud_datacatalog_v1_TagField_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.TagField getDefaultInstanceForType() {
      return com.google.cloud.datacatalog.v1.TagField.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.TagField build() {
      com.google.cloud.datacatalog.v1.TagField result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1.TagField buildPartial() {
      com.google.cloud.datacatalog.v1.TagField result =
          new com.google.cloud.datacatalog.v1.TagField(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.datacatalog.v1.TagField result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.order_ = order_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.datacatalog.v1.TagField result) {
      result.kindCase_ = kindCase_;
      result.kind_ = this.kind_;
      if (kindCase_ == 5 && timestampValueBuilder_ != null) {
        result.kind_ = timestampValueBuilder_.build();
      }
      if (kindCase_ == 6 && enumValueBuilder_ != null) {
        result.kind_ = enumValueBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datacatalog.v1.TagField) {
        return mergeFrom((com.google.cloud.datacatalog.v1.TagField) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datacatalog.v1.TagField other) {
      if (other == com.google.cloud.datacatalog.v1.TagField.getDefaultInstance()) return this;
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.getOrder() != 0) {
        setOrder(other.getOrder());
      }
      switch (other.getKindCase()) {
        case DOUBLE_VALUE:
          {
            setDoubleValue(other.getDoubleValue());
            break;
          }
        case STRING_VALUE:
          {
            kindCase_ = 3;
            kind_ = other.kind_;
            onChanged();
            break;
          }
        case BOOL_VALUE:
          {
            setBoolValue(other.getBoolValue());
            break;
          }
        case TIMESTAMP_VALUE:
          {
            mergeTimestampValue(other.getTimestampValue());
            break;
          }
        case ENUM_VALUE:
          {
            mergeEnumValue(other.getEnumValue());
            break;
          }
        case RICHTEXT_VALUE:
          {
            kindCase_ = 8;
            kind_ = other.kind_;
            onChanged();
            break;
          }
        case KIND_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 17:
              {
                kind_ = input.readDouble();
                kindCase_ = 2;
                break;
              } // case 17
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                kindCase_ = 3;
                kind_ = s;
                break;
              } // case 26
            case 32:
              {
                kind_ = input.readBool();
                kindCase_ = 4;
                break;
              } // case 32
            case 42:
              {
                input.readMessage(getTimestampValueFieldBuilder().getBuilder(), extensionRegistry);
                kindCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getEnumValueFieldBuilder().getBuilder(), extensionRegistry);
                kindCase_ = 6;
                break;
              } // case 50
            case 56:
              {
                order_ = input.readInt32();
                bitField0_ |= 0x00000080;
                break;
              } // case 56
            case 66:
              {
                java.lang.String s = input.readStringRequireUtf8();
                kindCase_ = 8;
                kind_ = s;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int kindCase_ = 0;
    private java.lang.Object kind_;

    public KindCase getKindCase() {
      return KindCase.forNumber(kindCase_);
    }

    public Builder clearKind() {
      kindCase_ = 0;
      kind_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The display name of this field.
     * </pre>
     *
     * <code>string display_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The display name of this field.
     * </pre>
     *
     * <code>string display_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The display name of this field.
     * </pre>
     *
     * <code>string display_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The display name of this field.
     * </pre>
     *
     * <code>string display_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The display name of this field.
     * </pre>
     *
     * <code>string display_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The value of a tag field with a double type.
     * </pre>
     *
     * <code>double double_value = 2;</code>
     *
     * @return Whether the doubleValue field is set.
     */
    public boolean hasDoubleValue() {
      return kindCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * The value of a tag field with a double type.
     * </pre>
     *
     * <code>double double_value = 2;</code>
     *
     * @return The doubleValue.
     */
    public double getDoubleValue() {
      if (kindCase_ == 2) {
        return (java.lang.Double) kind_;
      }
      return 0D;
    }
    /**
     *
     *
     * <pre>
     * The value of a tag field with a double type.
     * </pre>
     *
     * <code>double double_value = 2;</code>
     *
     * @param value The doubleValue to set.
     * @return This builder for chaining.
     */
    public Builder setDoubleValue(double value) {

      kindCase_ = 2;
      kind_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The value of a tag field with a double type.
     * </pre>
     *
     * <code>double double_value = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDoubleValue() {
      if (kindCase_ == 2) {
        kindCase_ = 0;
        kind_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The value of a tag field with a string type.
     *
     * The maximum length is 2000 UTF-8 characters.
     * </pre>
     *
     * <code>string string_value = 3;</code>
     *
     * @return Whether the stringValue field is set.
     */
    @java.lang.Override
    public boolean hasStringValue() {
      return kindCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * The value of a tag field with a string type.
     *
     * The maximum length is 2000 UTF-8 characters.
     * </pre>
     *
     * <code>string string_value = 3;</code>
     *
     * @return The stringValue.
     */
    @java.lang.Override
    public java.lang.String getStringValue() {
      java.lang.Object ref = "";
      if (kindCase_ == 3) {
        ref = kind_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (kindCase_ == 3) {
          kind_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The value of a tag field with a string type.
     *
     * The maximum length is 2000 UTF-8 characters.
     * </pre>
     *
     * <code>string string_value = 3;</code>
     *
     * @return The bytes for stringValue.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getStringValueBytes() {
      java.lang.Object ref = "";
      if (kindCase_ == 3) {
        ref = kind_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (kindCase_ == 3) {
          kind_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The value of a tag field with a string type.
     *
     * The maximum length is 2000 UTF-8 characters.
     * </pre>
     *
     * <code>string string_value = 3;</code>
     *
     * @param value The stringValue to set.
     * @return This builder for chaining.
     */
    public Builder setStringValue(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kindCase_ = 3;
      kind_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The value of a tag field with a string type.
     *
     * The maximum length is 2000 UTF-8 characters.
     * </pre>
     *
     * <code>string string_value = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStringValue() {
      if (kindCase_ == 3) {
        kindCase_ = 0;
        kind_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The value of a tag field with a string type.
     *
     * The maximum length is 2000 UTF-8 characters.
     * </pre>
     *
     * <code>string string_value = 3;</code>
     *
     * @param value The bytes for stringValue to set.
     * @return This builder for chaining.
     */
    public Builder setStringValueBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kindCase_ = 3;
      kind_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The value of a tag field with a boolean type.
     * </pre>
     *
     * <code>bool bool_value = 4;</code>
     *
     * @return Whether the boolValue field is set.
     */
    public boolean hasBoolValue() {
      return kindCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * The value of a tag field with a boolean type.
     * </pre>
     *
     * <code>bool bool_value = 4;</code>
     *
     * @return The boolValue.
     */
    public boolean getBoolValue() {
      if (kindCase_ == 4) {
        return (java.lang.Boolean) kind_;
      }
      return false;
    }
    /**
     *
     *
     * <pre>
     * The value of a tag field with a boolean type.
     * </pre>
     *
     * <code>bool bool_value = 4;</code>
     *
     * @param value The boolValue to set.
     * @return This builder for chaining.
     */
    public Builder setBoolValue(boolean value) {

      kindCase_ = 4;
      kind_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The value of a tag field with a boolean type.
     * </pre>
     *
     * <code>bool bool_value = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBoolValue() {
      if (kindCase_ == 4) {
        kindCase_ = 0;
        kind_ = null;
        onChanged();
      }
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        timestampValueBuilder_;
    /**
     *
     *
     * <pre>
     * The value of a tag field with a timestamp type.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp_value = 5;</code>
     *
     * @return Whether the timestampValue field is set.
     */
    @java.lang.Override
    public boolean hasTimestampValue() {
      return kindCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * The value of a tag field with a timestamp type.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp_value = 5;</code>
     *
     * @return The timestampValue.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getTimestampValue() {
      if (timestampValueBuilder_ == null) {
        if (kindCase_ == 5) {
          return (com.google.protobuf.Timestamp) kind_;
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      } else {
        if (kindCase_ == 5) {
          return timestampValueBuilder_.getMessage();
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The value of a tag field with a timestamp type.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp_value = 5;</code>
     */
    public Builder setTimestampValue(com.google.protobuf.Timestamp value) {
      if (timestampValueBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        kind_ = value;
        onChanged();
      } else {
        timestampValueBuilder_.setMessage(value);
      }
      kindCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The value of a tag field with a timestamp type.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp_value = 5;</code>
     */
    public Builder setTimestampValue(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (timestampValueBuilder_ == null) {
        kind_ = builderForValue.build();
        onChanged();
      } else {
        timestampValueBuilder_.setMessage(builderForValue.build());
      }
      kindCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The value of a tag field with a timestamp type.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp_value = 5;</code>
     */
    public Builder mergeTimestampValue(com.google.protobuf.Timestamp value) {
      if (timestampValueBuilder_ == null) {
        if (kindCase_ == 5 && kind_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          kind_ =
              com.google.protobuf.Timestamp.newBuilder((com.google.protobuf.Timestamp) kind_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          kind_ = value;
        }
        onChanged();
      } else {
        if (kindCase_ == 5) {
          timestampValueBuilder_.mergeFrom(value);
        } else {
          timestampValueBuilder_.setMessage(value);
        }
      }
      kindCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The value of a tag field with a timestamp type.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp_value = 5;</code>
     */
    public Builder clearTimestampValue() {
      if (timestampValueBuilder_ == null) {
        if (kindCase_ == 5) {
          kindCase_ = 0;
          kind_ = null;
          onChanged();
        }
      } else {
        if (kindCase_ == 5) {
          kindCase_ = 0;
          kind_ = null;
        }
        timestampValueBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The value of a tag field with a timestamp type.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp_value = 5;</code>
     */
    public com.google.protobuf.Timestamp.Builder getTimestampValueBuilder() {
      return getTimestampValueFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The value of a tag field with a timestamp type.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp_value = 5;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getTimestampValueOrBuilder() {
      if ((kindCase_ == 5) && (timestampValueBuilder_ != null)) {
        return timestampValueBuilder_.getMessageOrBuilder();
      } else {
        if (kindCase_ == 5) {
          return (com.google.protobuf.Timestamp) kind_;
        }
        return com.google.protobuf.Timestamp.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The value of a tag field with a timestamp type.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp_value = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getTimestampValueFieldBuilder() {
      if (timestampValueBuilder_ == null) {
        if (!(kindCase_ == 5)) {
          kind_ = com.google.protobuf.Timestamp.getDefaultInstance();
        }
        timestampValueBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                (com.google.protobuf.Timestamp) kind_, getParentForChildren(), isClean());
        kind_ = null;
      }
      kindCase_ = 5;
      onChanged();
      return timestampValueBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.TagField.EnumValue,
            com.google.cloud.datacatalog.v1.TagField.EnumValue.Builder,
            com.google.cloud.datacatalog.v1.TagField.EnumValueOrBuilder>
        enumValueBuilder_;
    /**
     *
     *
     * <pre>
     * The value of a tag field with an enum type.
     *
     * This value must be one of the allowed values listed in this enum.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.TagField.EnumValue enum_value = 6;</code>
     *
     * @return Whether the enumValue field is set.
     */
    @java.lang.Override
    public boolean hasEnumValue() {
      return kindCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * The value of a tag field with an enum type.
     *
     * This value must be one of the allowed values listed in this enum.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.TagField.EnumValue enum_value = 6;</code>
     *
     * @return The enumValue.
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1.TagField.EnumValue getEnumValue() {
      if (enumValueBuilder_ == null) {
        if (kindCase_ == 6) {
          return (com.google.cloud.datacatalog.v1.TagField.EnumValue) kind_;
        }
        return com.google.cloud.datacatalog.v1.TagField.EnumValue.getDefaultInstance();
      } else {
        if (kindCase_ == 6) {
          return enumValueBuilder_.getMessage();
        }
        return com.google.cloud.datacatalog.v1.TagField.EnumValue.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The value of a tag field with an enum type.
     *
     * This value must be one of the allowed values listed in this enum.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.TagField.EnumValue enum_value = 6;</code>
     */
    public Builder setEnumValue(com.google.cloud.datacatalog.v1.TagField.EnumValue value) {
      if (enumValueBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        kind_ = value;
        onChanged();
      } else {
        enumValueBuilder_.setMessage(value);
      }
      kindCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The value of a tag field with an enum type.
     *
     * This value must be one of the allowed values listed in this enum.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.TagField.EnumValue enum_value = 6;</code>
     */
    public Builder setEnumValue(
        com.google.cloud.datacatalog.v1.TagField.EnumValue.Builder builderForValue) {
      if (enumValueBuilder_ == null) {
        kind_ = builderForValue.build();
        onChanged();
      } else {
        enumValueBuilder_.setMessage(builderForValue.build());
      }
      kindCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The value of a tag field with an enum type.
     *
     * This value must be one of the allowed values listed in this enum.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.TagField.EnumValue enum_value = 6;</code>
     */
    public Builder mergeEnumValue(com.google.cloud.datacatalog.v1.TagField.EnumValue value) {
      if (enumValueBuilder_ == null) {
        if (kindCase_ == 6
            && kind_ != com.google.cloud.datacatalog.v1.TagField.EnumValue.getDefaultInstance()) {
          kind_ =
              com.google.cloud.datacatalog.v1.TagField.EnumValue.newBuilder(
                      (com.google.cloud.datacatalog.v1.TagField.EnumValue) kind_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          kind_ = value;
        }
        onChanged();
      } else {
        if (kindCase_ == 6) {
          enumValueBuilder_.mergeFrom(value);
        } else {
          enumValueBuilder_.setMessage(value);
        }
      }
      kindCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The value of a tag field with an enum type.
     *
     * This value must be one of the allowed values listed in this enum.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.TagField.EnumValue enum_value = 6;</code>
     */
    public Builder clearEnumValue() {
      if (enumValueBuilder_ == null) {
        if (kindCase_ == 6) {
          kindCase_ = 0;
          kind_ = null;
          onChanged();
        }
      } else {
        if (kindCase_ == 6) {
          kindCase_ = 0;
          kind_ = null;
        }
        enumValueBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The value of a tag field with an enum type.
     *
     * This value must be one of the allowed values listed in this enum.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.TagField.EnumValue enum_value = 6;</code>
     */
    public com.google.cloud.datacatalog.v1.TagField.EnumValue.Builder getEnumValueBuilder() {
      return getEnumValueFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The value of a tag field with an enum type.
     *
     * This value must be one of the allowed values listed in this enum.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.TagField.EnumValue enum_value = 6;</code>
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1.TagField.EnumValueOrBuilder getEnumValueOrBuilder() {
      if ((kindCase_ == 6) && (enumValueBuilder_ != null)) {
        return enumValueBuilder_.getMessageOrBuilder();
      } else {
        if (kindCase_ == 6) {
          return (com.google.cloud.datacatalog.v1.TagField.EnumValue) kind_;
        }
        return com.google.cloud.datacatalog.v1.TagField.EnumValue.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The value of a tag field with an enum type.
     *
     * This value must be one of the allowed values listed in this enum.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1.TagField.EnumValue enum_value = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1.TagField.EnumValue,
            com.google.cloud.datacatalog.v1.TagField.EnumValue.Builder,
            com.google.cloud.datacatalog.v1.TagField.EnumValueOrBuilder>
        getEnumValueFieldBuilder() {
      if (enumValueBuilder_ == null) {
        if (!(kindCase_ == 6)) {
          kind_ = com.google.cloud.datacatalog.v1.TagField.EnumValue.getDefaultInstance();
        }
        enumValueBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datacatalog.v1.TagField.EnumValue,
                com.google.cloud.datacatalog.v1.TagField.EnumValue.Builder,
                com.google.cloud.datacatalog.v1.TagField.EnumValueOrBuilder>(
                (com.google.cloud.datacatalog.v1.TagField.EnumValue) kind_,
                getParentForChildren(),
                isClean());
        kind_ = null;
      }
      kindCase_ = 6;
      onChanged();
      return enumValueBuilder_;
    }

    /**
     *
     *
     * <pre>
     * The value of a tag field with a rich text type.
     *
     * The maximum length is 10 MiB as this value holds HTML descriptions
     * including encoded images. The maximum length of the text without images
     * is 100 KiB.
     * </pre>
     *
     * <code>string richtext_value = 8;</code>
     *
     * @return Whether the richtextValue field is set.
     */
    @java.lang.Override
    public boolean hasRichtextValue() {
      return kindCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * The value of a tag field with a rich text type.
     *
     * The maximum length is 10 MiB as this value holds HTML descriptions
     * including encoded images. The maximum length of the text without images
     * is 100 KiB.
     * </pre>
     *
     * <code>string richtext_value = 8;</code>
     *
     * @return The richtextValue.
     */
    @java.lang.Override
    public java.lang.String getRichtextValue() {
      java.lang.Object ref = "";
      if (kindCase_ == 8) {
        ref = kind_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (kindCase_ == 8) {
          kind_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The value of a tag field with a rich text type.
     *
     * The maximum length is 10 MiB as this value holds HTML descriptions
     * including encoded images. The maximum length of the text without images
     * is 100 KiB.
     * </pre>
     *
     * <code>string richtext_value = 8;</code>
     *
     * @return The bytes for richtextValue.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getRichtextValueBytes() {
      java.lang.Object ref = "";
      if (kindCase_ == 8) {
        ref = kind_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (kindCase_ == 8) {
          kind_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The value of a tag field with a rich text type.
     *
     * The maximum length is 10 MiB as this value holds HTML descriptions
     * including encoded images. The maximum length of the text without images
     * is 100 KiB.
     * </pre>
     *
     * <code>string richtext_value = 8;</code>
     *
     * @param value The richtextValue to set.
     * @return This builder for chaining.
     */
    public Builder setRichtextValue(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kindCase_ = 8;
      kind_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The value of a tag field with a rich text type.
     *
     * The maximum length is 10 MiB as this value holds HTML descriptions
     * including encoded images. The maximum length of the text without images
     * is 100 KiB.
     * </pre>
     *
     * <code>string richtext_value = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRichtextValue() {
      if (kindCase_ == 8) {
        kindCase_ = 0;
        kind_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The value of a tag field with a rich text type.
     *
     * The maximum length is 10 MiB as this value holds HTML descriptions
     * including encoded images. The maximum length of the text without images
     * is 100 KiB.
     * </pre>
     *
     * <code>string richtext_value = 8;</code>
     *
     * @param value The bytes for richtextValue to set.
     * @return This builder for chaining.
     */
    public Builder setRichtextValueBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kindCase_ = 8;
      kind_ = value;
      onChanged();
      return this;
    }

    private int order_;
    /**
     *
     *
     * <pre>
     * Output only. The order of this field with respect to other fields in this
     * tag. Can be set by
     * [Tag][google.cloud.datacatalog.v1.TagTemplateField.order].
     *
     * For example, a higher value can indicate a more important field.
     * The value can be negative. Multiple fields can have the same order, and
     * field orders within a tag don't have to be sequential.
     * </pre>
     *
     * <code>int32 order = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The order.
     */
    @java.lang.Override
    public int getOrder() {
      return order_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The order of this field with respect to other fields in this
     * tag. Can be set by
     * [Tag][google.cloud.datacatalog.v1.TagTemplateField.order].
     *
     * For example, a higher value can indicate a more important field.
     * The value can be negative. Multiple fields can have the same order, and
     * field orders within a tag don't have to be sequential.
     * </pre>
     *
     * <code>int32 order = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The order to set.
     * @return This builder for chaining.
     */
    public Builder setOrder(int value) {

      order_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The order of this field with respect to other fields in this
     * tag. Can be set by
     * [Tag][google.cloud.datacatalog.v1.TagTemplateField.order].
     *
     * For example, a higher value can indicate a more important field.
     * The value can be negative. Multiple fields can have the same order, and
     * field orders within a tag don't have to be sequential.
     * </pre>
     *
     * <code>int32 order = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOrder() {
      bitField0_ = (bitField0_ & ~0x00000080);
      order_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datacatalog.v1.TagField)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datacatalog.v1.TagField)
  private static final com.google.cloud.datacatalog.v1.TagField DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datacatalog.v1.TagField();
  }

  public static com.google.cloud.datacatalog.v1.TagField getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TagField> PARSER =
      new com.google.protobuf.AbstractParser<TagField>() {
        @java.lang.Override
        public TagField parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TagField> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TagField> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datacatalog.v1.TagField getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
