/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datacatalog.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TagTemplateFieldEnumValueName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_TAG_TEMPLATE_TAG_TEMPLATE_FIELD_ID_ENUM_VALUE_DISPLAY_NAME = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/tagTemplates/{tag_template}/fields/{tag_template_field_id}/enumValues/{enum_value_display_name}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String tagTemplate;
    private final String tagTemplateFieldId;
    private final String enumValueDisplayName;

    @Deprecated
    protected TagTemplateFieldEnumValueName() {
        this.project = null;
        this.location = null;
        this.tagTemplate = null;
        this.tagTemplateFieldId = null;
        this.enumValueDisplayName = null;
    }

    private TagTemplateFieldEnumValueName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.tagTemplate = (String)Preconditions.checkNotNull((Object)builder.getTagTemplate());
        this.tagTemplateFieldId = (String)Preconditions.checkNotNull((Object)builder.getTagTemplateFieldId());
        this.enumValueDisplayName = (String)Preconditions.checkNotNull((Object)builder.getEnumValueDisplayName());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getTagTemplate() {
        return this.tagTemplate;
    }

    public String getTagTemplateFieldId() {
        return this.tagTemplateFieldId;
    }

    public String getEnumValueDisplayName() {
        return this.enumValueDisplayName;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static TagTemplateFieldEnumValueName of(String project, String location, String tagTemplate, String tagTemplateFieldId, String enumValueDisplayName) {
        return TagTemplateFieldEnumValueName.newBuilder().setProject(project).setLocation(location).setTagTemplate(tagTemplate).setTagTemplateFieldId(tagTemplateFieldId).setEnumValueDisplayName(enumValueDisplayName).build();
    }

    public static String format(String project, String location, String tagTemplate, String tagTemplateFieldId, String enumValueDisplayName) {
        return TagTemplateFieldEnumValueName.newBuilder().setProject(project).setLocation(location).setTagTemplate(tagTemplate).setTagTemplateFieldId(tagTemplateFieldId).setEnumValueDisplayName(enumValueDisplayName).build().toString();
    }

    public static TagTemplateFieldEnumValueName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_TAG_TEMPLATE_TAG_TEMPLATE_FIELD_ID_ENUM_VALUE_DISPLAY_NAME.validatedMatch(formattedString, "TagTemplateFieldEnumValueName.parse: formattedString not in valid format");
        return TagTemplateFieldEnumValueName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("tag_template"), (String)matchMap.get("tag_template_field_id"), (String)matchMap.get("enum_value_display_name"));
    }

    public static List<TagTemplateFieldEnumValueName> parseList(List<String> formattedStrings) {
        ArrayList<TagTemplateFieldEnumValueName> list = new ArrayList<TagTemplateFieldEnumValueName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(TagTemplateFieldEnumValueName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<TagTemplateFieldEnumValueName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (TagTemplateFieldEnumValueName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_TAG_TEMPLATE_TAG_TEMPLATE_FIELD_ID_ENUM_VALUE_DISPLAY_NAME.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            TagTemplateFieldEnumValueName tagTemplateFieldEnumValueName = this;
            synchronized (tagTemplateFieldEnumValueName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.tagTemplate != null) {
                        fieldMapBuilder.put((Object)"tag_template", (Object)this.tagTemplate);
                    }
                    if (this.tagTemplateFieldId != null) {
                        fieldMapBuilder.put((Object)"tag_template_field_id", (Object)this.tagTemplateFieldId);
                    }
                    if (this.enumValueDisplayName != null) {
                        fieldMapBuilder.put((Object)"enum_value_display_name", (Object)this.enumValueDisplayName);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_TAG_TEMPLATE_TAG_TEMPLATE_FIELD_ID_ENUM_VALUE_DISPLAY_NAME.instantiate(new String[]{"project", this.project, "location", this.location, "tag_template", this.tagTemplate, "tag_template_field_id", this.tagTemplateFieldId, "enum_value_display_name", this.enumValueDisplayName});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            TagTemplateFieldEnumValueName that = (TagTemplateFieldEnumValueName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.tagTemplate, that.tagTemplate) && Objects.equals(this.tagTemplateFieldId, that.tagTemplateFieldId) && Objects.equals(this.enumValueDisplayName, that.enumValueDisplayName);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.tagTemplate);
        h *= 1000003;
        h ^= Objects.hashCode(this.tagTemplateFieldId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.enumValueDisplayName);
    }

    public static class Builder {
        private String project;
        private String location;
        private String tagTemplate;
        private String tagTemplateFieldId;
        private String enumValueDisplayName;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getTagTemplate() {
            return this.tagTemplate;
        }

        public String getTagTemplateFieldId() {
            return this.tagTemplateFieldId;
        }

        public String getEnumValueDisplayName() {
            return this.enumValueDisplayName;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setTagTemplate(String tagTemplate) {
            this.tagTemplate = tagTemplate;
            return this;
        }

        public Builder setTagTemplateFieldId(String tagTemplateFieldId) {
            this.tagTemplateFieldId = tagTemplateFieldId;
            return this;
        }

        public Builder setEnumValueDisplayName(String enumValueDisplayName) {
            this.enumValueDisplayName = enumValueDisplayName;
            return this;
        }

        private Builder(TagTemplateFieldEnumValueName tagTemplateFieldEnumValueName) {
            this.project = tagTemplateFieldEnumValueName.project;
            this.location = tagTemplateFieldEnumValueName.location;
            this.tagTemplate = tagTemplateFieldEnumValueName.tagTemplate;
            this.tagTemplateFieldId = tagTemplateFieldEnumValueName.tagTemplateFieldId;
            this.enumValueDisplayName = tagTemplateFieldEnumValueName.enumValueDisplayName;
        }

        public TagTemplateFieldEnumValueName build() {
            return new TagTemplateFieldEnumValueName(this);
        }
    }
}

