// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datacatalog/v1beta1/datacatalog.proto

package com.google.cloud.datacatalog;

/**
 *
 *
 * <pre>
 * Entry Metadata.
 * A Data Catalog Entry resource represents another resource in Google
 * Cloud Platform, such as a BigQuery dataset or a Cloud Pub/Sub topic.
 * Clients can use the `linked_resource` field in the Entry resource to refer to
 * the original resource ID of the source system.
 * An Entry resource contains resource details, such as its schema. An Entry can
 * also be used to attach flexible metadata, such as a
 * [Tag][google.cloud.datacatalog.v1beta1.Tag].
 * </pre>
 *
 * Protobuf type {@code google.cloud.datacatalog.v1beta1.Entry}
 */
public final class Entry extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datacatalog.v1beta1.Entry)
    EntryOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Entry.newBuilder() to construct.
  private Entry(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Entry() {
    name_ = "";
    linkedResource_ = "";
    displayName_ = "";
    description_ = "";
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private Entry(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 16:
            {
              int rawValue = input.readEnum();
              entryTypeCase_ = 2;
              entryType_ = rawValue;
              break;
            }
          case 26:
            {
              java.lang.String s = input.readStringRequireUtf8();

              displayName_ = s;
              break;
            }
          case 34:
            {
              java.lang.String s = input.readStringRequireUtf8();

              description_ = s;
              break;
            }
          case 42:
            {
              com.google.cloud.datacatalog.Schema.Builder subBuilder = null;
              if (schema_ != null) {
                subBuilder = schema_.toBuilder();
              }
              schema_ =
                  input.readMessage(
                      com.google.cloud.datacatalog.Schema.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(schema_);
                schema_ = subBuilder.buildPartial();
              }

              break;
            }
          case 50:
            {
              com.google.cloud.datacatalog.GcsFilesetSpec.Builder subBuilder = null;
              if (typeSpecCase_ == 6) {
                subBuilder = ((com.google.cloud.datacatalog.GcsFilesetSpec) typeSpec_).toBuilder();
              }
              typeSpec_ =
                  input.readMessage(
                      com.google.cloud.datacatalog.GcsFilesetSpec.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.cloud.datacatalog.GcsFilesetSpec) typeSpec_);
                typeSpec_ = subBuilder.buildPartial();
              }
              typeSpecCase_ = 6;
              break;
            }
          case 58:
            {
              com.google.cloud.datacatalog.SystemTimestamps.Builder subBuilder = null;
              if (sourceSystemTimestamps_ != null) {
                subBuilder = sourceSystemTimestamps_.toBuilder();
              }
              sourceSystemTimestamps_ =
                  input.readMessage(
                      com.google.cloud.datacatalog.SystemTimestamps.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(sourceSystemTimestamps_);
                sourceSystemTimestamps_ = subBuilder.buildPartial();
              }

              break;
            }
          case 74:
            {
              java.lang.String s = input.readStringRequireUtf8();

              linkedResource_ = s;
              break;
            }
          case 98:
            {
              com.google.cloud.datacatalog.BigQueryTableSpec.Builder subBuilder = null;
              if (typeSpecCase_ == 12) {
                subBuilder =
                    ((com.google.cloud.datacatalog.BigQueryTableSpec) typeSpec_).toBuilder();
              }
              typeSpec_ =
                  input.readMessage(
                      com.google.cloud.datacatalog.BigQueryTableSpec.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.cloud.datacatalog.BigQueryTableSpec) typeSpec_);
                typeSpec_ = subBuilder.buildPartial();
              }
              typeSpecCase_ = 12;
              break;
            }
          case 122:
            {
              com.google.cloud.datacatalog.BigQueryDateShardedSpec.Builder subBuilder = null;
              if (typeSpecCase_ == 15) {
                subBuilder =
                    ((com.google.cloud.datacatalog.BigQueryDateShardedSpec) typeSpec_).toBuilder();
              }
              typeSpec_ =
                  input.readMessage(
                      com.google.cloud.datacatalog.BigQueryDateShardedSpec.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.datacatalog.BigQueryDateShardedSpec) typeSpec_);
                typeSpec_ = subBuilder.buildPartial();
              }
              typeSpecCase_ = 15;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datacatalog.Datacatalog
        .internal_static_google_cloud_datacatalog_v1beta1_Entry_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datacatalog.Datacatalog
        .internal_static_google_cloud_datacatalog_v1beta1_Entry_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datacatalog.Entry.class,
            com.google.cloud.datacatalog.Entry.Builder.class);
  }

  private int entryTypeCase_ = 0;
  private java.lang.Object entryType_;

  public enum EntryTypeCase implements com.google.protobuf.Internal.EnumLite {
    TYPE(2),
    ENTRYTYPE_NOT_SET(0);
    private final int value;

    private EntryTypeCase(int value) {
      this.value = value;
    }
    /** @deprecated Use {@link #forNumber(int)} instead. */
    @java.lang.Deprecated
    public static EntryTypeCase valueOf(int value) {
      return forNumber(value);
    }

    public static EntryTypeCase forNumber(int value) {
      switch (value) {
        case 2:
          return TYPE;
        case 0:
          return ENTRYTYPE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public EntryTypeCase getEntryTypeCase() {
    return EntryTypeCase.forNumber(entryTypeCase_);
  }

  private int typeSpecCase_ = 0;
  private java.lang.Object typeSpec_;

  public enum TypeSpecCase implements com.google.protobuf.Internal.EnumLite {
    GCS_FILESET_SPEC(6),
    BIGQUERY_TABLE_SPEC(12),
    BIGQUERY_DATE_SHARDED_SPEC(15),
    TYPESPEC_NOT_SET(0);
    private final int value;

    private TypeSpecCase(int value) {
      this.value = value;
    }
    /** @deprecated Use {@link #forNumber(int)} instead. */
    @java.lang.Deprecated
    public static TypeSpecCase valueOf(int value) {
      return forNumber(value);
    }

    public static TypeSpecCase forNumber(int value) {
      switch (value) {
        case 6:
          return GCS_FILESET_SPEC;
        case 12:
          return BIGQUERY_TABLE_SPEC;
        case 15:
          return BIGQUERY_DATE_SHARDED_SPEC;
        case 0:
          return TYPESPEC_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public TypeSpecCase getTypeSpecCase() {
    return TypeSpecCase.forNumber(typeSpecCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Required when used in
   * [UpdateEntryRequest][google.cloud.datacatalog.v1beta1.UpdateEntryRequest].
   * The Data Catalog resource name of the entry in URL format. Example:
   * * projects/{project_id}/locations/{location}/entryGroups/{entry_group_id}/entries/{entry_id}
   * Note that this Entry and its child resources may not actually be stored in
   * the location in this name.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.resource_reference) = { ... }</code>
   */
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required when used in
   * [UpdateEntryRequest][google.cloud.datacatalog.v1beta1.UpdateEntryRequest].
   * The Data Catalog resource name of the entry in URL format. Example:
   * * projects/{project_id}/locations/{location}/entryGroups/{entry_group_id}/entries/{entry_id}
   * Note that this Entry and its child resources may not actually be stored in
   * the location in this name.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.resource_reference) = { ... }</code>
   */
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LINKED_RESOURCE_FIELD_NUMBER = 9;
  private volatile java.lang.Object linkedResource_;
  /**
   *
   *
   * <pre>
   * Output only. The resource this metadata entry refers to.
   * For Google Cloud Platform resources, `linked_resource` is the [full name of
   * the
   * resource](https://cloud.google.com/apis/design/resource_names#full_resource_name).
   * For example, the `linked_resource` for a table resource from BigQuery is:
   * * //bigquery.googleapis.com/projects/projectId/datasets/datasetId/tables/tableId
   * </pre>
   *
   * <code>string linked_resource = 9;</code>
   */
  public java.lang.String getLinkedResource() {
    java.lang.Object ref = linkedResource_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      linkedResource_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The resource this metadata entry refers to.
   * For Google Cloud Platform resources, `linked_resource` is the [full name of
   * the
   * resource](https://cloud.google.com/apis/design/resource_names#full_resource_name).
   * For example, the `linked_resource` for a table resource from BigQuery is:
   * * //bigquery.googleapis.com/projects/projectId/datasets/datasetId/tables/tableId
   * </pre>
   *
   * <code>string linked_resource = 9;</code>
   */
  public com.google.protobuf.ByteString getLinkedResourceBytes() {
    java.lang.Object ref = linkedResource_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      linkedResource_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TYPE_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * The type of the entry.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1beta1.EntryType type = 2;</code>
   */
  public int getTypeValue() {
    if (entryTypeCase_ == 2) {
      return (java.lang.Integer) entryType_;
    }
    return 0;
  }
  /**
   *
   *
   * <pre>
   * The type of the entry.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1beta1.EntryType type = 2;</code>
   */
  public com.google.cloud.datacatalog.EntryType getType() {
    if (entryTypeCase_ == 2) {
      @SuppressWarnings("deprecation")
      com.google.cloud.datacatalog.EntryType result =
          com.google.cloud.datacatalog.EntryType.valueOf((java.lang.Integer) entryType_);
      return result == null ? com.google.cloud.datacatalog.EntryType.UNRECOGNIZED : result;
    }
    return com.google.cloud.datacatalog.EntryType.ENTRY_TYPE_UNSPECIFIED;
  }

  public static final int GCS_FILESET_SPEC_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * Specification that applies to a Cloud Storage fileset. This is only valid
   * on entries of type FILESET.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1beta1.GcsFilesetSpec gcs_fileset_spec = 6;</code>
   */
  public boolean hasGcsFilesetSpec() {
    return typeSpecCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * Specification that applies to a Cloud Storage fileset. This is only valid
   * on entries of type FILESET.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1beta1.GcsFilesetSpec gcs_fileset_spec = 6;</code>
   */
  public com.google.cloud.datacatalog.GcsFilesetSpec getGcsFilesetSpec() {
    if (typeSpecCase_ == 6) {
      return (com.google.cloud.datacatalog.GcsFilesetSpec) typeSpec_;
    }
    return com.google.cloud.datacatalog.GcsFilesetSpec.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Specification that applies to a Cloud Storage fileset. This is only valid
   * on entries of type FILESET.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1beta1.GcsFilesetSpec gcs_fileset_spec = 6;</code>
   */
  public com.google.cloud.datacatalog.GcsFilesetSpecOrBuilder getGcsFilesetSpecOrBuilder() {
    if (typeSpecCase_ == 6) {
      return (com.google.cloud.datacatalog.GcsFilesetSpec) typeSpec_;
    }
    return com.google.cloud.datacatalog.GcsFilesetSpec.getDefaultInstance();
  }

  public static final int BIGQUERY_TABLE_SPEC_FIELD_NUMBER = 12;
  /**
   *
   *
   * <pre>
   * Specification that applies to a BigQuery table. This is only valid on
   * entries of type `TABLE`.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1beta1.BigQueryTableSpec bigquery_table_spec = 12;</code>
   */
  public boolean hasBigqueryTableSpec() {
    return typeSpecCase_ == 12;
  }
  /**
   *
   *
   * <pre>
   * Specification that applies to a BigQuery table. This is only valid on
   * entries of type `TABLE`.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1beta1.BigQueryTableSpec bigquery_table_spec = 12;</code>
   */
  public com.google.cloud.datacatalog.BigQueryTableSpec getBigqueryTableSpec() {
    if (typeSpecCase_ == 12) {
      return (com.google.cloud.datacatalog.BigQueryTableSpec) typeSpec_;
    }
    return com.google.cloud.datacatalog.BigQueryTableSpec.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Specification that applies to a BigQuery table. This is only valid on
   * entries of type `TABLE`.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1beta1.BigQueryTableSpec bigquery_table_spec = 12;</code>
   */
  public com.google.cloud.datacatalog.BigQueryTableSpecOrBuilder getBigqueryTableSpecOrBuilder() {
    if (typeSpecCase_ == 12) {
      return (com.google.cloud.datacatalog.BigQueryTableSpec) typeSpec_;
    }
    return com.google.cloud.datacatalog.BigQueryTableSpec.getDefaultInstance();
  }

  public static final int BIGQUERY_DATE_SHARDED_SPEC_FIELD_NUMBER = 15;
  /**
   *
   *
   * <pre>
   * Specification for a group of BigQuery tables with name pattern
   * `[prefix]YYYYMMDD`. Context:
   * https://cloud.google.com/bigquery/docs/partitioned-tables#partitioning_versus_sharding.
   * </pre>
   *
   * <code>
   * .google.cloud.datacatalog.v1beta1.BigQueryDateShardedSpec bigquery_date_sharded_spec = 15;
   * </code>
   */
  public boolean hasBigqueryDateShardedSpec() {
    return typeSpecCase_ == 15;
  }
  /**
   *
   *
   * <pre>
   * Specification for a group of BigQuery tables with name pattern
   * `[prefix]YYYYMMDD`. Context:
   * https://cloud.google.com/bigquery/docs/partitioned-tables#partitioning_versus_sharding.
   * </pre>
   *
   * <code>
   * .google.cloud.datacatalog.v1beta1.BigQueryDateShardedSpec bigquery_date_sharded_spec = 15;
   * </code>
   */
  public com.google.cloud.datacatalog.BigQueryDateShardedSpec getBigqueryDateShardedSpec() {
    if (typeSpecCase_ == 15) {
      return (com.google.cloud.datacatalog.BigQueryDateShardedSpec) typeSpec_;
    }
    return com.google.cloud.datacatalog.BigQueryDateShardedSpec.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Specification for a group of BigQuery tables with name pattern
   * `[prefix]YYYYMMDD`. Context:
   * https://cloud.google.com/bigquery/docs/partitioned-tables#partitioning_versus_sharding.
   * </pre>
   *
   * <code>
   * .google.cloud.datacatalog.v1beta1.BigQueryDateShardedSpec bigquery_date_sharded_spec = 15;
   * </code>
   */
  public com.google.cloud.datacatalog.BigQueryDateShardedSpecOrBuilder
      getBigqueryDateShardedSpecOrBuilder() {
    if (typeSpecCase_ == 15) {
      return (com.google.cloud.datacatalog.BigQueryDateShardedSpec) typeSpec_;
    }
    return com.google.cloud.datacatalog.BigQueryDateShardedSpec.getDefaultInstance();
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 3;
  private volatile java.lang.Object displayName_;
  /**
   *
   *
   * <pre>
   * Optional. Display information such as title and description. A short name
   * to identify the entry, for example, "Analytics Data - Jan 2011". Default
   * value is an empty string.
   * </pre>
   *
   * <code>string display_name = 3;</code>
   */
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Display information such as title and description. A short name
   * to identify the entry, for example, "Analytics Data - Jan 2011". Default
   * value is an empty string.
   * </pre>
   *
   * <code>string display_name = 3;</code>
   */
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 4;
  private volatile java.lang.Object description_;
  /**
   *
   *
   * <pre>
   * Optional. Entry description, which can consist of several sentences or
   * paragraphs that describe entry contents. Default value is an empty string.
   * </pre>
   *
   * <code>string description = 4;</code>
   */
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Entry description, which can consist of several sentences or
   * paragraphs that describe entry contents. Default value is an empty string.
   * </pre>
   *
   * <code>string description = 4;</code>
   */
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SCHEMA_FIELD_NUMBER = 5;
  private com.google.cloud.datacatalog.Schema schema_;
  /**
   *
   *
   * <pre>
   * Optional. Schema of the entry. An entry might not have any schema attached
   * to it.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1beta1.Schema schema = 5;</code>
   */
  public boolean hasSchema() {
    return schema_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Schema of the entry. An entry might not have any schema attached
   * to it.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1beta1.Schema schema = 5;</code>
   */
  public com.google.cloud.datacatalog.Schema getSchema() {
    return schema_ == null ? com.google.cloud.datacatalog.Schema.getDefaultInstance() : schema_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Schema of the entry. An entry might not have any schema attached
   * to it.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1beta1.Schema schema = 5;</code>
   */
  public com.google.cloud.datacatalog.SchemaOrBuilder getSchemaOrBuilder() {
    return getSchema();
  }

  public static final int SOURCE_SYSTEM_TIMESTAMPS_FIELD_NUMBER = 7;
  private com.google.cloud.datacatalog.SystemTimestamps sourceSystemTimestamps_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamps about the underlying Google Cloud Platform
   * resource, not about this Data Catalog Entry.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1beta1.SystemTimestamps source_system_timestamps = 7;</code>
   */
  public boolean hasSourceSystemTimestamps() {
    return sourceSystemTimestamps_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamps about the underlying Google Cloud Platform
   * resource, not about this Data Catalog Entry.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1beta1.SystemTimestamps source_system_timestamps = 7;</code>
   */
  public com.google.cloud.datacatalog.SystemTimestamps getSourceSystemTimestamps() {
    return sourceSystemTimestamps_ == null
        ? com.google.cloud.datacatalog.SystemTimestamps.getDefaultInstance()
        : sourceSystemTimestamps_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamps about the underlying Google Cloud Platform
   * resource, not about this Data Catalog Entry.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1beta1.SystemTimestamps source_system_timestamps = 7;</code>
   */
  public com.google.cloud.datacatalog.SystemTimestampsOrBuilder
      getSourceSystemTimestampsOrBuilder() {
    return getSourceSystemTimestamps();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (entryTypeCase_ == 2) {
      output.writeEnum(2, ((java.lang.Integer) entryType_));
    }
    if (!getDisplayNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, displayName_);
    }
    if (!getDescriptionBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, description_);
    }
    if (schema_ != null) {
      output.writeMessage(5, getSchema());
    }
    if (typeSpecCase_ == 6) {
      output.writeMessage(6, (com.google.cloud.datacatalog.GcsFilesetSpec) typeSpec_);
    }
    if (sourceSystemTimestamps_ != null) {
      output.writeMessage(7, getSourceSystemTimestamps());
    }
    if (!getLinkedResourceBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, linkedResource_);
    }
    if (typeSpecCase_ == 12) {
      output.writeMessage(12, (com.google.cloud.datacatalog.BigQueryTableSpec) typeSpec_);
    }
    if (typeSpecCase_ == 15) {
      output.writeMessage(15, (com.google.cloud.datacatalog.BigQueryDateShardedSpec) typeSpec_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (entryTypeCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeEnumSize(
              2, ((java.lang.Integer) entryType_));
    }
    if (!getDisplayNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, displayName_);
    }
    if (!getDescriptionBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, description_);
    }
    if (schema_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getSchema());
    }
    if (typeSpecCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloud.datacatalog.GcsFilesetSpec) typeSpec_);
    }
    if (sourceSystemTimestamps_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(7, getSourceSystemTimestamps());
    }
    if (!getLinkedResourceBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, linkedResource_);
    }
    if (typeSpecCase_ == 12) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              12, (com.google.cloud.datacatalog.BigQueryTableSpec) typeSpec_);
    }
    if (typeSpecCase_ == 15) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              15, (com.google.cloud.datacatalog.BigQueryDateShardedSpec) typeSpec_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datacatalog.Entry)) {
      return super.equals(obj);
    }
    com.google.cloud.datacatalog.Entry other = (com.google.cloud.datacatalog.Entry) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getLinkedResource().equals(other.getLinkedResource())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (hasSchema() != other.hasSchema()) return false;
    if (hasSchema()) {
      if (!getSchema().equals(other.getSchema())) return false;
    }
    if (hasSourceSystemTimestamps() != other.hasSourceSystemTimestamps()) return false;
    if (hasSourceSystemTimestamps()) {
      if (!getSourceSystemTimestamps().equals(other.getSourceSystemTimestamps())) return false;
    }
    if (!getEntryTypeCase().equals(other.getEntryTypeCase())) return false;
    switch (entryTypeCase_) {
      case 2:
        if (getTypeValue() != other.getTypeValue()) return false;
        break;
      case 0:
      default:
    }
    if (!getTypeSpecCase().equals(other.getTypeSpecCase())) return false;
    switch (typeSpecCase_) {
      case 6:
        if (!getGcsFilesetSpec().equals(other.getGcsFilesetSpec())) return false;
        break;
      case 12:
        if (!getBigqueryTableSpec().equals(other.getBigqueryTableSpec())) return false;
        break;
      case 15:
        if (!getBigqueryDateShardedSpec().equals(other.getBigqueryDateShardedSpec())) return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + LINKED_RESOURCE_FIELD_NUMBER;
    hash = (53 * hash) + getLinkedResource().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (hasSchema()) {
      hash = (37 * hash) + SCHEMA_FIELD_NUMBER;
      hash = (53 * hash) + getSchema().hashCode();
    }
    if (hasSourceSystemTimestamps()) {
      hash = (37 * hash) + SOURCE_SYSTEM_TIMESTAMPS_FIELD_NUMBER;
      hash = (53 * hash) + getSourceSystemTimestamps().hashCode();
    }
    switch (entryTypeCase_) {
      case 2:
        hash = (37 * hash) + TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getTypeValue();
        break;
      case 0:
      default:
    }
    switch (typeSpecCase_) {
      case 6:
        hash = (37 * hash) + GCS_FILESET_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getGcsFilesetSpec().hashCode();
        break;
      case 12:
        hash = (37 * hash) + BIGQUERY_TABLE_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getBigqueryTableSpec().hashCode();
        break;
      case 15:
        hash = (37 * hash) + BIGQUERY_DATE_SHARDED_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getBigqueryDateShardedSpec().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datacatalog.Entry parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.Entry parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.Entry parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.Entry parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.Entry parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.Entry parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.Entry parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.Entry parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.Entry parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.Entry parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.Entry parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.Entry parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.datacatalog.Entry prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Entry Metadata.
   * A Data Catalog Entry resource represents another resource in Google
   * Cloud Platform, such as a BigQuery dataset or a Cloud Pub/Sub topic.
   * Clients can use the `linked_resource` field in the Entry resource to refer to
   * the original resource ID of the source system.
   * An Entry resource contains resource details, such as its schema. An Entry can
   * also be used to attach flexible metadata, such as a
   * [Tag][google.cloud.datacatalog.v1beta1.Tag].
   * </pre>
   *
   * Protobuf type {@code google.cloud.datacatalog.v1beta1.Entry}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datacatalog.v1beta1.Entry)
      com.google.cloud.datacatalog.EntryOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datacatalog.Datacatalog
          .internal_static_google_cloud_datacatalog_v1beta1_Entry_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datacatalog.Datacatalog
          .internal_static_google_cloud_datacatalog_v1beta1_Entry_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datacatalog.Entry.class,
              com.google.cloud.datacatalog.Entry.Builder.class);
    }

    // Construct using com.google.cloud.datacatalog.Entry.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      linkedResource_ = "";

      displayName_ = "";

      description_ = "";

      if (schemaBuilder_ == null) {
        schema_ = null;
      } else {
        schema_ = null;
        schemaBuilder_ = null;
      }
      if (sourceSystemTimestampsBuilder_ == null) {
        sourceSystemTimestamps_ = null;
      } else {
        sourceSystemTimestamps_ = null;
        sourceSystemTimestampsBuilder_ = null;
      }
      entryTypeCase_ = 0;
      entryType_ = null;
      typeSpecCase_ = 0;
      typeSpec_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datacatalog.Datacatalog
          .internal_static_google_cloud_datacatalog_v1beta1_Entry_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.Entry getDefaultInstanceForType() {
      return com.google.cloud.datacatalog.Entry.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.Entry build() {
      com.google.cloud.datacatalog.Entry result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.Entry buildPartial() {
      com.google.cloud.datacatalog.Entry result = new com.google.cloud.datacatalog.Entry(this);
      result.name_ = name_;
      result.linkedResource_ = linkedResource_;
      if (entryTypeCase_ == 2) {
        result.entryType_ = entryType_;
      }
      if (typeSpecCase_ == 6) {
        if (gcsFilesetSpecBuilder_ == null) {
          result.typeSpec_ = typeSpec_;
        } else {
          result.typeSpec_ = gcsFilesetSpecBuilder_.build();
        }
      }
      if (typeSpecCase_ == 12) {
        if (bigqueryTableSpecBuilder_ == null) {
          result.typeSpec_ = typeSpec_;
        } else {
          result.typeSpec_ = bigqueryTableSpecBuilder_.build();
        }
      }
      if (typeSpecCase_ == 15) {
        if (bigqueryDateShardedSpecBuilder_ == null) {
          result.typeSpec_ = typeSpec_;
        } else {
          result.typeSpec_ = bigqueryDateShardedSpecBuilder_.build();
        }
      }
      result.displayName_ = displayName_;
      result.description_ = description_;
      if (schemaBuilder_ == null) {
        result.schema_ = schema_;
      } else {
        result.schema_ = schemaBuilder_.build();
      }
      if (sourceSystemTimestampsBuilder_ == null) {
        result.sourceSystemTimestamps_ = sourceSystemTimestamps_;
      } else {
        result.sourceSystemTimestamps_ = sourceSystemTimestampsBuilder_.build();
      }
      result.entryTypeCase_ = entryTypeCase_;
      result.typeSpecCase_ = typeSpecCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datacatalog.Entry) {
        return mergeFrom((com.google.cloud.datacatalog.Entry) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datacatalog.Entry other) {
      if (other == com.google.cloud.datacatalog.Entry.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getLinkedResource().isEmpty()) {
        linkedResource_ = other.linkedResource_;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        onChanged();
      }
      if (other.hasSchema()) {
        mergeSchema(other.getSchema());
      }
      if (other.hasSourceSystemTimestamps()) {
        mergeSourceSystemTimestamps(other.getSourceSystemTimestamps());
      }
      switch (other.getEntryTypeCase()) {
        case TYPE:
          {
            setTypeValue(other.getTypeValue());
            break;
          }
        case ENTRYTYPE_NOT_SET:
          {
            break;
          }
      }
      switch (other.getTypeSpecCase()) {
        case GCS_FILESET_SPEC:
          {
            mergeGcsFilesetSpec(other.getGcsFilesetSpec());
            break;
          }
        case BIGQUERY_TABLE_SPEC:
          {
            mergeBigqueryTableSpec(other.getBigqueryTableSpec());
            break;
          }
        case BIGQUERY_DATE_SHARDED_SPEC:
          {
            mergeBigqueryDateShardedSpec(other.getBigqueryDateShardedSpec());
            break;
          }
        case TYPESPEC_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.datacatalog.Entry parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.datacatalog.Entry) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int entryTypeCase_ = 0;
    private java.lang.Object entryType_;

    public EntryTypeCase getEntryTypeCase() {
      return EntryTypeCase.forNumber(entryTypeCase_);
    }

    public Builder clearEntryType() {
      entryTypeCase_ = 0;
      entryType_ = null;
      onChanged();
      return this;
    }

    private int typeSpecCase_ = 0;
    private java.lang.Object typeSpec_;

    public TypeSpecCase getTypeSpecCase() {
      return TypeSpecCase.forNumber(typeSpecCase_);
    }

    public Builder clearTypeSpec() {
      typeSpecCase_ = 0;
      typeSpec_ = null;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required when used in
     * [UpdateEntryRequest][google.cloud.datacatalog.v1beta1.UpdateEntryRequest].
     * The Data Catalog resource name of the entry in URL format. Example:
     * * projects/{project_id}/locations/{location}/entryGroups/{entry_group_id}/entries/{entry_id}
     * Note that this Entry and its child resources may not actually be stored in
     * the location in this name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.resource_reference) = { ... }</code>
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required when used in
     * [UpdateEntryRequest][google.cloud.datacatalog.v1beta1.UpdateEntryRequest].
     * The Data Catalog resource name of the entry in URL format. Example:
     * * projects/{project_id}/locations/{location}/entryGroups/{entry_group_id}/entries/{entry_id}
     * Note that this Entry and its child resources may not actually be stored in
     * the location in this name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.resource_reference) = { ... }</code>
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required when used in
     * [UpdateEntryRequest][google.cloud.datacatalog.v1beta1.UpdateEntryRequest].
     * The Data Catalog resource name of the entry in URL format. Example:
     * * projects/{project_id}/locations/{location}/entryGroups/{entry_group_id}/entries/{entry_id}
     * Note that this Entry and its child resources may not actually be stored in
     * the location in this name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.resource_reference) = { ... }</code>
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required when used in
     * [UpdateEntryRequest][google.cloud.datacatalog.v1beta1.UpdateEntryRequest].
     * The Data Catalog resource name of the entry in URL format. Example:
     * * projects/{project_id}/locations/{location}/entryGroups/{entry_group_id}/entries/{entry_id}
     * Note that this Entry and its child resources may not actually be stored in
     * the location in this name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.resource_reference) = { ... }</code>
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required when used in
     * [UpdateEntryRequest][google.cloud.datacatalog.v1beta1.UpdateEntryRequest].
     * The Data Catalog resource name of the entry in URL format. Example:
     * * projects/{project_id}/locations/{location}/entryGroups/{entry_group_id}/entries/{entry_id}
     * Note that this Entry and its child resources may not actually be stored in
     * the location in this name.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.resource_reference) = { ... }</code>
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object linkedResource_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The resource this metadata entry refers to.
     * For Google Cloud Platform resources, `linked_resource` is the [full name of
     * the
     * resource](https://cloud.google.com/apis/design/resource_names#full_resource_name).
     * For example, the `linked_resource` for a table resource from BigQuery is:
     * * //bigquery.googleapis.com/projects/projectId/datasets/datasetId/tables/tableId
     * </pre>
     *
     * <code>string linked_resource = 9;</code>
     */
    public java.lang.String getLinkedResource() {
      java.lang.Object ref = linkedResource_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        linkedResource_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource this metadata entry refers to.
     * For Google Cloud Platform resources, `linked_resource` is the [full name of
     * the
     * resource](https://cloud.google.com/apis/design/resource_names#full_resource_name).
     * For example, the `linked_resource` for a table resource from BigQuery is:
     * * //bigquery.googleapis.com/projects/projectId/datasets/datasetId/tables/tableId
     * </pre>
     *
     * <code>string linked_resource = 9;</code>
     */
    public com.google.protobuf.ByteString getLinkedResourceBytes() {
      java.lang.Object ref = linkedResource_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        linkedResource_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource this metadata entry refers to.
     * For Google Cloud Platform resources, `linked_resource` is the [full name of
     * the
     * resource](https://cloud.google.com/apis/design/resource_names#full_resource_name).
     * For example, the `linked_resource` for a table resource from BigQuery is:
     * * //bigquery.googleapis.com/projects/projectId/datasets/datasetId/tables/tableId
     * </pre>
     *
     * <code>string linked_resource = 9;</code>
     */
    public Builder setLinkedResource(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      linkedResource_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource this metadata entry refers to.
     * For Google Cloud Platform resources, `linked_resource` is the [full name of
     * the
     * resource](https://cloud.google.com/apis/design/resource_names#full_resource_name).
     * For example, the `linked_resource` for a table resource from BigQuery is:
     * * //bigquery.googleapis.com/projects/projectId/datasets/datasetId/tables/tableId
     * </pre>
     *
     * <code>string linked_resource = 9;</code>
     */
    public Builder clearLinkedResource() {

      linkedResource_ = getDefaultInstance().getLinkedResource();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The resource this metadata entry refers to.
     * For Google Cloud Platform resources, `linked_resource` is the [full name of
     * the
     * resource](https://cloud.google.com/apis/design/resource_names#full_resource_name).
     * For example, the `linked_resource` for a table resource from BigQuery is:
     * * //bigquery.googleapis.com/projects/projectId/datasets/datasetId/tables/tableId
     * </pre>
     *
     * <code>string linked_resource = 9;</code>
     */
    public Builder setLinkedResourceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      linkedResource_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The type of the entry.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.EntryType type = 2;</code>
     */
    public int getTypeValue() {
      if (entryTypeCase_ == 2) {
        return ((java.lang.Integer) entryType_).intValue();
      }
      return 0;
    }
    /**
     *
     *
     * <pre>
     * The type of the entry.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.EntryType type = 2;</code>
     */
    public Builder setTypeValue(int value) {
      entryTypeCase_ = 2;
      entryType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of the entry.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.EntryType type = 2;</code>
     */
    public com.google.cloud.datacatalog.EntryType getType() {
      if (entryTypeCase_ == 2) {
        @SuppressWarnings("deprecation")
        com.google.cloud.datacatalog.EntryType result =
            com.google.cloud.datacatalog.EntryType.valueOf((java.lang.Integer) entryType_);
        return result == null ? com.google.cloud.datacatalog.EntryType.UNRECOGNIZED : result;
      }
      return com.google.cloud.datacatalog.EntryType.ENTRY_TYPE_UNSPECIFIED;
    }
    /**
     *
     *
     * <pre>
     * The type of the entry.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.EntryType type = 2;</code>
     */
    public Builder setType(com.google.cloud.datacatalog.EntryType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      entryTypeCase_ = 2;
      entryType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of the entry.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.EntryType type = 2;</code>
     */
    public Builder clearType() {
      if (entryTypeCase_ == 2) {
        entryTypeCase_ = 0;
        entryType_ = null;
        onChanged();
      }
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.GcsFilesetSpec,
            com.google.cloud.datacatalog.GcsFilesetSpec.Builder,
            com.google.cloud.datacatalog.GcsFilesetSpecOrBuilder>
        gcsFilesetSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Specification that applies to a Cloud Storage fileset. This is only valid
     * on entries of type FILESET.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.GcsFilesetSpec gcs_fileset_spec = 6;</code>
     */
    public boolean hasGcsFilesetSpec() {
      return typeSpecCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a Cloud Storage fileset. This is only valid
     * on entries of type FILESET.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.GcsFilesetSpec gcs_fileset_spec = 6;</code>
     */
    public com.google.cloud.datacatalog.GcsFilesetSpec getGcsFilesetSpec() {
      if (gcsFilesetSpecBuilder_ == null) {
        if (typeSpecCase_ == 6) {
          return (com.google.cloud.datacatalog.GcsFilesetSpec) typeSpec_;
        }
        return com.google.cloud.datacatalog.GcsFilesetSpec.getDefaultInstance();
      } else {
        if (typeSpecCase_ == 6) {
          return gcsFilesetSpecBuilder_.getMessage();
        }
        return com.google.cloud.datacatalog.GcsFilesetSpec.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a Cloud Storage fileset. This is only valid
     * on entries of type FILESET.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.GcsFilesetSpec gcs_fileset_spec = 6;</code>
     */
    public Builder setGcsFilesetSpec(com.google.cloud.datacatalog.GcsFilesetSpec value) {
      if (gcsFilesetSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        typeSpec_ = value;
        onChanged();
      } else {
        gcsFilesetSpecBuilder_.setMessage(value);
      }
      typeSpecCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a Cloud Storage fileset. This is only valid
     * on entries of type FILESET.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.GcsFilesetSpec gcs_fileset_spec = 6;</code>
     */
    public Builder setGcsFilesetSpec(
        com.google.cloud.datacatalog.GcsFilesetSpec.Builder builderForValue) {
      if (gcsFilesetSpecBuilder_ == null) {
        typeSpec_ = builderForValue.build();
        onChanged();
      } else {
        gcsFilesetSpecBuilder_.setMessage(builderForValue.build());
      }
      typeSpecCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a Cloud Storage fileset. This is only valid
     * on entries of type FILESET.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.GcsFilesetSpec gcs_fileset_spec = 6;</code>
     */
    public Builder mergeGcsFilesetSpec(com.google.cloud.datacatalog.GcsFilesetSpec value) {
      if (gcsFilesetSpecBuilder_ == null) {
        if (typeSpecCase_ == 6
            && typeSpec_ != com.google.cloud.datacatalog.GcsFilesetSpec.getDefaultInstance()) {
          typeSpec_ =
              com.google.cloud.datacatalog.GcsFilesetSpec.newBuilder(
                      (com.google.cloud.datacatalog.GcsFilesetSpec) typeSpec_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          typeSpec_ = value;
        }
        onChanged();
      } else {
        if (typeSpecCase_ == 6) {
          gcsFilesetSpecBuilder_.mergeFrom(value);
        }
        gcsFilesetSpecBuilder_.setMessage(value);
      }
      typeSpecCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a Cloud Storage fileset. This is only valid
     * on entries of type FILESET.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.GcsFilesetSpec gcs_fileset_spec = 6;</code>
     */
    public Builder clearGcsFilesetSpec() {
      if (gcsFilesetSpecBuilder_ == null) {
        if (typeSpecCase_ == 6) {
          typeSpecCase_ = 0;
          typeSpec_ = null;
          onChanged();
        }
      } else {
        if (typeSpecCase_ == 6) {
          typeSpecCase_ = 0;
          typeSpec_ = null;
        }
        gcsFilesetSpecBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a Cloud Storage fileset. This is only valid
     * on entries of type FILESET.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.GcsFilesetSpec gcs_fileset_spec = 6;</code>
     */
    public com.google.cloud.datacatalog.GcsFilesetSpec.Builder getGcsFilesetSpecBuilder() {
      return getGcsFilesetSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a Cloud Storage fileset. This is only valid
     * on entries of type FILESET.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.GcsFilesetSpec gcs_fileset_spec = 6;</code>
     */
    public com.google.cloud.datacatalog.GcsFilesetSpecOrBuilder getGcsFilesetSpecOrBuilder() {
      if ((typeSpecCase_ == 6) && (gcsFilesetSpecBuilder_ != null)) {
        return gcsFilesetSpecBuilder_.getMessageOrBuilder();
      } else {
        if (typeSpecCase_ == 6) {
          return (com.google.cloud.datacatalog.GcsFilesetSpec) typeSpec_;
        }
        return com.google.cloud.datacatalog.GcsFilesetSpec.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a Cloud Storage fileset. This is only valid
     * on entries of type FILESET.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.GcsFilesetSpec gcs_fileset_spec = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.GcsFilesetSpec,
            com.google.cloud.datacatalog.GcsFilesetSpec.Builder,
            com.google.cloud.datacatalog.GcsFilesetSpecOrBuilder>
        getGcsFilesetSpecFieldBuilder() {
      if (gcsFilesetSpecBuilder_ == null) {
        if (!(typeSpecCase_ == 6)) {
          typeSpec_ = com.google.cloud.datacatalog.GcsFilesetSpec.getDefaultInstance();
        }
        gcsFilesetSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datacatalog.GcsFilesetSpec,
                com.google.cloud.datacatalog.GcsFilesetSpec.Builder,
                com.google.cloud.datacatalog.GcsFilesetSpecOrBuilder>(
                (com.google.cloud.datacatalog.GcsFilesetSpec) typeSpec_,
                getParentForChildren(),
                isClean());
        typeSpec_ = null;
      }
      typeSpecCase_ = 6;
      onChanged();
      ;
      return gcsFilesetSpecBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.BigQueryTableSpec,
            com.google.cloud.datacatalog.BigQueryTableSpec.Builder,
            com.google.cloud.datacatalog.BigQueryTableSpecOrBuilder>
        bigqueryTableSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Specification that applies to a BigQuery table. This is only valid on
     * entries of type `TABLE`.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.BigQueryTableSpec bigquery_table_spec = 12;</code>
     */
    public boolean hasBigqueryTableSpec() {
      return typeSpecCase_ == 12;
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a BigQuery table. This is only valid on
     * entries of type `TABLE`.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.BigQueryTableSpec bigquery_table_spec = 12;</code>
     */
    public com.google.cloud.datacatalog.BigQueryTableSpec getBigqueryTableSpec() {
      if (bigqueryTableSpecBuilder_ == null) {
        if (typeSpecCase_ == 12) {
          return (com.google.cloud.datacatalog.BigQueryTableSpec) typeSpec_;
        }
        return com.google.cloud.datacatalog.BigQueryTableSpec.getDefaultInstance();
      } else {
        if (typeSpecCase_ == 12) {
          return bigqueryTableSpecBuilder_.getMessage();
        }
        return com.google.cloud.datacatalog.BigQueryTableSpec.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a BigQuery table. This is only valid on
     * entries of type `TABLE`.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.BigQueryTableSpec bigquery_table_spec = 12;</code>
     */
    public Builder setBigqueryTableSpec(com.google.cloud.datacatalog.BigQueryTableSpec value) {
      if (bigqueryTableSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        typeSpec_ = value;
        onChanged();
      } else {
        bigqueryTableSpecBuilder_.setMessage(value);
      }
      typeSpecCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a BigQuery table. This is only valid on
     * entries of type `TABLE`.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.BigQueryTableSpec bigquery_table_spec = 12;</code>
     */
    public Builder setBigqueryTableSpec(
        com.google.cloud.datacatalog.BigQueryTableSpec.Builder builderForValue) {
      if (bigqueryTableSpecBuilder_ == null) {
        typeSpec_ = builderForValue.build();
        onChanged();
      } else {
        bigqueryTableSpecBuilder_.setMessage(builderForValue.build());
      }
      typeSpecCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a BigQuery table. This is only valid on
     * entries of type `TABLE`.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.BigQueryTableSpec bigquery_table_spec = 12;</code>
     */
    public Builder mergeBigqueryTableSpec(com.google.cloud.datacatalog.BigQueryTableSpec value) {
      if (bigqueryTableSpecBuilder_ == null) {
        if (typeSpecCase_ == 12
            && typeSpec_ != com.google.cloud.datacatalog.BigQueryTableSpec.getDefaultInstance()) {
          typeSpec_ =
              com.google.cloud.datacatalog.BigQueryTableSpec.newBuilder(
                      (com.google.cloud.datacatalog.BigQueryTableSpec) typeSpec_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          typeSpec_ = value;
        }
        onChanged();
      } else {
        if (typeSpecCase_ == 12) {
          bigqueryTableSpecBuilder_.mergeFrom(value);
        }
        bigqueryTableSpecBuilder_.setMessage(value);
      }
      typeSpecCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a BigQuery table. This is only valid on
     * entries of type `TABLE`.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.BigQueryTableSpec bigquery_table_spec = 12;</code>
     */
    public Builder clearBigqueryTableSpec() {
      if (bigqueryTableSpecBuilder_ == null) {
        if (typeSpecCase_ == 12) {
          typeSpecCase_ = 0;
          typeSpec_ = null;
          onChanged();
        }
      } else {
        if (typeSpecCase_ == 12) {
          typeSpecCase_ = 0;
          typeSpec_ = null;
        }
        bigqueryTableSpecBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a BigQuery table. This is only valid on
     * entries of type `TABLE`.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.BigQueryTableSpec bigquery_table_spec = 12;</code>
     */
    public com.google.cloud.datacatalog.BigQueryTableSpec.Builder getBigqueryTableSpecBuilder() {
      return getBigqueryTableSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a BigQuery table. This is only valid on
     * entries of type `TABLE`.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.BigQueryTableSpec bigquery_table_spec = 12;</code>
     */
    public com.google.cloud.datacatalog.BigQueryTableSpecOrBuilder getBigqueryTableSpecOrBuilder() {
      if ((typeSpecCase_ == 12) && (bigqueryTableSpecBuilder_ != null)) {
        return bigqueryTableSpecBuilder_.getMessageOrBuilder();
      } else {
        if (typeSpecCase_ == 12) {
          return (com.google.cloud.datacatalog.BigQueryTableSpec) typeSpec_;
        }
        return com.google.cloud.datacatalog.BigQueryTableSpec.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Specification that applies to a BigQuery table. This is only valid on
     * entries of type `TABLE`.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.BigQueryTableSpec bigquery_table_spec = 12;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.BigQueryTableSpec,
            com.google.cloud.datacatalog.BigQueryTableSpec.Builder,
            com.google.cloud.datacatalog.BigQueryTableSpecOrBuilder>
        getBigqueryTableSpecFieldBuilder() {
      if (bigqueryTableSpecBuilder_ == null) {
        if (!(typeSpecCase_ == 12)) {
          typeSpec_ = com.google.cloud.datacatalog.BigQueryTableSpec.getDefaultInstance();
        }
        bigqueryTableSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datacatalog.BigQueryTableSpec,
                com.google.cloud.datacatalog.BigQueryTableSpec.Builder,
                com.google.cloud.datacatalog.BigQueryTableSpecOrBuilder>(
                (com.google.cloud.datacatalog.BigQueryTableSpec) typeSpec_,
                getParentForChildren(),
                isClean());
        typeSpec_ = null;
      }
      typeSpecCase_ = 12;
      onChanged();
      ;
      return bigqueryTableSpecBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.BigQueryDateShardedSpec,
            com.google.cloud.datacatalog.BigQueryDateShardedSpec.Builder,
            com.google.cloud.datacatalog.BigQueryDateShardedSpecOrBuilder>
        bigqueryDateShardedSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Specification for a group of BigQuery tables with name pattern
     * `[prefix]YYYYMMDD`. Context:
     * https://cloud.google.com/bigquery/docs/partitioned-tables#partitioning_versus_sharding.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1beta1.BigQueryDateShardedSpec bigquery_date_sharded_spec = 15;
     * </code>
     */
    public boolean hasBigqueryDateShardedSpec() {
      return typeSpecCase_ == 15;
    }
    /**
     *
     *
     * <pre>
     * Specification for a group of BigQuery tables with name pattern
     * `[prefix]YYYYMMDD`. Context:
     * https://cloud.google.com/bigquery/docs/partitioned-tables#partitioning_versus_sharding.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1beta1.BigQueryDateShardedSpec bigquery_date_sharded_spec = 15;
     * </code>
     */
    public com.google.cloud.datacatalog.BigQueryDateShardedSpec getBigqueryDateShardedSpec() {
      if (bigqueryDateShardedSpecBuilder_ == null) {
        if (typeSpecCase_ == 15) {
          return (com.google.cloud.datacatalog.BigQueryDateShardedSpec) typeSpec_;
        }
        return com.google.cloud.datacatalog.BigQueryDateShardedSpec.getDefaultInstance();
      } else {
        if (typeSpecCase_ == 15) {
          return bigqueryDateShardedSpecBuilder_.getMessage();
        }
        return com.google.cloud.datacatalog.BigQueryDateShardedSpec.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Specification for a group of BigQuery tables with name pattern
     * `[prefix]YYYYMMDD`. Context:
     * https://cloud.google.com/bigquery/docs/partitioned-tables#partitioning_versus_sharding.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1beta1.BigQueryDateShardedSpec bigquery_date_sharded_spec = 15;
     * </code>
     */
    public Builder setBigqueryDateShardedSpec(
        com.google.cloud.datacatalog.BigQueryDateShardedSpec value) {
      if (bigqueryDateShardedSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        typeSpec_ = value;
        onChanged();
      } else {
        bigqueryDateShardedSpecBuilder_.setMessage(value);
      }
      typeSpecCase_ = 15;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specification for a group of BigQuery tables with name pattern
     * `[prefix]YYYYMMDD`. Context:
     * https://cloud.google.com/bigquery/docs/partitioned-tables#partitioning_versus_sharding.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1beta1.BigQueryDateShardedSpec bigquery_date_sharded_spec = 15;
     * </code>
     */
    public Builder setBigqueryDateShardedSpec(
        com.google.cloud.datacatalog.BigQueryDateShardedSpec.Builder builderForValue) {
      if (bigqueryDateShardedSpecBuilder_ == null) {
        typeSpec_ = builderForValue.build();
        onChanged();
      } else {
        bigqueryDateShardedSpecBuilder_.setMessage(builderForValue.build());
      }
      typeSpecCase_ = 15;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specification for a group of BigQuery tables with name pattern
     * `[prefix]YYYYMMDD`. Context:
     * https://cloud.google.com/bigquery/docs/partitioned-tables#partitioning_versus_sharding.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1beta1.BigQueryDateShardedSpec bigquery_date_sharded_spec = 15;
     * </code>
     */
    public Builder mergeBigqueryDateShardedSpec(
        com.google.cloud.datacatalog.BigQueryDateShardedSpec value) {
      if (bigqueryDateShardedSpecBuilder_ == null) {
        if (typeSpecCase_ == 15
            && typeSpec_
                != com.google.cloud.datacatalog.BigQueryDateShardedSpec.getDefaultInstance()) {
          typeSpec_ =
              com.google.cloud.datacatalog.BigQueryDateShardedSpec.newBuilder(
                      (com.google.cloud.datacatalog.BigQueryDateShardedSpec) typeSpec_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          typeSpec_ = value;
        }
        onChanged();
      } else {
        if (typeSpecCase_ == 15) {
          bigqueryDateShardedSpecBuilder_.mergeFrom(value);
        }
        bigqueryDateShardedSpecBuilder_.setMessage(value);
      }
      typeSpecCase_ = 15;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specification for a group of BigQuery tables with name pattern
     * `[prefix]YYYYMMDD`. Context:
     * https://cloud.google.com/bigquery/docs/partitioned-tables#partitioning_versus_sharding.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1beta1.BigQueryDateShardedSpec bigquery_date_sharded_spec = 15;
     * </code>
     */
    public Builder clearBigqueryDateShardedSpec() {
      if (bigqueryDateShardedSpecBuilder_ == null) {
        if (typeSpecCase_ == 15) {
          typeSpecCase_ = 0;
          typeSpec_ = null;
          onChanged();
        }
      } else {
        if (typeSpecCase_ == 15) {
          typeSpecCase_ = 0;
          typeSpec_ = null;
        }
        bigqueryDateShardedSpecBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specification for a group of BigQuery tables with name pattern
     * `[prefix]YYYYMMDD`. Context:
     * https://cloud.google.com/bigquery/docs/partitioned-tables#partitioning_versus_sharding.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1beta1.BigQueryDateShardedSpec bigquery_date_sharded_spec = 15;
     * </code>
     */
    public com.google.cloud.datacatalog.BigQueryDateShardedSpec.Builder
        getBigqueryDateShardedSpecBuilder() {
      return getBigqueryDateShardedSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Specification for a group of BigQuery tables with name pattern
     * `[prefix]YYYYMMDD`. Context:
     * https://cloud.google.com/bigquery/docs/partitioned-tables#partitioning_versus_sharding.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1beta1.BigQueryDateShardedSpec bigquery_date_sharded_spec = 15;
     * </code>
     */
    public com.google.cloud.datacatalog.BigQueryDateShardedSpecOrBuilder
        getBigqueryDateShardedSpecOrBuilder() {
      if ((typeSpecCase_ == 15) && (bigqueryDateShardedSpecBuilder_ != null)) {
        return bigqueryDateShardedSpecBuilder_.getMessageOrBuilder();
      } else {
        if (typeSpecCase_ == 15) {
          return (com.google.cloud.datacatalog.BigQueryDateShardedSpec) typeSpec_;
        }
        return com.google.cloud.datacatalog.BigQueryDateShardedSpec.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Specification for a group of BigQuery tables with name pattern
     * `[prefix]YYYYMMDD`. Context:
     * https://cloud.google.com/bigquery/docs/partitioned-tables#partitioning_versus_sharding.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1beta1.BigQueryDateShardedSpec bigquery_date_sharded_spec = 15;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.BigQueryDateShardedSpec,
            com.google.cloud.datacatalog.BigQueryDateShardedSpec.Builder,
            com.google.cloud.datacatalog.BigQueryDateShardedSpecOrBuilder>
        getBigqueryDateShardedSpecFieldBuilder() {
      if (bigqueryDateShardedSpecBuilder_ == null) {
        if (!(typeSpecCase_ == 15)) {
          typeSpec_ = com.google.cloud.datacatalog.BigQueryDateShardedSpec.getDefaultInstance();
        }
        bigqueryDateShardedSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datacatalog.BigQueryDateShardedSpec,
                com.google.cloud.datacatalog.BigQueryDateShardedSpec.Builder,
                com.google.cloud.datacatalog.BigQueryDateShardedSpecOrBuilder>(
                (com.google.cloud.datacatalog.BigQueryDateShardedSpec) typeSpec_,
                getParentForChildren(),
                isClean());
        typeSpec_ = null;
      }
      typeSpecCase_ = 15;
      onChanged();
      ;
      return bigqueryDateShardedSpecBuilder_;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Display information such as title and description. A short name
     * to identify the entry, for example, "Analytics Data - Jan 2011". Default
     * value is an empty string.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Display information such as title and description. A short name
     * to identify the entry, for example, "Analytics Data - Jan 2011". Default
     * value is an empty string.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Display information such as title and description. A short name
     * to identify the entry, for example, "Analytics Data - Jan 2011". Default
     * value is an empty string.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      displayName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Display information such as title and description. A short name
     * to identify the entry, for example, "Analytics Data - Jan 2011". Default
     * value is an empty string.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     */
    public Builder clearDisplayName() {

      displayName_ = getDefaultInstance().getDisplayName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Display information such as title and description. A short name
     * to identify the entry, for example, "Analytics Data - Jan 2011". Default
     * value is an empty string.
     * </pre>
     *
     * <code>string display_name = 3;</code>
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      displayName_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Entry description, which can consist of several sentences or
     * paragraphs that describe entry contents. Default value is an empty string.
     * </pre>
     *
     * <code>string description = 4;</code>
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Entry description, which can consist of several sentences or
     * paragraphs that describe entry contents. Default value is an empty string.
     * </pre>
     *
     * <code>string description = 4;</code>
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Entry description, which can consist of several sentences or
     * paragraphs that describe entry contents. Default value is an empty string.
     * </pre>
     *
     * <code>string description = 4;</code>
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      description_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Entry description, which can consist of several sentences or
     * paragraphs that describe entry contents. Default value is an empty string.
     * </pre>
     *
     * <code>string description = 4;</code>
     */
    public Builder clearDescription() {

      description_ = getDefaultInstance().getDescription();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Entry description, which can consist of several sentences or
     * paragraphs that describe entry contents. Default value is an empty string.
     * </pre>
     *
     * <code>string description = 4;</code>
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      description_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.datacatalog.Schema schema_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.Schema,
            com.google.cloud.datacatalog.Schema.Builder,
            com.google.cloud.datacatalog.SchemaOrBuilder>
        schemaBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Schema of the entry. An entry might not have any schema attached
     * to it.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.Schema schema = 5;</code>
     */
    public boolean hasSchema() {
      return schemaBuilder_ != null || schema_ != null;
    }
    /**
     *
     *
     * <pre>
     * Optional. Schema of the entry. An entry might not have any schema attached
     * to it.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.Schema schema = 5;</code>
     */
    public com.google.cloud.datacatalog.Schema getSchema() {
      if (schemaBuilder_ == null) {
        return schema_ == null ? com.google.cloud.datacatalog.Schema.getDefaultInstance() : schema_;
      } else {
        return schemaBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Schema of the entry. An entry might not have any schema attached
     * to it.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.Schema schema = 5;</code>
     */
    public Builder setSchema(com.google.cloud.datacatalog.Schema value) {
      if (schemaBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        schema_ = value;
        onChanged();
      } else {
        schemaBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Schema of the entry. An entry might not have any schema attached
     * to it.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.Schema schema = 5;</code>
     */
    public Builder setSchema(com.google.cloud.datacatalog.Schema.Builder builderForValue) {
      if (schemaBuilder_ == null) {
        schema_ = builderForValue.build();
        onChanged();
      } else {
        schemaBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Schema of the entry. An entry might not have any schema attached
     * to it.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.Schema schema = 5;</code>
     */
    public Builder mergeSchema(com.google.cloud.datacatalog.Schema value) {
      if (schemaBuilder_ == null) {
        if (schema_ != null) {
          schema_ =
              com.google.cloud.datacatalog.Schema.newBuilder(schema_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          schema_ = value;
        }
        onChanged();
      } else {
        schemaBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Schema of the entry. An entry might not have any schema attached
     * to it.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.Schema schema = 5;</code>
     */
    public Builder clearSchema() {
      if (schemaBuilder_ == null) {
        schema_ = null;
        onChanged();
      } else {
        schema_ = null;
        schemaBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Schema of the entry. An entry might not have any schema attached
     * to it.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.Schema schema = 5;</code>
     */
    public com.google.cloud.datacatalog.Schema.Builder getSchemaBuilder() {

      onChanged();
      return getSchemaFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Schema of the entry. An entry might not have any schema attached
     * to it.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.Schema schema = 5;</code>
     */
    public com.google.cloud.datacatalog.SchemaOrBuilder getSchemaOrBuilder() {
      if (schemaBuilder_ != null) {
        return schemaBuilder_.getMessageOrBuilder();
      } else {
        return schema_ == null ? com.google.cloud.datacatalog.Schema.getDefaultInstance() : schema_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Schema of the entry. An entry might not have any schema attached
     * to it.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.Schema schema = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.Schema,
            com.google.cloud.datacatalog.Schema.Builder,
            com.google.cloud.datacatalog.SchemaOrBuilder>
        getSchemaFieldBuilder() {
      if (schemaBuilder_ == null) {
        schemaBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datacatalog.Schema,
                com.google.cloud.datacatalog.Schema.Builder,
                com.google.cloud.datacatalog.SchemaOrBuilder>(
                getSchema(), getParentForChildren(), isClean());
        schema_ = null;
      }
      return schemaBuilder_;
    }

    private com.google.cloud.datacatalog.SystemTimestamps sourceSystemTimestamps_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.SystemTimestamps,
            com.google.cloud.datacatalog.SystemTimestamps.Builder,
            com.google.cloud.datacatalog.SystemTimestampsOrBuilder>
        sourceSystemTimestampsBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamps about the underlying Google Cloud Platform
     * resource, not about this Data Catalog Entry.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.SystemTimestamps source_system_timestamps = 7;</code>
     */
    public boolean hasSourceSystemTimestamps() {
      return sourceSystemTimestampsBuilder_ != null || sourceSystemTimestamps_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamps about the underlying Google Cloud Platform
     * resource, not about this Data Catalog Entry.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.SystemTimestamps source_system_timestamps = 7;</code>
     */
    public com.google.cloud.datacatalog.SystemTimestamps getSourceSystemTimestamps() {
      if (sourceSystemTimestampsBuilder_ == null) {
        return sourceSystemTimestamps_ == null
            ? com.google.cloud.datacatalog.SystemTimestamps.getDefaultInstance()
            : sourceSystemTimestamps_;
      } else {
        return sourceSystemTimestampsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamps about the underlying Google Cloud Platform
     * resource, not about this Data Catalog Entry.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.SystemTimestamps source_system_timestamps = 7;</code>
     */
    public Builder setSourceSystemTimestamps(com.google.cloud.datacatalog.SystemTimestamps value) {
      if (sourceSystemTimestampsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        sourceSystemTimestamps_ = value;
        onChanged();
      } else {
        sourceSystemTimestampsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamps about the underlying Google Cloud Platform
     * resource, not about this Data Catalog Entry.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.SystemTimestamps source_system_timestamps = 7;</code>
     */
    public Builder setSourceSystemTimestamps(
        com.google.cloud.datacatalog.SystemTimestamps.Builder builderForValue) {
      if (sourceSystemTimestampsBuilder_ == null) {
        sourceSystemTimestamps_ = builderForValue.build();
        onChanged();
      } else {
        sourceSystemTimestampsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamps about the underlying Google Cloud Platform
     * resource, not about this Data Catalog Entry.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.SystemTimestamps source_system_timestamps = 7;</code>
     */
    public Builder mergeSourceSystemTimestamps(
        com.google.cloud.datacatalog.SystemTimestamps value) {
      if (sourceSystemTimestampsBuilder_ == null) {
        if (sourceSystemTimestamps_ != null) {
          sourceSystemTimestamps_ =
              com.google.cloud.datacatalog.SystemTimestamps.newBuilder(sourceSystemTimestamps_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          sourceSystemTimestamps_ = value;
        }
        onChanged();
      } else {
        sourceSystemTimestampsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamps about the underlying Google Cloud Platform
     * resource, not about this Data Catalog Entry.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.SystemTimestamps source_system_timestamps = 7;</code>
     */
    public Builder clearSourceSystemTimestamps() {
      if (sourceSystemTimestampsBuilder_ == null) {
        sourceSystemTimestamps_ = null;
        onChanged();
      } else {
        sourceSystemTimestamps_ = null;
        sourceSystemTimestampsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamps about the underlying Google Cloud Platform
     * resource, not about this Data Catalog Entry.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.SystemTimestamps source_system_timestamps = 7;</code>
     */
    public com.google.cloud.datacatalog.SystemTimestamps.Builder
        getSourceSystemTimestampsBuilder() {

      onChanged();
      return getSourceSystemTimestampsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamps about the underlying Google Cloud Platform
     * resource, not about this Data Catalog Entry.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.SystemTimestamps source_system_timestamps = 7;</code>
     */
    public com.google.cloud.datacatalog.SystemTimestampsOrBuilder
        getSourceSystemTimestampsOrBuilder() {
      if (sourceSystemTimestampsBuilder_ != null) {
        return sourceSystemTimestampsBuilder_.getMessageOrBuilder();
      } else {
        return sourceSystemTimestamps_ == null
            ? com.google.cloud.datacatalog.SystemTimestamps.getDefaultInstance()
            : sourceSystemTimestamps_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamps about the underlying Google Cloud Platform
     * resource, not about this Data Catalog Entry.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.SystemTimestamps source_system_timestamps = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.SystemTimestamps,
            com.google.cloud.datacatalog.SystemTimestamps.Builder,
            com.google.cloud.datacatalog.SystemTimestampsOrBuilder>
        getSourceSystemTimestampsFieldBuilder() {
      if (sourceSystemTimestampsBuilder_ == null) {
        sourceSystemTimestampsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datacatalog.SystemTimestamps,
                com.google.cloud.datacatalog.SystemTimestamps.Builder,
                com.google.cloud.datacatalog.SystemTimestampsOrBuilder>(
                getSourceSystemTimestamps(), getParentForChildren(), isClean());
        sourceSystemTimestamps_ = null;
      }
      return sourceSystemTimestampsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datacatalog.v1beta1.Entry)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datacatalog.v1beta1.Entry)
  private static final com.google.cloud.datacatalog.Entry DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datacatalog.Entry();
  }

  public static com.google.cloud.datacatalog.Entry getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Entry> PARSER =
      new com.google.protobuf.AbstractParser<Entry>() {
        @java.lang.Override
        public Entry parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Entry(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<Entry> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Entry> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datacatalog.Entry getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
