/*
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datacatalog/v1beta1/tags.proto

package com.google.cloud.datacatalog.v1beta1;

/**
 *
 *
 * <pre>
 * Tags are used to attach custom metadata to Data Catalog resources. Tags
 * conform to the specifications within their tag template.
 * See [Data Catalog IAM](/data-catalog/docs/concepts/iam) for information on
 * the permissions needed to create or view tags.
 * </pre>
 *
 * Protobuf type {@code google.cloud.datacatalog.v1beta1.Tag}
 */
public final class Tag extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datacatalog.v1beta1.Tag)
    TagOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Tag.newBuilder() to construct.
  private Tag(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Tag() {
    name_ = "";
    template_ = "";
    templateDisplayName_ = "";
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private Tag(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();

              template_ = s;
              break;
            }
          case 26:
            {
              if (!((mutable_bitField0_ & 0x00000010) != 0)) {
                fields_ =
                    com.google.protobuf.MapField.newMapField(FieldsDefaultEntryHolder.defaultEntry);
                mutable_bitField0_ |= 0x00000010;
              }
              com.google.protobuf.MapEntry<
                      java.lang.String, com.google.cloud.datacatalog.v1beta1.TagField>
                  fields__ =
                      input.readMessage(
                          FieldsDefaultEntryHolder.defaultEntry.getParserForType(),
                          extensionRegistry);
              fields_.getMutableMap().put(fields__.getKey(), fields__.getValue());
              break;
            }
          case 34:
            {
              java.lang.String s = input.readStringRequireUtf8();
              scopeCase_ = 4;
              scope_ = s;
              break;
            }
          case 42:
            {
              java.lang.String s = input.readStringRequireUtf8();

              templateDisplayName_ = s;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datacatalog.v1beta1.Tags
        .internal_static_google_cloud_datacatalog_v1beta1_Tag_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 3:
        return internalGetFields();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datacatalog.v1beta1.Tags
        .internal_static_google_cloud_datacatalog_v1beta1_Tag_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datacatalog.v1beta1.Tag.class,
            com.google.cloud.datacatalog.v1beta1.Tag.Builder.class);
  }

  private int bitField0_;
  private int scopeCase_ = 0;
  private java.lang.Object scope_;

  public enum ScopeCase implements com.google.protobuf.Internal.EnumLite {
    COLUMN(4),
    SCOPE_NOT_SET(0);
    private final int value;

    private ScopeCase(int value) {
      this.value = value;
    }
    /** @deprecated Use {@link #forNumber(int)} instead. */
    @java.lang.Deprecated
    public static ScopeCase valueOf(int value) {
      return forNumber(value);
    }

    public static ScopeCase forNumber(int value) {
      switch (value) {
        case 4:
          return COLUMN;
        case 0:
          return SCOPE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ScopeCase getScopeCase() {
    return ScopeCase.forNumber(scopeCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * The resource name of the tag in URL format. Example:
   * * projects/{project_id}/locations/{location}/entrygroups/{entry_group_id}/entries/{entry_id}/tags/{tag_id}
   * where `tag_id` is a system-generated identifier.
   * Note that this Tag may not actually be stored in the location in this name.
   * </pre>
   *
   * <code>string name = 1;</code>
   */
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name of the tag in URL format. Example:
   * * projects/{project_id}/locations/{location}/entrygroups/{entry_group_id}/entries/{entry_id}/tags/{tag_id}
   * where `tag_id` is a system-generated identifier.
   * Note that this Tag may not actually be stored in the location in this name.
   * </pre>
   *
   * <code>string name = 1;</code>
   */
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TEMPLATE_FIELD_NUMBER = 2;
  private volatile java.lang.Object template_;
  /**
   *
   *
   * <pre>
   * Required. The resource name of the tag template that this tag uses. Example:
   * * projects/{project_id}/locations/{location}/tagTemplates/{tag_template_id}
   * This field cannot be modified after creation.
   * </pre>
   *
   * <code>string template = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   */
  public java.lang.String getTemplate() {
    java.lang.Object ref = template_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      template_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The resource name of the tag template that this tag uses. Example:
   * * projects/{project_id}/locations/{location}/tagTemplates/{tag_template_id}
   * This field cannot be modified after creation.
   * </pre>
   *
   * <code>string template = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   */
  public com.google.protobuf.ByteString getTemplateBytes() {
    java.lang.Object ref = template_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      template_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TEMPLATE_DISPLAY_NAME_FIELD_NUMBER = 5;
  private volatile java.lang.Object templateDisplayName_;
  /**
   *
   *
   * <pre>
   * Output only. The display name of the tag template.
   * </pre>
   *
   * <code>string template_display_name = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  public java.lang.String getTemplateDisplayName() {
    java.lang.Object ref = templateDisplayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      templateDisplayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The display name of the tag template.
   * </pre>
   *
   * <code>string template_display_name = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  public com.google.protobuf.ByteString getTemplateDisplayNameBytes() {
    java.lang.Object ref = templateDisplayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      templateDisplayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int COLUMN_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Resources like Entry can have schemas associated with them. This scope
   * allows users to attach tags to an individual column based on that schema.
   * For attaching a tag to a nested column, use `.` to separate the column
   * names. Example:
   * * `outer_column.inner_column`
   * </pre>
   *
   * <code>string column = 4;</code>
   */
  public java.lang.String getColumn() {
    java.lang.Object ref = "";
    if (scopeCase_ == 4) {
      ref = scope_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (scopeCase_ == 4) {
        scope_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Resources like Entry can have schemas associated with them. This scope
   * allows users to attach tags to an individual column based on that schema.
   * For attaching a tag to a nested column, use `.` to separate the column
   * names. Example:
   * * `outer_column.inner_column`
   * </pre>
   *
   * <code>string column = 4;</code>
   */
  public com.google.protobuf.ByteString getColumnBytes() {
    java.lang.Object ref = "";
    if (scopeCase_ == 4) {
      ref = scope_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (scopeCase_ == 4) {
        scope_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FIELDS_FIELD_NUMBER = 3;

  private static final class FieldsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.cloud.datacatalog.v1beta1.TagField>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.cloud.datacatalog.v1beta1.TagField>
                    newDefaultInstance(
                        com.google.cloud.datacatalog.v1beta1.Tags
                            .internal_static_google_cloud_datacatalog_v1beta1_Tag_FieldsEntry_descriptor,
                        com.google.protobuf.WireFormat.FieldType.STRING,
                        "",
                        com.google.protobuf.WireFormat.FieldType.MESSAGE,
                        com.google.cloud.datacatalog.v1beta1.TagField.getDefaultInstance());
  }

  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.datacatalog.v1beta1.TagField>
      fields_;

  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.datacatalog.v1beta1.TagField>
      internalGetFields() {
    if (fields_ == null) {
      return com.google.protobuf.MapField.emptyMapField(FieldsDefaultEntryHolder.defaultEntry);
    }
    return fields_;
  }

  public int getFieldsCount() {
    return internalGetFields().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Required. This maps the ID of a tag field to the value of and additional information
   * about that field. Valid field IDs are defined by the tag's template. A tag
   * must have at least 1 field and at most 500 fields.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.datacatalog.v1beta1.TagField&gt; fields = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  public boolean containsFields(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    return internalGetFields().getMap().containsKey(key);
  }
  /** Use {@link #getFieldsMap()} instead. */
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.cloud.datacatalog.v1beta1.TagField>
      getFields() {
    return getFieldsMap();
  }
  /**
   *
   *
   * <pre>
   * Required. This maps the ID of a tag field to the value of and additional information
   * about that field. Valid field IDs are defined by the tag's template. A tag
   * must have at least 1 field and at most 500 fields.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.datacatalog.v1beta1.TagField&gt; fields = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  public java.util.Map<java.lang.String, com.google.cloud.datacatalog.v1beta1.TagField>
      getFieldsMap() {
    return internalGetFields().getMap();
  }
  /**
   *
   *
   * <pre>
   * Required. This maps the ID of a tag field to the value of and additional information
   * about that field. Valid field IDs are defined by the tag's template. A tag
   * must have at least 1 field and at most 500 fields.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.datacatalog.v1beta1.TagField&gt; fields = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  public com.google.cloud.datacatalog.v1beta1.TagField getFieldsOrDefault(
      java.lang.String key, com.google.cloud.datacatalog.v1beta1.TagField defaultValue) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, com.google.cloud.datacatalog.v1beta1.TagField> map =
        internalGetFields().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Required. This maps the ID of a tag field to the value of and additional information
   * about that field. Valid field IDs are defined by the tag's template. A tag
   * must have at least 1 field and at most 500 fields.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.datacatalog.v1beta1.TagField&gt; fields = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  public com.google.cloud.datacatalog.v1beta1.TagField getFieldsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, com.google.cloud.datacatalog.v1beta1.TagField> map =
        internalGetFields().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!getTemplateBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, template_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetFields(), FieldsDefaultEntryHolder.defaultEntry, 3);
    if (scopeCase_ == 4) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, scope_);
    }
    if (!getTemplateDisplayNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, templateDisplayName_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!getTemplateBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, template_);
    }
    for (java.util.Map.Entry<java.lang.String, com.google.cloud.datacatalog.v1beta1.TagField>
        entry : internalGetFields().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, com.google.cloud.datacatalog.v1beta1.TagField>
          fields__ =
              FieldsDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, fields__);
    }
    if (scopeCase_ == 4) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, scope_);
    }
    if (!getTemplateDisplayNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, templateDisplayName_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datacatalog.v1beta1.Tag)) {
      return super.equals(obj);
    }
    com.google.cloud.datacatalog.v1beta1.Tag other = (com.google.cloud.datacatalog.v1beta1.Tag) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getTemplate().equals(other.getTemplate())) return false;
    if (!getTemplateDisplayName().equals(other.getTemplateDisplayName())) return false;
    if (!internalGetFields().equals(other.internalGetFields())) return false;
    if (!getScopeCase().equals(other.getScopeCase())) return false;
    switch (scopeCase_) {
      case 4:
        if (!getColumn().equals(other.getColumn())) return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + TEMPLATE_FIELD_NUMBER;
    hash = (53 * hash) + getTemplate().hashCode();
    hash = (37 * hash) + TEMPLATE_DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getTemplateDisplayName().hashCode();
    if (!internalGetFields().getMap().isEmpty()) {
      hash = (37 * hash) + FIELDS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetFields().hashCode();
    }
    switch (scopeCase_) {
      case 4:
        hash = (37 * hash) + COLUMN_FIELD_NUMBER;
        hash = (53 * hash) + getColumn().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datacatalog.v1beta1.Tag parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1beta1.Tag parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1beta1.Tag parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1beta1.Tag parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1beta1.Tag parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1beta1.Tag parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1beta1.Tag parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1beta1.Tag parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1beta1.Tag parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1beta1.Tag parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1beta1.Tag parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1beta1.Tag parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.datacatalog.v1beta1.Tag prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Tags are used to attach custom metadata to Data Catalog resources. Tags
   * conform to the specifications within their tag template.
   * See [Data Catalog IAM](/data-catalog/docs/concepts/iam) for information on
   * the permissions needed to create or view tags.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datacatalog.v1beta1.Tag}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datacatalog.v1beta1.Tag)
      com.google.cloud.datacatalog.v1beta1.TagOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datacatalog.v1beta1.Tags
          .internal_static_google_cloud_datacatalog_v1beta1_Tag_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 3:
          return internalGetFields();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 3:
          return internalGetMutableFields();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datacatalog.v1beta1.Tags
          .internal_static_google_cloud_datacatalog_v1beta1_Tag_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datacatalog.v1beta1.Tag.class,
              com.google.cloud.datacatalog.v1beta1.Tag.Builder.class);
    }

    // Construct using com.google.cloud.datacatalog.v1beta1.Tag.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      template_ = "";

      templateDisplayName_ = "";

      internalGetMutableFields().clear();
      scopeCase_ = 0;
      scope_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datacatalog.v1beta1.Tags
          .internal_static_google_cloud_datacatalog_v1beta1_Tag_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1beta1.Tag getDefaultInstanceForType() {
      return com.google.cloud.datacatalog.v1beta1.Tag.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1beta1.Tag build() {
      com.google.cloud.datacatalog.v1beta1.Tag result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1beta1.Tag buildPartial() {
      com.google.cloud.datacatalog.v1beta1.Tag result =
          new com.google.cloud.datacatalog.v1beta1.Tag(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      result.name_ = name_;
      result.template_ = template_;
      result.templateDisplayName_ = templateDisplayName_;
      if (scopeCase_ == 4) {
        result.scope_ = scope_;
      }
      result.fields_ = internalGetFields();
      result.fields_.makeImmutable();
      result.bitField0_ = to_bitField0_;
      result.scopeCase_ = scopeCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datacatalog.v1beta1.Tag) {
        return mergeFrom((com.google.cloud.datacatalog.v1beta1.Tag) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datacatalog.v1beta1.Tag other) {
      if (other == com.google.cloud.datacatalog.v1beta1.Tag.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getTemplate().isEmpty()) {
        template_ = other.template_;
        onChanged();
      }
      if (!other.getTemplateDisplayName().isEmpty()) {
        templateDisplayName_ = other.templateDisplayName_;
        onChanged();
      }
      internalGetMutableFields().mergeFrom(other.internalGetFields());
      switch (other.getScopeCase()) {
        case COLUMN:
          {
            scopeCase_ = 4;
            scope_ = other.scope_;
            onChanged();
            break;
          }
        case SCOPE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.datacatalog.v1beta1.Tag parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.datacatalog.v1beta1.Tag) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int scopeCase_ = 0;
    private java.lang.Object scope_;

    public ScopeCase getScopeCase() {
      return ScopeCase.forNumber(scopeCase_);
    }

    public Builder clearScope() {
      scopeCase_ = 0;
      scope_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of the tag in URL format. Example:
     * * projects/{project_id}/locations/{location}/entrygroups/{entry_group_id}/entries/{entry_id}/tags/{tag_id}
     * where `tag_id` is a system-generated identifier.
     * Note that this Tag may not actually be stored in the location in this name.
     * </pre>
     *
     * <code>string name = 1;</code>
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the tag in URL format. Example:
     * * projects/{project_id}/locations/{location}/entrygroups/{entry_group_id}/entries/{entry_id}/tags/{tag_id}
     * where `tag_id` is a system-generated identifier.
     * Note that this Tag may not actually be stored in the location in this name.
     * </pre>
     *
     * <code>string name = 1;</code>
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the tag in URL format. Example:
     * * projects/{project_id}/locations/{location}/entrygroups/{entry_group_id}/entries/{entry_id}/tags/{tag_id}
     * where `tag_id` is a system-generated identifier.
     * Note that this Tag may not actually be stored in the location in this name.
     * </pre>
     *
     * <code>string name = 1;</code>
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the tag in URL format. Example:
     * * projects/{project_id}/locations/{location}/entrygroups/{entry_group_id}/entries/{entry_id}/tags/{tag_id}
     * where `tag_id` is a system-generated identifier.
     * Note that this Tag may not actually be stored in the location in this name.
     * </pre>
     *
     * <code>string name = 1;</code>
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the tag in URL format. Example:
     * * projects/{project_id}/locations/{location}/entrygroups/{entry_group_id}/entries/{entry_id}/tags/{tag_id}
     * where `tag_id` is a system-generated identifier.
     * Note that this Tag may not actually be stored in the location in this name.
     * </pre>
     *
     * <code>string name = 1;</code>
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object template_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name of the tag template that this tag uses. Example:
     * * projects/{project_id}/locations/{location}/tagTemplates/{tag_template_id}
     * This field cannot be modified after creation.
     * </pre>
     *
     * <code>string template = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public java.lang.String getTemplate() {
      java.lang.Object ref = template_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        template_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the tag template that this tag uses. Example:
     * * projects/{project_id}/locations/{location}/tagTemplates/{tag_template_id}
     * This field cannot be modified after creation.
     * </pre>
     *
     * <code>string template = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public com.google.protobuf.ByteString getTemplateBytes() {
      java.lang.Object ref = template_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        template_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the tag template that this tag uses. Example:
     * * projects/{project_id}/locations/{location}/tagTemplates/{tag_template_id}
     * This field cannot be modified after creation.
     * </pre>
     *
     * <code>string template = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder setTemplate(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      template_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the tag template that this tag uses. Example:
     * * projects/{project_id}/locations/{location}/tagTemplates/{tag_template_id}
     * This field cannot be modified after creation.
     * </pre>
     *
     * <code>string template = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder clearTemplate() {

      template_ = getDefaultInstance().getTemplate();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the tag template that this tag uses. Example:
     * * projects/{project_id}/locations/{location}/tagTemplates/{tag_template_id}
     * This field cannot be modified after creation.
     * </pre>
     *
     * <code>string template = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder setTemplateBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      template_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object templateDisplayName_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The display name of the tag template.
     * </pre>
     *
     * <code>string template_display_name = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public java.lang.String getTemplateDisplayName() {
      java.lang.Object ref = templateDisplayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        templateDisplayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The display name of the tag template.
     * </pre>
     *
     * <code>string template_display_name = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.protobuf.ByteString getTemplateDisplayNameBytes() {
      java.lang.Object ref = templateDisplayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        templateDisplayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The display name of the tag template.
     * </pre>
     *
     * <code>string template_display_name = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setTemplateDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      templateDisplayName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The display name of the tag template.
     * </pre>
     *
     * <code>string template_display_name = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearTemplateDisplayName() {

      templateDisplayName_ = getDefaultInstance().getTemplateDisplayName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The display name of the tag template.
     * </pre>
     *
     * <code>string template_display_name = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setTemplateDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      templateDisplayName_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Resources like Entry can have schemas associated with them. This scope
     * allows users to attach tags to an individual column based on that schema.
     * For attaching a tag to a nested column, use `.` to separate the column
     * names. Example:
     * * `outer_column.inner_column`
     * </pre>
     *
     * <code>string column = 4;</code>
     */
    public java.lang.String getColumn() {
      java.lang.Object ref = "";
      if (scopeCase_ == 4) {
        ref = scope_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (scopeCase_ == 4) {
          scope_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Resources like Entry can have schemas associated with them. This scope
     * allows users to attach tags to an individual column based on that schema.
     * For attaching a tag to a nested column, use `.` to separate the column
     * names. Example:
     * * `outer_column.inner_column`
     * </pre>
     *
     * <code>string column = 4;</code>
     */
    public com.google.protobuf.ByteString getColumnBytes() {
      java.lang.Object ref = "";
      if (scopeCase_ == 4) {
        ref = scope_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (scopeCase_ == 4) {
          scope_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Resources like Entry can have schemas associated with them. This scope
     * allows users to attach tags to an individual column based on that schema.
     * For attaching a tag to a nested column, use `.` to separate the column
     * names. Example:
     * * `outer_column.inner_column`
     * </pre>
     *
     * <code>string column = 4;</code>
     */
    public Builder setColumn(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      scopeCase_ = 4;
      scope_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resources like Entry can have schemas associated with them. This scope
     * allows users to attach tags to an individual column based on that schema.
     * For attaching a tag to a nested column, use `.` to separate the column
     * names. Example:
     * * `outer_column.inner_column`
     * </pre>
     *
     * <code>string column = 4;</code>
     */
    public Builder clearColumn() {
      if (scopeCase_ == 4) {
        scopeCase_ = 0;
        scope_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resources like Entry can have schemas associated with them. This scope
     * allows users to attach tags to an individual column based on that schema.
     * For attaching a tag to a nested column, use `.` to separate the column
     * names. Example:
     * * `outer_column.inner_column`
     * </pre>
     *
     * <code>string column = 4;</code>
     */
    public Builder setColumnBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      scopeCase_ = 4;
      scope_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.datacatalog.v1beta1.TagField>
        fields_;

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.datacatalog.v1beta1.TagField>
        internalGetFields() {
      if (fields_ == null) {
        return com.google.protobuf.MapField.emptyMapField(FieldsDefaultEntryHolder.defaultEntry);
      }
      return fields_;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.datacatalog.v1beta1.TagField>
        internalGetMutableFields() {
      onChanged();
      ;
      if (fields_ == null) {
        fields_ = com.google.protobuf.MapField.newMapField(FieldsDefaultEntryHolder.defaultEntry);
      }
      if (!fields_.isMutable()) {
        fields_ = fields_.copy();
      }
      return fields_;
    }

    public int getFieldsCount() {
      return internalGetFields().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Required. This maps the ID of a tag field to the value of and additional information
     * about that field. Valid field IDs are defined by the tag's template. A tag
     * must have at least 1 field and at most 500 fields.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.datacatalog.v1beta1.TagField&gt; fields = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public boolean containsFields(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      return internalGetFields().getMap().containsKey(key);
    }
    /** Use {@link #getFieldsMap()} instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.datacatalog.v1beta1.TagField>
        getFields() {
      return getFieldsMap();
    }
    /**
     *
     *
     * <pre>
     * Required. This maps the ID of a tag field to the value of and additional information
     * about that field. Valid field IDs are defined by the tag's template. A tag
     * must have at least 1 field and at most 500 fields.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.datacatalog.v1beta1.TagField&gt; fields = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.Map<java.lang.String, com.google.cloud.datacatalog.v1beta1.TagField>
        getFieldsMap() {
      return internalGetFields().getMap();
    }
    /**
     *
     *
     * <pre>
     * Required. This maps the ID of a tag field to the value of and additional information
     * about that field. Valid field IDs are defined by the tag's template. A tag
     * must have at least 1 field and at most 500 fields.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.datacatalog.v1beta1.TagField&gt; fields = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.datacatalog.v1beta1.TagField getFieldsOrDefault(
        java.lang.String key, com.google.cloud.datacatalog.v1beta1.TagField defaultValue) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, com.google.cloud.datacatalog.v1beta1.TagField> map =
          internalGetFields().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Required. This maps the ID of a tag field to the value of and additional information
     * about that field. Valid field IDs are defined by the tag's template. A tag
     * must have at least 1 field and at most 500 fields.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.datacatalog.v1beta1.TagField&gt; fields = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.datacatalog.v1beta1.TagField getFieldsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, com.google.cloud.datacatalog.v1beta1.TagField> map =
          internalGetFields().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearFields() {
      internalGetMutableFields().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. This maps the ID of a tag field to the value of and additional information
     * about that field. Valid field IDs are defined by the tag's template. A tag
     * must have at least 1 field and at most 500 fields.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.datacatalog.v1beta1.TagField&gt; fields = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeFields(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableFields().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.datacatalog.v1beta1.TagField>
        getMutableFields() {
      return internalGetMutableFields().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Required. This maps the ID of a tag field to the value of and additional information
     * about that field. Valid field IDs are defined by the tag's template. A tag
     * must have at least 1 field and at most 500 fields.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.datacatalog.v1beta1.TagField&gt; fields = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder putFields(
        java.lang.String key, com.google.cloud.datacatalog.v1beta1.TagField value) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      if (value == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableFields().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. This maps the ID of a tag field to the value of and additional information
     * about that field. Valid field IDs are defined by the tag's template. A tag
     * must have at least 1 field and at most 500 fields.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.datacatalog.v1beta1.TagField&gt; fields = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder putAllFields(
        java.util.Map<java.lang.String, com.google.cloud.datacatalog.v1beta1.TagField> values) {
      internalGetMutableFields().getMutableMap().putAll(values);
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datacatalog.v1beta1.Tag)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datacatalog.v1beta1.Tag)
  private static final com.google.cloud.datacatalog.v1beta1.Tag DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datacatalog.v1beta1.Tag();
  }

  public static com.google.cloud.datacatalog.v1beta1.Tag getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Tag> PARSER =
      new com.google.protobuf.AbstractParser<Tag>() {
        @java.lang.Override
        public Tag parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Tag(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<Tag> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Tag> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datacatalog.v1beta1.Tag getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
