/*
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datacatalog/v1beta1/gcs_fileset_spec.proto

package com.google.cloud.datacatalog.v1beta1;

/**
 *
 *
 * <pre>
 * Describes a Cloud Storage fileset entry.
 * </pre>
 *
 * Protobuf type {@code google.cloud.datacatalog.v1beta1.GcsFilesetSpec}
 */
public final class GcsFilesetSpec extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datacatalog.v1beta1.GcsFilesetSpec)
    GcsFilesetSpecOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use GcsFilesetSpec.newBuilder() to construct.
  private GcsFilesetSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private GcsFilesetSpec() {
    filePatterns_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    sampleGcsFileSpecs_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new GcsFilesetSpec();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private GcsFilesetSpec(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                filePatterns_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000001;
              }
              filePatterns_.add(s);
              break;
            }
          case 18:
            {
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                sampleGcsFileSpecs_ =
                    new java.util.ArrayList<com.google.cloud.datacatalog.v1beta1.GcsFileSpec>();
                mutable_bitField0_ |= 0x00000002;
              }
              sampleGcsFileSpecs_.add(
                  input.readMessage(
                      com.google.cloud.datacatalog.v1beta1.GcsFileSpec.parser(),
                      extensionRegistry));
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        filePatterns_ = filePatterns_.getUnmodifiableView();
      }
      if (((mutable_bitField0_ & 0x00000002) != 0)) {
        sampleGcsFileSpecs_ = java.util.Collections.unmodifiableList(sampleGcsFileSpecs_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datacatalog.v1beta1.GcsFilesetSpecOuterClass
        .internal_static_google_cloud_datacatalog_v1beta1_GcsFilesetSpec_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datacatalog.v1beta1.GcsFilesetSpecOuterClass
        .internal_static_google_cloud_datacatalog_v1beta1_GcsFilesetSpec_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datacatalog.v1beta1.GcsFilesetSpec.class,
            com.google.cloud.datacatalog.v1beta1.GcsFilesetSpec.Builder.class);
  }

  public static final int FILE_PATTERNS_FIELD_NUMBER = 1;
  private com.google.protobuf.LazyStringList filePatterns_;
  /**
   *
   *
   * <pre>
   * Required. Patterns to identify a set of files in Google Cloud Storage. See [Cloud
   * Storage documentation](storage/docs/gsutil/addlhelp/WildcardNames) for
   * more information. Note that bucket wildcards are currently not supported.
   * Examples of valid file_patterns:
   *  * `gs://bucket_name/dir/&#42;`: matches all files within `bucket_name/dir`
   *                              directory.
   *  * `gs://bucket_name/dir/&#42;*`: matches all files in `bucket_name/dir`
   *                               spanning all subdirectories.
   *  * `gs://bucket_name/file*`: matches files prefixed by `file` in
   *                              `bucket_name`
   *  * `gs://bucket_name/a/&#42;&#47;b`: matches all files in `bucket_name` that match
   *                              `a/&#42;&#47;b` pattern, such as `a/c/b`, `a/d/b`
   *  * `gs://another_bucket/a.txt`: matches `gs://another_bucket/a.txt`
   * </pre>
   *
   * <code>repeated string file_patterns = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return A list containing the filePatterns.
   */
  public com.google.protobuf.ProtocolStringList getFilePatternsList() {
    return filePatterns_;
  }
  /**
   *
   *
   * <pre>
   * Required. Patterns to identify a set of files in Google Cloud Storage. See [Cloud
   * Storage documentation](storage/docs/gsutil/addlhelp/WildcardNames) for
   * more information. Note that bucket wildcards are currently not supported.
   * Examples of valid file_patterns:
   *  * `gs://bucket_name/dir/&#42;`: matches all files within `bucket_name/dir`
   *                              directory.
   *  * `gs://bucket_name/dir/&#42;*`: matches all files in `bucket_name/dir`
   *                               spanning all subdirectories.
   *  * `gs://bucket_name/file*`: matches files prefixed by `file` in
   *                              `bucket_name`
   *  * `gs://bucket_name/a/&#42;&#47;b`: matches all files in `bucket_name` that match
   *                              `a/&#42;&#47;b` pattern, such as `a/c/b`, `a/d/b`
   *  * `gs://another_bucket/a.txt`: matches `gs://another_bucket/a.txt`
   * </pre>
   *
   * <code>repeated string file_patterns = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The count of filePatterns.
   */
  public int getFilePatternsCount() {
    return filePatterns_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. Patterns to identify a set of files in Google Cloud Storage. See [Cloud
   * Storage documentation](storage/docs/gsutil/addlhelp/WildcardNames) for
   * more information. Note that bucket wildcards are currently not supported.
   * Examples of valid file_patterns:
   *  * `gs://bucket_name/dir/&#42;`: matches all files within `bucket_name/dir`
   *                              directory.
   *  * `gs://bucket_name/dir/&#42;*`: matches all files in `bucket_name/dir`
   *                               spanning all subdirectories.
   *  * `gs://bucket_name/file*`: matches files prefixed by `file` in
   *                              `bucket_name`
   *  * `gs://bucket_name/a/&#42;&#47;b`: matches all files in `bucket_name` that match
   *                              `a/&#42;&#47;b` pattern, such as `a/c/b`, `a/d/b`
   *  * `gs://another_bucket/a.txt`: matches `gs://another_bucket/a.txt`
   * </pre>
   *
   * <code>repeated string file_patterns = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @param index The index of the element to return.
   * @return The filePatterns at the given index.
   */
  public java.lang.String getFilePatterns(int index) {
    return filePatterns_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. Patterns to identify a set of files in Google Cloud Storage. See [Cloud
   * Storage documentation](storage/docs/gsutil/addlhelp/WildcardNames) for
   * more information. Note that bucket wildcards are currently not supported.
   * Examples of valid file_patterns:
   *  * `gs://bucket_name/dir/&#42;`: matches all files within `bucket_name/dir`
   *                              directory.
   *  * `gs://bucket_name/dir/&#42;*`: matches all files in `bucket_name/dir`
   *                               spanning all subdirectories.
   *  * `gs://bucket_name/file*`: matches files prefixed by `file` in
   *                              `bucket_name`
   *  * `gs://bucket_name/a/&#42;&#47;b`: matches all files in `bucket_name` that match
   *                              `a/&#42;&#47;b` pattern, such as `a/c/b`, `a/d/b`
   *  * `gs://another_bucket/a.txt`: matches `gs://another_bucket/a.txt`
   * </pre>
   *
   * <code>repeated string file_patterns = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the filePatterns at the given index.
   */
  public com.google.protobuf.ByteString getFilePatternsBytes(int index) {
    return filePatterns_.getByteString(index);
  }

  public static final int SAMPLE_GCS_FILE_SPECS_FIELD_NUMBER = 2;
  private java.util.List<com.google.cloud.datacatalog.v1beta1.GcsFileSpec> sampleGcsFileSpecs_;
  /**
   *
   *
   * <pre>
   * Output only. Sample files contained in this fileset, not all files contained in this
   * fileset are represented here.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datacatalog.v1beta1.GcsFileSpec sample_gcs_file_specs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  public java.util.List<com.google.cloud.datacatalog.v1beta1.GcsFileSpec>
      getSampleGcsFileSpecsList() {
    return sampleGcsFileSpecs_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Sample files contained in this fileset, not all files contained in this
   * fileset are represented here.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datacatalog.v1beta1.GcsFileSpec sample_gcs_file_specs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  public java.util.List<? extends com.google.cloud.datacatalog.v1beta1.GcsFileSpecOrBuilder>
      getSampleGcsFileSpecsOrBuilderList() {
    return sampleGcsFileSpecs_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Sample files contained in this fileset, not all files contained in this
   * fileset are represented here.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datacatalog.v1beta1.GcsFileSpec sample_gcs_file_specs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  public int getSampleGcsFileSpecsCount() {
    return sampleGcsFileSpecs_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Sample files contained in this fileset, not all files contained in this
   * fileset are represented here.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datacatalog.v1beta1.GcsFileSpec sample_gcs_file_specs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  public com.google.cloud.datacatalog.v1beta1.GcsFileSpec getSampleGcsFileSpecs(int index) {
    return sampleGcsFileSpecs_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. Sample files contained in this fileset, not all files contained in this
   * fileset are represented here.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datacatalog.v1beta1.GcsFileSpec sample_gcs_file_specs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  public com.google.cloud.datacatalog.v1beta1.GcsFileSpecOrBuilder getSampleGcsFileSpecsOrBuilder(
      int index) {
    return sampleGcsFileSpecs_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < filePatterns_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, filePatterns_.getRaw(i));
    }
    for (int i = 0; i < sampleGcsFileSpecs_.size(); i++) {
      output.writeMessage(2, sampleGcsFileSpecs_.get(i));
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < filePatterns_.size(); i++) {
        dataSize += computeStringSizeNoTag(filePatterns_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getFilePatternsList().size();
    }
    for (int i = 0; i < sampleGcsFileSpecs_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(2, sampleGcsFileSpecs_.get(i));
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datacatalog.v1beta1.GcsFilesetSpec)) {
      return super.equals(obj);
    }
    com.google.cloud.datacatalog.v1beta1.GcsFilesetSpec other =
        (com.google.cloud.datacatalog.v1beta1.GcsFilesetSpec) obj;

    if (!getFilePatternsList().equals(other.getFilePatternsList())) return false;
    if (!getSampleGcsFileSpecsList().equals(other.getSampleGcsFileSpecsList())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getFilePatternsCount() > 0) {
      hash = (37 * hash) + FILE_PATTERNS_FIELD_NUMBER;
      hash = (53 * hash) + getFilePatternsList().hashCode();
    }
    if (getSampleGcsFileSpecsCount() > 0) {
      hash = (37 * hash) + SAMPLE_GCS_FILE_SPECS_FIELD_NUMBER;
      hash = (53 * hash) + getSampleGcsFileSpecsList().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datacatalog.v1beta1.GcsFilesetSpec parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1beta1.GcsFilesetSpec parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1beta1.GcsFilesetSpec parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1beta1.GcsFilesetSpec parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1beta1.GcsFilesetSpec parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1beta1.GcsFilesetSpec parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1beta1.GcsFilesetSpec parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1beta1.GcsFilesetSpec parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1beta1.GcsFilesetSpec parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1beta1.GcsFilesetSpec parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1beta1.GcsFilesetSpec parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1beta1.GcsFilesetSpec parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.datacatalog.v1beta1.GcsFilesetSpec prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Describes a Cloud Storage fileset entry.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datacatalog.v1beta1.GcsFilesetSpec}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datacatalog.v1beta1.GcsFilesetSpec)
      com.google.cloud.datacatalog.v1beta1.GcsFilesetSpecOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datacatalog.v1beta1.GcsFilesetSpecOuterClass
          .internal_static_google_cloud_datacatalog_v1beta1_GcsFilesetSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datacatalog.v1beta1.GcsFilesetSpecOuterClass
          .internal_static_google_cloud_datacatalog_v1beta1_GcsFilesetSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datacatalog.v1beta1.GcsFilesetSpec.class,
              com.google.cloud.datacatalog.v1beta1.GcsFilesetSpec.Builder.class);
    }

    // Construct using com.google.cloud.datacatalog.v1beta1.GcsFilesetSpec.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getSampleGcsFileSpecsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      filePatterns_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      if (sampleGcsFileSpecsBuilder_ == null) {
        sampleGcsFileSpecs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
      } else {
        sampleGcsFileSpecsBuilder_.clear();
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datacatalog.v1beta1.GcsFilesetSpecOuterClass
          .internal_static_google_cloud_datacatalog_v1beta1_GcsFilesetSpec_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1beta1.GcsFilesetSpec getDefaultInstanceForType() {
      return com.google.cloud.datacatalog.v1beta1.GcsFilesetSpec.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1beta1.GcsFilesetSpec build() {
      com.google.cloud.datacatalog.v1beta1.GcsFilesetSpec result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1beta1.GcsFilesetSpec buildPartial() {
      com.google.cloud.datacatalog.v1beta1.GcsFilesetSpec result =
          new com.google.cloud.datacatalog.v1beta1.GcsFilesetSpec(this);
      int from_bitField0_ = bitField0_;
      if (((bitField0_ & 0x00000001) != 0)) {
        filePatterns_ = filePatterns_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.filePatterns_ = filePatterns_;
      if (sampleGcsFileSpecsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          sampleGcsFileSpecs_ = java.util.Collections.unmodifiableList(sampleGcsFileSpecs_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.sampleGcsFileSpecs_ = sampleGcsFileSpecs_;
      } else {
        result.sampleGcsFileSpecs_ = sampleGcsFileSpecsBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datacatalog.v1beta1.GcsFilesetSpec) {
        return mergeFrom((com.google.cloud.datacatalog.v1beta1.GcsFilesetSpec) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datacatalog.v1beta1.GcsFilesetSpec other) {
      if (other == com.google.cloud.datacatalog.v1beta1.GcsFilesetSpec.getDefaultInstance())
        return this;
      if (!other.filePatterns_.isEmpty()) {
        if (filePatterns_.isEmpty()) {
          filePatterns_ = other.filePatterns_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureFilePatternsIsMutable();
          filePatterns_.addAll(other.filePatterns_);
        }
        onChanged();
      }
      if (sampleGcsFileSpecsBuilder_ == null) {
        if (!other.sampleGcsFileSpecs_.isEmpty()) {
          if (sampleGcsFileSpecs_.isEmpty()) {
            sampleGcsFileSpecs_ = other.sampleGcsFileSpecs_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureSampleGcsFileSpecsIsMutable();
            sampleGcsFileSpecs_.addAll(other.sampleGcsFileSpecs_);
          }
          onChanged();
        }
      } else {
        if (!other.sampleGcsFileSpecs_.isEmpty()) {
          if (sampleGcsFileSpecsBuilder_.isEmpty()) {
            sampleGcsFileSpecsBuilder_.dispose();
            sampleGcsFileSpecsBuilder_ = null;
            sampleGcsFileSpecs_ = other.sampleGcsFileSpecs_;
            bitField0_ = (bitField0_ & ~0x00000002);
            sampleGcsFileSpecsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSampleGcsFileSpecsFieldBuilder()
                    : null;
          } else {
            sampleGcsFileSpecsBuilder_.addAllMessages(other.sampleGcsFileSpecs_);
          }
        }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.datacatalog.v1beta1.GcsFilesetSpec parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.datacatalog.v1beta1.GcsFilesetSpec) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.LazyStringList filePatterns_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureFilePatternsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        filePatterns_ = new com.google.protobuf.LazyStringArrayList(filePatterns_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Patterns to identify a set of files in Google Cloud Storage. See [Cloud
     * Storage documentation](storage/docs/gsutil/addlhelp/WildcardNames) for
     * more information. Note that bucket wildcards are currently not supported.
     * Examples of valid file_patterns:
     *  * `gs://bucket_name/dir/&#42;`: matches all files within `bucket_name/dir`
     *                              directory.
     *  * `gs://bucket_name/dir/&#42;*`: matches all files in `bucket_name/dir`
     *                               spanning all subdirectories.
     *  * `gs://bucket_name/file*`: matches files prefixed by `file` in
     *                              `bucket_name`
     *  * `gs://bucket_name/a/&#42;&#47;b`: matches all files in `bucket_name` that match
     *                              `a/&#42;&#47;b` pattern, such as `a/c/b`, `a/d/b`
     *  * `gs://another_bucket/a.txt`: matches `gs://another_bucket/a.txt`
     * </pre>
     *
     * <code>repeated string file_patterns = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return A list containing the filePatterns.
     */
    public com.google.protobuf.ProtocolStringList getFilePatternsList() {
      return filePatterns_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * Required. Patterns to identify a set of files in Google Cloud Storage. See [Cloud
     * Storage documentation](storage/docs/gsutil/addlhelp/WildcardNames) for
     * more information. Note that bucket wildcards are currently not supported.
     * Examples of valid file_patterns:
     *  * `gs://bucket_name/dir/&#42;`: matches all files within `bucket_name/dir`
     *                              directory.
     *  * `gs://bucket_name/dir/&#42;*`: matches all files in `bucket_name/dir`
     *                               spanning all subdirectories.
     *  * `gs://bucket_name/file*`: matches files prefixed by `file` in
     *                              `bucket_name`
     *  * `gs://bucket_name/a/&#42;&#47;b`: matches all files in `bucket_name` that match
     *                              `a/&#42;&#47;b` pattern, such as `a/c/b`, `a/d/b`
     *  * `gs://another_bucket/a.txt`: matches `gs://another_bucket/a.txt`
     * </pre>
     *
     * <code>repeated string file_patterns = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The count of filePatterns.
     */
    public int getFilePatternsCount() {
      return filePatterns_.size();
    }
    /**
     *
     *
     * <pre>
     * Required. Patterns to identify a set of files in Google Cloud Storage. See [Cloud
     * Storage documentation](storage/docs/gsutil/addlhelp/WildcardNames) for
     * more information. Note that bucket wildcards are currently not supported.
     * Examples of valid file_patterns:
     *  * `gs://bucket_name/dir/&#42;`: matches all files within `bucket_name/dir`
     *                              directory.
     *  * `gs://bucket_name/dir/&#42;*`: matches all files in `bucket_name/dir`
     *                               spanning all subdirectories.
     *  * `gs://bucket_name/file*`: matches files prefixed by `file` in
     *                              `bucket_name`
     *  * `gs://bucket_name/a/&#42;&#47;b`: matches all files in `bucket_name` that match
     *                              `a/&#42;&#47;b` pattern, such as `a/c/b`, `a/d/b`
     *  * `gs://another_bucket/a.txt`: matches `gs://another_bucket/a.txt`
     * </pre>
     *
     * <code>repeated string file_patterns = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the element to return.
     * @return The filePatterns at the given index.
     */
    public java.lang.String getFilePatterns(int index) {
      return filePatterns_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Required. Patterns to identify a set of files in Google Cloud Storage. See [Cloud
     * Storage documentation](storage/docs/gsutil/addlhelp/WildcardNames) for
     * more information. Note that bucket wildcards are currently not supported.
     * Examples of valid file_patterns:
     *  * `gs://bucket_name/dir/&#42;`: matches all files within `bucket_name/dir`
     *                              directory.
     *  * `gs://bucket_name/dir/&#42;*`: matches all files in `bucket_name/dir`
     *                               spanning all subdirectories.
     *  * `gs://bucket_name/file*`: matches files prefixed by `file` in
     *                              `bucket_name`
     *  * `gs://bucket_name/a/&#42;&#47;b`: matches all files in `bucket_name` that match
     *                              `a/&#42;&#47;b` pattern, such as `a/c/b`, `a/d/b`
     *  * `gs://another_bucket/a.txt`: matches `gs://another_bucket/a.txt`
     * </pre>
     *
     * <code>repeated string file_patterns = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the filePatterns at the given index.
     */
    public com.google.protobuf.ByteString getFilePatternsBytes(int index) {
      return filePatterns_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Required. Patterns to identify a set of files in Google Cloud Storage. See [Cloud
     * Storage documentation](storage/docs/gsutil/addlhelp/WildcardNames) for
     * more information. Note that bucket wildcards are currently not supported.
     * Examples of valid file_patterns:
     *  * `gs://bucket_name/dir/&#42;`: matches all files within `bucket_name/dir`
     *                              directory.
     *  * `gs://bucket_name/dir/&#42;*`: matches all files in `bucket_name/dir`
     *                               spanning all subdirectories.
     *  * `gs://bucket_name/file*`: matches files prefixed by `file` in
     *                              `bucket_name`
     *  * `gs://bucket_name/a/&#42;&#47;b`: matches all files in `bucket_name` that match
     *                              `a/&#42;&#47;b` pattern, such as `a/c/b`, `a/d/b`
     *  * `gs://another_bucket/a.txt`: matches `gs://another_bucket/a.txt`
     * </pre>
     *
     * <code>repeated string file_patterns = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index to set the value at.
     * @param value The filePatterns to set.
     * @return This builder for chaining.
     */
    public Builder setFilePatterns(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureFilePatternsIsMutable();
      filePatterns_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Patterns to identify a set of files in Google Cloud Storage. See [Cloud
     * Storage documentation](storage/docs/gsutil/addlhelp/WildcardNames) for
     * more information. Note that bucket wildcards are currently not supported.
     * Examples of valid file_patterns:
     *  * `gs://bucket_name/dir/&#42;`: matches all files within `bucket_name/dir`
     *                              directory.
     *  * `gs://bucket_name/dir/&#42;*`: matches all files in `bucket_name/dir`
     *                               spanning all subdirectories.
     *  * `gs://bucket_name/file*`: matches files prefixed by `file` in
     *                              `bucket_name`
     *  * `gs://bucket_name/a/&#42;&#47;b`: matches all files in `bucket_name` that match
     *                              `a/&#42;&#47;b` pattern, such as `a/c/b`, `a/d/b`
     *  * `gs://another_bucket/a.txt`: matches `gs://another_bucket/a.txt`
     * </pre>
     *
     * <code>repeated string file_patterns = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The filePatterns to add.
     * @return This builder for chaining.
     */
    public Builder addFilePatterns(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureFilePatternsIsMutable();
      filePatterns_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Patterns to identify a set of files in Google Cloud Storage. See [Cloud
     * Storage documentation](storage/docs/gsutil/addlhelp/WildcardNames) for
     * more information. Note that bucket wildcards are currently not supported.
     * Examples of valid file_patterns:
     *  * `gs://bucket_name/dir/&#42;`: matches all files within `bucket_name/dir`
     *                              directory.
     *  * `gs://bucket_name/dir/&#42;*`: matches all files in `bucket_name/dir`
     *                               spanning all subdirectories.
     *  * `gs://bucket_name/file*`: matches files prefixed by `file` in
     *                              `bucket_name`
     *  * `gs://bucket_name/a/&#42;&#47;b`: matches all files in `bucket_name` that match
     *                              `a/&#42;&#47;b` pattern, such as `a/c/b`, `a/d/b`
     *  * `gs://another_bucket/a.txt`: matches `gs://another_bucket/a.txt`
     * </pre>
     *
     * <code>repeated string file_patterns = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param values The filePatterns to add.
     * @return This builder for chaining.
     */
    public Builder addAllFilePatterns(java.lang.Iterable<java.lang.String> values) {
      ensureFilePatternsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, filePatterns_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Patterns to identify a set of files in Google Cloud Storage. See [Cloud
     * Storage documentation](storage/docs/gsutil/addlhelp/WildcardNames) for
     * more information. Note that bucket wildcards are currently not supported.
     * Examples of valid file_patterns:
     *  * `gs://bucket_name/dir/&#42;`: matches all files within `bucket_name/dir`
     *                              directory.
     *  * `gs://bucket_name/dir/&#42;*`: matches all files in `bucket_name/dir`
     *                               spanning all subdirectories.
     *  * `gs://bucket_name/file*`: matches files prefixed by `file` in
     *                              `bucket_name`
     *  * `gs://bucket_name/a/&#42;&#47;b`: matches all files in `bucket_name` that match
     *                              `a/&#42;&#47;b` pattern, such as `a/c/b`, `a/d/b`
     *  * `gs://another_bucket/a.txt`: matches `gs://another_bucket/a.txt`
     * </pre>
     *
     * <code>repeated string file_patterns = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFilePatterns() {
      filePatterns_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Patterns to identify a set of files in Google Cloud Storage. See [Cloud
     * Storage documentation](storage/docs/gsutil/addlhelp/WildcardNames) for
     * more information. Note that bucket wildcards are currently not supported.
     * Examples of valid file_patterns:
     *  * `gs://bucket_name/dir/&#42;`: matches all files within `bucket_name/dir`
     *                              directory.
     *  * `gs://bucket_name/dir/&#42;*`: matches all files in `bucket_name/dir`
     *                               spanning all subdirectories.
     *  * `gs://bucket_name/file*`: matches files prefixed by `file` in
     *                              `bucket_name`
     *  * `gs://bucket_name/a/&#42;&#47;b`: matches all files in `bucket_name` that match
     *                              `a/&#42;&#47;b` pattern, such as `a/c/b`, `a/d/b`
     *  * `gs://another_bucket/a.txt`: matches `gs://another_bucket/a.txt`
     * </pre>
     *
     * <code>repeated string file_patterns = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes of the filePatterns to add.
     * @return This builder for chaining.
     */
    public Builder addFilePatternsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureFilePatternsIsMutable();
      filePatterns_.add(value);
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.datacatalog.v1beta1.GcsFileSpec> sampleGcsFileSpecs_ =
        java.util.Collections.emptyList();

    private void ensureSampleGcsFileSpecsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        sampleGcsFileSpecs_ =
            new java.util.ArrayList<com.google.cloud.datacatalog.v1beta1.GcsFileSpec>(
                sampleGcsFileSpecs_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.datacatalog.v1beta1.GcsFileSpec,
            com.google.cloud.datacatalog.v1beta1.GcsFileSpec.Builder,
            com.google.cloud.datacatalog.v1beta1.GcsFileSpecOrBuilder>
        sampleGcsFileSpecsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Sample files contained in this fileset, not all files contained in this
     * fileset are represented here.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1beta1.GcsFileSpec sample_gcs_file_specs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.datacatalog.v1beta1.GcsFileSpec>
        getSampleGcsFileSpecsList() {
      if (sampleGcsFileSpecsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(sampleGcsFileSpecs_);
      } else {
        return sampleGcsFileSpecsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Sample files contained in this fileset, not all files contained in this
     * fileset are represented here.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1beta1.GcsFileSpec sample_gcs_file_specs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getSampleGcsFileSpecsCount() {
      if (sampleGcsFileSpecsBuilder_ == null) {
        return sampleGcsFileSpecs_.size();
      } else {
        return sampleGcsFileSpecsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Sample files contained in this fileset, not all files contained in this
     * fileset are represented here.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1beta1.GcsFileSpec sample_gcs_file_specs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.datacatalog.v1beta1.GcsFileSpec getSampleGcsFileSpecs(int index) {
      if (sampleGcsFileSpecsBuilder_ == null) {
        return sampleGcsFileSpecs_.get(index);
      } else {
        return sampleGcsFileSpecsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Sample files contained in this fileset, not all files contained in this
     * fileset are represented here.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1beta1.GcsFileSpec sample_gcs_file_specs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setSampleGcsFileSpecs(
        int index, com.google.cloud.datacatalog.v1beta1.GcsFileSpec value) {
      if (sampleGcsFileSpecsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSampleGcsFileSpecsIsMutable();
        sampleGcsFileSpecs_.set(index, value);
        onChanged();
      } else {
        sampleGcsFileSpecsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Sample files contained in this fileset, not all files contained in this
     * fileset are represented here.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1beta1.GcsFileSpec sample_gcs_file_specs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setSampleGcsFileSpecs(
        int index, com.google.cloud.datacatalog.v1beta1.GcsFileSpec.Builder builderForValue) {
      if (sampleGcsFileSpecsBuilder_ == null) {
        ensureSampleGcsFileSpecsIsMutable();
        sampleGcsFileSpecs_.set(index, builderForValue.build());
        onChanged();
      } else {
        sampleGcsFileSpecsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Sample files contained in this fileset, not all files contained in this
     * fileset are represented here.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1beta1.GcsFileSpec sample_gcs_file_specs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addSampleGcsFileSpecs(com.google.cloud.datacatalog.v1beta1.GcsFileSpec value) {
      if (sampleGcsFileSpecsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSampleGcsFileSpecsIsMutable();
        sampleGcsFileSpecs_.add(value);
        onChanged();
      } else {
        sampleGcsFileSpecsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Sample files contained in this fileset, not all files contained in this
     * fileset are represented here.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1beta1.GcsFileSpec sample_gcs_file_specs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addSampleGcsFileSpecs(
        int index, com.google.cloud.datacatalog.v1beta1.GcsFileSpec value) {
      if (sampleGcsFileSpecsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSampleGcsFileSpecsIsMutable();
        sampleGcsFileSpecs_.add(index, value);
        onChanged();
      } else {
        sampleGcsFileSpecsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Sample files contained in this fileset, not all files contained in this
     * fileset are represented here.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1beta1.GcsFileSpec sample_gcs_file_specs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addSampleGcsFileSpecs(
        com.google.cloud.datacatalog.v1beta1.GcsFileSpec.Builder builderForValue) {
      if (sampleGcsFileSpecsBuilder_ == null) {
        ensureSampleGcsFileSpecsIsMutable();
        sampleGcsFileSpecs_.add(builderForValue.build());
        onChanged();
      } else {
        sampleGcsFileSpecsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Sample files contained in this fileset, not all files contained in this
     * fileset are represented here.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1beta1.GcsFileSpec sample_gcs_file_specs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addSampleGcsFileSpecs(
        int index, com.google.cloud.datacatalog.v1beta1.GcsFileSpec.Builder builderForValue) {
      if (sampleGcsFileSpecsBuilder_ == null) {
        ensureSampleGcsFileSpecsIsMutable();
        sampleGcsFileSpecs_.add(index, builderForValue.build());
        onChanged();
      } else {
        sampleGcsFileSpecsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Sample files contained in this fileset, not all files contained in this
     * fileset are represented here.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1beta1.GcsFileSpec sample_gcs_file_specs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllSampleGcsFileSpecs(
        java.lang.Iterable<? extends com.google.cloud.datacatalog.v1beta1.GcsFileSpec> values) {
      if (sampleGcsFileSpecsBuilder_ == null) {
        ensureSampleGcsFileSpecsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, sampleGcsFileSpecs_);
        onChanged();
      } else {
        sampleGcsFileSpecsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Sample files contained in this fileset, not all files contained in this
     * fileset are represented here.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1beta1.GcsFileSpec sample_gcs_file_specs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearSampleGcsFileSpecs() {
      if (sampleGcsFileSpecsBuilder_ == null) {
        sampleGcsFileSpecs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        sampleGcsFileSpecsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Sample files contained in this fileset, not all files contained in this
     * fileset are represented here.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1beta1.GcsFileSpec sample_gcs_file_specs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeSampleGcsFileSpecs(int index) {
      if (sampleGcsFileSpecsBuilder_ == null) {
        ensureSampleGcsFileSpecsIsMutable();
        sampleGcsFileSpecs_.remove(index);
        onChanged();
      } else {
        sampleGcsFileSpecsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Sample files contained in this fileset, not all files contained in this
     * fileset are represented here.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1beta1.GcsFileSpec sample_gcs_file_specs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.datacatalog.v1beta1.GcsFileSpec.Builder getSampleGcsFileSpecsBuilder(
        int index) {
      return getSampleGcsFileSpecsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Sample files contained in this fileset, not all files contained in this
     * fileset are represented here.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1beta1.GcsFileSpec sample_gcs_file_specs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.datacatalog.v1beta1.GcsFileSpecOrBuilder getSampleGcsFileSpecsOrBuilder(
        int index) {
      if (sampleGcsFileSpecsBuilder_ == null) {
        return sampleGcsFileSpecs_.get(index);
      } else {
        return sampleGcsFileSpecsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Sample files contained in this fileset, not all files contained in this
     * fileset are represented here.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1beta1.GcsFileSpec sample_gcs_file_specs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.datacatalog.v1beta1.GcsFileSpecOrBuilder>
        getSampleGcsFileSpecsOrBuilderList() {
      if (sampleGcsFileSpecsBuilder_ != null) {
        return sampleGcsFileSpecsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(sampleGcsFileSpecs_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Sample files contained in this fileset, not all files contained in this
     * fileset are represented here.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1beta1.GcsFileSpec sample_gcs_file_specs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.datacatalog.v1beta1.GcsFileSpec.Builder addSampleGcsFileSpecsBuilder() {
      return getSampleGcsFileSpecsFieldBuilder()
          .addBuilder(com.google.cloud.datacatalog.v1beta1.GcsFileSpec.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Sample files contained in this fileset, not all files contained in this
     * fileset are represented here.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1beta1.GcsFileSpec sample_gcs_file_specs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.datacatalog.v1beta1.GcsFileSpec.Builder addSampleGcsFileSpecsBuilder(
        int index) {
      return getSampleGcsFileSpecsFieldBuilder()
          .addBuilder(index, com.google.cloud.datacatalog.v1beta1.GcsFileSpec.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Sample files contained in this fileset, not all files contained in this
     * fileset are represented here.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1beta1.GcsFileSpec sample_gcs_file_specs = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.datacatalog.v1beta1.GcsFileSpec.Builder>
        getSampleGcsFileSpecsBuilderList() {
      return getSampleGcsFileSpecsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.datacatalog.v1beta1.GcsFileSpec,
            com.google.cloud.datacatalog.v1beta1.GcsFileSpec.Builder,
            com.google.cloud.datacatalog.v1beta1.GcsFileSpecOrBuilder>
        getSampleGcsFileSpecsFieldBuilder() {
      if (sampleGcsFileSpecsBuilder_ == null) {
        sampleGcsFileSpecsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.datacatalog.v1beta1.GcsFileSpec,
                com.google.cloud.datacatalog.v1beta1.GcsFileSpec.Builder,
                com.google.cloud.datacatalog.v1beta1.GcsFileSpecOrBuilder>(
                sampleGcsFileSpecs_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        sampleGcsFileSpecs_ = null;
      }
      return sampleGcsFileSpecsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datacatalog.v1beta1.GcsFilesetSpec)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datacatalog.v1beta1.GcsFilesetSpec)
  private static final com.google.cloud.datacatalog.v1beta1.GcsFilesetSpec DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datacatalog.v1beta1.GcsFilesetSpec();
  }

  public static com.google.cloud.datacatalog.v1beta1.GcsFilesetSpec getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GcsFilesetSpec> PARSER =
      new com.google.protobuf.AbstractParser<GcsFilesetSpec>() {
        @java.lang.Override
        public GcsFilesetSpec parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new GcsFilesetSpec(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<GcsFilesetSpec> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GcsFilesetSpec> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datacatalog.v1beta1.GcsFilesetSpec getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
