/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datacatalog.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FieldName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/tagTemplates/{tag_template}/fields/{field}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String tagTemplate;
    private final String field;

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getTagTemplate() {
        return this.tagTemplate;
    }

    public String getField() {
        return this.field;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private FieldName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.tagTemplate = (String)Preconditions.checkNotNull((Object)builder.getTagTemplate());
        this.field = (String)Preconditions.checkNotNull((Object)builder.getField());
    }

    public static FieldName of(String project, String location, String tagTemplate, String field) {
        return FieldName.newBuilder().setProject(project).setLocation(location).setTagTemplate(tagTemplate).setField(field).build();
    }

    public static String format(String project, String location, String tagTemplate, String field) {
        return FieldName.newBuilder().setProject(project).setLocation(location).setTagTemplate(tagTemplate).setField(field).build().toString();
    }

    public static FieldName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "FieldName.parse: formattedString not in valid format");
        return FieldName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("tag_template"), (String)matchMap.get("field"));
    }

    public static List<FieldName> parseList(List<String> formattedStrings) {
        ArrayList<FieldName> list = new ArrayList<FieldName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(FieldName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<FieldName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (FieldName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            FieldName fieldName = this;
            synchronized (fieldName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"location", (Object)this.location);
                    fieldMapBuilder.put((Object)"tagTemplate", (Object)this.tagTemplate);
                    fieldMapBuilder.put((Object)"field", (Object)this.field);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location, "tag_template", this.tagTemplate, "field", this.field});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof FieldName) {
            FieldName that = (FieldName)o;
            return this.project.equals(that.project) && this.location.equals(that.location) && this.tagTemplate.equals(that.tagTemplate) && this.field.equals(that.field);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        h ^= this.tagTemplate.hashCode();
        h *= 1000003;
        return h ^= this.field.hashCode();
    }

    public static class Builder {
        private String project;
        private String location;
        private String tagTemplate;
        private String field;

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getTagTemplate() {
            return this.tagTemplate;
        }

        public String getField() {
            return this.field;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setTagTemplate(String tagTemplate) {
            this.tagTemplate = tagTemplate;
            return this;
        }

        public Builder setField(String field) {
            this.field = field;
            return this;
        }

        private Builder() {
        }

        private Builder(FieldName fieldName) {
            this.project = fieldName.project;
            this.location = fieldName.location;
            this.tagTemplate = fieldName.tagTemplate;
            this.field = fieldName.field;
        }

        public FieldName build() {
            return new FieldName(this);
        }
    }
}

