/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datacatalog/v1beta1/tags.proto

package com.google.cloud.datacatalog.v1beta1;

/**
 *
 *
 * <pre>
 * A tag template defines the schema of the tags used to attach to Data Catalog
 * resources. It defines the mapping of accepted field names and types that can
 * be used within the tag. The tag template also controls the access to the tag.
 * </pre>
 *
 * Protobuf type {@code google.cloud.datacatalog.v1beta1.TagTemplate}
 */
public final class TagTemplate extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datacatalog.v1beta1.TagTemplate)
    TagTemplateOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TagTemplate.newBuilder() to construct.
  private TagTemplate(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TagTemplate() {
    name_ = "";
    displayName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TagTemplate();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private TagTemplate(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();

              displayName_ = s;
              break;
            }
          case 26:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                fields_ =
                    com.google.protobuf.MapField.newMapField(FieldsDefaultEntryHolder.defaultEntry);
                mutable_bitField0_ |= 0x00000001;
              }
              com.google.protobuf.MapEntry<
                      java.lang.String, com.google.cloud.datacatalog.v1beta1.TagTemplateField>
                  fields__ =
                      input.readMessage(
                          FieldsDefaultEntryHolder.defaultEntry.getParserForType(),
                          extensionRegistry);
              fields_.getMutableMap().put(fields__.getKey(), fields__.getValue());
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datacatalog.v1beta1.Tags
        .internal_static_google_cloud_datacatalog_v1beta1_TagTemplate_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 3:
        return internalGetFields();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datacatalog.v1beta1.Tags
        .internal_static_google_cloud_datacatalog_v1beta1_TagTemplate_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datacatalog.v1beta1.TagTemplate.class,
            com.google.cloud.datacatalog.v1beta1.TagTemplate.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * The resource name of the tag template in URL format. Example:
   * * projects/{project_id}/locations/{location}/tagTemplates/{tag_template_id}
   * Note that this TagTemplate and its child resources may not actually be
   * stored in the location in this name.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource name of the tag template in URL format. Example:
   * * projects/{project_id}/locations/{location}/tagTemplates/{tag_template_id}
   * Note that this TagTemplate and its child resources may not actually be
   * stored in the location in this name.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;
  private volatile java.lang.Object displayName_;
  /**
   *
   *
   * <pre>
   * The display name for this template. Defaults to an empty string.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The displayName.
   */
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The display name for this template. Defaults to an empty string.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The bytes for displayName.
   */
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FIELDS_FIELD_NUMBER = 3;

  private static final class FieldsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.cloud.datacatalog.v1beta1.TagTemplateField>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.cloud.datacatalog.v1beta1.TagTemplateField>
                    newDefaultInstance(
                        com.google.cloud.datacatalog.v1beta1.Tags
                            .internal_static_google_cloud_datacatalog_v1beta1_TagTemplate_FieldsEntry_descriptor,
                        com.google.protobuf.WireFormat.FieldType.STRING,
                        "",
                        com.google.protobuf.WireFormat.FieldType.MESSAGE,
                        com.google.cloud.datacatalog.v1beta1.TagTemplateField.getDefaultInstance());
  }

  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.datacatalog.v1beta1.TagTemplateField>
      fields_;

  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.datacatalog.v1beta1.TagTemplateField>
      internalGetFields() {
    if (fields_ == null) {
      return com.google.protobuf.MapField.emptyMapField(FieldsDefaultEntryHolder.defaultEntry);
    }
    return fields_;
  }

  public int getFieldsCount() {
    return internalGetFields().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Required. Map of tag template field IDs to the settings for the field.
   * This map is an exhaustive list of the allowed fields. This map must contain
   * at least one field and at most 500 fields.
   * The keys to this map are tag template field IDs. Field IDs can contain
   * letters (both uppercase and lowercase), numbers (0-9) and underscores (_).
   * Field IDs must be at least 1 character long and at most
   * 64 characters long. Field IDs must start with a letter or underscore.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.datacatalog.v1beta1.TagTemplateField&gt; fields = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  public boolean containsFields(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    return internalGetFields().getMap().containsKey(key);
  }
  /** Use {@link #getFieldsMap()} instead. */
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.cloud.datacatalog.v1beta1.TagTemplateField>
      getFields() {
    return getFieldsMap();
  }
  /**
   *
   *
   * <pre>
   * Required. Map of tag template field IDs to the settings for the field.
   * This map is an exhaustive list of the allowed fields. This map must contain
   * at least one field and at most 500 fields.
   * The keys to this map are tag template field IDs. Field IDs can contain
   * letters (both uppercase and lowercase), numbers (0-9) and underscores (_).
   * Field IDs must be at least 1 character long and at most
   * 64 characters long. Field IDs must start with a letter or underscore.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.datacatalog.v1beta1.TagTemplateField&gt; fields = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  public java.util.Map<java.lang.String, com.google.cloud.datacatalog.v1beta1.TagTemplateField>
      getFieldsMap() {
    return internalGetFields().getMap();
  }
  /**
   *
   *
   * <pre>
   * Required. Map of tag template field IDs to the settings for the field.
   * This map is an exhaustive list of the allowed fields. This map must contain
   * at least one field and at most 500 fields.
   * The keys to this map are tag template field IDs. Field IDs can contain
   * letters (both uppercase and lowercase), numbers (0-9) and underscores (_).
   * Field IDs must be at least 1 character long and at most
   * 64 characters long. Field IDs must start with a letter or underscore.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.datacatalog.v1beta1.TagTemplateField&gt; fields = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  public com.google.cloud.datacatalog.v1beta1.TagTemplateField getFieldsOrDefault(
      java.lang.String key, com.google.cloud.datacatalog.v1beta1.TagTemplateField defaultValue) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, com.google.cloud.datacatalog.v1beta1.TagTemplateField> map =
        internalGetFields().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Required. Map of tag template field IDs to the settings for the field.
   * This map is an exhaustive list of the allowed fields. This map must contain
   * at least one field and at most 500 fields.
   * The keys to this map are tag template field IDs. Field IDs can contain
   * letters (both uppercase and lowercase), numbers (0-9) and underscores (_).
   * Field IDs must be at least 1 character long and at most
   * 64 characters long. Field IDs must start with a letter or underscore.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.datacatalog.v1beta1.TagTemplateField&gt; fields = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  public com.google.cloud.datacatalog.v1beta1.TagTemplateField getFieldsOrThrow(
      java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, com.google.cloud.datacatalog.v1beta1.TagTemplateField> map =
        internalGetFields().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!getDisplayNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetFields(), FieldsDefaultEntryHolder.defaultEntry, 3);
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!getDisplayNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    for (java.util.Map.Entry<
            java.lang.String, com.google.cloud.datacatalog.v1beta1.TagTemplateField>
        entry : internalGetFields().getMap().entrySet()) {
      com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.datacatalog.v1beta1.TagTemplateField>
          fields__ =
              FieldsDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, fields__);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datacatalog.v1beta1.TagTemplate)) {
      return super.equals(obj);
    }
    com.google.cloud.datacatalog.v1beta1.TagTemplate other =
        (com.google.cloud.datacatalog.v1beta1.TagTemplate) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!internalGetFields().equals(other.internalGetFields())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (!internalGetFields().getMap().isEmpty()) {
      hash = (37 * hash) + FIELDS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetFields().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datacatalog.v1beta1.TagTemplate parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1beta1.TagTemplate parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1beta1.TagTemplate parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1beta1.TagTemplate parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1beta1.TagTemplate parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1beta1.TagTemplate parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1beta1.TagTemplate parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1beta1.TagTemplate parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1beta1.TagTemplate parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1beta1.TagTemplate parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1beta1.TagTemplate parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1beta1.TagTemplate parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.datacatalog.v1beta1.TagTemplate prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A tag template defines the schema of the tags used to attach to Data Catalog
   * resources. It defines the mapping of accepted field names and types that can
   * be used within the tag. The tag template also controls the access to the tag.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datacatalog.v1beta1.TagTemplate}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datacatalog.v1beta1.TagTemplate)
      com.google.cloud.datacatalog.v1beta1.TagTemplateOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datacatalog.v1beta1.Tags
          .internal_static_google_cloud_datacatalog_v1beta1_TagTemplate_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 3:
          return internalGetFields();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 3:
          return internalGetMutableFields();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datacatalog.v1beta1.Tags
          .internal_static_google_cloud_datacatalog_v1beta1_TagTemplate_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datacatalog.v1beta1.TagTemplate.class,
              com.google.cloud.datacatalog.v1beta1.TagTemplate.Builder.class);
    }

    // Construct using com.google.cloud.datacatalog.v1beta1.TagTemplate.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      displayName_ = "";

      internalGetMutableFields().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datacatalog.v1beta1.Tags
          .internal_static_google_cloud_datacatalog_v1beta1_TagTemplate_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1beta1.TagTemplate getDefaultInstanceForType() {
      return com.google.cloud.datacatalog.v1beta1.TagTemplate.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1beta1.TagTemplate build() {
      com.google.cloud.datacatalog.v1beta1.TagTemplate result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1beta1.TagTemplate buildPartial() {
      com.google.cloud.datacatalog.v1beta1.TagTemplate result =
          new com.google.cloud.datacatalog.v1beta1.TagTemplate(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      result.displayName_ = displayName_;
      result.fields_ = internalGetFields();
      result.fields_.makeImmutable();
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datacatalog.v1beta1.TagTemplate) {
        return mergeFrom((com.google.cloud.datacatalog.v1beta1.TagTemplate) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datacatalog.v1beta1.TagTemplate other) {
      if (other == com.google.cloud.datacatalog.v1beta1.TagTemplate.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        onChanged();
      }
      internalGetMutableFields().mergeFrom(other.internalGetFields());
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.datacatalog.v1beta1.TagTemplate parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.datacatalog.v1beta1.TagTemplate) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The resource name of the tag template in URL format. Example:
     * * projects/{project_id}/locations/{location}/tagTemplates/{tag_template_id}
     * Note that this TagTemplate and its child resources may not actually be
     * stored in the location in this name.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the tag template in URL format. Example:
     * * projects/{project_id}/locations/{location}/tagTemplates/{tag_template_id}
     * Note that this TagTemplate and its child resources may not actually be
     * stored in the location in this name.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource name of the tag template in URL format. Example:
     * * projects/{project_id}/locations/{location}/tagTemplates/{tag_template_id}
     * Note that this TagTemplate and its child resources may not actually be
     * stored in the location in this name.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the tag template in URL format. Example:
     * * projects/{project_id}/locations/{location}/tagTemplates/{tag_template_id}
     * Note that this TagTemplate and its child resources may not actually be
     * stored in the location in this name.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource name of the tag template in URL format. Example:
     * * projects/{project_id}/locations/{location}/tagTemplates/{tag_template_id}
     * Note that this TagTemplate and its child resources may not actually be
     * stored in the location in this name.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * The display name for this template. Defaults to an empty string.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The display name for this template. Defaults to an empty string.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The display name for this template. Defaults to an empty string.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      displayName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The display name for this template. Defaults to an empty string.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {

      displayName_ = getDefaultInstance().getDisplayName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The display name for this template. Defaults to an empty string.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      displayName_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.datacatalog.v1beta1.TagTemplateField>
        fields_;

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.datacatalog.v1beta1.TagTemplateField>
        internalGetFields() {
      if (fields_ == null) {
        return com.google.protobuf.MapField.emptyMapField(FieldsDefaultEntryHolder.defaultEntry);
      }
      return fields_;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.datacatalog.v1beta1.TagTemplateField>
        internalGetMutableFields() {
      onChanged();
      ;
      if (fields_ == null) {
        fields_ = com.google.protobuf.MapField.newMapField(FieldsDefaultEntryHolder.defaultEntry);
      }
      if (!fields_.isMutable()) {
        fields_ = fields_.copy();
      }
      return fields_;
    }

    public int getFieldsCount() {
      return internalGetFields().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Required. Map of tag template field IDs to the settings for the field.
     * This map is an exhaustive list of the allowed fields. This map must contain
     * at least one field and at most 500 fields.
     * The keys to this map are tag template field IDs. Field IDs can contain
     * letters (both uppercase and lowercase), numbers (0-9) and underscores (_).
     * Field IDs must be at least 1 character long and at most
     * 64 characters long. Field IDs must start with a letter or underscore.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.datacatalog.v1beta1.TagTemplateField&gt; fields = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public boolean containsFields(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      return internalGetFields().getMap().containsKey(key);
    }
    /** Use {@link #getFieldsMap()} instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.datacatalog.v1beta1.TagTemplateField>
        getFields() {
      return getFieldsMap();
    }
    /**
     *
     *
     * <pre>
     * Required. Map of tag template field IDs to the settings for the field.
     * This map is an exhaustive list of the allowed fields. This map must contain
     * at least one field and at most 500 fields.
     * The keys to this map are tag template field IDs. Field IDs can contain
     * letters (both uppercase and lowercase), numbers (0-9) and underscores (_).
     * Field IDs must be at least 1 character long and at most
     * 64 characters long. Field IDs must start with a letter or underscore.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.datacatalog.v1beta1.TagTemplateField&gt; fields = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.Map<java.lang.String, com.google.cloud.datacatalog.v1beta1.TagTemplateField>
        getFieldsMap() {
      return internalGetFields().getMap();
    }
    /**
     *
     *
     * <pre>
     * Required. Map of tag template field IDs to the settings for the field.
     * This map is an exhaustive list of the allowed fields. This map must contain
     * at least one field and at most 500 fields.
     * The keys to this map are tag template field IDs. Field IDs can contain
     * letters (both uppercase and lowercase), numbers (0-9) and underscores (_).
     * Field IDs must be at least 1 character long and at most
     * 64 characters long. Field IDs must start with a letter or underscore.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.datacatalog.v1beta1.TagTemplateField&gt; fields = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.datacatalog.v1beta1.TagTemplateField getFieldsOrDefault(
        java.lang.String key, com.google.cloud.datacatalog.v1beta1.TagTemplateField defaultValue) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, com.google.cloud.datacatalog.v1beta1.TagTemplateField> map =
          internalGetFields().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Required. Map of tag template field IDs to the settings for the field.
     * This map is an exhaustive list of the allowed fields. This map must contain
     * at least one field and at most 500 fields.
     * The keys to this map are tag template field IDs. Field IDs can contain
     * letters (both uppercase and lowercase), numbers (0-9) and underscores (_).
     * Field IDs must be at least 1 character long and at most
     * 64 characters long. Field IDs must start with a letter or underscore.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.datacatalog.v1beta1.TagTemplateField&gt; fields = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.datacatalog.v1beta1.TagTemplateField getFieldsOrThrow(
        java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, com.google.cloud.datacatalog.v1beta1.TagTemplateField> map =
          internalGetFields().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearFields() {
      internalGetMutableFields().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Map of tag template field IDs to the settings for the field.
     * This map is an exhaustive list of the allowed fields. This map must contain
     * at least one field and at most 500 fields.
     * The keys to this map are tag template field IDs. Field IDs can contain
     * letters (both uppercase and lowercase), numbers (0-9) and underscores (_).
     * Field IDs must be at least 1 character long and at most
     * 64 characters long. Field IDs must start with a letter or underscore.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.datacatalog.v1beta1.TagTemplateField&gt; fields = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeFields(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableFields().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.datacatalog.v1beta1.TagTemplateField>
        getMutableFields() {
      return internalGetMutableFields().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Required. Map of tag template field IDs to the settings for the field.
     * This map is an exhaustive list of the allowed fields. This map must contain
     * at least one field and at most 500 fields.
     * The keys to this map are tag template field IDs. Field IDs can contain
     * letters (both uppercase and lowercase), numbers (0-9) and underscores (_).
     * Field IDs must be at least 1 character long and at most
     * 64 characters long. Field IDs must start with a letter or underscore.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.datacatalog.v1beta1.TagTemplateField&gt; fields = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder putFields(
        java.lang.String key, com.google.cloud.datacatalog.v1beta1.TagTemplateField value) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      if (value == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableFields().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Map of tag template field IDs to the settings for the field.
     * This map is an exhaustive list of the allowed fields. This map must contain
     * at least one field and at most 500 fields.
     * The keys to this map are tag template field IDs. Field IDs can contain
     * letters (both uppercase and lowercase), numbers (0-9) and underscores (_).
     * Field IDs must be at least 1 character long and at most
     * 64 characters long. Field IDs must start with a letter or underscore.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.datacatalog.v1beta1.TagTemplateField&gt; fields = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder putAllFields(
        java.util.Map<java.lang.String, com.google.cloud.datacatalog.v1beta1.TagTemplateField>
            values) {
      internalGetMutableFields().getMutableMap().putAll(values);
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datacatalog.v1beta1.TagTemplate)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datacatalog.v1beta1.TagTemplate)
  private static final com.google.cloud.datacatalog.v1beta1.TagTemplate DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datacatalog.v1beta1.TagTemplate();
  }

  public static com.google.cloud.datacatalog.v1beta1.TagTemplate getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TagTemplate> PARSER =
      new com.google.protobuf.AbstractParser<TagTemplate>() {
        @java.lang.Override
        public TagTemplate parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new TagTemplate(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<TagTemplate> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TagTemplate> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datacatalog.v1beta1.TagTemplate getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
