/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datacatalog/v1beta1/policytagmanager.proto

package com.google.cloud.datacatalog.v1beta1;

/**
 *
 *
 * <pre>
 * A taxonomy is a collection of policy tags that classify data along a common
 * axis. For instance a data *sensitivity* taxonomy could contain policy tags
 * denoting PII such as age, zipcode, and SSN. A data *origin* taxonomy could
 * contain policy tags to distinguish user data, employee data, partner data,
 * public data.
 * </pre>
 *
 * Protobuf type {@code google.cloud.datacatalog.v1beta1.Taxonomy}
 */
public final class Taxonomy extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datacatalog.v1beta1.Taxonomy)
    TaxonomyOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Taxonomy.newBuilder() to construct.
  private Taxonomy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Taxonomy() {
    name_ = "";
    displayName_ = "";
    description_ = "";
    activatedPolicyTypes_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Taxonomy();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datacatalog.v1beta1.PolicyTagManagerProto
        .internal_static_google_cloud_datacatalog_v1beta1_Taxonomy_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datacatalog.v1beta1.PolicyTagManagerProto
        .internal_static_google_cloud_datacatalog_v1beta1_Taxonomy_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datacatalog.v1beta1.Taxonomy.class,
            com.google.cloud.datacatalog.v1beta1.Taxonomy.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Defines policy types where policy tag can be used for.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.datacatalog.v1beta1.Taxonomy.PolicyType}
   */
  public enum PolicyType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified policy type.
     * </pre>
     *
     * <code>POLICY_TYPE_UNSPECIFIED = 0;</code>
     */
    POLICY_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Fine grained access control policy, which enables access control on
     * tagged resources.
     * </pre>
     *
     * <code>FINE_GRAINED_ACCESS_CONTROL = 1;</code>
     */
    FINE_GRAINED_ACCESS_CONTROL(1),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified policy type.
     * </pre>
     *
     * <code>POLICY_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int POLICY_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Fine grained access control policy, which enables access control on
     * tagged resources.
     * </pre>
     *
     * <code>FINE_GRAINED_ACCESS_CONTROL = 1;</code>
     */
    public static final int FINE_GRAINED_ACCESS_CONTROL_VALUE = 1;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PolicyType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static PolicyType forNumber(int value) {
      switch (value) {
        case 0:
          return POLICY_TYPE_UNSPECIFIED;
        case 1:
          return FINE_GRAINED_ACCESS_CONTROL;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<PolicyType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<PolicyType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<PolicyType>() {
          public PolicyType findValueByNumber(int number) {
            return PolicyType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.datacatalog.v1beta1.Taxonomy.getDescriptor().getEnumTypes().get(0);
    }

    private static final PolicyType[] VALUES = values();

    public static PolicyType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private PolicyType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.datacatalog.v1beta1.Taxonomy.PolicyType)
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Output only. Resource name of this taxonomy, whose format is:
   * "projects/{project_number}/locations/{location_id}/taxonomies/{id}".
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Resource name of this taxonomy, whose format is:
   * "projects/{project_number}/locations/{location_id}/taxonomies/{id}".
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;
  private volatile java.lang.Object displayName_;
  /**
   *
   *
   * <pre>
   * Required. User defined name of this taxonomy. It must: contain only unicode letters,
   * numbers, underscores, dashes and spaces; not start or end with spaces; and
   * be at most 200 bytes long when encoded in UTF-8.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. User defined name of this taxonomy. It must: contain only unicode letters,
   * numbers, underscores, dashes and spaces; not start or end with spaces; and
   * be at most 200 bytes long when encoded in UTF-8.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 3;
  private volatile java.lang.Object description_;
  /**
   *
   *
   * <pre>
   * Optional. Description of this taxonomy. It must: contain only unicode characters,
   * tabs, newlines, carriage returns and page breaks; and be at most 2000 bytes
   * long when encoded in UTF-8. If not set, defaults to an empty description.
   * </pre>
   *
   * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Description of this taxonomy. It must: contain only unicode characters,
   * tabs, newlines, carriage returns and page breaks; and be at most 2000 bytes
   * long when encoded in UTF-8. If not set, defaults to an empty description.
   * </pre>
   *
   * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ACTIVATED_POLICY_TYPES_FIELD_NUMBER = 6;
  private java.util.List<java.lang.Integer> activatedPolicyTypes_;
  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.cloud.datacatalog.v1beta1.Taxonomy.PolicyType>
      activatedPolicyTypes_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.cloud.datacatalog.v1beta1.Taxonomy.PolicyType>() {
            public com.google.cloud.datacatalog.v1beta1.Taxonomy.PolicyType convert(
                java.lang.Integer from) {
              @SuppressWarnings("deprecation")
              com.google.cloud.datacatalog.v1beta1.Taxonomy.PolicyType result =
                  com.google.cloud.datacatalog.v1beta1.Taxonomy.PolicyType.valueOf(from);
              return result == null
                  ? com.google.cloud.datacatalog.v1beta1.Taxonomy.PolicyType.UNRECOGNIZED
                  : result;
            }
          };
  /**
   *
   *
   * <pre>
   * Optional. A list of policy types that are activated for this taxonomy. If not set,
   * defaults to an empty list.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datacatalog.v1beta1.Taxonomy.PolicyType activated_policy_types = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return A list containing the activatedPolicyTypes.
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.datacatalog.v1beta1.Taxonomy.PolicyType>
      getActivatedPolicyTypesList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.cloud.datacatalog.v1beta1.Taxonomy.PolicyType>(
        activatedPolicyTypes_, activatedPolicyTypes_converter_);
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of policy types that are activated for this taxonomy. If not set,
   * defaults to an empty list.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datacatalog.v1beta1.Taxonomy.PolicyType activated_policy_types = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The count of activatedPolicyTypes.
   */
  @java.lang.Override
  public int getActivatedPolicyTypesCount() {
    return activatedPolicyTypes_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of policy types that are activated for this taxonomy. If not set,
   * defaults to an empty list.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datacatalog.v1beta1.Taxonomy.PolicyType activated_policy_types = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The activatedPolicyTypes at the given index.
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1beta1.Taxonomy.PolicyType getActivatedPolicyTypes(
      int index) {
    return activatedPolicyTypes_converter_.convert(activatedPolicyTypes_.get(index));
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of policy types that are activated for this taxonomy. If not set,
   * defaults to an empty list.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datacatalog.v1beta1.Taxonomy.PolicyType activated_policy_types = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return A list containing the enum numeric values on the wire for activatedPolicyTypes.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getActivatedPolicyTypesValueList() {
    return activatedPolicyTypes_;
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of policy types that are activated for this taxonomy. If not set,
   * defaults to an empty list.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datacatalog.v1beta1.Taxonomy.PolicyType activated_policy_types = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of activatedPolicyTypes at the given index.
   */
  @java.lang.Override
  public int getActivatedPolicyTypesValue(int index) {
    return activatedPolicyTypes_.get(index);
  }

  private int activatedPolicyTypesMemoizedSerializedSize;

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, description_);
    }
    if (getActivatedPolicyTypesList().size() > 0) {
      output.writeUInt32NoTag(50);
      output.writeUInt32NoTag(activatedPolicyTypesMemoizedSerializedSize);
    }
    for (int i = 0; i < activatedPolicyTypes_.size(); i++) {
      output.writeEnumNoTag(activatedPolicyTypes_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, description_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < activatedPolicyTypes_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(
                activatedPolicyTypes_.get(i));
      }
      size += dataSize;
      if (!getActivatedPolicyTypesList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      activatedPolicyTypesMemoizedSerializedSize = dataSize;
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datacatalog.v1beta1.Taxonomy)) {
      return super.equals(obj);
    }
    com.google.cloud.datacatalog.v1beta1.Taxonomy other =
        (com.google.cloud.datacatalog.v1beta1.Taxonomy) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!activatedPolicyTypes_.equals(other.activatedPolicyTypes_)) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (getActivatedPolicyTypesCount() > 0) {
      hash = (37 * hash) + ACTIVATED_POLICY_TYPES_FIELD_NUMBER;
      hash = (53 * hash) + activatedPolicyTypes_.hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datacatalog.v1beta1.Taxonomy parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1beta1.Taxonomy parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1beta1.Taxonomy parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1beta1.Taxonomy parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1beta1.Taxonomy parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1beta1.Taxonomy parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1beta1.Taxonomy parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1beta1.Taxonomy parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1beta1.Taxonomy parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1beta1.Taxonomy parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1beta1.Taxonomy parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1beta1.Taxonomy parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.datacatalog.v1beta1.Taxonomy prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A taxonomy is a collection of policy tags that classify data along a common
   * axis. For instance a data *sensitivity* taxonomy could contain policy tags
   * denoting PII such as age, zipcode, and SSN. A data *origin* taxonomy could
   * contain policy tags to distinguish user data, employee data, partner data,
   * public data.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datacatalog.v1beta1.Taxonomy}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datacatalog.v1beta1.Taxonomy)
      com.google.cloud.datacatalog.v1beta1.TaxonomyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datacatalog.v1beta1.PolicyTagManagerProto
          .internal_static_google_cloud_datacatalog_v1beta1_Taxonomy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datacatalog.v1beta1.PolicyTagManagerProto
          .internal_static_google_cloud_datacatalog_v1beta1_Taxonomy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datacatalog.v1beta1.Taxonomy.class,
              com.google.cloud.datacatalog.v1beta1.Taxonomy.Builder.class);
    }

    // Construct using com.google.cloud.datacatalog.v1beta1.Taxonomy.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      displayName_ = "";

      description_ = "";

      activatedPolicyTypes_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datacatalog.v1beta1.PolicyTagManagerProto
          .internal_static_google_cloud_datacatalog_v1beta1_Taxonomy_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1beta1.Taxonomy getDefaultInstanceForType() {
      return com.google.cloud.datacatalog.v1beta1.Taxonomy.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1beta1.Taxonomy build() {
      com.google.cloud.datacatalog.v1beta1.Taxonomy result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1beta1.Taxonomy buildPartial() {
      com.google.cloud.datacatalog.v1beta1.Taxonomy result =
          new com.google.cloud.datacatalog.v1beta1.Taxonomy(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      result.displayName_ = displayName_;
      result.description_ = description_;
      if (((bitField0_ & 0x00000001) != 0)) {
        activatedPolicyTypes_ = java.util.Collections.unmodifiableList(activatedPolicyTypes_);
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.activatedPolicyTypes_ = activatedPolicyTypes_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datacatalog.v1beta1.Taxonomy) {
        return mergeFrom((com.google.cloud.datacatalog.v1beta1.Taxonomy) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datacatalog.v1beta1.Taxonomy other) {
      if (other == com.google.cloud.datacatalog.v1beta1.Taxonomy.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        onChanged();
      }
      if (!other.activatedPolicyTypes_.isEmpty()) {
        if (activatedPolicyTypes_.isEmpty()) {
          activatedPolicyTypes_ = other.activatedPolicyTypes_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureActivatedPolicyTypesIsMutable();
          activatedPolicyTypes_.addAll(other.activatedPolicyTypes_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();

                break;
              } // case 18
            case 26:
              {
                description_ = input.readStringRequireUtf8();

                break;
              } // case 26
            case 48:
              {
                int tmpRaw = input.readEnum();
                ensureActivatedPolicyTypesIsMutable();
                activatedPolicyTypes_.add(tmpRaw);
                break;
              } // case 48
            case 50:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureActivatedPolicyTypesIsMutable();
                  activatedPolicyTypes_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Resource name of this taxonomy, whose format is:
     * "projects/{project_number}/locations/{location_id}/taxonomies/{id}".
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of this taxonomy, whose format is:
     * "projects/{project_number}/locations/{location_id}/taxonomies/{id}".
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of this taxonomy, whose format is:
     * "projects/{project_number}/locations/{location_id}/taxonomies/{id}".
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of this taxonomy, whose format is:
     * "projects/{project_number}/locations/{location_id}/taxonomies/{id}".
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of this taxonomy, whose format is:
     * "projects/{project_number}/locations/{location_id}/taxonomies/{id}".
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. User defined name of this taxonomy. It must: contain only unicode letters,
     * numbers, underscores, dashes and spaces; not start or end with spaces; and
     * be at most 200 bytes long when encoded in UTF-8.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. User defined name of this taxonomy. It must: contain only unicode letters,
     * numbers, underscores, dashes and spaces; not start or end with spaces; and
     * be at most 200 bytes long when encoded in UTF-8.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. User defined name of this taxonomy. It must: contain only unicode letters,
     * numbers, underscores, dashes and spaces; not start or end with spaces; and
     * be at most 200 bytes long when encoded in UTF-8.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      displayName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. User defined name of this taxonomy. It must: contain only unicode letters,
     * numbers, underscores, dashes and spaces; not start or end with spaces; and
     * be at most 200 bytes long when encoded in UTF-8.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {

      displayName_ = getDefaultInstance().getDisplayName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. User defined name of this taxonomy. It must: contain only unicode letters,
     * numbers, underscores, dashes and spaces; not start or end with spaces; and
     * be at most 200 bytes long when encoded in UTF-8.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      displayName_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Description of this taxonomy. It must: contain only unicode characters,
     * tabs, newlines, carriage returns and page breaks; and be at most 2000 bytes
     * long when encoded in UTF-8. If not set, defaults to an empty description.
     * </pre>
     *
     * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Description of this taxonomy. It must: contain only unicode characters,
     * tabs, newlines, carriage returns and page breaks; and be at most 2000 bytes
     * long when encoded in UTF-8. If not set, defaults to an empty description.
     * </pre>
     *
     * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Description of this taxonomy. It must: contain only unicode characters,
     * tabs, newlines, carriage returns and page breaks; and be at most 2000 bytes
     * long when encoded in UTF-8. If not set, defaults to an empty description.
     * </pre>
     *
     * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      description_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Description of this taxonomy. It must: contain only unicode characters,
     * tabs, newlines, carriage returns and page breaks; and be at most 2000 bytes
     * long when encoded in UTF-8. If not set, defaults to an empty description.
     * </pre>
     *
     * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {

      description_ = getDefaultInstance().getDescription();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Description of this taxonomy. It must: contain only unicode characters,
     * tabs, newlines, carriage returns and page breaks; and be at most 2000 bytes
     * long when encoded in UTF-8. If not set, defaults to an empty description.
     * </pre>
     *
     * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      description_ = value;
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> activatedPolicyTypes_ =
        java.util.Collections.emptyList();

    private void ensureActivatedPolicyTypesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        activatedPolicyTypes_ = new java.util.ArrayList<java.lang.Integer>(activatedPolicyTypes_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of policy types that are activated for this taxonomy. If not set,
     * defaults to an empty list.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1beta1.Taxonomy.PolicyType activated_policy_types = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the activatedPolicyTypes.
     */
    public java.util.List<com.google.cloud.datacatalog.v1beta1.Taxonomy.PolicyType>
        getActivatedPolicyTypesList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.datacatalog.v1beta1.Taxonomy.PolicyType>(
          activatedPolicyTypes_, activatedPolicyTypes_converter_);
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of policy types that are activated for this taxonomy. If not set,
     * defaults to an empty list.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1beta1.Taxonomy.PolicyType activated_policy_types = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The count of activatedPolicyTypes.
     */
    public int getActivatedPolicyTypesCount() {
      return activatedPolicyTypes_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of policy types that are activated for this taxonomy. If not set,
     * defaults to an empty list.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1beta1.Taxonomy.PolicyType activated_policy_types = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The activatedPolicyTypes at the given index.
     */
    public com.google.cloud.datacatalog.v1beta1.Taxonomy.PolicyType getActivatedPolicyTypes(
        int index) {
      return activatedPolicyTypes_converter_.convert(activatedPolicyTypes_.get(index));
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of policy types that are activated for this taxonomy. If not set,
     * defaults to an empty list.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1beta1.Taxonomy.PolicyType activated_policy_types = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The activatedPolicyTypes to set.
     * @return This builder for chaining.
     */
    public Builder setActivatedPolicyTypes(
        int index, com.google.cloud.datacatalog.v1beta1.Taxonomy.PolicyType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureActivatedPolicyTypesIsMutable();
      activatedPolicyTypes_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of policy types that are activated for this taxonomy. If not set,
     * defaults to an empty list.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1beta1.Taxonomy.PolicyType activated_policy_types = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The activatedPolicyTypes to add.
     * @return This builder for chaining.
     */
    public Builder addActivatedPolicyTypes(
        com.google.cloud.datacatalog.v1beta1.Taxonomy.PolicyType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureActivatedPolicyTypesIsMutable();
      activatedPolicyTypes_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of policy types that are activated for this taxonomy. If not set,
     * defaults to an empty list.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1beta1.Taxonomy.PolicyType activated_policy_types = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param values The activatedPolicyTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAllActivatedPolicyTypes(
        java.lang.Iterable<? extends com.google.cloud.datacatalog.v1beta1.Taxonomy.PolicyType>
            values) {
      ensureActivatedPolicyTypesIsMutable();
      for (com.google.cloud.datacatalog.v1beta1.Taxonomy.PolicyType value : values) {
        activatedPolicyTypes_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of policy types that are activated for this taxonomy. If not set,
     * defaults to an empty list.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1beta1.Taxonomy.PolicyType activated_policy_types = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearActivatedPolicyTypes() {
      activatedPolicyTypes_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of policy types that are activated for this taxonomy. If not set,
     * defaults to an empty list.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1beta1.Taxonomy.PolicyType activated_policy_types = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for activatedPolicyTypes.
     */
    public java.util.List<java.lang.Integer> getActivatedPolicyTypesValueList() {
      return java.util.Collections.unmodifiableList(activatedPolicyTypes_);
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of policy types that are activated for this taxonomy. If not set,
     * defaults to an empty list.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1beta1.Taxonomy.PolicyType activated_policy_types = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of activatedPolicyTypes at the given index.
     */
    public int getActivatedPolicyTypesValue(int index) {
      return activatedPolicyTypes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of policy types that are activated for this taxonomy. If not set,
     * defaults to an empty list.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1beta1.Taxonomy.PolicyType activated_policy_types = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for activatedPolicyTypes to set.
     * @return This builder for chaining.
     */
    public Builder setActivatedPolicyTypesValue(int index, int value) {
      ensureActivatedPolicyTypesIsMutable();
      activatedPolicyTypes_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of policy types that are activated for this taxonomy. If not set,
     * defaults to an empty list.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1beta1.Taxonomy.PolicyType activated_policy_types = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for activatedPolicyTypes to add.
     * @return This builder for chaining.
     */
    public Builder addActivatedPolicyTypesValue(int value) {
      ensureActivatedPolicyTypesIsMutable();
      activatedPolicyTypes_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of policy types that are activated for this taxonomy. If not set,
     * defaults to an empty list.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datacatalog.v1beta1.Taxonomy.PolicyType activated_policy_types = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param values The enum numeric values on the wire for activatedPolicyTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAllActivatedPolicyTypesValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureActivatedPolicyTypesIsMutable();
      for (int value : values) {
        activatedPolicyTypes_.add(value);
      }
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datacatalog.v1beta1.Taxonomy)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datacatalog.v1beta1.Taxonomy)
  private static final com.google.cloud.datacatalog.v1beta1.Taxonomy DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datacatalog.v1beta1.Taxonomy();
  }

  public static com.google.cloud.datacatalog.v1beta1.Taxonomy getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Taxonomy> PARSER =
      new com.google.protobuf.AbstractParser<Taxonomy>() {
        @java.lang.Override
        public Taxonomy parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Taxonomy> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Taxonomy> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datacatalog.v1beta1.Taxonomy getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
