/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datacatalog/v1beta1/datacatalog.proto

package com.google.cloud.datacatalog.v1beta1;

/**
 *
 *
 * <pre>
 * Request message for
 * [SearchCatalog][google.cloud.datacatalog.v1beta1.DataCatalog.SearchCatalog].
 * </pre>
 *
 * Protobuf type {@code google.cloud.datacatalog.v1beta1.SearchCatalogRequest}
 */
public final class SearchCatalogRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datacatalog.v1beta1.SearchCatalogRequest)
    SearchCatalogRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SearchCatalogRequest.newBuilder() to construct.
  private SearchCatalogRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SearchCatalogRequest() {
    query_ = "";
    pageToken_ = "";
    orderBy_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SearchCatalogRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datacatalog.v1beta1.Datacatalog
        .internal_static_google_cloud_datacatalog_v1beta1_SearchCatalogRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datacatalog.v1beta1.Datacatalog
        .internal_static_google_cloud_datacatalog_v1beta1_SearchCatalogRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.class,
            com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Builder.class);
  }

  public interface ScopeOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The list of organization IDs to search within. To find your organization
     * ID, follow instructions in
     * https://cloud.google.com/resource-manager/docs/creating-managing-organization.
     * </pre>
     *
     * <code>repeated string include_org_ids = 2;</code>
     *
     * @return A list containing the includeOrgIds.
     */
    java.util.List<java.lang.String> getIncludeOrgIdsList();
    /**
     *
     *
     * <pre>
     * The list of organization IDs to search within. To find your organization
     * ID, follow instructions in
     * https://cloud.google.com/resource-manager/docs/creating-managing-organization.
     * </pre>
     *
     * <code>repeated string include_org_ids = 2;</code>
     *
     * @return The count of includeOrgIds.
     */
    int getIncludeOrgIdsCount();
    /**
     *
     *
     * <pre>
     * The list of organization IDs to search within. To find your organization
     * ID, follow instructions in
     * https://cloud.google.com/resource-manager/docs/creating-managing-organization.
     * </pre>
     *
     * <code>repeated string include_org_ids = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The includeOrgIds at the given index.
     */
    java.lang.String getIncludeOrgIds(int index);
    /**
     *
     *
     * <pre>
     * The list of organization IDs to search within. To find your organization
     * ID, follow instructions in
     * https://cloud.google.com/resource-manager/docs/creating-managing-organization.
     * </pre>
     *
     * <code>repeated string include_org_ids = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the includeOrgIds at the given index.
     */
    com.google.protobuf.ByteString getIncludeOrgIdsBytes(int index);

    /**
     *
     *
     * <pre>
     * The list of project IDs to search within. To learn more about the
     * distinction between project names/IDs/numbers, go to
     * https://cloud.google.com/docs/overview/#projects.
     * </pre>
     *
     * <code>repeated string include_project_ids = 3;</code>
     *
     * @return A list containing the includeProjectIds.
     */
    java.util.List<java.lang.String> getIncludeProjectIdsList();
    /**
     *
     *
     * <pre>
     * The list of project IDs to search within. To learn more about the
     * distinction between project names/IDs/numbers, go to
     * https://cloud.google.com/docs/overview/#projects.
     * </pre>
     *
     * <code>repeated string include_project_ids = 3;</code>
     *
     * @return The count of includeProjectIds.
     */
    int getIncludeProjectIdsCount();
    /**
     *
     *
     * <pre>
     * The list of project IDs to search within. To learn more about the
     * distinction between project names/IDs/numbers, go to
     * https://cloud.google.com/docs/overview/#projects.
     * </pre>
     *
     * <code>repeated string include_project_ids = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The includeProjectIds at the given index.
     */
    java.lang.String getIncludeProjectIds(int index);
    /**
     *
     *
     * <pre>
     * The list of project IDs to search within. To learn more about the
     * distinction between project names/IDs/numbers, go to
     * https://cloud.google.com/docs/overview/#projects.
     * </pre>
     *
     * <code>repeated string include_project_ids = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the includeProjectIds at the given index.
     */
    com.google.protobuf.ByteString getIncludeProjectIdsBytes(int index);

    /**
     *
     *
     * <pre>
     * If `true`, include Google Cloud Platform (GCP) public datasets in the
     * search results. Info on GCP public datasets is available at
     * https://cloud.google.com/public-datasets/. By default, GCP public
     * datasets are excluded.
     * </pre>
     *
     * <code>bool include_gcp_public_datasets = 7;</code>
     *
     * @return The includeGcpPublicDatasets.
     */
    boolean getIncludeGcpPublicDatasets();
  }
  /**
   *
   *
   * <pre>
   * The criteria that select the subspace used for query matching.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope}
   */
  public static final class Scope extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope)
      ScopeOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Scope.newBuilder() to construct.
    private Scope(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Scope() {
      includeOrgIds_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      includeProjectIds_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Scope();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datacatalog.v1beta1.Datacatalog
          .internal_static_google_cloud_datacatalog_v1beta1_SearchCatalogRequest_Scope_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datacatalog.v1beta1.Datacatalog
          .internal_static_google_cloud_datacatalog_v1beta1_SearchCatalogRequest_Scope_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope.class,
              com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope.Builder.class);
    }

    public static final int INCLUDE_ORG_IDS_FIELD_NUMBER = 2;
    private com.google.protobuf.LazyStringList includeOrgIds_;
    /**
     *
     *
     * <pre>
     * The list of organization IDs to search within. To find your organization
     * ID, follow instructions in
     * https://cloud.google.com/resource-manager/docs/creating-managing-organization.
     * </pre>
     *
     * <code>repeated string include_org_ids = 2;</code>
     *
     * @return A list containing the includeOrgIds.
     */
    public com.google.protobuf.ProtocolStringList getIncludeOrgIdsList() {
      return includeOrgIds_;
    }
    /**
     *
     *
     * <pre>
     * The list of organization IDs to search within. To find your organization
     * ID, follow instructions in
     * https://cloud.google.com/resource-manager/docs/creating-managing-organization.
     * </pre>
     *
     * <code>repeated string include_org_ids = 2;</code>
     *
     * @return The count of includeOrgIds.
     */
    public int getIncludeOrgIdsCount() {
      return includeOrgIds_.size();
    }
    /**
     *
     *
     * <pre>
     * The list of organization IDs to search within. To find your organization
     * ID, follow instructions in
     * https://cloud.google.com/resource-manager/docs/creating-managing-organization.
     * </pre>
     *
     * <code>repeated string include_org_ids = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The includeOrgIds at the given index.
     */
    public java.lang.String getIncludeOrgIds(int index) {
      return includeOrgIds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The list of organization IDs to search within. To find your organization
     * ID, follow instructions in
     * https://cloud.google.com/resource-manager/docs/creating-managing-organization.
     * </pre>
     *
     * <code>repeated string include_org_ids = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the includeOrgIds at the given index.
     */
    public com.google.protobuf.ByteString getIncludeOrgIdsBytes(int index) {
      return includeOrgIds_.getByteString(index);
    }

    public static final int INCLUDE_PROJECT_IDS_FIELD_NUMBER = 3;
    private com.google.protobuf.LazyStringList includeProjectIds_;
    /**
     *
     *
     * <pre>
     * The list of project IDs to search within. To learn more about the
     * distinction between project names/IDs/numbers, go to
     * https://cloud.google.com/docs/overview/#projects.
     * </pre>
     *
     * <code>repeated string include_project_ids = 3;</code>
     *
     * @return A list containing the includeProjectIds.
     */
    public com.google.protobuf.ProtocolStringList getIncludeProjectIdsList() {
      return includeProjectIds_;
    }
    /**
     *
     *
     * <pre>
     * The list of project IDs to search within. To learn more about the
     * distinction between project names/IDs/numbers, go to
     * https://cloud.google.com/docs/overview/#projects.
     * </pre>
     *
     * <code>repeated string include_project_ids = 3;</code>
     *
     * @return The count of includeProjectIds.
     */
    public int getIncludeProjectIdsCount() {
      return includeProjectIds_.size();
    }
    /**
     *
     *
     * <pre>
     * The list of project IDs to search within. To learn more about the
     * distinction between project names/IDs/numbers, go to
     * https://cloud.google.com/docs/overview/#projects.
     * </pre>
     *
     * <code>repeated string include_project_ids = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The includeProjectIds at the given index.
     */
    public java.lang.String getIncludeProjectIds(int index) {
      return includeProjectIds_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The list of project IDs to search within. To learn more about the
     * distinction between project names/IDs/numbers, go to
     * https://cloud.google.com/docs/overview/#projects.
     * </pre>
     *
     * <code>repeated string include_project_ids = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the includeProjectIds at the given index.
     */
    public com.google.protobuf.ByteString getIncludeProjectIdsBytes(int index) {
      return includeProjectIds_.getByteString(index);
    }

    public static final int INCLUDE_GCP_PUBLIC_DATASETS_FIELD_NUMBER = 7;
    private boolean includeGcpPublicDatasets_;
    /**
     *
     *
     * <pre>
     * If `true`, include Google Cloud Platform (GCP) public datasets in the
     * search results. Info on GCP public datasets is available at
     * https://cloud.google.com/public-datasets/. By default, GCP public
     * datasets are excluded.
     * </pre>
     *
     * <code>bool include_gcp_public_datasets = 7;</code>
     *
     * @return The includeGcpPublicDatasets.
     */
    @java.lang.Override
    public boolean getIncludeGcpPublicDatasets() {
      return includeGcpPublicDatasets_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < includeOrgIds_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, includeOrgIds_.getRaw(i));
      }
      for (int i = 0; i < includeProjectIds_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, includeProjectIds_.getRaw(i));
      }
      if (includeGcpPublicDatasets_ != false) {
        output.writeBool(7, includeGcpPublicDatasets_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < includeOrgIds_.size(); i++) {
          dataSize += computeStringSizeNoTag(includeOrgIds_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getIncludeOrgIdsList().size();
      }
      {
        int dataSize = 0;
        for (int i = 0; i < includeProjectIds_.size(); i++) {
          dataSize += computeStringSizeNoTag(includeProjectIds_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getIncludeProjectIdsList().size();
      }
      if (includeGcpPublicDatasets_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(7, includeGcpPublicDatasets_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope)) {
        return super.equals(obj);
      }
      com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope other =
          (com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope) obj;

      if (!getIncludeOrgIdsList().equals(other.getIncludeOrgIdsList())) return false;
      if (!getIncludeProjectIdsList().equals(other.getIncludeProjectIdsList())) return false;
      if (getIncludeGcpPublicDatasets() != other.getIncludeGcpPublicDatasets()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getIncludeOrgIdsCount() > 0) {
        hash = (37 * hash) + INCLUDE_ORG_IDS_FIELD_NUMBER;
        hash = (53 * hash) + getIncludeOrgIdsList().hashCode();
      }
      if (getIncludeProjectIdsCount() > 0) {
        hash = (37 * hash) + INCLUDE_PROJECT_IDS_FIELD_NUMBER;
        hash = (53 * hash) + getIncludeProjectIdsList().hashCode();
      }
      hash = (37 * hash) + INCLUDE_GCP_PUBLIC_DATASETS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIncludeGcpPublicDatasets());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The criteria that select the subspace used for query matching.
     * </pre>
     *
     * Protobuf type {@code google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope)
        com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.ScopeOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.datacatalog.v1beta1.Datacatalog
            .internal_static_google_cloud_datacatalog_v1beta1_SearchCatalogRequest_Scope_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.datacatalog.v1beta1.Datacatalog
            .internal_static_google_cloud_datacatalog_v1beta1_SearchCatalogRequest_Scope_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope.class,
                com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope.Builder.class);
      }

      // Construct using
      // com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        includeOrgIds_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000001);
        includeProjectIds_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000002);
        includeGcpPublicDatasets_ = false;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.datacatalog.v1beta1.Datacatalog
            .internal_static_google_cloud_datacatalog_v1beta1_SearchCatalogRequest_Scope_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope
          getDefaultInstanceForType() {
        return com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope build() {
        com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope buildPartial() {
        com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope result =
            new com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope(this);
        int from_bitField0_ = bitField0_;
        if (((bitField0_ & 0x00000001) != 0)) {
          includeOrgIds_ = includeOrgIds_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.includeOrgIds_ = includeOrgIds_;
        if (((bitField0_ & 0x00000002) != 0)) {
          includeProjectIds_ = includeProjectIds_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.includeProjectIds_ = includeProjectIds_;
        result.includeGcpPublicDatasets_ = includeGcpPublicDatasets_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope) {
          return mergeFrom((com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope other) {
        if (other
            == com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope.getDefaultInstance())
          return this;
        if (!other.includeOrgIds_.isEmpty()) {
          if (includeOrgIds_.isEmpty()) {
            includeOrgIds_ = other.includeOrgIds_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureIncludeOrgIdsIsMutable();
            includeOrgIds_.addAll(other.includeOrgIds_);
          }
          onChanged();
        }
        if (!other.includeProjectIds_.isEmpty()) {
          if (includeProjectIds_.isEmpty()) {
            includeProjectIds_ = other.includeProjectIds_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureIncludeProjectIdsIsMutable();
            includeProjectIds_.addAll(other.includeProjectIds_);
          }
          onChanged();
        }
        if (other.getIncludeGcpPublicDatasets() != false) {
          setIncludeGcpPublicDatasets(other.getIncludeGcpPublicDatasets());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureIncludeOrgIdsIsMutable();
                  includeOrgIds_.add(s);
                  break;
                } // case 18
              case 26:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureIncludeProjectIdsIsMutable();
                  includeProjectIds_.add(s);
                  break;
                } // case 26
              case 56:
                {
                  includeGcpPublicDatasets_ = input.readBool();

                  break;
                } // case 56
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.LazyStringList includeOrgIds_ =
          com.google.protobuf.LazyStringArrayList.EMPTY;

      private void ensureIncludeOrgIdsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          includeOrgIds_ = new com.google.protobuf.LazyStringArrayList(includeOrgIds_);
          bitField0_ |= 0x00000001;
        }
      }
      /**
       *
       *
       * <pre>
       * The list of organization IDs to search within. To find your organization
       * ID, follow instructions in
       * https://cloud.google.com/resource-manager/docs/creating-managing-organization.
       * </pre>
       *
       * <code>repeated string include_org_ids = 2;</code>
       *
       * @return A list containing the includeOrgIds.
       */
      public com.google.protobuf.ProtocolStringList getIncludeOrgIdsList() {
        return includeOrgIds_.getUnmodifiableView();
      }
      /**
       *
       *
       * <pre>
       * The list of organization IDs to search within. To find your organization
       * ID, follow instructions in
       * https://cloud.google.com/resource-manager/docs/creating-managing-organization.
       * </pre>
       *
       * <code>repeated string include_org_ids = 2;</code>
       *
       * @return The count of includeOrgIds.
       */
      public int getIncludeOrgIdsCount() {
        return includeOrgIds_.size();
      }
      /**
       *
       *
       * <pre>
       * The list of organization IDs to search within. To find your organization
       * ID, follow instructions in
       * https://cloud.google.com/resource-manager/docs/creating-managing-organization.
       * </pre>
       *
       * <code>repeated string include_org_ids = 2;</code>
       *
       * @param index The index of the element to return.
       * @return The includeOrgIds at the given index.
       */
      public java.lang.String getIncludeOrgIds(int index) {
        return includeOrgIds_.get(index);
      }
      /**
       *
       *
       * <pre>
       * The list of organization IDs to search within. To find your organization
       * ID, follow instructions in
       * https://cloud.google.com/resource-manager/docs/creating-managing-organization.
       * </pre>
       *
       * <code>repeated string include_org_ids = 2;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the includeOrgIds at the given index.
       */
      public com.google.protobuf.ByteString getIncludeOrgIdsBytes(int index) {
        return includeOrgIds_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * The list of organization IDs to search within. To find your organization
       * ID, follow instructions in
       * https://cloud.google.com/resource-manager/docs/creating-managing-organization.
       * </pre>
       *
       * <code>repeated string include_org_ids = 2;</code>
       *
       * @param index The index to set the value at.
       * @param value The includeOrgIds to set.
       * @return This builder for chaining.
       */
      public Builder setIncludeOrgIds(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIncludeOrgIdsIsMutable();
        includeOrgIds_.set(index, value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of organization IDs to search within. To find your organization
       * ID, follow instructions in
       * https://cloud.google.com/resource-manager/docs/creating-managing-organization.
       * </pre>
       *
       * <code>repeated string include_org_ids = 2;</code>
       *
       * @param value The includeOrgIds to add.
       * @return This builder for chaining.
       */
      public Builder addIncludeOrgIds(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIncludeOrgIdsIsMutable();
        includeOrgIds_.add(value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of organization IDs to search within. To find your organization
       * ID, follow instructions in
       * https://cloud.google.com/resource-manager/docs/creating-managing-organization.
       * </pre>
       *
       * <code>repeated string include_org_ids = 2;</code>
       *
       * @param values The includeOrgIds to add.
       * @return This builder for chaining.
       */
      public Builder addAllIncludeOrgIds(java.lang.Iterable<java.lang.String> values) {
        ensureIncludeOrgIdsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, includeOrgIds_);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of organization IDs to search within. To find your organization
       * ID, follow instructions in
       * https://cloud.google.com/resource-manager/docs/creating-managing-organization.
       * </pre>
       *
       * <code>repeated string include_org_ids = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearIncludeOrgIds() {
        includeOrgIds_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of organization IDs to search within. To find your organization
       * ID, follow instructions in
       * https://cloud.google.com/resource-manager/docs/creating-managing-organization.
       * </pre>
       *
       * <code>repeated string include_org_ids = 2;</code>
       *
       * @param value The bytes of the includeOrgIds to add.
       * @return This builder for chaining.
       */
      public Builder addIncludeOrgIdsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureIncludeOrgIdsIsMutable();
        includeOrgIds_.add(value);
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringList includeProjectIds_ =
          com.google.protobuf.LazyStringArrayList.EMPTY;

      private void ensureIncludeProjectIdsIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          includeProjectIds_ = new com.google.protobuf.LazyStringArrayList(includeProjectIds_);
          bitField0_ |= 0x00000002;
        }
      }
      /**
       *
       *
       * <pre>
       * The list of project IDs to search within. To learn more about the
       * distinction between project names/IDs/numbers, go to
       * https://cloud.google.com/docs/overview/#projects.
       * </pre>
       *
       * <code>repeated string include_project_ids = 3;</code>
       *
       * @return A list containing the includeProjectIds.
       */
      public com.google.protobuf.ProtocolStringList getIncludeProjectIdsList() {
        return includeProjectIds_.getUnmodifiableView();
      }
      /**
       *
       *
       * <pre>
       * The list of project IDs to search within. To learn more about the
       * distinction between project names/IDs/numbers, go to
       * https://cloud.google.com/docs/overview/#projects.
       * </pre>
       *
       * <code>repeated string include_project_ids = 3;</code>
       *
       * @return The count of includeProjectIds.
       */
      public int getIncludeProjectIdsCount() {
        return includeProjectIds_.size();
      }
      /**
       *
       *
       * <pre>
       * The list of project IDs to search within. To learn more about the
       * distinction between project names/IDs/numbers, go to
       * https://cloud.google.com/docs/overview/#projects.
       * </pre>
       *
       * <code>repeated string include_project_ids = 3;</code>
       *
       * @param index The index of the element to return.
       * @return The includeProjectIds at the given index.
       */
      public java.lang.String getIncludeProjectIds(int index) {
        return includeProjectIds_.get(index);
      }
      /**
       *
       *
       * <pre>
       * The list of project IDs to search within. To learn more about the
       * distinction between project names/IDs/numbers, go to
       * https://cloud.google.com/docs/overview/#projects.
       * </pre>
       *
       * <code>repeated string include_project_ids = 3;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the includeProjectIds at the given index.
       */
      public com.google.protobuf.ByteString getIncludeProjectIdsBytes(int index) {
        return includeProjectIds_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * The list of project IDs to search within. To learn more about the
       * distinction between project names/IDs/numbers, go to
       * https://cloud.google.com/docs/overview/#projects.
       * </pre>
       *
       * <code>repeated string include_project_ids = 3;</code>
       *
       * @param index The index to set the value at.
       * @param value The includeProjectIds to set.
       * @return This builder for chaining.
       */
      public Builder setIncludeProjectIds(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIncludeProjectIdsIsMutable();
        includeProjectIds_.set(index, value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of project IDs to search within. To learn more about the
       * distinction between project names/IDs/numbers, go to
       * https://cloud.google.com/docs/overview/#projects.
       * </pre>
       *
       * <code>repeated string include_project_ids = 3;</code>
       *
       * @param value The includeProjectIds to add.
       * @return This builder for chaining.
       */
      public Builder addIncludeProjectIds(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureIncludeProjectIdsIsMutable();
        includeProjectIds_.add(value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of project IDs to search within. To learn more about the
       * distinction between project names/IDs/numbers, go to
       * https://cloud.google.com/docs/overview/#projects.
       * </pre>
       *
       * <code>repeated string include_project_ids = 3;</code>
       *
       * @param values The includeProjectIds to add.
       * @return This builder for chaining.
       */
      public Builder addAllIncludeProjectIds(java.lang.Iterable<java.lang.String> values) {
        ensureIncludeProjectIdsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, includeProjectIds_);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of project IDs to search within. To learn more about the
       * distinction between project names/IDs/numbers, go to
       * https://cloud.google.com/docs/overview/#projects.
       * </pre>
       *
       * <code>repeated string include_project_ids = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearIncludeProjectIds() {
        includeProjectIds_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The list of project IDs to search within. To learn more about the
       * distinction between project names/IDs/numbers, go to
       * https://cloud.google.com/docs/overview/#projects.
       * </pre>
       *
       * <code>repeated string include_project_ids = 3;</code>
       *
       * @param value The bytes of the includeProjectIds to add.
       * @return This builder for chaining.
       */
      public Builder addIncludeProjectIdsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureIncludeProjectIdsIsMutable();
        includeProjectIds_.add(value);
        onChanged();
        return this;
      }

      private boolean includeGcpPublicDatasets_;
      /**
       *
       *
       * <pre>
       * If `true`, include Google Cloud Platform (GCP) public datasets in the
       * search results. Info on GCP public datasets is available at
       * https://cloud.google.com/public-datasets/. By default, GCP public
       * datasets are excluded.
       * </pre>
       *
       * <code>bool include_gcp_public_datasets = 7;</code>
       *
       * @return The includeGcpPublicDatasets.
       */
      @java.lang.Override
      public boolean getIncludeGcpPublicDatasets() {
        return includeGcpPublicDatasets_;
      }
      /**
       *
       *
       * <pre>
       * If `true`, include Google Cloud Platform (GCP) public datasets in the
       * search results. Info on GCP public datasets is available at
       * https://cloud.google.com/public-datasets/. By default, GCP public
       * datasets are excluded.
       * </pre>
       *
       * <code>bool include_gcp_public_datasets = 7;</code>
       *
       * @param value The includeGcpPublicDatasets to set.
       * @return This builder for chaining.
       */
      public Builder setIncludeGcpPublicDatasets(boolean value) {

        includeGcpPublicDatasets_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If `true`, include Google Cloud Platform (GCP) public datasets in the
       * search results. Info on GCP public datasets is available at
       * https://cloud.google.com/public-datasets/. By default, GCP public
       * datasets are excluded.
       * </pre>
       *
       * <code>bool include_gcp_public_datasets = 7;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearIncludeGcpPublicDatasets() {

        includeGcpPublicDatasets_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope)
    private static final com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope();
    }

    public static com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Scope> PARSER =
        new com.google.protobuf.AbstractParser<Scope>() {
          @java.lang.Override
          public Scope parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Scope> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Scope> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int SCOPE_FIELD_NUMBER = 6;
  private com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope scope_;
  /**
   *
   *
   * <pre>
   * Required. The scope of this search request. A `scope` that has empty
   * `include_org_ids`, `include_project_ids` AND false
   * `include_gcp_public_datasets` is considered invalid. Data Catalog will
   * return an error in such a case.
   * </pre>
   *
   * <code>
   * .google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope scope = 6 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the scope field is set.
   */
  @java.lang.Override
  public boolean hasScope() {
    return scope_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. The scope of this search request. A `scope` that has empty
   * `include_org_ids`, `include_project_ids` AND false
   * `include_gcp_public_datasets` is considered invalid. Data Catalog will
   * return an error in such a case.
   * </pre>
   *
   * <code>
   * .google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope scope = 6 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The scope.
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope getScope() {
    return scope_ == null
        ? com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope.getDefaultInstance()
        : scope_;
  }
  /**
   *
   *
   * <pre>
   * Required. The scope of this search request. A `scope` that has empty
   * `include_org_ids`, `include_project_ids` AND false
   * `include_gcp_public_datasets` is considered invalid. Data Catalog will
   * return an error in such a case.
   * </pre>
   *
   * <code>
   * .google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope scope = 6 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.ScopeOrBuilder
      getScopeOrBuilder() {
    return getScope();
  }

  public static final int QUERY_FIELD_NUMBER = 1;
  private volatile java.lang.Object query_;
  /**
   *
   *
   * <pre>
   * Required. The query string in search query syntax. The query must be non-empty.
   * Query strings can be simple as "x" or more qualified as:
   * * name:x
   * * column:x
   * * description:y
   * Note: Query tokens need to have a minimum of 3 characters for substring
   * matching to work correctly. See [Data Catalog Search
   * Syntax](https://cloud.google.com/data-catalog/docs/how-to/search-reference)
   * for more information.
   * </pre>
   *
   * <code>string query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The query.
   */
  @java.lang.Override
  public java.lang.String getQuery() {
    java.lang.Object ref = query_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      query_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The query string in search query syntax. The query must be non-empty.
   * Query strings can be simple as "x" or more qualified as:
   * * name:x
   * * column:x
   * * description:y
   * Note: Query tokens need to have a minimum of 3 characters for substring
   * matching to work correctly. See [Data Catalog Search
   * Syntax](https://cloud.google.com/data-catalog/docs/how-to/search-reference)
   * for more information.
   * </pre>
   *
   * <code>string query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for query.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getQueryBytes() {
    java.lang.Object ref = query_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      query_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PAGE_SIZE_FIELD_NUMBER = 2;
  private int pageSize_;
  /**
   *
   *
   * <pre>
   * Number of results in the search page. If &lt;=0 then defaults to 10. Max limit
   * for page_size is 1000. Throws an invalid argument for page_size &gt; 1000.
   * </pre>
   *
   * <code>int32 page_size = 2;</code>
   *
   * @return The pageSize.
   */
  @java.lang.Override
  public int getPageSize() {
    return pageSize_;
  }

  public static final int PAGE_TOKEN_FIELD_NUMBER = 3;
  private volatile java.lang.Object pageToken_;
  /**
   *
   *
   * <pre>
   * Optional. Pagination token returned in an earlier
   * [SearchCatalogResponse.next_page_token][google.cloud.datacatalog.v1beta1.SearchCatalogResponse.next_page_token], which
   * indicates that this is a continuation of a prior
   * [SearchCatalogRequest][google.cloud.datacatalog.v1beta1.DataCatalog.SearchCatalog]
   * call, and that the system should return the next page of data. If empty,
   * the first page is returned.
   * </pre>
   *
   * <code>string page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The pageToken.
   */
  @java.lang.Override
  public java.lang.String getPageToken() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pageToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. Pagination token returned in an earlier
   * [SearchCatalogResponse.next_page_token][google.cloud.datacatalog.v1beta1.SearchCatalogResponse.next_page_token], which
   * indicates that this is a continuation of a prior
   * [SearchCatalogRequest][google.cloud.datacatalog.v1beta1.DataCatalog.SearchCatalog]
   * call, and that the system should return the next page of data. If empty,
   * the first page is returned.
   * </pre>
   *
   * <code>string page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for pageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPageTokenBytes() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ORDER_BY_FIELD_NUMBER = 5;
  private volatile java.lang.Object orderBy_;
  /**
   *
   *
   * <pre>
   * Specifies the ordering of results, currently supported case-sensitive
   * choices are:
   *   * `relevance`, only supports descending
   *   * `last_modified_timestamp [asc|desc]`, defaults to descending if not
   *     specified
   * If not specified, defaults to `relevance` descending.
   * </pre>
   *
   * <code>string order_by = 5;</code>
   *
   * @return The orderBy.
   */
  @java.lang.Override
  public java.lang.String getOrderBy() {
    java.lang.Object ref = orderBy_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      orderBy_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Specifies the ordering of results, currently supported case-sensitive
   * choices are:
   *   * `relevance`, only supports descending
   *   * `last_modified_timestamp [asc|desc]`, defaults to descending if not
   *     specified
   * If not specified, defaults to `relevance` descending.
   * </pre>
   *
   * <code>string order_by = 5;</code>
   *
   * @return The bytes for orderBy.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOrderByBytes() {
    java.lang.Object ref = orderBy_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      orderBy_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(query_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, query_);
    }
    if (pageSize_ != 0) {
      output.writeInt32(2, pageSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, pageToken_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(orderBy_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, orderBy_);
    }
    if (scope_ != null) {
      output.writeMessage(6, getScope());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(query_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, query_);
    }
    if (pageSize_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, pageSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, pageToken_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(orderBy_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, orderBy_);
    }
    if (scope_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getScope());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest other =
        (com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest) obj;

    if (hasScope() != other.hasScope()) return false;
    if (hasScope()) {
      if (!getScope().equals(other.getScope())) return false;
    }
    if (!getQuery().equals(other.getQuery())) return false;
    if (getPageSize() != other.getPageSize()) return false;
    if (!getPageToken().equals(other.getPageToken())) return false;
    if (!getOrderBy().equals(other.getOrderBy())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasScope()) {
      hash = (37 * hash) + SCOPE_FIELD_NUMBER;
      hash = (53 * hash) + getScope().hashCode();
    }
    hash = (37 * hash) + QUERY_FIELD_NUMBER;
    hash = (53 * hash) + getQuery().hashCode();
    hash = (37 * hash) + PAGE_SIZE_FIELD_NUMBER;
    hash = (53 * hash) + getPageSize();
    hash = (37 * hash) + PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getPageToken().hashCode();
    hash = (37 * hash) + ORDER_BY_FIELD_NUMBER;
    hash = (53 * hash) + getOrderBy().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for
   * [SearchCatalog][google.cloud.datacatalog.v1beta1.DataCatalog.SearchCatalog].
   * </pre>
   *
   * Protobuf type {@code google.cloud.datacatalog.v1beta1.SearchCatalogRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datacatalog.v1beta1.SearchCatalogRequest)
      com.google.cloud.datacatalog.v1beta1.SearchCatalogRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datacatalog.v1beta1.Datacatalog
          .internal_static_google_cloud_datacatalog_v1beta1_SearchCatalogRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datacatalog.v1beta1.Datacatalog
          .internal_static_google_cloud_datacatalog_v1beta1_SearchCatalogRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.class,
              com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Builder.class);
    }

    // Construct using com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (scopeBuilder_ == null) {
        scope_ = null;
      } else {
        scope_ = null;
        scopeBuilder_ = null;
      }
      query_ = "";

      pageSize_ = 0;

      pageToken_ = "";

      orderBy_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datacatalog.v1beta1.Datacatalog
          .internal_static_google_cloud_datacatalog_v1beta1_SearchCatalogRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest getDefaultInstanceForType() {
      return com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest build() {
      com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest buildPartial() {
      com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest result =
          new com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest(this);
      if (scopeBuilder_ == null) {
        result.scope_ = scope_;
      } else {
        result.scope_ = scopeBuilder_.build();
      }
      result.query_ = query_;
      result.pageSize_ = pageSize_;
      result.pageToken_ = pageToken_;
      result.orderBy_ = orderBy_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest) {
        return mergeFrom((com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest other) {
      if (other == com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.getDefaultInstance())
        return this;
      if (other.hasScope()) {
        mergeScope(other.getScope());
      }
      if (!other.getQuery().isEmpty()) {
        query_ = other.query_;
        onChanged();
      }
      if (other.getPageSize() != 0) {
        setPageSize(other.getPageSize());
      }
      if (!other.getPageToken().isEmpty()) {
        pageToken_ = other.pageToken_;
        onChanged();
      }
      if (!other.getOrderBy().isEmpty()) {
        orderBy_ = other.orderBy_;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                query_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 16:
              {
                pageSize_ = input.readInt32();

                break;
              } // case 16
            case 26:
              {
                pageToken_ = input.readStringRequireUtf8();

                break;
              } // case 26
            case 42:
              {
                orderBy_ = input.readStringRequireUtf8();

                break;
              } // case 42
            case 50:
              {
                input.readMessage(getScopeFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope scope_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope,
            com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope.Builder,
            com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.ScopeOrBuilder>
        scopeBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The scope of this search request. A `scope` that has empty
     * `include_org_ids`, `include_project_ids` AND false
     * `include_gcp_public_datasets` is considered invalid. Data Catalog will
     * return an error in such a case.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope scope = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the scope field is set.
     */
    public boolean hasScope() {
      return scopeBuilder_ != null || scope_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. The scope of this search request. A `scope` that has empty
     * `include_org_ids`, `include_project_ids` AND false
     * `include_gcp_public_datasets` is considered invalid. Data Catalog will
     * return an error in such a case.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope scope = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The scope.
     */
    public com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope getScope() {
      if (scopeBuilder_ == null) {
        return scope_ == null
            ? com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope.getDefaultInstance()
            : scope_;
      } else {
        return scopeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The scope of this search request. A `scope` that has empty
     * `include_org_ids`, `include_project_ids` AND false
     * `include_gcp_public_datasets` is considered invalid. Data Catalog will
     * return an error in such a case.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope scope = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setScope(com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope value) {
      if (scopeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        scope_ = value;
        onChanged();
      } else {
        scopeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The scope of this search request. A `scope` that has empty
     * `include_org_ids`, `include_project_ids` AND false
     * `include_gcp_public_datasets` is considered invalid. Data Catalog will
     * return an error in such a case.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope scope = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setScope(
        com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope.Builder builderForValue) {
      if (scopeBuilder_ == null) {
        scope_ = builderForValue.build();
        onChanged();
      } else {
        scopeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The scope of this search request. A `scope` that has empty
     * `include_org_ids`, `include_project_ids` AND false
     * `include_gcp_public_datasets` is considered invalid. Data Catalog will
     * return an error in such a case.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope scope = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeScope(
        com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope value) {
      if (scopeBuilder_ == null) {
        if (scope_ != null) {
          scope_ =
              com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope.newBuilder(scope_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          scope_ = value;
        }
        onChanged();
      } else {
        scopeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The scope of this search request. A `scope` that has empty
     * `include_org_ids`, `include_project_ids` AND false
     * `include_gcp_public_datasets` is considered invalid. Data Catalog will
     * return an error in such a case.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope scope = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearScope() {
      if (scopeBuilder_ == null) {
        scope_ = null;
        onChanged();
      } else {
        scope_ = null;
        scopeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The scope of this search request. A `scope` that has empty
     * `include_org_ids`, `include_project_ids` AND false
     * `include_gcp_public_datasets` is considered invalid. Data Catalog will
     * return an error in such a case.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope scope = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope.Builder
        getScopeBuilder() {

      onChanged();
      return getScopeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The scope of this search request. A `scope` that has empty
     * `include_org_ids`, `include_project_ids` AND false
     * `include_gcp_public_datasets` is considered invalid. Data Catalog will
     * return an error in such a case.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope scope = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.ScopeOrBuilder
        getScopeOrBuilder() {
      if (scopeBuilder_ != null) {
        return scopeBuilder_.getMessageOrBuilder();
      } else {
        return scope_ == null
            ? com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope.getDefaultInstance()
            : scope_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The scope of this search request. A `scope` that has empty
     * `include_org_ids`, `include_project_ids` AND false
     * `include_gcp_public_datasets` is considered invalid. Data Catalog will
     * return an error in such a case.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope scope = 6 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope,
            com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope.Builder,
            com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.ScopeOrBuilder>
        getScopeFieldBuilder() {
      if (scopeBuilder_ == null) {
        scopeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope,
                com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.Scope.Builder,
                com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest.ScopeOrBuilder>(
                getScope(), getParentForChildren(), isClean());
        scope_ = null;
      }
      return scopeBuilder_;
    }

    private java.lang.Object query_ = "";
    /**
     *
     *
     * <pre>
     * Required. The query string in search query syntax. The query must be non-empty.
     * Query strings can be simple as "x" or more qualified as:
     * * name:x
     * * column:x
     * * description:y
     * Note: Query tokens need to have a minimum of 3 characters for substring
     * matching to work correctly. See [Data Catalog Search
     * Syntax](https://cloud.google.com/data-catalog/docs/how-to/search-reference)
     * for more information.
     * </pre>
     *
     * <code>string query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The query.
     */
    public java.lang.String getQuery() {
      java.lang.Object ref = query_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        query_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The query string in search query syntax. The query must be non-empty.
     * Query strings can be simple as "x" or more qualified as:
     * * name:x
     * * column:x
     * * description:y
     * Note: Query tokens need to have a minimum of 3 characters for substring
     * matching to work correctly. See [Data Catalog Search
     * Syntax](https://cloud.google.com/data-catalog/docs/how-to/search-reference)
     * for more information.
     * </pre>
     *
     * <code>string query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for query.
     */
    public com.google.protobuf.ByteString getQueryBytes() {
      java.lang.Object ref = query_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        query_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The query string in search query syntax. The query must be non-empty.
     * Query strings can be simple as "x" or more qualified as:
     * * name:x
     * * column:x
     * * description:y
     * Note: Query tokens need to have a minimum of 3 characters for substring
     * matching to work correctly. See [Data Catalog Search
     * Syntax](https://cloud.google.com/data-catalog/docs/how-to/search-reference)
     * for more information.
     * </pre>
     *
     * <code>string query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The query to set.
     * @return This builder for chaining.
     */
    public Builder setQuery(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      query_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The query string in search query syntax. The query must be non-empty.
     * Query strings can be simple as "x" or more qualified as:
     * * name:x
     * * column:x
     * * description:y
     * Note: Query tokens need to have a minimum of 3 characters for substring
     * matching to work correctly. See [Data Catalog Search
     * Syntax](https://cloud.google.com/data-catalog/docs/how-to/search-reference)
     * for more information.
     * </pre>
     *
     * <code>string query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearQuery() {

      query_ = getDefaultInstance().getQuery();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The query string in search query syntax. The query must be non-empty.
     * Query strings can be simple as "x" or more qualified as:
     * * name:x
     * * column:x
     * * description:y
     * Note: Query tokens need to have a minimum of 3 characters for substring
     * matching to work correctly. See [Data Catalog Search
     * Syntax](https://cloud.google.com/data-catalog/docs/how-to/search-reference)
     * for more information.
     * </pre>
     *
     * <code>string query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for query to set.
     * @return This builder for chaining.
     */
    public Builder setQueryBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      query_ = value;
      onChanged();
      return this;
    }

    private int pageSize_;
    /**
     *
     *
     * <pre>
     * Number of results in the search page. If &lt;=0 then defaults to 10. Max limit
     * for page_size is 1000. Throws an invalid argument for page_size &gt; 1000.
     * </pre>
     *
     * <code>int32 page_size = 2;</code>
     *
     * @return The pageSize.
     */
    @java.lang.Override
    public int getPageSize() {
      return pageSize_;
    }
    /**
     *
     *
     * <pre>
     * Number of results in the search page. If &lt;=0 then defaults to 10. Max limit
     * for page_size is 1000. Throws an invalid argument for page_size &gt; 1000.
     * </pre>
     *
     * <code>int32 page_size = 2;</code>
     *
     * @param value The pageSize to set.
     * @return This builder for chaining.
     */
    public Builder setPageSize(int value) {

      pageSize_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Number of results in the search page. If &lt;=0 then defaults to 10. Max limit
     * for page_size is 1000. Throws an invalid argument for page_size &gt; 1000.
     * </pre>
     *
     * <code>int32 page_size = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageSize() {

      pageSize_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object pageToken_ = "";
    /**
     *
     *
     * <pre>
     * Optional. Pagination token returned in an earlier
     * [SearchCatalogResponse.next_page_token][google.cloud.datacatalog.v1beta1.SearchCatalogResponse.next_page_token], which
     * indicates that this is a continuation of a prior
     * [SearchCatalogRequest][google.cloud.datacatalog.v1beta1.DataCatalog.SearchCatalog]
     * call, and that the system should return the next page of data. If empty,
     * the first page is returned.
     * </pre>
     *
     * <code>string page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The pageToken.
     */
    public java.lang.String getPageToken() {
      java.lang.Object ref = pageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Pagination token returned in an earlier
     * [SearchCatalogResponse.next_page_token][google.cloud.datacatalog.v1beta1.SearchCatalogResponse.next_page_token], which
     * indicates that this is a continuation of a prior
     * [SearchCatalogRequest][google.cloud.datacatalog.v1beta1.DataCatalog.SearchCatalog]
     * call, and that the system should return the next page of data. If empty,
     * the first page is returned.
     * </pre>
     *
     * <code>string page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for pageToken.
     */
    public com.google.protobuf.ByteString getPageTokenBytes() {
      java.lang.Object ref = pageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Pagination token returned in an earlier
     * [SearchCatalogResponse.next_page_token][google.cloud.datacatalog.v1beta1.SearchCatalogResponse.next_page_token], which
     * indicates that this is a continuation of a prior
     * [SearchCatalogRequest][google.cloud.datacatalog.v1beta1.DataCatalog.SearchCatalog]
     * call, and that the system should return the next page of data. If empty,
     * the first page is returned.
     * </pre>
     *
     * <code>string page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      pageToken_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Pagination token returned in an earlier
     * [SearchCatalogResponse.next_page_token][google.cloud.datacatalog.v1beta1.SearchCatalogResponse.next_page_token], which
     * indicates that this is a continuation of a prior
     * [SearchCatalogRequest][google.cloud.datacatalog.v1beta1.DataCatalog.SearchCatalog]
     * call, and that the system should return the next page of data. If empty,
     * the first page is returned.
     * </pre>
     *
     * <code>string page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageToken() {

      pageToken_ = getDefaultInstance().getPageToken();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Pagination token returned in an earlier
     * [SearchCatalogResponse.next_page_token][google.cloud.datacatalog.v1beta1.SearchCatalogResponse.next_page_token], which
     * indicates that this is a continuation of a prior
     * [SearchCatalogRequest][google.cloud.datacatalog.v1beta1.DataCatalog.SearchCatalog]
     * call, and that the system should return the next page of data. If empty,
     * the first page is returned.
     * </pre>
     *
     * <code>string page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      pageToken_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object orderBy_ = "";
    /**
     *
     *
     * <pre>
     * Specifies the ordering of results, currently supported case-sensitive
     * choices are:
     *   * `relevance`, only supports descending
     *   * `last_modified_timestamp [asc|desc]`, defaults to descending if not
     *     specified
     * If not specified, defaults to `relevance` descending.
     * </pre>
     *
     * <code>string order_by = 5;</code>
     *
     * @return The orderBy.
     */
    public java.lang.String getOrderBy() {
      java.lang.Object ref = orderBy_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        orderBy_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the ordering of results, currently supported case-sensitive
     * choices are:
     *   * `relevance`, only supports descending
     *   * `last_modified_timestamp [asc|desc]`, defaults to descending if not
     *     specified
     * If not specified, defaults to `relevance` descending.
     * </pre>
     *
     * <code>string order_by = 5;</code>
     *
     * @return The bytes for orderBy.
     */
    public com.google.protobuf.ByteString getOrderByBytes() {
      java.lang.Object ref = orderBy_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        orderBy_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies the ordering of results, currently supported case-sensitive
     * choices are:
     *   * `relevance`, only supports descending
     *   * `last_modified_timestamp [asc|desc]`, defaults to descending if not
     *     specified
     * If not specified, defaults to `relevance` descending.
     * </pre>
     *
     * <code>string order_by = 5;</code>
     *
     * @param value The orderBy to set.
     * @return This builder for chaining.
     */
    public Builder setOrderBy(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      orderBy_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the ordering of results, currently supported case-sensitive
     * choices are:
     *   * `relevance`, only supports descending
     *   * `last_modified_timestamp [asc|desc]`, defaults to descending if not
     *     specified
     * If not specified, defaults to `relevance` descending.
     * </pre>
     *
     * <code>string order_by = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOrderBy() {

      orderBy_ = getDefaultInstance().getOrderBy();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the ordering of results, currently supported case-sensitive
     * choices are:
     *   * `relevance`, only supports descending
     *   * `last_modified_timestamp [asc|desc]`, defaults to descending if not
     *     specified
     * If not specified, defaults to `relevance` descending.
     * </pre>
     *
     * <code>string order_by = 5;</code>
     *
     * @param value The bytes for orderBy to set.
     * @return This builder for chaining.
     */
    public Builder setOrderByBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      orderBy_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datacatalog.v1beta1.SearchCatalogRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datacatalog.v1beta1.SearchCatalogRequest)
  private static final com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest();
  }

  public static com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SearchCatalogRequest> PARSER =
      new com.google.protobuf.AbstractParser<SearchCatalogRequest>() {
        @java.lang.Override
        public SearchCatalogRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SearchCatalogRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SearchCatalogRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datacatalog.v1beta1.SearchCatalogRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
