/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datacatalog/v1beta1/table_spec.proto

package com.google.cloud.datacatalog.v1beta1;

/**
 *
 *
 * <pre>
 * Describes a BigQuery table.
 * </pre>
 *
 * Protobuf type {@code google.cloud.datacatalog.v1beta1.BigQueryTableSpec}
 */
public final class BigQueryTableSpec extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datacatalog.v1beta1.BigQueryTableSpec)
    BigQueryTableSpecOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BigQueryTableSpec.newBuilder() to construct.
  private BigQueryTableSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BigQueryTableSpec() {
    tableSourceType_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BigQueryTableSpec();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datacatalog.v1beta1.TableSpecOuterClass
        .internal_static_google_cloud_datacatalog_v1beta1_BigQueryTableSpec_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datacatalog.v1beta1.TableSpecOuterClass
        .internal_static_google_cloud_datacatalog_v1beta1_BigQueryTableSpec_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datacatalog.v1beta1.BigQueryTableSpec.class,
            com.google.cloud.datacatalog.v1beta1.BigQueryTableSpec.Builder.class);
  }

  private int typeSpecCase_ = 0;
  private java.lang.Object typeSpec_;

  public enum TypeSpecCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    VIEW_SPEC(2),
    TABLE_SPEC(3),
    TYPESPEC_NOT_SET(0);
    private final int value;

    private TypeSpecCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TypeSpecCase valueOf(int value) {
      return forNumber(value);
    }

    public static TypeSpecCase forNumber(int value) {
      switch (value) {
        case 2:
          return VIEW_SPEC;
        case 3:
          return TABLE_SPEC;
        case 0:
          return TYPESPEC_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public TypeSpecCase getTypeSpecCase() {
    return TypeSpecCase.forNumber(typeSpecCase_);
  }

  public static final int TABLE_SOURCE_TYPE_FIELD_NUMBER = 1;
  private int tableSourceType_;
  /**
   *
   *
   * <pre>
   * Output only. The table source type.
   * </pre>
   *
   * <code>
   * .google.cloud.datacatalog.v1beta1.TableSourceType table_source_type = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for tableSourceType.
   */
  @java.lang.Override
  public int getTableSourceTypeValue() {
    return tableSourceType_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The table source type.
   * </pre>
   *
   * <code>
   * .google.cloud.datacatalog.v1beta1.TableSourceType table_source_type = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The tableSourceType.
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1beta1.TableSourceType getTableSourceType() {
    @SuppressWarnings("deprecation")
    com.google.cloud.datacatalog.v1beta1.TableSourceType result =
        com.google.cloud.datacatalog.v1beta1.TableSourceType.valueOf(tableSourceType_);
    return result == null
        ? com.google.cloud.datacatalog.v1beta1.TableSourceType.UNRECOGNIZED
        : result;
  }

  public static final int VIEW_SPEC_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Table view specification. This field should only be populated if
   * `table_source_type` is `BIGQUERY_VIEW`.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1beta1.ViewSpec view_spec = 2;</code>
   *
   * @return Whether the viewSpec field is set.
   */
  @java.lang.Override
  public boolean hasViewSpec() {
    return typeSpecCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Table view specification. This field should only be populated if
   * `table_source_type` is `BIGQUERY_VIEW`.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1beta1.ViewSpec view_spec = 2;</code>
   *
   * @return The viewSpec.
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1beta1.ViewSpec getViewSpec() {
    if (typeSpecCase_ == 2) {
      return (com.google.cloud.datacatalog.v1beta1.ViewSpec) typeSpec_;
    }
    return com.google.cloud.datacatalog.v1beta1.ViewSpec.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Table view specification. This field should only be populated if
   * `table_source_type` is `BIGQUERY_VIEW`.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1beta1.ViewSpec view_spec = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1beta1.ViewSpecOrBuilder getViewSpecOrBuilder() {
    if (typeSpecCase_ == 2) {
      return (com.google.cloud.datacatalog.v1beta1.ViewSpec) typeSpec_;
    }
    return com.google.cloud.datacatalog.v1beta1.ViewSpec.getDefaultInstance();
  }

  public static final int TABLE_SPEC_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Spec of a BigQuery table. This field should only be populated if
   * `table_source_type` is `BIGQUERY_TABLE`.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1beta1.TableSpec table_spec = 3;</code>
   *
   * @return Whether the tableSpec field is set.
   */
  @java.lang.Override
  public boolean hasTableSpec() {
    return typeSpecCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Spec of a BigQuery table. This field should only be populated if
   * `table_source_type` is `BIGQUERY_TABLE`.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1beta1.TableSpec table_spec = 3;</code>
   *
   * @return The tableSpec.
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1beta1.TableSpec getTableSpec() {
    if (typeSpecCase_ == 3) {
      return (com.google.cloud.datacatalog.v1beta1.TableSpec) typeSpec_;
    }
    return com.google.cloud.datacatalog.v1beta1.TableSpec.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Spec of a BigQuery table. This field should only be populated if
   * `table_source_type` is `BIGQUERY_TABLE`.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1beta1.TableSpec table_spec = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1beta1.TableSpecOrBuilder getTableSpecOrBuilder() {
    if (typeSpecCase_ == 3) {
      return (com.google.cloud.datacatalog.v1beta1.TableSpec) typeSpec_;
    }
    return com.google.cloud.datacatalog.v1beta1.TableSpec.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (tableSourceType_
        != com.google.cloud.datacatalog.v1beta1.TableSourceType.TABLE_SOURCE_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(1, tableSourceType_);
    }
    if (typeSpecCase_ == 2) {
      output.writeMessage(2, (com.google.cloud.datacatalog.v1beta1.ViewSpec) typeSpec_);
    }
    if (typeSpecCase_ == 3) {
      output.writeMessage(3, (com.google.cloud.datacatalog.v1beta1.TableSpec) typeSpec_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (tableSourceType_
        != com.google.cloud.datacatalog.v1beta1.TableSourceType.TABLE_SOURCE_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, tableSourceType_);
    }
    if (typeSpecCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.datacatalog.v1beta1.ViewSpec) typeSpec_);
    }
    if (typeSpecCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.datacatalog.v1beta1.TableSpec) typeSpec_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datacatalog.v1beta1.BigQueryTableSpec)) {
      return super.equals(obj);
    }
    com.google.cloud.datacatalog.v1beta1.BigQueryTableSpec other =
        (com.google.cloud.datacatalog.v1beta1.BigQueryTableSpec) obj;

    if (tableSourceType_ != other.tableSourceType_) return false;
    if (!getTypeSpecCase().equals(other.getTypeSpecCase())) return false;
    switch (typeSpecCase_) {
      case 2:
        if (!getViewSpec().equals(other.getViewSpec())) return false;
        break;
      case 3:
        if (!getTableSpec().equals(other.getTableSpec())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TABLE_SOURCE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + tableSourceType_;
    switch (typeSpecCase_) {
      case 2:
        hash = (37 * hash) + VIEW_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getViewSpec().hashCode();
        break;
      case 3:
        hash = (37 * hash) + TABLE_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getTableSpec().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datacatalog.v1beta1.BigQueryTableSpec parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1beta1.BigQueryTableSpec parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1beta1.BigQueryTableSpec parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1beta1.BigQueryTableSpec parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1beta1.BigQueryTableSpec parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1beta1.BigQueryTableSpec parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1beta1.BigQueryTableSpec parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1beta1.BigQueryTableSpec parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1beta1.BigQueryTableSpec parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1beta1.BigQueryTableSpec parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1beta1.BigQueryTableSpec parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1beta1.BigQueryTableSpec parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.datacatalog.v1beta1.BigQueryTableSpec prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Describes a BigQuery table.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datacatalog.v1beta1.BigQueryTableSpec}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datacatalog.v1beta1.BigQueryTableSpec)
      com.google.cloud.datacatalog.v1beta1.BigQueryTableSpecOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datacatalog.v1beta1.TableSpecOuterClass
          .internal_static_google_cloud_datacatalog_v1beta1_BigQueryTableSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datacatalog.v1beta1.TableSpecOuterClass
          .internal_static_google_cloud_datacatalog_v1beta1_BigQueryTableSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datacatalog.v1beta1.BigQueryTableSpec.class,
              com.google.cloud.datacatalog.v1beta1.BigQueryTableSpec.Builder.class);
    }

    // Construct using com.google.cloud.datacatalog.v1beta1.BigQueryTableSpec.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      tableSourceType_ = 0;

      if (viewSpecBuilder_ != null) {
        viewSpecBuilder_.clear();
      }
      if (tableSpecBuilder_ != null) {
        tableSpecBuilder_.clear();
      }
      typeSpecCase_ = 0;
      typeSpec_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datacatalog.v1beta1.TableSpecOuterClass
          .internal_static_google_cloud_datacatalog_v1beta1_BigQueryTableSpec_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1beta1.BigQueryTableSpec getDefaultInstanceForType() {
      return com.google.cloud.datacatalog.v1beta1.BigQueryTableSpec.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1beta1.BigQueryTableSpec build() {
      com.google.cloud.datacatalog.v1beta1.BigQueryTableSpec result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1beta1.BigQueryTableSpec buildPartial() {
      com.google.cloud.datacatalog.v1beta1.BigQueryTableSpec result =
          new com.google.cloud.datacatalog.v1beta1.BigQueryTableSpec(this);
      result.tableSourceType_ = tableSourceType_;
      if (typeSpecCase_ == 2) {
        if (viewSpecBuilder_ == null) {
          result.typeSpec_ = typeSpec_;
        } else {
          result.typeSpec_ = viewSpecBuilder_.build();
        }
      }
      if (typeSpecCase_ == 3) {
        if (tableSpecBuilder_ == null) {
          result.typeSpec_ = typeSpec_;
        } else {
          result.typeSpec_ = tableSpecBuilder_.build();
        }
      }
      result.typeSpecCase_ = typeSpecCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datacatalog.v1beta1.BigQueryTableSpec) {
        return mergeFrom((com.google.cloud.datacatalog.v1beta1.BigQueryTableSpec) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datacatalog.v1beta1.BigQueryTableSpec other) {
      if (other == com.google.cloud.datacatalog.v1beta1.BigQueryTableSpec.getDefaultInstance())
        return this;
      if (other.tableSourceType_ != 0) {
        setTableSourceTypeValue(other.getTableSourceTypeValue());
      }
      switch (other.getTypeSpecCase()) {
        case VIEW_SPEC:
          {
            mergeViewSpec(other.getViewSpec());
            break;
          }
        case TABLE_SPEC:
          {
            mergeTableSpec(other.getTableSpec());
            break;
          }
        case TYPESPEC_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                tableSourceType_ = input.readEnum();

                break;
              } // case 8
            case 18:
              {
                input.readMessage(getViewSpecFieldBuilder().getBuilder(), extensionRegistry);
                typeSpecCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getTableSpecFieldBuilder().getBuilder(), extensionRegistry);
                typeSpecCase_ = 3;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int typeSpecCase_ = 0;
    private java.lang.Object typeSpec_;

    public TypeSpecCase getTypeSpecCase() {
      return TypeSpecCase.forNumber(typeSpecCase_);
    }

    public Builder clearTypeSpec() {
      typeSpecCase_ = 0;
      typeSpec_ = null;
      onChanged();
      return this;
    }

    private int tableSourceType_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The table source type.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1beta1.TableSourceType table_source_type = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for tableSourceType.
     */
    @java.lang.Override
    public int getTableSourceTypeValue() {
      return tableSourceType_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The table source type.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1beta1.TableSourceType table_source_type = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for tableSourceType to set.
     * @return This builder for chaining.
     */
    public Builder setTableSourceTypeValue(int value) {

      tableSourceType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The table source type.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1beta1.TableSourceType table_source_type = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The tableSourceType.
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1beta1.TableSourceType getTableSourceType() {
      @SuppressWarnings("deprecation")
      com.google.cloud.datacatalog.v1beta1.TableSourceType result =
          com.google.cloud.datacatalog.v1beta1.TableSourceType.valueOf(tableSourceType_);
      return result == null
          ? com.google.cloud.datacatalog.v1beta1.TableSourceType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The table source type.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1beta1.TableSourceType table_source_type = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The tableSourceType to set.
     * @return This builder for chaining.
     */
    public Builder setTableSourceType(com.google.cloud.datacatalog.v1beta1.TableSourceType value) {
      if (value == null) {
        throw new NullPointerException();
      }

      tableSourceType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The table source type.
     * </pre>
     *
     * <code>
     * .google.cloud.datacatalog.v1beta1.TableSourceType table_source_type = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTableSourceType() {

      tableSourceType_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1beta1.ViewSpec,
            com.google.cloud.datacatalog.v1beta1.ViewSpec.Builder,
            com.google.cloud.datacatalog.v1beta1.ViewSpecOrBuilder>
        viewSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Table view specification. This field should only be populated if
     * `table_source_type` is `BIGQUERY_VIEW`.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.ViewSpec view_spec = 2;</code>
     *
     * @return Whether the viewSpec field is set.
     */
    @java.lang.Override
    public boolean hasViewSpec() {
      return typeSpecCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Table view specification. This field should only be populated if
     * `table_source_type` is `BIGQUERY_VIEW`.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.ViewSpec view_spec = 2;</code>
     *
     * @return The viewSpec.
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1beta1.ViewSpec getViewSpec() {
      if (viewSpecBuilder_ == null) {
        if (typeSpecCase_ == 2) {
          return (com.google.cloud.datacatalog.v1beta1.ViewSpec) typeSpec_;
        }
        return com.google.cloud.datacatalog.v1beta1.ViewSpec.getDefaultInstance();
      } else {
        if (typeSpecCase_ == 2) {
          return viewSpecBuilder_.getMessage();
        }
        return com.google.cloud.datacatalog.v1beta1.ViewSpec.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Table view specification. This field should only be populated if
     * `table_source_type` is `BIGQUERY_VIEW`.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.ViewSpec view_spec = 2;</code>
     */
    public Builder setViewSpec(com.google.cloud.datacatalog.v1beta1.ViewSpec value) {
      if (viewSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        typeSpec_ = value;
        onChanged();
      } else {
        viewSpecBuilder_.setMessage(value);
      }
      typeSpecCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Table view specification. This field should only be populated if
     * `table_source_type` is `BIGQUERY_VIEW`.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.ViewSpec view_spec = 2;</code>
     */
    public Builder setViewSpec(
        com.google.cloud.datacatalog.v1beta1.ViewSpec.Builder builderForValue) {
      if (viewSpecBuilder_ == null) {
        typeSpec_ = builderForValue.build();
        onChanged();
      } else {
        viewSpecBuilder_.setMessage(builderForValue.build());
      }
      typeSpecCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Table view specification. This field should only be populated if
     * `table_source_type` is `BIGQUERY_VIEW`.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.ViewSpec view_spec = 2;</code>
     */
    public Builder mergeViewSpec(com.google.cloud.datacatalog.v1beta1.ViewSpec value) {
      if (viewSpecBuilder_ == null) {
        if (typeSpecCase_ == 2
            && typeSpec_ != com.google.cloud.datacatalog.v1beta1.ViewSpec.getDefaultInstance()) {
          typeSpec_ =
              com.google.cloud.datacatalog.v1beta1.ViewSpec.newBuilder(
                      (com.google.cloud.datacatalog.v1beta1.ViewSpec) typeSpec_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          typeSpec_ = value;
        }
        onChanged();
      } else {
        if (typeSpecCase_ == 2) {
          viewSpecBuilder_.mergeFrom(value);
        } else {
          viewSpecBuilder_.setMessage(value);
        }
      }
      typeSpecCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Table view specification. This field should only be populated if
     * `table_source_type` is `BIGQUERY_VIEW`.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.ViewSpec view_spec = 2;</code>
     */
    public Builder clearViewSpec() {
      if (viewSpecBuilder_ == null) {
        if (typeSpecCase_ == 2) {
          typeSpecCase_ = 0;
          typeSpec_ = null;
          onChanged();
        }
      } else {
        if (typeSpecCase_ == 2) {
          typeSpecCase_ = 0;
          typeSpec_ = null;
        }
        viewSpecBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Table view specification. This field should only be populated if
     * `table_source_type` is `BIGQUERY_VIEW`.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.ViewSpec view_spec = 2;</code>
     */
    public com.google.cloud.datacatalog.v1beta1.ViewSpec.Builder getViewSpecBuilder() {
      return getViewSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Table view specification. This field should only be populated if
     * `table_source_type` is `BIGQUERY_VIEW`.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.ViewSpec view_spec = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1beta1.ViewSpecOrBuilder getViewSpecOrBuilder() {
      if ((typeSpecCase_ == 2) && (viewSpecBuilder_ != null)) {
        return viewSpecBuilder_.getMessageOrBuilder();
      } else {
        if (typeSpecCase_ == 2) {
          return (com.google.cloud.datacatalog.v1beta1.ViewSpec) typeSpec_;
        }
        return com.google.cloud.datacatalog.v1beta1.ViewSpec.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Table view specification. This field should only be populated if
     * `table_source_type` is `BIGQUERY_VIEW`.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.ViewSpec view_spec = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1beta1.ViewSpec,
            com.google.cloud.datacatalog.v1beta1.ViewSpec.Builder,
            com.google.cloud.datacatalog.v1beta1.ViewSpecOrBuilder>
        getViewSpecFieldBuilder() {
      if (viewSpecBuilder_ == null) {
        if (!(typeSpecCase_ == 2)) {
          typeSpec_ = com.google.cloud.datacatalog.v1beta1.ViewSpec.getDefaultInstance();
        }
        viewSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datacatalog.v1beta1.ViewSpec,
                com.google.cloud.datacatalog.v1beta1.ViewSpec.Builder,
                com.google.cloud.datacatalog.v1beta1.ViewSpecOrBuilder>(
                (com.google.cloud.datacatalog.v1beta1.ViewSpec) typeSpec_,
                getParentForChildren(),
                isClean());
        typeSpec_ = null;
      }
      typeSpecCase_ = 2;
      onChanged();
      ;
      return viewSpecBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1beta1.TableSpec,
            com.google.cloud.datacatalog.v1beta1.TableSpec.Builder,
            com.google.cloud.datacatalog.v1beta1.TableSpecOrBuilder>
        tableSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Spec of a BigQuery table. This field should only be populated if
     * `table_source_type` is `BIGQUERY_TABLE`.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.TableSpec table_spec = 3;</code>
     *
     * @return Whether the tableSpec field is set.
     */
    @java.lang.Override
    public boolean hasTableSpec() {
      return typeSpecCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Spec of a BigQuery table. This field should only be populated if
     * `table_source_type` is `BIGQUERY_TABLE`.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.TableSpec table_spec = 3;</code>
     *
     * @return The tableSpec.
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1beta1.TableSpec getTableSpec() {
      if (tableSpecBuilder_ == null) {
        if (typeSpecCase_ == 3) {
          return (com.google.cloud.datacatalog.v1beta1.TableSpec) typeSpec_;
        }
        return com.google.cloud.datacatalog.v1beta1.TableSpec.getDefaultInstance();
      } else {
        if (typeSpecCase_ == 3) {
          return tableSpecBuilder_.getMessage();
        }
        return com.google.cloud.datacatalog.v1beta1.TableSpec.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Spec of a BigQuery table. This field should only be populated if
     * `table_source_type` is `BIGQUERY_TABLE`.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.TableSpec table_spec = 3;</code>
     */
    public Builder setTableSpec(com.google.cloud.datacatalog.v1beta1.TableSpec value) {
      if (tableSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        typeSpec_ = value;
        onChanged();
      } else {
        tableSpecBuilder_.setMessage(value);
      }
      typeSpecCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Spec of a BigQuery table. This field should only be populated if
     * `table_source_type` is `BIGQUERY_TABLE`.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.TableSpec table_spec = 3;</code>
     */
    public Builder setTableSpec(
        com.google.cloud.datacatalog.v1beta1.TableSpec.Builder builderForValue) {
      if (tableSpecBuilder_ == null) {
        typeSpec_ = builderForValue.build();
        onChanged();
      } else {
        tableSpecBuilder_.setMessage(builderForValue.build());
      }
      typeSpecCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Spec of a BigQuery table. This field should only be populated if
     * `table_source_type` is `BIGQUERY_TABLE`.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.TableSpec table_spec = 3;</code>
     */
    public Builder mergeTableSpec(com.google.cloud.datacatalog.v1beta1.TableSpec value) {
      if (tableSpecBuilder_ == null) {
        if (typeSpecCase_ == 3
            && typeSpec_ != com.google.cloud.datacatalog.v1beta1.TableSpec.getDefaultInstance()) {
          typeSpec_ =
              com.google.cloud.datacatalog.v1beta1.TableSpec.newBuilder(
                      (com.google.cloud.datacatalog.v1beta1.TableSpec) typeSpec_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          typeSpec_ = value;
        }
        onChanged();
      } else {
        if (typeSpecCase_ == 3) {
          tableSpecBuilder_.mergeFrom(value);
        } else {
          tableSpecBuilder_.setMessage(value);
        }
      }
      typeSpecCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Spec of a BigQuery table. This field should only be populated if
     * `table_source_type` is `BIGQUERY_TABLE`.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.TableSpec table_spec = 3;</code>
     */
    public Builder clearTableSpec() {
      if (tableSpecBuilder_ == null) {
        if (typeSpecCase_ == 3) {
          typeSpecCase_ = 0;
          typeSpec_ = null;
          onChanged();
        }
      } else {
        if (typeSpecCase_ == 3) {
          typeSpecCase_ = 0;
          typeSpec_ = null;
        }
        tableSpecBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Spec of a BigQuery table. This field should only be populated if
     * `table_source_type` is `BIGQUERY_TABLE`.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.TableSpec table_spec = 3;</code>
     */
    public com.google.cloud.datacatalog.v1beta1.TableSpec.Builder getTableSpecBuilder() {
      return getTableSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Spec of a BigQuery table. This field should only be populated if
     * `table_source_type` is `BIGQUERY_TABLE`.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.TableSpec table_spec = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1beta1.TableSpecOrBuilder getTableSpecOrBuilder() {
      if ((typeSpecCase_ == 3) && (tableSpecBuilder_ != null)) {
        return tableSpecBuilder_.getMessageOrBuilder();
      } else {
        if (typeSpecCase_ == 3) {
          return (com.google.cloud.datacatalog.v1beta1.TableSpec) typeSpec_;
        }
        return com.google.cloud.datacatalog.v1beta1.TableSpec.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Spec of a BigQuery table. This field should only be populated if
     * `table_source_type` is `BIGQUERY_TABLE`.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.TableSpec table_spec = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datacatalog.v1beta1.TableSpec,
            com.google.cloud.datacatalog.v1beta1.TableSpec.Builder,
            com.google.cloud.datacatalog.v1beta1.TableSpecOrBuilder>
        getTableSpecFieldBuilder() {
      if (tableSpecBuilder_ == null) {
        if (!(typeSpecCase_ == 3)) {
          typeSpec_ = com.google.cloud.datacatalog.v1beta1.TableSpec.getDefaultInstance();
        }
        tableSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datacatalog.v1beta1.TableSpec,
                com.google.cloud.datacatalog.v1beta1.TableSpec.Builder,
                com.google.cloud.datacatalog.v1beta1.TableSpecOrBuilder>(
                (com.google.cloud.datacatalog.v1beta1.TableSpec) typeSpec_,
                getParentForChildren(),
                isClean());
        typeSpec_ = null;
      }
      typeSpecCase_ = 3;
      onChanged();
      ;
      return tableSpecBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datacatalog.v1beta1.BigQueryTableSpec)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datacatalog.v1beta1.BigQueryTableSpec)
  private static final com.google.cloud.datacatalog.v1beta1.BigQueryTableSpec DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datacatalog.v1beta1.BigQueryTableSpec();
  }

  public static com.google.cloud.datacatalog.v1beta1.BigQueryTableSpec getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BigQueryTableSpec> PARSER =
      new com.google.protobuf.AbstractParser<BigQueryTableSpec>() {
        @java.lang.Override
        public BigQueryTableSpec parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BigQueryTableSpec> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BigQueryTableSpec> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datacatalog.v1beta1.BigQueryTableSpec getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
