/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datacatalog/v1beta1/policytagmanager.proto

package com.google.cloud.datacatalog.v1beta1;

/**
 *
 *
 * <pre>
 * Denotes one policy tag in a taxonomy (e.g. ssn). Policy Tags can be defined
 * in a hierarchy. For example, consider the following hierarchy:
 * Geolocation -&amp;gt; (LatLong, City, ZipCode). PolicyTag "Geolocation"
 * contains three child policy tags: "LatLong", "City", and "ZipCode".
 * </pre>
 *
 * Protobuf type {@code google.cloud.datacatalog.v1beta1.PolicyTag}
 */
public final class PolicyTag extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datacatalog.v1beta1.PolicyTag)
    PolicyTagOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PolicyTag.newBuilder() to construct.
  private PolicyTag(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PolicyTag() {
    name_ = "";
    displayName_ = "";
    description_ = "";
    parentPolicyTag_ = "";
    childPolicyTags_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PolicyTag();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datacatalog.v1beta1.PolicyTagManagerProto
        .internal_static_google_cloud_datacatalog_v1beta1_PolicyTag_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datacatalog.v1beta1.PolicyTagManagerProto
        .internal_static_google_cloud_datacatalog_v1beta1_PolicyTag_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datacatalog.v1beta1.PolicyTag.class,
            com.google.cloud.datacatalog.v1beta1.PolicyTag.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Identifier. Resource name of this policy tag, whose format is:
   * "projects/{project_number}/locations/{location_id}/taxonomies/{taxonomy_id}/policyTags/{id}".
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Identifier. Resource name of this policy tag, whose format is:
   * "projects/{project_number}/locations/{location_id}/taxonomies/{taxonomy_id}/policyTags/{id}".
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Required. User defined name of this policy tag. It must: be unique within
   * the parent taxonomy; contain only unicode letters, numbers, underscores,
   * dashes and spaces; not start or end with spaces; and be at most 200 bytes
   * long when encoded in UTF-8.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. User defined name of this policy tag. It must: be unique within
   * the parent taxonomy; contain only unicode letters, numbers, underscores,
   * dashes and spaces; not start or end with spaces; and be at most 200 bytes
   * long when encoded in UTF-8.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Description of this policy tag. It must: contain only unicode characters,
   * tabs, newlines, carriage returns and page breaks; and be at most 2000 bytes
   * long when encoded in UTF-8. If not set, defaults to an empty description.
   * If not set, defaults to an empty description.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Description of this policy tag. It must: contain only unicode characters,
   * tabs, newlines, carriage returns and page breaks; and be at most 2000 bytes
   * long when encoded in UTF-8. If not set, defaults to an empty description.
   * If not set, defaults to an empty description.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PARENT_POLICY_TAG_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parentPolicyTag_ = "";
  /**
   *
   *
   * <pre>
   * Resource name of this policy tag's parent policy tag (e.g. for the
   * "LatLong" policy tag in the example above, this field contains the
   * resource name of the "Geolocation" policy tag). If empty, it means this
   * policy tag is a top level policy tag (e.g. this field is empty for the
   * "Geolocation" policy tag in the example above). If not set, defaults to an
   * empty string.
   * </pre>
   *
   * <code>string parent_policy_tag = 4;</code>
   *
   * @return The parentPolicyTag.
   */
  @java.lang.Override
  public java.lang.String getParentPolicyTag() {
    java.lang.Object ref = parentPolicyTag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parentPolicyTag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Resource name of this policy tag's parent policy tag (e.g. for the
   * "LatLong" policy tag in the example above, this field contains the
   * resource name of the "Geolocation" policy tag). If empty, it means this
   * policy tag is a top level policy tag (e.g. this field is empty for the
   * "Geolocation" policy tag in the example above). If not set, defaults to an
   * empty string.
   * </pre>
   *
   * <code>string parent_policy_tag = 4;</code>
   *
   * @return The bytes for parentPolicyTag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentPolicyTagBytes() {
    java.lang.Object ref = parentPolicyTag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parentPolicyTag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CHILD_POLICY_TAGS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList childPolicyTags_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Output only. Resource names of child policy tags of this policy tag.
   * </pre>
   *
   * <code>repeated string child_policy_tags = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return A list containing the childPolicyTags.
   */
  public com.google.protobuf.ProtocolStringList getChildPolicyTagsList() {
    return childPolicyTags_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Resource names of child policy tags of this policy tag.
   * </pre>
   *
   * <code>repeated string child_policy_tags = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The count of childPolicyTags.
   */
  public int getChildPolicyTagsCount() {
    return childPolicyTags_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Resource names of child policy tags of this policy tag.
   * </pre>
   *
   * <code>repeated string child_policy_tags = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The childPolicyTags at the given index.
   */
  public java.lang.String getChildPolicyTags(int index) {
    return childPolicyTags_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. Resource names of child policy tags of this policy tag.
   * </pre>
   *
   * <code>repeated string child_policy_tags = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the childPolicyTags at the given index.
   */
  public com.google.protobuf.ByteString getChildPolicyTagsBytes(int index) {
    return childPolicyTags_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parentPolicyTag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, parentPolicyTag_);
    }
    for (int i = 0; i < childPolicyTags_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, childPolicyTags_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, description_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parentPolicyTag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, parentPolicyTag_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < childPolicyTags_.size(); i++) {
        dataSize += computeStringSizeNoTag(childPolicyTags_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getChildPolicyTagsList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datacatalog.v1beta1.PolicyTag)) {
      return super.equals(obj);
    }
    com.google.cloud.datacatalog.v1beta1.PolicyTag other =
        (com.google.cloud.datacatalog.v1beta1.PolicyTag) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getParentPolicyTag().equals(other.getParentPolicyTag())) return false;
    if (!getChildPolicyTagsList().equals(other.getChildPolicyTagsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + PARENT_POLICY_TAG_FIELD_NUMBER;
    hash = (53 * hash) + getParentPolicyTag().hashCode();
    if (getChildPolicyTagsCount() > 0) {
      hash = (37 * hash) + CHILD_POLICY_TAGS_FIELD_NUMBER;
      hash = (53 * hash) + getChildPolicyTagsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datacatalog.v1beta1.PolicyTag parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1beta1.PolicyTag parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1beta1.PolicyTag parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1beta1.PolicyTag parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1beta1.PolicyTag parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1beta1.PolicyTag parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1beta1.PolicyTag parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1beta1.PolicyTag parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1beta1.PolicyTag parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1beta1.PolicyTag parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1beta1.PolicyTag parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1beta1.PolicyTag parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.datacatalog.v1beta1.PolicyTag prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Denotes one policy tag in a taxonomy (e.g. ssn). Policy Tags can be defined
   * in a hierarchy. For example, consider the following hierarchy:
   * Geolocation -&amp;gt; (LatLong, City, ZipCode). PolicyTag "Geolocation"
   * contains three child policy tags: "LatLong", "City", and "ZipCode".
   * </pre>
   *
   * Protobuf type {@code google.cloud.datacatalog.v1beta1.PolicyTag}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datacatalog.v1beta1.PolicyTag)
      com.google.cloud.datacatalog.v1beta1.PolicyTagOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datacatalog.v1beta1.PolicyTagManagerProto
          .internal_static_google_cloud_datacatalog_v1beta1_PolicyTag_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datacatalog.v1beta1.PolicyTagManagerProto
          .internal_static_google_cloud_datacatalog_v1beta1_PolicyTag_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datacatalog.v1beta1.PolicyTag.class,
              com.google.cloud.datacatalog.v1beta1.PolicyTag.Builder.class);
    }

    // Construct using com.google.cloud.datacatalog.v1beta1.PolicyTag.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      description_ = "";
      parentPolicyTag_ = "";
      childPolicyTags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datacatalog.v1beta1.PolicyTagManagerProto
          .internal_static_google_cloud_datacatalog_v1beta1_PolicyTag_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1beta1.PolicyTag getDefaultInstanceForType() {
      return com.google.cloud.datacatalog.v1beta1.PolicyTag.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1beta1.PolicyTag build() {
      com.google.cloud.datacatalog.v1beta1.PolicyTag result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1beta1.PolicyTag buildPartial() {
      com.google.cloud.datacatalog.v1beta1.PolicyTag result =
          new com.google.cloud.datacatalog.v1beta1.PolicyTag(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.datacatalog.v1beta1.PolicyTag result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.parentPolicyTag_ = parentPolicyTag_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        childPolicyTags_.makeImmutable();
        result.childPolicyTags_ = childPolicyTags_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datacatalog.v1beta1.PolicyTag) {
        return mergeFrom((com.google.cloud.datacatalog.v1beta1.PolicyTag) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datacatalog.v1beta1.PolicyTag other) {
      if (other == com.google.cloud.datacatalog.v1beta1.PolicyTag.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getParentPolicyTag().isEmpty()) {
        parentPolicyTag_ = other.parentPolicyTag_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.childPolicyTags_.isEmpty()) {
        if (childPolicyTags_.isEmpty()) {
          childPolicyTags_ = other.childPolicyTags_;
          bitField0_ |= 0x00000010;
        } else {
          ensureChildPolicyTagsIsMutable();
          childPolicyTags_.addAll(other.childPolicyTags_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                parentPolicyTag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureChildPolicyTagsIsMutable();
                childPolicyTags_.add(s);
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Identifier. Resource name of this policy tag, whose format is:
     * "projects/{project_number}/locations/{location_id}/taxonomies/{taxonomy_id}/policyTags/{id}".
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Identifier. Resource name of this policy tag, whose format is:
     * "projects/{project_number}/locations/{location_id}/taxonomies/{taxonomy_id}/policyTags/{id}".
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Identifier. Resource name of this policy tag, whose format is:
     * "projects/{project_number}/locations/{location_id}/taxonomies/{taxonomy_id}/policyTags/{id}".
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identifier. Resource name of this policy tag, whose format is:
     * "projects/{project_number}/locations/{location_id}/taxonomies/{taxonomy_id}/policyTags/{id}".
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Identifier. Resource name of this policy tag, whose format is:
     * "projects/{project_number}/locations/{location_id}/taxonomies/{taxonomy_id}/policyTags/{id}".
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. User defined name of this policy tag. It must: be unique within
     * the parent taxonomy; contain only unicode letters, numbers, underscores,
     * dashes and spaces; not start or end with spaces; and be at most 200 bytes
     * long when encoded in UTF-8.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. User defined name of this policy tag. It must: be unique within
     * the parent taxonomy; contain only unicode letters, numbers, underscores,
     * dashes and spaces; not start or end with spaces; and be at most 200 bytes
     * long when encoded in UTF-8.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. User defined name of this policy tag. It must: be unique within
     * the parent taxonomy; contain only unicode letters, numbers, underscores,
     * dashes and spaces; not start or end with spaces; and be at most 200 bytes
     * long when encoded in UTF-8.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. User defined name of this policy tag. It must: be unique within
     * the parent taxonomy; contain only unicode letters, numbers, underscores,
     * dashes and spaces; not start or end with spaces; and be at most 200 bytes
     * long when encoded in UTF-8.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. User defined name of this policy tag. It must: be unique within
     * the parent taxonomy; contain only unicode letters, numbers, underscores,
     * dashes and spaces; not start or end with spaces; and be at most 200 bytes
     * long when encoded in UTF-8.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Description of this policy tag. It must: contain only unicode characters,
     * tabs, newlines, carriage returns and page breaks; and be at most 2000 bytes
     * long when encoded in UTF-8. If not set, defaults to an empty description.
     * If not set, defaults to an empty description.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Description of this policy tag. It must: contain only unicode characters,
     * tabs, newlines, carriage returns and page breaks; and be at most 2000 bytes
     * long when encoded in UTF-8. If not set, defaults to an empty description.
     * If not set, defaults to an empty description.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Description of this policy tag. It must: contain only unicode characters,
     * tabs, newlines, carriage returns and page breaks; and be at most 2000 bytes
     * long when encoded in UTF-8. If not set, defaults to an empty description.
     * If not set, defaults to an empty description.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Description of this policy tag. It must: contain only unicode characters,
     * tabs, newlines, carriage returns and page breaks; and be at most 2000 bytes
     * long when encoded in UTF-8. If not set, defaults to an empty description.
     * If not set, defaults to an empty description.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Description of this policy tag. It must: contain only unicode characters,
     * tabs, newlines, carriage returns and page breaks; and be at most 2000 bytes
     * long when encoded in UTF-8. If not set, defaults to an empty description.
     * If not set, defaults to an empty description.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object parentPolicyTag_ = "";
    /**
     *
     *
     * <pre>
     * Resource name of this policy tag's parent policy tag (e.g. for the
     * "LatLong" policy tag in the example above, this field contains the
     * resource name of the "Geolocation" policy tag). If empty, it means this
     * policy tag is a top level policy tag (e.g. this field is empty for the
     * "Geolocation" policy tag in the example above). If not set, defaults to an
     * empty string.
     * </pre>
     *
     * <code>string parent_policy_tag = 4;</code>
     *
     * @return The parentPolicyTag.
     */
    public java.lang.String getParentPolicyTag() {
      java.lang.Object ref = parentPolicyTag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parentPolicyTag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Resource name of this policy tag's parent policy tag (e.g. for the
     * "LatLong" policy tag in the example above, this field contains the
     * resource name of the "Geolocation" policy tag). If empty, it means this
     * policy tag is a top level policy tag (e.g. this field is empty for the
     * "Geolocation" policy tag in the example above). If not set, defaults to an
     * empty string.
     * </pre>
     *
     * <code>string parent_policy_tag = 4;</code>
     *
     * @return The bytes for parentPolicyTag.
     */
    public com.google.protobuf.ByteString getParentPolicyTagBytes() {
      java.lang.Object ref = parentPolicyTag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parentPolicyTag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Resource name of this policy tag's parent policy tag (e.g. for the
     * "LatLong" policy tag in the example above, this field contains the
     * resource name of the "Geolocation" policy tag). If empty, it means this
     * policy tag is a top level policy tag (e.g. this field is empty for the
     * "Geolocation" policy tag in the example above). If not set, defaults to an
     * empty string.
     * </pre>
     *
     * <code>string parent_policy_tag = 4;</code>
     *
     * @param value The parentPolicyTag to set.
     * @return This builder for chaining.
     */
    public Builder setParentPolicyTag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parentPolicyTag_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource name of this policy tag's parent policy tag (e.g. for the
     * "LatLong" policy tag in the example above, this field contains the
     * resource name of the "Geolocation" policy tag). If empty, it means this
     * policy tag is a top level policy tag (e.g. this field is empty for the
     * "Geolocation" policy tag in the example above). If not set, defaults to an
     * empty string.
     * </pre>
     *
     * <code>string parent_policy_tag = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParentPolicyTag() {
      parentPolicyTag_ = getDefaultInstance().getParentPolicyTag();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource name of this policy tag's parent policy tag (e.g. for the
     * "LatLong" policy tag in the example above, this field contains the
     * resource name of the "Geolocation" policy tag). If empty, it means this
     * policy tag is a top level policy tag (e.g. this field is empty for the
     * "Geolocation" policy tag in the example above). If not set, defaults to an
     * empty string.
     * </pre>
     *
     * <code>string parent_policy_tag = 4;</code>
     *
     * @param value The bytes for parentPolicyTag to set.
     * @return This builder for chaining.
     */
    public Builder setParentPolicyTagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parentPolicyTag_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList childPolicyTags_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureChildPolicyTagsIsMutable() {
      if (!childPolicyTags_.isModifiable()) {
        childPolicyTags_ = new com.google.protobuf.LazyStringArrayList(childPolicyTags_);
      }
      bitField0_ |= 0x00000010;
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource names of child policy tags of this policy tag.
     * </pre>
     *
     * <code>repeated string child_policy_tags = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return A list containing the childPolicyTags.
     */
    public com.google.protobuf.ProtocolStringList getChildPolicyTagsList() {
      childPolicyTags_.makeImmutable();
      return childPolicyTags_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource names of child policy tags of this policy tag.
     * </pre>
     *
     * <code>repeated string child_policy_tags = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The count of childPolicyTags.
     */
    public int getChildPolicyTagsCount() {
      return childPolicyTags_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource names of child policy tags of this policy tag.
     * </pre>
     *
     * <code>repeated string child_policy_tags = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The childPolicyTags at the given index.
     */
    public java.lang.String getChildPolicyTags(int index) {
      return childPolicyTags_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource names of child policy tags of this policy tag.
     * </pre>
     *
     * <code>repeated string child_policy_tags = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the childPolicyTags at the given index.
     */
    public com.google.protobuf.ByteString getChildPolicyTagsBytes(int index) {
      return childPolicyTags_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource names of child policy tags of this policy tag.
     * </pre>
     *
     * <code>repeated string child_policy_tags = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The childPolicyTags to set.
     * @return This builder for chaining.
     */
    public Builder setChildPolicyTags(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureChildPolicyTagsIsMutable();
      childPolicyTags_.set(index, value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource names of child policy tags of this policy tag.
     * </pre>
     *
     * <code>repeated string child_policy_tags = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The childPolicyTags to add.
     * @return This builder for chaining.
     */
    public Builder addChildPolicyTags(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureChildPolicyTagsIsMutable();
      childPolicyTags_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource names of child policy tags of this policy tag.
     * </pre>
     *
     * <code>repeated string child_policy_tags = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param values The childPolicyTags to add.
     * @return This builder for chaining.
     */
    public Builder addAllChildPolicyTags(java.lang.Iterable<java.lang.String> values) {
      ensureChildPolicyTagsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, childPolicyTags_);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource names of child policy tags of this policy tag.
     * </pre>
     *
     * <code>repeated string child_policy_tags = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearChildPolicyTags() {
      childPolicyTags_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000010);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource names of child policy tags of this policy tag.
     * </pre>
     *
     * <code>repeated string child_policy_tags = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The bytes of the childPolicyTags to add.
     * @return This builder for chaining.
     */
    public Builder addChildPolicyTagsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureChildPolicyTagsIsMutable();
      childPolicyTags_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datacatalog.v1beta1.PolicyTag)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datacatalog.v1beta1.PolicyTag)
  private static final com.google.cloud.datacatalog.v1beta1.PolicyTag DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datacatalog.v1beta1.PolicyTag();
  }

  public static com.google.cloud.datacatalog.v1beta1.PolicyTag getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PolicyTag> PARSER =
      new com.google.protobuf.AbstractParser<PolicyTag>() {
        @java.lang.Override
        public PolicyTag parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PolicyTag> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PolicyTag> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datacatalog.v1beta1.PolicyTag getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
