/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datacatalog/v1beta1/search.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.datacatalog.v1beta1;

/**
 *
 *
 * <pre>
 * A result that appears in the response of a search request. Each result
 * captures details of one entry that matches the search.
 * </pre>
 *
 * Protobuf type {@code google.cloud.datacatalog.v1beta1.SearchCatalogResult}
 */
public final class SearchCatalogResult extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datacatalog.v1beta1.SearchCatalogResult)
    SearchCatalogResultOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SearchCatalogResult.newBuilder() to construct.
  private SearchCatalogResult(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SearchCatalogResult() {
    searchResultType_ = 0;
    searchResultSubtype_ = "";
    relativeResourceName_ = "";
    linkedResource_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SearchCatalogResult();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datacatalog.v1beta1.Search
        .internal_static_google_cloud_datacatalog_v1beta1_SearchCatalogResult_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datacatalog.v1beta1.Search
        .internal_static_google_cloud_datacatalog_v1beta1_SearchCatalogResult_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datacatalog.v1beta1.SearchCatalogResult.class,
            com.google.cloud.datacatalog.v1beta1.SearchCatalogResult.Builder.class);
  }

  private int bitField0_;
  public static final int SEARCH_RESULT_TYPE_FIELD_NUMBER = 1;
  private int searchResultType_ = 0;
  /**
   *
   *
   * <pre>
   * Type of the search result. This field can be used to determine which Get
   * method to call to fetch the full resource.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1beta1.SearchResultType search_result_type = 1;</code>
   *
   * @return The enum numeric value on the wire for searchResultType.
   */
  @java.lang.Override
  public int getSearchResultTypeValue() {
    return searchResultType_;
  }
  /**
   *
   *
   * <pre>
   * Type of the search result. This field can be used to determine which Get
   * method to call to fetch the full resource.
   * </pre>
   *
   * <code>.google.cloud.datacatalog.v1beta1.SearchResultType search_result_type = 1;</code>
   *
   * @return The searchResultType.
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1beta1.SearchResultType getSearchResultType() {
    com.google.cloud.datacatalog.v1beta1.SearchResultType result =
        com.google.cloud.datacatalog.v1beta1.SearchResultType.forNumber(searchResultType_);
    return result == null
        ? com.google.cloud.datacatalog.v1beta1.SearchResultType.UNRECOGNIZED
        : result;
  }

  public static final int SEARCH_RESULT_SUBTYPE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object searchResultSubtype_ = "";
  /**
   *
   *
   * <pre>
   * Sub-type of the search result. This is a dot-delimited description of the
   * resource's full type, and is the same as the value callers would provide in
   * the "type" search facet.  Examples: `entry.table`, `entry.dataStream`,
   * `tagTemplate`.
   * </pre>
   *
   * <code>string search_result_subtype = 2;</code>
   *
   * @return The searchResultSubtype.
   */
  @java.lang.Override
  public java.lang.String getSearchResultSubtype() {
    java.lang.Object ref = searchResultSubtype_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      searchResultSubtype_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Sub-type of the search result. This is a dot-delimited description of the
   * resource's full type, and is the same as the value callers would provide in
   * the "type" search facet.  Examples: `entry.table`, `entry.dataStream`,
   * `tagTemplate`.
   * </pre>
   *
   * <code>string search_result_subtype = 2;</code>
   *
   * @return The bytes for searchResultSubtype.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSearchResultSubtypeBytes() {
    java.lang.Object ref = searchResultSubtype_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      searchResultSubtype_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RELATIVE_RESOURCE_NAME_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object relativeResourceName_ = "";
  /**
   *
   *
   * <pre>
   * The relative resource name of the resource in URL format.
   * Examples:
   *
   *  * `projects/{project_id}/locations/{location_id}/entryGroups/{entry_group_id}/entries/{entry_id}`
   *  * `projects/{project_id}/tagTemplates/{tag_template_id}`
   * </pre>
   *
   * <code>string relative_resource_name = 3;</code>
   *
   * @return The relativeResourceName.
   */
  @java.lang.Override
  public java.lang.String getRelativeResourceName() {
    java.lang.Object ref = relativeResourceName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      relativeResourceName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The relative resource name of the resource in URL format.
   * Examples:
   *
   *  * `projects/{project_id}/locations/{location_id}/entryGroups/{entry_group_id}/entries/{entry_id}`
   *  * `projects/{project_id}/tagTemplates/{tag_template_id}`
   * </pre>
   *
   * <code>string relative_resource_name = 3;</code>
   *
   * @return The bytes for relativeResourceName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRelativeResourceNameBytes() {
    java.lang.Object ref = relativeResourceName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      relativeResourceName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LINKED_RESOURCE_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object linkedResource_ = "";
  /**
   *
   *
   * <pre>
   * The full name of the cloud resource the entry belongs to. See:
   * https://cloud.google.com/apis/design/resource_names#full_resource_name.
   * Example:
   *
   *  * `//bigquery.googleapis.com/projects/projectId/datasets/datasetId/tables/tableId`
   * </pre>
   *
   * <code>string linked_resource = 4;</code>
   *
   * @return The linkedResource.
   */
  @java.lang.Override
  public java.lang.String getLinkedResource() {
    java.lang.Object ref = linkedResource_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      linkedResource_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The full name of the cloud resource the entry belongs to. See:
   * https://cloud.google.com/apis/design/resource_names#full_resource_name.
   * Example:
   *
   *  * `//bigquery.googleapis.com/projects/projectId/datasets/datasetId/tables/tableId`
   * </pre>
   *
   * <code>string linked_resource = 4;</code>
   *
   * @return The bytes for linkedResource.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLinkedResourceBytes() {
    java.lang.Object ref = linkedResource_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      linkedResource_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MODIFY_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp modifyTime_;
  /**
   *
   *
   * <pre>
   * Last-modified timestamp of the entry from the managing system.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp modify_time = 7;</code>
   *
   * @return Whether the modifyTime field is set.
   */
  @java.lang.Override
  public boolean hasModifyTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Last-modified timestamp of the entry from the managing system.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp modify_time = 7;</code>
   *
   * @return The modifyTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getModifyTime() {
    return modifyTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : modifyTime_;
  }
  /**
   *
   *
   * <pre>
   * Last-modified timestamp of the entry from the managing system.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp modify_time = 7;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getModifyTimeOrBuilder() {
    return modifyTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : modifyTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (searchResultType_
        != com.google.cloud.datacatalog.v1beta1.SearchResultType.SEARCH_RESULT_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(1, searchResultType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(searchResultSubtype_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, searchResultSubtype_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(relativeResourceName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, relativeResourceName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(linkedResource_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, linkedResource_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(7, getModifyTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (searchResultType_
        != com.google.cloud.datacatalog.v1beta1.SearchResultType.SEARCH_RESULT_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, searchResultType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(searchResultSubtype_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, searchResultSubtype_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(relativeResourceName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, relativeResourceName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(linkedResource_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, linkedResource_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getModifyTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datacatalog.v1beta1.SearchCatalogResult)) {
      return super.equals(obj);
    }
    com.google.cloud.datacatalog.v1beta1.SearchCatalogResult other =
        (com.google.cloud.datacatalog.v1beta1.SearchCatalogResult) obj;

    if (searchResultType_ != other.searchResultType_) return false;
    if (!getSearchResultSubtype().equals(other.getSearchResultSubtype())) return false;
    if (!getRelativeResourceName().equals(other.getRelativeResourceName())) return false;
    if (!getLinkedResource().equals(other.getLinkedResource())) return false;
    if (hasModifyTime() != other.hasModifyTime()) return false;
    if (hasModifyTime()) {
      if (!getModifyTime().equals(other.getModifyTime())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SEARCH_RESULT_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + searchResultType_;
    hash = (37 * hash) + SEARCH_RESULT_SUBTYPE_FIELD_NUMBER;
    hash = (53 * hash) + getSearchResultSubtype().hashCode();
    hash = (37 * hash) + RELATIVE_RESOURCE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getRelativeResourceName().hashCode();
    hash = (37 * hash) + LINKED_RESOURCE_FIELD_NUMBER;
    hash = (53 * hash) + getLinkedResource().hashCode();
    if (hasModifyTime()) {
      hash = (37 * hash) + MODIFY_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getModifyTime().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datacatalog.v1beta1.SearchCatalogResult parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1beta1.SearchCatalogResult parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1beta1.SearchCatalogResult parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1beta1.SearchCatalogResult parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1beta1.SearchCatalogResult parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1beta1.SearchCatalogResult parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1beta1.SearchCatalogResult parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1beta1.SearchCatalogResult parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1beta1.SearchCatalogResult parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1beta1.SearchCatalogResult parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1beta1.SearchCatalogResult parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1beta1.SearchCatalogResult parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.datacatalog.v1beta1.SearchCatalogResult prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A result that appears in the response of a search request. Each result
   * captures details of one entry that matches the search.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datacatalog.v1beta1.SearchCatalogResult}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datacatalog.v1beta1.SearchCatalogResult)
      com.google.cloud.datacatalog.v1beta1.SearchCatalogResultOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datacatalog.v1beta1.Search
          .internal_static_google_cloud_datacatalog_v1beta1_SearchCatalogResult_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datacatalog.v1beta1.Search
          .internal_static_google_cloud_datacatalog_v1beta1_SearchCatalogResult_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datacatalog.v1beta1.SearchCatalogResult.class,
              com.google.cloud.datacatalog.v1beta1.SearchCatalogResult.Builder.class);
    }

    // Construct using com.google.cloud.datacatalog.v1beta1.SearchCatalogResult.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getModifyTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      searchResultType_ = 0;
      searchResultSubtype_ = "";
      relativeResourceName_ = "";
      linkedResource_ = "";
      modifyTime_ = null;
      if (modifyTimeBuilder_ != null) {
        modifyTimeBuilder_.dispose();
        modifyTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datacatalog.v1beta1.Search
          .internal_static_google_cloud_datacatalog_v1beta1_SearchCatalogResult_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1beta1.SearchCatalogResult getDefaultInstanceForType() {
      return com.google.cloud.datacatalog.v1beta1.SearchCatalogResult.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1beta1.SearchCatalogResult build() {
      com.google.cloud.datacatalog.v1beta1.SearchCatalogResult result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1beta1.SearchCatalogResult buildPartial() {
      com.google.cloud.datacatalog.v1beta1.SearchCatalogResult result =
          new com.google.cloud.datacatalog.v1beta1.SearchCatalogResult(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.datacatalog.v1beta1.SearchCatalogResult result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.searchResultType_ = searchResultType_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.searchResultSubtype_ = searchResultSubtype_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.relativeResourceName_ = relativeResourceName_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.linkedResource_ = linkedResource_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.modifyTime_ = modifyTimeBuilder_ == null ? modifyTime_ : modifyTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datacatalog.v1beta1.SearchCatalogResult) {
        return mergeFrom((com.google.cloud.datacatalog.v1beta1.SearchCatalogResult) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datacatalog.v1beta1.SearchCatalogResult other) {
      if (other == com.google.cloud.datacatalog.v1beta1.SearchCatalogResult.getDefaultInstance())
        return this;
      if (other.searchResultType_ != 0) {
        setSearchResultTypeValue(other.getSearchResultTypeValue());
      }
      if (!other.getSearchResultSubtype().isEmpty()) {
        searchResultSubtype_ = other.searchResultSubtype_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getRelativeResourceName().isEmpty()) {
        relativeResourceName_ = other.relativeResourceName_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getLinkedResource().isEmpty()) {
        linkedResource_ = other.linkedResource_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasModifyTime()) {
        mergeModifyTime(other.getModifyTime());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                searchResultType_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                searchResultSubtype_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                relativeResourceName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                linkedResource_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 58:
              {
                input.readMessage(getModifyTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int searchResultType_ = 0;
    /**
     *
     *
     * <pre>
     * Type of the search result. This field can be used to determine which Get
     * method to call to fetch the full resource.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.SearchResultType search_result_type = 1;</code>
     *
     * @return The enum numeric value on the wire for searchResultType.
     */
    @java.lang.Override
    public int getSearchResultTypeValue() {
      return searchResultType_;
    }
    /**
     *
     *
     * <pre>
     * Type of the search result. This field can be used to determine which Get
     * method to call to fetch the full resource.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.SearchResultType search_result_type = 1;</code>
     *
     * @param value The enum numeric value on the wire for searchResultType to set.
     * @return This builder for chaining.
     */
    public Builder setSearchResultTypeValue(int value) {
      searchResultType_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of the search result. This field can be used to determine which Get
     * method to call to fetch the full resource.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.SearchResultType search_result_type = 1;</code>
     *
     * @return The searchResultType.
     */
    @java.lang.Override
    public com.google.cloud.datacatalog.v1beta1.SearchResultType getSearchResultType() {
      com.google.cloud.datacatalog.v1beta1.SearchResultType result =
          com.google.cloud.datacatalog.v1beta1.SearchResultType.forNumber(searchResultType_);
      return result == null
          ? com.google.cloud.datacatalog.v1beta1.SearchResultType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Type of the search result. This field can be used to determine which Get
     * method to call to fetch the full resource.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.SearchResultType search_result_type = 1;</code>
     *
     * @param value The searchResultType to set.
     * @return This builder for chaining.
     */
    public Builder setSearchResultType(
        com.google.cloud.datacatalog.v1beta1.SearchResultType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      searchResultType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Type of the search result. This field can be used to determine which Get
     * method to call to fetch the full resource.
     * </pre>
     *
     * <code>.google.cloud.datacatalog.v1beta1.SearchResultType search_result_type = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSearchResultType() {
      bitField0_ = (bitField0_ & ~0x00000001);
      searchResultType_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object searchResultSubtype_ = "";
    /**
     *
     *
     * <pre>
     * Sub-type of the search result. This is a dot-delimited description of the
     * resource's full type, and is the same as the value callers would provide in
     * the "type" search facet.  Examples: `entry.table`, `entry.dataStream`,
     * `tagTemplate`.
     * </pre>
     *
     * <code>string search_result_subtype = 2;</code>
     *
     * @return The searchResultSubtype.
     */
    public java.lang.String getSearchResultSubtype() {
      java.lang.Object ref = searchResultSubtype_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        searchResultSubtype_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Sub-type of the search result. This is a dot-delimited description of the
     * resource's full type, and is the same as the value callers would provide in
     * the "type" search facet.  Examples: `entry.table`, `entry.dataStream`,
     * `tagTemplate`.
     * </pre>
     *
     * <code>string search_result_subtype = 2;</code>
     *
     * @return The bytes for searchResultSubtype.
     */
    public com.google.protobuf.ByteString getSearchResultSubtypeBytes() {
      java.lang.Object ref = searchResultSubtype_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        searchResultSubtype_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Sub-type of the search result. This is a dot-delimited description of the
     * resource's full type, and is the same as the value callers would provide in
     * the "type" search facet.  Examples: `entry.table`, `entry.dataStream`,
     * `tagTemplate`.
     * </pre>
     *
     * <code>string search_result_subtype = 2;</code>
     *
     * @param value The searchResultSubtype to set.
     * @return This builder for chaining.
     */
    public Builder setSearchResultSubtype(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      searchResultSubtype_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sub-type of the search result. This is a dot-delimited description of the
     * resource's full type, and is the same as the value callers would provide in
     * the "type" search facet.  Examples: `entry.table`, `entry.dataStream`,
     * `tagTemplate`.
     * </pre>
     *
     * <code>string search_result_subtype = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSearchResultSubtype() {
      searchResultSubtype_ = getDefaultInstance().getSearchResultSubtype();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Sub-type of the search result. This is a dot-delimited description of the
     * resource's full type, and is the same as the value callers would provide in
     * the "type" search facet.  Examples: `entry.table`, `entry.dataStream`,
     * `tagTemplate`.
     * </pre>
     *
     * <code>string search_result_subtype = 2;</code>
     *
     * @param value The bytes for searchResultSubtype to set.
     * @return This builder for chaining.
     */
    public Builder setSearchResultSubtypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      searchResultSubtype_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object relativeResourceName_ = "";
    /**
     *
     *
     * <pre>
     * The relative resource name of the resource in URL format.
     * Examples:
     *
     *  * `projects/{project_id}/locations/{location_id}/entryGroups/{entry_group_id}/entries/{entry_id}`
     *  * `projects/{project_id}/tagTemplates/{tag_template_id}`
     * </pre>
     *
     * <code>string relative_resource_name = 3;</code>
     *
     * @return The relativeResourceName.
     */
    public java.lang.String getRelativeResourceName() {
      java.lang.Object ref = relativeResourceName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        relativeResourceName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The relative resource name of the resource in URL format.
     * Examples:
     *
     *  * `projects/{project_id}/locations/{location_id}/entryGroups/{entry_group_id}/entries/{entry_id}`
     *  * `projects/{project_id}/tagTemplates/{tag_template_id}`
     * </pre>
     *
     * <code>string relative_resource_name = 3;</code>
     *
     * @return The bytes for relativeResourceName.
     */
    public com.google.protobuf.ByteString getRelativeResourceNameBytes() {
      java.lang.Object ref = relativeResourceName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        relativeResourceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The relative resource name of the resource in URL format.
     * Examples:
     *
     *  * `projects/{project_id}/locations/{location_id}/entryGroups/{entry_group_id}/entries/{entry_id}`
     *  * `projects/{project_id}/tagTemplates/{tag_template_id}`
     * </pre>
     *
     * <code>string relative_resource_name = 3;</code>
     *
     * @param value The relativeResourceName to set.
     * @return This builder for chaining.
     */
    public Builder setRelativeResourceName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      relativeResourceName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The relative resource name of the resource in URL format.
     * Examples:
     *
     *  * `projects/{project_id}/locations/{location_id}/entryGroups/{entry_group_id}/entries/{entry_id}`
     *  * `projects/{project_id}/tagTemplates/{tag_template_id}`
     * </pre>
     *
     * <code>string relative_resource_name = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRelativeResourceName() {
      relativeResourceName_ = getDefaultInstance().getRelativeResourceName();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The relative resource name of the resource in URL format.
     * Examples:
     *
     *  * `projects/{project_id}/locations/{location_id}/entryGroups/{entry_group_id}/entries/{entry_id}`
     *  * `projects/{project_id}/tagTemplates/{tag_template_id}`
     * </pre>
     *
     * <code>string relative_resource_name = 3;</code>
     *
     * @param value The bytes for relativeResourceName to set.
     * @return This builder for chaining.
     */
    public Builder setRelativeResourceNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      relativeResourceName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object linkedResource_ = "";
    /**
     *
     *
     * <pre>
     * The full name of the cloud resource the entry belongs to. See:
     * https://cloud.google.com/apis/design/resource_names#full_resource_name.
     * Example:
     *
     *  * `//bigquery.googleapis.com/projects/projectId/datasets/datasetId/tables/tableId`
     * </pre>
     *
     * <code>string linked_resource = 4;</code>
     *
     * @return The linkedResource.
     */
    public java.lang.String getLinkedResource() {
      java.lang.Object ref = linkedResource_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        linkedResource_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The full name of the cloud resource the entry belongs to. See:
     * https://cloud.google.com/apis/design/resource_names#full_resource_name.
     * Example:
     *
     *  * `//bigquery.googleapis.com/projects/projectId/datasets/datasetId/tables/tableId`
     * </pre>
     *
     * <code>string linked_resource = 4;</code>
     *
     * @return The bytes for linkedResource.
     */
    public com.google.protobuf.ByteString getLinkedResourceBytes() {
      java.lang.Object ref = linkedResource_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        linkedResource_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The full name of the cloud resource the entry belongs to. See:
     * https://cloud.google.com/apis/design/resource_names#full_resource_name.
     * Example:
     *
     *  * `//bigquery.googleapis.com/projects/projectId/datasets/datasetId/tables/tableId`
     * </pre>
     *
     * <code>string linked_resource = 4;</code>
     *
     * @param value The linkedResource to set.
     * @return This builder for chaining.
     */
    public Builder setLinkedResource(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      linkedResource_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The full name of the cloud resource the entry belongs to. See:
     * https://cloud.google.com/apis/design/resource_names#full_resource_name.
     * Example:
     *
     *  * `//bigquery.googleapis.com/projects/projectId/datasets/datasetId/tables/tableId`
     * </pre>
     *
     * <code>string linked_resource = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLinkedResource() {
      linkedResource_ = getDefaultInstance().getLinkedResource();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The full name of the cloud resource the entry belongs to. See:
     * https://cloud.google.com/apis/design/resource_names#full_resource_name.
     * Example:
     *
     *  * `//bigquery.googleapis.com/projects/projectId/datasets/datasetId/tables/tableId`
     * </pre>
     *
     * <code>string linked_resource = 4;</code>
     *
     * @param value The bytes for linkedResource to set.
     * @return This builder for chaining.
     */
    public Builder setLinkedResourceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      linkedResource_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp modifyTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        modifyTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Last-modified timestamp of the entry from the managing system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp modify_time = 7;</code>
     *
     * @return Whether the modifyTime field is set.
     */
    public boolean hasModifyTime() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Last-modified timestamp of the entry from the managing system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp modify_time = 7;</code>
     *
     * @return The modifyTime.
     */
    public com.google.protobuf.Timestamp getModifyTime() {
      if (modifyTimeBuilder_ == null) {
        return modifyTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : modifyTime_;
      } else {
        return modifyTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Last-modified timestamp of the entry from the managing system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp modify_time = 7;</code>
     */
    public Builder setModifyTime(com.google.protobuf.Timestamp value) {
      if (modifyTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        modifyTime_ = value;
      } else {
        modifyTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Last-modified timestamp of the entry from the managing system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp modify_time = 7;</code>
     */
    public Builder setModifyTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (modifyTimeBuilder_ == null) {
        modifyTime_ = builderForValue.build();
      } else {
        modifyTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Last-modified timestamp of the entry from the managing system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp modify_time = 7;</code>
     */
    public Builder mergeModifyTime(com.google.protobuf.Timestamp value) {
      if (modifyTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && modifyTime_ != null
            && modifyTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getModifyTimeBuilder().mergeFrom(value);
        } else {
          modifyTime_ = value;
        }
      } else {
        modifyTimeBuilder_.mergeFrom(value);
      }
      if (modifyTime_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Last-modified timestamp of the entry from the managing system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp modify_time = 7;</code>
     */
    public Builder clearModifyTime() {
      bitField0_ = (bitField0_ & ~0x00000010);
      modifyTime_ = null;
      if (modifyTimeBuilder_ != null) {
        modifyTimeBuilder_.dispose();
        modifyTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Last-modified timestamp of the entry from the managing system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp modify_time = 7;</code>
     */
    public com.google.protobuf.Timestamp.Builder getModifyTimeBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getModifyTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Last-modified timestamp of the entry from the managing system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp modify_time = 7;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getModifyTimeOrBuilder() {
      if (modifyTimeBuilder_ != null) {
        return modifyTimeBuilder_.getMessageOrBuilder();
      } else {
        return modifyTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : modifyTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Last-modified timestamp of the entry from the managing system.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp modify_time = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getModifyTimeFieldBuilder() {
      if (modifyTimeBuilder_ == null) {
        modifyTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getModifyTime(), getParentForChildren(), isClean());
        modifyTime_ = null;
      }
      return modifyTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datacatalog.v1beta1.SearchCatalogResult)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datacatalog.v1beta1.SearchCatalogResult)
  private static final com.google.cloud.datacatalog.v1beta1.SearchCatalogResult DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datacatalog.v1beta1.SearchCatalogResult();
  }

  public static com.google.cloud.datacatalog.v1beta1.SearchCatalogResult getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SearchCatalogResult> PARSER =
      new com.google.protobuf.AbstractParser<SearchCatalogResult>() {
        @java.lang.Override
        public SearchCatalogResult parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SearchCatalogResult> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SearchCatalogResult> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datacatalog.v1beta1.SearchCatalogResult getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
