/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datacatalog/v1beta1/policytagmanagerserialization.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.datacatalog.v1beta1;

/**
 *
 *
 * <pre>
 * Message representing one policy tag when exported as a nested proto.
 * </pre>
 *
 * Protobuf type {@code google.cloud.datacatalog.v1beta1.SerializedPolicyTag}
 */
public final class SerializedPolicyTag extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datacatalog.v1beta1.SerializedPolicyTag)
    SerializedPolicyTagOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SerializedPolicyTag.newBuilder() to construct.
  private SerializedPolicyTag(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SerializedPolicyTag() {
    policyTag_ = "";
    displayName_ = "";
    description_ = "";
    childPolicyTags_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SerializedPolicyTag();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datacatalog.v1beta1.PolicyTagManagerSerializationProto
        .internal_static_google_cloud_datacatalog_v1beta1_SerializedPolicyTag_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datacatalog.v1beta1.PolicyTagManagerSerializationProto
        .internal_static_google_cloud_datacatalog_v1beta1_SerializedPolicyTag_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag.class,
            com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag.Builder.class);
  }

  public static final int POLICY_TAG_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object policyTag_ = "";
  /**
   *
   *
   * <pre>
   * Resource name of the policy tag.
   *
   * This field will be ignored when calling ImportTaxonomies.
   * </pre>
   *
   * <code>string policy_tag = 1;</code>
   *
   * @return The policyTag.
   */
  @java.lang.Override
  public java.lang.String getPolicyTag() {
    java.lang.Object ref = policyTag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      policyTag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Resource name of the policy tag.
   *
   * This field will be ignored when calling ImportTaxonomies.
   * </pre>
   *
   * <code>string policy_tag = 1;</code>
   *
   * @return The bytes for policyTag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPolicyTagBytes() {
    java.lang.Object ref = policyTag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      policyTag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Required. Display name of the policy tag. Max 200 bytes when encoded in
   * UTF-8.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Display name of the policy tag. Max 200 bytes when encoded in
   * UTF-8.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Description of the serialized policy tag. The length of the
   * description is limited to 2000 bytes when encoded in UTF-8. If not set,
   * defaults to an empty description.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Description of the serialized policy tag. The length of the
   * description is limited to 2000 bytes when encoded in UTF-8. If not set,
   * defaults to an empty description.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CHILD_POLICY_TAGS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag> childPolicyTags_;
  /**
   *
   *
   * <pre>
   * Children of the policy tag if any.
   * </pre>
   *
   * <code>repeated .google.cloud.datacatalog.v1beta1.SerializedPolicyTag child_policy_tags = 4;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag>
      getChildPolicyTagsList() {
    return childPolicyTags_;
  }
  /**
   *
   *
   * <pre>
   * Children of the policy tag if any.
   * </pre>
   *
   * <code>repeated .google.cloud.datacatalog.v1beta1.SerializedPolicyTag child_policy_tags = 4;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.datacatalog.v1beta1.SerializedPolicyTagOrBuilder>
      getChildPolicyTagsOrBuilderList() {
    return childPolicyTags_;
  }
  /**
   *
   *
   * <pre>
   * Children of the policy tag if any.
   * </pre>
   *
   * <code>repeated .google.cloud.datacatalog.v1beta1.SerializedPolicyTag child_policy_tags = 4;
   * </code>
   */
  @java.lang.Override
  public int getChildPolicyTagsCount() {
    return childPolicyTags_.size();
  }
  /**
   *
   *
   * <pre>
   * Children of the policy tag if any.
   * </pre>
   *
   * <code>repeated .google.cloud.datacatalog.v1beta1.SerializedPolicyTag child_policy_tags = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag getChildPolicyTags(int index) {
    return childPolicyTags_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Children of the policy tag if any.
   * </pre>
   *
   * <code>repeated .google.cloud.datacatalog.v1beta1.SerializedPolicyTag child_policy_tags = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datacatalog.v1beta1.SerializedPolicyTagOrBuilder
      getChildPolicyTagsOrBuilder(int index) {
    return childPolicyTags_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(policyTag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, policyTag_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, description_);
    }
    for (int i = 0; i < childPolicyTags_.size(); i++) {
      output.writeMessage(4, childPolicyTags_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(policyTag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, policyTag_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, description_);
    }
    for (int i = 0; i < childPolicyTags_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, childPolicyTags_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag)) {
      return super.equals(obj);
    }
    com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag other =
        (com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag) obj;

    if (!getPolicyTag().equals(other.getPolicyTag())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getChildPolicyTagsList().equals(other.getChildPolicyTagsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + POLICY_TAG_FIELD_NUMBER;
    hash = (53 * hash) + getPolicyTag().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (getChildPolicyTagsCount() > 0) {
      hash = (37 * hash) + CHILD_POLICY_TAGS_FIELD_NUMBER;
      hash = (53 * hash) + getChildPolicyTagsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Message representing one policy tag when exported as a nested proto.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datacatalog.v1beta1.SerializedPolicyTag}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datacatalog.v1beta1.SerializedPolicyTag)
      com.google.cloud.datacatalog.v1beta1.SerializedPolicyTagOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datacatalog.v1beta1.PolicyTagManagerSerializationProto
          .internal_static_google_cloud_datacatalog_v1beta1_SerializedPolicyTag_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datacatalog.v1beta1.PolicyTagManagerSerializationProto
          .internal_static_google_cloud_datacatalog_v1beta1_SerializedPolicyTag_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag.class,
              com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag.Builder.class);
    }

    // Construct using com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      policyTag_ = "";
      displayName_ = "";
      description_ = "";
      if (childPolicyTagsBuilder_ == null) {
        childPolicyTags_ = java.util.Collections.emptyList();
      } else {
        childPolicyTags_ = null;
        childPolicyTagsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datacatalog.v1beta1.PolicyTagManagerSerializationProto
          .internal_static_google_cloud_datacatalog_v1beta1_SerializedPolicyTag_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag getDefaultInstanceForType() {
      return com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag build() {
      com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag buildPartial() {
      com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag result =
          new com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag result) {
      if (childPolicyTagsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          childPolicyTags_ = java.util.Collections.unmodifiableList(childPolicyTags_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.childPolicyTags_ = childPolicyTags_;
      } else {
        result.childPolicyTags_ = childPolicyTagsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.policyTag_ = policyTag_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.description_ = description_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag) {
        return mergeFrom((com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag other) {
      if (other == com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag.getDefaultInstance())
        return this;
      if (!other.getPolicyTag().isEmpty()) {
        policyTag_ = other.policyTag_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (childPolicyTagsBuilder_ == null) {
        if (!other.childPolicyTags_.isEmpty()) {
          if (childPolicyTags_.isEmpty()) {
            childPolicyTags_ = other.childPolicyTags_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureChildPolicyTagsIsMutable();
            childPolicyTags_.addAll(other.childPolicyTags_);
          }
          onChanged();
        }
      } else {
        if (!other.childPolicyTags_.isEmpty()) {
          if (childPolicyTagsBuilder_.isEmpty()) {
            childPolicyTagsBuilder_.dispose();
            childPolicyTagsBuilder_ = null;
            childPolicyTags_ = other.childPolicyTags_;
            bitField0_ = (bitField0_ & ~0x00000008);
            childPolicyTagsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getChildPolicyTagsFieldBuilder()
                    : null;
          } else {
            childPolicyTagsBuilder_.addAllMessages(other.childPolicyTags_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                policyTag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag m =
                    input.readMessage(
                        com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag.parser(),
                        extensionRegistry);
                if (childPolicyTagsBuilder_ == null) {
                  ensureChildPolicyTagsIsMutable();
                  childPolicyTags_.add(m);
                } else {
                  childPolicyTagsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object policyTag_ = "";
    /**
     *
     *
     * <pre>
     * Resource name of the policy tag.
     *
     * This field will be ignored when calling ImportTaxonomies.
     * </pre>
     *
     * <code>string policy_tag = 1;</code>
     *
     * @return The policyTag.
     */
    public java.lang.String getPolicyTag() {
      java.lang.Object ref = policyTag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        policyTag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Resource name of the policy tag.
     *
     * This field will be ignored when calling ImportTaxonomies.
     * </pre>
     *
     * <code>string policy_tag = 1;</code>
     *
     * @return The bytes for policyTag.
     */
    public com.google.protobuf.ByteString getPolicyTagBytes() {
      java.lang.Object ref = policyTag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        policyTag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Resource name of the policy tag.
     *
     * This field will be ignored when calling ImportTaxonomies.
     * </pre>
     *
     * <code>string policy_tag = 1;</code>
     *
     * @param value The policyTag to set.
     * @return This builder for chaining.
     */
    public Builder setPolicyTag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      policyTag_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource name of the policy tag.
     *
     * This field will be ignored when calling ImportTaxonomies.
     * </pre>
     *
     * <code>string policy_tag = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPolicyTag() {
      policyTag_ = getDefaultInstance().getPolicyTag();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Resource name of the policy tag.
     *
     * This field will be ignored when calling ImportTaxonomies.
     * </pre>
     *
     * <code>string policy_tag = 1;</code>
     *
     * @param value The bytes for policyTag to set.
     * @return This builder for chaining.
     */
    public Builder setPolicyTagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      policyTag_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. Display name of the policy tag. Max 200 bytes when encoded in
     * UTF-8.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Display name of the policy tag. Max 200 bytes when encoded in
     * UTF-8.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Display name of the policy tag. Max 200 bytes when encoded in
     * UTF-8.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Display name of the policy tag. Max 200 bytes when encoded in
     * UTF-8.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Display name of the policy tag. Max 200 bytes when encoded in
     * UTF-8.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Description of the serialized policy tag. The length of the
     * description is limited to 2000 bytes when encoded in UTF-8. If not set,
     * defaults to an empty description.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Description of the serialized policy tag. The length of the
     * description is limited to 2000 bytes when encoded in UTF-8. If not set,
     * defaults to an empty description.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Description of the serialized policy tag. The length of the
     * description is limited to 2000 bytes when encoded in UTF-8. If not set,
     * defaults to an empty description.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Description of the serialized policy tag. The length of the
     * description is limited to 2000 bytes when encoded in UTF-8. If not set,
     * defaults to an empty description.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Description of the serialized policy tag. The length of the
     * description is limited to 2000 bytes when encoded in UTF-8. If not set,
     * defaults to an empty description.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag>
        childPolicyTags_ = java.util.Collections.emptyList();

    private void ensureChildPolicyTagsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        childPolicyTags_ =
            new java.util.ArrayList<com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag>(
                childPolicyTags_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag,
            com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag.Builder,
            com.google.cloud.datacatalog.v1beta1.SerializedPolicyTagOrBuilder>
        childPolicyTagsBuilder_;

    /**
     *
     *
     * <pre>
     * Children of the policy tag if any.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1beta1.SerializedPolicyTag child_policy_tags = 4;
     * </code>
     */
    public java.util.List<com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag>
        getChildPolicyTagsList() {
      if (childPolicyTagsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(childPolicyTags_);
      } else {
        return childPolicyTagsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Children of the policy tag if any.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1beta1.SerializedPolicyTag child_policy_tags = 4;
     * </code>
     */
    public int getChildPolicyTagsCount() {
      if (childPolicyTagsBuilder_ == null) {
        return childPolicyTags_.size();
      } else {
        return childPolicyTagsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Children of the policy tag if any.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1beta1.SerializedPolicyTag child_policy_tags = 4;
     * </code>
     */
    public com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag getChildPolicyTags(int index) {
      if (childPolicyTagsBuilder_ == null) {
        return childPolicyTags_.get(index);
      } else {
        return childPolicyTagsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Children of the policy tag if any.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1beta1.SerializedPolicyTag child_policy_tags = 4;
     * </code>
     */
    public Builder setChildPolicyTags(
        int index, com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag value) {
      if (childPolicyTagsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureChildPolicyTagsIsMutable();
        childPolicyTags_.set(index, value);
        onChanged();
      } else {
        childPolicyTagsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Children of the policy tag if any.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1beta1.SerializedPolicyTag child_policy_tags = 4;
     * </code>
     */
    public Builder setChildPolicyTags(
        int index,
        com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag.Builder builderForValue) {
      if (childPolicyTagsBuilder_ == null) {
        ensureChildPolicyTagsIsMutable();
        childPolicyTags_.set(index, builderForValue.build());
        onChanged();
      } else {
        childPolicyTagsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Children of the policy tag if any.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1beta1.SerializedPolicyTag child_policy_tags = 4;
     * </code>
     */
    public Builder addChildPolicyTags(
        com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag value) {
      if (childPolicyTagsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureChildPolicyTagsIsMutable();
        childPolicyTags_.add(value);
        onChanged();
      } else {
        childPolicyTagsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Children of the policy tag if any.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1beta1.SerializedPolicyTag child_policy_tags = 4;
     * </code>
     */
    public Builder addChildPolicyTags(
        int index, com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag value) {
      if (childPolicyTagsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureChildPolicyTagsIsMutable();
        childPolicyTags_.add(index, value);
        onChanged();
      } else {
        childPolicyTagsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Children of the policy tag if any.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1beta1.SerializedPolicyTag child_policy_tags = 4;
     * </code>
     */
    public Builder addChildPolicyTags(
        com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag.Builder builderForValue) {
      if (childPolicyTagsBuilder_ == null) {
        ensureChildPolicyTagsIsMutable();
        childPolicyTags_.add(builderForValue.build());
        onChanged();
      } else {
        childPolicyTagsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Children of the policy tag if any.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1beta1.SerializedPolicyTag child_policy_tags = 4;
     * </code>
     */
    public Builder addChildPolicyTags(
        int index,
        com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag.Builder builderForValue) {
      if (childPolicyTagsBuilder_ == null) {
        ensureChildPolicyTagsIsMutable();
        childPolicyTags_.add(index, builderForValue.build());
        onChanged();
      } else {
        childPolicyTagsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Children of the policy tag if any.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1beta1.SerializedPolicyTag child_policy_tags = 4;
     * </code>
     */
    public Builder addAllChildPolicyTags(
        java.lang.Iterable<? extends com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag>
            values) {
      if (childPolicyTagsBuilder_ == null) {
        ensureChildPolicyTagsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, childPolicyTags_);
        onChanged();
      } else {
        childPolicyTagsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Children of the policy tag if any.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1beta1.SerializedPolicyTag child_policy_tags = 4;
     * </code>
     */
    public Builder clearChildPolicyTags() {
      if (childPolicyTagsBuilder_ == null) {
        childPolicyTags_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        childPolicyTagsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Children of the policy tag if any.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1beta1.SerializedPolicyTag child_policy_tags = 4;
     * </code>
     */
    public Builder removeChildPolicyTags(int index) {
      if (childPolicyTagsBuilder_ == null) {
        ensureChildPolicyTagsIsMutable();
        childPolicyTags_.remove(index);
        onChanged();
      } else {
        childPolicyTagsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Children of the policy tag if any.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1beta1.SerializedPolicyTag child_policy_tags = 4;
     * </code>
     */
    public com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag.Builder
        getChildPolicyTagsBuilder(int index) {
      return getChildPolicyTagsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Children of the policy tag if any.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1beta1.SerializedPolicyTag child_policy_tags = 4;
     * </code>
     */
    public com.google.cloud.datacatalog.v1beta1.SerializedPolicyTagOrBuilder
        getChildPolicyTagsOrBuilder(int index) {
      if (childPolicyTagsBuilder_ == null) {
        return childPolicyTags_.get(index);
      } else {
        return childPolicyTagsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Children of the policy tag if any.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1beta1.SerializedPolicyTag child_policy_tags = 4;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.datacatalog.v1beta1.SerializedPolicyTagOrBuilder>
        getChildPolicyTagsOrBuilderList() {
      if (childPolicyTagsBuilder_ != null) {
        return childPolicyTagsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(childPolicyTags_);
      }
    }
    /**
     *
     *
     * <pre>
     * Children of the policy tag if any.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1beta1.SerializedPolicyTag child_policy_tags = 4;
     * </code>
     */
    public com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag.Builder
        addChildPolicyTagsBuilder() {
      return getChildPolicyTagsFieldBuilder()
          .addBuilder(
              com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Children of the policy tag if any.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1beta1.SerializedPolicyTag child_policy_tags = 4;
     * </code>
     */
    public com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag.Builder
        addChildPolicyTagsBuilder(int index) {
      return getChildPolicyTagsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Children of the policy tag if any.
     * </pre>
     *
     * <code>repeated .google.cloud.datacatalog.v1beta1.SerializedPolicyTag child_policy_tags = 4;
     * </code>
     */
    public java.util.List<com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag.Builder>
        getChildPolicyTagsBuilderList() {
      return getChildPolicyTagsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag,
            com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag.Builder,
            com.google.cloud.datacatalog.v1beta1.SerializedPolicyTagOrBuilder>
        getChildPolicyTagsFieldBuilder() {
      if (childPolicyTagsBuilder_ == null) {
        childPolicyTagsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag,
                com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag.Builder,
                com.google.cloud.datacatalog.v1beta1.SerializedPolicyTagOrBuilder>(
                childPolicyTags_,
                ((bitField0_ & 0x00000008) != 0),
                getParentForChildren(),
                isClean());
        childPolicyTags_ = null;
      }
      return childPolicyTagsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datacatalog.v1beta1.SerializedPolicyTag)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datacatalog.v1beta1.SerializedPolicyTag)
  private static final com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag();
  }

  public static com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SerializedPolicyTag> PARSER =
      new com.google.protobuf.AbstractParser<SerializedPolicyTag>() {
        @java.lang.Override
        public SerializedPolicyTag parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SerializedPolicyTag> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SerializedPolicyTag> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datacatalog.v1beta1.SerializedPolicyTag getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
