/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datalabeling/v1beta1/annotation.proto

package com.google.cloud.datalabeling.v1beta1;

/**
 *
 *
 * <pre>
 * Annotation value for an example.
 * </pre>
 *
 * Protobuf type {@code google.cloud.datalabeling.v1beta1.AnnotationValue}
 */
public final class AnnotationValue extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datalabeling.v1beta1.AnnotationValue)
    AnnotationValueOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AnnotationValue.newBuilder() to construct.
  private AnnotationValue(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AnnotationValue() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AnnotationValue();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datalabeling.v1beta1.AnnotationOuterClass
        .internal_static_google_cloud_datalabeling_v1beta1_AnnotationValue_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datalabeling.v1beta1.AnnotationOuterClass
        .internal_static_google_cloud_datalabeling_v1beta1_AnnotationValue_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datalabeling.v1beta1.AnnotationValue.class,
            com.google.cloud.datalabeling.v1beta1.AnnotationValue.Builder.class);
  }

  private int valueTypeCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object valueType_;

  public enum ValueTypeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    IMAGE_CLASSIFICATION_ANNOTATION(1),
    IMAGE_BOUNDING_POLY_ANNOTATION(2),
    IMAGE_POLYLINE_ANNOTATION(8),
    IMAGE_SEGMENTATION_ANNOTATION(9),
    TEXT_CLASSIFICATION_ANNOTATION(3),
    TEXT_ENTITY_EXTRACTION_ANNOTATION(10),
    VIDEO_CLASSIFICATION_ANNOTATION(4),
    VIDEO_OBJECT_TRACKING_ANNOTATION(5),
    VIDEO_EVENT_ANNOTATION(6),
    VALUETYPE_NOT_SET(0);
    private final int value;

    private ValueTypeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ValueTypeCase valueOf(int value) {
      return forNumber(value);
    }

    public static ValueTypeCase forNumber(int value) {
      switch (value) {
        case 1:
          return IMAGE_CLASSIFICATION_ANNOTATION;
        case 2:
          return IMAGE_BOUNDING_POLY_ANNOTATION;
        case 8:
          return IMAGE_POLYLINE_ANNOTATION;
        case 9:
          return IMAGE_SEGMENTATION_ANNOTATION;
        case 3:
          return TEXT_CLASSIFICATION_ANNOTATION;
        case 10:
          return TEXT_ENTITY_EXTRACTION_ANNOTATION;
        case 4:
          return VIDEO_CLASSIFICATION_ANNOTATION;
        case 5:
          return VIDEO_OBJECT_TRACKING_ANNOTATION;
        case 6:
          return VIDEO_EVENT_ANNOTATION;
        case 0:
          return VALUETYPE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ValueTypeCase getValueTypeCase() {
    return ValueTypeCase.forNumber(valueTypeCase_);
  }

  public static final int IMAGE_CLASSIFICATION_ANNOTATION_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Annotation value for image classification case.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.ImageClassificationAnnotation image_classification_annotation = 1;
   * </code>
   *
   * @return Whether the imageClassificationAnnotation field is set.
   */
  @java.lang.Override
  public boolean hasImageClassificationAnnotation() {
    return valueTypeCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Annotation value for image classification case.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.ImageClassificationAnnotation image_classification_annotation = 1;
   * </code>
   *
   * @return The imageClassificationAnnotation.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.ImageClassificationAnnotation
      getImageClassificationAnnotation() {
    if (valueTypeCase_ == 1) {
      return (com.google.cloud.datalabeling.v1beta1.ImageClassificationAnnotation) valueType_;
    }
    return com.google.cloud.datalabeling.v1beta1.ImageClassificationAnnotation.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Annotation value for image classification case.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.ImageClassificationAnnotation image_classification_annotation = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.ImageClassificationAnnotationOrBuilder
      getImageClassificationAnnotationOrBuilder() {
    if (valueTypeCase_ == 1) {
      return (com.google.cloud.datalabeling.v1beta1.ImageClassificationAnnotation) valueType_;
    }
    return com.google.cloud.datalabeling.v1beta1.ImageClassificationAnnotation.getDefaultInstance();
  }

  public static final int IMAGE_BOUNDING_POLY_ANNOTATION_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Annotation value for image bounding box, oriented bounding box
   * and polygon cases.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation image_bounding_poly_annotation = 2;
   * </code>
   *
   * @return Whether the imageBoundingPolyAnnotation field is set.
   */
  @java.lang.Override
  public boolean hasImageBoundingPolyAnnotation() {
    return valueTypeCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Annotation value for image bounding box, oriented bounding box
   * and polygon cases.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation image_bounding_poly_annotation = 2;
   * </code>
   *
   * @return The imageBoundingPolyAnnotation.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation
      getImageBoundingPolyAnnotation() {
    if (valueTypeCase_ == 2) {
      return (com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation) valueType_;
    }
    return com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Annotation value for image bounding box, oriented bounding box
   * and polygon cases.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation image_bounding_poly_annotation = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotationOrBuilder
      getImageBoundingPolyAnnotationOrBuilder() {
    if (valueTypeCase_ == 2) {
      return (com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation) valueType_;
    }
    return com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation.getDefaultInstance();
  }

  public static final int IMAGE_POLYLINE_ANNOTATION_FIELD_NUMBER = 8;
  /**
   *
   *
   * <pre>
   * Annotation value for image polyline cases.
   * Polyline here is different from BoundingPoly. It is formed by
   * line segments connected to each other but not closed form(Bounding Poly).
   * The line segments can cross each other.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.ImagePolylineAnnotation image_polyline_annotation = 8;
   * </code>
   *
   * @return Whether the imagePolylineAnnotation field is set.
   */
  @java.lang.Override
  public boolean hasImagePolylineAnnotation() {
    return valueTypeCase_ == 8;
  }
  /**
   *
   *
   * <pre>
   * Annotation value for image polyline cases.
   * Polyline here is different from BoundingPoly. It is formed by
   * line segments connected to each other but not closed form(Bounding Poly).
   * The line segments can cross each other.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.ImagePolylineAnnotation image_polyline_annotation = 8;
   * </code>
   *
   * @return The imagePolylineAnnotation.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.ImagePolylineAnnotation
      getImagePolylineAnnotation() {
    if (valueTypeCase_ == 8) {
      return (com.google.cloud.datalabeling.v1beta1.ImagePolylineAnnotation) valueType_;
    }
    return com.google.cloud.datalabeling.v1beta1.ImagePolylineAnnotation.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Annotation value for image polyline cases.
   * Polyline here is different from BoundingPoly. It is formed by
   * line segments connected to each other but not closed form(Bounding Poly).
   * The line segments can cross each other.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.ImagePolylineAnnotation image_polyline_annotation = 8;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.ImagePolylineAnnotationOrBuilder
      getImagePolylineAnnotationOrBuilder() {
    if (valueTypeCase_ == 8) {
      return (com.google.cloud.datalabeling.v1beta1.ImagePolylineAnnotation) valueType_;
    }
    return com.google.cloud.datalabeling.v1beta1.ImagePolylineAnnotation.getDefaultInstance();
  }

  public static final int IMAGE_SEGMENTATION_ANNOTATION_FIELD_NUMBER = 9;
  /**
   *
   *
   * <pre>
   * Annotation value for image segmentation.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.ImageSegmentationAnnotation image_segmentation_annotation = 9;
   * </code>
   *
   * @return Whether the imageSegmentationAnnotation field is set.
   */
  @java.lang.Override
  public boolean hasImageSegmentationAnnotation() {
    return valueTypeCase_ == 9;
  }
  /**
   *
   *
   * <pre>
   * Annotation value for image segmentation.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.ImageSegmentationAnnotation image_segmentation_annotation = 9;
   * </code>
   *
   * @return The imageSegmentationAnnotation.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.ImageSegmentationAnnotation
      getImageSegmentationAnnotation() {
    if (valueTypeCase_ == 9) {
      return (com.google.cloud.datalabeling.v1beta1.ImageSegmentationAnnotation) valueType_;
    }
    return com.google.cloud.datalabeling.v1beta1.ImageSegmentationAnnotation.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Annotation value for image segmentation.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.ImageSegmentationAnnotation image_segmentation_annotation = 9;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.ImageSegmentationAnnotationOrBuilder
      getImageSegmentationAnnotationOrBuilder() {
    if (valueTypeCase_ == 9) {
      return (com.google.cloud.datalabeling.v1beta1.ImageSegmentationAnnotation) valueType_;
    }
    return com.google.cloud.datalabeling.v1beta1.ImageSegmentationAnnotation.getDefaultInstance();
  }

  public static final int TEXT_CLASSIFICATION_ANNOTATION_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Annotation value for text classification case.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.TextClassificationAnnotation text_classification_annotation = 3;
   * </code>
   *
   * @return Whether the textClassificationAnnotation field is set.
   */
  @java.lang.Override
  public boolean hasTextClassificationAnnotation() {
    return valueTypeCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Annotation value for text classification case.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.TextClassificationAnnotation text_classification_annotation = 3;
   * </code>
   *
   * @return The textClassificationAnnotation.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.TextClassificationAnnotation
      getTextClassificationAnnotation() {
    if (valueTypeCase_ == 3) {
      return (com.google.cloud.datalabeling.v1beta1.TextClassificationAnnotation) valueType_;
    }
    return com.google.cloud.datalabeling.v1beta1.TextClassificationAnnotation.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Annotation value for text classification case.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.TextClassificationAnnotation text_classification_annotation = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.TextClassificationAnnotationOrBuilder
      getTextClassificationAnnotationOrBuilder() {
    if (valueTypeCase_ == 3) {
      return (com.google.cloud.datalabeling.v1beta1.TextClassificationAnnotation) valueType_;
    }
    return com.google.cloud.datalabeling.v1beta1.TextClassificationAnnotation.getDefaultInstance();
  }

  public static final int TEXT_ENTITY_EXTRACTION_ANNOTATION_FIELD_NUMBER = 10;
  /**
   *
   *
   * <pre>
   * Annotation value for text entity extraction case.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.TextEntityExtractionAnnotation text_entity_extraction_annotation = 10;
   * </code>
   *
   * @return Whether the textEntityExtractionAnnotation field is set.
   */
  @java.lang.Override
  public boolean hasTextEntityExtractionAnnotation() {
    return valueTypeCase_ == 10;
  }
  /**
   *
   *
   * <pre>
   * Annotation value for text entity extraction case.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.TextEntityExtractionAnnotation text_entity_extraction_annotation = 10;
   * </code>
   *
   * @return The textEntityExtractionAnnotation.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.TextEntityExtractionAnnotation
      getTextEntityExtractionAnnotation() {
    if (valueTypeCase_ == 10) {
      return (com.google.cloud.datalabeling.v1beta1.TextEntityExtractionAnnotation) valueType_;
    }
    return com.google.cloud.datalabeling.v1beta1.TextEntityExtractionAnnotation
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Annotation value for text entity extraction case.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.TextEntityExtractionAnnotation text_entity_extraction_annotation = 10;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.TextEntityExtractionAnnotationOrBuilder
      getTextEntityExtractionAnnotationOrBuilder() {
    if (valueTypeCase_ == 10) {
      return (com.google.cloud.datalabeling.v1beta1.TextEntityExtractionAnnotation) valueType_;
    }
    return com.google.cloud.datalabeling.v1beta1.TextEntityExtractionAnnotation
        .getDefaultInstance();
  }

  public static final int VIDEO_CLASSIFICATION_ANNOTATION_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Annotation value for video classification case.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.VideoClassificationAnnotation video_classification_annotation = 4;
   * </code>
   *
   * @return Whether the videoClassificationAnnotation field is set.
   */
  @java.lang.Override
  public boolean hasVideoClassificationAnnotation() {
    return valueTypeCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Annotation value for video classification case.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.VideoClassificationAnnotation video_classification_annotation = 4;
   * </code>
   *
   * @return The videoClassificationAnnotation.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.VideoClassificationAnnotation
      getVideoClassificationAnnotation() {
    if (valueTypeCase_ == 4) {
      return (com.google.cloud.datalabeling.v1beta1.VideoClassificationAnnotation) valueType_;
    }
    return com.google.cloud.datalabeling.v1beta1.VideoClassificationAnnotation.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Annotation value for video classification case.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.VideoClassificationAnnotation video_classification_annotation = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.VideoClassificationAnnotationOrBuilder
      getVideoClassificationAnnotationOrBuilder() {
    if (valueTypeCase_ == 4) {
      return (com.google.cloud.datalabeling.v1beta1.VideoClassificationAnnotation) valueType_;
    }
    return com.google.cloud.datalabeling.v1beta1.VideoClassificationAnnotation.getDefaultInstance();
  }

  public static final int VIDEO_OBJECT_TRACKING_ANNOTATION_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Annotation value for video object detection and tracking case.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation video_object_tracking_annotation = 5;
   * </code>
   *
   * @return Whether the videoObjectTrackingAnnotation field is set.
   */
  @java.lang.Override
  public boolean hasVideoObjectTrackingAnnotation() {
    return valueTypeCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Annotation value for video object detection and tracking case.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation video_object_tracking_annotation = 5;
   * </code>
   *
   * @return The videoObjectTrackingAnnotation.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation
      getVideoObjectTrackingAnnotation() {
    if (valueTypeCase_ == 5) {
      return (com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation) valueType_;
    }
    return com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Annotation value for video object detection and tracking case.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation video_object_tracking_annotation = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotationOrBuilder
      getVideoObjectTrackingAnnotationOrBuilder() {
    if (valueTypeCase_ == 5) {
      return (com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation) valueType_;
    }
    return com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation.getDefaultInstance();
  }

  public static final int VIDEO_EVENT_ANNOTATION_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * Annotation value for video event case.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.VideoEventAnnotation video_event_annotation = 6;
   * </code>
   *
   * @return Whether the videoEventAnnotation field is set.
   */
  @java.lang.Override
  public boolean hasVideoEventAnnotation() {
    return valueTypeCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * Annotation value for video event case.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.VideoEventAnnotation video_event_annotation = 6;
   * </code>
   *
   * @return The videoEventAnnotation.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.VideoEventAnnotation getVideoEventAnnotation() {
    if (valueTypeCase_ == 6) {
      return (com.google.cloud.datalabeling.v1beta1.VideoEventAnnotation) valueType_;
    }
    return com.google.cloud.datalabeling.v1beta1.VideoEventAnnotation.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Annotation value for video event case.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.VideoEventAnnotation video_event_annotation = 6;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.VideoEventAnnotationOrBuilder
      getVideoEventAnnotationOrBuilder() {
    if (valueTypeCase_ == 6) {
      return (com.google.cloud.datalabeling.v1beta1.VideoEventAnnotation) valueType_;
    }
    return com.google.cloud.datalabeling.v1beta1.VideoEventAnnotation.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (valueTypeCase_ == 1) {
      output.writeMessage(
          1, (com.google.cloud.datalabeling.v1beta1.ImageClassificationAnnotation) valueType_);
    }
    if (valueTypeCase_ == 2) {
      output.writeMessage(
          2, (com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation) valueType_);
    }
    if (valueTypeCase_ == 3) {
      output.writeMessage(
          3, (com.google.cloud.datalabeling.v1beta1.TextClassificationAnnotation) valueType_);
    }
    if (valueTypeCase_ == 4) {
      output.writeMessage(
          4, (com.google.cloud.datalabeling.v1beta1.VideoClassificationAnnotation) valueType_);
    }
    if (valueTypeCase_ == 5) {
      output.writeMessage(
          5, (com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation) valueType_);
    }
    if (valueTypeCase_ == 6) {
      output.writeMessage(
          6, (com.google.cloud.datalabeling.v1beta1.VideoEventAnnotation) valueType_);
    }
    if (valueTypeCase_ == 8) {
      output.writeMessage(
          8, (com.google.cloud.datalabeling.v1beta1.ImagePolylineAnnotation) valueType_);
    }
    if (valueTypeCase_ == 9) {
      output.writeMessage(
          9, (com.google.cloud.datalabeling.v1beta1.ImageSegmentationAnnotation) valueType_);
    }
    if (valueTypeCase_ == 10) {
      output.writeMessage(
          10, (com.google.cloud.datalabeling.v1beta1.TextEntityExtractionAnnotation) valueType_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (valueTypeCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.cloud.datalabeling.v1beta1.ImageClassificationAnnotation) valueType_);
    }
    if (valueTypeCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation) valueType_);
    }
    if (valueTypeCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.datalabeling.v1beta1.TextClassificationAnnotation) valueType_);
    }
    if (valueTypeCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.datalabeling.v1beta1.VideoClassificationAnnotation) valueType_);
    }
    if (valueTypeCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation) valueType_);
    }
    if (valueTypeCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloud.datalabeling.v1beta1.VideoEventAnnotation) valueType_);
    }
    if (valueTypeCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, (com.google.cloud.datalabeling.v1beta1.ImagePolylineAnnotation) valueType_);
    }
    if (valueTypeCase_ == 9) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              9, (com.google.cloud.datalabeling.v1beta1.ImageSegmentationAnnotation) valueType_);
    }
    if (valueTypeCase_ == 10) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              10,
              (com.google.cloud.datalabeling.v1beta1.TextEntityExtractionAnnotation) valueType_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datalabeling.v1beta1.AnnotationValue)) {
      return super.equals(obj);
    }
    com.google.cloud.datalabeling.v1beta1.AnnotationValue other =
        (com.google.cloud.datalabeling.v1beta1.AnnotationValue) obj;

    if (!getValueTypeCase().equals(other.getValueTypeCase())) return false;
    switch (valueTypeCase_) {
      case 1:
        if (!getImageClassificationAnnotation().equals(other.getImageClassificationAnnotation()))
          return false;
        break;
      case 2:
        if (!getImageBoundingPolyAnnotation().equals(other.getImageBoundingPolyAnnotation()))
          return false;
        break;
      case 8:
        if (!getImagePolylineAnnotation().equals(other.getImagePolylineAnnotation())) return false;
        break;
      case 9:
        if (!getImageSegmentationAnnotation().equals(other.getImageSegmentationAnnotation()))
          return false;
        break;
      case 3:
        if (!getTextClassificationAnnotation().equals(other.getTextClassificationAnnotation()))
          return false;
        break;
      case 10:
        if (!getTextEntityExtractionAnnotation().equals(other.getTextEntityExtractionAnnotation()))
          return false;
        break;
      case 4:
        if (!getVideoClassificationAnnotation().equals(other.getVideoClassificationAnnotation()))
          return false;
        break;
      case 5:
        if (!getVideoObjectTrackingAnnotation().equals(other.getVideoObjectTrackingAnnotation()))
          return false;
        break;
      case 6:
        if (!getVideoEventAnnotation().equals(other.getVideoEventAnnotation())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (valueTypeCase_) {
      case 1:
        hash = (37 * hash) + IMAGE_CLASSIFICATION_ANNOTATION_FIELD_NUMBER;
        hash = (53 * hash) + getImageClassificationAnnotation().hashCode();
        break;
      case 2:
        hash = (37 * hash) + IMAGE_BOUNDING_POLY_ANNOTATION_FIELD_NUMBER;
        hash = (53 * hash) + getImageBoundingPolyAnnotation().hashCode();
        break;
      case 8:
        hash = (37 * hash) + IMAGE_POLYLINE_ANNOTATION_FIELD_NUMBER;
        hash = (53 * hash) + getImagePolylineAnnotation().hashCode();
        break;
      case 9:
        hash = (37 * hash) + IMAGE_SEGMENTATION_ANNOTATION_FIELD_NUMBER;
        hash = (53 * hash) + getImageSegmentationAnnotation().hashCode();
        break;
      case 3:
        hash = (37 * hash) + TEXT_CLASSIFICATION_ANNOTATION_FIELD_NUMBER;
        hash = (53 * hash) + getTextClassificationAnnotation().hashCode();
        break;
      case 10:
        hash = (37 * hash) + TEXT_ENTITY_EXTRACTION_ANNOTATION_FIELD_NUMBER;
        hash = (53 * hash) + getTextEntityExtractionAnnotation().hashCode();
        break;
      case 4:
        hash = (37 * hash) + VIDEO_CLASSIFICATION_ANNOTATION_FIELD_NUMBER;
        hash = (53 * hash) + getVideoClassificationAnnotation().hashCode();
        break;
      case 5:
        hash = (37 * hash) + VIDEO_OBJECT_TRACKING_ANNOTATION_FIELD_NUMBER;
        hash = (53 * hash) + getVideoObjectTrackingAnnotation().hashCode();
        break;
      case 6:
        hash = (37 * hash) + VIDEO_EVENT_ANNOTATION_FIELD_NUMBER;
        hash = (53 * hash) + getVideoEventAnnotation().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datalabeling.v1beta1.AnnotationValue parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.AnnotationValue parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.AnnotationValue parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.AnnotationValue parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.AnnotationValue parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.AnnotationValue parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.AnnotationValue parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.AnnotationValue parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.AnnotationValue parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.AnnotationValue parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.AnnotationValue parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.AnnotationValue parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.datalabeling.v1beta1.AnnotationValue prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Annotation value for an example.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datalabeling.v1beta1.AnnotationValue}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datalabeling.v1beta1.AnnotationValue)
      com.google.cloud.datalabeling.v1beta1.AnnotationValueOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datalabeling.v1beta1.AnnotationOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_AnnotationValue_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datalabeling.v1beta1.AnnotationOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_AnnotationValue_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datalabeling.v1beta1.AnnotationValue.class,
              com.google.cloud.datalabeling.v1beta1.AnnotationValue.Builder.class);
    }

    // Construct using com.google.cloud.datalabeling.v1beta1.AnnotationValue.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (imageClassificationAnnotationBuilder_ != null) {
        imageClassificationAnnotationBuilder_.clear();
      }
      if (imageBoundingPolyAnnotationBuilder_ != null) {
        imageBoundingPolyAnnotationBuilder_.clear();
      }
      if (imagePolylineAnnotationBuilder_ != null) {
        imagePolylineAnnotationBuilder_.clear();
      }
      if (imageSegmentationAnnotationBuilder_ != null) {
        imageSegmentationAnnotationBuilder_.clear();
      }
      if (textClassificationAnnotationBuilder_ != null) {
        textClassificationAnnotationBuilder_.clear();
      }
      if (textEntityExtractionAnnotationBuilder_ != null) {
        textEntityExtractionAnnotationBuilder_.clear();
      }
      if (videoClassificationAnnotationBuilder_ != null) {
        videoClassificationAnnotationBuilder_.clear();
      }
      if (videoObjectTrackingAnnotationBuilder_ != null) {
        videoObjectTrackingAnnotationBuilder_.clear();
      }
      if (videoEventAnnotationBuilder_ != null) {
        videoEventAnnotationBuilder_.clear();
      }
      valueTypeCase_ = 0;
      valueType_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datalabeling.v1beta1.AnnotationOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_AnnotationValue_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.AnnotationValue getDefaultInstanceForType() {
      return com.google.cloud.datalabeling.v1beta1.AnnotationValue.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.AnnotationValue build() {
      com.google.cloud.datalabeling.v1beta1.AnnotationValue result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.AnnotationValue buildPartial() {
      com.google.cloud.datalabeling.v1beta1.AnnotationValue result =
          new com.google.cloud.datalabeling.v1beta1.AnnotationValue(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.datalabeling.v1beta1.AnnotationValue result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.datalabeling.v1beta1.AnnotationValue result) {
      result.valueTypeCase_ = valueTypeCase_;
      result.valueType_ = this.valueType_;
      if (valueTypeCase_ == 1 && imageClassificationAnnotationBuilder_ != null) {
        result.valueType_ = imageClassificationAnnotationBuilder_.build();
      }
      if (valueTypeCase_ == 2 && imageBoundingPolyAnnotationBuilder_ != null) {
        result.valueType_ = imageBoundingPolyAnnotationBuilder_.build();
      }
      if (valueTypeCase_ == 8 && imagePolylineAnnotationBuilder_ != null) {
        result.valueType_ = imagePolylineAnnotationBuilder_.build();
      }
      if (valueTypeCase_ == 9 && imageSegmentationAnnotationBuilder_ != null) {
        result.valueType_ = imageSegmentationAnnotationBuilder_.build();
      }
      if (valueTypeCase_ == 3 && textClassificationAnnotationBuilder_ != null) {
        result.valueType_ = textClassificationAnnotationBuilder_.build();
      }
      if (valueTypeCase_ == 10 && textEntityExtractionAnnotationBuilder_ != null) {
        result.valueType_ = textEntityExtractionAnnotationBuilder_.build();
      }
      if (valueTypeCase_ == 4 && videoClassificationAnnotationBuilder_ != null) {
        result.valueType_ = videoClassificationAnnotationBuilder_.build();
      }
      if (valueTypeCase_ == 5 && videoObjectTrackingAnnotationBuilder_ != null) {
        result.valueType_ = videoObjectTrackingAnnotationBuilder_.build();
      }
      if (valueTypeCase_ == 6 && videoEventAnnotationBuilder_ != null) {
        result.valueType_ = videoEventAnnotationBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datalabeling.v1beta1.AnnotationValue) {
        return mergeFrom((com.google.cloud.datalabeling.v1beta1.AnnotationValue) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datalabeling.v1beta1.AnnotationValue other) {
      if (other == com.google.cloud.datalabeling.v1beta1.AnnotationValue.getDefaultInstance())
        return this;
      switch (other.getValueTypeCase()) {
        case IMAGE_CLASSIFICATION_ANNOTATION:
          {
            mergeImageClassificationAnnotation(other.getImageClassificationAnnotation());
            break;
          }
        case IMAGE_BOUNDING_POLY_ANNOTATION:
          {
            mergeImageBoundingPolyAnnotation(other.getImageBoundingPolyAnnotation());
            break;
          }
        case IMAGE_POLYLINE_ANNOTATION:
          {
            mergeImagePolylineAnnotation(other.getImagePolylineAnnotation());
            break;
          }
        case IMAGE_SEGMENTATION_ANNOTATION:
          {
            mergeImageSegmentationAnnotation(other.getImageSegmentationAnnotation());
            break;
          }
        case TEXT_CLASSIFICATION_ANNOTATION:
          {
            mergeTextClassificationAnnotation(other.getTextClassificationAnnotation());
            break;
          }
        case TEXT_ENTITY_EXTRACTION_ANNOTATION:
          {
            mergeTextEntityExtractionAnnotation(other.getTextEntityExtractionAnnotation());
            break;
          }
        case VIDEO_CLASSIFICATION_ANNOTATION:
          {
            mergeVideoClassificationAnnotation(other.getVideoClassificationAnnotation());
            break;
          }
        case VIDEO_OBJECT_TRACKING_ANNOTATION:
          {
            mergeVideoObjectTrackingAnnotation(other.getVideoObjectTrackingAnnotation());
            break;
          }
        case VIDEO_EVENT_ANNOTATION:
          {
            mergeVideoEventAnnotation(other.getVideoEventAnnotation());
            break;
          }
        case VALUETYPE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(
                    getImageClassificationAnnotationFieldBuilder().getBuilder(), extensionRegistry);
                valueTypeCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getImageBoundingPolyAnnotationFieldBuilder().getBuilder(), extensionRegistry);
                valueTypeCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getTextClassificationAnnotationFieldBuilder().getBuilder(), extensionRegistry);
                valueTypeCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getVideoClassificationAnnotationFieldBuilder().getBuilder(), extensionRegistry);
                valueTypeCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    getVideoObjectTrackingAnnotationFieldBuilder().getBuilder(), extensionRegistry);
                valueTypeCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(
                    getVideoEventAnnotationFieldBuilder().getBuilder(), extensionRegistry);
                valueTypeCase_ = 6;
                break;
              } // case 50
            case 66:
              {
                input.readMessage(
                    getImagePolylineAnnotationFieldBuilder().getBuilder(), extensionRegistry);
                valueTypeCase_ = 8;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(
                    getImageSegmentationAnnotationFieldBuilder().getBuilder(), extensionRegistry);
                valueTypeCase_ = 9;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(
                    getTextEntityExtractionAnnotationFieldBuilder().getBuilder(),
                    extensionRegistry);
                valueTypeCase_ = 10;
                break;
              } // case 82
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int valueTypeCase_ = 0;
    private java.lang.Object valueType_;

    public ValueTypeCase getValueTypeCase() {
      return ValueTypeCase.forNumber(valueTypeCase_);
    }

    public Builder clearValueType() {
      valueTypeCase_ = 0;
      valueType_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.ImageClassificationAnnotation,
            com.google.cloud.datalabeling.v1beta1.ImageClassificationAnnotation.Builder,
            com.google.cloud.datalabeling.v1beta1.ImageClassificationAnnotationOrBuilder>
        imageClassificationAnnotationBuilder_;
    /**
     *
     *
     * <pre>
     * Annotation value for image classification case.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageClassificationAnnotation image_classification_annotation = 1;
     * </code>
     *
     * @return Whether the imageClassificationAnnotation field is set.
     */
    @java.lang.Override
    public boolean hasImageClassificationAnnotation() {
      return valueTypeCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Annotation value for image classification case.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageClassificationAnnotation image_classification_annotation = 1;
     * </code>
     *
     * @return The imageClassificationAnnotation.
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.ImageClassificationAnnotation
        getImageClassificationAnnotation() {
      if (imageClassificationAnnotationBuilder_ == null) {
        if (valueTypeCase_ == 1) {
          return (com.google.cloud.datalabeling.v1beta1.ImageClassificationAnnotation) valueType_;
        }
        return com.google.cloud.datalabeling.v1beta1.ImageClassificationAnnotation
            .getDefaultInstance();
      } else {
        if (valueTypeCase_ == 1) {
          return imageClassificationAnnotationBuilder_.getMessage();
        }
        return com.google.cloud.datalabeling.v1beta1.ImageClassificationAnnotation
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Annotation value for image classification case.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageClassificationAnnotation image_classification_annotation = 1;
     * </code>
     */
    public Builder setImageClassificationAnnotation(
        com.google.cloud.datalabeling.v1beta1.ImageClassificationAnnotation value) {
      if (imageClassificationAnnotationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        valueType_ = value;
        onChanged();
      } else {
        imageClassificationAnnotationBuilder_.setMessage(value);
      }
      valueTypeCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotation value for image classification case.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageClassificationAnnotation image_classification_annotation = 1;
     * </code>
     */
    public Builder setImageClassificationAnnotation(
        com.google.cloud.datalabeling.v1beta1.ImageClassificationAnnotation.Builder
            builderForValue) {
      if (imageClassificationAnnotationBuilder_ == null) {
        valueType_ = builderForValue.build();
        onChanged();
      } else {
        imageClassificationAnnotationBuilder_.setMessage(builderForValue.build());
      }
      valueTypeCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotation value for image classification case.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageClassificationAnnotation image_classification_annotation = 1;
     * </code>
     */
    public Builder mergeImageClassificationAnnotation(
        com.google.cloud.datalabeling.v1beta1.ImageClassificationAnnotation value) {
      if (imageClassificationAnnotationBuilder_ == null) {
        if (valueTypeCase_ == 1
            && valueType_
                != com.google.cloud.datalabeling.v1beta1.ImageClassificationAnnotation
                    .getDefaultInstance()) {
          valueType_ =
              com.google.cloud.datalabeling.v1beta1.ImageClassificationAnnotation.newBuilder(
                      (com.google.cloud.datalabeling.v1beta1.ImageClassificationAnnotation)
                          valueType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          valueType_ = value;
        }
        onChanged();
      } else {
        if (valueTypeCase_ == 1) {
          imageClassificationAnnotationBuilder_.mergeFrom(value);
        } else {
          imageClassificationAnnotationBuilder_.setMessage(value);
        }
      }
      valueTypeCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotation value for image classification case.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageClassificationAnnotation image_classification_annotation = 1;
     * </code>
     */
    public Builder clearImageClassificationAnnotation() {
      if (imageClassificationAnnotationBuilder_ == null) {
        if (valueTypeCase_ == 1) {
          valueTypeCase_ = 0;
          valueType_ = null;
          onChanged();
        }
      } else {
        if (valueTypeCase_ == 1) {
          valueTypeCase_ = 0;
          valueType_ = null;
        }
        imageClassificationAnnotationBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotation value for image classification case.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageClassificationAnnotation image_classification_annotation = 1;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.ImageClassificationAnnotation.Builder
        getImageClassificationAnnotationBuilder() {
      return getImageClassificationAnnotationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Annotation value for image classification case.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageClassificationAnnotation image_classification_annotation = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.ImageClassificationAnnotationOrBuilder
        getImageClassificationAnnotationOrBuilder() {
      if ((valueTypeCase_ == 1) && (imageClassificationAnnotationBuilder_ != null)) {
        return imageClassificationAnnotationBuilder_.getMessageOrBuilder();
      } else {
        if (valueTypeCase_ == 1) {
          return (com.google.cloud.datalabeling.v1beta1.ImageClassificationAnnotation) valueType_;
        }
        return com.google.cloud.datalabeling.v1beta1.ImageClassificationAnnotation
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Annotation value for image classification case.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageClassificationAnnotation image_classification_annotation = 1;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.ImageClassificationAnnotation,
            com.google.cloud.datalabeling.v1beta1.ImageClassificationAnnotation.Builder,
            com.google.cloud.datalabeling.v1beta1.ImageClassificationAnnotationOrBuilder>
        getImageClassificationAnnotationFieldBuilder() {
      if (imageClassificationAnnotationBuilder_ == null) {
        if (!(valueTypeCase_ == 1)) {
          valueType_ =
              com.google.cloud.datalabeling.v1beta1.ImageClassificationAnnotation
                  .getDefaultInstance();
        }
        imageClassificationAnnotationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.ImageClassificationAnnotation,
                com.google.cloud.datalabeling.v1beta1.ImageClassificationAnnotation.Builder,
                com.google.cloud.datalabeling.v1beta1.ImageClassificationAnnotationOrBuilder>(
                (com.google.cloud.datalabeling.v1beta1.ImageClassificationAnnotation) valueType_,
                getParentForChildren(),
                isClean());
        valueType_ = null;
      }
      valueTypeCase_ = 1;
      onChanged();
      return imageClassificationAnnotationBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation,
            com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation.Builder,
            com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotationOrBuilder>
        imageBoundingPolyAnnotationBuilder_;
    /**
     *
     *
     * <pre>
     * Annotation value for image bounding box, oriented bounding box
     * and polygon cases.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation image_bounding_poly_annotation = 2;
     * </code>
     *
     * @return Whether the imageBoundingPolyAnnotation field is set.
     */
    @java.lang.Override
    public boolean hasImageBoundingPolyAnnotation() {
      return valueTypeCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Annotation value for image bounding box, oriented bounding box
     * and polygon cases.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation image_bounding_poly_annotation = 2;
     * </code>
     *
     * @return The imageBoundingPolyAnnotation.
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation
        getImageBoundingPolyAnnotation() {
      if (imageBoundingPolyAnnotationBuilder_ == null) {
        if (valueTypeCase_ == 2) {
          return (com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation) valueType_;
        }
        return com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation
            .getDefaultInstance();
      } else {
        if (valueTypeCase_ == 2) {
          return imageBoundingPolyAnnotationBuilder_.getMessage();
        }
        return com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Annotation value for image bounding box, oriented bounding box
     * and polygon cases.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation image_bounding_poly_annotation = 2;
     * </code>
     */
    public Builder setImageBoundingPolyAnnotation(
        com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation value) {
      if (imageBoundingPolyAnnotationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        valueType_ = value;
        onChanged();
      } else {
        imageBoundingPolyAnnotationBuilder_.setMessage(value);
      }
      valueTypeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotation value for image bounding box, oriented bounding box
     * and polygon cases.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation image_bounding_poly_annotation = 2;
     * </code>
     */
    public Builder setImageBoundingPolyAnnotation(
        com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation.Builder builderForValue) {
      if (imageBoundingPolyAnnotationBuilder_ == null) {
        valueType_ = builderForValue.build();
        onChanged();
      } else {
        imageBoundingPolyAnnotationBuilder_.setMessage(builderForValue.build());
      }
      valueTypeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotation value for image bounding box, oriented bounding box
     * and polygon cases.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation image_bounding_poly_annotation = 2;
     * </code>
     */
    public Builder mergeImageBoundingPolyAnnotation(
        com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation value) {
      if (imageBoundingPolyAnnotationBuilder_ == null) {
        if (valueTypeCase_ == 2
            && valueType_
                != com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation
                    .getDefaultInstance()) {
          valueType_ =
              com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation.newBuilder(
                      (com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation)
                          valueType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          valueType_ = value;
        }
        onChanged();
      } else {
        if (valueTypeCase_ == 2) {
          imageBoundingPolyAnnotationBuilder_.mergeFrom(value);
        } else {
          imageBoundingPolyAnnotationBuilder_.setMessage(value);
        }
      }
      valueTypeCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotation value for image bounding box, oriented bounding box
     * and polygon cases.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation image_bounding_poly_annotation = 2;
     * </code>
     */
    public Builder clearImageBoundingPolyAnnotation() {
      if (imageBoundingPolyAnnotationBuilder_ == null) {
        if (valueTypeCase_ == 2) {
          valueTypeCase_ = 0;
          valueType_ = null;
          onChanged();
        }
      } else {
        if (valueTypeCase_ == 2) {
          valueTypeCase_ = 0;
          valueType_ = null;
        }
        imageBoundingPolyAnnotationBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotation value for image bounding box, oriented bounding box
     * and polygon cases.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation image_bounding_poly_annotation = 2;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation.Builder
        getImageBoundingPolyAnnotationBuilder() {
      return getImageBoundingPolyAnnotationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Annotation value for image bounding box, oriented bounding box
     * and polygon cases.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation image_bounding_poly_annotation = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotationOrBuilder
        getImageBoundingPolyAnnotationOrBuilder() {
      if ((valueTypeCase_ == 2) && (imageBoundingPolyAnnotationBuilder_ != null)) {
        return imageBoundingPolyAnnotationBuilder_.getMessageOrBuilder();
      } else {
        if (valueTypeCase_ == 2) {
          return (com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation) valueType_;
        }
        return com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Annotation value for image bounding box, oriented bounding box
     * and polygon cases.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation image_bounding_poly_annotation = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation,
            com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation.Builder,
            com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotationOrBuilder>
        getImageBoundingPolyAnnotationFieldBuilder() {
      if (imageBoundingPolyAnnotationBuilder_ == null) {
        if (!(valueTypeCase_ == 2)) {
          valueType_ =
              com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation
                  .getDefaultInstance();
        }
        imageBoundingPolyAnnotationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation,
                com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation.Builder,
                com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotationOrBuilder>(
                (com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation) valueType_,
                getParentForChildren(),
                isClean());
        valueType_ = null;
      }
      valueTypeCase_ = 2;
      onChanged();
      return imageBoundingPolyAnnotationBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.ImagePolylineAnnotation,
            com.google.cloud.datalabeling.v1beta1.ImagePolylineAnnotation.Builder,
            com.google.cloud.datalabeling.v1beta1.ImagePolylineAnnotationOrBuilder>
        imagePolylineAnnotationBuilder_;
    /**
     *
     *
     * <pre>
     * Annotation value for image polyline cases.
     * Polyline here is different from BoundingPoly. It is formed by
     * line segments connected to each other but not closed form(Bounding Poly).
     * The line segments can cross each other.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImagePolylineAnnotation image_polyline_annotation = 8;
     * </code>
     *
     * @return Whether the imagePolylineAnnotation field is set.
     */
    @java.lang.Override
    public boolean hasImagePolylineAnnotation() {
      return valueTypeCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * Annotation value for image polyline cases.
     * Polyline here is different from BoundingPoly. It is formed by
     * line segments connected to each other but not closed form(Bounding Poly).
     * The line segments can cross each other.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImagePolylineAnnotation image_polyline_annotation = 8;
     * </code>
     *
     * @return The imagePolylineAnnotation.
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.ImagePolylineAnnotation
        getImagePolylineAnnotation() {
      if (imagePolylineAnnotationBuilder_ == null) {
        if (valueTypeCase_ == 8) {
          return (com.google.cloud.datalabeling.v1beta1.ImagePolylineAnnotation) valueType_;
        }
        return com.google.cloud.datalabeling.v1beta1.ImagePolylineAnnotation.getDefaultInstance();
      } else {
        if (valueTypeCase_ == 8) {
          return imagePolylineAnnotationBuilder_.getMessage();
        }
        return com.google.cloud.datalabeling.v1beta1.ImagePolylineAnnotation.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Annotation value for image polyline cases.
     * Polyline here is different from BoundingPoly. It is formed by
     * line segments connected to each other but not closed form(Bounding Poly).
     * The line segments can cross each other.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImagePolylineAnnotation image_polyline_annotation = 8;
     * </code>
     */
    public Builder setImagePolylineAnnotation(
        com.google.cloud.datalabeling.v1beta1.ImagePolylineAnnotation value) {
      if (imagePolylineAnnotationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        valueType_ = value;
        onChanged();
      } else {
        imagePolylineAnnotationBuilder_.setMessage(value);
      }
      valueTypeCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotation value for image polyline cases.
     * Polyline here is different from BoundingPoly. It is formed by
     * line segments connected to each other but not closed form(Bounding Poly).
     * The line segments can cross each other.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImagePolylineAnnotation image_polyline_annotation = 8;
     * </code>
     */
    public Builder setImagePolylineAnnotation(
        com.google.cloud.datalabeling.v1beta1.ImagePolylineAnnotation.Builder builderForValue) {
      if (imagePolylineAnnotationBuilder_ == null) {
        valueType_ = builderForValue.build();
        onChanged();
      } else {
        imagePolylineAnnotationBuilder_.setMessage(builderForValue.build());
      }
      valueTypeCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotation value for image polyline cases.
     * Polyline here is different from BoundingPoly. It is formed by
     * line segments connected to each other but not closed form(Bounding Poly).
     * The line segments can cross each other.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImagePolylineAnnotation image_polyline_annotation = 8;
     * </code>
     */
    public Builder mergeImagePolylineAnnotation(
        com.google.cloud.datalabeling.v1beta1.ImagePolylineAnnotation value) {
      if (imagePolylineAnnotationBuilder_ == null) {
        if (valueTypeCase_ == 8
            && valueType_
                != com.google.cloud.datalabeling.v1beta1.ImagePolylineAnnotation
                    .getDefaultInstance()) {
          valueType_ =
              com.google.cloud.datalabeling.v1beta1.ImagePolylineAnnotation.newBuilder(
                      (com.google.cloud.datalabeling.v1beta1.ImagePolylineAnnotation) valueType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          valueType_ = value;
        }
        onChanged();
      } else {
        if (valueTypeCase_ == 8) {
          imagePolylineAnnotationBuilder_.mergeFrom(value);
        } else {
          imagePolylineAnnotationBuilder_.setMessage(value);
        }
      }
      valueTypeCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotation value for image polyline cases.
     * Polyline here is different from BoundingPoly. It is formed by
     * line segments connected to each other but not closed form(Bounding Poly).
     * The line segments can cross each other.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImagePolylineAnnotation image_polyline_annotation = 8;
     * </code>
     */
    public Builder clearImagePolylineAnnotation() {
      if (imagePolylineAnnotationBuilder_ == null) {
        if (valueTypeCase_ == 8) {
          valueTypeCase_ = 0;
          valueType_ = null;
          onChanged();
        }
      } else {
        if (valueTypeCase_ == 8) {
          valueTypeCase_ = 0;
          valueType_ = null;
        }
        imagePolylineAnnotationBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotation value for image polyline cases.
     * Polyline here is different from BoundingPoly. It is formed by
     * line segments connected to each other but not closed form(Bounding Poly).
     * The line segments can cross each other.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImagePolylineAnnotation image_polyline_annotation = 8;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.ImagePolylineAnnotation.Builder
        getImagePolylineAnnotationBuilder() {
      return getImagePolylineAnnotationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Annotation value for image polyline cases.
     * Polyline here is different from BoundingPoly. It is formed by
     * line segments connected to each other but not closed form(Bounding Poly).
     * The line segments can cross each other.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImagePolylineAnnotation image_polyline_annotation = 8;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.ImagePolylineAnnotationOrBuilder
        getImagePolylineAnnotationOrBuilder() {
      if ((valueTypeCase_ == 8) && (imagePolylineAnnotationBuilder_ != null)) {
        return imagePolylineAnnotationBuilder_.getMessageOrBuilder();
      } else {
        if (valueTypeCase_ == 8) {
          return (com.google.cloud.datalabeling.v1beta1.ImagePolylineAnnotation) valueType_;
        }
        return com.google.cloud.datalabeling.v1beta1.ImagePolylineAnnotation.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Annotation value for image polyline cases.
     * Polyline here is different from BoundingPoly. It is formed by
     * line segments connected to each other but not closed form(Bounding Poly).
     * The line segments can cross each other.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImagePolylineAnnotation image_polyline_annotation = 8;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.ImagePolylineAnnotation,
            com.google.cloud.datalabeling.v1beta1.ImagePolylineAnnotation.Builder,
            com.google.cloud.datalabeling.v1beta1.ImagePolylineAnnotationOrBuilder>
        getImagePolylineAnnotationFieldBuilder() {
      if (imagePolylineAnnotationBuilder_ == null) {
        if (!(valueTypeCase_ == 8)) {
          valueType_ =
              com.google.cloud.datalabeling.v1beta1.ImagePolylineAnnotation.getDefaultInstance();
        }
        imagePolylineAnnotationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.ImagePolylineAnnotation,
                com.google.cloud.datalabeling.v1beta1.ImagePolylineAnnotation.Builder,
                com.google.cloud.datalabeling.v1beta1.ImagePolylineAnnotationOrBuilder>(
                (com.google.cloud.datalabeling.v1beta1.ImagePolylineAnnotation) valueType_,
                getParentForChildren(),
                isClean());
        valueType_ = null;
      }
      valueTypeCase_ = 8;
      onChanged();
      return imagePolylineAnnotationBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.ImageSegmentationAnnotation,
            com.google.cloud.datalabeling.v1beta1.ImageSegmentationAnnotation.Builder,
            com.google.cloud.datalabeling.v1beta1.ImageSegmentationAnnotationOrBuilder>
        imageSegmentationAnnotationBuilder_;
    /**
     *
     *
     * <pre>
     * Annotation value for image segmentation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageSegmentationAnnotation image_segmentation_annotation = 9;
     * </code>
     *
     * @return Whether the imageSegmentationAnnotation field is set.
     */
    @java.lang.Override
    public boolean hasImageSegmentationAnnotation() {
      return valueTypeCase_ == 9;
    }
    /**
     *
     *
     * <pre>
     * Annotation value for image segmentation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageSegmentationAnnotation image_segmentation_annotation = 9;
     * </code>
     *
     * @return The imageSegmentationAnnotation.
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.ImageSegmentationAnnotation
        getImageSegmentationAnnotation() {
      if (imageSegmentationAnnotationBuilder_ == null) {
        if (valueTypeCase_ == 9) {
          return (com.google.cloud.datalabeling.v1beta1.ImageSegmentationAnnotation) valueType_;
        }
        return com.google.cloud.datalabeling.v1beta1.ImageSegmentationAnnotation
            .getDefaultInstance();
      } else {
        if (valueTypeCase_ == 9) {
          return imageSegmentationAnnotationBuilder_.getMessage();
        }
        return com.google.cloud.datalabeling.v1beta1.ImageSegmentationAnnotation
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Annotation value for image segmentation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageSegmentationAnnotation image_segmentation_annotation = 9;
     * </code>
     */
    public Builder setImageSegmentationAnnotation(
        com.google.cloud.datalabeling.v1beta1.ImageSegmentationAnnotation value) {
      if (imageSegmentationAnnotationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        valueType_ = value;
        onChanged();
      } else {
        imageSegmentationAnnotationBuilder_.setMessage(value);
      }
      valueTypeCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotation value for image segmentation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageSegmentationAnnotation image_segmentation_annotation = 9;
     * </code>
     */
    public Builder setImageSegmentationAnnotation(
        com.google.cloud.datalabeling.v1beta1.ImageSegmentationAnnotation.Builder builderForValue) {
      if (imageSegmentationAnnotationBuilder_ == null) {
        valueType_ = builderForValue.build();
        onChanged();
      } else {
        imageSegmentationAnnotationBuilder_.setMessage(builderForValue.build());
      }
      valueTypeCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotation value for image segmentation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageSegmentationAnnotation image_segmentation_annotation = 9;
     * </code>
     */
    public Builder mergeImageSegmentationAnnotation(
        com.google.cloud.datalabeling.v1beta1.ImageSegmentationAnnotation value) {
      if (imageSegmentationAnnotationBuilder_ == null) {
        if (valueTypeCase_ == 9
            && valueType_
                != com.google.cloud.datalabeling.v1beta1.ImageSegmentationAnnotation
                    .getDefaultInstance()) {
          valueType_ =
              com.google.cloud.datalabeling.v1beta1.ImageSegmentationAnnotation.newBuilder(
                      (com.google.cloud.datalabeling.v1beta1.ImageSegmentationAnnotation)
                          valueType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          valueType_ = value;
        }
        onChanged();
      } else {
        if (valueTypeCase_ == 9) {
          imageSegmentationAnnotationBuilder_.mergeFrom(value);
        } else {
          imageSegmentationAnnotationBuilder_.setMessage(value);
        }
      }
      valueTypeCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotation value for image segmentation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageSegmentationAnnotation image_segmentation_annotation = 9;
     * </code>
     */
    public Builder clearImageSegmentationAnnotation() {
      if (imageSegmentationAnnotationBuilder_ == null) {
        if (valueTypeCase_ == 9) {
          valueTypeCase_ = 0;
          valueType_ = null;
          onChanged();
        }
      } else {
        if (valueTypeCase_ == 9) {
          valueTypeCase_ = 0;
          valueType_ = null;
        }
        imageSegmentationAnnotationBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotation value for image segmentation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageSegmentationAnnotation image_segmentation_annotation = 9;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.ImageSegmentationAnnotation.Builder
        getImageSegmentationAnnotationBuilder() {
      return getImageSegmentationAnnotationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Annotation value for image segmentation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageSegmentationAnnotation image_segmentation_annotation = 9;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.ImageSegmentationAnnotationOrBuilder
        getImageSegmentationAnnotationOrBuilder() {
      if ((valueTypeCase_ == 9) && (imageSegmentationAnnotationBuilder_ != null)) {
        return imageSegmentationAnnotationBuilder_.getMessageOrBuilder();
      } else {
        if (valueTypeCase_ == 9) {
          return (com.google.cloud.datalabeling.v1beta1.ImageSegmentationAnnotation) valueType_;
        }
        return com.google.cloud.datalabeling.v1beta1.ImageSegmentationAnnotation
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Annotation value for image segmentation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageSegmentationAnnotation image_segmentation_annotation = 9;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.ImageSegmentationAnnotation,
            com.google.cloud.datalabeling.v1beta1.ImageSegmentationAnnotation.Builder,
            com.google.cloud.datalabeling.v1beta1.ImageSegmentationAnnotationOrBuilder>
        getImageSegmentationAnnotationFieldBuilder() {
      if (imageSegmentationAnnotationBuilder_ == null) {
        if (!(valueTypeCase_ == 9)) {
          valueType_ =
              com.google.cloud.datalabeling.v1beta1.ImageSegmentationAnnotation
                  .getDefaultInstance();
        }
        imageSegmentationAnnotationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.ImageSegmentationAnnotation,
                com.google.cloud.datalabeling.v1beta1.ImageSegmentationAnnotation.Builder,
                com.google.cloud.datalabeling.v1beta1.ImageSegmentationAnnotationOrBuilder>(
                (com.google.cloud.datalabeling.v1beta1.ImageSegmentationAnnotation) valueType_,
                getParentForChildren(),
                isClean());
        valueType_ = null;
      }
      valueTypeCase_ = 9;
      onChanged();
      return imageSegmentationAnnotationBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.TextClassificationAnnotation,
            com.google.cloud.datalabeling.v1beta1.TextClassificationAnnotation.Builder,
            com.google.cloud.datalabeling.v1beta1.TextClassificationAnnotationOrBuilder>
        textClassificationAnnotationBuilder_;
    /**
     *
     *
     * <pre>
     * Annotation value for text classification case.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextClassificationAnnotation text_classification_annotation = 3;
     * </code>
     *
     * @return Whether the textClassificationAnnotation field is set.
     */
    @java.lang.Override
    public boolean hasTextClassificationAnnotation() {
      return valueTypeCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Annotation value for text classification case.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextClassificationAnnotation text_classification_annotation = 3;
     * </code>
     *
     * @return The textClassificationAnnotation.
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.TextClassificationAnnotation
        getTextClassificationAnnotation() {
      if (textClassificationAnnotationBuilder_ == null) {
        if (valueTypeCase_ == 3) {
          return (com.google.cloud.datalabeling.v1beta1.TextClassificationAnnotation) valueType_;
        }
        return com.google.cloud.datalabeling.v1beta1.TextClassificationAnnotation
            .getDefaultInstance();
      } else {
        if (valueTypeCase_ == 3) {
          return textClassificationAnnotationBuilder_.getMessage();
        }
        return com.google.cloud.datalabeling.v1beta1.TextClassificationAnnotation
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Annotation value for text classification case.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextClassificationAnnotation text_classification_annotation = 3;
     * </code>
     */
    public Builder setTextClassificationAnnotation(
        com.google.cloud.datalabeling.v1beta1.TextClassificationAnnotation value) {
      if (textClassificationAnnotationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        valueType_ = value;
        onChanged();
      } else {
        textClassificationAnnotationBuilder_.setMessage(value);
      }
      valueTypeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotation value for text classification case.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextClassificationAnnotation text_classification_annotation = 3;
     * </code>
     */
    public Builder setTextClassificationAnnotation(
        com.google.cloud.datalabeling.v1beta1.TextClassificationAnnotation.Builder
            builderForValue) {
      if (textClassificationAnnotationBuilder_ == null) {
        valueType_ = builderForValue.build();
        onChanged();
      } else {
        textClassificationAnnotationBuilder_.setMessage(builderForValue.build());
      }
      valueTypeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotation value for text classification case.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextClassificationAnnotation text_classification_annotation = 3;
     * </code>
     */
    public Builder mergeTextClassificationAnnotation(
        com.google.cloud.datalabeling.v1beta1.TextClassificationAnnotation value) {
      if (textClassificationAnnotationBuilder_ == null) {
        if (valueTypeCase_ == 3
            && valueType_
                != com.google.cloud.datalabeling.v1beta1.TextClassificationAnnotation
                    .getDefaultInstance()) {
          valueType_ =
              com.google.cloud.datalabeling.v1beta1.TextClassificationAnnotation.newBuilder(
                      (com.google.cloud.datalabeling.v1beta1.TextClassificationAnnotation)
                          valueType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          valueType_ = value;
        }
        onChanged();
      } else {
        if (valueTypeCase_ == 3) {
          textClassificationAnnotationBuilder_.mergeFrom(value);
        } else {
          textClassificationAnnotationBuilder_.setMessage(value);
        }
      }
      valueTypeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotation value for text classification case.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextClassificationAnnotation text_classification_annotation = 3;
     * </code>
     */
    public Builder clearTextClassificationAnnotation() {
      if (textClassificationAnnotationBuilder_ == null) {
        if (valueTypeCase_ == 3) {
          valueTypeCase_ = 0;
          valueType_ = null;
          onChanged();
        }
      } else {
        if (valueTypeCase_ == 3) {
          valueTypeCase_ = 0;
          valueType_ = null;
        }
        textClassificationAnnotationBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotation value for text classification case.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextClassificationAnnotation text_classification_annotation = 3;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.TextClassificationAnnotation.Builder
        getTextClassificationAnnotationBuilder() {
      return getTextClassificationAnnotationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Annotation value for text classification case.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextClassificationAnnotation text_classification_annotation = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.TextClassificationAnnotationOrBuilder
        getTextClassificationAnnotationOrBuilder() {
      if ((valueTypeCase_ == 3) && (textClassificationAnnotationBuilder_ != null)) {
        return textClassificationAnnotationBuilder_.getMessageOrBuilder();
      } else {
        if (valueTypeCase_ == 3) {
          return (com.google.cloud.datalabeling.v1beta1.TextClassificationAnnotation) valueType_;
        }
        return com.google.cloud.datalabeling.v1beta1.TextClassificationAnnotation
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Annotation value for text classification case.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextClassificationAnnotation text_classification_annotation = 3;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.TextClassificationAnnotation,
            com.google.cloud.datalabeling.v1beta1.TextClassificationAnnotation.Builder,
            com.google.cloud.datalabeling.v1beta1.TextClassificationAnnotationOrBuilder>
        getTextClassificationAnnotationFieldBuilder() {
      if (textClassificationAnnotationBuilder_ == null) {
        if (!(valueTypeCase_ == 3)) {
          valueType_ =
              com.google.cloud.datalabeling.v1beta1.TextClassificationAnnotation
                  .getDefaultInstance();
        }
        textClassificationAnnotationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.TextClassificationAnnotation,
                com.google.cloud.datalabeling.v1beta1.TextClassificationAnnotation.Builder,
                com.google.cloud.datalabeling.v1beta1.TextClassificationAnnotationOrBuilder>(
                (com.google.cloud.datalabeling.v1beta1.TextClassificationAnnotation) valueType_,
                getParentForChildren(),
                isClean());
        valueType_ = null;
      }
      valueTypeCase_ = 3;
      onChanged();
      return textClassificationAnnotationBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.TextEntityExtractionAnnotation,
            com.google.cloud.datalabeling.v1beta1.TextEntityExtractionAnnotation.Builder,
            com.google.cloud.datalabeling.v1beta1.TextEntityExtractionAnnotationOrBuilder>
        textEntityExtractionAnnotationBuilder_;
    /**
     *
     *
     * <pre>
     * Annotation value for text entity extraction case.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextEntityExtractionAnnotation text_entity_extraction_annotation = 10;
     * </code>
     *
     * @return Whether the textEntityExtractionAnnotation field is set.
     */
    @java.lang.Override
    public boolean hasTextEntityExtractionAnnotation() {
      return valueTypeCase_ == 10;
    }
    /**
     *
     *
     * <pre>
     * Annotation value for text entity extraction case.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextEntityExtractionAnnotation text_entity_extraction_annotation = 10;
     * </code>
     *
     * @return The textEntityExtractionAnnotation.
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.TextEntityExtractionAnnotation
        getTextEntityExtractionAnnotation() {
      if (textEntityExtractionAnnotationBuilder_ == null) {
        if (valueTypeCase_ == 10) {
          return (com.google.cloud.datalabeling.v1beta1.TextEntityExtractionAnnotation) valueType_;
        }
        return com.google.cloud.datalabeling.v1beta1.TextEntityExtractionAnnotation
            .getDefaultInstance();
      } else {
        if (valueTypeCase_ == 10) {
          return textEntityExtractionAnnotationBuilder_.getMessage();
        }
        return com.google.cloud.datalabeling.v1beta1.TextEntityExtractionAnnotation
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Annotation value for text entity extraction case.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextEntityExtractionAnnotation text_entity_extraction_annotation = 10;
     * </code>
     */
    public Builder setTextEntityExtractionAnnotation(
        com.google.cloud.datalabeling.v1beta1.TextEntityExtractionAnnotation value) {
      if (textEntityExtractionAnnotationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        valueType_ = value;
        onChanged();
      } else {
        textEntityExtractionAnnotationBuilder_.setMessage(value);
      }
      valueTypeCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotation value for text entity extraction case.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextEntityExtractionAnnotation text_entity_extraction_annotation = 10;
     * </code>
     */
    public Builder setTextEntityExtractionAnnotation(
        com.google.cloud.datalabeling.v1beta1.TextEntityExtractionAnnotation.Builder
            builderForValue) {
      if (textEntityExtractionAnnotationBuilder_ == null) {
        valueType_ = builderForValue.build();
        onChanged();
      } else {
        textEntityExtractionAnnotationBuilder_.setMessage(builderForValue.build());
      }
      valueTypeCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotation value for text entity extraction case.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextEntityExtractionAnnotation text_entity_extraction_annotation = 10;
     * </code>
     */
    public Builder mergeTextEntityExtractionAnnotation(
        com.google.cloud.datalabeling.v1beta1.TextEntityExtractionAnnotation value) {
      if (textEntityExtractionAnnotationBuilder_ == null) {
        if (valueTypeCase_ == 10
            && valueType_
                != com.google.cloud.datalabeling.v1beta1.TextEntityExtractionAnnotation
                    .getDefaultInstance()) {
          valueType_ =
              com.google.cloud.datalabeling.v1beta1.TextEntityExtractionAnnotation.newBuilder(
                      (com.google.cloud.datalabeling.v1beta1.TextEntityExtractionAnnotation)
                          valueType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          valueType_ = value;
        }
        onChanged();
      } else {
        if (valueTypeCase_ == 10) {
          textEntityExtractionAnnotationBuilder_.mergeFrom(value);
        } else {
          textEntityExtractionAnnotationBuilder_.setMessage(value);
        }
      }
      valueTypeCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotation value for text entity extraction case.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextEntityExtractionAnnotation text_entity_extraction_annotation = 10;
     * </code>
     */
    public Builder clearTextEntityExtractionAnnotation() {
      if (textEntityExtractionAnnotationBuilder_ == null) {
        if (valueTypeCase_ == 10) {
          valueTypeCase_ = 0;
          valueType_ = null;
          onChanged();
        }
      } else {
        if (valueTypeCase_ == 10) {
          valueTypeCase_ = 0;
          valueType_ = null;
        }
        textEntityExtractionAnnotationBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotation value for text entity extraction case.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextEntityExtractionAnnotation text_entity_extraction_annotation = 10;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.TextEntityExtractionAnnotation.Builder
        getTextEntityExtractionAnnotationBuilder() {
      return getTextEntityExtractionAnnotationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Annotation value for text entity extraction case.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextEntityExtractionAnnotation text_entity_extraction_annotation = 10;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.TextEntityExtractionAnnotationOrBuilder
        getTextEntityExtractionAnnotationOrBuilder() {
      if ((valueTypeCase_ == 10) && (textEntityExtractionAnnotationBuilder_ != null)) {
        return textEntityExtractionAnnotationBuilder_.getMessageOrBuilder();
      } else {
        if (valueTypeCase_ == 10) {
          return (com.google.cloud.datalabeling.v1beta1.TextEntityExtractionAnnotation) valueType_;
        }
        return com.google.cloud.datalabeling.v1beta1.TextEntityExtractionAnnotation
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Annotation value for text entity extraction case.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextEntityExtractionAnnotation text_entity_extraction_annotation = 10;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.TextEntityExtractionAnnotation,
            com.google.cloud.datalabeling.v1beta1.TextEntityExtractionAnnotation.Builder,
            com.google.cloud.datalabeling.v1beta1.TextEntityExtractionAnnotationOrBuilder>
        getTextEntityExtractionAnnotationFieldBuilder() {
      if (textEntityExtractionAnnotationBuilder_ == null) {
        if (!(valueTypeCase_ == 10)) {
          valueType_ =
              com.google.cloud.datalabeling.v1beta1.TextEntityExtractionAnnotation
                  .getDefaultInstance();
        }
        textEntityExtractionAnnotationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.TextEntityExtractionAnnotation,
                com.google.cloud.datalabeling.v1beta1.TextEntityExtractionAnnotation.Builder,
                com.google.cloud.datalabeling.v1beta1.TextEntityExtractionAnnotationOrBuilder>(
                (com.google.cloud.datalabeling.v1beta1.TextEntityExtractionAnnotation) valueType_,
                getParentForChildren(),
                isClean());
        valueType_ = null;
      }
      valueTypeCase_ = 10;
      onChanged();
      return textEntityExtractionAnnotationBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.VideoClassificationAnnotation,
            com.google.cloud.datalabeling.v1beta1.VideoClassificationAnnotation.Builder,
            com.google.cloud.datalabeling.v1beta1.VideoClassificationAnnotationOrBuilder>
        videoClassificationAnnotationBuilder_;
    /**
     *
     *
     * <pre>
     * Annotation value for video classification case.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.VideoClassificationAnnotation video_classification_annotation = 4;
     * </code>
     *
     * @return Whether the videoClassificationAnnotation field is set.
     */
    @java.lang.Override
    public boolean hasVideoClassificationAnnotation() {
      return valueTypeCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Annotation value for video classification case.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.VideoClassificationAnnotation video_classification_annotation = 4;
     * </code>
     *
     * @return The videoClassificationAnnotation.
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.VideoClassificationAnnotation
        getVideoClassificationAnnotation() {
      if (videoClassificationAnnotationBuilder_ == null) {
        if (valueTypeCase_ == 4) {
          return (com.google.cloud.datalabeling.v1beta1.VideoClassificationAnnotation) valueType_;
        }
        return com.google.cloud.datalabeling.v1beta1.VideoClassificationAnnotation
            .getDefaultInstance();
      } else {
        if (valueTypeCase_ == 4) {
          return videoClassificationAnnotationBuilder_.getMessage();
        }
        return com.google.cloud.datalabeling.v1beta1.VideoClassificationAnnotation
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Annotation value for video classification case.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.VideoClassificationAnnotation video_classification_annotation = 4;
     * </code>
     */
    public Builder setVideoClassificationAnnotation(
        com.google.cloud.datalabeling.v1beta1.VideoClassificationAnnotation value) {
      if (videoClassificationAnnotationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        valueType_ = value;
        onChanged();
      } else {
        videoClassificationAnnotationBuilder_.setMessage(value);
      }
      valueTypeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotation value for video classification case.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.VideoClassificationAnnotation video_classification_annotation = 4;
     * </code>
     */
    public Builder setVideoClassificationAnnotation(
        com.google.cloud.datalabeling.v1beta1.VideoClassificationAnnotation.Builder
            builderForValue) {
      if (videoClassificationAnnotationBuilder_ == null) {
        valueType_ = builderForValue.build();
        onChanged();
      } else {
        videoClassificationAnnotationBuilder_.setMessage(builderForValue.build());
      }
      valueTypeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotation value for video classification case.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.VideoClassificationAnnotation video_classification_annotation = 4;
     * </code>
     */
    public Builder mergeVideoClassificationAnnotation(
        com.google.cloud.datalabeling.v1beta1.VideoClassificationAnnotation value) {
      if (videoClassificationAnnotationBuilder_ == null) {
        if (valueTypeCase_ == 4
            && valueType_
                != com.google.cloud.datalabeling.v1beta1.VideoClassificationAnnotation
                    .getDefaultInstance()) {
          valueType_ =
              com.google.cloud.datalabeling.v1beta1.VideoClassificationAnnotation.newBuilder(
                      (com.google.cloud.datalabeling.v1beta1.VideoClassificationAnnotation)
                          valueType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          valueType_ = value;
        }
        onChanged();
      } else {
        if (valueTypeCase_ == 4) {
          videoClassificationAnnotationBuilder_.mergeFrom(value);
        } else {
          videoClassificationAnnotationBuilder_.setMessage(value);
        }
      }
      valueTypeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotation value for video classification case.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.VideoClassificationAnnotation video_classification_annotation = 4;
     * </code>
     */
    public Builder clearVideoClassificationAnnotation() {
      if (videoClassificationAnnotationBuilder_ == null) {
        if (valueTypeCase_ == 4) {
          valueTypeCase_ = 0;
          valueType_ = null;
          onChanged();
        }
      } else {
        if (valueTypeCase_ == 4) {
          valueTypeCase_ = 0;
          valueType_ = null;
        }
        videoClassificationAnnotationBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotation value for video classification case.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.VideoClassificationAnnotation video_classification_annotation = 4;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.VideoClassificationAnnotation.Builder
        getVideoClassificationAnnotationBuilder() {
      return getVideoClassificationAnnotationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Annotation value for video classification case.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.VideoClassificationAnnotation video_classification_annotation = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.VideoClassificationAnnotationOrBuilder
        getVideoClassificationAnnotationOrBuilder() {
      if ((valueTypeCase_ == 4) && (videoClassificationAnnotationBuilder_ != null)) {
        return videoClassificationAnnotationBuilder_.getMessageOrBuilder();
      } else {
        if (valueTypeCase_ == 4) {
          return (com.google.cloud.datalabeling.v1beta1.VideoClassificationAnnotation) valueType_;
        }
        return com.google.cloud.datalabeling.v1beta1.VideoClassificationAnnotation
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Annotation value for video classification case.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.VideoClassificationAnnotation video_classification_annotation = 4;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.VideoClassificationAnnotation,
            com.google.cloud.datalabeling.v1beta1.VideoClassificationAnnotation.Builder,
            com.google.cloud.datalabeling.v1beta1.VideoClassificationAnnotationOrBuilder>
        getVideoClassificationAnnotationFieldBuilder() {
      if (videoClassificationAnnotationBuilder_ == null) {
        if (!(valueTypeCase_ == 4)) {
          valueType_ =
              com.google.cloud.datalabeling.v1beta1.VideoClassificationAnnotation
                  .getDefaultInstance();
        }
        videoClassificationAnnotationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.VideoClassificationAnnotation,
                com.google.cloud.datalabeling.v1beta1.VideoClassificationAnnotation.Builder,
                com.google.cloud.datalabeling.v1beta1.VideoClassificationAnnotationOrBuilder>(
                (com.google.cloud.datalabeling.v1beta1.VideoClassificationAnnotation) valueType_,
                getParentForChildren(),
                isClean());
        valueType_ = null;
      }
      valueTypeCase_ = 4;
      onChanged();
      return videoClassificationAnnotationBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation,
            com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation.Builder,
            com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotationOrBuilder>
        videoObjectTrackingAnnotationBuilder_;
    /**
     *
     *
     * <pre>
     * Annotation value for video object detection and tracking case.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation video_object_tracking_annotation = 5;
     * </code>
     *
     * @return Whether the videoObjectTrackingAnnotation field is set.
     */
    @java.lang.Override
    public boolean hasVideoObjectTrackingAnnotation() {
      return valueTypeCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Annotation value for video object detection and tracking case.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation video_object_tracking_annotation = 5;
     * </code>
     *
     * @return The videoObjectTrackingAnnotation.
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation
        getVideoObjectTrackingAnnotation() {
      if (videoObjectTrackingAnnotationBuilder_ == null) {
        if (valueTypeCase_ == 5) {
          return (com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation) valueType_;
        }
        return com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation
            .getDefaultInstance();
      } else {
        if (valueTypeCase_ == 5) {
          return videoObjectTrackingAnnotationBuilder_.getMessage();
        }
        return com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Annotation value for video object detection and tracking case.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation video_object_tracking_annotation = 5;
     * </code>
     */
    public Builder setVideoObjectTrackingAnnotation(
        com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation value) {
      if (videoObjectTrackingAnnotationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        valueType_ = value;
        onChanged();
      } else {
        videoObjectTrackingAnnotationBuilder_.setMessage(value);
      }
      valueTypeCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotation value for video object detection and tracking case.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation video_object_tracking_annotation = 5;
     * </code>
     */
    public Builder setVideoObjectTrackingAnnotation(
        com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation.Builder
            builderForValue) {
      if (videoObjectTrackingAnnotationBuilder_ == null) {
        valueType_ = builderForValue.build();
        onChanged();
      } else {
        videoObjectTrackingAnnotationBuilder_.setMessage(builderForValue.build());
      }
      valueTypeCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotation value for video object detection and tracking case.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation video_object_tracking_annotation = 5;
     * </code>
     */
    public Builder mergeVideoObjectTrackingAnnotation(
        com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation value) {
      if (videoObjectTrackingAnnotationBuilder_ == null) {
        if (valueTypeCase_ == 5
            && valueType_
                != com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation
                    .getDefaultInstance()) {
          valueType_ =
              com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation.newBuilder(
                      (com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation)
                          valueType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          valueType_ = value;
        }
        onChanged();
      } else {
        if (valueTypeCase_ == 5) {
          videoObjectTrackingAnnotationBuilder_.mergeFrom(value);
        } else {
          videoObjectTrackingAnnotationBuilder_.setMessage(value);
        }
      }
      valueTypeCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotation value for video object detection and tracking case.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation video_object_tracking_annotation = 5;
     * </code>
     */
    public Builder clearVideoObjectTrackingAnnotation() {
      if (videoObjectTrackingAnnotationBuilder_ == null) {
        if (valueTypeCase_ == 5) {
          valueTypeCase_ = 0;
          valueType_ = null;
          onChanged();
        }
      } else {
        if (valueTypeCase_ == 5) {
          valueTypeCase_ = 0;
          valueType_ = null;
        }
        videoObjectTrackingAnnotationBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotation value for video object detection and tracking case.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation video_object_tracking_annotation = 5;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation.Builder
        getVideoObjectTrackingAnnotationBuilder() {
      return getVideoObjectTrackingAnnotationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Annotation value for video object detection and tracking case.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation video_object_tracking_annotation = 5;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotationOrBuilder
        getVideoObjectTrackingAnnotationOrBuilder() {
      if ((valueTypeCase_ == 5) && (videoObjectTrackingAnnotationBuilder_ != null)) {
        return videoObjectTrackingAnnotationBuilder_.getMessageOrBuilder();
      } else {
        if (valueTypeCase_ == 5) {
          return (com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation) valueType_;
        }
        return com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Annotation value for video object detection and tracking case.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation video_object_tracking_annotation = 5;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation,
            com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation.Builder,
            com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotationOrBuilder>
        getVideoObjectTrackingAnnotationFieldBuilder() {
      if (videoObjectTrackingAnnotationBuilder_ == null) {
        if (!(valueTypeCase_ == 5)) {
          valueType_ =
              com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation
                  .getDefaultInstance();
        }
        videoObjectTrackingAnnotationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation,
                com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation.Builder,
                com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotationOrBuilder>(
                (com.google.cloud.datalabeling.v1beta1.VideoObjectTrackingAnnotation) valueType_,
                getParentForChildren(),
                isClean());
        valueType_ = null;
      }
      valueTypeCase_ = 5;
      onChanged();
      return videoObjectTrackingAnnotationBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.VideoEventAnnotation,
            com.google.cloud.datalabeling.v1beta1.VideoEventAnnotation.Builder,
            com.google.cloud.datalabeling.v1beta1.VideoEventAnnotationOrBuilder>
        videoEventAnnotationBuilder_;
    /**
     *
     *
     * <pre>
     * Annotation value for video event case.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.VideoEventAnnotation video_event_annotation = 6;
     * </code>
     *
     * @return Whether the videoEventAnnotation field is set.
     */
    @java.lang.Override
    public boolean hasVideoEventAnnotation() {
      return valueTypeCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * Annotation value for video event case.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.VideoEventAnnotation video_event_annotation = 6;
     * </code>
     *
     * @return The videoEventAnnotation.
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.VideoEventAnnotation getVideoEventAnnotation() {
      if (videoEventAnnotationBuilder_ == null) {
        if (valueTypeCase_ == 6) {
          return (com.google.cloud.datalabeling.v1beta1.VideoEventAnnotation) valueType_;
        }
        return com.google.cloud.datalabeling.v1beta1.VideoEventAnnotation.getDefaultInstance();
      } else {
        if (valueTypeCase_ == 6) {
          return videoEventAnnotationBuilder_.getMessage();
        }
        return com.google.cloud.datalabeling.v1beta1.VideoEventAnnotation.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Annotation value for video event case.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.VideoEventAnnotation video_event_annotation = 6;
     * </code>
     */
    public Builder setVideoEventAnnotation(
        com.google.cloud.datalabeling.v1beta1.VideoEventAnnotation value) {
      if (videoEventAnnotationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        valueType_ = value;
        onChanged();
      } else {
        videoEventAnnotationBuilder_.setMessage(value);
      }
      valueTypeCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotation value for video event case.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.VideoEventAnnotation video_event_annotation = 6;
     * </code>
     */
    public Builder setVideoEventAnnotation(
        com.google.cloud.datalabeling.v1beta1.VideoEventAnnotation.Builder builderForValue) {
      if (videoEventAnnotationBuilder_ == null) {
        valueType_ = builderForValue.build();
        onChanged();
      } else {
        videoEventAnnotationBuilder_.setMessage(builderForValue.build());
      }
      valueTypeCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotation value for video event case.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.VideoEventAnnotation video_event_annotation = 6;
     * </code>
     */
    public Builder mergeVideoEventAnnotation(
        com.google.cloud.datalabeling.v1beta1.VideoEventAnnotation value) {
      if (videoEventAnnotationBuilder_ == null) {
        if (valueTypeCase_ == 6
            && valueType_
                != com.google.cloud.datalabeling.v1beta1.VideoEventAnnotation
                    .getDefaultInstance()) {
          valueType_ =
              com.google.cloud.datalabeling.v1beta1.VideoEventAnnotation.newBuilder(
                      (com.google.cloud.datalabeling.v1beta1.VideoEventAnnotation) valueType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          valueType_ = value;
        }
        onChanged();
      } else {
        if (valueTypeCase_ == 6) {
          videoEventAnnotationBuilder_.mergeFrom(value);
        } else {
          videoEventAnnotationBuilder_.setMessage(value);
        }
      }
      valueTypeCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotation value for video event case.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.VideoEventAnnotation video_event_annotation = 6;
     * </code>
     */
    public Builder clearVideoEventAnnotation() {
      if (videoEventAnnotationBuilder_ == null) {
        if (valueTypeCase_ == 6) {
          valueTypeCase_ = 0;
          valueType_ = null;
          onChanged();
        }
      } else {
        if (valueTypeCase_ == 6) {
          valueTypeCase_ = 0;
          valueType_ = null;
        }
        videoEventAnnotationBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotation value for video event case.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.VideoEventAnnotation video_event_annotation = 6;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.VideoEventAnnotation.Builder
        getVideoEventAnnotationBuilder() {
      return getVideoEventAnnotationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Annotation value for video event case.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.VideoEventAnnotation video_event_annotation = 6;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.VideoEventAnnotationOrBuilder
        getVideoEventAnnotationOrBuilder() {
      if ((valueTypeCase_ == 6) && (videoEventAnnotationBuilder_ != null)) {
        return videoEventAnnotationBuilder_.getMessageOrBuilder();
      } else {
        if (valueTypeCase_ == 6) {
          return (com.google.cloud.datalabeling.v1beta1.VideoEventAnnotation) valueType_;
        }
        return com.google.cloud.datalabeling.v1beta1.VideoEventAnnotation.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Annotation value for video event case.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.VideoEventAnnotation video_event_annotation = 6;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.VideoEventAnnotation,
            com.google.cloud.datalabeling.v1beta1.VideoEventAnnotation.Builder,
            com.google.cloud.datalabeling.v1beta1.VideoEventAnnotationOrBuilder>
        getVideoEventAnnotationFieldBuilder() {
      if (videoEventAnnotationBuilder_ == null) {
        if (!(valueTypeCase_ == 6)) {
          valueType_ =
              com.google.cloud.datalabeling.v1beta1.VideoEventAnnotation.getDefaultInstance();
        }
        videoEventAnnotationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.VideoEventAnnotation,
                com.google.cloud.datalabeling.v1beta1.VideoEventAnnotation.Builder,
                com.google.cloud.datalabeling.v1beta1.VideoEventAnnotationOrBuilder>(
                (com.google.cloud.datalabeling.v1beta1.VideoEventAnnotation) valueType_,
                getParentForChildren(),
                isClean());
        valueType_ = null;
      }
      valueTypeCase_ = 6;
      onChanged();
      return videoEventAnnotationBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datalabeling.v1beta1.AnnotationValue)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datalabeling.v1beta1.AnnotationValue)
  private static final com.google.cloud.datalabeling.v1beta1.AnnotationValue DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datalabeling.v1beta1.AnnotationValue();
  }

  public static com.google.cloud.datalabeling.v1beta1.AnnotationValue getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AnnotationValue> PARSER =
      new com.google.protobuf.AbstractParser<AnnotationValue>() {
        @java.lang.Override
        public AnnotationValue parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AnnotationValue> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AnnotationValue> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.AnnotationValue getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
