/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datalabeling/v1beta1/evaluation.proto

package com.google.cloud.datalabeling.v1beta1;

/**
 *
 *
 * <pre>
 * Confusion matrix of the model running the classification. Only applicable
 * when the metrics entry aggregates multiple labels. Not applicable when the
 * entry is for a single label.
 * </pre>
 *
 * Protobuf type {@code google.cloud.datalabeling.v1beta1.ConfusionMatrix}
 */
public final class ConfusionMatrix extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datalabeling.v1beta1.ConfusionMatrix)
    ConfusionMatrixOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ConfusionMatrix.newBuilder() to construct.
  private ConfusionMatrix(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ConfusionMatrix() {
    row_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ConfusionMatrix();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datalabeling.v1beta1.EvaluationOuterClass
        .internal_static_google_cloud_datalabeling_v1beta1_ConfusionMatrix_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datalabeling.v1beta1.EvaluationOuterClass
        .internal_static_google_cloud_datalabeling_v1beta1_ConfusionMatrix_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.class,
            com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Builder.class);
  }

  public interface ConfusionMatrixEntryOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The annotation spec of a predicted label.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
     *
     * @return Whether the annotationSpec field is set.
     */
    boolean hasAnnotationSpec();
    /**
     *
     *
     * <pre>
     * The annotation spec of a predicted label.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
     *
     * @return The annotationSpec.
     */
    com.google.cloud.datalabeling.v1beta1.AnnotationSpec getAnnotationSpec();
    /**
     *
     *
     * <pre>
     * The annotation spec of a predicted label.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
     */
    com.google.cloud.datalabeling.v1beta1.AnnotationSpecOrBuilder getAnnotationSpecOrBuilder();

    /**
     *
     *
     * <pre>
     * Number of items predicted to have this label. (The ground truth label for
     * these items is the `Row.annotationSpec` of this entry's parent.)
     * </pre>
     *
     * <code>int32 item_count = 2;</code>
     *
     * @return The itemCount.
     */
    int getItemCount();
  }
  /**
   * Protobuf type {@code google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry}
   */
  public static final class ConfusionMatrixEntry extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry)
      ConfusionMatrixEntryOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ConfusionMatrixEntry.newBuilder() to construct.
    private ConfusionMatrixEntry(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ConfusionMatrixEntry() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ConfusionMatrixEntry();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datalabeling.v1beta1.EvaluationOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_ConfusionMatrix_ConfusionMatrixEntry_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datalabeling.v1beta1.EvaluationOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_ConfusionMatrix_ConfusionMatrixEntry_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry.class,
              com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry.Builder
                  .class);
    }

    public static final int ANNOTATION_SPEC_FIELD_NUMBER = 1;
    private com.google.cloud.datalabeling.v1beta1.AnnotationSpec annotationSpec_;
    /**
     *
     *
     * <pre>
     * The annotation spec of a predicted label.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
     *
     * @return Whether the annotationSpec field is set.
     */
    @java.lang.Override
    public boolean hasAnnotationSpec() {
      return annotationSpec_ != null;
    }
    /**
     *
     *
     * <pre>
     * The annotation spec of a predicted label.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
     *
     * @return The annotationSpec.
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.AnnotationSpec getAnnotationSpec() {
      return annotationSpec_ == null
          ? com.google.cloud.datalabeling.v1beta1.AnnotationSpec.getDefaultInstance()
          : annotationSpec_;
    }
    /**
     *
     *
     * <pre>
     * The annotation spec of a predicted label.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.AnnotationSpecOrBuilder
        getAnnotationSpecOrBuilder() {
      return annotationSpec_ == null
          ? com.google.cloud.datalabeling.v1beta1.AnnotationSpec.getDefaultInstance()
          : annotationSpec_;
    }

    public static final int ITEM_COUNT_FIELD_NUMBER = 2;
    private int itemCount_ = 0;
    /**
     *
     *
     * <pre>
     * Number of items predicted to have this label. (The ground truth label for
     * these items is the `Row.annotationSpec` of this entry's parent.)
     * </pre>
     *
     * <code>int32 item_count = 2;</code>
     *
     * @return The itemCount.
     */
    @java.lang.Override
    public int getItemCount() {
      return itemCount_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (annotationSpec_ != null) {
        output.writeMessage(1, getAnnotationSpec());
      }
      if (itemCount_ != 0) {
        output.writeInt32(2, itemCount_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (annotationSpec_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getAnnotationSpec());
      }
      if (itemCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, itemCount_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry)) {
        return super.equals(obj);
      }
      com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry other =
          (com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry) obj;

      if (hasAnnotationSpec() != other.hasAnnotationSpec()) return false;
      if (hasAnnotationSpec()) {
        if (!getAnnotationSpec().equals(other.getAnnotationSpec())) return false;
      }
      if (getItemCount() != other.getItemCount()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasAnnotationSpec()) {
        hash = (37 * hash) + ANNOTATION_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getAnnotationSpec().hashCode();
      }
      hash = (37 * hash) + ITEM_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getItemCount();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry)
        com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntryOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.datalabeling.v1beta1.EvaluationOuterClass
            .internal_static_google_cloud_datalabeling_v1beta1_ConfusionMatrix_ConfusionMatrixEntry_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.datalabeling.v1beta1.EvaluationOuterClass
            .internal_static_google_cloud_datalabeling_v1beta1_ConfusionMatrix_ConfusionMatrixEntry_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry.class,
                com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        annotationSpec_ = null;
        if (annotationSpecBuilder_ != null) {
          annotationSpecBuilder_.dispose();
          annotationSpecBuilder_ = null;
        }
        itemCount_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.datalabeling.v1beta1.EvaluationOuterClass
            .internal_static_google_cloud_datalabeling_v1beta1_ConfusionMatrix_ConfusionMatrixEntry_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry
          getDefaultInstanceForType() {
        return com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry build() {
        com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry
          buildPartial() {
        com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry result =
            new com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.annotationSpec_ =
              annotationSpecBuilder_ == null ? annotationSpec_ : annotationSpecBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.itemCount_ = itemCount_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry) {
          return mergeFrom(
              (com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry other) {
        if (other
            == com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry
                .getDefaultInstance()) return this;
        if (other.hasAnnotationSpec()) {
          mergeAnnotationSpec(other.getAnnotationSpec());
        }
        if (other.getItemCount() != 0) {
          setItemCount(other.getItemCount());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getAnnotationSpecFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  itemCount_ = input.readInt32();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.datalabeling.v1beta1.AnnotationSpec annotationSpec_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.datalabeling.v1beta1.AnnotationSpec,
              com.google.cloud.datalabeling.v1beta1.AnnotationSpec.Builder,
              com.google.cloud.datalabeling.v1beta1.AnnotationSpecOrBuilder>
          annotationSpecBuilder_;
      /**
       *
       *
       * <pre>
       * The annotation spec of a predicted label.
       * </pre>
       *
       * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
       *
       * @return Whether the annotationSpec field is set.
       */
      public boolean hasAnnotationSpec() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * The annotation spec of a predicted label.
       * </pre>
       *
       * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
       *
       * @return The annotationSpec.
       */
      public com.google.cloud.datalabeling.v1beta1.AnnotationSpec getAnnotationSpec() {
        if (annotationSpecBuilder_ == null) {
          return annotationSpec_ == null
              ? com.google.cloud.datalabeling.v1beta1.AnnotationSpec.getDefaultInstance()
              : annotationSpec_;
        } else {
          return annotationSpecBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The annotation spec of a predicted label.
       * </pre>
       *
       * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
       */
      public Builder setAnnotationSpec(com.google.cloud.datalabeling.v1beta1.AnnotationSpec value) {
        if (annotationSpecBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          annotationSpec_ = value;
        } else {
          annotationSpecBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The annotation spec of a predicted label.
       * </pre>
       *
       * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
       */
      public Builder setAnnotationSpec(
          com.google.cloud.datalabeling.v1beta1.AnnotationSpec.Builder builderForValue) {
        if (annotationSpecBuilder_ == null) {
          annotationSpec_ = builderForValue.build();
        } else {
          annotationSpecBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The annotation spec of a predicted label.
       * </pre>
       *
       * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
       */
      public Builder mergeAnnotationSpec(
          com.google.cloud.datalabeling.v1beta1.AnnotationSpec value) {
        if (annotationSpecBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && annotationSpec_ != null
              && annotationSpec_
                  != com.google.cloud.datalabeling.v1beta1.AnnotationSpec.getDefaultInstance()) {
            getAnnotationSpecBuilder().mergeFrom(value);
          } else {
            annotationSpec_ = value;
          }
        } else {
          annotationSpecBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The annotation spec of a predicted label.
       * </pre>
       *
       * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
       */
      public Builder clearAnnotationSpec() {
        bitField0_ = (bitField0_ & ~0x00000001);
        annotationSpec_ = null;
        if (annotationSpecBuilder_ != null) {
          annotationSpecBuilder_.dispose();
          annotationSpecBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The annotation spec of a predicted label.
       * </pre>
       *
       * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
       */
      public com.google.cloud.datalabeling.v1beta1.AnnotationSpec.Builder
          getAnnotationSpecBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getAnnotationSpecFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The annotation spec of a predicted label.
       * </pre>
       *
       * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
       */
      public com.google.cloud.datalabeling.v1beta1.AnnotationSpecOrBuilder
          getAnnotationSpecOrBuilder() {
        if (annotationSpecBuilder_ != null) {
          return annotationSpecBuilder_.getMessageOrBuilder();
        } else {
          return annotationSpec_ == null
              ? com.google.cloud.datalabeling.v1beta1.AnnotationSpec.getDefaultInstance()
              : annotationSpec_;
        }
      }
      /**
       *
       *
       * <pre>
       * The annotation spec of a predicted label.
       * </pre>
       *
       * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.datalabeling.v1beta1.AnnotationSpec,
              com.google.cloud.datalabeling.v1beta1.AnnotationSpec.Builder,
              com.google.cloud.datalabeling.v1beta1.AnnotationSpecOrBuilder>
          getAnnotationSpecFieldBuilder() {
        if (annotationSpecBuilder_ == null) {
          annotationSpecBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.datalabeling.v1beta1.AnnotationSpec,
                  com.google.cloud.datalabeling.v1beta1.AnnotationSpec.Builder,
                  com.google.cloud.datalabeling.v1beta1.AnnotationSpecOrBuilder>(
                  getAnnotationSpec(), getParentForChildren(), isClean());
          annotationSpec_ = null;
        }
        return annotationSpecBuilder_;
      }

      private int itemCount_;
      /**
       *
       *
       * <pre>
       * Number of items predicted to have this label. (The ground truth label for
       * these items is the `Row.annotationSpec` of this entry's parent.)
       * </pre>
       *
       * <code>int32 item_count = 2;</code>
       *
       * @return The itemCount.
       */
      @java.lang.Override
      public int getItemCount() {
        return itemCount_;
      }
      /**
       *
       *
       * <pre>
       * Number of items predicted to have this label. (The ground truth label for
       * these items is the `Row.annotationSpec` of this entry's parent.)
       * </pre>
       *
       * <code>int32 item_count = 2;</code>
       *
       * @param value The itemCount to set.
       * @return This builder for chaining.
       */
      public Builder setItemCount(int value) {

        itemCount_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Number of items predicted to have this label. (The ground truth label for
       * these items is the `Row.annotationSpec` of this entry's parent.)
       * </pre>
       *
       * <code>int32 item_count = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearItemCount() {
        bitField0_ = (bitField0_ & ~0x00000002);
        itemCount_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry)
    private static final com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry();
    }

    public static com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ConfusionMatrixEntry> PARSER =
        new com.google.protobuf.AbstractParser<ConfusionMatrixEntry>() {
          @java.lang.Override
          public ConfusionMatrixEntry parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ConfusionMatrixEntry> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ConfusionMatrixEntry> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface RowOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The annotation spec of the ground truth label for this row.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
     *
     * @return Whether the annotationSpec field is set.
     */
    boolean hasAnnotationSpec();
    /**
     *
     *
     * <pre>
     * The annotation spec of the ground truth label for this row.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
     *
     * @return The annotationSpec.
     */
    com.google.cloud.datalabeling.v1beta1.AnnotationSpec getAnnotationSpec();
    /**
     *
     *
     * <pre>
     * The annotation spec of the ground truth label for this row.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
     */
    com.google.cloud.datalabeling.v1beta1.AnnotationSpecOrBuilder getAnnotationSpecOrBuilder();

    /**
     *
     *
     * <pre>
     * A list of the confusion matrix entries. One entry for each possible
     * predicted label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry entries = 2;
     * </code>
     */
    java.util.List<com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry>
        getEntriesList();
    /**
     *
     *
     * <pre>
     * A list of the confusion matrix entries. One entry for each possible
     * predicted label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry entries = 2;
     * </code>
     */
    com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry getEntries(
        int index);
    /**
     *
     *
     * <pre>
     * A list of the confusion matrix entries. One entry for each possible
     * predicted label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry entries = 2;
     * </code>
     */
    int getEntriesCount();
    /**
     *
     *
     * <pre>
     * A list of the confusion matrix entries. One entry for each possible
     * predicted label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry entries = 2;
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntryOrBuilder>
        getEntriesOrBuilderList();
    /**
     *
     *
     * <pre>
     * A list of the confusion matrix entries. One entry for each possible
     * predicted label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry entries = 2;
     * </code>
     */
    com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntryOrBuilder
        getEntriesOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * A row in the confusion matrix. Each entry in this row has the same
   * ground truth label.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row}
   */
  public static final class Row extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row)
      RowOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Row.newBuilder() to construct.
    private Row(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Row() {
      entries_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Row();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datalabeling.v1beta1.EvaluationOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_ConfusionMatrix_Row_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datalabeling.v1beta1.EvaluationOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_ConfusionMatrix_Row_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row.class,
              com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row.Builder.class);
    }

    public static final int ANNOTATION_SPEC_FIELD_NUMBER = 1;
    private com.google.cloud.datalabeling.v1beta1.AnnotationSpec annotationSpec_;
    /**
     *
     *
     * <pre>
     * The annotation spec of the ground truth label for this row.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
     *
     * @return Whether the annotationSpec field is set.
     */
    @java.lang.Override
    public boolean hasAnnotationSpec() {
      return annotationSpec_ != null;
    }
    /**
     *
     *
     * <pre>
     * The annotation spec of the ground truth label for this row.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
     *
     * @return The annotationSpec.
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.AnnotationSpec getAnnotationSpec() {
      return annotationSpec_ == null
          ? com.google.cloud.datalabeling.v1beta1.AnnotationSpec.getDefaultInstance()
          : annotationSpec_;
    }
    /**
     *
     *
     * <pre>
     * The annotation spec of the ground truth label for this row.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.AnnotationSpecOrBuilder
        getAnnotationSpecOrBuilder() {
      return annotationSpec_ == null
          ? com.google.cloud.datalabeling.v1beta1.AnnotationSpec.getDefaultInstance()
          : annotationSpec_;
    }

    public static final int ENTRIES_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private java.util.List<
            com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry>
        entries_;
    /**
     *
     *
     * <pre>
     * A list of the confusion matrix entries. One entry for each possible
     * predicted label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry entries = 2;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry>
        getEntriesList() {
      return entries_;
    }
    /**
     *
     *
     * <pre>
     * A list of the confusion matrix entries. One entry for each possible
     * predicted label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry entries = 2;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntryOrBuilder>
        getEntriesOrBuilderList() {
      return entries_;
    }
    /**
     *
     *
     * <pre>
     * A list of the confusion matrix entries. One entry for each possible
     * predicted label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry entries = 2;
     * </code>
     */
    @java.lang.Override
    public int getEntriesCount() {
      return entries_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of the confusion matrix entries. One entry for each possible
     * predicted label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry entries = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry getEntries(
        int index) {
      return entries_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of the confusion matrix entries. One entry for each possible
     * predicted label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry entries = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntryOrBuilder
        getEntriesOrBuilder(int index) {
      return entries_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (annotationSpec_ != null) {
        output.writeMessage(1, getAnnotationSpec());
      }
      for (int i = 0; i < entries_.size(); i++) {
        output.writeMessage(2, entries_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (annotationSpec_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getAnnotationSpec());
      }
      for (int i = 0; i < entries_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, entries_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row)) {
        return super.equals(obj);
      }
      com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row other =
          (com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row) obj;

      if (hasAnnotationSpec() != other.hasAnnotationSpec()) return false;
      if (hasAnnotationSpec()) {
        if (!getAnnotationSpec().equals(other.getAnnotationSpec())) return false;
      }
      if (!getEntriesList().equals(other.getEntriesList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasAnnotationSpec()) {
        hash = (37 * hash) + ANNOTATION_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getAnnotationSpec().hashCode();
      }
      if (getEntriesCount() > 0) {
        hash = (37 * hash) + ENTRIES_FIELD_NUMBER;
        hash = (53 * hash) + getEntriesList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A row in the confusion matrix. Each entry in this row has the same
     * ground truth label.
     * </pre>
     *
     * Protobuf type {@code google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row)
        com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.RowOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.datalabeling.v1beta1.EvaluationOuterClass
            .internal_static_google_cloud_datalabeling_v1beta1_ConfusionMatrix_Row_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.datalabeling.v1beta1.EvaluationOuterClass
            .internal_static_google_cloud_datalabeling_v1beta1_ConfusionMatrix_Row_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row.class,
                com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row.Builder.class);
      }

      // Construct using com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        annotationSpec_ = null;
        if (annotationSpecBuilder_ != null) {
          annotationSpecBuilder_.dispose();
          annotationSpecBuilder_ = null;
        }
        if (entriesBuilder_ == null) {
          entries_ = java.util.Collections.emptyList();
        } else {
          entries_ = null;
          entriesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.datalabeling.v1beta1.EvaluationOuterClass
            .internal_static_google_cloud_datalabeling_v1beta1_ConfusionMatrix_Row_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row getDefaultInstanceForType() {
        return com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row build() {
        com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row buildPartial() {
        com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row result =
            new com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row result) {
        if (entriesBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            entries_ = java.util.Collections.unmodifiableList(entries_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.entries_ = entries_;
        } else {
          result.entries_ = entriesBuilder_.build();
        }
      }

      private void buildPartial0(com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.annotationSpec_ =
              annotationSpecBuilder_ == null ? annotationSpec_ : annotationSpecBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row) {
          return mergeFrom((com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row other) {
        if (other == com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row.getDefaultInstance())
          return this;
        if (other.hasAnnotationSpec()) {
          mergeAnnotationSpec(other.getAnnotationSpec());
        }
        if (entriesBuilder_ == null) {
          if (!other.entries_.isEmpty()) {
            if (entries_.isEmpty()) {
              entries_ = other.entries_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureEntriesIsMutable();
              entries_.addAll(other.entries_);
            }
            onChanged();
          }
        } else {
          if (!other.entries_.isEmpty()) {
            if (entriesBuilder_.isEmpty()) {
              entriesBuilder_.dispose();
              entriesBuilder_ = null;
              entries_ = other.entries_;
              bitField0_ = (bitField0_ & ~0x00000002);
              entriesBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getEntriesFieldBuilder()
                      : null;
            } else {
              entriesBuilder_.addAllMessages(other.entries_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getAnnotationSpecFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry m =
                      input.readMessage(
                          com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry
                              .parser(),
                          extensionRegistry);
                  if (entriesBuilder_ == null) {
                    ensureEntriesIsMutable();
                    entries_.add(m);
                  } else {
                    entriesBuilder_.addMessage(m);
                  }
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.datalabeling.v1beta1.AnnotationSpec annotationSpec_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.datalabeling.v1beta1.AnnotationSpec,
              com.google.cloud.datalabeling.v1beta1.AnnotationSpec.Builder,
              com.google.cloud.datalabeling.v1beta1.AnnotationSpecOrBuilder>
          annotationSpecBuilder_;
      /**
       *
       *
       * <pre>
       * The annotation spec of the ground truth label for this row.
       * </pre>
       *
       * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
       *
       * @return Whether the annotationSpec field is set.
       */
      public boolean hasAnnotationSpec() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * The annotation spec of the ground truth label for this row.
       * </pre>
       *
       * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
       *
       * @return The annotationSpec.
       */
      public com.google.cloud.datalabeling.v1beta1.AnnotationSpec getAnnotationSpec() {
        if (annotationSpecBuilder_ == null) {
          return annotationSpec_ == null
              ? com.google.cloud.datalabeling.v1beta1.AnnotationSpec.getDefaultInstance()
              : annotationSpec_;
        } else {
          return annotationSpecBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The annotation spec of the ground truth label for this row.
       * </pre>
       *
       * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
       */
      public Builder setAnnotationSpec(com.google.cloud.datalabeling.v1beta1.AnnotationSpec value) {
        if (annotationSpecBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          annotationSpec_ = value;
        } else {
          annotationSpecBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The annotation spec of the ground truth label for this row.
       * </pre>
       *
       * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
       */
      public Builder setAnnotationSpec(
          com.google.cloud.datalabeling.v1beta1.AnnotationSpec.Builder builderForValue) {
        if (annotationSpecBuilder_ == null) {
          annotationSpec_ = builderForValue.build();
        } else {
          annotationSpecBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The annotation spec of the ground truth label for this row.
       * </pre>
       *
       * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
       */
      public Builder mergeAnnotationSpec(
          com.google.cloud.datalabeling.v1beta1.AnnotationSpec value) {
        if (annotationSpecBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && annotationSpec_ != null
              && annotationSpec_
                  != com.google.cloud.datalabeling.v1beta1.AnnotationSpec.getDefaultInstance()) {
            getAnnotationSpecBuilder().mergeFrom(value);
          } else {
            annotationSpec_ = value;
          }
        } else {
          annotationSpecBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The annotation spec of the ground truth label for this row.
       * </pre>
       *
       * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
       */
      public Builder clearAnnotationSpec() {
        bitField0_ = (bitField0_ & ~0x00000001);
        annotationSpec_ = null;
        if (annotationSpecBuilder_ != null) {
          annotationSpecBuilder_.dispose();
          annotationSpecBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The annotation spec of the ground truth label for this row.
       * </pre>
       *
       * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
       */
      public com.google.cloud.datalabeling.v1beta1.AnnotationSpec.Builder
          getAnnotationSpecBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getAnnotationSpecFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The annotation spec of the ground truth label for this row.
       * </pre>
       *
       * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
       */
      public com.google.cloud.datalabeling.v1beta1.AnnotationSpecOrBuilder
          getAnnotationSpecOrBuilder() {
        if (annotationSpecBuilder_ != null) {
          return annotationSpecBuilder_.getMessageOrBuilder();
        } else {
          return annotationSpec_ == null
              ? com.google.cloud.datalabeling.v1beta1.AnnotationSpec.getDefaultInstance()
              : annotationSpec_;
        }
      }
      /**
       *
       *
       * <pre>
       * The annotation spec of the ground truth label for this row.
       * </pre>
       *
       * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.datalabeling.v1beta1.AnnotationSpec,
              com.google.cloud.datalabeling.v1beta1.AnnotationSpec.Builder,
              com.google.cloud.datalabeling.v1beta1.AnnotationSpecOrBuilder>
          getAnnotationSpecFieldBuilder() {
        if (annotationSpecBuilder_ == null) {
          annotationSpecBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.datalabeling.v1beta1.AnnotationSpec,
                  com.google.cloud.datalabeling.v1beta1.AnnotationSpec.Builder,
                  com.google.cloud.datalabeling.v1beta1.AnnotationSpecOrBuilder>(
                  getAnnotationSpec(), getParentForChildren(), isClean());
          annotationSpec_ = null;
        }
        return annotationSpecBuilder_;
      }

      private java.util.List<
              com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry>
          entries_ = java.util.Collections.emptyList();

      private void ensureEntriesIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          entries_ =
              new java.util.ArrayList<
                  com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry>(
                  entries_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry,
              com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry.Builder,
              com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntryOrBuilder>
          entriesBuilder_;

      /**
       *
       *
       * <pre>
       * A list of the confusion matrix entries. One entry for each possible
       * predicted label.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry entries = 2;
       * </code>
       */
      public java.util.List<
              com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry>
          getEntriesList() {
        if (entriesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(entries_);
        } else {
          return entriesBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * A list of the confusion matrix entries. One entry for each possible
       * predicted label.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry entries = 2;
       * </code>
       */
      public int getEntriesCount() {
        if (entriesBuilder_ == null) {
          return entries_.size();
        } else {
          return entriesBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * A list of the confusion matrix entries. One entry for each possible
       * predicted label.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry entries = 2;
       * </code>
       */
      public com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry getEntries(
          int index) {
        if (entriesBuilder_ == null) {
          return entries_.get(index);
        } else {
          return entriesBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of the confusion matrix entries. One entry for each possible
       * predicted label.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry entries = 2;
       * </code>
       */
      public Builder setEntries(
          int index,
          com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry value) {
        if (entriesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureEntriesIsMutable();
          entries_.set(index, value);
          onChanged();
        } else {
          entriesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of the confusion matrix entries. One entry for each possible
       * predicted label.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry entries = 2;
       * </code>
       */
      public Builder setEntries(
          int index,
          com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry.Builder
              builderForValue) {
        if (entriesBuilder_ == null) {
          ensureEntriesIsMutable();
          entries_.set(index, builderForValue.build());
          onChanged();
        } else {
          entriesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of the confusion matrix entries. One entry for each possible
       * predicted label.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry entries = 2;
       * </code>
       */
      public Builder addEntries(
          com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry value) {
        if (entriesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureEntriesIsMutable();
          entries_.add(value);
          onChanged();
        } else {
          entriesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of the confusion matrix entries. One entry for each possible
       * predicted label.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry entries = 2;
       * </code>
       */
      public Builder addEntries(
          int index,
          com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry value) {
        if (entriesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureEntriesIsMutable();
          entries_.add(index, value);
          onChanged();
        } else {
          entriesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of the confusion matrix entries. One entry for each possible
       * predicted label.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry entries = 2;
       * </code>
       */
      public Builder addEntries(
          com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry.Builder
              builderForValue) {
        if (entriesBuilder_ == null) {
          ensureEntriesIsMutable();
          entries_.add(builderForValue.build());
          onChanged();
        } else {
          entriesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of the confusion matrix entries. One entry for each possible
       * predicted label.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry entries = 2;
       * </code>
       */
      public Builder addEntries(
          int index,
          com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry.Builder
              builderForValue) {
        if (entriesBuilder_ == null) {
          ensureEntriesIsMutable();
          entries_.add(index, builderForValue.build());
          onChanged();
        } else {
          entriesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of the confusion matrix entries. One entry for each possible
       * predicted label.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry entries = 2;
       * </code>
       */
      public Builder addAllEntries(
          java.lang.Iterable<
                  ? extends
                      com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry>
              values) {
        if (entriesBuilder_ == null) {
          ensureEntriesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, entries_);
          onChanged();
        } else {
          entriesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of the confusion matrix entries. One entry for each possible
       * predicted label.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry entries = 2;
       * </code>
       */
      public Builder clearEntries() {
        if (entriesBuilder_ == null) {
          entries_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          entriesBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of the confusion matrix entries. One entry for each possible
       * predicted label.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry entries = 2;
       * </code>
       */
      public Builder removeEntries(int index) {
        if (entriesBuilder_ == null) {
          ensureEntriesIsMutable();
          entries_.remove(index);
          onChanged();
        } else {
          entriesBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of the confusion matrix entries. One entry for each possible
       * predicted label.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry entries = 2;
       * </code>
       */
      public com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry.Builder
          getEntriesBuilder(int index) {
        return getEntriesFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * A list of the confusion matrix entries. One entry for each possible
       * predicted label.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry entries = 2;
       * </code>
       */
      public com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntryOrBuilder
          getEntriesOrBuilder(int index) {
        if (entriesBuilder_ == null) {
          return entries_.get(index);
        } else {
          return entriesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of the confusion matrix entries. One entry for each possible
       * predicted label.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry entries = 2;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.datalabeling.v1beta1.ConfusionMatrix
                      .ConfusionMatrixEntryOrBuilder>
          getEntriesOrBuilderList() {
        if (entriesBuilder_ != null) {
          return entriesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(entries_);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of the confusion matrix entries. One entry for each possible
       * predicted label.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry entries = 2;
       * </code>
       */
      public com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry.Builder
          addEntriesBuilder() {
        return getEntriesFieldBuilder()
            .addBuilder(
                com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * A list of the confusion matrix entries. One entry for each possible
       * predicted label.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry entries = 2;
       * </code>
       */
      public com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry.Builder
          addEntriesBuilder(int index) {
        return getEntriesFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * A list of the confusion matrix entries. One entry for each possible
       * predicted label.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry entries = 2;
       * </code>
       */
      public java.util.List<
              com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry.Builder>
          getEntriesBuilderList() {
        return getEntriesFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry,
              com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry.Builder,
              com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntryOrBuilder>
          getEntriesFieldBuilder() {
        if (entriesBuilder_ == null) {
          entriesBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry,
                  com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry
                      .Builder,
                  com.google.cloud.datalabeling.v1beta1.ConfusionMatrix
                      .ConfusionMatrixEntryOrBuilder>(
                  entries_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
          entries_ = null;
        }
        return entriesBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row)
    private static final com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row();
    }

    public static com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Row> PARSER =
        new com.google.protobuf.AbstractParser<Row>() {
          @java.lang.Override
          public Row parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Row> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Row> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int ROW_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row> row_;
  /** <code>repeated .google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row row = 1;</code> */
  @java.lang.Override
  public java.util.List<com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row> getRowList() {
    return row_;
  }
  /** <code>repeated .google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row row = 1;</code> */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.RowOrBuilder>
      getRowOrBuilderList() {
    return row_;
  }
  /** <code>repeated .google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row row = 1;</code> */
  @java.lang.Override
  public int getRowCount() {
    return row_.size();
  }
  /** <code>repeated .google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row row = 1;</code> */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row getRow(int index) {
    return row_.get(index);
  }
  /** <code>repeated .google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row row = 1;</code> */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.RowOrBuilder getRowOrBuilder(
      int index) {
    return row_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < row_.size(); i++) {
      output.writeMessage(1, row_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < row_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, row_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datalabeling.v1beta1.ConfusionMatrix)) {
      return super.equals(obj);
    }
    com.google.cloud.datalabeling.v1beta1.ConfusionMatrix other =
        (com.google.cloud.datalabeling.v1beta1.ConfusionMatrix) obj;

    if (!getRowList().equals(other.getRowList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getRowCount() > 0) {
      hash = (37 * hash) + ROW_FIELD_NUMBER;
      hash = (53 * hash) + getRowList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datalabeling.v1beta1.ConfusionMatrix parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.ConfusionMatrix parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.ConfusionMatrix parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.ConfusionMatrix parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.ConfusionMatrix parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.ConfusionMatrix parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.ConfusionMatrix parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.ConfusionMatrix parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.ConfusionMatrix parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.ConfusionMatrix parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.ConfusionMatrix parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.ConfusionMatrix parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.datalabeling.v1beta1.ConfusionMatrix prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Confusion matrix of the model running the classification. Only applicable
   * when the metrics entry aggregates multiple labels. Not applicable when the
   * entry is for a single label.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datalabeling.v1beta1.ConfusionMatrix}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datalabeling.v1beta1.ConfusionMatrix)
      com.google.cloud.datalabeling.v1beta1.ConfusionMatrixOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datalabeling.v1beta1.EvaluationOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_ConfusionMatrix_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datalabeling.v1beta1.EvaluationOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_ConfusionMatrix_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.class,
              com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Builder.class);
    }

    // Construct using com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (rowBuilder_ == null) {
        row_ = java.util.Collections.emptyList();
      } else {
        row_ = null;
        rowBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datalabeling.v1beta1.EvaluationOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_ConfusionMatrix_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.ConfusionMatrix getDefaultInstanceForType() {
      return com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.ConfusionMatrix build() {
      com.google.cloud.datalabeling.v1beta1.ConfusionMatrix result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.ConfusionMatrix buildPartial() {
      com.google.cloud.datalabeling.v1beta1.ConfusionMatrix result =
          new com.google.cloud.datalabeling.v1beta1.ConfusionMatrix(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.datalabeling.v1beta1.ConfusionMatrix result) {
      if (rowBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          row_ = java.util.Collections.unmodifiableList(row_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.row_ = row_;
      } else {
        result.row_ = rowBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.datalabeling.v1beta1.ConfusionMatrix result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datalabeling.v1beta1.ConfusionMatrix) {
        return mergeFrom((com.google.cloud.datalabeling.v1beta1.ConfusionMatrix) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datalabeling.v1beta1.ConfusionMatrix other) {
      if (other == com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.getDefaultInstance())
        return this;
      if (rowBuilder_ == null) {
        if (!other.row_.isEmpty()) {
          if (row_.isEmpty()) {
            row_ = other.row_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureRowIsMutable();
            row_.addAll(other.row_);
          }
          onChanged();
        }
      } else {
        if (!other.row_.isEmpty()) {
          if (rowBuilder_.isEmpty()) {
            rowBuilder_.dispose();
            rowBuilder_ = null;
            row_ = other.row_;
            bitField0_ = (bitField0_ & ~0x00000001);
            rowBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getRowFieldBuilder()
                    : null;
          } else {
            rowBuilder_.addAllMessages(other.row_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row m =
                    input.readMessage(
                        com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row.parser(),
                        extensionRegistry);
                if (rowBuilder_ == null) {
                  ensureRowIsMutable();
                  row_.add(m);
                } else {
                  rowBuilder_.addMessage(m);
                }
                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row> row_ =
        java.util.Collections.emptyList();

    private void ensureRowIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        row_ =
            new java.util.ArrayList<com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row>(
                row_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row,
            com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row.Builder,
            com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.RowOrBuilder>
        rowBuilder_;

    /** <code>repeated .google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row row = 1;</code> */
    public java.util.List<com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row> getRowList() {
      if (rowBuilder_ == null) {
        return java.util.Collections.unmodifiableList(row_);
      } else {
        return rowBuilder_.getMessageList();
      }
    }
    /** <code>repeated .google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row row = 1;</code> */
    public int getRowCount() {
      if (rowBuilder_ == null) {
        return row_.size();
      } else {
        return rowBuilder_.getCount();
      }
    }
    /** <code>repeated .google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row row = 1;</code> */
    public com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row getRow(int index) {
      if (rowBuilder_ == null) {
        return row_.get(index);
      } else {
        return rowBuilder_.getMessage(index);
      }
    }
    /** <code>repeated .google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row row = 1;</code> */
    public Builder setRow(
        int index, com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row value) {
      if (rowBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRowIsMutable();
        row_.set(index, value);
        onChanged();
      } else {
        rowBuilder_.setMessage(index, value);
      }
      return this;
    }
    /** <code>repeated .google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row row = 1;</code> */
    public Builder setRow(
        int index,
        com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row.Builder builderForValue) {
      if (rowBuilder_ == null) {
        ensureRowIsMutable();
        row_.set(index, builderForValue.build());
        onChanged();
      } else {
        rowBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /** <code>repeated .google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row row = 1;</code> */
    public Builder addRow(com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row value) {
      if (rowBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRowIsMutable();
        row_.add(value);
        onChanged();
      } else {
        rowBuilder_.addMessage(value);
      }
      return this;
    }
    /** <code>repeated .google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row row = 1;</code> */
    public Builder addRow(
        int index, com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row value) {
      if (rowBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRowIsMutable();
        row_.add(index, value);
        onChanged();
      } else {
        rowBuilder_.addMessage(index, value);
      }
      return this;
    }
    /** <code>repeated .google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row row = 1;</code> */
    public Builder addRow(
        com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row.Builder builderForValue) {
      if (rowBuilder_ == null) {
        ensureRowIsMutable();
        row_.add(builderForValue.build());
        onChanged();
      } else {
        rowBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /** <code>repeated .google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row row = 1;</code> */
    public Builder addRow(
        int index,
        com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row.Builder builderForValue) {
      if (rowBuilder_ == null) {
        ensureRowIsMutable();
        row_.add(index, builderForValue.build());
        onChanged();
      } else {
        rowBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /** <code>repeated .google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row row = 1;</code> */
    public Builder addAllRow(
        java.lang.Iterable<? extends com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row>
            values) {
      if (rowBuilder_ == null) {
        ensureRowIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, row_);
        onChanged();
      } else {
        rowBuilder_.addAllMessages(values);
      }
      return this;
    }
    /** <code>repeated .google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row row = 1;</code> */
    public Builder clearRow() {
      if (rowBuilder_ == null) {
        row_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        rowBuilder_.clear();
      }
      return this;
    }
    /** <code>repeated .google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row row = 1;</code> */
    public Builder removeRow(int index) {
      if (rowBuilder_ == null) {
        ensureRowIsMutable();
        row_.remove(index);
        onChanged();
      } else {
        rowBuilder_.remove(index);
      }
      return this;
    }
    /** <code>repeated .google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row row = 1;</code> */
    public com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row.Builder getRowBuilder(
        int index) {
      return getRowFieldBuilder().getBuilder(index);
    }
    /** <code>repeated .google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row row = 1;</code> */
    public com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.RowOrBuilder getRowOrBuilder(
        int index) {
      if (rowBuilder_ == null) {
        return row_.get(index);
      } else {
        return rowBuilder_.getMessageOrBuilder(index);
      }
    }
    /** <code>repeated .google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row row = 1;</code> */
    public java.util.List<
            ? extends com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.RowOrBuilder>
        getRowOrBuilderList() {
      if (rowBuilder_ != null) {
        return rowBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(row_);
      }
    }
    /** <code>repeated .google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row row = 1;</code> */
    public com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row.Builder addRowBuilder() {
      return getRowFieldBuilder()
          .addBuilder(
              com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row.getDefaultInstance());
    }
    /** <code>repeated .google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row row = 1;</code> */
    public com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row.Builder addRowBuilder(
        int index) {
      return getRowFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row.getDefaultInstance());
    }
    /** <code>repeated .google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row row = 1;</code> */
    public java.util.List<com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row.Builder>
        getRowBuilderList() {
      return getRowFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row,
            com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row.Builder,
            com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.RowOrBuilder>
        getRowFieldBuilder() {
      if (rowBuilder_ == null) {
        rowBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row,
                com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row.Builder,
                com.google.cloud.datalabeling.v1beta1.ConfusionMatrix.RowOrBuilder>(
                row_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        row_ = null;
      }
      return rowBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datalabeling.v1beta1.ConfusionMatrix)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datalabeling.v1beta1.ConfusionMatrix)
  private static final com.google.cloud.datalabeling.v1beta1.ConfusionMatrix DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datalabeling.v1beta1.ConfusionMatrix();
  }

  public static com.google.cloud.datalabeling.v1beta1.ConfusionMatrix getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ConfusionMatrix> PARSER =
      new com.google.protobuf.AbstractParser<ConfusionMatrix>() {
        @java.lang.Override
        public ConfusionMatrix parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ConfusionMatrix> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ConfusionMatrix> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.ConfusionMatrix getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
