/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datalabeling/v1beta1/evaluation.proto

package com.google.cloud.datalabeling.v1beta1;

/**
 *
 *
 * <pre>
 * Describes an evaluation between a machine learning model's predictions and
 * ground truth labels. Created when an [EvaluationJob][google.cloud.datalabeling.v1beta1.EvaluationJob] runs successfully.
 * </pre>
 *
 * Protobuf type {@code google.cloud.datalabeling.v1beta1.Evaluation}
 */
public final class Evaluation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datalabeling.v1beta1.Evaluation)
    EvaluationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Evaluation.newBuilder() to construct.
  private Evaluation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Evaluation() {
    name_ = "";
    annotationType_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Evaluation();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datalabeling.v1beta1.EvaluationOuterClass
        .internal_static_google_cloud_datalabeling_v1beta1_Evaluation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datalabeling.v1beta1.EvaluationOuterClass
        .internal_static_google_cloud_datalabeling_v1beta1_Evaluation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datalabeling.v1beta1.Evaluation.class,
            com.google.cloud.datalabeling.v1beta1.Evaluation.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Resource name of an evaluation. The name has the following
   * format:
   *
   * "projects/&lt;var&gt;{project_id}&lt;/var&gt;/datasets/&lt;var&gt;{dataset_id}&lt;/var&gt;/evaluations/&lt;var&gt;{evaluation_id&lt;/var&gt;}'
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Resource name of an evaluation. The name has the following
   * format:
   *
   * "projects/&lt;var&gt;{project_id}&lt;/var&gt;/datasets/&lt;var&gt;{dataset_id}&lt;/var&gt;/evaluations/&lt;var&gt;{evaluation_id&lt;/var&gt;}'
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONFIG_FIELD_NUMBER = 2;
  private com.google.cloud.datalabeling.v1beta1.EvaluationConfig config_;
  /**
   *
   *
   * <pre>
   * Output only. Options used in the evaluation job that created this
   * evaluation.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.EvaluationConfig config = 2;</code>
   *
   * @return Whether the config field is set.
   */
  @java.lang.Override
  public boolean hasConfig() {
    return config_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Options used in the evaluation job that created this
   * evaluation.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.EvaluationConfig config = 2;</code>
   *
   * @return The config.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.EvaluationConfig getConfig() {
    return config_ == null
        ? com.google.cloud.datalabeling.v1beta1.EvaluationConfig.getDefaultInstance()
        : config_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Options used in the evaluation job that created this
   * evaluation.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.EvaluationConfig config = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.EvaluationConfigOrBuilder getConfigOrBuilder() {
    return config_ == null
        ? com.google.cloud.datalabeling.v1beta1.EvaluationConfig.getDefaultInstance()
        : config_;
  }

  public static final int EVALUATION_JOB_RUN_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp evaluationJobRunTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp for when the evaluation job that created this
   * evaluation ran.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp evaluation_job_run_time = 3;</code>
   *
   * @return Whether the evaluationJobRunTime field is set.
   */
  @java.lang.Override
  public boolean hasEvaluationJobRunTime() {
    return evaluationJobRunTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp for when the evaluation job that created this
   * evaluation ran.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp evaluation_job_run_time = 3;</code>
   *
   * @return The evaluationJobRunTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEvaluationJobRunTime() {
    return evaluationJobRunTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : evaluationJobRunTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp for when the evaluation job that created this
   * evaluation ran.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp evaluation_job_run_time = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEvaluationJobRunTimeOrBuilder() {
    return evaluationJobRunTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : evaluationJobRunTime_;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp for when this evaluation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4;</code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp for when this evaluation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4;</code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp for when this evaluation was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int EVALUATION_METRICS_FIELD_NUMBER = 5;
  private com.google.cloud.datalabeling.v1beta1.EvaluationMetrics evaluationMetrics_;
  /**
   *
   *
   * <pre>
   * Output only. Metrics comparing predictions to ground truth labels.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.EvaluationMetrics evaluation_metrics = 5;</code>
   *
   * @return Whether the evaluationMetrics field is set.
   */
  @java.lang.Override
  public boolean hasEvaluationMetrics() {
    return evaluationMetrics_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Metrics comparing predictions to ground truth labels.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.EvaluationMetrics evaluation_metrics = 5;</code>
   *
   * @return The evaluationMetrics.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.EvaluationMetrics getEvaluationMetrics() {
    return evaluationMetrics_ == null
        ? com.google.cloud.datalabeling.v1beta1.EvaluationMetrics.getDefaultInstance()
        : evaluationMetrics_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Metrics comparing predictions to ground truth labels.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.EvaluationMetrics evaluation_metrics = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.EvaluationMetricsOrBuilder
      getEvaluationMetricsOrBuilder() {
    return evaluationMetrics_ == null
        ? com.google.cloud.datalabeling.v1beta1.EvaluationMetrics.getDefaultInstance()
        : evaluationMetrics_;
  }

  public static final int ANNOTATION_TYPE_FIELD_NUMBER = 6;
  private int annotationType_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. Type of task that the model version being evaluated performs,
   * as defined in the
   *
   * [evaluationJobConfig.inputConfig.annotationType][google.cloud.datalabeling.v1beta1.EvaluationJobConfig.input_config]
   * field of the evaluation job that created this evaluation.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.AnnotationType annotation_type = 6;</code>
   *
   * @return The enum numeric value on the wire for annotationType.
   */
  @java.lang.Override
  public int getAnnotationTypeValue() {
    return annotationType_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Type of task that the model version being evaluated performs,
   * as defined in the
   *
   * [evaluationJobConfig.inputConfig.annotationType][google.cloud.datalabeling.v1beta1.EvaluationJobConfig.input_config]
   * field of the evaluation job that created this evaluation.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.AnnotationType annotation_type = 6;</code>
   *
   * @return The annotationType.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.AnnotationType getAnnotationType() {
    com.google.cloud.datalabeling.v1beta1.AnnotationType result =
        com.google.cloud.datalabeling.v1beta1.AnnotationType.forNumber(annotationType_);
    return result == null
        ? com.google.cloud.datalabeling.v1beta1.AnnotationType.UNRECOGNIZED
        : result;
  }

  public static final int EVALUATED_ITEM_COUNT_FIELD_NUMBER = 7;
  private long evaluatedItemCount_ = 0L;
  /**
   *
   *
   * <pre>
   * Output only. The number of items in the ground truth dataset that were used
   * for this evaluation. Only populated when the evaulation is for certain
   * AnnotationTypes.
   * </pre>
   *
   * <code>int64 evaluated_item_count = 7;</code>
   *
   * @return The evaluatedItemCount.
   */
  @java.lang.Override
  public long getEvaluatedItemCount() {
    return evaluatedItemCount_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (config_ != null) {
      output.writeMessage(2, getConfig());
    }
    if (evaluationJobRunTime_ != null) {
      output.writeMessage(3, getEvaluationJobRunTime());
    }
    if (createTime_ != null) {
      output.writeMessage(4, getCreateTime());
    }
    if (evaluationMetrics_ != null) {
      output.writeMessage(5, getEvaluationMetrics());
    }
    if (annotationType_
        != com.google.cloud.datalabeling.v1beta1.AnnotationType.ANNOTATION_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(6, annotationType_);
    }
    if (evaluatedItemCount_ != 0L) {
      output.writeInt64(7, evaluatedItemCount_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (config_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getConfig());
    }
    if (evaluationJobRunTime_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(3, getEvaluationJobRunTime());
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getCreateTime());
    }
    if (evaluationMetrics_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getEvaluationMetrics());
    }
    if (annotationType_
        != com.google.cloud.datalabeling.v1beta1.AnnotationType.ANNOTATION_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, annotationType_);
    }
    if (evaluatedItemCount_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(7, evaluatedItemCount_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datalabeling.v1beta1.Evaluation)) {
      return super.equals(obj);
    }
    com.google.cloud.datalabeling.v1beta1.Evaluation other =
        (com.google.cloud.datalabeling.v1beta1.Evaluation) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasConfig() != other.hasConfig()) return false;
    if (hasConfig()) {
      if (!getConfig().equals(other.getConfig())) return false;
    }
    if (hasEvaluationJobRunTime() != other.hasEvaluationJobRunTime()) return false;
    if (hasEvaluationJobRunTime()) {
      if (!getEvaluationJobRunTime().equals(other.getEvaluationJobRunTime())) return false;
    }
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasEvaluationMetrics() != other.hasEvaluationMetrics()) return false;
    if (hasEvaluationMetrics()) {
      if (!getEvaluationMetrics().equals(other.getEvaluationMetrics())) return false;
    }
    if (annotationType_ != other.annotationType_) return false;
    if (getEvaluatedItemCount() != other.getEvaluatedItemCount()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasConfig()) {
      hash = (37 * hash) + CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getConfig().hashCode();
    }
    if (hasEvaluationJobRunTime()) {
      hash = (37 * hash) + EVALUATION_JOB_RUN_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEvaluationJobRunTime().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasEvaluationMetrics()) {
      hash = (37 * hash) + EVALUATION_METRICS_FIELD_NUMBER;
      hash = (53 * hash) + getEvaluationMetrics().hashCode();
    }
    hash = (37 * hash) + ANNOTATION_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + annotationType_;
    hash = (37 * hash) + EVALUATED_ITEM_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getEvaluatedItemCount());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datalabeling.v1beta1.Evaluation parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.Evaluation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.Evaluation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.Evaluation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.Evaluation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.Evaluation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.Evaluation parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.Evaluation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.Evaluation parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.Evaluation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.Evaluation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.Evaluation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.datalabeling.v1beta1.Evaluation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Describes an evaluation between a machine learning model's predictions and
   * ground truth labels. Created when an [EvaluationJob][google.cloud.datalabeling.v1beta1.EvaluationJob] runs successfully.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datalabeling.v1beta1.Evaluation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datalabeling.v1beta1.Evaluation)
      com.google.cloud.datalabeling.v1beta1.EvaluationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datalabeling.v1beta1.EvaluationOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_Evaluation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datalabeling.v1beta1.EvaluationOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_Evaluation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datalabeling.v1beta1.Evaluation.class,
              com.google.cloud.datalabeling.v1beta1.Evaluation.Builder.class);
    }

    // Construct using com.google.cloud.datalabeling.v1beta1.Evaluation.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      config_ = null;
      if (configBuilder_ != null) {
        configBuilder_.dispose();
        configBuilder_ = null;
      }
      evaluationJobRunTime_ = null;
      if (evaluationJobRunTimeBuilder_ != null) {
        evaluationJobRunTimeBuilder_.dispose();
        evaluationJobRunTimeBuilder_ = null;
      }
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      evaluationMetrics_ = null;
      if (evaluationMetricsBuilder_ != null) {
        evaluationMetricsBuilder_.dispose();
        evaluationMetricsBuilder_ = null;
      }
      annotationType_ = 0;
      evaluatedItemCount_ = 0L;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datalabeling.v1beta1.EvaluationOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_Evaluation_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.Evaluation getDefaultInstanceForType() {
      return com.google.cloud.datalabeling.v1beta1.Evaluation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.Evaluation build() {
      com.google.cloud.datalabeling.v1beta1.Evaluation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.Evaluation buildPartial() {
      com.google.cloud.datalabeling.v1beta1.Evaluation result =
          new com.google.cloud.datalabeling.v1beta1.Evaluation(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.datalabeling.v1beta1.Evaluation result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.config_ = configBuilder_ == null ? config_ : configBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.evaluationJobRunTime_ =
            evaluationJobRunTimeBuilder_ == null
                ? evaluationJobRunTime_
                : evaluationJobRunTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.evaluationMetrics_ =
            evaluationMetricsBuilder_ == null
                ? evaluationMetrics_
                : evaluationMetricsBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.annotationType_ = annotationType_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.evaluatedItemCount_ = evaluatedItemCount_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datalabeling.v1beta1.Evaluation) {
        return mergeFrom((com.google.cloud.datalabeling.v1beta1.Evaluation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datalabeling.v1beta1.Evaluation other) {
      if (other == com.google.cloud.datalabeling.v1beta1.Evaluation.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasConfig()) {
        mergeConfig(other.getConfig());
      }
      if (other.hasEvaluationJobRunTime()) {
        mergeEvaluationJobRunTime(other.getEvaluationJobRunTime());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasEvaluationMetrics()) {
        mergeEvaluationMetrics(other.getEvaluationMetrics());
      }
      if (other.annotationType_ != 0) {
        setAnnotationTypeValue(other.getAnnotationTypeValue());
      }
      if (other.getEvaluatedItemCount() != 0L) {
        setEvaluatedItemCount(other.getEvaluatedItemCount());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getEvaluationJobRunTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    getEvaluationMetricsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 48:
              {
                annotationType_ = input.readEnum();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 56:
              {
                evaluatedItemCount_ = input.readInt64();
                bitField0_ |= 0x00000040;
                break;
              } // case 56
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Resource name of an evaluation. The name has the following
     * format:
     *
     * "projects/&lt;var&gt;{project_id}&lt;/var&gt;/datasets/&lt;var&gt;{dataset_id}&lt;/var&gt;/evaluations/&lt;var&gt;{evaluation_id&lt;/var&gt;}'
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of an evaluation. The name has the following
     * format:
     *
     * "projects/&lt;var&gt;{project_id}&lt;/var&gt;/datasets/&lt;var&gt;{dataset_id}&lt;/var&gt;/evaluations/&lt;var&gt;{evaluation_id&lt;/var&gt;}'
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of an evaluation. The name has the following
     * format:
     *
     * "projects/&lt;var&gt;{project_id}&lt;/var&gt;/datasets/&lt;var&gt;{dataset_id}&lt;/var&gt;/evaluations/&lt;var&gt;{evaluation_id&lt;/var&gt;}'
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of an evaluation. The name has the following
     * format:
     *
     * "projects/&lt;var&gt;{project_id}&lt;/var&gt;/datasets/&lt;var&gt;{dataset_id}&lt;/var&gt;/evaluations/&lt;var&gt;{evaluation_id&lt;/var&gt;}'
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Resource name of an evaluation. The name has the following
     * format:
     *
     * "projects/&lt;var&gt;{project_id}&lt;/var&gt;/datasets/&lt;var&gt;{dataset_id}&lt;/var&gt;/evaluations/&lt;var&gt;{evaluation_id&lt;/var&gt;}'
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.datalabeling.v1beta1.EvaluationConfig config_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.EvaluationConfig,
            com.google.cloud.datalabeling.v1beta1.EvaluationConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.EvaluationConfigOrBuilder>
        configBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Options used in the evaluation job that created this
     * evaluation.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EvaluationConfig config = 2;</code>
     *
     * @return Whether the config field is set.
     */
    public boolean hasConfig() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Options used in the evaluation job that created this
     * evaluation.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EvaluationConfig config = 2;</code>
     *
     * @return The config.
     */
    public com.google.cloud.datalabeling.v1beta1.EvaluationConfig getConfig() {
      if (configBuilder_ == null) {
        return config_ == null
            ? com.google.cloud.datalabeling.v1beta1.EvaluationConfig.getDefaultInstance()
            : config_;
      } else {
        return configBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Options used in the evaluation job that created this
     * evaluation.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EvaluationConfig config = 2;</code>
     */
    public Builder setConfig(com.google.cloud.datalabeling.v1beta1.EvaluationConfig value) {
      if (configBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        config_ = value;
      } else {
        configBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Options used in the evaluation job that created this
     * evaluation.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EvaluationConfig config = 2;</code>
     */
    public Builder setConfig(
        com.google.cloud.datalabeling.v1beta1.EvaluationConfig.Builder builderForValue) {
      if (configBuilder_ == null) {
        config_ = builderForValue.build();
      } else {
        configBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Options used in the evaluation job that created this
     * evaluation.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EvaluationConfig config = 2;</code>
     */
    public Builder mergeConfig(com.google.cloud.datalabeling.v1beta1.EvaluationConfig value) {
      if (configBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && config_ != null
            && config_
                != com.google.cloud.datalabeling.v1beta1.EvaluationConfig.getDefaultInstance()) {
          getConfigBuilder().mergeFrom(value);
        } else {
          config_ = value;
        }
      } else {
        configBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Options used in the evaluation job that created this
     * evaluation.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EvaluationConfig config = 2;</code>
     */
    public Builder clearConfig() {
      bitField0_ = (bitField0_ & ~0x00000002);
      config_ = null;
      if (configBuilder_ != null) {
        configBuilder_.dispose();
        configBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Options used in the evaluation job that created this
     * evaluation.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EvaluationConfig config = 2;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.EvaluationConfig.Builder getConfigBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Options used in the evaluation job that created this
     * evaluation.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EvaluationConfig config = 2;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.EvaluationConfigOrBuilder getConfigOrBuilder() {
      if (configBuilder_ != null) {
        return configBuilder_.getMessageOrBuilder();
      } else {
        return config_ == null
            ? com.google.cloud.datalabeling.v1beta1.EvaluationConfig.getDefaultInstance()
            : config_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Options used in the evaluation job that created this
     * evaluation.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EvaluationConfig config = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.EvaluationConfig,
            com.google.cloud.datalabeling.v1beta1.EvaluationConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.EvaluationConfigOrBuilder>
        getConfigFieldBuilder() {
      if (configBuilder_ == null) {
        configBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.EvaluationConfig,
                com.google.cloud.datalabeling.v1beta1.EvaluationConfig.Builder,
                com.google.cloud.datalabeling.v1beta1.EvaluationConfigOrBuilder>(
                getConfig(), getParentForChildren(), isClean());
        config_ = null;
      }
      return configBuilder_;
    }

    private com.google.protobuf.Timestamp evaluationJobRunTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        evaluationJobRunTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp for when the evaluation job that created this
     * evaluation ran.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp evaluation_job_run_time = 3;</code>
     *
     * @return Whether the evaluationJobRunTime field is set.
     */
    public boolean hasEvaluationJobRunTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp for when the evaluation job that created this
     * evaluation ran.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp evaluation_job_run_time = 3;</code>
     *
     * @return The evaluationJobRunTime.
     */
    public com.google.protobuf.Timestamp getEvaluationJobRunTime() {
      if (evaluationJobRunTimeBuilder_ == null) {
        return evaluationJobRunTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : evaluationJobRunTime_;
      } else {
        return evaluationJobRunTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp for when the evaluation job that created this
     * evaluation ran.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp evaluation_job_run_time = 3;</code>
     */
    public Builder setEvaluationJobRunTime(com.google.protobuf.Timestamp value) {
      if (evaluationJobRunTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        evaluationJobRunTime_ = value;
      } else {
        evaluationJobRunTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp for when the evaluation job that created this
     * evaluation ran.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp evaluation_job_run_time = 3;</code>
     */
    public Builder setEvaluationJobRunTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (evaluationJobRunTimeBuilder_ == null) {
        evaluationJobRunTime_ = builderForValue.build();
      } else {
        evaluationJobRunTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp for when the evaluation job that created this
     * evaluation ran.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp evaluation_job_run_time = 3;</code>
     */
    public Builder mergeEvaluationJobRunTime(com.google.protobuf.Timestamp value) {
      if (evaluationJobRunTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && evaluationJobRunTime_ != null
            && evaluationJobRunTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getEvaluationJobRunTimeBuilder().mergeFrom(value);
        } else {
          evaluationJobRunTime_ = value;
        }
      } else {
        evaluationJobRunTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp for when the evaluation job that created this
     * evaluation ran.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp evaluation_job_run_time = 3;</code>
     */
    public Builder clearEvaluationJobRunTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      evaluationJobRunTime_ = null;
      if (evaluationJobRunTimeBuilder_ != null) {
        evaluationJobRunTimeBuilder_.dispose();
        evaluationJobRunTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp for when the evaluation job that created this
     * evaluation ran.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp evaluation_job_run_time = 3;</code>
     */
    public com.google.protobuf.Timestamp.Builder getEvaluationJobRunTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getEvaluationJobRunTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp for when the evaluation job that created this
     * evaluation ran.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp evaluation_job_run_time = 3;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getEvaluationJobRunTimeOrBuilder() {
      if (evaluationJobRunTimeBuilder_ != null) {
        return evaluationJobRunTimeBuilder_.getMessageOrBuilder();
      } else {
        return evaluationJobRunTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : evaluationJobRunTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp for when the evaluation job that created this
     * evaluation ran.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp evaluation_job_run_time = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEvaluationJobRunTimeFieldBuilder() {
      if (evaluationJobRunTimeBuilder_ == null) {
        evaluationJobRunTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEvaluationJobRunTime(), getParentForChildren(), isClean());
        evaluationJobRunTime_ = null;
      }
      return evaluationJobRunTimeBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp for when this evaluation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp for when this evaluation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp for when this evaluation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp for when this evaluation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp for when this evaluation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp for when this evaluation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp for when this evaluation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp for when this evaluation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp for when this evaluation was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.cloud.datalabeling.v1beta1.EvaluationMetrics evaluationMetrics_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.EvaluationMetrics,
            com.google.cloud.datalabeling.v1beta1.EvaluationMetrics.Builder,
            com.google.cloud.datalabeling.v1beta1.EvaluationMetricsOrBuilder>
        evaluationMetricsBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Metrics comparing predictions to ground truth labels.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EvaluationMetrics evaluation_metrics = 5;</code>
     *
     * @return Whether the evaluationMetrics field is set.
     */
    public boolean hasEvaluationMetrics() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Metrics comparing predictions to ground truth labels.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EvaluationMetrics evaluation_metrics = 5;</code>
     *
     * @return The evaluationMetrics.
     */
    public com.google.cloud.datalabeling.v1beta1.EvaluationMetrics getEvaluationMetrics() {
      if (evaluationMetricsBuilder_ == null) {
        return evaluationMetrics_ == null
            ? com.google.cloud.datalabeling.v1beta1.EvaluationMetrics.getDefaultInstance()
            : evaluationMetrics_;
      } else {
        return evaluationMetricsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Metrics comparing predictions to ground truth labels.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EvaluationMetrics evaluation_metrics = 5;</code>
     */
    public Builder setEvaluationMetrics(
        com.google.cloud.datalabeling.v1beta1.EvaluationMetrics value) {
      if (evaluationMetricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        evaluationMetrics_ = value;
      } else {
        evaluationMetricsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Metrics comparing predictions to ground truth labels.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EvaluationMetrics evaluation_metrics = 5;</code>
     */
    public Builder setEvaluationMetrics(
        com.google.cloud.datalabeling.v1beta1.EvaluationMetrics.Builder builderForValue) {
      if (evaluationMetricsBuilder_ == null) {
        evaluationMetrics_ = builderForValue.build();
      } else {
        evaluationMetricsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Metrics comparing predictions to ground truth labels.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EvaluationMetrics evaluation_metrics = 5;</code>
     */
    public Builder mergeEvaluationMetrics(
        com.google.cloud.datalabeling.v1beta1.EvaluationMetrics value) {
      if (evaluationMetricsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && evaluationMetrics_ != null
            && evaluationMetrics_
                != com.google.cloud.datalabeling.v1beta1.EvaluationMetrics.getDefaultInstance()) {
          getEvaluationMetricsBuilder().mergeFrom(value);
        } else {
          evaluationMetrics_ = value;
        }
      } else {
        evaluationMetricsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Metrics comparing predictions to ground truth labels.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EvaluationMetrics evaluation_metrics = 5;</code>
     */
    public Builder clearEvaluationMetrics() {
      bitField0_ = (bitField0_ & ~0x00000010);
      evaluationMetrics_ = null;
      if (evaluationMetricsBuilder_ != null) {
        evaluationMetricsBuilder_.dispose();
        evaluationMetricsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Metrics comparing predictions to ground truth labels.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EvaluationMetrics evaluation_metrics = 5;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.EvaluationMetrics.Builder
        getEvaluationMetricsBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getEvaluationMetricsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Metrics comparing predictions to ground truth labels.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EvaluationMetrics evaluation_metrics = 5;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.EvaluationMetricsOrBuilder
        getEvaluationMetricsOrBuilder() {
      if (evaluationMetricsBuilder_ != null) {
        return evaluationMetricsBuilder_.getMessageOrBuilder();
      } else {
        return evaluationMetrics_ == null
            ? com.google.cloud.datalabeling.v1beta1.EvaluationMetrics.getDefaultInstance()
            : evaluationMetrics_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Metrics comparing predictions to ground truth labels.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EvaluationMetrics evaluation_metrics = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.EvaluationMetrics,
            com.google.cloud.datalabeling.v1beta1.EvaluationMetrics.Builder,
            com.google.cloud.datalabeling.v1beta1.EvaluationMetricsOrBuilder>
        getEvaluationMetricsFieldBuilder() {
      if (evaluationMetricsBuilder_ == null) {
        evaluationMetricsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.EvaluationMetrics,
                com.google.cloud.datalabeling.v1beta1.EvaluationMetrics.Builder,
                com.google.cloud.datalabeling.v1beta1.EvaluationMetricsOrBuilder>(
                getEvaluationMetrics(), getParentForChildren(), isClean());
        evaluationMetrics_ = null;
      }
      return evaluationMetricsBuilder_;
    }

    private int annotationType_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. Type of task that the model version being evaluated performs,
     * as defined in the
     *
     * [evaluationJobConfig.inputConfig.annotationType][google.cloud.datalabeling.v1beta1.EvaluationJobConfig.input_config]
     * field of the evaluation job that created this evaluation.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationType annotation_type = 6;</code>
     *
     * @return The enum numeric value on the wire for annotationType.
     */
    @java.lang.Override
    public int getAnnotationTypeValue() {
      return annotationType_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Type of task that the model version being evaluated performs,
     * as defined in the
     *
     * [evaluationJobConfig.inputConfig.annotationType][google.cloud.datalabeling.v1beta1.EvaluationJobConfig.input_config]
     * field of the evaluation job that created this evaluation.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationType annotation_type = 6;</code>
     *
     * @param value The enum numeric value on the wire for annotationType to set.
     * @return This builder for chaining.
     */
    public Builder setAnnotationTypeValue(int value) {
      annotationType_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Type of task that the model version being evaluated performs,
     * as defined in the
     *
     * [evaluationJobConfig.inputConfig.annotationType][google.cloud.datalabeling.v1beta1.EvaluationJobConfig.input_config]
     * field of the evaluation job that created this evaluation.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationType annotation_type = 6;</code>
     *
     * @return The annotationType.
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.AnnotationType getAnnotationType() {
      com.google.cloud.datalabeling.v1beta1.AnnotationType result =
          com.google.cloud.datalabeling.v1beta1.AnnotationType.forNumber(annotationType_);
      return result == null
          ? com.google.cloud.datalabeling.v1beta1.AnnotationType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. Type of task that the model version being evaluated performs,
     * as defined in the
     *
     * [evaluationJobConfig.inputConfig.annotationType][google.cloud.datalabeling.v1beta1.EvaluationJobConfig.input_config]
     * field of the evaluation job that created this evaluation.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationType annotation_type = 6;</code>
     *
     * @param value The annotationType to set.
     * @return This builder for chaining.
     */
    public Builder setAnnotationType(com.google.cloud.datalabeling.v1beta1.AnnotationType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      annotationType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Type of task that the model version being evaluated performs,
     * as defined in the
     *
     * [evaluationJobConfig.inputConfig.annotationType][google.cloud.datalabeling.v1beta1.EvaluationJobConfig.input_config]
     * field of the evaluation job that created this evaluation.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationType annotation_type = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAnnotationType() {
      bitField0_ = (bitField0_ & ~0x00000020);
      annotationType_ = 0;
      onChanged();
      return this;
    }

    private long evaluatedItemCount_;
    /**
     *
     *
     * <pre>
     * Output only. The number of items in the ground truth dataset that were used
     * for this evaluation. Only populated when the evaulation is for certain
     * AnnotationTypes.
     * </pre>
     *
     * <code>int64 evaluated_item_count = 7;</code>
     *
     * @return The evaluatedItemCount.
     */
    @java.lang.Override
    public long getEvaluatedItemCount() {
      return evaluatedItemCount_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The number of items in the ground truth dataset that were used
     * for this evaluation. Only populated when the evaulation is for certain
     * AnnotationTypes.
     * </pre>
     *
     * <code>int64 evaluated_item_count = 7;</code>
     *
     * @param value The evaluatedItemCount to set.
     * @return This builder for chaining.
     */
    public Builder setEvaluatedItemCount(long value) {

      evaluatedItemCount_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The number of items in the ground truth dataset that were used
     * for this evaluation. Only populated when the evaulation is for certain
     * AnnotationTypes.
     * </pre>
     *
     * <code>int64 evaluated_item_count = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEvaluatedItemCount() {
      bitField0_ = (bitField0_ & ~0x00000040);
      evaluatedItemCount_ = 0L;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datalabeling.v1beta1.Evaluation)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datalabeling.v1beta1.Evaluation)
  private static final com.google.cloud.datalabeling.v1beta1.Evaluation DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datalabeling.v1beta1.Evaluation();
  }

  public static com.google.cloud.datalabeling.v1beta1.Evaluation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Evaluation> PARSER =
      new com.google.protobuf.AbstractParser<Evaluation>() {
        @java.lang.Override
        public Evaluation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Evaluation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Evaluation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.Evaluation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
