/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datalabeling/v1beta1/dataset.proto

package com.google.cloud.datalabeling.v1beta1;

/**
 *
 *
 * <pre>
 * An Example is a piece of data and its annotation. For example, an image with
 * label "house".
 * </pre>
 *
 * Protobuf type {@code google.cloud.datalabeling.v1beta1.Example}
 */
public final class Example extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datalabeling.v1beta1.Example)
    ExampleOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Example.newBuilder() to construct.
  private Example(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Example() {
    name_ = "";
    annotations_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Example();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datalabeling.v1beta1.DatasetOuterClass
        .internal_static_google_cloud_datalabeling_v1beta1_Example_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datalabeling.v1beta1.DatasetOuterClass
        .internal_static_google_cloud_datalabeling_v1beta1_Example_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datalabeling.v1beta1.Example.class,
            com.google.cloud.datalabeling.v1beta1.Example.Builder.class);
  }

  private int payloadCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object payload_;

  public enum PayloadCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    IMAGE_PAYLOAD(2),
    TEXT_PAYLOAD(6),
    VIDEO_PAYLOAD(7),
    PAYLOAD_NOT_SET(0);
    private final int value;

    private PayloadCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PayloadCase valueOf(int value) {
      return forNumber(value);
    }

    public static PayloadCase forNumber(int value) {
      switch (value) {
        case 2:
          return IMAGE_PAYLOAD;
        case 6:
          return TEXT_PAYLOAD;
        case 7:
          return VIDEO_PAYLOAD;
        case 0:
          return PAYLOAD_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public PayloadCase getPayloadCase() {
    return PayloadCase.forNumber(payloadCase_);
  }

  public static final int IMAGE_PAYLOAD_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * The image payload, a container of the image bytes/uri.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.ImagePayload image_payload = 2;</code>
   *
   * @return Whether the imagePayload field is set.
   */
  @java.lang.Override
  public boolean hasImagePayload() {
    return payloadCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * The image payload, a container of the image bytes/uri.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.ImagePayload image_payload = 2;</code>
   *
   * @return The imagePayload.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.ImagePayload getImagePayload() {
    if (payloadCase_ == 2) {
      return (com.google.cloud.datalabeling.v1beta1.ImagePayload) payload_;
    }
    return com.google.cloud.datalabeling.v1beta1.ImagePayload.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The image payload, a container of the image bytes/uri.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.ImagePayload image_payload = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.ImagePayloadOrBuilder getImagePayloadOrBuilder() {
    if (payloadCase_ == 2) {
      return (com.google.cloud.datalabeling.v1beta1.ImagePayload) payload_;
    }
    return com.google.cloud.datalabeling.v1beta1.ImagePayload.getDefaultInstance();
  }

  public static final int TEXT_PAYLOAD_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * The text payload, a container of the text content.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.TextPayload text_payload = 6;</code>
   *
   * @return Whether the textPayload field is set.
   */
  @java.lang.Override
  public boolean hasTextPayload() {
    return payloadCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * The text payload, a container of the text content.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.TextPayload text_payload = 6;</code>
   *
   * @return The textPayload.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.TextPayload getTextPayload() {
    if (payloadCase_ == 6) {
      return (com.google.cloud.datalabeling.v1beta1.TextPayload) payload_;
    }
    return com.google.cloud.datalabeling.v1beta1.TextPayload.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The text payload, a container of the text content.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.TextPayload text_payload = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.TextPayloadOrBuilder getTextPayloadOrBuilder() {
    if (payloadCase_ == 6) {
      return (com.google.cloud.datalabeling.v1beta1.TextPayload) payload_;
    }
    return com.google.cloud.datalabeling.v1beta1.TextPayload.getDefaultInstance();
  }

  public static final int VIDEO_PAYLOAD_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * The video payload, a container of the video uri.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.VideoPayload video_payload = 7;</code>
   *
   * @return Whether the videoPayload field is set.
   */
  @java.lang.Override
  public boolean hasVideoPayload() {
    return payloadCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * The video payload, a container of the video uri.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.VideoPayload video_payload = 7;</code>
   *
   * @return The videoPayload.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.VideoPayload getVideoPayload() {
    if (payloadCase_ == 7) {
      return (com.google.cloud.datalabeling.v1beta1.VideoPayload) payload_;
    }
    return com.google.cloud.datalabeling.v1beta1.VideoPayload.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The video payload, a container of the video uri.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.VideoPayload video_payload = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.VideoPayloadOrBuilder getVideoPayloadOrBuilder() {
    if (payloadCase_ == 7) {
      return (com.google.cloud.datalabeling.v1beta1.VideoPayload) payload_;
    }
    return com.google.cloud.datalabeling.v1beta1.VideoPayload.getDefaultInstance();
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Name of the example, in format of:
   * projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/
   * {annotated_dataset_id}/examples/{example_id}
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Name of the example, in format of:
   * projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/
   * {annotated_dataset_id}/examples/{example_id}
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ANNOTATIONS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.datalabeling.v1beta1.Annotation> annotations_;
  /**
   *
   *
   * <pre>
   * Output only. Annotations for the piece of data in Example.
   * One piece of data can have multiple annotations.
   * </pre>
   *
   * <code>repeated .google.cloud.datalabeling.v1beta1.Annotation annotations = 5;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.datalabeling.v1beta1.Annotation> getAnnotationsList() {
    return annotations_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Annotations for the piece of data in Example.
   * One piece of data can have multiple annotations.
   * </pre>
   *
   * <code>repeated .google.cloud.datalabeling.v1beta1.Annotation annotations = 5;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.datalabeling.v1beta1.AnnotationOrBuilder>
      getAnnotationsOrBuilderList() {
    return annotations_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Annotations for the piece of data in Example.
   * One piece of data can have multiple annotations.
   * </pre>
   *
   * <code>repeated .google.cloud.datalabeling.v1beta1.Annotation annotations = 5;</code>
   */
  @java.lang.Override
  public int getAnnotationsCount() {
    return annotations_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Annotations for the piece of data in Example.
   * One piece of data can have multiple annotations.
   * </pre>
   *
   * <code>repeated .google.cloud.datalabeling.v1beta1.Annotation annotations = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.Annotation getAnnotations(int index) {
    return annotations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. Annotations for the piece of data in Example.
   * One piece of data can have multiple annotations.
   * </pre>
   *
   * <code>repeated .google.cloud.datalabeling.v1beta1.Annotation annotations = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.AnnotationOrBuilder getAnnotationsOrBuilder(
      int index) {
    return annotations_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (payloadCase_ == 2) {
      output.writeMessage(2, (com.google.cloud.datalabeling.v1beta1.ImagePayload) payload_);
    }
    for (int i = 0; i < annotations_.size(); i++) {
      output.writeMessage(5, annotations_.get(i));
    }
    if (payloadCase_ == 6) {
      output.writeMessage(6, (com.google.cloud.datalabeling.v1beta1.TextPayload) payload_);
    }
    if (payloadCase_ == 7) {
      output.writeMessage(7, (com.google.cloud.datalabeling.v1beta1.VideoPayload) payload_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (payloadCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.datalabeling.v1beta1.ImagePayload) payload_);
    }
    for (int i = 0; i < annotations_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, annotations_.get(i));
    }
    if (payloadCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloud.datalabeling.v1beta1.TextPayload) payload_);
    }
    if (payloadCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.cloud.datalabeling.v1beta1.VideoPayload) payload_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datalabeling.v1beta1.Example)) {
      return super.equals(obj);
    }
    com.google.cloud.datalabeling.v1beta1.Example other =
        (com.google.cloud.datalabeling.v1beta1.Example) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getAnnotationsList().equals(other.getAnnotationsList())) return false;
    if (!getPayloadCase().equals(other.getPayloadCase())) return false;
    switch (payloadCase_) {
      case 2:
        if (!getImagePayload().equals(other.getImagePayload())) return false;
        break;
      case 6:
        if (!getTextPayload().equals(other.getTextPayload())) return false;
        break;
      case 7:
        if (!getVideoPayload().equals(other.getVideoPayload())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (getAnnotationsCount() > 0) {
      hash = (37 * hash) + ANNOTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getAnnotationsList().hashCode();
    }
    switch (payloadCase_) {
      case 2:
        hash = (37 * hash) + IMAGE_PAYLOAD_FIELD_NUMBER;
        hash = (53 * hash) + getImagePayload().hashCode();
        break;
      case 6:
        hash = (37 * hash) + TEXT_PAYLOAD_FIELD_NUMBER;
        hash = (53 * hash) + getTextPayload().hashCode();
        break;
      case 7:
        hash = (37 * hash) + VIDEO_PAYLOAD_FIELD_NUMBER;
        hash = (53 * hash) + getVideoPayload().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datalabeling.v1beta1.Example parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.Example parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.Example parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.Example parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.Example parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.Example parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.Example parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.Example parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.Example parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.Example parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.Example parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.Example parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.datalabeling.v1beta1.Example prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * An Example is a piece of data and its annotation. For example, an image with
   * label "house".
   * </pre>
   *
   * Protobuf type {@code google.cloud.datalabeling.v1beta1.Example}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datalabeling.v1beta1.Example)
      com.google.cloud.datalabeling.v1beta1.ExampleOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datalabeling.v1beta1.DatasetOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_Example_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datalabeling.v1beta1.DatasetOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_Example_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datalabeling.v1beta1.Example.class,
              com.google.cloud.datalabeling.v1beta1.Example.Builder.class);
    }

    // Construct using com.google.cloud.datalabeling.v1beta1.Example.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (imagePayloadBuilder_ != null) {
        imagePayloadBuilder_.clear();
      }
      if (textPayloadBuilder_ != null) {
        textPayloadBuilder_.clear();
      }
      if (videoPayloadBuilder_ != null) {
        videoPayloadBuilder_.clear();
      }
      name_ = "";
      if (annotationsBuilder_ == null) {
        annotations_ = java.util.Collections.emptyList();
      } else {
        annotations_ = null;
        annotationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      payloadCase_ = 0;
      payload_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datalabeling.v1beta1.DatasetOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_Example_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.Example getDefaultInstanceForType() {
      return com.google.cloud.datalabeling.v1beta1.Example.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.Example build() {
      com.google.cloud.datalabeling.v1beta1.Example result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.Example buildPartial() {
      com.google.cloud.datalabeling.v1beta1.Example result =
          new com.google.cloud.datalabeling.v1beta1.Example(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.datalabeling.v1beta1.Example result) {
      if (annotationsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          annotations_ = java.util.Collections.unmodifiableList(annotations_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.annotations_ = annotations_;
      } else {
        result.annotations_ = annotationsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.datalabeling.v1beta1.Example result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.name_ = name_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.datalabeling.v1beta1.Example result) {
      result.payloadCase_ = payloadCase_;
      result.payload_ = this.payload_;
      if (payloadCase_ == 2 && imagePayloadBuilder_ != null) {
        result.payload_ = imagePayloadBuilder_.build();
      }
      if (payloadCase_ == 6 && textPayloadBuilder_ != null) {
        result.payload_ = textPayloadBuilder_.build();
      }
      if (payloadCase_ == 7 && videoPayloadBuilder_ != null) {
        result.payload_ = videoPayloadBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datalabeling.v1beta1.Example) {
        return mergeFrom((com.google.cloud.datalabeling.v1beta1.Example) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datalabeling.v1beta1.Example other) {
      if (other == com.google.cloud.datalabeling.v1beta1.Example.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (annotationsBuilder_ == null) {
        if (!other.annotations_.isEmpty()) {
          if (annotations_.isEmpty()) {
            annotations_ = other.annotations_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureAnnotationsIsMutable();
            annotations_.addAll(other.annotations_);
          }
          onChanged();
        }
      } else {
        if (!other.annotations_.isEmpty()) {
          if (annotationsBuilder_.isEmpty()) {
            annotationsBuilder_.dispose();
            annotationsBuilder_ = null;
            annotations_ = other.annotations_;
            bitField0_ = (bitField0_ & ~0x00000010);
            annotationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAnnotationsFieldBuilder()
                    : null;
          } else {
            annotationsBuilder_.addAllMessages(other.annotations_);
          }
        }
      }
      switch (other.getPayloadCase()) {
        case IMAGE_PAYLOAD:
          {
            mergeImagePayload(other.getImagePayload());
            break;
          }
        case TEXT_PAYLOAD:
          {
            mergeTextPayload(other.getTextPayload());
            break;
          }
        case VIDEO_PAYLOAD:
          {
            mergeVideoPayload(other.getVideoPayload());
            break;
          }
        case PAYLOAD_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getImagePayloadFieldBuilder().getBuilder(), extensionRegistry);
                payloadCase_ = 2;
                break;
              } // case 18
            case 42:
              {
                com.google.cloud.datalabeling.v1beta1.Annotation m =
                    input.readMessage(
                        com.google.cloud.datalabeling.v1beta1.Annotation.parser(),
                        extensionRegistry);
                if (annotationsBuilder_ == null) {
                  ensureAnnotationsIsMutable();
                  annotations_.add(m);
                } else {
                  annotationsBuilder_.addMessage(m);
                }
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getTextPayloadFieldBuilder().getBuilder(), extensionRegistry);
                payloadCase_ = 6;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getVideoPayloadFieldBuilder().getBuilder(), extensionRegistry);
                payloadCase_ = 7;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int payloadCase_ = 0;
    private java.lang.Object payload_;

    public PayloadCase getPayloadCase() {
      return PayloadCase.forNumber(payloadCase_);
    }

    public Builder clearPayload() {
      payloadCase_ = 0;
      payload_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.ImagePayload,
            com.google.cloud.datalabeling.v1beta1.ImagePayload.Builder,
            com.google.cloud.datalabeling.v1beta1.ImagePayloadOrBuilder>
        imagePayloadBuilder_;
    /**
     *
     *
     * <pre>
     * The image payload, a container of the image bytes/uri.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.ImagePayload image_payload = 2;</code>
     *
     * @return Whether the imagePayload field is set.
     */
    @java.lang.Override
    public boolean hasImagePayload() {
      return payloadCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * The image payload, a container of the image bytes/uri.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.ImagePayload image_payload = 2;</code>
     *
     * @return The imagePayload.
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.ImagePayload getImagePayload() {
      if (imagePayloadBuilder_ == null) {
        if (payloadCase_ == 2) {
          return (com.google.cloud.datalabeling.v1beta1.ImagePayload) payload_;
        }
        return com.google.cloud.datalabeling.v1beta1.ImagePayload.getDefaultInstance();
      } else {
        if (payloadCase_ == 2) {
          return imagePayloadBuilder_.getMessage();
        }
        return com.google.cloud.datalabeling.v1beta1.ImagePayload.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The image payload, a container of the image bytes/uri.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.ImagePayload image_payload = 2;</code>
     */
    public Builder setImagePayload(com.google.cloud.datalabeling.v1beta1.ImagePayload value) {
      if (imagePayloadBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        payload_ = value;
        onChanged();
      } else {
        imagePayloadBuilder_.setMessage(value);
      }
      payloadCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The image payload, a container of the image bytes/uri.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.ImagePayload image_payload = 2;</code>
     */
    public Builder setImagePayload(
        com.google.cloud.datalabeling.v1beta1.ImagePayload.Builder builderForValue) {
      if (imagePayloadBuilder_ == null) {
        payload_ = builderForValue.build();
        onChanged();
      } else {
        imagePayloadBuilder_.setMessage(builderForValue.build());
      }
      payloadCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The image payload, a container of the image bytes/uri.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.ImagePayload image_payload = 2;</code>
     */
    public Builder mergeImagePayload(com.google.cloud.datalabeling.v1beta1.ImagePayload value) {
      if (imagePayloadBuilder_ == null) {
        if (payloadCase_ == 2
            && payload_
                != com.google.cloud.datalabeling.v1beta1.ImagePayload.getDefaultInstance()) {
          payload_ =
              com.google.cloud.datalabeling.v1beta1.ImagePayload.newBuilder(
                      (com.google.cloud.datalabeling.v1beta1.ImagePayload) payload_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          payload_ = value;
        }
        onChanged();
      } else {
        if (payloadCase_ == 2) {
          imagePayloadBuilder_.mergeFrom(value);
        } else {
          imagePayloadBuilder_.setMessage(value);
        }
      }
      payloadCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The image payload, a container of the image bytes/uri.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.ImagePayload image_payload = 2;</code>
     */
    public Builder clearImagePayload() {
      if (imagePayloadBuilder_ == null) {
        if (payloadCase_ == 2) {
          payloadCase_ = 0;
          payload_ = null;
          onChanged();
        }
      } else {
        if (payloadCase_ == 2) {
          payloadCase_ = 0;
          payload_ = null;
        }
        imagePayloadBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The image payload, a container of the image bytes/uri.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.ImagePayload image_payload = 2;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.ImagePayload.Builder getImagePayloadBuilder() {
      return getImagePayloadFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The image payload, a container of the image bytes/uri.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.ImagePayload image_payload = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.ImagePayloadOrBuilder getImagePayloadOrBuilder() {
      if ((payloadCase_ == 2) && (imagePayloadBuilder_ != null)) {
        return imagePayloadBuilder_.getMessageOrBuilder();
      } else {
        if (payloadCase_ == 2) {
          return (com.google.cloud.datalabeling.v1beta1.ImagePayload) payload_;
        }
        return com.google.cloud.datalabeling.v1beta1.ImagePayload.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The image payload, a container of the image bytes/uri.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.ImagePayload image_payload = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.ImagePayload,
            com.google.cloud.datalabeling.v1beta1.ImagePayload.Builder,
            com.google.cloud.datalabeling.v1beta1.ImagePayloadOrBuilder>
        getImagePayloadFieldBuilder() {
      if (imagePayloadBuilder_ == null) {
        if (!(payloadCase_ == 2)) {
          payload_ = com.google.cloud.datalabeling.v1beta1.ImagePayload.getDefaultInstance();
        }
        imagePayloadBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.ImagePayload,
                com.google.cloud.datalabeling.v1beta1.ImagePayload.Builder,
                com.google.cloud.datalabeling.v1beta1.ImagePayloadOrBuilder>(
                (com.google.cloud.datalabeling.v1beta1.ImagePayload) payload_,
                getParentForChildren(),
                isClean());
        payload_ = null;
      }
      payloadCase_ = 2;
      onChanged();
      return imagePayloadBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.TextPayload,
            com.google.cloud.datalabeling.v1beta1.TextPayload.Builder,
            com.google.cloud.datalabeling.v1beta1.TextPayloadOrBuilder>
        textPayloadBuilder_;
    /**
     *
     *
     * <pre>
     * The text payload, a container of the text content.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.TextPayload text_payload = 6;</code>
     *
     * @return Whether the textPayload field is set.
     */
    @java.lang.Override
    public boolean hasTextPayload() {
      return payloadCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * The text payload, a container of the text content.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.TextPayload text_payload = 6;</code>
     *
     * @return The textPayload.
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.TextPayload getTextPayload() {
      if (textPayloadBuilder_ == null) {
        if (payloadCase_ == 6) {
          return (com.google.cloud.datalabeling.v1beta1.TextPayload) payload_;
        }
        return com.google.cloud.datalabeling.v1beta1.TextPayload.getDefaultInstance();
      } else {
        if (payloadCase_ == 6) {
          return textPayloadBuilder_.getMessage();
        }
        return com.google.cloud.datalabeling.v1beta1.TextPayload.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The text payload, a container of the text content.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.TextPayload text_payload = 6;</code>
     */
    public Builder setTextPayload(com.google.cloud.datalabeling.v1beta1.TextPayload value) {
      if (textPayloadBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        payload_ = value;
        onChanged();
      } else {
        textPayloadBuilder_.setMessage(value);
      }
      payloadCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The text payload, a container of the text content.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.TextPayload text_payload = 6;</code>
     */
    public Builder setTextPayload(
        com.google.cloud.datalabeling.v1beta1.TextPayload.Builder builderForValue) {
      if (textPayloadBuilder_ == null) {
        payload_ = builderForValue.build();
        onChanged();
      } else {
        textPayloadBuilder_.setMessage(builderForValue.build());
      }
      payloadCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The text payload, a container of the text content.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.TextPayload text_payload = 6;</code>
     */
    public Builder mergeTextPayload(com.google.cloud.datalabeling.v1beta1.TextPayload value) {
      if (textPayloadBuilder_ == null) {
        if (payloadCase_ == 6
            && payload_ != com.google.cloud.datalabeling.v1beta1.TextPayload.getDefaultInstance()) {
          payload_ =
              com.google.cloud.datalabeling.v1beta1.TextPayload.newBuilder(
                      (com.google.cloud.datalabeling.v1beta1.TextPayload) payload_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          payload_ = value;
        }
        onChanged();
      } else {
        if (payloadCase_ == 6) {
          textPayloadBuilder_.mergeFrom(value);
        } else {
          textPayloadBuilder_.setMessage(value);
        }
      }
      payloadCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The text payload, a container of the text content.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.TextPayload text_payload = 6;</code>
     */
    public Builder clearTextPayload() {
      if (textPayloadBuilder_ == null) {
        if (payloadCase_ == 6) {
          payloadCase_ = 0;
          payload_ = null;
          onChanged();
        }
      } else {
        if (payloadCase_ == 6) {
          payloadCase_ = 0;
          payload_ = null;
        }
        textPayloadBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The text payload, a container of the text content.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.TextPayload text_payload = 6;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.TextPayload.Builder getTextPayloadBuilder() {
      return getTextPayloadFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The text payload, a container of the text content.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.TextPayload text_payload = 6;</code>
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.TextPayloadOrBuilder getTextPayloadOrBuilder() {
      if ((payloadCase_ == 6) && (textPayloadBuilder_ != null)) {
        return textPayloadBuilder_.getMessageOrBuilder();
      } else {
        if (payloadCase_ == 6) {
          return (com.google.cloud.datalabeling.v1beta1.TextPayload) payload_;
        }
        return com.google.cloud.datalabeling.v1beta1.TextPayload.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The text payload, a container of the text content.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.TextPayload text_payload = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.TextPayload,
            com.google.cloud.datalabeling.v1beta1.TextPayload.Builder,
            com.google.cloud.datalabeling.v1beta1.TextPayloadOrBuilder>
        getTextPayloadFieldBuilder() {
      if (textPayloadBuilder_ == null) {
        if (!(payloadCase_ == 6)) {
          payload_ = com.google.cloud.datalabeling.v1beta1.TextPayload.getDefaultInstance();
        }
        textPayloadBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.TextPayload,
                com.google.cloud.datalabeling.v1beta1.TextPayload.Builder,
                com.google.cloud.datalabeling.v1beta1.TextPayloadOrBuilder>(
                (com.google.cloud.datalabeling.v1beta1.TextPayload) payload_,
                getParentForChildren(),
                isClean());
        payload_ = null;
      }
      payloadCase_ = 6;
      onChanged();
      return textPayloadBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.VideoPayload,
            com.google.cloud.datalabeling.v1beta1.VideoPayload.Builder,
            com.google.cloud.datalabeling.v1beta1.VideoPayloadOrBuilder>
        videoPayloadBuilder_;
    /**
     *
     *
     * <pre>
     * The video payload, a container of the video uri.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.VideoPayload video_payload = 7;</code>
     *
     * @return Whether the videoPayload field is set.
     */
    @java.lang.Override
    public boolean hasVideoPayload() {
      return payloadCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * The video payload, a container of the video uri.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.VideoPayload video_payload = 7;</code>
     *
     * @return The videoPayload.
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.VideoPayload getVideoPayload() {
      if (videoPayloadBuilder_ == null) {
        if (payloadCase_ == 7) {
          return (com.google.cloud.datalabeling.v1beta1.VideoPayload) payload_;
        }
        return com.google.cloud.datalabeling.v1beta1.VideoPayload.getDefaultInstance();
      } else {
        if (payloadCase_ == 7) {
          return videoPayloadBuilder_.getMessage();
        }
        return com.google.cloud.datalabeling.v1beta1.VideoPayload.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The video payload, a container of the video uri.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.VideoPayload video_payload = 7;</code>
     */
    public Builder setVideoPayload(com.google.cloud.datalabeling.v1beta1.VideoPayload value) {
      if (videoPayloadBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        payload_ = value;
        onChanged();
      } else {
        videoPayloadBuilder_.setMessage(value);
      }
      payloadCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The video payload, a container of the video uri.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.VideoPayload video_payload = 7;</code>
     */
    public Builder setVideoPayload(
        com.google.cloud.datalabeling.v1beta1.VideoPayload.Builder builderForValue) {
      if (videoPayloadBuilder_ == null) {
        payload_ = builderForValue.build();
        onChanged();
      } else {
        videoPayloadBuilder_.setMessage(builderForValue.build());
      }
      payloadCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The video payload, a container of the video uri.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.VideoPayload video_payload = 7;</code>
     */
    public Builder mergeVideoPayload(com.google.cloud.datalabeling.v1beta1.VideoPayload value) {
      if (videoPayloadBuilder_ == null) {
        if (payloadCase_ == 7
            && payload_
                != com.google.cloud.datalabeling.v1beta1.VideoPayload.getDefaultInstance()) {
          payload_ =
              com.google.cloud.datalabeling.v1beta1.VideoPayload.newBuilder(
                      (com.google.cloud.datalabeling.v1beta1.VideoPayload) payload_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          payload_ = value;
        }
        onChanged();
      } else {
        if (payloadCase_ == 7) {
          videoPayloadBuilder_.mergeFrom(value);
        } else {
          videoPayloadBuilder_.setMessage(value);
        }
      }
      payloadCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The video payload, a container of the video uri.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.VideoPayload video_payload = 7;</code>
     */
    public Builder clearVideoPayload() {
      if (videoPayloadBuilder_ == null) {
        if (payloadCase_ == 7) {
          payloadCase_ = 0;
          payload_ = null;
          onChanged();
        }
      } else {
        if (payloadCase_ == 7) {
          payloadCase_ = 0;
          payload_ = null;
        }
        videoPayloadBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The video payload, a container of the video uri.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.VideoPayload video_payload = 7;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.VideoPayload.Builder getVideoPayloadBuilder() {
      return getVideoPayloadFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The video payload, a container of the video uri.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.VideoPayload video_payload = 7;</code>
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.VideoPayloadOrBuilder getVideoPayloadOrBuilder() {
      if ((payloadCase_ == 7) && (videoPayloadBuilder_ != null)) {
        return videoPayloadBuilder_.getMessageOrBuilder();
      } else {
        if (payloadCase_ == 7) {
          return (com.google.cloud.datalabeling.v1beta1.VideoPayload) payload_;
        }
        return com.google.cloud.datalabeling.v1beta1.VideoPayload.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The video payload, a container of the video uri.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.VideoPayload video_payload = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.VideoPayload,
            com.google.cloud.datalabeling.v1beta1.VideoPayload.Builder,
            com.google.cloud.datalabeling.v1beta1.VideoPayloadOrBuilder>
        getVideoPayloadFieldBuilder() {
      if (videoPayloadBuilder_ == null) {
        if (!(payloadCase_ == 7)) {
          payload_ = com.google.cloud.datalabeling.v1beta1.VideoPayload.getDefaultInstance();
        }
        videoPayloadBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.VideoPayload,
                com.google.cloud.datalabeling.v1beta1.VideoPayload.Builder,
                com.google.cloud.datalabeling.v1beta1.VideoPayloadOrBuilder>(
                (com.google.cloud.datalabeling.v1beta1.VideoPayload) payload_,
                getParentForChildren(),
                isClean());
        payload_ = null;
      }
      payloadCase_ = 7;
      onChanged();
      return videoPayloadBuilder_;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Name of the example, in format of:
     * projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/
     * {annotated_dataset_id}/examples/{example_id}
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the example, in format of:
     * projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/
     * {annotated_dataset_id}/examples/{example_id}
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the example, in format of:
     * projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/
     * {annotated_dataset_id}/examples/{example_id}
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the example, in format of:
     * projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/
     * {annotated_dataset_id}/examples/{example_id}
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Name of the example, in format of:
     * projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/
     * {annotated_dataset_id}/examples/{example_id}
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.datalabeling.v1beta1.Annotation> annotations_ =
        java.util.Collections.emptyList();

    private void ensureAnnotationsIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        annotations_ =
            new java.util.ArrayList<com.google.cloud.datalabeling.v1beta1.Annotation>(annotations_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.Annotation,
            com.google.cloud.datalabeling.v1beta1.Annotation.Builder,
            com.google.cloud.datalabeling.v1beta1.AnnotationOrBuilder>
        annotationsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Annotations for the piece of data in Example.
     * One piece of data can have multiple annotations.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.Annotation annotations = 5;</code>
     */
    public java.util.List<com.google.cloud.datalabeling.v1beta1.Annotation> getAnnotationsList() {
      if (annotationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(annotations_);
      } else {
        return annotationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Annotations for the piece of data in Example.
     * One piece of data can have multiple annotations.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.Annotation annotations = 5;</code>
     */
    public int getAnnotationsCount() {
      if (annotationsBuilder_ == null) {
        return annotations_.size();
      } else {
        return annotationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Annotations for the piece of data in Example.
     * One piece of data can have multiple annotations.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.Annotation annotations = 5;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.Annotation getAnnotations(int index) {
      if (annotationsBuilder_ == null) {
        return annotations_.get(index);
      } else {
        return annotationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Annotations for the piece of data in Example.
     * One piece of data can have multiple annotations.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.Annotation annotations = 5;</code>
     */
    public Builder setAnnotations(
        int index, com.google.cloud.datalabeling.v1beta1.Annotation value) {
      if (annotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAnnotationsIsMutable();
        annotations_.set(index, value);
        onChanged();
      } else {
        annotationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Annotations for the piece of data in Example.
     * One piece of data can have multiple annotations.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.Annotation annotations = 5;</code>
     */
    public Builder setAnnotations(
        int index, com.google.cloud.datalabeling.v1beta1.Annotation.Builder builderForValue) {
      if (annotationsBuilder_ == null) {
        ensureAnnotationsIsMutable();
        annotations_.set(index, builderForValue.build());
        onChanged();
      } else {
        annotationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Annotations for the piece of data in Example.
     * One piece of data can have multiple annotations.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.Annotation annotations = 5;</code>
     */
    public Builder addAnnotations(com.google.cloud.datalabeling.v1beta1.Annotation value) {
      if (annotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAnnotationsIsMutable();
        annotations_.add(value);
        onChanged();
      } else {
        annotationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Annotations for the piece of data in Example.
     * One piece of data can have multiple annotations.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.Annotation annotations = 5;</code>
     */
    public Builder addAnnotations(
        int index, com.google.cloud.datalabeling.v1beta1.Annotation value) {
      if (annotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAnnotationsIsMutable();
        annotations_.add(index, value);
        onChanged();
      } else {
        annotationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Annotations for the piece of data in Example.
     * One piece of data can have multiple annotations.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.Annotation annotations = 5;</code>
     */
    public Builder addAnnotations(
        com.google.cloud.datalabeling.v1beta1.Annotation.Builder builderForValue) {
      if (annotationsBuilder_ == null) {
        ensureAnnotationsIsMutable();
        annotations_.add(builderForValue.build());
        onChanged();
      } else {
        annotationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Annotations for the piece of data in Example.
     * One piece of data can have multiple annotations.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.Annotation annotations = 5;</code>
     */
    public Builder addAnnotations(
        int index, com.google.cloud.datalabeling.v1beta1.Annotation.Builder builderForValue) {
      if (annotationsBuilder_ == null) {
        ensureAnnotationsIsMutable();
        annotations_.add(index, builderForValue.build());
        onChanged();
      } else {
        annotationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Annotations for the piece of data in Example.
     * One piece of data can have multiple annotations.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.Annotation annotations = 5;</code>
     */
    public Builder addAllAnnotations(
        java.lang.Iterable<? extends com.google.cloud.datalabeling.v1beta1.Annotation> values) {
      if (annotationsBuilder_ == null) {
        ensureAnnotationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, annotations_);
        onChanged();
      } else {
        annotationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Annotations for the piece of data in Example.
     * One piece of data can have multiple annotations.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.Annotation annotations = 5;</code>
     */
    public Builder clearAnnotations() {
      if (annotationsBuilder_ == null) {
        annotations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        annotationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Annotations for the piece of data in Example.
     * One piece of data can have multiple annotations.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.Annotation annotations = 5;</code>
     */
    public Builder removeAnnotations(int index) {
      if (annotationsBuilder_ == null) {
        ensureAnnotationsIsMutable();
        annotations_.remove(index);
        onChanged();
      } else {
        annotationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Annotations for the piece of data in Example.
     * One piece of data can have multiple annotations.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.Annotation annotations = 5;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.Annotation.Builder getAnnotationsBuilder(
        int index) {
      return getAnnotationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Annotations for the piece of data in Example.
     * One piece of data can have multiple annotations.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.Annotation annotations = 5;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.AnnotationOrBuilder getAnnotationsOrBuilder(
        int index) {
      if (annotationsBuilder_ == null) {
        return annotations_.get(index);
      } else {
        return annotationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Annotations for the piece of data in Example.
     * One piece of data can have multiple annotations.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.Annotation annotations = 5;</code>
     */
    public java.util.List<? extends com.google.cloud.datalabeling.v1beta1.AnnotationOrBuilder>
        getAnnotationsOrBuilderList() {
      if (annotationsBuilder_ != null) {
        return annotationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(annotations_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Annotations for the piece of data in Example.
     * One piece of data can have multiple annotations.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.Annotation annotations = 5;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.Annotation.Builder addAnnotationsBuilder() {
      return getAnnotationsFieldBuilder()
          .addBuilder(com.google.cloud.datalabeling.v1beta1.Annotation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Annotations for the piece of data in Example.
     * One piece of data can have multiple annotations.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.Annotation annotations = 5;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.Annotation.Builder addAnnotationsBuilder(
        int index) {
      return getAnnotationsFieldBuilder()
          .addBuilder(index, com.google.cloud.datalabeling.v1beta1.Annotation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Annotations for the piece of data in Example.
     * One piece of data can have multiple annotations.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.Annotation annotations = 5;</code>
     */
    public java.util.List<com.google.cloud.datalabeling.v1beta1.Annotation.Builder>
        getAnnotationsBuilderList() {
      return getAnnotationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.Annotation,
            com.google.cloud.datalabeling.v1beta1.Annotation.Builder,
            com.google.cloud.datalabeling.v1beta1.AnnotationOrBuilder>
        getAnnotationsFieldBuilder() {
      if (annotationsBuilder_ == null) {
        annotationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.Annotation,
                com.google.cloud.datalabeling.v1beta1.Annotation.Builder,
                com.google.cloud.datalabeling.v1beta1.AnnotationOrBuilder>(
                annotations_, ((bitField0_ & 0x00000010) != 0), getParentForChildren(), isClean());
        annotations_ = null;
      }
      return annotationsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datalabeling.v1beta1.Example)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datalabeling.v1beta1.Example)
  private static final com.google.cloud.datalabeling.v1beta1.Example DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datalabeling.v1beta1.Example();
  }

  public static com.google.cloud.datalabeling.v1beta1.Example getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Example> PARSER =
      new com.google.protobuf.AbstractParser<Example>() {
        @java.lang.Override
        public Example parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Example> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Example> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.Example getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
