/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datalabeling/v1beta1/annotation_spec_set.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.datalabeling.v1beta1;

/**
 *
 *
 * <pre>
 * An AnnotationSpecSet is a collection of label definitions. For example, in
 * image classification tasks, you define a set of possible labels for images as
 * an AnnotationSpecSet. An AnnotationSpecSet is immutable upon creation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.datalabeling.v1beta1.AnnotationSpecSet}
 */
public final class AnnotationSpecSet extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datalabeling.v1beta1.AnnotationSpecSet)
    AnnotationSpecSetOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AnnotationSpecSet.newBuilder() to construct.
  private AnnotationSpecSet(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AnnotationSpecSet() {
    name_ = "";
    displayName_ = "";
    description_ = "";
    annotationSpecs_ = java.util.Collections.emptyList();
    blockingResources_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AnnotationSpecSet();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datalabeling.v1beta1.AnnotationSpecSetOuterClass
        .internal_static_google_cloud_datalabeling_v1beta1_AnnotationSpecSet_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datalabeling.v1beta1.AnnotationSpecSetOuterClass
        .internal_static_google_cloud_datalabeling_v1beta1_AnnotationSpecSet_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datalabeling.v1beta1.AnnotationSpecSet.class,
            com.google.cloud.datalabeling.v1beta1.AnnotationSpecSet.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The AnnotationSpecSet resource name in the following format:
   *
   * "projects/&lt;var&gt;{project_id}&lt;/var&gt;/annotationSpecSets/&lt;var&gt;{annotation_spec_set_id}&lt;/var&gt;"
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The AnnotationSpecSet resource name in the following format:
   *
   * "projects/&lt;var&gt;{project_id}&lt;/var&gt;/annotationSpecSets/&lt;var&gt;{annotation_spec_set_id}&lt;/var&gt;"
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Required. The display name for AnnotationSpecSet that you define when you
   * create it. Maximum of 64 characters.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The display name for AnnotationSpecSet that you define when you
   * create it. Maximum of 64 characters.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Optional. User-provided description of the annotation specification set.
   * The description can be up to 10,000 characters long.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. User-provided description of the annotation specification set.
   * The description can be up to 10,000 characters long.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ANNOTATION_SPECS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.datalabeling.v1beta1.AnnotationSpec> annotationSpecs_;
  /**
   *
   *
   * <pre>
   * Required. The array of AnnotationSpecs that you define when you create the
   * AnnotationSpecSet. These are the possible labels for the labeling task.
   * </pre>
   *
   * <code>repeated .google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_specs = 4;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.datalabeling.v1beta1.AnnotationSpec>
      getAnnotationSpecsList() {
    return annotationSpecs_;
  }
  /**
   *
   *
   * <pre>
   * Required. The array of AnnotationSpecs that you define when you create the
   * AnnotationSpecSet. These are the possible labels for the labeling task.
   * </pre>
   *
   * <code>repeated .google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_specs = 4;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.datalabeling.v1beta1.AnnotationSpecOrBuilder>
      getAnnotationSpecsOrBuilderList() {
    return annotationSpecs_;
  }
  /**
   *
   *
   * <pre>
   * Required. The array of AnnotationSpecs that you define when you create the
   * AnnotationSpecSet. These are the possible labels for the labeling task.
   * </pre>
   *
   * <code>repeated .google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_specs = 4;</code>
   */
  @java.lang.Override
  public int getAnnotationSpecsCount() {
    return annotationSpecs_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. The array of AnnotationSpecs that you define when you create the
   * AnnotationSpecSet. These are the possible labels for the labeling task.
   * </pre>
   *
   * <code>repeated .google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_specs = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.AnnotationSpec getAnnotationSpecs(int index) {
    return annotationSpecs_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. The array of AnnotationSpecs that you define when you create the
   * AnnotationSpecSet. These are the possible labels for the labeling task.
   * </pre>
   *
   * <code>repeated .google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_specs = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.AnnotationSpecOrBuilder getAnnotationSpecsOrBuilder(
      int index) {
    return annotationSpecs_.get(index);
  }

  public static final int BLOCKING_RESOURCES_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList blockingResources_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Output only. The names of any related resources that are blocking changes
   * to the annotation spec set.
   * </pre>
   *
   * <code>repeated string blocking_resources = 5;</code>
   *
   * @return A list containing the blockingResources.
   */
  public com.google.protobuf.ProtocolStringList getBlockingResourcesList() {
    return blockingResources_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The names of any related resources that are blocking changes
   * to the annotation spec set.
   * </pre>
   *
   * <code>repeated string blocking_resources = 5;</code>
   *
   * @return The count of blockingResources.
   */
  public int getBlockingResourcesCount() {
    return blockingResources_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The names of any related resources that are blocking changes
   * to the annotation spec set.
   * </pre>
   *
   * <code>repeated string blocking_resources = 5;</code>
   *
   * @param index The index of the element to return.
   * @return The blockingResources at the given index.
   */
  public java.lang.String getBlockingResources(int index) {
    return blockingResources_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. The names of any related resources that are blocking changes
   * to the annotation spec set.
   * </pre>
   *
   * <code>repeated string blocking_resources = 5;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the blockingResources at the given index.
   */
  public com.google.protobuf.ByteString getBlockingResourcesBytes(int index) {
    return blockingResources_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, description_);
    }
    for (int i = 0; i < annotationSpecs_.size(); i++) {
      output.writeMessage(4, annotationSpecs_.get(i));
    }
    for (int i = 0; i < blockingResources_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, blockingResources_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, description_);
    }
    for (int i = 0; i < annotationSpecs_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, annotationSpecs_.get(i));
    }
    {
      int dataSize = 0;
      for (int i = 0; i < blockingResources_.size(); i++) {
        dataSize += computeStringSizeNoTag(blockingResources_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getBlockingResourcesList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datalabeling.v1beta1.AnnotationSpecSet)) {
      return super.equals(obj);
    }
    com.google.cloud.datalabeling.v1beta1.AnnotationSpecSet other =
        (com.google.cloud.datalabeling.v1beta1.AnnotationSpecSet) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getAnnotationSpecsList().equals(other.getAnnotationSpecsList())) return false;
    if (!getBlockingResourcesList().equals(other.getBlockingResourcesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (getAnnotationSpecsCount() > 0) {
      hash = (37 * hash) + ANNOTATION_SPECS_FIELD_NUMBER;
      hash = (53 * hash) + getAnnotationSpecsList().hashCode();
    }
    if (getBlockingResourcesCount() > 0) {
      hash = (37 * hash) + BLOCKING_RESOURCES_FIELD_NUMBER;
      hash = (53 * hash) + getBlockingResourcesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datalabeling.v1beta1.AnnotationSpecSet parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.AnnotationSpecSet parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.AnnotationSpecSet parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.AnnotationSpecSet parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.AnnotationSpecSet parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.AnnotationSpecSet parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.AnnotationSpecSet parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.AnnotationSpecSet parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.AnnotationSpecSet parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.AnnotationSpecSet parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.AnnotationSpecSet parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.AnnotationSpecSet parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.datalabeling.v1beta1.AnnotationSpecSet prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * An AnnotationSpecSet is a collection of label definitions. For example, in
   * image classification tasks, you define a set of possible labels for images as
   * an AnnotationSpecSet. An AnnotationSpecSet is immutable upon creation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datalabeling.v1beta1.AnnotationSpecSet}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datalabeling.v1beta1.AnnotationSpecSet)
      com.google.cloud.datalabeling.v1beta1.AnnotationSpecSetOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datalabeling.v1beta1.AnnotationSpecSetOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_AnnotationSpecSet_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datalabeling.v1beta1.AnnotationSpecSetOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_AnnotationSpecSet_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datalabeling.v1beta1.AnnotationSpecSet.class,
              com.google.cloud.datalabeling.v1beta1.AnnotationSpecSet.Builder.class);
    }

    // Construct using com.google.cloud.datalabeling.v1beta1.AnnotationSpecSet.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      description_ = "";
      if (annotationSpecsBuilder_ == null) {
        annotationSpecs_ = java.util.Collections.emptyList();
      } else {
        annotationSpecs_ = null;
        annotationSpecsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      blockingResources_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datalabeling.v1beta1.AnnotationSpecSetOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_AnnotationSpecSet_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.AnnotationSpecSet getDefaultInstanceForType() {
      return com.google.cloud.datalabeling.v1beta1.AnnotationSpecSet.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.AnnotationSpecSet build() {
      com.google.cloud.datalabeling.v1beta1.AnnotationSpecSet result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.AnnotationSpecSet buildPartial() {
      com.google.cloud.datalabeling.v1beta1.AnnotationSpecSet result =
          new com.google.cloud.datalabeling.v1beta1.AnnotationSpecSet(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.datalabeling.v1beta1.AnnotationSpecSet result) {
      if (annotationSpecsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          annotationSpecs_ = java.util.Collections.unmodifiableList(annotationSpecs_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.annotationSpecs_ = annotationSpecs_;
      } else {
        result.annotationSpecs_ = annotationSpecsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.datalabeling.v1beta1.AnnotationSpecSet result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        blockingResources_.makeImmutable();
        result.blockingResources_ = blockingResources_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datalabeling.v1beta1.AnnotationSpecSet) {
        return mergeFrom((com.google.cloud.datalabeling.v1beta1.AnnotationSpecSet) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datalabeling.v1beta1.AnnotationSpecSet other) {
      if (other == com.google.cloud.datalabeling.v1beta1.AnnotationSpecSet.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (annotationSpecsBuilder_ == null) {
        if (!other.annotationSpecs_.isEmpty()) {
          if (annotationSpecs_.isEmpty()) {
            annotationSpecs_ = other.annotationSpecs_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureAnnotationSpecsIsMutable();
            annotationSpecs_.addAll(other.annotationSpecs_);
          }
          onChanged();
        }
      } else {
        if (!other.annotationSpecs_.isEmpty()) {
          if (annotationSpecsBuilder_.isEmpty()) {
            annotationSpecsBuilder_.dispose();
            annotationSpecsBuilder_ = null;
            annotationSpecs_ = other.annotationSpecs_;
            bitField0_ = (bitField0_ & ~0x00000008);
            annotationSpecsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAnnotationSpecsFieldBuilder()
                    : null;
          } else {
            annotationSpecsBuilder_.addAllMessages(other.annotationSpecs_);
          }
        }
      }
      if (!other.blockingResources_.isEmpty()) {
        if (blockingResources_.isEmpty()) {
          blockingResources_ = other.blockingResources_;
          bitField0_ |= 0x00000010;
        } else {
          ensureBlockingResourcesIsMutable();
          blockingResources_.addAll(other.blockingResources_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                com.google.cloud.datalabeling.v1beta1.AnnotationSpec m =
                    input.readMessage(
                        com.google.cloud.datalabeling.v1beta1.AnnotationSpec.parser(),
                        extensionRegistry);
                if (annotationSpecsBuilder_ == null) {
                  ensureAnnotationSpecsIsMutable();
                  annotationSpecs_.add(m);
                } else {
                  annotationSpecsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureBlockingResourcesIsMutable();
                blockingResources_.add(s);
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The AnnotationSpecSet resource name in the following format:
     *
     * "projects/&lt;var&gt;{project_id}&lt;/var&gt;/annotationSpecSets/&lt;var&gt;{annotation_spec_set_id}&lt;/var&gt;"
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The AnnotationSpecSet resource name in the following format:
     *
     * "projects/&lt;var&gt;{project_id}&lt;/var&gt;/annotationSpecSets/&lt;var&gt;{annotation_spec_set_id}&lt;/var&gt;"
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The AnnotationSpecSet resource name in the following format:
     *
     * "projects/&lt;var&gt;{project_id}&lt;/var&gt;/annotationSpecSets/&lt;var&gt;{annotation_spec_set_id}&lt;/var&gt;"
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The AnnotationSpecSet resource name in the following format:
     *
     * "projects/&lt;var&gt;{project_id}&lt;/var&gt;/annotationSpecSets/&lt;var&gt;{annotation_spec_set_id}&lt;/var&gt;"
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The AnnotationSpecSet resource name in the following format:
     *
     * "projects/&lt;var&gt;{project_id}&lt;/var&gt;/annotationSpecSets/&lt;var&gt;{annotation_spec_set_id}&lt;/var&gt;"
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The display name for AnnotationSpecSet that you define when you
     * create it. Maximum of 64 characters.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The display name for AnnotationSpecSet that you define when you
     * create it. Maximum of 64 characters.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The display name for AnnotationSpecSet that you define when you
     * create it. Maximum of 64 characters.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The display name for AnnotationSpecSet that you define when you
     * create it. Maximum of 64 characters.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The display name for AnnotationSpecSet that you define when you
     * create it. Maximum of 64 characters.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Optional. User-provided description of the annotation specification set.
     * The description can be up to 10,000 characters long.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. User-provided description of the annotation specification set.
     * The description can be up to 10,000 characters long.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. User-provided description of the annotation specification set.
     * The description can be up to 10,000 characters long.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. User-provided description of the annotation specification set.
     * The description can be up to 10,000 characters long.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. User-provided description of the annotation specification set.
     * The description can be up to 10,000 characters long.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.datalabeling.v1beta1.AnnotationSpec> annotationSpecs_ =
        java.util.Collections.emptyList();

    private void ensureAnnotationSpecsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        annotationSpecs_ =
            new java.util.ArrayList<com.google.cloud.datalabeling.v1beta1.AnnotationSpec>(
                annotationSpecs_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.AnnotationSpec,
            com.google.cloud.datalabeling.v1beta1.AnnotationSpec.Builder,
            com.google.cloud.datalabeling.v1beta1.AnnotationSpecOrBuilder>
        annotationSpecsBuilder_;

    /**
     *
     *
     * <pre>
     * Required. The array of AnnotationSpecs that you define when you create the
     * AnnotationSpecSet. These are the possible labels for the labeling task.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_specs = 4;</code>
     */
    public java.util.List<com.google.cloud.datalabeling.v1beta1.AnnotationSpec>
        getAnnotationSpecsList() {
      if (annotationSpecsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(annotationSpecs_);
      } else {
        return annotationSpecsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The array of AnnotationSpecs that you define when you create the
     * AnnotationSpecSet. These are the possible labels for the labeling task.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_specs = 4;</code>
     */
    public int getAnnotationSpecsCount() {
      if (annotationSpecsBuilder_ == null) {
        return annotationSpecs_.size();
      } else {
        return annotationSpecsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The array of AnnotationSpecs that you define when you create the
     * AnnotationSpecSet. These are the possible labels for the labeling task.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_specs = 4;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.AnnotationSpec getAnnotationSpecs(int index) {
      if (annotationSpecsBuilder_ == null) {
        return annotationSpecs_.get(index);
      } else {
        return annotationSpecsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The array of AnnotationSpecs that you define when you create the
     * AnnotationSpecSet. These are the possible labels for the labeling task.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_specs = 4;</code>
     */
    public Builder setAnnotationSpecs(
        int index, com.google.cloud.datalabeling.v1beta1.AnnotationSpec value) {
      if (annotationSpecsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAnnotationSpecsIsMutable();
        annotationSpecs_.set(index, value);
        onChanged();
      } else {
        annotationSpecsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The array of AnnotationSpecs that you define when you create the
     * AnnotationSpecSet. These are the possible labels for the labeling task.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_specs = 4;</code>
     */
    public Builder setAnnotationSpecs(
        int index, com.google.cloud.datalabeling.v1beta1.AnnotationSpec.Builder builderForValue) {
      if (annotationSpecsBuilder_ == null) {
        ensureAnnotationSpecsIsMutable();
        annotationSpecs_.set(index, builderForValue.build());
        onChanged();
      } else {
        annotationSpecsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The array of AnnotationSpecs that you define when you create the
     * AnnotationSpecSet. These are the possible labels for the labeling task.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_specs = 4;</code>
     */
    public Builder addAnnotationSpecs(com.google.cloud.datalabeling.v1beta1.AnnotationSpec value) {
      if (annotationSpecsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAnnotationSpecsIsMutable();
        annotationSpecs_.add(value);
        onChanged();
      } else {
        annotationSpecsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The array of AnnotationSpecs that you define when you create the
     * AnnotationSpecSet. These are the possible labels for the labeling task.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_specs = 4;</code>
     */
    public Builder addAnnotationSpecs(
        int index, com.google.cloud.datalabeling.v1beta1.AnnotationSpec value) {
      if (annotationSpecsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAnnotationSpecsIsMutable();
        annotationSpecs_.add(index, value);
        onChanged();
      } else {
        annotationSpecsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The array of AnnotationSpecs that you define when you create the
     * AnnotationSpecSet. These are the possible labels for the labeling task.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_specs = 4;</code>
     */
    public Builder addAnnotationSpecs(
        com.google.cloud.datalabeling.v1beta1.AnnotationSpec.Builder builderForValue) {
      if (annotationSpecsBuilder_ == null) {
        ensureAnnotationSpecsIsMutable();
        annotationSpecs_.add(builderForValue.build());
        onChanged();
      } else {
        annotationSpecsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The array of AnnotationSpecs that you define when you create the
     * AnnotationSpecSet. These are the possible labels for the labeling task.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_specs = 4;</code>
     */
    public Builder addAnnotationSpecs(
        int index, com.google.cloud.datalabeling.v1beta1.AnnotationSpec.Builder builderForValue) {
      if (annotationSpecsBuilder_ == null) {
        ensureAnnotationSpecsIsMutable();
        annotationSpecs_.add(index, builderForValue.build());
        onChanged();
      } else {
        annotationSpecsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The array of AnnotationSpecs that you define when you create the
     * AnnotationSpecSet. These are the possible labels for the labeling task.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_specs = 4;</code>
     */
    public Builder addAllAnnotationSpecs(
        java.lang.Iterable<? extends com.google.cloud.datalabeling.v1beta1.AnnotationSpec> values) {
      if (annotationSpecsBuilder_ == null) {
        ensureAnnotationSpecsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, annotationSpecs_);
        onChanged();
      } else {
        annotationSpecsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The array of AnnotationSpecs that you define when you create the
     * AnnotationSpecSet. These are the possible labels for the labeling task.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_specs = 4;</code>
     */
    public Builder clearAnnotationSpecs() {
      if (annotationSpecsBuilder_ == null) {
        annotationSpecs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        annotationSpecsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The array of AnnotationSpecs that you define when you create the
     * AnnotationSpecSet. These are the possible labels for the labeling task.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_specs = 4;</code>
     */
    public Builder removeAnnotationSpecs(int index) {
      if (annotationSpecsBuilder_ == null) {
        ensureAnnotationSpecsIsMutable();
        annotationSpecs_.remove(index);
        onChanged();
      } else {
        annotationSpecsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The array of AnnotationSpecs that you define when you create the
     * AnnotationSpecSet. These are the possible labels for the labeling task.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_specs = 4;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.AnnotationSpec.Builder getAnnotationSpecsBuilder(
        int index) {
      return getAnnotationSpecsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Required. The array of AnnotationSpecs that you define when you create the
     * AnnotationSpecSet. These are the possible labels for the labeling task.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_specs = 4;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.AnnotationSpecOrBuilder
        getAnnotationSpecsOrBuilder(int index) {
      if (annotationSpecsBuilder_ == null) {
        return annotationSpecs_.get(index);
      } else {
        return annotationSpecsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The array of AnnotationSpecs that you define when you create the
     * AnnotationSpecSet. These are the possible labels for the labeling task.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_specs = 4;</code>
     */
    public java.util.List<? extends com.google.cloud.datalabeling.v1beta1.AnnotationSpecOrBuilder>
        getAnnotationSpecsOrBuilderList() {
      if (annotationSpecsBuilder_ != null) {
        return annotationSpecsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(annotationSpecs_);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The array of AnnotationSpecs that you define when you create the
     * AnnotationSpecSet. These are the possible labels for the labeling task.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_specs = 4;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.AnnotationSpec.Builder
        addAnnotationSpecsBuilder() {
      return getAnnotationSpecsFieldBuilder()
          .addBuilder(com.google.cloud.datalabeling.v1beta1.AnnotationSpec.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. The array of AnnotationSpecs that you define when you create the
     * AnnotationSpecSet. These are the possible labels for the labeling task.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_specs = 4;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.AnnotationSpec.Builder addAnnotationSpecsBuilder(
        int index) {
      return getAnnotationSpecsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.datalabeling.v1beta1.AnnotationSpec.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. The array of AnnotationSpecs that you define when you create the
     * AnnotationSpecSet. These are the possible labels for the labeling task.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_specs = 4;</code>
     */
    public java.util.List<com.google.cloud.datalabeling.v1beta1.AnnotationSpec.Builder>
        getAnnotationSpecsBuilderList() {
      return getAnnotationSpecsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.AnnotationSpec,
            com.google.cloud.datalabeling.v1beta1.AnnotationSpec.Builder,
            com.google.cloud.datalabeling.v1beta1.AnnotationSpecOrBuilder>
        getAnnotationSpecsFieldBuilder() {
      if (annotationSpecsBuilder_ == null) {
        annotationSpecsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.AnnotationSpec,
                com.google.cloud.datalabeling.v1beta1.AnnotationSpec.Builder,
                com.google.cloud.datalabeling.v1beta1.AnnotationSpecOrBuilder>(
                annotationSpecs_,
                ((bitField0_ & 0x00000008) != 0),
                getParentForChildren(),
                isClean());
        annotationSpecs_ = null;
      }
      return annotationSpecsBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList blockingResources_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureBlockingResourcesIsMutable() {
      if (!blockingResources_.isModifiable()) {
        blockingResources_ = new com.google.protobuf.LazyStringArrayList(blockingResources_);
      }
      bitField0_ |= 0x00000010;
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of any related resources that are blocking changes
     * to the annotation spec set.
     * </pre>
     *
     * <code>repeated string blocking_resources = 5;</code>
     *
     * @return A list containing the blockingResources.
     */
    public com.google.protobuf.ProtocolStringList getBlockingResourcesList() {
      blockingResources_.makeImmutable();
      return blockingResources_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of any related resources that are blocking changes
     * to the annotation spec set.
     * </pre>
     *
     * <code>repeated string blocking_resources = 5;</code>
     *
     * @return The count of blockingResources.
     */
    public int getBlockingResourcesCount() {
      return blockingResources_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of any related resources that are blocking changes
     * to the annotation spec set.
     * </pre>
     *
     * <code>repeated string blocking_resources = 5;</code>
     *
     * @param index The index of the element to return.
     * @return The blockingResources at the given index.
     */
    public java.lang.String getBlockingResources(int index) {
      return blockingResources_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of any related resources that are blocking changes
     * to the annotation spec set.
     * </pre>
     *
     * <code>repeated string blocking_resources = 5;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the blockingResources at the given index.
     */
    public com.google.protobuf.ByteString getBlockingResourcesBytes(int index) {
      return blockingResources_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of any related resources that are blocking changes
     * to the annotation spec set.
     * </pre>
     *
     * <code>repeated string blocking_resources = 5;</code>
     *
     * @param index The index to set the value at.
     * @param value The blockingResources to set.
     * @return This builder for chaining.
     */
    public Builder setBlockingResources(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureBlockingResourcesIsMutable();
      blockingResources_.set(index, value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of any related resources that are blocking changes
     * to the annotation spec set.
     * </pre>
     *
     * <code>repeated string blocking_resources = 5;</code>
     *
     * @param value The blockingResources to add.
     * @return This builder for chaining.
     */
    public Builder addBlockingResources(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureBlockingResourcesIsMutable();
      blockingResources_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of any related resources that are blocking changes
     * to the annotation spec set.
     * </pre>
     *
     * <code>repeated string blocking_resources = 5;</code>
     *
     * @param values The blockingResources to add.
     * @return This builder for chaining.
     */
    public Builder addAllBlockingResources(java.lang.Iterable<java.lang.String> values) {
      ensureBlockingResourcesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, blockingResources_);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of any related resources that are blocking changes
     * to the annotation spec set.
     * </pre>
     *
     * <code>repeated string blocking_resources = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBlockingResources() {
      blockingResources_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000010);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of any related resources that are blocking changes
     * to the annotation spec set.
     * </pre>
     *
     * <code>repeated string blocking_resources = 5;</code>
     *
     * @param value The bytes of the blockingResources to add.
     * @return This builder for chaining.
     */
    public Builder addBlockingResourcesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureBlockingResourcesIsMutable();
      blockingResources_.add(value);
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datalabeling.v1beta1.AnnotationSpecSet)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datalabeling.v1beta1.AnnotationSpecSet)
  private static final com.google.cloud.datalabeling.v1beta1.AnnotationSpecSet DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datalabeling.v1beta1.AnnotationSpecSet();
  }

  public static com.google.cloud.datalabeling.v1beta1.AnnotationSpecSet getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AnnotationSpecSet> PARSER =
      new com.google.protobuf.AbstractParser<AnnotationSpecSet>() {
        @java.lang.Override
        public AnnotationSpecSet parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AnnotationSpecSet> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AnnotationSpecSet> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.AnnotationSpecSet getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
