/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datalabeling/v1beta1/dataset.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.datalabeling.v1beta1;

/**
 *
 *
 * <pre>
 * AnnotatedDataset is a set holding annotations for data in a Dataset. Each
 * labeling task will generate an AnnotatedDataset under the Dataset that the
 * task is requested for.
 * </pre>
 *
 * Protobuf type {@code google.cloud.datalabeling.v1beta1.AnnotatedDataset}
 */
public final class AnnotatedDataset extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datalabeling.v1beta1.AnnotatedDataset)
    AnnotatedDatasetOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AnnotatedDataset.newBuilder() to construct.
  private AnnotatedDataset(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AnnotatedDataset() {
    name_ = "";
    displayName_ = "";
    description_ = "";
    annotationSource_ = 0;
    annotationType_ = 0;
    blockingResources_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AnnotatedDataset();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datalabeling.v1beta1.DatasetOuterClass
        .internal_static_google_cloud_datalabeling_v1beta1_AnnotatedDataset_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datalabeling.v1beta1.DatasetOuterClass
        .internal_static_google_cloud_datalabeling_v1beta1_AnnotatedDataset_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datalabeling.v1beta1.AnnotatedDataset.class,
            com.google.cloud.datalabeling.v1beta1.AnnotatedDataset.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. AnnotatedDataset resource name in format of:
   * projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/
   * {annotated_dataset_id}
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. AnnotatedDataset resource name in format of:
   * projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/
   * {annotated_dataset_id}
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The display name of the AnnotatedDataset. It is specified in
   * HumanAnnotationConfig when user starts a labeling task. Maximum of 64
   * characters.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The display name of the AnnotatedDataset. It is specified in
   * HumanAnnotationConfig when user starts a labeling task. Maximum of 64
   * characters.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Output only. The description of the AnnotatedDataset. It is specified in
   * HumanAnnotationConfig when user starts a labeling task. Maximum of 10000
   * characters.
   * </pre>
   *
   * <code>string description = 9;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The description of the AnnotatedDataset. It is specified in
   * HumanAnnotationConfig when user starts a labeling task. Maximum of 10000
   * characters.
   * </pre>
   *
   * <code>string description = 9;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ANNOTATION_SOURCE_FIELD_NUMBER = 3;
  private int annotationSource_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. Source of the annotation.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.AnnotationSource annotation_source = 3;</code>
   *
   * @return The enum numeric value on the wire for annotationSource.
   */
  @java.lang.Override
  public int getAnnotationSourceValue() {
    return annotationSource_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Source of the annotation.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.AnnotationSource annotation_source = 3;</code>
   *
   * @return The annotationSource.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.AnnotationSource getAnnotationSource() {
    com.google.cloud.datalabeling.v1beta1.AnnotationSource result =
        com.google.cloud.datalabeling.v1beta1.AnnotationSource.forNumber(annotationSource_);
    return result == null
        ? com.google.cloud.datalabeling.v1beta1.AnnotationSource.UNRECOGNIZED
        : result;
  }

  public static final int ANNOTATION_TYPE_FIELD_NUMBER = 8;
  private int annotationType_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. Type of the annotation. It is specified when starting labeling
   * task.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.AnnotationType annotation_type = 8;</code>
   *
   * @return The enum numeric value on the wire for annotationType.
   */
  @java.lang.Override
  public int getAnnotationTypeValue() {
    return annotationType_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Type of the annotation. It is specified when starting labeling
   * task.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.AnnotationType annotation_type = 8;</code>
   *
   * @return The annotationType.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.AnnotationType getAnnotationType() {
    com.google.cloud.datalabeling.v1beta1.AnnotationType result =
        com.google.cloud.datalabeling.v1beta1.AnnotationType.forNumber(annotationType_);
    return result == null
        ? com.google.cloud.datalabeling.v1beta1.AnnotationType.UNRECOGNIZED
        : result;
  }

  public static final int EXAMPLE_COUNT_FIELD_NUMBER = 4;
  private long exampleCount_ = 0L;
  /**
   *
   *
   * <pre>
   * Output only. Number of examples in the annotated dataset.
   * </pre>
   *
   * <code>int64 example_count = 4;</code>
   *
   * @return The exampleCount.
   */
  @java.lang.Override
  public long getExampleCount() {
    return exampleCount_;
  }

  public static final int COMPLETED_EXAMPLE_COUNT_FIELD_NUMBER = 5;
  private long completedExampleCount_ = 0L;
  /**
   *
   *
   * <pre>
   * Output only. Number of examples that have annotation in the annotated
   * dataset.
   * </pre>
   *
   * <code>int64 completed_example_count = 5;</code>
   *
   * @return The completedExampleCount.
   */
  @java.lang.Override
  public long getCompletedExampleCount() {
    return completedExampleCount_;
  }

  public static final int LABEL_STATS_FIELD_NUMBER = 6;
  private com.google.cloud.datalabeling.v1beta1.LabelStats labelStats_;
  /**
   *
   *
   * <pre>
   * Output only. Per label statistics.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.LabelStats label_stats = 6;</code>
   *
   * @return Whether the labelStats field is set.
   */
  @java.lang.Override
  public boolean hasLabelStats() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Per label statistics.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.LabelStats label_stats = 6;</code>
   *
   * @return The labelStats.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.LabelStats getLabelStats() {
    return labelStats_ == null
        ? com.google.cloud.datalabeling.v1beta1.LabelStats.getDefaultInstance()
        : labelStats_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Per label statistics.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.LabelStats label_stats = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.LabelStatsOrBuilder getLabelStatsOrBuilder() {
    return labelStats_ == null
        ? com.google.cloud.datalabeling.v1beta1.LabelStats.getDefaultInstance()
        : labelStats_;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time the AnnotatedDataset was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7;</code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Time the AnnotatedDataset was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7;</code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time the AnnotatedDataset was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int METADATA_FIELD_NUMBER = 10;
  private com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata metadata_;
  /**
   *
   *
   * <pre>
   * Output only. Additional information about AnnotatedDataset.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata metadata = 10;</code>
   *
   * @return Whether the metadata field is set.
   */
  @java.lang.Override
  public boolean hasMetadata() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Additional information about AnnotatedDataset.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata metadata = 10;</code>
   *
   * @return The metadata.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata getMetadata() {
    return metadata_ == null
        ? com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata.getDefaultInstance()
        : metadata_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Additional information about AnnotatedDataset.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata metadata = 10;</code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadataOrBuilder
      getMetadataOrBuilder() {
    return metadata_ == null
        ? com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata.getDefaultInstance()
        : metadata_;
  }

  public static final int BLOCKING_RESOURCES_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList blockingResources_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Output only. The names of any related resources that are blocking changes
   * to the annotated dataset.
   * </pre>
   *
   * <code>repeated string blocking_resources = 11;</code>
   *
   * @return A list containing the blockingResources.
   */
  public com.google.protobuf.ProtocolStringList getBlockingResourcesList() {
    return blockingResources_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The names of any related resources that are blocking changes
   * to the annotated dataset.
   * </pre>
   *
   * <code>repeated string blocking_resources = 11;</code>
   *
   * @return The count of blockingResources.
   */
  public int getBlockingResourcesCount() {
    return blockingResources_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The names of any related resources that are blocking changes
   * to the annotated dataset.
   * </pre>
   *
   * <code>repeated string blocking_resources = 11;</code>
   *
   * @param index The index of the element to return.
   * @return The blockingResources at the given index.
   */
  public java.lang.String getBlockingResources(int index) {
    return blockingResources_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. The names of any related resources that are blocking changes
   * to the annotated dataset.
   * </pre>
   *
   * <code>repeated string blocking_resources = 11;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the blockingResources at the given index.
   */
  public com.google.protobuf.ByteString getBlockingResourcesBytes(int index) {
    return blockingResources_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (annotationSource_
        != com.google.cloud.datalabeling.v1beta1.AnnotationSource.ANNOTATION_SOURCE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, annotationSource_);
    }
    if (exampleCount_ != 0L) {
      output.writeInt64(4, exampleCount_);
    }
    if (completedExampleCount_ != 0L) {
      output.writeInt64(5, completedExampleCount_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(6, getLabelStats());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(7, getCreateTime());
    }
    if (annotationType_
        != com.google.cloud.datalabeling.v1beta1.AnnotationType.ANNOTATION_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(8, annotationType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, description_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(10, getMetadata());
    }
    for (int i = 0; i < blockingResources_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, blockingResources_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (annotationSource_
        != com.google.cloud.datalabeling.v1beta1.AnnotationSource.ANNOTATION_SOURCE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, annotationSource_);
    }
    if (exampleCount_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(4, exampleCount_);
    }
    if (completedExampleCount_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(5, completedExampleCount_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getLabelStats());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getCreateTime());
    }
    if (annotationType_
        != com.google.cloud.datalabeling.v1beta1.AnnotationType.ANNOTATION_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(8, annotationType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, description_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getMetadata());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < blockingResources_.size(); i++) {
        dataSize += computeStringSizeNoTag(blockingResources_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getBlockingResourcesList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datalabeling.v1beta1.AnnotatedDataset)) {
      return super.equals(obj);
    }
    com.google.cloud.datalabeling.v1beta1.AnnotatedDataset other =
        (com.google.cloud.datalabeling.v1beta1.AnnotatedDataset) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (annotationSource_ != other.annotationSource_) return false;
    if (annotationType_ != other.annotationType_) return false;
    if (getExampleCount() != other.getExampleCount()) return false;
    if (getCompletedExampleCount() != other.getCompletedExampleCount()) return false;
    if (hasLabelStats() != other.hasLabelStats()) return false;
    if (hasLabelStats()) {
      if (!getLabelStats().equals(other.getLabelStats())) return false;
    }
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasMetadata() != other.hasMetadata()) return false;
    if (hasMetadata()) {
      if (!getMetadata().equals(other.getMetadata())) return false;
    }
    if (!getBlockingResourcesList().equals(other.getBlockingResourcesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + ANNOTATION_SOURCE_FIELD_NUMBER;
    hash = (53 * hash) + annotationSource_;
    hash = (37 * hash) + ANNOTATION_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + annotationType_;
    hash = (37 * hash) + EXAMPLE_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getExampleCount());
    hash = (37 * hash) + COMPLETED_EXAMPLE_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getCompletedExampleCount());
    if (hasLabelStats()) {
      hash = (37 * hash) + LABEL_STATS_FIELD_NUMBER;
      hash = (53 * hash) + getLabelStats().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasMetadata()) {
      hash = (37 * hash) + METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getMetadata().hashCode();
    }
    if (getBlockingResourcesCount() > 0) {
      hash = (37 * hash) + BLOCKING_RESOURCES_FIELD_NUMBER;
      hash = (53 * hash) + getBlockingResourcesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datalabeling.v1beta1.AnnotatedDataset parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.AnnotatedDataset parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.AnnotatedDataset parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.AnnotatedDataset parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.AnnotatedDataset parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.AnnotatedDataset parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.AnnotatedDataset parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.AnnotatedDataset parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.AnnotatedDataset parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.AnnotatedDataset parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.AnnotatedDataset parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.AnnotatedDataset parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.datalabeling.v1beta1.AnnotatedDataset prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * AnnotatedDataset is a set holding annotations for data in a Dataset. Each
   * labeling task will generate an AnnotatedDataset under the Dataset that the
   * task is requested for.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datalabeling.v1beta1.AnnotatedDataset}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datalabeling.v1beta1.AnnotatedDataset)
      com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datalabeling.v1beta1.DatasetOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_AnnotatedDataset_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datalabeling.v1beta1.DatasetOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_AnnotatedDataset_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datalabeling.v1beta1.AnnotatedDataset.class,
              com.google.cloud.datalabeling.v1beta1.AnnotatedDataset.Builder.class);
    }

    // Construct using com.google.cloud.datalabeling.v1beta1.AnnotatedDataset.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getLabelStatsFieldBuilder();
        getCreateTimeFieldBuilder();
        getMetadataFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      description_ = "";
      annotationSource_ = 0;
      annotationType_ = 0;
      exampleCount_ = 0L;
      completedExampleCount_ = 0L;
      labelStats_ = null;
      if (labelStatsBuilder_ != null) {
        labelStatsBuilder_.dispose();
        labelStatsBuilder_ = null;
      }
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      metadata_ = null;
      if (metadataBuilder_ != null) {
        metadataBuilder_.dispose();
        metadataBuilder_ = null;
      }
      blockingResources_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datalabeling.v1beta1.DatasetOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_AnnotatedDataset_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.AnnotatedDataset getDefaultInstanceForType() {
      return com.google.cloud.datalabeling.v1beta1.AnnotatedDataset.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.AnnotatedDataset build() {
      com.google.cloud.datalabeling.v1beta1.AnnotatedDataset result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.AnnotatedDataset buildPartial() {
      com.google.cloud.datalabeling.v1beta1.AnnotatedDataset result =
          new com.google.cloud.datalabeling.v1beta1.AnnotatedDataset(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.datalabeling.v1beta1.AnnotatedDataset result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.annotationSource_ = annotationSource_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.annotationType_ = annotationType_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.exampleCount_ = exampleCount_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.completedExampleCount_ = completedExampleCount_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.labelStats_ = labelStatsBuilder_ == null ? labelStats_ : labelStatsBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.metadata_ = metadataBuilder_ == null ? metadata_ : metadataBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        blockingResources_.makeImmutable();
        result.blockingResources_ = blockingResources_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datalabeling.v1beta1.AnnotatedDataset) {
        return mergeFrom((com.google.cloud.datalabeling.v1beta1.AnnotatedDataset) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datalabeling.v1beta1.AnnotatedDataset other) {
      if (other == com.google.cloud.datalabeling.v1beta1.AnnotatedDataset.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.annotationSource_ != 0) {
        setAnnotationSourceValue(other.getAnnotationSourceValue());
      }
      if (other.annotationType_ != 0) {
        setAnnotationTypeValue(other.getAnnotationTypeValue());
      }
      if (other.getExampleCount() != 0L) {
        setExampleCount(other.getExampleCount());
      }
      if (other.getCompletedExampleCount() != 0L) {
        setCompletedExampleCount(other.getCompletedExampleCount());
      }
      if (other.hasLabelStats()) {
        mergeLabelStats(other.getLabelStats());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasMetadata()) {
        mergeMetadata(other.getMetadata());
      }
      if (!other.blockingResources_.isEmpty()) {
        if (blockingResources_.isEmpty()) {
          blockingResources_ = other.blockingResources_;
          bitField0_ |= 0x00000400;
        } else {
          ensureBlockingResourcesIsMutable();
          blockingResources_.addAll(other.blockingResources_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                annotationSource_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 24
            case 32:
              {
                exampleCount_ = input.readInt64();
                bitField0_ |= 0x00000020;
                break;
              } // case 32
            case 40:
              {
                completedExampleCount_ = input.readInt64();
                bitField0_ |= 0x00000040;
                break;
              } // case 40
            case 50:
              {
                input.readMessage(getLabelStatsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 58
            case 64:
              {
                annotationType_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 64
            case 74:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getMetadataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            case 90:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureBlockingResourcesIsMutable();
                blockingResources_.add(s);
                break;
              } // case 90
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. AnnotatedDataset resource name in format of:
     * projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/
     * {annotated_dataset_id}
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. AnnotatedDataset resource name in format of:
     * projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/
     * {annotated_dataset_id}
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. AnnotatedDataset resource name in format of:
     * projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/
     * {annotated_dataset_id}
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. AnnotatedDataset resource name in format of:
     * projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/
     * {annotated_dataset_id}
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. AnnotatedDataset resource name in format of:
     * projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/
     * {annotated_dataset_id}
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The display name of the AnnotatedDataset. It is specified in
     * HumanAnnotationConfig when user starts a labeling task. Maximum of 64
     * characters.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The display name of the AnnotatedDataset. It is specified in
     * HumanAnnotationConfig when user starts a labeling task. Maximum of 64
     * characters.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The display name of the AnnotatedDataset. It is specified in
     * HumanAnnotationConfig when user starts a labeling task. Maximum of 64
     * characters.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The display name of the AnnotatedDataset. It is specified in
     * HumanAnnotationConfig when user starts a labeling task. Maximum of 64
     * characters.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The display name of the AnnotatedDataset. It is specified in
     * HumanAnnotationConfig when user starts a labeling task. Maximum of 64
     * characters.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The description of the AnnotatedDataset. It is specified in
     * HumanAnnotationConfig when user starts a labeling task. Maximum of 10000
     * characters.
     * </pre>
     *
     * <code>string description = 9;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The description of the AnnotatedDataset. It is specified in
     * HumanAnnotationConfig when user starts a labeling task. Maximum of 10000
     * characters.
     * </pre>
     *
     * <code>string description = 9;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The description of the AnnotatedDataset. It is specified in
     * HumanAnnotationConfig when user starts a labeling task. Maximum of 10000
     * characters.
     * </pre>
     *
     * <code>string description = 9;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The description of the AnnotatedDataset. It is specified in
     * HumanAnnotationConfig when user starts a labeling task. Maximum of 10000
     * characters.
     * </pre>
     *
     * <code>string description = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The description of the AnnotatedDataset. It is specified in
     * HumanAnnotationConfig when user starts a labeling task. Maximum of 10000
     * characters.
     * </pre>
     *
     * <code>string description = 9;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private int annotationSource_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. Source of the annotation.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSource annotation_source = 3;</code>
     *
     * @return The enum numeric value on the wire for annotationSource.
     */
    @java.lang.Override
    public int getAnnotationSourceValue() {
      return annotationSource_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Source of the annotation.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSource annotation_source = 3;</code>
     *
     * @param value The enum numeric value on the wire for annotationSource to set.
     * @return This builder for chaining.
     */
    public Builder setAnnotationSourceValue(int value) {
      annotationSource_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Source of the annotation.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSource annotation_source = 3;</code>
     *
     * @return The annotationSource.
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.AnnotationSource getAnnotationSource() {
      com.google.cloud.datalabeling.v1beta1.AnnotationSource result =
          com.google.cloud.datalabeling.v1beta1.AnnotationSource.forNumber(annotationSource_);
      return result == null
          ? com.google.cloud.datalabeling.v1beta1.AnnotationSource.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. Source of the annotation.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSource annotation_source = 3;</code>
     *
     * @param value The annotationSource to set.
     * @return This builder for chaining.
     */
    public Builder setAnnotationSource(
        com.google.cloud.datalabeling.v1beta1.AnnotationSource value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      annotationSource_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Source of the annotation.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSource annotation_source = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAnnotationSource() {
      bitField0_ = (bitField0_ & ~0x00000008);
      annotationSource_ = 0;
      onChanged();
      return this;
    }

    private int annotationType_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. Type of the annotation. It is specified when starting labeling
     * task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationType annotation_type = 8;</code>
     *
     * @return The enum numeric value on the wire for annotationType.
     */
    @java.lang.Override
    public int getAnnotationTypeValue() {
      return annotationType_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Type of the annotation. It is specified when starting labeling
     * task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationType annotation_type = 8;</code>
     *
     * @param value The enum numeric value on the wire for annotationType to set.
     * @return This builder for chaining.
     */
    public Builder setAnnotationTypeValue(int value) {
      annotationType_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Type of the annotation. It is specified when starting labeling
     * task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationType annotation_type = 8;</code>
     *
     * @return The annotationType.
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.AnnotationType getAnnotationType() {
      com.google.cloud.datalabeling.v1beta1.AnnotationType result =
          com.google.cloud.datalabeling.v1beta1.AnnotationType.forNumber(annotationType_);
      return result == null
          ? com.google.cloud.datalabeling.v1beta1.AnnotationType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. Type of the annotation. It is specified when starting labeling
     * task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationType annotation_type = 8;</code>
     *
     * @param value The annotationType to set.
     * @return This builder for chaining.
     */
    public Builder setAnnotationType(com.google.cloud.datalabeling.v1beta1.AnnotationType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      annotationType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Type of the annotation. It is specified when starting labeling
     * task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationType annotation_type = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAnnotationType() {
      bitField0_ = (bitField0_ & ~0x00000010);
      annotationType_ = 0;
      onChanged();
      return this;
    }

    private long exampleCount_;
    /**
     *
     *
     * <pre>
     * Output only. Number of examples in the annotated dataset.
     * </pre>
     *
     * <code>int64 example_count = 4;</code>
     *
     * @return The exampleCount.
     */
    @java.lang.Override
    public long getExampleCount() {
      return exampleCount_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Number of examples in the annotated dataset.
     * </pre>
     *
     * <code>int64 example_count = 4;</code>
     *
     * @param value The exampleCount to set.
     * @return This builder for chaining.
     */
    public Builder setExampleCount(long value) {

      exampleCount_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Number of examples in the annotated dataset.
     * </pre>
     *
     * <code>int64 example_count = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExampleCount() {
      bitField0_ = (bitField0_ & ~0x00000020);
      exampleCount_ = 0L;
      onChanged();
      return this;
    }

    private long completedExampleCount_;
    /**
     *
     *
     * <pre>
     * Output only. Number of examples that have annotation in the annotated
     * dataset.
     * </pre>
     *
     * <code>int64 completed_example_count = 5;</code>
     *
     * @return The completedExampleCount.
     */
    @java.lang.Override
    public long getCompletedExampleCount() {
      return completedExampleCount_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Number of examples that have annotation in the annotated
     * dataset.
     * </pre>
     *
     * <code>int64 completed_example_count = 5;</code>
     *
     * @param value The completedExampleCount to set.
     * @return This builder for chaining.
     */
    public Builder setCompletedExampleCount(long value) {

      completedExampleCount_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Number of examples that have annotation in the annotated
     * dataset.
     * </pre>
     *
     * <code>int64 completed_example_count = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCompletedExampleCount() {
      bitField0_ = (bitField0_ & ~0x00000040);
      completedExampleCount_ = 0L;
      onChanged();
      return this;
    }

    private com.google.cloud.datalabeling.v1beta1.LabelStats labelStats_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.LabelStats,
            com.google.cloud.datalabeling.v1beta1.LabelStats.Builder,
            com.google.cloud.datalabeling.v1beta1.LabelStatsOrBuilder>
        labelStatsBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Per label statistics.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.LabelStats label_stats = 6;</code>
     *
     * @return Whether the labelStats field is set.
     */
    public boolean hasLabelStats() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Per label statistics.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.LabelStats label_stats = 6;</code>
     *
     * @return The labelStats.
     */
    public com.google.cloud.datalabeling.v1beta1.LabelStats getLabelStats() {
      if (labelStatsBuilder_ == null) {
        return labelStats_ == null
            ? com.google.cloud.datalabeling.v1beta1.LabelStats.getDefaultInstance()
            : labelStats_;
      } else {
        return labelStatsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Per label statistics.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.LabelStats label_stats = 6;</code>
     */
    public Builder setLabelStats(com.google.cloud.datalabeling.v1beta1.LabelStats value) {
      if (labelStatsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        labelStats_ = value;
      } else {
        labelStatsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Per label statistics.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.LabelStats label_stats = 6;</code>
     */
    public Builder setLabelStats(
        com.google.cloud.datalabeling.v1beta1.LabelStats.Builder builderForValue) {
      if (labelStatsBuilder_ == null) {
        labelStats_ = builderForValue.build();
      } else {
        labelStatsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Per label statistics.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.LabelStats label_stats = 6;</code>
     */
    public Builder mergeLabelStats(com.google.cloud.datalabeling.v1beta1.LabelStats value) {
      if (labelStatsBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && labelStats_ != null
            && labelStats_
                != com.google.cloud.datalabeling.v1beta1.LabelStats.getDefaultInstance()) {
          getLabelStatsBuilder().mergeFrom(value);
        } else {
          labelStats_ = value;
        }
      } else {
        labelStatsBuilder_.mergeFrom(value);
      }
      if (labelStats_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Per label statistics.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.LabelStats label_stats = 6;</code>
     */
    public Builder clearLabelStats() {
      bitField0_ = (bitField0_ & ~0x00000080);
      labelStats_ = null;
      if (labelStatsBuilder_ != null) {
        labelStatsBuilder_.dispose();
        labelStatsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Per label statistics.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.LabelStats label_stats = 6;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.LabelStats.Builder getLabelStatsBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getLabelStatsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Per label statistics.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.LabelStats label_stats = 6;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.LabelStatsOrBuilder getLabelStatsOrBuilder() {
      if (labelStatsBuilder_ != null) {
        return labelStatsBuilder_.getMessageOrBuilder();
      } else {
        return labelStats_ == null
            ? com.google.cloud.datalabeling.v1beta1.LabelStats.getDefaultInstance()
            : labelStats_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Per label statistics.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.LabelStats label_stats = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.LabelStats,
            com.google.cloud.datalabeling.v1beta1.LabelStats.Builder,
            com.google.cloud.datalabeling.v1beta1.LabelStatsOrBuilder>
        getLabelStatsFieldBuilder() {
      if (labelStatsBuilder_ == null) {
        labelStatsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.LabelStats,
                com.google.cloud.datalabeling.v1beta1.LabelStats.Builder,
                com.google.cloud.datalabeling.v1beta1.LabelStatsOrBuilder>(
                getLabelStats(), getParentForChildren(), isClean());
        labelStats_ = null;
      }
      return labelStatsBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time the AnnotatedDataset was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Time the AnnotatedDataset was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time the AnnotatedDataset was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time the AnnotatedDataset was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time the AnnotatedDataset was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time the AnnotatedDataset was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000100);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time the AnnotatedDataset was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time the AnnotatedDataset was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time the AnnotatedDataset was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata metadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata,
            com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata.Builder,
            com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadataOrBuilder>
        metadataBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Additional information about AnnotatedDataset.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata metadata = 10;</code>
     *
     * @return Whether the metadata field is set.
     */
    public boolean hasMetadata() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about AnnotatedDataset.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata metadata = 10;</code>
     *
     * @return The metadata.
     */
    public com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata getMetadata() {
      if (metadataBuilder_ == null) {
        return metadata_ == null
            ? com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata.getDefaultInstance()
            : metadata_;
      } else {
        return metadataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about AnnotatedDataset.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata metadata = 10;</code>
     */
    public Builder setMetadata(
        com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata value) {
      if (metadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metadata_ = value;
      } else {
        metadataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about AnnotatedDataset.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata metadata = 10;</code>
     */
    public Builder setMetadata(
        com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata.Builder builderForValue) {
      if (metadataBuilder_ == null) {
        metadata_ = builderForValue.build();
      } else {
        metadataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about AnnotatedDataset.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata metadata = 10;</code>
     */
    public Builder mergeMetadata(
        com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata value) {
      if (metadataBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && metadata_ != null
            && metadata_
                != com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata
                    .getDefaultInstance()) {
          getMetadataBuilder().mergeFrom(value);
        } else {
          metadata_ = value;
        }
      } else {
        metadataBuilder_.mergeFrom(value);
      }
      if (metadata_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about AnnotatedDataset.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata metadata = 10;</code>
     */
    public Builder clearMetadata() {
      bitField0_ = (bitField0_ & ~0x00000200);
      metadata_ = null;
      if (metadataBuilder_ != null) {
        metadataBuilder_.dispose();
        metadataBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about AnnotatedDataset.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata metadata = 10;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata.Builder
        getMetadataBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about AnnotatedDataset.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata metadata = 10;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadataOrBuilder
        getMetadataOrBuilder() {
      if (metadataBuilder_ != null) {
        return metadataBuilder_.getMessageOrBuilder();
      } else {
        return metadata_ == null
            ? com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata.getDefaultInstance()
            : metadata_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Additional information about AnnotatedDataset.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata metadata = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata,
            com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata.Builder,
            com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadataOrBuilder>
        getMetadataFieldBuilder() {
      if (metadataBuilder_ == null) {
        metadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata,
                com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata.Builder,
                com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadataOrBuilder>(
                getMetadata(), getParentForChildren(), isClean());
        metadata_ = null;
      }
      return metadataBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList blockingResources_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureBlockingResourcesIsMutable() {
      if (!blockingResources_.isModifiable()) {
        blockingResources_ = new com.google.protobuf.LazyStringArrayList(blockingResources_);
      }
      bitField0_ |= 0x00000400;
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of any related resources that are blocking changes
     * to the annotated dataset.
     * </pre>
     *
     * <code>repeated string blocking_resources = 11;</code>
     *
     * @return A list containing the blockingResources.
     */
    public com.google.protobuf.ProtocolStringList getBlockingResourcesList() {
      blockingResources_.makeImmutable();
      return blockingResources_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of any related resources that are blocking changes
     * to the annotated dataset.
     * </pre>
     *
     * <code>repeated string blocking_resources = 11;</code>
     *
     * @return The count of blockingResources.
     */
    public int getBlockingResourcesCount() {
      return blockingResources_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of any related resources that are blocking changes
     * to the annotated dataset.
     * </pre>
     *
     * <code>repeated string blocking_resources = 11;</code>
     *
     * @param index The index of the element to return.
     * @return The blockingResources at the given index.
     */
    public java.lang.String getBlockingResources(int index) {
      return blockingResources_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of any related resources that are blocking changes
     * to the annotated dataset.
     * </pre>
     *
     * <code>repeated string blocking_resources = 11;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the blockingResources at the given index.
     */
    public com.google.protobuf.ByteString getBlockingResourcesBytes(int index) {
      return blockingResources_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of any related resources that are blocking changes
     * to the annotated dataset.
     * </pre>
     *
     * <code>repeated string blocking_resources = 11;</code>
     *
     * @param index The index to set the value at.
     * @param value The blockingResources to set.
     * @return This builder for chaining.
     */
    public Builder setBlockingResources(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureBlockingResourcesIsMutable();
      blockingResources_.set(index, value);
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of any related resources that are blocking changes
     * to the annotated dataset.
     * </pre>
     *
     * <code>repeated string blocking_resources = 11;</code>
     *
     * @param value The blockingResources to add.
     * @return This builder for chaining.
     */
    public Builder addBlockingResources(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureBlockingResourcesIsMutable();
      blockingResources_.add(value);
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of any related resources that are blocking changes
     * to the annotated dataset.
     * </pre>
     *
     * <code>repeated string blocking_resources = 11;</code>
     *
     * @param values The blockingResources to add.
     * @return This builder for chaining.
     */
    public Builder addAllBlockingResources(java.lang.Iterable<java.lang.String> values) {
      ensureBlockingResourcesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, blockingResources_);
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of any related resources that are blocking changes
     * to the annotated dataset.
     * </pre>
     *
     * <code>repeated string blocking_resources = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBlockingResources() {
      blockingResources_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000400);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of any related resources that are blocking changes
     * to the annotated dataset.
     * </pre>
     *
     * <code>repeated string blocking_resources = 11;</code>
     *
     * @param value The bytes of the blockingResources to add.
     * @return This builder for chaining.
     */
    public Builder addBlockingResourcesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureBlockingResourcesIsMutable();
      blockingResources_.add(value);
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datalabeling.v1beta1.AnnotatedDataset)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datalabeling.v1beta1.AnnotatedDataset)
  private static final com.google.cloud.datalabeling.v1beta1.AnnotatedDataset DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datalabeling.v1beta1.AnnotatedDataset();
  }

  public static com.google.cloud.datalabeling.v1beta1.AnnotatedDataset getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AnnotatedDataset> PARSER =
      new com.google.protobuf.AbstractParser<AnnotatedDataset>() {
        @java.lang.Override
        public AnnotatedDataset parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AnnotatedDataset> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AnnotatedDataset> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.AnnotatedDataset getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
