/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datalabeling/v1beta1/dataset.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.datalabeling.v1beta1;

public interface AnnotatedDatasetOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.datalabeling.v1beta1.AnnotatedDataset)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Output only. AnnotatedDataset resource name in format of:
   * projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/
   * {annotated_dataset_id}
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * Output only. AnnotatedDataset resource name in format of:
   * projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/
   * {annotated_dataset_id}
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Output only. The display name of the AnnotatedDataset. It is specified in
   * HumanAnnotationConfig when user starts a labeling task. Maximum of 64
   * characters.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The displayName.
   */
  java.lang.String getDisplayName();
  /**
   *
   *
   * <pre>
   * Output only. The display name of the AnnotatedDataset. It is specified in
   * HumanAnnotationConfig when user starts a labeling task. Maximum of 64
   * characters.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The bytes for displayName.
   */
  com.google.protobuf.ByteString getDisplayNameBytes();

  /**
   *
   *
   * <pre>
   * Output only. The description of the AnnotatedDataset. It is specified in
   * HumanAnnotationConfig when user starts a labeling task. Maximum of 10000
   * characters.
   * </pre>
   *
   * <code>string description = 9;</code>
   *
   * @return The description.
   */
  java.lang.String getDescription();
  /**
   *
   *
   * <pre>
   * Output only. The description of the AnnotatedDataset. It is specified in
   * HumanAnnotationConfig when user starts a labeling task. Maximum of 10000
   * characters.
   * </pre>
   *
   * <code>string description = 9;</code>
   *
   * @return The bytes for description.
   */
  com.google.protobuf.ByteString getDescriptionBytes();

  /**
   *
   *
   * <pre>
   * Output only. Source of the annotation.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.AnnotationSource annotation_source = 3;</code>
   *
   * @return The enum numeric value on the wire for annotationSource.
   */
  int getAnnotationSourceValue();
  /**
   *
   *
   * <pre>
   * Output only. Source of the annotation.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.AnnotationSource annotation_source = 3;</code>
   *
   * @return The annotationSource.
   */
  com.google.cloud.datalabeling.v1beta1.AnnotationSource getAnnotationSource();

  /**
   *
   *
   * <pre>
   * Output only. Type of the annotation. It is specified when starting labeling
   * task.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.AnnotationType annotation_type = 8;</code>
   *
   * @return The enum numeric value on the wire for annotationType.
   */
  int getAnnotationTypeValue();
  /**
   *
   *
   * <pre>
   * Output only. Type of the annotation. It is specified when starting labeling
   * task.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.AnnotationType annotation_type = 8;</code>
   *
   * @return The annotationType.
   */
  com.google.cloud.datalabeling.v1beta1.AnnotationType getAnnotationType();

  /**
   *
   *
   * <pre>
   * Output only. Number of examples in the annotated dataset.
   * </pre>
   *
   * <code>int64 example_count = 4;</code>
   *
   * @return The exampleCount.
   */
  long getExampleCount();

  /**
   *
   *
   * <pre>
   * Output only. Number of examples that have annotation in the annotated
   * dataset.
   * </pre>
   *
   * <code>int64 completed_example_count = 5;</code>
   *
   * @return The completedExampleCount.
   */
  long getCompletedExampleCount();

  /**
   *
   *
   * <pre>
   * Output only. Per label statistics.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.LabelStats label_stats = 6;</code>
   *
   * @return Whether the labelStats field is set.
   */
  boolean hasLabelStats();
  /**
   *
   *
   * <pre>
   * Output only. Per label statistics.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.LabelStats label_stats = 6;</code>
   *
   * @return The labelStats.
   */
  com.google.cloud.datalabeling.v1beta1.LabelStats getLabelStats();
  /**
   *
   *
   * <pre>
   * Output only. Per label statistics.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.LabelStats label_stats = 6;</code>
   */
  com.google.cloud.datalabeling.v1beta1.LabelStatsOrBuilder getLabelStatsOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. Time the AnnotatedDataset was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7;</code>
   *
   * @return Whether the createTime field is set.
   */
  boolean hasCreateTime();
  /**
   *
   *
   * <pre>
   * Output only. Time the AnnotatedDataset was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7;</code>
   *
   * @return The createTime.
   */
  com.google.protobuf.Timestamp getCreateTime();
  /**
   *
   *
   * <pre>
   * Output only. Time the AnnotatedDataset was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7;</code>
   */
  com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. Additional information about AnnotatedDataset.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata metadata = 10;</code>
   *
   * @return Whether the metadata field is set.
   */
  boolean hasMetadata();
  /**
   *
   *
   * <pre>
   * Output only. Additional information about AnnotatedDataset.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata metadata = 10;</code>
   *
   * @return The metadata.
   */
  com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata getMetadata();
  /**
   *
   *
   * <pre>
   * Output only. Additional information about AnnotatedDataset.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata metadata = 10;</code>
   */
  com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadataOrBuilder getMetadataOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. The names of any related resources that are blocking changes
   * to the annotated dataset.
   * </pre>
   *
   * <code>repeated string blocking_resources = 11;</code>
   *
   * @return A list containing the blockingResources.
   */
  java.util.List<java.lang.String> getBlockingResourcesList();
  /**
   *
   *
   * <pre>
   * Output only. The names of any related resources that are blocking changes
   * to the annotated dataset.
   * </pre>
   *
   * <code>repeated string blocking_resources = 11;</code>
   *
   * @return The count of blockingResources.
   */
  int getBlockingResourcesCount();
  /**
   *
   *
   * <pre>
   * Output only. The names of any related resources that are blocking changes
   * to the annotated dataset.
   * </pre>
   *
   * <code>repeated string blocking_resources = 11;</code>
   *
   * @param index The index of the element to return.
   * @return The blockingResources at the given index.
   */
  java.lang.String getBlockingResources(int index);
  /**
   *
   *
   * <pre>
   * Output only. The names of any related resources that are blocking changes
   * to the annotated dataset.
   * </pre>
   *
   * <code>repeated string blocking_resources = 11;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the blockingResources at the given index.
   */
  com.google.protobuf.ByteString getBlockingResourcesBytes(int index);
}
