/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datalabeling/v1beta1/annotation.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.datalabeling.v1beta1;

/**
 *
 *
 * <pre>
 * Annotation for Example. Each example may have one or more annotations. For
 * example in image classification problem, each image might have one or more
 * labels. We call labels binded with this image an Annotation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.datalabeling.v1beta1.Annotation}
 */
public final class Annotation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datalabeling.v1beta1.Annotation)
    AnnotationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Annotation.newBuilder() to construct.
  private Annotation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Annotation() {
    name_ = "";
    annotationSource_ = 0;
    annotationSentiment_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Annotation();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datalabeling.v1beta1.AnnotationOuterClass
        .internal_static_google_cloud_datalabeling_v1beta1_Annotation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datalabeling.v1beta1.AnnotationOuterClass
        .internal_static_google_cloud_datalabeling_v1beta1_Annotation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datalabeling.v1beta1.Annotation.class,
            com.google.cloud.datalabeling.v1beta1.Annotation.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Unique name of this annotation, format is:
   *
   * projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/{annotated_dataset}/examples/{example_id}/annotations/{annotation_id}
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Unique name of this annotation, format is:
   *
   * projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/{annotated_dataset}/examples/{example_id}/annotations/{annotation_id}
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ANNOTATION_SOURCE_FIELD_NUMBER = 2;
  private int annotationSource_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The source of the annotation.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.AnnotationSource annotation_source = 2;</code>
   *
   * @return The enum numeric value on the wire for annotationSource.
   */
  @java.lang.Override
  public int getAnnotationSourceValue() {
    return annotationSource_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The source of the annotation.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.AnnotationSource annotation_source = 2;</code>
   *
   * @return The annotationSource.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.AnnotationSource getAnnotationSource() {
    com.google.cloud.datalabeling.v1beta1.AnnotationSource result =
        com.google.cloud.datalabeling.v1beta1.AnnotationSource.forNumber(annotationSource_);
    return result == null
        ? com.google.cloud.datalabeling.v1beta1.AnnotationSource.UNRECOGNIZED
        : result;
  }

  public static final int ANNOTATION_VALUE_FIELD_NUMBER = 3;
  private com.google.cloud.datalabeling.v1beta1.AnnotationValue annotationValue_;
  /**
   *
   *
   * <pre>
   * Output only. This is the actual annotation value, e.g classification,
   * bounding box values are stored here.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.AnnotationValue annotation_value = 3;</code>
   *
   * @return Whether the annotationValue field is set.
   */
  @java.lang.Override
  public boolean hasAnnotationValue() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. This is the actual annotation value, e.g classification,
   * bounding box values are stored here.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.AnnotationValue annotation_value = 3;</code>
   *
   * @return The annotationValue.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.AnnotationValue getAnnotationValue() {
    return annotationValue_ == null
        ? com.google.cloud.datalabeling.v1beta1.AnnotationValue.getDefaultInstance()
        : annotationValue_;
  }
  /**
   *
   *
   * <pre>
   * Output only. This is the actual annotation value, e.g classification,
   * bounding box values are stored here.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.AnnotationValue annotation_value = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.AnnotationValueOrBuilder
      getAnnotationValueOrBuilder() {
    return annotationValue_ == null
        ? com.google.cloud.datalabeling.v1beta1.AnnotationValue.getDefaultInstance()
        : annotationValue_;
  }

  public static final int ANNOTATION_METADATA_FIELD_NUMBER = 4;
  private com.google.cloud.datalabeling.v1beta1.AnnotationMetadata annotationMetadata_;
  /**
   *
   *
   * <pre>
   * Output only. Annotation metadata, including information like votes
   * for labels.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.AnnotationMetadata annotation_metadata = 4;</code>
   *
   * @return Whether the annotationMetadata field is set.
   */
  @java.lang.Override
  public boolean hasAnnotationMetadata() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Annotation metadata, including information like votes
   * for labels.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.AnnotationMetadata annotation_metadata = 4;</code>
   *
   * @return The annotationMetadata.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.AnnotationMetadata getAnnotationMetadata() {
    return annotationMetadata_ == null
        ? com.google.cloud.datalabeling.v1beta1.AnnotationMetadata.getDefaultInstance()
        : annotationMetadata_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Annotation metadata, including information like votes
   * for labels.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.AnnotationMetadata annotation_metadata = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.AnnotationMetadataOrBuilder
      getAnnotationMetadataOrBuilder() {
    return annotationMetadata_ == null
        ? com.google.cloud.datalabeling.v1beta1.AnnotationMetadata.getDefaultInstance()
        : annotationMetadata_;
  }

  public static final int ANNOTATION_SENTIMENT_FIELD_NUMBER = 6;
  private int annotationSentiment_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. Sentiment for this annotation.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.AnnotationSentiment annotation_sentiment = 6;</code>
   *
   * @return The enum numeric value on the wire for annotationSentiment.
   */
  @java.lang.Override
  public int getAnnotationSentimentValue() {
    return annotationSentiment_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Sentiment for this annotation.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.AnnotationSentiment annotation_sentiment = 6;</code>
   *
   * @return The annotationSentiment.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.AnnotationSentiment getAnnotationSentiment() {
    com.google.cloud.datalabeling.v1beta1.AnnotationSentiment result =
        com.google.cloud.datalabeling.v1beta1.AnnotationSentiment.forNumber(annotationSentiment_);
    return result == null
        ? com.google.cloud.datalabeling.v1beta1.AnnotationSentiment.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (annotationSource_
        != com.google.cloud.datalabeling.v1beta1.AnnotationSource.ANNOTATION_SOURCE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, annotationSource_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getAnnotationValue());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getAnnotationMetadata());
    }
    if (annotationSentiment_
        != com.google.cloud.datalabeling.v1beta1.AnnotationSentiment
            .ANNOTATION_SENTIMENT_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(6, annotationSentiment_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (annotationSource_
        != com.google.cloud.datalabeling.v1beta1.AnnotationSource.ANNOTATION_SOURCE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, annotationSource_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getAnnotationValue());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getAnnotationMetadata());
    }
    if (annotationSentiment_
        != com.google.cloud.datalabeling.v1beta1.AnnotationSentiment
            .ANNOTATION_SENTIMENT_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, annotationSentiment_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datalabeling.v1beta1.Annotation)) {
      return super.equals(obj);
    }
    com.google.cloud.datalabeling.v1beta1.Annotation other =
        (com.google.cloud.datalabeling.v1beta1.Annotation) obj;

    if (!getName().equals(other.getName())) return false;
    if (annotationSource_ != other.annotationSource_) return false;
    if (hasAnnotationValue() != other.hasAnnotationValue()) return false;
    if (hasAnnotationValue()) {
      if (!getAnnotationValue().equals(other.getAnnotationValue())) return false;
    }
    if (hasAnnotationMetadata() != other.hasAnnotationMetadata()) return false;
    if (hasAnnotationMetadata()) {
      if (!getAnnotationMetadata().equals(other.getAnnotationMetadata())) return false;
    }
    if (annotationSentiment_ != other.annotationSentiment_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + ANNOTATION_SOURCE_FIELD_NUMBER;
    hash = (53 * hash) + annotationSource_;
    if (hasAnnotationValue()) {
      hash = (37 * hash) + ANNOTATION_VALUE_FIELD_NUMBER;
      hash = (53 * hash) + getAnnotationValue().hashCode();
    }
    if (hasAnnotationMetadata()) {
      hash = (37 * hash) + ANNOTATION_METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getAnnotationMetadata().hashCode();
    }
    hash = (37 * hash) + ANNOTATION_SENTIMENT_FIELD_NUMBER;
    hash = (53 * hash) + annotationSentiment_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datalabeling.v1beta1.Annotation parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.Annotation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.Annotation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.Annotation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.Annotation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.Annotation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.Annotation parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.Annotation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.Annotation parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.Annotation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.Annotation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.Annotation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.datalabeling.v1beta1.Annotation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Annotation for Example. Each example may have one or more annotations. For
   * example in image classification problem, each image might have one or more
   * labels. We call labels binded with this image an Annotation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datalabeling.v1beta1.Annotation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datalabeling.v1beta1.Annotation)
      com.google.cloud.datalabeling.v1beta1.AnnotationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datalabeling.v1beta1.AnnotationOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_Annotation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datalabeling.v1beta1.AnnotationOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_Annotation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datalabeling.v1beta1.Annotation.class,
              com.google.cloud.datalabeling.v1beta1.Annotation.Builder.class);
    }

    // Construct using com.google.cloud.datalabeling.v1beta1.Annotation.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getAnnotationValueFieldBuilder();
        getAnnotationMetadataFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      annotationSource_ = 0;
      annotationValue_ = null;
      if (annotationValueBuilder_ != null) {
        annotationValueBuilder_.dispose();
        annotationValueBuilder_ = null;
      }
      annotationMetadata_ = null;
      if (annotationMetadataBuilder_ != null) {
        annotationMetadataBuilder_.dispose();
        annotationMetadataBuilder_ = null;
      }
      annotationSentiment_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datalabeling.v1beta1.AnnotationOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_Annotation_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.Annotation getDefaultInstanceForType() {
      return com.google.cloud.datalabeling.v1beta1.Annotation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.Annotation build() {
      com.google.cloud.datalabeling.v1beta1.Annotation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.Annotation buildPartial() {
      com.google.cloud.datalabeling.v1beta1.Annotation result =
          new com.google.cloud.datalabeling.v1beta1.Annotation(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.datalabeling.v1beta1.Annotation result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.annotationSource_ = annotationSource_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.annotationValue_ =
            annotationValueBuilder_ == null ? annotationValue_ : annotationValueBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.annotationMetadata_ =
            annotationMetadataBuilder_ == null
                ? annotationMetadata_
                : annotationMetadataBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.annotationSentiment_ = annotationSentiment_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datalabeling.v1beta1.Annotation) {
        return mergeFrom((com.google.cloud.datalabeling.v1beta1.Annotation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datalabeling.v1beta1.Annotation other) {
      if (other == com.google.cloud.datalabeling.v1beta1.Annotation.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.annotationSource_ != 0) {
        setAnnotationSourceValue(other.getAnnotationSourceValue());
      }
      if (other.hasAnnotationValue()) {
        mergeAnnotationValue(other.getAnnotationValue());
      }
      if (other.hasAnnotationMetadata()) {
        mergeAnnotationMetadata(other.getAnnotationMetadata());
      }
      if (other.annotationSentiment_ != 0) {
        setAnnotationSentimentValue(other.getAnnotationSentimentValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                annotationSource_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                input.readMessage(getAnnotationValueFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getAnnotationMetadataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 48:
              {
                annotationSentiment_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 48
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Unique name of this annotation, format is:
     *
     * projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/{annotated_dataset}/examples/{example_id}/annotations/{annotation_id}
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique name of this annotation, format is:
     *
     * projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/{annotated_dataset}/examples/{example_id}/annotations/{annotation_id}
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique name of this annotation, format is:
     *
     * projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/{annotated_dataset}/examples/{example_id}/annotations/{annotation_id}
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique name of this annotation, format is:
     *
     * projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/{annotated_dataset}/examples/{example_id}/annotations/{annotation_id}
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique name of this annotation, format is:
     *
     * projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/{annotated_dataset}/examples/{example_id}/annotations/{annotation_id}
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int annotationSource_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The source of the annotation.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSource annotation_source = 2;</code>
     *
     * @return The enum numeric value on the wire for annotationSource.
     */
    @java.lang.Override
    public int getAnnotationSourceValue() {
      return annotationSource_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The source of the annotation.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSource annotation_source = 2;</code>
     *
     * @param value The enum numeric value on the wire for annotationSource to set.
     * @return This builder for chaining.
     */
    public Builder setAnnotationSourceValue(int value) {
      annotationSource_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The source of the annotation.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSource annotation_source = 2;</code>
     *
     * @return The annotationSource.
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.AnnotationSource getAnnotationSource() {
      com.google.cloud.datalabeling.v1beta1.AnnotationSource result =
          com.google.cloud.datalabeling.v1beta1.AnnotationSource.forNumber(annotationSource_);
      return result == null
          ? com.google.cloud.datalabeling.v1beta1.AnnotationSource.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The source of the annotation.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSource annotation_source = 2;</code>
     *
     * @param value The annotationSource to set.
     * @return This builder for chaining.
     */
    public Builder setAnnotationSource(
        com.google.cloud.datalabeling.v1beta1.AnnotationSource value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      annotationSource_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The source of the annotation.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSource annotation_source = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAnnotationSource() {
      bitField0_ = (bitField0_ & ~0x00000002);
      annotationSource_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.datalabeling.v1beta1.AnnotationValue annotationValue_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.AnnotationValue,
            com.google.cloud.datalabeling.v1beta1.AnnotationValue.Builder,
            com.google.cloud.datalabeling.v1beta1.AnnotationValueOrBuilder>
        annotationValueBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. This is the actual annotation value, e.g classification,
     * bounding box values are stored here.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationValue annotation_value = 3;</code>
     *
     * @return Whether the annotationValue field is set.
     */
    public boolean hasAnnotationValue() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. This is the actual annotation value, e.g classification,
     * bounding box values are stored here.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationValue annotation_value = 3;</code>
     *
     * @return The annotationValue.
     */
    public com.google.cloud.datalabeling.v1beta1.AnnotationValue getAnnotationValue() {
      if (annotationValueBuilder_ == null) {
        return annotationValue_ == null
            ? com.google.cloud.datalabeling.v1beta1.AnnotationValue.getDefaultInstance()
            : annotationValue_;
      } else {
        return annotationValueBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. This is the actual annotation value, e.g classification,
     * bounding box values are stored here.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationValue annotation_value = 3;</code>
     */
    public Builder setAnnotationValue(com.google.cloud.datalabeling.v1beta1.AnnotationValue value) {
      if (annotationValueBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        annotationValue_ = value;
      } else {
        annotationValueBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. This is the actual annotation value, e.g classification,
     * bounding box values are stored here.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationValue annotation_value = 3;</code>
     */
    public Builder setAnnotationValue(
        com.google.cloud.datalabeling.v1beta1.AnnotationValue.Builder builderForValue) {
      if (annotationValueBuilder_ == null) {
        annotationValue_ = builderForValue.build();
      } else {
        annotationValueBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. This is the actual annotation value, e.g classification,
     * bounding box values are stored here.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationValue annotation_value = 3;</code>
     */
    public Builder mergeAnnotationValue(
        com.google.cloud.datalabeling.v1beta1.AnnotationValue value) {
      if (annotationValueBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && annotationValue_ != null
            && annotationValue_
                != com.google.cloud.datalabeling.v1beta1.AnnotationValue.getDefaultInstance()) {
          getAnnotationValueBuilder().mergeFrom(value);
        } else {
          annotationValue_ = value;
        }
      } else {
        annotationValueBuilder_.mergeFrom(value);
      }
      if (annotationValue_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. This is the actual annotation value, e.g classification,
     * bounding box values are stored here.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationValue annotation_value = 3;</code>
     */
    public Builder clearAnnotationValue() {
      bitField0_ = (bitField0_ & ~0x00000004);
      annotationValue_ = null;
      if (annotationValueBuilder_ != null) {
        annotationValueBuilder_.dispose();
        annotationValueBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. This is the actual annotation value, e.g classification,
     * bounding box values are stored here.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationValue annotation_value = 3;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.AnnotationValue.Builder
        getAnnotationValueBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getAnnotationValueFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. This is the actual annotation value, e.g classification,
     * bounding box values are stored here.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationValue annotation_value = 3;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.AnnotationValueOrBuilder
        getAnnotationValueOrBuilder() {
      if (annotationValueBuilder_ != null) {
        return annotationValueBuilder_.getMessageOrBuilder();
      } else {
        return annotationValue_ == null
            ? com.google.cloud.datalabeling.v1beta1.AnnotationValue.getDefaultInstance()
            : annotationValue_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. This is the actual annotation value, e.g classification,
     * bounding box values are stored here.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationValue annotation_value = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.AnnotationValue,
            com.google.cloud.datalabeling.v1beta1.AnnotationValue.Builder,
            com.google.cloud.datalabeling.v1beta1.AnnotationValueOrBuilder>
        getAnnotationValueFieldBuilder() {
      if (annotationValueBuilder_ == null) {
        annotationValueBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.AnnotationValue,
                com.google.cloud.datalabeling.v1beta1.AnnotationValue.Builder,
                com.google.cloud.datalabeling.v1beta1.AnnotationValueOrBuilder>(
                getAnnotationValue(), getParentForChildren(), isClean());
        annotationValue_ = null;
      }
      return annotationValueBuilder_;
    }

    private com.google.cloud.datalabeling.v1beta1.AnnotationMetadata annotationMetadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.AnnotationMetadata,
            com.google.cloud.datalabeling.v1beta1.AnnotationMetadata.Builder,
            com.google.cloud.datalabeling.v1beta1.AnnotationMetadataOrBuilder>
        annotationMetadataBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Annotation metadata, including information like votes
     * for labels.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationMetadata annotation_metadata = 4;</code>
     *
     * @return Whether the annotationMetadata field is set.
     */
    public boolean hasAnnotationMetadata() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Annotation metadata, including information like votes
     * for labels.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationMetadata annotation_metadata = 4;</code>
     *
     * @return The annotationMetadata.
     */
    public com.google.cloud.datalabeling.v1beta1.AnnotationMetadata getAnnotationMetadata() {
      if (annotationMetadataBuilder_ == null) {
        return annotationMetadata_ == null
            ? com.google.cloud.datalabeling.v1beta1.AnnotationMetadata.getDefaultInstance()
            : annotationMetadata_;
      } else {
        return annotationMetadataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Annotation metadata, including information like votes
     * for labels.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationMetadata annotation_metadata = 4;</code>
     */
    public Builder setAnnotationMetadata(
        com.google.cloud.datalabeling.v1beta1.AnnotationMetadata value) {
      if (annotationMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        annotationMetadata_ = value;
      } else {
        annotationMetadataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Annotation metadata, including information like votes
     * for labels.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationMetadata annotation_metadata = 4;</code>
     */
    public Builder setAnnotationMetadata(
        com.google.cloud.datalabeling.v1beta1.AnnotationMetadata.Builder builderForValue) {
      if (annotationMetadataBuilder_ == null) {
        annotationMetadata_ = builderForValue.build();
      } else {
        annotationMetadataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Annotation metadata, including information like votes
     * for labels.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationMetadata annotation_metadata = 4;</code>
     */
    public Builder mergeAnnotationMetadata(
        com.google.cloud.datalabeling.v1beta1.AnnotationMetadata value) {
      if (annotationMetadataBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && annotationMetadata_ != null
            && annotationMetadata_
                != com.google.cloud.datalabeling.v1beta1.AnnotationMetadata.getDefaultInstance()) {
          getAnnotationMetadataBuilder().mergeFrom(value);
        } else {
          annotationMetadata_ = value;
        }
      } else {
        annotationMetadataBuilder_.mergeFrom(value);
      }
      if (annotationMetadata_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Annotation metadata, including information like votes
     * for labels.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationMetadata annotation_metadata = 4;</code>
     */
    public Builder clearAnnotationMetadata() {
      bitField0_ = (bitField0_ & ~0x00000008);
      annotationMetadata_ = null;
      if (annotationMetadataBuilder_ != null) {
        annotationMetadataBuilder_.dispose();
        annotationMetadataBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Annotation metadata, including information like votes
     * for labels.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationMetadata annotation_metadata = 4;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.AnnotationMetadata.Builder
        getAnnotationMetadataBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getAnnotationMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Annotation metadata, including information like votes
     * for labels.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationMetadata annotation_metadata = 4;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.AnnotationMetadataOrBuilder
        getAnnotationMetadataOrBuilder() {
      if (annotationMetadataBuilder_ != null) {
        return annotationMetadataBuilder_.getMessageOrBuilder();
      } else {
        return annotationMetadata_ == null
            ? com.google.cloud.datalabeling.v1beta1.AnnotationMetadata.getDefaultInstance()
            : annotationMetadata_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Annotation metadata, including information like votes
     * for labels.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationMetadata annotation_metadata = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.AnnotationMetadata,
            com.google.cloud.datalabeling.v1beta1.AnnotationMetadata.Builder,
            com.google.cloud.datalabeling.v1beta1.AnnotationMetadataOrBuilder>
        getAnnotationMetadataFieldBuilder() {
      if (annotationMetadataBuilder_ == null) {
        annotationMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.AnnotationMetadata,
                com.google.cloud.datalabeling.v1beta1.AnnotationMetadata.Builder,
                com.google.cloud.datalabeling.v1beta1.AnnotationMetadataOrBuilder>(
                getAnnotationMetadata(), getParentForChildren(), isClean());
        annotationMetadata_ = null;
      }
      return annotationMetadataBuilder_;
    }

    private int annotationSentiment_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. Sentiment for this annotation.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSentiment annotation_sentiment = 6;</code>
     *
     * @return The enum numeric value on the wire for annotationSentiment.
     */
    @java.lang.Override
    public int getAnnotationSentimentValue() {
      return annotationSentiment_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Sentiment for this annotation.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSentiment annotation_sentiment = 6;</code>
     *
     * @param value The enum numeric value on the wire for annotationSentiment to set.
     * @return This builder for chaining.
     */
    public Builder setAnnotationSentimentValue(int value) {
      annotationSentiment_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Sentiment for this annotation.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSentiment annotation_sentiment = 6;</code>
     *
     * @return The annotationSentiment.
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.AnnotationSentiment getAnnotationSentiment() {
      com.google.cloud.datalabeling.v1beta1.AnnotationSentiment result =
          com.google.cloud.datalabeling.v1beta1.AnnotationSentiment.forNumber(annotationSentiment_);
      return result == null
          ? com.google.cloud.datalabeling.v1beta1.AnnotationSentiment.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. Sentiment for this annotation.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSentiment annotation_sentiment = 6;</code>
     *
     * @param value The annotationSentiment to set.
     * @return This builder for chaining.
     */
    public Builder setAnnotationSentiment(
        com.google.cloud.datalabeling.v1beta1.AnnotationSentiment value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      annotationSentiment_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Sentiment for this annotation.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSentiment annotation_sentiment = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAnnotationSentiment() {
      bitField0_ = (bitField0_ & ~0x00000010);
      annotationSentiment_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datalabeling.v1beta1.Annotation)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datalabeling.v1beta1.Annotation)
  private static final com.google.cloud.datalabeling.v1beta1.Annotation DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datalabeling.v1beta1.Annotation();
  }

  public static com.google.cloud.datalabeling.v1beta1.Annotation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Annotation> PARSER =
      new com.google.protobuf.AbstractParser<Annotation>() {
        @java.lang.Override
        public Annotation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Annotation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Annotation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.Annotation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
