/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datalabeling/v1beta1/dataset.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.datalabeling.v1beta1;

/**
 *
 *
 * <pre>
 * Dataset is the resource to hold your data. You can request multiple labeling
 * tasks for a dataset while each one will generate an AnnotatedDataset.
 * </pre>
 *
 * Protobuf type {@code google.cloud.datalabeling.v1beta1.Dataset}
 */
public final class Dataset extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datalabeling.v1beta1.Dataset)
    DatasetOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Dataset.newBuilder() to construct.
  private Dataset(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Dataset() {
    name_ = "";
    displayName_ = "";
    description_ = "";
    inputConfigs_ = java.util.Collections.emptyList();
    blockingResources_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Dataset();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datalabeling.v1beta1.DatasetOuterClass
        .internal_static_google_cloud_datalabeling_v1beta1_Dataset_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datalabeling.v1beta1.DatasetOuterClass
        .internal_static_google_cloud_datalabeling_v1beta1_Dataset_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datalabeling.v1beta1.Dataset.class,
            com.google.cloud.datalabeling.v1beta1.Dataset.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Dataset resource name, format is:
   * projects/{project_id}/datasets/{dataset_id}
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Dataset resource name, format is:
   * projects/{project_id}/datasets/{dataset_id}
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Required. The display name of the dataset. Maximum of 64 characters.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The display name of the dataset. Maximum of 64 characters.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Optional. User-provided description of the annotation specification set.
   * The description can be up to 10000 characters long.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. User-provided description of the annotation specification set.
   * The description can be up to 10000 characters long.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time the dataset is created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4;</code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. Time the dataset is created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4;</code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time the dataset is created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int INPUT_CONFIGS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.datalabeling.v1beta1.InputConfig> inputConfigs_;
  /**
   *
   *
   * <pre>
   * Output only. This is populated with the original input configs
   * where ImportData is called. It is available only after the clients
   * import data to this dataset.
   * </pre>
   *
   * <code>repeated .google.cloud.datalabeling.v1beta1.InputConfig input_configs = 5;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.datalabeling.v1beta1.InputConfig> getInputConfigsList() {
    return inputConfigs_;
  }
  /**
   *
   *
   * <pre>
   * Output only. This is populated with the original input configs
   * where ImportData is called. It is available only after the clients
   * import data to this dataset.
   * </pre>
   *
   * <code>repeated .google.cloud.datalabeling.v1beta1.InputConfig input_configs = 5;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.datalabeling.v1beta1.InputConfigOrBuilder>
      getInputConfigsOrBuilderList() {
    return inputConfigs_;
  }
  /**
   *
   *
   * <pre>
   * Output only. This is populated with the original input configs
   * where ImportData is called. It is available only after the clients
   * import data to this dataset.
   * </pre>
   *
   * <code>repeated .google.cloud.datalabeling.v1beta1.InputConfig input_configs = 5;</code>
   */
  @java.lang.Override
  public int getInputConfigsCount() {
    return inputConfigs_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. This is populated with the original input configs
   * where ImportData is called. It is available only after the clients
   * import data to this dataset.
   * </pre>
   *
   * <code>repeated .google.cloud.datalabeling.v1beta1.InputConfig input_configs = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.InputConfig getInputConfigs(int index) {
    return inputConfigs_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. This is populated with the original input configs
   * where ImportData is called. It is available only after the clients
   * import data to this dataset.
   * </pre>
   *
   * <code>repeated .google.cloud.datalabeling.v1beta1.InputConfig input_configs = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.InputConfigOrBuilder getInputConfigsOrBuilder(
      int index) {
    return inputConfigs_.get(index);
  }

  public static final int BLOCKING_RESOURCES_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList blockingResources_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Output only. The names of any related resources that are blocking changes
   * to the dataset.
   * </pre>
   *
   * <code>repeated string blocking_resources = 6;</code>
   *
   * @return A list containing the blockingResources.
   */
  public com.google.protobuf.ProtocolStringList getBlockingResourcesList() {
    return blockingResources_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The names of any related resources that are blocking changes
   * to the dataset.
   * </pre>
   *
   * <code>repeated string blocking_resources = 6;</code>
   *
   * @return The count of blockingResources.
   */
  public int getBlockingResourcesCount() {
    return blockingResources_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The names of any related resources that are blocking changes
   * to the dataset.
   * </pre>
   *
   * <code>repeated string blocking_resources = 6;</code>
   *
   * @param index The index of the element to return.
   * @return The blockingResources at the given index.
   */
  public java.lang.String getBlockingResources(int index) {
    return blockingResources_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. The names of any related resources that are blocking changes
   * to the dataset.
   * </pre>
   *
   * <code>repeated string blocking_resources = 6;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the blockingResources at the given index.
   */
  public com.google.protobuf.ByteString getBlockingResourcesBytes(int index) {
    return blockingResources_.getByteString(index);
  }

  public static final int DATA_ITEM_COUNT_FIELD_NUMBER = 7;
  private long dataItemCount_ = 0L;
  /**
   *
   *
   * <pre>
   * Output only. The number of data items in the dataset.
   * </pre>
   *
   * <code>int64 data_item_count = 7;</code>
   *
   * @return The dataItemCount.
   */
  @java.lang.Override
  public long getDataItemCount() {
    return dataItemCount_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, description_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getCreateTime());
    }
    for (int i = 0; i < inputConfigs_.size(); i++) {
      output.writeMessage(5, inputConfigs_.get(i));
    }
    for (int i = 0; i < blockingResources_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, blockingResources_.getRaw(i));
    }
    if (dataItemCount_ != 0L) {
      output.writeInt64(7, dataItemCount_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, description_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getCreateTime());
    }
    for (int i = 0; i < inputConfigs_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, inputConfigs_.get(i));
    }
    {
      int dataSize = 0;
      for (int i = 0; i < blockingResources_.size(); i++) {
        dataSize += computeStringSizeNoTag(blockingResources_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getBlockingResourcesList().size();
    }
    if (dataItemCount_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(7, dataItemCount_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datalabeling.v1beta1.Dataset)) {
      return super.equals(obj);
    }
    com.google.cloud.datalabeling.v1beta1.Dataset other =
        (com.google.cloud.datalabeling.v1beta1.Dataset) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (!getInputConfigsList().equals(other.getInputConfigsList())) return false;
    if (!getBlockingResourcesList().equals(other.getBlockingResourcesList())) return false;
    if (getDataItemCount() != other.getDataItemCount()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (getInputConfigsCount() > 0) {
      hash = (37 * hash) + INPUT_CONFIGS_FIELD_NUMBER;
      hash = (53 * hash) + getInputConfigsList().hashCode();
    }
    if (getBlockingResourcesCount() > 0) {
      hash = (37 * hash) + BLOCKING_RESOURCES_FIELD_NUMBER;
      hash = (53 * hash) + getBlockingResourcesList().hashCode();
    }
    hash = (37 * hash) + DATA_ITEM_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getDataItemCount());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datalabeling.v1beta1.Dataset parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.Dataset parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.Dataset parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.Dataset parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.Dataset parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.Dataset parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.Dataset parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.Dataset parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.Dataset parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.Dataset parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.Dataset parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.Dataset parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.datalabeling.v1beta1.Dataset prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Dataset is the resource to hold your data. You can request multiple labeling
   * tasks for a dataset while each one will generate an AnnotatedDataset.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datalabeling.v1beta1.Dataset}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datalabeling.v1beta1.Dataset)
      com.google.cloud.datalabeling.v1beta1.DatasetOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datalabeling.v1beta1.DatasetOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_Dataset_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datalabeling.v1beta1.DatasetOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_Dataset_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datalabeling.v1beta1.Dataset.class,
              com.google.cloud.datalabeling.v1beta1.Dataset.Builder.class);
    }

    // Construct using com.google.cloud.datalabeling.v1beta1.Dataset.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getInputConfigsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      description_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      if (inputConfigsBuilder_ == null) {
        inputConfigs_ = java.util.Collections.emptyList();
      } else {
        inputConfigs_ = null;
        inputConfigsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      blockingResources_ = com.google.protobuf.LazyStringArrayList.emptyList();
      dataItemCount_ = 0L;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datalabeling.v1beta1.DatasetOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_Dataset_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.Dataset getDefaultInstanceForType() {
      return com.google.cloud.datalabeling.v1beta1.Dataset.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.Dataset build() {
      com.google.cloud.datalabeling.v1beta1.Dataset result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.Dataset buildPartial() {
      com.google.cloud.datalabeling.v1beta1.Dataset result =
          new com.google.cloud.datalabeling.v1beta1.Dataset(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.datalabeling.v1beta1.Dataset result) {
      if (inputConfigsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          inputConfigs_ = java.util.Collections.unmodifiableList(inputConfigs_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.inputConfigs_ = inputConfigs_;
      } else {
        result.inputConfigs_ = inputConfigsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.datalabeling.v1beta1.Dataset result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.description_ = description_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        blockingResources_.makeImmutable();
        result.blockingResources_ = blockingResources_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.dataItemCount_ = dataItemCount_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datalabeling.v1beta1.Dataset) {
        return mergeFrom((com.google.cloud.datalabeling.v1beta1.Dataset) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datalabeling.v1beta1.Dataset other) {
      if (other == com.google.cloud.datalabeling.v1beta1.Dataset.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (inputConfigsBuilder_ == null) {
        if (!other.inputConfigs_.isEmpty()) {
          if (inputConfigs_.isEmpty()) {
            inputConfigs_ = other.inputConfigs_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureInputConfigsIsMutable();
            inputConfigs_.addAll(other.inputConfigs_);
          }
          onChanged();
        }
      } else {
        if (!other.inputConfigs_.isEmpty()) {
          if (inputConfigsBuilder_.isEmpty()) {
            inputConfigsBuilder_.dispose();
            inputConfigsBuilder_ = null;
            inputConfigs_ = other.inputConfigs_;
            bitField0_ = (bitField0_ & ~0x00000010);
            inputConfigsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getInputConfigsFieldBuilder()
                    : null;
          } else {
            inputConfigsBuilder_.addAllMessages(other.inputConfigs_);
          }
        }
      }
      if (!other.blockingResources_.isEmpty()) {
        if (blockingResources_.isEmpty()) {
          blockingResources_ = other.blockingResources_;
          bitField0_ |= 0x00000020;
        } else {
          ensureBlockingResourcesIsMutable();
          blockingResources_.addAll(other.blockingResources_);
        }
        onChanged();
      }
      if (other.getDataItemCount() != 0L) {
        setDataItemCount(other.getDataItemCount());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                com.google.cloud.datalabeling.v1beta1.InputConfig m =
                    input.readMessage(
                        com.google.cloud.datalabeling.v1beta1.InputConfig.parser(),
                        extensionRegistry);
                if (inputConfigsBuilder_ == null) {
                  ensureInputConfigsIsMutable();
                  inputConfigs_.add(m);
                } else {
                  inputConfigsBuilder_.addMessage(m);
                }
                break;
              } // case 42
            case 50:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureBlockingResourcesIsMutable();
                blockingResources_.add(s);
                break;
              } // case 50
            case 56:
              {
                dataItemCount_ = input.readInt64();
                bitField0_ |= 0x00000040;
                break;
              } // case 56
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Dataset resource name, format is:
     * projects/{project_id}/datasets/{dataset_id}
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Dataset resource name, format is:
     * projects/{project_id}/datasets/{dataset_id}
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Dataset resource name, format is:
     * projects/{project_id}/datasets/{dataset_id}
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Dataset resource name, format is:
     * projects/{project_id}/datasets/{dataset_id}
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Dataset resource name, format is:
     * projects/{project_id}/datasets/{dataset_id}
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The display name of the dataset. Maximum of 64 characters.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the dataset. Maximum of 64 characters.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the dataset. Maximum of 64 characters.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the dataset. Maximum of 64 characters.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the dataset. Maximum of 64 characters.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Optional. User-provided description of the annotation specification set.
     * The description can be up to 10000 characters long.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. User-provided description of the annotation specification set.
     * The description can be up to 10000 characters long.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. User-provided description of the annotation specification set.
     * The description can be up to 10000 characters long.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. User-provided description of the annotation specification set.
     * The description can be up to 10000 characters long.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. User-provided description of the annotation specification set.
     * The description can be up to 10000 characters long.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time the dataset is created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Time the dataset is created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time the dataset is created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time the dataset is created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time the dataset is created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time the dataset is created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time the dataset is created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time the dataset is created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time the dataset is created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private java.util.List<com.google.cloud.datalabeling.v1beta1.InputConfig> inputConfigs_ =
        java.util.Collections.emptyList();

    private void ensureInputConfigsIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        inputConfigs_ =
            new java.util.ArrayList<com.google.cloud.datalabeling.v1beta1.InputConfig>(
                inputConfigs_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.InputConfig,
            com.google.cloud.datalabeling.v1beta1.InputConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.InputConfigOrBuilder>
        inputConfigsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. This is populated with the original input configs
     * where ImportData is called. It is available only after the clients
     * import data to this dataset.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.InputConfig input_configs = 5;</code>
     */
    public java.util.List<com.google.cloud.datalabeling.v1beta1.InputConfig> getInputConfigsList() {
      if (inputConfigsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(inputConfigs_);
      } else {
        return inputConfigsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. This is populated with the original input configs
     * where ImportData is called. It is available only after the clients
     * import data to this dataset.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.InputConfig input_configs = 5;</code>
     */
    public int getInputConfigsCount() {
      if (inputConfigsBuilder_ == null) {
        return inputConfigs_.size();
      } else {
        return inputConfigsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. This is populated with the original input configs
     * where ImportData is called. It is available only after the clients
     * import data to this dataset.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.InputConfig input_configs = 5;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.InputConfig getInputConfigs(int index) {
      if (inputConfigsBuilder_ == null) {
        return inputConfigs_.get(index);
      } else {
        return inputConfigsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. This is populated with the original input configs
     * where ImportData is called. It is available only after the clients
     * import data to this dataset.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.InputConfig input_configs = 5;</code>
     */
    public Builder setInputConfigs(
        int index, com.google.cloud.datalabeling.v1beta1.InputConfig value) {
      if (inputConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInputConfigsIsMutable();
        inputConfigs_.set(index, value);
        onChanged();
      } else {
        inputConfigsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. This is populated with the original input configs
     * where ImportData is called. It is available only after the clients
     * import data to this dataset.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.InputConfig input_configs = 5;</code>
     */
    public Builder setInputConfigs(
        int index, com.google.cloud.datalabeling.v1beta1.InputConfig.Builder builderForValue) {
      if (inputConfigsBuilder_ == null) {
        ensureInputConfigsIsMutable();
        inputConfigs_.set(index, builderForValue.build());
        onChanged();
      } else {
        inputConfigsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. This is populated with the original input configs
     * where ImportData is called. It is available only after the clients
     * import data to this dataset.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.InputConfig input_configs = 5;</code>
     */
    public Builder addInputConfigs(com.google.cloud.datalabeling.v1beta1.InputConfig value) {
      if (inputConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInputConfigsIsMutable();
        inputConfigs_.add(value);
        onChanged();
      } else {
        inputConfigsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. This is populated with the original input configs
     * where ImportData is called. It is available only after the clients
     * import data to this dataset.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.InputConfig input_configs = 5;</code>
     */
    public Builder addInputConfigs(
        int index, com.google.cloud.datalabeling.v1beta1.InputConfig value) {
      if (inputConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInputConfigsIsMutable();
        inputConfigs_.add(index, value);
        onChanged();
      } else {
        inputConfigsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. This is populated with the original input configs
     * where ImportData is called. It is available only after the clients
     * import data to this dataset.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.InputConfig input_configs = 5;</code>
     */
    public Builder addInputConfigs(
        com.google.cloud.datalabeling.v1beta1.InputConfig.Builder builderForValue) {
      if (inputConfigsBuilder_ == null) {
        ensureInputConfigsIsMutable();
        inputConfigs_.add(builderForValue.build());
        onChanged();
      } else {
        inputConfigsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. This is populated with the original input configs
     * where ImportData is called. It is available only after the clients
     * import data to this dataset.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.InputConfig input_configs = 5;</code>
     */
    public Builder addInputConfigs(
        int index, com.google.cloud.datalabeling.v1beta1.InputConfig.Builder builderForValue) {
      if (inputConfigsBuilder_ == null) {
        ensureInputConfigsIsMutable();
        inputConfigs_.add(index, builderForValue.build());
        onChanged();
      } else {
        inputConfigsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. This is populated with the original input configs
     * where ImportData is called. It is available only after the clients
     * import data to this dataset.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.InputConfig input_configs = 5;</code>
     */
    public Builder addAllInputConfigs(
        java.lang.Iterable<? extends com.google.cloud.datalabeling.v1beta1.InputConfig> values) {
      if (inputConfigsBuilder_ == null) {
        ensureInputConfigsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, inputConfigs_);
        onChanged();
      } else {
        inputConfigsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. This is populated with the original input configs
     * where ImportData is called. It is available only after the clients
     * import data to this dataset.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.InputConfig input_configs = 5;</code>
     */
    public Builder clearInputConfigs() {
      if (inputConfigsBuilder_ == null) {
        inputConfigs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        inputConfigsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. This is populated with the original input configs
     * where ImportData is called. It is available only after the clients
     * import data to this dataset.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.InputConfig input_configs = 5;</code>
     */
    public Builder removeInputConfigs(int index) {
      if (inputConfigsBuilder_ == null) {
        ensureInputConfigsIsMutable();
        inputConfigs_.remove(index);
        onChanged();
      } else {
        inputConfigsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. This is populated with the original input configs
     * where ImportData is called. It is available only after the clients
     * import data to this dataset.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.InputConfig input_configs = 5;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.InputConfig.Builder getInputConfigsBuilder(
        int index) {
      return getInputConfigsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. This is populated with the original input configs
     * where ImportData is called. It is available only after the clients
     * import data to this dataset.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.InputConfig input_configs = 5;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.InputConfigOrBuilder getInputConfigsOrBuilder(
        int index) {
      if (inputConfigsBuilder_ == null) {
        return inputConfigs_.get(index);
      } else {
        return inputConfigsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. This is populated with the original input configs
     * where ImportData is called. It is available only after the clients
     * import data to this dataset.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.InputConfig input_configs = 5;</code>
     */
    public java.util.List<? extends com.google.cloud.datalabeling.v1beta1.InputConfigOrBuilder>
        getInputConfigsOrBuilderList() {
      if (inputConfigsBuilder_ != null) {
        return inputConfigsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(inputConfigs_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. This is populated with the original input configs
     * where ImportData is called. It is available only after the clients
     * import data to this dataset.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.InputConfig input_configs = 5;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.InputConfig.Builder addInputConfigsBuilder() {
      return getInputConfigsFieldBuilder()
          .addBuilder(com.google.cloud.datalabeling.v1beta1.InputConfig.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. This is populated with the original input configs
     * where ImportData is called. It is available only after the clients
     * import data to this dataset.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.InputConfig input_configs = 5;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.InputConfig.Builder addInputConfigsBuilder(
        int index) {
      return getInputConfigsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.datalabeling.v1beta1.InputConfig.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. This is populated with the original input configs
     * where ImportData is called. It is available only after the clients
     * import data to this dataset.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.InputConfig input_configs = 5;</code>
     */
    public java.util.List<com.google.cloud.datalabeling.v1beta1.InputConfig.Builder>
        getInputConfigsBuilderList() {
      return getInputConfigsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.InputConfig,
            com.google.cloud.datalabeling.v1beta1.InputConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.InputConfigOrBuilder>
        getInputConfigsFieldBuilder() {
      if (inputConfigsBuilder_ == null) {
        inputConfigsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.InputConfig,
                com.google.cloud.datalabeling.v1beta1.InputConfig.Builder,
                com.google.cloud.datalabeling.v1beta1.InputConfigOrBuilder>(
                inputConfigs_, ((bitField0_ & 0x00000010) != 0), getParentForChildren(), isClean());
        inputConfigs_ = null;
      }
      return inputConfigsBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList blockingResources_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureBlockingResourcesIsMutable() {
      if (!blockingResources_.isModifiable()) {
        blockingResources_ = new com.google.protobuf.LazyStringArrayList(blockingResources_);
      }
      bitField0_ |= 0x00000020;
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of any related resources that are blocking changes
     * to the dataset.
     * </pre>
     *
     * <code>repeated string blocking_resources = 6;</code>
     *
     * @return A list containing the blockingResources.
     */
    public com.google.protobuf.ProtocolStringList getBlockingResourcesList() {
      blockingResources_.makeImmutable();
      return blockingResources_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of any related resources that are blocking changes
     * to the dataset.
     * </pre>
     *
     * <code>repeated string blocking_resources = 6;</code>
     *
     * @return The count of blockingResources.
     */
    public int getBlockingResourcesCount() {
      return blockingResources_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of any related resources that are blocking changes
     * to the dataset.
     * </pre>
     *
     * <code>repeated string blocking_resources = 6;</code>
     *
     * @param index The index of the element to return.
     * @return The blockingResources at the given index.
     */
    public java.lang.String getBlockingResources(int index) {
      return blockingResources_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of any related resources that are blocking changes
     * to the dataset.
     * </pre>
     *
     * <code>repeated string blocking_resources = 6;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the blockingResources at the given index.
     */
    public com.google.protobuf.ByteString getBlockingResourcesBytes(int index) {
      return blockingResources_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of any related resources that are blocking changes
     * to the dataset.
     * </pre>
     *
     * <code>repeated string blocking_resources = 6;</code>
     *
     * @param index The index to set the value at.
     * @param value The blockingResources to set.
     * @return This builder for chaining.
     */
    public Builder setBlockingResources(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureBlockingResourcesIsMutable();
      blockingResources_.set(index, value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of any related resources that are blocking changes
     * to the dataset.
     * </pre>
     *
     * <code>repeated string blocking_resources = 6;</code>
     *
     * @param value The blockingResources to add.
     * @return This builder for chaining.
     */
    public Builder addBlockingResources(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureBlockingResourcesIsMutable();
      blockingResources_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of any related resources that are blocking changes
     * to the dataset.
     * </pre>
     *
     * <code>repeated string blocking_resources = 6;</code>
     *
     * @param values The blockingResources to add.
     * @return This builder for chaining.
     */
    public Builder addAllBlockingResources(java.lang.Iterable<java.lang.String> values) {
      ensureBlockingResourcesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, blockingResources_);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of any related resources that are blocking changes
     * to the dataset.
     * </pre>
     *
     * <code>repeated string blocking_resources = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBlockingResources() {
      blockingResources_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000020);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of any related resources that are blocking changes
     * to the dataset.
     * </pre>
     *
     * <code>repeated string blocking_resources = 6;</code>
     *
     * @param value The bytes of the blockingResources to add.
     * @return This builder for chaining.
     */
    public Builder addBlockingResourcesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureBlockingResourcesIsMutable();
      blockingResources_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private long dataItemCount_;
    /**
     *
     *
     * <pre>
     * Output only. The number of data items in the dataset.
     * </pre>
     *
     * <code>int64 data_item_count = 7;</code>
     *
     * @return The dataItemCount.
     */
    @java.lang.Override
    public long getDataItemCount() {
      return dataItemCount_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The number of data items in the dataset.
     * </pre>
     *
     * <code>int64 data_item_count = 7;</code>
     *
     * @param value The dataItemCount to set.
     * @return This builder for chaining.
     */
    public Builder setDataItemCount(long value) {

      dataItemCount_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The number of data items in the dataset.
     * </pre>
     *
     * <code>int64 data_item_count = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDataItemCount() {
      bitField0_ = (bitField0_ & ~0x00000040);
      dataItemCount_ = 0L;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datalabeling.v1beta1.Dataset)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datalabeling.v1beta1.Dataset)
  private static final com.google.cloud.datalabeling.v1beta1.Dataset DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datalabeling.v1beta1.Dataset();
  }

  public static com.google.cloud.datalabeling.v1beta1.Dataset getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Dataset> PARSER =
      new com.google.protobuf.AbstractParser<Dataset>() {
        @java.lang.Override
        public Dataset parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Dataset> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Dataset> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.Dataset getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
