/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datalabeling/v1beta1/evaluation_job.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.datalabeling.v1beta1;

/**
 *
 *
 * <pre>
 * Configures specific details of how a continuous evaluation job works. Provide
 * this configuration when you create an EvaluationJob.
 * </pre>
 *
 * Protobuf type {@code google.cloud.datalabeling.v1beta1.EvaluationJobConfig}
 */
public final class EvaluationJobConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datalabeling.v1beta1.EvaluationJobConfig)
    EvaluationJobConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use EvaluationJobConfig.newBuilder() to construct.
  private EvaluationJobConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private EvaluationJobConfig() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new EvaluationJobConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datalabeling.v1beta1.EvaluationJobOuterClass
        .internal_static_google_cloud_datalabeling_v1beta1_EvaluationJobConfig_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 9:
        return internalGetBigqueryImportKeys();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datalabeling.v1beta1.EvaluationJobOuterClass
        .internal_static_google_cloud_datalabeling_v1beta1_EvaluationJobConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig.class,
            com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig.Builder.class);
  }

  private int bitField0_;
  private int humanAnnotationRequestConfigCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object humanAnnotationRequestConfig_;

  public enum HumanAnnotationRequestConfigCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    IMAGE_CLASSIFICATION_CONFIG(4),
    BOUNDING_POLY_CONFIG(5),
    TEXT_CLASSIFICATION_CONFIG(8),
    HUMANANNOTATIONREQUESTCONFIG_NOT_SET(0);
    private final int value;

    private HumanAnnotationRequestConfigCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static HumanAnnotationRequestConfigCase valueOf(int value) {
      return forNumber(value);
    }

    public static HumanAnnotationRequestConfigCase forNumber(int value) {
      switch (value) {
        case 4:
          return IMAGE_CLASSIFICATION_CONFIG;
        case 5:
          return BOUNDING_POLY_CONFIG;
        case 8:
          return TEXT_CLASSIFICATION_CONFIG;
        case 0:
          return HUMANANNOTATIONREQUESTCONFIG_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public HumanAnnotationRequestConfigCase getHumanAnnotationRequestConfigCase() {
    return HumanAnnotationRequestConfigCase.forNumber(humanAnnotationRequestConfigCase_);
  }

  public static final int IMAGE_CLASSIFICATION_CONFIG_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Specify this field if your model version performs image classification or
   * general classification.
   *
   * `annotationSpecSet` in this configuration must match
   * [EvaluationJob.annotationSpecSet][google.cloud.datalabeling.v1beta1.EvaluationJob.annotation_spec_set].
   * `allowMultiLabel` in this configuration must match
   * `classificationMetadata.isMultiLabel` in [input_config][google.cloud.datalabeling.v1beta1.EvaluationJobConfig.input_config].
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.ImageClassificationConfig image_classification_config = 4;
   * </code>
   *
   * @return Whether the imageClassificationConfig field is set.
   */
  @java.lang.Override
  public boolean hasImageClassificationConfig() {
    return humanAnnotationRequestConfigCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Specify this field if your model version performs image classification or
   * general classification.
   *
   * `annotationSpecSet` in this configuration must match
   * [EvaluationJob.annotationSpecSet][google.cloud.datalabeling.v1beta1.EvaluationJob.annotation_spec_set].
   * `allowMultiLabel` in this configuration must match
   * `classificationMetadata.isMultiLabel` in [input_config][google.cloud.datalabeling.v1beta1.EvaluationJobConfig.input_config].
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.ImageClassificationConfig image_classification_config = 4;
   * </code>
   *
   * @return The imageClassificationConfig.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig
      getImageClassificationConfig() {
    if (humanAnnotationRequestConfigCase_ == 4) {
      return (com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig)
          humanAnnotationRequestConfig_;
    }
    return com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Specify this field if your model version performs image classification or
   * general classification.
   *
   * `annotationSpecSet` in this configuration must match
   * [EvaluationJob.annotationSpecSet][google.cloud.datalabeling.v1beta1.EvaluationJob.annotation_spec_set].
   * `allowMultiLabel` in this configuration must match
   * `classificationMetadata.isMultiLabel` in [input_config][google.cloud.datalabeling.v1beta1.EvaluationJobConfig.input_config].
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.ImageClassificationConfig image_classification_config = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.ImageClassificationConfigOrBuilder
      getImageClassificationConfigOrBuilder() {
    if (humanAnnotationRequestConfigCase_ == 4) {
      return (com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig)
          humanAnnotationRequestConfig_;
    }
    return com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig.getDefaultInstance();
  }

  public static final int BOUNDING_POLY_CONFIG_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Specify this field if your model version performs image object detection
   * (bounding box detection).
   *
   * `annotationSpecSet` in this configuration must match
   * [EvaluationJob.annotationSpecSet][google.cloud.datalabeling.v1beta1.EvaluationJob.annotation_spec_set].
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.BoundingPolyConfig bounding_poly_config = 5;</code>
   *
   * @return Whether the boundingPolyConfig field is set.
   */
  @java.lang.Override
  public boolean hasBoundingPolyConfig() {
    return humanAnnotationRequestConfigCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Specify this field if your model version performs image object detection
   * (bounding box detection).
   *
   * `annotationSpecSet` in this configuration must match
   * [EvaluationJob.annotationSpecSet][google.cloud.datalabeling.v1beta1.EvaluationJob.annotation_spec_set].
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.BoundingPolyConfig bounding_poly_config = 5;</code>
   *
   * @return The boundingPolyConfig.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig getBoundingPolyConfig() {
    if (humanAnnotationRequestConfigCase_ == 5) {
      return (com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig)
          humanAnnotationRequestConfig_;
    }
    return com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Specify this field if your model version performs image object detection
   * (bounding box detection).
   *
   * `annotationSpecSet` in this configuration must match
   * [EvaluationJob.annotationSpecSet][google.cloud.datalabeling.v1beta1.EvaluationJob.annotation_spec_set].
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.BoundingPolyConfig bounding_poly_config = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.BoundingPolyConfigOrBuilder
      getBoundingPolyConfigOrBuilder() {
    if (humanAnnotationRequestConfigCase_ == 5) {
      return (com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig)
          humanAnnotationRequestConfig_;
    }
    return com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig.getDefaultInstance();
  }

  public static final int TEXT_CLASSIFICATION_CONFIG_FIELD_NUMBER = 8;
  /**
   *
   *
   * <pre>
   * Specify this field if your model version performs text classification.
   *
   * `annotationSpecSet` in this configuration must match
   * [EvaluationJob.annotationSpecSet][google.cloud.datalabeling.v1beta1.EvaluationJob.annotation_spec_set].
   * `allowMultiLabel` in this configuration must match
   * `classificationMetadata.isMultiLabel` in [input_config][google.cloud.datalabeling.v1beta1.EvaluationJobConfig.input_config].
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.TextClassificationConfig text_classification_config = 8;
   * </code>
   *
   * @return Whether the textClassificationConfig field is set.
   */
  @java.lang.Override
  public boolean hasTextClassificationConfig() {
    return humanAnnotationRequestConfigCase_ == 8;
  }
  /**
   *
   *
   * <pre>
   * Specify this field if your model version performs text classification.
   *
   * `annotationSpecSet` in this configuration must match
   * [EvaluationJob.annotationSpecSet][google.cloud.datalabeling.v1beta1.EvaluationJob.annotation_spec_set].
   * `allowMultiLabel` in this configuration must match
   * `classificationMetadata.isMultiLabel` in [input_config][google.cloud.datalabeling.v1beta1.EvaluationJobConfig.input_config].
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.TextClassificationConfig text_classification_config = 8;
   * </code>
   *
   * @return The textClassificationConfig.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.TextClassificationConfig
      getTextClassificationConfig() {
    if (humanAnnotationRequestConfigCase_ == 8) {
      return (com.google.cloud.datalabeling.v1beta1.TextClassificationConfig)
          humanAnnotationRequestConfig_;
    }
    return com.google.cloud.datalabeling.v1beta1.TextClassificationConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Specify this field if your model version performs text classification.
   *
   * `annotationSpecSet` in this configuration must match
   * [EvaluationJob.annotationSpecSet][google.cloud.datalabeling.v1beta1.EvaluationJob.annotation_spec_set].
   * `allowMultiLabel` in this configuration must match
   * `classificationMetadata.isMultiLabel` in [input_config][google.cloud.datalabeling.v1beta1.EvaluationJobConfig.input_config].
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.TextClassificationConfig text_classification_config = 8;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.TextClassificationConfigOrBuilder
      getTextClassificationConfigOrBuilder() {
    if (humanAnnotationRequestConfigCase_ == 8) {
      return (com.google.cloud.datalabeling.v1beta1.TextClassificationConfig)
          humanAnnotationRequestConfig_;
    }
    return com.google.cloud.datalabeling.v1beta1.TextClassificationConfig.getDefaultInstance();
  }

  public static final int INPUT_CONFIG_FIELD_NUMBER = 1;
  private com.google.cloud.datalabeling.v1beta1.InputConfig inputConfig_;
  /**
   *
   *
   * <pre>
   * Rquired. Details for the sampled prediction input. Within this
   * configuration, there are requirements for several fields:
   *
   * * `dataType` must be one of `IMAGE`, `TEXT`, or `GENERAL_DATA`.
   * * `annotationType` must be one of `IMAGE_CLASSIFICATION_ANNOTATION`,
   *   `TEXT_CLASSIFICATION_ANNOTATION`, `GENERAL_CLASSIFICATION_ANNOTATION`,
   *   or `IMAGE_BOUNDING_BOX_ANNOTATION` (image object detection).
   * * If your machine learning model performs classification, you must specify
   *   `classificationMetadata.isMultiLabel`.
   * * You must specify `bigquerySource` (not `gcsSource`).
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.InputConfig input_config = 1;</code>
   *
   * @return Whether the inputConfig field is set.
   */
  @java.lang.Override
  public boolean hasInputConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Rquired. Details for the sampled prediction input. Within this
   * configuration, there are requirements for several fields:
   *
   * * `dataType` must be one of `IMAGE`, `TEXT`, or `GENERAL_DATA`.
   * * `annotationType` must be one of `IMAGE_CLASSIFICATION_ANNOTATION`,
   *   `TEXT_CLASSIFICATION_ANNOTATION`, `GENERAL_CLASSIFICATION_ANNOTATION`,
   *   or `IMAGE_BOUNDING_BOX_ANNOTATION` (image object detection).
   * * If your machine learning model performs classification, you must specify
   *   `classificationMetadata.isMultiLabel`.
   * * You must specify `bigquerySource` (not `gcsSource`).
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.InputConfig input_config = 1;</code>
   *
   * @return The inputConfig.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.InputConfig getInputConfig() {
    return inputConfig_ == null
        ? com.google.cloud.datalabeling.v1beta1.InputConfig.getDefaultInstance()
        : inputConfig_;
  }
  /**
   *
   *
   * <pre>
   * Rquired. Details for the sampled prediction input. Within this
   * configuration, there are requirements for several fields:
   *
   * * `dataType` must be one of `IMAGE`, `TEXT`, or `GENERAL_DATA`.
   * * `annotationType` must be one of `IMAGE_CLASSIFICATION_ANNOTATION`,
   *   `TEXT_CLASSIFICATION_ANNOTATION`, `GENERAL_CLASSIFICATION_ANNOTATION`,
   *   or `IMAGE_BOUNDING_BOX_ANNOTATION` (image object detection).
   * * If your machine learning model performs classification, you must specify
   *   `classificationMetadata.isMultiLabel`.
   * * You must specify `bigquerySource` (not `gcsSource`).
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.InputConfig input_config = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.InputConfigOrBuilder getInputConfigOrBuilder() {
    return inputConfig_ == null
        ? com.google.cloud.datalabeling.v1beta1.InputConfig.getDefaultInstance()
        : inputConfig_;
  }

  public static final int EVALUATION_CONFIG_FIELD_NUMBER = 2;
  private com.google.cloud.datalabeling.v1beta1.EvaluationConfig evaluationConfig_;
  /**
   *
   *
   * <pre>
   * Required. Details for calculating evaluation metrics and creating
   * [Evaulations][google.cloud.datalabeling.v1beta1.Evaluation]. If your model version performs image object
   * detection, you must specify the `boundingBoxEvaluationOptions` field within
   * this configuration. Otherwise, provide an empty object for this
   * configuration.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.EvaluationConfig evaluation_config = 2;</code>
   *
   * @return Whether the evaluationConfig field is set.
   */
  @java.lang.Override
  public boolean hasEvaluationConfig() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. Details for calculating evaluation metrics and creating
   * [Evaulations][google.cloud.datalabeling.v1beta1.Evaluation]. If your model version performs image object
   * detection, you must specify the `boundingBoxEvaluationOptions` field within
   * this configuration. Otherwise, provide an empty object for this
   * configuration.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.EvaluationConfig evaluation_config = 2;</code>
   *
   * @return The evaluationConfig.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.EvaluationConfig getEvaluationConfig() {
    return evaluationConfig_ == null
        ? com.google.cloud.datalabeling.v1beta1.EvaluationConfig.getDefaultInstance()
        : evaluationConfig_;
  }
  /**
   *
   *
   * <pre>
   * Required. Details for calculating evaluation metrics and creating
   * [Evaulations][google.cloud.datalabeling.v1beta1.Evaluation]. If your model version performs image object
   * detection, you must specify the `boundingBoxEvaluationOptions` field within
   * this configuration. Otherwise, provide an empty object for this
   * configuration.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.EvaluationConfig evaluation_config = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.EvaluationConfigOrBuilder
      getEvaluationConfigOrBuilder() {
    return evaluationConfig_ == null
        ? com.google.cloud.datalabeling.v1beta1.EvaluationConfig.getDefaultInstance()
        : evaluationConfig_;
  }

  public static final int HUMAN_ANNOTATION_CONFIG_FIELD_NUMBER = 3;
  private com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig humanAnnotationConfig_;
  /**
   *
   *
   * <pre>
   * Optional. Details for human annotation of your data. If you set
   * [labelMissingGroundTruth][google.cloud.datalabeling.v1beta1.EvaluationJob.label_missing_ground_truth] to
   * `true` for this evaluation job, then you must specify this field. If you
   * plan to provide your own ground truth labels, then omit this field.
   *
   * Note that you must create an [Instruction][google.cloud.datalabeling.v1beta1.Instruction] resource before you can
   * specify this field. Provide the name of the instruction resource in the
   * `instruction` field within this configuration.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig human_annotation_config = 3;
   * </code>
   *
   * @return Whether the humanAnnotationConfig field is set.
   */
  @java.lang.Override
  public boolean hasHumanAnnotationConfig() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Details for human annotation of your data. If you set
   * [labelMissingGroundTruth][google.cloud.datalabeling.v1beta1.EvaluationJob.label_missing_ground_truth] to
   * `true` for this evaluation job, then you must specify this field. If you
   * plan to provide your own ground truth labels, then omit this field.
   *
   * Note that you must create an [Instruction][google.cloud.datalabeling.v1beta1.Instruction] resource before you can
   * specify this field. Provide the name of the instruction resource in the
   * `instruction` field within this configuration.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig human_annotation_config = 3;
   * </code>
   *
   * @return The humanAnnotationConfig.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig getHumanAnnotationConfig() {
    return humanAnnotationConfig_ == null
        ? com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.getDefaultInstance()
        : humanAnnotationConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Details for human annotation of your data. If you set
   * [labelMissingGroundTruth][google.cloud.datalabeling.v1beta1.EvaluationJob.label_missing_ground_truth] to
   * `true` for this evaluation job, then you must specify this field. If you
   * plan to provide your own ground truth labels, then omit this field.
   *
   * Note that you must create an [Instruction][google.cloud.datalabeling.v1beta1.Instruction] resource before you can
   * specify this field. Provide the name of the instruction resource in the
   * `instruction` field within this configuration.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig human_annotation_config = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfigOrBuilder
      getHumanAnnotationConfigOrBuilder() {
    return humanAnnotationConfig_ == null
        ? com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.getDefaultInstance()
        : humanAnnotationConfig_;
  }

  public static final int BIGQUERY_IMPORT_KEYS_FIELD_NUMBER = 9;

  private static final class BigqueryImportKeysDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.datalabeling.v1beta1.EvaluationJobOuterClass
                .internal_static_google_cloud_datalabeling_v1beta1_EvaluationJobConfig_BigqueryImportKeysEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> bigqueryImportKeys_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetBigqueryImportKeys() {
    if (bigqueryImportKeys_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          BigqueryImportKeysDefaultEntryHolder.defaultEntry);
    }
    return bigqueryImportKeys_;
  }

  public int getBigqueryImportKeysCount() {
    return internalGetBigqueryImportKeys().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Required. Prediction keys that tell Data Labeling Service where to find the
   * data for evaluation in your BigQuery table. When the service samples
   * prediction input and output from your model version and saves it to
   * BigQuery, the data gets stored as JSON strings in the BigQuery table. These
   * keys tell Data Labeling Service how to parse the JSON.
   *
   * You can provide the following entries in this field:
   *
   * * `data_json_key`: the data key for prediction input. You must provide
   *   either this key or `reference_json_key`.
   * * `reference_json_key`: the data reference key for prediction input. You
   *   must provide either this key or `data_json_key`.
   * * `label_json_key`: the label key for prediction output. Required.
   * * `label_score_json_key`: the score key for prediction output. Required.
   * * `bounding_box_json_key`: the bounding box key for prediction output.
   *   Required if your model version perform image object detection.
   *
   * Learn [how to configure prediction
   * keys](/ml-engine/docs/continuous-evaluation/create-job#prediction-keys).
   * </pre>
   *
   * <code>map&lt;string, string&gt; bigquery_import_keys = 9;</code>
   */
  @java.lang.Override
  public boolean containsBigqueryImportKeys(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetBigqueryImportKeys().getMap().containsKey(key);
  }
  /** Use {@link #getBigqueryImportKeysMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getBigqueryImportKeys() {
    return getBigqueryImportKeysMap();
  }
  /**
   *
   *
   * <pre>
   * Required. Prediction keys that tell Data Labeling Service where to find the
   * data for evaluation in your BigQuery table. When the service samples
   * prediction input and output from your model version and saves it to
   * BigQuery, the data gets stored as JSON strings in the BigQuery table. These
   * keys tell Data Labeling Service how to parse the JSON.
   *
   * You can provide the following entries in this field:
   *
   * * `data_json_key`: the data key for prediction input. You must provide
   *   either this key or `reference_json_key`.
   * * `reference_json_key`: the data reference key for prediction input. You
   *   must provide either this key or `data_json_key`.
   * * `label_json_key`: the label key for prediction output. Required.
   * * `label_score_json_key`: the score key for prediction output. Required.
   * * `bounding_box_json_key`: the bounding box key for prediction output.
   *   Required if your model version perform image object detection.
   *
   * Learn [how to configure prediction
   * keys](/ml-engine/docs/continuous-evaluation/create-job#prediction-keys).
   * </pre>
   *
   * <code>map&lt;string, string&gt; bigquery_import_keys = 9;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getBigqueryImportKeysMap() {
    return internalGetBigqueryImportKeys().getMap();
  }
  /**
   *
   *
   * <pre>
   * Required. Prediction keys that tell Data Labeling Service where to find the
   * data for evaluation in your BigQuery table. When the service samples
   * prediction input and output from your model version and saves it to
   * BigQuery, the data gets stored as JSON strings in the BigQuery table. These
   * keys tell Data Labeling Service how to parse the JSON.
   *
   * You can provide the following entries in this field:
   *
   * * `data_json_key`: the data key for prediction input. You must provide
   *   either this key or `reference_json_key`.
   * * `reference_json_key`: the data reference key for prediction input. You
   *   must provide either this key or `data_json_key`.
   * * `label_json_key`: the label key for prediction output. Required.
   * * `label_score_json_key`: the score key for prediction output. Required.
   * * `bounding_box_json_key`: the bounding box key for prediction output.
   *   Required if your model version perform image object detection.
   *
   * Learn [how to configure prediction
   * keys](/ml-engine/docs/continuous-evaluation/create-job#prediction-keys).
   * </pre>
   *
   * <code>map&lt;string, string&gt; bigquery_import_keys = 9;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getBigqueryImportKeysOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map =
        internalGetBigqueryImportKeys().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Required. Prediction keys that tell Data Labeling Service where to find the
   * data for evaluation in your BigQuery table. When the service samples
   * prediction input and output from your model version and saves it to
   * BigQuery, the data gets stored as JSON strings in the BigQuery table. These
   * keys tell Data Labeling Service how to parse the JSON.
   *
   * You can provide the following entries in this field:
   *
   * * `data_json_key`: the data key for prediction input. You must provide
   *   either this key or `reference_json_key`.
   * * `reference_json_key`: the data reference key for prediction input. You
   *   must provide either this key or `data_json_key`.
   * * `label_json_key`: the label key for prediction output. Required.
   * * `label_score_json_key`: the score key for prediction output. Required.
   * * `bounding_box_json_key`: the bounding box key for prediction output.
   *   Required if your model version perform image object detection.
   *
   * Learn [how to configure prediction
   * keys](/ml-engine/docs/continuous-evaluation/create-job#prediction-keys).
   * </pre>
   *
   * <code>map&lt;string, string&gt; bigquery_import_keys = 9;</code>
   */
  @java.lang.Override
  public java.lang.String getBigqueryImportKeysOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map =
        internalGetBigqueryImportKeys().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int EXAMPLE_COUNT_FIELD_NUMBER = 10;
  private int exampleCount_ = 0;
  /**
   *
   *
   * <pre>
   * Required. The maximum number of predictions to sample and save to BigQuery
   * during each [evaluation interval][google.cloud.datalabeling.v1beta1.EvaluationJob.schedule]. This limit
   * overrides `example_sample_percentage`: even if the service has not sampled
   * enough predictions to fulfill `example_sample_perecentage` during an
   * interval, it stops sampling predictions when it meets this limit.
   * </pre>
   *
   * <code>int32 example_count = 10;</code>
   *
   * @return The exampleCount.
   */
  @java.lang.Override
  public int getExampleCount() {
    return exampleCount_;
  }

  public static final int EXAMPLE_SAMPLE_PERCENTAGE_FIELD_NUMBER = 11;
  private double exampleSamplePercentage_ = 0D;
  /**
   *
   *
   * <pre>
   * Required. Fraction of predictions to sample and save to BigQuery during
   * each [evaluation interval][google.cloud.datalabeling.v1beta1.EvaluationJob.schedule]. For example, 0.1 means
   * 10% of predictions served by your model version get saved to BigQuery.
   * </pre>
   *
   * <code>double example_sample_percentage = 11;</code>
   *
   * @return The exampleSamplePercentage.
   */
  @java.lang.Override
  public double getExampleSamplePercentage() {
    return exampleSamplePercentage_;
  }

  public static final int EVALUATION_JOB_ALERT_CONFIG_FIELD_NUMBER = 13;
  private com.google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig evaluationJobAlertConfig_;
  /**
   *
   *
   * <pre>
   * Optional. Configuration details for evaluation job alerts. Specify this
   * field if you want to receive email alerts if the evaluation job finds that
   * your predictions have low mean average precision during a run.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig evaluation_job_alert_config = 13;
   * </code>
   *
   * @return Whether the evaluationJobAlertConfig field is set.
   */
  @java.lang.Override
  public boolean hasEvaluationJobAlertConfig() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. Configuration details for evaluation job alerts. Specify this
   * field if you want to receive email alerts if the evaluation job finds that
   * your predictions have low mean average precision during a run.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig evaluation_job_alert_config = 13;
   * </code>
   *
   * @return The evaluationJobAlertConfig.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig
      getEvaluationJobAlertConfig() {
    return evaluationJobAlertConfig_ == null
        ? com.google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig.getDefaultInstance()
        : evaluationJobAlertConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Configuration details for evaluation job alerts. Specify this
   * field if you want to receive email alerts if the evaluation job finds that
   * your predictions have low mean average precision during a run.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig evaluation_job_alert_config = 13;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfigOrBuilder
      getEvaluationJobAlertConfigOrBuilder() {
    return evaluationJobAlertConfig_ == null
        ? com.google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig.getDefaultInstance()
        : evaluationJobAlertConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getInputConfig());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getEvaluationConfig());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(3, getHumanAnnotationConfig());
    }
    if (humanAnnotationRequestConfigCase_ == 4) {
      output.writeMessage(
          4,
          (com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig)
              humanAnnotationRequestConfig_);
    }
    if (humanAnnotationRequestConfigCase_ == 5) {
      output.writeMessage(
          5,
          (com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig) humanAnnotationRequestConfig_);
    }
    if (humanAnnotationRequestConfigCase_ == 8) {
      output.writeMessage(
          8,
          (com.google.cloud.datalabeling.v1beta1.TextClassificationConfig)
              humanAnnotationRequestConfig_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output,
        internalGetBigqueryImportKeys(),
        BigqueryImportKeysDefaultEntryHolder.defaultEntry,
        9);
    if (exampleCount_ != 0) {
      output.writeInt32(10, exampleCount_);
    }
    if (java.lang.Double.doubleToRawLongBits(exampleSamplePercentage_) != 0) {
      output.writeDouble(11, exampleSamplePercentage_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(13, getEvaluationJobAlertConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getInputConfig());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getEvaluationConfig());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(3, getHumanAnnotationConfig());
    }
    if (humanAnnotationRequestConfigCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4,
              (com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig)
                  humanAnnotationRequestConfig_);
    }
    if (humanAnnotationRequestConfigCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5,
              (com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig)
                  humanAnnotationRequestConfig_);
    }
    if (humanAnnotationRequestConfigCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8,
              (com.google.cloud.datalabeling.v1beta1.TextClassificationConfig)
                  humanAnnotationRequestConfig_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetBigqueryImportKeys().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> bigqueryImportKeys__ =
          BigqueryImportKeysDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, bigqueryImportKeys__);
    }
    if (exampleCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(10, exampleCount_);
    }
    if (java.lang.Double.doubleToRawLongBits(exampleSamplePercentage_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(11, exampleSamplePercentage_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              13, getEvaluationJobAlertConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig other =
        (com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig) obj;

    if (hasInputConfig() != other.hasInputConfig()) return false;
    if (hasInputConfig()) {
      if (!getInputConfig().equals(other.getInputConfig())) return false;
    }
    if (hasEvaluationConfig() != other.hasEvaluationConfig()) return false;
    if (hasEvaluationConfig()) {
      if (!getEvaluationConfig().equals(other.getEvaluationConfig())) return false;
    }
    if (hasHumanAnnotationConfig() != other.hasHumanAnnotationConfig()) return false;
    if (hasHumanAnnotationConfig()) {
      if (!getHumanAnnotationConfig().equals(other.getHumanAnnotationConfig())) return false;
    }
    if (!internalGetBigqueryImportKeys().equals(other.internalGetBigqueryImportKeys()))
      return false;
    if (getExampleCount() != other.getExampleCount()) return false;
    if (java.lang.Double.doubleToLongBits(getExampleSamplePercentage())
        != java.lang.Double.doubleToLongBits(other.getExampleSamplePercentage())) return false;
    if (hasEvaluationJobAlertConfig() != other.hasEvaluationJobAlertConfig()) return false;
    if (hasEvaluationJobAlertConfig()) {
      if (!getEvaluationJobAlertConfig().equals(other.getEvaluationJobAlertConfig())) return false;
    }
    if (!getHumanAnnotationRequestConfigCase().equals(other.getHumanAnnotationRequestConfigCase()))
      return false;
    switch (humanAnnotationRequestConfigCase_) {
      case 4:
        if (!getImageClassificationConfig().equals(other.getImageClassificationConfig()))
          return false;
        break;
      case 5:
        if (!getBoundingPolyConfig().equals(other.getBoundingPolyConfig())) return false;
        break;
      case 8:
        if (!getTextClassificationConfig().equals(other.getTextClassificationConfig()))
          return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasInputConfig()) {
      hash = (37 * hash) + INPUT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getInputConfig().hashCode();
    }
    if (hasEvaluationConfig()) {
      hash = (37 * hash) + EVALUATION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getEvaluationConfig().hashCode();
    }
    if (hasHumanAnnotationConfig()) {
      hash = (37 * hash) + HUMAN_ANNOTATION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getHumanAnnotationConfig().hashCode();
    }
    if (!internalGetBigqueryImportKeys().getMap().isEmpty()) {
      hash = (37 * hash) + BIGQUERY_IMPORT_KEYS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetBigqueryImportKeys().hashCode();
    }
    hash = (37 * hash) + EXAMPLE_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getExampleCount();
    hash = (37 * hash) + EXAMPLE_SAMPLE_PERCENTAGE_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(
                java.lang.Double.doubleToLongBits(getExampleSamplePercentage()));
    if (hasEvaluationJobAlertConfig()) {
      hash = (37 * hash) + EVALUATION_JOB_ALERT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getEvaluationJobAlertConfig().hashCode();
    }
    switch (humanAnnotationRequestConfigCase_) {
      case 4:
        hash = (37 * hash) + IMAGE_CLASSIFICATION_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getImageClassificationConfig().hashCode();
        break;
      case 5:
        hash = (37 * hash) + BOUNDING_POLY_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getBoundingPolyConfig().hashCode();
        break;
      case 8:
        hash = (37 * hash) + TEXT_CLASSIFICATION_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getTextClassificationConfig().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Configures specific details of how a continuous evaluation job works. Provide
   * this configuration when you create an EvaluationJob.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datalabeling.v1beta1.EvaluationJobConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datalabeling.v1beta1.EvaluationJobConfig)
      com.google.cloud.datalabeling.v1beta1.EvaluationJobConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datalabeling.v1beta1.EvaluationJobOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_EvaluationJobConfig_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 9:
          return internalGetBigqueryImportKeys();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 9:
          return internalGetMutableBigqueryImportKeys();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datalabeling.v1beta1.EvaluationJobOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_EvaluationJobConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig.class,
              com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig.Builder.class);
    }

    // Construct using com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getInputConfigFieldBuilder();
        getEvaluationConfigFieldBuilder();
        getHumanAnnotationConfigFieldBuilder();
        getEvaluationJobAlertConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (imageClassificationConfigBuilder_ != null) {
        imageClassificationConfigBuilder_.clear();
      }
      if (boundingPolyConfigBuilder_ != null) {
        boundingPolyConfigBuilder_.clear();
      }
      if (textClassificationConfigBuilder_ != null) {
        textClassificationConfigBuilder_.clear();
      }
      inputConfig_ = null;
      if (inputConfigBuilder_ != null) {
        inputConfigBuilder_.dispose();
        inputConfigBuilder_ = null;
      }
      evaluationConfig_ = null;
      if (evaluationConfigBuilder_ != null) {
        evaluationConfigBuilder_.dispose();
        evaluationConfigBuilder_ = null;
      }
      humanAnnotationConfig_ = null;
      if (humanAnnotationConfigBuilder_ != null) {
        humanAnnotationConfigBuilder_.dispose();
        humanAnnotationConfigBuilder_ = null;
      }
      internalGetMutableBigqueryImportKeys().clear();
      exampleCount_ = 0;
      exampleSamplePercentage_ = 0D;
      evaluationJobAlertConfig_ = null;
      if (evaluationJobAlertConfigBuilder_ != null) {
        evaluationJobAlertConfigBuilder_.dispose();
        evaluationJobAlertConfigBuilder_ = null;
      }
      humanAnnotationRequestConfigCase_ = 0;
      humanAnnotationRequestConfig_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datalabeling.v1beta1.EvaluationJobOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_EvaluationJobConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig getDefaultInstanceForType() {
      return com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig build() {
      com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig buildPartial() {
      com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig result =
          new com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.inputConfig_ =
            inputConfigBuilder_ == null ? inputConfig_ : inputConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.evaluationConfig_ =
            evaluationConfigBuilder_ == null ? evaluationConfig_ : evaluationConfigBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.humanAnnotationConfig_ =
            humanAnnotationConfigBuilder_ == null
                ? humanAnnotationConfig_
                : humanAnnotationConfigBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.bigqueryImportKeys_ = internalGetBigqueryImportKeys();
        result.bigqueryImportKeys_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.exampleCount_ = exampleCount_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.exampleSamplePercentage_ = exampleSamplePercentage_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.evaluationJobAlertConfig_ =
            evaluationJobAlertConfigBuilder_ == null
                ? evaluationJobAlertConfig_
                : evaluationJobAlertConfigBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(
        com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig result) {
      result.humanAnnotationRequestConfigCase_ = humanAnnotationRequestConfigCase_;
      result.humanAnnotationRequestConfig_ = this.humanAnnotationRequestConfig_;
      if (humanAnnotationRequestConfigCase_ == 4 && imageClassificationConfigBuilder_ != null) {
        result.humanAnnotationRequestConfig_ = imageClassificationConfigBuilder_.build();
      }
      if (humanAnnotationRequestConfigCase_ == 5 && boundingPolyConfigBuilder_ != null) {
        result.humanAnnotationRequestConfig_ = boundingPolyConfigBuilder_.build();
      }
      if (humanAnnotationRequestConfigCase_ == 8 && textClassificationConfigBuilder_ != null) {
        result.humanAnnotationRequestConfig_ = textClassificationConfigBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig) {
        return mergeFrom((com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig other) {
      if (other == com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig.getDefaultInstance())
        return this;
      if (other.hasInputConfig()) {
        mergeInputConfig(other.getInputConfig());
      }
      if (other.hasEvaluationConfig()) {
        mergeEvaluationConfig(other.getEvaluationConfig());
      }
      if (other.hasHumanAnnotationConfig()) {
        mergeHumanAnnotationConfig(other.getHumanAnnotationConfig());
      }
      internalGetMutableBigqueryImportKeys().mergeFrom(other.internalGetBigqueryImportKeys());
      bitField0_ |= 0x00000040;
      if (other.getExampleCount() != 0) {
        setExampleCount(other.getExampleCount());
      }
      if (other.getExampleSamplePercentage() != 0D) {
        setExampleSamplePercentage(other.getExampleSamplePercentage());
      }
      if (other.hasEvaluationJobAlertConfig()) {
        mergeEvaluationJobAlertConfig(other.getEvaluationJobAlertConfig());
      }
      switch (other.getHumanAnnotationRequestConfigCase()) {
        case IMAGE_CLASSIFICATION_CONFIG:
          {
            mergeImageClassificationConfig(other.getImageClassificationConfig());
            break;
          }
        case BOUNDING_POLY_CONFIG:
          {
            mergeBoundingPolyConfig(other.getBoundingPolyConfig());
            break;
          }
        case TEXT_CLASSIFICATION_CONFIG:
          {
            mergeTextClassificationConfig(other.getTextClassificationConfig());
            break;
          }
        case HUMANANNOTATIONREQUESTCONFIG_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getInputConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getEvaluationConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getHumanAnnotationConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getImageClassificationConfigFieldBuilder().getBuilder(), extensionRegistry);
                humanAnnotationRequestConfigCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    getBoundingPolyConfigFieldBuilder().getBuilder(), extensionRegistry);
                humanAnnotationRequestConfigCase_ = 5;
                break;
              } // case 42
            case 66:
              {
                input.readMessage(
                    getTextClassificationConfigFieldBuilder().getBuilder(), extensionRegistry);
                humanAnnotationRequestConfigCase_ = 8;
                break;
              } // case 66
            case 74:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String>
                    bigqueryImportKeys__ =
                        input.readMessage(
                            BigqueryImportKeysDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableBigqueryImportKeys()
                    .getMutableMap()
                    .put(bigqueryImportKeys__.getKey(), bigqueryImportKeys__.getValue());
                bitField0_ |= 0x00000040;
                break;
              } // case 74
            case 80:
              {
                exampleCount_ = input.readInt32();
                bitField0_ |= 0x00000080;
                break;
              } // case 80
            case 89:
              {
                exampleSamplePercentage_ = input.readDouble();
                bitField0_ |= 0x00000100;
                break;
              } // case 89
            case 106:
              {
                input.readMessage(
                    getEvaluationJobAlertConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 106
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int humanAnnotationRequestConfigCase_ = 0;
    private java.lang.Object humanAnnotationRequestConfig_;

    public HumanAnnotationRequestConfigCase getHumanAnnotationRequestConfigCase() {
      return HumanAnnotationRequestConfigCase.forNumber(humanAnnotationRequestConfigCase_);
    }

    public Builder clearHumanAnnotationRequestConfig() {
      humanAnnotationRequestConfigCase_ = 0;
      humanAnnotationRequestConfig_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig,
            com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.ImageClassificationConfigOrBuilder>
        imageClassificationConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Specify this field if your model version performs image classification or
     * general classification.
     *
     * `annotationSpecSet` in this configuration must match
     * [EvaluationJob.annotationSpecSet][google.cloud.datalabeling.v1beta1.EvaluationJob.annotation_spec_set].
     * `allowMultiLabel` in this configuration must match
     * `classificationMetadata.isMultiLabel` in [input_config][google.cloud.datalabeling.v1beta1.EvaluationJobConfig.input_config].
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageClassificationConfig image_classification_config = 4;
     * </code>
     *
     * @return Whether the imageClassificationConfig field is set.
     */
    @java.lang.Override
    public boolean hasImageClassificationConfig() {
      return humanAnnotationRequestConfigCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Specify this field if your model version performs image classification or
     * general classification.
     *
     * `annotationSpecSet` in this configuration must match
     * [EvaluationJob.annotationSpecSet][google.cloud.datalabeling.v1beta1.EvaluationJob.annotation_spec_set].
     * `allowMultiLabel` in this configuration must match
     * `classificationMetadata.isMultiLabel` in [input_config][google.cloud.datalabeling.v1beta1.EvaluationJobConfig.input_config].
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageClassificationConfig image_classification_config = 4;
     * </code>
     *
     * @return The imageClassificationConfig.
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig
        getImageClassificationConfig() {
      if (imageClassificationConfigBuilder_ == null) {
        if (humanAnnotationRequestConfigCase_ == 4) {
          return (com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig)
              humanAnnotationRequestConfig_;
        }
        return com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig.getDefaultInstance();
      } else {
        if (humanAnnotationRequestConfigCase_ == 4) {
          return imageClassificationConfigBuilder_.getMessage();
        }
        return com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Specify this field if your model version performs image classification or
     * general classification.
     *
     * `annotationSpecSet` in this configuration must match
     * [EvaluationJob.annotationSpecSet][google.cloud.datalabeling.v1beta1.EvaluationJob.annotation_spec_set].
     * `allowMultiLabel` in this configuration must match
     * `classificationMetadata.isMultiLabel` in [input_config][google.cloud.datalabeling.v1beta1.EvaluationJobConfig.input_config].
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageClassificationConfig image_classification_config = 4;
     * </code>
     */
    public Builder setImageClassificationConfig(
        com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig value) {
      if (imageClassificationConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        humanAnnotationRequestConfig_ = value;
        onChanged();
      } else {
        imageClassificationConfigBuilder_.setMessage(value);
      }
      humanAnnotationRequestConfigCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specify this field if your model version performs image classification or
     * general classification.
     *
     * `annotationSpecSet` in this configuration must match
     * [EvaluationJob.annotationSpecSet][google.cloud.datalabeling.v1beta1.EvaluationJob.annotation_spec_set].
     * `allowMultiLabel` in this configuration must match
     * `classificationMetadata.isMultiLabel` in [input_config][google.cloud.datalabeling.v1beta1.EvaluationJobConfig.input_config].
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageClassificationConfig image_classification_config = 4;
     * </code>
     */
    public Builder setImageClassificationConfig(
        com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig.Builder builderForValue) {
      if (imageClassificationConfigBuilder_ == null) {
        humanAnnotationRequestConfig_ = builderForValue.build();
        onChanged();
      } else {
        imageClassificationConfigBuilder_.setMessage(builderForValue.build());
      }
      humanAnnotationRequestConfigCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specify this field if your model version performs image classification or
     * general classification.
     *
     * `annotationSpecSet` in this configuration must match
     * [EvaluationJob.annotationSpecSet][google.cloud.datalabeling.v1beta1.EvaluationJob.annotation_spec_set].
     * `allowMultiLabel` in this configuration must match
     * `classificationMetadata.isMultiLabel` in [input_config][google.cloud.datalabeling.v1beta1.EvaluationJobConfig.input_config].
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageClassificationConfig image_classification_config = 4;
     * </code>
     */
    public Builder mergeImageClassificationConfig(
        com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig value) {
      if (imageClassificationConfigBuilder_ == null) {
        if (humanAnnotationRequestConfigCase_ == 4
            && humanAnnotationRequestConfig_
                != com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig
                    .getDefaultInstance()) {
          humanAnnotationRequestConfig_ =
              com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig.newBuilder(
                      (com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig)
                          humanAnnotationRequestConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          humanAnnotationRequestConfig_ = value;
        }
        onChanged();
      } else {
        if (humanAnnotationRequestConfigCase_ == 4) {
          imageClassificationConfigBuilder_.mergeFrom(value);
        } else {
          imageClassificationConfigBuilder_.setMessage(value);
        }
      }
      humanAnnotationRequestConfigCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specify this field if your model version performs image classification or
     * general classification.
     *
     * `annotationSpecSet` in this configuration must match
     * [EvaluationJob.annotationSpecSet][google.cloud.datalabeling.v1beta1.EvaluationJob.annotation_spec_set].
     * `allowMultiLabel` in this configuration must match
     * `classificationMetadata.isMultiLabel` in [input_config][google.cloud.datalabeling.v1beta1.EvaluationJobConfig.input_config].
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageClassificationConfig image_classification_config = 4;
     * </code>
     */
    public Builder clearImageClassificationConfig() {
      if (imageClassificationConfigBuilder_ == null) {
        if (humanAnnotationRequestConfigCase_ == 4) {
          humanAnnotationRequestConfigCase_ = 0;
          humanAnnotationRequestConfig_ = null;
          onChanged();
        }
      } else {
        if (humanAnnotationRequestConfigCase_ == 4) {
          humanAnnotationRequestConfigCase_ = 0;
          humanAnnotationRequestConfig_ = null;
        }
        imageClassificationConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specify this field if your model version performs image classification or
     * general classification.
     *
     * `annotationSpecSet` in this configuration must match
     * [EvaluationJob.annotationSpecSet][google.cloud.datalabeling.v1beta1.EvaluationJob.annotation_spec_set].
     * `allowMultiLabel` in this configuration must match
     * `classificationMetadata.isMultiLabel` in [input_config][google.cloud.datalabeling.v1beta1.EvaluationJobConfig.input_config].
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageClassificationConfig image_classification_config = 4;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig.Builder
        getImageClassificationConfigBuilder() {
      return getImageClassificationConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Specify this field if your model version performs image classification or
     * general classification.
     *
     * `annotationSpecSet` in this configuration must match
     * [EvaluationJob.annotationSpecSet][google.cloud.datalabeling.v1beta1.EvaluationJob.annotation_spec_set].
     * `allowMultiLabel` in this configuration must match
     * `classificationMetadata.isMultiLabel` in [input_config][google.cloud.datalabeling.v1beta1.EvaluationJobConfig.input_config].
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageClassificationConfig image_classification_config = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.ImageClassificationConfigOrBuilder
        getImageClassificationConfigOrBuilder() {
      if ((humanAnnotationRequestConfigCase_ == 4) && (imageClassificationConfigBuilder_ != null)) {
        return imageClassificationConfigBuilder_.getMessageOrBuilder();
      } else {
        if (humanAnnotationRequestConfigCase_ == 4) {
          return (com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig)
              humanAnnotationRequestConfig_;
        }
        return com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Specify this field if your model version performs image classification or
     * general classification.
     *
     * `annotationSpecSet` in this configuration must match
     * [EvaluationJob.annotationSpecSet][google.cloud.datalabeling.v1beta1.EvaluationJob.annotation_spec_set].
     * `allowMultiLabel` in this configuration must match
     * `classificationMetadata.isMultiLabel` in [input_config][google.cloud.datalabeling.v1beta1.EvaluationJobConfig.input_config].
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageClassificationConfig image_classification_config = 4;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig,
            com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.ImageClassificationConfigOrBuilder>
        getImageClassificationConfigFieldBuilder() {
      if (imageClassificationConfigBuilder_ == null) {
        if (!(humanAnnotationRequestConfigCase_ == 4)) {
          humanAnnotationRequestConfig_ =
              com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig.getDefaultInstance();
        }
        imageClassificationConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig,
                com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig.Builder,
                com.google.cloud.datalabeling.v1beta1.ImageClassificationConfigOrBuilder>(
                (com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig)
                    humanAnnotationRequestConfig_,
                getParentForChildren(),
                isClean());
        humanAnnotationRequestConfig_ = null;
      }
      humanAnnotationRequestConfigCase_ = 4;
      onChanged();
      return imageClassificationConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig,
            com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.BoundingPolyConfigOrBuilder>
        boundingPolyConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Specify this field if your model version performs image object detection
     * (bounding box detection).
     *
     * `annotationSpecSet` in this configuration must match
     * [EvaluationJob.annotationSpecSet][google.cloud.datalabeling.v1beta1.EvaluationJob.annotation_spec_set].
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.BoundingPolyConfig bounding_poly_config = 5;</code>
     *
     * @return Whether the boundingPolyConfig field is set.
     */
    @java.lang.Override
    public boolean hasBoundingPolyConfig() {
      return humanAnnotationRequestConfigCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Specify this field if your model version performs image object detection
     * (bounding box detection).
     *
     * `annotationSpecSet` in this configuration must match
     * [EvaluationJob.annotationSpecSet][google.cloud.datalabeling.v1beta1.EvaluationJob.annotation_spec_set].
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.BoundingPolyConfig bounding_poly_config = 5;</code>
     *
     * @return The boundingPolyConfig.
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig getBoundingPolyConfig() {
      if (boundingPolyConfigBuilder_ == null) {
        if (humanAnnotationRequestConfigCase_ == 5) {
          return (com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig)
              humanAnnotationRequestConfig_;
        }
        return com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig.getDefaultInstance();
      } else {
        if (humanAnnotationRequestConfigCase_ == 5) {
          return boundingPolyConfigBuilder_.getMessage();
        }
        return com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Specify this field if your model version performs image object detection
     * (bounding box detection).
     *
     * `annotationSpecSet` in this configuration must match
     * [EvaluationJob.annotationSpecSet][google.cloud.datalabeling.v1beta1.EvaluationJob.annotation_spec_set].
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.BoundingPolyConfig bounding_poly_config = 5;</code>
     */
    public Builder setBoundingPolyConfig(
        com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig value) {
      if (boundingPolyConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        humanAnnotationRequestConfig_ = value;
        onChanged();
      } else {
        boundingPolyConfigBuilder_.setMessage(value);
      }
      humanAnnotationRequestConfigCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specify this field if your model version performs image object detection
     * (bounding box detection).
     *
     * `annotationSpecSet` in this configuration must match
     * [EvaluationJob.annotationSpecSet][google.cloud.datalabeling.v1beta1.EvaluationJob.annotation_spec_set].
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.BoundingPolyConfig bounding_poly_config = 5;</code>
     */
    public Builder setBoundingPolyConfig(
        com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig.Builder builderForValue) {
      if (boundingPolyConfigBuilder_ == null) {
        humanAnnotationRequestConfig_ = builderForValue.build();
        onChanged();
      } else {
        boundingPolyConfigBuilder_.setMessage(builderForValue.build());
      }
      humanAnnotationRequestConfigCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specify this field if your model version performs image object detection
     * (bounding box detection).
     *
     * `annotationSpecSet` in this configuration must match
     * [EvaluationJob.annotationSpecSet][google.cloud.datalabeling.v1beta1.EvaluationJob.annotation_spec_set].
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.BoundingPolyConfig bounding_poly_config = 5;</code>
     */
    public Builder mergeBoundingPolyConfig(
        com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig value) {
      if (boundingPolyConfigBuilder_ == null) {
        if (humanAnnotationRequestConfigCase_ == 5
            && humanAnnotationRequestConfig_
                != com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig.getDefaultInstance()) {
          humanAnnotationRequestConfig_ =
              com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig.newBuilder(
                      (com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig)
                          humanAnnotationRequestConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          humanAnnotationRequestConfig_ = value;
        }
        onChanged();
      } else {
        if (humanAnnotationRequestConfigCase_ == 5) {
          boundingPolyConfigBuilder_.mergeFrom(value);
        } else {
          boundingPolyConfigBuilder_.setMessage(value);
        }
      }
      humanAnnotationRequestConfigCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specify this field if your model version performs image object detection
     * (bounding box detection).
     *
     * `annotationSpecSet` in this configuration must match
     * [EvaluationJob.annotationSpecSet][google.cloud.datalabeling.v1beta1.EvaluationJob.annotation_spec_set].
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.BoundingPolyConfig bounding_poly_config = 5;</code>
     */
    public Builder clearBoundingPolyConfig() {
      if (boundingPolyConfigBuilder_ == null) {
        if (humanAnnotationRequestConfigCase_ == 5) {
          humanAnnotationRequestConfigCase_ = 0;
          humanAnnotationRequestConfig_ = null;
          onChanged();
        }
      } else {
        if (humanAnnotationRequestConfigCase_ == 5) {
          humanAnnotationRequestConfigCase_ = 0;
          humanAnnotationRequestConfig_ = null;
        }
        boundingPolyConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specify this field if your model version performs image object detection
     * (bounding box detection).
     *
     * `annotationSpecSet` in this configuration must match
     * [EvaluationJob.annotationSpecSet][google.cloud.datalabeling.v1beta1.EvaluationJob.annotation_spec_set].
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.BoundingPolyConfig bounding_poly_config = 5;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig.Builder
        getBoundingPolyConfigBuilder() {
      return getBoundingPolyConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Specify this field if your model version performs image object detection
     * (bounding box detection).
     *
     * `annotationSpecSet` in this configuration must match
     * [EvaluationJob.annotationSpecSet][google.cloud.datalabeling.v1beta1.EvaluationJob.annotation_spec_set].
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.BoundingPolyConfig bounding_poly_config = 5;</code>
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.BoundingPolyConfigOrBuilder
        getBoundingPolyConfigOrBuilder() {
      if ((humanAnnotationRequestConfigCase_ == 5) && (boundingPolyConfigBuilder_ != null)) {
        return boundingPolyConfigBuilder_.getMessageOrBuilder();
      } else {
        if (humanAnnotationRequestConfigCase_ == 5) {
          return (com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig)
              humanAnnotationRequestConfig_;
        }
        return com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Specify this field if your model version performs image object detection
     * (bounding box detection).
     *
     * `annotationSpecSet` in this configuration must match
     * [EvaluationJob.annotationSpecSet][google.cloud.datalabeling.v1beta1.EvaluationJob.annotation_spec_set].
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.BoundingPolyConfig bounding_poly_config = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig,
            com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.BoundingPolyConfigOrBuilder>
        getBoundingPolyConfigFieldBuilder() {
      if (boundingPolyConfigBuilder_ == null) {
        if (!(humanAnnotationRequestConfigCase_ == 5)) {
          humanAnnotationRequestConfig_ =
              com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig.getDefaultInstance();
        }
        boundingPolyConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig,
                com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig.Builder,
                com.google.cloud.datalabeling.v1beta1.BoundingPolyConfigOrBuilder>(
                (com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig)
                    humanAnnotationRequestConfig_,
                getParentForChildren(),
                isClean());
        humanAnnotationRequestConfig_ = null;
      }
      humanAnnotationRequestConfigCase_ = 5;
      onChanged();
      return boundingPolyConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.TextClassificationConfig,
            com.google.cloud.datalabeling.v1beta1.TextClassificationConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.TextClassificationConfigOrBuilder>
        textClassificationConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Specify this field if your model version performs text classification.
     *
     * `annotationSpecSet` in this configuration must match
     * [EvaluationJob.annotationSpecSet][google.cloud.datalabeling.v1beta1.EvaluationJob.annotation_spec_set].
     * `allowMultiLabel` in this configuration must match
     * `classificationMetadata.isMultiLabel` in [input_config][google.cloud.datalabeling.v1beta1.EvaluationJobConfig.input_config].
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextClassificationConfig text_classification_config = 8;
     * </code>
     *
     * @return Whether the textClassificationConfig field is set.
     */
    @java.lang.Override
    public boolean hasTextClassificationConfig() {
      return humanAnnotationRequestConfigCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * Specify this field if your model version performs text classification.
     *
     * `annotationSpecSet` in this configuration must match
     * [EvaluationJob.annotationSpecSet][google.cloud.datalabeling.v1beta1.EvaluationJob.annotation_spec_set].
     * `allowMultiLabel` in this configuration must match
     * `classificationMetadata.isMultiLabel` in [input_config][google.cloud.datalabeling.v1beta1.EvaluationJobConfig.input_config].
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextClassificationConfig text_classification_config = 8;
     * </code>
     *
     * @return The textClassificationConfig.
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.TextClassificationConfig
        getTextClassificationConfig() {
      if (textClassificationConfigBuilder_ == null) {
        if (humanAnnotationRequestConfigCase_ == 8) {
          return (com.google.cloud.datalabeling.v1beta1.TextClassificationConfig)
              humanAnnotationRequestConfig_;
        }
        return com.google.cloud.datalabeling.v1beta1.TextClassificationConfig.getDefaultInstance();
      } else {
        if (humanAnnotationRequestConfigCase_ == 8) {
          return textClassificationConfigBuilder_.getMessage();
        }
        return com.google.cloud.datalabeling.v1beta1.TextClassificationConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Specify this field if your model version performs text classification.
     *
     * `annotationSpecSet` in this configuration must match
     * [EvaluationJob.annotationSpecSet][google.cloud.datalabeling.v1beta1.EvaluationJob.annotation_spec_set].
     * `allowMultiLabel` in this configuration must match
     * `classificationMetadata.isMultiLabel` in [input_config][google.cloud.datalabeling.v1beta1.EvaluationJobConfig.input_config].
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextClassificationConfig text_classification_config = 8;
     * </code>
     */
    public Builder setTextClassificationConfig(
        com.google.cloud.datalabeling.v1beta1.TextClassificationConfig value) {
      if (textClassificationConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        humanAnnotationRequestConfig_ = value;
        onChanged();
      } else {
        textClassificationConfigBuilder_.setMessage(value);
      }
      humanAnnotationRequestConfigCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specify this field if your model version performs text classification.
     *
     * `annotationSpecSet` in this configuration must match
     * [EvaluationJob.annotationSpecSet][google.cloud.datalabeling.v1beta1.EvaluationJob.annotation_spec_set].
     * `allowMultiLabel` in this configuration must match
     * `classificationMetadata.isMultiLabel` in [input_config][google.cloud.datalabeling.v1beta1.EvaluationJobConfig.input_config].
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextClassificationConfig text_classification_config = 8;
     * </code>
     */
    public Builder setTextClassificationConfig(
        com.google.cloud.datalabeling.v1beta1.TextClassificationConfig.Builder builderForValue) {
      if (textClassificationConfigBuilder_ == null) {
        humanAnnotationRequestConfig_ = builderForValue.build();
        onChanged();
      } else {
        textClassificationConfigBuilder_.setMessage(builderForValue.build());
      }
      humanAnnotationRequestConfigCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specify this field if your model version performs text classification.
     *
     * `annotationSpecSet` in this configuration must match
     * [EvaluationJob.annotationSpecSet][google.cloud.datalabeling.v1beta1.EvaluationJob.annotation_spec_set].
     * `allowMultiLabel` in this configuration must match
     * `classificationMetadata.isMultiLabel` in [input_config][google.cloud.datalabeling.v1beta1.EvaluationJobConfig.input_config].
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextClassificationConfig text_classification_config = 8;
     * </code>
     */
    public Builder mergeTextClassificationConfig(
        com.google.cloud.datalabeling.v1beta1.TextClassificationConfig value) {
      if (textClassificationConfigBuilder_ == null) {
        if (humanAnnotationRequestConfigCase_ == 8
            && humanAnnotationRequestConfig_
                != com.google.cloud.datalabeling.v1beta1.TextClassificationConfig
                    .getDefaultInstance()) {
          humanAnnotationRequestConfig_ =
              com.google.cloud.datalabeling.v1beta1.TextClassificationConfig.newBuilder(
                      (com.google.cloud.datalabeling.v1beta1.TextClassificationConfig)
                          humanAnnotationRequestConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          humanAnnotationRequestConfig_ = value;
        }
        onChanged();
      } else {
        if (humanAnnotationRequestConfigCase_ == 8) {
          textClassificationConfigBuilder_.mergeFrom(value);
        } else {
          textClassificationConfigBuilder_.setMessage(value);
        }
      }
      humanAnnotationRequestConfigCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specify this field if your model version performs text classification.
     *
     * `annotationSpecSet` in this configuration must match
     * [EvaluationJob.annotationSpecSet][google.cloud.datalabeling.v1beta1.EvaluationJob.annotation_spec_set].
     * `allowMultiLabel` in this configuration must match
     * `classificationMetadata.isMultiLabel` in [input_config][google.cloud.datalabeling.v1beta1.EvaluationJobConfig.input_config].
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextClassificationConfig text_classification_config = 8;
     * </code>
     */
    public Builder clearTextClassificationConfig() {
      if (textClassificationConfigBuilder_ == null) {
        if (humanAnnotationRequestConfigCase_ == 8) {
          humanAnnotationRequestConfigCase_ = 0;
          humanAnnotationRequestConfig_ = null;
          onChanged();
        }
      } else {
        if (humanAnnotationRequestConfigCase_ == 8) {
          humanAnnotationRequestConfigCase_ = 0;
          humanAnnotationRequestConfig_ = null;
        }
        textClassificationConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specify this field if your model version performs text classification.
     *
     * `annotationSpecSet` in this configuration must match
     * [EvaluationJob.annotationSpecSet][google.cloud.datalabeling.v1beta1.EvaluationJob.annotation_spec_set].
     * `allowMultiLabel` in this configuration must match
     * `classificationMetadata.isMultiLabel` in [input_config][google.cloud.datalabeling.v1beta1.EvaluationJobConfig.input_config].
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextClassificationConfig text_classification_config = 8;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.TextClassificationConfig.Builder
        getTextClassificationConfigBuilder() {
      return getTextClassificationConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Specify this field if your model version performs text classification.
     *
     * `annotationSpecSet` in this configuration must match
     * [EvaluationJob.annotationSpecSet][google.cloud.datalabeling.v1beta1.EvaluationJob.annotation_spec_set].
     * `allowMultiLabel` in this configuration must match
     * `classificationMetadata.isMultiLabel` in [input_config][google.cloud.datalabeling.v1beta1.EvaluationJobConfig.input_config].
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextClassificationConfig text_classification_config = 8;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.TextClassificationConfigOrBuilder
        getTextClassificationConfigOrBuilder() {
      if ((humanAnnotationRequestConfigCase_ == 8) && (textClassificationConfigBuilder_ != null)) {
        return textClassificationConfigBuilder_.getMessageOrBuilder();
      } else {
        if (humanAnnotationRequestConfigCase_ == 8) {
          return (com.google.cloud.datalabeling.v1beta1.TextClassificationConfig)
              humanAnnotationRequestConfig_;
        }
        return com.google.cloud.datalabeling.v1beta1.TextClassificationConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Specify this field if your model version performs text classification.
     *
     * `annotationSpecSet` in this configuration must match
     * [EvaluationJob.annotationSpecSet][google.cloud.datalabeling.v1beta1.EvaluationJob.annotation_spec_set].
     * `allowMultiLabel` in this configuration must match
     * `classificationMetadata.isMultiLabel` in [input_config][google.cloud.datalabeling.v1beta1.EvaluationJobConfig.input_config].
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextClassificationConfig text_classification_config = 8;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.TextClassificationConfig,
            com.google.cloud.datalabeling.v1beta1.TextClassificationConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.TextClassificationConfigOrBuilder>
        getTextClassificationConfigFieldBuilder() {
      if (textClassificationConfigBuilder_ == null) {
        if (!(humanAnnotationRequestConfigCase_ == 8)) {
          humanAnnotationRequestConfig_ =
              com.google.cloud.datalabeling.v1beta1.TextClassificationConfig.getDefaultInstance();
        }
        textClassificationConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.TextClassificationConfig,
                com.google.cloud.datalabeling.v1beta1.TextClassificationConfig.Builder,
                com.google.cloud.datalabeling.v1beta1.TextClassificationConfigOrBuilder>(
                (com.google.cloud.datalabeling.v1beta1.TextClassificationConfig)
                    humanAnnotationRequestConfig_,
                getParentForChildren(),
                isClean());
        humanAnnotationRequestConfig_ = null;
      }
      humanAnnotationRequestConfigCase_ = 8;
      onChanged();
      return textClassificationConfigBuilder_;
    }

    private com.google.cloud.datalabeling.v1beta1.InputConfig inputConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.InputConfig,
            com.google.cloud.datalabeling.v1beta1.InputConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.InputConfigOrBuilder>
        inputConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Rquired. Details for the sampled prediction input. Within this
     * configuration, there are requirements for several fields:
     *
     * * `dataType` must be one of `IMAGE`, `TEXT`, or `GENERAL_DATA`.
     * * `annotationType` must be one of `IMAGE_CLASSIFICATION_ANNOTATION`,
     *   `TEXT_CLASSIFICATION_ANNOTATION`, `GENERAL_CLASSIFICATION_ANNOTATION`,
     *   or `IMAGE_BOUNDING_BOX_ANNOTATION` (image object detection).
     * * If your machine learning model performs classification, you must specify
     *   `classificationMetadata.isMultiLabel`.
     * * You must specify `bigquerySource` (not `gcsSource`).
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.InputConfig input_config = 1;</code>
     *
     * @return Whether the inputConfig field is set.
     */
    public boolean hasInputConfig() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Rquired. Details for the sampled prediction input. Within this
     * configuration, there are requirements for several fields:
     *
     * * `dataType` must be one of `IMAGE`, `TEXT`, or `GENERAL_DATA`.
     * * `annotationType` must be one of `IMAGE_CLASSIFICATION_ANNOTATION`,
     *   `TEXT_CLASSIFICATION_ANNOTATION`, `GENERAL_CLASSIFICATION_ANNOTATION`,
     *   or `IMAGE_BOUNDING_BOX_ANNOTATION` (image object detection).
     * * If your machine learning model performs classification, you must specify
     *   `classificationMetadata.isMultiLabel`.
     * * You must specify `bigquerySource` (not `gcsSource`).
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.InputConfig input_config = 1;</code>
     *
     * @return The inputConfig.
     */
    public com.google.cloud.datalabeling.v1beta1.InputConfig getInputConfig() {
      if (inputConfigBuilder_ == null) {
        return inputConfig_ == null
            ? com.google.cloud.datalabeling.v1beta1.InputConfig.getDefaultInstance()
            : inputConfig_;
      } else {
        return inputConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Rquired. Details for the sampled prediction input. Within this
     * configuration, there are requirements for several fields:
     *
     * * `dataType` must be one of `IMAGE`, `TEXT`, or `GENERAL_DATA`.
     * * `annotationType` must be one of `IMAGE_CLASSIFICATION_ANNOTATION`,
     *   `TEXT_CLASSIFICATION_ANNOTATION`, `GENERAL_CLASSIFICATION_ANNOTATION`,
     *   or `IMAGE_BOUNDING_BOX_ANNOTATION` (image object detection).
     * * If your machine learning model performs classification, you must specify
     *   `classificationMetadata.isMultiLabel`.
     * * You must specify `bigquerySource` (not `gcsSource`).
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.InputConfig input_config = 1;</code>
     */
    public Builder setInputConfig(com.google.cloud.datalabeling.v1beta1.InputConfig value) {
      if (inputConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        inputConfig_ = value;
      } else {
        inputConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rquired. Details for the sampled prediction input. Within this
     * configuration, there are requirements for several fields:
     *
     * * `dataType` must be one of `IMAGE`, `TEXT`, or `GENERAL_DATA`.
     * * `annotationType` must be one of `IMAGE_CLASSIFICATION_ANNOTATION`,
     *   `TEXT_CLASSIFICATION_ANNOTATION`, `GENERAL_CLASSIFICATION_ANNOTATION`,
     *   or `IMAGE_BOUNDING_BOX_ANNOTATION` (image object detection).
     * * If your machine learning model performs classification, you must specify
     *   `classificationMetadata.isMultiLabel`.
     * * You must specify `bigquerySource` (not `gcsSource`).
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.InputConfig input_config = 1;</code>
     */
    public Builder setInputConfig(
        com.google.cloud.datalabeling.v1beta1.InputConfig.Builder builderForValue) {
      if (inputConfigBuilder_ == null) {
        inputConfig_ = builderForValue.build();
      } else {
        inputConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rquired. Details for the sampled prediction input. Within this
     * configuration, there are requirements for several fields:
     *
     * * `dataType` must be one of `IMAGE`, `TEXT`, or `GENERAL_DATA`.
     * * `annotationType` must be one of `IMAGE_CLASSIFICATION_ANNOTATION`,
     *   `TEXT_CLASSIFICATION_ANNOTATION`, `GENERAL_CLASSIFICATION_ANNOTATION`,
     *   or `IMAGE_BOUNDING_BOX_ANNOTATION` (image object detection).
     * * If your machine learning model performs classification, you must specify
     *   `classificationMetadata.isMultiLabel`.
     * * You must specify `bigquerySource` (not `gcsSource`).
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.InputConfig input_config = 1;</code>
     */
    public Builder mergeInputConfig(com.google.cloud.datalabeling.v1beta1.InputConfig value) {
      if (inputConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && inputConfig_ != null
            && inputConfig_
                != com.google.cloud.datalabeling.v1beta1.InputConfig.getDefaultInstance()) {
          getInputConfigBuilder().mergeFrom(value);
        } else {
          inputConfig_ = value;
        }
      } else {
        inputConfigBuilder_.mergeFrom(value);
      }
      if (inputConfig_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rquired. Details for the sampled prediction input. Within this
     * configuration, there are requirements for several fields:
     *
     * * `dataType` must be one of `IMAGE`, `TEXT`, or `GENERAL_DATA`.
     * * `annotationType` must be one of `IMAGE_CLASSIFICATION_ANNOTATION`,
     *   `TEXT_CLASSIFICATION_ANNOTATION`, `GENERAL_CLASSIFICATION_ANNOTATION`,
     *   or `IMAGE_BOUNDING_BOX_ANNOTATION` (image object detection).
     * * If your machine learning model performs classification, you must specify
     *   `classificationMetadata.isMultiLabel`.
     * * You must specify `bigquerySource` (not `gcsSource`).
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.InputConfig input_config = 1;</code>
     */
    public Builder clearInputConfig() {
      bitField0_ = (bitField0_ & ~0x00000008);
      inputConfig_ = null;
      if (inputConfigBuilder_ != null) {
        inputConfigBuilder_.dispose();
        inputConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rquired. Details for the sampled prediction input. Within this
     * configuration, there are requirements for several fields:
     *
     * * `dataType` must be one of `IMAGE`, `TEXT`, or `GENERAL_DATA`.
     * * `annotationType` must be one of `IMAGE_CLASSIFICATION_ANNOTATION`,
     *   `TEXT_CLASSIFICATION_ANNOTATION`, `GENERAL_CLASSIFICATION_ANNOTATION`,
     *   or `IMAGE_BOUNDING_BOX_ANNOTATION` (image object detection).
     * * If your machine learning model performs classification, you must specify
     *   `classificationMetadata.isMultiLabel`.
     * * You must specify `bigquerySource` (not `gcsSource`).
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.InputConfig input_config = 1;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.InputConfig.Builder getInputConfigBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getInputConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Rquired. Details for the sampled prediction input. Within this
     * configuration, there are requirements for several fields:
     *
     * * `dataType` must be one of `IMAGE`, `TEXT`, or `GENERAL_DATA`.
     * * `annotationType` must be one of `IMAGE_CLASSIFICATION_ANNOTATION`,
     *   `TEXT_CLASSIFICATION_ANNOTATION`, `GENERAL_CLASSIFICATION_ANNOTATION`,
     *   or `IMAGE_BOUNDING_BOX_ANNOTATION` (image object detection).
     * * If your machine learning model performs classification, you must specify
     *   `classificationMetadata.isMultiLabel`.
     * * You must specify `bigquerySource` (not `gcsSource`).
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.InputConfig input_config = 1;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.InputConfigOrBuilder getInputConfigOrBuilder() {
      if (inputConfigBuilder_ != null) {
        return inputConfigBuilder_.getMessageOrBuilder();
      } else {
        return inputConfig_ == null
            ? com.google.cloud.datalabeling.v1beta1.InputConfig.getDefaultInstance()
            : inputConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Rquired. Details for the sampled prediction input. Within this
     * configuration, there are requirements for several fields:
     *
     * * `dataType` must be one of `IMAGE`, `TEXT`, or `GENERAL_DATA`.
     * * `annotationType` must be one of `IMAGE_CLASSIFICATION_ANNOTATION`,
     *   `TEXT_CLASSIFICATION_ANNOTATION`, `GENERAL_CLASSIFICATION_ANNOTATION`,
     *   or `IMAGE_BOUNDING_BOX_ANNOTATION` (image object detection).
     * * If your machine learning model performs classification, you must specify
     *   `classificationMetadata.isMultiLabel`.
     * * You must specify `bigquerySource` (not `gcsSource`).
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.InputConfig input_config = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.InputConfig,
            com.google.cloud.datalabeling.v1beta1.InputConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.InputConfigOrBuilder>
        getInputConfigFieldBuilder() {
      if (inputConfigBuilder_ == null) {
        inputConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.InputConfig,
                com.google.cloud.datalabeling.v1beta1.InputConfig.Builder,
                com.google.cloud.datalabeling.v1beta1.InputConfigOrBuilder>(
                getInputConfig(), getParentForChildren(), isClean());
        inputConfig_ = null;
      }
      return inputConfigBuilder_;
    }

    private com.google.cloud.datalabeling.v1beta1.EvaluationConfig evaluationConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.EvaluationConfig,
            com.google.cloud.datalabeling.v1beta1.EvaluationConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.EvaluationConfigOrBuilder>
        evaluationConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Details for calculating evaluation metrics and creating
     * [Evaulations][google.cloud.datalabeling.v1beta1.Evaluation]. If your model version performs image object
     * detection, you must specify the `boundingBoxEvaluationOptions` field within
     * this configuration. Otherwise, provide an empty object for this
     * configuration.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EvaluationConfig evaluation_config = 2;</code>
     *
     * @return Whether the evaluationConfig field is set.
     */
    public boolean hasEvaluationConfig() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Details for calculating evaluation metrics and creating
     * [Evaulations][google.cloud.datalabeling.v1beta1.Evaluation]. If your model version performs image object
     * detection, you must specify the `boundingBoxEvaluationOptions` field within
     * this configuration. Otherwise, provide an empty object for this
     * configuration.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EvaluationConfig evaluation_config = 2;</code>
     *
     * @return The evaluationConfig.
     */
    public com.google.cloud.datalabeling.v1beta1.EvaluationConfig getEvaluationConfig() {
      if (evaluationConfigBuilder_ == null) {
        return evaluationConfig_ == null
            ? com.google.cloud.datalabeling.v1beta1.EvaluationConfig.getDefaultInstance()
            : evaluationConfig_;
      } else {
        return evaluationConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Details for calculating evaluation metrics and creating
     * [Evaulations][google.cloud.datalabeling.v1beta1.Evaluation]. If your model version performs image object
     * detection, you must specify the `boundingBoxEvaluationOptions` field within
     * this configuration. Otherwise, provide an empty object for this
     * configuration.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EvaluationConfig evaluation_config = 2;</code>
     */
    public Builder setEvaluationConfig(
        com.google.cloud.datalabeling.v1beta1.EvaluationConfig value) {
      if (evaluationConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        evaluationConfig_ = value;
      } else {
        evaluationConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Details for calculating evaluation metrics and creating
     * [Evaulations][google.cloud.datalabeling.v1beta1.Evaluation]. If your model version performs image object
     * detection, you must specify the `boundingBoxEvaluationOptions` field within
     * this configuration. Otherwise, provide an empty object for this
     * configuration.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EvaluationConfig evaluation_config = 2;</code>
     */
    public Builder setEvaluationConfig(
        com.google.cloud.datalabeling.v1beta1.EvaluationConfig.Builder builderForValue) {
      if (evaluationConfigBuilder_ == null) {
        evaluationConfig_ = builderForValue.build();
      } else {
        evaluationConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Details for calculating evaluation metrics and creating
     * [Evaulations][google.cloud.datalabeling.v1beta1.Evaluation]. If your model version performs image object
     * detection, you must specify the `boundingBoxEvaluationOptions` field within
     * this configuration. Otherwise, provide an empty object for this
     * configuration.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EvaluationConfig evaluation_config = 2;</code>
     */
    public Builder mergeEvaluationConfig(
        com.google.cloud.datalabeling.v1beta1.EvaluationConfig value) {
      if (evaluationConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && evaluationConfig_ != null
            && evaluationConfig_
                != com.google.cloud.datalabeling.v1beta1.EvaluationConfig.getDefaultInstance()) {
          getEvaluationConfigBuilder().mergeFrom(value);
        } else {
          evaluationConfig_ = value;
        }
      } else {
        evaluationConfigBuilder_.mergeFrom(value);
      }
      if (evaluationConfig_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Details for calculating evaluation metrics and creating
     * [Evaulations][google.cloud.datalabeling.v1beta1.Evaluation]. If your model version performs image object
     * detection, you must specify the `boundingBoxEvaluationOptions` field within
     * this configuration. Otherwise, provide an empty object for this
     * configuration.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EvaluationConfig evaluation_config = 2;</code>
     */
    public Builder clearEvaluationConfig() {
      bitField0_ = (bitField0_ & ~0x00000010);
      evaluationConfig_ = null;
      if (evaluationConfigBuilder_ != null) {
        evaluationConfigBuilder_.dispose();
        evaluationConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Details for calculating evaluation metrics and creating
     * [Evaulations][google.cloud.datalabeling.v1beta1.Evaluation]. If your model version performs image object
     * detection, you must specify the `boundingBoxEvaluationOptions` field within
     * this configuration. Otherwise, provide an empty object for this
     * configuration.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EvaluationConfig evaluation_config = 2;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.EvaluationConfig.Builder
        getEvaluationConfigBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getEvaluationConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Details for calculating evaluation metrics and creating
     * [Evaulations][google.cloud.datalabeling.v1beta1.Evaluation]. If your model version performs image object
     * detection, you must specify the `boundingBoxEvaluationOptions` field within
     * this configuration. Otherwise, provide an empty object for this
     * configuration.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EvaluationConfig evaluation_config = 2;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.EvaluationConfigOrBuilder
        getEvaluationConfigOrBuilder() {
      if (evaluationConfigBuilder_ != null) {
        return evaluationConfigBuilder_.getMessageOrBuilder();
      } else {
        return evaluationConfig_ == null
            ? com.google.cloud.datalabeling.v1beta1.EvaluationConfig.getDefaultInstance()
            : evaluationConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Details for calculating evaluation metrics and creating
     * [Evaulations][google.cloud.datalabeling.v1beta1.Evaluation]. If your model version performs image object
     * detection, you must specify the `boundingBoxEvaluationOptions` field within
     * this configuration. Otherwise, provide an empty object for this
     * configuration.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EvaluationConfig evaluation_config = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.EvaluationConfig,
            com.google.cloud.datalabeling.v1beta1.EvaluationConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.EvaluationConfigOrBuilder>
        getEvaluationConfigFieldBuilder() {
      if (evaluationConfigBuilder_ == null) {
        evaluationConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.EvaluationConfig,
                com.google.cloud.datalabeling.v1beta1.EvaluationConfig.Builder,
                com.google.cloud.datalabeling.v1beta1.EvaluationConfigOrBuilder>(
                getEvaluationConfig(), getParentForChildren(), isClean());
        evaluationConfig_ = null;
      }
      return evaluationConfigBuilder_;
    }

    private com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig humanAnnotationConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig,
            com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfigOrBuilder>
        humanAnnotationConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Details for human annotation of your data. If you set
     * [labelMissingGroundTruth][google.cloud.datalabeling.v1beta1.EvaluationJob.label_missing_ground_truth] to
     * `true` for this evaluation job, then you must specify this field. If you
     * plan to provide your own ground truth labels, then omit this field.
     *
     * Note that you must create an [Instruction][google.cloud.datalabeling.v1beta1.Instruction] resource before you can
     * specify this field. Provide the name of the instruction resource in the
     * `instruction` field within this configuration.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig human_annotation_config = 3;
     * </code>
     *
     * @return Whether the humanAnnotationConfig field is set.
     */
    public boolean hasHumanAnnotationConfig() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Details for human annotation of your data. If you set
     * [labelMissingGroundTruth][google.cloud.datalabeling.v1beta1.EvaluationJob.label_missing_ground_truth] to
     * `true` for this evaluation job, then you must specify this field. If you
     * plan to provide your own ground truth labels, then omit this field.
     *
     * Note that you must create an [Instruction][google.cloud.datalabeling.v1beta1.Instruction] resource before you can
     * specify this field. Provide the name of the instruction resource in the
     * `instruction` field within this configuration.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig human_annotation_config = 3;
     * </code>
     *
     * @return The humanAnnotationConfig.
     */
    public com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig getHumanAnnotationConfig() {
      if (humanAnnotationConfigBuilder_ == null) {
        return humanAnnotationConfig_ == null
            ? com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.getDefaultInstance()
            : humanAnnotationConfig_;
      } else {
        return humanAnnotationConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Details for human annotation of your data. If you set
     * [labelMissingGroundTruth][google.cloud.datalabeling.v1beta1.EvaluationJob.label_missing_ground_truth] to
     * `true` for this evaluation job, then you must specify this field. If you
     * plan to provide your own ground truth labels, then omit this field.
     *
     * Note that you must create an [Instruction][google.cloud.datalabeling.v1beta1.Instruction] resource before you can
     * specify this field. Provide the name of the instruction resource in the
     * `instruction` field within this configuration.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig human_annotation_config = 3;
     * </code>
     */
    public Builder setHumanAnnotationConfig(
        com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig value) {
      if (humanAnnotationConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        humanAnnotationConfig_ = value;
      } else {
        humanAnnotationConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Details for human annotation of your data. If you set
     * [labelMissingGroundTruth][google.cloud.datalabeling.v1beta1.EvaluationJob.label_missing_ground_truth] to
     * `true` for this evaluation job, then you must specify this field. If you
     * plan to provide your own ground truth labels, then omit this field.
     *
     * Note that you must create an [Instruction][google.cloud.datalabeling.v1beta1.Instruction] resource before you can
     * specify this field. Provide the name of the instruction resource in the
     * `instruction` field within this configuration.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig human_annotation_config = 3;
     * </code>
     */
    public Builder setHumanAnnotationConfig(
        com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.Builder builderForValue) {
      if (humanAnnotationConfigBuilder_ == null) {
        humanAnnotationConfig_ = builderForValue.build();
      } else {
        humanAnnotationConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Details for human annotation of your data. If you set
     * [labelMissingGroundTruth][google.cloud.datalabeling.v1beta1.EvaluationJob.label_missing_ground_truth] to
     * `true` for this evaluation job, then you must specify this field. If you
     * plan to provide your own ground truth labels, then omit this field.
     *
     * Note that you must create an [Instruction][google.cloud.datalabeling.v1beta1.Instruction] resource before you can
     * specify this field. Provide the name of the instruction resource in the
     * `instruction` field within this configuration.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig human_annotation_config = 3;
     * </code>
     */
    public Builder mergeHumanAnnotationConfig(
        com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig value) {
      if (humanAnnotationConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && humanAnnotationConfig_ != null
            && humanAnnotationConfig_
                != com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig
                    .getDefaultInstance()) {
          getHumanAnnotationConfigBuilder().mergeFrom(value);
        } else {
          humanAnnotationConfig_ = value;
        }
      } else {
        humanAnnotationConfigBuilder_.mergeFrom(value);
      }
      if (humanAnnotationConfig_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Details for human annotation of your data. If you set
     * [labelMissingGroundTruth][google.cloud.datalabeling.v1beta1.EvaluationJob.label_missing_ground_truth] to
     * `true` for this evaluation job, then you must specify this field. If you
     * plan to provide your own ground truth labels, then omit this field.
     *
     * Note that you must create an [Instruction][google.cloud.datalabeling.v1beta1.Instruction] resource before you can
     * specify this field. Provide the name of the instruction resource in the
     * `instruction` field within this configuration.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig human_annotation_config = 3;
     * </code>
     */
    public Builder clearHumanAnnotationConfig() {
      bitField0_ = (bitField0_ & ~0x00000020);
      humanAnnotationConfig_ = null;
      if (humanAnnotationConfigBuilder_ != null) {
        humanAnnotationConfigBuilder_.dispose();
        humanAnnotationConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Details for human annotation of your data. If you set
     * [labelMissingGroundTruth][google.cloud.datalabeling.v1beta1.EvaluationJob.label_missing_ground_truth] to
     * `true` for this evaluation job, then you must specify this field. If you
     * plan to provide your own ground truth labels, then omit this field.
     *
     * Note that you must create an [Instruction][google.cloud.datalabeling.v1beta1.Instruction] resource before you can
     * specify this field. Provide the name of the instruction resource in the
     * `instruction` field within this configuration.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig human_annotation_config = 3;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.Builder
        getHumanAnnotationConfigBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getHumanAnnotationConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Details for human annotation of your data. If you set
     * [labelMissingGroundTruth][google.cloud.datalabeling.v1beta1.EvaluationJob.label_missing_ground_truth] to
     * `true` for this evaluation job, then you must specify this field. If you
     * plan to provide your own ground truth labels, then omit this field.
     *
     * Note that you must create an [Instruction][google.cloud.datalabeling.v1beta1.Instruction] resource before you can
     * specify this field. Provide the name of the instruction resource in the
     * `instruction` field within this configuration.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig human_annotation_config = 3;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfigOrBuilder
        getHumanAnnotationConfigOrBuilder() {
      if (humanAnnotationConfigBuilder_ != null) {
        return humanAnnotationConfigBuilder_.getMessageOrBuilder();
      } else {
        return humanAnnotationConfig_ == null
            ? com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.getDefaultInstance()
            : humanAnnotationConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Details for human annotation of your data. If you set
     * [labelMissingGroundTruth][google.cloud.datalabeling.v1beta1.EvaluationJob.label_missing_ground_truth] to
     * `true` for this evaluation job, then you must specify this field. If you
     * plan to provide your own ground truth labels, then omit this field.
     *
     * Note that you must create an [Instruction][google.cloud.datalabeling.v1beta1.Instruction] resource before you can
     * specify this field. Provide the name of the instruction resource in the
     * `instruction` field within this configuration.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig human_annotation_config = 3;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig,
            com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfigOrBuilder>
        getHumanAnnotationConfigFieldBuilder() {
      if (humanAnnotationConfigBuilder_ == null) {
        humanAnnotationConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig,
                com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.Builder,
                com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfigOrBuilder>(
                getHumanAnnotationConfig(), getParentForChildren(), isClean());
        humanAnnotationConfig_ = null;
      }
      return humanAnnotationConfigBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> bigqueryImportKeys_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetBigqueryImportKeys() {
      if (bigqueryImportKeys_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            BigqueryImportKeysDefaultEntryHolder.defaultEntry);
      }
      return bigqueryImportKeys_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableBigqueryImportKeys() {
      if (bigqueryImportKeys_ == null) {
        bigqueryImportKeys_ =
            com.google.protobuf.MapField.newMapField(
                BigqueryImportKeysDefaultEntryHolder.defaultEntry);
      }
      if (!bigqueryImportKeys_.isMutable()) {
        bigqueryImportKeys_ = bigqueryImportKeys_.copy();
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return bigqueryImportKeys_;
    }

    public int getBigqueryImportKeysCount() {
      return internalGetBigqueryImportKeys().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Required. Prediction keys that tell Data Labeling Service where to find the
     * data for evaluation in your BigQuery table. When the service samples
     * prediction input and output from your model version and saves it to
     * BigQuery, the data gets stored as JSON strings in the BigQuery table. These
     * keys tell Data Labeling Service how to parse the JSON.
     *
     * You can provide the following entries in this field:
     *
     * * `data_json_key`: the data key for prediction input. You must provide
     *   either this key or `reference_json_key`.
     * * `reference_json_key`: the data reference key for prediction input. You
     *   must provide either this key or `data_json_key`.
     * * `label_json_key`: the label key for prediction output. Required.
     * * `label_score_json_key`: the score key for prediction output. Required.
     * * `bounding_box_json_key`: the bounding box key for prediction output.
     *   Required if your model version perform image object detection.
     *
     * Learn [how to configure prediction
     * keys](/ml-engine/docs/continuous-evaluation/create-job#prediction-keys).
     * </pre>
     *
     * <code>map&lt;string, string&gt; bigquery_import_keys = 9;</code>
     */
    @java.lang.Override
    public boolean containsBigqueryImportKeys(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetBigqueryImportKeys().getMap().containsKey(key);
    }
    /** Use {@link #getBigqueryImportKeysMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getBigqueryImportKeys() {
      return getBigqueryImportKeysMap();
    }
    /**
     *
     *
     * <pre>
     * Required. Prediction keys that tell Data Labeling Service where to find the
     * data for evaluation in your BigQuery table. When the service samples
     * prediction input and output from your model version and saves it to
     * BigQuery, the data gets stored as JSON strings in the BigQuery table. These
     * keys tell Data Labeling Service how to parse the JSON.
     *
     * You can provide the following entries in this field:
     *
     * * `data_json_key`: the data key for prediction input. You must provide
     *   either this key or `reference_json_key`.
     * * `reference_json_key`: the data reference key for prediction input. You
     *   must provide either this key or `data_json_key`.
     * * `label_json_key`: the label key for prediction output. Required.
     * * `label_score_json_key`: the score key for prediction output. Required.
     * * `bounding_box_json_key`: the bounding box key for prediction output.
     *   Required if your model version perform image object detection.
     *
     * Learn [how to configure prediction
     * keys](/ml-engine/docs/continuous-evaluation/create-job#prediction-keys).
     * </pre>
     *
     * <code>map&lt;string, string&gt; bigquery_import_keys = 9;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getBigqueryImportKeysMap() {
      return internalGetBigqueryImportKeys().getMap();
    }
    /**
     *
     *
     * <pre>
     * Required. Prediction keys that tell Data Labeling Service where to find the
     * data for evaluation in your BigQuery table. When the service samples
     * prediction input and output from your model version and saves it to
     * BigQuery, the data gets stored as JSON strings in the BigQuery table. These
     * keys tell Data Labeling Service how to parse the JSON.
     *
     * You can provide the following entries in this field:
     *
     * * `data_json_key`: the data key for prediction input. You must provide
     *   either this key or `reference_json_key`.
     * * `reference_json_key`: the data reference key for prediction input. You
     *   must provide either this key or `data_json_key`.
     * * `label_json_key`: the label key for prediction output. Required.
     * * `label_score_json_key`: the score key for prediction output. Required.
     * * `bounding_box_json_key`: the bounding box key for prediction output.
     *   Required if your model version perform image object detection.
     *
     * Learn [how to configure prediction
     * keys](/ml-engine/docs/continuous-evaluation/create-job#prediction-keys).
     * </pre>
     *
     * <code>map&lt;string, string&gt; bigquery_import_keys = 9;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getBigqueryImportKeysOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetBigqueryImportKeys().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Required. Prediction keys that tell Data Labeling Service where to find the
     * data for evaluation in your BigQuery table. When the service samples
     * prediction input and output from your model version and saves it to
     * BigQuery, the data gets stored as JSON strings in the BigQuery table. These
     * keys tell Data Labeling Service how to parse the JSON.
     *
     * You can provide the following entries in this field:
     *
     * * `data_json_key`: the data key for prediction input. You must provide
     *   either this key or `reference_json_key`.
     * * `reference_json_key`: the data reference key for prediction input. You
     *   must provide either this key or `data_json_key`.
     * * `label_json_key`: the label key for prediction output. Required.
     * * `label_score_json_key`: the score key for prediction output. Required.
     * * `bounding_box_json_key`: the bounding box key for prediction output.
     *   Required if your model version perform image object detection.
     *
     * Learn [how to configure prediction
     * keys](/ml-engine/docs/continuous-evaluation/create-job#prediction-keys).
     * </pre>
     *
     * <code>map&lt;string, string&gt; bigquery_import_keys = 9;</code>
     */
    @java.lang.Override
    public java.lang.String getBigqueryImportKeysOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetBigqueryImportKeys().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearBigqueryImportKeys() {
      bitField0_ = (bitField0_ & ~0x00000040);
      internalGetMutableBigqueryImportKeys().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Prediction keys that tell Data Labeling Service where to find the
     * data for evaluation in your BigQuery table. When the service samples
     * prediction input and output from your model version and saves it to
     * BigQuery, the data gets stored as JSON strings in the BigQuery table. These
     * keys tell Data Labeling Service how to parse the JSON.
     *
     * You can provide the following entries in this field:
     *
     * * `data_json_key`: the data key for prediction input. You must provide
     *   either this key or `reference_json_key`.
     * * `reference_json_key`: the data reference key for prediction input. You
     *   must provide either this key or `data_json_key`.
     * * `label_json_key`: the label key for prediction output. Required.
     * * `label_score_json_key`: the score key for prediction output. Required.
     * * `bounding_box_json_key`: the bounding box key for prediction output.
     *   Required if your model version perform image object detection.
     *
     * Learn [how to configure prediction
     * keys](/ml-engine/docs/continuous-evaluation/create-job#prediction-keys).
     * </pre>
     *
     * <code>map&lt;string, string&gt; bigquery_import_keys = 9;</code>
     */
    public Builder removeBigqueryImportKeys(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableBigqueryImportKeys().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableBigqueryImportKeys() {
      bitField0_ |= 0x00000040;
      return internalGetMutableBigqueryImportKeys().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Required. Prediction keys that tell Data Labeling Service where to find the
     * data for evaluation in your BigQuery table. When the service samples
     * prediction input and output from your model version and saves it to
     * BigQuery, the data gets stored as JSON strings in the BigQuery table. These
     * keys tell Data Labeling Service how to parse the JSON.
     *
     * You can provide the following entries in this field:
     *
     * * `data_json_key`: the data key for prediction input. You must provide
     *   either this key or `reference_json_key`.
     * * `reference_json_key`: the data reference key for prediction input. You
     *   must provide either this key or `data_json_key`.
     * * `label_json_key`: the label key for prediction output. Required.
     * * `label_score_json_key`: the score key for prediction output. Required.
     * * `bounding_box_json_key`: the bounding box key for prediction output.
     *   Required if your model version perform image object detection.
     *
     * Learn [how to configure prediction
     * keys](/ml-engine/docs/continuous-evaluation/create-job#prediction-keys).
     * </pre>
     *
     * <code>map&lt;string, string&gt; bigquery_import_keys = 9;</code>
     */
    public Builder putBigqueryImportKeys(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableBigqueryImportKeys().getMutableMap().put(key, value);
      bitField0_ |= 0x00000040;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Prediction keys that tell Data Labeling Service where to find the
     * data for evaluation in your BigQuery table. When the service samples
     * prediction input and output from your model version and saves it to
     * BigQuery, the data gets stored as JSON strings in the BigQuery table. These
     * keys tell Data Labeling Service how to parse the JSON.
     *
     * You can provide the following entries in this field:
     *
     * * `data_json_key`: the data key for prediction input. You must provide
     *   either this key or `reference_json_key`.
     * * `reference_json_key`: the data reference key for prediction input. You
     *   must provide either this key or `data_json_key`.
     * * `label_json_key`: the label key for prediction output. Required.
     * * `label_score_json_key`: the score key for prediction output. Required.
     * * `bounding_box_json_key`: the bounding box key for prediction output.
     *   Required if your model version perform image object detection.
     *
     * Learn [how to configure prediction
     * keys](/ml-engine/docs/continuous-evaluation/create-job#prediction-keys).
     * </pre>
     *
     * <code>map&lt;string, string&gt; bigquery_import_keys = 9;</code>
     */
    public Builder putAllBigqueryImportKeys(
        java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableBigqueryImportKeys().getMutableMap().putAll(values);
      bitField0_ |= 0x00000040;
      return this;
    }

    private int exampleCount_;
    /**
     *
     *
     * <pre>
     * Required. The maximum number of predictions to sample and save to BigQuery
     * during each [evaluation interval][google.cloud.datalabeling.v1beta1.EvaluationJob.schedule]. This limit
     * overrides `example_sample_percentage`: even if the service has not sampled
     * enough predictions to fulfill `example_sample_perecentage` during an
     * interval, it stops sampling predictions when it meets this limit.
     * </pre>
     *
     * <code>int32 example_count = 10;</code>
     *
     * @return The exampleCount.
     */
    @java.lang.Override
    public int getExampleCount() {
      return exampleCount_;
    }
    /**
     *
     *
     * <pre>
     * Required. The maximum number of predictions to sample and save to BigQuery
     * during each [evaluation interval][google.cloud.datalabeling.v1beta1.EvaluationJob.schedule]. This limit
     * overrides `example_sample_percentage`: even if the service has not sampled
     * enough predictions to fulfill `example_sample_perecentage` during an
     * interval, it stops sampling predictions when it meets this limit.
     * </pre>
     *
     * <code>int32 example_count = 10;</code>
     *
     * @param value The exampleCount to set.
     * @return This builder for chaining.
     */
    public Builder setExampleCount(int value) {

      exampleCount_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The maximum number of predictions to sample and save to BigQuery
     * during each [evaluation interval][google.cloud.datalabeling.v1beta1.EvaluationJob.schedule]. This limit
     * overrides `example_sample_percentage`: even if the service has not sampled
     * enough predictions to fulfill `example_sample_perecentage` during an
     * interval, it stops sampling predictions when it meets this limit.
     * </pre>
     *
     * <code>int32 example_count = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExampleCount() {
      bitField0_ = (bitField0_ & ~0x00000080);
      exampleCount_ = 0;
      onChanged();
      return this;
    }

    private double exampleSamplePercentage_;
    /**
     *
     *
     * <pre>
     * Required. Fraction of predictions to sample and save to BigQuery during
     * each [evaluation interval][google.cloud.datalabeling.v1beta1.EvaluationJob.schedule]. For example, 0.1 means
     * 10% of predictions served by your model version get saved to BigQuery.
     * </pre>
     *
     * <code>double example_sample_percentage = 11;</code>
     *
     * @return The exampleSamplePercentage.
     */
    @java.lang.Override
    public double getExampleSamplePercentage() {
      return exampleSamplePercentage_;
    }
    /**
     *
     *
     * <pre>
     * Required. Fraction of predictions to sample and save to BigQuery during
     * each [evaluation interval][google.cloud.datalabeling.v1beta1.EvaluationJob.schedule]. For example, 0.1 means
     * 10% of predictions served by your model version get saved to BigQuery.
     * </pre>
     *
     * <code>double example_sample_percentage = 11;</code>
     *
     * @param value The exampleSamplePercentage to set.
     * @return This builder for chaining.
     */
    public Builder setExampleSamplePercentage(double value) {

      exampleSamplePercentage_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Fraction of predictions to sample and save to BigQuery during
     * each [evaluation interval][google.cloud.datalabeling.v1beta1.EvaluationJob.schedule]. For example, 0.1 means
     * 10% of predictions served by your model version get saved to BigQuery.
     * </pre>
     *
     * <code>double example_sample_percentage = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExampleSamplePercentage() {
      bitField0_ = (bitField0_ & ~0x00000100);
      exampleSamplePercentage_ = 0D;
      onChanged();
      return this;
    }

    private com.google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig
        evaluationJobAlertConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig,
            com.google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfigOrBuilder>
        evaluationJobAlertConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Configuration details for evaluation job alerts. Specify this
     * field if you want to receive email alerts if the evaluation job finds that
     * your predictions have low mean average precision during a run.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig evaluation_job_alert_config = 13;
     * </code>
     *
     * @return Whether the evaluationJobAlertConfig field is set.
     */
    public boolean hasEvaluationJobAlertConfig() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration details for evaluation job alerts. Specify this
     * field if you want to receive email alerts if the evaluation job finds that
     * your predictions have low mean average precision during a run.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig evaluation_job_alert_config = 13;
     * </code>
     *
     * @return The evaluationJobAlertConfig.
     */
    public com.google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig
        getEvaluationJobAlertConfig() {
      if (evaluationJobAlertConfigBuilder_ == null) {
        return evaluationJobAlertConfig_ == null
            ? com.google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig.getDefaultInstance()
            : evaluationJobAlertConfig_;
      } else {
        return evaluationJobAlertConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration details for evaluation job alerts. Specify this
     * field if you want to receive email alerts if the evaluation job finds that
     * your predictions have low mean average precision during a run.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig evaluation_job_alert_config = 13;
     * </code>
     */
    public Builder setEvaluationJobAlertConfig(
        com.google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig value) {
      if (evaluationJobAlertConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        evaluationJobAlertConfig_ = value;
      } else {
        evaluationJobAlertConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration details for evaluation job alerts. Specify this
     * field if you want to receive email alerts if the evaluation job finds that
     * your predictions have low mean average precision during a run.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig evaluation_job_alert_config = 13;
     * </code>
     */
    public Builder setEvaluationJobAlertConfig(
        com.google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig.Builder builderForValue) {
      if (evaluationJobAlertConfigBuilder_ == null) {
        evaluationJobAlertConfig_ = builderForValue.build();
      } else {
        evaluationJobAlertConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration details for evaluation job alerts. Specify this
     * field if you want to receive email alerts if the evaluation job finds that
     * your predictions have low mean average precision during a run.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig evaluation_job_alert_config = 13;
     * </code>
     */
    public Builder mergeEvaluationJobAlertConfig(
        com.google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig value) {
      if (evaluationJobAlertConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && evaluationJobAlertConfig_ != null
            && evaluationJobAlertConfig_
                != com.google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig
                    .getDefaultInstance()) {
          getEvaluationJobAlertConfigBuilder().mergeFrom(value);
        } else {
          evaluationJobAlertConfig_ = value;
        }
      } else {
        evaluationJobAlertConfigBuilder_.mergeFrom(value);
      }
      if (evaluationJobAlertConfig_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration details for evaluation job alerts. Specify this
     * field if you want to receive email alerts if the evaluation job finds that
     * your predictions have low mean average precision during a run.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig evaluation_job_alert_config = 13;
     * </code>
     */
    public Builder clearEvaluationJobAlertConfig() {
      bitField0_ = (bitField0_ & ~0x00000200);
      evaluationJobAlertConfig_ = null;
      if (evaluationJobAlertConfigBuilder_ != null) {
        evaluationJobAlertConfigBuilder_.dispose();
        evaluationJobAlertConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration details for evaluation job alerts. Specify this
     * field if you want to receive email alerts if the evaluation job finds that
     * your predictions have low mean average precision during a run.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig evaluation_job_alert_config = 13;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig.Builder
        getEvaluationJobAlertConfigBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getEvaluationJobAlertConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration details for evaluation job alerts. Specify this
     * field if you want to receive email alerts if the evaluation job finds that
     * your predictions have low mean average precision during a run.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig evaluation_job_alert_config = 13;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfigOrBuilder
        getEvaluationJobAlertConfigOrBuilder() {
      if (evaluationJobAlertConfigBuilder_ != null) {
        return evaluationJobAlertConfigBuilder_.getMessageOrBuilder();
      } else {
        return evaluationJobAlertConfig_ == null
            ? com.google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig.getDefaultInstance()
            : evaluationJobAlertConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Configuration details for evaluation job alerts. Specify this
     * field if you want to receive email alerts if the evaluation job finds that
     * your predictions have low mean average precision during a run.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig evaluation_job_alert_config = 13;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig,
            com.google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfigOrBuilder>
        getEvaluationJobAlertConfigFieldBuilder() {
      if (evaluationJobAlertConfigBuilder_ == null) {
        evaluationJobAlertConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig,
                com.google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig.Builder,
                com.google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfigOrBuilder>(
                getEvaluationJobAlertConfig(), getParentForChildren(), isClean());
        evaluationJobAlertConfig_ = null;
      }
      return evaluationJobAlertConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datalabeling.v1beta1.EvaluationJobConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datalabeling.v1beta1.EvaluationJobConfig)
  private static final com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig();
  }

  public static com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<EvaluationJobConfig> PARSER =
      new com.google.protobuf.AbstractParser<EvaluationJobConfig>() {
        @java.lang.Override
        public EvaluationJobConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<EvaluationJobConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<EvaluationJobConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
