/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datalabeling.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DataItemName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/datasets/{dataset}/dataItems/{data_item}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String dataset;
    private final String dataItem;

    public String getProject() {
        return this.project;
    }

    public String getDataset() {
        return this.dataset;
    }

    public String getDataItem() {
        return this.dataItem;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private DataItemName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.dataset = (String)Preconditions.checkNotNull((Object)builder.getDataset());
        this.dataItem = (String)Preconditions.checkNotNull((Object)builder.getDataItem());
    }

    public static DataItemName of(String project, String dataset, String dataItem) {
        return DataItemName.newBuilder().setProject(project).setDataset(dataset).setDataItem(dataItem).build();
    }

    public static String format(String project, String dataset, String dataItem) {
        return DataItemName.newBuilder().setProject(project).setDataset(dataset).setDataItem(dataItem).build().toString();
    }

    public static DataItemName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "DataItemName.parse: formattedString not in valid format");
        return DataItemName.of((String)matchMap.get("project"), (String)matchMap.get("dataset"), (String)matchMap.get("data_item"));
    }

    public static List<DataItemName> parseList(List<String> formattedStrings) {
        ArrayList<DataItemName> list = new ArrayList<DataItemName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DataItemName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DataItemName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DataItemName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DataItemName dataItemName = this;
            synchronized (dataItemName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"dataset", (Object)this.dataset);
                    fieldMapBuilder.put((Object)"dataItem", (Object)this.dataItem);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "dataset", this.dataset, "data_item", this.dataItem});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DataItemName) {
            DataItemName that = (DataItemName)o;
            return this.project.equals(that.project) && this.dataset.equals(that.dataset) && this.dataItem.equals(that.dataItem);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.dataset.hashCode();
        h *= 1000003;
        return h ^= this.dataItem.hashCode();
    }

    public static class Builder {
        private String project;
        private String dataset;
        private String dataItem;

        public String getProject() {
            return this.project;
        }

        public String getDataset() {
            return this.dataset;
        }

        public String getDataItem() {
            return this.dataItem;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setDataset(String dataset) {
            this.dataset = dataset;
            return this;
        }

        public Builder setDataItem(String dataItem) {
            this.dataItem = dataItem;
            return this;
        }

        private Builder() {
        }

        private Builder(DataItemName dataItemName) {
            this.project = dataItemName.project;
            this.dataset = dataItemName.dataset;
            this.dataItem = dataItemName.dataItem;
        }

        public DataItemName build() {
            return new DataItemName(this);
        }
    }
}

