/*
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datalabeling/v1beta1/evaluation_job.proto

package com.google.cloud.datalabeling.v1beta1;

/** Protobuf type {@code google.cloud.datalabeling.v1beta1.EvaluationJobConfig} */
public final class EvaluationJobConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datalabeling.v1beta1.EvaluationJobConfig)
    EvaluationJobConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use EvaluationJobConfig.newBuilder() to construct.
  private EvaluationJobConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private EvaluationJobConfig() {}

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private EvaluationJobConfig(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              com.google.cloud.datalabeling.v1beta1.InputConfig.Builder subBuilder = null;
              if (inputConfig_ != null) {
                subBuilder = inputConfig_.toBuilder();
              }
              inputConfig_ =
                  input.readMessage(
                      com.google.cloud.datalabeling.v1beta1.InputConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(inputConfig_);
                inputConfig_ = subBuilder.buildPartial();
              }

              break;
            }
          case 18:
            {
              com.google.cloud.datalabeling.v1beta1.EvaluationConfig.Builder subBuilder = null;
              if (evaluationConfig_ != null) {
                subBuilder = evaluationConfig_.toBuilder();
              }
              evaluationConfig_ =
                  input.readMessage(
                      com.google.cloud.datalabeling.v1beta1.EvaluationConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(evaluationConfig_);
                evaluationConfig_ = subBuilder.buildPartial();
              }

              break;
            }
          case 26:
            {
              com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.Builder subBuilder = null;
              if (humanAnnotationConfig_ != null) {
                subBuilder = humanAnnotationConfig_.toBuilder();
              }
              humanAnnotationConfig_ =
                  input.readMessage(
                      com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(humanAnnotationConfig_);
                humanAnnotationConfig_ = subBuilder.buildPartial();
              }

              break;
            }
          case 34:
            {
              com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig.Builder subBuilder =
                  null;
              if (humanAnnotationRequestConfigCase_ == 4) {
                subBuilder =
                    ((com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig)
                            humanAnnotationRequestConfig_)
                        .toBuilder();
              }
              humanAnnotationRequestConfig_ =
                  input.readMessage(
                      com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig)
                        humanAnnotationRequestConfig_);
                humanAnnotationRequestConfig_ = subBuilder.buildPartial();
              }
              humanAnnotationRequestConfigCase_ = 4;
              break;
            }
          case 42:
            {
              com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig.Builder subBuilder = null;
              if (humanAnnotationRequestConfigCase_ == 5) {
                subBuilder =
                    ((com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig)
                            humanAnnotationRequestConfig_)
                        .toBuilder();
              }
              humanAnnotationRequestConfig_ =
                  input.readMessage(
                      com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig)
                        humanAnnotationRequestConfig_);
                humanAnnotationRequestConfig_ = subBuilder.buildPartial();
              }
              humanAnnotationRequestConfigCase_ = 5;
              break;
            }
          case 50:
            {
              com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.Builder subBuilder =
                  null;
              if (humanAnnotationRequestConfigCase_ == 6) {
                subBuilder =
                    ((com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig)
                            humanAnnotationRequestConfig_)
                        .toBuilder();
              }
              humanAnnotationRequestConfig_ =
                  input.readMessage(
                      com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig)
                        humanAnnotationRequestConfig_);
                humanAnnotationRequestConfig_ = subBuilder.buildPartial();
              }
              humanAnnotationRequestConfigCase_ = 6;
              break;
            }
          case 58:
            {
              com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig.Builder subBuilder = null;
              if (humanAnnotationRequestConfigCase_ == 7) {
                subBuilder =
                    ((com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig)
                            humanAnnotationRequestConfig_)
                        .toBuilder();
              }
              humanAnnotationRequestConfig_ =
                  input.readMessage(
                      com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig)
                        humanAnnotationRequestConfig_);
                humanAnnotationRequestConfig_ = subBuilder.buildPartial();
              }
              humanAnnotationRequestConfigCase_ = 7;
              break;
            }
          case 66:
            {
              com.google.cloud.datalabeling.v1beta1.TextClassificationConfig.Builder subBuilder =
                  null;
              if (humanAnnotationRequestConfigCase_ == 8) {
                subBuilder =
                    ((com.google.cloud.datalabeling.v1beta1.TextClassificationConfig)
                            humanAnnotationRequestConfig_)
                        .toBuilder();
              }
              humanAnnotationRequestConfig_ =
                  input.readMessage(
                      com.google.cloud.datalabeling.v1beta1.TextClassificationConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.datalabeling.v1beta1.TextClassificationConfig)
                        humanAnnotationRequestConfig_);
                humanAnnotationRequestConfig_ = subBuilder.buildPartial();
              }
              humanAnnotationRequestConfigCase_ = 8;
              break;
            }
          case 74:
            {
              if (!((mutable_bitField0_ & 0x00000200) != 0)) {
                bigqueryImportKeys_ =
                    com.google.protobuf.MapField.newMapField(
                        BigqueryImportKeysDefaultEntryHolder.defaultEntry);
                mutable_bitField0_ |= 0x00000200;
              }
              com.google.protobuf.MapEntry<java.lang.String, java.lang.String>
                  bigqueryImportKeys__ =
                      input.readMessage(
                          BigqueryImportKeysDefaultEntryHolder.defaultEntry.getParserForType(),
                          extensionRegistry);
              bigqueryImportKeys_
                  .getMutableMap()
                  .put(bigqueryImportKeys__.getKey(), bigqueryImportKeys__.getValue());
              break;
            }
          case 80:
            {
              exampleCount_ = input.readInt32();
              break;
            }
          case 89:
            {
              exampleSamplePercentage_ = input.readDouble();
              break;
            }
          case 98:
            {
              com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig.Builder subBuilder = null;
              if (humanAnnotationRequestConfigCase_ == 12) {
                subBuilder =
                    ((com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig)
                            humanAnnotationRequestConfig_)
                        .toBuilder();
              }
              humanAnnotationRequestConfig_ =
                  input.readMessage(
                      com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig)
                        humanAnnotationRequestConfig_);
                humanAnnotationRequestConfig_ = subBuilder.buildPartial();
              }
              humanAnnotationRequestConfigCase_ = 12;
              break;
            }
          case 106:
            {
              com.google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig.Builder subBuilder =
                  null;
              if (evaluationJobAlertConfig_ != null) {
                subBuilder = evaluationJobAlertConfig_.toBuilder();
              }
              evaluationJobAlertConfig_ =
                  input.readMessage(
                      com.google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(evaluationJobAlertConfig_);
                evaluationJobAlertConfig_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datalabeling.v1beta1.EvaluationJobOuterClass
        .internal_static_google_cloud_datalabeling_v1beta1_EvaluationJobConfig_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 9:
        return internalGetBigqueryImportKeys();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datalabeling.v1beta1.EvaluationJobOuterClass
        .internal_static_google_cloud_datalabeling_v1beta1_EvaluationJobConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig.class,
            com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig.Builder.class);
  }

  private int bitField0_;
  private int humanAnnotationRequestConfigCase_ = 0;
  private java.lang.Object humanAnnotationRequestConfig_;

  public enum HumanAnnotationRequestConfigCase implements com.google.protobuf.Internal.EnumLite {
    IMAGE_CLASSIFICATION_CONFIG(4),
    BOUNDING_POLY_CONFIG(5),
    VIDEO_CLASSIFICATION_CONFIG(6),
    OBJECT_DETECTION_CONFIG(7),
    TEXT_CLASSIFICATION_CONFIG(8),
    OBJECT_TRACKING_CONFIG(12),
    HUMANANNOTATIONREQUESTCONFIG_NOT_SET(0);
    private final int value;

    private HumanAnnotationRequestConfigCase(int value) {
      this.value = value;
    }
    /** @deprecated Use {@link #forNumber(int)} instead. */
    @java.lang.Deprecated
    public static HumanAnnotationRequestConfigCase valueOf(int value) {
      return forNumber(value);
    }

    public static HumanAnnotationRequestConfigCase forNumber(int value) {
      switch (value) {
        case 4:
          return IMAGE_CLASSIFICATION_CONFIG;
        case 5:
          return BOUNDING_POLY_CONFIG;
        case 6:
          return VIDEO_CLASSIFICATION_CONFIG;
        case 7:
          return OBJECT_DETECTION_CONFIG;
        case 8:
          return TEXT_CLASSIFICATION_CONFIG;
        case 12:
          return OBJECT_TRACKING_CONFIG;
        case 0:
          return HUMANANNOTATIONREQUESTCONFIG_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public HumanAnnotationRequestConfigCase getHumanAnnotationRequestConfigCase() {
    return HumanAnnotationRequestConfigCase.forNumber(humanAnnotationRequestConfigCase_);
  }

  public static final int IMAGE_CLASSIFICATION_CONFIG_FIELD_NUMBER = 4;
  /**
   * <code>
   * .google.cloud.datalabeling.v1beta1.ImageClassificationConfig image_classification_config = 4;
   * </code>
   */
  public boolean hasImageClassificationConfig() {
    return humanAnnotationRequestConfigCase_ == 4;
  }
  /**
   * <code>
   * .google.cloud.datalabeling.v1beta1.ImageClassificationConfig image_classification_config = 4;
   * </code>
   */
  public com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig
      getImageClassificationConfig() {
    if (humanAnnotationRequestConfigCase_ == 4) {
      return (com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig)
          humanAnnotationRequestConfig_;
    }
    return com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig.getDefaultInstance();
  }
  /**
   * <code>
   * .google.cloud.datalabeling.v1beta1.ImageClassificationConfig image_classification_config = 4;
   * </code>
   */
  public com.google.cloud.datalabeling.v1beta1.ImageClassificationConfigOrBuilder
      getImageClassificationConfigOrBuilder() {
    if (humanAnnotationRequestConfigCase_ == 4) {
      return (com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig)
          humanAnnotationRequestConfig_;
    }
    return com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig.getDefaultInstance();
  }

  public static final int BOUNDING_POLY_CONFIG_FIELD_NUMBER = 5;
  /**
   * <code>.google.cloud.datalabeling.v1beta1.BoundingPolyConfig bounding_poly_config = 5;</code>
   */
  public boolean hasBoundingPolyConfig() {
    return humanAnnotationRequestConfigCase_ == 5;
  }
  /**
   * <code>.google.cloud.datalabeling.v1beta1.BoundingPolyConfig bounding_poly_config = 5;</code>
   */
  public com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig getBoundingPolyConfig() {
    if (humanAnnotationRequestConfigCase_ == 5) {
      return (com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig)
          humanAnnotationRequestConfig_;
    }
    return com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig.getDefaultInstance();
  }
  /**
   * <code>.google.cloud.datalabeling.v1beta1.BoundingPolyConfig bounding_poly_config = 5;</code>
   */
  public com.google.cloud.datalabeling.v1beta1.BoundingPolyConfigOrBuilder
      getBoundingPolyConfigOrBuilder() {
    if (humanAnnotationRequestConfigCase_ == 5) {
      return (com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig)
          humanAnnotationRequestConfig_;
    }
    return com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig.getDefaultInstance();
  }

  public static final int VIDEO_CLASSIFICATION_CONFIG_FIELD_NUMBER = 6;
  /**
   * <code>
   * .google.cloud.datalabeling.v1beta1.VideoClassificationConfig video_classification_config = 6;
   * </code>
   */
  public boolean hasVideoClassificationConfig() {
    return humanAnnotationRequestConfigCase_ == 6;
  }
  /**
   * <code>
   * .google.cloud.datalabeling.v1beta1.VideoClassificationConfig video_classification_config = 6;
   * </code>
   */
  public com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig
      getVideoClassificationConfig() {
    if (humanAnnotationRequestConfigCase_ == 6) {
      return (com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig)
          humanAnnotationRequestConfig_;
    }
    return com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.getDefaultInstance();
  }
  /**
   * <code>
   * .google.cloud.datalabeling.v1beta1.VideoClassificationConfig video_classification_config = 6;
   * </code>
   */
  public com.google.cloud.datalabeling.v1beta1.VideoClassificationConfigOrBuilder
      getVideoClassificationConfigOrBuilder() {
    if (humanAnnotationRequestConfigCase_ == 6) {
      return (com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig)
          humanAnnotationRequestConfig_;
    }
    return com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.getDefaultInstance();
  }

  public static final int OBJECT_DETECTION_CONFIG_FIELD_NUMBER = 7;
  /**
   * <code>.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig object_detection_config = 7;
   * </code>
   */
  public boolean hasObjectDetectionConfig() {
    return humanAnnotationRequestConfigCase_ == 7;
  }
  /**
   * <code>.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig object_detection_config = 7;
   * </code>
   */
  public com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig getObjectDetectionConfig() {
    if (humanAnnotationRequestConfigCase_ == 7) {
      return (com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig)
          humanAnnotationRequestConfig_;
    }
    return com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig.getDefaultInstance();
  }
  /**
   * <code>.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig object_detection_config = 7;
   * </code>
   */
  public com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfigOrBuilder
      getObjectDetectionConfigOrBuilder() {
    if (humanAnnotationRequestConfigCase_ == 7) {
      return (com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig)
          humanAnnotationRequestConfig_;
    }
    return com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig.getDefaultInstance();
  }

  public static final int TEXT_CLASSIFICATION_CONFIG_FIELD_NUMBER = 8;
  /**
   * <code>
   * .google.cloud.datalabeling.v1beta1.TextClassificationConfig text_classification_config = 8;
   * </code>
   */
  public boolean hasTextClassificationConfig() {
    return humanAnnotationRequestConfigCase_ == 8;
  }
  /**
   * <code>
   * .google.cloud.datalabeling.v1beta1.TextClassificationConfig text_classification_config = 8;
   * </code>
   */
  public com.google.cloud.datalabeling.v1beta1.TextClassificationConfig
      getTextClassificationConfig() {
    if (humanAnnotationRequestConfigCase_ == 8) {
      return (com.google.cloud.datalabeling.v1beta1.TextClassificationConfig)
          humanAnnotationRequestConfig_;
    }
    return com.google.cloud.datalabeling.v1beta1.TextClassificationConfig.getDefaultInstance();
  }
  /**
   * <code>
   * .google.cloud.datalabeling.v1beta1.TextClassificationConfig text_classification_config = 8;
   * </code>
   */
  public com.google.cloud.datalabeling.v1beta1.TextClassificationConfigOrBuilder
      getTextClassificationConfigOrBuilder() {
    if (humanAnnotationRequestConfigCase_ == 8) {
      return (com.google.cloud.datalabeling.v1beta1.TextClassificationConfig)
          humanAnnotationRequestConfig_;
    }
    return com.google.cloud.datalabeling.v1beta1.TextClassificationConfig.getDefaultInstance();
  }

  public static final int OBJECT_TRACKING_CONFIG_FIELD_NUMBER = 12;
  /**
   * <code>.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig object_tracking_config = 12;
   * </code>
   */
  public boolean hasObjectTrackingConfig() {
    return humanAnnotationRequestConfigCase_ == 12;
  }
  /**
   * <code>.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig object_tracking_config = 12;
   * </code>
   */
  public com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig getObjectTrackingConfig() {
    if (humanAnnotationRequestConfigCase_ == 12) {
      return (com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig)
          humanAnnotationRequestConfig_;
    }
    return com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig.getDefaultInstance();
  }
  /**
   * <code>.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig object_tracking_config = 12;
   * </code>
   */
  public com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfigOrBuilder
      getObjectTrackingConfigOrBuilder() {
    if (humanAnnotationRequestConfigCase_ == 12) {
      return (com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig)
          humanAnnotationRequestConfig_;
    }
    return com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig.getDefaultInstance();
  }

  public static final int INPUT_CONFIG_FIELD_NUMBER = 1;
  private com.google.cloud.datalabeling.v1beta1.InputConfig inputConfig_;
  /**
   *
   *
   * <pre>
   * Input config for data, gcs_source in the config will be the root path for
   * data. Data should be organzied chronically under that path.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.InputConfig input_config = 1;</code>
   */
  public boolean hasInputConfig() {
    return inputConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Input config for data, gcs_source in the config will be the root path for
   * data. Data should be organzied chronically under that path.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.InputConfig input_config = 1;</code>
   */
  public com.google.cloud.datalabeling.v1beta1.InputConfig getInputConfig() {
    return inputConfig_ == null
        ? com.google.cloud.datalabeling.v1beta1.InputConfig.getDefaultInstance()
        : inputConfig_;
  }
  /**
   *
   *
   * <pre>
   * Input config for data, gcs_source in the config will be the root path for
   * data. Data should be organzied chronically under that path.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.InputConfig input_config = 1;</code>
   */
  public com.google.cloud.datalabeling.v1beta1.InputConfigOrBuilder getInputConfigOrBuilder() {
    return getInputConfig();
  }

  public static final int EVALUATION_CONFIG_FIELD_NUMBER = 2;
  private com.google.cloud.datalabeling.v1beta1.EvaluationConfig evaluationConfig_;
  /**
   *
   *
   * <pre>
   * Config used to create evaluation.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.EvaluationConfig evaluation_config = 2;</code>
   */
  public boolean hasEvaluationConfig() {
    return evaluationConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Config used to create evaluation.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.EvaluationConfig evaluation_config = 2;</code>
   */
  public com.google.cloud.datalabeling.v1beta1.EvaluationConfig getEvaluationConfig() {
    return evaluationConfig_ == null
        ? com.google.cloud.datalabeling.v1beta1.EvaluationConfig.getDefaultInstance()
        : evaluationConfig_;
  }
  /**
   *
   *
   * <pre>
   * Config used to create evaluation.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.EvaluationConfig evaluation_config = 2;</code>
   */
  public com.google.cloud.datalabeling.v1beta1.EvaluationConfigOrBuilder
      getEvaluationConfigOrBuilder() {
    return getEvaluationConfig();
  }

  public static final int HUMAN_ANNOTATION_CONFIG_FIELD_NUMBER = 3;
  private com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig humanAnnotationConfig_;
  /**
   * <code>.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig human_annotation_config = 3;
   * </code>
   */
  public boolean hasHumanAnnotationConfig() {
    return humanAnnotationConfig_ != null;
  }
  /**
   * <code>.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig human_annotation_config = 3;
   * </code>
   */
  public com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig getHumanAnnotationConfig() {
    return humanAnnotationConfig_ == null
        ? com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.getDefaultInstance()
        : humanAnnotationConfig_;
  }
  /**
   * <code>.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig human_annotation_config = 3;
   * </code>
   */
  public com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfigOrBuilder
      getHumanAnnotationConfigOrBuilder() {
    return getHumanAnnotationConfig();
  }

  public static final int BIGQUERY_IMPORT_KEYS_FIELD_NUMBER = 9;

  private static final class BigqueryImportKeysDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.datalabeling.v1beta1.EvaluationJobOuterClass
                .internal_static_google_cloud_datalabeling_v1beta1_EvaluationJobConfig_BigqueryImportKeysEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> bigqueryImportKeys_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetBigqueryImportKeys() {
    if (bigqueryImportKeys_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          BigqueryImportKeysDefaultEntryHolder.defaultEntry);
    }
    return bigqueryImportKeys_;
  }

  public int getBigqueryImportKeysCount() {
    return internalGetBigqueryImportKeys().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Mappings between reserved keys for bigquery import and customized tensor
   * names. Key is the reserved key, value is tensor name in the bigquery table.
   * Different annotation type has different required key mapping. See user
   * manual for more details:
   * https:
   * //docs.google.com/document/d/1bg1meMIBGY
   * // 9I5QEoFoHSX6u9LsZQYBSmPt6E9SxqHZc/edit#heading=h.tfyjhxhvsqem
   * </pre>
   *
   * <code>map&lt;string, string&gt; bigquery_import_keys = 9;</code>
   */
  public boolean containsBigqueryImportKeys(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    return internalGetBigqueryImportKeys().getMap().containsKey(key);
  }
  /** Use {@link #getBigqueryImportKeysMap()} instead. */
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getBigqueryImportKeys() {
    return getBigqueryImportKeysMap();
  }
  /**
   *
   *
   * <pre>
   * Mappings between reserved keys for bigquery import and customized tensor
   * names. Key is the reserved key, value is tensor name in the bigquery table.
   * Different annotation type has different required key mapping. See user
   * manual for more details:
   * https:
   * //docs.google.com/document/d/1bg1meMIBGY
   * // 9I5QEoFoHSX6u9LsZQYBSmPt6E9SxqHZc/edit#heading=h.tfyjhxhvsqem
   * </pre>
   *
   * <code>map&lt;string, string&gt; bigquery_import_keys = 9;</code>
   */
  public java.util.Map<java.lang.String, java.lang.String> getBigqueryImportKeysMap() {
    return internalGetBigqueryImportKeys().getMap();
  }
  /**
   *
   *
   * <pre>
   * Mappings between reserved keys for bigquery import and customized tensor
   * names. Key is the reserved key, value is tensor name in the bigquery table.
   * Different annotation type has different required key mapping. See user
   * manual for more details:
   * https:
   * //docs.google.com/document/d/1bg1meMIBGY
   * // 9I5QEoFoHSX6u9LsZQYBSmPt6E9SxqHZc/edit#heading=h.tfyjhxhvsqem
   * </pre>
   *
   * <code>map&lt;string, string&gt; bigquery_import_keys = 9;</code>
   */
  public java.lang.String getBigqueryImportKeysOrDefault(
      java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, java.lang.String> map =
        internalGetBigqueryImportKeys().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Mappings between reserved keys for bigquery import and customized tensor
   * names. Key is the reserved key, value is tensor name in the bigquery table.
   * Different annotation type has different required key mapping. See user
   * manual for more details:
   * https:
   * //docs.google.com/document/d/1bg1meMIBGY
   * // 9I5QEoFoHSX6u9LsZQYBSmPt6E9SxqHZc/edit#heading=h.tfyjhxhvsqem
   * </pre>
   *
   * <code>map&lt;string, string&gt; bigquery_import_keys = 9;</code>
   */
  public java.lang.String getBigqueryImportKeysOrThrow(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, java.lang.String> map =
        internalGetBigqueryImportKeys().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int EXAMPLE_COUNT_FIELD_NUMBER = 10;
  private int exampleCount_;
  /**
   *
   *
   * <pre>
   * Max number of examples to collect in each period.
   * </pre>
   *
   * <code>int32 example_count = 10;</code>
   */
  public int getExampleCount() {
    return exampleCount_;
  }

  public static final int EXAMPLE_SAMPLE_PERCENTAGE_FIELD_NUMBER = 11;
  private double exampleSamplePercentage_;
  /**
   *
   *
   * <pre>
   * Percentage of examples to collect in each period. 0.1 means 10% of total
   * examples will be collected, and 0.0 means no collection.
   * </pre>
   *
   * <code>double example_sample_percentage = 11;</code>
   */
  public double getExampleSamplePercentage() {
    return exampleSamplePercentage_;
  }

  public static final int EVALUATION_JOB_ALERT_CONFIG_FIELD_NUMBER = 13;
  private com.google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig evaluationJobAlertConfig_;
  /**
   *
   *
   * <pre>
   * Alert config for the evaluation job. The alert will be triggered when its
   * criteria is met.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig evaluation_job_alert_config = 13;
   * </code>
   */
  public boolean hasEvaluationJobAlertConfig() {
    return evaluationJobAlertConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Alert config for the evaluation job. The alert will be triggered when its
   * criteria is met.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig evaluation_job_alert_config = 13;
   * </code>
   */
  public com.google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig
      getEvaluationJobAlertConfig() {
    return evaluationJobAlertConfig_ == null
        ? com.google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig.getDefaultInstance()
        : evaluationJobAlertConfig_;
  }
  /**
   *
   *
   * <pre>
   * Alert config for the evaluation job. The alert will be triggered when its
   * criteria is met.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig evaluation_job_alert_config = 13;
   * </code>
   */
  public com.google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfigOrBuilder
      getEvaluationJobAlertConfigOrBuilder() {
    return getEvaluationJobAlertConfig();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (inputConfig_ != null) {
      output.writeMessage(1, getInputConfig());
    }
    if (evaluationConfig_ != null) {
      output.writeMessage(2, getEvaluationConfig());
    }
    if (humanAnnotationConfig_ != null) {
      output.writeMessage(3, getHumanAnnotationConfig());
    }
    if (humanAnnotationRequestConfigCase_ == 4) {
      output.writeMessage(
          4,
          (com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig)
              humanAnnotationRequestConfig_);
    }
    if (humanAnnotationRequestConfigCase_ == 5) {
      output.writeMessage(
          5,
          (com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig) humanAnnotationRequestConfig_);
    }
    if (humanAnnotationRequestConfigCase_ == 6) {
      output.writeMessage(
          6,
          (com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig)
              humanAnnotationRequestConfig_);
    }
    if (humanAnnotationRequestConfigCase_ == 7) {
      output.writeMessage(
          7,
          (com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig)
              humanAnnotationRequestConfig_);
    }
    if (humanAnnotationRequestConfigCase_ == 8) {
      output.writeMessage(
          8,
          (com.google.cloud.datalabeling.v1beta1.TextClassificationConfig)
              humanAnnotationRequestConfig_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output,
        internalGetBigqueryImportKeys(),
        BigqueryImportKeysDefaultEntryHolder.defaultEntry,
        9);
    if (exampleCount_ != 0) {
      output.writeInt32(10, exampleCount_);
    }
    if (exampleSamplePercentage_ != 0D) {
      output.writeDouble(11, exampleSamplePercentage_);
    }
    if (humanAnnotationRequestConfigCase_ == 12) {
      output.writeMessage(
          12,
          (com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig)
              humanAnnotationRequestConfig_);
    }
    if (evaluationJobAlertConfig_ != null) {
      output.writeMessage(13, getEvaluationJobAlertConfig());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (inputConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getInputConfig());
    }
    if (evaluationConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getEvaluationConfig());
    }
    if (humanAnnotationConfig_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(3, getHumanAnnotationConfig());
    }
    if (humanAnnotationRequestConfigCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4,
              (com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig)
                  humanAnnotationRequestConfig_);
    }
    if (humanAnnotationRequestConfigCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5,
              (com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig)
                  humanAnnotationRequestConfig_);
    }
    if (humanAnnotationRequestConfigCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6,
              (com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig)
                  humanAnnotationRequestConfig_);
    }
    if (humanAnnotationRequestConfigCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7,
              (com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig)
                  humanAnnotationRequestConfig_);
    }
    if (humanAnnotationRequestConfigCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8,
              (com.google.cloud.datalabeling.v1beta1.TextClassificationConfig)
                  humanAnnotationRequestConfig_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetBigqueryImportKeys().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> bigqueryImportKeys__ =
          BigqueryImportKeysDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, bigqueryImportKeys__);
    }
    if (exampleCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(10, exampleCount_);
    }
    if (exampleSamplePercentage_ != 0D) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(11, exampleSamplePercentage_);
    }
    if (humanAnnotationRequestConfigCase_ == 12) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              12,
              (com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig)
                  humanAnnotationRequestConfig_);
    }
    if (evaluationJobAlertConfig_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              13, getEvaluationJobAlertConfig());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig other =
        (com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig) obj;

    if (hasInputConfig() != other.hasInputConfig()) return false;
    if (hasInputConfig()) {
      if (!getInputConfig().equals(other.getInputConfig())) return false;
    }
    if (hasEvaluationConfig() != other.hasEvaluationConfig()) return false;
    if (hasEvaluationConfig()) {
      if (!getEvaluationConfig().equals(other.getEvaluationConfig())) return false;
    }
    if (hasHumanAnnotationConfig() != other.hasHumanAnnotationConfig()) return false;
    if (hasHumanAnnotationConfig()) {
      if (!getHumanAnnotationConfig().equals(other.getHumanAnnotationConfig())) return false;
    }
    if (!internalGetBigqueryImportKeys().equals(other.internalGetBigqueryImportKeys()))
      return false;
    if (getExampleCount() != other.getExampleCount()) return false;
    if (java.lang.Double.doubleToLongBits(getExampleSamplePercentage())
        != java.lang.Double.doubleToLongBits(other.getExampleSamplePercentage())) return false;
    if (hasEvaluationJobAlertConfig() != other.hasEvaluationJobAlertConfig()) return false;
    if (hasEvaluationJobAlertConfig()) {
      if (!getEvaluationJobAlertConfig().equals(other.getEvaluationJobAlertConfig())) return false;
    }
    if (!getHumanAnnotationRequestConfigCase().equals(other.getHumanAnnotationRequestConfigCase()))
      return false;
    switch (humanAnnotationRequestConfigCase_) {
      case 4:
        if (!getImageClassificationConfig().equals(other.getImageClassificationConfig()))
          return false;
        break;
      case 5:
        if (!getBoundingPolyConfig().equals(other.getBoundingPolyConfig())) return false;
        break;
      case 6:
        if (!getVideoClassificationConfig().equals(other.getVideoClassificationConfig()))
          return false;
        break;
      case 7:
        if (!getObjectDetectionConfig().equals(other.getObjectDetectionConfig())) return false;
        break;
      case 8:
        if (!getTextClassificationConfig().equals(other.getTextClassificationConfig()))
          return false;
        break;
      case 12:
        if (!getObjectTrackingConfig().equals(other.getObjectTrackingConfig())) return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasInputConfig()) {
      hash = (37 * hash) + INPUT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getInputConfig().hashCode();
    }
    if (hasEvaluationConfig()) {
      hash = (37 * hash) + EVALUATION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getEvaluationConfig().hashCode();
    }
    if (hasHumanAnnotationConfig()) {
      hash = (37 * hash) + HUMAN_ANNOTATION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getHumanAnnotationConfig().hashCode();
    }
    if (!internalGetBigqueryImportKeys().getMap().isEmpty()) {
      hash = (37 * hash) + BIGQUERY_IMPORT_KEYS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetBigqueryImportKeys().hashCode();
    }
    hash = (37 * hash) + EXAMPLE_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getExampleCount();
    hash = (37 * hash) + EXAMPLE_SAMPLE_PERCENTAGE_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(
                java.lang.Double.doubleToLongBits(getExampleSamplePercentage()));
    if (hasEvaluationJobAlertConfig()) {
      hash = (37 * hash) + EVALUATION_JOB_ALERT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getEvaluationJobAlertConfig().hashCode();
    }
    switch (humanAnnotationRequestConfigCase_) {
      case 4:
        hash = (37 * hash) + IMAGE_CLASSIFICATION_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getImageClassificationConfig().hashCode();
        break;
      case 5:
        hash = (37 * hash) + BOUNDING_POLY_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getBoundingPolyConfig().hashCode();
        break;
      case 6:
        hash = (37 * hash) + VIDEO_CLASSIFICATION_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getVideoClassificationConfig().hashCode();
        break;
      case 7:
        hash = (37 * hash) + OBJECT_DETECTION_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getObjectDetectionConfig().hashCode();
        break;
      case 8:
        hash = (37 * hash) + TEXT_CLASSIFICATION_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getTextClassificationConfig().hashCode();
        break;
      case 12:
        hash = (37 * hash) + OBJECT_TRACKING_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getObjectTrackingConfig().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /** Protobuf type {@code google.cloud.datalabeling.v1beta1.EvaluationJobConfig} */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datalabeling.v1beta1.EvaluationJobConfig)
      com.google.cloud.datalabeling.v1beta1.EvaluationJobConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datalabeling.v1beta1.EvaluationJobOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_EvaluationJobConfig_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 9:
          return internalGetBigqueryImportKeys();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 9:
          return internalGetMutableBigqueryImportKeys();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datalabeling.v1beta1.EvaluationJobOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_EvaluationJobConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig.class,
              com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig.Builder.class);
    }

    // Construct using com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (inputConfigBuilder_ == null) {
        inputConfig_ = null;
      } else {
        inputConfig_ = null;
        inputConfigBuilder_ = null;
      }
      if (evaluationConfigBuilder_ == null) {
        evaluationConfig_ = null;
      } else {
        evaluationConfig_ = null;
        evaluationConfigBuilder_ = null;
      }
      if (humanAnnotationConfigBuilder_ == null) {
        humanAnnotationConfig_ = null;
      } else {
        humanAnnotationConfig_ = null;
        humanAnnotationConfigBuilder_ = null;
      }
      internalGetMutableBigqueryImportKeys().clear();
      exampleCount_ = 0;

      exampleSamplePercentage_ = 0D;

      if (evaluationJobAlertConfigBuilder_ == null) {
        evaluationJobAlertConfig_ = null;
      } else {
        evaluationJobAlertConfig_ = null;
        evaluationJobAlertConfigBuilder_ = null;
      }
      humanAnnotationRequestConfigCase_ = 0;
      humanAnnotationRequestConfig_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datalabeling.v1beta1.EvaluationJobOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_EvaluationJobConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig getDefaultInstanceForType() {
      return com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig build() {
      com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig buildPartial() {
      com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig result =
          new com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (humanAnnotationRequestConfigCase_ == 4) {
        if (imageClassificationConfigBuilder_ == null) {
          result.humanAnnotationRequestConfig_ = humanAnnotationRequestConfig_;
        } else {
          result.humanAnnotationRequestConfig_ = imageClassificationConfigBuilder_.build();
        }
      }
      if (humanAnnotationRequestConfigCase_ == 5) {
        if (boundingPolyConfigBuilder_ == null) {
          result.humanAnnotationRequestConfig_ = humanAnnotationRequestConfig_;
        } else {
          result.humanAnnotationRequestConfig_ = boundingPolyConfigBuilder_.build();
        }
      }
      if (humanAnnotationRequestConfigCase_ == 6) {
        if (videoClassificationConfigBuilder_ == null) {
          result.humanAnnotationRequestConfig_ = humanAnnotationRequestConfig_;
        } else {
          result.humanAnnotationRequestConfig_ = videoClassificationConfigBuilder_.build();
        }
      }
      if (humanAnnotationRequestConfigCase_ == 7) {
        if (objectDetectionConfigBuilder_ == null) {
          result.humanAnnotationRequestConfig_ = humanAnnotationRequestConfig_;
        } else {
          result.humanAnnotationRequestConfig_ = objectDetectionConfigBuilder_.build();
        }
      }
      if (humanAnnotationRequestConfigCase_ == 8) {
        if (textClassificationConfigBuilder_ == null) {
          result.humanAnnotationRequestConfig_ = humanAnnotationRequestConfig_;
        } else {
          result.humanAnnotationRequestConfig_ = textClassificationConfigBuilder_.build();
        }
      }
      if (humanAnnotationRequestConfigCase_ == 12) {
        if (objectTrackingConfigBuilder_ == null) {
          result.humanAnnotationRequestConfig_ = humanAnnotationRequestConfig_;
        } else {
          result.humanAnnotationRequestConfig_ = objectTrackingConfigBuilder_.build();
        }
      }
      if (inputConfigBuilder_ == null) {
        result.inputConfig_ = inputConfig_;
      } else {
        result.inputConfig_ = inputConfigBuilder_.build();
      }
      if (evaluationConfigBuilder_ == null) {
        result.evaluationConfig_ = evaluationConfig_;
      } else {
        result.evaluationConfig_ = evaluationConfigBuilder_.build();
      }
      if (humanAnnotationConfigBuilder_ == null) {
        result.humanAnnotationConfig_ = humanAnnotationConfig_;
      } else {
        result.humanAnnotationConfig_ = humanAnnotationConfigBuilder_.build();
      }
      result.bigqueryImportKeys_ = internalGetBigqueryImportKeys();
      result.bigqueryImportKeys_.makeImmutable();
      result.exampleCount_ = exampleCount_;
      result.exampleSamplePercentage_ = exampleSamplePercentage_;
      if (evaluationJobAlertConfigBuilder_ == null) {
        result.evaluationJobAlertConfig_ = evaluationJobAlertConfig_;
      } else {
        result.evaluationJobAlertConfig_ = evaluationJobAlertConfigBuilder_.build();
      }
      result.bitField0_ = to_bitField0_;
      result.humanAnnotationRequestConfigCase_ = humanAnnotationRequestConfigCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig) {
        return mergeFrom((com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig other) {
      if (other == com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig.getDefaultInstance())
        return this;
      if (other.hasInputConfig()) {
        mergeInputConfig(other.getInputConfig());
      }
      if (other.hasEvaluationConfig()) {
        mergeEvaluationConfig(other.getEvaluationConfig());
      }
      if (other.hasHumanAnnotationConfig()) {
        mergeHumanAnnotationConfig(other.getHumanAnnotationConfig());
      }
      internalGetMutableBigqueryImportKeys().mergeFrom(other.internalGetBigqueryImportKeys());
      if (other.getExampleCount() != 0) {
        setExampleCount(other.getExampleCount());
      }
      if (other.getExampleSamplePercentage() != 0D) {
        setExampleSamplePercentage(other.getExampleSamplePercentage());
      }
      if (other.hasEvaluationJobAlertConfig()) {
        mergeEvaluationJobAlertConfig(other.getEvaluationJobAlertConfig());
      }
      switch (other.getHumanAnnotationRequestConfigCase()) {
        case IMAGE_CLASSIFICATION_CONFIG:
          {
            mergeImageClassificationConfig(other.getImageClassificationConfig());
            break;
          }
        case BOUNDING_POLY_CONFIG:
          {
            mergeBoundingPolyConfig(other.getBoundingPolyConfig());
            break;
          }
        case VIDEO_CLASSIFICATION_CONFIG:
          {
            mergeVideoClassificationConfig(other.getVideoClassificationConfig());
            break;
          }
        case OBJECT_DETECTION_CONFIG:
          {
            mergeObjectDetectionConfig(other.getObjectDetectionConfig());
            break;
          }
        case TEXT_CLASSIFICATION_CONFIG:
          {
            mergeTextClassificationConfig(other.getTextClassificationConfig());
            break;
          }
        case OBJECT_TRACKING_CONFIG:
          {
            mergeObjectTrackingConfig(other.getObjectTrackingConfig());
            break;
          }
        case HUMANANNOTATIONREQUESTCONFIG_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int humanAnnotationRequestConfigCase_ = 0;
    private java.lang.Object humanAnnotationRequestConfig_;

    public HumanAnnotationRequestConfigCase getHumanAnnotationRequestConfigCase() {
      return HumanAnnotationRequestConfigCase.forNumber(humanAnnotationRequestConfigCase_);
    }

    public Builder clearHumanAnnotationRequestConfig() {
      humanAnnotationRequestConfigCase_ = 0;
      humanAnnotationRequestConfig_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig,
            com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.ImageClassificationConfigOrBuilder>
        imageClassificationConfigBuilder_;
    /**
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageClassificationConfig image_classification_config = 4;
     * </code>
     */
    public boolean hasImageClassificationConfig() {
      return humanAnnotationRequestConfigCase_ == 4;
    }
    /**
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageClassificationConfig image_classification_config = 4;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig
        getImageClassificationConfig() {
      if (imageClassificationConfigBuilder_ == null) {
        if (humanAnnotationRequestConfigCase_ == 4) {
          return (com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig)
              humanAnnotationRequestConfig_;
        }
        return com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig.getDefaultInstance();
      } else {
        if (humanAnnotationRequestConfigCase_ == 4) {
          return imageClassificationConfigBuilder_.getMessage();
        }
        return com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig.getDefaultInstance();
      }
    }
    /**
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageClassificationConfig image_classification_config = 4;
     * </code>
     */
    public Builder setImageClassificationConfig(
        com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig value) {
      if (imageClassificationConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        humanAnnotationRequestConfig_ = value;
        onChanged();
      } else {
        imageClassificationConfigBuilder_.setMessage(value);
      }
      humanAnnotationRequestConfigCase_ = 4;
      return this;
    }
    /**
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageClassificationConfig image_classification_config = 4;
     * </code>
     */
    public Builder setImageClassificationConfig(
        com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig.Builder builderForValue) {
      if (imageClassificationConfigBuilder_ == null) {
        humanAnnotationRequestConfig_ = builderForValue.build();
        onChanged();
      } else {
        imageClassificationConfigBuilder_.setMessage(builderForValue.build());
      }
      humanAnnotationRequestConfigCase_ = 4;
      return this;
    }
    /**
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageClassificationConfig image_classification_config = 4;
     * </code>
     */
    public Builder mergeImageClassificationConfig(
        com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig value) {
      if (imageClassificationConfigBuilder_ == null) {
        if (humanAnnotationRequestConfigCase_ == 4
            && humanAnnotationRequestConfig_
                != com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig
                    .getDefaultInstance()) {
          humanAnnotationRequestConfig_ =
              com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig.newBuilder(
                      (com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig)
                          humanAnnotationRequestConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          humanAnnotationRequestConfig_ = value;
        }
        onChanged();
      } else {
        if (humanAnnotationRequestConfigCase_ == 4) {
          imageClassificationConfigBuilder_.mergeFrom(value);
        }
        imageClassificationConfigBuilder_.setMessage(value);
      }
      humanAnnotationRequestConfigCase_ = 4;
      return this;
    }
    /**
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageClassificationConfig image_classification_config = 4;
     * </code>
     */
    public Builder clearImageClassificationConfig() {
      if (imageClassificationConfigBuilder_ == null) {
        if (humanAnnotationRequestConfigCase_ == 4) {
          humanAnnotationRequestConfigCase_ = 0;
          humanAnnotationRequestConfig_ = null;
          onChanged();
        }
      } else {
        if (humanAnnotationRequestConfigCase_ == 4) {
          humanAnnotationRequestConfigCase_ = 0;
          humanAnnotationRequestConfig_ = null;
        }
        imageClassificationConfigBuilder_.clear();
      }
      return this;
    }
    /**
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageClassificationConfig image_classification_config = 4;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig.Builder
        getImageClassificationConfigBuilder() {
      return getImageClassificationConfigFieldBuilder().getBuilder();
    }
    /**
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageClassificationConfig image_classification_config = 4;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.ImageClassificationConfigOrBuilder
        getImageClassificationConfigOrBuilder() {
      if ((humanAnnotationRequestConfigCase_ == 4) && (imageClassificationConfigBuilder_ != null)) {
        return imageClassificationConfigBuilder_.getMessageOrBuilder();
      } else {
        if (humanAnnotationRequestConfigCase_ == 4) {
          return (com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig)
              humanAnnotationRequestConfig_;
        }
        return com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig.getDefaultInstance();
      }
    }
    /**
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageClassificationConfig image_classification_config = 4;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig,
            com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.ImageClassificationConfigOrBuilder>
        getImageClassificationConfigFieldBuilder() {
      if (imageClassificationConfigBuilder_ == null) {
        if (!(humanAnnotationRequestConfigCase_ == 4)) {
          humanAnnotationRequestConfig_ =
              com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig.getDefaultInstance();
        }
        imageClassificationConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig,
                com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig.Builder,
                com.google.cloud.datalabeling.v1beta1.ImageClassificationConfigOrBuilder>(
                (com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig)
                    humanAnnotationRequestConfig_,
                getParentForChildren(),
                isClean());
        humanAnnotationRequestConfig_ = null;
      }
      humanAnnotationRequestConfigCase_ = 4;
      onChanged();
      ;
      return imageClassificationConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig,
            com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.BoundingPolyConfigOrBuilder>
        boundingPolyConfigBuilder_;
    /**
     * <code>.google.cloud.datalabeling.v1beta1.BoundingPolyConfig bounding_poly_config = 5;</code>
     */
    public boolean hasBoundingPolyConfig() {
      return humanAnnotationRequestConfigCase_ == 5;
    }
    /**
     * <code>.google.cloud.datalabeling.v1beta1.BoundingPolyConfig bounding_poly_config = 5;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig getBoundingPolyConfig() {
      if (boundingPolyConfigBuilder_ == null) {
        if (humanAnnotationRequestConfigCase_ == 5) {
          return (com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig)
              humanAnnotationRequestConfig_;
        }
        return com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig.getDefaultInstance();
      } else {
        if (humanAnnotationRequestConfigCase_ == 5) {
          return boundingPolyConfigBuilder_.getMessage();
        }
        return com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig.getDefaultInstance();
      }
    }
    /**
     * <code>.google.cloud.datalabeling.v1beta1.BoundingPolyConfig bounding_poly_config = 5;</code>
     */
    public Builder setBoundingPolyConfig(
        com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig value) {
      if (boundingPolyConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        humanAnnotationRequestConfig_ = value;
        onChanged();
      } else {
        boundingPolyConfigBuilder_.setMessage(value);
      }
      humanAnnotationRequestConfigCase_ = 5;
      return this;
    }
    /**
     * <code>.google.cloud.datalabeling.v1beta1.BoundingPolyConfig bounding_poly_config = 5;</code>
     */
    public Builder setBoundingPolyConfig(
        com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig.Builder builderForValue) {
      if (boundingPolyConfigBuilder_ == null) {
        humanAnnotationRequestConfig_ = builderForValue.build();
        onChanged();
      } else {
        boundingPolyConfigBuilder_.setMessage(builderForValue.build());
      }
      humanAnnotationRequestConfigCase_ = 5;
      return this;
    }
    /**
     * <code>.google.cloud.datalabeling.v1beta1.BoundingPolyConfig bounding_poly_config = 5;</code>
     */
    public Builder mergeBoundingPolyConfig(
        com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig value) {
      if (boundingPolyConfigBuilder_ == null) {
        if (humanAnnotationRequestConfigCase_ == 5
            && humanAnnotationRequestConfig_
                != com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig.getDefaultInstance()) {
          humanAnnotationRequestConfig_ =
              com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig.newBuilder(
                      (com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig)
                          humanAnnotationRequestConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          humanAnnotationRequestConfig_ = value;
        }
        onChanged();
      } else {
        if (humanAnnotationRequestConfigCase_ == 5) {
          boundingPolyConfigBuilder_.mergeFrom(value);
        }
        boundingPolyConfigBuilder_.setMessage(value);
      }
      humanAnnotationRequestConfigCase_ = 5;
      return this;
    }
    /**
     * <code>.google.cloud.datalabeling.v1beta1.BoundingPolyConfig bounding_poly_config = 5;</code>
     */
    public Builder clearBoundingPolyConfig() {
      if (boundingPolyConfigBuilder_ == null) {
        if (humanAnnotationRequestConfigCase_ == 5) {
          humanAnnotationRequestConfigCase_ = 0;
          humanAnnotationRequestConfig_ = null;
          onChanged();
        }
      } else {
        if (humanAnnotationRequestConfigCase_ == 5) {
          humanAnnotationRequestConfigCase_ = 0;
          humanAnnotationRequestConfig_ = null;
        }
        boundingPolyConfigBuilder_.clear();
      }
      return this;
    }
    /**
     * <code>.google.cloud.datalabeling.v1beta1.BoundingPolyConfig bounding_poly_config = 5;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig.Builder
        getBoundingPolyConfigBuilder() {
      return getBoundingPolyConfigFieldBuilder().getBuilder();
    }
    /**
     * <code>.google.cloud.datalabeling.v1beta1.BoundingPolyConfig bounding_poly_config = 5;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.BoundingPolyConfigOrBuilder
        getBoundingPolyConfigOrBuilder() {
      if ((humanAnnotationRequestConfigCase_ == 5) && (boundingPolyConfigBuilder_ != null)) {
        return boundingPolyConfigBuilder_.getMessageOrBuilder();
      } else {
        if (humanAnnotationRequestConfigCase_ == 5) {
          return (com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig)
              humanAnnotationRequestConfig_;
        }
        return com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig.getDefaultInstance();
      }
    }
    /**
     * <code>.google.cloud.datalabeling.v1beta1.BoundingPolyConfig bounding_poly_config = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig,
            com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.BoundingPolyConfigOrBuilder>
        getBoundingPolyConfigFieldBuilder() {
      if (boundingPolyConfigBuilder_ == null) {
        if (!(humanAnnotationRequestConfigCase_ == 5)) {
          humanAnnotationRequestConfig_ =
              com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig.getDefaultInstance();
        }
        boundingPolyConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig,
                com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig.Builder,
                com.google.cloud.datalabeling.v1beta1.BoundingPolyConfigOrBuilder>(
                (com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig)
                    humanAnnotationRequestConfig_,
                getParentForChildren(),
                isClean());
        humanAnnotationRequestConfig_ = null;
      }
      humanAnnotationRequestConfigCase_ = 5;
      onChanged();
      ;
      return boundingPolyConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig,
            com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.VideoClassificationConfigOrBuilder>
        videoClassificationConfigBuilder_;
    /**
     * <code>
     * .google.cloud.datalabeling.v1beta1.VideoClassificationConfig video_classification_config = 6;
     * </code>
     */
    public boolean hasVideoClassificationConfig() {
      return humanAnnotationRequestConfigCase_ == 6;
    }
    /**
     * <code>
     * .google.cloud.datalabeling.v1beta1.VideoClassificationConfig video_classification_config = 6;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig
        getVideoClassificationConfig() {
      if (videoClassificationConfigBuilder_ == null) {
        if (humanAnnotationRequestConfigCase_ == 6) {
          return (com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig)
              humanAnnotationRequestConfig_;
        }
        return com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.getDefaultInstance();
      } else {
        if (humanAnnotationRequestConfigCase_ == 6) {
          return videoClassificationConfigBuilder_.getMessage();
        }
        return com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.getDefaultInstance();
      }
    }
    /**
     * <code>
     * .google.cloud.datalabeling.v1beta1.VideoClassificationConfig video_classification_config = 6;
     * </code>
     */
    public Builder setVideoClassificationConfig(
        com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig value) {
      if (videoClassificationConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        humanAnnotationRequestConfig_ = value;
        onChanged();
      } else {
        videoClassificationConfigBuilder_.setMessage(value);
      }
      humanAnnotationRequestConfigCase_ = 6;
      return this;
    }
    /**
     * <code>
     * .google.cloud.datalabeling.v1beta1.VideoClassificationConfig video_classification_config = 6;
     * </code>
     */
    public Builder setVideoClassificationConfig(
        com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.Builder builderForValue) {
      if (videoClassificationConfigBuilder_ == null) {
        humanAnnotationRequestConfig_ = builderForValue.build();
        onChanged();
      } else {
        videoClassificationConfigBuilder_.setMessage(builderForValue.build());
      }
      humanAnnotationRequestConfigCase_ = 6;
      return this;
    }
    /**
     * <code>
     * .google.cloud.datalabeling.v1beta1.VideoClassificationConfig video_classification_config = 6;
     * </code>
     */
    public Builder mergeVideoClassificationConfig(
        com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig value) {
      if (videoClassificationConfigBuilder_ == null) {
        if (humanAnnotationRequestConfigCase_ == 6
            && humanAnnotationRequestConfig_
                != com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig
                    .getDefaultInstance()) {
          humanAnnotationRequestConfig_ =
              com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.newBuilder(
                      (com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig)
                          humanAnnotationRequestConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          humanAnnotationRequestConfig_ = value;
        }
        onChanged();
      } else {
        if (humanAnnotationRequestConfigCase_ == 6) {
          videoClassificationConfigBuilder_.mergeFrom(value);
        }
        videoClassificationConfigBuilder_.setMessage(value);
      }
      humanAnnotationRequestConfigCase_ = 6;
      return this;
    }
    /**
     * <code>
     * .google.cloud.datalabeling.v1beta1.VideoClassificationConfig video_classification_config = 6;
     * </code>
     */
    public Builder clearVideoClassificationConfig() {
      if (videoClassificationConfigBuilder_ == null) {
        if (humanAnnotationRequestConfigCase_ == 6) {
          humanAnnotationRequestConfigCase_ = 0;
          humanAnnotationRequestConfig_ = null;
          onChanged();
        }
      } else {
        if (humanAnnotationRequestConfigCase_ == 6) {
          humanAnnotationRequestConfigCase_ = 0;
          humanAnnotationRequestConfig_ = null;
        }
        videoClassificationConfigBuilder_.clear();
      }
      return this;
    }
    /**
     * <code>
     * .google.cloud.datalabeling.v1beta1.VideoClassificationConfig video_classification_config = 6;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.Builder
        getVideoClassificationConfigBuilder() {
      return getVideoClassificationConfigFieldBuilder().getBuilder();
    }
    /**
     * <code>
     * .google.cloud.datalabeling.v1beta1.VideoClassificationConfig video_classification_config = 6;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.VideoClassificationConfigOrBuilder
        getVideoClassificationConfigOrBuilder() {
      if ((humanAnnotationRequestConfigCase_ == 6) && (videoClassificationConfigBuilder_ != null)) {
        return videoClassificationConfigBuilder_.getMessageOrBuilder();
      } else {
        if (humanAnnotationRequestConfigCase_ == 6) {
          return (com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig)
              humanAnnotationRequestConfig_;
        }
        return com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.getDefaultInstance();
      }
    }
    /**
     * <code>
     * .google.cloud.datalabeling.v1beta1.VideoClassificationConfig video_classification_config = 6;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig,
            com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.VideoClassificationConfigOrBuilder>
        getVideoClassificationConfigFieldBuilder() {
      if (videoClassificationConfigBuilder_ == null) {
        if (!(humanAnnotationRequestConfigCase_ == 6)) {
          humanAnnotationRequestConfig_ =
              com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.getDefaultInstance();
        }
        videoClassificationConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig,
                com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.Builder,
                com.google.cloud.datalabeling.v1beta1.VideoClassificationConfigOrBuilder>(
                (com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig)
                    humanAnnotationRequestConfig_,
                getParentForChildren(),
                isClean());
        humanAnnotationRequestConfig_ = null;
      }
      humanAnnotationRequestConfigCase_ = 6;
      onChanged();
      ;
      return videoClassificationConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig,
            com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfigOrBuilder>
        objectDetectionConfigBuilder_;
    /**
     * <code>.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig object_detection_config = 7;
     * </code>
     */
    public boolean hasObjectDetectionConfig() {
      return humanAnnotationRequestConfigCase_ == 7;
    }
    /**
     * <code>.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig object_detection_config = 7;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig getObjectDetectionConfig() {
      if (objectDetectionConfigBuilder_ == null) {
        if (humanAnnotationRequestConfigCase_ == 7) {
          return (com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig)
              humanAnnotationRequestConfig_;
        }
        return com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig.getDefaultInstance();
      } else {
        if (humanAnnotationRequestConfigCase_ == 7) {
          return objectDetectionConfigBuilder_.getMessage();
        }
        return com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig.getDefaultInstance();
      }
    }
    /**
     * <code>.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig object_detection_config = 7;
     * </code>
     */
    public Builder setObjectDetectionConfig(
        com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig value) {
      if (objectDetectionConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        humanAnnotationRequestConfig_ = value;
        onChanged();
      } else {
        objectDetectionConfigBuilder_.setMessage(value);
      }
      humanAnnotationRequestConfigCase_ = 7;
      return this;
    }
    /**
     * <code>.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig object_detection_config = 7;
     * </code>
     */
    public Builder setObjectDetectionConfig(
        com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig.Builder builderForValue) {
      if (objectDetectionConfigBuilder_ == null) {
        humanAnnotationRequestConfig_ = builderForValue.build();
        onChanged();
      } else {
        objectDetectionConfigBuilder_.setMessage(builderForValue.build());
      }
      humanAnnotationRequestConfigCase_ = 7;
      return this;
    }
    /**
     * <code>.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig object_detection_config = 7;
     * </code>
     */
    public Builder mergeObjectDetectionConfig(
        com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig value) {
      if (objectDetectionConfigBuilder_ == null) {
        if (humanAnnotationRequestConfigCase_ == 7
            && humanAnnotationRequestConfig_
                != com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig
                    .getDefaultInstance()) {
          humanAnnotationRequestConfig_ =
              com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig.newBuilder(
                      (com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig)
                          humanAnnotationRequestConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          humanAnnotationRequestConfig_ = value;
        }
        onChanged();
      } else {
        if (humanAnnotationRequestConfigCase_ == 7) {
          objectDetectionConfigBuilder_.mergeFrom(value);
        }
        objectDetectionConfigBuilder_.setMessage(value);
      }
      humanAnnotationRequestConfigCase_ = 7;
      return this;
    }
    /**
     * <code>.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig object_detection_config = 7;
     * </code>
     */
    public Builder clearObjectDetectionConfig() {
      if (objectDetectionConfigBuilder_ == null) {
        if (humanAnnotationRequestConfigCase_ == 7) {
          humanAnnotationRequestConfigCase_ = 0;
          humanAnnotationRequestConfig_ = null;
          onChanged();
        }
      } else {
        if (humanAnnotationRequestConfigCase_ == 7) {
          humanAnnotationRequestConfigCase_ = 0;
          humanAnnotationRequestConfig_ = null;
        }
        objectDetectionConfigBuilder_.clear();
      }
      return this;
    }
    /**
     * <code>.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig object_detection_config = 7;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig.Builder
        getObjectDetectionConfigBuilder() {
      return getObjectDetectionConfigFieldBuilder().getBuilder();
    }
    /**
     * <code>.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig object_detection_config = 7;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfigOrBuilder
        getObjectDetectionConfigOrBuilder() {
      if ((humanAnnotationRequestConfigCase_ == 7) && (objectDetectionConfigBuilder_ != null)) {
        return objectDetectionConfigBuilder_.getMessageOrBuilder();
      } else {
        if (humanAnnotationRequestConfigCase_ == 7) {
          return (com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig)
              humanAnnotationRequestConfig_;
        }
        return com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig.getDefaultInstance();
      }
    }
    /**
     * <code>.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig object_detection_config = 7;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig,
            com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfigOrBuilder>
        getObjectDetectionConfigFieldBuilder() {
      if (objectDetectionConfigBuilder_ == null) {
        if (!(humanAnnotationRequestConfigCase_ == 7)) {
          humanAnnotationRequestConfig_ =
              com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig.getDefaultInstance();
        }
        objectDetectionConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig,
                com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig.Builder,
                com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfigOrBuilder>(
                (com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig)
                    humanAnnotationRequestConfig_,
                getParentForChildren(),
                isClean());
        humanAnnotationRequestConfig_ = null;
      }
      humanAnnotationRequestConfigCase_ = 7;
      onChanged();
      ;
      return objectDetectionConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.TextClassificationConfig,
            com.google.cloud.datalabeling.v1beta1.TextClassificationConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.TextClassificationConfigOrBuilder>
        textClassificationConfigBuilder_;
    /**
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextClassificationConfig text_classification_config = 8;
     * </code>
     */
    public boolean hasTextClassificationConfig() {
      return humanAnnotationRequestConfigCase_ == 8;
    }
    /**
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextClassificationConfig text_classification_config = 8;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.TextClassificationConfig
        getTextClassificationConfig() {
      if (textClassificationConfigBuilder_ == null) {
        if (humanAnnotationRequestConfigCase_ == 8) {
          return (com.google.cloud.datalabeling.v1beta1.TextClassificationConfig)
              humanAnnotationRequestConfig_;
        }
        return com.google.cloud.datalabeling.v1beta1.TextClassificationConfig.getDefaultInstance();
      } else {
        if (humanAnnotationRequestConfigCase_ == 8) {
          return textClassificationConfigBuilder_.getMessage();
        }
        return com.google.cloud.datalabeling.v1beta1.TextClassificationConfig.getDefaultInstance();
      }
    }
    /**
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextClassificationConfig text_classification_config = 8;
     * </code>
     */
    public Builder setTextClassificationConfig(
        com.google.cloud.datalabeling.v1beta1.TextClassificationConfig value) {
      if (textClassificationConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        humanAnnotationRequestConfig_ = value;
        onChanged();
      } else {
        textClassificationConfigBuilder_.setMessage(value);
      }
      humanAnnotationRequestConfigCase_ = 8;
      return this;
    }
    /**
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextClassificationConfig text_classification_config = 8;
     * </code>
     */
    public Builder setTextClassificationConfig(
        com.google.cloud.datalabeling.v1beta1.TextClassificationConfig.Builder builderForValue) {
      if (textClassificationConfigBuilder_ == null) {
        humanAnnotationRequestConfig_ = builderForValue.build();
        onChanged();
      } else {
        textClassificationConfigBuilder_.setMessage(builderForValue.build());
      }
      humanAnnotationRequestConfigCase_ = 8;
      return this;
    }
    /**
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextClassificationConfig text_classification_config = 8;
     * </code>
     */
    public Builder mergeTextClassificationConfig(
        com.google.cloud.datalabeling.v1beta1.TextClassificationConfig value) {
      if (textClassificationConfigBuilder_ == null) {
        if (humanAnnotationRequestConfigCase_ == 8
            && humanAnnotationRequestConfig_
                != com.google.cloud.datalabeling.v1beta1.TextClassificationConfig
                    .getDefaultInstance()) {
          humanAnnotationRequestConfig_ =
              com.google.cloud.datalabeling.v1beta1.TextClassificationConfig.newBuilder(
                      (com.google.cloud.datalabeling.v1beta1.TextClassificationConfig)
                          humanAnnotationRequestConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          humanAnnotationRequestConfig_ = value;
        }
        onChanged();
      } else {
        if (humanAnnotationRequestConfigCase_ == 8) {
          textClassificationConfigBuilder_.mergeFrom(value);
        }
        textClassificationConfigBuilder_.setMessage(value);
      }
      humanAnnotationRequestConfigCase_ = 8;
      return this;
    }
    /**
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextClassificationConfig text_classification_config = 8;
     * </code>
     */
    public Builder clearTextClassificationConfig() {
      if (textClassificationConfigBuilder_ == null) {
        if (humanAnnotationRequestConfigCase_ == 8) {
          humanAnnotationRequestConfigCase_ = 0;
          humanAnnotationRequestConfig_ = null;
          onChanged();
        }
      } else {
        if (humanAnnotationRequestConfigCase_ == 8) {
          humanAnnotationRequestConfigCase_ = 0;
          humanAnnotationRequestConfig_ = null;
        }
        textClassificationConfigBuilder_.clear();
      }
      return this;
    }
    /**
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextClassificationConfig text_classification_config = 8;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.TextClassificationConfig.Builder
        getTextClassificationConfigBuilder() {
      return getTextClassificationConfigFieldBuilder().getBuilder();
    }
    /**
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextClassificationConfig text_classification_config = 8;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.TextClassificationConfigOrBuilder
        getTextClassificationConfigOrBuilder() {
      if ((humanAnnotationRequestConfigCase_ == 8) && (textClassificationConfigBuilder_ != null)) {
        return textClassificationConfigBuilder_.getMessageOrBuilder();
      } else {
        if (humanAnnotationRequestConfigCase_ == 8) {
          return (com.google.cloud.datalabeling.v1beta1.TextClassificationConfig)
              humanAnnotationRequestConfig_;
        }
        return com.google.cloud.datalabeling.v1beta1.TextClassificationConfig.getDefaultInstance();
      }
    }
    /**
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextClassificationConfig text_classification_config = 8;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.TextClassificationConfig,
            com.google.cloud.datalabeling.v1beta1.TextClassificationConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.TextClassificationConfigOrBuilder>
        getTextClassificationConfigFieldBuilder() {
      if (textClassificationConfigBuilder_ == null) {
        if (!(humanAnnotationRequestConfigCase_ == 8)) {
          humanAnnotationRequestConfig_ =
              com.google.cloud.datalabeling.v1beta1.TextClassificationConfig.getDefaultInstance();
        }
        textClassificationConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.TextClassificationConfig,
                com.google.cloud.datalabeling.v1beta1.TextClassificationConfig.Builder,
                com.google.cloud.datalabeling.v1beta1.TextClassificationConfigOrBuilder>(
                (com.google.cloud.datalabeling.v1beta1.TextClassificationConfig)
                    humanAnnotationRequestConfig_,
                getParentForChildren(),
                isClean());
        humanAnnotationRequestConfig_ = null;
      }
      humanAnnotationRequestConfigCase_ = 8;
      onChanged();
      ;
      return textClassificationConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig,
            com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfigOrBuilder>
        objectTrackingConfigBuilder_;
    /**
     * <code>.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig object_tracking_config = 12;
     * </code>
     */
    public boolean hasObjectTrackingConfig() {
      return humanAnnotationRequestConfigCase_ == 12;
    }
    /**
     * <code>.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig object_tracking_config = 12;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig getObjectTrackingConfig() {
      if (objectTrackingConfigBuilder_ == null) {
        if (humanAnnotationRequestConfigCase_ == 12) {
          return (com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig)
              humanAnnotationRequestConfig_;
        }
        return com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig.getDefaultInstance();
      } else {
        if (humanAnnotationRequestConfigCase_ == 12) {
          return objectTrackingConfigBuilder_.getMessage();
        }
        return com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig.getDefaultInstance();
      }
    }
    /**
     * <code>.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig object_tracking_config = 12;
     * </code>
     */
    public Builder setObjectTrackingConfig(
        com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig value) {
      if (objectTrackingConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        humanAnnotationRequestConfig_ = value;
        onChanged();
      } else {
        objectTrackingConfigBuilder_.setMessage(value);
      }
      humanAnnotationRequestConfigCase_ = 12;
      return this;
    }
    /**
     * <code>.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig object_tracking_config = 12;
     * </code>
     */
    public Builder setObjectTrackingConfig(
        com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig.Builder builderForValue) {
      if (objectTrackingConfigBuilder_ == null) {
        humanAnnotationRequestConfig_ = builderForValue.build();
        onChanged();
      } else {
        objectTrackingConfigBuilder_.setMessage(builderForValue.build());
      }
      humanAnnotationRequestConfigCase_ = 12;
      return this;
    }
    /**
     * <code>.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig object_tracking_config = 12;
     * </code>
     */
    public Builder mergeObjectTrackingConfig(
        com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig value) {
      if (objectTrackingConfigBuilder_ == null) {
        if (humanAnnotationRequestConfigCase_ == 12
            && humanAnnotationRequestConfig_
                != com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig
                    .getDefaultInstance()) {
          humanAnnotationRequestConfig_ =
              com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig.newBuilder(
                      (com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig)
                          humanAnnotationRequestConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          humanAnnotationRequestConfig_ = value;
        }
        onChanged();
      } else {
        if (humanAnnotationRequestConfigCase_ == 12) {
          objectTrackingConfigBuilder_.mergeFrom(value);
        }
        objectTrackingConfigBuilder_.setMessage(value);
      }
      humanAnnotationRequestConfigCase_ = 12;
      return this;
    }
    /**
     * <code>.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig object_tracking_config = 12;
     * </code>
     */
    public Builder clearObjectTrackingConfig() {
      if (objectTrackingConfigBuilder_ == null) {
        if (humanAnnotationRequestConfigCase_ == 12) {
          humanAnnotationRequestConfigCase_ = 0;
          humanAnnotationRequestConfig_ = null;
          onChanged();
        }
      } else {
        if (humanAnnotationRequestConfigCase_ == 12) {
          humanAnnotationRequestConfigCase_ = 0;
          humanAnnotationRequestConfig_ = null;
        }
        objectTrackingConfigBuilder_.clear();
      }
      return this;
    }
    /**
     * <code>.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig object_tracking_config = 12;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig.Builder
        getObjectTrackingConfigBuilder() {
      return getObjectTrackingConfigFieldBuilder().getBuilder();
    }
    /**
     * <code>.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig object_tracking_config = 12;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfigOrBuilder
        getObjectTrackingConfigOrBuilder() {
      if ((humanAnnotationRequestConfigCase_ == 12) && (objectTrackingConfigBuilder_ != null)) {
        return objectTrackingConfigBuilder_.getMessageOrBuilder();
      } else {
        if (humanAnnotationRequestConfigCase_ == 12) {
          return (com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig)
              humanAnnotationRequestConfig_;
        }
        return com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig.getDefaultInstance();
      }
    }
    /**
     * <code>.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig object_tracking_config = 12;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig,
            com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfigOrBuilder>
        getObjectTrackingConfigFieldBuilder() {
      if (objectTrackingConfigBuilder_ == null) {
        if (!(humanAnnotationRequestConfigCase_ == 12)) {
          humanAnnotationRequestConfig_ =
              com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig.getDefaultInstance();
        }
        objectTrackingConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig,
                com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig.Builder,
                com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfigOrBuilder>(
                (com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig)
                    humanAnnotationRequestConfig_,
                getParentForChildren(),
                isClean());
        humanAnnotationRequestConfig_ = null;
      }
      humanAnnotationRequestConfigCase_ = 12;
      onChanged();
      ;
      return objectTrackingConfigBuilder_;
    }

    private com.google.cloud.datalabeling.v1beta1.InputConfig inputConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.InputConfig,
            com.google.cloud.datalabeling.v1beta1.InputConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.InputConfigOrBuilder>
        inputConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Input config for data, gcs_source in the config will be the root path for
     * data. Data should be organzied chronically under that path.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.InputConfig input_config = 1;</code>
     */
    public boolean hasInputConfig() {
      return inputConfigBuilder_ != null || inputConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Input config for data, gcs_source in the config will be the root path for
     * data. Data should be organzied chronically under that path.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.InputConfig input_config = 1;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.InputConfig getInputConfig() {
      if (inputConfigBuilder_ == null) {
        return inputConfig_ == null
            ? com.google.cloud.datalabeling.v1beta1.InputConfig.getDefaultInstance()
            : inputConfig_;
      } else {
        return inputConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Input config for data, gcs_source in the config will be the root path for
     * data. Data should be organzied chronically under that path.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.InputConfig input_config = 1;</code>
     */
    public Builder setInputConfig(com.google.cloud.datalabeling.v1beta1.InputConfig value) {
      if (inputConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        inputConfig_ = value;
        onChanged();
      } else {
        inputConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Input config for data, gcs_source in the config will be the root path for
     * data. Data should be organzied chronically under that path.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.InputConfig input_config = 1;</code>
     */
    public Builder setInputConfig(
        com.google.cloud.datalabeling.v1beta1.InputConfig.Builder builderForValue) {
      if (inputConfigBuilder_ == null) {
        inputConfig_ = builderForValue.build();
        onChanged();
      } else {
        inputConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Input config for data, gcs_source in the config will be the root path for
     * data. Data should be organzied chronically under that path.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.InputConfig input_config = 1;</code>
     */
    public Builder mergeInputConfig(com.google.cloud.datalabeling.v1beta1.InputConfig value) {
      if (inputConfigBuilder_ == null) {
        if (inputConfig_ != null) {
          inputConfig_ =
              com.google.cloud.datalabeling.v1beta1.InputConfig.newBuilder(inputConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          inputConfig_ = value;
        }
        onChanged();
      } else {
        inputConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Input config for data, gcs_source in the config will be the root path for
     * data. Data should be organzied chronically under that path.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.InputConfig input_config = 1;</code>
     */
    public Builder clearInputConfig() {
      if (inputConfigBuilder_ == null) {
        inputConfig_ = null;
        onChanged();
      } else {
        inputConfig_ = null;
        inputConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Input config for data, gcs_source in the config will be the root path for
     * data. Data should be organzied chronically under that path.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.InputConfig input_config = 1;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.InputConfig.Builder getInputConfigBuilder() {

      onChanged();
      return getInputConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Input config for data, gcs_source in the config will be the root path for
     * data. Data should be organzied chronically under that path.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.InputConfig input_config = 1;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.InputConfigOrBuilder getInputConfigOrBuilder() {
      if (inputConfigBuilder_ != null) {
        return inputConfigBuilder_.getMessageOrBuilder();
      } else {
        return inputConfig_ == null
            ? com.google.cloud.datalabeling.v1beta1.InputConfig.getDefaultInstance()
            : inputConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Input config for data, gcs_source in the config will be the root path for
     * data. Data should be organzied chronically under that path.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.InputConfig input_config = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.InputConfig,
            com.google.cloud.datalabeling.v1beta1.InputConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.InputConfigOrBuilder>
        getInputConfigFieldBuilder() {
      if (inputConfigBuilder_ == null) {
        inputConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.InputConfig,
                com.google.cloud.datalabeling.v1beta1.InputConfig.Builder,
                com.google.cloud.datalabeling.v1beta1.InputConfigOrBuilder>(
                getInputConfig(), getParentForChildren(), isClean());
        inputConfig_ = null;
      }
      return inputConfigBuilder_;
    }

    private com.google.cloud.datalabeling.v1beta1.EvaluationConfig evaluationConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.EvaluationConfig,
            com.google.cloud.datalabeling.v1beta1.EvaluationConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.EvaluationConfigOrBuilder>
        evaluationConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Config used to create evaluation.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EvaluationConfig evaluation_config = 2;</code>
     */
    public boolean hasEvaluationConfig() {
      return evaluationConfigBuilder_ != null || evaluationConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Config used to create evaluation.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EvaluationConfig evaluation_config = 2;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.EvaluationConfig getEvaluationConfig() {
      if (evaluationConfigBuilder_ == null) {
        return evaluationConfig_ == null
            ? com.google.cloud.datalabeling.v1beta1.EvaluationConfig.getDefaultInstance()
            : evaluationConfig_;
      } else {
        return evaluationConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Config used to create evaluation.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EvaluationConfig evaluation_config = 2;</code>
     */
    public Builder setEvaluationConfig(
        com.google.cloud.datalabeling.v1beta1.EvaluationConfig value) {
      if (evaluationConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        evaluationConfig_ = value;
        onChanged();
      } else {
        evaluationConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Config used to create evaluation.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EvaluationConfig evaluation_config = 2;</code>
     */
    public Builder setEvaluationConfig(
        com.google.cloud.datalabeling.v1beta1.EvaluationConfig.Builder builderForValue) {
      if (evaluationConfigBuilder_ == null) {
        evaluationConfig_ = builderForValue.build();
        onChanged();
      } else {
        evaluationConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Config used to create evaluation.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EvaluationConfig evaluation_config = 2;</code>
     */
    public Builder mergeEvaluationConfig(
        com.google.cloud.datalabeling.v1beta1.EvaluationConfig value) {
      if (evaluationConfigBuilder_ == null) {
        if (evaluationConfig_ != null) {
          evaluationConfig_ =
              com.google.cloud.datalabeling.v1beta1.EvaluationConfig.newBuilder(evaluationConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          evaluationConfig_ = value;
        }
        onChanged();
      } else {
        evaluationConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Config used to create evaluation.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EvaluationConfig evaluation_config = 2;</code>
     */
    public Builder clearEvaluationConfig() {
      if (evaluationConfigBuilder_ == null) {
        evaluationConfig_ = null;
        onChanged();
      } else {
        evaluationConfig_ = null;
        evaluationConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Config used to create evaluation.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EvaluationConfig evaluation_config = 2;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.EvaluationConfig.Builder
        getEvaluationConfigBuilder() {

      onChanged();
      return getEvaluationConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Config used to create evaluation.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EvaluationConfig evaluation_config = 2;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.EvaluationConfigOrBuilder
        getEvaluationConfigOrBuilder() {
      if (evaluationConfigBuilder_ != null) {
        return evaluationConfigBuilder_.getMessageOrBuilder();
      } else {
        return evaluationConfig_ == null
            ? com.google.cloud.datalabeling.v1beta1.EvaluationConfig.getDefaultInstance()
            : evaluationConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Config used to create evaluation.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EvaluationConfig evaluation_config = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.EvaluationConfig,
            com.google.cloud.datalabeling.v1beta1.EvaluationConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.EvaluationConfigOrBuilder>
        getEvaluationConfigFieldBuilder() {
      if (evaluationConfigBuilder_ == null) {
        evaluationConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.EvaluationConfig,
                com.google.cloud.datalabeling.v1beta1.EvaluationConfig.Builder,
                com.google.cloud.datalabeling.v1beta1.EvaluationConfigOrBuilder>(
                getEvaluationConfig(), getParentForChildren(), isClean());
        evaluationConfig_ = null;
      }
      return evaluationConfigBuilder_;
    }

    private com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig humanAnnotationConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig,
            com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfigOrBuilder>
        humanAnnotationConfigBuilder_;
    /**
     * <code>.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig human_annotation_config = 3;
     * </code>
     */
    public boolean hasHumanAnnotationConfig() {
      return humanAnnotationConfigBuilder_ != null || humanAnnotationConfig_ != null;
    }
    /**
     * <code>.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig human_annotation_config = 3;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig getHumanAnnotationConfig() {
      if (humanAnnotationConfigBuilder_ == null) {
        return humanAnnotationConfig_ == null
            ? com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.getDefaultInstance()
            : humanAnnotationConfig_;
      } else {
        return humanAnnotationConfigBuilder_.getMessage();
      }
    }
    /**
     * <code>.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig human_annotation_config = 3;
     * </code>
     */
    public Builder setHumanAnnotationConfig(
        com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig value) {
      if (humanAnnotationConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        humanAnnotationConfig_ = value;
        onChanged();
      } else {
        humanAnnotationConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <code>.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig human_annotation_config = 3;
     * </code>
     */
    public Builder setHumanAnnotationConfig(
        com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.Builder builderForValue) {
      if (humanAnnotationConfigBuilder_ == null) {
        humanAnnotationConfig_ = builderForValue.build();
        onChanged();
      } else {
        humanAnnotationConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <code>.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig human_annotation_config = 3;
     * </code>
     */
    public Builder mergeHumanAnnotationConfig(
        com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig value) {
      if (humanAnnotationConfigBuilder_ == null) {
        if (humanAnnotationConfig_ != null) {
          humanAnnotationConfig_ =
              com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.newBuilder(
                      humanAnnotationConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          humanAnnotationConfig_ = value;
        }
        onChanged();
      } else {
        humanAnnotationConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <code>.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig human_annotation_config = 3;
     * </code>
     */
    public Builder clearHumanAnnotationConfig() {
      if (humanAnnotationConfigBuilder_ == null) {
        humanAnnotationConfig_ = null;
        onChanged();
      } else {
        humanAnnotationConfig_ = null;
        humanAnnotationConfigBuilder_ = null;
      }

      return this;
    }
    /**
     * <code>.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig human_annotation_config = 3;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.Builder
        getHumanAnnotationConfigBuilder() {

      onChanged();
      return getHumanAnnotationConfigFieldBuilder().getBuilder();
    }
    /**
     * <code>.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig human_annotation_config = 3;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfigOrBuilder
        getHumanAnnotationConfigOrBuilder() {
      if (humanAnnotationConfigBuilder_ != null) {
        return humanAnnotationConfigBuilder_.getMessageOrBuilder();
      } else {
        return humanAnnotationConfig_ == null
            ? com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.getDefaultInstance()
            : humanAnnotationConfig_;
      }
    }
    /**
     * <code>.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig human_annotation_config = 3;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig,
            com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfigOrBuilder>
        getHumanAnnotationConfigFieldBuilder() {
      if (humanAnnotationConfigBuilder_ == null) {
        humanAnnotationConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig,
                com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.Builder,
                com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfigOrBuilder>(
                getHumanAnnotationConfig(), getParentForChildren(), isClean());
        humanAnnotationConfig_ = null;
      }
      return humanAnnotationConfigBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> bigqueryImportKeys_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetBigqueryImportKeys() {
      if (bigqueryImportKeys_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            BigqueryImportKeysDefaultEntryHolder.defaultEntry);
      }
      return bigqueryImportKeys_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableBigqueryImportKeys() {
      onChanged();
      ;
      if (bigqueryImportKeys_ == null) {
        bigqueryImportKeys_ =
            com.google.protobuf.MapField.newMapField(
                BigqueryImportKeysDefaultEntryHolder.defaultEntry);
      }
      if (!bigqueryImportKeys_.isMutable()) {
        bigqueryImportKeys_ = bigqueryImportKeys_.copy();
      }
      return bigqueryImportKeys_;
    }

    public int getBigqueryImportKeysCount() {
      return internalGetBigqueryImportKeys().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Mappings between reserved keys for bigquery import and customized tensor
     * names. Key is the reserved key, value is tensor name in the bigquery table.
     * Different annotation type has different required key mapping. See user
     * manual for more details:
     * https:
     * //docs.google.com/document/d/1bg1meMIBGY
     * // 9I5QEoFoHSX6u9LsZQYBSmPt6E9SxqHZc/edit#heading=h.tfyjhxhvsqem
     * </pre>
     *
     * <code>map&lt;string, string&gt; bigquery_import_keys = 9;</code>
     */
    public boolean containsBigqueryImportKeys(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      return internalGetBigqueryImportKeys().getMap().containsKey(key);
    }
    /** Use {@link #getBigqueryImportKeysMap()} instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getBigqueryImportKeys() {
      return getBigqueryImportKeysMap();
    }
    /**
     *
     *
     * <pre>
     * Mappings between reserved keys for bigquery import and customized tensor
     * names. Key is the reserved key, value is tensor name in the bigquery table.
     * Different annotation type has different required key mapping. See user
     * manual for more details:
     * https:
     * //docs.google.com/document/d/1bg1meMIBGY
     * // 9I5QEoFoHSX6u9LsZQYBSmPt6E9SxqHZc/edit#heading=h.tfyjhxhvsqem
     * </pre>
     *
     * <code>map&lt;string, string&gt; bigquery_import_keys = 9;</code>
     */
    public java.util.Map<java.lang.String, java.lang.String> getBigqueryImportKeysMap() {
      return internalGetBigqueryImportKeys().getMap();
    }
    /**
     *
     *
     * <pre>
     * Mappings between reserved keys for bigquery import and customized tensor
     * names. Key is the reserved key, value is tensor name in the bigquery table.
     * Different annotation type has different required key mapping. See user
     * manual for more details:
     * https:
     * //docs.google.com/document/d/1bg1meMIBGY
     * // 9I5QEoFoHSX6u9LsZQYBSmPt6E9SxqHZc/edit#heading=h.tfyjhxhvsqem
     * </pre>
     *
     * <code>map&lt;string, string&gt; bigquery_import_keys = 9;</code>
     */
    public java.lang.String getBigqueryImportKeysOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetBigqueryImportKeys().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Mappings between reserved keys for bigquery import and customized tensor
     * names. Key is the reserved key, value is tensor name in the bigquery table.
     * Different annotation type has different required key mapping. See user
     * manual for more details:
     * https:
     * //docs.google.com/document/d/1bg1meMIBGY
     * // 9I5QEoFoHSX6u9LsZQYBSmPt6E9SxqHZc/edit#heading=h.tfyjhxhvsqem
     * </pre>
     *
     * <code>map&lt;string, string&gt; bigquery_import_keys = 9;</code>
     */
    public java.lang.String getBigqueryImportKeysOrThrow(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetBigqueryImportKeys().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearBigqueryImportKeys() {
      internalGetMutableBigqueryImportKeys().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Mappings between reserved keys for bigquery import and customized tensor
     * names. Key is the reserved key, value is tensor name in the bigquery table.
     * Different annotation type has different required key mapping. See user
     * manual for more details:
     * https:
     * //docs.google.com/document/d/1bg1meMIBGY
     * // 9I5QEoFoHSX6u9LsZQYBSmPt6E9SxqHZc/edit#heading=h.tfyjhxhvsqem
     * </pre>
     *
     * <code>map&lt;string, string&gt; bigquery_import_keys = 9;</code>
     */
    public Builder removeBigqueryImportKeys(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableBigqueryImportKeys().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableBigqueryImportKeys() {
      return internalGetMutableBigqueryImportKeys().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Mappings between reserved keys for bigquery import and customized tensor
     * names. Key is the reserved key, value is tensor name in the bigquery table.
     * Different annotation type has different required key mapping. See user
     * manual for more details:
     * https:
     * //docs.google.com/document/d/1bg1meMIBGY
     * // 9I5QEoFoHSX6u9LsZQYBSmPt6E9SxqHZc/edit#heading=h.tfyjhxhvsqem
     * </pre>
     *
     * <code>map&lt;string, string&gt; bigquery_import_keys = 9;</code>
     */
    public Builder putBigqueryImportKeys(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      if (value == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableBigqueryImportKeys().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * Mappings between reserved keys for bigquery import and customized tensor
     * names. Key is the reserved key, value is tensor name in the bigquery table.
     * Different annotation type has different required key mapping. See user
     * manual for more details:
     * https:
     * //docs.google.com/document/d/1bg1meMIBGY
     * // 9I5QEoFoHSX6u9LsZQYBSmPt6E9SxqHZc/edit#heading=h.tfyjhxhvsqem
     * </pre>
     *
     * <code>map&lt;string, string&gt; bigquery_import_keys = 9;</code>
     */
    public Builder putAllBigqueryImportKeys(
        java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableBigqueryImportKeys().getMutableMap().putAll(values);
      return this;
    }

    private int exampleCount_;
    /**
     *
     *
     * <pre>
     * Max number of examples to collect in each period.
     * </pre>
     *
     * <code>int32 example_count = 10;</code>
     */
    public int getExampleCount() {
      return exampleCount_;
    }
    /**
     *
     *
     * <pre>
     * Max number of examples to collect in each period.
     * </pre>
     *
     * <code>int32 example_count = 10;</code>
     */
    public Builder setExampleCount(int value) {

      exampleCount_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Max number of examples to collect in each period.
     * </pre>
     *
     * <code>int32 example_count = 10;</code>
     */
    public Builder clearExampleCount() {

      exampleCount_ = 0;
      onChanged();
      return this;
    }

    private double exampleSamplePercentage_;
    /**
     *
     *
     * <pre>
     * Percentage of examples to collect in each period. 0.1 means 10% of total
     * examples will be collected, and 0.0 means no collection.
     * </pre>
     *
     * <code>double example_sample_percentage = 11;</code>
     */
    public double getExampleSamplePercentage() {
      return exampleSamplePercentage_;
    }
    /**
     *
     *
     * <pre>
     * Percentage of examples to collect in each period. 0.1 means 10% of total
     * examples will be collected, and 0.0 means no collection.
     * </pre>
     *
     * <code>double example_sample_percentage = 11;</code>
     */
    public Builder setExampleSamplePercentage(double value) {

      exampleSamplePercentage_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Percentage of examples to collect in each period. 0.1 means 10% of total
     * examples will be collected, and 0.0 means no collection.
     * </pre>
     *
     * <code>double example_sample_percentage = 11;</code>
     */
    public Builder clearExampleSamplePercentage() {

      exampleSamplePercentage_ = 0D;
      onChanged();
      return this;
    }

    private com.google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig
        evaluationJobAlertConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig,
            com.google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfigOrBuilder>
        evaluationJobAlertConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Alert config for the evaluation job. The alert will be triggered when its
     * criteria is met.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig evaluation_job_alert_config = 13;
     * </code>
     */
    public boolean hasEvaluationJobAlertConfig() {
      return evaluationJobAlertConfigBuilder_ != null || evaluationJobAlertConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Alert config for the evaluation job. The alert will be triggered when its
     * criteria is met.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig evaluation_job_alert_config = 13;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig
        getEvaluationJobAlertConfig() {
      if (evaluationJobAlertConfigBuilder_ == null) {
        return evaluationJobAlertConfig_ == null
            ? com.google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig.getDefaultInstance()
            : evaluationJobAlertConfig_;
      } else {
        return evaluationJobAlertConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Alert config for the evaluation job. The alert will be triggered when its
     * criteria is met.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig evaluation_job_alert_config = 13;
     * </code>
     */
    public Builder setEvaluationJobAlertConfig(
        com.google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig value) {
      if (evaluationJobAlertConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        evaluationJobAlertConfig_ = value;
        onChanged();
      } else {
        evaluationJobAlertConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Alert config for the evaluation job. The alert will be triggered when its
     * criteria is met.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig evaluation_job_alert_config = 13;
     * </code>
     */
    public Builder setEvaluationJobAlertConfig(
        com.google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig.Builder builderForValue) {
      if (evaluationJobAlertConfigBuilder_ == null) {
        evaluationJobAlertConfig_ = builderForValue.build();
        onChanged();
      } else {
        evaluationJobAlertConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Alert config for the evaluation job. The alert will be triggered when its
     * criteria is met.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig evaluation_job_alert_config = 13;
     * </code>
     */
    public Builder mergeEvaluationJobAlertConfig(
        com.google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig value) {
      if (evaluationJobAlertConfigBuilder_ == null) {
        if (evaluationJobAlertConfig_ != null) {
          evaluationJobAlertConfig_ =
              com.google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig.newBuilder(
                      evaluationJobAlertConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          evaluationJobAlertConfig_ = value;
        }
        onChanged();
      } else {
        evaluationJobAlertConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Alert config for the evaluation job. The alert will be triggered when its
     * criteria is met.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig evaluation_job_alert_config = 13;
     * </code>
     */
    public Builder clearEvaluationJobAlertConfig() {
      if (evaluationJobAlertConfigBuilder_ == null) {
        evaluationJobAlertConfig_ = null;
        onChanged();
      } else {
        evaluationJobAlertConfig_ = null;
        evaluationJobAlertConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Alert config for the evaluation job. The alert will be triggered when its
     * criteria is met.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig evaluation_job_alert_config = 13;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig.Builder
        getEvaluationJobAlertConfigBuilder() {

      onChanged();
      return getEvaluationJobAlertConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Alert config for the evaluation job. The alert will be triggered when its
     * criteria is met.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig evaluation_job_alert_config = 13;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfigOrBuilder
        getEvaluationJobAlertConfigOrBuilder() {
      if (evaluationJobAlertConfigBuilder_ != null) {
        return evaluationJobAlertConfigBuilder_.getMessageOrBuilder();
      } else {
        return evaluationJobAlertConfig_ == null
            ? com.google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig.getDefaultInstance()
            : evaluationJobAlertConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Alert config for the evaluation job. The alert will be triggered when its
     * criteria is met.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig evaluation_job_alert_config = 13;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig,
            com.google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfigOrBuilder>
        getEvaluationJobAlertConfigFieldBuilder() {
      if (evaluationJobAlertConfigBuilder_ == null) {
        evaluationJobAlertConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig,
                com.google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfig.Builder,
                com.google.cloud.datalabeling.v1beta1.EvaluationJobAlertConfigOrBuilder>(
                getEvaluationJobAlertConfig(), getParentForChildren(), isClean());
        evaluationJobAlertConfig_ = null;
      }
      return evaluationJobAlertConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datalabeling.v1beta1.EvaluationJobConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datalabeling.v1beta1.EvaluationJobConfig)
  private static final com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig();
  }

  public static com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<EvaluationJobConfig> PARSER =
      new com.google.protobuf.AbstractParser<EvaluationJobConfig>() {
        @java.lang.Override
        public EvaluationJobConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new EvaluationJobConfig(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<EvaluationJobConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<EvaluationJobConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
