/*
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datalabeling/v1beta1/data_labeling_service.proto

package com.google.cloud.datalabeling.v1beta1;

/**
 *
 *
 * <pre>
 * Request message for LabelText.
 * </pre>
 *
 * Protobuf type {@code google.cloud.datalabeling.v1beta1.LabelTextRequest}
 */
public final class LabelTextRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datalabeling.v1beta1.LabelTextRequest)
    LabelTextRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use LabelTextRequest.newBuilder() to construct.
  private LabelTextRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private LabelTextRequest() {
    parent_ = "";
    feature_ = 0;
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private LabelTextRequest(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              parent_ = s;
              break;
            }
          case 18:
            {
              com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.Builder subBuilder = null;
              if (basicConfig_ != null) {
                subBuilder = basicConfig_.toBuilder();
              }
              basicConfig_ =
                  input.readMessage(
                      com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(basicConfig_);
                basicConfig_ = subBuilder.buildPartial();
              }

              break;
            }
          case 34:
            {
              com.google.cloud.datalabeling.v1beta1.TextClassificationConfig.Builder subBuilder =
                  null;
              if (requestConfigCase_ == 4) {
                subBuilder =
                    ((com.google.cloud.datalabeling.v1beta1.TextClassificationConfig)
                            requestConfig_)
                        .toBuilder();
              }
              requestConfig_ =
                  input.readMessage(
                      com.google.cloud.datalabeling.v1beta1.TextClassificationConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.datalabeling.v1beta1.TextClassificationConfig)
                        requestConfig_);
                requestConfig_ = subBuilder.buildPartial();
              }
              requestConfigCase_ = 4;
              break;
            }
          case 42:
            {
              com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig.Builder subBuilder =
                  null;
              if (requestConfigCase_ == 5) {
                subBuilder =
                    ((com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig)
                            requestConfig_)
                        .toBuilder();
              }
              requestConfig_ =
                  input.readMessage(
                      com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig)
                        requestConfig_);
                requestConfig_ = subBuilder.buildPartial();
              }
              requestConfigCase_ = 5;
              break;
            }
          case 48:
            {
              int rawValue = input.readEnum();

              feature_ = rawValue;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datalabeling.v1beta1.DataLabelingServiceOuterClass
        .internal_static_google_cloud_datalabeling_v1beta1_LabelTextRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datalabeling.v1beta1.DataLabelingServiceOuterClass
        .internal_static_google_cloud_datalabeling_v1beta1_LabelTextRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datalabeling.v1beta1.LabelTextRequest.class,
            com.google.cloud.datalabeling.v1beta1.LabelTextRequest.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Text labeling task feature.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.datalabeling.v1beta1.LabelTextRequest.Feature}
   */
  public enum Feature implements com.google.protobuf.ProtocolMessageEnum {
    /** <code>FEATURE_UNSPECIFIED = 0;</code> */
    FEATURE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Label text content to one of more labels.
     * </pre>
     *
     * <code>TEXT_CLASSIFICATION = 1;</code>
     */
    TEXT_CLASSIFICATION(1),
    /**
     *
     *
     * <pre>
     * Label entities and their span in text.
     * </pre>
     *
     * <code>TEXT_ENTITY_EXTRACTION = 2;</code>
     */
    TEXT_ENTITY_EXTRACTION(2),
    UNRECOGNIZED(-1),
    ;

    /** <code>FEATURE_UNSPECIFIED = 0;</code> */
    public static final int FEATURE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Label text content to one of more labels.
     * </pre>
     *
     * <code>TEXT_CLASSIFICATION = 1;</code>
     */
    public static final int TEXT_CLASSIFICATION_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Label entities and their span in text.
     * </pre>
     *
     * <code>TEXT_ENTITY_EXTRACTION = 2;</code>
     */
    public static final int TEXT_ENTITY_EXTRACTION_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /** @deprecated Use {@link #forNumber(int)} instead. */
    @java.lang.Deprecated
    public static Feature valueOf(int value) {
      return forNumber(value);
    }

    public static Feature forNumber(int value) {
      switch (value) {
        case 0:
          return FEATURE_UNSPECIFIED;
        case 1:
          return TEXT_CLASSIFICATION;
        case 2:
          return TEXT_ENTITY_EXTRACTION;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Feature> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Feature> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Feature>() {
          public Feature findValueByNumber(int number) {
            return Feature.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.datalabeling.v1beta1.LabelTextRequest.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final Feature[] VALUES = values();

    public static Feature valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Feature(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.datalabeling.v1beta1.LabelTextRequest.Feature)
  }

  private int requestConfigCase_ = 0;
  private java.lang.Object requestConfig_;

  public enum RequestConfigCase implements com.google.protobuf.Internal.EnumLite {
    TEXT_CLASSIFICATION_CONFIG(4),
    TEXT_ENTITY_EXTRACTION_CONFIG(5),
    REQUESTCONFIG_NOT_SET(0);
    private final int value;

    private RequestConfigCase(int value) {
      this.value = value;
    }
    /** @deprecated Use {@link #forNumber(int)} instead. */
    @java.lang.Deprecated
    public static RequestConfigCase valueOf(int value) {
      return forNumber(value);
    }

    public static RequestConfigCase forNumber(int value) {
      switch (value) {
        case 4:
          return TEXT_CLASSIFICATION_CONFIG;
        case 5:
          return TEXT_ENTITY_EXTRACTION_CONFIG;
        case 0:
          return REQUESTCONFIG_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public RequestConfigCase getRequestConfigCase() {
    return RequestConfigCase.forNumber(requestConfigCase_);
  }

  public static final int TEXT_CLASSIFICATION_CONFIG_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Configuration for text classification task.
   * One of text_classification_config and text_entity_extraction_config
   * is required.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.TextClassificationConfig text_classification_config = 4;
   * </code>
   */
  public boolean hasTextClassificationConfig() {
    return requestConfigCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Configuration for text classification task.
   * One of text_classification_config and text_entity_extraction_config
   * is required.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.TextClassificationConfig text_classification_config = 4;
   * </code>
   */
  public com.google.cloud.datalabeling.v1beta1.TextClassificationConfig
      getTextClassificationConfig() {
    if (requestConfigCase_ == 4) {
      return (com.google.cloud.datalabeling.v1beta1.TextClassificationConfig) requestConfig_;
    }
    return com.google.cloud.datalabeling.v1beta1.TextClassificationConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Configuration for text classification task.
   * One of text_classification_config and text_entity_extraction_config
   * is required.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.TextClassificationConfig text_classification_config = 4;
   * </code>
   */
  public com.google.cloud.datalabeling.v1beta1.TextClassificationConfigOrBuilder
      getTextClassificationConfigOrBuilder() {
    if (requestConfigCase_ == 4) {
      return (com.google.cloud.datalabeling.v1beta1.TextClassificationConfig) requestConfig_;
    }
    return com.google.cloud.datalabeling.v1beta1.TextClassificationConfig.getDefaultInstance();
  }

  public static final int TEXT_ENTITY_EXTRACTION_CONFIG_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Configuration for entity extraction task.
   * One of text_classification_config and text_entity_extraction_config
   * is required.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig text_entity_extraction_config = 5;
   * </code>
   */
  public boolean hasTextEntityExtractionConfig() {
    return requestConfigCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Configuration for entity extraction task.
   * One of text_classification_config and text_entity_extraction_config
   * is required.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig text_entity_extraction_config = 5;
   * </code>
   */
  public com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig
      getTextEntityExtractionConfig() {
    if (requestConfigCase_ == 5) {
      return (com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig) requestConfig_;
    }
    return com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Configuration for entity extraction task.
   * One of text_classification_config and text_entity_extraction_config
   * is required.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig text_entity_extraction_config = 5;
   * </code>
   */
  public com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfigOrBuilder
      getTextEntityExtractionConfigOrBuilder() {
    if (requestConfigCase_ == 5) {
      return (com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig) requestConfig_;
    }
    return com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig.getDefaultInstance();
  }

  public static final int PARENT_FIELD_NUMBER = 1;
  private volatile java.lang.Object parent_;
  /**
   *
   *
   * <pre>
   * Required. Name of the data set to request labeling task, format:
   * projects/{project_id}/datasets/{dataset_id}
   * </pre>
   *
   * <code>string parent = 1;</code>
   */
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Name of the data set to request labeling task, format:
   * projects/{project_id}/datasets/{dataset_id}
   * </pre>
   *
   * <code>string parent = 1;</code>
   */
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BASIC_CONFIG_FIELD_NUMBER = 2;
  private com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig basicConfig_;
  /**
   *
   *
   * <pre>
   * Required. Basic human annotation config.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig basic_config = 2;</code>
   */
  public boolean hasBasicConfig() {
    return basicConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. Basic human annotation config.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig basic_config = 2;</code>
   */
  public com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig getBasicConfig() {
    return basicConfig_ == null
        ? com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.getDefaultInstance()
        : basicConfig_;
  }
  /**
   *
   *
   * <pre>
   * Required. Basic human annotation config.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig basic_config = 2;</code>
   */
  public com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfigOrBuilder
      getBasicConfigOrBuilder() {
    return getBasicConfig();
  }

  public static final int FEATURE_FIELD_NUMBER = 6;
  private int feature_;
  /**
   *
   *
   * <pre>
   * Required. The type of text labeling task.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.LabelTextRequest.Feature feature = 6;</code>
   */
  public int getFeatureValue() {
    return feature_;
  }
  /**
   *
   *
   * <pre>
   * Required. The type of text labeling task.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.LabelTextRequest.Feature feature = 6;</code>
   */
  public com.google.cloud.datalabeling.v1beta1.LabelTextRequest.Feature getFeature() {
    @SuppressWarnings("deprecation")
    com.google.cloud.datalabeling.v1beta1.LabelTextRequest.Feature result =
        com.google.cloud.datalabeling.v1beta1.LabelTextRequest.Feature.valueOf(feature_);
    return result == null
        ? com.google.cloud.datalabeling.v1beta1.LabelTextRequest.Feature.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getParentBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (basicConfig_ != null) {
      output.writeMessage(2, getBasicConfig());
    }
    if (requestConfigCase_ == 4) {
      output.writeMessage(
          4, (com.google.cloud.datalabeling.v1beta1.TextClassificationConfig) requestConfig_);
    }
    if (requestConfigCase_ == 5) {
      output.writeMessage(
          5, (com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig) requestConfig_);
    }
    if (feature_
        != com.google.cloud.datalabeling.v1beta1.LabelTextRequest.Feature.FEATURE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(6, feature_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getParentBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (basicConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getBasicConfig());
    }
    if (requestConfigCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.datalabeling.v1beta1.TextClassificationConfig) requestConfig_);
    }
    if (requestConfigCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig) requestConfig_);
    }
    if (feature_
        != com.google.cloud.datalabeling.v1beta1.LabelTextRequest.Feature.FEATURE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, feature_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datalabeling.v1beta1.LabelTextRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.datalabeling.v1beta1.LabelTextRequest other =
        (com.google.cloud.datalabeling.v1beta1.LabelTextRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (hasBasicConfig() != other.hasBasicConfig()) return false;
    if (hasBasicConfig()) {
      if (!getBasicConfig().equals(other.getBasicConfig())) return false;
    }
    if (feature_ != other.feature_) return false;
    if (!getRequestConfigCase().equals(other.getRequestConfigCase())) return false;
    switch (requestConfigCase_) {
      case 4:
        if (!getTextClassificationConfig().equals(other.getTextClassificationConfig()))
          return false;
        break;
      case 5:
        if (!getTextEntityExtractionConfig().equals(other.getTextEntityExtractionConfig()))
          return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    if (hasBasicConfig()) {
      hash = (37 * hash) + BASIC_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getBasicConfig().hashCode();
    }
    hash = (37 * hash) + FEATURE_FIELD_NUMBER;
    hash = (53 * hash) + feature_;
    switch (requestConfigCase_) {
      case 4:
        hash = (37 * hash) + TEXT_CLASSIFICATION_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getTextClassificationConfig().hashCode();
        break;
      case 5:
        hash = (37 * hash) + TEXT_ENTITY_EXTRACTION_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getTextEntityExtractionConfig().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datalabeling.v1beta1.LabelTextRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.LabelTextRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.LabelTextRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.LabelTextRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.LabelTextRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.LabelTextRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.LabelTextRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.LabelTextRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.LabelTextRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.LabelTextRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.LabelTextRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.LabelTextRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.datalabeling.v1beta1.LabelTextRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for LabelText.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datalabeling.v1beta1.LabelTextRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datalabeling.v1beta1.LabelTextRequest)
      com.google.cloud.datalabeling.v1beta1.LabelTextRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datalabeling.v1beta1.DataLabelingServiceOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_LabelTextRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datalabeling.v1beta1.DataLabelingServiceOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_LabelTextRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datalabeling.v1beta1.LabelTextRequest.class,
              com.google.cloud.datalabeling.v1beta1.LabelTextRequest.Builder.class);
    }

    // Construct using com.google.cloud.datalabeling.v1beta1.LabelTextRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      parent_ = "";

      if (basicConfigBuilder_ == null) {
        basicConfig_ = null;
      } else {
        basicConfig_ = null;
        basicConfigBuilder_ = null;
      }
      feature_ = 0;

      requestConfigCase_ = 0;
      requestConfig_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datalabeling.v1beta1.DataLabelingServiceOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_LabelTextRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.LabelTextRequest getDefaultInstanceForType() {
      return com.google.cloud.datalabeling.v1beta1.LabelTextRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.LabelTextRequest build() {
      com.google.cloud.datalabeling.v1beta1.LabelTextRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.LabelTextRequest buildPartial() {
      com.google.cloud.datalabeling.v1beta1.LabelTextRequest result =
          new com.google.cloud.datalabeling.v1beta1.LabelTextRequest(this);
      if (requestConfigCase_ == 4) {
        if (textClassificationConfigBuilder_ == null) {
          result.requestConfig_ = requestConfig_;
        } else {
          result.requestConfig_ = textClassificationConfigBuilder_.build();
        }
      }
      if (requestConfigCase_ == 5) {
        if (textEntityExtractionConfigBuilder_ == null) {
          result.requestConfig_ = requestConfig_;
        } else {
          result.requestConfig_ = textEntityExtractionConfigBuilder_.build();
        }
      }
      result.parent_ = parent_;
      if (basicConfigBuilder_ == null) {
        result.basicConfig_ = basicConfig_;
      } else {
        result.basicConfig_ = basicConfigBuilder_.build();
      }
      result.feature_ = feature_;
      result.requestConfigCase_ = requestConfigCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datalabeling.v1beta1.LabelTextRequest) {
        return mergeFrom((com.google.cloud.datalabeling.v1beta1.LabelTextRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datalabeling.v1beta1.LabelTextRequest other) {
      if (other == com.google.cloud.datalabeling.v1beta1.LabelTextRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        onChanged();
      }
      if (other.hasBasicConfig()) {
        mergeBasicConfig(other.getBasicConfig());
      }
      if (other.feature_ != 0) {
        setFeatureValue(other.getFeatureValue());
      }
      switch (other.getRequestConfigCase()) {
        case TEXT_CLASSIFICATION_CONFIG:
          {
            mergeTextClassificationConfig(other.getTextClassificationConfig());
            break;
          }
        case TEXT_ENTITY_EXTRACTION_CONFIG:
          {
            mergeTextEntityExtractionConfig(other.getTextEntityExtractionConfig());
            break;
          }
        case REQUESTCONFIG_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.datalabeling.v1beta1.LabelTextRequest parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.datalabeling.v1beta1.LabelTextRequest) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int requestConfigCase_ = 0;
    private java.lang.Object requestConfig_;

    public RequestConfigCase getRequestConfigCase() {
      return RequestConfigCase.forNumber(requestConfigCase_);
    }

    public Builder clearRequestConfig() {
      requestConfigCase_ = 0;
      requestConfig_ = null;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.TextClassificationConfig,
            com.google.cloud.datalabeling.v1beta1.TextClassificationConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.TextClassificationConfigOrBuilder>
        textClassificationConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for text classification task.
     * One of text_classification_config and text_entity_extraction_config
     * is required.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextClassificationConfig text_classification_config = 4;
     * </code>
     */
    public boolean hasTextClassificationConfig() {
      return requestConfigCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Configuration for text classification task.
     * One of text_classification_config and text_entity_extraction_config
     * is required.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextClassificationConfig text_classification_config = 4;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.TextClassificationConfig
        getTextClassificationConfig() {
      if (textClassificationConfigBuilder_ == null) {
        if (requestConfigCase_ == 4) {
          return (com.google.cloud.datalabeling.v1beta1.TextClassificationConfig) requestConfig_;
        }
        return com.google.cloud.datalabeling.v1beta1.TextClassificationConfig.getDefaultInstance();
      } else {
        if (requestConfigCase_ == 4) {
          return textClassificationConfigBuilder_.getMessage();
        }
        return com.google.cloud.datalabeling.v1beta1.TextClassificationConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for text classification task.
     * One of text_classification_config and text_entity_extraction_config
     * is required.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextClassificationConfig text_classification_config = 4;
     * </code>
     */
    public Builder setTextClassificationConfig(
        com.google.cloud.datalabeling.v1beta1.TextClassificationConfig value) {
      if (textClassificationConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        requestConfig_ = value;
        onChanged();
      } else {
        textClassificationConfigBuilder_.setMessage(value);
      }
      requestConfigCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for text classification task.
     * One of text_classification_config and text_entity_extraction_config
     * is required.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextClassificationConfig text_classification_config = 4;
     * </code>
     */
    public Builder setTextClassificationConfig(
        com.google.cloud.datalabeling.v1beta1.TextClassificationConfig.Builder builderForValue) {
      if (textClassificationConfigBuilder_ == null) {
        requestConfig_ = builderForValue.build();
        onChanged();
      } else {
        textClassificationConfigBuilder_.setMessage(builderForValue.build());
      }
      requestConfigCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for text classification task.
     * One of text_classification_config and text_entity_extraction_config
     * is required.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextClassificationConfig text_classification_config = 4;
     * </code>
     */
    public Builder mergeTextClassificationConfig(
        com.google.cloud.datalabeling.v1beta1.TextClassificationConfig value) {
      if (textClassificationConfigBuilder_ == null) {
        if (requestConfigCase_ == 4
            && requestConfig_
                != com.google.cloud.datalabeling.v1beta1.TextClassificationConfig
                    .getDefaultInstance()) {
          requestConfig_ =
              com.google.cloud.datalabeling.v1beta1.TextClassificationConfig.newBuilder(
                      (com.google.cloud.datalabeling.v1beta1.TextClassificationConfig)
                          requestConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          requestConfig_ = value;
        }
        onChanged();
      } else {
        if (requestConfigCase_ == 4) {
          textClassificationConfigBuilder_.mergeFrom(value);
        }
        textClassificationConfigBuilder_.setMessage(value);
      }
      requestConfigCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for text classification task.
     * One of text_classification_config and text_entity_extraction_config
     * is required.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextClassificationConfig text_classification_config = 4;
     * </code>
     */
    public Builder clearTextClassificationConfig() {
      if (textClassificationConfigBuilder_ == null) {
        if (requestConfigCase_ == 4) {
          requestConfigCase_ = 0;
          requestConfig_ = null;
          onChanged();
        }
      } else {
        if (requestConfigCase_ == 4) {
          requestConfigCase_ = 0;
          requestConfig_ = null;
        }
        textClassificationConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for text classification task.
     * One of text_classification_config and text_entity_extraction_config
     * is required.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextClassificationConfig text_classification_config = 4;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.TextClassificationConfig.Builder
        getTextClassificationConfigBuilder() {
      return getTextClassificationConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for text classification task.
     * One of text_classification_config and text_entity_extraction_config
     * is required.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextClassificationConfig text_classification_config = 4;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.TextClassificationConfigOrBuilder
        getTextClassificationConfigOrBuilder() {
      if ((requestConfigCase_ == 4) && (textClassificationConfigBuilder_ != null)) {
        return textClassificationConfigBuilder_.getMessageOrBuilder();
      } else {
        if (requestConfigCase_ == 4) {
          return (com.google.cloud.datalabeling.v1beta1.TextClassificationConfig) requestConfig_;
        }
        return com.google.cloud.datalabeling.v1beta1.TextClassificationConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for text classification task.
     * One of text_classification_config and text_entity_extraction_config
     * is required.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextClassificationConfig text_classification_config = 4;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.TextClassificationConfig,
            com.google.cloud.datalabeling.v1beta1.TextClassificationConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.TextClassificationConfigOrBuilder>
        getTextClassificationConfigFieldBuilder() {
      if (textClassificationConfigBuilder_ == null) {
        if (!(requestConfigCase_ == 4)) {
          requestConfig_ =
              com.google.cloud.datalabeling.v1beta1.TextClassificationConfig.getDefaultInstance();
        }
        textClassificationConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.TextClassificationConfig,
                com.google.cloud.datalabeling.v1beta1.TextClassificationConfig.Builder,
                com.google.cloud.datalabeling.v1beta1.TextClassificationConfigOrBuilder>(
                (com.google.cloud.datalabeling.v1beta1.TextClassificationConfig) requestConfig_,
                getParentForChildren(),
                isClean());
        requestConfig_ = null;
      }
      requestConfigCase_ = 4;
      onChanged();
      ;
      return textClassificationConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig,
            com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfigOrBuilder>
        textEntityExtractionConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for entity extraction task.
     * One of text_classification_config and text_entity_extraction_config
     * is required.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig text_entity_extraction_config = 5;
     * </code>
     */
    public boolean hasTextEntityExtractionConfig() {
      return requestConfigCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Configuration for entity extraction task.
     * One of text_classification_config and text_entity_extraction_config
     * is required.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig text_entity_extraction_config = 5;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig
        getTextEntityExtractionConfig() {
      if (textEntityExtractionConfigBuilder_ == null) {
        if (requestConfigCase_ == 5) {
          return (com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig) requestConfig_;
        }
        return com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig
            .getDefaultInstance();
      } else {
        if (requestConfigCase_ == 5) {
          return textEntityExtractionConfigBuilder_.getMessage();
        }
        return com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for entity extraction task.
     * One of text_classification_config and text_entity_extraction_config
     * is required.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig text_entity_extraction_config = 5;
     * </code>
     */
    public Builder setTextEntityExtractionConfig(
        com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig value) {
      if (textEntityExtractionConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        requestConfig_ = value;
        onChanged();
      } else {
        textEntityExtractionConfigBuilder_.setMessage(value);
      }
      requestConfigCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for entity extraction task.
     * One of text_classification_config and text_entity_extraction_config
     * is required.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig text_entity_extraction_config = 5;
     * </code>
     */
    public Builder setTextEntityExtractionConfig(
        com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig.Builder builderForValue) {
      if (textEntityExtractionConfigBuilder_ == null) {
        requestConfig_ = builderForValue.build();
        onChanged();
      } else {
        textEntityExtractionConfigBuilder_.setMessage(builderForValue.build());
      }
      requestConfigCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for entity extraction task.
     * One of text_classification_config and text_entity_extraction_config
     * is required.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig text_entity_extraction_config = 5;
     * </code>
     */
    public Builder mergeTextEntityExtractionConfig(
        com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig value) {
      if (textEntityExtractionConfigBuilder_ == null) {
        if (requestConfigCase_ == 5
            && requestConfig_
                != com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig
                    .getDefaultInstance()) {
          requestConfig_ =
              com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig.newBuilder(
                      (com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig)
                          requestConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          requestConfig_ = value;
        }
        onChanged();
      } else {
        if (requestConfigCase_ == 5) {
          textEntityExtractionConfigBuilder_.mergeFrom(value);
        }
        textEntityExtractionConfigBuilder_.setMessage(value);
      }
      requestConfigCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for entity extraction task.
     * One of text_classification_config and text_entity_extraction_config
     * is required.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig text_entity_extraction_config = 5;
     * </code>
     */
    public Builder clearTextEntityExtractionConfig() {
      if (textEntityExtractionConfigBuilder_ == null) {
        if (requestConfigCase_ == 5) {
          requestConfigCase_ = 0;
          requestConfig_ = null;
          onChanged();
        }
      } else {
        if (requestConfigCase_ == 5) {
          requestConfigCase_ = 0;
          requestConfig_ = null;
        }
        textEntityExtractionConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for entity extraction task.
     * One of text_classification_config and text_entity_extraction_config
     * is required.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig text_entity_extraction_config = 5;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig.Builder
        getTextEntityExtractionConfigBuilder() {
      return getTextEntityExtractionConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for entity extraction task.
     * One of text_classification_config and text_entity_extraction_config
     * is required.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig text_entity_extraction_config = 5;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfigOrBuilder
        getTextEntityExtractionConfigOrBuilder() {
      if ((requestConfigCase_ == 5) && (textEntityExtractionConfigBuilder_ != null)) {
        return textEntityExtractionConfigBuilder_.getMessageOrBuilder();
      } else {
        if (requestConfigCase_ == 5) {
          return (com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig) requestConfig_;
        }
        return com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for entity extraction task.
     * One of text_classification_config and text_entity_extraction_config
     * is required.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig text_entity_extraction_config = 5;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig,
            com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfigOrBuilder>
        getTextEntityExtractionConfigFieldBuilder() {
      if (textEntityExtractionConfigBuilder_ == null) {
        if (!(requestConfigCase_ == 5)) {
          requestConfig_ =
              com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig.getDefaultInstance();
        }
        textEntityExtractionConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig,
                com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig.Builder,
                com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfigOrBuilder>(
                (com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig) requestConfig_,
                getParentForChildren(),
                isClean());
        requestConfig_ = null;
      }
      requestConfigCase_ = 5;
      onChanged();
      ;
      return textEntityExtractionConfigBuilder_;
    }

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. Name of the data set to request labeling task, format:
     * projects/{project_id}/datasets/{dataset_id}
     * </pre>
     *
     * <code>string parent = 1;</code>
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the data set to request labeling task, format:
     * projects/{project_id}/datasets/{dataset_id}
     * </pre>
     *
     * <code>string parent = 1;</code>
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the data set to request labeling task, format:
     * projects/{project_id}/datasets/{dataset_id}
     * </pre>
     *
     * <code>string parent = 1;</code>
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      parent_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the data set to request labeling task, format:
     * projects/{project_id}/datasets/{dataset_id}
     * </pre>
     *
     * <code>string parent = 1;</code>
     */
    public Builder clearParent() {

      parent_ = getDefaultInstance().getParent();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the data set to request labeling task, format:
     * projects/{project_id}/datasets/{dataset_id}
     * </pre>
     *
     * <code>string parent = 1;</code>
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      parent_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig basicConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig,
            com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfigOrBuilder>
        basicConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Basic human annotation config.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig basic_config = 2;</code>
     */
    public boolean hasBasicConfig() {
      return basicConfigBuilder_ != null || basicConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. Basic human annotation config.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig basic_config = 2;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig getBasicConfig() {
      if (basicConfigBuilder_ == null) {
        return basicConfig_ == null
            ? com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.getDefaultInstance()
            : basicConfig_;
      } else {
        return basicConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Basic human annotation config.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig basic_config = 2;</code>
     */
    public Builder setBasicConfig(
        com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig value) {
      if (basicConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        basicConfig_ = value;
        onChanged();
      } else {
        basicConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Basic human annotation config.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig basic_config = 2;</code>
     */
    public Builder setBasicConfig(
        com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.Builder builderForValue) {
      if (basicConfigBuilder_ == null) {
        basicConfig_ = builderForValue.build();
        onChanged();
      } else {
        basicConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Basic human annotation config.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig basic_config = 2;</code>
     */
    public Builder mergeBasicConfig(
        com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig value) {
      if (basicConfigBuilder_ == null) {
        if (basicConfig_ != null) {
          basicConfig_ =
              com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.newBuilder(basicConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          basicConfig_ = value;
        }
        onChanged();
      } else {
        basicConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Basic human annotation config.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig basic_config = 2;</code>
     */
    public Builder clearBasicConfig() {
      if (basicConfigBuilder_ == null) {
        basicConfig_ = null;
        onChanged();
      } else {
        basicConfig_ = null;
        basicConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Basic human annotation config.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig basic_config = 2;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.Builder
        getBasicConfigBuilder() {

      onChanged();
      return getBasicConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Basic human annotation config.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig basic_config = 2;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfigOrBuilder
        getBasicConfigOrBuilder() {
      if (basicConfigBuilder_ != null) {
        return basicConfigBuilder_.getMessageOrBuilder();
      } else {
        return basicConfig_ == null
            ? com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.getDefaultInstance()
            : basicConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Basic human annotation config.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig basic_config = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig,
            com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfigOrBuilder>
        getBasicConfigFieldBuilder() {
      if (basicConfigBuilder_ == null) {
        basicConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig,
                com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.Builder,
                com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfigOrBuilder>(
                getBasicConfig(), getParentForChildren(), isClean());
        basicConfig_ = null;
      }
      return basicConfigBuilder_;
    }

    private int feature_ = 0;
    /**
     *
     *
     * <pre>
     * Required. The type of text labeling task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.LabelTextRequest.Feature feature = 6;</code>
     */
    public int getFeatureValue() {
      return feature_;
    }
    /**
     *
     *
     * <pre>
     * Required. The type of text labeling task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.LabelTextRequest.Feature feature = 6;</code>
     */
    public Builder setFeatureValue(int value) {
      feature_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The type of text labeling task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.LabelTextRequest.Feature feature = 6;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.LabelTextRequest.Feature getFeature() {
      @SuppressWarnings("deprecation")
      com.google.cloud.datalabeling.v1beta1.LabelTextRequest.Feature result =
          com.google.cloud.datalabeling.v1beta1.LabelTextRequest.Feature.valueOf(feature_);
      return result == null
          ? com.google.cloud.datalabeling.v1beta1.LabelTextRequest.Feature.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Required. The type of text labeling task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.LabelTextRequest.Feature feature = 6;</code>
     */
    public Builder setFeature(
        com.google.cloud.datalabeling.v1beta1.LabelTextRequest.Feature value) {
      if (value == null) {
        throw new NullPointerException();
      }

      feature_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The type of text labeling task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.LabelTextRequest.Feature feature = 6;</code>
     */
    public Builder clearFeature() {

      feature_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datalabeling.v1beta1.LabelTextRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datalabeling.v1beta1.LabelTextRequest)
  private static final com.google.cloud.datalabeling.v1beta1.LabelTextRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datalabeling.v1beta1.LabelTextRequest();
  }

  public static com.google.cloud.datalabeling.v1beta1.LabelTextRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<LabelTextRequest> PARSER =
      new com.google.protobuf.AbstractParser<LabelTextRequest>() {
        @java.lang.Override
        public LabelTextRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new LabelTextRequest(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<LabelTextRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<LabelTextRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.LabelTextRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
