/*
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datalabeling/v1beta1/evaluation.proto

package com.google.cloud.datalabeling.v1beta1;

/** Protobuf type {@code google.cloud.datalabeling.v1beta1.PrCurve} */
public final class PrCurve extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datalabeling.v1beta1.PrCurve)
    PrCurveOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use PrCurve.newBuilder() to construct.
  private PrCurve(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PrCurve() {
    confidenceMetricsEntries_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PrCurve();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private PrCurve(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              com.google.cloud.datalabeling.v1beta1.AnnotationSpec.Builder subBuilder = null;
              if (annotationSpec_ != null) {
                subBuilder = annotationSpec_.toBuilder();
              }
              annotationSpec_ =
                  input.readMessage(
                      com.google.cloud.datalabeling.v1beta1.AnnotationSpec.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(annotationSpec_);
                annotationSpec_ = subBuilder.buildPartial();
              }

              break;
            }
          case 21:
            {
              areaUnderCurve_ = input.readFloat();
              break;
            }
          case 26:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                confidenceMetricsEntries_ =
                    new java.util.ArrayList<
                        com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry>();
                mutable_bitField0_ |= 0x00000001;
              }
              confidenceMetricsEntries_.add(
                  input.readMessage(
                      com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry.parser(),
                      extensionRegistry));
              break;
            }
          case 37:
            {
              meanAveragePrecision_ = input.readFloat();
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        confidenceMetricsEntries_ =
            java.util.Collections.unmodifiableList(confidenceMetricsEntries_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datalabeling.v1beta1.EvaluationOuterClass
        .internal_static_google_cloud_datalabeling_v1beta1_PrCurve_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datalabeling.v1beta1.EvaluationOuterClass
        .internal_static_google_cloud_datalabeling_v1beta1_PrCurve_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datalabeling.v1beta1.PrCurve.class,
            com.google.cloud.datalabeling.v1beta1.PrCurve.Builder.class);
  }

  public interface ConfidenceMetricsEntryOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Threshold used for this entry, for example, IoU threshold for bounding
     * box problem, or detection threshold for classification.
     * </pre>
     *
     * <code>float confidence_threshold = 1;</code>
     *
     * @return The confidenceThreshold.
     */
    float getConfidenceThreshold();

    /**
     *
     *
     * <pre>
     * Recall value.
     * </pre>
     *
     * <code>float recall = 2;</code>
     *
     * @return The recall.
     */
    float getRecall();

    /**
     *
     *
     * <pre>
     * Precision value.
     * </pre>
     *
     * <code>float precision = 3;</code>
     *
     * @return The precision.
     */
    float getPrecision();

    /**
     *
     *
     * <pre>
     * Harmonic mean of recall and precision.
     * </pre>
     *
     * <code>float f1_score = 4;</code>
     *
     * @return The f1Score.
     */
    float getF1Score();

    /**
     *
     *
     * <pre>
     * Recall value for entries with label that has highest score.
     * </pre>
     *
     * <code>float recall_at1 = 5;</code>
     *
     * @return The recallAt1.
     */
    float getRecallAt1();

    /**
     *
     *
     * <pre>
     * Precision value for entries with label that has highest score.
     * </pre>
     *
     * <code>float precision_at1 = 6;</code>
     *
     * @return The precisionAt1.
     */
    float getPrecisionAt1();

    /**
     *
     *
     * <pre>
     * The harmonic mean of
     * [recall_at1][google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry.recall_at1]
     * and
     * [precision_at1][google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry.precision_at1].
     * </pre>
     *
     * <code>float f1_score_at1 = 7;</code>
     *
     * @return The f1ScoreAt1.
     */
    float getF1ScoreAt1();

    /**
     *
     *
     * <pre>
     * Recall value for entries with label that has highest 5 scores.
     * </pre>
     *
     * <code>float recall_at5 = 8;</code>
     *
     * @return The recallAt5.
     */
    float getRecallAt5();

    /**
     *
     *
     * <pre>
     * Precision value for entries with label that has highest 5 scores.
     * </pre>
     *
     * <code>float precision_at5 = 9;</code>
     *
     * @return The precisionAt5.
     */
    float getPrecisionAt5();

    /**
     *
     *
     * <pre>
     * The harmonic mean of
     * [recall_at5][google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry.recall_at5]
     * and
     * [precision_at5][google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry.precision_at5].
     * </pre>
     *
     * <code>float f1_score_at5 = 10;</code>
     *
     * @return The f1ScoreAt5.
     */
    float getF1ScoreAt5();
  }
  /** Protobuf type {@code google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry} */
  public static final class ConfidenceMetricsEntry extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry)
      ConfidenceMetricsEntryOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ConfidenceMetricsEntry.newBuilder() to construct.
    private ConfidenceMetricsEntry(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ConfidenceMetricsEntry() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ConfidenceMetricsEntry();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private ConfidenceMetricsEntry(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 13:
              {
                confidenceThreshold_ = input.readFloat();
                break;
              }
            case 21:
              {
                recall_ = input.readFloat();
                break;
              }
            case 29:
              {
                precision_ = input.readFloat();
                break;
              }
            case 37:
              {
                f1Score_ = input.readFloat();
                break;
              }
            case 45:
              {
                recallAt1_ = input.readFloat();
                break;
              }
            case 53:
              {
                precisionAt1_ = input.readFloat();
                break;
              }
            case 61:
              {
                f1ScoreAt1_ = input.readFloat();
                break;
              }
            case 69:
              {
                recallAt5_ = input.readFloat();
                break;
              }
            case 77:
              {
                precisionAt5_ = input.readFloat();
                break;
              }
            case 85:
              {
                f1ScoreAt5_ = input.readFloat();
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datalabeling.v1beta1.EvaluationOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_PrCurve_ConfidenceMetricsEntry_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datalabeling.v1beta1.EvaluationOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_PrCurve_ConfidenceMetricsEntry_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry.class,
              com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry.Builder.class);
    }

    public static final int CONFIDENCE_THRESHOLD_FIELD_NUMBER = 1;
    private float confidenceThreshold_;
    /**
     *
     *
     * <pre>
     * Threshold used for this entry, for example, IoU threshold for bounding
     * box problem, or detection threshold for classification.
     * </pre>
     *
     * <code>float confidence_threshold = 1;</code>
     *
     * @return The confidenceThreshold.
     */
    public float getConfidenceThreshold() {
      return confidenceThreshold_;
    }

    public static final int RECALL_FIELD_NUMBER = 2;
    private float recall_;
    /**
     *
     *
     * <pre>
     * Recall value.
     * </pre>
     *
     * <code>float recall = 2;</code>
     *
     * @return The recall.
     */
    public float getRecall() {
      return recall_;
    }

    public static final int PRECISION_FIELD_NUMBER = 3;
    private float precision_;
    /**
     *
     *
     * <pre>
     * Precision value.
     * </pre>
     *
     * <code>float precision = 3;</code>
     *
     * @return The precision.
     */
    public float getPrecision() {
      return precision_;
    }

    public static final int F1_SCORE_FIELD_NUMBER = 4;
    private float f1Score_;
    /**
     *
     *
     * <pre>
     * Harmonic mean of recall and precision.
     * </pre>
     *
     * <code>float f1_score = 4;</code>
     *
     * @return The f1Score.
     */
    public float getF1Score() {
      return f1Score_;
    }

    public static final int RECALL_AT1_FIELD_NUMBER = 5;
    private float recallAt1_;
    /**
     *
     *
     * <pre>
     * Recall value for entries with label that has highest score.
     * </pre>
     *
     * <code>float recall_at1 = 5;</code>
     *
     * @return The recallAt1.
     */
    public float getRecallAt1() {
      return recallAt1_;
    }

    public static final int PRECISION_AT1_FIELD_NUMBER = 6;
    private float precisionAt1_;
    /**
     *
     *
     * <pre>
     * Precision value for entries with label that has highest score.
     * </pre>
     *
     * <code>float precision_at1 = 6;</code>
     *
     * @return The precisionAt1.
     */
    public float getPrecisionAt1() {
      return precisionAt1_;
    }

    public static final int F1_SCORE_AT1_FIELD_NUMBER = 7;
    private float f1ScoreAt1_;
    /**
     *
     *
     * <pre>
     * The harmonic mean of
     * [recall_at1][google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry.recall_at1]
     * and
     * [precision_at1][google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry.precision_at1].
     * </pre>
     *
     * <code>float f1_score_at1 = 7;</code>
     *
     * @return The f1ScoreAt1.
     */
    public float getF1ScoreAt1() {
      return f1ScoreAt1_;
    }

    public static final int RECALL_AT5_FIELD_NUMBER = 8;
    private float recallAt5_;
    /**
     *
     *
     * <pre>
     * Recall value for entries with label that has highest 5 scores.
     * </pre>
     *
     * <code>float recall_at5 = 8;</code>
     *
     * @return The recallAt5.
     */
    public float getRecallAt5() {
      return recallAt5_;
    }

    public static final int PRECISION_AT5_FIELD_NUMBER = 9;
    private float precisionAt5_;
    /**
     *
     *
     * <pre>
     * Precision value for entries with label that has highest 5 scores.
     * </pre>
     *
     * <code>float precision_at5 = 9;</code>
     *
     * @return The precisionAt5.
     */
    public float getPrecisionAt5() {
      return precisionAt5_;
    }

    public static final int F1_SCORE_AT5_FIELD_NUMBER = 10;
    private float f1ScoreAt5_;
    /**
     *
     *
     * <pre>
     * The harmonic mean of
     * [recall_at5][google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry.recall_at5]
     * and
     * [precision_at5][google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry.precision_at5].
     * </pre>
     *
     * <code>float f1_score_at5 = 10;</code>
     *
     * @return The f1ScoreAt5.
     */
    public float getF1ScoreAt5() {
      return f1ScoreAt5_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (confidenceThreshold_ != 0F) {
        output.writeFloat(1, confidenceThreshold_);
      }
      if (recall_ != 0F) {
        output.writeFloat(2, recall_);
      }
      if (precision_ != 0F) {
        output.writeFloat(3, precision_);
      }
      if (f1Score_ != 0F) {
        output.writeFloat(4, f1Score_);
      }
      if (recallAt1_ != 0F) {
        output.writeFloat(5, recallAt1_);
      }
      if (precisionAt1_ != 0F) {
        output.writeFloat(6, precisionAt1_);
      }
      if (f1ScoreAt1_ != 0F) {
        output.writeFloat(7, f1ScoreAt1_);
      }
      if (recallAt5_ != 0F) {
        output.writeFloat(8, recallAt5_);
      }
      if (precisionAt5_ != 0F) {
        output.writeFloat(9, precisionAt5_);
      }
      if (f1ScoreAt5_ != 0F) {
        output.writeFloat(10, f1ScoreAt5_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (confidenceThreshold_ != 0F) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(1, confidenceThreshold_);
      }
      if (recall_ != 0F) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, recall_);
      }
      if (precision_ != 0F) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(3, precision_);
      }
      if (f1Score_ != 0F) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(4, f1Score_);
      }
      if (recallAt1_ != 0F) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(5, recallAt1_);
      }
      if (precisionAt1_ != 0F) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(6, precisionAt1_);
      }
      if (f1ScoreAt1_ != 0F) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(7, f1ScoreAt1_);
      }
      if (recallAt5_ != 0F) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(8, recallAt5_);
      }
      if (precisionAt5_ != 0F) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(9, precisionAt5_);
      }
      if (f1ScoreAt5_ != 0F) {
        size += com.google.protobuf.CodedOutputStream.computeFloatSize(10, f1ScoreAt5_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry)) {
        return super.equals(obj);
      }
      com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry other =
          (com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry) obj;

      if (java.lang.Float.floatToIntBits(getConfidenceThreshold())
          != java.lang.Float.floatToIntBits(other.getConfidenceThreshold())) return false;
      if (java.lang.Float.floatToIntBits(getRecall())
          != java.lang.Float.floatToIntBits(other.getRecall())) return false;
      if (java.lang.Float.floatToIntBits(getPrecision())
          != java.lang.Float.floatToIntBits(other.getPrecision())) return false;
      if (java.lang.Float.floatToIntBits(getF1Score())
          != java.lang.Float.floatToIntBits(other.getF1Score())) return false;
      if (java.lang.Float.floatToIntBits(getRecallAt1())
          != java.lang.Float.floatToIntBits(other.getRecallAt1())) return false;
      if (java.lang.Float.floatToIntBits(getPrecisionAt1())
          != java.lang.Float.floatToIntBits(other.getPrecisionAt1())) return false;
      if (java.lang.Float.floatToIntBits(getF1ScoreAt1())
          != java.lang.Float.floatToIntBits(other.getF1ScoreAt1())) return false;
      if (java.lang.Float.floatToIntBits(getRecallAt5())
          != java.lang.Float.floatToIntBits(other.getRecallAt5())) return false;
      if (java.lang.Float.floatToIntBits(getPrecisionAt5())
          != java.lang.Float.floatToIntBits(other.getPrecisionAt5())) return false;
      if (java.lang.Float.floatToIntBits(getF1ScoreAt5())
          != java.lang.Float.floatToIntBits(other.getF1ScoreAt5())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + CONFIDENCE_THRESHOLD_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getConfidenceThreshold());
      hash = (37 * hash) + RECALL_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getRecall());
      hash = (37 * hash) + PRECISION_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getPrecision());
      hash = (37 * hash) + F1_SCORE_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getF1Score());
      hash = (37 * hash) + RECALL_AT1_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getRecallAt1());
      hash = (37 * hash) + PRECISION_AT1_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getPrecisionAt1());
      hash = (37 * hash) + F1_SCORE_AT1_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getF1ScoreAt1());
      hash = (37 * hash) + RECALL_AT5_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getRecallAt5());
      hash = (37 * hash) + PRECISION_AT5_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getPrecisionAt5());
      hash = (37 * hash) + F1_SCORE_AT5_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(getF1ScoreAt5());
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /** Protobuf type {@code google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry} */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry)
        com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntryOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.datalabeling.v1beta1.EvaluationOuterClass
            .internal_static_google_cloud_datalabeling_v1beta1_PrCurve_ConfidenceMetricsEntry_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.datalabeling.v1beta1.EvaluationOuterClass
            .internal_static_google_cloud_datalabeling_v1beta1_PrCurve_ConfidenceMetricsEntry_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry.class,
                com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry.Builder.class);
      }

      // Construct using
      // com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        confidenceThreshold_ = 0F;

        recall_ = 0F;

        precision_ = 0F;

        f1Score_ = 0F;

        recallAt1_ = 0F;

        precisionAt1_ = 0F;

        f1ScoreAt1_ = 0F;

        recallAt5_ = 0F;

        precisionAt5_ = 0F;

        f1ScoreAt5_ = 0F;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.datalabeling.v1beta1.EvaluationOuterClass
            .internal_static_google_cloud_datalabeling_v1beta1_PrCurve_ConfidenceMetricsEntry_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry
          getDefaultInstanceForType() {
        return com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry build() {
        com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry buildPartial() {
        com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry result =
            new com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry(this);
        result.confidenceThreshold_ = confidenceThreshold_;
        result.recall_ = recall_;
        result.precision_ = precision_;
        result.f1Score_ = f1Score_;
        result.recallAt1_ = recallAt1_;
        result.precisionAt1_ = precisionAt1_;
        result.f1ScoreAt1_ = f1ScoreAt1_;
        result.recallAt5_ = recallAt5_;
        result.precisionAt5_ = precisionAt5_;
        result.f1ScoreAt5_ = f1ScoreAt5_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry) {
          return mergeFrom(
              (com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry other) {
        if (other
            == com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry
                .getDefaultInstance()) return this;
        if (other.getConfidenceThreshold() != 0F) {
          setConfidenceThreshold(other.getConfidenceThreshold());
        }
        if (other.getRecall() != 0F) {
          setRecall(other.getRecall());
        }
        if (other.getPrecision() != 0F) {
          setPrecision(other.getPrecision());
        }
        if (other.getF1Score() != 0F) {
          setF1Score(other.getF1Score());
        }
        if (other.getRecallAt1() != 0F) {
          setRecallAt1(other.getRecallAt1());
        }
        if (other.getPrecisionAt1() != 0F) {
          setPrecisionAt1(other.getPrecisionAt1());
        }
        if (other.getF1ScoreAt1() != 0F) {
          setF1ScoreAt1(other.getF1ScoreAt1());
        }
        if (other.getRecallAt5() != 0F) {
          setRecallAt5(other.getRecallAt5());
        }
        if (other.getPrecisionAt5() != 0F) {
          setPrecisionAt5(other.getPrecisionAt5());
        }
        if (other.getF1ScoreAt5() != 0F) {
          setF1ScoreAt5(other.getF1ScoreAt5());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private float confidenceThreshold_;
      /**
       *
       *
       * <pre>
       * Threshold used for this entry, for example, IoU threshold for bounding
       * box problem, or detection threshold for classification.
       * </pre>
       *
       * <code>float confidence_threshold = 1;</code>
       *
       * @return The confidenceThreshold.
       */
      public float getConfidenceThreshold() {
        return confidenceThreshold_;
      }
      /**
       *
       *
       * <pre>
       * Threshold used for this entry, for example, IoU threshold for bounding
       * box problem, or detection threshold for classification.
       * </pre>
       *
       * <code>float confidence_threshold = 1;</code>
       *
       * @param value The confidenceThreshold to set.
       * @return This builder for chaining.
       */
      public Builder setConfidenceThreshold(float value) {

        confidenceThreshold_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Threshold used for this entry, for example, IoU threshold for bounding
       * box problem, or detection threshold for classification.
       * </pre>
       *
       * <code>float confidence_threshold = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearConfidenceThreshold() {

        confidenceThreshold_ = 0F;
        onChanged();
        return this;
      }

      private float recall_;
      /**
       *
       *
       * <pre>
       * Recall value.
       * </pre>
       *
       * <code>float recall = 2;</code>
       *
       * @return The recall.
       */
      public float getRecall() {
        return recall_;
      }
      /**
       *
       *
       * <pre>
       * Recall value.
       * </pre>
       *
       * <code>float recall = 2;</code>
       *
       * @param value The recall to set.
       * @return This builder for chaining.
       */
      public Builder setRecall(float value) {

        recall_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Recall value.
       * </pre>
       *
       * <code>float recall = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRecall() {

        recall_ = 0F;
        onChanged();
        return this;
      }

      private float precision_;
      /**
       *
       *
       * <pre>
       * Precision value.
       * </pre>
       *
       * <code>float precision = 3;</code>
       *
       * @return The precision.
       */
      public float getPrecision() {
        return precision_;
      }
      /**
       *
       *
       * <pre>
       * Precision value.
       * </pre>
       *
       * <code>float precision = 3;</code>
       *
       * @param value The precision to set.
       * @return This builder for chaining.
       */
      public Builder setPrecision(float value) {

        precision_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Precision value.
       * </pre>
       *
       * <code>float precision = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPrecision() {

        precision_ = 0F;
        onChanged();
        return this;
      }

      private float f1Score_;
      /**
       *
       *
       * <pre>
       * Harmonic mean of recall and precision.
       * </pre>
       *
       * <code>float f1_score = 4;</code>
       *
       * @return The f1Score.
       */
      public float getF1Score() {
        return f1Score_;
      }
      /**
       *
       *
       * <pre>
       * Harmonic mean of recall and precision.
       * </pre>
       *
       * <code>float f1_score = 4;</code>
       *
       * @param value The f1Score to set.
       * @return This builder for chaining.
       */
      public Builder setF1Score(float value) {

        f1Score_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Harmonic mean of recall and precision.
       * </pre>
       *
       * <code>float f1_score = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearF1Score() {

        f1Score_ = 0F;
        onChanged();
        return this;
      }

      private float recallAt1_;
      /**
       *
       *
       * <pre>
       * Recall value for entries with label that has highest score.
       * </pre>
       *
       * <code>float recall_at1 = 5;</code>
       *
       * @return The recallAt1.
       */
      public float getRecallAt1() {
        return recallAt1_;
      }
      /**
       *
       *
       * <pre>
       * Recall value for entries with label that has highest score.
       * </pre>
       *
       * <code>float recall_at1 = 5;</code>
       *
       * @param value The recallAt1 to set.
       * @return This builder for chaining.
       */
      public Builder setRecallAt1(float value) {

        recallAt1_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Recall value for entries with label that has highest score.
       * </pre>
       *
       * <code>float recall_at1 = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRecallAt1() {

        recallAt1_ = 0F;
        onChanged();
        return this;
      }

      private float precisionAt1_;
      /**
       *
       *
       * <pre>
       * Precision value for entries with label that has highest score.
       * </pre>
       *
       * <code>float precision_at1 = 6;</code>
       *
       * @return The precisionAt1.
       */
      public float getPrecisionAt1() {
        return precisionAt1_;
      }
      /**
       *
       *
       * <pre>
       * Precision value for entries with label that has highest score.
       * </pre>
       *
       * <code>float precision_at1 = 6;</code>
       *
       * @param value The precisionAt1 to set.
       * @return This builder for chaining.
       */
      public Builder setPrecisionAt1(float value) {

        precisionAt1_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Precision value for entries with label that has highest score.
       * </pre>
       *
       * <code>float precision_at1 = 6;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPrecisionAt1() {

        precisionAt1_ = 0F;
        onChanged();
        return this;
      }

      private float f1ScoreAt1_;
      /**
       *
       *
       * <pre>
       * The harmonic mean of
       * [recall_at1][google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry.recall_at1]
       * and
       * [precision_at1][google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry.precision_at1].
       * </pre>
       *
       * <code>float f1_score_at1 = 7;</code>
       *
       * @return The f1ScoreAt1.
       */
      public float getF1ScoreAt1() {
        return f1ScoreAt1_;
      }
      /**
       *
       *
       * <pre>
       * The harmonic mean of
       * [recall_at1][google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry.recall_at1]
       * and
       * [precision_at1][google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry.precision_at1].
       * </pre>
       *
       * <code>float f1_score_at1 = 7;</code>
       *
       * @param value The f1ScoreAt1 to set.
       * @return This builder for chaining.
       */
      public Builder setF1ScoreAt1(float value) {

        f1ScoreAt1_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The harmonic mean of
       * [recall_at1][google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry.recall_at1]
       * and
       * [precision_at1][google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry.precision_at1].
       * </pre>
       *
       * <code>float f1_score_at1 = 7;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearF1ScoreAt1() {

        f1ScoreAt1_ = 0F;
        onChanged();
        return this;
      }

      private float recallAt5_;
      /**
       *
       *
       * <pre>
       * Recall value for entries with label that has highest 5 scores.
       * </pre>
       *
       * <code>float recall_at5 = 8;</code>
       *
       * @return The recallAt5.
       */
      public float getRecallAt5() {
        return recallAt5_;
      }
      /**
       *
       *
       * <pre>
       * Recall value for entries with label that has highest 5 scores.
       * </pre>
       *
       * <code>float recall_at5 = 8;</code>
       *
       * @param value The recallAt5 to set.
       * @return This builder for chaining.
       */
      public Builder setRecallAt5(float value) {

        recallAt5_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Recall value for entries with label that has highest 5 scores.
       * </pre>
       *
       * <code>float recall_at5 = 8;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRecallAt5() {

        recallAt5_ = 0F;
        onChanged();
        return this;
      }

      private float precisionAt5_;
      /**
       *
       *
       * <pre>
       * Precision value for entries with label that has highest 5 scores.
       * </pre>
       *
       * <code>float precision_at5 = 9;</code>
       *
       * @return The precisionAt5.
       */
      public float getPrecisionAt5() {
        return precisionAt5_;
      }
      /**
       *
       *
       * <pre>
       * Precision value for entries with label that has highest 5 scores.
       * </pre>
       *
       * <code>float precision_at5 = 9;</code>
       *
       * @param value The precisionAt5 to set.
       * @return This builder for chaining.
       */
      public Builder setPrecisionAt5(float value) {

        precisionAt5_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Precision value for entries with label that has highest 5 scores.
       * </pre>
       *
       * <code>float precision_at5 = 9;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPrecisionAt5() {

        precisionAt5_ = 0F;
        onChanged();
        return this;
      }

      private float f1ScoreAt5_;
      /**
       *
       *
       * <pre>
       * The harmonic mean of
       * [recall_at5][google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry.recall_at5]
       * and
       * [precision_at5][google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry.precision_at5].
       * </pre>
       *
       * <code>float f1_score_at5 = 10;</code>
       *
       * @return The f1ScoreAt5.
       */
      public float getF1ScoreAt5() {
        return f1ScoreAt5_;
      }
      /**
       *
       *
       * <pre>
       * The harmonic mean of
       * [recall_at5][google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry.recall_at5]
       * and
       * [precision_at5][google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry.precision_at5].
       * </pre>
       *
       * <code>float f1_score_at5 = 10;</code>
       *
       * @param value The f1ScoreAt5 to set.
       * @return This builder for chaining.
       */
      public Builder setF1ScoreAt5(float value) {

        f1ScoreAt5_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The harmonic mean of
       * [recall_at5][google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry.recall_at5]
       * and
       * [precision_at5][google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry.precision_at5].
       * </pre>
       *
       * <code>float f1_score_at5 = 10;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearF1ScoreAt5() {

        f1ScoreAt5_ = 0F;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry)
    private static final com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry();
    }

    public static com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ConfidenceMetricsEntry> PARSER =
        new com.google.protobuf.AbstractParser<ConfidenceMetricsEntry>() {
          @java.lang.Override
          public ConfidenceMetricsEntry parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new ConfidenceMetricsEntry(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<ConfidenceMetricsEntry> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ConfidenceMetricsEntry> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int ANNOTATION_SPEC_FIELD_NUMBER = 1;
  private com.google.cloud.datalabeling.v1beta1.AnnotationSpec annotationSpec_;
  /**
   *
   *
   * <pre>
   * PR curve against which annotation spec. Could be empty.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
   *
   * @return Whether the annotationSpec field is set.
   */
  public boolean hasAnnotationSpec() {
    return annotationSpec_ != null;
  }
  /**
   *
   *
   * <pre>
   * PR curve against which annotation spec. Could be empty.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
   *
   * @return The annotationSpec.
   */
  public com.google.cloud.datalabeling.v1beta1.AnnotationSpec getAnnotationSpec() {
    return annotationSpec_ == null
        ? com.google.cloud.datalabeling.v1beta1.AnnotationSpec.getDefaultInstance()
        : annotationSpec_;
  }
  /**
   *
   *
   * <pre>
   * PR curve against which annotation spec. Could be empty.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
   */
  public com.google.cloud.datalabeling.v1beta1.AnnotationSpecOrBuilder
      getAnnotationSpecOrBuilder() {
    return getAnnotationSpec();
  }

  public static final int AREA_UNDER_CURVE_FIELD_NUMBER = 2;
  private float areaUnderCurve_;
  /**
   *
   *
   * <pre>
   * Area under precision recall curve.
   * </pre>
   *
   * <code>float area_under_curve = 2;</code>
   *
   * @return The areaUnderCurve.
   */
  public float getAreaUnderCurve() {
    return areaUnderCurve_;
  }

  public static final int CONFIDENCE_METRICS_ENTRIES_FIELD_NUMBER = 3;
  private java.util.List<com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry>
      confidenceMetricsEntries_;
  /**
   *
   *
   * <pre>
   * entries to draw PR graph.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry confidence_metrics_entries = 3;
   * </code>
   */
  public java.util.List<com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry>
      getConfidenceMetricsEntriesList() {
    return confidenceMetricsEntries_;
  }
  /**
   *
   *
   * <pre>
   * entries to draw PR graph.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry confidence_metrics_entries = 3;
   * </code>
   */
  public java.util.List<
          ? extends com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntryOrBuilder>
      getConfidenceMetricsEntriesOrBuilderList() {
    return confidenceMetricsEntries_;
  }
  /**
   *
   *
   * <pre>
   * entries to draw PR graph.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry confidence_metrics_entries = 3;
   * </code>
   */
  public int getConfidenceMetricsEntriesCount() {
    return confidenceMetricsEntries_.size();
  }
  /**
   *
   *
   * <pre>
   * entries to draw PR graph.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry confidence_metrics_entries = 3;
   * </code>
   */
  public com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry
      getConfidenceMetricsEntries(int index) {
    return confidenceMetricsEntries_.get(index);
  }
  /**
   *
   *
   * <pre>
   * entries to draw PR graph.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry confidence_metrics_entries = 3;
   * </code>
   */
  public com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntryOrBuilder
      getConfidenceMetricsEntriesOrBuilder(int index) {
    return confidenceMetricsEntries_.get(index);
  }

  public static final int MEAN_AVERAGE_PRECISION_FIELD_NUMBER = 4;
  private float meanAveragePrecision_;
  /**
   *
   *
   * <pre>
   * mean average prcision of this curve.
   * </pre>
   *
   * <code>float mean_average_precision = 4;</code>
   *
   * @return The meanAveragePrecision.
   */
  public float getMeanAveragePrecision() {
    return meanAveragePrecision_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (annotationSpec_ != null) {
      output.writeMessage(1, getAnnotationSpec());
    }
    if (areaUnderCurve_ != 0F) {
      output.writeFloat(2, areaUnderCurve_);
    }
    for (int i = 0; i < confidenceMetricsEntries_.size(); i++) {
      output.writeMessage(3, confidenceMetricsEntries_.get(i));
    }
    if (meanAveragePrecision_ != 0F) {
      output.writeFloat(4, meanAveragePrecision_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (annotationSpec_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getAnnotationSpec());
    }
    if (areaUnderCurve_ != 0F) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(2, areaUnderCurve_);
    }
    for (int i = 0; i < confidenceMetricsEntries_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, confidenceMetricsEntries_.get(i));
    }
    if (meanAveragePrecision_ != 0F) {
      size += com.google.protobuf.CodedOutputStream.computeFloatSize(4, meanAveragePrecision_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datalabeling.v1beta1.PrCurve)) {
      return super.equals(obj);
    }
    com.google.cloud.datalabeling.v1beta1.PrCurve other =
        (com.google.cloud.datalabeling.v1beta1.PrCurve) obj;

    if (hasAnnotationSpec() != other.hasAnnotationSpec()) return false;
    if (hasAnnotationSpec()) {
      if (!getAnnotationSpec().equals(other.getAnnotationSpec())) return false;
    }
    if (java.lang.Float.floatToIntBits(getAreaUnderCurve())
        != java.lang.Float.floatToIntBits(other.getAreaUnderCurve())) return false;
    if (!getConfidenceMetricsEntriesList().equals(other.getConfidenceMetricsEntriesList()))
      return false;
    if (java.lang.Float.floatToIntBits(getMeanAveragePrecision())
        != java.lang.Float.floatToIntBits(other.getMeanAveragePrecision())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasAnnotationSpec()) {
      hash = (37 * hash) + ANNOTATION_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getAnnotationSpec().hashCode();
    }
    hash = (37 * hash) + AREA_UNDER_CURVE_FIELD_NUMBER;
    hash = (53 * hash) + java.lang.Float.floatToIntBits(getAreaUnderCurve());
    if (getConfidenceMetricsEntriesCount() > 0) {
      hash = (37 * hash) + CONFIDENCE_METRICS_ENTRIES_FIELD_NUMBER;
      hash = (53 * hash) + getConfidenceMetricsEntriesList().hashCode();
    }
    hash = (37 * hash) + MEAN_AVERAGE_PRECISION_FIELD_NUMBER;
    hash = (53 * hash) + java.lang.Float.floatToIntBits(getMeanAveragePrecision());
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datalabeling.v1beta1.PrCurve parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.PrCurve parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.PrCurve parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.PrCurve parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.PrCurve parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.PrCurve parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.PrCurve parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.PrCurve parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.PrCurve parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.PrCurve parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.PrCurve parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.PrCurve parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.datalabeling.v1beta1.PrCurve prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /** Protobuf type {@code google.cloud.datalabeling.v1beta1.PrCurve} */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datalabeling.v1beta1.PrCurve)
      com.google.cloud.datalabeling.v1beta1.PrCurveOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datalabeling.v1beta1.EvaluationOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_PrCurve_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datalabeling.v1beta1.EvaluationOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_PrCurve_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datalabeling.v1beta1.PrCurve.class,
              com.google.cloud.datalabeling.v1beta1.PrCurve.Builder.class);
    }

    // Construct using com.google.cloud.datalabeling.v1beta1.PrCurve.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getConfidenceMetricsEntriesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (annotationSpecBuilder_ == null) {
        annotationSpec_ = null;
      } else {
        annotationSpec_ = null;
        annotationSpecBuilder_ = null;
      }
      areaUnderCurve_ = 0F;

      if (confidenceMetricsEntriesBuilder_ == null) {
        confidenceMetricsEntries_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        confidenceMetricsEntriesBuilder_.clear();
      }
      meanAveragePrecision_ = 0F;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datalabeling.v1beta1.EvaluationOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_PrCurve_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.PrCurve getDefaultInstanceForType() {
      return com.google.cloud.datalabeling.v1beta1.PrCurve.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.PrCurve build() {
      com.google.cloud.datalabeling.v1beta1.PrCurve result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.PrCurve buildPartial() {
      com.google.cloud.datalabeling.v1beta1.PrCurve result =
          new com.google.cloud.datalabeling.v1beta1.PrCurve(this);
      int from_bitField0_ = bitField0_;
      if (annotationSpecBuilder_ == null) {
        result.annotationSpec_ = annotationSpec_;
      } else {
        result.annotationSpec_ = annotationSpecBuilder_.build();
      }
      result.areaUnderCurve_ = areaUnderCurve_;
      if (confidenceMetricsEntriesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          confidenceMetricsEntries_ =
              java.util.Collections.unmodifiableList(confidenceMetricsEntries_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.confidenceMetricsEntries_ = confidenceMetricsEntries_;
      } else {
        result.confidenceMetricsEntries_ = confidenceMetricsEntriesBuilder_.build();
      }
      result.meanAveragePrecision_ = meanAveragePrecision_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datalabeling.v1beta1.PrCurve) {
        return mergeFrom((com.google.cloud.datalabeling.v1beta1.PrCurve) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datalabeling.v1beta1.PrCurve other) {
      if (other == com.google.cloud.datalabeling.v1beta1.PrCurve.getDefaultInstance()) return this;
      if (other.hasAnnotationSpec()) {
        mergeAnnotationSpec(other.getAnnotationSpec());
      }
      if (other.getAreaUnderCurve() != 0F) {
        setAreaUnderCurve(other.getAreaUnderCurve());
      }
      if (confidenceMetricsEntriesBuilder_ == null) {
        if (!other.confidenceMetricsEntries_.isEmpty()) {
          if (confidenceMetricsEntries_.isEmpty()) {
            confidenceMetricsEntries_ = other.confidenceMetricsEntries_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureConfidenceMetricsEntriesIsMutable();
            confidenceMetricsEntries_.addAll(other.confidenceMetricsEntries_);
          }
          onChanged();
        }
      } else {
        if (!other.confidenceMetricsEntries_.isEmpty()) {
          if (confidenceMetricsEntriesBuilder_.isEmpty()) {
            confidenceMetricsEntriesBuilder_.dispose();
            confidenceMetricsEntriesBuilder_ = null;
            confidenceMetricsEntries_ = other.confidenceMetricsEntries_;
            bitField0_ = (bitField0_ & ~0x00000001);
            confidenceMetricsEntriesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getConfidenceMetricsEntriesFieldBuilder()
                    : null;
          } else {
            confidenceMetricsEntriesBuilder_.addAllMessages(other.confidenceMetricsEntries_);
          }
        }
      }
      if (other.getMeanAveragePrecision() != 0F) {
        setMeanAveragePrecision(other.getMeanAveragePrecision());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.datalabeling.v1beta1.PrCurve parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.datalabeling.v1beta1.PrCurve) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private com.google.cloud.datalabeling.v1beta1.AnnotationSpec annotationSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.AnnotationSpec,
            com.google.cloud.datalabeling.v1beta1.AnnotationSpec.Builder,
            com.google.cloud.datalabeling.v1beta1.AnnotationSpecOrBuilder>
        annotationSpecBuilder_;
    /**
     *
     *
     * <pre>
     * PR curve against which annotation spec. Could be empty.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
     *
     * @return Whether the annotationSpec field is set.
     */
    public boolean hasAnnotationSpec() {
      return annotationSpecBuilder_ != null || annotationSpec_ != null;
    }
    /**
     *
     *
     * <pre>
     * PR curve against which annotation spec. Could be empty.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
     *
     * @return The annotationSpec.
     */
    public com.google.cloud.datalabeling.v1beta1.AnnotationSpec getAnnotationSpec() {
      if (annotationSpecBuilder_ == null) {
        return annotationSpec_ == null
            ? com.google.cloud.datalabeling.v1beta1.AnnotationSpec.getDefaultInstance()
            : annotationSpec_;
      } else {
        return annotationSpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * PR curve against which annotation spec. Could be empty.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
     */
    public Builder setAnnotationSpec(com.google.cloud.datalabeling.v1beta1.AnnotationSpec value) {
      if (annotationSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        annotationSpec_ = value;
        onChanged();
      } else {
        annotationSpecBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * PR curve against which annotation spec. Could be empty.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
     */
    public Builder setAnnotationSpec(
        com.google.cloud.datalabeling.v1beta1.AnnotationSpec.Builder builderForValue) {
      if (annotationSpecBuilder_ == null) {
        annotationSpec_ = builderForValue.build();
        onChanged();
      } else {
        annotationSpecBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * PR curve against which annotation spec. Could be empty.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
     */
    public Builder mergeAnnotationSpec(com.google.cloud.datalabeling.v1beta1.AnnotationSpec value) {
      if (annotationSpecBuilder_ == null) {
        if (annotationSpec_ != null) {
          annotationSpec_ =
              com.google.cloud.datalabeling.v1beta1.AnnotationSpec.newBuilder(annotationSpec_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          annotationSpec_ = value;
        }
        onChanged();
      } else {
        annotationSpecBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * PR curve against which annotation spec. Could be empty.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
     */
    public Builder clearAnnotationSpec() {
      if (annotationSpecBuilder_ == null) {
        annotationSpec_ = null;
        onChanged();
      } else {
        annotationSpec_ = null;
        annotationSpecBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * PR curve against which annotation spec. Could be empty.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.AnnotationSpec.Builder getAnnotationSpecBuilder() {

      onChanged();
      return getAnnotationSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * PR curve against which annotation spec. Could be empty.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.AnnotationSpecOrBuilder
        getAnnotationSpecOrBuilder() {
      if (annotationSpecBuilder_ != null) {
        return annotationSpecBuilder_.getMessageOrBuilder();
      } else {
        return annotationSpec_ == null
            ? com.google.cloud.datalabeling.v1beta1.AnnotationSpec.getDefaultInstance()
            : annotationSpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * PR curve against which annotation spec. Could be empty.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.AnnotationSpec,
            com.google.cloud.datalabeling.v1beta1.AnnotationSpec.Builder,
            com.google.cloud.datalabeling.v1beta1.AnnotationSpecOrBuilder>
        getAnnotationSpecFieldBuilder() {
      if (annotationSpecBuilder_ == null) {
        annotationSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.AnnotationSpec,
                com.google.cloud.datalabeling.v1beta1.AnnotationSpec.Builder,
                com.google.cloud.datalabeling.v1beta1.AnnotationSpecOrBuilder>(
                getAnnotationSpec(), getParentForChildren(), isClean());
        annotationSpec_ = null;
      }
      return annotationSpecBuilder_;
    }

    private float areaUnderCurve_;
    /**
     *
     *
     * <pre>
     * Area under precision recall curve.
     * </pre>
     *
     * <code>float area_under_curve = 2;</code>
     *
     * @return The areaUnderCurve.
     */
    public float getAreaUnderCurve() {
      return areaUnderCurve_;
    }
    /**
     *
     *
     * <pre>
     * Area under precision recall curve.
     * </pre>
     *
     * <code>float area_under_curve = 2;</code>
     *
     * @param value The areaUnderCurve to set.
     * @return This builder for chaining.
     */
    public Builder setAreaUnderCurve(float value) {

      areaUnderCurve_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Area under precision recall curve.
     * </pre>
     *
     * <code>float area_under_curve = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAreaUnderCurve() {

      areaUnderCurve_ = 0F;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry>
        confidenceMetricsEntries_ = java.util.Collections.emptyList();

    private void ensureConfidenceMetricsEntriesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        confidenceMetricsEntries_ =
            new java.util.ArrayList<
                com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry>(
                confidenceMetricsEntries_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry,
            com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry.Builder,
            com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntryOrBuilder>
        confidenceMetricsEntriesBuilder_;

    /**
     *
     *
     * <pre>
     * entries to draw PR graph.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry confidence_metrics_entries = 3;
     * </code>
     */
    public java.util.List<com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry>
        getConfidenceMetricsEntriesList() {
      if (confidenceMetricsEntriesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(confidenceMetricsEntries_);
      } else {
        return confidenceMetricsEntriesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * entries to draw PR graph.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry confidence_metrics_entries = 3;
     * </code>
     */
    public int getConfidenceMetricsEntriesCount() {
      if (confidenceMetricsEntriesBuilder_ == null) {
        return confidenceMetricsEntries_.size();
      } else {
        return confidenceMetricsEntriesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * entries to draw PR graph.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry confidence_metrics_entries = 3;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry
        getConfidenceMetricsEntries(int index) {
      if (confidenceMetricsEntriesBuilder_ == null) {
        return confidenceMetricsEntries_.get(index);
      } else {
        return confidenceMetricsEntriesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * entries to draw PR graph.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry confidence_metrics_entries = 3;
     * </code>
     */
    public Builder setConfidenceMetricsEntries(
        int index, com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry value) {
      if (confidenceMetricsEntriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConfidenceMetricsEntriesIsMutable();
        confidenceMetricsEntries_.set(index, value);
        onChanged();
      } else {
        confidenceMetricsEntriesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * entries to draw PR graph.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry confidence_metrics_entries = 3;
     * </code>
     */
    public Builder setConfidenceMetricsEntries(
        int index,
        com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry.Builder
            builderForValue) {
      if (confidenceMetricsEntriesBuilder_ == null) {
        ensureConfidenceMetricsEntriesIsMutable();
        confidenceMetricsEntries_.set(index, builderForValue.build());
        onChanged();
      } else {
        confidenceMetricsEntriesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * entries to draw PR graph.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry confidence_metrics_entries = 3;
     * </code>
     */
    public Builder addConfidenceMetricsEntries(
        com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry value) {
      if (confidenceMetricsEntriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConfidenceMetricsEntriesIsMutable();
        confidenceMetricsEntries_.add(value);
        onChanged();
      } else {
        confidenceMetricsEntriesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * entries to draw PR graph.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry confidence_metrics_entries = 3;
     * </code>
     */
    public Builder addConfidenceMetricsEntries(
        int index, com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry value) {
      if (confidenceMetricsEntriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureConfidenceMetricsEntriesIsMutable();
        confidenceMetricsEntries_.add(index, value);
        onChanged();
      } else {
        confidenceMetricsEntriesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * entries to draw PR graph.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry confidence_metrics_entries = 3;
     * </code>
     */
    public Builder addConfidenceMetricsEntries(
        com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry.Builder
            builderForValue) {
      if (confidenceMetricsEntriesBuilder_ == null) {
        ensureConfidenceMetricsEntriesIsMutable();
        confidenceMetricsEntries_.add(builderForValue.build());
        onChanged();
      } else {
        confidenceMetricsEntriesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * entries to draw PR graph.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry confidence_metrics_entries = 3;
     * </code>
     */
    public Builder addConfidenceMetricsEntries(
        int index,
        com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry.Builder
            builderForValue) {
      if (confidenceMetricsEntriesBuilder_ == null) {
        ensureConfidenceMetricsEntriesIsMutable();
        confidenceMetricsEntries_.add(index, builderForValue.build());
        onChanged();
      } else {
        confidenceMetricsEntriesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * entries to draw PR graph.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry confidence_metrics_entries = 3;
     * </code>
     */
    public Builder addAllConfidenceMetricsEntries(
        java.lang.Iterable<
                ? extends com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry>
            values) {
      if (confidenceMetricsEntriesBuilder_ == null) {
        ensureConfidenceMetricsEntriesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, confidenceMetricsEntries_);
        onChanged();
      } else {
        confidenceMetricsEntriesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * entries to draw PR graph.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry confidence_metrics_entries = 3;
     * </code>
     */
    public Builder clearConfidenceMetricsEntries() {
      if (confidenceMetricsEntriesBuilder_ == null) {
        confidenceMetricsEntries_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        confidenceMetricsEntriesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * entries to draw PR graph.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry confidence_metrics_entries = 3;
     * </code>
     */
    public Builder removeConfidenceMetricsEntries(int index) {
      if (confidenceMetricsEntriesBuilder_ == null) {
        ensureConfidenceMetricsEntriesIsMutable();
        confidenceMetricsEntries_.remove(index);
        onChanged();
      } else {
        confidenceMetricsEntriesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * entries to draw PR graph.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry confidence_metrics_entries = 3;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry.Builder
        getConfidenceMetricsEntriesBuilder(int index) {
      return getConfidenceMetricsEntriesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * entries to draw PR graph.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry confidence_metrics_entries = 3;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntryOrBuilder
        getConfidenceMetricsEntriesOrBuilder(int index) {
      if (confidenceMetricsEntriesBuilder_ == null) {
        return confidenceMetricsEntries_.get(index);
      } else {
        return confidenceMetricsEntriesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * entries to draw PR graph.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry confidence_metrics_entries = 3;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntryOrBuilder>
        getConfidenceMetricsEntriesOrBuilderList() {
      if (confidenceMetricsEntriesBuilder_ != null) {
        return confidenceMetricsEntriesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(confidenceMetricsEntries_);
      }
    }
    /**
     *
     *
     * <pre>
     * entries to draw PR graph.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry confidence_metrics_entries = 3;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry.Builder
        addConfidenceMetricsEntriesBuilder() {
      return getConfidenceMetricsEntriesFieldBuilder()
          .addBuilder(
              com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * entries to draw PR graph.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry confidence_metrics_entries = 3;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry.Builder
        addConfidenceMetricsEntriesBuilder(int index) {
      return getConfidenceMetricsEntriesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * entries to draw PR graph.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry confidence_metrics_entries = 3;
     * </code>
     */
    public java.util.List<
            com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry.Builder>
        getConfidenceMetricsEntriesBuilderList() {
      return getConfidenceMetricsEntriesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry,
            com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry.Builder,
            com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntryOrBuilder>
        getConfidenceMetricsEntriesFieldBuilder() {
      if (confidenceMetricsEntriesBuilder_ == null) {
        confidenceMetricsEntriesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry,
                com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry.Builder,
                com.google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntryOrBuilder>(
                confidenceMetricsEntries_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        confidenceMetricsEntries_ = null;
      }
      return confidenceMetricsEntriesBuilder_;
    }

    private float meanAveragePrecision_;
    /**
     *
     *
     * <pre>
     * mean average prcision of this curve.
     * </pre>
     *
     * <code>float mean_average_precision = 4;</code>
     *
     * @return The meanAveragePrecision.
     */
    public float getMeanAveragePrecision() {
      return meanAveragePrecision_;
    }
    /**
     *
     *
     * <pre>
     * mean average prcision of this curve.
     * </pre>
     *
     * <code>float mean_average_precision = 4;</code>
     *
     * @param value The meanAveragePrecision to set.
     * @return This builder for chaining.
     */
    public Builder setMeanAveragePrecision(float value) {

      meanAveragePrecision_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * mean average prcision of this curve.
     * </pre>
     *
     * <code>float mean_average_precision = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMeanAveragePrecision() {

      meanAveragePrecision_ = 0F;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datalabeling.v1beta1.PrCurve)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datalabeling.v1beta1.PrCurve)
  private static final com.google.cloud.datalabeling.v1beta1.PrCurve DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datalabeling.v1beta1.PrCurve();
  }

  public static com.google.cloud.datalabeling.v1beta1.PrCurve getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PrCurve> PARSER =
      new com.google.protobuf.AbstractParser<PrCurve>() {
        @java.lang.Override
        public PrCurve parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new PrCurve(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<PrCurve> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PrCurve> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.PrCurve getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
