/*
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datalabeling/v1beta1/annotation.proto

package com.google.cloud.datalabeling.v1beta1;

/**
 *
 *
 * <pre>
 * Annotation for Example. Each example may have one or more annotations. For
 * example in image classification problem, each image might have one or more
 * labels. We call labels binded with this image an Annotation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.datalabeling.v1beta1.Annotation}
 */
public final class Annotation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datalabeling.v1beta1.Annotation)
    AnnotationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Annotation.newBuilder() to construct.
  private Annotation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Annotation() {
    name_ = "";
    annotationSource_ = 0;
    annotationSentiment_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Annotation();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private Annotation(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 16:
            {
              int rawValue = input.readEnum();

              annotationSource_ = rawValue;
              break;
            }
          case 26:
            {
              com.google.cloud.datalabeling.v1beta1.AnnotationValue.Builder subBuilder = null;
              if (annotationValue_ != null) {
                subBuilder = annotationValue_.toBuilder();
              }
              annotationValue_ =
                  input.readMessage(
                      com.google.cloud.datalabeling.v1beta1.AnnotationValue.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(annotationValue_);
                annotationValue_ = subBuilder.buildPartial();
              }

              break;
            }
          case 34:
            {
              com.google.cloud.datalabeling.v1beta1.AnnotationMetadata.Builder subBuilder = null;
              if (annotationMetadata_ != null) {
                subBuilder = annotationMetadata_.toBuilder();
              }
              annotationMetadata_ =
                  input.readMessage(
                      com.google.cloud.datalabeling.v1beta1.AnnotationMetadata.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(annotationMetadata_);
                annotationMetadata_ = subBuilder.buildPartial();
              }

              break;
            }
          case 48:
            {
              int rawValue = input.readEnum();

              annotationSentiment_ = rawValue;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datalabeling.v1beta1.AnnotationOuterClass
        .internal_static_google_cloud_datalabeling_v1beta1_Annotation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datalabeling.v1beta1.AnnotationOuterClass
        .internal_static_google_cloud_datalabeling_v1beta1_Annotation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datalabeling.v1beta1.Annotation.class,
            com.google.cloud.datalabeling.v1beta1.Annotation.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Output only. Unique name of this annotation, format is:
   * projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/{annotated_dataset}/examples/{example_id}/annotations/{annotation_id}
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Unique name of this annotation, format is:
   * projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/{annotated_dataset}/examples/{example_id}/annotations/{annotation_id}
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ANNOTATION_SOURCE_FIELD_NUMBER = 2;
  private int annotationSource_;
  /**
   *
   *
   * <pre>
   * Output only. The source of the annotation.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.AnnotationSource annotation_source = 2;</code>
   *
   * @return The enum numeric value on the wire for annotationSource.
   */
  public int getAnnotationSourceValue() {
    return annotationSource_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The source of the annotation.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.AnnotationSource annotation_source = 2;</code>
   *
   * @return The annotationSource.
   */
  public com.google.cloud.datalabeling.v1beta1.AnnotationSource getAnnotationSource() {
    @SuppressWarnings("deprecation")
    com.google.cloud.datalabeling.v1beta1.AnnotationSource result =
        com.google.cloud.datalabeling.v1beta1.AnnotationSource.valueOf(annotationSource_);
    return result == null
        ? com.google.cloud.datalabeling.v1beta1.AnnotationSource.UNRECOGNIZED
        : result;
  }

  public static final int ANNOTATION_VALUE_FIELD_NUMBER = 3;
  private com.google.cloud.datalabeling.v1beta1.AnnotationValue annotationValue_;
  /**
   *
   *
   * <pre>
   * Output only. This is the actual annotation value, e.g classification,
   * bounding box values are stored here.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.AnnotationValue annotation_value = 3;</code>
   *
   * @return Whether the annotationValue field is set.
   */
  public boolean hasAnnotationValue() {
    return annotationValue_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. This is the actual annotation value, e.g classification,
   * bounding box values are stored here.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.AnnotationValue annotation_value = 3;</code>
   *
   * @return The annotationValue.
   */
  public com.google.cloud.datalabeling.v1beta1.AnnotationValue getAnnotationValue() {
    return annotationValue_ == null
        ? com.google.cloud.datalabeling.v1beta1.AnnotationValue.getDefaultInstance()
        : annotationValue_;
  }
  /**
   *
   *
   * <pre>
   * Output only. This is the actual annotation value, e.g classification,
   * bounding box values are stored here.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.AnnotationValue annotation_value = 3;</code>
   */
  public com.google.cloud.datalabeling.v1beta1.AnnotationValueOrBuilder
      getAnnotationValueOrBuilder() {
    return getAnnotationValue();
  }

  public static final int ANNOTATION_METADATA_FIELD_NUMBER = 4;
  private com.google.cloud.datalabeling.v1beta1.AnnotationMetadata annotationMetadata_;
  /**
   *
   *
   * <pre>
   * Output only. Annotation metadata, including information like votes
   * for labels.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.AnnotationMetadata annotation_metadata = 4;</code>
   *
   * @return Whether the annotationMetadata field is set.
   */
  public boolean hasAnnotationMetadata() {
    return annotationMetadata_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Annotation metadata, including information like votes
   * for labels.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.AnnotationMetadata annotation_metadata = 4;</code>
   *
   * @return The annotationMetadata.
   */
  public com.google.cloud.datalabeling.v1beta1.AnnotationMetadata getAnnotationMetadata() {
    return annotationMetadata_ == null
        ? com.google.cloud.datalabeling.v1beta1.AnnotationMetadata.getDefaultInstance()
        : annotationMetadata_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Annotation metadata, including information like votes
   * for labels.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.AnnotationMetadata annotation_metadata = 4;</code>
   */
  public com.google.cloud.datalabeling.v1beta1.AnnotationMetadataOrBuilder
      getAnnotationMetadataOrBuilder() {
    return getAnnotationMetadata();
  }

  public static final int ANNOTATION_SENTIMENT_FIELD_NUMBER = 6;
  private int annotationSentiment_;
  /**
   *
   *
   * <pre>
   * Output only. Sentiment for this annotation.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.AnnotationSentiment annotation_sentiment = 6;</code>
   *
   * @return The enum numeric value on the wire for annotationSentiment.
   */
  public int getAnnotationSentimentValue() {
    return annotationSentiment_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Sentiment for this annotation.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.AnnotationSentiment annotation_sentiment = 6;</code>
   *
   * @return The annotationSentiment.
   */
  public com.google.cloud.datalabeling.v1beta1.AnnotationSentiment getAnnotationSentiment() {
    @SuppressWarnings("deprecation")
    com.google.cloud.datalabeling.v1beta1.AnnotationSentiment result =
        com.google.cloud.datalabeling.v1beta1.AnnotationSentiment.valueOf(annotationSentiment_);
    return result == null
        ? com.google.cloud.datalabeling.v1beta1.AnnotationSentiment.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (annotationSource_
        != com.google.cloud.datalabeling.v1beta1.AnnotationSource.ANNOTATION_SOURCE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, annotationSource_);
    }
    if (annotationValue_ != null) {
      output.writeMessage(3, getAnnotationValue());
    }
    if (annotationMetadata_ != null) {
      output.writeMessage(4, getAnnotationMetadata());
    }
    if (annotationSentiment_
        != com.google.cloud.datalabeling.v1beta1.AnnotationSentiment
            .ANNOTATION_SENTIMENT_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(6, annotationSentiment_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (annotationSource_
        != com.google.cloud.datalabeling.v1beta1.AnnotationSource.ANNOTATION_SOURCE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, annotationSource_);
    }
    if (annotationValue_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getAnnotationValue());
    }
    if (annotationMetadata_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getAnnotationMetadata());
    }
    if (annotationSentiment_
        != com.google.cloud.datalabeling.v1beta1.AnnotationSentiment
            .ANNOTATION_SENTIMENT_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, annotationSentiment_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datalabeling.v1beta1.Annotation)) {
      return super.equals(obj);
    }
    com.google.cloud.datalabeling.v1beta1.Annotation other =
        (com.google.cloud.datalabeling.v1beta1.Annotation) obj;

    if (!getName().equals(other.getName())) return false;
    if (annotationSource_ != other.annotationSource_) return false;
    if (hasAnnotationValue() != other.hasAnnotationValue()) return false;
    if (hasAnnotationValue()) {
      if (!getAnnotationValue().equals(other.getAnnotationValue())) return false;
    }
    if (hasAnnotationMetadata() != other.hasAnnotationMetadata()) return false;
    if (hasAnnotationMetadata()) {
      if (!getAnnotationMetadata().equals(other.getAnnotationMetadata())) return false;
    }
    if (annotationSentiment_ != other.annotationSentiment_) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + ANNOTATION_SOURCE_FIELD_NUMBER;
    hash = (53 * hash) + annotationSource_;
    if (hasAnnotationValue()) {
      hash = (37 * hash) + ANNOTATION_VALUE_FIELD_NUMBER;
      hash = (53 * hash) + getAnnotationValue().hashCode();
    }
    if (hasAnnotationMetadata()) {
      hash = (37 * hash) + ANNOTATION_METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getAnnotationMetadata().hashCode();
    }
    hash = (37 * hash) + ANNOTATION_SENTIMENT_FIELD_NUMBER;
    hash = (53 * hash) + annotationSentiment_;
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datalabeling.v1beta1.Annotation parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.Annotation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.Annotation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.Annotation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.Annotation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.Annotation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.Annotation parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.Annotation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.Annotation parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.Annotation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.Annotation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.Annotation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.datalabeling.v1beta1.Annotation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Annotation for Example. Each example may have one or more annotations. For
   * example in image classification problem, each image might have one or more
   * labels. We call labels binded with this image an Annotation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datalabeling.v1beta1.Annotation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datalabeling.v1beta1.Annotation)
      com.google.cloud.datalabeling.v1beta1.AnnotationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datalabeling.v1beta1.AnnotationOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_Annotation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datalabeling.v1beta1.AnnotationOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_Annotation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datalabeling.v1beta1.Annotation.class,
              com.google.cloud.datalabeling.v1beta1.Annotation.Builder.class);
    }

    // Construct using com.google.cloud.datalabeling.v1beta1.Annotation.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      annotationSource_ = 0;

      if (annotationValueBuilder_ == null) {
        annotationValue_ = null;
      } else {
        annotationValue_ = null;
        annotationValueBuilder_ = null;
      }
      if (annotationMetadataBuilder_ == null) {
        annotationMetadata_ = null;
      } else {
        annotationMetadata_ = null;
        annotationMetadataBuilder_ = null;
      }
      annotationSentiment_ = 0;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datalabeling.v1beta1.AnnotationOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_Annotation_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.Annotation getDefaultInstanceForType() {
      return com.google.cloud.datalabeling.v1beta1.Annotation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.Annotation build() {
      com.google.cloud.datalabeling.v1beta1.Annotation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.Annotation buildPartial() {
      com.google.cloud.datalabeling.v1beta1.Annotation result =
          new com.google.cloud.datalabeling.v1beta1.Annotation(this);
      result.name_ = name_;
      result.annotationSource_ = annotationSource_;
      if (annotationValueBuilder_ == null) {
        result.annotationValue_ = annotationValue_;
      } else {
        result.annotationValue_ = annotationValueBuilder_.build();
      }
      if (annotationMetadataBuilder_ == null) {
        result.annotationMetadata_ = annotationMetadata_;
      } else {
        result.annotationMetadata_ = annotationMetadataBuilder_.build();
      }
      result.annotationSentiment_ = annotationSentiment_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datalabeling.v1beta1.Annotation) {
        return mergeFrom((com.google.cloud.datalabeling.v1beta1.Annotation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datalabeling.v1beta1.Annotation other) {
      if (other == com.google.cloud.datalabeling.v1beta1.Annotation.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (other.annotationSource_ != 0) {
        setAnnotationSourceValue(other.getAnnotationSourceValue());
      }
      if (other.hasAnnotationValue()) {
        mergeAnnotationValue(other.getAnnotationValue());
      }
      if (other.hasAnnotationMetadata()) {
        mergeAnnotationMetadata(other.getAnnotationMetadata());
      }
      if (other.annotationSentiment_ != 0) {
        setAnnotationSentimentValue(other.getAnnotationSentimentValue());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.datalabeling.v1beta1.Annotation parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.datalabeling.v1beta1.Annotation) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Unique name of this annotation, format is:
     * projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/{annotated_dataset}/examples/{example_id}/annotations/{annotation_id}
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique name of this annotation, format is:
     * projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/{annotated_dataset}/examples/{example_id}/annotations/{annotation_id}
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique name of this annotation, format is:
     * projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/{annotated_dataset}/examples/{example_id}/annotations/{annotation_id}
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique name of this annotation, format is:
     * projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/{annotated_dataset}/examples/{example_id}/annotations/{annotation_id}
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique name of this annotation, format is:
     * projects/{project_id}/datasets/{dataset_id}/annotatedDatasets/{annotated_dataset}/examples/{example_id}/annotations/{annotation_id}
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private int annotationSource_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The source of the annotation.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSource annotation_source = 2;</code>
     *
     * @return The enum numeric value on the wire for annotationSource.
     */
    public int getAnnotationSourceValue() {
      return annotationSource_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The source of the annotation.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSource annotation_source = 2;</code>
     *
     * @param value The enum numeric value on the wire for annotationSource to set.
     * @return This builder for chaining.
     */
    public Builder setAnnotationSourceValue(int value) {
      annotationSource_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The source of the annotation.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSource annotation_source = 2;</code>
     *
     * @return The annotationSource.
     */
    public com.google.cloud.datalabeling.v1beta1.AnnotationSource getAnnotationSource() {
      @SuppressWarnings("deprecation")
      com.google.cloud.datalabeling.v1beta1.AnnotationSource result =
          com.google.cloud.datalabeling.v1beta1.AnnotationSource.valueOf(annotationSource_);
      return result == null
          ? com.google.cloud.datalabeling.v1beta1.AnnotationSource.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The source of the annotation.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSource annotation_source = 2;</code>
     *
     * @param value The annotationSource to set.
     * @return This builder for chaining.
     */
    public Builder setAnnotationSource(
        com.google.cloud.datalabeling.v1beta1.AnnotationSource value) {
      if (value == null) {
        throw new NullPointerException();
      }

      annotationSource_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The source of the annotation.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSource annotation_source = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAnnotationSource() {

      annotationSource_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.datalabeling.v1beta1.AnnotationValue annotationValue_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.AnnotationValue,
            com.google.cloud.datalabeling.v1beta1.AnnotationValue.Builder,
            com.google.cloud.datalabeling.v1beta1.AnnotationValueOrBuilder>
        annotationValueBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. This is the actual annotation value, e.g classification,
     * bounding box values are stored here.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationValue annotation_value = 3;</code>
     *
     * @return Whether the annotationValue field is set.
     */
    public boolean hasAnnotationValue() {
      return annotationValueBuilder_ != null || annotationValue_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. This is the actual annotation value, e.g classification,
     * bounding box values are stored here.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationValue annotation_value = 3;</code>
     *
     * @return The annotationValue.
     */
    public com.google.cloud.datalabeling.v1beta1.AnnotationValue getAnnotationValue() {
      if (annotationValueBuilder_ == null) {
        return annotationValue_ == null
            ? com.google.cloud.datalabeling.v1beta1.AnnotationValue.getDefaultInstance()
            : annotationValue_;
      } else {
        return annotationValueBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. This is the actual annotation value, e.g classification,
     * bounding box values are stored here.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationValue annotation_value = 3;</code>
     */
    public Builder setAnnotationValue(com.google.cloud.datalabeling.v1beta1.AnnotationValue value) {
      if (annotationValueBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        annotationValue_ = value;
        onChanged();
      } else {
        annotationValueBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. This is the actual annotation value, e.g classification,
     * bounding box values are stored here.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationValue annotation_value = 3;</code>
     */
    public Builder setAnnotationValue(
        com.google.cloud.datalabeling.v1beta1.AnnotationValue.Builder builderForValue) {
      if (annotationValueBuilder_ == null) {
        annotationValue_ = builderForValue.build();
        onChanged();
      } else {
        annotationValueBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. This is the actual annotation value, e.g classification,
     * bounding box values are stored here.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationValue annotation_value = 3;</code>
     */
    public Builder mergeAnnotationValue(
        com.google.cloud.datalabeling.v1beta1.AnnotationValue value) {
      if (annotationValueBuilder_ == null) {
        if (annotationValue_ != null) {
          annotationValue_ =
              com.google.cloud.datalabeling.v1beta1.AnnotationValue.newBuilder(annotationValue_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          annotationValue_ = value;
        }
        onChanged();
      } else {
        annotationValueBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. This is the actual annotation value, e.g classification,
     * bounding box values are stored here.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationValue annotation_value = 3;</code>
     */
    public Builder clearAnnotationValue() {
      if (annotationValueBuilder_ == null) {
        annotationValue_ = null;
        onChanged();
      } else {
        annotationValue_ = null;
        annotationValueBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. This is the actual annotation value, e.g classification,
     * bounding box values are stored here.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationValue annotation_value = 3;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.AnnotationValue.Builder
        getAnnotationValueBuilder() {

      onChanged();
      return getAnnotationValueFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. This is the actual annotation value, e.g classification,
     * bounding box values are stored here.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationValue annotation_value = 3;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.AnnotationValueOrBuilder
        getAnnotationValueOrBuilder() {
      if (annotationValueBuilder_ != null) {
        return annotationValueBuilder_.getMessageOrBuilder();
      } else {
        return annotationValue_ == null
            ? com.google.cloud.datalabeling.v1beta1.AnnotationValue.getDefaultInstance()
            : annotationValue_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. This is the actual annotation value, e.g classification,
     * bounding box values are stored here.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationValue annotation_value = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.AnnotationValue,
            com.google.cloud.datalabeling.v1beta1.AnnotationValue.Builder,
            com.google.cloud.datalabeling.v1beta1.AnnotationValueOrBuilder>
        getAnnotationValueFieldBuilder() {
      if (annotationValueBuilder_ == null) {
        annotationValueBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.AnnotationValue,
                com.google.cloud.datalabeling.v1beta1.AnnotationValue.Builder,
                com.google.cloud.datalabeling.v1beta1.AnnotationValueOrBuilder>(
                getAnnotationValue(), getParentForChildren(), isClean());
        annotationValue_ = null;
      }
      return annotationValueBuilder_;
    }

    private com.google.cloud.datalabeling.v1beta1.AnnotationMetadata annotationMetadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.AnnotationMetadata,
            com.google.cloud.datalabeling.v1beta1.AnnotationMetadata.Builder,
            com.google.cloud.datalabeling.v1beta1.AnnotationMetadataOrBuilder>
        annotationMetadataBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Annotation metadata, including information like votes
     * for labels.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationMetadata annotation_metadata = 4;</code>
     *
     * @return Whether the annotationMetadata field is set.
     */
    public boolean hasAnnotationMetadata() {
      return annotationMetadataBuilder_ != null || annotationMetadata_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Annotation metadata, including information like votes
     * for labels.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationMetadata annotation_metadata = 4;</code>
     *
     * @return The annotationMetadata.
     */
    public com.google.cloud.datalabeling.v1beta1.AnnotationMetadata getAnnotationMetadata() {
      if (annotationMetadataBuilder_ == null) {
        return annotationMetadata_ == null
            ? com.google.cloud.datalabeling.v1beta1.AnnotationMetadata.getDefaultInstance()
            : annotationMetadata_;
      } else {
        return annotationMetadataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Annotation metadata, including information like votes
     * for labels.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationMetadata annotation_metadata = 4;</code>
     */
    public Builder setAnnotationMetadata(
        com.google.cloud.datalabeling.v1beta1.AnnotationMetadata value) {
      if (annotationMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        annotationMetadata_ = value;
        onChanged();
      } else {
        annotationMetadataBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Annotation metadata, including information like votes
     * for labels.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationMetadata annotation_metadata = 4;</code>
     */
    public Builder setAnnotationMetadata(
        com.google.cloud.datalabeling.v1beta1.AnnotationMetadata.Builder builderForValue) {
      if (annotationMetadataBuilder_ == null) {
        annotationMetadata_ = builderForValue.build();
        onChanged();
      } else {
        annotationMetadataBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Annotation metadata, including information like votes
     * for labels.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationMetadata annotation_metadata = 4;</code>
     */
    public Builder mergeAnnotationMetadata(
        com.google.cloud.datalabeling.v1beta1.AnnotationMetadata value) {
      if (annotationMetadataBuilder_ == null) {
        if (annotationMetadata_ != null) {
          annotationMetadata_ =
              com.google.cloud.datalabeling.v1beta1.AnnotationMetadata.newBuilder(
                      annotationMetadata_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          annotationMetadata_ = value;
        }
        onChanged();
      } else {
        annotationMetadataBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Annotation metadata, including information like votes
     * for labels.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationMetadata annotation_metadata = 4;</code>
     */
    public Builder clearAnnotationMetadata() {
      if (annotationMetadataBuilder_ == null) {
        annotationMetadata_ = null;
        onChanged();
      } else {
        annotationMetadata_ = null;
        annotationMetadataBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Annotation metadata, including information like votes
     * for labels.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationMetadata annotation_metadata = 4;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.AnnotationMetadata.Builder
        getAnnotationMetadataBuilder() {

      onChanged();
      return getAnnotationMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Annotation metadata, including information like votes
     * for labels.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationMetadata annotation_metadata = 4;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.AnnotationMetadataOrBuilder
        getAnnotationMetadataOrBuilder() {
      if (annotationMetadataBuilder_ != null) {
        return annotationMetadataBuilder_.getMessageOrBuilder();
      } else {
        return annotationMetadata_ == null
            ? com.google.cloud.datalabeling.v1beta1.AnnotationMetadata.getDefaultInstance()
            : annotationMetadata_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Annotation metadata, including information like votes
     * for labels.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationMetadata annotation_metadata = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.AnnotationMetadata,
            com.google.cloud.datalabeling.v1beta1.AnnotationMetadata.Builder,
            com.google.cloud.datalabeling.v1beta1.AnnotationMetadataOrBuilder>
        getAnnotationMetadataFieldBuilder() {
      if (annotationMetadataBuilder_ == null) {
        annotationMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.AnnotationMetadata,
                com.google.cloud.datalabeling.v1beta1.AnnotationMetadata.Builder,
                com.google.cloud.datalabeling.v1beta1.AnnotationMetadataOrBuilder>(
                getAnnotationMetadata(), getParentForChildren(), isClean());
        annotationMetadata_ = null;
      }
      return annotationMetadataBuilder_;
    }

    private int annotationSentiment_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. Sentiment for this annotation.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSentiment annotation_sentiment = 6;</code>
     *
     * @return The enum numeric value on the wire for annotationSentiment.
     */
    public int getAnnotationSentimentValue() {
      return annotationSentiment_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Sentiment for this annotation.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSentiment annotation_sentiment = 6;</code>
     *
     * @param value The enum numeric value on the wire for annotationSentiment to set.
     * @return This builder for chaining.
     */
    public Builder setAnnotationSentimentValue(int value) {
      annotationSentiment_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Sentiment for this annotation.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSentiment annotation_sentiment = 6;</code>
     *
     * @return The annotationSentiment.
     */
    public com.google.cloud.datalabeling.v1beta1.AnnotationSentiment getAnnotationSentiment() {
      @SuppressWarnings("deprecation")
      com.google.cloud.datalabeling.v1beta1.AnnotationSentiment result =
          com.google.cloud.datalabeling.v1beta1.AnnotationSentiment.valueOf(annotationSentiment_);
      return result == null
          ? com.google.cloud.datalabeling.v1beta1.AnnotationSentiment.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. Sentiment for this annotation.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSentiment annotation_sentiment = 6;</code>
     *
     * @param value The annotationSentiment to set.
     * @return This builder for chaining.
     */
    public Builder setAnnotationSentiment(
        com.google.cloud.datalabeling.v1beta1.AnnotationSentiment value) {
      if (value == null) {
        throw new NullPointerException();
      }

      annotationSentiment_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Sentiment for this annotation.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSentiment annotation_sentiment = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAnnotationSentiment() {

      annotationSentiment_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datalabeling.v1beta1.Annotation)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datalabeling.v1beta1.Annotation)
  private static final com.google.cloud.datalabeling.v1beta1.Annotation DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datalabeling.v1beta1.Annotation();
  }

  public static com.google.cloud.datalabeling.v1beta1.Annotation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Annotation> PARSER =
      new com.google.protobuf.AbstractParser<Annotation>() {
        @java.lang.Override
        public Annotation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Annotation(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<Annotation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Annotation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.Annotation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
