/*
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datalabeling/v1beta1/human_annotation_config.proto

package com.google.cloud.datalabeling.v1beta1;

/**
 *
 *
 * <pre>
 * Configuration for how human labeling task should be done.
 * </pre>
 *
 * Protobuf type {@code google.cloud.datalabeling.v1beta1.HumanAnnotationConfig}
 */
public final class HumanAnnotationConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datalabeling.v1beta1.HumanAnnotationConfig)
    HumanAnnotationConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use HumanAnnotationConfig.newBuilder() to construct.
  private HumanAnnotationConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private HumanAnnotationConfig() {
    instruction_ = "";
    annotatedDatasetDisplayName_ = "";
    annotatedDatasetDescription_ = "";
    labelGroup_ = "";
    languageCode_ = "";
    contributorEmails_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    userEmailAddress_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new HumanAnnotationConfig();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private HumanAnnotationConfig(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              instruction_ = s;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();

              annotatedDatasetDisplayName_ = s;
              break;
            }
          case 26:
            {
              java.lang.String s = input.readStringRequireUtf8();

              annotatedDatasetDescription_ = s;
              break;
            }
          case 34:
            {
              java.lang.String s = input.readStringRequireUtf8();

              labelGroup_ = s;
              break;
            }
          case 42:
            {
              java.lang.String s = input.readStringRequireUtf8();

              languageCode_ = s;
              break;
            }
          case 48:
            {
              replicaCount_ = input.readInt32();
              break;
            }
          case 58:
            {
              com.google.protobuf.Duration.Builder subBuilder = null;
              if (questionDuration_ != null) {
                subBuilder = questionDuration_.toBuilder();
              }
              questionDuration_ =
                  input.readMessage(com.google.protobuf.Duration.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(questionDuration_);
                questionDuration_ = subBuilder.buildPartial();
              }

              break;
            }
          case 74:
            {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                contributorEmails_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000001;
              }
              contributorEmails_.add(s);
              break;
            }
          case 82:
            {
              java.lang.String s = input.readStringRequireUtf8();

              userEmailAddress_ = s;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        contributorEmails_ = contributorEmails_.getUnmodifiableView();
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfigOuterClass
        .internal_static_google_cloud_datalabeling_v1beta1_HumanAnnotationConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfigOuterClass
        .internal_static_google_cloud_datalabeling_v1beta1_HumanAnnotationConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.class,
            com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.Builder.class);
  }

  public static final int INSTRUCTION_FIELD_NUMBER = 1;
  private volatile java.lang.Object instruction_;
  /**
   *
   *
   * <pre>
   * Required. Instruction resource name.
   * </pre>
   *
   * <code>string instruction = 1;</code>
   *
   * @return The instruction.
   */
  public java.lang.String getInstruction() {
    java.lang.Object ref = instruction_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      instruction_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Instruction resource name.
   * </pre>
   *
   * <code>string instruction = 1;</code>
   *
   * @return The bytes for instruction.
   */
  public com.google.protobuf.ByteString getInstructionBytes() {
    java.lang.Object ref = instruction_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      instruction_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ANNOTATED_DATASET_DISPLAY_NAME_FIELD_NUMBER = 2;
  private volatile java.lang.Object annotatedDatasetDisplayName_;
  /**
   *
   *
   * <pre>
   * Required. A human-readable name for AnnotatedDataset defined by
   * users. Maximum of 64 characters
   * .
   * </pre>
   *
   * <code>string annotated_dataset_display_name = 2;</code>
   *
   * @return The annotatedDatasetDisplayName.
   */
  public java.lang.String getAnnotatedDatasetDisplayName() {
    java.lang.Object ref = annotatedDatasetDisplayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      annotatedDatasetDisplayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. A human-readable name for AnnotatedDataset defined by
   * users. Maximum of 64 characters
   * .
   * </pre>
   *
   * <code>string annotated_dataset_display_name = 2;</code>
   *
   * @return The bytes for annotatedDatasetDisplayName.
   */
  public com.google.protobuf.ByteString getAnnotatedDatasetDisplayNameBytes() {
    java.lang.Object ref = annotatedDatasetDisplayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      annotatedDatasetDisplayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ANNOTATED_DATASET_DESCRIPTION_FIELD_NUMBER = 3;
  private volatile java.lang.Object annotatedDatasetDescription_;
  /**
   *
   *
   * <pre>
   * Optional. A human-readable description for AnnotatedDataset.
   * The description can be up to 10000 characters long.
   * </pre>
   *
   * <code>string annotated_dataset_description = 3;</code>
   *
   * @return The annotatedDatasetDescription.
   */
  public java.lang.String getAnnotatedDatasetDescription() {
    java.lang.Object ref = annotatedDatasetDescription_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      annotatedDatasetDescription_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. A human-readable description for AnnotatedDataset.
   * The description can be up to 10000 characters long.
   * </pre>
   *
   * <code>string annotated_dataset_description = 3;</code>
   *
   * @return The bytes for annotatedDatasetDescription.
   */
  public com.google.protobuf.ByteString getAnnotatedDatasetDescriptionBytes() {
    java.lang.Object ref = annotatedDatasetDescription_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      annotatedDatasetDescription_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABEL_GROUP_FIELD_NUMBER = 4;
  private volatile java.lang.Object labelGroup_;
  /**
   *
   *
   * <pre>
   * Optional. A human-readable label used to logically group labeling tasks.
   * This string must match the regular expression `[a-zA-Z&#92;&#92;d_-]{0,128}`.
   * </pre>
   *
   * <code>string label_group = 4;</code>
   *
   * @return The labelGroup.
   */
  public java.lang.String getLabelGroup() {
    java.lang.Object ref = labelGroup_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      labelGroup_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. A human-readable label used to logically group labeling tasks.
   * This string must match the regular expression `[a-zA-Z&#92;&#92;d_-]{0,128}`.
   * </pre>
   *
   * <code>string label_group = 4;</code>
   *
   * @return The bytes for labelGroup.
   */
  public com.google.protobuf.ByteString getLabelGroupBytes() {
    java.lang.Object ref = labelGroup_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      labelGroup_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LANGUAGE_CODE_FIELD_NUMBER = 5;
  private volatile java.lang.Object languageCode_;
  /**
   *
   *
   * <pre>
   * Optional. The Language of this question, as a
   * [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
   * Default value is en-US.
   * Only need to set this when task is language related. For example, French
   * text classification.
   * </pre>
   *
   * <code>string language_code = 5;</code>
   *
   * @return The languageCode.
   */
  public java.lang.String getLanguageCode() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      languageCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. The Language of this question, as a
   * [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
   * Default value is en-US.
   * Only need to set this when task is language related. For example, French
   * text classification.
   * </pre>
   *
   * <code>string language_code = 5;</code>
   *
   * @return The bytes for languageCode.
   */
  public com.google.protobuf.ByteString getLanguageCodeBytes() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      languageCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REPLICA_COUNT_FIELD_NUMBER = 6;
  private int replicaCount_;
  /**
   *
   *
   * <pre>
   * Optional. Replication of questions. Each question will be sent to up to
   * this number of contributors to label. Aggregated answers will be returned.
   * Default is set to 1.
   * For image related labeling, valid values are 1, 3, 5.
   * </pre>
   *
   * <code>int32 replica_count = 6;</code>
   *
   * @return The replicaCount.
   */
  public int getReplicaCount() {
    return replicaCount_;
  }

  public static final int QUESTION_DURATION_FIELD_NUMBER = 7;
  private com.google.protobuf.Duration questionDuration_;
  /**
   *
   *
   * <pre>
   * Optional. Maximum duration for contributors to answer a question. Default
   * is 1800 seconds.
   * </pre>
   *
   * <code>.google.protobuf.Duration question_duration = 7;</code>
   *
   * @return Whether the questionDuration field is set.
   */
  public boolean hasQuestionDuration() {
    return questionDuration_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Maximum duration for contributors to answer a question. Default
   * is 1800 seconds.
   * </pre>
   *
   * <code>.google.protobuf.Duration question_duration = 7;</code>
   *
   * @return The questionDuration.
   */
  public com.google.protobuf.Duration getQuestionDuration() {
    return questionDuration_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : questionDuration_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Maximum duration for contributors to answer a question. Default
   * is 1800 seconds.
   * </pre>
   *
   * <code>.google.protobuf.Duration question_duration = 7;</code>
   */
  public com.google.protobuf.DurationOrBuilder getQuestionDurationOrBuilder() {
    return getQuestionDuration();
  }

  public static final int CONTRIBUTOR_EMAILS_FIELD_NUMBER = 9;
  private com.google.protobuf.LazyStringList contributorEmails_;
  /**
   *
   *
   * <pre>
   * Optional. If you want your own labeling contributors to manage and work on
   * this labeling request, you can set these contributors here. We will give
   * them access to the question types in crowdcompute. Note that these
   * emails must be registered in crowdcompute worker UI:
   * https://crowd-compute.appspot.com/
   * </pre>
   *
   * <code>repeated string contributor_emails = 9;</code>
   *
   * @return A list containing the contributorEmails.
   */
  public com.google.protobuf.ProtocolStringList getContributorEmailsList() {
    return contributorEmails_;
  }
  /**
   *
   *
   * <pre>
   * Optional. If you want your own labeling contributors to manage and work on
   * this labeling request, you can set these contributors here. We will give
   * them access to the question types in crowdcompute. Note that these
   * emails must be registered in crowdcompute worker UI:
   * https://crowd-compute.appspot.com/
   * </pre>
   *
   * <code>repeated string contributor_emails = 9;</code>
   *
   * @return The count of contributorEmails.
   */
  public int getContributorEmailsCount() {
    return contributorEmails_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. If you want your own labeling contributors to manage and work on
   * this labeling request, you can set these contributors here. We will give
   * them access to the question types in crowdcompute. Note that these
   * emails must be registered in crowdcompute worker UI:
   * https://crowd-compute.appspot.com/
   * </pre>
   *
   * <code>repeated string contributor_emails = 9;</code>
   *
   * @param index The index of the element to return.
   * @return The contributorEmails at the given index.
   */
  public java.lang.String getContributorEmails(int index) {
    return contributorEmails_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. If you want your own labeling contributors to manage and work on
   * this labeling request, you can set these contributors here. We will give
   * them access to the question types in crowdcompute. Note that these
   * emails must be registered in crowdcompute worker UI:
   * https://crowd-compute.appspot.com/
   * </pre>
   *
   * <code>repeated string contributor_emails = 9;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the contributorEmails at the given index.
   */
  public com.google.protobuf.ByteString getContributorEmailsBytes(int index) {
    return contributorEmails_.getByteString(index);
  }

  public static final int USER_EMAIL_ADDRESS_FIELD_NUMBER = 10;
  private volatile java.lang.Object userEmailAddress_;
  /**
   *
   *
   * <pre>
   * Email of the user who started the labeling task and should be notified by
   * email. If empty no notification will be sent.
   * </pre>
   *
   * <code>string user_email_address = 10;</code>
   *
   * @return The userEmailAddress.
   */
  public java.lang.String getUserEmailAddress() {
    java.lang.Object ref = userEmailAddress_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      userEmailAddress_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Email of the user who started the labeling task and should be notified by
   * email. If empty no notification will be sent.
   * </pre>
   *
   * <code>string user_email_address = 10;</code>
   *
   * @return The bytes for userEmailAddress.
   */
  public com.google.protobuf.ByteString getUserEmailAddressBytes() {
    java.lang.Object ref = userEmailAddress_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      userEmailAddress_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getInstructionBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, instruction_);
    }
    if (!getAnnotatedDatasetDisplayNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, annotatedDatasetDisplayName_);
    }
    if (!getAnnotatedDatasetDescriptionBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, annotatedDatasetDescription_);
    }
    if (!getLabelGroupBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, labelGroup_);
    }
    if (!getLanguageCodeBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, languageCode_);
    }
    if (replicaCount_ != 0) {
      output.writeInt32(6, replicaCount_);
    }
    if (questionDuration_ != null) {
      output.writeMessage(7, getQuestionDuration());
    }
    for (int i = 0; i < contributorEmails_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, contributorEmails_.getRaw(i));
    }
    if (!getUserEmailAddressBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, userEmailAddress_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getInstructionBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, instruction_);
    }
    if (!getAnnotatedDatasetDisplayNameBytes().isEmpty()) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(2, annotatedDatasetDisplayName_);
    }
    if (!getAnnotatedDatasetDescriptionBytes().isEmpty()) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(3, annotatedDatasetDescription_);
    }
    if (!getLabelGroupBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, labelGroup_);
    }
    if (!getLanguageCodeBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, languageCode_);
    }
    if (replicaCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(6, replicaCount_);
    }
    if (questionDuration_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getQuestionDuration());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < contributorEmails_.size(); i++) {
        dataSize += computeStringSizeNoTag(contributorEmails_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getContributorEmailsList().size();
    }
    if (!getUserEmailAddressBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, userEmailAddress_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig other =
        (com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig) obj;

    if (!getInstruction().equals(other.getInstruction())) return false;
    if (!getAnnotatedDatasetDisplayName().equals(other.getAnnotatedDatasetDisplayName()))
      return false;
    if (!getAnnotatedDatasetDescription().equals(other.getAnnotatedDatasetDescription()))
      return false;
    if (!getLabelGroup().equals(other.getLabelGroup())) return false;
    if (!getLanguageCode().equals(other.getLanguageCode())) return false;
    if (getReplicaCount() != other.getReplicaCount()) return false;
    if (hasQuestionDuration() != other.hasQuestionDuration()) return false;
    if (hasQuestionDuration()) {
      if (!getQuestionDuration().equals(other.getQuestionDuration())) return false;
    }
    if (!getContributorEmailsList().equals(other.getContributorEmailsList())) return false;
    if (!getUserEmailAddress().equals(other.getUserEmailAddress())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + INSTRUCTION_FIELD_NUMBER;
    hash = (53 * hash) + getInstruction().hashCode();
    hash = (37 * hash) + ANNOTATED_DATASET_DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getAnnotatedDatasetDisplayName().hashCode();
    hash = (37 * hash) + ANNOTATED_DATASET_DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getAnnotatedDatasetDescription().hashCode();
    hash = (37 * hash) + LABEL_GROUP_FIELD_NUMBER;
    hash = (53 * hash) + getLabelGroup().hashCode();
    hash = (37 * hash) + LANGUAGE_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getLanguageCode().hashCode();
    hash = (37 * hash) + REPLICA_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getReplicaCount();
    if (hasQuestionDuration()) {
      hash = (37 * hash) + QUESTION_DURATION_FIELD_NUMBER;
      hash = (53 * hash) + getQuestionDuration().hashCode();
    }
    if (getContributorEmailsCount() > 0) {
      hash = (37 * hash) + CONTRIBUTOR_EMAILS_FIELD_NUMBER;
      hash = (53 * hash) + getContributorEmailsList().hashCode();
    }
    hash = (37 * hash) + USER_EMAIL_ADDRESS_FIELD_NUMBER;
    hash = (53 * hash) + getUserEmailAddress().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Configuration for how human labeling task should be done.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datalabeling.v1beta1.HumanAnnotationConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datalabeling.v1beta1.HumanAnnotationConfig)
      com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfigOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_HumanAnnotationConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfigOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_HumanAnnotationConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.class,
              com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.Builder.class);
    }

    // Construct using com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      instruction_ = "";

      annotatedDatasetDisplayName_ = "";

      annotatedDatasetDescription_ = "";

      labelGroup_ = "";

      languageCode_ = "";

      replicaCount_ = 0;

      if (questionDurationBuilder_ == null) {
        questionDuration_ = null;
      } else {
        questionDuration_ = null;
        questionDurationBuilder_ = null;
      }
      contributorEmails_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      userEmailAddress_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfigOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_HumanAnnotationConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig getDefaultInstanceForType() {
      return com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig build() {
      com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig buildPartial() {
      com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig result =
          new com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig(this);
      int from_bitField0_ = bitField0_;
      result.instruction_ = instruction_;
      result.annotatedDatasetDisplayName_ = annotatedDatasetDisplayName_;
      result.annotatedDatasetDescription_ = annotatedDatasetDescription_;
      result.labelGroup_ = labelGroup_;
      result.languageCode_ = languageCode_;
      result.replicaCount_ = replicaCount_;
      if (questionDurationBuilder_ == null) {
        result.questionDuration_ = questionDuration_;
      } else {
        result.questionDuration_ = questionDurationBuilder_.build();
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        contributorEmails_ = contributorEmails_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.contributorEmails_ = contributorEmails_;
      result.userEmailAddress_ = userEmailAddress_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig) {
        return mergeFrom((com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig other) {
      if (other == com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.getDefaultInstance())
        return this;
      if (!other.getInstruction().isEmpty()) {
        instruction_ = other.instruction_;
        onChanged();
      }
      if (!other.getAnnotatedDatasetDisplayName().isEmpty()) {
        annotatedDatasetDisplayName_ = other.annotatedDatasetDisplayName_;
        onChanged();
      }
      if (!other.getAnnotatedDatasetDescription().isEmpty()) {
        annotatedDatasetDescription_ = other.annotatedDatasetDescription_;
        onChanged();
      }
      if (!other.getLabelGroup().isEmpty()) {
        labelGroup_ = other.labelGroup_;
        onChanged();
      }
      if (!other.getLanguageCode().isEmpty()) {
        languageCode_ = other.languageCode_;
        onChanged();
      }
      if (other.getReplicaCount() != 0) {
        setReplicaCount(other.getReplicaCount());
      }
      if (other.hasQuestionDuration()) {
        mergeQuestionDuration(other.getQuestionDuration());
      }
      if (!other.contributorEmails_.isEmpty()) {
        if (contributorEmails_.isEmpty()) {
          contributorEmails_ = other.contributorEmails_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureContributorEmailsIsMutable();
          contributorEmails_.addAll(other.contributorEmails_);
        }
        onChanged();
      }
      if (!other.getUserEmailAddress().isEmpty()) {
        userEmailAddress_ = other.userEmailAddress_;
        onChanged();
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object instruction_ = "";
    /**
     *
     *
     * <pre>
     * Required. Instruction resource name.
     * </pre>
     *
     * <code>string instruction = 1;</code>
     *
     * @return The instruction.
     */
    public java.lang.String getInstruction() {
      java.lang.Object ref = instruction_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        instruction_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Instruction resource name.
     * </pre>
     *
     * <code>string instruction = 1;</code>
     *
     * @return The bytes for instruction.
     */
    public com.google.protobuf.ByteString getInstructionBytes() {
      java.lang.Object ref = instruction_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        instruction_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Instruction resource name.
     * </pre>
     *
     * <code>string instruction = 1;</code>
     *
     * @param value The instruction to set.
     * @return This builder for chaining.
     */
    public Builder setInstruction(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      instruction_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Instruction resource name.
     * </pre>
     *
     * <code>string instruction = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInstruction() {

      instruction_ = getDefaultInstance().getInstruction();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Instruction resource name.
     * </pre>
     *
     * <code>string instruction = 1;</code>
     *
     * @param value The bytes for instruction to set.
     * @return This builder for chaining.
     */
    public Builder setInstructionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      instruction_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object annotatedDatasetDisplayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. A human-readable name for AnnotatedDataset defined by
     * users. Maximum of 64 characters
     * .
     * </pre>
     *
     * <code>string annotated_dataset_display_name = 2;</code>
     *
     * @return The annotatedDatasetDisplayName.
     */
    public java.lang.String getAnnotatedDatasetDisplayName() {
      java.lang.Object ref = annotatedDatasetDisplayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        annotatedDatasetDisplayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. A human-readable name for AnnotatedDataset defined by
     * users. Maximum of 64 characters
     * .
     * </pre>
     *
     * <code>string annotated_dataset_display_name = 2;</code>
     *
     * @return The bytes for annotatedDatasetDisplayName.
     */
    public com.google.protobuf.ByteString getAnnotatedDatasetDisplayNameBytes() {
      java.lang.Object ref = annotatedDatasetDisplayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        annotatedDatasetDisplayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. A human-readable name for AnnotatedDataset defined by
     * users. Maximum of 64 characters
     * .
     * </pre>
     *
     * <code>string annotated_dataset_display_name = 2;</code>
     *
     * @param value The annotatedDatasetDisplayName to set.
     * @return This builder for chaining.
     */
    public Builder setAnnotatedDatasetDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      annotatedDatasetDisplayName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A human-readable name for AnnotatedDataset defined by
     * users. Maximum of 64 characters
     * .
     * </pre>
     *
     * <code>string annotated_dataset_display_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAnnotatedDatasetDisplayName() {

      annotatedDatasetDisplayName_ = getDefaultInstance().getAnnotatedDatasetDisplayName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A human-readable name for AnnotatedDataset defined by
     * users. Maximum of 64 characters
     * .
     * </pre>
     *
     * <code>string annotated_dataset_display_name = 2;</code>
     *
     * @param value The bytes for annotatedDatasetDisplayName to set.
     * @return This builder for chaining.
     */
    public Builder setAnnotatedDatasetDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      annotatedDatasetDisplayName_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object annotatedDatasetDescription_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A human-readable description for AnnotatedDataset.
     * The description can be up to 10000 characters long.
     * </pre>
     *
     * <code>string annotated_dataset_description = 3;</code>
     *
     * @return The annotatedDatasetDescription.
     */
    public java.lang.String getAnnotatedDatasetDescription() {
      java.lang.Object ref = annotatedDatasetDescription_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        annotatedDatasetDescription_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A human-readable description for AnnotatedDataset.
     * The description can be up to 10000 characters long.
     * </pre>
     *
     * <code>string annotated_dataset_description = 3;</code>
     *
     * @return The bytes for annotatedDatasetDescription.
     */
    public com.google.protobuf.ByteString getAnnotatedDatasetDescriptionBytes() {
      java.lang.Object ref = annotatedDatasetDescription_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        annotatedDatasetDescription_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A human-readable description for AnnotatedDataset.
     * The description can be up to 10000 characters long.
     * </pre>
     *
     * <code>string annotated_dataset_description = 3;</code>
     *
     * @param value The annotatedDatasetDescription to set.
     * @return This builder for chaining.
     */
    public Builder setAnnotatedDatasetDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      annotatedDatasetDescription_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A human-readable description for AnnotatedDataset.
     * The description can be up to 10000 characters long.
     * </pre>
     *
     * <code>string annotated_dataset_description = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAnnotatedDatasetDescription() {

      annotatedDatasetDescription_ = getDefaultInstance().getAnnotatedDatasetDescription();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A human-readable description for AnnotatedDataset.
     * The description can be up to 10000 characters long.
     * </pre>
     *
     * <code>string annotated_dataset_description = 3;</code>
     *
     * @param value The bytes for annotatedDatasetDescription to set.
     * @return This builder for chaining.
     */
    public Builder setAnnotatedDatasetDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      annotatedDatasetDescription_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object labelGroup_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A human-readable label used to logically group labeling tasks.
     * This string must match the regular expression `[a-zA-Z&#92;&#92;d_-]{0,128}`.
     * </pre>
     *
     * <code>string label_group = 4;</code>
     *
     * @return The labelGroup.
     */
    public java.lang.String getLabelGroup() {
      java.lang.Object ref = labelGroup_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        labelGroup_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A human-readable label used to logically group labeling tasks.
     * This string must match the regular expression `[a-zA-Z&#92;&#92;d_-]{0,128}`.
     * </pre>
     *
     * <code>string label_group = 4;</code>
     *
     * @return The bytes for labelGroup.
     */
    public com.google.protobuf.ByteString getLabelGroupBytes() {
      java.lang.Object ref = labelGroup_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        labelGroup_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A human-readable label used to logically group labeling tasks.
     * This string must match the regular expression `[a-zA-Z&#92;&#92;d_-]{0,128}`.
     * </pre>
     *
     * <code>string label_group = 4;</code>
     *
     * @param value The labelGroup to set.
     * @return This builder for chaining.
     */
    public Builder setLabelGroup(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      labelGroup_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A human-readable label used to logically group labeling tasks.
     * This string must match the regular expression `[a-zA-Z&#92;&#92;d_-]{0,128}`.
     * </pre>
     *
     * <code>string label_group = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLabelGroup() {

      labelGroup_ = getDefaultInstance().getLabelGroup();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A human-readable label used to logically group labeling tasks.
     * This string must match the regular expression `[a-zA-Z&#92;&#92;d_-]{0,128}`.
     * </pre>
     *
     * <code>string label_group = 4;</code>
     *
     * @param value The bytes for labelGroup to set.
     * @return This builder for chaining.
     */
    public Builder setLabelGroupBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      labelGroup_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object languageCode_ = "";
    /**
     *
     *
     * <pre>
     * Optional. The Language of this question, as a
     * [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
     * Default value is en-US.
     * Only need to set this when task is language related. For example, French
     * text classification.
     * </pre>
     *
     * <code>string language_code = 5;</code>
     *
     * @return The languageCode.
     */
    public java.lang.String getLanguageCode() {
      java.lang.Object ref = languageCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        languageCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Language of this question, as a
     * [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
     * Default value is en-US.
     * Only need to set this when task is language related. For example, French
     * text classification.
     * </pre>
     *
     * <code>string language_code = 5;</code>
     *
     * @return The bytes for languageCode.
     */
    public com.google.protobuf.ByteString getLanguageCodeBytes() {
      java.lang.Object ref = languageCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        languageCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Language of this question, as a
     * [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
     * Default value is en-US.
     * Only need to set this when task is language related. For example, French
     * text classification.
     * </pre>
     *
     * <code>string language_code = 5;</code>
     *
     * @param value The languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      languageCode_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Language of this question, as a
     * [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
     * Default value is en-US.
     * Only need to set this when task is language related. For example, French
     * text classification.
     * </pre>
     *
     * <code>string language_code = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLanguageCode() {

      languageCode_ = getDefaultInstance().getLanguageCode();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Language of this question, as a
     * [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt).
     * Default value is en-US.
     * Only need to set this when task is language related. For example, French
     * text classification.
     * </pre>
     *
     * <code>string language_code = 5;</code>
     *
     * @param value The bytes for languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      languageCode_ = value;
      onChanged();
      return this;
    }

    private int replicaCount_;
    /**
     *
     *
     * <pre>
     * Optional. Replication of questions. Each question will be sent to up to
     * this number of contributors to label. Aggregated answers will be returned.
     * Default is set to 1.
     * For image related labeling, valid values are 1, 3, 5.
     * </pre>
     *
     * <code>int32 replica_count = 6;</code>
     *
     * @return The replicaCount.
     */
    public int getReplicaCount() {
      return replicaCount_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Replication of questions. Each question will be sent to up to
     * this number of contributors to label. Aggregated answers will be returned.
     * Default is set to 1.
     * For image related labeling, valid values are 1, 3, 5.
     * </pre>
     *
     * <code>int32 replica_count = 6;</code>
     *
     * @param value The replicaCount to set.
     * @return This builder for chaining.
     */
    public Builder setReplicaCount(int value) {

      replicaCount_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Replication of questions. Each question will be sent to up to
     * this number of contributors to label. Aggregated answers will be returned.
     * Default is set to 1.
     * For image related labeling, valid values are 1, 3, 5.
     * </pre>
     *
     * <code>int32 replica_count = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReplicaCount() {

      replicaCount_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Duration questionDuration_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        questionDurationBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Maximum duration for contributors to answer a question. Default
     * is 1800 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration question_duration = 7;</code>
     *
     * @return Whether the questionDuration field is set.
     */
    public boolean hasQuestionDuration() {
      return questionDurationBuilder_ != null || questionDuration_ != null;
    }
    /**
     *
     *
     * <pre>
     * Optional. Maximum duration for contributors to answer a question. Default
     * is 1800 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration question_duration = 7;</code>
     *
     * @return The questionDuration.
     */
    public com.google.protobuf.Duration getQuestionDuration() {
      if (questionDurationBuilder_ == null) {
        return questionDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : questionDuration_;
      } else {
        return questionDurationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Maximum duration for contributors to answer a question. Default
     * is 1800 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration question_duration = 7;</code>
     */
    public Builder setQuestionDuration(com.google.protobuf.Duration value) {
      if (questionDurationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        questionDuration_ = value;
        onChanged();
      } else {
        questionDurationBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Maximum duration for contributors to answer a question. Default
     * is 1800 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration question_duration = 7;</code>
     */
    public Builder setQuestionDuration(com.google.protobuf.Duration.Builder builderForValue) {
      if (questionDurationBuilder_ == null) {
        questionDuration_ = builderForValue.build();
        onChanged();
      } else {
        questionDurationBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Maximum duration for contributors to answer a question. Default
     * is 1800 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration question_duration = 7;</code>
     */
    public Builder mergeQuestionDuration(com.google.protobuf.Duration value) {
      if (questionDurationBuilder_ == null) {
        if (questionDuration_ != null) {
          questionDuration_ =
              com.google.protobuf.Duration.newBuilder(questionDuration_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          questionDuration_ = value;
        }
        onChanged();
      } else {
        questionDurationBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Maximum duration for contributors to answer a question. Default
     * is 1800 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration question_duration = 7;</code>
     */
    public Builder clearQuestionDuration() {
      if (questionDurationBuilder_ == null) {
        questionDuration_ = null;
        onChanged();
      } else {
        questionDuration_ = null;
        questionDurationBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Maximum duration for contributors to answer a question. Default
     * is 1800 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration question_duration = 7;</code>
     */
    public com.google.protobuf.Duration.Builder getQuestionDurationBuilder() {

      onChanged();
      return getQuestionDurationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Maximum duration for contributors to answer a question. Default
     * is 1800 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration question_duration = 7;</code>
     */
    public com.google.protobuf.DurationOrBuilder getQuestionDurationOrBuilder() {
      if (questionDurationBuilder_ != null) {
        return questionDurationBuilder_.getMessageOrBuilder();
      } else {
        return questionDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : questionDuration_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Maximum duration for contributors to answer a question. Default
     * is 1800 seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration question_duration = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getQuestionDurationFieldBuilder() {
      if (questionDurationBuilder_ == null) {
        questionDurationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getQuestionDuration(), getParentForChildren(), isClean());
        questionDuration_ = null;
      }
      return questionDurationBuilder_;
    }

    private com.google.protobuf.LazyStringList contributorEmails_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureContributorEmailsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        contributorEmails_ = new com.google.protobuf.LazyStringArrayList(contributorEmails_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. If you want your own labeling contributors to manage and work on
     * this labeling request, you can set these contributors here. We will give
     * them access to the question types in crowdcompute. Note that these
     * emails must be registered in crowdcompute worker UI:
     * https://crowd-compute.appspot.com/
     * </pre>
     *
     * <code>repeated string contributor_emails = 9;</code>
     *
     * @return A list containing the contributorEmails.
     */
    public com.google.protobuf.ProtocolStringList getContributorEmailsList() {
      return contributorEmails_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * Optional. If you want your own labeling contributors to manage and work on
     * this labeling request, you can set these contributors here. We will give
     * them access to the question types in crowdcompute. Note that these
     * emails must be registered in crowdcompute worker UI:
     * https://crowd-compute.appspot.com/
     * </pre>
     *
     * <code>repeated string contributor_emails = 9;</code>
     *
     * @return The count of contributorEmails.
     */
    public int getContributorEmailsCount() {
      return contributorEmails_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. If you want your own labeling contributors to manage and work on
     * this labeling request, you can set these contributors here. We will give
     * them access to the question types in crowdcompute. Note that these
     * emails must be registered in crowdcompute worker UI:
     * https://crowd-compute.appspot.com/
     * </pre>
     *
     * <code>repeated string contributor_emails = 9;</code>
     *
     * @param index The index of the element to return.
     * @return The contributorEmails at the given index.
     */
    public java.lang.String getContributorEmails(int index) {
      return contributorEmails_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. If you want your own labeling contributors to manage and work on
     * this labeling request, you can set these contributors here. We will give
     * them access to the question types in crowdcompute. Note that these
     * emails must be registered in crowdcompute worker UI:
     * https://crowd-compute.appspot.com/
     * </pre>
     *
     * <code>repeated string contributor_emails = 9;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the contributorEmails at the given index.
     */
    public com.google.protobuf.ByteString getContributorEmailsBytes(int index) {
      return contributorEmails_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. If you want your own labeling contributors to manage and work on
     * this labeling request, you can set these contributors here. We will give
     * them access to the question types in crowdcompute. Note that these
     * emails must be registered in crowdcompute worker UI:
     * https://crowd-compute.appspot.com/
     * </pre>
     *
     * <code>repeated string contributor_emails = 9;</code>
     *
     * @param index The index to set the value at.
     * @param value The contributorEmails to set.
     * @return This builder for chaining.
     */
    public Builder setContributorEmails(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureContributorEmailsIsMutable();
      contributorEmails_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If you want your own labeling contributors to manage and work on
     * this labeling request, you can set these contributors here. We will give
     * them access to the question types in crowdcompute. Note that these
     * emails must be registered in crowdcompute worker UI:
     * https://crowd-compute.appspot.com/
     * </pre>
     *
     * <code>repeated string contributor_emails = 9;</code>
     *
     * @param value The contributorEmails to add.
     * @return This builder for chaining.
     */
    public Builder addContributorEmails(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureContributorEmailsIsMutable();
      contributorEmails_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If you want your own labeling contributors to manage and work on
     * this labeling request, you can set these contributors here. We will give
     * them access to the question types in crowdcompute. Note that these
     * emails must be registered in crowdcompute worker UI:
     * https://crowd-compute.appspot.com/
     * </pre>
     *
     * <code>repeated string contributor_emails = 9;</code>
     *
     * @param values The contributorEmails to add.
     * @return This builder for chaining.
     */
    public Builder addAllContributorEmails(java.lang.Iterable<java.lang.String> values) {
      ensureContributorEmailsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, contributorEmails_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If you want your own labeling contributors to manage and work on
     * this labeling request, you can set these contributors here. We will give
     * them access to the question types in crowdcompute. Note that these
     * emails must be registered in crowdcompute worker UI:
     * https://crowd-compute.appspot.com/
     * </pre>
     *
     * <code>repeated string contributor_emails = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearContributorEmails() {
      contributorEmails_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. If you want your own labeling contributors to manage and work on
     * this labeling request, you can set these contributors here. We will give
     * them access to the question types in crowdcompute. Note that these
     * emails must be registered in crowdcompute worker UI:
     * https://crowd-compute.appspot.com/
     * </pre>
     *
     * <code>repeated string contributor_emails = 9;</code>
     *
     * @param value The bytes of the contributorEmails to add.
     * @return This builder for chaining.
     */
    public Builder addContributorEmailsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureContributorEmailsIsMutable();
      contributorEmails_.add(value);
      onChanged();
      return this;
    }

    private java.lang.Object userEmailAddress_ = "";
    /**
     *
     *
     * <pre>
     * Email of the user who started the labeling task and should be notified by
     * email. If empty no notification will be sent.
     * </pre>
     *
     * <code>string user_email_address = 10;</code>
     *
     * @return The userEmailAddress.
     */
    public java.lang.String getUserEmailAddress() {
      java.lang.Object ref = userEmailAddress_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        userEmailAddress_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Email of the user who started the labeling task and should be notified by
     * email. If empty no notification will be sent.
     * </pre>
     *
     * <code>string user_email_address = 10;</code>
     *
     * @return The bytes for userEmailAddress.
     */
    public com.google.protobuf.ByteString getUserEmailAddressBytes() {
      java.lang.Object ref = userEmailAddress_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        userEmailAddress_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Email of the user who started the labeling task and should be notified by
     * email. If empty no notification will be sent.
     * </pre>
     *
     * <code>string user_email_address = 10;</code>
     *
     * @param value The userEmailAddress to set.
     * @return This builder for chaining.
     */
    public Builder setUserEmailAddress(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      userEmailAddress_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Email of the user who started the labeling task and should be notified by
     * email. If empty no notification will be sent.
     * </pre>
     *
     * <code>string user_email_address = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUserEmailAddress() {

      userEmailAddress_ = getDefaultInstance().getUserEmailAddress();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Email of the user who started the labeling task and should be notified by
     * email. If empty no notification will be sent.
     * </pre>
     *
     * <code>string user_email_address = 10;</code>
     *
     * @param value The bytes for userEmailAddress to set.
     * @return This builder for chaining.
     */
    public Builder setUserEmailAddressBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      userEmailAddress_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datalabeling.v1beta1.HumanAnnotationConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datalabeling.v1beta1.HumanAnnotationConfig)
  private static final com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig();
  }

  public static com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<HumanAnnotationConfig> PARSER =
      new com.google.protobuf.AbstractParser<HumanAnnotationConfig>() {
        @java.lang.Override
        public HumanAnnotationConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new HumanAnnotationConfig(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<HumanAnnotationConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<HumanAnnotationConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
