/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datalabeling/v1beta1/evaluation_job.proto

package com.google.cloud.datalabeling.v1beta1;

/**
 *
 *
 * <pre>
 * Defines an evaluation job that runs periodically to generate
 * [Evaluations][google.cloud.datalabeling.v1beta1.Evaluation]. [Creating an evaluation
 * job](/ml-engine/docs/continuous-evaluation/create-job) is the starting point
 * for using continuous evaluation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.datalabeling.v1beta1.EvaluationJob}
 */
public final class EvaluationJob extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datalabeling.v1beta1.EvaluationJob)
    EvaluationJobOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use EvaluationJob.newBuilder() to construct.
  private EvaluationJob(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private EvaluationJob() {
    name_ = "";
    description_ = "";
    state_ = 0;
    schedule_ = "";
    modelVersion_ = "";
    annotationSpecSet_ = "";
    attempts_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new EvaluationJob();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private EvaluationJob(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();

              description_ = s;
              break;
            }
          case 24:
            {
              int rawValue = input.readEnum();

              state_ = rawValue;
              break;
            }
          case 34:
            {
              java.lang.String s = input.readStringRequireUtf8();

              schedule_ = s;
              break;
            }
          case 42:
            {
              java.lang.String s = input.readStringRequireUtf8();

              modelVersion_ = s;
              break;
            }
          case 50:
            {
              com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig.Builder subBuilder = null;
              if (evaluationJobConfig_ != null) {
                subBuilder = evaluationJobConfig_.toBuilder();
              }
              evaluationJobConfig_ =
                  input.readMessage(
                      com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(evaluationJobConfig_);
                evaluationJobConfig_ = subBuilder.buildPartial();
              }

              break;
            }
          case 58:
            {
              java.lang.String s = input.readStringRequireUtf8();

              annotationSpecSet_ = s;
              break;
            }
          case 64:
            {
              labelMissingGroundTruth_ = input.readBool();
              break;
            }
          case 74:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                attempts_ =
                    new java.util.ArrayList<com.google.cloud.datalabeling.v1beta1.Attempt>();
                mutable_bitField0_ |= 0x00000001;
              }
              attempts_.add(
                  input.readMessage(
                      com.google.cloud.datalabeling.v1beta1.Attempt.parser(), extensionRegistry));
              break;
            }
          case 82:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (createTime_ != null) {
                subBuilder = createTime_.toBuilder();
              }
              createTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(createTime_);
                createTime_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        attempts_ = java.util.Collections.unmodifiableList(attempts_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datalabeling.v1beta1.EvaluationJobOuterClass
        .internal_static_google_cloud_datalabeling_v1beta1_EvaluationJob_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datalabeling.v1beta1.EvaluationJobOuterClass
        .internal_static_google_cloud_datalabeling_v1beta1_EvaluationJob_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datalabeling.v1beta1.EvaluationJob.class,
            com.google.cloud.datalabeling.v1beta1.EvaluationJob.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * State of the job.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.datalabeling.v1beta1.EvaluationJob.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /** <code>STATE_UNSPECIFIED = 0;</code> */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The job is scheduled to run at the [configured interval][google.cloud.datalabeling.v1beta1.EvaluationJob.schedule]. You
     * can [pause][google.cloud.datalabeling.v1beta1.DataLabelingService.PauseEvaluationJob] or
     * [delete][google.cloud.datalabeling.v1beta1.DataLabelingService.DeleteEvaluationJob] the job.
     * When the job is in this state, it samples prediction input and output
     * from your model version into your BigQuery table as predictions occur.
     * </pre>
     *
     * <code>SCHEDULED = 1;</code>
     */
    SCHEDULED(1),
    /**
     *
     *
     * <pre>
     * The job is currently running. When the job runs, Data Labeling Service
     * does several things:
     * 1. If you have configured your job to use Data Labeling Service for
     *    ground truth labeling, the service creates a
     *    [Dataset][google.cloud.datalabeling.v1beta1.Dataset] and a labeling task for all data sampled
     *    since the last time the job ran. Human labelers provide ground truth
     *    labels for your data. Human labeling may take hours, or even days,
     *    depending on how much data has been sampled. The job remains in the
     *    `RUNNING` state during this time, and it can even be running multiple
     *    times in parallel if it gets triggered again (for example 24 hours
     *    later) before the earlier run has completed. When human labelers have
     *    finished labeling the data, the next step occurs.
     *    &lt;br&gt;&lt;br&gt;
     *    If you have configured your job to provide your own ground truth
     *    labels, Data Labeling Service still creates a [Dataset][google.cloud.datalabeling.v1beta1.Dataset] for newly
     *    sampled data, but it expects that you have already added ground truth
     *    labels to the BigQuery table by this time. The next step occurs
     *    immediately.
     * 2. Data Labeling Service creates an [Evaluation][google.cloud.datalabeling.v1beta1.Evaluation] by comparing your
     *    model version's predictions with the ground truth labels.
     * If the job remains in this state for a long time, it continues to sample
     * prediction data into your BigQuery table and will run again at the next
     * interval, even if it causes the job to run multiple times in parallel.
     * </pre>
     *
     * <code>RUNNING = 2;</code>
     */
    RUNNING(2),
    /**
     *
     *
     * <pre>
     * The job is not sampling prediction input and output into your BigQuery
     * table and it will not run according to its schedule. You can
     * [resume][google.cloud.datalabeling.v1beta1.DataLabelingService.ResumeEvaluationJob] the job.
     * </pre>
     *
     * <code>PAUSED = 3;</code>
     */
    PAUSED(3),
    /**
     *
     *
     * <pre>
     * The job has this state right before it is deleted.
     * </pre>
     *
     * <code>STOPPED = 4;</code>
     */
    STOPPED(4),
    UNRECOGNIZED(-1),
    ;

    /** <code>STATE_UNSPECIFIED = 0;</code> */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The job is scheduled to run at the [configured interval][google.cloud.datalabeling.v1beta1.EvaluationJob.schedule]. You
     * can [pause][google.cloud.datalabeling.v1beta1.DataLabelingService.PauseEvaluationJob] or
     * [delete][google.cloud.datalabeling.v1beta1.DataLabelingService.DeleteEvaluationJob] the job.
     * When the job is in this state, it samples prediction input and output
     * from your model version into your BigQuery table as predictions occur.
     * </pre>
     *
     * <code>SCHEDULED = 1;</code>
     */
    public static final int SCHEDULED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The job is currently running. When the job runs, Data Labeling Service
     * does several things:
     * 1. If you have configured your job to use Data Labeling Service for
     *    ground truth labeling, the service creates a
     *    [Dataset][google.cloud.datalabeling.v1beta1.Dataset] and a labeling task for all data sampled
     *    since the last time the job ran. Human labelers provide ground truth
     *    labels for your data. Human labeling may take hours, or even days,
     *    depending on how much data has been sampled. The job remains in the
     *    `RUNNING` state during this time, and it can even be running multiple
     *    times in parallel if it gets triggered again (for example 24 hours
     *    later) before the earlier run has completed. When human labelers have
     *    finished labeling the data, the next step occurs.
     *    &lt;br&gt;&lt;br&gt;
     *    If you have configured your job to provide your own ground truth
     *    labels, Data Labeling Service still creates a [Dataset][google.cloud.datalabeling.v1beta1.Dataset] for newly
     *    sampled data, but it expects that you have already added ground truth
     *    labels to the BigQuery table by this time. The next step occurs
     *    immediately.
     * 2. Data Labeling Service creates an [Evaluation][google.cloud.datalabeling.v1beta1.Evaluation] by comparing your
     *    model version's predictions with the ground truth labels.
     * If the job remains in this state for a long time, it continues to sample
     * prediction data into your BigQuery table and will run again at the next
     * interval, even if it causes the job to run multiple times in parallel.
     * </pre>
     *
     * <code>RUNNING = 2;</code>
     */
    public static final int RUNNING_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The job is not sampling prediction input and output into your BigQuery
     * table and it will not run according to its schedule. You can
     * [resume][google.cloud.datalabeling.v1beta1.DataLabelingService.ResumeEvaluationJob] the job.
     * </pre>
     *
     * <code>PAUSED = 3;</code>
     */
    public static final int PAUSED_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The job has this state right before it is deleted.
     * </pre>
     *
     * <code>STOPPED = 4;</code>
     */
    public static final int STOPPED_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return SCHEDULED;
        case 2:
          return RUNNING;
        case 3:
          return PAUSED;
        case 4:
          return STOPPED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.datalabeling.v1beta1.EvaluationJob.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.datalabeling.v1beta1.EvaluationJob.State)
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * Output only. After you create a job, Data Labeling Service assigns a name
   * to the job with the following format:
   * "projects/&lt;var&gt;{project_id}&lt;/var&gt;/evaluationJobs/&lt;var&gt;{evaluation_job_id}&lt;/var&gt;"
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. After you create a job, Data Labeling Service assigns a name
   * to the job with the following format:
   * "projects/&lt;var&gt;{project_id}&lt;/var&gt;/evaluationJobs/&lt;var&gt;{evaluation_job_id}&lt;/var&gt;"
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 2;
  private volatile java.lang.Object description_;
  /**
   *
   *
   * <pre>
   * Required. Description of the job. The description can be up to 25,000
   * characters long.
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The description.
   */
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Description of the job. The description can be up to 25,000
   * characters long.
   * </pre>
   *
   * <code>string description = 2;</code>
   *
   * @return The bytes for description.
   */
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 3;
  private int state_;
  /**
   *
   *
   * <pre>
   * Output only. Describes the current state of the job.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.EvaluationJob.State state = 3;</code>
   *
   * @return The enum numeric value on the wire for state.
   */
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Describes the current state of the job.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.EvaluationJob.State state = 3;</code>
   *
   * @return The state.
   */
  public com.google.cloud.datalabeling.v1beta1.EvaluationJob.State getState() {
    @SuppressWarnings("deprecation")
    com.google.cloud.datalabeling.v1beta1.EvaluationJob.State result =
        com.google.cloud.datalabeling.v1beta1.EvaluationJob.State.valueOf(state_);
    return result == null
        ? com.google.cloud.datalabeling.v1beta1.EvaluationJob.State.UNRECOGNIZED
        : result;
  }

  public static final int SCHEDULE_FIELD_NUMBER = 4;
  private volatile java.lang.Object schedule_;
  /**
   *
   *
   * <pre>
   * Required. Describes the interval at which the job runs. This interval must
   * be at least 1 day, and it is rounded to the nearest day. For example, if
   * you specify a 50-hour interval, the job runs every 2 days.
   * You can provide the schedule in
   * [crontab format](/scheduler/docs/configuring/cron-job-schedules) or in an
   * [English-like
   * format](/appengine/docs/standard/python/config/cronref#schedule_format).
   * Regardless of what you specify, the job will run at 10:00 AM UTC. Only the
   * interval from this schedule is used, not the specific time of day.
   * </pre>
   *
   * <code>string schedule = 4;</code>
   *
   * @return The schedule.
   */
  public java.lang.String getSchedule() {
    java.lang.Object ref = schedule_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      schedule_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Describes the interval at which the job runs. This interval must
   * be at least 1 day, and it is rounded to the nearest day. For example, if
   * you specify a 50-hour interval, the job runs every 2 days.
   * You can provide the schedule in
   * [crontab format](/scheduler/docs/configuring/cron-job-schedules) or in an
   * [English-like
   * format](/appengine/docs/standard/python/config/cronref#schedule_format).
   * Regardless of what you specify, the job will run at 10:00 AM UTC. Only the
   * interval from this schedule is used, not the specific time of day.
   * </pre>
   *
   * <code>string schedule = 4;</code>
   *
   * @return The bytes for schedule.
   */
  public com.google.protobuf.ByteString getScheduleBytes() {
    java.lang.Object ref = schedule_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      schedule_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MODEL_VERSION_FIELD_NUMBER = 5;
  private volatile java.lang.Object modelVersion_;
  /**
   *
   *
   * <pre>
   * Required. The [AI Platform Prediction model
   * version](/ml-engine/docs/prediction-overview) to be evaluated. Prediction
   * input and output is sampled from this model version. When creating an
   * evaluation job, specify the model version in the following format:
   * "projects/&lt;var&gt;{project_id}&lt;/var&gt;/models/&lt;var&gt;{model_name}&lt;/var&gt;/versions/&lt;var&gt;{version_name}&lt;/var&gt;"
   * There can only be one evaluation job per model version.
   * </pre>
   *
   * <code>string model_version = 5;</code>
   *
   * @return The modelVersion.
   */
  public java.lang.String getModelVersion() {
    java.lang.Object ref = modelVersion_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      modelVersion_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The [AI Platform Prediction model
   * version](/ml-engine/docs/prediction-overview) to be evaluated. Prediction
   * input and output is sampled from this model version. When creating an
   * evaluation job, specify the model version in the following format:
   * "projects/&lt;var&gt;{project_id}&lt;/var&gt;/models/&lt;var&gt;{model_name}&lt;/var&gt;/versions/&lt;var&gt;{version_name}&lt;/var&gt;"
   * There can only be one evaluation job per model version.
   * </pre>
   *
   * <code>string model_version = 5;</code>
   *
   * @return The bytes for modelVersion.
   */
  public com.google.protobuf.ByteString getModelVersionBytes() {
    java.lang.Object ref = modelVersion_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      modelVersion_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EVALUATION_JOB_CONFIG_FIELD_NUMBER = 6;
  private com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig evaluationJobConfig_;
  /**
   *
   *
   * <pre>
   * Required. Configuration details for the evaluation job.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.EvaluationJobConfig evaluation_job_config = 6;</code>
   *
   * @return Whether the evaluationJobConfig field is set.
   */
  public boolean hasEvaluationJobConfig() {
    return evaluationJobConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. Configuration details for the evaluation job.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.EvaluationJobConfig evaluation_job_config = 6;</code>
   *
   * @return The evaluationJobConfig.
   */
  public com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig getEvaluationJobConfig() {
    return evaluationJobConfig_ == null
        ? com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig.getDefaultInstance()
        : evaluationJobConfig_;
  }
  /**
   *
   *
   * <pre>
   * Required. Configuration details for the evaluation job.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.EvaluationJobConfig evaluation_job_config = 6;</code>
   */
  public com.google.cloud.datalabeling.v1beta1.EvaluationJobConfigOrBuilder
      getEvaluationJobConfigOrBuilder() {
    return getEvaluationJobConfig();
  }

  public static final int ANNOTATION_SPEC_SET_FIELD_NUMBER = 7;
  private volatile java.lang.Object annotationSpecSet_;
  /**
   *
   *
   * <pre>
   * Required. Name of the [AnnotationSpecSet][google.cloud.datalabeling.v1beta1.AnnotationSpecSet] describing all the
   * labels that your machine learning model outputs. You must create this
   * resource before you create an evaluation job and provide its name in the
   * following format:
   * "projects/&lt;var&gt;{project_id}&lt;/var&gt;/annotationSpecSets/&lt;var&gt;{annotation_spec_set_id}&lt;/var&gt;"
   * </pre>
   *
   * <code>string annotation_spec_set = 7;</code>
   *
   * @return The annotationSpecSet.
   */
  public java.lang.String getAnnotationSpecSet() {
    java.lang.Object ref = annotationSpecSet_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      annotationSpecSet_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Name of the [AnnotationSpecSet][google.cloud.datalabeling.v1beta1.AnnotationSpecSet] describing all the
   * labels that your machine learning model outputs. You must create this
   * resource before you create an evaluation job and provide its name in the
   * following format:
   * "projects/&lt;var&gt;{project_id}&lt;/var&gt;/annotationSpecSets/&lt;var&gt;{annotation_spec_set_id}&lt;/var&gt;"
   * </pre>
   *
   * <code>string annotation_spec_set = 7;</code>
   *
   * @return The bytes for annotationSpecSet.
   */
  public com.google.protobuf.ByteString getAnnotationSpecSetBytes() {
    java.lang.Object ref = annotationSpecSet_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      annotationSpecSet_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABEL_MISSING_GROUND_TRUTH_FIELD_NUMBER = 8;
  private boolean labelMissingGroundTruth_;
  /**
   *
   *
   * <pre>
   * Required. Whether you want Data Labeling Service to provide ground truth
   * labels for prediction input. If you want the service to assign human
   * labelers to annotate your data, set this to `true`. If you want to provide
   * your own ground truth labels in the evaluation job's BigQuery table, set
   * this to `false`.
   * </pre>
   *
   * <code>bool label_missing_ground_truth = 8;</code>
   *
   * @return The labelMissingGroundTruth.
   */
  public boolean getLabelMissingGroundTruth() {
    return labelMissingGroundTruth_;
  }

  public static final int ATTEMPTS_FIELD_NUMBER = 9;
  private java.util.List<com.google.cloud.datalabeling.v1beta1.Attempt> attempts_;
  /**
   *
   *
   * <pre>
   * Output only. Every time the evaluation job runs and an error occurs, the
   * failed attempt is appended to this array.
   * </pre>
   *
   * <code>repeated .google.cloud.datalabeling.v1beta1.Attempt attempts = 9;</code>
   */
  public java.util.List<com.google.cloud.datalabeling.v1beta1.Attempt> getAttemptsList() {
    return attempts_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Every time the evaluation job runs and an error occurs, the
   * failed attempt is appended to this array.
   * </pre>
   *
   * <code>repeated .google.cloud.datalabeling.v1beta1.Attempt attempts = 9;</code>
   */
  public java.util.List<? extends com.google.cloud.datalabeling.v1beta1.AttemptOrBuilder>
      getAttemptsOrBuilderList() {
    return attempts_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Every time the evaluation job runs and an error occurs, the
   * failed attempt is appended to this array.
   * </pre>
   *
   * <code>repeated .google.cloud.datalabeling.v1beta1.Attempt attempts = 9;</code>
   */
  public int getAttemptsCount() {
    return attempts_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Every time the evaluation job runs and an error occurs, the
   * failed attempt is appended to this array.
   * </pre>
   *
   * <code>repeated .google.cloud.datalabeling.v1beta1.Attempt attempts = 9;</code>
   */
  public com.google.cloud.datalabeling.v1beta1.Attempt getAttempts(int index) {
    return attempts_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. Every time the evaluation job runs and an error occurs, the
   * failed attempt is appended to this array.
   * </pre>
   *
   * <code>repeated .google.cloud.datalabeling.v1beta1.Attempt attempts = 9;</code>
   */
  public com.google.cloud.datalabeling.v1beta1.AttemptOrBuilder getAttemptsOrBuilder(int index) {
    return attempts_.get(index);
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 10;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp of when this evaluation job was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 10;</code>
   *
   * @return Whether the createTime field is set.
   */
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp of when this evaluation job was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 10;</code>
   *
   * @return The createTime.
   */
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp of when this evaluation job was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 10;</code>
   */
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return getCreateTime();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!getDescriptionBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, description_);
    }
    if (state_
        != com.google.cloud.datalabeling.v1beta1.EvaluationJob.State.STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, state_);
    }
    if (!getScheduleBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, schedule_);
    }
    if (!getModelVersionBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, modelVersion_);
    }
    if (evaluationJobConfig_ != null) {
      output.writeMessage(6, getEvaluationJobConfig());
    }
    if (!getAnnotationSpecSetBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, annotationSpecSet_);
    }
    if (labelMissingGroundTruth_ != false) {
      output.writeBool(8, labelMissingGroundTruth_);
    }
    for (int i = 0; i < attempts_.size(); i++) {
      output.writeMessage(9, attempts_.get(i));
    }
    if (createTime_ != null) {
      output.writeMessage(10, getCreateTime());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!getDescriptionBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, description_);
    }
    if (state_
        != com.google.cloud.datalabeling.v1beta1.EvaluationJob.State.STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, state_);
    }
    if (!getScheduleBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, schedule_);
    }
    if (!getModelVersionBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, modelVersion_);
    }
    if (evaluationJobConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getEvaluationJobConfig());
    }
    if (!getAnnotationSpecSetBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, annotationSpecSet_);
    }
    if (labelMissingGroundTruth_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(8, labelMissingGroundTruth_);
    }
    for (int i = 0; i < attempts_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, attempts_.get(i));
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getCreateTime());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datalabeling.v1beta1.EvaluationJob)) {
      return super.equals(obj);
    }
    com.google.cloud.datalabeling.v1beta1.EvaluationJob other =
        (com.google.cloud.datalabeling.v1beta1.EvaluationJob) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (state_ != other.state_) return false;
    if (!getSchedule().equals(other.getSchedule())) return false;
    if (!getModelVersion().equals(other.getModelVersion())) return false;
    if (hasEvaluationJobConfig() != other.hasEvaluationJobConfig()) return false;
    if (hasEvaluationJobConfig()) {
      if (!getEvaluationJobConfig().equals(other.getEvaluationJobConfig())) return false;
    }
    if (!getAnnotationSpecSet().equals(other.getAnnotationSpecSet())) return false;
    if (getLabelMissingGroundTruth() != other.getLabelMissingGroundTruth()) return false;
    if (!getAttemptsList().equals(other.getAttemptsList())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + SCHEDULE_FIELD_NUMBER;
    hash = (53 * hash) + getSchedule().hashCode();
    hash = (37 * hash) + MODEL_VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getModelVersion().hashCode();
    if (hasEvaluationJobConfig()) {
      hash = (37 * hash) + EVALUATION_JOB_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getEvaluationJobConfig().hashCode();
    }
    hash = (37 * hash) + ANNOTATION_SPEC_SET_FIELD_NUMBER;
    hash = (53 * hash) + getAnnotationSpecSet().hashCode();
    hash = (37 * hash) + LABEL_MISSING_GROUND_TRUTH_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getLabelMissingGroundTruth());
    if (getAttemptsCount() > 0) {
      hash = (37 * hash) + ATTEMPTS_FIELD_NUMBER;
      hash = (53 * hash) + getAttemptsList().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datalabeling.v1beta1.EvaluationJob parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.EvaluationJob parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.EvaluationJob parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.EvaluationJob parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.EvaluationJob parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.EvaluationJob parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.EvaluationJob parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.EvaluationJob parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.EvaluationJob parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.EvaluationJob parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.EvaluationJob parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.EvaluationJob parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.datalabeling.v1beta1.EvaluationJob prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Defines an evaluation job that runs periodically to generate
   * [Evaluations][google.cloud.datalabeling.v1beta1.Evaluation]. [Creating an evaluation
   * job](/ml-engine/docs/continuous-evaluation/create-job) is the starting point
   * for using continuous evaluation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datalabeling.v1beta1.EvaluationJob}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datalabeling.v1beta1.EvaluationJob)
      com.google.cloud.datalabeling.v1beta1.EvaluationJobOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datalabeling.v1beta1.EvaluationJobOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_EvaluationJob_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datalabeling.v1beta1.EvaluationJobOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_EvaluationJob_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datalabeling.v1beta1.EvaluationJob.class,
              com.google.cloud.datalabeling.v1beta1.EvaluationJob.Builder.class);
    }

    // Construct using com.google.cloud.datalabeling.v1beta1.EvaluationJob.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getAttemptsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      description_ = "";

      state_ = 0;

      schedule_ = "";

      modelVersion_ = "";

      if (evaluationJobConfigBuilder_ == null) {
        evaluationJobConfig_ = null;
      } else {
        evaluationJobConfig_ = null;
        evaluationJobConfigBuilder_ = null;
      }
      annotationSpecSet_ = "";

      labelMissingGroundTruth_ = false;

      if (attemptsBuilder_ == null) {
        attempts_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        attemptsBuilder_.clear();
      }
      if (createTimeBuilder_ == null) {
        createTime_ = null;
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datalabeling.v1beta1.EvaluationJobOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_EvaluationJob_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.EvaluationJob getDefaultInstanceForType() {
      return com.google.cloud.datalabeling.v1beta1.EvaluationJob.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.EvaluationJob build() {
      com.google.cloud.datalabeling.v1beta1.EvaluationJob result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.EvaluationJob buildPartial() {
      com.google.cloud.datalabeling.v1beta1.EvaluationJob result =
          new com.google.cloud.datalabeling.v1beta1.EvaluationJob(this);
      int from_bitField0_ = bitField0_;
      result.name_ = name_;
      result.description_ = description_;
      result.state_ = state_;
      result.schedule_ = schedule_;
      result.modelVersion_ = modelVersion_;
      if (evaluationJobConfigBuilder_ == null) {
        result.evaluationJobConfig_ = evaluationJobConfig_;
      } else {
        result.evaluationJobConfig_ = evaluationJobConfigBuilder_.build();
      }
      result.annotationSpecSet_ = annotationSpecSet_;
      result.labelMissingGroundTruth_ = labelMissingGroundTruth_;
      if (attemptsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          attempts_ = java.util.Collections.unmodifiableList(attempts_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.attempts_ = attempts_;
      } else {
        result.attempts_ = attemptsBuilder_.build();
      }
      if (createTimeBuilder_ == null) {
        result.createTime_ = createTime_;
      } else {
        result.createTime_ = createTimeBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datalabeling.v1beta1.EvaluationJob) {
        return mergeFrom((com.google.cloud.datalabeling.v1beta1.EvaluationJob) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datalabeling.v1beta1.EvaluationJob other) {
      if (other == com.google.cloud.datalabeling.v1beta1.EvaluationJob.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (!other.getSchedule().isEmpty()) {
        schedule_ = other.schedule_;
        onChanged();
      }
      if (!other.getModelVersion().isEmpty()) {
        modelVersion_ = other.modelVersion_;
        onChanged();
      }
      if (other.hasEvaluationJobConfig()) {
        mergeEvaluationJobConfig(other.getEvaluationJobConfig());
      }
      if (!other.getAnnotationSpecSet().isEmpty()) {
        annotationSpecSet_ = other.annotationSpecSet_;
        onChanged();
      }
      if (other.getLabelMissingGroundTruth() != false) {
        setLabelMissingGroundTruth(other.getLabelMissingGroundTruth());
      }
      if (attemptsBuilder_ == null) {
        if (!other.attempts_.isEmpty()) {
          if (attempts_.isEmpty()) {
            attempts_ = other.attempts_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureAttemptsIsMutable();
            attempts_.addAll(other.attempts_);
          }
          onChanged();
        }
      } else {
        if (!other.attempts_.isEmpty()) {
          if (attemptsBuilder_.isEmpty()) {
            attemptsBuilder_.dispose();
            attemptsBuilder_ = null;
            attempts_ = other.attempts_;
            bitField0_ = (bitField0_ & ~0x00000001);
            attemptsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAttemptsFieldBuilder()
                    : null;
          } else {
            attemptsBuilder_.addAllMessages(other.attempts_);
          }
        }
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.datalabeling.v1beta1.EvaluationJob parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.datalabeling.v1beta1.EvaluationJob) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. After you create a job, Data Labeling Service assigns a name
     * to the job with the following format:
     * "projects/&lt;var&gt;{project_id}&lt;/var&gt;/evaluationJobs/&lt;var&gt;{evaluation_job_id}&lt;/var&gt;"
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. After you create a job, Data Labeling Service assigns a name
     * to the job with the following format:
     * "projects/&lt;var&gt;{project_id}&lt;/var&gt;/evaluationJobs/&lt;var&gt;{evaluation_job_id}&lt;/var&gt;"
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. After you create a job, Data Labeling Service assigns a name
     * to the job with the following format:
     * "projects/&lt;var&gt;{project_id}&lt;/var&gt;/evaluationJobs/&lt;var&gt;{evaluation_job_id}&lt;/var&gt;"
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. After you create a job, Data Labeling Service assigns a name
     * to the job with the following format:
     * "projects/&lt;var&gt;{project_id}&lt;/var&gt;/evaluationJobs/&lt;var&gt;{evaluation_job_id}&lt;/var&gt;"
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. After you create a job, Data Labeling Service assigns a name
     * to the job with the following format:
     * "projects/&lt;var&gt;{project_id}&lt;/var&gt;/evaluationJobs/&lt;var&gt;{evaluation_job_id}&lt;/var&gt;"
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Required. Description of the job. The description can be up to 25,000
     * characters long.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Description of the job. The description can be up to 25,000
     * characters long.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Description of the job. The description can be up to 25,000
     * characters long.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      description_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Description of the job. The description can be up to 25,000
     * characters long.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {

      description_ = getDefaultInstance().getDescription();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Description of the job. The description can be up to 25,000
     * characters long.
     * </pre>
     *
     * <code>string description = 2;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      description_ = value;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. Describes the current state of the job.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EvaluationJob.State state = 3;</code>
     *
     * @return The enum numeric value on the wire for state.
     */
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Describes the current state of the job.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EvaluationJob.State state = 3;</code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Describes the current state of the job.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EvaluationJob.State state = 3;</code>
     *
     * @return The state.
     */
    public com.google.cloud.datalabeling.v1beta1.EvaluationJob.State getState() {
      @SuppressWarnings("deprecation")
      com.google.cloud.datalabeling.v1beta1.EvaluationJob.State result =
          com.google.cloud.datalabeling.v1beta1.EvaluationJob.State.valueOf(state_);
      return result == null
          ? com.google.cloud.datalabeling.v1beta1.EvaluationJob.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. Describes the current state of the job.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EvaluationJob.State state = 3;</code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.datalabeling.v1beta1.EvaluationJob.State value) {
      if (value == null) {
        throw new NullPointerException();
      }

      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Describes the current state of the job.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EvaluationJob.State state = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {

      state_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object schedule_ = "";
    /**
     *
     *
     * <pre>
     * Required. Describes the interval at which the job runs. This interval must
     * be at least 1 day, and it is rounded to the nearest day. For example, if
     * you specify a 50-hour interval, the job runs every 2 days.
     * You can provide the schedule in
     * [crontab format](/scheduler/docs/configuring/cron-job-schedules) or in an
     * [English-like
     * format](/appengine/docs/standard/python/config/cronref#schedule_format).
     * Regardless of what you specify, the job will run at 10:00 AM UTC. Only the
     * interval from this schedule is used, not the specific time of day.
     * </pre>
     *
     * <code>string schedule = 4;</code>
     *
     * @return The schedule.
     */
    public java.lang.String getSchedule() {
      java.lang.Object ref = schedule_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        schedule_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Describes the interval at which the job runs. This interval must
     * be at least 1 day, and it is rounded to the nearest day. For example, if
     * you specify a 50-hour interval, the job runs every 2 days.
     * You can provide the schedule in
     * [crontab format](/scheduler/docs/configuring/cron-job-schedules) or in an
     * [English-like
     * format](/appengine/docs/standard/python/config/cronref#schedule_format).
     * Regardless of what you specify, the job will run at 10:00 AM UTC. Only the
     * interval from this schedule is used, not the specific time of day.
     * </pre>
     *
     * <code>string schedule = 4;</code>
     *
     * @return The bytes for schedule.
     */
    public com.google.protobuf.ByteString getScheduleBytes() {
      java.lang.Object ref = schedule_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        schedule_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Describes the interval at which the job runs. This interval must
     * be at least 1 day, and it is rounded to the nearest day. For example, if
     * you specify a 50-hour interval, the job runs every 2 days.
     * You can provide the schedule in
     * [crontab format](/scheduler/docs/configuring/cron-job-schedules) or in an
     * [English-like
     * format](/appengine/docs/standard/python/config/cronref#schedule_format).
     * Regardless of what you specify, the job will run at 10:00 AM UTC. Only the
     * interval from this schedule is used, not the specific time of day.
     * </pre>
     *
     * <code>string schedule = 4;</code>
     *
     * @param value The schedule to set.
     * @return This builder for chaining.
     */
    public Builder setSchedule(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      schedule_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Describes the interval at which the job runs. This interval must
     * be at least 1 day, and it is rounded to the nearest day. For example, if
     * you specify a 50-hour interval, the job runs every 2 days.
     * You can provide the schedule in
     * [crontab format](/scheduler/docs/configuring/cron-job-schedules) or in an
     * [English-like
     * format](/appengine/docs/standard/python/config/cronref#schedule_format).
     * Regardless of what you specify, the job will run at 10:00 AM UTC. Only the
     * interval from this schedule is used, not the specific time of day.
     * </pre>
     *
     * <code>string schedule = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSchedule() {

      schedule_ = getDefaultInstance().getSchedule();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Describes the interval at which the job runs. This interval must
     * be at least 1 day, and it is rounded to the nearest day. For example, if
     * you specify a 50-hour interval, the job runs every 2 days.
     * You can provide the schedule in
     * [crontab format](/scheduler/docs/configuring/cron-job-schedules) or in an
     * [English-like
     * format](/appengine/docs/standard/python/config/cronref#schedule_format).
     * Regardless of what you specify, the job will run at 10:00 AM UTC. Only the
     * interval from this schedule is used, not the specific time of day.
     * </pre>
     *
     * <code>string schedule = 4;</code>
     *
     * @param value The bytes for schedule to set.
     * @return This builder for chaining.
     */
    public Builder setScheduleBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      schedule_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object modelVersion_ = "";
    /**
     *
     *
     * <pre>
     * Required. The [AI Platform Prediction model
     * version](/ml-engine/docs/prediction-overview) to be evaluated. Prediction
     * input and output is sampled from this model version. When creating an
     * evaluation job, specify the model version in the following format:
     * "projects/&lt;var&gt;{project_id}&lt;/var&gt;/models/&lt;var&gt;{model_name}&lt;/var&gt;/versions/&lt;var&gt;{version_name}&lt;/var&gt;"
     * There can only be one evaluation job per model version.
     * </pre>
     *
     * <code>string model_version = 5;</code>
     *
     * @return The modelVersion.
     */
    public java.lang.String getModelVersion() {
      java.lang.Object ref = modelVersion_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        modelVersion_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The [AI Platform Prediction model
     * version](/ml-engine/docs/prediction-overview) to be evaluated. Prediction
     * input and output is sampled from this model version. When creating an
     * evaluation job, specify the model version in the following format:
     * "projects/&lt;var&gt;{project_id}&lt;/var&gt;/models/&lt;var&gt;{model_name}&lt;/var&gt;/versions/&lt;var&gt;{version_name}&lt;/var&gt;"
     * There can only be one evaluation job per model version.
     * </pre>
     *
     * <code>string model_version = 5;</code>
     *
     * @return The bytes for modelVersion.
     */
    public com.google.protobuf.ByteString getModelVersionBytes() {
      java.lang.Object ref = modelVersion_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        modelVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The [AI Platform Prediction model
     * version](/ml-engine/docs/prediction-overview) to be evaluated. Prediction
     * input and output is sampled from this model version. When creating an
     * evaluation job, specify the model version in the following format:
     * "projects/&lt;var&gt;{project_id}&lt;/var&gt;/models/&lt;var&gt;{model_name}&lt;/var&gt;/versions/&lt;var&gt;{version_name}&lt;/var&gt;"
     * There can only be one evaluation job per model version.
     * </pre>
     *
     * <code>string model_version = 5;</code>
     *
     * @param value The modelVersion to set.
     * @return This builder for chaining.
     */
    public Builder setModelVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      modelVersion_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The [AI Platform Prediction model
     * version](/ml-engine/docs/prediction-overview) to be evaluated. Prediction
     * input and output is sampled from this model version. When creating an
     * evaluation job, specify the model version in the following format:
     * "projects/&lt;var&gt;{project_id}&lt;/var&gt;/models/&lt;var&gt;{model_name}&lt;/var&gt;/versions/&lt;var&gt;{version_name}&lt;/var&gt;"
     * There can only be one evaluation job per model version.
     * </pre>
     *
     * <code>string model_version = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearModelVersion() {

      modelVersion_ = getDefaultInstance().getModelVersion();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The [AI Platform Prediction model
     * version](/ml-engine/docs/prediction-overview) to be evaluated. Prediction
     * input and output is sampled from this model version. When creating an
     * evaluation job, specify the model version in the following format:
     * "projects/&lt;var&gt;{project_id}&lt;/var&gt;/models/&lt;var&gt;{model_name}&lt;/var&gt;/versions/&lt;var&gt;{version_name}&lt;/var&gt;"
     * There can only be one evaluation job per model version.
     * </pre>
     *
     * <code>string model_version = 5;</code>
     *
     * @param value The bytes for modelVersion to set.
     * @return This builder for chaining.
     */
    public Builder setModelVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      modelVersion_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig evaluationJobConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig,
            com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.EvaluationJobConfigOrBuilder>
        evaluationJobConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Configuration details for the evaluation job.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EvaluationJobConfig evaluation_job_config = 6;
     * </code>
     *
     * @return Whether the evaluationJobConfig field is set.
     */
    public boolean hasEvaluationJobConfig() {
      return evaluationJobConfigBuilder_ != null || evaluationJobConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. Configuration details for the evaluation job.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EvaluationJobConfig evaluation_job_config = 6;
     * </code>
     *
     * @return The evaluationJobConfig.
     */
    public com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig getEvaluationJobConfig() {
      if (evaluationJobConfigBuilder_ == null) {
        return evaluationJobConfig_ == null
            ? com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig.getDefaultInstance()
            : evaluationJobConfig_;
      } else {
        return evaluationJobConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Configuration details for the evaluation job.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EvaluationJobConfig evaluation_job_config = 6;
     * </code>
     */
    public Builder setEvaluationJobConfig(
        com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig value) {
      if (evaluationJobConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        evaluationJobConfig_ = value;
        onChanged();
      } else {
        evaluationJobConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Configuration details for the evaluation job.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EvaluationJobConfig evaluation_job_config = 6;
     * </code>
     */
    public Builder setEvaluationJobConfig(
        com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig.Builder builderForValue) {
      if (evaluationJobConfigBuilder_ == null) {
        evaluationJobConfig_ = builderForValue.build();
        onChanged();
      } else {
        evaluationJobConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Configuration details for the evaluation job.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EvaluationJobConfig evaluation_job_config = 6;
     * </code>
     */
    public Builder mergeEvaluationJobConfig(
        com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig value) {
      if (evaluationJobConfigBuilder_ == null) {
        if (evaluationJobConfig_ != null) {
          evaluationJobConfig_ =
              com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig.newBuilder(
                      evaluationJobConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          evaluationJobConfig_ = value;
        }
        onChanged();
      } else {
        evaluationJobConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Configuration details for the evaluation job.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EvaluationJobConfig evaluation_job_config = 6;
     * </code>
     */
    public Builder clearEvaluationJobConfig() {
      if (evaluationJobConfigBuilder_ == null) {
        evaluationJobConfig_ = null;
        onChanged();
      } else {
        evaluationJobConfig_ = null;
        evaluationJobConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Configuration details for the evaluation job.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EvaluationJobConfig evaluation_job_config = 6;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig.Builder
        getEvaluationJobConfigBuilder() {

      onChanged();
      return getEvaluationJobConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Configuration details for the evaluation job.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EvaluationJobConfig evaluation_job_config = 6;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.EvaluationJobConfigOrBuilder
        getEvaluationJobConfigOrBuilder() {
      if (evaluationJobConfigBuilder_ != null) {
        return evaluationJobConfigBuilder_.getMessageOrBuilder();
      } else {
        return evaluationJobConfig_ == null
            ? com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig.getDefaultInstance()
            : evaluationJobConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Configuration details for the evaluation job.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EvaluationJobConfig evaluation_job_config = 6;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig,
            com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.EvaluationJobConfigOrBuilder>
        getEvaluationJobConfigFieldBuilder() {
      if (evaluationJobConfigBuilder_ == null) {
        evaluationJobConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig,
                com.google.cloud.datalabeling.v1beta1.EvaluationJobConfig.Builder,
                com.google.cloud.datalabeling.v1beta1.EvaluationJobConfigOrBuilder>(
                getEvaluationJobConfig(), getParentForChildren(), isClean());
        evaluationJobConfig_ = null;
      }
      return evaluationJobConfigBuilder_;
    }

    private java.lang.Object annotationSpecSet_ = "";
    /**
     *
     *
     * <pre>
     * Required. Name of the [AnnotationSpecSet][google.cloud.datalabeling.v1beta1.AnnotationSpecSet] describing all the
     * labels that your machine learning model outputs. You must create this
     * resource before you create an evaluation job and provide its name in the
     * following format:
     * "projects/&lt;var&gt;{project_id}&lt;/var&gt;/annotationSpecSets/&lt;var&gt;{annotation_spec_set_id}&lt;/var&gt;"
     * </pre>
     *
     * <code>string annotation_spec_set = 7;</code>
     *
     * @return The annotationSpecSet.
     */
    public java.lang.String getAnnotationSpecSet() {
      java.lang.Object ref = annotationSpecSet_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        annotationSpecSet_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the [AnnotationSpecSet][google.cloud.datalabeling.v1beta1.AnnotationSpecSet] describing all the
     * labels that your machine learning model outputs. You must create this
     * resource before you create an evaluation job and provide its name in the
     * following format:
     * "projects/&lt;var&gt;{project_id}&lt;/var&gt;/annotationSpecSets/&lt;var&gt;{annotation_spec_set_id}&lt;/var&gt;"
     * </pre>
     *
     * <code>string annotation_spec_set = 7;</code>
     *
     * @return The bytes for annotationSpecSet.
     */
    public com.google.protobuf.ByteString getAnnotationSpecSetBytes() {
      java.lang.Object ref = annotationSpecSet_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        annotationSpecSet_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the [AnnotationSpecSet][google.cloud.datalabeling.v1beta1.AnnotationSpecSet] describing all the
     * labels that your machine learning model outputs. You must create this
     * resource before you create an evaluation job and provide its name in the
     * following format:
     * "projects/&lt;var&gt;{project_id}&lt;/var&gt;/annotationSpecSets/&lt;var&gt;{annotation_spec_set_id}&lt;/var&gt;"
     * </pre>
     *
     * <code>string annotation_spec_set = 7;</code>
     *
     * @param value The annotationSpecSet to set.
     * @return This builder for chaining.
     */
    public Builder setAnnotationSpecSet(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      annotationSpecSet_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the [AnnotationSpecSet][google.cloud.datalabeling.v1beta1.AnnotationSpecSet] describing all the
     * labels that your machine learning model outputs. You must create this
     * resource before you create an evaluation job and provide its name in the
     * following format:
     * "projects/&lt;var&gt;{project_id}&lt;/var&gt;/annotationSpecSets/&lt;var&gt;{annotation_spec_set_id}&lt;/var&gt;"
     * </pre>
     *
     * <code>string annotation_spec_set = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAnnotationSpecSet() {

      annotationSpecSet_ = getDefaultInstance().getAnnotationSpecSet();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the [AnnotationSpecSet][google.cloud.datalabeling.v1beta1.AnnotationSpecSet] describing all the
     * labels that your machine learning model outputs. You must create this
     * resource before you create an evaluation job and provide its name in the
     * following format:
     * "projects/&lt;var&gt;{project_id}&lt;/var&gt;/annotationSpecSets/&lt;var&gt;{annotation_spec_set_id}&lt;/var&gt;"
     * </pre>
     *
     * <code>string annotation_spec_set = 7;</code>
     *
     * @param value The bytes for annotationSpecSet to set.
     * @return This builder for chaining.
     */
    public Builder setAnnotationSpecSetBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      annotationSpecSet_ = value;
      onChanged();
      return this;
    }

    private boolean labelMissingGroundTruth_;
    /**
     *
     *
     * <pre>
     * Required. Whether you want Data Labeling Service to provide ground truth
     * labels for prediction input. If you want the service to assign human
     * labelers to annotate your data, set this to `true`. If you want to provide
     * your own ground truth labels in the evaluation job's BigQuery table, set
     * this to `false`.
     * </pre>
     *
     * <code>bool label_missing_ground_truth = 8;</code>
     *
     * @return The labelMissingGroundTruth.
     */
    public boolean getLabelMissingGroundTruth() {
      return labelMissingGroundTruth_;
    }
    /**
     *
     *
     * <pre>
     * Required. Whether you want Data Labeling Service to provide ground truth
     * labels for prediction input. If you want the service to assign human
     * labelers to annotate your data, set this to `true`. If you want to provide
     * your own ground truth labels in the evaluation job's BigQuery table, set
     * this to `false`.
     * </pre>
     *
     * <code>bool label_missing_ground_truth = 8;</code>
     *
     * @param value The labelMissingGroundTruth to set.
     * @return This builder for chaining.
     */
    public Builder setLabelMissingGroundTruth(boolean value) {

      labelMissingGroundTruth_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Whether you want Data Labeling Service to provide ground truth
     * labels for prediction input. If you want the service to assign human
     * labelers to annotate your data, set this to `true`. If you want to provide
     * your own ground truth labels in the evaluation job's BigQuery table, set
     * this to `false`.
     * </pre>
     *
     * <code>bool label_missing_ground_truth = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLabelMissingGroundTruth() {

      labelMissingGroundTruth_ = false;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.datalabeling.v1beta1.Attempt> attempts_ =
        java.util.Collections.emptyList();

    private void ensureAttemptsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        attempts_ =
            new java.util.ArrayList<com.google.cloud.datalabeling.v1beta1.Attempt>(attempts_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.Attempt,
            com.google.cloud.datalabeling.v1beta1.Attempt.Builder,
            com.google.cloud.datalabeling.v1beta1.AttemptOrBuilder>
        attemptsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Every time the evaluation job runs and an error occurs, the
     * failed attempt is appended to this array.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.Attempt attempts = 9;</code>
     */
    public java.util.List<com.google.cloud.datalabeling.v1beta1.Attempt> getAttemptsList() {
      if (attemptsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(attempts_);
      } else {
        return attemptsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Every time the evaluation job runs and an error occurs, the
     * failed attempt is appended to this array.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.Attempt attempts = 9;</code>
     */
    public int getAttemptsCount() {
      if (attemptsBuilder_ == null) {
        return attempts_.size();
      } else {
        return attemptsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Every time the evaluation job runs and an error occurs, the
     * failed attempt is appended to this array.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.Attempt attempts = 9;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.Attempt getAttempts(int index) {
      if (attemptsBuilder_ == null) {
        return attempts_.get(index);
      } else {
        return attemptsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Every time the evaluation job runs and an error occurs, the
     * failed attempt is appended to this array.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.Attempt attempts = 9;</code>
     */
    public Builder setAttempts(int index, com.google.cloud.datalabeling.v1beta1.Attempt value) {
      if (attemptsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAttemptsIsMutable();
        attempts_.set(index, value);
        onChanged();
      } else {
        attemptsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Every time the evaluation job runs and an error occurs, the
     * failed attempt is appended to this array.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.Attempt attempts = 9;</code>
     */
    public Builder setAttempts(
        int index, com.google.cloud.datalabeling.v1beta1.Attempt.Builder builderForValue) {
      if (attemptsBuilder_ == null) {
        ensureAttemptsIsMutable();
        attempts_.set(index, builderForValue.build());
        onChanged();
      } else {
        attemptsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Every time the evaluation job runs and an error occurs, the
     * failed attempt is appended to this array.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.Attempt attempts = 9;</code>
     */
    public Builder addAttempts(com.google.cloud.datalabeling.v1beta1.Attempt value) {
      if (attemptsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAttemptsIsMutable();
        attempts_.add(value);
        onChanged();
      } else {
        attemptsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Every time the evaluation job runs and an error occurs, the
     * failed attempt is appended to this array.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.Attempt attempts = 9;</code>
     */
    public Builder addAttempts(int index, com.google.cloud.datalabeling.v1beta1.Attempt value) {
      if (attemptsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAttemptsIsMutable();
        attempts_.add(index, value);
        onChanged();
      } else {
        attemptsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Every time the evaluation job runs and an error occurs, the
     * failed attempt is appended to this array.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.Attempt attempts = 9;</code>
     */
    public Builder addAttempts(
        com.google.cloud.datalabeling.v1beta1.Attempt.Builder builderForValue) {
      if (attemptsBuilder_ == null) {
        ensureAttemptsIsMutable();
        attempts_.add(builderForValue.build());
        onChanged();
      } else {
        attemptsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Every time the evaluation job runs and an error occurs, the
     * failed attempt is appended to this array.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.Attempt attempts = 9;</code>
     */
    public Builder addAttempts(
        int index, com.google.cloud.datalabeling.v1beta1.Attempt.Builder builderForValue) {
      if (attemptsBuilder_ == null) {
        ensureAttemptsIsMutable();
        attempts_.add(index, builderForValue.build());
        onChanged();
      } else {
        attemptsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Every time the evaluation job runs and an error occurs, the
     * failed attempt is appended to this array.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.Attempt attempts = 9;</code>
     */
    public Builder addAllAttempts(
        java.lang.Iterable<? extends com.google.cloud.datalabeling.v1beta1.Attempt> values) {
      if (attemptsBuilder_ == null) {
        ensureAttemptsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, attempts_);
        onChanged();
      } else {
        attemptsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Every time the evaluation job runs and an error occurs, the
     * failed attempt is appended to this array.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.Attempt attempts = 9;</code>
     */
    public Builder clearAttempts() {
      if (attemptsBuilder_ == null) {
        attempts_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        attemptsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Every time the evaluation job runs and an error occurs, the
     * failed attempt is appended to this array.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.Attempt attempts = 9;</code>
     */
    public Builder removeAttempts(int index) {
      if (attemptsBuilder_ == null) {
        ensureAttemptsIsMutable();
        attempts_.remove(index);
        onChanged();
      } else {
        attemptsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Every time the evaluation job runs and an error occurs, the
     * failed attempt is appended to this array.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.Attempt attempts = 9;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.Attempt.Builder getAttemptsBuilder(int index) {
      return getAttemptsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Every time the evaluation job runs and an error occurs, the
     * failed attempt is appended to this array.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.Attempt attempts = 9;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.AttemptOrBuilder getAttemptsOrBuilder(int index) {
      if (attemptsBuilder_ == null) {
        return attempts_.get(index);
      } else {
        return attemptsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Every time the evaluation job runs and an error occurs, the
     * failed attempt is appended to this array.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.Attempt attempts = 9;</code>
     */
    public java.util.List<? extends com.google.cloud.datalabeling.v1beta1.AttemptOrBuilder>
        getAttemptsOrBuilderList() {
      if (attemptsBuilder_ != null) {
        return attemptsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(attempts_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Every time the evaluation job runs and an error occurs, the
     * failed attempt is appended to this array.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.Attempt attempts = 9;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.Attempt.Builder addAttemptsBuilder() {
      return getAttemptsFieldBuilder()
          .addBuilder(com.google.cloud.datalabeling.v1beta1.Attempt.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Every time the evaluation job runs and an error occurs, the
     * failed attempt is appended to this array.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.Attempt attempts = 9;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.Attempt.Builder addAttemptsBuilder(int index) {
      return getAttemptsFieldBuilder()
          .addBuilder(index, com.google.cloud.datalabeling.v1beta1.Attempt.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Every time the evaluation job runs and an error occurs, the
     * failed attempt is appended to this array.
     * </pre>
     *
     * <code>repeated .google.cloud.datalabeling.v1beta1.Attempt attempts = 9;</code>
     */
    public java.util.List<com.google.cloud.datalabeling.v1beta1.Attempt.Builder>
        getAttemptsBuilderList() {
      return getAttemptsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.Attempt,
            com.google.cloud.datalabeling.v1beta1.Attempt.Builder,
            com.google.cloud.datalabeling.v1beta1.AttemptOrBuilder>
        getAttemptsFieldBuilder() {
      if (attemptsBuilder_ == null) {
        attemptsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.Attempt,
                com.google.cloud.datalabeling.v1beta1.Attempt.Builder,
                com.google.cloud.datalabeling.v1beta1.AttemptOrBuilder>(
                attempts_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        attempts_ = null;
      }
      return attemptsBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp of when this evaluation job was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 10;</code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return createTimeBuilder_ != null || createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp of when this evaluation job was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 10;</code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp of when this evaluation job was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 10;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
        onChanged();
      } else {
        createTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp of when this evaluation job was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 10;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
        onChanged();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp of when this evaluation job was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 10;</code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (createTime_ != null) {
          createTime_ =
              com.google.protobuf.Timestamp.newBuilder(createTime_).mergeFrom(value).buildPartial();
        } else {
          createTime_ = value;
        }
        onChanged();
      } else {
        createTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp of when this evaluation job was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 10;</code>
     */
    public Builder clearCreateTime() {
      if (createTimeBuilder_ == null) {
        createTime_ = null;
        onChanged();
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp of when this evaluation job was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 10;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {

      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp of when this evaluation job was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 10;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp of when this evaluation job was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datalabeling.v1beta1.EvaluationJob)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datalabeling.v1beta1.EvaluationJob)
  private static final com.google.cloud.datalabeling.v1beta1.EvaluationJob DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datalabeling.v1beta1.EvaluationJob();
  }

  public static com.google.cloud.datalabeling.v1beta1.EvaluationJob getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<EvaluationJob> PARSER =
      new com.google.protobuf.AbstractParser<EvaluationJob>() {
        @java.lang.Override
        public EvaluationJob parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new EvaluationJob(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<EvaluationJob> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<EvaluationJob> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.EvaluationJob getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
