/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datalabeling/v1beta1/annotation.proto

package com.google.cloud.datalabeling.v1beta1;

/**
 *
 *
 * <pre>
 * Image bounding poly annotation. It represents a polygon including
 * bounding box in the image.
 * </pre>
 *
 * Protobuf type {@code google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation}
 */
public final class ImageBoundingPolyAnnotation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation)
    ImageBoundingPolyAnnotationOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ImageBoundingPolyAnnotation.newBuilder() to construct.
  private ImageBoundingPolyAnnotation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ImageBoundingPolyAnnotation() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ImageBoundingPolyAnnotation();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private ImageBoundingPolyAnnotation(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              com.google.cloud.datalabeling.v1beta1.AnnotationSpec.Builder subBuilder = null;
              if (annotationSpec_ != null) {
                subBuilder = annotationSpec_.toBuilder();
              }
              annotationSpec_ =
                  input.readMessage(
                      com.google.cloud.datalabeling.v1beta1.AnnotationSpec.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(annotationSpec_);
                annotationSpec_ = subBuilder.buildPartial();
              }

              break;
            }
          case 18:
            {
              com.google.cloud.datalabeling.v1beta1.BoundingPoly.Builder subBuilder = null;
              if (boundedAreaCase_ == 2) {
                subBuilder =
                    ((com.google.cloud.datalabeling.v1beta1.BoundingPoly) boundedArea_).toBuilder();
              }
              boundedArea_ =
                  input.readMessage(
                      com.google.cloud.datalabeling.v1beta1.BoundingPoly.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.datalabeling.v1beta1.BoundingPoly) boundedArea_);
                boundedArea_ = subBuilder.buildPartial();
              }
              boundedAreaCase_ = 2;
              break;
            }
          case 26:
            {
              com.google.cloud.datalabeling.v1beta1.NormalizedBoundingPoly.Builder subBuilder =
                  null;
              if (boundedAreaCase_ == 3) {
                subBuilder =
                    ((com.google.cloud.datalabeling.v1beta1.NormalizedBoundingPoly) boundedArea_)
                        .toBuilder();
              }
              boundedArea_ =
                  input.readMessage(
                      com.google.cloud.datalabeling.v1beta1.NormalizedBoundingPoly.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.datalabeling.v1beta1.NormalizedBoundingPoly) boundedArea_);
                boundedArea_ = subBuilder.buildPartial();
              }
              boundedAreaCase_ = 3;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datalabeling.v1beta1.AnnotationOuterClass
        .internal_static_google_cloud_datalabeling_v1beta1_ImageBoundingPolyAnnotation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datalabeling.v1beta1.AnnotationOuterClass
        .internal_static_google_cloud_datalabeling_v1beta1_ImageBoundingPolyAnnotation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation.class,
            com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation.Builder.class);
  }

  private int boundedAreaCase_ = 0;
  private java.lang.Object boundedArea_;

  public enum BoundedAreaCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    BOUNDING_POLY(2),
    NORMALIZED_BOUNDING_POLY(3),
    BOUNDEDAREA_NOT_SET(0);
    private final int value;

    private BoundedAreaCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static BoundedAreaCase valueOf(int value) {
      return forNumber(value);
    }

    public static BoundedAreaCase forNumber(int value) {
      switch (value) {
        case 2:
          return BOUNDING_POLY;
        case 3:
          return NORMALIZED_BOUNDING_POLY;
        case 0:
          return BOUNDEDAREA_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public BoundedAreaCase getBoundedAreaCase() {
    return BoundedAreaCase.forNumber(boundedAreaCase_);
  }

  public static final int BOUNDING_POLY_FIELD_NUMBER = 2;
  /**
   * <code>.google.cloud.datalabeling.v1beta1.BoundingPoly bounding_poly = 2;</code>
   *
   * @return Whether the boundingPoly field is set.
   */
  public boolean hasBoundingPoly() {
    return boundedAreaCase_ == 2;
  }
  /**
   * <code>.google.cloud.datalabeling.v1beta1.BoundingPoly bounding_poly = 2;</code>
   *
   * @return The boundingPoly.
   */
  public com.google.cloud.datalabeling.v1beta1.BoundingPoly getBoundingPoly() {
    if (boundedAreaCase_ == 2) {
      return (com.google.cloud.datalabeling.v1beta1.BoundingPoly) boundedArea_;
    }
    return com.google.cloud.datalabeling.v1beta1.BoundingPoly.getDefaultInstance();
  }
  /** <code>.google.cloud.datalabeling.v1beta1.BoundingPoly bounding_poly = 2;</code> */
  public com.google.cloud.datalabeling.v1beta1.BoundingPolyOrBuilder getBoundingPolyOrBuilder() {
    if (boundedAreaCase_ == 2) {
      return (com.google.cloud.datalabeling.v1beta1.BoundingPoly) boundedArea_;
    }
    return com.google.cloud.datalabeling.v1beta1.BoundingPoly.getDefaultInstance();
  }

  public static final int NORMALIZED_BOUNDING_POLY_FIELD_NUMBER = 3;
  /**
   * <code>.google.cloud.datalabeling.v1beta1.NormalizedBoundingPoly normalized_bounding_poly = 3;
   * </code>
   *
   * @return Whether the normalizedBoundingPoly field is set.
   */
  public boolean hasNormalizedBoundingPoly() {
    return boundedAreaCase_ == 3;
  }
  /**
   * <code>.google.cloud.datalabeling.v1beta1.NormalizedBoundingPoly normalized_bounding_poly = 3;
   * </code>
   *
   * @return The normalizedBoundingPoly.
   */
  public com.google.cloud.datalabeling.v1beta1.NormalizedBoundingPoly getNormalizedBoundingPoly() {
    if (boundedAreaCase_ == 3) {
      return (com.google.cloud.datalabeling.v1beta1.NormalizedBoundingPoly) boundedArea_;
    }
    return com.google.cloud.datalabeling.v1beta1.NormalizedBoundingPoly.getDefaultInstance();
  }
  /**
   * <code>.google.cloud.datalabeling.v1beta1.NormalizedBoundingPoly normalized_bounding_poly = 3;
   * </code>
   */
  public com.google.cloud.datalabeling.v1beta1.NormalizedBoundingPolyOrBuilder
      getNormalizedBoundingPolyOrBuilder() {
    if (boundedAreaCase_ == 3) {
      return (com.google.cloud.datalabeling.v1beta1.NormalizedBoundingPoly) boundedArea_;
    }
    return com.google.cloud.datalabeling.v1beta1.NormalizedBoundingPoly.getDefaultInstance();
  }

  public static final int ANNOTATION_SPEC_FIELD_NUMBER = 1;
  private com.google.cloud.datalabeling.v1beta1.AnnotationSpec annotationSpec_;
  /**
   *
   *
   * <pre>
   * Label of object in this bounding polygon.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
   *
   * @return Whether the annotationSpec field is set.
   */
  public boolean hasAnnotationSpec() {
    return annotationSpec_ != null;
  }
  /**
   *
   *
   * <pre>
   * Label of object in this bounding polygon.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
   *
   * @return The annotationSpec.
   */
  public com.google.cloud.datalabeling.v1beta1.AnnotationSpec getAnnotationSpec() {
    return annotationSpec_ == null
        ? com.google.cloud.datalabeling.v1beta1.AnnotationSpec.getDefaultInstance()
        : annotationSpec_;
  }
  /**
   *
   *
   * <pre>
   * Label of object in this bounding polygon.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
   */
  public com.google.cloud.datalabeling.v1beta1.AnnotationSpecOrBuilder
      getAnnotationSpecOrBuilder() {
    return getAnnotationSpec();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (annotationSpec_ != null) {
      output.writeMessage(1, getAnnotationSpec());
    }
    if (boundedAreaCase_ == 2) {
      output.writeMessage(2, (com.google.cloud.datalabeling.v1beta1.BoundingPoly) boundedArea_);
    }
    if (boundedAreaCase_ == 3) {
      output.writeMessage(
          3, (com.google.cloud.datalabeling.v1beta1.NormalizedBoundingPoly) boundedArea_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (annotationSpec_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getAnnotationSpec());
    }
    if (boundedAreaCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.datalabeling.v1beta1.BoundingPoly) boundedArea_);
    }
    if (boundedAreaCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.datalabeling.v1beta1.NormalizedBoundingPoly) boundedArea_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation)) {
      return super.equals(obj);
    }
    com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation other =
        (com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation) obj;

    if (hasAnnotationSpec() != other.hasAnnotationSpec()) return false;
    if (hasAnnotationSpec()) {
      if (!getAnnotationSpec().equals(other.getAnnotationSpec())) return false;
    }
    if (!getBoundedAreaCase().equals(other.getBoundedAreaCase())) return false;
    switch (boundedAreaCase_) {
      case 2:
        if (!getBoundingPoly().equals(other.getBoundingPoly())) return false;
        break;
      case 3:
        if (!getNormalizedBoundingPoly().equals(other.getNormalizedBoundingPoly())) return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasAnnotationSpec()) {
      hash = (37 * hash) + ANNOTATION_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getAnnotationSpec().hashCode();
    }
    switch (boundedAreaCase_) {
      case 2:
        hash = (37 * hash) + BOUNDING_POLY_FIELD_NUMBER;
        hash = (53 * hash) + getBoundingPoly().hashCode();
        break;
      case 3:
        hash = (37 * hash) + NORMALIZED_BOUNDING_POLY_FIELD_NUMBER;
        hash = (53 * hash) + getNormalizedBoundingPoly().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Image bounding poly annotation. It represents a polygon including
   * bounding box in the image.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation)
      com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datalabeling.v1beta1.AnnotationOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_ImageBoundingPolyAnnotation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datalabeling.v1beta1.AnnotationOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_ImageBoundingPolyAnnotation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation.class,
              com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation.Builder.class);
    }

    // Construct using
    // com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (annotationSpecBuilder_ == null) {
        annotationSpec_ = null;
      } else {
        annotationSpec_ = null;
        annotationSpecBuilder_ = null;
      }
      boundedAreaCase_ = 0;
      boundedArea_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datalabeling.v1beta1.AnnotationOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_ImageBoundingPolyAnnotation_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation
        getDefaultInstanceForType() {
      return com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation build() {
      com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation buildPartial() {
      com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation result =
          new com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation(this);
      if (boundedAreaCase_ == 2) {
        if (boundingPolyBuilder_ == null) {
          result.boundedArea_ = boundedArea_;
        } else {
          result.boundedArea_ = boundingPolyBuilder_.build();
        }
      }
      if (boundedAreaCase_ == 3) {
        if (normalizedBoundingPolyBuilder_ == null) {
          result.boundedArea_ = boundedArea_;
        } else {
          result.boundedArea_ = normalizedBoundingPolyBuilder_.build();
        }
      }
      if (annotationSpecBuilder_ == null) {
        result.annotationSpec_ = annotationSpec_;
      } else {
        result.annotationSpec_ = annotationSpecBuilder_.build();
      }
      result.boundedAreaCase_ = boundedAreaCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation) {
        return mergeFrom((com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation other) {
      if (other
          == com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation.getDefaultInstance())
        return this;
      if (other.hasAnnotationSpec()) {
        mergeAnnotationSpec(other.getAnnotationSpec());
      }
      switch (other.getBoundedAreaCase()) {
        case BOUNDING_POLY:
          {
            mergeBoundingPoly(other.getBoundingPoly());
            break;
          }
        case NORMALIZED_BOUNDING_POLY:
          {
            mergeNormalizedBoundingPoly(other.getNormalizedBoundingPoly());
            break;
          }
        case BOUNDEDAREA_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation)
                e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int boundedAreaCase_ = 0;
    private java.lang.Object boundedArea_;

    public BoundedAreaCase getBoundedAreaCase() {
      return BoundedAreaCase.forNumber(boundedAreaCase_);
    }

    public Builder clearBoundedArea() {
      boundedAreaCase_ = 0;
      boundedArea_ = null;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.BoundingPoly,
            com.google.cloud.datalabeling.v1beta1.BoundingPoly.Builder,
            com.google.cloud.datalabeling.v1beta1.BoundingPolyOrBuilder>
        boundingPolyBuilder_;
    /**
     * <code>.google.cloud.datalabeling.v1beta1.BoundingPoly bounding_poly = 2;</code>
     *
     * @return Whether the boundingPoly field is set.
     */
    public boolean hasBoundingPoly() {
      return boundedAreaCase_ == 2;
    }
    /**
     * <code>.google.cloud.datalabeling.v1beta1.BoundingPoly bounding_poly = 2;</code>
     *
     * @return The boundingPoly.
     */
    public com.google.cloud.datalabeling.v1beta1.BoundingPoly getBoundingPoly() {
      if (boundingPolyBuilder_ == null) {
        if (boundedAreaCase_ == 2) {
          return (com.google.cloud.datalabeling.v1beta1.BoundingPoly) boundedArea_;
        }
        return com.google.cloud.datalabeling.v1beta1.BoundingPoly.getDefaultInstance();
      } else {
        if (boundedAreaCase_ == 2) {
          return boundingPolyBuilder_.getMessage();
        }
        return com.google.cloud.datalabeling.v1beta1.BoundingPoly.getDefaultInstance();
      }
    }
    /** <code>.google.cloud.datalabeling.v1beta1.BoundingPoly bounding_poly = 2;</code> */
    public Builder setBoundingPoly(com.google.cloud.datalabeling.v1beta1.BoundingPoly value) {
      if (boundingPolyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        boundedArea_ = value;
        onChanged();
      } else {
        boundingPolyBuilder_.setMessage(value);
      }
      boundedAreaCase_ = 2;
      return this;
    }
    /** <code>.google.cloud.datalabeling.v1beta1.BoundingPoly bounding_poly = 2;</code> */
    public Builder setBoundingPoly(
        com.google.cloud.datalabeling.v1beta1.BoundingPoly.Builder builderForValue) {
      if (boundingPolyBuilder_ == null) {
        boundedArea_ = builderForValue.build();
        onChanged();
      } else {
        boundingPolyBuilder_.setMessage(builderForValue.build());
      }
      boundedAreaCase_ = 2;
      return this;
    }
    /** <code>.google.cloud.datalabeling.v1beta1.BoundingPoly bounding_poly = 2;</code> */
    public Builder mergeBoundingPoly(com.google.cloud.datalabeling.v1beta1.BoundingPoly value) {
      if (boundingPolyBuilder_ == null) {
        if (boundedAreaCase_ == 2
            && boundedArea_
                != com.google.cloud.datalabeling.v1beta1.BoundingPoly.getDefaultInstance()) {
          boundedArea_ =
              com.google.cloud.datalabeling.v1beta1.BoundingPoly.newBuilder(
                      (com.google.cloud.datalabeling.v1beta1.BoundingPoly) boundedArea_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          boundedArea_ = value;
        }
        onChanged();
      } else {
        if (boundedAreaCase_ == 2) {
          boundingPolyBuilder_.mergeFrom(value);
        }
        boundingPolyBuilder_.setMessage(value);
      }
      boundedAreaCase_ = 2;
      return this;
    }
    /** <code>.google.cloud.datalabeling.v1beta1.BoundingPoly bounding_poly = 2;</code> */
    public Builder clearBoundingPoly() {
      if (boundingPolyBuilder_ == null) {
        if (boundedAreaCase_ == 2) {
          boundedAreaCase_ = 0;
          boundedArea_ = null;
          onChanged();
        }
      } else {
        if (boundedAreaCase_ == 2) {
          boundedAreaCase_ = 0;
          boundedArea_ = null;
        }
        boundingPolyBuilder_.clear();
      }
      return this;
    }
    /** <code>.google.cloud.datalabeling.v1beta1.BoundingPoly bounding_poly = 2;</code> */
    public com.google.cloud.datalabeling.v1beta1.BoundingPoly.Builder getBoundingPolyBuilder() {
      return getBoundingPolyFieldBuilder().getBuilder();
    }
    /** <code>.google.cloud.datalabeling.v1beta1.BoundingPoly bounding_poly = 2;</code> */
    public com.google.cloud.datalabeling.v1beta1.BoundingPolyOrBuilder getBoundingPolyOrBuilder() {
      if ((boundedAreaCase_ == 2) && (boundingPolyBuilder_ != null)) {
        return boundingPolyBuilder_.getMessageOrBuilder();
      } else {
        if (boundedAreaCase_ == 2) {
          return (com.google.cloud.datalabeling.v1beta1.BoundingPoly) boundedArea_;
        }
        return com.google.cloud.datalabeling.v1beta1.BoundingPoly.getDefaultInstance();
      }
    }
    /** <code>.google.cloud.datalabeling.v1beta1.BoundingPoly bounding_poly = 2;</code> */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.BoundingPoly,
            com.google.cloud.datalabeling.v1beta1.BoundingPoly.Builder,
            com.google.cloud.datalabeling.v1beta1.BoundingPolyOrBuilder>
        getBoundingPolyFieldBuilder() {
      if (boundingPolyBuilder_ == null) {
        if (!(boundedAreaCase_ == 2)) {
          boundedArea_ = com.google.cloud.datalabeling.v1beta1.BoundingPoly.getDefaultInstance();
        }
        boundingPolyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.BoundingPoly,
                com.google.cloud.datalabeling.v1beta1.BoundingPoly.Builder,
                com.google.cloud.datalabeling.v1beta1.BoundingPolyOrBuilder>(
                (com.google.cloud.datalabeling.v1beta1.BoundingPoly) boundedArea_,
                getParentForChildren(),
                isClean());
        boundedArea_ = null;
      }
      boundedAreaCase_ = 2;
      onChanged();
      ;
      return boundingPolyBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.NormalizedBoundingPoly,
            com.google.cloud.datalabeling.v1beta1.NormalizedBoundingPoly.Builder,
            com.google.cloud.datalabeling.v1beta1.NormalizedBoundingPolyOrBuilder>
        normalizedBoundingPolyBuilder_;
    /**
     * <code>.google.cloud.datalabeling.v1beta1.NormalizedBoundingPoly normalized_bounding_poly = 3;
     * </code>
     *
     * @return Whether the normalizedBoundingPoly field is set.
     */
    public boolean hasNormalizedBoundingPoly() {
      return boundedAreaCase_ == 3;
    }
    /**
     * <code>.google.cloud.datalabeling.v1beta1.NormalizedBoundingPoly normalized_bounding_poly = 3;
     * </code>
     *
     * @return The normalizedBoundingPoly.
     */
    public com.google.cloud.datalabeling.v1beta1.NormalizedBoundingPoly
        getNormalizedBoundingPoly() {
      if (normalizedBoundingPolyBuilder_ == null) {
        if (boundedAreaCase_ == 3) {
          return (com.google.cloud.datalabeling.v1beta1.NormalizedBoundingPoly) boundedArea_;
        }
        return com.google.cloud.datalabeling.v1beta1.NormalizedBoundingPoly.getDefaultInstance();
      } else {
        if (boundedAreaCase_ == 3) {
          return normalizedBoundingPolyBuilder_.getMessage();
        }
        return com.google.cloud.datalabeling.v1beta1.NormalizedBoundingPoly.getDefaultInstance();
      }
    }
    /**
     * <code>.google.cloud.datalabeling.v1beta1.NormalizedBoundingPoly normalized_bounding_poly = 3;
     * </code>
     */
    public Builder setNormalizedBoundingPoly(
        com.google.cloud.datalabeling.v1beta1.NormalizedBoundingPoly value) {
      if (normalizedBoundingPolyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        boundedArea_ = value;
        onChanged();
      } else {
        normalizedBoundingPolyBuilder_.setMessage(value);
      }
      boundedAreaCase_ = 3;
      return this;
    }
    /**
     * <code>.google.cloud.datalabeling.v1beta1.NormalizedBoundingPoly normalized_bounding_poly = 3;
     * </code>
     */
    public Builder setNormalizedBoundingPoly(
        com.google.cloud.datalabeling.v1beta1.NormalizedBoundingPoly.Builder builderForValue) {
      if (normalizedBoundingPolyBuilder_ == null) {
        boundedArea_ = builderForValue.build();
        onChanged();
      } else {
        normalizedBoundingPolyBuilder_.setMessage(builderForValue.build());
      }
      boundedAreaCase_ = 3;
      return this;
    }
    /**
     * <code>.google.cloud.datalabeling.v1beta1.NormalizedBoundingPoly normalized_bounding_poly = 3;
     * </code>
     */
    public Builder mergeNormalizedBoundingPoly(
        com.google.cloud.datalabeling.v1beta1.NormalizedBoundingPoly value) {
      if (normalizedBoundingPolyBuilder_ == null) {
        if (boundedAreaCase_ == 3
            && boundedArea_
                != com.google.cloud.datalabeling.v1beta1.NormalizedBoundingPoly
                    .getDefaultInstance()) {
          boundedArea_ =
              com.google.cloud.datalabeling.v1beta1.NormalizedBoundingPoly.newBuilder(
                      (com.google.cloud.datalabeling.v1beta1.NormalizedBoundingPoly) boundedArea_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          boundedArea_ = value;
        }
        onChanged();
      } else {
        if (boundedAreaCase_ == 3) {
          normalizedBoundingPolyBuilder_.mergeFrom(value);
        }
        normalizedBoundingPolyBuilder_.setMessage(value);
      }
      boundedAreaCase_ = 3;
      return this;
    }
    /**
     * <code>.google.cloud.datalabeling.v1beta1.NormalizedBoundingPoly normalized_bounding_poly = 3;
     * </code>
     */
    public Builder clearNormalizedBoundingPoly() {
      if (normalizedBoundingPolyBuilder_ == null) {
        if (boundedAreaCase_ == 3) {
          boundedAreaCase_ = 0;
          boundedArea_ = null;
          onChanged();
        }
      } else {
        if (boundedAreaCase_ == 3) {
          boundedAreaCase_ = 0;
          boundedArea_ = null;
        }
        normalizedBoundingPolyBuilder_.clear();
      }
      return this;
    }
    /**
     * <code>.google.cloud.datalabeling.v1beta1.NormalizedBoundingPoly normalized_bounding_poly = 3;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.NormalizedBoundingPoly.Builder
        getNormalizedBoundingPolyBuilder() {
      return getNormalizedBoundingPolyFieldBuilder().getBuilder();
    }
    /**
     * <code>.google.cloud.datalabeling.v1beta1.NormalizedBoundingPoly normalized_bounding_poly = 3;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.NormalizedBoundingPolyOrBuilder
        getNormalizedBoundingPolyOrBuilder() {
      if ((boundedAreaCase_ == 3) && (normalizedBoundingPolyBuilder_ != null)) {
        return normalizedBoundingPolyBuilder_.getMessageOrBuilder();
      } else {
        if (boundedAreaCase_ == 3) {
          return (com.google.cloud.datalabeling.v1beta1.NormalizedBoundingPoly) boundedArea_;
        }
        return com.google.cloud.datalabeling.v1beta1.NormalizedBoundingPoly.getDefaultInstance();
      }
    }
    /**
     * <code>.google.cloud.datalabeling.v1beta1.NormalizedBoundingPoly normalized_bounding_poly = 3;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.NormalizedBoundingPoly,
            com.google.cloud.datalabeling.v1beta1.NormalizedBoundingPoly.Builder,
            com.google.cloud.datalabeling.v1beta1.NormalizedBoundingPolyOrBuilder>
        getNormalizedBoundingPolyFieldBuilder() {
      if (normalizedBoundingPolyBuilder_ == null) {
        if (!(boundedAreaCase_ == 3)) {
          boundedArea_ =
              com.google.cloud.datalabeling.v1beta1.NormalizedBoundingPoly.getDefaultInstance();
        }
        normalizedBoundingPolyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.NormalizedBoundingPoly,
                com.google.cloud.datalabeling.v1beta1.NormalizedBoundingPoly.Builder,
                com.google.cloud.datalabeling.v1beta1.NormalizedBoundingPolyOrBuilder>(
                (com.google.cloud.datalabeling.v1beta1.NormalizedBoundingPoly) boundedArea_,
                getParentForChildren(),
                isClean());
        boundedArea_ = null;
      }
      boundedAreaCase_ = 3;
      onChanged();
      ;
      return normalizedBoundingPolyBuilder_;
    }

    private com.google.cloud.datalabeling.v1beta1.AnnotationSpec annotationSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.AnnotationSpec,
            com.google.cloud.datalabeling.v1beta1.AnnotationSpec.Builder,
            com.google.cloud.datalabeling.v1beta1.AnnotationSpecOrBuilder>
        annotationSpecBuilder_;
    /**
     *
     *
     * <pre>
     * Label of object in this bounding polygon.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
     *
     * @return Whether the annotationSpec field is set.
     */
    public boolean hasAnnotationSpec() {
      return annotationSpecBuilder_ != null || annotationSpec_ != null;
    }
    /**
     *
     *
     * <pre>
     * Label of object in this bounding polygon.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
     *
     * @return The annotationSpec.
     */
    public com.google.cloud.datalabeling.v1beta1.AnnotationSpec getAnnotationSpec() {
      if (annotationSpecBuilder_ == null) {
        return annotationSpec_ == null
            ? com.google.cloud.datalabeling.v1beta1.AnnotationSpec.getDefaultInstance()
            : annotationSpec_;
      } else {
        return annotationSpecBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Label of object in this bounding polygon.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
     */
    public Builder setAnnotationSpec(com.google.cloud.datalabeling.v1beta1.AnnotationSpec value) {
      if (annotationSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        annotationSpec_ = value;
        onChanged();
      } else {
        annotationSpecBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Label of object in this bounding polygon.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
     */
    public Builder setAnnotationSpec(
        com.google.cloud.datalabeling.v1beta1.AnnotationSpec.Builder builderForValue) {
      if (annotationSpecBuilder_ == null) {
        annotationSpec_ = builderForValue.build();
        onChanged();
      } else {
        annotationSpecBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Label of object in this bounding polygon.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
     */
    public Builder mergeAnnotationSpec(com.google.cloud.datalabeling.v1beta1.AnnotationSpec value) {
      if (annotationSpecBuilder_ == null) {
        if (annotationSpec_ != null) {
          annotationSpec_ =
              com.google.cloud.datalabeling.v1beta1.AnnotationSpec.newBuilder(annotationSpec_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          annotationSpec_ = value;
        }
        onChanged();
      } else {
        annotationSpecBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Label of object in this bounding polygon.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
     */
    public Builder clearAnnotationSpec() {
      if (annotationSpecBuilder_ == null) {
        annotationSpec_ = null;
        onChanged();
      } else {
        annotationSpec_ = null;
        annotationSpecBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Label of object in this bounding polygon.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.AnnotationSpec.Builder getAnnotationSpecBuilder() {

      onChanged();
      return getAnnotationSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Label of object in this bounding polygon.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.AnnotationSpecOrBuilder
        getAnnotationSpecOrBuilder() {
      if (annotationSpecBuilder_ != null) {
        return annotationSpecBuilder_.getMessageOrBuilder();
      } else {
        return annotationSpec_ == null
            ? com.google.cloud.datalabeling.v1beta1.AnnotationSpec.getDefaultInstance()
            : annotationSpec_;
      }
    }
    /**
     *
     *
     * <pre>
     * Label of object in this bounding polygon.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationSpec annotation_spec = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.AnnotationSpec,
            com.google.cloud.datalabeling.v1beta1.AnnotationSpec.Builder,
            com.google.cloud.datalabeling.v1beta1.AnnotationSpecOrBuilder>
        getAnnotationSpecFieldBuilder() {
      if (annotationSpecBuilder_ == null) {
        annotationSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.AnnotationSpec,
                com.google.cloud.datalabeling.v1beta1.AnnotationSpec.Builder,
                com.google.cloud.datalabeling.v1beta1.AnnotationSpecOrBuilder>(
                getAnnotationSpec(), getParentForChildren(), isClean());
        annotationSpec_ = null;
      }
      return annotationSpecBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation)
  private static final com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation();
  }

  public static com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ImageBoundingPolyAnnotation> PARSER =
      new com.google.protobuf.AbstractParser<ImageBoundingPolyAnnotation>() {
        @java.lang.Override
        public ImageBoundingPolyAnnotation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new ImageBoundingPolyAnnotation(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<ImageBoundingPolyAnnotation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ImageBoundingPolyAnnotation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.ImageBoundingPolyAnnotation
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
