/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datalabeling/v1beta1/dataset.proto

package com.google.cloud.datalabeling.v1beta1;

/**
 *
 *
 * <pre>
 * Metadata on AnnotatedDataset.
 * </pre>
 *
 * Protobuf type {@code google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata}
 */
public final class AnnotatedDatasetMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata)
    AnnotatedDatasetMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AnnotatedDatasetMetadata.newBuilder() to construct.
  private AnnotatedDatasetMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AnnotatedDatasetMetadata() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AnnotatedDatasetMetadata();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private AnnotatedDatasetMetadata(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.Builder subBuilder = null;
              if (humanAnnotationConfig_ != null) {
                subBuilder = humanAnnotationConfig_.toBuilder();
              }
              humanAnnotationConfig_ =
                  input.readMessage(
                      com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(humanAnnotationConfig_);
                humanAnnotationConfig_ = subBuilder.buildPartial();
              }

              break;
            }
          case 18:
            {
              com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig.Builder subBuilder =
                  null;
              if (annotationRequestConfigCase_ == 2) {
                subBuilder =
                    ((com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig)
                            annotationRequestConfig_)
                        .toBuilder();
              }
              annotationRequestConfig_ =
                  input.readMessage(
                      com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig)
                        annotationRequestConfig_);
                annotationRequestConfig_ = subBuilder.buildPartial();
              }
              annotationRequestConfigCase_ = 2;
              break;
            }
          case 26:
            {
              com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig.Builder subBuilder = null;
              if (annotationRequestConfigCase_ == 3) {
                subBuilder =
                    ((com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig)
                            annotationRequestConfig_)
                        .toBuilder();
              }
              annotationRequestConfig_ =
                  input.readMessage(
                      com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig)
                        annotationRequestConfig_);
                annotationRequestConfig_ = subBuilder.buildPartial();
              }
              annotationRequestConfigCase_ = 3;
              break;
            }
          case 34:
            {
              com.google.cloud.datalabeling.v1beta1.PolylineConfig.Builder subBuilder = null;
              if (annotationRequestConfigCase_ == 4) {
                subBuilder =
                    ((com.google.cloud.datalabeling.v1beta1.PolylineConfig)
                            annotationRequestConfig_)
                        .toBuilder();
              }
              annotationRequestConfig_ =
                  input.readMessage(
                      com.google.cloud.datalabeling.v1beta1.PolylineConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.datalabeling.v1beta1.PolylineConfig)
                        annotationRequestConfig_);
                annotationRequestConfig_ = subBuilder.buildPartial();
              }
              annotationRequestConfigCase_ = 4;
              break;
            }
          case 42:
            {
              com.google.cloud.datalabeling.v1beta1.SegmentationConfig.Builder subBuilder = null;
              if (annotationRequestConfigCase_ == 5) {
                subBuilder =
                    ((com.google.cloud.datalabeling.v1beta1.SegmentationConfig)
                            annotationRequestConfig_)
                        .toBuilder();
              }
              annotationRequestConfig_ =
                  input.readMessage(
                      com.google.cloud.datalabeling.v1beta1.SegmentationConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.datalabeling.v1beta1.SegmentationConfig)
                        annotationRequestConfig_);
                annotationRequestConfig_ = subBuilder.buildPartial();
              }
              annotationRequestConfigCase_ = 5;
              break;
            }
          case 50:
            {
              com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.Builder subBuilder =
                  null;
              if (annotationRequestConfigCase_ == 6) {
                subBuilder =
                    ((com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig)
                            annotationRequestConfig_)
                        .toBuilder();
              }
              annotationRequestConfig_ =
                  input.readMessage(
                      com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig)
                        annotationRequestConfig_);
                annotationRequestConfig_ = subBuilder.buildPartial();
              }
              annotationRequestConfigCase_ = 6;
              break;
            }
          case 58:
            {
              com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig.Builder subBuilder = null;
              if (annotationRequestConfigCase_ == 7) {
                subBuilder =
                    ((com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig)
                            annotationRequestConfig_)
                        .toBuilder();
              }
              annotationRequestConfig_ =
                  input.readMessage(
                      com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig)
                        annotationRequestConfig_);
                annotationRequestConfig_ = subBuilder.buildPartial();
              }
              annotationRequestConfigCase_ = 7;
              break;
            }
          case 66:
            {
              com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig.Builder subBuilder = null;
              if (annotationRequestConfigCase_ == 8) {
                subBuilder =
                    ((com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig)
                            annotationRequestConfig_)
                        .toBuilder();
              }
              annotationRequestConfig_ =
                  input.readMessage(
                      com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig)
                        annotationRequestConfig_);
                annotationRequestConfig_ = subBuilder.buildPartial();
              }
              annotationRequestConfigCase_ = 8;
              break;
            }
          case 74:
            {
              com.google.cloud.datalabeling.v1beta1.EventConfig.Builder subBuilder = null;
              if (annotationRequestConfigCase_ == 9) {
                subBuilder =
                    ((com.google.cloud.datalabeling.v1beta1.EventConfig) annotationRequestConfig_)
                        .toBuilder();
              }
              annotationRequestConfig_ =
                  input.readMessage(
                      com.google.cloud.datalabeling.v1beta1.EventConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.datalabeling.v1beta1.EventConfig) annotationRequestConfig_);
                annotationRequestConfig_ = subBuilder.buildPartial();
              }
              annotationRequestConfigCase_ = 9;
              break;
            }
          case 82:
            {
              com.google.cloud.datalabeling.v1beta1.TextClassificationConfig.Builder subBuilder =
                  null;
              if (annotationRequestConfigCase_ == 10) {
                subBuilder =
                    ((com.google.cloud.datalabeling.v1beta1.TextClassificationConfig)
                            annotationRequestConfig_)
                        .toBuilder();
              }
              annotationRequestConfig_ =
                  input.readMessage(
                      com.google.cloud.datalabeling.v1beta1.TextClassificationConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.datalabeling.v1beta1.TextClassificationConfig)
                        annotationRequestConfig_);
                annotationRequestConfig_ = subBuilder.buildPartial();
              }
              annotationRequestConfigCase_ = 10;
              break;
            }
          case 90:
            {
              com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig.Builder subBuilder =
                  null;
              if (annotationRequestConfigCase_ == 11) {
                subBuilder =
                    ((com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig)
                            annotationRequestConfig_)
                        .toBuilder();
              }
              annotationRequestConfig_ =
                  input.readMessage(
                      com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig)
                        annotationRequestConfig_);
                annotationRequestConfig_ = subBuilder.buildPartial();
              }
              annotationRequestConfigCase_ = 11;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datalabeling.v1beta1.DatasetOuterClass
        .internal_static_google_cloud_datalabeling_v1beta1_AnnotatedDatasetMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datalabeling.v1beta1.DatasetOuterClass
        .internal_static_google_cloud_datalabeling_v1beta1_AnnotatedDatasetMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata.class,
            com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata.Builder.class);
  }

  private int annotationRequestConfigCase_ = 0;
  private java.lang.Object annotationRequestConfig_;

  public enum AnnotationRequestConfigCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    IMAGE_CLASSIFICATION_CONFIG(2),
    BOUNDING_POLY_CONFIG(3),
    POLYLINE_CONFIG(4),
    SEGMENTATION_CONFIG(5),
    VIDEO_CLASSIFICATION_CONFIG(6),
    OBJECT_DETECTION_CONFIG(7),
    OBJECT_TRACKING_CONFIG(8),
    EVENT_CONFIG(9),
    TEXT_CLASSIFICATION_CONFIG(10),
    TEXT_ENTITY_EXTRACTION_CONFIG(11),
    ANNOTATIONREQUESTCONFIG_NOT_SET(0);
    private final int value;

    private AnnotationRequestConfigCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AnnotationRequestConfigCase valueOf(int value) {
      return forNumber(value);
    }

    public static AnnotationRequestConfigCase forNumber(int value) {
      switch (value) {
        case 2:
          return IMAGE_CLASSIFICATION_CONFIG;
        case 3:
          return BOUNDING_POLY_CONFIG;
        case 4:
          return POLYLINE_CONFIG;
        case 5:
          return SEGMENTATION_CONFIG;
        case 6:
          return VIDEO_CLASSIFICATION_CONFIG;
        case 7:
          return OBJECT_DETECTION_CONFIG;
        case 8:
          return OBJECT_TRACKING_CONFIG;
        case 9:
          return EVENT_CONFIG;
        case 10:
          return TEXT_CLASSIFICATION_CONFIG;
        case 11:
          return TEXT_ENTITY_EXTRACTION_CONFIG;
        case 0:
          return ANNOTATIONREQUESTCONFIG_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public AnnotationRequestConfigCase getAnnotationRequestConfigCase() {
    return AnnotationRequestConfigCase.forNumber(annotationRequestConfigCase_);
  }

  public static final int IMAGE_CLASSIFICATION_CONFIG_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Configuration for image classification task.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.ImageClassificationConfig image_classification_config = 2;
   * </code>
   *
   * @return Whether the imageClassificationConfig field is set.
   */
  public boolean hasImageClassificationConfig() {
    return annotationRequestConfigCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Configuration for image classification task.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.ImageClassificationConfig image_classification_config = 2;
   * </code>
   *
   * @return The imageClassificationConfig.
   */
  public com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig
      getImageClassificationConfig() {
    if (annotationRequestConfigCase_ == 2) {
      return (com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig)
          annotationRequestConfig_;
    }
    return com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Configuration for image classification task.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.ImageClassificationConfig image_classification_config = 2;
   * </code>
   */
  public com.google.cloud.datalabeling.v1beta1.ImageClassificationConfigOrBuilder
      getImageClassificationConfigOrBuilder() {
    if (annotationRequestConfigCase_ == 2) {
      return (com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig)
          annotationRequestConfig_;
    }
    return com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig.getDefaultInstance();
  }

  public static final int BOUNDING_POLY_CONFIG_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Configuration for image bounding box and bounding poly task.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.BoundingPolyConfig bounding_poly_config = 3;</code>
   *
   * @return Whether the boundingPolyConfig field is set.
   */
  public boolean hasBoundingPolyConfig() {
    return annotationRequestConfigCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Configuration for image bounding box and bounding poly task.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.BoundingPolyConfig bounding_poly_config = 3;</code>
   *
   * @return The boundingPolyConfig.
   */
  public com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig getBoundingPolyConfig() {
    if (annotationRequestConfigCase_ == 3) {
      return (com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig) annotationRequestConfig_;
    }
    return com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Configuration for image bounding box and bounding poly task.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.BoundingPolyConfig bounding_poly_config = 3;</code>
   */
  public com.google.cloud.datalabeling.v1beta1.BoundingPolyConfigOrBuilder
      getBoundingPolyConfigOrBuilder() {
    if (annotationRequestConfigCase_ == 3) {
      return (com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig) annotationRequestConfig_;
    }
    return com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig.getDefaultInstance();
  }

  public static final int POLYLINE_CONFIG_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Configuration for image polyline task.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.PolylineConfig polyline_config = 4;</code>
   *
   * @return Whether the polylineConfig field is set.
   */
  public boolean hasPolylineConfig() {
    return annotationRequestConfigCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Configuration for image polyline task.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.PolylineConfig polyline_config = 4;</code>
   *
   * @return The polylineConfig.
   */
  public com.google.cloud.datalabeling.v1beta1.PolylineConfig getPolylineConfig() {
    if (annotationRequestConfigCase_ == 4) {
      return (com.google.cloud.datalabeling.v1beta1.PolylineConfig) annotationRequestConfig_;
    }
    return com.google.cloud.datalabeling.v1beta1.PolylineConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Configuration for image polyline task.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.PolylineConfig polyline_config = 4;</code>
   */
  public com.google.cloud.datalabeling.v1beta1.PolylineConfigOrBuilder
      getPolylineConfigOrBuilder() {
    if (annotationRequestConfigCase_ == 4) {
      return (com.google.cloud.datalabeling.v1beta1.PolylineConfig) annotationRequestConfig_;
    }
    return com.google.cloud.datalabeling.v1beta1.PolylineConfig.getDefaultInstance();
  }

  public static final int SEGMENTATION_CONFIG_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Configuration for image segmentation task.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.SegmentationConfig segmentation_config = 5;</code>
   *
   * @return Whether the segmentationConfig field is set.
   */
  public boolean hasSegmentationConfig() {
    return annotationRequestConfigCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Configuration for image segmentation task.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.SegmentationConfig segmentation_config = 5;</code>
   *
   * @return The segmentationConfig.
   */
  public com.google.cloud.datalabeling.v1beta1.SegmentationConfig getSegmentationConfig() {
    if (annotationRequestConfigCase_ == 5) {
      return (com.google.cloud.datalabeling.v1beta1.SegmentationConfig) annotationRequestConfig_;
    }
    return com.google.cloud.datalabeling.v1beta1.SegmentationConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Configuration for image segmentation task.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.SegmentationConfig segmentation_config = 5;</code>
   */
  public com.google.cloud.datalabeling.v1beta1.SegmentationConfigOrBuilder
      getSegmentationConfigOrBuilder() {
    if (annotationRequestConfigCase_ == 5) {
      return (com.google.cloud.datalabeling.v1beta1.SegmentationConfig) annotationRequestConfig_;
    }
    return com.google.cloud.datalabeling.v1beta1.SegmentationConfig.getDefaultInstance();
  }

  public static final int VIDEO_CLASSIFICATION_CONFIG_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * Configuration for video classification task.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.VideoClassificationConfig video_classification_config = 6;
   * </code>
   *
   * @return Whether the videoClassificationConfig field is set.
   */
  public boolean hasVideoClassificationConfig() {
    return annotationRequestConfigCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * Configuration for video classification task.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.VideoClassificationConfig video_classification_config = 6;
   * </code>
   *
   * @return The videoClassificationConfig.
   */
  public com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig
      getVideoClassificationConfig() {
    if (annotationRequestConfigCase_ == 6) {
      return (com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig)
          annotationRequestConfig_;
    }
    return com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Configuration for video classification task.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.VideoClassificationConfig video_classification_config = 6;
   * </code>
   */
  public com.google.cloud.datalabeling.v1beta1.VideoClassificationConfigOrBuilder
      getVideoClassificationConfigOrBuilder() {
    if (annotationRequestConfigCase_ == 6) {
      return (com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig)
          annotationRequestConfig_;
    }
    return com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.getDefaultInstance();
  }

  public static final int OBJECT_DETECTION_CONFIG_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * Configuration for video object detection task.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig object_detection_config = 7;
   * </code>
   *
   * @return Whether the objectDetectionConfig field is set.
   */
  public boolean hasObjectDetectionConfig() {
    return annotationRequestConfigCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * Configuration for video object detection task.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig object_detection_config = 7;
   * </code>
   *
   * @return The objectDetectionConfig.
   */
  public com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig getObjectDetectionConfig() {
    if (annotationRequestConfigCase_ == 7) {
      return (com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig) annotationRequestConfig_;
    }
    return com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Configuration for video object detection task.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig object_detection_config = 7;
   * </code>
   */
  public com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfigOrBuilder
      getObjectDetectionConfigOrBuilder() {
    if (annotationRequestConfigCase_ == 7) {
      return (com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig) annotationRequestConfig_;
    }
    return com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig.getDefaultInstance();
  }

  public static final int OBJECT_TRACKING_CONFIG_FIELD_NUMBER = 8;
  /**
   *
   *
   * <pre>
   * Configuration for video object tracking task.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig object_tracking_config = 8;
   * </code>
   *
   * @return Whether the objectTrackingConfig field is set.
   */
  public boolean hasObjectTrackingConfig() {
    return annotationRequestConfigCase_ == 8;
  }
  /**
   *
   *
   * <pre>
   * Configuration for video object tracking task.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig object_tracking_config = 8;
   * </code>
   *
   * @return The objectTrackingConfig.
   */
  public com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig getObjectTrackingConfig() {
    if (annotationRequestConfigCase_ == 8) {
      return (com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig) annotationRequestConfig_;
    }
    return com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Configuration for video object tracking task.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig object_tracking_config = 8;
   * </code>
   */
  public com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfigOrBuilder
      getObjectTrackingConfigOrBuilder() {
    if (annotationRequestConfigCase_ == 8) {
      return (com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig) annotationRequestConfig_;
    }
    return com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig.getDefaultInstance();
  }

  public static final int EVENT_CONFIG_FIELD_NUMBER = 9;
  /**
   *
   *
   * <pre>
   * Configuration for video event labeling task.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.EventConfig event_config = 9;</code>
   *
   * @return Whether the eventConfig field is set.
   */
  public boolean hasEventConfig() {
    return annotationRequestConfigCase_ == 9;
  }
  /**
   *
   *
   * <pre>
   * Configuration for video event labeling task.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.EventConfig event_config = 9;</code>
   *
   * @return The eventConfig.
   */
  public com.google.cloud.datalabeling.v1beta1.EventConfig getEventConfig() {
    if (annotationRequestConfigCase_ == 9) {
      return (com.google.cloud.datalabeling.v1beta1.EventConfig) annotationRequestConfig_;
    }
    return com.google.cloud.datalabeling.v1beta1.EventConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Configuration for video event labeling task.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.EventConfig event_config = 9;</code>
   */
  public com.google.cloud.datalabeling.v1beta1.EventConfigOrBuilder getEventConfigOrBuilder() {
    if (annotationRequestConfigCase_ == 9) {
      return (com.google.cloud.datalabeling.v1beta1.EventConfig) annotationRequestConfig_;
    }
    return com.google.cloud.datalabeling.v1beta1.EventConfig.getDefaultInstance();
  }

  public static final int TEXT_CLASSIFICATION_CONFIG_FIELD_NUMBER = 10;
  /**
   *
   *
   * <pre>
   * Configuration for text classification task.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.TextClassificationConfig text_classification_config = 10;
   * </code>
   *
   * @return Whether the textClassificationConfig field is set.
   */
  public boolean hasTextClassificationConfig() {
    return annotationRequestConfigCase_ == 10;
  }
  /**
   *
   *
   * <pre>
   * Configuration for text classification task.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.TextClassificationConfig text_classification_config = 10;
   * </code>
   *
   * @return The textClassificationConfig.
   */
  public com.google.cloud.datalabeling.v1beta1.TextClassificationConfig
      getTextClassificationConfig() {
    if (annotationRequestConfigCase_ == 10) {
      return (com.google.cloud.datalabeling.v1beta1.TextClassificationConfig)
          annotationRequestConfig_;
    }
    return com.google.cloud.datalabeling.v1beta1.TextClassificationConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Configuration for text classification task.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.TextClassificationConfig text_classification_config = 10;
   * </code>
   */
  public com.google.cloud.datalabeling.v1beta1.TextClassificationConfigOrBuilder
      getTextClassificationConfigOrBuilder() {
    if (annotationRequestConfigCase_ == 10) {
      return (com.google.cloud.datalabeling.v1beta1.TextClassificationConfig)
          annotationRequestConfig_;
    }
    return com.google.cloud.datalabeling.v1beta1.TextClassificationConfig.getDefaultInstance();
  }

  public static final int TEXT_ENTITY_EXTRACTION_CONFIG_FIELD_NUMBER = 11;
  /**
   *
   *
   * <pre>
   * Configuration for text entity extraction task.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig text_entity_extraction_config = 11;
   * </code>
   *
   * @return Whether the textEntityExtractionConfig field is set.
   */
  public boolean hasTextEntityExtractionConfig() {
    return annotationRequestConfigCase_ == 11;
  }
  /**
   *
   *
   * <pre>
   * Configuration for text entity extraction task.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig text_entity_extraction_config = 11;
   * </code>
   *
   * @return The textEntityExtractionConfig.
   */
  public com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig
      getTextEntityExtractionConfig() {
    if (annotationRequestConfigCase_ == 11) {
      return (com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig)
          annotationRequestConfig_;
    }
    return com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Configuration for text entity extraction task.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig text_entity_extraction_config = 11;
   * </code>
   */
  public com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfigOrBuilder
      getTextEntityExtractionConfigOrBuilder() {
    if (annotationRequestConfigCase_ == 11) {
      return (com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig)
          annotationRequestConfig_;
    }
    return com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig.getDefaultInstance();
  }

  public static final int HUMAN_ANNOTATION_CONFIG_FIELD_NUMBER = 1;
  private com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig humanAnnotationConfig_;
  /**
   *
   *
   * <pre>
   * HumanAnnotationConfig used when requesting the human labeling task for this
   * AnnotatedDataset.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig human_annotation_config = 1;
   * </code>
   *
   * @return Whether the humanAnnotationConfig field is set.
   */
  public boolean hasHumanAnnotationConfig() {
    return humanAnnotationConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * HumanAnnotationConfig used when requesting the human labeling task for this
   * AnnotatedDataset.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig human_annotation_config = 1;
   * </code>
   *
   * @return The humanAnnotationConfig.
   */
  public com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig getHumanAnnotationConfig() {
    return humanAnnotationConfig_ == null
        ? com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.getDefaultInstance()
        : humanAnnotationConfig_;
  }
  /**
   *
   *
   * <pre>
   * HumanAnnotationConfig used when requesting the human labeling task for this
   * AnnotatedDataset.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig human_annotation_config = 1;
   * </code>
   */
  public com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfigOrBuilder
      getHumanAnnotationConfigOrBuilder() {
    return getHumanAnnotationConfig();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (humanAnnotationConfig_ != null) {
      output.writeMessage(1, getHumanAnnotationConfig());
    }
    if (annotationRequestConfigCase_ == 2) {
      output.writeMessage(
          2,
          (com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig)
              annotationRequestConfig_);
    }
    if (annotationRequestConfigCase_ == 3) {
      output.writeMessage(
          3, (com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig) annotationRequestConfig_);
    }
    if (annotationRequestConfigCase_ == 4) {
      output.writeMessage(
          4, (com.google.cloud.datalabeling.v1beta1.PolylineConfig) annotationRequestConfig_);
    }
    if (annotationRequestConfigCase_ == 5) {
      output.writeMessage(
          5, (com.google.cloud.datalabeling.v1beta1.SegmentationConfig) annotationRequestConfig_);
    }
    if (annotationRequestConfigCase_ == 6) {
      output.writeMessage(
          6,
          (com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig)
              annotationRequestConfig_);
    }
    if (annotationRequestConfigCase_ == 7) {
      output.writeMessage(
          7,
          (com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig) annotationRequestConfig_);
    }
    if (annotationRequestConfigCase_ == 8) {
      output.writeMessage(
          8, (com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig) annotationRequestConfig_);
    }
    if (annotationRequestConfigCase_ == 9) {
      output.writeMessage(
          9, (com.google.cloud.datalabeling.v1beta1.EventConfig) annotationRequestConfig_);
    }
    if (annotationRequestConfigCase_ == 10) {
      output.writeMessage(
          10,
          (com.google.cloud.datalabeling.v1beta1.TextClassificationConfig)
              annotationRequestConfig_);
    }
    if (annotationRequestConfigCase_ == 11) {
      output.writeMessage(
          11,
          (com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig)
              annotationRequestConfig_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (humanAnnotationConfig_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(1, getHumanAnnotationConfig());
    }
    if (annotationRequestConfigCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2,
              (com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig)
                  annotationRequestConfig_);
    }
    if (annotationRequestConfigCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3,
              (com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig) annotationRequestConfig_);
    }
    if (annotationRequestConfigCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.datalabeling.v1beta1.PolylineConfig) annotationRequestConfig_);
    }
    if (annotationRequestConfigCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5,
              (com.google.cloud.datalabeling.v1beta1.SegmentationConfig) annotationRequestConfig_);
    }
    if (annotationRequestConfigCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6,
              (com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig)
                  annotationRequestConfig_);
    }
    if (annotationRequestConfigCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7,
              (com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig)
                  annotationRequestConfig_);
    }
    if (annotationRequestConfigCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8,
              (com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig)
                  annotationRequestConfig_);
    }
    if (annotationRequestConfigCase_ == 9) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              9, (com.google.cloud.datalabeling.v1beta1.EventConfig) annotationRequestConfig_);
    }
    if (annotationRequestConfigCase_ == 10) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              10,
              (com.google.cloud.datalabeling.v1beta1.TextClassificationConfig)
                  annotationRequestConfig_);
    }
    if (annotationRequestConfigCase_ == 11) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              11,
              (com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig)
                  annotationRequestConfig_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata)) {
      return super.equals(obj);
    }
    com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata other =
        (com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata) obj;

    if (hasHumanAnnotationConfig() != other.hasHumanAnnotationConfig()) return false;
    if (hasHumanAnnotationConfig()) {
      if (!getHumanAnnotationConfig().equals(other.getHumanAnnotationConfig())) return false;
    }
    if (!getAnnotationRequestConfigCase().equals(other.getAnnotationRequestConfigCase()))
      return false;
    switch (annotationRequestConfigCase_) {
      case 2:
        if (!getImageClassificationConfig().equals(other.getImageClassificationConfig()))
          return false;
        break;
      case 3:
        if (!getBoundingPolyConfig().equals(other.getBoundingPolyConfig())) return false;
        break;
      case 4:
        if (!getPolylineConfig().equals(other.getPolylineConfig())) return false;
        break;
      case 5:
        if (!getSegmentationConfig().equals(other.getSegmentationConfig())) return false;
        break;
      case 6:
        if (!getVideoClassificationConfig().equals(other.getVideoClassificationConfig()))
          return false;
        break;
      case 7:
        if (!getObjectDetectionConfig().equals(other.getObjectDetectionConfig())) return false;
        break;
      case 8:
        if (!getObjectTrackingConfig().equals(other.getObjectTrackingConfig())) return false;
        break;
      case 9:
        if (!getEventConfig().equals(other.getEventConfig())) return false;
        break;
      case 10:
        if (!getTextClassificationConfig().equals(other.getTextClassificationConfig()))
          return false;
        break;
      case 11:
        if (!getTextEntityExtractionConfig().equals(other.getTextEntityExtractionConfig()))
          return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasHumanAnnotationConfig()) {
      hash = (37 * hash) + HUMAN_ANNOTATION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getHumanAnnotationConfig().hashCode();
    }
    switch (annotationRequestConfigCase_) {
      case 2:
        hash = (37 * hash) + IMAGE_CLASSIFICATION_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getImageClassificationConfig().hashCode();
        break;
      case 3:
        hash = (37 * hash) + BOUNDING_POLY_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getBoundingPolyConfig().hashCode();
        break;
      case 4:
        hash = (37 * hash) + POLYLINE_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getPolylineConfig().hashCode();
        break;
      case 5:
        hash = (37 * hash) + SEGMENTATION_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getSegmentationConfig().hashCode();
        break;
      case 6:
        hash = (37 * hash) + VIDEO_CLASSIFICATION_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getVideoClassificationConfig().hashCode();
        break;
      case 7:
        hash = (37 * hash) + OBJECT_DETECTION_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getObjectDetectionConfig().hashCode();
        break;
      case 8:
        hash = (37 * hash) + OBJECT_TRACKING_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getObjectTrackingConfig().hashCode();
        break;
      case 9:
        hash = (37 * hash) + EVENT_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getEventConfig().hashCode();
        break;
      case 10:
        hash = (37 * hash) + TEXT_CLASSIFICATION_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getTextClassificationConfig().hashCode();
        break;
      case 11:
        hash = (37 * hash) + TEXT_ENTITY_EXTRACTION_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getTextEntityExtractionConfig().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Metadata on AnnotatedDataset.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata)
      com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datalabeling.v1beta1.DatasetOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_AnnotatedDatasetMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datalabeling.v1beta1.DatasetOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_AnnotatedDatasetMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata.class,
              com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata.Builder.class);
    }

    // Construct using com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (humanAnnotationConfigBuilder_ == null) {
        humanAnnotationConfig_ = null;
      } else {
        humanAnnotationConfig_ = null;
        humanAnnotationConfigBuilder_ = null;
      }
      annotationRequestConfigCase_ = 0;
      annotationRequestConfig_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datalabeling.v1beta1.DatasetOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_AnnotatedDatasetMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata
        getDefaultInstanceForType() {
      return com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata build() {
      com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata buildPartial() {
      com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata result =
          new com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata(this);
      if (annotationRequestConfigCase_ == 2) {
        if (imageClassificationConfigBuilder_ == null) {
          result.annotationRequestConfig_ = annotationRequestConfig_;
        } else {
          result.annotationRequestConfig_ = imageClassificationConfigBuilder_.build();
        }
      }
      if (annotationRequestConfigCase_ == 3) {
        if (boundingPolyConfigBuilder_ == null) {
          result.annotationRequestConfig_ = annotationRequestConfig_;
        } else {
          result.annotationRequestConfig_ = boundingPolyConfigBuilder_.build();
        }
      }
      if (annotationRequestConfigCase_ == 4) {
        if (polylineConfigBuilder_ == null) {
          result.annotationRequestConfig_ = annotationRequestConfig_;
        } else {
          result.annotationRequestConfig_ = polylineConfigBuilder_.build();
        }
      }
      if (annotationRequestConfigCase_ == 5) {
        if (segmentationConfigBuilder_ == null) {
          result.annotationRequestConfig_ = annotationRequestConfig_;
        } else {
          result.annotationRequestConfig_ = segmentationConfigBuilder_.build();
        }
      }
      if (annotationRequestConfigCase_ == 6) {
        if (videoClassificationConfigBuilder_ == null) {
          result.annotationRequestConfig_ = annotationRequestConfig_;
        } else {
          result.annotationRequestConfig_ = videoClassificationConfigBuilder_.build();
        }
      }
      if (annotationRequestConfigCase_ == 7) {
        if (objectDetectionConfigBuilder_ == null) {
          result.annotationRequestConfig_ = annotationRequestConfig_;
        } else {
          result.annotationRequestConfig_ = objectDetectionConfigBuilder_.build();
        }
      }
      if (annotationRequestConfigCase_ == 8) {
        if (objectTrackingConfigBuilder_ == null) {
          result.annotationRequestConfig_ = annotationRequestConfig_;
        } else {
          result.annotationRequestConfig_ = objectTrackingConfigBuilder_.build();
        }
      }
      if (annotationRequestConfigCase_ == 9) {
        if (eventConfigBuilder_ == null) {
          result.annotationRequestConfig_ = annotationRequestConfig_;
        } else {
          result.annotationRequestConfig_ = eventConfigBuilder_.build();
        }
      }
      if (annotationRequestConfigCase_ == 10) {
        if (textClassificationConfigBuilder_ == null) {
          result.annotationRequestConfig_ = annotationRequestConfig_;
        } else {
          result.annotationRequestConfig_ = textClassificationConfigBuilder_.build();
        }
      }
      if (annotationRequestConfigCase_ == 11) {
        if (textEntityExtractionConfigBuilder_ == null) {
          result.annotationRequestConfig_ = annotationRequestConfig_;
        } else {
          result.annotationRequestConfig_ = textEntityExtractionConfigBuilder_.build();
        }
      }
      if (humanAnnotationConfigBuilder_ == null) {
        result.humanAnnotationConfig_ = humanAnnotationConfig_;
      } else {
        result.humanAnnotationConfig_ = humanAnnotationConfigBuilder_.build();
      }
      result.annotationRequestConfigCase_ = annotationRequestConfigCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata) {
        return mergeFrom((com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata other) {
      if (other
          == com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata.getDefaultInstance())
        return this;
      if (other.hasHumanAnnotationConfig()) {
        mergeHumanAnnotationConfig(other.getHumanAnnotationConfig());
      }
      switch (other.getAnnotationRequestConfigCase()) {
        case IMAGE_CLASSIFICATION_CONFIG:
          {
            mergeImageClassificationConfig(other.getImageClassificationConfig());
            break;
          }
        case BOUNDING_POLY_CONFIG:
          {
            mergeBoundingPolyConfig(other.getBoundingPolyConfig());
            break;
          }
        case POLYLINE_CONFIG:
          {
            mergePolylineConfig(other.getPolylineConfig());
            break;
          }
        case SEGMENTATION_CONFIG:
          {
            mergeSegmentationConfig(other.getSegmentationConfig());
            break;
          }
        case VIDEO_CLASSIFICATION_CONFIG:
          {
            mergeVideoClassificationConfig(other.getVideoClassificationConfig());
            break;
          }
        case OBJECT_DETECTION_CONFIG:
          {
            mergeObjectDetectionConfig(other.getObjectDetectionConfig());
            break;
          }
        case OBJECT_TRACKING_CONFIG:
          {
            mergeObjectTrackingConfig(other.getObjectTrackingConfig());
            break;
          }
        case EVENT_CONFIG:
          {
            mergeEventConfig(other.getEventConfig());
            break;
          }
        case TEXT_CLASSIFICATION_CONFIG:
          {
            mergeTextClassificationConfig(other.getTextClassificationConfig());
            break;
          }
        case TEXT_ENTITY_EXTRACTION_CONFIG:
          {
            mergeTextEntityExtractionConfig(other.getTextEntityExtractionConfig());
            break;
          }
        case ANNOTATIONREQUESTCONFIG_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata)
                e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int annotationRequestConfigCase_ = 0;
    private java.lang.Object annotationRequestConfig_;

    public AnnotationRequestConfigCase getAnnotationRequestConfigCase() {
      return AnnotationRequestConfigCase.forNumber(annotationRequestConfigCase_);
    }

    public Builder clearAnnotationRequestConfig() {
      annotationRequestConfigCase_ = 0;
      annotationRequestConfig_ = null;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig,
            com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.ImageClassificationConfigOrBuilder>
        imageClassificationConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for image classification task.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageClassificationConfig image_classification_config = 2;
     * </code>
     *
     * @return Whether the imageClassificationConfig field is set.
     */
    public boolean hasImageClassificationConfig() {
      return annotationRequestConfigCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Configuration for image classification task.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageClassificationConfig image_classification_config = 2;
     * </code>
     *
     * @return The imageClassificationConfig.
     */
    public com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig
        getImageClassificationConfig() {
      if (imageClassificationConfigBuilder_ == null) {
        if (annotationRequestConfigCase_ == 2) {
          return (com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig)
              annotationRequestConfig_;
        }
        return com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig.getDefaultInstance();
      } else {
        if (annotationRequestConfigCase_ == 2) {
          return imageClassificationConfigBuilder_.getMessage();
        }
        return com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for image classification task.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageClassificationConfig image_classification_config = 2;
     * </code>
     */
    public Builder setImageClassificationConfig(
        com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig value) {
      if (imageClassificationConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        annotationRequestConfig_ = value;
        onChanged();
      } else {
        imageClassificationConfigBuilder_.setMessage(value);
      }
      annotationRequestConfigCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for image classification task.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageClassificationConfig image_classification_config = 2;
     * </code>
     */
    public Builder setImageClassificationConfig(
        com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig.Builder builderForValue) {
      if (imageClassificationConfigBuilder_ == null) {
        annotationRequestConfig_ = builderForValue.build();
        onChanged();
      } else {
        imageClassificationConfigBuilder_.setMessage(builderForValue.build());
      }
      annotationRequestConfigCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for image classification task.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageClassificationConfig image_classification_config = 2;
     * </code>
     */
    public Builder mergeImageClassificationConfig(
        com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig value) {
      if (imageClassificationConfigBuilder_ == null) {
        if (annotationRequestConfigCase_ == 2
            && annotationRequestConfig_
                != com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig
                    .getDefaultInstance()) {
          annotationRequestConfig_ =
              com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig.newBuilder(
                      (com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig)
                          annotationRequestConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          annotationRequestConfig_ = value;
        }
        onChanged();
      } else {
        if (annotationRequestConfigCase_ == 2) {
          imageClassificationConfigBuilder_.mergeFrom(value);
        }
        imageClassificationConfigBuilder_.setMessage(value);
      }
      annotationRequestConfigCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for image classification task.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageClassificationConfig image_classification_config = 2;
     * </code>
     */
    public Builder clearImageClassificationConfig() {
      if (imageClassificationConfigBuilder_ == null) {
        if (annotationRequestConfigCase_ == 2) {
          annotationRequestConfigCase_ = 0;
          annotationRequestConfig_ = null;
          onChanged();
        }
      } else {
        if (annotationRequestConfigCase_ == 2) {
          annotationRequestConfigCase_ = 0;
          annotationRequestConfig_ = null;
        }
        imageClassificationConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for image classification task.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageClassificationConfig image_classification_config = 2;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig.Builder
        getImageClassificationConfigBuilder() {
      return getImageClassificationConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for image classification task.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageClassificationConfig image_classification_config = 2;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.ImageClassificationConfigOrBuilder
        getImageClassificationConfigOrBuilder() {
      if ((annotationRequestConfigCase_ == 2) && (imageClassificationConfigBuilder_ != null)) {
        return imageClassificationConfigBuilder_.getMessageOrBuilder();
      } else {
        if (annotationRequestConfigCase_ == 2) {
          return (com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig)
              annotationRequestConfig_;
        }
        return com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for image classification task.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageClassificationConfig image_classification_config = 2;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig,
            com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.ImageClassificationConfigOrBuilder>
        getImageClassificationConfigFieldBuilder() {
      if (imageClassificationConfigBuilder_ == null) {
        if (!(annotationRequestConfigCase_ == 2)) {
          annotationRequestConfig_ =
              com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig.getDefaultInstance();
        }
        imageClassificationConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig,
                com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig.Builder,
                com.google.cloud.datalabeling.v1beta1.ImageClassificationConfigOrBuilder>(
                (com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig)
                    annotationRequestConfig_,
                getParentForChildren(),
                isClean());
        annotationRequestConfig_ = null;
      }
      annotationRequestConfigCase_ = 2;
      onChanged();
      ;
      return imageClassificationConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig,
            com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.BoundingPolyConfigOrBuilder>
        boundingPolyConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for image bounding box and bounding poly task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.BoundingPolyConfig bounding_poly_config = 3;</code>
     *
     * @return Whether the boundingPolyConfig field is set.
     */
    public boolean hasBoundingPolyConfig() {
      return annotationRequestConfigCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Configuration for image bounding box and bounding poly task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.BoundingPolyConfig bounding_poly_config = 3;</code>
     *
     * @return The boundingPolyConfig.
     */
    public com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig getBoundingPolyConfig() {
      if (boundingPolyConfigBuilder_ == null) {
        if (annotationRequestConfigCase_ == 3) {
          return (com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig)
              annotationRequestConfig_;
        }
        return com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig.getDefaultInstance();
      } else {
        if (annotationRequestConfigCase_ == 3) {
          return boundingPolyConfigBuilder_.getMessage();
        }
        return com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for image bounding box and bounding poly task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.BoundingPolyConfig bounding_poly_config = 3;</code>
     */
    public Builder setBoundingPolyConfig(
        com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig value) {
      if (boundingPolyConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        annotationRequestConfig_ = value;
        onChanged();
      } else {
        boundingPolyConfigBuilder_.setMessage(value);
      }
      annotationRequestConfigCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for image bounding box and bounding poly task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.BoundingPolyConfig bounding_poly_config = 3;</code>
     */
    public Builder setBoundingPolyConfig(
        com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig.Builder builderForValue) {
      if (boundingPolyConfigBuilder_ == null) {
        annotationRequestConfig_ = builderForValue.build();
        onChanged();
      } else {
        boundingPolyConfigBuilder_.setMessage(builderForValue.build());
      }
      annotationRequestConfigCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for image bounding box and bounding poly task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.BoundingPolyConfig bounding_poly_config = 3;</code>
     */
    public Builder mergeBoundingPolyConfig(
        com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig value) {
      if (boundingPolyConfigBuilder_ == null) {
        if (annotationRequestConfigCase_ == 3
            && annotationRequestConfig_
                != com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig.getDefaultInstance()) {
          annotationRequestConfig_ =
              com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig.newBuilder(
                      (com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig)
                          annotationRequestConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          annotationRequestConfig_ = value;
        }
        onChanged();
      } else {
        if (annotationRequestConfigCase_ == 3) {
          boundingPolyConfigBuilder_.mergeFrom(value);
        }
        boundingPolyConfigBuilder_.setMessage(value);
      }
      annotationRequestConfigCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for image bounding box and bounding poly task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.BoundingPolyConfig bounding_poly_config = 3;</code>
     */
    public Builder clearBoundingPolyConfig() {
      if (boundingPolyConfigBuilder_ == null) {
        if (annotationRequestConfigCase_ == 3) {
          annotationRequestConfigCase_ = 0;
          annotationRequestConfig_ = null;
          onChanged();
        }
      } else {
        if (annotationRequestConfigCase_ == 3) {
          annotationRequestConfigCase_ = 0;
          annotationRequestConfig_ = null;
        }
        boundingPolyConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for image bounding box and bounding poly task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.BoundingPolyConfig bounding_poly_config = 3;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig.Builder
        getBoundingPolyConfigBuilder() {
      return getBoundingPolyConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for image bounding box and bounding poly task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.BoundingPolyConfig bounding_poly_config = 3;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.BoundingPolyConfigOrBuilder
        getBoundingPolyConfigOrBuilder() {
      if ((annotationRequestConfigCase_ == 3) && (boundingPolyConfigBuilder_ != null)) {
        return boundingPolyConfigBuilder_.getMessageOrBuilder();
      } else {
        if (annotationRequestConfigCase_ == 3) {
          return (com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig)
              annotationRequestConfig_;
        }
        return com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for image bounding box and bounding poly task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.BoundingPolyConfig bounding_poly_config = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig,
            com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.BoundingPolyConfigOrBuilder>
        getBoundingPolyConfigFieldBuilder() {
      if (boundingPolyConfigBuilder_ == null) {
        if (!(annotationRequestConfigCase_ == 3)) {
          annotationRequestConfig_ =
              com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig.getDefaultInstance();
        }
        boundingPolyConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig,
                com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig.Builder,
                com.google.cloud.datalabeling.v1beta1.BoundingPolyConfigOrBuilder>(
                (com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig) annotationRequestConfig_,
                getParentForChildren(),
                isClean());
        annotationRequestConfig_ = null;
      }
      annotationRequestConfigCase_ = 3;
      onChanged();
      ;
      return boundingPolyConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.PolylineConfig,
            com.google.cloud.datalabeling.v1beta1.PolylineConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.PolylineConfigOrBuilder>
        polylineConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for image polyline task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.PolylineConfig polyline_config = 4;</code>
     *
     * @return Whether the polylineConfig field is set.
     */
    public boolean hasPolylineConfig() {
      return annotationRequestConfigCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Configuration for image polyline task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.PolylineConfig polyline_config = 4;</code>
     *
     * @return The polylineConfig.
     */
    public com.google.cloud.datalabeling.v1beta1.PolylineConfig getPolylineConfig() {
      if (polylineConfigBuilder_ == null) {
        if (annotationRequestConfigCase_ == 4) {
          return (com.google.cloud.datalabeling.v1beta1.PolylineConfig) annotationRequestConfig_;
        }
        return com.google.cloud.datalabeling.v1beta1.PolylineConfig.getDefaultInstance();
      } else {
        if (annotationRequestConfigCase_ == 4) {
          return polylineConfigBuilder_.getMessage();
        }
        return com.google.cloud.datalabeling.v1beta1.PolylineConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for image polyline task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.PolylineConfig polyline_config = 4;</code>
     */
    public Builder setPolylineConfig(com.google.cloud.datalabeling.v1beta1.PolylineConfig value) {
      if (polylineConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        annotationRequestConfig_ = value;
        onChanged();
      } else {
        polylineConfigBuilder_.setMessage(value);
      }
      annotationRequestConfigCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for image polyline task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.PolylineConfig polyline_config = 4;</code>
     */
    public Builder setPolylineConfig(
        com.google.cloud.datalabeling.v1beta1.PolylineConfig.Builder builderForValue) {
      if (polylineConfigBuilder_ == null) {
        annotationRequestConfig_ = builderForValue.build();
        onChanged();
      } else {
        polylineConfigBuilder_.setMessage(builderForValue.build());
      }
      annotationRequestConfigCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for image polyline task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.PolylineConfig polyline_config = 4;</code>
     */
    public Builder mergePolylineConfig(com.google.cloud.datalabeling.v1beta1.PolylineConfig value) {
      if (polylineConfigBuilder_ == null) {
        if (annotationRequestConfigCase_ == 4
            && annotationRequestConfig_
                != com.google.cloud.datalabeling.v1beta1.PolylineConfig.getDefaultInstance()) {
          annotationRequestConfig_ =
              com.google.cloud.datalabeling.v1beta1.PolylineConfig.newBuilder(
                      (com.google.cloud.datalabeling.v1beta1.PolylineConfig)
                          annotationRequestConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          annotationRequestConfig_ = value;
        }
        onChanged();
      } else {
        if (annotationRequestConfigCase_ == 4) {
          polylineConfigBuilder_.mergeFrom(value);
        }
        polylineConfigBuilder_.setMessage(value);
      }
      annotationRequestConfigCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for image polyline task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.PolylineConfig polyline_config = 4;</code>
     */
    public Builder clearPolylineConfig() {
      if (polylineConfigBuilder_ == null) {
        if (annotationRequestConfigCase_ == 4) {
          annotationRequestConfigCase_ = 0;
          annotationRequestConfig_ = null;
          onChanged();
        }
      } else {
        if (annotationRequestConfigCase_ == 4) {
          annotationRequestConfigCase_ = 0;
          annotationRequestConfig_ = null;
        }
        polylineConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for image polyline task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.PolylineConfig polyline_config = 4;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.PolylineConfig.Builder getPolylineConfigBuilder() {
      return getPolylineConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for image polyline task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.PolylineConfig polyline_config = 4;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.PolylineConfigOrBuilder
        getPolylineConfigOrBuilder() {
      if ((annotationRequestConfigCase_ == 4) && (polylineConfigBuilder_ != null)) {
        return polylineConfigBuilder_.getMessageOrBuilder();
      } else {
        if (annotationRequestConfigCase_ == 4) {
          return (com.google.cloud.datalabeling.v1beta1.PolylineConfig) annotationRequestConfig_;
        }
        return com.google.cloud.datalabeling.v1beta1.PolylineConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for image polyline task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.PolylineConfig polyline_config = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.PolylineConfig,
            com.google.cloud.datalabeling.v1beta1.PolylineConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.PolylineConfigOrBuilder>
        getPolylineConfigFieldBuilder() {
      if (polylineConfigBuilder_ == null) {
        if (!(annotationRequestConfigCase_ == 4)) {
          annotationRequestConfig_ =
              com.google.cloud.datalabeling.v1beta1.PolylineConfig.getDefaultInstance();
        }
        polylineConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.PolylineConfig,
                com.google.cloud.datalabeling.v1beta1.PolylineConfig.Builder,
                com.google.cloud.datalabeling.v1beta1.PolylineConfigOrBuilder>(
                (com.google.cloud.datalabeling.v1beta1.PolylineConfig) annotationRequestConfig_,
                getParentForChildren(),
                isClean());
        annotationRequestConfig_ = null;
      }
      annotationRequestConfigCase_ = 4;
      onChanged();
      ;
      return polylineConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.SegmentationConfig,
            com.google.cloud.datalabeling.v1beta1.SegmentationConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.SegmentationConfigOrBuilder>
        segmentationConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for image segmentation task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.SegmentationConfig segmentation_config = 5;</code>
     *
     * @return Whether the segmentationConfig field is set.
     */
    public boolean hasSegmentationConfig() {
      return annotationRequestConfigCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Configuration for image segmentation task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.SegmentationConfig segmentation_config = 5;</code>
     *
     * @return The segmentationConfig.
     */
    public com.google.cloud.datalabeling.v1beta1.SegmentationConfig getSegmentationConfig() {
      if (segmentationConfigBuilder_ == null) {
        if (annotationRequestConfigCase_ == 5) {
          return (com.google.cloud.datalabeling.v1beta1.SegmentationConfig)
              annotationRequestConfig_;
        }
        return com.google.cloud.datalabeling.v1beta1.SegmentationConfig.getDefaultInstance();
      } else {
        if (annotationRequestConfigCase_ == 5) {
          return segmentationConfigBuilder_.getMessage();
        }
        return com.google.cloud.datalabeling.v1beta1.SegmentationConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for image segmentation task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.SegmentationConfig segmentation_config = 5;</code>
     */
    public Builder setSegmentationConfig(
        com.google.cloud.datalabeling.v1beta1.SegmentationConfig value) {
      if (segmentationConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        annotationRequestConfig_ = value;
        onChanged();
      } else {
        segmentationConfigBuilder_.setMessage(value);
      }
      annotationRequestConfigCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for image segmentation task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.SegmentationConfig segmentation_config = 5;</code>
     */
    public Builder setSegmentationConfig(
        com.google.cloud.datalabeling.v1beta1.SegmentationConfig.Builder builderForValue) {
      if (segmentationConfigBuilder_ == null) {
        annotationRequestConfig_ = builderForValue.build();
        onChanged();
      } else {
        segmentationConfigBuilder_.setMessage(builderForValue.build());
      }
      annotationRequestConfigCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for image segmentation task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.SegmentationConfig segmentation_config = 5;</code>
     */
    public Builder mergeSegmentationConfig(
        com.google.cloud.datalabeling.v1beta1.SegmentationConfig value) {
      if (segmentationConfigBuilder_ == null) {
        if (annotationRequestConfigCase_ == 5
            && annotationRequestConfig_
                != com.google.cloud.datalabeling.v1beta1.SegmentationConfig.getDefaultInstance()) {
          annotationRequestConfig_ =
              com.google.cloud.datalabeling.v1beta1.SegmentationConfig.newBuilder(
                      (com.google.cloud.datalabeling.v1beta1.SegmentationConfig)
                          annotationRequestConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          annotationRequestConfig_ = value;
        }
        onChanged();
      } else {
        if (annotationRequestConfigCase_ == 5) {
          segmentationConfigBuilder_.mergeFrom(value);
        }
        segmentationConfigBuilder_.setMessage(value);
      }
      annotationRequestConfigCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for image segmentation task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.SegmentationConfig segmentation_config = 5;</code>
     */
    public Builder clearSegmentationConfig() {
      if (segmentationConfigBuilder_ == null) {
        if (annotationRequestConfigCase_ == 5) {
          annotationRequestConfigCase_ = 0;
          annotationRequestConfig_ = null;
          onChanged();
        }
      } else {
        if (annotationRequestConfigCase_ == 5) {
          annotationRequestConfigCase_ = 0;
          annotationRequestConfig_ = null;
        }
        segmentationConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for image segmentation task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.SegmentationConfig segmentation_config = 5;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.SegmentationConfig.Builder
        getSegmentationConfigBuilder() {
      return getSegmentationConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for image segmentation task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.SegmentationConfig segmentation_config = 5;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.SegmentationConfigOrBuilder
        getSegmentationConfigOrBuilder() {
      if ((annotationRequestConfigCase_ == 5) && (segmentationConfigBuilder_ != null)) {
        return segmentationConfigBuilder_.getMessageOrBuilder();
      } else {
        if (annotationRequestConfigCase_ == 5) {
          return (com.google.cloud.datalabeling.v1beta1.SegmentationConfig)
              annotationRequestConfig_;
        }
        return com.google.cloud.datalabeling.v1beta1.SegmentationConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for image segmentation task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.SegmentationConfig segmentation_config = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.SegmentationConfig,
            com.google.cloud.datalabeling.v1beta1.SegmentationConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.SegmentationConfigOrBuilder>
        getSegmentationConfigFieldBuilder() {
      if (segmentationConfigBuilder_ == null) {
        if (!(annotationRequestConfigCase_ == 5)) {
          annotationRequestConfig_ =
              com.google.cloud.datalabeling.v1beta1.SegmentationConfig.getDefaultInstance();
        }
        segmentationConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.SegmentationConfig,
                com.google.cloud.datalabeling.v1beta1.SegmentationConfig.Builder,
                com.google.cloud.datalabeling.v1beta1.SegmentationConfigOrBuilder>(
                (com.google.cloud.datalabeling.v1beta1.SegmentationConfig) annotationRequestConfig_,
                getParentForChildren(),
                isClean());
        annotationRequestConfig_ = null;
      }
      annotationRequestConfigCase_ = 5;
      onChanged();
      ;
      return segmentationConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig,
            com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.VideoClassificationConfigOrBuilder>
        videoClassificationConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for video classification task.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.VideoClassificationConfig video_classification_config = 6;
     * </code>
     *
     * @return Whether the videoClassificationConfig field is set.
     */
    public boolean hasVideoClassificationConfig() {
      return annotationRequestConfigCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * Configuration for video classification task.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.VideoClassificationConfig video_classification_config = 6;
     * </code>
     *
     * @return The videoClassificationConfig.
     */
    public com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig
        getVideoClassificationConfig() {
      if (videoClassificationConfigBuilder_ == null) {
        if (annotationRequestConfigCase_ == 6) {
          return (com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig)
              annotationRequestConfig_;
        }
        return com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.getDefaultInstance();
      } else {
        if (annotationRequestConfigCase_ == 6) {
          return videoClassificationConfigBuilder_.getMessage();
        }
        return com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for video classification task.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.VideoClassificationConfig video_classification_config = 6;
     * </code>
     */
    public Builder setVideoClassificationConfig(
        com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig value) {
      if (videoClassificationConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        annotationRequestConfig_ = value;
        onChanged();
      } else {
        videoClassificationConfigBuilder_.setMessage(value);
      }
      annotationRequestConfigCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for video classification task.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.VideoClassificationConfig video_classification_config = 6;
     * </code>
     */
    public Builder setVideoClassificationConfig(
        com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.Builder builderForValue) {
      if (videoClassificationConfigBuilder_ == null) {
        annotationRequestConfig_ = builderForValue.build();
        onChanged();
      } else {
        videoClassificationConfigBuilder_.setMessage(builderForValue.build());
      }
      annotationRequestConfigCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for video classification task.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.VideoClassificationConfig video_classification_config = 6;
     * </code>
     */
    public Builder mergeVideoClassificationConfig(
        com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig value) {
      if (videoClassificationConfigBuilder_ == null) {
        if (annotationRequestConfigCase_ == 6
            && annotationRequestConfig_
                != com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig
                    .getDefaultInstance()) {
          annotationRequestConfig_ =
              com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.newBuilder(
                      (com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig)
                          annotationRequestConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          annotationRequestConfig_ = value;
        }
        onChanged();
      } else {
        if (annotationRequestConfigCase_ == 6) {
          videoClassificationConfigBuilder_.mergeFrom(value);
        }
        videoClassificationConfigBuilder_.setMessage(value);
      }
      annotationRequestConfigCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for video classification task.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.VideoClassificationConfig video_classification_config = 6;
     * </code>
     */
    public Builder clearVideoClassificationConfig() {
      if (videoClassificationConfigBuilder_ == null) {
        if (annotationRequestConfigCase_ == 6) {
          annotationRequestConfigCase_ = 0;
          annotationRequestConfig_ = null;
          onChanged();
        }
      } else {
        if (annotationRequestConfigCase_ == 6) {
          annotationRequestConfigCase_ = 0;
          annotationRequestConfig_ = null;
        }
        videoClassificationConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for video classification task.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.VideoClassificationConfig video_classification_config = 6;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.Builder
        getVideoClassificationConfigBuilder() {
      return getVideoClassificationConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for video classification task.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.VideoClassificationConfig video_classification_config = 6;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.VideoClassificationConfigOrBuilder
        getVideoClassificationConfigOrBuilder() {
      if ((annotationRequestConfigCase_ == 6) && (videoClassificationConfigBuilder_ != null)) {
        return videoClassificationConfigBuilder_.getMessageOrBuilder();
      } else {
        if (annotationRequestConfigCase_ == 6) {
          return (com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig)
              annotationRequestConfig_;
        }
        return com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for video classification task.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.VideoClassificationConfig video_classification_config = 6;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig,
            com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.VideoClassificationConfigOrBuilder>
        getVideoClassificationConfigFieldBuilder() {
      if (videoClassificationConfigBuilder_ == null) {
        if (!(annotationRequestConfigCase_ == 6)) {
          annotationRequestConfig_ =
              com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.getDefaultInstance();
        }
        videoClassificationConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig,
                com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.Builder,
                com.google.cloud.datalabeling.v1beta1.VideoClassificationConfigOrBuilder>(
                (com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig)
                    annotationRequestConfig_,
                getParentForChildren(),
                isClean());
        annotationRequestConfig_ = null;
      }
      annotationRequestConfigCase_ = 6;
      onChanged();
      ;
      return videoClassificationConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig,
            com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfigOrBuilder>
        objectDetectionConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for video object detection task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig object_detection_config = 7;
     * </code>
     *
     * @return Whether the objectDetectionConfig field is set.
     */
    public boolean hasObjectDetectionConfig() {
      return annotationRequestConfigCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * Configuration for video object detection task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig object_detection_config = 7;
     * </code>
     *
     * @return The objectDetectionConfig.
     */
    public com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig getObjectDetectionConfig() {
      if (objectDetectionConfigBuilder_ == null) {
        if (annotationRequestConfigCase_ == 7) {
          return (com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig)
              annotationRequestConfig_;
        }
        return com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig.getDefaultInstance();
      } else {
        if (annotationRequestConfigCase_ == 7) {
          return objectDetectionConfigBuilder_.getMessage();
        }
        return com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for video object detection task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig object_detection_config = 7;
     * </code>
     */
    public Builder setObjectDetectionConfig(
        com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig value) {
      if (objectDetectionConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        annotationRequestConfig_ = value;
        onChanged();
      } else {
        objectDetectionConfigBuilder_.setMessage(value);
      }
      annotationRequestConfigCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for video object detection task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig object_detection_config = 7;
     * </code>
     */
    public Builder setObjectDetectionConfig(
        com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig.Builder builderForValue) {
      if (objectDetectionConfigBuilder_ == null) {
        annotationRequestConfig_ = builderForValue.build();
        onChanged();
      } else {
        objectDetectionConfigBuilder_.setMessage(builderForValue.build());
      }
      annotationRequestConfigCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for video object detection task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig object_detection_config = 7;
     * </code>
     */
    public Builder mergeObjectDetectionConfig(
        com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig value) {
      if (objectDetectionConfigBuilder_ == null) {
        if (annotationRequestConfigCase_ == 7
            && annotationRequestConfig_
                != com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig
                    .getDefaultInstance()) {
          annotationRequestConfig_ =
              com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig.newBuilder(
                      (com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig)
                          annotationRequestConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          annotationRequestConfig_ = value;
        }
        onChanged();
      } else {
        if (annotationRequestConfigCase_ == 7) {
          objectDetectionConfigBuilder_.mergeFrom(value);
        }
        objectDetectionConfigBuilder_.setMessage(value);
      }
      annotationRequestConfigCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for video object detection task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig object_detection_config = 7;
     * </code>
     */
    public Builder clearObjectDetectionConfig() {
      if (objectDetectionConfigBuilder_ == null) {
        if (annotationRequestConfigCase_ == 7) {
          annotationRequestConfigCase_ = 0;
          annotationRequestConfig_ = null;
          onChanged();
        }
      } else {
        if (annotationRequestConfigCase_ == 7) {
          annotationRequestConfigCase_ = 0;
          annotationRequestConfig_ = null;
        }
        objectDetectionConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for video object detection task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig object_detection_config = 7;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig.Builder
        getObjectDetectionConfigBuilder() {
      return getObjectDetectionConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for video object detection task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig object_detection_config = 7;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfigOrBuilder
        getObjectDetectionConfigOrBuilder() {
      if ((annotationRequestConfigCase_ == 7) && (objectDetectionConfigBuilder_ != null)) {
        return objectDetectionConfigBuilder_.getMessageOrBuilder();
      } else {
        if (annotationRequestConfigCase_ == 7) {
          return (com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig)
              annotationRequestConfig_;
        }
        return com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for video object detection task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig object_detection_config = 7;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig,
            com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfigOrBuilder>
        getObjectDetectionConfigFieldBuilder() {
      if (objectDetectionConfigBuilder_ == null) {
        if (!(annotationRequestConfigCase_ == 7)) {
          annotationRequestConfig_ =
              com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig.getDefaultInstance();
        }
        objectDetectionConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig,
                com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig.Builder,
                com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfigOrBuilder>(
                (com.google.cloud.datalabeling.v1beta1.ObjectDetectionConfig)
                    annotationRequestConfig_,
                getParentForChildren(),
                isClean());
        annotationRequestConfig_ = null;
      }
      annotationRequestConfigCase_ = 7;
      onChanged();
      ;
      return objectDetectionConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig,
            com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfigOrBuilder>
        objectTrackingConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for video object tracking task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig object_tracking_config = 8;
     * </code>
     *
     * @return Whether the objectTrackingConfig field is set.
     */
    public boolean hasObjectTrackingConfig() {
      return annotationRequestConfigCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * Configuration for video object tracking task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig object_tracking_config = 8;
     * </code>
     *
     * @return The objectTrackingConfig.
     */
    public com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig getObjectTrackingConfig() {
      if (objectTrackingConfigBuilder_ == null) {
        if (annotationRequestConfigCase_ == 8) {
          return (com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig)
              annotationRequestConfig_;
        }
        return com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig.getDefaultInstance();
      } else {
        if (annotationRequestConfigCase_ == 8) {
          return objectTrackingConfigBuilder_.getMessage();
        }
        return com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for video object tracking task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig object_tracking_config = 8;
     * </code>
     */
    public Builder setObjectTrackingConfig(
        com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig value) {
      if (objectTrackingConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        annotationRequestConfig_ = value;
        onChanged();
      } else {
        objectTrackingConfigBuilder_.setMessage(value);
      }
      annotationRequestConfigCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for video object tracking task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig object_tracking_config = 8;
     * </code>
     */
    public Builder setObjectTrackingConfig(
        com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig.Builder builderForValue) {
      if (objectTrackingConfigBuilder_ == null) {
        annotationRequestConfig_ = builderForValue.build();
        onChanged();
      } else {
        objectTrackingConfigBuilder_.setMessage(builderForValue.build());
      }
      annotationRequestConfigCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for video object tracking task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig object_tracking_config = 8;
     * </code>
     */
    public Builder mergeObjectTrackingConfig(
        com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig value) {
      if (objectTrackingConfigBuilder_ == null) {
        if (annotationRequestConfigCase_ == 8
            && annotationRequestConfig_
                != com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig
                    .getDefaultInstance()) {
          annotationRequestConfig_ =
              com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig.newBuilder(
                      (com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig)
                          annotationRequestConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          annotationRequestConfig_ = value;
        }
        onChanged();
      } else {
        if (annotationRequestConfigCase_ == 8) {
          objectTrackingConfigBuilder_.mergeFrom(value);
        }
        objectTrackingConfigBuilder_.setMessage(value);
      }
      annotationRequestConfigCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for video object tracking task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig object_tracking_config = 8;
     * </code>
     */
    public Builder clearObjectTrackingConfig() {
      if (objectTrackingConfigBuilder_ == null) {
        if (annotationRequestConfigCase_ == 8) {
          annotationRequestConfigCase_ = 0;
          annotationRequestConfig_ = null;
          onChanged();
        }
      } else {
        if (annotationRequestConfigCase_ == 8) {
          annotationRequestConfigCase_ = 0;
          annotationRequestConfig_ = null;
        }
        objectTrackingConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for video object tracking task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig object_tracking_config = 8;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig.Builder
        getObjectTrackingConfigBuilder() {
      return getObjectTrackingConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for video object tracking task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig object_tracking_config = 8;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfigOrBuilder
        getObjectTrackingConfigOrBuilder() {
      if ((annotationRequestConfigCase_ == 8) && (objectTrackingConfigBuilder_ != null)) {
        return objectTrackingConfigBuilder_.getMessageOrBuilder();
      } else {
        if (annotationRequestConfigCase_ == 8) {
          return (com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig)
              annotationRequestConfig_;
        }
        return com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for video object tracking task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig object_tracking_config = 8;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig,
            com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfigOrBuilder>
        getObjectTrackingConfigFieldBuilder() {
      if (objectTrackingConfigBuilder_ == null) {
        if (!(annotationRequestConfigCase_ == 8)) {
          annotationRequestConfig_ =
              com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig.getDefaultInstance();
        }
        objectTrackingConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig,
                com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig.Builder,
                com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfigOrBuilder>(
                (com.google.cloud.datalabeling.v1beta1.ObjectTrackingConfig)
                    annotationRequestConfig_,
                getParentForChildren(),
                isClean());
        annotationRequestConfig_ = null;
      }
      annotationRequestConfigCase_ = 8;
      onChanged();
      ;
      return objectTrackingConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.EventConfig,
            com.google.cloud.datalabeling.v1beta1.EventConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.EventConfigOrBuilder>
        eventConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for video event labeling task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EventConfig event_config = 9;</code>
     *
     * @return Whether the eventConfig field is set.
     */
    public boolean hasEventConfig() {
      return annotationRequestConfigCase_ == 9;
    }
    /**
     *
     *
     * <pre>
     * Configuration for video event labeling task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EventConfig event_config = 9;</code>
     *
     * @return The eventConfig.
     */
    public com.google.cloud.datalabeling.v1beta1.EventConfig getEventConfig() {
      if (eventConfigBuilder_ == null) {
        if (annotationRequestConfigCase_ == 9) {
          return (com.google.cloud.datalabeling.v1beta1.EventConfig) annotationRequestConfig_;
        }
        return com.google.cloud.datalabeling.v1beta1.EventConfig.getDefaultInstance();
      } else {
        if (annotationRequestConfigCase_ == 9) {
          return eventConfigBuilder_.getMessage();
        }
        return com.google.cloud.datalabeling.v1beta1.EventConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for video event labeling task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EventConfig event_config = 9;</code>
     */
    public Builder setEventConfig(com.google.cloud.datalabeling.v1beta1.EventConfig value) {
      if (eventConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        annotationRequestConfig_ = value;
        onChanged();
      } else {
        eventConfigBuilder_.setMessage(value);
      }
      annotationRequestConfigCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for video event labeling task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EventConfig event_config = 9;</code>
     */
    public Builder setEventConfig(
        com.google.cloud.datalabeling.v1beta1.EventConfig.Builder builderForValue) {
      if (eventConfigBuilder_ == null) {
        annotationRequestConfig_ = builderForValue.build();
        onChanged();
      } else {
        eventConfigBuilder_.setMessage(builderForValue.build());
      }
      annotationRequestConfigCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for video event labeling task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EventConfig event_config = 9;</code>
     */
    public Builder mergeEventConfig(com.google.cloud.datalabeling.v1beta1.EventConfig value) {
      if (eventConfigBuilder_ == null) {
        if (annotationRequestConfigCase_ == 9
            && annotationRequestConfig_
                != com.google.cloud.datalabeling.v1beta1.EventConfig.getDefaultInstance()) {
          annotationRequestConfig_ =
              com.google.cloud.datalabeling.v1beta1.EventConfig.newBuilder(
                      (com.google.cloud.datalabeling.v1beta1.EventConfig) annotationRequestConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          annotationRequestConfig_ = value;
        }
        onChanged();
      } else {
        if (annotationRequestConfigCase_ == 9) {
          eventConfigBuilder_.mergeFrom(value);
        }
        eventConfigBuilder_.setMessage(value);
      }
      annotationRequestConfigCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for video event labeling task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EventConfig event_config = 9;</code>
     */
    public Builder clearEventConfig() {
      if (eventConfigBuilder_ == null) {
        if (annotationRequestConfigCase_ == 9) {
          annotationRequestConfigCase_ = 0;
          annotationRequestConfig_ = null;
          onChanged();
        }
      } else {
        if (annotationRequestConfigCase_ == 9) {
          annotationRequestConfigCase_ = 0;
          annotationRequestConfig_ = null;
        }
        eventConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for video event labeling task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EventConfig event_config = 9;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.EventConfig.Builder getEventConfigBuilder() {
      return getEventConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for video event labeling task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EventConfig event_config = 9;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.EventConfigOrBuilder getEventConfigOrBuilder() {
      if ((annotationRequestConfigCase_ == 9) && (eventConfigBuilder_ != null)) {
        return eventConfigBuilder_.getMessageOrBuilder();
      } else {
        if (annotationRequestConfigCase_ == 9) {
          return (com.google.cloud.datalabeling.v1beta1.EventConfig) annotationRequestConfig_;
        }
        return com.google.cloud.datalabeling.v1beta1.EventConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for video event labeling task.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.EventConfig event_config = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.EventConfig,
            com.google.cloud.datalabeling.v1beta1.EventConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.EventConfigOrBuilder>
        getEventConfigFieldBuilder() {
      if (eventConfigBuilder_ == null) {
        if (!(annotationRequestConfigCase_ == 9)) {
          annotationRequestConfig_ =
              com.google.cloud.datalabeling.v1beta1.EventConfig.getDefaultInstance();
        }
        eventConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.EventConfig,
                com.google.cloud.datalabeling.v1beta1.EventConfig.Builder,
                com.google.cloud.datalabeling.v1beta1.EventConfigOrBuilder>(
                (com.google.cloud.datalabeling.v1beta1.EventConfig) annotationRequestConfig_,
                getParentForChildren(),
                isClean());
        annotationRequestConfig_ = null;
      }
      annotationRequestConfigCase_ = 9;
      onChanged();
      ;
      return eventConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.TextClassificationConfig,
            com.google.cloud.datalabeling.v1beta1.TextClassificationConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.TextClassificationConfigOrBuilder>
        textClassificationConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for text classification task.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextClassificationConfig text_classification_config = 10;
     * </code>
     *
     * @return Whether the textClassificationConfig field is set.
     */
    public boolean hasTextClassificationConfig() {
      return annotationRequestConfigCase_ == 10;
    }
    /**
     *
     *
     * <pre>
     * Configuration for text classification task.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextClassificationConfig text_classification_config = 10;
     * </code>
     *
     * @return The textClassificationConfig.
     */
    public com.google.cloud.datalabeling.v1beta1.TextClassificationConfig
        getTextClassificationConfig() {
      if (textClassificationConfigBuilder_ == null) {
        if (annotationRequestConfigCase_ == 10) {
          return (com.google.cloud.datalabeling.v1beta1.TextClassificationConfig)
              annotationRequestConfig_;
        }
        return com.google.cloud.datalabeling.v1beta1.TextClassificationConfig.getDefaultInstance();
      } else {
        if (annotationRequestConfigCase_ == 10) {
          return textClassificationConfigBuilder_.getMessage();
        }
        return com.google.cloud.datalabeling.v1beta1.TextClassificationConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for text classification task.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextClassificationConfig text_classification_config = 10;
     * </code>
     */
    public Builder setTextClassificationConfig(
        com.google.cloud.datalabeling.v1beta1.TextClassificationConfig value) {
      if (textClassificationConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        annotationRequestConfig_ = value;
        onChanged();
      } else {
        textClassificationConfigBuilder_.setMessage(value);
      }
      annotationRequestConfigCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for text classification task.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextClassificationConfig text_classification_config = 10;
     * </code>
     */
    public Builder setTextClassificationConfig(
        com.google.cloud.datalabeling.v1beta1.TextClassificationConfig.Builder builderForValue) {
      if (textClassificationConfigBuilder_ == null) {
        annotationRequestConfig_ = builderForValue.build();
        onChanged();
      } else {
        textClassificationConfigBuilder_.setMessage(builderForValue.build());
      }
      annotationRequestConfigCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for text classification task.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextClassificationConfig text_classification_config = 10;
     * </code>
     */
    public Builder mergeTextClassificationConfig(
        com.google.cloud.datalabeling.v1beta1.TextClassificationConfig value) {
      if (textClassificationConfigBuilder_ == null) {
        if (annotationRequestConfigCase_ == 10
            && annotationRequestConfig_
                != com.google.cloud.datalabeling.v1beta1.TextClassificationConfig
                    .getDefaultInstance()) {
          annotationRequestConfig_ =
              com.google.cloud.datalabeling.v1beta1.TextClassificationConfig.newBuilder(
                      (com.google.cloud.datalabeling.v1beta1.TextClassificationConfig)
                          annotationRequestConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          annotationRequestConfig_ = value;
        }
        onChanged();
      } else {
        if (annotationRequestConfigCase_ == 10) {
          textClassificationConfigBuilder_.mergeFrom(value);
        }
        textClassificationConfigBuilder_.setMessage(value);
      }
      annotationRequestConfigCase_ = 10;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for text classification task.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextClassificationConfig text_classification_config = 10;
     * </code>
     */
    public Builder clearTextClassificationConfig() {
      if (textClassificationConfigBuilder_ == null) {
        if (annotationRequestConfigCase_ == 10) {
          annotationRequestConfigCase_ = 0;
          annotationRequestConfig_ = null;
          onChanged();
        }
      } else {
        if (annotationRequestConfigCase_ == 10) {
          annotationRequestConfigCase_ = 0;
          annotationRequestConfig_ = null;
        }
        textClassificationConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for text classification task.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextClassificationConfig text_classification_config = 10;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.TextClassificationConfig.Builder
        getTextClassificationConfigBuilder() {
      return getTextClassificationConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for text classification task.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextClassificationConfig text_classification_config = 10;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.TextClassificationConfigOrBuilder
        getTextClassificationConfigOrBuilder() {
      if ((annotationRequestConfigCase_ == 10) && (textClassificationConfigBuilder_ != null)) {
        return textClassificationConfigBuilder_.getMessageOrBuilder();
      } else {
        if (annotationRequestConfigCase_ == 10) {
          return (com.google.cloud.datalabeling.v1beta1.TextClassificationConfig)
              annotationRequestConfig_;
        }
        return com.google.cloud.datalabeling.v1beta1.TextClassificationConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for text classification task.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextClassificationConfig text_classification_config = 10;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.TextClassificationConfig,
            com.google.cloud.datalabeling.v1beta1.TextClassificationConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.TextClassificationConfigOrBuilder>
        getTextClassificationConfigFieldBuilder() {
      if (textClassificationConfigBuilder_ == null) {
        if (!(annotationRequestConfigCase_ == 10)) {
          annotationRequestConfig_ =
              com.google.cloud.datalabeling.v1beta1.TextClassificationConfig.getDefaultInstance();
        }
        textClassificationConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.TextClassificationConfig,
                com.google.cloud.datalabeling.v1beta1.TextClassificationConfig.Builder,
                com.google.cloud.datalabeling.v1beta1.TextClassificationConfigOrBuilder>(
                (com.google.cloud.datalabeling.v1beta1.TextClassificationConfig)
                    annotationRequestConfig_,
                getParentForChildren(),
                isClean());
        annotationRequestConfig_ = null;
      }
      annotationRequestConfigCase_ = 10;
      onChanged();
      ;
      return textClassificationConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig,
            com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfigOrBuilder>
        textEntityExtractionConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for text entity extraction task.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig text_entity_extraction_config = 11;
     * </code>
     *
     * @return Whether the textEntityExtractionConfig field is set.
     */
    public boolean hasTextEntityExtractionConfig() {
      return annotationRequestConfigCase_ == 11;
    }
    /**
     *
     *
     * <pre>
     * Configuration for text entity extraction task.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig text_entity_extraction_config = 11;
     * </code>
     *
     * @return The textEntityExtractionConfig.
     */
    public com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig
        getTextEntityExtractionConfig() {
      if (textEntityExtractionConfigBuilder_ == null) {
        if (annotationRequestConfigCase_ == 11) {
          return (com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig)
              annotationRequestConfig_;
        }
        return com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig
            .getDefaultInstance();
      } else {
        if (annotationRequestConfigCase_ == 11) {
          return textEntityExtractionConfigBuilder_.getMessage();
        }
        return com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for text entity extraction task.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig text_entity_extraction_config = 11;
     * </code>
     */
    public Builder setTextEntityExtractionConfig(
        com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig value) {
      if (textEntityExtractionConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        annotationRequestConfig_ = value;
        onChanged();
      } else {
        textEntityExtractionConfigBuilder_.setMessage(value);
      }
      annotationRequestConfigCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for text entity extraction task.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig text_entity_extraction_config = 11;
     * </code>
     */
    public Builder setTextEntityExtractionConfig(
        com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig.Builder builderForValue) {
      if (textEntityExtractionConfigBuilder_ == null) {
        annotationRequestConfig_ = builderForValue.build();
        onChanged();
      } else {
        textEntityExtractionConfigBuilder_.setMessage(builderForValue.build());
      }
      annotationRequestConfigCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for text entity extraction task.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig text_entity_extraction_config = 11;
     * </code>
     */
    public Builder mergeTextEntityExtractionConfig(
        com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig value) {
      if (textEntityExtractionConfigBuilder_ == null) {
        if (annotationRequestConfigCase_ == 11
            && annotationRequestConfig_
                != com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig
                    .getDefaultInstance()) {
          annotationRequestConfig_ =
              com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig.newBuilder(
                      (com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig)
                          annotationRequestConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          annotationRequestConfig_ = value;
        }
        onChanged();
      } else {
        if (annotationRequestConfigCase_ == 11) {
          textEntityExtractionConfigBuilder_.mergeFrom(value);
        }
        textEntityExtractionConfigBuilder_.setMessage(value);
      }
      annotationRequestConfigCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for text entity extraction task.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig text_entity_extraction_config = 11;
     * </code>
     */
    public Builder clearTextEntityExtractionConfig() {
      if (textEntityExtractionConfigBuilder_ == null) {
        if (annotationRequestConfigCase_ == 11) {
          annotationRequestConfigCase_ = 0;
          annotationRequestConfig_ = null;
          onChanged();
        }
      } else {
        if (annotationRequestConfigCase_ == 11) {
          annotationRequestConfigCase_ = 0;
          annotationRequestConfig_ = null;
        }
        textEntityExtractionConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for text entity extraction task.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig text_entity_extraction_config = 11;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig.Builder
        getTextEntityExtractionConfigBuilder() {
      return getTextEntityExtractionConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for text entity extraction task.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig text_entity_extraction_config = 11;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfigOrBuilder
        getTextEntityExtractionConfigOrBuilder() {
      if ((annotationRequestConfigCase_ == 11) && (textEntityExtractionConfigBuilder_ != null)) {
        return textEntityExtractionConfigBuilder_.getMessageOrBuilder();
      } else {
        if (annotationRequestConfigCase_ == 11) {
          return (com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig)
              annotationRequestConfig_;
        }
        return com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for text entity extraction task.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig text_entity_extraction_config = 11;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig,
            com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfigOrBuilder>
        getTextEntityExtractionConfigFieldBuilder() {
      if (textEntityExtractionConfigBuilder_ == null) {
        if (!(annotationRequestConfigCase_ == 11)) {
          annotationRequestConfig_ =
              com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig.getDefaultInstance();
        }
        textEntityExtractionConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig,
                com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig.Builder,
                com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfigOrBuilder>(
                (com.google.cloud.datalabeling.v1beta1.TextEntityExtractionConfig)
                    annotationRequestConfig_,
                getParentForChildren(),
                isClean());
        annotationRequestConfig_ = null;
      }
      annotationRequestConfigCase_ = 11;
      onChanged();
      ;
      return textEntityExtractionConfigBuilder_;
    }

    private com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig humanAnnotationConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig,
            com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfigOrBuilder>
        humanAnnotationConfigBuilder_;
    /**
     *
     *
     * <pre>
     * HumanAnnotationConfig used when requesting the human labeling task for this
     * AnnotatedDataset.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig human_annotation_config = 1;
     * </code>
     *
     * @return Whether the humanAnnotationConfig field is set.
     */
    public boolean hasHumanAnnotationConfig() {
      return humanAnnotationConfigBuilder_ != null || humanAnnotationConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * HumanAnnotationConfig used when requesting the human labeling task for this
     * AnnotatedDataset.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig human_annotation_config = 1;
     * </code>
     *
     * @return The humanAnnotationConfig.
     */
    public com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig getHumanAnnotationConfig() {
      if (humanAnnotationConfigBuilder_ == null) {
        return humanAnnotationConfig_ == null
            ? com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.getDefaultInstance()
            : humanAnnotationConfig_;
      } else {
        return humanAnnotationConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * HumanAnnotationConfig used when requesting the human labeling task for this
     * AnnotatedDataset.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig human_annotation_config = 1;
     * </code>
     */
    public Builder setHumanAnnotationConfig(
        com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig value) {
      if (humanAnnotationConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        humanAnnotationConfig_ = value;
        onChanged();
      } else {
        humanAnnotationConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * HumanAnnotationConfig used when requesting the human labeling task for this
     * AnnotatedDataset.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig human_annotation_config = 1;
     * </code>
     */
    public Builder setHumanAnnotationConfig(
        com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.Builder builderForValue) {
      if (humanAnnotationConfigBuilder_ == null) {
        humanAnnotationConfig_ = builderForValue.build();
        onChanged();
      } else {
        humanAnnotationConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * HumanAnnotationConfig used when requesting the human labeling task for this
     * AnnotatedDataset.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig human_annotation_config = 1;
     * </code>
     */
    public Builder mergeHumanAnnotationConfig(
        com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig value) {
      if (humanAnnotationConfigBuilder_ == null) {
        if (humanAnnotationConfig_ != null) {
          humanAnnotationConfig_ =
              com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.newBuilder(
                      humanAnnotationConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          humanAnnotationConfig_ = value;
        }
        onChanged();
      } else {
        humanAnnotationConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * HumanAnnotationConfig used when requesting the human labeling task for this
     * AnnotatedDataset.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig human_annotation_config = 1;
     * </code>
     */
    public Builder clearHumanAnnotationConfig() {
      if (humanAnnotationConfigBuilder_ == null) {
        humanAnnotationConfig_ = null;
        onChanged();
      } else {
        humanAnnotationConfig_ = null;
        humanAnnotationConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * HumanAnnotationConfig used when requesting the human labeling task for this
     * AnnotatedDataset.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig human_annotation_config = 1;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.Builder
        getHumanAnnotationConfigBuilder() {

      onChanged();
      return getHumanAnnotationConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * HumanAnnotationConfig used when requesting the human labeling task for this
     * AnnotatedDataset.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig human_annotation_config = 1;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfigOrBuilder
        getHumanAnnotationConfigOrBuilder() {
      if (humanAnnotationConfigBuilder_ != null) {
        return humanAnnotationConfigBuilder_.getMessageOrBuilder();
      } else {
        return humanAnnotationConfig_ == null
            ? com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.getDefaultInstance()
            : humanAnnotationConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * HumanAnnotationConfig used when requesting the human labeling task for this
     * AnnotatedDataset.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig human_annotation_config = 1;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig,
            com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfigOrBuilder>
        getHumanAnnotationConfigFieldBuilder() {
      if (humanAnnotationConfigBuilder_ == null) {
        humanAnnotationConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig,
                com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.Builder,
                com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfigOrBuilder>(
                getHumanAnnotationConfig(), getParentForChildren(), isClean());
        humanAnnotationConfig_ = null;
      }
      return humanAnnotationConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata)
  private static final com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata();
  }

  public static com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AnnotatedDatasetMetadata> PARSER =
      new com.google.protobuf.AbstractParser<AnnotatedDatasetMetadata>() {
        @java.lang.Override
        public AnnotatedDatasetMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new AnnotatedDatasetMetadata(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<AnnotatedDatasetMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AnnotatedDatasetMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.AnnotatedDatasetMetadata
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
