/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datalabeling/v1beta1/operations.proto

package com.google.cloud.datalabeling.v1beta1;

/**
 *
 *
 * <pre>
 * Metadata of an ImportData operation.
 * </pre>
 *
 * Protobuf type {@code google.cloud.datalabeling.v1beta1.ImportDataOperationMetadata}
 */
public final class ImportDataOperationMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datalabeling.v1beta1.ImportDataOperationMetadata)
    ImportDataOperationMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ImportDataOperationMetadata.newBuilder() to construct.
  private ImportDataOperationMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ImportDataOperationMetadata() {
    dataset_ = "";
    partialFailures_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ImportDataOperationMetadata();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private ImportDataOperationMetadata(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              dataset_ = s;
              break;
            }
          case 18:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                partialFailures_ = new java.util.ArrayList<com.google.rpc.Status>();
                mutable_bitField0_ |= 0x00000001;
              }
              partialFailures_.add(
                  input.readMessage(com.google.rpc.Status.parser(), extensionRegistry));
              break;
            }
          case 26:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (createTime_ != null) {
                subBuilder = createTime_.toBuilder();
              }
              createTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(createTime_);
                createTime_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        partialFailures_ = java.util.Collections.unmodifiableList(partialFailures_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datalabeling.v1beta1.Operations
        .internal_static_google_cloud_datalabeling_v1beta1_ImportDataOperationMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datalabeling.v1beta1.Operations
        .internal_static_google_cloud_datalabeling_v1beta1_ImportDataOperationMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datalabeling.v1beta1.ImportDataOperationMetadata.class,
            com.google.cloud.datalabeling.v1beta1.ImportDataOperationMetadata.Builder.class);
  }

  public static final int DATASET_FIELD_NUMBER = 1;
  private volatile java.lang.Object dataset_;
  /**
   *
   *
   * <pre>
   * Output only. The name of imported dataset.
   * "projects/&#42;&#47;datasets/&#42;"
   * </pre>
   *
   * <code>string dataset = 1;</code>
   *
   * @return The dataset.
   */
  public java.lang.String getDataset() {
    java.lang.Object ref = dataset_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      dataset_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The name of imported dataset.
   * "projects/&#42;&#47;datasets/&#42;"
   * </pre>
   *
   * <code>string dataset = 1;</code>
   *
   * @return The bytes for dataset.
   */
  public com.google.protobuf.ByteString getDatasetBytes() {
    java.lang.Object ref = dataset_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      dataset_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PARTIAL_FAILURES_FIELD_NUMBER = 2;
  private java.util.List<com.google.rpc.Status> partialFailures_;
  /**
   *
   *
   * <pre>
   * Output only. Partial failures encountered.
   * E.g. single files that couldn't be read.
   * Status details field will contain standard GCP error details.
   * </pre>
   *
   * <code>repeated .google.rpc.Status partial_failures = 2;</code>
   */
  public java.util.List<com.google.rpc.Status> getPartialFailuresList() {
    return partialFailures_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Partial failures encountered.
   * E.g. single files that couldn't be read.
   * Status details field will contain standard GCP error details.
   * </pre>
   *
   * <code>repeated .google.rpc.Status partial_failures = 2;</code>
   */
  public java.util.List<? extends com.google.rpc.StatusOrBuilder>
      getPartialFailuresOrBuilderList() {
    return partialFailures_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Partial failures encountered.
   * E.g. single files that couldn't be read.
   * Status details field will contain standard GCP error details.
   * </pre>
   *
   * <code>repeated .google.rpc.Status partial_failures = 2;</code>
   */
  public int getPartialFailuresCount() {
    return partialFailures_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Partial failures encountered.
   * E.g. single files that couldn't be read.
   * Status details field will contain standard GCP error details.
   * </pre>
   *
   * <code>repeated .google.rpc.Status partial_failures = 2;</code>
   */
  public com.google.rpc.Status getPartialFailures(int index) {
    return partialFailures_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. Partial failures encountered.
   * E.g. single files that couldn't be read.
   * Status details field will contain standard GCP error details.
   * </pre>
   *
   * <code>repeated .google.rpc.Status partial_failures = 2;</code>
   */
  public com.google.rpc.StatusOrBuilder getPartialFailuresOrBuilder(int index) {
    return partialFailures_.get(index);
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when import dataset request was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3;</code>
   *
   * @return Whether the createTime field is set.
   */
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when import dataset request was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3;</code>
   *
   * @return The createTime.
   */
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when import dataset request was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 3;</code>
   */
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return getCreateTime();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getDatasetBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, dataset_);
    }
    for (int i = 0; i < partialFailures_.size(); i++) {
      output.writeMessage(2, partialFailures_.get(i));
    }
    if (createTime_ != null) {
      output.writeMessage(3, getCreateTime());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getDatasetBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, dataset_);
    }
    for (int i = 0; i < partialFailures_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, partialFailures_.get(i));
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getCreateTime());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datalabeling.v1beta1.ImportDataOperationMetadata)) {
      return super.equals(obj);
    }
    com.google.cloud.datalabeling.v1beta1.ImportDataOperationMetadata other =
        (com.google.cloud.datalabeling.v1beta1.ImportDataOperationMetadata) obj;

    if (!getDataset().equals(other.getDataset())) return false;
    if (!getPartialFailuresList().equals(other.getPartialFailuresList())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DATASET_FIELD_NUMBER;
    hash = (53 * hash) + getDataset().hashCode();
    if (getPartialFailuresCount() > 0) {
      hash = (37 * hash) + PARTIAL_FAILURES_FIELD_NUMBER;
      hash = (53 * hash) + getPartialFailuresList().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datalabeling.v1beta1.ImportDataOperationMetadata parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.ImportDataOperationMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.ImportDataOperationMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.ImportDataOperationMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.ImportDataOperationMetadata parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.ImportDataOperationMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.ImportDataOperationMetadata parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.ImportDataOperationMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.ImportDataOperationMetadata
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.ImportDataOperationMetadata
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.ImportDataOperationMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.ImportDataOperationMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.datalabeling.v1beta1.ImportDataOperationMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Metadata of an ImportData operation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datalabeling.v1beta1.ImportDataOperationMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datalabeling.v1beta1.ImportDataOperationMetadata)
      com.google.cloud.datalabeling.v1beta1.ImportDataOperationMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datalabeling.v1beta1.Operations
          .internal_static_google_cloud_datalabeling_v1beta1_ImportDataOperationMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datalabeling.v1beta1.Operations
          .internal_static_google_cloud_datalabeling_v1beta1_ImportDataOperationMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datalabeling.v1beta1.ImportDataOperationMetadata.class,
              com.google.cloud.datalabeling.v1beta1.ImportDataOperationMetadata.Builder.class);
    }

    // Construct using
    // com.google.cloud.datalabeling.v1beta1.ImportDataOperationMetadata.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getPartialFailuresFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      dataset_ = "";

      if (partialFailuresBuilder_ == null) {
        partialFailures_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        partialFailuresBuilder_.clear();
      }
      if (createTimeBuilder_ == null) {
        createTime_ = null;
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datalabeling.v1beta1.Operations
          .internal_static_google_cloud_datalabeling_v1beta1_ImportDataOperationMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.ImportDataOperationMetadata
        getDefaultInstanceForType() {
      return com.google.cloud.datalabeling.v1beta1.ImportDataOperationMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.ImportDataOperationMetadata build() {
      com.google.cloud.datalabeling.v1beta1.ImportDataOperationMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.ImportDataOperationMetadata buildPartial() {
      com.google.cloud.datalabeling.v1beta1.ImportDataOperationMetadata result =
          new com.google.cloud.datalabeling.v1beta1.ImportDataOperationMetadata(this);
      int from_bitField0_ = bitField0_;
      result.dataset_ = dataset_;
      if (partialFailuresBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          partialFailures_ = java.util.Collections.unmodifiableList(partialFailures_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.partialFailures_ = partialFailures_;
      } else {
        result.partialFailures_ = partialFailuresBuilder_.build();
      }
      if (createTimeBuilder_ == null) {
        result.createTime_ = createTime_;
      } else {
        result.createTime_ = createTimeBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datalabeling.v1beta1.ImportDataOperationMetadata) {
        return mergeFrom((com.google.cloud.datalabeling.v1beta1.ImportDataOperationMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.datalabeling.v1beta1.ImportDataOperationMetadata other) {
      if (other
          == com.google.cloud.datalabeling.v1beta1.ImportDataOperationMetadata.getDefaultInstance())
        return this;
      if (!other.getDataset().isEmpty()) {
        dataset_ = other.dataset_;
        onChanged();
      }
      if (partialFailuresBuilder_ == null) {
        if (!other.partialFailures_.isEmpty()) {
          if (partialFailures_.isEmpty()) {
            partialFailures_ = other.partialFailures_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensurePartialFailuresIsMutable();
            partialFailures_.addAll(other.partialFailures_);
          }
          onChanged();
        }
      } else {
        if (!other.partialFailures_.isEmpty()) {
          if (partialFailuresBuilder_.isEmpty()) {
            partialFailuresBuilder_.dispose();
            partialFailuresBuilder_ = null;
            partialFailures_ = other.partialFailures_;
            bitField0_ = (bitField0_ & ~0x00000001);
            partialFailuresBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPartialFailuresFieldBuilder()
                    : null;
          } else {
            partialFailuresBuilder_.addAllMessages(other.partialFailures_);
          }
        }
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.datalabeling.v1beta1.ImportDataOperationMetadata parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.datalabeling.v1beta1.ImportDataOperationMetadata)
                e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object dataset_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The name of imported dataset.
     * "projects/&#42;&#47;datasets/&#42;"
     * </pre>
     *
     * <code>string dataset = 1;</code>
     *
     * @return The dataset.
     */
    public java.lang.String getDataset() {
      java.lang.Object ref = dataset_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dataset_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of imported dataset.
     * "projects/&#42;&#47;datasets/&#42;"
     * </pre>
     *
     * <code>string dataset = 1;</code>
     *
     * @return The bytes for dataset.
     */
    public com.google.protobuf.ByteString getDatasetBytes() {
      java.lang.Object ref = dataset_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dataset_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of imported dataset.
     * "projects/&#42;&#47;datasets/&#42;"
     * </pre>
     *
     * <code>string dataset = 1;</code>
     *
     * @param value The dataset to set.
     * @return This builder for chaining.
     */
    public Builder setDataset(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      dataset_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of imported dataset.
     * "projects/&#42;&#47;datasets/&#42;"
     * </pre>
     *
     * <code>string dataset = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDataset() {

      dataset_ = getDefaultInstance().getDataset();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The name of imported dataset.
     * "projects/&#42;&#47;datasets/&#42;"
     * </pre>
     *
     * <code>string dataset = 1;</code>
     *
     * @param value The bytes for dataset to set.
     * @return This builder for chaining.
     */
    public Builder setDatasetBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      dataset_ = value;
      onChanged();
      return this;
    }

    private java.util.List<com.google.rpc.Status> partialFailures_ =
        java.util.Collections.emptyList();

    private void ensurePartialFailuresIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        partialFailures_ = new java.util.ArrayList<com.google.rpc.Status>(partialFailures_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        partialFailuresBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * E.g. single files that couldn't be read.
     * Status details field will contain standard GCP error details.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_failures = 2;</code>
     */
    public java.util.List<com.google.rpc.Status> getPartialFailuresList() {
      if (partialFailuresBuilder_ == null) {
        return java.util.Collections.unmodifiableList(partialFailures_);
      } else {
        return partialFailuresBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * E.g. single files that couldn't be read.
     * Status details field will contain standard GCP error details.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_failures = 2;</code>
     */
    public int getPartialFailuresCount() {
      if (partialFailuresBuilder_ == null) {
        return partialFailures_.size();
      } else {
        return partialFailuresBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * E.g. single files that couldn't be read.
     * Status details field will contain standard GCP error details.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_failures = 2;</code>
     */
    public com.google.rpc.Status getPartialFailures(int index) {
      if (partialFailuresBuilder_ == null) {
        return partialFailures_.get(index);
      } else {
        return partialFailuresBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * E.g. single files that couldn't be read.
     * Status details field will contain standard GCP error details.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_failures = 2;</code>
     */
    public Builder setPartialFailures(int index, com.google.rpc.Status value) {
      if (partialFailuresBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePartialFailuresIsMutable();
        partialFailures_.set(index, value);
        onChanged();
      } else {
        partialFailuresBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * E.g. single files that couldn't be read.
     * Status details field will contain standard GCP error details.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_failures = 2;</code>
     */
    public Builder setPartialFailures(int index, com.google.rpc.Status.Builder builderForValue) {
      if (partialFailuresBuilder_ == null) {
        ensurePartialFailuresIsMutable();
        partialFailures_.set(index, builderForValue.build());
        onChanged();
      } else {
        partialFailuresBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * E.g. single files that couldn't be read.
     * Status details field will contain standard GCP error details.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_failures = 2;</code>
     */
    public Builder addPartialFailures(com.google.rpc.Status value) {
      if (partialFailuresBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePartialFailuresIsMutable();
        partialFailures_.add(value);
        onChanged();
      } else {
        partialFailuresBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * E.g. single files that couldn't be read.
     * Status details field will contain standard GCP error details.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_failures = 2;</code>
     */
    public Builder addPartialFailures(int index, com.google.rpc.Status value) {
      if (partialFailuresBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePartialFailuresIsMutable();
        partialFailures_.add(index, value);
        onChanged();
      } else {
        partialFailuresBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * E.g. single files that couldn't be read.
     * Status details field will contain standard GCP error details.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_failures = 2;</code>
     */
    public Builder addPartialFailures(com.google.rpc.Status.Builder builderForValue) {
      if (partialFailuresBuilder_ == null) {
        ensurePartialFailuresIsMutable();
        partialFailures_.add(builderForValue.build());
        onChanged();
      } else {
        partialFailuresBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * E.g. single files that couldn't be read.
     * Status details field will contain standard GCP error details.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_failures = 2;</code>
     */
    public Builder addPartialFailures(int index, com.google.rpc.Status.Builder builderForValue) {
      if (partialFailuresBuilder_ == null) {
        ensurePartialFailuresIsMutable();
        partialFailures_.add(index, builderForValue.build());
        onChanged();
      } else {
        partialFailuresBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * E.g. single files that couldn't be read.
     * Status details field will contain standard GCP error details.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_failures = 2;</code>
     */
    public Builder addAllPartialFailures(
        java.lang.Iterable<? extends com.google.rpc.Status> values) {
      if (partialFailuresBuilder_ == null) {
        ensurePartialFailuresIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, partialFailures_);
        onChanged();
      } else {
        partialFailuresBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * E.g. single files that couldn't be read.
     * Status details field will contain standard GCP error details.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_failures = 2;</code>
     */
    public Builder clearPartialFailures() {
      if (partialFailuresBuilder_ == null) {
        partialFailures_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        partialFailuresBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * E.g. single files that couldn't be read.
     * Status details field will contain standard GCP error details.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_failures = 2;</code>
     */
    public Builder removePartialFailures(int index) {
      if (partialFailuresBuilder_ == null) {
        ensurePartialFailuresIsMutable();
        partialFailures_.remove(index);
        onChanged();
      } else {
        partialFailuresBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * E.g. single files that couldn't be read.
     * Status details field will contain standard GCP error details.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_failures = 2;</code>
     */
    public com.google.rpc.Status.Builder getPartialFailuresBuilder(int index) {
      return getPartialFailuresFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * E.g. single files that couldn't be read.
     * Status details field will contain standard GCP error details.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_failures = 2;</code>
     */
    public com.google.rpc.StatusOrBuilder getPartialFailuresOrBuilder(int index) {
      if (partialFailuresBuilder_ == null) {
        return partialFailures_.get(index);
      } else {
        return partialFailuresBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * E.g. single files that couldn't be read.
     * Status details field will contain standard GCP error details.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_failures = 2;</code>
     */
    public java.util.List<? extends com.google.rpc.StatusOrBuilder>
        getPartialFailuresOrBuilderList() {
      if (partialFailuresBuilder_ != null) {
        return partialFailuresBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(partialFailures_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * E.g. single files that couldn't be read.
     * Status details field will contain standard GCP error details.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_failures = 2;</code>
     */
    public com.google.rpc.Status.Builder addPartialFailuresBuilder() {
      return getPartialFailuresFieldBuilder()
          .addBuilder(com.google.rpc.Status.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * E.g. single files that couldn't be read.
     * Status details field will contain standard GCP error details.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_failures = 2;</code>
     */
    public com.google.rpc.Status.Builder addPartialFailuresBuilder(int index) {
      return getPartialFailuresFieldBuilder()
          .addBuilder(index, com.google.rpc.Status.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * E.g. single files that couldn't be read.
     * Status details field will contain standard GCP error details.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_failures = 2;</code>
     */
    public java.util.List<com.google.rpc.Status.Builder> getPartialFailuresBuilderList() {
      return getPartialFailuresFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getPartialFailuresFieldBuilder() {
      if (partialFailuresBuilder_ == null) {
        partialFailuresBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(
                partialFailures_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        partialFailures_ = null;
      }
      return partialFailuresBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when import dataset request was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return createTimeBuilder_ != null || createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when import dataset request was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when import dataset request was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
        onChanged();
      } else {
        createTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when import dataset request was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
        onChanged();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when import dataset request was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (createTime_ != null) {
          createTime_ =
              com.google.protobuf.Timestamp.newBuilder(createTime_).mergeFrom(value).buildPartial();
        } else {
          createTime_ = value;
        }
        onChanged();
      } else {
        createTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when import dataset request was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     */
    public Builder clearCreateTime() {
      if (createTimeBuilder_ == null) {
        createTime_ = null;
        onChanged();
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when import dataset request was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {

      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when import dataset request was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when import dataset request was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datalabeling.v1beta1.ImportDataOperationMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datalabeling.v1beta1.ImportDataOperationMetadata)
  private static final com.google.cloud.datalabeling.v1beta1.ImportDataOperationMetadata
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datalabeling.v1beta1.ImportDataOperationMetadata();
  }

  public static com.google.cloud.datalabeling.v1beta1.ImportDataOperationMetadata
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ImportDataOperationMetadata> PARSER =
      new com.google.protobuf.AbstractParser<ImportDataOperationMetadata>() {
        @java.lang.Override
        public ImportDataOperationMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new ImportDataOperationMetadata(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<ImportDataOperationMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ImportDataOperationMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.ImportDataOperationMetadata
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
