/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datalabeling/v1beta1/dataset.proto

package com.google.cloud.datalabeling.v1beta1;

/**
 *
 *
 * <pre>
 * The configuration of input data, including data type, location, etc.
 * </pre>
 *
 * Protobuf type {@code google.cloud.datalabeling.v1beta1.InputConfig}
 */
public final class InputConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datalabeling.v1beta1.InputConfig)
    InputConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use InputConfig.newBuilder() to construct.
  private InputConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private InputConfig() {
    dataType_ = 0;
    annotationType_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new InputConfig();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private InputConfig(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 8:
            {
              int rawValue = input.readEnum();

              dataType_ = rawValue;
              break;
            }
          case 18:
            {
              com.google.cloud.datalabeling.v1beta1.GcsSource.Builder subBuilder = null;
              if (sourceCase_ == 2) {
                subBuilder =
                    ((com.google.cloud.datalabeling.v1beta1.GcsSource) source_).toBuilder();
              }
              source_ =
                  input.readMessage(
                      com.google.cloud.datalabeling.v1beta1.GcsSource.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.cloud.datalabeling.v1beta1.GcsSource) source_);
                source_ = subBuilder.buildPartial();
              }
              sourceCase_ = 2;
              break;
            }
          case 24:
            {
              int rawValue = input.readEnum();

              annotationType_ = rawValue;
              break;
            }
          case 34:
            {
              com.google.cloud.datalabeling.v1beta1.ClassificationMetadata.Builder subBuilder =
                  null;
              if (classificationMetadata_ != null) {
                subBuilder = classificationMetadata_.toBuilder();
              }
              classificationMetadata_ =
                  input.readMessage(
                      com.google.cloud.datalabeling.v1beta1.ClassificationMetadata.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(classificationMetadata_);
                classificationMetadata_ = subBuilder.buildPartial();
              }

              break;
            }
          case 42:
            {
              com.google.cloud.datalabeling.v1beta1.BigQuerySource.Builder subBuilder = null;
              if (sourceCase_ == 5) {
                subBuilder =
                    ((com.google.cloud.datalabeling.v1beta1.BigQuerySource) source_).toBuilder();
              }
              source_ =
                  input.readMessage(
                      com.google.cloud.datalabeling.v1beta1.BigQuerySource.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.datalabeling.v1beta1.BigQuerySource) source_);
                source_ = subBuilder.buildPartial();
              }
              sourceCase_ = 5;
              break;
            }
          case 50:
            {
              com.google.cloud.datalabeling.v1beta1.TextMetadata.Builder subBuilder = null;
              if (dataTypeMetadataCase_ == 6) {
                subBuilder =
                    ((com.google.cloud.datalabeling.v1beta1.TextMetadata) dataTypeMetadata_)
                        .toBuilder();
              }
              dataTypeMetadata_ =
                  input.readMessage(
                      com.google.cloud.datalabeling.v1beta1.TextMetadata.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.datalabeling.v1beta1.TextMetadata) dataTypeMetadata_);
                dataTypeMetadata_ = subBuilder.buildPartial();
              }
              dataTypeMetadataCase_ = 6;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datalabeling.v1beta1.DatasetOuterClass
        .internal_static_google_cloud_datalabeling_v1beta1_InputConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datalabeling.v1beta1.DatasetOuterClass
        .internal_static_google_cloud_datalabeling_v1beta1_InputConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datalabeling.v1beta1.InputConfig.class,
            com.google.cloud.datalabeling.v1beta1.InputConfig.Builder.class);
  }

  private int dataTypeMetadataCase_ = 0;
  private java.lang.Object dataTypeMetadata_;

  public enum DataTypeMetadataCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    TEXT_METADATA(6),
    DATATYPEMETADATA_NOT_SET(0);
    private final int value;

    private DataTypeMetadataCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DataTypeMetadataCase valueOf(int value) {
      return forNumber(value);
    }

    public static DataTypeMetadataCase forNumber(int value) {
      switch (value) {
        case 6:
          return TEXT_METADATA;
        case 0:
          return DATATYPEMETADATA_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DataTypeMetadataCase getDataTypeMetadataCase() {
    return DataTypeMetadataCase.forNumber(dataTypeMetadataCase_);
  }

  private int sourceCase_ = 0;
  private java.lang.Object source_;

  public enum SourceCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    GCS_SOURCE(2),
    BIGQUERY_SOURCE(5),
    SOURCE_NOT_SET(0);
    private final int value;

    private SourceCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SourceCase valueOf(int value) {
      return forNumber(value);
    }

    public static SourceCase forNumber(int value) {
      switch (value) {
        case 2:
          return GCS_SOURCE;
        case 5:
          return BIGQUERY_SOURCE;
        case 0:
          return SOURCE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SourceCase getSourceCase() {
    return SourceCase.forNumber(sourceCase_);
  }

  public static final int TEXT_METADATA_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * Required for text import, as language code must be specified.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.TextMetadata text_metadata = 6;</code>
   *
   * @return Whether the textMetadata field is set.
   */
  @java.lang.Override
  public boolean hasTextMetadata() {
    return dataTypeMetadataCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * Required for text import, as language code must be specified.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.TextMetadata text_metadata = 6;</code>
   *
   * @return The textMetadata.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.TextMetadata getTextMetadata() {
    if (dataTypeMetadataCase_ == 6) {
      return (com.google.cloud.datalabeling.v1beta1.TextMetadata) dataTypeMetadata_;
    }
    return com.google.cloud.datalabeling.v1beta1.TextMetadata.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Required for text import, as language code must be specified.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.TextMetadata text_metadata = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.TextMetadataOrBuilder getTextMetadataOrBuilder() {
    if (dataTypeMetadataCase_ == 6) {
      return (com.google.cloud.datalabeling.v1beta1.TextMetadata) dataTypeMetadata_;
    }
    return com.google.cloud.datalabeling.v1beta1.TextMetadata.getDefaultInstance();
  }

  public static final int GCS_SOURCE_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Source located in Cloud Storage.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.GcsSource gcs_source = 2;</code>
   *
   * @return Whether the gcsSource field is set.
   */
  @java.lang.Override
  public boolean hasGcsSource() {
    return sourceCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Source located in Cloud Storage.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.GcsSource gcs_source = 2;</code>
   *
   * @return The gcsSource.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.GcsSource getGcsSource() {
    if (sourceCase_ == 2) {
      return (com.google.cloud.datalabeling.v1beta1.GcsSource) source_;
    }
    return com.google.cloud.datalabeling.v1beta1.GcsSource.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Source located in Cloud Storage.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.GcsSource gcs_source = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.GcsSourceOrBuilder getGcsSourceOrBuilder() {
    if (sourceCase_ == 2) {
      return (com.google.cloud.datalabeling.v1beta1.GcsSource) source_;
    }
    return com.google.cloud.datalabeling.v1beta1.GcsSource.getDefaultInstance();
  }

  public static final int BIGQUERY_SOURCE_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Source located in BigQuery. You must specify this field if you are using
   * this InputConfig in an [EvaluationJob][google.cloud.datalabeling.v1beta1.EvaluationJob].
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.BigQuerySource bigquery_source = 5;</code>
   *
   * @return Whether the bigquerySource field is set.
   */
  @java.lang.Override
  public boolean hasBigquerySource() {
    return sourceCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Source located in BigQuery. You must specify this field if you are using
   * this InputConfig in an [EvaluationJob][google.cloud.datalabeling.v1beta1.EvaluationJob].
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.BigQuerySource bigquery_source = 5;</code>
   *
   * @return The bigquerySource.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.BigQuerySource getBigquerySource() {
    if (sourceCase_ == 5) {
      return (com.google.cloud.datalabeling.v1beta1.BigQuerySource) source_;
    }
    return com.google.cloud.datalabeling.v1beta1.BigQuerySource.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Source located in BigQuery. You must specify this field if you are using
   * this InputConfig in an [EvaluationJob][google.cloud.datalabeling.v1beta1.EvaluationJob].
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.BigQuerySource bigquery_source = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.BigQuerySourceOrBuilder
      getBigquerySourceOrBuilder() {
    if (sourceCase_ == 5) {
      return (com.google.cloud.datalabeling.v1beta1.BigQuerySource) source_;
    }
    return com.google.cloud.datalabeling.v1beta1.BigQuerySource.getDefaultInstance();
  }

  public static final int DATA_TYPE_FIELD_NUMBER = 1;
  private int dataType_;
  /**
   *
   *
   * <pre>
   * Required. Data type must be specifed when user tries to import data.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.DataType data_type = 1;</code>
   *
   * @return The enum numeric value on the wire for dataType.
   */
  @java.lang.Override
  public int getDataTypeValue() {
    return dataType_;
  }
  /**
   *
   *
   * <pre>
   * Required. Data type must be specifed when user tries to import data.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.DataType data_type = 1;</code>
   *
   * @return The dataType.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.DataType getDataType() {
    @SuppressWarnings("deprecation")
    com.google.cloud.datalabeling.v1beta1.DataType result =
        com.google.cloud.datalabeling.v1beta1.DataType.valueOf(dataType_);
    return result == null ? com.google.cloud.datalabeling.v1beta1.DataType.UNRECOGNIZED : result;
  }

  public static final int ANNOTATION_TYPE_FIELD_NUMBER = 3;
  private int annotationType_;
  /**
   *
   *
   * <pre>
   * Optional. The type of annotation to be performed on this data. You must
   * specify this field if you are using this InputConfig in an
   * [EvaluationJob][google.cloud.datalabeling.v1beta1.EvaluationJob].
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.AnnotationType annotation_type = 3;</code>
   *
   * @return The enum numeric value on the wire for annotationType.
   */
  @java.lang.Override
  public int getAnnotationTypeValue() {
    return annotationType_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The type of annotation to be performed on this data. You must
   * specify this field if you are using this InputConfig in an
   * [EvaluationJob][google.cloud.datalabeling.v1beta1.EvaluationJob].
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.AnnotationType annotation_type = 3;</code>
   *
   * @return The annotationType.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.AnnotationType getAnnotationType() {
    @SuppressWarnings("deprecation")
    com.google.cloud.datalabeling.v1beta1.AnnotationType result =
        com.google.cloud.datalabeling.v1beta1.AnnotationType.valueOf(annotationType_);
    return result == null
        ? com.google.cloud.datalabeling.v1beta1.AnnotationType.UNRECOGNIZED
        : result;
  }

  public static final int CLASSIFICATION_METADATA_FIELD_NUMBER = 4;
  private com.google.cloud.datalabeling.v1beta1.ClassificationMetadata classificationMetadata_;
  /**
   *
   *
   * <pre>
   * Optional. Metadata about annotations for the input. You must specify this
   * field if you are using this InputConfig in an [EvaluationJob][google.cloud.datalabeling.v1beta1.EvaluationJob] for a
   * model version that performs classification.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.ClassificationMetadata classification_metadata = 4;
   * </code>
   *
   * @return Whether the classificationMetadata field is set.
   */
  @java.lang.Override
  public boolean hasClassificationMetadata() {
    return classificationMetadata_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Metadata about annotations for the input. You must specify this
   * field if you are using this InputConfig in an [EvaluationJob][google.cloud.datalabeling.v1beta1.EvaluationJob] for a
   * model version that performs classification.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.ClassificationMetadata classification_metadata = 4;
   * </code>
   *
   * @return The classificationMetadata.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.ClassificationMetadata getClassificationMetadata() {
    return classificationMetadata_ == null
        ? com.google.cloud.datalabeling.v1beta1.ClassificationMetadata.getDefaultInstance()
        : classificationMetadata_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Metadata about annotations for the input. You must specify this
   * field if you are using this InputConfig in an [EvaluationJob][google.cloud.datalabeling.v1beta1.EvaluationJob] for a
   * model version that performs classification.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.ClassificationMetadata classification_metadata = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.ClassificationMetadataOrBuilder
      getClassificationMetadataOrBuilder() {
    return getClassificationMetadata();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (dataType_
        != com.google.cloud.datalabeling.v1beta1.DataType.DATA_TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(1, dataType_);
    }
    if (sourceCase_ == 2) {
      output.writeMessage(2, (com.google.cloud.datalabeling.v1beta1.GcsSource) source_);
    }
    if (annotationType_
        != com.google.cloud.datalabeling.v1beta1.AnnotationType.ANNOTATION_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, annotationType_);
    }
    if (classificationMetadata_ != null) {
      output.writeMessage(4, getClassificationMetadata());
    }
    if (sourceCase_ == 5) {
      output.writeMessage(5, (com.google.cloud.datalabeling.v1beta1.BigQuerySource) source_);
    }
    if (dataTypeMetadataCase_ == 6) {
      output.writeMessage(
          6, (com.google.cloud.datalabeling.v1beta1.TextMetadata) dataTypeMetadata_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (dataType_
        != com.google.cloud.datalabeling.v1beta1.DataType.DATA_TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, dataType_);
    }
    if (sourceCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.datalabeling.v1beta1.GcsSource) source_);
    }
    if (annotationType_
        != com.google.cloud.datalabeling.v1beta1.AnnotationType.ANNOTATION_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, annotationType_);
    }
    if (classificationMetadata_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(4, getClassificationMetadata());
    }
    if (sourceCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloud.datalabeling.v1beta1.BigQuerySource) source_);
    }
    if (dataTypeMetadataCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloud.datalabeling.v1beta1.TextMetadata) dataTypeMetadata_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datalabeling.v1beta1.InputConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.datalabeling.v1beta1.InputConfig other =
        (com.google.cloud.datalabeling.v1beta1.InputConfig) obj;

    if (dataType_ != other.dataType_) return false;
    if (annotationType_ != other.annotationType_) return false;
    if (hasClassificationMetadata() != other.hasClassificationMetadata()) return false;
    if (hasClassificationMetadata()) {
      if (!getClassificationMetadata().equals(other.getClassificationMetadata())) return false;
    }
    if (!getDataTypeMetadataCase().equals(other.getDataTypeMetadataCase())) return false;
    switch (dataTypeMetadataCase_) {
      case 6:
        if (!getTextMetadata().equals(other.getTextMetadata())) return false;
        break;
      case 0:
      default:
    }
    if (!getSourceCase().equals(other.getSourceCase())) return false;
    switch (sourceCase_) {
      case 2:
        if (!getGcsSource().equals(other.getGcsSource())) return false;
        break;
      case 5:
        if (!getBigquerySource().equals(other.getBigquerySource())) return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DATA_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + dataType_;
    hash = (37 * hash) + ANNOTATION_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + annotationType_;
    if (hasClassificationMetadata()) {
      hash = (37 * hash) + CLASSIFICATION_METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getClassificationMetadata().hashCode();
    }
    switch (dataTypeMetadataCase_) {
      case 6:
        hash = (37 * hash) + TEXT_METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getTextMetadata().hashCode();
        break;
      case 0:
      default:
    }
    switch (sourceCase_) {
      case 2:
        hash = (37 * hash) + GCS_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getGcsSource().hashCode();
        break;
      case 5:
        hash = (37 * hash) + BIGQUERY_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getBigquerySource().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datalabeling.v1beta1.InputConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.InputConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.InputConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.InputConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.InputConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.InputConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.InputConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.InputConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.InputConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.InputConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.InputConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.InputConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.datalabeling.v1beta1.InputConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The configuration of input data, including data type, location, etc.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datalabeling.v1beta1.InputConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datalabeling.v1beta1.InputConfig)
      com.google.cloud.datalabeling.v1beta1.InputConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datalabeling.v1beta1.DatasetOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_InputConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datalabeling.v1beta1.DatasetOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_InputConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datalabeling.v1beta1.InputConfig.class,
              com.google.cloud.datalabeling.v1beta1.InputConfig.Builder.class);
    }

    // Construct using com.google.cloud.datalabeling.v1beta1.InputConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      dataType_ = 0;

      annotationType_ = 0;

      if (classificationMetadataBuilder_ == null) {
        classificationMetadata_ = null;
      } else {
        classificationMetadata_ = null;
        classificationMetadataBuilder_ = null;
      }
      dataTypeMetadataCase_ = 0;
      dataTypeMetadata_ = null;
      sourceCase_ = 0;
      source_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datalabeling.v1beta1.DatasetOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_InputConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.InputConfig getDefaultInstanceForType() {
      return com.google.cloud.datalabeling.v1beta1.InputConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.InputConfig build() {
      com.google.cloud.datalabeling.v1beta1.InputConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.InputConfig buildPartial() {
      com.google.cloud.datalabeling.v1beta1.InputConfig result =
          new com.google.cloud.datalabeling.v1beta1.InputConfig(this);
      if (dataTypeMetadataCase_ == 6) {
        if (textMetadataBuilder_ == null) {
          result.dataTypeMetadata_ = dataTypeMetadata_;
        } else {
          result.dataTypeMetadata_ = textMetadataBuilder_.build();
        }
      }
      if (sourceCase_ == 2) {
        if (gcsSourceBuilder_ == null) {
          result.source_ = source_;
        } else {
          result.source_ = gcsSourceBuilder_.build();
        }
      }
      if (sourceCase_ == 5) {
        if (bigquerySourceBuilder_ == null) {
          result.source_ = source_;
        } else {
          result.source_ = bigquerySourceBuilder_.build();
        }
      }
      result.dataType_ = dataType_;
      result.annotationType_ = annotationType_;
      if (classificationMetadataBuilder_ == null) {
        result.classificationMetadata_ = classificationMetadata_;
      } else {
        result.classificationMetadata_ = classificationMetadataBuilder_.build();
      }
      result.dataTypeMetadataCase_ = dataTypeMetadataCase_;
      result.sourceCase_ = sourceCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datalabeling.v1beta1.InputConfig) {
        return mergeFrom((com.google.cloud.datalabeling.v1beta1.InputConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datalabeling.v1beta1.InputConfig other) {
      if (other == com.google.cloud.datalabeling.v1beta1.InputConfig.getDefaultInstance())
        return this;
      if (other.dataType_ != 0) {
        setDataTypeValue(other.getDataTypeValue());
      }
      if (other.annotationType_ != 0) {
        setAnnotationTypeValue(other.getAnnotationTypeValue());
      }
      if (other.hasClassificationMetadata()) {
        mergeClassificationMetadata(other.getClassificationMetadata());
      }
      switch (other.getDataTypeMetadataCase()) {
        case TEXT_METADATA:
          {
            mergeTextMetadata(other.getTextMetadata());
            break;
          }
        case DATATYPEMETADATA_NOT_SET:
          {
            break;
          }
      }
      switch (other.getSourceCase()) {
        case GCS_SOURCE:
          {
            mergeGcsSource(other.getGcsSource());
            break;
          }
        case BIGQUERY_SOURCE:
          {
            mergeBigquerySource(other.getBigquerySource());
            break;
          }
        case SOURCE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.datalabeling.v1beta1.InputConfig parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.datalabeling.v1beta1.InputConfig) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int dataTypeMetadataCase_ = 0;
    private java.lang.Object dataTypeMetadata_;

    public DataTypeMetadataCase getDataTypeMetadataCase() {
      return DataTypeMetadataCase.forNumber(dataTypeMetadataCase_);
    }

    public Builder clearDataTypeMetadata() {
      dataTypeMetadataCase_ = 0;
      dataTypeMetadata_ = null;
      onChanged();
      return this;
    }

    private int sourceCase_ = 0;
    private java.lang.Object source_;

    public SourceCase getSourceCase() {
      return SourceCase.forNumber(sourceCase_);
    }

    public Builder clearSource() {
      sourceCase_ = 0;
      source_ = null;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.TextMetadata,
            com.google.cloud.datalabeling.v1beta1.TextMetadata.Builder,
            com.google.cloud.datalabeling.v1beta1.TextMetadataOrBuilder>
        textMetadataBuilder_;
    /**
     *
     *
     * <pre>
     * Required for text import, as language code must be specified.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.TextMetadata text_metadata = 6;</code>
     *
     * @return Whether the textMetadata field is set.
     */
    @java.lang.Override
    public boolean hasTextMetadata() {
      return dataTypeMetadataCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * Required for text import, as language code must be specified.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.TextMetadata text_metadata = 6;</code>
     *
     * @return The textMetadata.
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.TextMetadata getTextMetadata() {
      if (textMetadataBuilder_ == null) {
        if (dataTypeMetadataCase_ == 6) {
          return (com.google.cloud.datalabeling.v1beta1.TextMetadata) dataTypeMetadata_;
        }
        return com.google.cloud.datalabeling.v1beta1.TextMetadata.getDefaultInstance();
      } else {
        if (dataTypeMetadataCase_ == 6) {
          return textMetadataBuilder_.getMessage();
        }
        return com.google.cloud.datalabeling.v1beta1.TextMetadata.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Required for text import, as language code must be specified.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.TextMetadata text_metadata = 6;</code>
     */
    public Builder setTextMetadata(com.google.cloud.datalabeling.v1beta1.TextMetadata value) {
      if (textMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dataTypeMetadata_ = value;
        onChanged();
      } else {
        textMetadataBuilder_.setMessage(value);
      }
      dataTypeMetadataCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required for text import, as language code must be specified.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.TextMetadata text_metadata = 6;</code>
     */
    public Builder setTextMetadata(
        com.google.cloud.datalabeling.v1beta1.TextMetadata.Builder builderForValue) {
      if (textMetadataBuilder_ == null) {
        dataTypeMetadata_ = builderForValue.build();
        onChanged();
      } else {
        textMetadataBuilder_.setMessage(builderForValue.build());
      }
      dataTypeMetadataCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required for text import, as language code must be specified.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.TextMetadata text_metadata = 6;</code>
     */
    public Builder mergeTextMetadata(com.google.cloud.datalabeling.v1beta1.TextMetadata value) {
      if (textMetadataBuilder_ == null) {
        if (dataTypeMetadataCase_ == 6
            && dataTypeMetadata_
                != com.google.cloud.datalabeling.v1beta1.TextMetadata.getDefaultInstance()) {
          dataTypeMetadata_ =
              com.google.cloud.datalabeling.v1beta1.TextMetadata.newBuilder(
                      (com.google.cloud.datalabeling.v1beta1.TextMetadata) dataTypeMetadata_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          dataTypeMetadata_ = value;
        }
        onChanged();
      } else {
        if (dataTypeMetadataCase_ == 6) {
          textMetadataBuilder_.mergeFrom(value);
        }
        textMetadataBuilder_.setMessage(value);
      }
      dataTypeMetadataCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required for text import, as language code must be specified.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.TextMetadata text_metadata = 6;</code>
     */
    public Builder clearTextMetadata() {
      if (textMetadataBuilder_ == null) {
        if (dataTypeMetadataCase_ == 6) {
          dataTypeMetadataCase_ = 0;
          dataTypeMetadata_ = null;
          onChanged();
        }
      } else {
        if (dataTypeMetadataCase_ == 6) {
          dataTypeMetadataCase_ = 0;
          dataTypeMetadata_ = null;
        }
        textMetadataBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required for text import, as language code must be specified.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.TextMetadata text_metadata = 6;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.TextMetadata.Builder getTextMetadataBuilder() {
      return getTextMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required for text import, as language code must be specified.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.TextMetadata text_metadata = 6;</code>
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.TextMetadataOrBuilder getTextMetadataOrBuilder() {
      if ((dataTypeMetadataCase_ == 6) && (textMetadataBuilder_ != null)) {
        return textMetadataBuilder_.getMessageOrBuilder();
      } else {
        if (dataTypeMetadataCase_ == 6) {
          return (com.google.cloud.datalabeling.v1beta1.TextMetadata) dataTypeMetadata_;
        }
        return com.google.cloud.datalabeling.v1beta1.TextMetadata.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Required for text import, as language code must be specified.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.TextMetadata text_metadata = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.TextMetadata,
            com.google.cloud.datalabeling.v1beta1.TextMetadata.Builder,
            com.google.cloud.datalabeling.v1beta1.TextMetadataOrBuilder>
        getTextMetadataFieldBuilder() {
      if (textMetadataBuilder_ == null) {
        if (!(dataTypeMetadataCase_ == 6)) {
          dataTypeMetadata_ =
              com.google.cloud.datalabeling.v1beta1.TextMetadata.getDefaultInstance();
        }
        textMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.TextMetadata,
                com.google.cloud.datalabeling.v1beta1.TextMetadata.Builder,
                com.google.cloud.datalabeling.v1beta1.TextMetadataOrBuilder>(
                (com.google.cloud.datalabeling.v1beta1.TextMetadata) dataTypeMetadata_,
                getParentForChildren(),
                isClean());
        dataTypeMetadata_ = null;
      }
      dataTypeMetadataCase_ = 6;
      onChanged();
      ;
      return textMetadataBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.GcsSource,
            com.google.cloud.datalabeling.v1beta1.GcsSource.Builder,
            com.google.cloud.datalabeling.v1beta1.GcsSourceOrBuilder>
        gcsSourceBuilder_;
    /**
     *
     *
     * <pre>
     * Source located in Cloud Storage.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.GcsSource gcs_source = 2;</code>
     *
     * @return Whether the gcsSource field is set.
     */
    @java.lang.Override
    public boolean hasGcsSource() {
      return sourceCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Source located in Cloud Storage.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.GcsSource gcs_source = 2;</code>
     *
     * @return The gcsSource.
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.GcsSource getGcsSource() {
      if (gcsSourceBuilder_ == null) {
        if (sourceCase_ == 2) {
          return (com.google.cloud.datalabeling.v1beta1.GcsSource) source_;
        }
        return com.google.cloud.datalabeling.v1beta1.GcsSource.getDefaultInstance();
      } else {
        if (sourceCase_ == 2) {
          return gcsSourceBuilder_.getMessage();
        }
        return com.google.cloud.datalabeling.v1beta1.GcsSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Source located in Cloud Storage.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.GcsSource gcs_source = 2;</code>
     */
    public Builder setGcsSource(com.google.cloud.datalabeling.v1beta1.GcsSource value) {
      if (gcsSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        gcsSourceBuilder_.setMessage(value);
      }
      sourceCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source located in Cloud Storage.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.GcsSource gcs_source = 2;</code>
     */
    public Builder setGcsSource(
        com.google.cloud.datalabeling.v1beta1.GcsSource.Builder builderForValue) {
      if (gcsSourceBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        gcsSourceBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source located in Cloud Storage.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.GcsSource gcs_source = 2;</code>
     */
    public Builder mergeGcsSource(com.google.cloud.datalabeling.v1beta1.GcsSource value) {
      if (gcsSourceBuilder_ == null) {
        if (sourceCase_ == 2
            && source_ != com.google.cloud.datalabeling.v1beta1.GcsSource.getDefaultInstance()) {
          source_ =
              com.google.cloud.datalabeling.v1beta1.GcsSource.newBuilder(
                      (com.google.cloud.datalabeling.v1beta1.GcsSource) source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 2) {
          gcsSourceBuilder_.mergeFrom(value);
        }
        gcsSourceBuilder_.setMessage(value);
      }
      sourceCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source located in Cloud Storage.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.GcsSource gcs_source = 2;</code>
     */
    public Builder clearGcsSource() {
      if (gcsSourceBuilder_ == null) {
        if (sourceCase_ == 2) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 2) {
          sourceCase_ = 0;
          source_ = null;
        }
        gcsSourceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source located in Cloud Storage.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.GcsSource gcs_source = 2;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.GcsSource.Builder getGcsSourceBuilder() {
      return getGcsSourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Source located in Cloud Storage.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.GcsSource gcs_source = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.GcsSourceOrBuilder getGcsSourceOrBuilder() {
      if ((sourceCase_ == 2) && (gcsSourceBuilder_ != null)) {
        return gcsSourceBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 2) {
          return (com.google.cloud.datalabeling.v1beta1.GcsSource) source_;
        }
        return com.google.cloud.datalabeling.v1beta1.GcsSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Source located in Cloud Storage.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.GcsSource gcs_source = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.GcsSource,
            com.google.cloud.datalabeling.v1beta1.GcsSource.Builder,
            com.google.cloud.datalabeling.v1beta1.GcsSourceOrBuilder>
        getGcsSourceFieldBuilder() {
      if (gcsSourceBuilder_ == null) {
        if (!(sourceCase_ == 2)) {
          source_ = com.google.cloud.datalabeling.v1beta1.GcsSource.getDefaultInstance();
        }
        gcsSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.GcsSource,
                com.google.cloud.datalabeling.v1beta1.GcsSource.Builder,
                com.google.cloud.datalabeling.v1beta1.GcsSourceOrBuilder>(
                (com.google.cloud.datalabeling.v1beta1.GcsSource) source_,
                getParentForChildren(),
                isClean());
        source_ = null;
      }
      sourceCase_ = 2;
      onChanged();
      ;
      return gcsSourceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.BigQuerySource,
            com.google.cloud.datalabeling.v1beta1.BigQuerySource.Builder,
            com.google.cloud.datalabeling.v1beta1.BigQuerySourceOrBuilder>
        bigquerySourceBuilder_;
    /**
     *
     *
     * <pre>
     * Source located in BigQuery. You must specify this field if you are using
     * this InputConfig in an [EvaluationJob][google.cloud.datalabeling.v1beta1.EvaluationJob].
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.BigQuerySource bigquery_source = 5;</code>
     *
     * @return Whether the bigquerySource field is set.
     */
    @java.lang.Override
    public boolean hasBigquerySource() {
      return sourceCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Source located in BigQuery. You must specify this field if you are using
     * this InputConfig in an [EvaluationJob][google.cloud.datalabeling.v1beta1.EvaluationJob].
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.BigQuerySource bigquery_source = 5;</code>
     *
     * @return The bigquerySource.
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.BigQuerySource getBigquerySource() {
      if (bigquerySourceBuilder_ == null) {
        if (sourceCase_ == 5) {
          return (com.google.cloud.datalabeling.v1beta1.BigQuerySource) source_;
        }
        return com.google.cloud.datalabeling.v1beta1.BigQuerySource.getDefaultInstance();
      } else {
        if (sourceCase_ == 5) {
          return bigquerySourceBuilder_.getMessage();
        }
        return com.google.cloud.datalabeling.v1beta1.BigQuerySource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Source located in BigQuery. You must specify this field if you are using
     * this InputConfig in an [EvaluationJob][google.cloud.datalabeling.v1beta1.EvaluationJob].
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.BigQuerySource bigquery_source = 5;</code>
     */
    public Builder setBigquerySource(com.google.cloud.datalabeling.v1beta1.BigQuerySource value) {
      if (bigquerySourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        bigquerySourceBuilder_.setMessage(value);
      }
      sourceCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source located in BigQuery. You must specify this field if you are using
     * this InputConfig in an [EvaluationJob][google.cloud.datalabeling.v1beta1.EvaluationJob].
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.BigQuerySource bigquery_source = 5;</code>
     */
    public Builder setBigquerySource(
        com.google.cloud.datalabeling.v1beta1.BigQuerySource.Builder builderForValue) {
      if (bigquerySourceBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        bigquerySourceBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source located in BigQuery. You must specify this field if you are using
     * this InputConfig in an [EvaluationJob][google.cloud.datalabeling.v1beta1.EvaluationJob].
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.BigQuerySource bigquery_source = 5;</code>
     */
    public Builder mergeBigquerySource(com.google.cloud.datalabeling.v1beta1.BigQuerySource value) {
      if (bigquerySourceBuilder_ == null) {
        if (sourceCase_ == 5
            && source_
                != com.google.cloud.datalabeling.v1beta1.BigQuerySource.getDefaultInstance()) {
          source_ =
              com.google.cloud.datalabeling.v1beta1.BigQuerySource.newBuilder(
                      (com.google.cloud.datalabeling.v1beta1.BigQuerySource) source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 5) {
          bigquerySourceBuilder_.mergeFrom(value);
        }
        bigquerySourceBuilder_.setMessage(value);
      }
      sourceCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source located in BigQuery. You must specify this field if you are using
     * this InputConfig in an [EvaluationJob][google.cloud.datalabeling.v1beta1.EvaluationJob].
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.BigQuerySource bigquery_source = 5;</code>
     */
    public Builder clearBigquerySource() {
      if (bigquerySourceBuilder_ == null) {
        if (sourceCase_ == 5) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 5) {
          sourceCase_ = 0;
          source_ = null;
        }
        bigquerySourceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Source located in BigQuery. You must specify this field if you are using
     * this InputConfig in an [EvaluationJob][google.cloud.datalabeling.v1beta1.EvaluationJob].
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.BigQuerySource bigquery_source = 5;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.BigQuerySource.Builder getBigquerySourceBuilder() {
      return getBigquerySourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Source located in BigQuery. You must specify this field if you are using
     * this InputConfig in an [EvaluationJob][google.cloud.datalabeling.v1beta1.EvaluationJob].
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.BigQuerySource bigquery_source = 5;</code>
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.BigQuerySourceOrBuilder
        getBigquerySourceOrBuilder() {
      if ((sourceCase_ == 5) && (bigquerySourceBuilder_ != null)) {
        return bigquerySourceBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 5) {
          return (com.google.cloud.datalabeling.v1beta1.BigQuerySource) source_;
        }
        return com.google.cloud.datalabeling.v1beta1.BigQuerySource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Source located in BigQuery. You must specify this field if you are using
     * this InputConfig in an [EvaluationJob][google.cloud.datalabeling.v1beta1.EvaluationJob].
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.BigQuerySource bigquery_source = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.BigQuerySource,
            com.google.cloud.datalabeling.v1beta1.BigQuerySource.Builder,
            com.google.cloud.datalabeling.v1beta1.BigQuerySourceOrBuilder>
        getBigquerySourceFieldBuilder() {
      if (bigquerySourceBuilder_ == null) {
        if (!(sourceCase_ == 5)) {
          source_ = com.google.cloud.datalabeling.v1beta1.BigQuerySource.getDefaultInstance();
        }
        bigquerySourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.BigQuerySource,
                com.google.cloud.datalabeling.v1beta1.BigQuerySource.Builder,
                com.google.cloud.datalabeling.v1beta1.BigQuerySourceOrBuilder>(
                (com.google.cloud.datalabeling.v1beta1.BigQuerySource) source_,
                getParentForChildren(),
                isClean());
        source_ = null;
      }
      sourceCase_ = 5;
      onChanged();
      ;
      return bigquerySourceBuilder_;
    }

    private int dataType_ = 0;
    /**
     *
     *
     * <pre>
     * Required. Data type must be specifed when user tries to import data.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.DataType data_type = 1;</code>
     *
     * @return The enum numeric value on the wire for dataType.
     */
    @java.lang.Override
    public int getDataTypeValue() {
      return dataType_;
    }
    /**
     *
     *
     * <pre>
     * Required. Data type must be specifed when user tries to import data.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.DataType data_type = 1;</code>
     *
     * @param value The enum numeric value on the wire for dataType to set.
     * @return This builder for chaining.
     */
    public Builder setDataTypeValue(int value) {

      dataType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Data type must be specifed when user tries to import data.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.DataType data_type = 1;</code>
     *
     * @return The dataType.
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.DataType getDataType() {
      @SuppressWarnings("deprecation")
      com.google.cloud.datalabeling.v1beta1.DataType result =
          com.google.cloud.datalabeling.v1beta1.DataType.valueOf(dataType_);
      return result == null ? com.google.cloud.datalabeling.v1beta1.DataType.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Required. Data type must be specifed when user tries to import data.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.DataType data_type = 1;</code>
     *
     * @param value The dataType to set.
     * @return This builder for chaining.
     */
    public Builder setDataType(com.google.cloud.datalabeling.v1beta1.DataType value) {
      if (value == null) {
        throw new NullPointerException();
      }

      dataType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Data type must be specifed when user tries to import data.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.DataType data_type = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDataType() {

      dataType_ = 0;
      onChanged();
      return this;
    }

    private int annotationType_ = 0;
    /**
     *
     *
     * <pre>
     * Optional. The type of annotation to be performed on this data. You must
     * specify this field if you are using this InputConfig in an
     * [EvaluationJob][google.cloud.datalabeling.v1beta1.EvaluationJob].
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationType annotation_type = 3;</code>
     *
     * @return The enum numeric value on the wire for annotationType.
     */
    @java.lang.Override
    public int getAnnotationTypeValue() {
      return annotationType_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The type of annotation to be performed on this data. You must
     * specify this field if you are using this InputConfig in an
     * [EvaluationJob][google.cloud.datalabeling.v1beta1.EvaluationJob].
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationType annotation_type = 3;</code>
     *
     * @param value The enum numeric value on the wire for annotationType to set.
     * @return This builder for chaining.
     */
    public Builder setAnnotationTypeValue(int value) {

      annotationType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The type of annotation to be performed on this data. You must
     * specify this field if you are using this InputConfig in an
     * [EvaluationJob][google.cloud.datalabeling.v1beta1.EvaluationJob].
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationType annotation_type = 3;</code>
     *
     * @return The annotationType.
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.AnnotationType getAnnotationType() {
      @SuppressWarnings("deprecation")
      com.google.cloud.datalabeling.v1beta1.AnnotationType result =
          com.google.cloud.datalabeling.v1beta1.AnnotationType.valueOf(annotationType_);
      return result == null
          ? com.google.cloud.datalabeling.v1beta1.AnnotationType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Optional. The type of annotation to be performed on this data. You must
     * specify this field if you are using this InputConfig in an
     * [EvaluationJob][google.cloud.datalabeling.v1beta1.EvaluationJob].
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationType annotation_type = 3;</code>
     *
     * @param value The annotationType to set.
     * @return This builder for chaining.
     */
    public Builder setAnnotationType(com.google.cloud.datalabeling.v1beta1.AnnotationType value) {
      if (value == null) {
        throw new NullPointerException();
      }

      annotationType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The type of annotation to be performed on this data. You must
     * specify this field if you are using this InputConfig in an
     * [EvaluationJob][google.cloud.datalabeling.v1beta1.EvaluationJob].
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.AnnotationType annotation_type = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAnnotationType() {

      annotationType_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.datalabeling.v1beta1.ClassificationMetadata classificationMetadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.ClassificationMetadata,
            com.google.cloud.datalabeling.v1beta1.ClassificationMetadata.Builder,
            com.google.cloud.datalabeling.v1beta1.ClassificationMetadataOrBuilder>
        classificationMetadataBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Metadata about annotations for the input. You must specify this
     * field if you are using this InputConfig in an [EvaluationJob][google.cloud.datalabeling.v1beta1.EvaluationJob] for a
     * model version that performs classification.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.ClassificationMetadata classification_metadata = 4;
     * </code>
     *
     * @return Whether the classificationMetadata field is set.
     */
    public boolean hasClassificationMetadata() {
      return classificationMetadataBuilder_ != null || classificationMetadata_ != null;
    }
    /**
     *
     *
     * <pre>
     * Optional. Metadata about annotations for the input. You must specify this
     * field if you are using this InputConfig in an [EvaluationJob][google.cloud.datalabeling.v1beta1.EvaluationJob] for a
     * model version that performs classification.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.ClassificationMetadata classification_metadata = 4;
     * </code>
     *
     * @return The classificationMetadata.
     */
    public com.google.cloud.datalabeling.v1beta1.ClassificationMetadata
        getClassificationMetadata() {
      if (classificationMetadataBuilder_ == null) {
        return classificationMetadata_ == null
            ? com.google.cloud.datalabeling.v1beta1.ClassificationMetadata.getDefaultInstance()
            : classificationMetadata_;
      } else {
        return classificationMetadataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Metadata about annotations for the input. You must specify this
     * field if you are using this InputConfig in an [EvaluationJob][google.cloud.datalabeling.v1beta1.EvaluationJob] for a
     * model version that performs classification.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.ClassificationMetadata classification_metadata = 4;
     * </code>
     */
    public Builder setClassificationMetadata(
        com.google.cloud.datalabeling.v1beta1.ClassificationMetadata value) {
      if (classificationMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        classificationMetadata_ = value;
        onChanged();
      } else {
        classificationMetadataBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Metadata about annotations for the input. You must specify this
     * field if you are using this InputConfig in an [EvaluationJob][google.cloud.datalabeling.v1beta1.EvaluationJob] for a
     * model version that performs classification.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.ClassificationMetadata classification_metadata = 4;
     * </code>
     */
    public Builder setClassificationMetadata(
        com.google.cloud.datalabeling.v1beta1.ClassificationMetadata.Builder builderForValue) {
      if (classificationMetadataBuilder_ == null) {
        classificationMetadata_ = builderForValue.build();
        onChanged();
      } else {
        classificationMetadataBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Metadata about annotations for the input. You must specify this
     * field if you are using this InputConfig in an [EvaluationJob][google.cloud.datalabeling.v1beta1.EvaluationJob] for a
     * model version that performs classification.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.ClassificationMetadata classification_metadata = 4;
     * </code>
     */
    public Builder mergeClassificationMetadata(
        com.google.cloud.datalabeling.v1beta1.ClassificationMetadata value) {
      if (classificationMetadataBuilder_ == null) {
        if (classificationMetadata_ != null) {
          classificationMetadata_ =
              com.google.cloud.datalabeling.v1beta1.ClassificationMetadata.newBuilder(
                      classificationMetadata_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          classificationMetadata_ = value;
        }
        onChanged();
      } else {
        classificationMetadataBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Metadata about annotations for the input. You must specify this
     * field if you are using this InputConfig in an [EvaluationJob][google.cloud.datalabeling.v1beta1.EvaluationJob] for a
     * model version that performs classification.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.ClassificationMetadata classification_metadata = 4;
     * </code>
     */
    public Builder clearClassificationMetadata() {
      if (classificationMetadataBuilder_ == null) {
        classificationMetadata_ = null;
        onChanged();
      } else {
        classificationMetadata_ = null;
        classificationMetadataBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Metadata about annotations for the input. You must specify this
     * field if you are using this InputConfig in an [EvaluationJob][google.cloud.datalabeling.v1beta1.EvaluationJob] for a
     * model version that performs classification.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.ClassificationMetadata classification_metadata = 4;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.ClassificationMetadata.Builder
        getClassificationMetadataBuilder() {

      onChanged();
      return getClassificationMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Metadata about annotations for the input. You must specify this
     * field if you are using this InputConfig in an [EvaluationJob][google.cloud.datalabeling.v1beta1.EvaluationJob] for a
     * model version that performs classification.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.ClassificationMetadata classification_metadata = 4;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.ClassificationMetadataOrBuilder
        getClassificationMetadataOrBuilder() {
      if (classificationMetadataBuilder_ != null) {
        return classificationMetadataBuilder_.getMessageOrBuilder();
      } else {
        return classificationMetadata_ == null
            ? com.google.cloud.datalabeling.v1beta1.ClassificationMetadata.getDefaultInstance()
            : classificationMetadata_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Metadata about annotations for the input. You must specify this
     * field if you are using this InputConfig in an [EvaluationJob][google.cloud.datalabeling.v1beta1.EvaluationJob] for a
     * model version that performs classification.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.ClassificationMetadata classification_metadata = 4;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.ClassificationMetadata,
            com.google.cloud.datalabeling.v1beta1.ClassificationMetadata.Builder,
            com.google.cloud.datalabeling.v1beta1.ClassificationMetadataOrBuilder>
        getClassificationMetadataFieldBuilder() {
      if (classificationMetadataBuilder_ == null) {
        classificationMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.ClassificationMetadata,
                com.google.cloud.datalabeling.v1beta1.ClassificationMetadata.Builder,
                com.google.cloud.datalabeling.v1beta1.ClassificationMetadataOrBuilder>(
                getClassificationMetadata(), getParentForChildren(), isClean());
        classificationMetadata_ = null;
      }
      return classificationMetadataBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datalabeling.v1beta1.InputConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datalabeling.v1beta1.InputConfig)
  private static final com.google.cloud.datalabeling.v1beta1.InputConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datalabeling.v1beta1.InputConfig();
  }

  public static com.google.cloud.datalabeling.v1beta1.InputConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<InputConfig> PARSER =
      new com.google.protobuf.AbstractParser<InputConfig>() {
        @java.lang.Override
        public InputConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new InputConfig(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<InputConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<InputConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.InputConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
