/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datalabeling/v1beta1/data_labeling_service.proto

package com.google.cloud.datalabeling.v1beta1;

/**
 *
 *
 * <pre>
 * Request message for starting an image labeling task.
 * </pre>
 *
 * Protobuf type {@code google.cloud.datalabeling.v1beta1.LabelImageRequest}
 */
public final class LabelImageRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datalabeling.v1beta1.LabelImageRequest)
    LabelImageRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use LabelImageRequest.newBuilder() to construct.
  private LabelImageRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private LabelImageRequest() {
    parent_ = "";
    feature_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new LabelImageRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private LabelImageRequest(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              parent_ = s;
              break;
            }
          case 18:
            {
              com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.Builder subBuilder = null;
              if (basicConfig_ != null) {
                subBuilder = basicConfig_.toBuilder();
              }
              basicConfig_ =
                  input.readMessage(
                      com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(basicConfig_);
                basicConfig_ = subBuilder.buildPartial();
              }

              break;
            }
          case 24:
            {
              int rawValue = input.readEnum();

              feature_ = rawValue;
              break;
            }
          case 34:
            {
              com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig.Builder subBuilder =
                  null;
              if (requestConfigCase_ == 4) {
                subBuilder =
                    ((com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig)
                            requestConfig_)
                        .toBuilder();
              }
              requestConfig_ =
                  input.readMessage(
                      com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig)
                        requestConfig_);
                requestConfig_ = subBuilder.buildPartial();
              }
              requestConfigCase_ = 4;
              break;
            }
          case 42:
            {
              com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig.Builder subBuilder = null;
              if (requestConfigCase_ == 5) {
                subBuilder =
                    ((com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig) requestConfig_)
                        .toBuilder();
              }
              requestConfig_ =
                  input.readMessage(
                      com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig) requestConfig_);
                requestConfig_ = subBuilder.buildPartial();
              }
              requestConfigCase_ = 5;
              break;
            }
          case 50:
            {
              com.google.cloud.datalabeling.v1beta1.PolylineConfig.Builder subBuilder = null;
              if (requestConfigCase_ == 6) {
                subBuilder =
                    ((com.google.cloud.datalabeling.v1beta1.PolylineConfig) requestConfig_)
                        .toBuilder();
              }
              requestConfig_ =
                  input.readMessage(
                      com.google.cloud.datalabeling.v1beta1.PolylineConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.datalabeling.v1beta1.PolylineConfig) requestConfig_);
                requestConfig_ = subBuilder.buildPartial();
              }
              requestConfigCase_ = 6;
              break;
            }
          case 58:
            {
              com.google.cloud.datalabeling.v1beta1.SegmentationConfig.Builder subBuilder = null;
              if (requestConfigCase_ == 7) {
                subBuilder =
                    ((com.google.cloud.datalabeling.v1beta1.SegmentationConfig) requestConfig_)
                        .toBuilder();
              }
              requestConfig_ =
                  input.readMessage(
                      com.google.cloud.datalabeling.v1beta1.SegmentationConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.datalabeling.v1beta1.SegmentationConfig) requestConfig_);
                requestConfig_ = subBuilder.buildPartial();
              }
              requestConfigCase_ = 7;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datalabeling.v1beta1.DataLabelingServiceOuterClass
        .internal_static_google_cloud_datalabeling_v1beta1_LabelImageRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datalabeling.v1beta1.DataLabelingServiceOuterClass
        .internal_static_google_cloud_datalabeling_v1beta1_LabelImageRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datalabeling.v1beta1.LabelImageRequest.class,
            com.google.cloud.datalabeling.v1beta1.LabelImageRequest.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Image labeling task feature.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.datalabeling.v1beta1.LabelImageRequest.Feature}
   */
  public enum Feature implements com.google.protobuf.ProtocolMessageEnum {
    /** <code>FEATURE_UNSPECIFIED = 0;</code> */
    FEATURE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Label whole image with one or more of labels.
     * </pre>
     *
     * <code>CLASSIFICATION = 1;</code>
     */
    CLASSIFICATION(1),
    /**
     *
     *
     * <pre>
     * Label image with bounding boxes for labels.
     * </pre>
     *
     * <code>BOUNDING_BOX = 2;</code>
     */
    BOUNDING_BOX(2),
    /**
     *
     *
     * <pre>
     * Label oriented bounding box. The box does not have to be parallel to
     * horizontal line.
     * </pre>
     *
     * <code>ORIENTED_BOUNDING_BOX = 6;</code>
     */
    ORIENTED_BOUNDING_BOX(6),
    /**
     *
     *
     * <pre>
     * Label images with bounding poly. A bounding poly is a plane figure that
     * is bounded by a finite chain of straight line segments closing in a loop.
     * </pre>
     *
     * <code>BOUNDING_POLY = 3;</code>
     */
    BOUNDING_POLY(3),
    /**
     *
     *
     * <pre>
     * Label images with polyline. Polyline is formed by connected line segments
     * which are not in closed form.
     * </pre>
     *
     * <code>POLYLINE = 4;</code>
     */
    POLYLINE(4),
    /**
     *
     *
     * <pre>
     * Label images with segmentation. Segmentation is different from bounding
     * poly since it is more fine-grained, pixel level annotation.
     * </pre>
     *
     * <code>SEGMENTATION = 5;</code>
     */
    SEGMENTATION(5),
    UNRECOGNIZED(-1),
    ;

    /** <code>FEATURE_UNSPECIFIED = 0;</code> */
    public static final int FEATURE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Label whole image with one or more of labels.
     * </pre>
     *
     * <code>CLASSIFICATION = 1;</code>
     */
    public static final int CLASSIFICATION_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Label image with bounding boxes for labels.
     * </pre>
     *
     * <code>BOUNDING_BOX = 2;</code>
     */
    public static final int BOUNDING_BOX_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Label oriented bounding box. The box does not have to be parallel to
     * horizontal line.
     * </pre>
     *
     * <code>ORIENTED_BOUNDING_BOX = 6;</code>
     */
    public static final int ORIENTED_BOUNDING_BOX_VALUE = 6;
    /**
     *
     *
     * <pre>
     * Label images with bounding poly. A bounding poly is a plane figure that
     * is bounded by a finite chain of straight line segments closing in a loop.
     * </pre>
     *
     * <code>BOUNDING_POLY = 3;</code>
     */
    public static final int BOUNDING_POLY_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Label images with polyline. Polyline is formed by connected line segments
     * which are not in closed form.
     * </pre>
     *
     * <code>POLYLINE = 4;</code>
     */
    public static final int POLYLINE_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Label images with segmentation. Segmentation is different from bounding
     * poly since it is more fine-grained, pixel level annotation.
     * </pre>
     *
     * <code>SEGMENTATION = 5;</code>
     */
    public static final int SEGMENTATION_VALUE = 5;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Feature valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Feature forNumber(int value) {
      switch (value) {
        case 0:
          return FEATURE_UNSPECIFIED;
        case 1:
          return CLASSIFICATION;
        case 2:
          return BOUNDING_BOX;
        case 6:
          return ORIENTED_BOUNDING_BOX;
        case 3:
          return BOUNDING_POLY;
        case 4:
          return POLYLINE;
        case 5:
          return SEGMENTATION;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Feature> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Feature> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Feature>() {
          public Feature findValueByNumber(int number) {
            return Feature.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.datalabeling.v1beta1.LabelImageRequest.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final Feature[] VALUES = values();

    public static Feature valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Feature(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.datalabeling.v1beta1.LabelImageRequest.Feature)
  }

  private int requestConfigCase_ = 0;
  private java.lang.Object requestConfig_;

  public enum RequestConfigCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    IMAGE_CLASSIFICATION_CONFIG(4),
    BOUNDING_POLY_CONFIG(5),
    POLYLINE_CONFIG(6),
    SEGMENTATION_CONFIG(7),
    REQUESTCONFIG_NOT_SET(0);
    private final int value;

    private RequestConfigCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RequestConfigCase valueOf(int value) {
      return forNumber(value);
    }

    public static RequestConfigCase forNumber(int value) {
      switch (value) {
        case 4:
          return IMAGE_CLASSIFICATION_CONFIG;
        case 5:
          return BOUNDING_POLY_CONFIG;
        case 6:
          return POLYLINE_CONFIG;
        case 7:
          return SEGMENTATION_CONFIG;
        case 0:
          return REQUESTCONFIG_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public RequestConfigCase getRequestConfigCase() {
    return RequestConfigCase.forNumber(requestConfigCase_);
  }

  public static final int IMAGE_CLASSIFICATION_CONFIG_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Configuration for image classification task.
   * One of image_classification_config, bounding_poly_config,
   * polyline_config and segmentation_config are required.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.ImageClassificationConfig image_classification_config = 4;
   * </code>
   *
   * @return Whether the imageClassificationConfig field is set.
   */
  @java.lang.Override
  public boolean hasImageClassificationConfig() {
    return requestConfigCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Configuration for image classification task.
   * One of image_classification_config, bounding_poly_config,
   * polyline_config and segmentation_config are required.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.ImageClassificationConfig image_classification_config = 4;
   * </code>
   *
   * @return The imageClassificationConfig.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig
      getImageClassificationConfig() {
    if (requestConfigCase_ == 4) {
      return (com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig) requestConfig_;
    }
    return com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Configuration for image classification task.
   * One of image_classification_config, bounding_poly_config,
   * polyline_config and segmentation_config are required.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.ImageClassificationConfig image_classification_config = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.ImageClassificationConfigOrBuilder
      getImageClassificationConfigOrBuilder() {
    if (requestConfigCase_ == 4) {
      return (com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig) requestConfig_;
    }
    return com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig.getDefaultInstance();
  }

  public static final int BOUNDING_POLY_CONFIG_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Configuration for bounding box and bounding poly task.
   * One of image_classification_config, bounding_poly_config,
   * polyline_config and segmentation_config are required.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.BoundingPolyConfig bounding_poly_config = 5;</code>
   *
   * @return Whether the boundingPolyConfig field is set.
   */
  @java.lang.Override
  public boolean hasBoundingPolyConfig() {
    return requestConfigCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Configuration for bounding box and bounding poly task.
   * One of image_classification_config, bounding_poly_config,
   * polyline_config and segmentation_config are required.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.BoundingPolyConfig bounding_poly_config = 5;</code>
   *
   * @return The boundingPolyConfig.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig getBoundingPolyConfig() {
    if (requestConfigCase_ == 5) {
      return (com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig) requestConfig_;
    }
    return com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Configuration for bounding box and bounding poly task.
   * One of image_classification_config, bounding_poly_config,
   * polyline_config and segmentation_config are required.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.BoundingPolyConfig bounding_poly_config = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.BoundingPolyConfigOrBuilder
      getBoundingPolyConfigOrBuilder() {
    if (requestConfigCase_ == 5) {
      return (com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig) requestConfig_;
    }
    return com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig.getDefaultInstance();
  }

  public static final int POLYLINE_CONFIG_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * Configuration for polyline task.
   * One of image_classification_config, bounding_poly_config,
   * polyline_config and segmentation_config are required.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.PolylineConfig polyline_config = 6;</code>
   *
   * @return Whether the polylineConfig field is set.
   */
  @java.lang.Override
  public boolean hasPolylineConfig() {
    return requestConfigCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * Configuration for polyline task.
   * One of image_classification_config, bounding_poly_config,
   * polyline_config and segmentation_config are required.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.PolylineConfig polyline_config = 6;</code>
   *
   * @return The polylineConfig.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.PolylineConfig getPolylineConfig() {
    if (requestConfigCase_ == 6) {
      return (com.google.cloud.datalabeling.v1beta1.PolylineConfig) requestConfig_;
    }
    return com.google.cloud.datalabeling.v1beta1.PolylineConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Configuration for polyline task.
   * One of image_classification_config, bounding_poly_config,
   * polyline_config and segmentation_config are required.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.PolylineConfig polyline_config = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.PolylineConfigOrBuilder
      getPolylineConfigOrBuilder() {
    if (requestConfigCase_ == 6) {
      return (com.google.cloud.datalabeling.v1beta1.PolylineConfig) requestConfig_;
    }
    return com.google.cloud.datalabeling.v1beta1.PolylineConfig.getDefaultInstance();
  }

  public static final int SEGMENTATION_CONFIG_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * Configuration for segmentation task.
   * One of image_classification_config, bounding_poly_config,
   * polyline_config and segmentation_config are required.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.SegmentationConfig segmentation_config = 7;</code>
   *
   * @return Whether the segmentationConfig field is set.
   */
  @java.lang.Override
  public boolean hasSegmentationConfig() {
    return requestConfigCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * Configuration for segmentation task.
   * One of image_classification_config, bounding_poly_config,
   * polyline_config and segmentation_config are required.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.SegmentationConfig segmentation_config = 7;</code>
   *
   * @return The segmentationConfig.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.SegmentationConfig getSegmentationConfig() {
    if (requestConfigCase_ == 7) {
      return (com.google.cloud.datalabeling.v1beta1.SegmentationConfig) requestConfig_;
    }
    return com.google.cloud.datalabeling.v1beta1.SegmentationConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Configuration for segmentation task.
   * One of image_classification_config, bounding_poly_config,
   * polyline_config and segmentation_config are required.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.SegmentationConfig segmentation_config = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.SegmentationConfigOrBuilder
      getSegmentationConfigOrBuilder() {
    if (requestConfigCase_ == 7) {
      return (com.google.cloud.datalabeling.v1beta1.SegmentationConfig) requestConfig_;
    }
    return com.google.cloud.datalabeling.v1beta1.SegmentationConfig.getDefaultInstance();
  }

  public static final int PARENT_FIELD_NUMBER = 1;
  private volatile java.lang.Object parent_;
  /**
   *
   *
   * <pre>
   * Required. Name of the dataset to request labeling task, format:
   * projects/{project_id}/datasets/{dataset_id}
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Name of the dataset to request labeling task, format:
   * projects/{project_id}/datasets/{dataset_id}
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BASIC_CONFIG_FIELD_NUMBER = 2;
  private com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig basicConfig_;
  /**
   *
   *
   * <pre>
   * Required. Basic human annotation config.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.HumanAnnotationConfig basic_config = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the basicConfig field is set.
   */
  @java.lang.Override
  public boolean hasBasicConfig() {
    return basicConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. Basic human annotation config.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.HumanAnnotationConfig basic_config = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The basicConfig.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig getBasicConfig() {
    return basicConfig_ == null
        ? com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.getDefaultInstance()
        : basicConfig_;
  }
  /**
   *
   *
   * <pre>
   * Required. Basic human annotation config.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.HumanAnnotationConfig basic_config = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfigOrBuilder
      getBasicConfigOrBuilder() {
    return getBasicConfig();
  }

  public static final int FEATURE_FIELD_NUMBER = 3;
  private int feature_;
  /**
   *
   *
   * <pre>
   * Required. The type of image labeling task.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.LabelImageRequest.Feature feature = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for feature.
   */
  @java.lang.Override
  public int getFeatureValue() {
    return feature_;
  }
  /**
   *
   *
   * <pre>
   * Required. The type of image labeling task.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.LabelImageRequest.Feature feature = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The feature.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.LabelImageRequest.Feature getFeature() {
    @SuppressWarnings("deprecation")
    com.google.cloud.datalabeling.v1beta1.LabelImageRequest.Feature result =
        com.google.cloud.datalabeling.v1beta1.LabelImageRequest.Feature.valueOf(feature_);
    return result == null
        ? com.google.cloud.datalabeling.v1beta1.LabelImageRequest.Feature.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (basicConfig_ != null) {
      output.writeMessage(2, getBasicConfig());
    }
    if (feature_
        != com.google.cloud.datalabeling.v1beta1.LabelImageRequest.Feature.FEATURE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, feature_);
    }
    if (requestConfigCase_ == 4) {
      output.writeMessage(
          4, (com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig) requestConfig_);
    }
    if (requestConfigCase_ == 5) {
      output.writeMessage(
          5, (com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig) requestConfig_);
    }
    if (requestConfigCase_ == 6) {
      output.writeMessage(6, (com.google.cloud.datalabeling.v1beta1.PolylineConfig) requestConfig_);
    }
    if (requestConfigCase_ == 7) {
      output.writeMessage(
          7, (com.google.cloud.datalabeling.v1beta1.SegmentationConfig) requestConfig_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (basicConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getBasicConfig());
    }
    if (feature_
        != com.google.cloud.datalabeling.v1beta1.LabelImageRequest.Feature.FEATURE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, feature_);
    }
    if (requestConfigCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig) requestConfig_);
    }
    if (requestConfigCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig) requestConfig_);
    }
    if (requestConfigCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloud.datalabeling.v1beta1.PolylineConfig) requestConfig_);
    }
    if (requestConfigCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.cloud.datalabeling.v1beta1.SegmentationConfig) requestConfig_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datalabeling.v1beta1.LabelImageRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.datalabeling.v1beta1.LabelImageRequest other =
        (com.google.cloud.datalabeling.v1beta1.LabelImageRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (hasBasicConfig() != other.hasBasicConfig()) return false;
    if (hasBasicConfig()) {
      if (!getBasicConfig().equals(other.getBasicConfig())) return false;
    }
    if (feature_ != other.feature_) return false;
    if (!getRequestConfigCase().equals(other.getRequestConfigCase())) return false;
    switch (requestConfigCase_) {
      case 4:
        if (!getImageClassificationConfig().equals(other.getImageClassificationConfig()))
          return false;
        break;
      case 5:
        if (!getBoundingPolyConfig().equals(other.getBoundingPolyConfig())) return false;
        break;
      case 6:
        if (!getPolylineConfig().equals(other.getPolylineConfig())) return false;
        break;
      case 7:
        if (!getSegmentationConfig().equals(other.getSegmentationConfig())) return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    if (hasBasicConfig()) {
      hash = (37 * hash) + BASIC_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getBasicConfig().hashCode();
    }
    hash = (37 * hash) + FEATURE_FIELD_NUMBER;
    hash = (53 * hash) + feature_;
    switch (requestConfigCase_) {
      case 4:
        hash = (37 * hash) + IMAGE_CLASSIFICATION_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getImageClassificationConfig().hashCode();
        break;
      case 5:
        hash = (37 * hash) + BOUNDING_POLY_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getBoundingPolyConfig().hashCode();
        break;
      case 6:
        hash = (37 * hash) + POLYLINE_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getPolylineConfig().hashCode();
        break;
      case 7:
        hash = (37 * hash) + SEGMENTATION_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getSegmentationConfig().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datalabeling.v1beta1.LabelImageRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.LabelImageRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.LabelImageRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.LabelImageRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.LabelImageRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.LabelImageRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.LabelImageRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.LabelImageRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.LabelImageRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.LabelImageRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.LabelImageRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.LabelImageRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.datalabeling.v1beta1.LabelImageRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for starting an image labeling task.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datalabeling.v1beta1.LabelImageRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datalabeling.v1beta1.LabelImageRequest)
      com.google.cloud.datalabeling.v1beta1.LabelImageRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datalabeling.v1beta1.DataLabelingServiceOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_LabelImageRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datalabeling.v1beta1.DataLabelingServiceOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_LabelImageRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datalabeling.v1beta1.LabelImageRequest.class,
              com.google.cloud.datalabeling.v1beta1.LabelImageRequest.Builder.class);
    }

    // Construct using com.google.cloud.datalabeling.v1beta1.LabelImageRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      parent_ = "";

      if (basicConfigBuilder_ == null) {
        basicConfig_ = null;
      } else {
        basicConfig_ = null;
        basicConfigBuilder_ = null;
      }
      feature_ = 0;

      requestConfigCase_ = 0;
      requestConfig_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datalabeling.v1beta1.DataLabelingServiceOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_LabelImageRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.LabelImageRequest getDefaultInstanceForType() {
      return com.google.cloud.datalabeling.v1beta1.LabelImageRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.LabelImageRequest build() {
      com.google.cloud.datalabeling.v1beta1.LabelImageRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.LabelImageRequest buildPartial() {
      com.google.cloud.datalabeling.v1beta1.LabelImageRequest result =
          new com.google.cloud.datalabeling.v1beta1.LabelImageRequest(this);
      if (requestConfigCase_ == 4) {
        if (imageClassificationConfigBuilder_ == null) {
          result.requestConfig_ = requestConfig_;
        } else {
          result.requestConfig_ = imageClassificationConfigBuilder_.build();
        }
      }
      if (requestConfigCase_ == 5) {
        if (boundingPolyConfigBuilder_ == null) {
          result.requestConfig_ = requestConfig_;
        } else {
          result.requestConfig_ = boundingPolyConfigBuilder_.build();
        }
      }
      if (requestConfigCase_ == 6) {
        if (polylineConfigBuilder_ == null) {
          result.requestConfig_ = requestConfig_;
        } else {
          result.requestConfig_ = polylineConfigBuilder_.build();
        }
      }
      if (requestConfigCase_ == 7) {
        if (segmentationConfigBuilder_ == null) {
          result.requestConfig_ = requestConfig_;
        } else {
          result.requestConfig_ = segmentationConfigBuilder_.build();
        }
      }
      result.parent_ = parent_;
      if (basicConfigBuilder_ == null) {
        result.basicConfig_ = basicConfig_;
      } else {
        result.basicConfig_ = basicConfigBuilder_.build();
      }
      result.feature_ = feature_;
      result.requestConfigCase_ = requestConfigCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datalabeling.v1beta1.LabelImageRequest) {
        return mergeFrom((com.google.cloud.datalabeling.v1beta1.LabelImageRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datalabeling.v1beta1.LabelImageRequest other) {
      if (other == com.google.cloud.datalabeling.v1beta1.LabelImageRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        onChanged();
      }
      if (other.hasBasicConfig()) {
        mergeBasicConfig(other.getBasicConfig());
      }
      if (other.feature_ != 0) {
        setFeatureValue(other.getFeatureValue());
      }
      switch (other.getRequestConfigCase()) {
        case IMAGE_CLASSIFICATION_CONFIG:
          {
            mergeImageClassificationConfig(other.getImageClassificationConfig());
            break;
          }
        case BOUNDING_POLY_CONFIG:
          {
            mergeBoundingPolyConfig(other.getBoundingPolyConfig());
            break;
          }
        case POLYLINE_CONFIG:
          {
            mergePolylineConfig(other.getPolylineConfig());
            break;
          }
        case SEGMENTATION_CONFIG:
          {
            mergeSegmentationConfig(other.getSegmentationConfig());
            break;
          }
        case REQUESTCONFIG_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.datalabeling.v1beta1.LabelImageRequest parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.datalabeling.v1beta1.LabelImageRequest) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int requestConfigCase_ = 0;
    private java.lang.Object requestConfig_;

    public RequestConfigCase getRequestConfigCase() {
      return RequestConfigCase.forNumber(requestConfigCase_);
    }

    public Builder clearRequestConfig() {
      requestConfigCase_ = 0;
      requestConfig_ = null;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig,
            com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.ImageClassificationConfigOrBuilder>
        imageClassificationConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for image classification task.
     * One of image_classification_config, bounding_poly_config,
     * polyline_config and segmentation_config are required.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageClassificationConfig image_classification_config = 4;
     * </code>
     *
     * @return Whether the imageClassificationConfig field is set.
     */
    @java.lang.Override
    public boolean hasImageClassificationConfig() {
      return requestConfigCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Configuration for image classification task.
     * One of image_classification_config, bounding_poly_config,
     * polyline_config and segmentation_config are required.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageClassificationConfig image_classification_config = 4;
     * </code>
     *
     * @return The imageClassificationConfig.
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig
        getImageClassificationConfig() {
      if (imageClassificationConfigBuilder_ == null) {
        if (requestConfigCase_ == 4) {
          return (com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig) requestConfig_;
        }
        return com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig.getDefaultInstance();
      } else {
        if (requestConfigCase_ == 4) {
          return imageClassificationConfigBuilder_.getMessage();
        }
        return com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for image classification task.
     * One of image_classification_config, bounding_poly_config,
     * polyline_config and segmentation_config are required.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageClassificationConfig image_classification_config = 4;
     * </code>
     */
    public Builder setImageClassificationConfig(
        com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig value) {
      if (imageClassificationConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        requestConfig_ = value;
        onChanged();
      } else {
        imageClassificationConfigBuilder_.setMessage(value);
      }
      requestConfigCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for image classification task.
     * One of image_classification_config, bounding_poly_config,
     * polyline_config and segmentation_config are required.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageClassificationConfig image_classification_config = 4;
     * </code>
     */
    public Builder setImageClassificationConfig(
        com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig.Builder builderForValue) {
      if (imageClassificationConfigBuilder_ == null) {
        requestConfig_ = builderForValue.build();
        onChanged();
      } else {
        imageClassificationConfigBuilder_.setMessage(builderForValue.build());
      }
      requestConfigCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for image classification task.
     * One of image_classification_config, bounding_poly_config,
     * polyline_config and segmentation_config are required.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageClassificationConfig image_classification_config = 4;
     * </code>
     */
    public Builder mergeImageClassificationConfig(
        com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig value) {
      if (imageClassificationConfigBuilder_ == null) {
        if (requestConfigCase_ == 4
            && requestConfig_
                != com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig
                    .getDefaultInstance()) {
          requestConfig_ =
              com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig.newBuilder(
                      (com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig)
                          requestConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          requestConfig_ = value;
        }
        onChanged();
      } else {
        if (requestConfigCase_ == 4) {
          imageClassificationConfigBuilder_.mergeFrom(value);
        }
        imageClassificationConfigBuilder_.setMessage(value);
      }
      requestConfigCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for image classification task.
     * One of image_classification_config, bounding_poly_config,
     * polyline_config and segmentation_config are required.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageClassificationConfig image_classification_config = 4;
     * </code>
     */
    public Builder clearImageClassificationConfig() {
      if (imageClassificationConfigBuilder_ == null) {
        if (requestConfigCase_ == 4) {
          requestConfigCase_ = 0;
          requestConfig_ = null;
          onChanged();
        }
      } else {
        if (requestConfigCase_ == 4) {
          requestConfigCase_ = 0;
          requestConfig_ = null;
        }
        imageClassificationConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for image classification task.
     * One of image_classification_config, bounding_poly_config,
     * polyline_config and segmentation_config are required.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageClassificationConfig image_classification_config = 4;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig.Builder
        getImageClassificationConfigBuilder() {
      return getImageClassificationConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for image classification task.
     * One of image_classification_config, bounding_poly_config,
     * polyline_config and segmentation_config are required.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageClassificationConfig image_classification_config = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.ImageClassificationConfigOrBuilder
        getImageClassificationConfigOrBuilder() {
      if ((requestConfigCase_ == 4) && (imageClassificationConfigBuilder_ != null)) {
        return imageClassificationConfigBuilder_.getMessageOrBuilder();
      } else {
        if (requestConfigCase_ == 4) {
          return (com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig) requestConfig_;
        }
        return com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for image classification task.
     * One of image_classification_config, bounding_poly_config,
     * polyline_config and segmentation_config are required.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.ImageClassificationConfig image_classification_config = 4;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig,
            com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.ImageClassificationConfigOrBuilder>
        getImageClassificationConfigFieldBuilder() {
      if (imageClassificationConfigBuilder_ == null) {
        if (!(requestConfigCase_ == 4)) {
          requestConfig_ =
              com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig.getDefaultInstance();
        }
        imageClassificationConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig,
                com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig.Builder,
                com.google.cloud.datalabeling.v1beta1.ImageClassificationConfigOrBuilder>(
                (com.google.cloud.datalabeling.v1beta1.ImageClassificationConfig) requestConfig_,
                getParentForChildren(),
                isClean());
        requestConfig_ = null;
      }
      requestConfigCase_ = 4;
      onChanged();
      ;
      return imageClassificationConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig,
            com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.BoundingPolyConfigOrBuilder>
        boundingPolyConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for bounding box and bounding poly task.
     * One of image_classification_config, bounding_poly_config,
     * polyline_config and segmentation_config are required.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.BoundingPolyConfig bounding_poly_config = 5;</code>
     *
     * @return Whether the boundingPolyConfig field is set.
     */
    @java.lang.Override
    public boolean hasBoundingPolyConfig() {
      return requestConfigCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Configuration for bounding box and bounding poly task.
     * One of image_classification_config, bounding_poly_config,
     * polyline_config and segmentation_config are required.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.BoundingPolyConfig bounding_poly_config = 5;</code>
     *
     * @return The boundingPolyConfig.
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig getBoundingPolyConfig() {
      if (boundingPolyConfigBuilder_ == null) {
        if (requestConfigCase_ == 5) {
          return (com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig) requestConfig_;
        }
        return com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig.getDefaultInstance();
      } else {
        if (requestConfigCase_ == 5) {
          return boundingPolyConfigBuilder_.getMessage();
        }
        return com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for bounding box and bounding poly task.
     * One of image_classification_config, bounding_poly_config,
     * polyline_config and segmentation_config are required.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.BoundingPolyConfig bounding_poly_config = 5;</code>
     */
    public Builder setBoundingPolyConfig(
        com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig value) {
      if (boundingPolyConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        requestConfig_ = value;
        onChanged();
      } else {
        boundingPolyConfigBuilder_.setMessage(value);
      }
      requestConfigCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for bounding box and bounding poly task.
     * One of image_classification_config, bounding_poly_config,
     * polyline_config and segmentation_config are required.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.BoundingPolyConfig bounding_poly_config = 5;</code>
     */
    public Builder setBoundingPolyConfig(
        com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig.Builder builderForValue) {
      if (boundingPolyConfigBuilder_ == null) {
        requestConfig_ = builderForValue.build();
        onChanged();
      } else {
        boundingPolyConfigBuilder_.setMessage(builderForValue.build());
      }
      requestConfigCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for bounding box and bounding poly task.
     * One of image_classification_config, bounding_poly_config,
     * polyline_config and segmentation_config are required.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.BoundingPolyConfig bounding_poly_config = 5;</code>
     */
    public Builder mergeBoundingPolyConfig(
        com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig value) {
      if (boundingPolyConfigBuilder_ == null) {
        if (requestConfigCase_ == 5
            && requestConfig_
                != com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig.getDefaultInstance()) {
          requestConfig_ =
              com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig.newBuilder(
                      (com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig) requestConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          requestConfig_ = value;
        }
        onChanged();
      } else {
        if (requestConfigCase_ == 5) {
          boundingPolyConfigBuilder_.mergeFrom(value);
        }
        boundingPolyConfigBuilder_.setMessage(value);
      }
      requestConfigCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for bounding box and bounding poly task.
     * One of image_classification_config, bounding_poly_config,
     * polyline_config and segmentation_config are required.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.BoundingPolyConfig bounding_poly_config = 5;</code>
     */
    public Builder clearBoundingPolyConfig() {
      if (boundingPolyConfigBuilder_ == null) {
        if (requestConfigCase_ == 5) {
          requestConfigCase_ = 0;
          requestConfig_ = null;
          onChanged();
        }
      } else {
        if (requestConfigCase_ == 5) {
          requestConfigCase_ = 0;
          requestConfig_ = null;
        }
        boundingPolyConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for bounding box and bounding poly task.
     * One of image_classification_config, bounding_poly_config,
     * polyline_config and segmentation_config are required.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.BoundingPolyConfig bounding_poly_config = 5;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig.Builder
        getBoundingPolyConfigBuilder() {
      return getBoundingPolyConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for bounding box and bounding poly task.
     * One of image_classification_config, bounding_poly_config,
     * polyline_config and segmentation_config are required.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.BoundingPolyConfig bounding_poly_config = 5;</code>
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.BoundingPolyConfigOrBuilder
        getBoundingPolyConfigOrBuilder() {
      if ((requestConfigCase_ == 5) && (boundingPolyConfigBuilder_ != null)) {
        return boundingPolyConfigBuilder_.getMessageOrBuilder();
      } else {
        if (requestConfigCase_ == 5) {
          return (com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig) requestConfig_;
        }
        return com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for bounding box and bounding poly task.
     * One of image_classification_config, bounding_poly_config,
     * polyline_config and segmentation_config are required.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.BoundingPolyConfig bounding_poly_config = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig,
            com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.BoundingPolyConfigOrBuilder>
        getBoundingPolyConfigFieldBuilder() {
      if (boundingPolyConfigBuilder_ == null) {
        if (!(requestConfigCase_ == 5)) {
          requestConfig_ =
              com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig.getDefaultInstance();
        }
        boundingPolyConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig,
                com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig.Builder,
                com.google.cloud.datalabeling.v1beta1.BoundingPolyConfigOrBuilder>(
                (com.google.cloud.datalabeling.v1beta1.BoundingPolyConfig) requestConfig_,
                getParentForChildren(),
                isClean());
        requestConfig_ = null;
      }
      requestConfigCase_ = 5;
      onChanged();
      ;
      return boundingPolyConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.PolylineConfig,
            com.google.cloud.datalabeling.v1beta1.PolylineConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.PolylineConfigOrBuilder>
        polylineConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for polyline task.
     * One of image_classification_config, bounding_poly_config,
     * polyline_config and segmentation_config are required.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.PolylineConfig polyline_config = 6;</code>
     *
     * @return Whether the polylineConfig field is set.
     */
    @java.lang.Override
    public boolean hasPolylineConfig() {
      return requestConfigCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * Configuration for polyline task.
     * One of image_classification_config, bounding_poly_config,
     * polyline_config and segmentation_config are required.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.PolylineConfig polyline_config = 6;</code>
     *
     * @return The polylineConfig.
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.PolylineConfig getPolylineConfig() {
      if (polylineConfigBuilder_ == null) {
        if (requestConfigCase_ == 6) {
          return (com.google.cloud.datalabeling.v1beta1.PolylineConfig) requestConfig_;
        }
        return com.google.cloud.datalabeling.v1beta1.PolylineConfig.getDefaultInstance();
      } else {
        if (requestConfigCase_ == 6) {
          return polylineConfigBuilder_.getMessage();
        }
        return com.google.cloud.datalabeling.v1beta1.PolylineConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for polyline task.
     * One of image_classification_config, bounding_poly_config,
     * polyline_config and segmentation_config are required.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.PolylineConfig polyline_config = 6;</code>
     */
    public Builder setPolylineConfig(com.google.cloud.datalabeling.v1beta1.PolylineConfig value) {
      if (polylineConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        requestConfig_ = value;
        onChanged();
      } else {
        polylineConfigBuilder_.setMessage(value);
      }
      requestConfigCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for polyline task.
     * One of image_classification_config, bounding_poly_config,
     * polyline_config and segmentation_config are required.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.PolylineConfig polyline_config = 6;</code>
     */
    public Builder setPolylineConfig(
        com.google.cloud.datalabeling.v1beta1.PolylineConfig.Builder builderForValue) {
      if (polylineConfigBuilder_ == null) {
        requestConfig_ = builderForValue.build();
        onChanged();
      } else {
        polylineConfigBuilder_.setMessage(builderForValue.build());
      }
      requestConfigCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for polyline task.
     * One of image_classification_config, bounding_poly_config,
     * polyline_config and segmentation_config are required.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.PolylineConfig polyline_config = 6;</code>
     */
    public Builder mergePolylineConfig(com.google.cloud.datalabeling.v1beta1.PolylineConfig value) {
      if (polylineConfigBuilder_ == null) {
        if (requestConfigCase_ == 6
            && requestConfig_
                != com.google.cloud.datalabeling.v1beta1.PolylineConfig.getDefaultInstance()) {
          requestConfig_ =
              com.google.cloud.datalabeling.v1beta1.PolylineConfig.newBuilder(
                      (com.google.cloud.datalabeling.v1beta1.PolylineConfig) requestConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          requestConfig_ = value;
        }
        onChanged();
      } else {
        if (requestConfigCase_ == 6) {
          polylineConfigBuilder_.mergeFrom(value);
        }
        polylineConfigBuilder_.setMessage(value);
      }
      requestConfigCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for polyline task.
     * One of image_classification_config, bounding_poly_config,
     * polyline_config and segmentation_config are required.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.PolylineConfig polyline_config = 6;</code>
     */
    public Builder clearPolylineConfig() {
      if (polylineConfigBuilder_ == null) {
        if (requestConfigCase_ == 6) {
          requestConfigCase_ = 0;
          requestConfig_ = null;
          onChanged();
        }
      } else {
        if (requestConfigCase_ == 6) {
          requestConfigCase_ = 0;
          requestConfig_ = null;
        }
        polylineConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for polyline task.
     * One of image_classification_config, bounding_poly_config,
     * polyline_config and segmentation_config are required.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.PolylineConfig polyline_config = 6;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.PolylineConfig.Builder getPolylineConfigBuilder() {
      return getPolylineConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for polyline task.
     * One of image_classification_config, bounding_poly_config,
     * polyline_config and segmentation_config are required.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.PolylineConfig polyline_config = 6;</code>
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.PolylineConfigOrBuilder
        getPolylineConfigOrBuilder() {
      if ((requestConfigCase_ == 6) && (polylineConfigBuilder_ != null)) {
        return polylineConfigBuilder_.getMessageOrBuilder();
      } else {
        if (requestConfigCase_ == 6) {
          return (com.google.cloud.datalabeling.v1beta1.PolylineConfig) requestConfig_;
        }
        return com.google.cloud.datalabeling.v1beta1.PolylineConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for polyline task.
     * One of image_classification_config, bounding_poly_config,
     * polyline_config and segmentation_config are required.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.PolylineConfig polyline_config = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.PolylineConfig,
            com.google.cloud.datalabeling.v1beta1.PolylineConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.PolylineConfigOrBuilder>
        getPolylineConfigFieldBuilder() {
      if (polylineConfigBuilder_ == null) {
        if (!(requestConfigCase_ == 6)) {
          requestConfig_ =
              com.google.cloud.datalabeling.v1beta1.PolylineConfig.getDefaultInstance();
        }
        polylineConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.PolylineConfig,
                com.google.cloud.datalabeling.v1beta1.PolylineConfig.Builder,
                com.google.cloud.datalabeling.v1beta1.PolylineConfigOrBuilder>(
                (com.google.cloud.datalabeling.v1beta1.PolylineConfig) requestConfig_,
                getParentForChildren(),
                isClean());
        requestConfig_ = null;
      }
      requestConfigCase_ = 6;
      onChanged();
      ;
      return polylineConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.SegmentationConfig,
            com.google.cloud.datalabeling.v1beta1.SegmentationConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.SegmentationConfigOrBuilder>
        segmentationConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration for segmentation task.
     * One of image_classification_config, bounding_poly_config,
     * polyline_config and segmentation_config are required.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.SegmentationConfig segmentation_config = 7;</code>
     *
     * @return Whether the segmentationConfig field is set.
     */
    @java.lang.Override
    public boolean hasSegmentationConfig() {
      return requestConfigCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * Configuration for segmentation task.
     * One of image_classification_config, bounding_poly_config,
     * polyline_config and segmentation_config are required.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.SegmentationConfig segmentation_config = 7;</code>
     *
     * @return The segmentationConfig.
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.SegmentationConfig getSegmentationConfig() {
      if (segmentationConfigBuilder_ == null) {
        if (requestConfigCase_ == 7) {
          return (com.google.cloud.datalabeling.v1beta1.SegmentationConfig) requestConfig_;
        }
        return com.google.cloud.datalabeling.v1beta1.SegmentationConfig.getDefaultInstance();
      } else {
        if (requestConfigCase_ == 7) {
          return segmentationConfigBuilder_.getMessage();
        }
        return com.google.cloud.datalabeling.v1beta1.SegmentationConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for segmentation task.
     * One of image_classification_config, bounding_poly_config,
     * polyline_config and segmentation_config are required.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.SegmentationConfig segmentation_config = 7;</code>
     */
    public Builder setSegmentationConfig(
        com.google.cloud.datalabeling.v1beta1.SegmentationConfig value) {
      if (segmentationConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        requestConfig_ = value;
        onChanged();
      } else {
        segmentationConfigBuilder_.setMessage(value);
      }
      requestConfigCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for segmentation task.
     * One of image_classification_config, bounding_poly_config,
     * polyline_config and segmentation_config are required.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.SegmentationConfig segmentation_config = 7;</code>
     */
    public Builder setSegmentationConfig(
        com.google.cloud.datalabeling.v1beta1.SegmentationConfig.Builder builderForValue) {
      if (segmentationConfigBuilder_ == null) {
        requestConfig_ = builderForValue.build();
        onChanged();
      } else {
        segmentationConfigBuilder_.setMessage(builderForValue.build());
      }
      requestConfigCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for segmentation task.
     * One of image_classification_config, bounding_poly_config,
     * polyline_config and segmentation_config are required.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.SegmentationConfig segmentation_config = 7;</code>
     */
    public Builder mergeSegmentationConfig(
        com.google.cloud.datalabeling.v1beta1.SegmentationConfig value) {
      if (segmentationConfigBuilder_ == null) {
        if (requestConfigCase_ == 7
            && requestConfig_
                != com.google.cloud.datalabeling.v1beta1.SegmentationConfig.getDefaultInstance()) {
          requestConfig_ =
              com.google.cloud.datalabeling.v1beta1.SegmentationConfig.newBuilder(
                      (com.google.cloud.datalabeling.v1beta1.SegmentationConfig) requestConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          requestConfig_ = value;
        }
        onChanged();
      } else {
        if (requestConfigCase_ == 7) {
          segmentationConfigBuilder_.mergeFrom(value);
        }
        segmentationConfigBuilder_.setMessage(value);
      }
      requestConfigCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for segmentation task.
     * One of image_classification_config, bounding_poly_config,
     * polyline_config and segmentation_config are required.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.SegmentationConfig segmentation_config = 7;</code>
     */
    public Builder clearSegmentationConfig() {
      if (segmentationConfigBuilder_ == null) {
        if (requestConfigCase_ == 7) {
          requestConfigCase_ = 0;
          requestConfig_ = null;
          onChanged();
        }
      } else {
        if (requestConfigCase_ == 7) {
          requestConfigCase_ = 0;
          requestConfig_ = null;
        }
        segmentationConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration for segmentation task.
     * One of image_classification_config, bounding_poly_config,
     * polyline_config and segmentation_config are required.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.SegmentationConfig segmentation_config = 7;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.SegmentationConfig.Builder
        getSegmentationConfigBuilder() {
      return getSegmentationConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration for segmentation task.
     * One of image_classification_config, bounding_poly_config,
     * polyline_config and segmentation_config are required.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.SegmentationConfig segmentation_config = 7;</code>
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.SegmentationConfigOrBuilder
        getSegmentationConfigOrBuilder() {
      if ((requestConfigCase_ == 7) && (segmentationConfigBuilder_ != null)) {
        return segmentationConfigBuilder_.getMessageOrBuilder();
      } else {
        if (requestConfigCase_ == 7) {
          return (com.google.cloud.datalabeling.v1beta1.SegmentationConfig) requestConfig_;
        }
        return com.google.cloud.datalabeling.v1beta1.SegmentationConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration for segmentation task.
     * One of image_classification_config, bounding_poly_config,
     * polyline_config and segmentation_config are required.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.SegmentationConfig segmentation_config = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.SegmentationConfig,
            com.google.cloud.datalabeling.v1beta1.SegmentationConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.SegmentationConfigOrBuilder>
        getSegmentationConfigFieldBuilder() {
      if (segmentationConfigBuilder_ == null) {
        if (!(requestConfigCase_ == 7)) {
          requestConfig_ =
              com.google.cloud.datalabeling.v1beta1.SegmentationConfig.getDefaultInstance();
        }
        segmentationConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.SegmentationConfig,
                com.google.cloud.datalabeling.v1beta1.SegmentationConfig.Builder,
                com.google.cloud.datalabeling.v1beta1.SegmentationConfigOrBuilder>(
                (com.google.cloud.datalabeling.v1beta1.SegmentationConfig) requestConfig_,
                getParentForChildren(),
                isClean());
        requestConfig_ = null;
      }
      requestConfigCase_ = 7;
      onChanged();
      ;
      return segmentationConfigBuilder_;
    }

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. Name of the dataset to request labeling task, format:
     * projects/{project_id}/datasets/{dataset_id}
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the dataset to request labeling task, format:
     * projects/{project_id}/datasets/{dataset_id}
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the dataset to request labeling task, format:
     * projects/{project_id}/datasets/{dataset_id}
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      parent_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the dataset to request labeling task, format:
     * projects/{project_id}/datasets/{dataset_id}
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {

      parent_ = getDefaultInstance().getParent();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Name of the dataset to request labeling task, format:
     * projects/{project_id}/datasets/{dataset_id}
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      parent_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig basicConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig,
            com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfigOrBuilder>
        basicConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Basic human annotation config.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.HumanAnnotationConfig basic_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the basicConfig field is set.
     */
    public boolean hasBasicConfig() {
      return basicConfigBuilder_ != null || basicConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. Basic human annotation config.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.HumanAnnotationConfig basic_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The basicConfig.
     */
    public com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig getBasicConfig() {
      if (basicConfigBuilder_ == null) {
        return basicConfig_ == null
            ? com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.getDefaultInstance()
            : basicConfig_;
      } else {
        return basicConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Basic human annotation config.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.HumanAnnotationConfig basic_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setBasicConfig(
        com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig value) {
      if (basicConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        basicConfig_ = value;
        onChanged();
      } else {
        basicConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Basic human annotation config.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.HumanAnnotationConfig basic_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setBasicConfig(
        com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.Builder builderForValue) {
      if (basicConfigBuilder_ == null) {
        basicConfig_ = builderForValue.build();
        onChanged();
      } else {
        basicConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Basic human annotation config.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.HumanAnnotationConfig basic_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeBasicConfig(
        com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig value) {
      if (basicConfigBuilder_ == null) {
        if (basicConfig_ != null) {
          basicConfig_ =
              com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.newBuilder(basicConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          basicConfig_ = value;
        }
        onChanged();
      } else {
        basicConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Basic human annotation config.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.HumanAnnotationConfig basic_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearBasicConfig() {
      if (basicConfigBuilder_ == null) {
        basicConfig_ = null;
        onChanged();
      } else {
        basicConfig_ = null;
        basicConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Basic human annotation config.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.HumanAnnotationConfig basic_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.Builder
        getBasicConfigBuilder() {

      onChanged();
      return getBasicConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Basic human annotation config.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.HumanAnnotationConfig basic_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfigOrBuilder
        getBasicConfigOrBuilder() {
      if (basicConfigBuilder_ != null) {
        return basicConfigBuilder_.getMessageOrBuilder();
      } else {
        return basicConfig_ == null
            ? com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.getDefaultInstance()
            : basicConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Basic human annotation config.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.HumanAnnotationConfig basic_config = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig,
            com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.Builder,
            com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfigOrBuilder>
        getBasicConfigFieldBuilder() {
      if (basicConfigBuilder_ == null) {
        basicConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig,
                com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfig.Builder,
                com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfigOrBuilder>(
                getBasicConfig(), getParentForChildren(), isClean());
        basicConfig_ = null;
      }
      return basicConfigBuilder_;
    }

    private int feature_ = 0;
    /**
     *
     *
     * <pre>
     * Required. The type of image labeling task.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelImageRequest.Feature feature = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for feature.
     */
    @java.lang.Override
    public int getFeatureValue() {
      return feature_;
    }
    /**
     *
     *
     * <pre>
     * Required. The type of image labeling task.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelImageRequest.Feature feature = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for feature to set.
     * @return This builder for chaining.
     */
    public Builder setFeatureValue(int value) {

      feature_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The type of image labeling task.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelImageRequest.Feature feature = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The feature.
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.LabelImageRequest.Feature getFeature() {
      @SuppressWarnings("deprecation")
      com.google.cloud.datalabeling.v1beta1.LabelImageRequest.Feature result =
          com.google.cloud.datalabeling.v1beta1.LabelImageRequest.Feature.valueOf(feature_);
      return result == null
          ? com.google.cloud.datalabeling.v1beta1.LabelImageRequest.Feature.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Required. The type of image labeling task.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelImageRequest.Feature feature = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The feature to set.
     * @return This builder for chaining.
     */
    public Builder setFeature(
        com.google.cloud.datalabeling.v1beta1.LabelImageRequest.Feature value) {
      if (value == null) {
        throw new NullPointerException();
      }

      feature_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The type of image labeling task.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelImageRequest.Feature feature = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFeature() {

      feature_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datalabeling.v1beta1.LabelImageRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datalabeling.v1beta1.LabelImageRequest)
  private static final com.google.cloud.datalabeling.v1beta1.LabelImageRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datalabeling.v1beta1.LabelImageRequest();
  }

  public static com.google.cloud.datalabeling.v1beta1.LabelImageRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<LabelImageRequest> PARSER =
      new com.google.protobuf.AbstractParser<LabelImageRequest>() {
        @java.lang.Override
        public LabelImageRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new LabelImageRequest(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<LabelImageRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<LabelImageRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.LabelImageRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
