/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datalabeling/v1beta1/dataset.proto

package com.google.cloud.datalabeling.v1beta1;

public interface DatasetOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.datalabeling.v1beta1.Dataset)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Output only. Dataset resource name, format is:
   * projects/{project_id}/datasets/{dataset_id}
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * Output only. Dataset resource name, format is:
   * projects/{project_id}/datasets/{dataset_id}
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Required. The display name of the dataset. Maximum of 64 characters.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The displayName.
   */
  java.lang.String getDisplayName();
  /**
   *
   *
   * <pre>
   * Required. The display name of the dataset. Maximum of 64 characters.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The bytes for displayName.
   */
  com.google.protobuf.ByteString getDisplayNameBytes();

  /**
   *
   *
   * <pre>
   * Optional. User-provided description of the annotation specification set.
   * The description can be up to 10000 characters long.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The description.
   */
  java.lang.String getDescription();
  /**
   *
   *
   * <pre>
   * Optional. User-provided description of the annotation specification set.
   * The description can be up to 10000 characters long.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The bytes for description.
   */
  com.google.protobuf.ByteString getDescriptionBytes();

  /**
   *
   *
   * <pre>
   * Output only. Time the dataset is created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4;</code>
   *
   * @return Whether the createTime field is set.
   */
  boolean hasCreateTime();
  /**
   *
   *
   * <pre>
   * Output only. Time the dataset is created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4;</code>
   *
   * @return The createTime.
   */
  com.google.protobuf.Timestamp getCreateTime();
  /**
   *
   *
   * <pre>
   * Output only. Time the dataset is created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4;</code>
   */
  com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. This is populated with the original input configs
   * where ImportData is called. It is available only after the clients
   * import data to this dataset.
   * </pre>
   *
   * <code>repeated .google.cloud.datalabeling.v1beta1.InputConfig input_configs = 5;</code>
   */
  java.util.List<com.google.cloud.datalabeling.v1beta1.InputConfig> getInputConfigsList();
  /**
   *
   *
   * <pre>
   * Output only. This is populated with the original input configs
   * where ImportData is called. It is available only after the clients
   * import data to this dataset.
   * </pre>
   *
   * <code>repeated .google.cloud.datalabeling.v1beta1.InputConfig input_configs = 5;</code>
   */
  com.google.cloud.datalabeling.v1beta1.InputConfig getInputConfigs(int index);
  /**
   *
   *
   * <pre>
   * Output only. This is populated with the original input configs
   * where ImportData is called. It is available only after the clients
   * import data to this dataset.
   * </pre>
   *
   * <code>repeated .google.cloud.datalabeling.v1beta1.InputConfig input_configs = 5;</code>
   */
  int getInputConfigsCount();
  /**
   *
   *
   * <pre>
   * Output only. This is populated with the original input configs
   * where ImportData is called. It is available only after the clients
   * import data to this dataset.
   * </pre>
   *
   * <code>repeated .google.cloud.datalabeling.v1beta1.InputConfig input_configs = 5;</code>
   */
  java.util.List<? extends com.google.cloud.datalabeling.v1beta1.InputConfigOrBuilder>
      getInputConfigsOrBuilderList();
  /**
   *
   *
   * <pre>
   * Output only. This is populated with the original input configs
   * where ImportData is called. It is available only after the clients
   * import data to this dataset.
   * </pre>
   *
   * <code>repeated .google.cloud.datalabeling.v1beta1.InputConfig input_configs = 5;</code>
   */
  com.google.cloud.datalabeling.v1beta1.InputConfigOrBuilder getInputConfigsOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Output only. The names of any related resources that are blocking changes
   * to the dataset.
   * </pre>
   *
   * <code>repeated string blocking_resources = 6;</code>
   *
   * @return A list containing the blockingResources.
   */
  java.util.List<java.lang.String> getBlockingResourcesList();
  /**
   *
   *
   * <pre>
   * Output only. The names of any related resources that are blocking changes
   * to the dataset.
   * </pre>
   *
   * <code>repeated string blocking_resources = 6;</code>
   *
   * @return The count of blockingResources.
   */
  int getBlockingResourcesCount();
  /**
   *
   *
   * <pre>
   * Output only. The names of any related resources that are blocking changes
   * to the dataset.
   * </pre>
   *
   * <code>repeated string blocking_resources = 6;</code>
   *
   * @param index The index of the element to return.
   * @return The blockingResources at the given index.
   */
  java.lang.String getBlockingResources(int index);
  /**
   *
   *
   * <pre>
   * Output only. The names of any related resources that are blocking changes
   * to the dataset.
   * </pre>
   *
   * <code>repeated string blocking_resources = 6;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the blockingResources at the given index.
   */
  com.google.protobuf.ByteString getBlockingResourcesBytes(int index);

  /**
   *
   *
   * <pre>
   * Output only. The number of data items in the dataset.
   * </pre>
   *
   * <code>int64 data_item_count = 7;</code>
   *
   * @return The dataItemCount.
   */
  long getDataItemCount();
}
