/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datalabeling/v1beta1/operations.proto

package com.google.cloud.datalabeling.v1beta1;

/**
 *
 *
 * <pre>
 * Metadata of a labeling operation, such as LabelImage or LabelVideo.
 * Next tag: 20
 * </pre>
 *
 * Protobuf type {@code google.cloud.datalabeling.v1beta1.LabelOperationMetadata}
 */
public final class LabelOperationMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datalabeling.v1beta1.LabelOperationMetadata)
    LabelOperationMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use LabelOperationMetadata.newBuilder() to construct.
  private LabelOperationMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private LabelOperationMetadata() {
    partialFailures_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new LabelOperationMetadata();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private LabelOperationMetadata(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 8:
            {
              progressPercent_ = input.readInt32();
              break;
            }
          case 18:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                partialFailures_ = new java.util.ArrayList<com.google.rpc.Status>();
                mutable_bitField0_ |= 0x00000001;
              }
              partialFailures_.add(
                  input.readMessage(com.google.rpc.Status.parser(), extensionRegistry));
              break;
            }
          case 26:
            {
              com.google.cloud.datalabeling.v1beta1.LabelImageClassificationOperationMetadata
                      .Builder
                  subBuilder = null;
              if (detailsCase_ == 3) {
                subBuilder =
                    ((com.google.cloud.datalabeling.v1beta1
                                .LabelImageClassificationOperationMetadata)
                            details_)
                        .toBuilder();
              }
              details_ =
                  input.readMessage(
                      com.google.cloud.datalabeling.v1beta1
                          .LabelImageClassificationOperationMetadata.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.datalabeling.v1beta1
                            .LabelImageClassificationOperationMetadata)
                        details_);
                details_ = subBuilder.buildPartial();
              }
              detailsCase_ = 3;
              break;
            }
          case 34:
            {
              com.google.cloud.datalabeling.v1beta1.LabelImageBoundingBoxOperationMetadata.Builder
                  subBuilder = null;
              if (detailsCase_ == 4) {
                subBuilder =
                    ((com.google.cloud.datalabeling.v1beta1.LabelImageBoundingBoxOperationMetadata)
                            details_)
                        .toBuilder();
              }
              details_ =
                  input.readMessage(
                      com.google.cloud.datalabeling.v1beta1.LabelImageBoundingBoxOperationMetadata
                          .parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.datalabeling.v1beta1.LabelImageBoundingBoxOperationMetadata)
                        details_);
                details_ = subBuilder.buildPartial();
              }
              detailsCase_ = 4;
              break;
            }
          case 42:
            {
              com.google.cloud.datalabeling.v1beta1.LabelVideoClassificationOperationMetadata
                      .Builder
                  subBuilder = null;
              if (detailsCase_ == 5) {
                subBuilder =
                    ((com.google.cloud.datalabeling.v1beta1
                                .LabelVideoClassificationOperationMetadata)
                            details_)
                        .toBuilder();
              }
              details_ =
                  input.readMessage(
                      com.google.cloud.datalabeling.v1beta1
                          .LabelVideoClassificationOperationMetadata.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.datalabeling.v1beta1
                            .LabelVideoClassificationOperationMetadata)
                        details_);
                details_ = subBuilder.buildPartial();
              }
              detailsCase_ = 5;
              break;
            }
          case 50:
            {
              com.google.cloud.datalabeling.v1beta1.LabelVideoObjectDetectionOperationMetadata
                      .Builder
                  subBuilder = null;
              if (detailsCase_ == 6) {
                subBuilder =
                    ((com.google.cloud.datalabeling.v1beta1
                                .LabelVideoObjectDetectionOperationMetadata)
                            details_)
                        .toBuilder();
              }
              details_ =
                  input.readMessage(
                      com.google.cloud.datalabeling.v1beta1
                          .LabelVideoObjectDetectionOperationMetadata.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.datalabeling.v1beta1
                            .LabelVideoObjectDetectionOperationMetadata)
                        details_);
                details_ = subBuilder.buildPartial();
              }
              detailsCase_ = 6;
              break;
            }
          case 58:
            {
              com.google.cloud.datalabeling.v1beta1.LabelVideoObjectTrackingOperationMetadata
                      .Builder
                  subBuilder = null;
              if (detailsCase_ == 7) {
                subBuilder =
                    ((com.google.cloud.datalabeling.v1beta1
                                .LabelVideoObjectTrackingOperationMetadata)
                            details_)
                        .toBuilder();
              }
              details_ =
                  input.readMessage(
                      com.google.cloud.datalabeling.v1beta1
                          .LabelVideoObjectTrackingOperationMetadata.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.datalabeling.v1beta1
                            .LabelVideoObjectTrackingOperationMetadata)
                        details_);
                details_ = subBuilder.buildPartial();
              }
              detailsCase_ = 7;
              break;
            }
          case 66:
            {
              com.google.cloud.datalabeling.v1beta1.LabelVideoEventOperationMetadata.Builder
                  subBuilder = null;
              if (detailsCase_ == 8) {
                subBuilder =
                    ((com.google.cloud.datalabeling.v1beta1.LabelVideoEventOperationMetadata)
                            details_)
                        .toBuilder();
              }
              details_ =
                  input.readMessage(
                      com.google.cloud.datalabeling.v1beta1.LabelVideoEventOperationMetadata
                          .parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.datalabeling.v1beta1.LabelVideoEventOperationMetadata)
                        details_);
                details_ = subBuilder.buildPartial();
              }
              detailsCase_ = 8;
              break;
            }
          case 74:
            {
              com.google.cloud.datalabeling.v1beta1.LabelTextClassificationOperationMetadata.Builder
                  subBuilder = null;
              if (detailsCase_ == 9) {
                subBuilder =
                    ((com.google.cloud.datalabeling.v1beta1
                                .LabelTextClassificationOperationMetadata)
                            details_)
                        .toBuilder();
              }
              details_ =
                  input.readMessage(
                      com.google.cloud.datalabeling.v1beta1.LabelTextClassificationOperationMetadata
                          .parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.datalabeling.v1beta1.LabelTextClassificationOperationMetadata)
                        details_);
                details_ = subBuilder.buildPartial();
              }
              detailsCase_ = 9;
              break;
            }
          case 90:
            {
              com.google.cloud.datalabeling.v1beta1.LabelImageBoundingPolyOperationMetadata.Builder
                  subBuilder = null;
              if (detailsCase_ == 11) {
                subBuilder =
                    ((com.google.cloud.datalabeling.v1beta1.LabelImageBoundingPolyOperationMetadata)
                            details_)
                        .toBuilder();
              }
              details_ =
                  input.readMessage(
                      com.google.cloud.datalabeling.v1beta1.LabelImageBoundingPolyOperationMetadata
                          .parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.datalabeling.v1beta1.LabelImageBoundingPolyOperationMetadata)
                        details_);
                details_ = subBuilder.buildPartial();
              }
              detailsCase_ = 11;
              break;
            }
          case 98:
            {
              com.google.cloud.datalabeling.v1beta1.LabelImagePolylineOperationMetadata.Builder
                  subBuilder = null;
              if (detailsCase_ == 12) {
                subBuilder =
                    ((com.google.cloud.datalabeling.v1beta1.LabelImagePolylineOperationMetadata)
                            details_)
                        .toBuilder();
              }
              details_ =
                  input.readMessage(
                      com.google.cloud.datalabeling.v1beta1.LabelImagePolylineOperationMetadata
                          .parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.datalabeling.v1beta1.LabelImagePolylineOperationMetadata)
                        details_);
                details_ = subBuilder.buildPartial();
              }
              detailsCase_ = 12;
              break;
            }
          case 106:
            {
              com.google.cloud.datalabeling.v1beta1.LabelTextEntityExtractionOperationMetadata
                      .Builder
                  subBuilder = null;
              if (detailsCase_ == 13) {
                subBuilder =
                    ((com.google.cloud.datalabeling.v1beta1
                                .LabelTextEntityExtractionOperationMetadata)
                            details_)
                        .toBuilder();
              }
              details_ =
                  input.readMessage(
                      com.google.cloud.datalabeling.v1beta1
                          .LabelTextEntityExtractionOperationMetadata.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.datalabeling.v1beta1
                            .LabelTextEntityExtractionOperationMetadata)
                        details_);
                details_ = subBuilder.buildPartial();
              }
              detailsCase_ = 13;
              break;
            }
          case 114:
            {
              com.google.cloud.datalabeling.v1beta1.LabelImageOrientedBoundingBoxOperationMetadata
                      .Builder
                  subBuilder = null;
              if (detailsCase_ == 14) {
                subBuilder =
                    ((com.google.cloud.datalabeling.v1beta1
                                .LabelImageOrientedBoundingBoxOperationMetadata)
                            details_)
                        .toBuilder();
              }
              details_ =
                  input.readMessage(
                      com.google.cloud.datalabeling.v1beta1
                          .LabelImageOrientedBoundingBoxOperationMetadata.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.datalabeling.v1beta1
                            .LabelImageOrientedBoundingBoxOperationMetadata)
                        details_);
                details_ = subBuilder.buildPartial();
              }
              detailsCase_ = 14;
              break;
            }
          case 122:
            {
              com.google.cloud.datalabeling.v1beta1.LabelImageSegmentationOperationMetadata.Builder
                  subBuilder = null;
              if (detailsCase_ == 15) {
                subBuilder =
                    ((com.google.cloud.datalabeling.v1beta1.LabelImageSegmentationOperationMetadata)
                            details_)
                        .toBuilder();
              }
              details_ =
                  input.readMessage(
                      com.google.cloud.datalabeling.v1beta1.LabelImageSegmentationOperationMetadata
                          .parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.datalabeling.v1beta1.LabelImageSegmentationOperationMetadata)
                        details_);
                details_ = subBuilder.buildPartial();
              }
              detailsCase_ = 15;
              break;
            }
          case 130:
            {
              com.google.protobuf.Timestamp.Builder subBuilder = null;
              if (createTime_ != null) {
                subBuilder = createTime_.toBuilder();
              }
              createTime_ =
                  input.readMessage(com.google.protobuf.Timestamp.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(createTime_);
                createTime_ = subBuilder.buildPartial();
              }

              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        partialFailures_ = java.util.Collections.unmodifiableList(partialFailures_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datalabeling.v1beta1.Operations
        .internal_static_google_cloud_datalabeling_v1beta1_LabelOperationMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datalabeling.v1beta1.Operations
        .internal_static_google_cloud_datalabeling_v1beta1_LabelOperationMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datalabeling.v1beta1.LabelOperationMetadata.class,
            com.google.cloud.datalabeling.v1beta1.LabelOperationMetadata.Builder.class);
  }

  private int detailsCase_ = 0;
  private java.lang.Object details_;

  public enum DetailsCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    IMAGE_CLASSIFICATION_DETAILS(3),
    IMAGE_BOUNDING_BOX_DETAILS(4),
    IMAGE_BOUNDING_POLY_DETAILS(11),
    IMAGE_ORIENTED_BOUNDING_BOX_DETAILS(14),
    IMAGE_POLYLINE_DETAILS(12),
    IMAGE_SEGMENTATION_DETAILS(15),
    VIDEO_CLASSIFICATION_DETAILS(5),
    VIDEO_OBJECT_DETECTION_DETAILS(6),
    VIDEO_OBJECT_TRACKING_DETAILS(7),
    VIDEO_EVENT_DETAILS(8),
    TEXT_CLASSIFICATION_DETAILS(9),
    TEXT_ENTITY_EXTRACTION_DETAILS(13),
    DETAILS_NOT_SET(0);
    private final int value;

    private DetailsCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DetailsCase valueOf(int value) {
      return forNumber(value);
    }

    public static DetailsCase forNumber(int value) {
      switch (value) {
        case 3:
          return IMAGE_CLASSIFICATION_DETAILS;
        case 4:
          return IMAGE_BOUNDING_BOX_DETAILS;
        case 11:
          return IMAGE_BOUNDING_POLY_DETAILS;
        case 14:
          return IMAGE_ORIENTED_BOUNDING_BOX_DETAILS;
        case 12:
          return IMAGE_POLYLINE_DETAILS;
        case 15:
          return IMAGE_SEGMENTATION_DETAILS;
        case 5:
          return VIDEO_CLASSIFICATION_DETAILS;
        case 6:
          return VIDEO_OBJECT_DETECTION_DETAILS;
        case 7:
          return VIDEO_OBJECT_TRACKING_DETAILS;
        case 8:
          return VIDEO_EVENT_DETAILS;
        case 9:
          return TEXT_CLASSIFICATION_DETAILS;
        case 13:
          return TEXT_ENTITY_EXTRACTION_DETAILS;
        case 0:
          return DETAILS_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DetailsCase getDetailsCase() {
    return DetailsCase.forNumber(detailsCase_);
  }

  public static final int IMAGE_CLASSIFICATION_DETAILS_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Details of label image classification operation.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.LabelImageClassificationOperationMetadata image_classification_details = 3;
   * </code>
   *
   * @return Whether the imageClassificationDetails field is set.
   */
  @java.lang.Override
  public boolean hasImageClassificationDetails() {
    return detailsCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Details of label image classification operation.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.LabelImageClassificationOperationMetadata image_classification_details = 3;
   * </code>
   *
   * @return The imageClassificationDetails.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.LabelImageClassificationOperationMetadata
      getImageClassificationDetails() {
    if (detailsCase_ == 3) {
      return (com.google.cloud.datalabeling.v1beta1.LabelImageClassificationOperationMetadata)
          details_;
    }
    return com.google.cloud.datalabeling.v1beta1.LabelImageClassificationOperationMetadata
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Details of label image classification operation.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.LabelImageClassificationOperationMetadata image_classification_details = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.LabelImageClassificationOperationMetadataOrBuilder
      getImageClassificationDetailsOrBuilder() {
    if (detailsCase_ == 3) {
      return (com.google.cloud.datalabeling.v1beta1.LabelImageClassificationOperationMetadata)
          details_;
    }
    return com.google.cloud.datalabeling.v1beta1.LabelImageClassificationOperationMetadata
        .getDefaultInstance();
  }

  public static final int IMAGE_BOUNDING_BOX_DETAILS_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Details of label image bounding box operation.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.LabelImageBoundingBoxOperationMetadata image_bounding_box_details = 4;
   * </code>
   *
   * @return Whether the imageBoundingBoxDetails field is set.
   */
  @java.lang.Override
  public boolean hasImageBoundingBoxDetails() {
    return detailsCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Details of label image bounding box operation.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.LabelImageBoundingBoxOperationMetadata image_bounding_box_details = 4;
   * </code>
   *
   * @return The imageBoundingBoxDetails.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.LabelImageBoundingBoxOperationMetadata
      getImageBoundingBoxDetails() {
    if (detailsCase_ == 4) {
      return (com.google.cloud.datalabeling.v1beta1.LabelImageBoundingBoxOperationMetadata)
          details_;
    }
    return com.google.cloud.datalabeling.v1beta1.LabelImageBoundingBoxOperationMetadata
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Details of label image bounding box operation.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.LabelImageBoundingBoxOperationMetadata image_bounding_box_details = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.LabelImageBoundingBoxOperationMetadataOrBuilder
      getImageBoundingBoxDetailsOrBuilder() {
    if (detailsCase_ == 4) {
      return (com.google.cloud.datalabeling.v1beta1.LabelImageBoundingBoxOperationMetadata)
          details_;
    }
    return com.google.cloud.datalabeling.v1beta1.LabelImageBoundingBoxOperationMetadata
        .getDefaultInstance();
  }

  public static final int IMAGE_BOUNDING_POLY_DETAILS_FIELD_NUMBER = 11;
  /**
   *
   *
   * <pre>
   * Details of label image bounding poly operation.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.LabelImageBoundingPolyOperationMetadata image_bounding_poly_details = 11;
   * </code>
   *
   * @return Whether the imageBoundingPolyDetails field is set.
   */
  @java.lang.Override
  public boolean hasImageBoundingPolyDetails() {
    return detailsCase_ == 11;
  }
  /**
   *
   *
   * <pre>
   * Details of label image bounding poly operation.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.LabelImageBoundingPolyOperationMetadata image_bounding_poly_details = 11;
   * </code>
   *
   * @return The imageBoundingPolyDetails.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.LabelImageBoundingPolyOperationMetadata
      getImageBoundingPolyDetails() {
    if (detailsCase_ == 11) {
      return (com.google.cloud.datalabeling.v1beta1.LabelImageBoundingPolyOperationMetadata)
          details_;
    }
    return com.google.cloud.datalabeling.v1beta1.LabelImageBoundingPolyOperationMetadata
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Details of label image bounding poly operation.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.LabelImageBoundingPolyOperationMetadata image_bounding_poly_details = 11;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.LabelImageBoundingPolyOperationMetadataOrBuilder
      getImageBoundingPolyDetailsOrBuilder() {
    if (detailsCase_ == 11) {
      return (com.google.cloud.datalabeling.v1beta1.LabelImageBoundingPolyOperationMetadata)
          details_;
    }
    return com.google.cloud.datalabeling.v1beta1.LabelImageBoundingPolyOperationMetadata
        .getDefaultInstance();
  }

  public static final int IMAGE_ORIENTED_BOUNDING_BOX_DETAILS_FIELD_NUMBER = 14;
  /**
   *
   *
   * <pre>
   * Details of label image oriented bounding box operation.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.LabelImageOrientedBoundingBoxOperationMetadata image_oriented_bounding_box_details = 14;
   * </code>
   *
   * @return Whether the imageOrientedBoundingBoxDetails field is set.
   */
  @java.lang.Override
  public boolean hasImageOrientedBoundingBoxDetails() {
    return detailsCase_ == 14;
  }
  /**
   *
   *
   * <pre>
   * Details of label image oriented bounding box operation.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.LabelImageOrientedBoundingBoxOperationMetadata image_oriented_bounding_box_details = 14;
   * </code>
   *
   * @return The imageOrientedBoundingBoxDetails.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.LabelImageOrientedBoundingBoxOperationMetadata
      getImageOrientedBoundingBoxDetails() {
    if (detailsCase_ == 14) {
      return (com.google.cloud.datalabeling.v1beta1.LabelImageOrientedBoundingBoxOperationMetadata)
          details_;
    }
    return com.google.cloud.datalabeling.v1beta1.LabelImageOrientedBoundingBoxOperationMetadata
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Details of label image oriented bounding box operation.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.LabelImageOrientedBoundingBoxOperationMetadata image_oriented_bounding_box_details = 14;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1
          .LabelImageOrientedBoundingBoxOperationMetadataOrBuilder
      getImageOrientedBoundingBoxDetailsOrBuilder() {
    if (detailsCase_ == 14) {
      return (com.google.cloud.datalabeling.v1beta1.LabelImageOrientedBoundingBoxOperationMetadata)
          details_;
    }
    return com.google.cloud.datalabeling.v1beta1.LabelImageOrientedBoundingBoxOperationMetadata
        .getDefaultInstance();
  }

  public static final int IMAGE_POLYLINE_DETAILS_FIELD_NUMBER = 12;
  /**
   *
   *
   * <pre>
   * Details of label image polyline operation.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.LabelImagePolylineOperationMetadata image_polyline_details = 12;
   * </code>
   *
   * @return Whether the imagePolylineDetails field is set.
   */
  @java.lang.Override
  public boolean hasImagePolylineDetails() {
    return detailsCase_ == 12;
  }
  /**
   *
   *
   * <pre>
   * Details of label image polyline operation.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.LabelImagePolylineOperationMetadata image_polyline_details = 12;
   * </code>
   *
   * @return The imagePolylineDetails.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.LabelImagePolylineOperationMetadata
      getImagePolylineDetails() {
    if (detailsCase_ == 12) {
      return (com.google.cloud.datalabeling.v1beta1.LabelImagePolylineOperationMetadata) details_;
    }
    return com.google.cloud.datalabeling.v1beta1.LabelImagePolylineOperationMetadata
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Details of label image polyline operation.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.LabelImagePolylineOperationMetadata image_polyline_details = 12;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.LabelImagePolylineOperationMetadataOrBuilder
      getImagePolylineDetailsOrBuilder() {
    if (detailsCase_ == 12) {
      return (com.google.cloud.datalabeling.v1beta1.LabelImagePolylineOperationMetadata) details_;
    }
    return com.google.cloud.datalabeling.v1beta1.LabelImagePolylineOperationMetadata
        .getDefaultInstance();
  }

  public static final int IMAGE_SEGMENTATION_DETAILS_FIELD_NUMBER = 15;
  /**
   *
   *
   * <pre>
   * Details of label image segmentation operation.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.LabelImageSegmentationOperationMetadata image_segmentation_details = 15;
   * </code>
   *
   * @return Whether the imageSegmentationDetails field is set.
   */
  @java.lang.Override
  public boolean hasImageSegmentationDetails() {
    return detailsCase_ == 15;
  }
  /**
   *
   *
   * <pre>
   * Details of label image segmentation operation.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.LabelImageSegmentationOperationMetadata image_segmentation_details = 15;
   * </code>
   *
   * @return The imageSegmentationDetails.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.LabelImageSegmentationOperationMetadata
      getImageSegmentationDetails() {
    if (detailsCase_ == 15) {
      return (com.google.cloud.datalabeling.v1beta1.LabelImageSegmentationOperationMetadata)
          details_;
    }
    return com.google.cloud.datalabeling.v1beta1.LabelImageSegmentationOperationMetadata
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Details of label image segmentation operation.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.LabelImageSegmentationOperationMetadata image_segmentation_details = 15;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.LabelImageSegmentationOperationMetadataOrBuilder
      getImageSegmentationDetailsOrBuilder() {
    if (detailsCase_ == 15) {
      return (com.google.cloud.datalabeling.v1beta1.LabelImageSegmentationOperationMetadata)
          details_;
    }
    return com.google.cloud.datalabeling.v1beta1.LabelImageSegmentationOperationMetadata
        .getDefaultInstance();
  }

  public static final int VIDEO_CLASSIFICATION_DETAILS_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Details of label video classification operation.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.LabelVideoClassificationOperationMetadata video_classification_details = 5;
   * </code>
   *
   * @return Whether the videoClassificationDetails field is set.
   */
  @java.lang.Override
  public boolean hasVideoClassificationDetails() {
    return detailsCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Details of label video classification operation.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.LabelVideoClassificationOperationMetadata video_classification_details = 5;
   * </code>
   *
   * @return The videoClassificationDetails.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.LabelVideoClassificationOperationMetadata
      getVideoClassificationDetails() {
    if (detailsCase_ == 5) {
      return (com.google.cloud.datalabeling.v1beta1.LabelVideoClassificationOperationMetadata)
          details_;
    }
    return com.google.cloud.datalabeling.v1beta1.LabelVideoClassificationOperationMetadata
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Details of label video classification operation.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.LabelVideoClassificationOperationMetadata video_classification_details = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.LabelVideoClassificationOperationMetadataOrBuilder
      getVideoClassificationDetailsOrBuilder() {
    if (detailsCase_ == 5) {
      return (com.google.cloud.datalabeling.v1beta1.LabelVideoClassificationOperationMetadata)
          details_;
    }
    return com.google.cloud.datalabeling.v1beta1.LabelVideoClassificationOperationMetadata
        .getDefaultInstance();
  }

  public static final int VIDEO_OBJECT_DETECTION_DETAILS_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * Details of label video object detection operation.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.LabelVideoObjectDetectionOperationMetadata video_object_detection_details = 6;
   * </code>
   *
   * @return Whether the videoObjectDetectionDetails field is set.
   */
  @java.lang.Override
  public boolean hasVideoObjectDetectionDetails() {
    return detailsCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * Details of label video object detection operation.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.LabelVideoObjectDetectionOperationMetadata video_object_detection_details = 6;
   * </code>
   *
   * @return The videoObjectDetectionDetails.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.LabelVideoObjectDetectionOperationMetadata
      getVideoObjectDetectionDetails() {
    if (detailsCase_ == 6) {
      return (com.google.cloud.datalabeling.v1beta1.LabelVideoObjectDetectionOperationMetadata)
          details_;
    }
    return com.google.cloud.datalabeling.v1beta1.LabelVideoObjectDetectionOperationMetadata
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Details of label video object detection operation.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.LabelVideoObjectDetectionOperationMetadata video_object_detection_details = 6;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.LabelVideoObjectDetectionOperationMetadataOrBuilder
      getVideoObjectDetectionDetailsOrBuilder() {
    if (detailsCase_ == 6) {
      return (com.google.cloud.datalabeling.v1beta1.LabelVideoObjectDetectionOperationMetadata)
          details_;
    }
    return com.google.cloud.datalabeling.v1beta1.LabelVideoObjectDetectionOperationMetadata
        .getDefaultInstance();
  }

  public static final int VIDEO_OBJECT_TRACKING_DETAILS_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * Details of label video object tracking operation.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.LabelVideoObjectTrackingOperationMetadata video_object_tracking_details = 7;
   * </code>
   *
   * @return Whether the videoObjectTrackingDetails field is set.
   */
  @java.lang.Override
  public boolean hasVideoObjectTrackingDetails() {
    return detailsCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * Details of label video object tracking operation.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.LabelVideoObjectTrackingOperationMetadata video_object_tracking_details = 7;
   * </code>
   *
   * @return The videoObjectTrackingDetails.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.LabelVideoObjectTrackingOperationMetadata
      getVideoObjectTrackingDetails() {
    if (detailsCase_ == 7) {
      return (com.google.cloud.datalabeling.v1beta1.LabelVideoObjectTrackingOperationMetadata)
          details_;
    }
    return com.google.cloud.datalabeling.v1beta1.LabelVideoObjectTrackingOperationMetadata
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Details of label video object tracking operation.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.LabelVideoObjectTrackingOperationMetadata video_object_tracking_details = 7;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.LabelVideoObjectTrackingOperationMetadataOrBuilder
      getVideoObjectTrackingDetailsOrBuilder() {
    if (detailsCase_ == 7) {
      return (com.google.cloud.datalabeling.v1beta1.LabelVideoObjectTrackingOperationMetadata)
          details_;
    }
    return com.google.cloud.datalabeling.v1beta1.LabelVideoObjectTrackingOperationMetadata
        .getDefaultInstance();
  }

  public static final int VIDEO_EVENT_DETAILS_FIELD_NUMBER = 8;
  /**
   *
   *
   * <pre>
   * Details of label video event operation.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.LabelVideoEventOperationMetadata video_event_details = 8;
   * </code>
   *
   * @return Whether the videoEventDetails field is set.
   */
  @java.lang.Override
  public boolean hasVideoEventDetails() {
    return detailsCase_ == 8;
  }
  /**
   *
   *
   * <pre>
   * Details of label video event operation.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.LabelVideoEventOperationMetadata video_event_details = 8;
   * </code>
   *
   * @return The videoEventDetails.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.LabelVideoEventOperationMetadata
      getVideoEventDetails() {
    if (detailsCase_ == 8) {
      return (com.google.cloud.datalabeling.v1beta1.LabelVideoEventOperationMetadata) details_;
    }
    return com.google.cloud.datalabeling.v1beta1.LabelVideoEventOperationMetadata
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Details of label video event operation.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.LabelVideoEventOperationMetadata video_event_details = 8;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.LabelVideoEventOperationMetadataOrBuilder
      getVideoEventDetailsOrBuilder() {
    if (detailsCase_ == 8) {
      return (com.google.cloud.datalabeling.v1beta1.LabelVideoEventOperationMetadata) details_;
    }
    return com.google.cloud.datalabeling.v1beta1.LabelVideoEventOperationMetadata
        .getDefaultInstance();
  }

  public static final int TEXT_CLASSIFICATION_DETAILS_FIELD_NUMBER = 9;
  /**
   *
   *
   * <pre>
   * Details of label text classification operation.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.LabelTextClassificationOperationMetadata text_classification_details = 9;
   * </code>
   *
   * @return Whether the textClassificationDetails field is set.
   */
  @java.lang.Override
  public boolean hasTextClassificationDetails() {
    return detailsCase_ == 9;
  }
  /**
   *
   *
   * <pre>
   * Details of label text classification operation.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.LabelTextClassificationOperationMetadata text_classification_details = 9;
   * </code>
   *
   * @return The textClassificationDetails.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.LabelTextClassificationOperationMetadata
      getTextClassificationDetails() {
    if (detailsCase_ == 9) {
      return (com.google.cloud.datalabeling.v1beta1.LabelTextClassificationOperationMetadata)
          details_;
    }
    return com.google.cloud.datalabeling.v1beta1.LabelTextClassificationOperationMetadata
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Details of label text classification operation.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.LabelTextClassificationOperationMetadata text_classification_details = 9;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.LabelTextClassificationOperationMetadataOrBuilder
      getTextClassificationDetailsOrBuilder() {
    if (detailsCase_ == 9) {
      return (com.google.cloud.datalabeling.v1beta1.LabelTextClassificationOperationMetadata)
          details_;
    }
    return com.google.cloud.datalabeling.v1beta1.LabelTextClassificationOperationMetadata
        .getDefaultInstance();
  }

  public static final int TEXT_ENTITY_EXTRACTION_DETAILS_FIELD_NUMBER = 13;
  /**
   *
   *
   * <pre>
   * Details of label text entity extraction operation.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.LabelTextEntityExtractionOperationMetadata text_entity_extraction_details = 13;
   * </code>
   *
   * @return Whether the textEntityExtractionDetails field is set.
   */
  @java.lang.Override
  public boolean hasTextEntityExtractionDetails() {
    return detailsCase_ == 13;
  }
  /**
   *
   *
   * <pre>
   * Details of label text entity extraction operation.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.LabelTextEntityExtractionOperationMetadata text_entity_extraction_details = 13;
   * </code>
   *
   * @return The textEntityExtractionDetails.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.LabelTextEntityExtractionOperationMetadata
      getTextEntityExtractionDetails() {
    if (detailsCase_ == 13) {
      return (com.google.cloud.datalabeling.v1beta1.LabelTextEntityExtractionOperationMetadata)
          details_;
    }
    return com.google.cloud.datalabeling.v1beta1.LabelTextEntityExtractionOperationMetadata
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Details of label text entity extraction operation.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.LabelTextEntityExtractionOperationMetadata text_entity_extraction_details = 13;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.LabelTextEntityExtractionOperationMetadataOrBuilder
      getTextEntityExtractionDetailsOrBuilder() {
    if (detailsCase_ == 13) {
      return (com.google.cloud.datalabeling.v1beta1.LabelTextEntityExtractionOperationMetadata)
          details_;
    }
    return com.google.cloud.datalabeling.v1beta1.LabelTextEntityExtractionOperationMetadata
        .getDefaultInstance();
  }

  public static final int PROGRESS_PERCENT_FIELD_NUMBER = 1;
  private int progressPercent_;
  /**
   *
   *
   * <pre>
   * Output only. Progress of label operation. Range: [0, 100].
   * </pre>
   *
   * <code>int32 progress_percent = 1;</code>
   *
   * @return The progressPercent.
   */
  @java.lang.Override
  public int getProgressPercent() {
    return progressPercent_;
  }

  public static final int PARTIAL_FAILURES_FIELD_NUMBER = 2;
  private java.util.List<com.google.rpc.Status> partialFailures_;
  /**
   *
   *
   * <pre>
   * Output only. Partial failures encountered.
   * E.g. single files that couldn't be read.
   * Status details field will contain standard GCP error details.
   * </pre>
   *
   * <code>repeated .google.rpc.Status partial_failures = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.rpc.Status> getPartialFailuresList() {
    return partialFailures_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Partial failures encountered.
   * E.g. single files that couldn't be read.
   * Status details field will contain standard GCP error details.
   * </pre>
   *
   * <code>repeated .google.rpc.Status partial_failures = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.rpc.StatusOrBuilder>
      getPartialFailuresOrBuilderList() {
    return partialFailures_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Partial failures encountered.
   * E.g. single files that couldn't be read.
   * Status details field will contain standard GCP error details.
   * </pre>
   *
   * <code>repeated .google.rpc.Status partial_failures = 2;</code>
   */
  @java.lang.Override
  public int getPartialFailuresCount() {
    return partialFailures_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. Partial failures encountered.
   * E.g. single files that couldn't be read.
   * Status details field will contain standard GCP error details.
   * </pre>
   *
   * <code>repeated .google.rpc.Status partial_failures = 2;</code>
   */
  @java.lang.Override
  public com.google.rpc.Status getPartialFailures(int index) {
    return partialFailures_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. Partial failures encountered.
   * E.g. single files that couldn't be read.
   * Status details field will contain standard GCP error details.
   * </pre>
   *
   * <code>repeated .google.rpc.Status partial_failures = 2;</code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getPartialFailuresOrBuilder(int index) {
    return partialFailures_.get(index);
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 16;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when labeling request was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 16;</code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when labeling request was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 16;</code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Timestamp when labeling request was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 16;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return getCreateTime();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (progressPercent_ != 0) {
      output.writeInt32(1, progressPercent_);
    }
    for (int i = 0; i < partialFailures_.size(); i++) {
      output.writeMessage(2, partialFailures_.get(i));
    }
    if (detailsCase_ == 3) {
      output.writeMessage(
          3,
          (com.google.cloud.datalabeling.v1beta1.LabelImageClassificationOperationMetadata)
              details_);
    }
    if (detailsCase_ == 4) {
      output.writeMessage(
          4,
          (com.google.cloud.datalabeling.v1beta1.LabelImageBoundingBoxOperationMetadata) details_);
    }
    if (detailsCase_ == 5) {
      output.writeMessage(
          5,
          (com.google.cloud.datalabeling.v1beta1.LabelVideoClassificationOperationMetadata)
              details_);
    }
    if (detailsCase_ == 6) {
      output.writeMessage(
          6,
          (com.google.cloud.datalabeling.v1beta1.LabelVideoObjectDetectionOperationMetadata)
              details_);
    }
    if (detailsCase_ == 7) {
      output.writeMessage(
          7,
          (com.google.cloud.datalabeling.v1beta1.LabelVideoObjectTrackingOperationMetadata)
              details_);
    }
    if (detailsCase_ == 8) {
      output.writeMessage(
          8, (com.google.cloud.datalabeling.v1beta1.LabelVideoEventOperationMetadata) details_);
    }
    if (detailsCase_ == 9) {
      output.writeMessage(
          9,
          (com.google.cloud.datalabeling.v1beta1.LabelTextClassificationOperationMetadata)
              details_);
    }
    if (detailsCase_ == 11) {
      output.writeMessage(
          11,
          (com.google.cloud.datalabeling.v1beta1.LabelImageBoundingPolyOperationMetadata) details_);
    }
    if (detailsCase_ == 12) {
      output.writeMessage(
          12, (com.google.cloud.datalabeling.v1beta1.LabelImagePolylineOperationMetadata) details_);
    }
    if (detailsCase_ == 13) {
      output.writeMessage(
          13,
          (com.google.cloud.datalabeling.v1beta1.LabelTextEntityExtractionOperationMetadata)
              details_);
    }
    if (detailsCase_ == 14) {
      output.writeMessage(
          14,
          (com.google.cloud.datalabeling.v1beta1.LabelImageOrientedBoundingBoxOperationMetadata)
              details_);
    }
    if (detailsCase_ == 15) {
      output.writeMessage(
          15,
          (com.google.cloud.datalabeling.v1beta1.LabelImageSegmentationOperationMetadata) details_);
    }
    if (createTime_ != null) {
      output.writeMessage(16, getCreateTime());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (progressPercent_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, progressPercent_);
    }
    for (int i = 0; i < partialFailures_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, partialFailures_.get(i));
    }
    if (detailsCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3,
              (com.google.cloud.datalabeling.v1beta1.LabelImageClassificationOperationMetadata)
                  details_);
    }
    if (detailsCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4,
              (com.google.cloud.datalabeling.v1beta1.LabelImageBoundingBoxOperationMetadata)
                  details_);
    }
    if (detailsCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5,
              (com.google.cloud.datalabeling.v1beta1.LabelVideoClassificationOperationMetadata)
                  details_);
    }
    if (detailsCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6,
              (com.google.cloud.datalabeling.v1beta1.LabelVideoObjectDetectionOperationMetadata)
                  details_);
    }
    if (detailsCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7,
              (com.google.cloud.datalabeling.v1beta1.LabelVideoObjectTrackingOperationMetadata)
                  details_);
    }
    if (detailsCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, (com.google.cloud.datalabeling.v1beta1.LabelVideoEventOperationMetadata) details_);
    }
    if (detailsCase_ == 9) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              9,
              (com.google.cloud.datalabeling.v1beta1.LabelTextClassificationOperationMetadata)
                  details_);
    }
    if (detailsCase_ == 11) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              11,
              (com.google.cloud.datalabeling.v1beta1.LabelImageBoundingPolyOperationMetadata)
                  details_);
    }
    if (detailsCase_ == 12) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              12,
              (com.google.cloud.datalabeling.v1beta1.LabelImagePolylineOperationMetadata) details_);
    }
    if (detailsCase_ == 13) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              13,
              (com.google.cloud.datalabeling.v1beta1.LabelTextEntityExtractionOperationMetadata)
                  details_);
    }
    if (detailsCase_ == 14) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              14,
              (com.google.cloud.datalabeling.v1beta1.LabelImageOrientedBoundingBoxOperationMetadata)
                  details_);
    }
    if (detailsCase_ == 15) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              15,
              (com.google.cloud.datalabeling.v1beta1.LabelImageSegmentationOperationMetadata)
                  details_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(16, getCreateTime());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datalabeling.v1beta1.LabelOperationMetadata)) {
      return super.equals(obj);
    }
    com.google.cloud.datalabeling.v1beta1.LabelOperationMetadata other =
        (com.google.cloud.datalabeling.v1beta1.LabelOperationMetadata) obj;

    if (getProgressPercent() != other.getProgressPercent()) return false;
    if (!getPartialFailuresList().equals(other.getPartialFailuresList())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (!getDetailsCase().equals(other.getDetailsCase())) return false;
    switch (detailsCase_) {
      case 3:
        if (!getImageClassificationDetails().equals(other.getImageClassificationDetails()))
          return false;
        break;
      case 4:
        if (!getImageBoundingBoxDetails().equals(other.getImageBoundingBoxDetails())) return false;
        break;
      case 11:
        if (!getImageBoundingPolyDetails().equals(other.getImageBoundingPolyDetails()))
          return false;
        break;
      case 14:
        if (!getImageOrientedBoundingBoxDetails()
            .equals(other.getImageOrientedBoundingBoxDetails())) return false;
        break;
      case 12:
        if (!getImagePolylineDetails().equals(other.getImagePolylineDetails())) return false;
        break;
      case 15:
        if (!getImageSegmentationDetails().equals(other.getImageSegmentationDetails()))
          return false;
        break;
      case 5:
        if (!getVideoClassificationDetails().equals(other.getVideoClassificationDetails()))
          return false;
        break;
      case 6:
        if (!getVideoObjectDetectionDetails().equals(other.getVideoObjectDetectionDetails()))
          return false;
        break;
      case 7:
        if (!getVideoObjectTrackingDetails().equals(other.getVideoObjectTrackingDetails()))
          return false;
        break;
      case 8:
        if (!getVideoEventDetails().equals(other.getVideoEventDetails())) return false;
        break;
      case 9:
        if (!getTextClassificationDetails().equals(other.getTextClassificationDetails()))
          return false;
        break;
      case 13:
        if (!getTextEntityExtractionDetails().equals(other.getTextEntityExtractionDetails()))
          return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PROGRESS_PERCENT_FIELD_NUMBER;
    hash = (53 * hash) + getProgressPercent();
    if (getPartialFailuresCount() > 0) {
      hash = (37 * hash) + PARTIAL_FAILURES_FIELD_NUMBER;
      hash = (53 * hash) + getPartialFailuresList().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    switch (detailsCase_) {
      case 3:
        hash = (37 * hash) + IMAGE_CLASSIFICATION_DETAILS_FIELD_NUMBER;
        hash = (53 * hash) + getImageClassificationDetails().hashCode();
        break;
      case 4:
        hash = (37 * hash) + IMAGE_BOUNDING_BOX_DETAILS_FIELD_NUMBER;
        hash = (53 * hash) + getImageBoundingBoxDetails().hashCode();
        break;
      case 11:
        hash = (37 * hash) + IMAGE_BOUNDING_POLY_DETAILS_FIELD_NUMBER;
        hash = (53 * hash) + getImageBoundingPolyDetails().hashCode();
        break;
      case 14:
        hash = (37 * hash) + IMAGE_ORIENTED_BOUNDING_BOX_DETAILS_FIELD_NUMBER;
        hash = (53 * hash) + getImageOrientedBoundingBoxDetails().hashCode();
        break;
      case 12:
        hash = (37 * hash) + IMAGE_POLYLINE_DETAILS_FIELD_NUMBER;
        hash = (53 * hash) + getImagePolylineDetails().hashCode();
        break;
      case 15:
        hash = (37 * hash) + IMAGE_SEGMENTATION_DETAILS_FIELD_NUMBER;
        hash = (53 * hash) + getImageSegmentationDetails().hashCode();
        break;
      case 5:
        hash = (37 * hash) + VIDEO_CLASSIFICATION_DETAILS_FIELD_NUMBER;
        hash = (53 * hash) + getVideoClassificationDetails().hashCode();
        break;
      case 6:
        hash = (37 * hash) + VIDEO_OBJECT_DETECTION_DETAILS_FIELD_NUMBER;
        hash = (53 * hash) + getVideoObjectDetectionDetails().hashCode();
        break;
      case 7:
        hash = (37 * hash) + VIDEO_OBJECT_TRACKING_DETAILS_FIELD_NUMBER;
        hash = (53 * hash) + getVideoObjectTrackingDetails().hashCode();
        break;
      case 8:
        hash = (37 * hash) + VIDEO_EVENT_DETAILS_FIELD_NUMBER;
        hash = (53 * hash) + getVideoEventDetails().hashCode();
        break;
      case 9:
        hash = (37 * hash) + TEXT_CLASSIFICATION_DETAILS_FIELD_NUMBER;
        hash = (53 * hash) + getTextClassificationDetails().hashCode();
        break;
      case 13:
        hash = (37 * hash) + TEXT_ENTITY_EXTRACTION_DETAILS_FIELD_NUMBER;
        hash = (53 * hash) + getTextEntityExtractionDetails().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datalabeling.v1beta1.LabelOperationMetadata parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.LabelOperationMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.LabelOperationMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.LabelOperationMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.LabelOperationMetadata parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.LabelOperationMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.LabelOperationMetadata parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.LabelOperationMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.LabelOperationMetadata parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.LabelOperationMetadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.LabelOperationMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.LabelOperationMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.datalabeling.v1beta1.LabelOperationMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Metadata of a labeling operation, such as LabelImage or LabelVideo.
   * Next tag: 20
   * </pre>
   *
   * Protobuf type {@code google.cloud.datalabeling.v1beta1.LabelOperationMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datalabeling.v1beta1.LabelOperationMetadata)
      com.google.cloud.datalabeling.v1beta1.LabelOperationMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datalabeling.v1beta1.Operations
          .internal_static_google_cloud_datalabeling_v1beta1_LabelOperationMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datalabeling.v1beta1.Operations
          .internal_static_google_cloud_datalabeling_v1beta1_LabelOperationMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datalabeling.v1beta1.LabelOperationMetadata.class,
              com.google.cloud.datalabeling.v1beta1.LabelOperationMetadata.Builder.class);
    }

    // Construct using com.google.cloud.datalabeling.v1beta1.LabelOperationMetadata.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getPartialFailuresFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      progressPercent_ = 0;

      if (partialFailuresBuilder_ == null) {
        partialFailures_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        partialFailuresBuilder_.clear();
      }
      if (createTimeBuilder_ == null) {
        createTime_ = null;
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }
      detailsCase_ = 0;
      details_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datalabeling.v1beta1.Operations
          .internal_static_google_cloud_datalabeling_v1beta1_LabelOperationMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.LabelOperationMetadata
        getDefaultInstanceForType() {
      return com.google.cloud.datalabeling.v1beta1.LabelOperationMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.LabelOperationMetadata build() {
      com.google.cloud.datalabeling.v1beta1.LabelOperationMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.LabelOperationMetadata buildPartial() {
      com.google.cloud.datalabeling.v1beta1.LabelOperationMetadata result =
          new com.google.cloud.datalabeling.v1beta1.LabelOperationMetadata(this);
      int from_bitField0_ = bitField0_;
      if (detailsCase_ == 3) {
        if (imageClassificationDetailsBuilder_ == null) {
          result.details_ = details_;
        } else {
          result.details_ = imageClassificationDetailsBuilder_.build();
        }
      }
      if (detailsCase_ == 4) {
        if (imageBoundingBoxDetailsBuilder_ == null) {
          result.details_ = details_;
        } else {
          result.details_ = imageBoundingBoxDetailsBuilder_.build();
        }
      }
      if (detailsCase_ == 11) {
        if (imageBoundingPolyDetailsBuilder_ == null) {
          result.details_ = details_;
        } else {
          result.details_ = imageBoundingPolyDetailsBuilder_.build();
        }
      }
      if (detailsCase_ == 14) {
        if (imageOrientedBoundingBoxDetailsBuilder_ == null) {
          result.details_ = details_;
        } else {
          result.details_ = imageOrientedBoundingBoxDetailsBuilder_.build();
        }
      }
      if (detailsCase_ == 12) {
        if (imagePolylineDetailsBuilder_ == null) {
          result.details_ = details_;
        } else {
          result.details_ = imagePolylineDetailsBuilder_.build();
        }
      }
      if (detailsCase_ == 15) {
        if (imageSegmentationDetailsBuilder_ == null) {
          result.details_ = details_;
        } else {
          result.details_ = imageSegmentationDetailsBuilder_.build();
        }
      }
      if (detailsCase_ == 5) {
        if (videoClassificationDetailsBuilder_ == null) {
          result.details_ = details_;
        } else {
          result.details_ = videoClassificationDetailsBuilder_.build();
        }
      }
      if (detailsCase_ == 6) {
        if (videoObjectDetectionDetailsBuilder_ == null) {
          result.details_ = details_;
        } else {
          result.details_ = videoObjectDetectionDetailsBuilder_.build();
        }
      }
      if (detailsCase_ == 7) {
        if (videoObjectTrackingDetailsBuilder_ == null) {
          result.details_ = details_;
        } else {
          result.details_ = videoObjectTrackingDetailsBuilder_.build();
        }
      }
      if (detailsCase_ == 8) {
        if (videoEventDetailsBuilder_ == null) {
          result.details_ = details_;
        } else {
          result.details_ = videoEventDetailsBuilder_.build();
        }
      }
      if (detailsCase_ == 9) {
        if (textClassificationDetailsBuilder_ == null) {
          result.details_ = details_;
        } else {
          result.details_ = textClassificationDetailsBuilder_.build();
        }
      }
      if (detailsCase_ == 13) {
        if (textEntityExtractionDetailsBuilder_ == null) {
          result.details_ = details_;
        } else {
          result.details_ = textEntityExtractionDetailsBuilder_.build();
        }
      }
      result.progressPercent_ = progressPercent_;
      if (partialFailuresBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          partialFailures_ = java.util.Collections.unmodifiableList(partialFailures_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.partialFailures_ = partialFailures_;
      } else {
        result.partialFailures_ = partialFailuresBuilder_.build();
      }
      if (createTimeBuilder_ == null) {
        result.createTime_ = createTime_;
      } else {
        result.createTime_ = createTimeBuilder_.build();
      }
      result.detailsCase_ = detailsCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datalabeling.v1beta1.LabelOperationMetadata) {
        return mergeFrom((com.google.cloud.datalabeling.v1beta1.LabelOperationMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datalabeling.v1beta1.LabelOperationMetadata other) {
      if (other
          == com.google.cloud.datalabeling.v1beta1.LabelOperationMetadata.getDefaultInstance())
        return this;
      if (other.getProgressPercent() != 0) {
        setProgressPercent(other.getProgressPercent());
      }
      if (partialFailuresBuilder_ == null) {
        if (!other.partialFailures_.isEmpty()) {
          if (partialFailures_.isEmpty()) {
            partialFailures_ = other.partialFailures_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensurePartialFailuresIsMutable();
            partialFailures_.addAll(other.partialFailures_);
          }
          onChanged();
        }
      } else {
        if (!other.partialFailures_.isEmpty()) {
          if (partialFailuresBuilder_.isEmpty()) {
            partialFailuresBuilder_.dispose();
            partialFailuresBuilder_ = null;
            partialFailures_ = other.partialFailures_;
            bitField0_ = (bitField0_ & ~0x00000001);
            partialFailuresBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPartialFailuresFieldBuilder()
                    : null;
          } else {
            partialFailuresBuilder_.addAllMessages(other.partialFailures_);
          }
        }
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      switch (other.getDetailsCase()) {
        case IMAGE_CLASSIFICATION_DETAILS:
          {
            mergeImageClassificationDetails(other.getImageClassificationDetails());
            break;
          }
        case IMAGE_BOUNDING_BOX_DETAILS:
          {
            mergeImageBoundingBoxDetails(other.getImageBoundingBoxDetails());
            break;
          }
        case IMAGE_BOUNDING_POLY_DETAILS:
          {
            mergeImageBoundingPolyDetails(other.getImageBoundingPolyDetails());
            break;
          }
        case IMAGE_ORIENTED_BOUNDING_BOX_DETAILS:
          {
            mergeImageOrientedBoundingBoxDetails(other.getImageOrientedBoundingBoxDetails());
            break;
          }
        case IMAGE_POLYLINE_DETAILS:
          {
            mergeImagePolylineDetails(other.getImagePolylineDetails());
            break;
          }
        case IMAGE_SEGMENTATION_DETAILS:
          {
            mergeImageSegmentationDetails(other.getImageSegmentationDetails());
            break;
          }
        case VIDEO_CLASSIFICATION_DETAILS:
          {
            mergeVideoClassificationDetails(other.getVideoClassificationDetails());
            break;
          }
        case VIDEO_OBJECT_DETECTION_DETAILS:
          {
            mergeVideoObjectDetectionDetails(other.getVideoObjectDetectionDetails());
            break;
          }
        case VIDEO_OBJECT_TRACKING_DETAILS:
          {
            mergeVideoObjectTrackingDetails(other.getVideoObjectTrackingDetails());
            break;
          }
        case VIDEO_EVENT_DETAILS:
          {
            mergeVideoEventDetails(other.getVideoEventDetails());
            break;
          }
        case TEXT_CLASSIFICATION_DETAILS:
          {
            mergeTextClassificationDetails(other.getTextClassificationDetails());
            break;
          }
        case TEXT_ENTITY_EXTRACTION_DETAILS:
          {
            mergeTextEntityExtractionDetails(other.getTextEntityExtractionDetails());
            break;
          }
        case DETAILS_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.datalabeling.v1beta1.LabelOperationMetadata parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.datalabeling.v1beta1.LabelOperationMetadata) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int detailsCase_ = 0;
    private java.lang.Object details_;

    public DetailsCase getDetailsCase() {
      return DetailsCase.forNumber(detailsCase_);
    }

    public Builder clearDetails() {
      detailsCase_ = 0;
      details_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.LabelImageClassificationOperationMetadata,
            com.google.cloud.datalabeling.v1beta1.LabelImageClassificationOperationMetadata.Builder,
            com.google.cloud.datalabeling.v1beta1
                .LabelImageClassificationOperationMetadataOrBuilder>
        imageClassificationDetailsBuilder_;
    /**
     *
     *
     * <pre>
     * Details of label image classification operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelImageClassificationOperationMetadata image_classification_details = 3;
     * </code>
     *
     * @return Whether the imageClassificationDetails field is set.
     */
    @java.lang.Override
    public boolean hasImageClassificationDetails() {
      return detailsCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Details of label image classification operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelImageClassificationOperationMetadata image_classification_details = 3;
     * </code>
     *
     * @return The imageClassificationDetails.
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.LabelImageClassificationOperationMetadata
        getImageClassificationDetails() {
      if (imageClassificationDetailsBuilder_ == null) {
        if (detailsCase_ == 3) {
          return (com.google.cloud.datalabeling.v1beta1.LabelImageClassificationOperationMetadata)
              details_;
        }
        return com.google.cloud.datalabeling.v1beta1.LabelImageClassificationOperationMetadata
            .getDefaultInstance();
      } else {
        if (detailsCase_ == 3) {
          return imageClassificationDetailsBuilder_.getMessage();
        }
        return com.google.cloud.datalabeling.v1beta1.LabelImageClassificationOperationMetadata
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Details of label image classification operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelImageClassificationOperationMetadata image_classification_details = 3;
     * </code>
     */
    public Builder setImageClassificationDetails(
        com.google.cloud.datalabeling.v1beta1.LabelImageClassificationOperationMetadata value) {
      if (imageClassificationDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        details_ = value;
        onChanged();
      } else {
        imageClassificationDetailsBuilder_.setMessage(value);
      }
      detailsCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of label image classification operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelImageClassificationOperationMetadata image_classification_details = 3;
     * </code>
     */
    public Builder setImageClassificationDetails(
        com.google.cloud.datalabeling.v1beta1.LabelImageClassificationOperationMetadata.Builder
            builderForValue) {
      if (imageClassificationDetailsBuilder_ == null) {
        details_ = builderForValue.build();
        onChanged();
      } else {
        imageClassificationDetailsBuilder_.setMessage(builderForValue.build());
      }
      detailsCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of label image classification operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelImageClassificationOperationMetadata image_classification_details = 3;
     * </code>
     */
    public Builder mergeImageClassificationDetails(
        com.google.cloud.datalabeling.v1beta1.LabelImageClassificationOperationMetadata value) {
      if (imageClassificationDetailsBuilder_ == null) {
        if (detailsCase_ == 3
            && details_
                != com.google.cloud.datalabeling.v1beta1.LabelImageClassificationOperationMetadata
                    .getDefaultInstance()) {
          details_ =
              com.google.cloud.datalabeling.v1beta1.LabelImageClassificationOperationMetadata
                  .newBuilder(
                      (com.google.cloud.datalabeling.v1beta1
                              .LabelImageClassificationOperationMetadata)
                          details_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          details_ = value;
        }
        onChanged();
      } else {
        if (detailsCase_ == 3) {
          imageClassificationDetailsBuilder_.mergeFrom(value);
        } else {
          imageClassificationDetailsBuilder_.setMessage(value);
        }
      }
      detailsCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of label image classification operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelImageClassificationOperationMetadata image_classification_details = 3;
     * </code>
     */
    public Builder clearImageClassificationDetails() {
      if (imageClassificationDetailsBuilder_ == null) {
        if (detailsCase_ == 3) {
          detailsCase_ = 0;
          details_ = null;
          onChanged();
        }
      } else {
        if (detailsCase_ == 3) {
          detailsCase_ = 0;
          details_ = null;
        }
        imageClassificationDetailsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of label image classification operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelImageClassificationOperationMetadata image_classification_details = 3;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.LabelImageClassificationOperationMetadata.Builder
        getImageClassificationDetailsBuilder() {
      return getImageClassificationDetailsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Details of label image classification operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelImageClassificationOperationMetadata image_classification_details = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.LabelImageClassificationOperationMetadataOrBuilder
        getImageClassificationDetailsOrBuilder() {
      if ((detailsCase_ == 3) && (imageClassificationDetailsBuilder_ != null)) {
        return imageClassificationDetailsBuilder_.getMessageOrBuilder();
      } else {
        if (detailsCase_ == 3) {
          return (com.google.cloud.datalabeling.v1beta1.LabelImageClassificationOperationMetadata)
              details_;
        }
        return com.google.cloud.datalabeling.v1beta1.LabelImageClassificationOperationMetadata
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Details of label image classification operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelImageClassificationOperationMetadata image_classification_details = 3;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.LabelImageClassificationOperationMetadata,
            com.google.cloud.datalabeling.v1beta1.LabelImageClassificationOperationMetadata.Builder,
            com.google.cloud.datalabeling.v1beta1
                .LabelImageClassificationOperationMetadataOrBuilder>
        getImageClassificationDetailsFieldBuilder() {
      if (imageClassificationDetailsBuilder_ == null) {
        if (!(detailsCase_ == 3)) {
          details_ =
              com.google.cloud.datalabeling.v1beta1.LabelImageClassificationOperationMetadata
                  .getDefaultInstance();
        }
        imageClassificationDetailsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.LabelImageClassificationOperationMetadata,
                com.google.cloud.datalabeling.v1beta1.LabelImageClassificationOperationMetadata
                    .Builder,
                com.google.cloud.datalabeling.v1beta1
                    .LabelImageClassificationOperationMetadataOrBuilder>(
                (com.google.cloud.datalabeling.v1beta1.LabelImageClassificationOperationMetadata)
                    details_,
                getParentForChildren(),
                isClean());
        details_ = null;
      }
      detailsCase_ = 3;
      onChanged();
      ;
      return imageClassificationDetailsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.LabelImageBoundingBoxOperationMetadata,
            com.google.cloud.datalabeling.v1beta1.LabelImageBoundingBoxOperationMetadata.Builder,
            com.google.cloud.datalabeling.v1beta1.LabelImageBoundingBoxOperationMetadataOrBuilder>
        imageBoundingBoxDetailsBuilder_;
    /**
     *
     *
     * <pre>
     * Details of label image bounding box operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelImageBoundingBoxOperationMetadata image_bounding_box_details = 4;
     * </code>
     *
     * @return Whether the imageBoundingBoxDetails field is set.
     */
    @java.lang.Override
    public boolean hasImageBoundingBoxDetails() {
      return detailsCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Details of label image bounding box operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelImageBoundingBoxOperationMetadata image_bounding_box_details = 4;
     * </code>
     *
     * @return The imageBoundingBoxDetails.
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.LabelImageBoundingBoxOperationMetadata
        getImageBoundingBoxDetails() {
      if (imageBoundingBoxDetailsBuilder_ == null) {
        if (detailsCase_ == 4) {
          return (com.google.cloud.datalabeling.v1beta1.LabelImageBoundingBoxOperationMetadata)
              details_;
        }
        return com.google.cloud.datalabeling.v1beta1.LabelImageBoundingBoxOperationMetadata
            .getDefaultInstance();
      } else {
        if (detailsCase_ == 4) {
          return imageBoundingBoxDetailsBuilder_.getMessage();
        }
        return com.google.cloud.datalabeling.v1beta1.LabelImageBoundingBoxOperationMetadata
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Details of label image bounding box operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelImageBoundingBoxOperationMetadata image_bounding_box_details = 4;
     * </code>
     */
    public Builder setImageBoundingBoxDetails(
        com.google.cloud.datalabeling.v1beta1.LabelImageBoundingBoxOperationMetadata value) {
      if (imageBoundingBoxDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        details_ = value;
        onChanged();
      } else {
        imageBoundingBoxDetailsBuilder_.setMessage(value);
      }
      detailsCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of label image bounding box operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelImageBoundingBoxOperationMetadata image_bounding_box_details = 4;
     * </code>
     */
    public Builder setImageBoundingBoxDetails(
        com.google.cloud.datalabeling.v1beta1.LabelImageBoundingBoxOperationMetadata.Builder
            builderForValue) {
      if (imageBoundingBoxDetailsBuilder_ == null) {
        details_ = builderForValue.build();
        onChanged();
      } else {
        imageBoundingBoxDetailsBuilder_.setMessage(builderForValue.build());
      }
      detailsCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of label image bounding box operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelImageBoundingBoxOperationMetadata image_bounding_box_details = 4;
     * </code>
     */
    public Builder mergeImageBoundingBoxDetails(
        com.google.cloud.datalabeling.v1beta1.LabelImageBoundingBoxOperationMetadata value) {
      if (imageBoundingBoxDetailsBuilder_ == null) {
        if (detailsCase_ == 4
            && details_
                != com.google.cloud.datalabeling.v1beta1.LabelImageBoundingBoxOperationMetadata
                    .getDefaultInstance()) {
          details_ =
              com.google.cloud.datalabeling.v1beta1.LabelImageBoundingBoxOperationMetadata
                  .newBuilder(
                      (com.google.cloud.datalabeling.v1beta1.LabelImageBoundingBoxOperationMetadata)
                          details_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          details_ = value;
        }
        onChanged();
      } else {
        if (detailsCase_ == 4) {
          imageBoundingBoxDetailsBuilder_.mergeFrom(value);
        } else {
          imageBoundingBoxDetailsBuilder_.setMessage(value);
        }
      }
      detailsCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of label image bounding box operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelImageBoundingBoxOperationMetadata image_bounding_box_details = 4;
     * </code>
     */
    public Builder clearImageBoundingBoxDetails() {
      if (imageBoundingBoxDetailsBuilder_ == null) {
        if (detailsCase_ == 4) {
          detailsCase_ = 0;
          details_ = null;
          onChanged();
        }
      } else {
        if (detailsCase_ == 4) {
          detailsCase_ = 0;
          details_ = null;
        }
        imageBoundingBoxDetailsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of label image bounding box operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelImageBoundingBoxOperationMetadata image_bounding_box_details = 4;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.LabelImageBoundingBoxOperationMetadata.Builder
        getImageBoundingBoxDetailsBuilder() {
      return getImageBoundingBoxDetailsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Details of label image bounding box operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelImageBoundingBoxOperationMetadata image_bounding_box_details = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.LabelImageBoundingBoxOperationMetadataOrBuilder
        getImageBoundingBoxDetailsOrBuilder() {
      if ((detailsCase_ == 4) && (imageBoundingBoxDetailsBuilder_ != null)) {
        return imageBoundingBoxDetailsBuilder_.getMessageOrBuilder();
      } else {
        if (detailsCase_ == 4) {
          return (com.google.cloud.datalabeling.v1beta1.LabelImageBoundingBoxOperationMetadata)
              details_;
        }
        return com.google.cloud.datalabeling.v1beta1.LabelImageBoundingBoxOperationMetadata
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Details of label image bounding box operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelImageBoundingBoxOperationMetadata image_bounding_box_details = 4;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.LabelImageBoundingBoxOperationMetadata,
            com.google.cloud.datalabeling.v1beta1.LabelImageBoundingBoxOperationMetadata.Builder,
            com.google.cloud.datalabeling.v1beta1.LabelImageBoundingBoxOperationMetadataOrBuilder>
        getImageBoundingBoxDetailsFieldBuilder() {
      if (imageBoundingBoxDetailsBuilder_ == null) {
        if (!(detailsCase_ == 4)) {
          details_ =
              com.google.cloud.datalabeling.v1beta1.LabelImageBoundingBoxOperationMetadata
                  .getDefaultInstance();
        }
        imageBoundingBoxDetailsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.LabelImageBoundingBoxOperationMetadata,
                com.google.cloud.datalabeling.v1beta1.LabelImageBoundingBoxOperationMetadata
                    .Builder,
                com.google.cloud.datalabeling.v1beta1
                    .LabelImageBoundingBoxOperationMetadataOrBuilder>(
                (com.google.cloud.datalabeling.v1beta1.LabelImageBoundingBoxOperationMetadata)
                    details_,
                getParentForChildren(),
                isClean());
        details_ = null;
      }
      detailsCase_ = 4;
      onChanged();
      ;
      return imageBoundingBoxDetailsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.LabelImageBoundingPolyOperationMetadata,
            com.google.cloud.datalabeling.v1beta1.LabelImageBoundingPolyOperationMetadata.Builder,
            com.google.cloud.datalabeling.v1beta1.LabelImageBoundingPolyOperationMetadataOrBuilder>
        imageBoundingPolyDetailsBuilder_;
    /**
     *
     *
     * <pre>
     * Details of label image bounding poly operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelImageBoundingPolyOperationMetadata image_bounding_poly_details = 11;
     * </code>
     *
     * @return Whether the imageBoundingPolyDetails field is set.
     */
    @java.lang.Override
    public boolean hasImageBoundingPolyDetails() {
      return detailsCase_ == 11;
    }
    /**
     *
     *
     * <pre>
     * Details of label image bounding poly operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelImageBoundingPolyOperationMetadata image_bounding_poly_details = 11;
     * </code>
     *
     * @return The imageBoundingPolyDetails.
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.LabelImageBoundingPolyOperationMetadata
        getImageBoundingPolyDetails() {
      if (imageBoundingPolyDetailsBuilder_ == null) {
        if (detailsCase_ == 11) {
          return (com.google.cloud.datalabeling.v1beta1.LabelImageBoundingPolyOperationMetadata)
              details_;
        }
        return com.google.cloud.datalabeling.v1beta1.LabelImageBoundingPolyOperationMetadata
            .getDefaultInstance();
      } else {
        if (detailsCase_ == 11) {
          return imageBoundingPolyDetailsBuilder_.getMessage();
        }
        return com.google.cloud.datalabeling.v1beta1.LabelImageBoundingPolyOperationMetadata
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Details of label image bounding poly operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelImageBoundingPolyOperationMetadata image_bounding_poly_details = 11;
     * </code>
     */
    public Builder setImageBoundingPolyDetails(
        com.google.cloud.datalabeling.v1beta1.LabelImageBoundingPolyOperationMetadata value) {
      if (imageBoundingPolyDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        details_ = value;
        onChanged();
      } else {
        imageBoundingPolyDetailsBuilder_.setMessage(value);
      }
      detailsCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of label image bounding poly operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelImageBoundingPolyOperationMetadata image_bounding_poly_details = 11;
     * </code>
     */
    public Builder setImageBoundingPolyDetails(
        com.google.cloud.datalabeling.v1beta1.LabelImageBoundingPolyOperationMetadata.Builder
            builderForValue) {
      if (imageBoundingPolyDetailsBuilder_ == null) {
        details_ = builderForValue.build();
        onChanged();
      } else {
        imageBoundingPolyDetailsBuilder_.setMessage(builderForValue.build());
      }
      detailsCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of label image bounding poly operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelImageBoundingPolyOperationMetadata image_bounding_poly_details = 11;
     * </code>
     */
    public Builder mergeImageBoundingPolyDetails(
        com.google.cloud.datalabeling.v1beta1.LabelImageBoundingPolyOperationMetadata value) {
      if (imageBoundingPolyDetailsBuilder_ == null) {
        if (detailsCase_ == 11
            && details_
                != com.google.cloud.datalabeling.v1beta1.LabelImageBoundingPolyOperationMetadata
                    .getDefaultInstance()) {
          details_ =
              com.google.cloud.datalabeling.v1beta1.LabelImageBoundingPolyOperationMetadata
                  .newBuilder(
                      (com.google.cloud.datalabeling.v1beta1
                              .LabelImageBoundingPolyOperationMetadata)
                          details_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          details_ = value;
        }
        onChanged();
      } else {
        if (detailsCase_ == 11) {
          imageBoundingPolyDetailsBuilder_.mergeFrom(value);
        } else {
          imageBoundingPolyDetailsBuilder_.setMessage(value);
        }
      }
      detailsCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of label image bounding poly operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelImageBoundingPolyOperationMetadata image_bounding_poly_details = 11;
     * </code>
     */
    public Builder clearImageBoundingPolyDetails() {
      if (imageBoundingPolyDetailsBuilder_ == null) {
        if (detailsCase_ == 11) {
          detailsCase_ = 0;
          details_ = null;
          onChanged();
        }
      } else {
        if (detailsCase_ == 11) {
          detailsCase_ = 0;
          details_ = null;
        }
        imageBoundingPolyDetailsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of label image bounding poly operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelImageBoundingPolyOperationMetadata image_bounding_poly_details = 11;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.LabelImageBoundingPolyOperationMetadata.Builder
        getImageBoundingPolyDetailsBuilder() {
      return getImageBoundingPolyDetailsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Details of label image bounding poly operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelImageBoundingPolyOperationMetadata image_bounding_poly_details = 11;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.LabelImageBoundingPolyOperationMetadataOrBuilder
        getImageBoundingPolyDetailsOrBuilder() {
      if ((detailsCase_ == 11) && (imageBoundingPolyDetailsBuilder_ != null)) {
        return imageBoundingPolyDetailsBuilder_.getMessageOrBuilder();
      } else {
        if (detailsCase_ == 11) {
          return (com.google.cloud.datalabeling.v1beta1.LabelImageBoundingPolyOperationMetadata)
              details_;
        }
        return com.google.cloud.datalabeling.v1beta1.LabelImageBoundingPolyOperationMetadata
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Details of label image bounding poly operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelImageBoundingPolyOperationMetadata image_bounding_poly_details = 11;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.LabelImageBoundingPolyOperationMetadata,
            com.google.cloud.datalabeling.v1beta1.LabelImageBoundingPolyOperationMetadata.Builder,
            com.google.cloud.datalabeling.v1beta1.LabelImageBoundingPolyOperationMetadataOrBuilder>
        getImageBoundingPolyDetailsFieldBuilder() {
      if (imageBoundingPolyDetailsBuilder_ == null) {
        if (!(detailsCase_ == 11)) {
          details_ =
              com.google.cloud.datalabeling.v1beta1.LabelImageBoundingPolyOperationMetadata
                  .getDefaultInstance();
        }
        imageBoundingPolyDetailsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.LabelImageBoundingPolyOperationMetadata,
                com.google.cloud.datalabeling.v1beta1.LabelImageBoundingPolyOperationMetadata
                    .Builder,
                com.google.cloud.datalabeling.v1beta1
                    .LabelImageBoundingPolyOperationMetadataOrBuilder>(
                (com.google.cloud.datalabeling.v1beta1.LabelImageBoundingPolyOperationMetadata)
                    details_,
                getParentForChildren(),
                isClean());
        details_ = null;
      }
      detailsCase_ = 11;
      onChanged();
      ;
      return imageBoundingPolyDetailsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.LabelImageOrientedBoundingBoxOperationMetadata,
            com.google.cloud.datalabeling.v1beta1.LabelImageOrientedBoundingBoxOperationMetadata
                .Builder,
            com.google.cloud.datalabeling.v1beta1
                .LabelImageOrientedBoundingBoxOperationMetadataOrBuilder>
        imageOrientedBoundingBoxDetailsBuilder_;
    /**
     *
     *
     * <pre>
     * Details of label image oriented bounding box operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelImageOrientedBoundingBoxOperationMetadata image_oriented_bounding_box_details = 14;
     * </code>
     *
     * @return Whether the imageOrientedBoundingBoxDetails field is set.
     */
    @java.lang.Override
    public boolean hasImageOrientedBoundingBoxDetails() {
      return detailsCase_ == 14;
    }
    /**
     *
     *
     * <pre>
     * Details of label image oriented bounding box operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelImageOrientedBoundingBoxOperationMetadata image_oriented_bounding_box_details = 14;
     * </code>
     *
     * @return The imageOrientedBoundingBoxDetails.
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.LabelImageOrientedBoundingBoxOperationMetadata
        getImageOrientedBoundingBoxDetails() {
      if (imageOrientedBoundingBoxDetailsBuilder_ == null) {
        if (detailsCase_ == 14) {
          return (com.google.cloud.datalabeling.v1beta1
                  .LabelImageOrientedBoundingBoxOperationMetadata)
              details_;
        }
        return com.google.cloud.datalabeling.v1beta1.LabelImageOrientedBoundingBoxOperationMetadata
            .getDefaultInstance();
      } else {
        if (detailsCase_ == 14) {
          return imageOrientedBoundingBoxDetailsBuilder_.getMessage();
        }
        return com.google.cloud.datalabeling.v1beta1.LabelImageOrientedBoundingBoxOperationMetadata
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Details of label image oriented bounding box operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelImageOrientedBoundingBoxOperationMetadata image_oriented_bounding_box_details = 14;
     * </code>
     */
    public Builder setImageOrientedBoundingBoxDetails(
        com.google.cloud.datalabeling.v1beta1.LabelImageOrientedBoundingBoxOperationMetadata
            value) {
      if (imageOrientedBoundingBoxDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        details_ = value;
        onChanged();
      } else {
        imageOrientedBoundingBoxDetailsBuilder_.setMessage(value);
      }
      detailsCase_ = 14;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of label image oriented bounding box operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelImageOrientedBoundingBoxOperationMetadata image_oriented_bounding_box_details = 14;
     * </code>
     */
    public Builder setImageOrientedBoundingBoxDetails(
        com.google.cloud.datalabeling.v1beta1.LabelImageOrientedBoundingBoxOperationMetadata.Builder
            builderForValue) {
      if (imageOrientedBoundingBoxDetailsBuilder_ == null) {
        details_ = builderForValue.build();
        onChanged();
      } else {
        imageOrientedBoundingBoxDetailsBuilder_.setMessage(builderForValue.build());
      }
      detailsCase_ = 14;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of label image oriented bounding box operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelImageOrientedBoundingBoxOperationMetadata image_oriented_bounding_box_details = 14;
     * </code>
     */
    public Builder mergeImageOrientedBoundingBoxDetails(
        com.google.cloud.datalabeling.v1beta1.LabelImageOrientedBoundingBoxOperationMetadata
            value) {
      if (imageOrientedBoundingBoxDetailsBuilder_ == null) {
        if (detailsCase_ == 14
            && details_
                != com.google.cloud.datalabeling.v1beta1
                    .LabelImageOrientedBoundingBoxOperationMetadata.getDefaultInstance()) {
          details_ =
              com.google.cloud.datalabeling.v1beta1.LabelImageOrientedBoundingBoxOperationMetadata
                  .newBuilder(
                      (com.google.cloud.datalabeling.v1beta1
                              .LabelImageOrientedBoundingBoxOperationMetadata)
                          details_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          details_ = value;
        }
        onChanged();
      } else {
        if (detailsCase_ == 14) {
          imageOrientedBoundingBoxDetailsBuilder_.mergeFrom(value);
        } else {
          imageOrientedBoundingBoxDetailsBuilder_.setMessage(value);
        }
      }
      detailsCase_ = 14;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of label image oriented bounding box operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelImageOrientedBoundingBoxOperationMetadata image_oriented_bounding_box_details = 14;
     * </code>
     */
    public Builder clearImageOrientedBoundingBoxDetails() {
      if (imageOrientedBoundingBoxDetailsBuilder_ == null) {
        if (detailsCase_ == 14) {
          detailsCase_ = 0;
          details_ = null;
          onChanged();
        }
      } else {
        if (detailsCase_ == 14) {
          detailsCase_ = 0;
          details_ = null;
        }
        imageOrientedBoundingBoxDetailsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of label image oriented bounding box operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelImageOrientedBoundingBoxOperationMetadata image_oriented_bounding_box_details = 14;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.LabelImageOrientedBoundingBoxOperationMetadata
            .Builder
        getImageOrientedBoundingBoxDetailsBuilder() {
      return getImageOrientedBoundingBoxDetailsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Details of label image oriented bounding box operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelImageOrientedBoundingBoxOperationMetadata image_oriented_bounding_box_details = 14;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1
            .LabelImageOrientedBoundingBoxOperationMetadataOrBuilder
        getImageOrientedBoundingBoxDetailsOrBuilder() {
      if ((detailsCase_ == 14) && (imageOrientedBoundingBoxDetailsBuilder_ != null)) {
        return imageOrientedBoundingBoxDetailsBuilder_.getMessageOrBuilder();
      } else {
        if (detailsCase_ == 14) {
          return (com.google.cloud.datalabeling.v1beta1
                  .LabelImageOrientedBoundingBoxOperationMetadata)
              details_;
        }
        return com.google.cloud.datalabeling.v1beta1.LabelImageOrientedBoundingBoxOperationMetadata
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Details of label image oriented bounding box operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelImageOrientedBoundingBoxOperationMetadata image_oriented_bounding_box_details = 14;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.LabelImageOrientedBoundingBoxOperationMetadata,
            com.google.cloud.datalabeling.v1beta1.LabelImageOrientedBoundingBoxOperationMetadata
                .Builder,
            com.google.cloud.datalabeling.v1beta1
                .LabelImageOrientedBoundingBoxOperationMetadataOrBuilder>
        getImageOrientedBoundingBoxDetailsFieldBuilder() {
      if (imageOrientedBoundingBoxDetailsBuilder_ == null) {
        if (!(detailsCase_ == 14)) {
          details_ =
              com.google.cloud.datalabeling.v1beta1.LabelImageOrientedBoundingBoxOperationMetadata
                  .getDefaultInstance();
        }
        imageOrientedBoundingBoxDetailsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1
                    .LabelImageOrientedBoundingBoxOperationMetadata,
                com.google.cloud.datalabeling.v1beta1.LabelImageOrientedBoundingBoxOperationMetadata
                    .Builder,
                com.google.cloud.datalabeling.v1beta1
                    .LabelImageOrientedBoundingBoxOperationMetadataOrBuilder>(
                (com.google.cloud.datalabeling.v1beta1
                        .LabelImageOrientedBoundingBoxOperationMetadata)
                    details_,
                getParentForChildren(),
                isClean());
        details_ = null;
      }
      detailsCase_ = 14;
      onChanged();
      ;
      return imageOrientedBoundingBoxDetailsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.LabelImagePolylineOperationMetadata,
            com.google.cloud.datalabeling.v1beta1.LabelImagePolylineOperationMetadata.Builder,
            com.google.cloud.datalabeling.v1beta1.LabelImagePolylineOperationMetadataOrBuilder>
        imagePolylineDetailsBuilder_;
    /**
     *
     *
     * <pre>
     * Details of label image polyline operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelImagePolylineOperationMetadata image_polyline_details = 12;
     * </code>
     *
     * @return Whether the imagePolylineDetails field is set.
     */
    @java.lang.Override
    public boolean hasImagePolylineDetails() {
      return detailsCase_ == 12;
    }
    /**
     *
     *
     * <pre>
     * Details of label image polyline operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelImagePolylineOperationMetadata image_polyline_details = 12;
     * </code>
     *
     * @return The imagePolylineDetails.
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.LabelImagePolylineOperationMetadata
        getImagePolylineDetails() {
      if (imagePolylineDetailsBuilder_ == null) {
        if (detailsCase_ == 12) {
          return (com.google.cloud.datalabeling.v1beta1.LabelImagePolylineOperationMetadata)
              details_;
        }
        return com.google.cloud.datalabeling.v1beta1.LabelImagePolylineOperationMetadata
            .getDefaultInstance();
      } else {
        if (detailsCase_ == 12) {
          return imagePolylineDetailsBuilder_.getMessage();
        }
        return com.google.cloud.datalabeling.v1beta1.LabelImagePolylineOperationMetadata
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Details of label image polyline operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelImagePolylineOperationMetadata image_polyline_details = 12;
     * </code>
     */
    public Builder setImagePolylineDetails(
        com.google.cloud.datalabeling.v1beta1.LabelImagePolylineOperationMetadata value) {
      if (imagePolylineDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        details_ = value;
        onChanged();
      } else {
        imagePolylineDetailsBuilder_.setMessage(value);
      }
      detailsCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of label image polyline operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelImagePolylineOperationMetadata image_polyline_details = 12;
     * </code>
     */
    public Builder setImagePolylineDetails(
        com.google.cloud.datalabeling.v1beta1.LabelImagePolylineOperationMetadata.Builder
            builderForValue) {
      if (imagePolylineDetailsBuilder_ == null) {
        details_ = builderForValue.build();
        onChanged();
      } else {
        imagePolylineDetailsBuilder_.setMessage(builderForValue.build());
      }
      detailsCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of label image polyline operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelImagePolylineOperationMetadata image_polyline_details = 12;
     * </code>
     */
    public Builder mergeImagePolylineDetails(
        com.google.cloud.datalabeling.v1beta1.LabelImagePolylineOperationMetadata value) {
      if (imagePolylineDetailsBuilder_ == null) {
        if (detailsCase_ == 12
            && details_
                != com.google.cloud.datalabeling.v1beta1.LabelImagePolylineOperationMetadata
                    .getDefaultInstance()) {
          details_ =
              com.google.cloud.datalabeling.v1beta1.LabelImagePolylineOperationMetadata.newBuilder(
                      (com.google.cloud.datalabeling.v1beta1.LabelImagePolylineOperationMetadata)
                          details_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          details_ = value;
        }
        onChanged();
      } else {
        if (detailsCase_ == 12) {
          imagePolylineDetailsBuilder_.mergeFrom(value);
        } else {
          imagePolylineDetailsBuilder_.setMessage(value);
        }
      }
      detailsCase_ = 12;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of label image polyline operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelImagePolylineOperationMetadata image_polyline_details = 12;
     * </code>
     */
    public Builder clearImagePolylineDetails() {
      if (imagePolylineDetailsBuilder_ == null) {
        if (detailsCase_ == 12) {
          detailsCase_ = 0;
          details_ = null;
          onChanged();
        }
      } else {
        if (detailsCase_ == 12) {
          detailsCase_ = 0;
          details_ = null;
        }
        imagePolylineDetailsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of label image polyline operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelImagePolylineOperationMetadata image_polyline_details = 12;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.LabelImagePolylineOperationMetadata.Builder
        getImagePolylineDetailsBuilder() {
      return getImagePolylineDetailsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Details of label image polyline operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelImagePolylineOperationMetadata image_polyline_details = 12;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.LabelImagePolylineOperationMetadataOrBuilder
        getImagePolylineDetailsOrBuilder() {
      if ((detailsCase_ == 12) && (imagePolylineDetailsBuilder_ != null)) {
        return imagePolylineDetailsBuilder_.getMessageOrBuilder();
      } else {
        if (detailsCase_ == 12) {
          return (com.google.cloud.datalabeling.v1beta1.LabelImagePolylineOperationMetadata)
              details_;
        }
        return com.google.cloud.datalabeling.v1beta1.LabelImagePolylineOperationMetadata
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Details of label image polyline operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelImagePolylineOperationMetadata image_polyline_details = 12;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.LabelImagePolylineOperationMetadata,
            com.google.cloud.datalabeling.v1beta1.LabelImagePolylineOperationMetadata.Builder,
            com.google.cloud.datalabeling.v1beta1.LabelImagePolylineOperationMetadataOrBuilder>
        getImagePolylineDetailsFieldBuilder() {
      if (imagePolylineDetailsBuilder_ == null) {
        if (!(detailsCase_ == 12)) {
          details_ =
              com.google.cloud.datalabeling.v1beta1.LabelImagePolylineOperationMetadata
                  .getDefaultInstance();
        }
        imagePolylineDetailsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.LabelImagePolylineOperationMetadata,
                com.google.cloud.datalabeling.v1beta1.LabelImagePolylineOperationMetadata.Builder,
                com.google.cloud.datalabeling.v1beta1.LabelImagePolylineOperationMetadataOrBuilder>(
                (com.google.cloud.datalabeling.v1beta1.LabelImagePolylineOperationMetadata)
                    details_,
                getParentForChildren(),
                isClean());
        details_ = null;
      }
      detailsCase_ = 12;
      onChanged();
      ;
      return imagePolylineDetailsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.LabelImageSegmentationOperationMetadata,
            com.google.cloud.datalabeling.v1beta1.LabelImageSegmentationOperationMetadata.Builder,
            com.google.cloud.datalabeling.v1beta1.LabelImageSegmentationOperationMetadataOrBuilder>
        imageSegmentationDetailsBuilder_;
    /**
     *
     *
     * <pre>
     * Details of label image segmentation operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelImageSegmentationOperationMetadata image_segmentation_details = 15;
     * </code>
     *
     * @return Whether the imageSegmentationDetails field is set.
     */
    @java.lang.Override
    public boolean hasImageSegmentationDetails() {
      return detailsCase_ == 15;
    }
    /**
     *
     *
     * <pre>
     * Details of label image segmentation operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelImageSegmentationOperationMetadata image_segmentation_details = 15;
     * </code>
     *
     * @return The imageSegmentationDetails.
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.LabelImageSegmentationOperationMetadata
        getImageSegmentationDetails() {
      if (imageSegmentationDetailsBuilder_ == null) {
        if (detailsCase_ == 15) {
          return (com.google.cloud.datalabeling.v1beta1.LabelImageSegmentationOperationMetadata)
              details_;
        }
        return com.google.cloud.datalabeling.v1beta1.LabelImageSegmentationOperationMetadata
            .getDefaultInstance();
      } else {
        if (detailsCase_ == 15) {
          return imageSegmentationDetailsBuilder_.getMessage();
        }
        return com.google.cloud.datalabeling.v1beta1.LabelImageSegmentationOperationMetadata
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Details of label image segmentation operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelImageSegmentationOperationMetadata image_segmentation_details = 15;
     * </code>
     */
    public Builder setImageSegmentationDetails(
        com.google.cloud.datalabeling.v1beta1.LabelImageSegmentationOperationMetadata value) {
      if (imageSegmentationDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        details_ = value;
        onChanged();
      } else {
        imageSegmentationDetailsBuilder_.setMessage(value);
      }
      detailsCase_ = 15;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of label image segmentation operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelImageSegmentationOperationMetadata image_segmentation_details = 15;
     * </code>
     */
    public Builder setImageSegmentationDetails(
        com.google.cloud.datalabeling.v1beta1.LabelImageSegmentationOperationMetadata.Builder
            builderForValue) {
      if (imageSegmentationDetailsBuilder_ == null) {
        details_ = builderForValue.build();
        onChanged();
      } else {
        imageSegmentationDetailsBuilder_.setMessage(builderForValue.build());
      }
      detailsCase_ = 15;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of label image segmentation operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelImageSegmentationOperationMetadata image_segmentation_details = 15;
     * </code>
     */
    public Builder mergeImageSegmentationDetails(
        com.google.cloud.datalabeling.v1beta1.LabelImageSegmentationOperationMetadata value) {
      if (imageSegmentationDetailsBuilder_ == null) {
        if (detailsCase_ == 15
            && details_
                != com.google.cloud.datalabeling.v1beta1.LabelImageSegmentationOperationMetadata
                    .getDefaultInstance()) {
          details_ =
              com.google.cloud.datalabeling.v1beta1.LabelImageSegmentationOperationMetadata
                  .newBuilder(
                      (com.google.cloud.datalabeling.v1beta1
                              .LabelImageSegmentationOperationMetadata)
                          details_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          details_ = value;
        }
        onChanged();
      } else {
        if (detailsCase_ == 15) {
          imageSegmentationDetailsBuilder_.mergeFrom(value);
        } else {
          imageSegmentationDetailsBuilder_.setMessage(value);
        }
      }
      detailsCase_ = 15;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of label image segmentation operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelImageSegmentationOperationMetadata image_segmentation_details = 15;
     * </code>
     */
    public Builder clearImageSegmentationDetails() {
      if (imageSegmentationDetailsBuilder_ == null) {
        if (detailsCase_ == 15) {
          detailsCase_ = 0;
          details_ = null;
          onChanged();
        }
      } else {
        if (detailsCase_ == 15) {
          detailsCase_ = 0;
          details_ = null;
        }
        imageSegmentationDetailsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of label image segmentation operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelImageSegmentationOperationMetadata image_segmentation_details = 15;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.LabelImageSegmentationOperationMetadata.Builder
        getImageSegmentationDetailsBuilder() {
      return getImageSegmentationDetailsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Details of label image segmentation operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelImageSegmentationOperationMetadata image_segmentation_details = 15;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.LabelImageSegmentationOperationMetadataOrBuilder
        getImageSegmentationDetailsOrBuilder() {
      if ((detailsCase_ == 15) && (imageSegmentationDetailsBuilder_ != null)) {
        return imageSegmentationDetailsBuilder_.getMessageOrBuilder();
      } else {
        if (detailsCase_ == 15) {
          return (com.google.cloud.datalabeling.v1beta1.LabelImageSegmentationOperationMetadata)
              details_;
        }
        return com.google.cloud.datalabeling.v1beta1.LabelImageSegmentationOperationMetadata
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Details of label image segmentation operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelImageSegmentationOperationMetadata image_segmentation_details = 15;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.LabelImageSegmentationOperationMetadata,
            com.google.cloud.datalabeling.v1beta1.LabelImageSegmentationOperationMetadata.Builder,
            com.google.cloud.datalabeling.v1beta1.LabelImageSegmentationOperationMetadataOrBuilder>
        getImageSegmentationDetailsFieldBuilder() {
      if (imageSegmentationDetailsBuilder_ == null) {
        if (!(detailsCase_ == 15)) {
          details_ =
              com.google.cloud.datalabeling.v1beta1.LabelImageSegmentationOperationMetadata
                  .getDefaultInstance();
        }
        imageSegmentationDetailsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.LabelImageSegmentationOperationMetadata,
                com.google.cloud.datalabeling.v1beta1.LabelImageSegmentationOperationMetadata
                    .Builder,
                com.google.cloud.datalabeling.v1beta1
                    .LabelImageSegmentationOperationMetadataOrBuilder>(
                (com.google.cloud.datalabeling.v1beta1.LabelImageSegmentationOperationMetadata)
                    details_,
                getParentForChildren(),
                isClean());
        details_ = null;
      }
      detailsCase_ = 15;
      onChanged();
      ;
      return imageSegmentationDetailsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.LabelVideoClassificationOperationMetadata,
            com.google.cloud.datalabeling.v1beta1.LabelVideoClassificationOperationMetadata.Builder,
            com.google.cloud.datalabeling.v1beta1
                .LabelVideoClassificationOperationMetadataOrBuilder>
        videoClassificationDetailsBuilder_;
    /**
     *
     *
     * <pre>
     * Details of label video classification operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelVideoClassificationOperationMetadata video_classification_details = 5;
     * </code>
     *
     * @return Whether the videoClassificationDetails field is set.
     */
    @java.lang.Override
    public boolean hasVideoClassificationDetails() {
      return detailsCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Details of label video classification operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelVideoClassificationOperationMetadata video_classification_details = 5;
     * </code>
     *
     * @return The videoClassificationDetails.
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.LabelVideoClassificationOperationMetadata
        getVideoClassificationDetails() {
      if (videoClassificationDetailsBuilder_ == null) {
        if (detailsCase_ == 5) {
          return (com.google.cloud.datalabeling.v1beta1.LabelVideoClassificationOperationMetadata)
              details_;
        }
        return com.google.cloud.datalabeling.v1beta1.LabelVideoClassificationOperationMetadata
            .getDefaultInstance();
      } else {
        if (detailsCase_ == 5) {
          return videoClassificationDetailsBuilder_.getMessage();
        }
        return com.google.cloud.datalabeling.v1beta1.LabelVideoClassificationOperationMetadata
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Details of label video classification operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelVideoClassificationOperationMetadata video_classification_details = 5;
     * </code>
     */
    public Builder setVideoClassificationDetails(
        com.google.cloud.datalabeling.v1beta1.LabelVideoClassificationOperationMetadata value) {
      if (videoClassificationDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        details_ = value;
        onChanged();
      } else {
        videoClassificationDetailsBuilder_.setMessage(value);
      }
      detailsCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of label video classification operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelVideoClassificationOperationMetadata video_classification_details = 5;
     * </code>
     */
    public Builder setVideoClassificationDetails(
        com.google.cloud.datalabeling.v1beta1.LabelVideoClassificationOperationMetadata.Builder
            builderForValue) {
      if (videoClassificationDetailsBuilder_ == null) {
        details_ = builderForValue.build();
        onChanged();
      } else {
        videoClassificationDetailsBuilder_.setMessage(builderForValue.build());
      }
      detailsCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of label video classification operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelVideoClassificationOperationMetadata video_classification_details = 5;
     * </code>
     */
    public Builder mergeVideoClassificationDetails(
        com.google.cloud.datalabeling.v1beta1.LabelVideoClassificationOperationMetadata value) {
      if (videoClassificationDetailsBuilder_ == null) {
        if (detailsCase_ == 5
            && details_
                != com.google.cloud.datalabeling.v1beta1.LabelVideoClassificationOperationMetadata
                    .getDefaultInstance()) {
          details_ =
              com.google.cloud.datalabeling.v1beta1.LabelVideoClassificationOperationMetadata
                  .newBuilder(
                      (com.google.cloud.datalabeling.v1beta1
                              .LabelVideoClassificationOperationMetadata)
                          details_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          details_ = value;
        }
        onChanged();
      } else {
        if (detailsCase_ == 5) {
          videoClassificationDetailsBuilder_.mergeFrom(value);
        } else {
          videoClassificationDetailsBuilder_.setMessage(value);
        }
      }
      detailsCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of label video classification operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelVideoClassificationOperationMetadata video_classification_details = 5;
     * </code>
     */
    public Builder clearVideoClassificationDetails() {
      if (videoClassificationDetailsBuilder_ == null) {
        if (detailsCase_ == 5) {
          detailsCase_ = 0;
          details_ = null;
          onChanged();
        }
      } else {
        if (detailsCase_ == 5) {
          detailsCase_ = 0;
          details_ = null;
        }
        videoClassificationDetailsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of label video classification operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelVideoClassificationOperationMetadata video_classification_details = 5;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.LabelVideoClassificationOperationMetadata.Builder
        getVideoClassificationDetailsBuilder() {
      return getVideoClassificationDetailsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Details of label video classification operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelVideoClassificationOperationMetadata video_classification_details = 5;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.LabelVideoClassificationOperationMetadataOrBuilder
        getVideoClassificationDetailsOrBuilder() {
      if ((detailsCase_ == 5) && (videoClassificationDetailsBuilder_ != null)) {
        return videoClassificationDetailsBuilder_.getMessageOrBuilder();
      } else {
        if (detailsCase_ == 5) {
          return (com.google.cloud.datalabeling.v1beta1.LabelVideoClassificationOperationMetadata)
              details_;
        }
        return com.google.cloud.datalabeling.v1beta1.LabelVideoClassificationOperationMetadata
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Details of label video classification operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelVideoClassificationOperationMetadata video_classification_details = 5;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.LabelVideoClassificationOperationMetadata,
            com.google.cloud.datalabeling.v1beta1.LabelVideoClassificationOperationMetadata.Builder,
            com.google.cloud.datalabeling.v1beta1
                .LabelVideoClassificationOperationMetadataOrBuilder>
        getVideoClassificationDetailsFieldBuilder() {
      if (videoClassificationDetailsBuilder_ == null) {
        if (!(detailsCase_ == 5)) {
          details_ =
              com.google.cloud.datalabeling.v1beta1.LabelVideoClassificationOperationMetadata
                  .getDefaultInstance();
        }
        videoClassificationDetailsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.LabelVideoClassificationOperationMetadata,
                com.google.cloud.datalabeling.v1beta1.LabelVideoClassificationOperationMetadata
                    .Builder,
                com.google.cloud.datalabeling.v1beta1
                    .LabelVideoClassificationOperationMetadataOrBuilder>(
                (com.google.cloud.datalabeling.v1beta1.LabelVideoClassificationOperationMetadata)
                    details_,
                getParentForChildren(),
                isClean());
        details_ = null;
      }
      detailsCase_ = 5;
      onChanged();
      ;
      return videoClassificationDetailsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.LabelVideoObjectDetectionOperationMetadata,
            com.google.cloud.datalabeling.v1beta1.LabelVideoObjectDetectionOperationMetadata
                .Builder,
            com.google.cloud.datalabeling.v1beta1
                .LabelVideoObjectDetectionOperationMetadataOrBuilder>
        videoObjectDetectionDetailsBuilder_;
    /**
     *
     *
     * <pre>
     * Details of label video object detection operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelVideoObjectDetectionOperationMetadata video_object_detection_details = 6;
     * </code>
     *
     * @return Whether the videoObjectDetectionDetails field is set.
     */
    @java.lang.Override
    public boolean hasVideoObjectDetectionDetails() {
      return detailsCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * Details of label video object detection operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelVideoObjectDetectionOperationMetadata video_object_detection_details = 6;
     * </code>
     *
     * @return The videoObjectDetectionDetails.
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.LabelVideoObjectDetectionOperationMetadata
        getVideoObjectDetectionDetails() {
      if (videoObjectDetectionDetailsBuilder_ == null) {
        if (detailsCase_ == 6) {
          return (com.google.cloud.datalabeling.v1beta1.LabelVideoObjectDetectionOperationMetadata)
              details_;
        }
        return com.google.cloud.datalabeling.v1beta1.LabelVideoObjectDetectionOperationMetadata
            .getDefaultInstance();
      } else {
        if (detailsCase_ == 6) {
          return videoObjectDetectionDetailsBuilder_.getMessage();
        }
        return com.google.cloud.datalabeling.v1beta1.LabelVideoObjectDetectionOperationMetadata
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Details of label video object detection operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelVideoObjectDetectionOperationMetadata video_object_detection_details = 6;
     * </code>
     */
    public Builder setVideoObjectDetectionDetails(
        com.google.cloud.datalabeling.v1beta1.LabelVideoObjectDetectionOperationMetadata value) {
      if (videoObjectDetectionDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        details_ = value;
        onChanged();
      } else {
        videoObjectDetectionDetailsBuilder_.setMessage(value);
      }
      detailsCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of label video object detection operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelVideoObjectDetectionOperationMetadata video_object_detection_details = 6;
     * </code>
     */
    public Builder setVideoObjectDetectionDetails(
        com.google.cloud.datalabeling.v1beta1.LabelVideoObjectDetectionOperationMetadata.Builder
            builderForValue) {
      if (videoObjectDetectionDetailsBuilder_ == null) {
        details_ = builderForValue.build();
        onChanged();
      } else {
        videoObjectDetectionDetailsBuilder_.setMessage(builderForValue.build());
      }
      detailsCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of label video object detection operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelVideoObjectDetectionOperationMetadata video_object_detection_details = 6;
     * </code>
     */
    public Builder mergeVideoObjectDetectionDetails(
        com.google.cloud.datalabeling.v1beta1.LabelVideoObjectDetectionOperationMetadata value) {
      if (videoObjectDetectionDetailsBuilder_ == null) {
        if (detailsCase_ == 6
            && details_
                != com.google.cloud.datalabeling.v1beta1.LabelVideoObjectDetectionOperationMetadata
                    .getDefaultInstance()) {
          details_ =
              com.google.cloud.datalabeling.v1beta1.LabelVideoObjectDetectionOperationMetadata
                  .newBuilder(
                      (com.google.cloud.datalabeling.v1beta1
                              .LabelVideoObjectDetectionOperationMetadata)
                          details_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          details_ = value;
        }
        onChanged();
      } else {
        if (detailsCase_ == 6) {
          videoObjectDetectionDetailsBuilder_.mergeFrom(value);
        } else {
          videoObjectDetectionDetailsBuilder_.setMessage(value);
        }
      }
      detailsCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of label video object detection operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelVideoObjectDetectionOperationMetadata video_object_detection_details = 6;
     * </code>
     */
    public Builder clearVideoObjectDetectionDetails() {
      if (videoObjectDetectionDetailsBuilder_ == null) {
        if (detailsCase_ == 6) {
          detailsCase_ = 0;
          details_ = null;
          onChanged();
        }
      } else {
        if (detailsCase_ == 6) {
          detailsCase_ = 0;
          details_ = null;
        }
        videoObjectDetectionDetailsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of label video object detection operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelVideoObjectDetectionOperationMetadata video_object_detection_details = 6;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.LabelVideoObjectDetectionOperationMetadata.Builder
        getVideoObjectDetectionDetailsBuilder() {
      return getVideoObjectDetectionDetailsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Details of label video object detection operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelVideoObjectDetectionOperationMetadata video_object_detection_details = 6;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.LabelVideoObjectDetectionOperationMetadataOrBuilder
        getVideoObjectDetectionDetailsOrBuilder() {
      if ((detailsCase_ == 6) && (videoObjectDetectionDetailsBuilder_ != null)) {
        return videoObjectDetectionDetailsBuilder_.getMessageOrBuilder();
      } else {
        if (detailsCase_ == 6) {
          return (com.google.cloud.datalabeling.v1beta1.LabelVideoObjectDetectionOperationMetadata)
              details_;
        }
        return com.google.cloud.datalabeling.v1beta1.LabelVideoObjectDetectionOperationMetadata
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Details of label video object detection operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelVideoObjectDetectionOperationMetadata video_object_detection_details = 6;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.LabelVideoObjectDetectionOperationMetadata,
            com.google.cloud.datalabeling.v1beta1.LabelVideoObjectDetectionOperationMetadata
                .Builder,
            com.google.cloud.datalabeling.v1beta1
                .LabelVideoObjectDetectionOperationMetadataOrBuilder>
        getVideoObjectDetectionDetailsFieldBuilder() {
      if (videoObjectDetectionDetailsBuilder_ == null) {
        if (!(detailsCase_ == 6)) {
          details_ =
              com.google.cloud.datalabeling.v1beta1.LabelVideoObjectDetectionOperationMetadata
                  .getDefaultInstance();
        }
        videoObjectDetectionDetailsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.LabelVideoObjectDetectionOperationMetadata,
                com.google.cloud.datalabeling.v1beta1.LabelVideoObjectDetectionOperationMetadata
                    .Builder,
                com.google.cloud.datalabeling.v1beta1
                    .LabelVideoObjectDetectionOperationMetadataOrBuilder>(
                (com.google.cloud.datalabeling.v1beta1.LabelVideoObjectDetectionOperationMetadata)
                    details_,
                getParentForChildren(),
                isClean());
        details_ = null;
      }
      detailsCase_ = 6;
      onChanged();
      ;
      return videoObjectDetectionDetailsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.LabelVideoObjectTrackingOperationMetadata,
            com.google.cloud.datalabeling.v1beta1.LabelVideoObjectTrackingOperationMetadata.Builder,
            com.google.cloud.datalabeling.v1beta1
                .LabelVideoObjectTrackingOperationMetadataOrBuilder>
        videoObjectTrackingDetailsBuilder_;
    /**
     *
     *
     * <pre>
     * Details of label video object tracking operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelVideoObjectTrackingOperationMetadata video_object_tracking_details = 7;
     * </code>
     *
     * @return Whether the videoObjectTrackingDetails field is set.
     */
    @java.lang.Override
    public boolean hasVideoObjectTrackingDetails() {
      return detailsCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * Details of label video object tracking operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelVideoObjectTrackingOperationMetadata video_object_tracking_details = 7;
     * </code>
     *
     * @return The videoObjectTrackingDetails.
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.LabelVideoObjectTrackingOperationMetadata
        getVideoObjectTrackingDetails() {
      if (videoObjectTrackingDetailsBuilder_ == null) {
        if (detailsCase_ == 7) {
          return (com.google.cloud.datalabeling.v1beta1.LabelVideoObjectTrackingOperationMetadata)
              details_;
        }
        return com.google.cloud.datalabeling.v1beta1.LabelVideoObjectTrackingOperationMetadata
            .getDefaultInstance();
      } else {
        if (detailsCase_ == 7) {
          return videoObjectTrackingDetailsBuilder_.getMessage();
        }
        return com.google.cloud.datalabeling.v1beta1.LabelVideoObjectTrackingOperationMetadata
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Details of label video object tracking operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelVideoObjectTrackingOperationMetadata video_object_tracking_details = 7;
     * </code>
     */
    public Builder setVideoObjectTrackingDetails(
        com.google.cloud.datalabeling.v1beta1.LabelVideoObjectTrackingOperationMetadata value) {
      if (videoObjectTrackingDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        details_ = value;
        onChanged();
      } else {
        videoObjectTrackingDetailsBuilder_.setMessage(value);
      }
      detailsCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of label video object tracking operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelVideoObjectTrackingOperationMetadata video_object_tracking_details = 7;
     * </code>
     */
    public Builder setVideoObjectTrackingDetails(
        com.google.cloud.datalabeling.v1beta1.LabelVideoObjectTrackingOperationMetadata.Builder
            builderForValue) {
      if (videoObjectTrackingDetailsBuilder_ == null) {
        details_ = builderForValue.build();
        onChanged();
      } else {
        videoObjectTrackingDetailsBuilder_.setMessage(builderForValue.build());
      }
      detailsCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of label video object tracking operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelVideoObjectTrackingOperationMetadata video_object_tracking_details = 7;
     * </code>
     */
    public Builder mergeVideoObjectTrackingDetails(
        com.google.cloud.datalabeling.v1beta1.LabelVideoObjectTrackingOperationMetadata value) {
      if (videoObjectTrackingDetailsBuilder_ == null) {
        if (detailsCase_ == 7
            && details_
                != com.google.cloud.datalabeling.v1beta1.LabelVideoObjectTrackingOperationMetadata
                    .getDefaultInstance()) {
          details_ =
              com.google.cloud.datalabeling.v1beta1.LabelVideoObjectTrackingOperationMetadata
                  .newBuilder(
                      (com.google.cloud.datalabeling.v1beta1
                              .LabelVideoObjectTrackingOperationMetadata)
                          details_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          details_ = value;
        }
        onChanged();
      } else {
        if (detailsCase_ == 7) {
          videoObjectTrackingDetailsBuilder_.mergeFrom(value);
        } else {
          videoObjectTrackingDetailsBuilder_.setMessage(value);
        }
      }
      detailsCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of label video object tracking operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelVideoObjectTrackingOperationMetadata video_object_tracking_details = 7;
     * </code>
     */
    public Builder clearVideoObjectTrackingDetails() {
      if (videoObjectTrackingDetailsBuilder_ == null) {
        if (detailsCase_ == 7) {
          detailsCase_ = 0;
          details_ = null;
          onChanged();
        }
      } else {
        if (detailsCase_ == 7) {
          detailsCase_ = 0;
          details_ = null;
        }
        videoObjectTrackingDetailsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of label video object tracking operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelVideoObjectTrackingOperationMetadata video_object_tracking_details = 7;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.LabelVideoObjectTrackingOperationMetadata.Builder
        getVideoObjectTrackingDetailsBuilder() {
      return getVideoObjectTrackingDetailsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Details of label video object tracking operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelVideoObjectTrackingOperationMetadata video_object_tracking_details = 7;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.LabelVideoObjectTrackingOperationMetadataOrBuilder
        getVideoObjectTrackingDetailsOrBuilder() {
      if ((detailsCase_ == 7) && (videoObjectTrackingDetailsBuilder_ != null)) {
        return videoObjectTrackingDetailsBuilder_.getMessageOrBuilder();
      } else {
        if (detailsCase_ == 7) {
          return (com.google.cloud.datalabeling.v1beta1.LabelVideoObjectTrackingOperationMetadata)
              details_;
        }
        return com.google.cloud.datalabeling.v1beta1.LabelVideoObjectTrackingOperationMetadata
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Details of label video object tracking operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelVideoObjectTrackingOperationMetadata video_object_tracking_details = 7;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.LabelVideoObjectTrackingOperationMetadata,
            com.google.cloud.datalabeling.v1beta1.LabelVideoObjectTrackingOperationMetadata.Builder,
            com.google.cloud.datalabeling.v1beta1
                .LabelVideoObjectTrackingOperationMetadataOrBuilder>
        getVideoObjectTrackingDetailsFieldBuilder() {
      if (videoObjectTrackingDetailsBuilder_ == null) {
        if (!(detailsCase_ == 7)) {
          details_ =
              com.google.cloud.datalabeling.v1beta1.LabelVideoObjectTrackingOperationMetadata
                  .getDefaultInstance();
        }
        videoObjectTrackingDetailsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.LabelVideoObjectTrackingOperationMetadata,
                com.google.cloud.datalabeling.v1beta1.LabelVideoObjectTrackingOperationMetadata
                    .Builder,
                com.google.cloud.datalabeling.v1beta1
                    .LabelVideoObjectTrackingOperationMetadataOrBuilder>(
                (com.google.cloud.datalabeling.v1beta1.LabelVideoObjectTrackingOperationMetadata)
                    details_,
                getParentForChildren(),
                isClean());
        details_ = null;
      }
      detailsCase_ = 7;
      onChanged();
      ;
      return videoObjectTrackingDetailsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.LabelVideoEventOperationMetadata,
            com.google.cloud.datalabeling.v1beta1.LabelVideoEventOperationMetadata.Builder,
            com.google.cloud.datalabeling.v1beta1.LabelVideoEventOperationMetadataOrBuilder>
        videoEventDetailsBuilder_;
    /**
     *
     *
     * <pre>
     * Details of label video event operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelVideoEventOperationMetadata video_event_details = 8;
     * </code>
     *
     * @return Whether the videoEventDetails field is set.
     */
    @java.lang.Override
    public boolean hasVideoEventDetails() {
      return detailsCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * Details of label video event operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelVideoEventOperationMetadata video_event_details = 8;
     * </code>
     *
     * @return The videoEventDetails.
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.LabelVideoEventOperationMetadata
        getVideoEventDetails() {
      if (videoEventDetailsBuilder_ == null) {
        if (detailsCase_ == 8) {
          return (com.google.cloud.datalabeling.v1beta1.LabelVideoEventOperationMetadata) details_;
        }
        return com.google.cloud.datalabeling.v1beta1.LabelVideoEventOperationMetadata
            .getDefaultInstance();
      } else {
        if (detailsCase_ == 8) {
          return videoEventDetailsBuilder_.getMessage();
        }
        return com.google.cloud.datalabeling.v1beta1.LabelVideoEventOperationMetadata
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Details of label video event operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelVideoEventOperationMetadata video_event_details = 8;
     * </code>
     */
    public Builder setVideoEventDetails(
        com.google.cloud.datalabeling.v1beta1.LabelVideoEventOperationMetadata value) {
      if (videoEventDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        details_ = value;
        onChanged();
      } else {
        videoEventDetailsBuilder_.setMessage(value);
      }
      detailsCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of label video event operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelVideoEventOperationMetadata video_event_details = 8;
     * </code>
     */
    public Builder setVideoEventDetails(
        com.google.cloud.datalabeling.v1beta1.LabelVideoEventOperationMetadata.Builder
            builderForValue) {
      if (videoEventDetailsBuilder_ == null) {
        details_ = builderForValue.build();
        onChanged();
      } else {
        videoEventDetailsBuilder_.setMessage(builderForValue.build());
      }
      detailsCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of label video event operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelVideoEventOperationMetadata video_event_details = 8;
     * </code>
     */
    public Builder mergeVideoEventDetails(
        com.google.cloud.datalabeling.v1beta1.LabelVideoEventOperationMetadata value) {
      if (videoEventDetailsBuilder_ == null) {
        if (detailsCase_ == 8
            && details_
                != com.google.cloud.datalabeling.v1beta1.LabelVideoEventOperationMetadata
                    .getDefaultInstance()) {
          details_ =
              com.google.cloud.datalabeling.v1beta1.LabelVideoEventOperationMetadata.newBuilder(
                      (com.google.cloud.datalabeling.v1beta1.LabelVideoEventOperationMetadata)
                          details_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          details_ = value;
        }
        onChanged();
      } else {
        if (detailsCase_ == 8) {
          videoEventDetailsBuilder_.mergeFrom(value);
        } else {
          videoEventDetailsBuilder_.setMessage(value);
        }
      }
      detailsCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of label video event operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelVideoEventOperationMetadata video_event_details = 8;
     * </code>
     */
    public Builder clearVideoEventDetails() {
      if (videoEventDetailsBuilder_ == null) {
        if (detailsCase_ == 8) {
          detailsCase_ = 0;
          details_ = null;
          onChanged();
        }
      } else {
        if (detailsCase_ == 8) {
          detailsCase_ = 0;
          details_ = null;
        }
        videoEventDetailsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of label video event operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelVideoEventOperationMetadata video_event_details = 8;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.LabelVideoEventOperationMetadata.Builder
        getVideoEventDetailsBuilder() {
      return getVideoEventDetailsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Details of label video event operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelVideoEventOperationMetadata video_event_details = 8;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.LabelVideoEventOperationMetadataOrBuilder
        getVideoEventDetailsOrBuilder() {
      if ((detailsCase_ == 8) && (videoEventDetailsBuilder_ != null)) {
        return videoEventDetailsBuilder_.getMessageOrBuilder();
      } else {
        if (detailsCase_ == 8) {
          return (com.google.cloud.datalabeling.v1beta1.LabelVideoEventOperationMetadata) details_;
        }
        return com.google.cloud.datalabeling.v1beta1.LabelVideoEventOperationMetadata
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Details of label video event operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelVideoEventOperationMetadata video_event_details = 8;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.LabelVideoEventOperationMetadata,
            com.google.cloud.datalabeling.v1beta1.LabelVideoEventOperationMetadata.Builder,
            com.google.cloud.datalabeling.v1beta1.LabelVideoEventOperationMetadataOrBuilder>
        getVideoEventDetailsFieldBuilder() {
      if (videoEventDetailsBuilder_ == null) {
        if (!(detailsCase_ == 8)) {
          details_ =
              com.google.cloud.datalabeling.v1beta1.LabelVideoEventOperationMetadata
                  .getDefaultInstance();
        }
        videoEventDetailsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.LabelVideoEventOperationMetadata,
                com.google.cloud.datalabeling.v1beta1.LabelVideoEventOperationMetadata.Builder,
                com.google.cloud.datalabeling.v1beta1.LabelVideoEventOperationMetadataOrBuilder>(
                (com.google.cloud.datalabeling.v1beta1.LabelVideoEventOperationMetadata) details_,
                getParentForChildren(),
                isClean());
        details_ = null;
      }
      detailsCase_ = 8;
      onChanged();
      ;
      return videoEventDetailsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.LabelTextClassificationOperationMetadata,
            com.google.cloud.datalabeling.v1beta1.LabelTextClassificationOperationMetadata.Builder,
            com.google.cloud.datalabeling.v1beta1.LabelTextClassificationOperationMetadataOrBuilder>
        textClassificationDetailsBuilder_;
    /**
     *
     *
     * <pre>
     * Details of label text classification operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelTextClassificationOperationMetadata text_classification_details = 9;
     * </code>
     *
     * @return Whether the textClassificationDetails field is set.
     */
    @java.lang.Override
    public boolean hasTextClassificationDetails() {
      return detailsCase_ == 9;
    }
    /**
     *
     *
     * <pre>
     * Details of label text classification operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelTextClassificationOperationMetadata text_classification_details = 9;
     * </code>
     *
     * @return The textClassificationDetails.
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.LabelTextClassificationOperationMetadata
        getTextClassificationDetails() {
      if (textClassificationDetailsBuilder_ == null) {
        if (detailsCase_ == 9) {
          return (com.google.cloud.datalabeling.v1beta1.LabelTextClassificationOperationMetadata)
              details_;
        }
        return com.google.cloud.datalabeling.v1beta1.LabelTextClassificationOperationMetadata
            .getDefaultInstance();
      } else {
        if (detailsCase_ == 9) {
          return textClassificationDetailsBuilder_.getMessage();
        }
        return com.google.cloud.datalabeling.v1beta1.LabelTextClassificationOperationMetadata
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Details of label text classification operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelTextClassificationOperationMetadata text_classification_details = 9;
     * </code>
     */
    public Builder setTextClassificationDetails(
        com.google.cloud.datalabeling.v1beta1.LabelTextClassificationOperationMetadata value) {
      if (textClassificationDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        details_ = value;
        onChanged();
      } else {
        textClassificationDetailsBuilder_.setMessage(value);
      }
      detailsCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of label text classification operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelTextClassificationOperationMetadata text_classification_details = 9;
     * </code>
     */
    public Builder setTextClassificationDetails(
        com.google.cloud.datalabeling.v1beta1.LabelTextClassificationOperationMetadata.Builder
            builderForValue) {
      if (textClassificationDetailsBuilder_ == null) {
        details_ = builderForValue.build();
        onChanged();
      } else {
        textClassificationDetailsBuilder_.setMessage(builderForValue.build());
      }
      detailsCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of label text classification operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelTextClassificationOperationMetadata text_classification_details = 9;
     * </code>
     */
    public Builder mergeTextClassificationDetails(
        com.google.cloud.datalabeling.v1beta1.LabelTextClassificationOperationMetadata value) {
      if (textClassificationDetailsBuilder_ == null) {
        if (detailsCase_ == 9
            && details_
                != com.google.cloud.datalabeling.v1beta1.LabelTextClassificationOperationMetadata
                    .getDefaultInstance()) {
          details_ =
              com.google.cloud.datalabeling.v1beta1.LabelTextClassificationOperationMetadata
                  .newBuilder(
                      (com.google.cloud.datalabeling.v1beta1
                              .LabelTextClassificationOperationMetadata)
                          details_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          details_ = value;
        }
        onChanged();
      } else {
        if (detailsCase_ == 9) {
          textClassificationDetailsBuilder_.mergeFrom(value);
        } else {
          textClassificationDetailsBuilder_.setMessage(value);
        }
      }
      detailsCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of label text classification operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelTextClassificationOperationMetadata text_classification_details = 9;
     * </code>
     */
    public Builder clearTextClassificationDetails() {
      if (textClassificationDetailsBuilder_ == null) {
        if (detailsCase_ == 9) {
          detailsCase_ = 0;
          details_ = null;
          onChanged();
        }
      } else {
        if (detailsCase_ == 9) {
          detailsCase_ = 0;
          details_ = null;
        }
        textClassificationDetailsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of label text classification operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelTextClassificationOperationMetadata text_classification_details = 9;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.LabelTextClassificationOperationMetadata.Builder
        getTextClassificationDetailsBuilder() {
      return getTextClassificationDetailsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Details of label text classification operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelTextClassificationOperationMetadata text_classification_details = 9;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.LabelTextClassificationOperationMetadataOrBuilder
        getTextClassificationDetailsOrBuilder() {
      if ((detailsCase_ == 9) && (textClassificationDetailsBuilder_ != null)) {
        return textClassificationDetailsBuilder_.getMessageOrBuilder();
      } else {
        if (detailsCase_ == 9) {
          return (com.google.cloud.datalabeling.v1beta1.LabelTextClassificationOperationMetadata)
              details_;
        }
        return com.google.cloud.datalabeling.v1beta1.LabelTextClassificationOperationMetadata
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Details of label text classification operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelTextClassificationOperationMetadata text_classification_details = 9;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.LabelTextClassificationOperationMetadata,
            com.google.cloud.datalabeling.v1beta1.LabelTextClassificationOperationMetadata.Builder,
            com.google.cloud.datalabeling.v1beta1.LabelTextClassificationOperationMetadataOrBuilder>
        getTextClassificationDetailsFieldBuilder() {
      if (textClassificationDetailsBuilder_ == null) {
        if (!(detailsCase_ == 9)) {
          details_ =
              com.google.cloud.datalabeling.v1beta1.LabelTextClassificationOperationMetadata
                  .getDefaultInstance();
        }
        textClassificationDetailsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.LabelTextClassificationOperationMetadata,
                com.google.cloud.datalabeling.v1beta1.LabelTextClassificationOperationMetadata
                    .Builder,
                com.google.cloud.datalabeling.v1beta1
                    .LabelTextClassificationOperationMetadataOrBuilder>(
                (com.google.cloud.datalabeling.v1beta1.LabelTextClassificationOperationMetadata)
                    details_,
                getParentForChildren(),
                isClean());
        details_ = null;
      }
      detailsCase_ = 9;
      onChanged();
      ;
      return textClassificationDetailsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.LabelTextEntityExtractionOperationMetadata,
            com.google.cloud.datalabeling.v1beta1.LabelTextEntityExtractionOperationMetadata
                .Builder,
            com.google.cloud.datalabeling.v1beta1
                .LabelTextEntityExtractionOperationMetadataOrBuilder>
        textEntityExtractionDetailsBuilder_;
    /**
     *
     *
     * <pre>
     * Details of label text entity extraction operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelTextEntityExtractionOperationMetadata text_entity_extraction_details = 13;
     * </code>
     *
     * @return Whether the textEntityExtractionDetails field is set.
     */
    @java.lang.Override
    public boolean hasTextEntityExtractionDetails() {
      return detailsCase_ == 13;
    }
    /**
     *
     *
     * <pre>
     * Details of label text entity extraction operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelTextEntityExtractionOperationMetadata text_entity_extraction_details = 13;
     * </code>
     *
     * @return The textEntityExtractionDetails.
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.LabelTextEntityExtractionOperationMetadata
        getTextEntityExtractionDetails() {
      if (textEntityExtractionDetailsBuilder_ == null) {
        if (detailsCase_ == 13) {
          return (com.google.cloud.datalabeling.v1beta1.LabelTextEntityExtractionOperationMetadata)
              details_;
        }
        return com.google.cloud.datalabeling.v1beta1.LabelTextEntityExtractionOperationMetadata
            .getDefaultInstance();
      } else {
        if (detailsCase_ == 13) {
          return textEntityExtractionDetailsBuilder_.getMessage();
        }
        return com.google.cloud.datalabeling.v1beta1.LabelTextEntityExtractionOperationMetadata
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Details of label text entity extraction operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelTextEntityExtractionOperationMetadata text_entity_extraction_details = 13;
     * </code>
     */
    public Builder setTextEntityExtractionDetails(
        com.google.cloud.datalabeling.v1beta1.LabelTextEntityExtractionOperationMetadata value) {
      if (textEntityExtractionDetailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        details_ = value;
        onChanged();
      } else {
        textEntityExtractionDetailsBuilder_.setMessage(value);
      }
      detailsCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of label text entity extraction operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelTextEntityExtractionOperationMetadata text_entity_extraction_details = 13;
     * </code>
     */
    public Builder setTextEntityExtractionDetails(
        com.google.cloud.datalabeling.v1beta1.LabelTextEntityExtractionOperationMetadata.Builder
            builderForValue) {
      if (textEntityExtractionDetailsBuilder_ == null) {
        details_ = builderForValue.build();
        onChanged();
      } else {
        textEntityExtractionDetailsBuilder_.setMessage(builderForValue.build());
      }
      detailsCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of label text entity extraction operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelTextEntityExtractionOperationMetadata text_entity_extraction_details = 13;
     * </code>
     */
    public Builder mergeTextEntityExtractionDetails(
        com.google.cloud.datalabeling.v1beta1.LabelTextEntityExtractionOperationMetadata value) {
      if (textEntityExtractionDetailsBuilder_ == null) {
        if (detailsCase_ == 13
            && details_
                != com.google.cloud.datalabeling.v1beta1.LabelTextEntityExtractionOperationMetadata
                    .getDefaultInstance()) {
          details_ =
              com.google.cloud.datalabeling.v1beta1.LabelTextEntityExtractionOperationMetadata
                  .newBuilder(
                      (com.google.cloud.datalabeling.v1beta1
                              .LabelTextEntityExtractionOperationMetadata)
                          details_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          details_ = value;
        }
        onChanged();
      } else {
        if (detailsCase_ == 13) {
          textEntityExtractionDetailsBuilder_.mergeFrom(value);
        } else {
          textEntityExtractionDetailsBuilder_.setMessage(value);
        }
      }
      detailsCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of label text entity extraction operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelTextEntityExtractionOperationMetadata text_entity_extraction_details = 13;
     * </code>
     */
    public Builder clearTextEntityExtractionDetails() {
      if (textEntityExtractionDetailsBuilder_ == null) {
        if (detailsCase_ == 13) {
          detailsCase_ = 0;
          details_ = null;
          onChanged();
        }
      } else {
        if (detailsCase_ == 13) {
          detailsCase_ = 0;
          details_ = null;
        }
        textEntityExtractionDetailsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Details of label text entity extraction operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelTextEntityExtractionOperationMetadata text_entity_extraction_details = 13;
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.LabelTextEntityExtractionOperationMetadata.Builder
        getTextEntityExtractionDetailsBuilder() {
      return getTextEntityExtractionDetailsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Details of label text entity extraction operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelTextEntityExtractionOperationMetadata text_entity_extraction_details = 13;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.LabelTextEntityExtractionOperationMetadataOrBuilder
        getTextEntityExtractionDetailsOrBuilder() {
      if ((detailsCase_ == 13) && (textEntityExtractionDetailsBuilder_ != null)) {
        return textEntityExtractionDetailsBuilder_.getMessageOrBuilder();
      } else {
        if (detailsCase_ == 13) {
          return (com.google.cloud.datalabeling.v1beta1.LabelTextEntityExtractionOperationMetadata)
              details_;
        }
        return com.google.cloud.datalabeling.v1beta1.LabelTextEntityExtractionOperationMetadata
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Details of label text entity extraction operation.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.LabelTextEntityExtractionOperationMetadata text_entity_extraction_details = 13;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.LabelTextEntityExtractionOperationMetadata,
            com.google.cloud.datalabeling.v1beta1.LabelTextEntityExtractionOperationMetadata
                .Builder,
            com.google.cloud.datalabeling.v1beta1
                .LabelTextEntityExtractionOperationMetadataOrBuilder>
        getTextEntityExtractionDetailsFieldBuilder() {
      if (textEntityExtractionDetailsBuilder_ == null) {
        if (!(detailsCase_ == 13)) {
          details_ =
              com.google.cloud.datalabeling.v1beta1.LabelTextEntityExtractionOperationMetadata
                  .getDefaultInstance();
        }
        textEntityExtractionDetailsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.LabelTextEntityExtractionOperationMetadata,
                com.google.cloud.datalabeling.v1beta1.LabelTextEntityExtractionOperationMetadata
                    .Builder,
                com.google.cloud.datalabeling.v1beta1
                    .LabelTextEntityExtractionOperationMetadataOrBuilder>(
                (com.google.cloud.datalabeling.v1beta1.LabelTextEntityExtractionOperationMetadata)
                    details_,
                getParentForChildren(),
                isClean());
        details_ = null;
      }
      detailsCase_ = 13;
      onChanged();
      ;
      return textEntityExtractionDetailsBuilder_;
    }

    private int progressPercent_;
    /**
     *
     *
     * <pre>
     * Output only. Progress of label operation. Range: [0, 100].
     * </pre>
     *
     * <code>int32 progress_percent = 1;</code>
     *
     * @return The progressPercent.
     */
    @java.lang.Override
    public int getProgressPercent() {
      return progressPercent_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Progress of label operation. Range: [0, 100].
     * </pre>
     *
     * <code>int32 progress_percent = 1;</code>
     *
     * @param value The progressPercent to set.
     * @return This builder for chaining.
     */
    public Builder setProgressPercent(int value) {

      progressPercent_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Progress of label operation. Range: [0, 100].
     * </pre>
     *
     * <code>int32 progress_percent = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProgressPercent() {

      progressPercent_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.rpc.Status> partialFailures_ =
        java.util.Collections.emptyList();

    private void ensurePartialFailuresIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        partialFailures_ = new java.util.ArrayList<com.google.rpc.Status>(partialFailures_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        partialFailuresBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * E.g. single files that couldn't be read.
     * Status details field will contain standard GCP error details.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_failures = 2;</code>
     */
    public java.util.List<com.google.rpc.Status> getPartialFailuresList() {
      if (partialFailuresBuilder_ == null) {
        return java.util.Collections.unmodifiableList(partialFailures_);
      } else {
        return partialFailuresBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * E.g. single files that couldn't be read.
     * Status details field will contain standard GCP error details.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_failures = 2;</code>
     */
    public int getPartialFailuresCount() {
      if (partialFailuresBuilder_ == null) {
        return partialFailures_.size();
      } else {
        return partialFailuresBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * E.g. single files that couldn't be read.
     * Status details field will contain standard GCP error details.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_failures = 2;</code>
     */
    public com.google.rpc.Status getPartialFailures(int index) {
      if (partialFailuresBuilder_ == null) {
        return partialFailures_.get(index);
      } else {
        return partialFailuresBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * E.g. single files that couldn't be read.
     * Status details field will contain standard GCP error details.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_failures = 2;</code>
     */
    public Builder setPartialFailures(int index, com.google.rpc.Status value) {
      if (partialFailuresBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePartialFailuresIsMutable();
        partialFailures_.set(index, value);
        onChanged();
      } else {
        partialFailuresBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * E.g. single files that couldn't be read.
     * Status details field will contain standard GCP error details.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_failures = 2;</code>
     */
    public Builder setPartialFailures(int index, com.google.rpc.Status.Builder builderForValue) {
      if (partialFailuresBuilder_ == null) {
        ensurePartialFailuresIsMutable();
        partialFailures_.set(index, builderForValue.build());
        onChanged();
      } else {
        partialFailuresBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * E.g. single files that couldn't be read.
     * Status details field will contain standard GCP error details.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_failures = 2;</code>
     */
    public Builder addPartialFailures(com.google.rpc.Status value) {
      if (partialFailuresBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePartialFailuresIsMutable();
        partialFailures_.add(value);
        onChanged();
      } else {
        partialFailuresBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * E.g. single files that couldn't be read.
     * Status details field will contain standard GCP error details.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_failures = 2;</code>
     */
    public Builder addPartialFailures(int index, com.google.rpc.Status value) {
      if (partialFailuresBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePartialFailuresIsMutable();
        partialFailures_.add(index, value);
        onChanged();
      } else {
        partialFailuresBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * E.g. single files that couldn't be read.
     * Status details field will contain standard GCP error details.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_failures = 2;</code>
     */
    public Builder addPartialFailures(com.google.rpc.Status.Builder builderForValue) {
      if (partialFailuresBuilder_ == null) {
        ensurePartialFailuresIsMutable();
        partialFailures_.add(builderForValue.build());
        onChanged();
      } else {
        partialFailuresBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * E.g. single files that couldn't be read.
     * Status details field will contain standard GCP error details.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_failures = 2;</code>
     */
    public Builder addPartialFailures(int index, com.google.rpc.Status.Builder builderForValue) {
      if (partialFailuresBuilder_ == null) {
        ensurePartialFailuresIsMutable();
        partialFailures_.add(index, builderForValue.build());
        onChanged();
      } else {
        partialFailuresBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * E.g. single files that couldn't be read.
     * Status details field will contain standard GCP error details.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_failures = 2;</code>
     */
    public Builder addAllPartialFailures(
        java.lang.Iterable<? extends com.google.rpc.Status> values) {
      if (partialFailuresBuilder_ == null) {
        ensurePartialFailuresIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, partialFailures_);
        onChanged();
      } else {
        partialFailuresBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * E.g. single files that couldn't be read.
     * Status details field will contain standard GCP error details.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_failures = 2;</code>
     */
    public Builder clearPartialFailures() {
      if (partialFailuresBuilder_ == null) {
        partialFailures_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        partialFailuresBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * E.g. single files that couldn't be read.
     * Status details field will contain standard GCP error details.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_failures = 2;</code>
     */
    public Builder removePartialFailures(int index) {
      if (partialFailuresBuilder_ == null) {
        ensurePartialFailuresIsMutable();
        partialFailures_.remove(index);
        onChanged();
      } else {
        partialFailuresBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * E.g. single files that couldn't be read.
     * Status details field will contain standard GCP error details.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_failures = 2;</code>
     */
    public com.google.rpc.Status.Builder getPartialFailuresBuilder(int index) {
      return getPartialFailuresFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * E.g. single files that couldn't be read.
     * Status details field will contain standard GCP error details.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_failures = 2;</code>
     */
    public com.google.rpc.StatusOrBuilder getPartialFailuresOrBuilder(int index) {
      if (partialFailuresBuilder_ == null) {
        return partialFailures_.get(index);
      } else {
        return partialFailuresBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * E.g. single files that couldn't be read.
     * Status details field will contain standard GCP error details.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_failures = 2;</code>
     */
    public java.util.List<? extends com.google.rpc.StatusOrBuilder>
        getPartialFailuresOrBuilderList() {
      if (partialFailuresBuilder_ != null) {
        return partialFailuresBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(partialFailures_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * E.g. single files that couldn't be read.
     * Status details field will contain standard GCP error details.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_failures = 2;</code>
     */
    public com.google.rpc.Status.Builder addPartialFailuresBuilder() {
      return getPartialFailuresFieldBuilder()
          .addBuilder(com.google.rpc.Status.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * E.g. single files that couldn't be read.
     * Status details field will contain standard GCP error details.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_failures = 2;</code>
     */
    public com.google.rpc.Status.Builder addPartialFailuresBuilder(int index) {
      return getPartialFailuresFieldBuilder()
          .addBuilder(index, com.google.rpc.Status.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. Partial failures encountered.
     * E.g. single files that couldn't be read.
     * Status details field will contain standard GCP error details.
     * </pre>
     *
     * <code>repeated .google.rpc.Status partial_failures = 2;</code>
     */
    public java.util.List<com.google.rpc.Status.Builder> getPartialFailuresBuilderList() {
      return getPartialFailuresFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getPartialFailuresFieldBuilder() {
      if (partialFailuresBuilder_ == null) {
        partialFailuresBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(
                partialFailures_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        partialFailures_ = null;
      }
      return partialFailuresBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when labeling request was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 16;</code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return createTimeBuilder_ != null || createTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when labeling request was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 16;</code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when labeling request was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 16;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
        onChanged();
      } else {
        createTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when labeling request was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 16;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
        onChanged();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when labeling request was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 16;</code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (createTime_ != null) {
          createTime_ =
              com.google.protobuf.Timestamp.newBuilder(createTime_).mergeFrom(value).buildPartial();
        } else {
          createTime_ = value;
        }
        onChanged();
      } else {
        createTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when labeling request was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 16;</code>
     */
    public Builder clearCreateTime() {
      if (createTimeBuilder_ == null) {
        createTime_ = null;
        onChanged();
      } else {
        createTime_ = null;
        createTimeBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when labeling request was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 16;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {

      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when labeling request was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 16;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Timestamp when labeling request was created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 16;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datalabeling.v1beta1.LabelOperationMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datalabeling.v1beta1.LabelOperationMetadata)
  private static final com.google.cloud.datalabeling.v1beta1.LabelOperationMetadata
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datalabeling.v1beta1.LabelOperationMetadata();
  }

  public static com.google.cloud.datalabeling.v1beta1.LabelOperationMetadata getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<LabelOperationMetadata> PARSER =
      new com.google.protobuf.AbstractParser<LabelOperationMetadata>() {
        @java.lang.Override
        public LabelOperationMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new LabelOperationMetadata(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<LabelOperationMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<LabelOperationMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.LabelOperationMetadata getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
