/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datalabeling/v1beta1/human_annotation_config.proto

package com.google.cloud.datalabeling.v1beta1;

/**
 *
 *
 * <pre>
 * Config for video classification human labeling task.
 * Currently two types of video classification are supported:
 * 1. Assign labels on the entire video.
 * 2. Split the video into multiple video clips based on camera shot, and
 * assign labels on each video clip.
 * </pre>
 *
 * Protobuf type {@code google.cloud.datalabeling.v1beta1.VideoClassificationConfig}
 */
public final class VideoClassificationConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datalabeling.v1beta1.VideoClassificationConfig)
    VideoClassificationConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use VideoClassificationConfig.newBuilder() to construct.
  private VideoClassificationConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private VideoClassificationConfig() {
    annotationSpecSetConfigs_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new VideoClassificationConfig();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private VideoClassificationConfig(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                annotationSpecSetConfigs_ =
                    new java.util.ArrayList<
                        com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig
                            .AnnotationSpecSetConfig>();
                mutable_bitField0_ |= 0x00000001;
              }
              annotationSpecSetConfigs_.add(
                  input.readMessage(
                      com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig
                          .AnnotationSpecSetConfig.parser(),
                      extensionRegistry));
              break;
            }
          case 16:
            {
              applyShotDetection_ = input.readBool();
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        annotationSpecSetConfigs_ =
            java.util.Collections.unmodifiableList(annotationSpecSetConfigs_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfigOuterClass
        .internal_static_google_cloud_datalabeling_v1beta1_VideoClassificationConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfigOuterClass
        .internal_static_google_cloud_datalabeling_v1beta1_VideoClassificationConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.class,
            com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.Builder.class);
  }

  public interface AnnotationSpecSetConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Annotation spec set resource name.
     * </pre>
     *
     * <code>string annotation_spec_set = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The annotationSpecSet.
     */
    java.lang.String getAnnotationSpecSet();
    /**
     *
     *
     * <pre>
     * Required. Annotation spec set resource name.
     * </pre>
     *
     * <code>string annotation_spec_set = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for annotationSpecSet.
     */
    com.google.protobuf.ByteString getAnnotationSpecSetBytes();

    /**
     *
     *
     * <pre>
     * Optional. If allow_multi_label is true, contributors are able to
     * choose multiple labels from one annotation spec set.
     * </pre>
     *
     * <code>bool allow_multi_label = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The allowMultiLabel.
     */
    boolean getAllowMultiLabel();
  }
  /**
   *
   *
   * <pre>
   * Annotation spec set with the setting of allowing multi labels or not.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig}
   */
  public static final class AnnotationSpecSetConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig)
      AnnotationSpecSetConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use AnnotationSpecSetConfig.newBuilder() to construct.
    private AnnotationSpecSetConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AnnotationSpecSetConfig() {
      annotationSpecSet_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AnnotationSpecSetConfig();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private AnnotationSpecSetConfig(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();

                annotationSpecSet_ = s;
                break;
              }
            case 16:
              {
                allowMultiLabel_ = input.readBool();
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfigOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_VideoClassificationConfig_AnnotationSpecSetConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfigOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_VideoClassificationConfig_AnnotationSpecSetConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig
                  .AnnotationSpecSetConfig.class,
              com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig
                  .AnnotationSpecSetConfig.Builder.class);
    }

    public static final int ANNOTATION_SPEC_SET_FIELD_NUMBER = 1;
    private volatile java.lang.Object annotationSpecSet_;
    /**
     *
     *
     * <pre>
     * Required. Annotation spec set resource name.
     * </pre>
     *
     * <code>string annotation_spec_set = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The annotationSpecSet.
     */
    @java.lang.Override
    public java.lang.String getAnnotationSpecSet() {
      java.lang.Object ref = annotationSpecSet_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        annotationSpecSet_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Annotation spec set resource name.
     * </pre>
     *
     * <code>string annotation_spec_set = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for annotationSpecSet.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getAnnotationSpecSetBytes() {
      java.lang.Object ref = annotationSpecSet_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        annotationSpecSet_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ALLOW_MULTI_LABEL_FIELD_NUMBER = 2;
    private boolean allowMultiLabel_;
    /**
     *
     *
     * <pre>
     * Optional. If allow_multi_label is true, contributors are able to
     * choose multiple labels from one annotation spec set.
     * </pre>
     *
     * <code>bool allow_multi_label = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The allowMultiLabel.
     */
    @java.lang.Override
    public boolean getAllowMultiLabel() {
      return allowMultiLabel_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(annotationSpecSet_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, annotationSpecSet_);
      }
      if (allowMultiLabel_ != false) {
        output.writeBool(2, allowMultiLabel_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(annotationSpecSet_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, annotationSpecSet_);
      }
      if (allowMultiLabel_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, allowMultiLabel_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig
              .AnnotationSpecSetConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig
          other =
              (com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig
                      .AnnotationSpecSetConfig)
                  obj;

      if (!getAnnotationSpecSet().equals(other.getAnnotationSpecSet())) return false;
      if (getAllowMultiLabel() != other.getAllowMultiLabel()) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ANNOTATION_SPEC_SET_FIELD_NUMBER;
      hash = (53 * hash) + getAnnotationSpecSet().hashCode();
      hash = (37 * hash) + ALLOW_MULTI_LABEL_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAllowMultiLabel());
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig
            .AnnotationSpecSetConfig
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig
            .AnnotationSpecSetConfig
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig
            .AnnotationSpecSetConfig
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig
            .AnnotationSpecSetConfig
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig
            .AnnotationSpecSetConfig
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig
            .AnnotationSpecSetConfig
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig
            .AnnotationSpecSetConfig
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig
            .AnnotationSpecSetConfig
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig
            .AnnotationSpecSetConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig
            .AnnotationSpecSetConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig
            .AnnotationSpecSetConfig
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig
            .AnnotationSpecSetConfig
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Annotation spec set with the setting of allowing multi labels or not.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig)
        com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig
            .AnnotationSpecSetConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfigOuterClass
            .internal_static_google_cloud_datalabeling_v1beta1_VideoClassificationConfig_AnnotationSpecSetConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfigOuterClass
            .internal_static_google_cloud_datalabeling_v1beta1_VideoClassificationConfig_AnnotationSpecSetConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig
                    .AnnotationSpecSetConfig.class,
                com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig
                    .AnnotationSpecSetConfig.Builder.class);
      }

      // Construct using
      // com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        annotationSpecSet_ = "";

        allowMultiLabel_ = false;

        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfigOuterClass
            .internal_static_google_cloud_datalabeling_v1beta1_VideoClassificationConfig_AnnotationSpecSetConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig
          getDefaultInstanceForType() {
        return com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig
            .AnnotationSpecSetConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig
          build() {
        com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig
          buildPartial() {
        com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig
            result =
                new com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig
                    .AnnotationSpecSetConfig(this);
        result.annotationSpecSet_ = annotationSpecSet_;
        result.allowMultiLabel_ = allowMultiLabel_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig
                .AnnotationSpecSetConfig) {
          return mergeFrom(
              (com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig
                      .AnnotationSpecSetConfig)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig
              other) {
        if (other
            == com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig
                .AnnotationSpecSetConfig.getDefaultInstance()) return this;
        if (!other.getAnnotationSpecSet().isEmpty()) {
          annotationSpecSet_ = other.annotationSpecSet_;
          onChanged();
        }
        if (other.getAllowMultiLabel() != false) {
          setAllowMultiLabel(other.getAllowMultiLabel());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig
            parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig
                      .AnnotationSpecSetConfig)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object annotationSpecSet_ = "";
      /**
       *
       *
       * <pre>
       * Required. Annotation spec set resource name.
       * </pre>
       *
       * <code>string annotation_spec_set = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The annotationSpecSet.
       */
      public java.lang.String getAnnotationSpecSet() {
        java.lang.Object ref = annotationSpecSet_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          annotationSpecSet_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Annotation spec set resource name.
       * </pre>
       *
       * <code>string annotation_spec_set = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for annotationSpecSet.
       */
      public com.google.protobuf.ByteString getAnnotationSpecSetBytes() {
        java.lang.Object ref = annotationSpecSet_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          annotationSpecSet_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Annotation spec set resource name.
       * </pre>
       *
       * <code>string annotation_spec_set = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The annotationSpecSet to set.
       * @return This builder for chaining.
       */
      public Builder setAnnotationSpecSet(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }

        annotationSpecSet_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Annotation spec set resource name.
       * </pre>
       *
       * <code>string annotation_spec_set = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAnnotationSpecSet() {

        annotationSpecSet_ = getDefaultInstance().getAnnotationSpecSet();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Annotation spec set resource name.
       * </pre>
       *
       * <code>string annotation_spec_set = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for annotationSpecSet to set.
       * @return This builder for chaining.
       */
      public Builder setAnnotationSpecSetBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);

        annotationSpecSet_ = value;
        onChanged();
        return this;
      }

      private boolean allowMultiLabel_;
      /**
       *
       *
       * <pre>
       * Optional. If allow_multi_label is true, contributors are able to
       * choose multiple labels from one annotation spec set.
       * </pre>
       *
       * <code>bool allow_multi_label = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The allowMultiLabel.
       */
      @java.lang.Override
      public boolean getAllowMultiLabel() {
        return allowMultiLabel_;
      }
      /**
       *
       *
       * <pre>
       * Optional. If allow_multi_label is true, contributors are able to
       * choose multiple labels from one annotation spec set.
       * </pre>
       *
       * <code>bool allow_multi_label = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The allowMultiLabel to set.
       * @return This builder for chaining.
       */
      public Builder setAllowMultiLabel(boolean value) {

        allowMultiLabel_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. If allow_multi_label is true, contributors are able to
       * choose multiple labels from one annotation spec set.
       * </pre>
       *
       * <code>bool allow_multi_label = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAllowMultiLabel() {

        allowMultiLabel_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig)
    private static final com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig
            .AnnotationSpecSetConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig
              .AnnotationSpecSetConfig();
    }

    public static com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig
            .AnnotationSpecSetConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AnnotationSpecSetConfig> PARSER =
        new com.google.protobuf.AbstractParser<AnnotationSpecSetConfig>() {
          @java.lang.Override
          public AnnotationSpecSetConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new AnnotationSpecSetConfig(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<AnnotationSpecSetConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AnnotationSpecSetConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int ANNOTATION_SPEC_SET_CONFIGS_FIELD_NUMBER = 1;
  private java.util.List<
          com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig>
      annotationSpecSetConfigs_;
  /**
   *
   *
   * <pre>
   * Required. The list of annotation spec set configs.
   * Since watching a video clip takes much longer time than an image, we
   * support label with multiple AnnotationSpecSet at the same time. Labels
   * in each AnnotationSpecSet will be shown in a group to contributors.
   * Contributors can select one or more (depending on whether to allow multi
   * label) from each group.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig annotation_spec_set_configs = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig>
      getAnnotationSpecSetConfigsList() {
    return annotationSpecSetConfigs_;
  }
  /**
   *
   *
   * <pre>
   * Required. The list of annotation spec set configs.
   * Since watching a video clip takes much longer time than an image, we
   * support label with multiple AnnotationSpecSet at the same time. Labels
   * in each AnnotationSpecSet will be shown in a group to contributors.
   * Contributors can select one or more (depending on whether to allow multi
   * label) from each group.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig annotation_spec_set_configs = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig
                  .AnnotationSpecSetConfigOrBuilder>
      getAnnotationSpecSetConfigsOrBuilderList() {
    return annotationSpecSetConfigs_;
  }
  /**
   *
   *
   * <pre>
   * Required. The list of annotation spec set configs.
   * Since watching a video clip takes much longer time than an image, we
   * support label with multiple AnnotationSpecSet at the same time. Labels
   * in each AnnotationSpecSet will be shown in a group to contributors.
   * Contributors can select one or more (depending on whether to allow multi
   * label) from each group.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig annotation_spec_set_configs = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getAnnotationSpecSetConfigsCount() {
    return annotationSpecSetConfigs_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. The list of annotation spec set configs.
   * Since watching a video clip takes much longer time than an image, we
   * support label with multiple AnnotationSpecSet at the same time. Labels
   * in each AnnotationSpecSet will be shown in a group to contributors.
   * Contributors can select one or more (depending on whether to allow multi
   * label) from each group.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig annotation_spec_set_configs = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig
      getAnnotationSpecSetConfigs(int index) {
    return annotationSpecSetConfigs_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. The list of annotation spec set configs.
   * Since watching a video clip takes much longer time than an image, we
   * support label with multiple AnnotationSpecSet at the same time. Labels
   * in each AnnotationSpecSet will be shown in a group to contributors.
   * Contributors can select one or more (depending on whether to allow multi
   * label) from each group.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig annotation_spec_set_configs = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig
          .AnnotationSpecSetConfigOrBuilder
      getAnnotationSpecSetConfigsOrBuilder(int index) {
    return annotationSpecSetConfigs_.get(index);
  }

  public static final int APPLY_SHOT_DETECTION_FIELD_NUMBER = 2;
  private boolean applyShotDetection_;
  /**
   *
   *
   * <pre>
   * Optional. Option to apply shot detection on the video.
   * </pre>
   *
   * <code>bool apply_shot_detection = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The applyShotDetection.
   */
  @java.lang.Override
  public boolean getApplyShotDetection() {
    return applyShotDetection_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < annotationSpecSetConfigs_.size(); i++) {
      output.writeMessage(1, annotationSpecSetConfigs_.get(i));
    }
    if (applyShotDetection_ != false) {
      output.writeBool(2, applyShotDetection_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < annotationSpecSetConfigs_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, annotationSpecSetConfigs_.get(i));
    }
    if (applyShotDetection_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, applyShotDetection_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig other =
        (com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig) obj;

    if (!getAnnotationSpecSetConfigsList().equals(other.getAnnotationSpecSetConfigsList()))
      return false;
    if (getApplyShotDetection() != other.getApplyShotDetection()) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getAnnotationSpecSetConfigsCount() > 0) {
      hash = (37 * hash) + ANNOTATION_SPEC_SET_CONFIGS_FIELD_NUMBER;
      hash = (53 * hash) + getAnnotationSpecSetConfigsList().hashCode();
    }
    hash = (37 * hash) + APPLY_SHOT_DETECTION_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getApplyShotDetection());
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Config for video classification human labeling task.
   * Currently two types of video classification are supported:
   * 1. Assign labels on the entire video.
   * 2. Split the video into multiple video clips based on camera shot, and
   * assign labels on each video clip.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datalabeling.v1beta1.VideoClassificationConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datalabeling.v1beta1.VideoClassificationConfig)
      com.google.cloud.datalabeling.v1beta1.VideoClassificationConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfigOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_VideoClassificationConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfigOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_VideoClassificationConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.class,
              com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.Builder.class);
    }

    // Construct using com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getAnnotationSpecSetConfigsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (annotationSpecSetConfigsBuilder_ == null) {
        annotationSpecSetConfigs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        annotationSpecSetConfigsBuilder_.clear();
      }
      applyShotDetection_ = false;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datalabeling.v1beta1.HumanAnnotationConfigOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_VideoClassificationConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig
        getDefaultInstanceForType() {
      return com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig build() {
      com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig buildPartial() {
      com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig result =
          new com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig(this);
      int from_bitField0_ = bitField0_;
      if (annotationSpecSetConfigsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          annotationSpecSetConfigs_ =
              java.util.Collections.unmodifiableList(annotationSpecSetConfigs_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.annotationSpecSetConfigs_ = annotationSpecSetConfigs_;
      } else {
        result.annotationSpecSetConfigs_ = annotationSpecSetConfigsBuilder_.build();
      }
      result.applyShotDetection_ = applyShotDetection_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig) {
        return mergeFrom((com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig other) {
      if (other
          == com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.getDefaultInstance())
        return this;
      if (annotationSpecSetConfigsBuilder_ == null) {
        if (!other.annotationSpecSetConfigs_.isEmpty()) {
          if (annotationSpecSetConfigs_.isEmpty()) {
            annotationSpecSetConfigs_ = other.annotationSpecSetConfigs_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureAnnotationSpecSetConfigsIsMutable();
            annotationSpecSetConfigs_.addAll(other.annotationSpecSetConfigs_);
          }
          onChanged();
        }
      } else {
        if (!other.annotationSpecSetConfigs_.isEmpty()) {
          if (annotationSpecSetConfigsBuilder_.isEmpty()) {
            annotationSpecSetConfigsBuilder_.dispose();
            annotationSpecSetConfigsBuilder_ = null;
            annotationSpecSetConfigs_ = other.annotationSpecSetConfigs_;
            bitField0_ = (bitField0_ & ~0x00000001);
            annotationSpecSetConfigsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAnnotationSpecSetConfigsFieldBuilder()
                    : null;
          } else {
            annotationSpecSetConfigsBuilder_.addAllMessages(other.annotationSpecSetConfigs_);
          }
        }
      }
      if (other.getApplyShotDetection() != false) {
        setApplyShotDetection(other.getApplyShotDetection());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig)
                e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.util.List<
            com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig>
        annotationSpecSetConfigs_ = java.util.Collections.emptyList();

    private void ensureAnnotationSpecSetConfigsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        annotationSpecSetConfigs_ =
            new java.util.ArrayList<
                com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig
                    .AnnotationSpecSetConfig>(annotationSpecSetConfigs_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig,
            com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig
                .Builder,
            com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig
                .AnnotationSpecSetConfigOrBuilder>
        annotationSpecSetConfigsBuilder_;

    /**
     *
     *
     * <pre>
     * Required. The list of annotation spec set configs.
     * Since watching a video clip takes much longer time than an image, we
     * support label with multiple AnnotationSpecSet at the same time. Labels
     * in each AnnotationSpecSet will be shown in a group to contributors.
     * Contributors can select one or more (depending on whether to allow multi
     * label) from each group.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig annotation_spec_set_configs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<
            com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig>
        getAnnotationSpecSetConfigsList() {
      if (annotationSpecSetConfigsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(annotationSpecSetConfigs_);
      } else {
        return annotationSpecSetConfigsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The list of annotation spec set configs.
     * Since watching a video clip takes much longer time than an image, we
     * support label with multiple AnnotationSpecSet at the same time. Labels
     * in each AnnotationSpecSet will be shown in a group to contributors.
     * Contributors can select one or more (depending on whether to allow multi
     * label) from each group.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig annotation_spec_set_configs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getAnnotationSpecSetConfigsCount() {
      if (annotationSpecSetConfigsBuilder_ == null) {
        return annotationSpecSetConfigs_.size();
      } else {
        return annotationSpecSetConfigsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The list of annotation spec set configs.
     * Since watching a video clip takes much longer time than an image, we
     * support label with multiple AnnotationSpecSet at the same time. Labels
     * in each AnnotationSpecSet will be shown in a group to contributors.
     * Contributors can select one or more (depending on whether to allow multi
     * label) from each group.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig annotation_spec_set_configs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig
        getAnnotationSpecSetConfigs(int index) {
      if (annotationSpecSetConfigsBuilder_ == null) {
        return annotationSpecSetConfigs_.get(index);
      } else {
        return annotationSpecSetConfigsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The list of annotation spec set configs.
     * Since watching a video clip takes much longer time than an image, we
     * support label with multiple AnnotationSpecSet at the same time. Labels
     * in each AnnotationSpecSet will be shown in a group to contributors.
     * Contributors can select one or more (depending on whether to allow multi
     * label) from each group.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig annotation_spec_set_configs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setAnnotationSpecSetConfigs(
        int index,
        com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig
            value) {
      if (annotationSpecSetConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAnnotationSpecSetConfigsIsMutable();
        annotationSpecSetConfigs_.set(index, value);
        onChanged();
      } else {
        annotationSpecSetConfigsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The list of annotation spec set configs.
     * Since watching a video clip takes much longer time than an image, we
     * support label with multiple AnnotationSpecSet at the same time. Labels
     * in each AnnotationSpecSet will be shown in a group to contributors.
     * Contributors can select one or more (depending on whether to allow multi
     * label) from each group.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig annotation_spec_set_configs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setAnnotationSpecSetConfigs(
        int index,
        com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig
                .Builder
            builderForValue) {
      if (annotationSpecSetConfigsBuilder_ == null) {
        ensureAnnotationSpecSetConfigsIsMutable();
        annotationSpecSetConfigs_.set(index, builderForValue.build());
        onChanged();
      } else {
        annotationSpecSetConfigsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The list of annotation spec set configs.
     * Since watching a video clip takes much longer time than an image, we
     * support label with multiple AnnotationSpecSet at the same time. Labels
     * in each AnnotationSpecSet will be shown in a group to contributors.
     * Contributors can select one or more (depending on whether to allow multi
     * label) from each group.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig annotation_spec_set_configs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAnnotationSpecSetConfigs(
        com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig
            value) {
      if (annotationSpecSetConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAnnotationSpecSetConfigsIsMutable();
        annotationSpecSetConfigs_.add(value);
        onChanged();
      } else {
        annotationSpecSetConfigsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The list of annotation spec set configs.
     * Since watching a video clip takes much longer time than an image, we
     * support label with multiple AnnotationSpecSet at the same time. Labels
     * in each AnnotationSpecSet will be shown in a group to contributors.
     * Contributors can select one or more (depending on whether to allow multi
     * label) from each group.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig annotation_spec_set_configs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAnnotationSpecSetConfigs(
        int index,
        com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig
            value) {
      if (annotationSpecSetConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAnnotationSpecSetConfigsIsMutable();
        annotationSpecSetConfigs_.add(index, value);
        onChanged();
      } else {
        annotationSpecSetConfigsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The list of annotation spec set configs.
     * Since watching a video clip takes much longer time than an image, we
     * support label with multiple AnnotationSpecSet at the same time. Labels
     * in each AnnotationSpecSet will be shown in a group to contributors.
     * Contributors can select one or more (depending on whether to allow multi
     * label) from each group.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig annotation_spec_set_configs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAnnotationSpecSetConfigs(
        com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig
                .Builder
            builderForValue) {
      if (annotationSpecSetConfigsBuilder_ == null) {
        ensureAnnotationSpecSetConfigsIsMutable();
        annotationSpecSetConfigs_.add(builderForValue.build());
        onChanged();
      } else {
        annotationSpecSetConfigsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The list of annotation spec set configs.
     * Since watching a video clip takes much longer time than an image, we
     * support label with multiple AnnotationSpecSet at the same time. Labels
     * in each AnnotationSpecSet will be shown in a group to contributors.
     * Contributors can select one or more (depending on whether to allow multi
     * label) from each group.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig annotation_spec_set_configs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAnnotationSpecSetConfigs(
        int index,
        com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig
                .Builder
            builderForValue) {
      if (annotationSpecSetConfigsBuilder_ == null) {
        ensureAnnotationSpecSetConfigsIsMutable();
        annotationSpecSetConfigs_.add(index, builderForValue.build());
        onChanged();
      } else {
        annotationSpecSetConfigsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The list of annotation spec set configs.
     * Since watching a video clip takes much longer time than an image, we
     * support label with multiple AnnotationSpecSet at the same time. Labels
     * in each AnnotationSpecSet will be shown in a group to contributors.
     * Contributors can select one or more (depending on whether to allow multi
     * label) from each group.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig annotation_spec_set_configs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllAnnotationSpecSetConfigs(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig
                        .AnnotationSpecSetConfig>
            values) {
      if (annotationSpecSetConfigsBuilder_ == null) {
        ensureAnnotationSpecSetConfigsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, annotationSpecSetConfigs_);
        onChanged();
      } else {
        annotationSpecSetConfigsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The list of annotation spec set configs.
     * Since watching a video clip takes much longer time than an image, we
     * support label with multiple AnnotationSpecSet at the same time. Labels
     * in each AnnotationSpecSet will be shown in a group to contributors.
     * Contributors can select one or more (depending on whether to allow multi
     * label) from each group.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig annotation_spec_set_configs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearAnnotationSpecSetConfigs() {
      if (annotationSpecSetConfigsBuilder_ == null) {
        annotationSpecSetConfigs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        annotationSpecSetConfigsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The list of annotation spec set configs.
     * Since watching a video clip takes much longer time than an image, we
     * support label with multiple AnnotationSpecSet at the same time. Labels
     * in each AnnotationSpecSet will be shown in a group to contributors.
     * Contributors can select one or more (depending on whether to allow multi
     * label) from each group.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig annotation_spec_set_configs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeAnnotationSpecSetConfigs(int index) {
      if (annotationSpecSetConfigsBuilder_ == null) {
        ensureAnnotationSpecSetConfigsIsMutable();
        annotationSpecSetConfigs_.remove(index);
        onChanged();
      } else {
        annotationSpecSetConfigsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The list of annotation spec set configs.
     * Since watching a video clip takes much longer time than an image, we
     * support label with multiple AnnotationSpecSet at the same time. Labels
     * in each AnnotationSpecSet will be shown in a group to contributors.
     * Contributors can select one or more (depending on whether to allow multi
     * label) from each group.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig annotation_spec_set_configs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig
            .Builder
        getAnnotationSpecSetConfigsBuilder(int index) {
      return getAnnotationSpecSetConfigsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Required. The list of annotation spec set configs.
     * Since watching a video clip takes much longer time than an image, we
     * support label with multiple AnnotationSpecSet at the same time. Labels
     * in each AnnotationSpecSet will be shown in a group to contributors.
     * Contributors can select one or more (depending on whether to allow multi
     * label) from each group.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig annotation_spec_set_configs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig
            .AnnotationSpecSetConfigOrBuilder
        getAnnotationSpecSetConfigsOrBuilder(int index) {
      if (annotationSpecSetConfigsBuilder_ == null) {
        return annotationSpecSetConfigs_.get(index);
      } else {
        return annotationSpecSetConfigsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The list of annotation spec set configs.
     * Since watching a video clip takes much longer time than an image, we
     * support label with multiple AnnotationSpecSet at the same time. Labels
     * in each AnnotationSpecSet will be shown in a group to contributors.
     * Contributors can select one or more (depending on whether to allow multi
     * label) from each group.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig annotation_spec_set_configs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig
                    .AnnotationSpecSetConfigOrBuilder>
        getAnnotationSpecSetConfigsOrBuilderList() {
      if (annotationSpecSetConfigsBuilder_ != null) {
        return annotationSpecSetConfigsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(annotationSpecSetConfigs_);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The list of annotation spec set configs.
     * Since watching a video clip takes much longer time than an image, we
     * support label with multiple AnnotationSpecSet at the same time. Labels
     * in each AnnotationSpecSet will be shown in a group to contributors.
     * Contributors can select one or more (depending on whether to allow multi
     * label) from each group.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig annotation_spec_set_configs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig
            .Builder
        addAnnotationSpecSetConfigsBuilder() {
      return getAnnotationSpecSetConfigsFieldBuilder()
          .addBuilder(
              com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig
                  .AnnotationSpecSetConfig.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. The list of annotation spec set configs.
     * Since watching a video clip takes much longer time than an image, we
     * support label with multiple AnnotationSpecSet at the same time. Labels
     * in each AnnotationSpecSet will be shown in a group to contributors.
     * Contributors can select one or more (depending on whether to allow multi
     * label) from each group.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig annotation_spec_set_configs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig
            .Builder
        addAnnotationSpecSetConfigsBuilder(int index) {
      return getAnnotationSpecSetConfigsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig
                  .AnnotationSpecSetConfig.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. The list of annotation spec set configs.
     * Since watching a video clip takes much longer time than an image, we
     * support label with multiple AnnotationSpecSet at the same time. Labels
     * in each AnnotationSpecSet will be shown in a group to contributors.
     * Contributors can select one or more (depending on whether to allow multi
     * label) from each group.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig annotation_spec_set_configs = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<
            com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig
                .Builder>
        getAnnotationSpecSetConfigsBuilderList() {
      return getAnnotationSpecSetConfigsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig,
            com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig.AnnotationSpecSetConfig
                .Builder,
            com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig
                .AnnotationSpecSetConfigOrBuilder>
        getAnnotationSpecSetConfigsFieldBuilder() {
      if (annotationSpecSetConfigsBuilder_ == null) {
        annotationSpecSetConfigsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig
                    .AnnotationSpecSetConfig,
                com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig
                    .AnnotationSpecSetConfig.Builder,
                com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig
                    .AnnotationSpecSetConfigOrBuilder>(
                annotationSpecSetConfigs_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        annotationSpecSetConfigs_ = null;
      }
      return annotationSpecSetConfigsBuilder_;
    }

    private boolean applyShotDetection_;
    /**
     *
     *
     * <pre>
     * Optional. Option to apply shot detection on the video.
     * </pre>
     *
     * <code>bool apply_shot_detection = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The applyShotDetection.
     */
    @java.lang.Override
    public boolean getApplyShotDetection() {
      return applyShotDetection_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Option to apply shot detection on the video.
     * </pre>
     *
     * <code>bool apply_shot_detection = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The applyShotDetection to set.
     * @return This builder for chaining.
     */
    public Builder setApplyShotDetection(boolean value) {

      applyShotDetection_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Option to apply shot detection on the video.
     * </pre>
     *
     * <code>bool apply_shot_detection = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearApplyShotDetection() {

      applyShotDetection_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datalabeling.v1beta1.VideoClassificationConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datalabeling.v1beta1.VideoClassificationConfig)
  private static final com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig();
  }

  public static com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<VideoClassificationConfig> PARSER =
      new com.google.protobuf.AbstractParser<VideoClassificationConfig>() {
        @java.lang.Override
        public VideoClassificationConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new VideoClassificationConfig(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<VideoClassificationConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<VideoClassificationConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.VideoClassificationConfig
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
