/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datalabeling.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AnnotatedDatasetName
implements ResourceName {
    private static final PathTemplate PROJECT_DATASET_ANNOTATED_DATASET = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/datasets/{dataset}/annotatedDatasets/{annotated_dataset}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String dataset;
    private final String annotatedDataset;

    @Deprecated
    protected AnnotatedDatasetName() {
        this.project = null;
        this.dataset = null;
        this.annotatedDataset = null;
    }

    private AnnotatedDatasetName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.dataset = (String)Preconditions.checkNotNull((Object)builder.getDataset());
        this.annotatedDataset = (String)Preconditions.checkNotNull((Object)builder.getAnnotatedDataset());
    }

    public String getProject() {
        return this.project;
    }

    public String getDataset() {
        return this.dataset;
    }

    public String getAnnotatedDataset() {
        return this.annotatedDataset;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AnnotatedDatasetName of(String project, String dataset, String annotatedDataset) {
        return AnnotatedDatasetName.newBuilder().setProject(project).setDataset(dataset).setAnnotatedDataset(annotatedDataset).build();
    }

    public static String format(String project, String dataset, String annotatedDataset) {
        return AnnotatedDatasetName.newBuilder().setProject(project).setDataset(dataset).setAnnotatedDataset(annotatedDataset).build().toString();
    }

    public static AnnotatedDatasetName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_DATASET_ANNOTATED_DATASET.validatedMatch(formattedString, "AnnotatedDatasetName.parse: formattedString not in valid format");
        return AnnotatedDatasetName.of((String)matchMap.get("project"), (String)matchMap.get("dataset"), (String)matchMap.get("annotated_dataset"));
    }

    public static List<AnnotatedDatasetName> parseList(List<String> formattedStrings) {
        ArrayList<AnnotatedDatasetName> list = new ArrayList<AnnotatedDatasetName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AnnotatedDatasetName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AnnotatedDatasetName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AnnotatedDatasetName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_DATASET_ANNOTATED_DATASET.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AnnotatedDatasetName annotatedDatasetName = this;
            synchronized (annotatedDatasetName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.dataset != null) {
                        fieldMapBuilder.put((Object)"dataset", (Object)this.dataset);
                    }
                    if (this.annotatedDataset != null) {
                        fieldMapBuilder.put((Object)"annotated_dataset", (Object)this.annotatedDataset);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_DATASET_ANNOTATED_DATASET.instantiate(new String[]{"project", this.project, "dataset", this.dataset, "annotated_dataset", this.annotatedDataset});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            AnnotatedDatasetName that = (AnnotatedDatasetName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.dataset, that.dataset) && Objects.equals(this.annotatedDataset, that.annotatedDataset);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.dataset);
        h *= 1000003;
        return h ^= Objects.hashCode(this.annotatedDataset);
    }

    public static class Builder {
        private String project;
        private String dataset;
        private String annotatedDataset;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getDataset() {
            return this.dataset;
        }

        public String getAnnotatedDataset() {
            return this.annotatedDataset;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setDataset(String dataset) {
            this.dataset = dataset;
            return this;
        }

        public Builder setAnnotatedDataset(String annotatedDataset) {
            this.annotatedDataset = annotatedDataset;
            return this;
        }

        private Builder(AnnotatedDatasetName annotatedDatasetName) {
            this.project = annotatedDatasetName.project;
            this.dataset = annotatedDatasetName.dataset;
            this.annotatedDataset = annotatedDatasetName.annotatedDataset;
        }

        public AnnotatedDatasetName build() {
            return new AnnotatedDatasetName(this);
        }
    }
}

