/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/datalabeling/v1beta1/instruction.proto

package com.google.cloud.datalabeling.v1beta1;

/**
 *
 *
 * <pre>
 * Instruction of how to perform the labeling task for human operators.
 * Currently only PDF instruction is supported.
 * </pre>
 *
 * Protobuf type {@code google.cloud.datalabeling.v1beta1.Instruction}
 */
public final class Instruction extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.datalabeling.v1beta1.Instruction)
    InstructionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Instruction.newBuilder() to construct.
  private Instruction(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Instruction() {
    name_ = "";
    displayName_ = "";
    description_ = "";
    dataType_ = 0;
    blockingResources_ = com.google.protobuf.LazyStringArrayList.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Instruction();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.datalabeling.v1beta1.InstructionOuterClass
        .internal_static_google_cloud_datalabeling_v1beta1_Instruction_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.datalabeling.v1beta1.InstructionOuterClass
        .internal_static_google_cloud_datalabeling_v1beta1_Instruction_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.datalabeling.v1beta1.Instruction.class,
            com.google.cloud.datalabeling.v1beta1.Instruction.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Instruction resource name, format:
   * projects/{project_id}/instructions/{instruction_id}
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Instruction resource name, format:
   * projects/{project_id}/instructions/{instruction_id}
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Required. The display name of the instruction. Maximum of 64 characters.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The display name of the instruction. Maximum of 64 characters.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Optional. User-provided description of the instruction.
   * The description can be up to 10000 characters long.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. User-provided description of the instruction.
   * The description can be up to 10000 characters long.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. Creation time of instruction.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4;</code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Creation time of instruction.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4;</code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Creation time of instruction.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * Output only. Last update time of instruction.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5;</code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Last update time of instruction.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5;</code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Last update time of instruction.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int DATA_TYPE_FIELD_NUMBER = 6;
  private int dataType_ = 0;
  /**
   *
   *
   * <pre>
   * Required. The data type of this instruction.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.DataType data_type = 6;</code>
   *
   * @return The enum numeric value on the wire for dataType.
   */
  @java.lang.Override
  public int getDataTypeValue() {
    return dataType_;
  }
  /**
   *
   *
   * <pre>
   * Required. The data type of this instruction.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.DataType data_type = 6;</code>
   *
   * @return The dataType.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.DataType getDataType() {
    com.google.cloud.datalabeling.v1beta1.DataType result =
        com.google.cloud.datalabeling.v1beta1.DataType.forNumber(dataType_);
    return result == null ? com.google.cloud.datalabeling.v1beta1.DataType.UNRECOGNIZED : result;
  }

  public static final int CSV_INSTRUCTION_FIELD_NUMBER = 7;
  private com.google.cloud.datalabeling.v1beta1.CsvInstruction csvInstruction_;
  /**
   *
   *
   * <pre>
   * Deprecated: this instruction format is not supported any more.
   * Instruction from a CSV file, such as for classification task.
   * The CSV file should have exact two columns, in the following format:
   * * The first column is labeled data, such as an image reference, text.
   * * The second column is comma separated labels associated with data.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.CsvInstruction csv_instruction = 7 [deprecated = true];
   * </code>
   *
   * @deprecated google.cloud.datalabeling.v1beta1.Instruction.csv_instruction is deprecated. See
   *     google/cloud/datalabeling/v1beta1/instruction.proto;l=64
   * @return Whether the csvInstruction field is set.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean hasCsvInstruction() {
    return csvInstruction_ != null;
  }
  /**
   *
   *
   * <pre>
   * Deprecated: this instruction format is not supported any more.
   * Instruction from a CSV file, such as for classification task.
   * The CSV file should have exact two columns, in the following format:
   * * The first column is labeled data, such as an image reference, text.
   * * The second column is comma separated labels associated with data.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.CsvInstruction csv_instruction = 7 [deprecated = true];
   * </code>
   *
   * @deprecated google.cloud.datalabeling.v1beta1.Instruction.csv_instruction is deprecated. See
   *     google/cloud/datalabeling/v1beta1/instruction.proto;l=64
   * @return The csvInstruction.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.datalabeling.v1beta1.CsvInstruction getCsvInstruction() {
    return csvInstruction_ == null
        ? com.google.cloud.datalabeling.v1beta1.CsvInstruction.getDefaultInstance()
        : csvInstruction_;
  }
  /**
   *
   *
   * <pre>
   * Deprecated: this instruction format is not supported any more.
   * Instruction from a CSV file, such as for classification task.
   * The CSV file should have exact two columns, in the following format:
   * * The first column is labeled data, such as an image reference, text.
   * * The second column is comma separated labels associated with data.
   * </pre>
   *
   * <code>
   * .google.cloud.datalabeling.v1beta1.CsvInstruction csv_instruction = 7 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.datalabeling.v1beta1.CsvInstructionOrBuilder
      getCsvInstructionOrBuilder() {
    return csvInstruction_ == null
        ? com.google.cloud.datalabeling.v1beta1.CsvInstruction.getDefaultInstance()
        : csvInstruction_;
  }

  public static final int PDF_INSTRUCTION_FIELD_NUMBER = 9;
  private com.google.cloud.datalabeling.v1beta1.PdfInstruction pdfInstruction_;
  /**
   *
   *
   * <pre>
   * Instruction from a PDF document. The PDF should be in a Cloud Storage
   * bucket.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.PdfInstruction pdf_instruction = 9;</code>
   *
   * @return Whether the pdfInstruction field is set.
   */
  @java.lang.Override
  public boolean hasPdfInstruction() {
    return pdfInstruction_ != null;
  }
  /**
   *
   *
   * <pre>
   * Instruction from a PDF document. The PDF should be in a Cloud Storage
   * bucket.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.PdfInstruction pdf_instruction = 9;</code>
   *
   * @return The pdfInstruction.
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.PdfInstruction getPdfInstruction() {
    return pdfInstruction_ == null
        ? com.google.cloud.datalabeling.v1beta1.PdfInstruction.getDefaultInstance()
        : pdfInstruction_;
  }
  /**
   *
   *
   * <pre>
   * Instruction from a PDF document. The PDF should be in a Cloud Storage
   * bucket.
   * </pre>
   *
   * <code>.google.cloud.datalabeling.v1beta1.PdfInstruction pdf_instruction = 9;</code>
   */
  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.PdfInstructionOrBuilder
      getPdfInstructionOrBuilder() {
    return pdfInstruction_ == null
        ? com.google.cloud.datalabeling.v1beta1.PdfInstruction.getDefaultInstance()
        : pdfInstruction_;
  }

  public static final int BLOCKING_RESOURCES_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringList blockingResources_;
  /**
   *
   *
   * <pre>
   * Output only. The names of any related resources that are blocking changes
   * to the instruction.
   * </pre>
   *
   * <code>repeated string blocking_resources = 10;</code>
   *
   * @return A list containing the blockingResources.
   */
  public com.google.protobuf.ProtocolStringList getBlockingResourcesList() {
    return blockingResources_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The names of any related resources that are blocking changes
   * to the instruction.
   * </pre>
   *
   * <code>repeated string blocking_resources = 10;</code>
   *
   * @return The count of blockingResources.
   */
  public int getBlockingResourcesCount() {
    return blockingResources_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The names of any related resources that are blocking changes
   * to the instruction.
   * </pre>
   *
   * <code>repeated string blocking_resources = 10;</code>
   *
   * @param index The index of the element to return.
   * @return The blockingResources at the given index.
   */
  public java.lang.String getBlockingResources(int index) {
    return blockingResources_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. The names of any related resources that are blocking changes
   * to the instruction.
   * </pre>
   *
   * <code>repeated string blocking_resources = 10;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the blockingResources at the given index.
   */
  public com.google.protobuf.ByteString getBlockingResourcesBytes(int index) {
    return blockingResources_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, description_);
    }
    if (createTime_ != null) {
      output.writeMessage(4, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(5, getUpdateTime());
    }
    if (dataType_
        != com.google.cloud.datalabeling.v1beta1.DataType.DATA_TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(6, dataType_);
    }
    if (csvInstruction_ != null) {
      output.writeMessage(7, getCsvInstruction());
    }
    if (pdfInstruction_ != null) {
      output.writeMessage(9, getPdfInstruction());
    }
    for (int i = 0; i < blockingResources_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, blockingResources_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, description_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getUpdateTime());
    }
    if (dataType_
        != com.google.cloud.datalabeling.v1beta1.DataType.DATA_TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, dataType_);
    }
    if (csvInstruction_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getCsvInstruction());
    }
    if (pdfInstruction_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getPdfInstruction());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < blockingResources_.size(); i++) {
        dataSize += computeStringSizeNoTag(blockingResources_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getBlockingResourcesList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.datalabeling.v1beta1.Instruction)) {
      return super.equals(obj);
    }
    com.google.cloud.datalabeling.v1beta1.Instruction other =
        (com.google.cloud.datalabeling.v1beta1.Instruction) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (dataType_ != other.dataType_) return false;
    if (hasCsvInstruction() != other.hasCsvInstruction()) return false;
    if (hasCsvInstruction()) {
      if (!getCsvInstruction().equals(other.getCsvInstruction())) return false;
    }
    if (hasPdfInstruction() != other.hasPdfInstruction()) return false;
    if (hasPdfInstruction()) {
      if (!getPdfInstruction().equals(other.getPdfInstruction())) return false;
    }
    if (!getBlockingResourcesList().equals(other.getBlockingResourcesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + DATA_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + dataType_;
    if (hasCsvInstruction()) {
      hash = (37 * hash) + CSV_INSTRUCTION_FIELD_NUMBER;
      hash = (53 * hash) + getCsvInstruction().hashCode();
    }
    if (hasPdfInstruction()) {
      hash = (37 * hash) + PDF_INSTRUCTION_FIELD_NUMBER;
      hash = (53 * hash) + getPdfInstruction().hashCode();
    }
    if (getBlockingResourcesCount() > 0) {
      hash = (37 * hash) + BLOCKING_RESOURCES_FIELD_NUMBER;
      hash = (53 * hash) + getBlockingResourcesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.datalabeling.v1beta1.Instruction parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.Instruction parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.Instruction parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.Instruction parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.Instruction parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.datalabeling.v1beta1.Instruction parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.Instruction parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.Instruction parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.Instruction parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.Instruction parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.datalabeling.v1beta1.Instruction parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.datalabeling.v1beta1.Instruction parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.datalabeling.v1beta1.Instruction prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Instruction of how to perform the labeling task for human operators.
   * Currently only PDF instruction is supported.
   * </pre>
   *
   * Protobuf type {@code google.cloud.datalabeling.v1beta1.Instruction}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.datalabeling.v1beta1.Instruction)
      com.google.cloud.datalabeling.v1beta1.InstructionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.datalabeling.v1beta1.InstructionOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_Instruction_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.datalabeling.v1beta1.InstructionOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_Instruction_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.datalabeling.v1beta1.Instruction.class,
              com.google.cloud.datalabeling.v1beta1.Instruction.Builder.class);
    }

    // Construct using com.google.cloud.datalabeling.v1beta1.Instruction.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      description_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      dataType_ = 0;
      csvInstruction_ = null;
      if (csvInstructionBuilder_ != null) {
        csvInstructionBuilder_.dispose();
        csvInstructionBuilder_ = null;
      }
      pdfInstruction_ = null;
      if (pdfInstructionBuilder_ != null) {
        pdfInstructionBuilder_.dispose();
        pdfInstructionBuilder_ = null;
      }
      blockingResources_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000100);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.datalabeling.v1beta1.InstructionOuterClass
          .internal_static_google_cloud_datalabeling_v1beta1_Instruction_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.Instruction getDefaultInstanceForType() {
      return com.google.cloud.datalabeling.v1beta1.Instruction.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.Instruction build() {
      com.google.cloud.datalabeling.v1beta1.Instruction result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.Instruction buildPartial() {
      com.google.cloud.datalabeling.v1beta1.Instruction result =
          new com.google.cloud.datalabeling.v1beta1.Instruction(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.datalabeling.v1beta1.Instruction result) {
      if (((bitField0_ & 0x00000100) != 0)) {
        blockingResources_ = blockingResources_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000100);
      }
      result.blockingResources_ = blockingResources_;
    }

    private void buildPartial0(com.google.cloud.datalabeling.v1beta1.Instruction result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.dataType_ = dataType_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.csvInstruction_ =
            csvInstructionBuilder_ == null ? csvInstruction_ : csvInstructionBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.pdfInstruction_ =
            pdfInstructionBuilder_ == null ? pdfInstruction_ : pdfInstructionBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.datalabeling.v1beta1.Instruction) {
        return mergeFrom((com.google.cloud.datalabeling.v1beta1.Instruction) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.datalabeling.v1beta1.Instruction other) {
      if (other == com.google.cloud.datalabeling.v1beta1.Instruction.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.dataType_ != 0) {
        setDataTypeValue(other.getDataTypeValue());
      }
      if (other.hasCsvInstruction()) {
        mergeCsvInstruction(other.getCsvInstruction());
      }
      if (other.hasPdfInstruction()) {
        mergePdfInstruction(other.getPdfInstruction());
      }
      if (!other.blockingResources_.isEmpty()) {
        if (blockingResources_.isEmpty()) {
          blockingResources_ = other.blockingResources_;
          bitField0_ = (bitField0_ & ~0x00000100);
        } else {
          ensureBlockingResourcesIsMutable();
          blockingResources_.addAll(other.blockingResources_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 48:
              {
                dataType_ = input.readEnum();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 58:
              {
                input.readMessage(getCsvInstructionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 74:
              {
                input.readMessage(getPdfInstructionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 74
            case 82:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureBlockingResourcesIsMutable();
                blockingResources_.add(s);
                break;
              } // case 82
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Instruction resource name, format:
     * projects/{project_id}/instructions/{instruction_id}
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Instruction resource name, format:
     * projects/{project_id}/instructions/{instruction_id}
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Instruction resource name, format:
     * projects/{project_id}/instructions/{instruction_id}
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Instruction resource name, format:
     * projects/{project_id}/instructions/{instruction_id}
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Instruction resource name, format:
     * projects/{project_id}/instructions/{instruction_id}
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The display name of the instruction. Maximum of 64 characters.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the instruction. Maximum of 64 characters.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the instruction. Maximum of 64 characters.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the instruction. Maximum of 64 characters.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the instruction. Maximum of 64 characters.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Optional. User-provided description of the instruction.
     * The description can be up to 10000 characters long.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. User-provided description of the instruction.
     * The description can be up to 10000 characters long.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. User-provided description of the instruction.
     * The description can be up to 10000 characters long.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. User-provided description of the instruction.
     * The description can be up to 10000 characters long.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. User-provided description of the instruction.
     * The description can be up to 10000 characters long.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Creation time of instruction.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Creation time of instruction.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Creation time of instruction.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Creation time of instruction.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Creation time of instruction.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Creation time of instruction.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Creation time of instruction.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Creation time of instruction.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Creation time of instruction.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Last update time of instruction.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 5;</code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Last update time of instruction.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 5;</code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Last update time of instruction.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 5;</code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Last update time of instruction.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 5;</code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Last update time of instruction.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 5;</code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Last update time of instruction.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 5;</code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000010);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Last update time of instruction.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 5;</code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Last update time of instruction.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 5;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Last update time of instruction.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private int dataType_ = 0;
    /**
     *
     *
     * <pre>
     * Required. The data type of this instruction.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.DataType data_type = 6;</code>
     *
     * @return The enum numeric value on the wire for dataType.
     */
    @java.lang.Override
    public int getDataTypeValue() {
      return dataType_;
    }
    /**
     *
     *
     * <pre>
     * Required. The data type of this instruction.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.DataType data_type = 6;</code>
     *
     * @param value The enum numeric value on the wire for dataType to set.
     * @return This builder for chaining.
     */
    public Builder setDataTypeValue(int value) {
      dataType_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The data type of this instruction.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.DataType data_type = 6;</code>
     *
     * @return The dataType.
     */
    @java.lang.Override
    public com.google.cloud.datalabeling.v1beta1.DataType getDataType() {
      com.google.cloud.datalabeling.v1beta1.DataType result =
          com.google.cloud.datalabeling.v1beta1.DataType.forNumber(dataType_);
      return result == null ? com.google.cloud.datalabeling.v1beta1.DataType.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Required. The data type of this instruction.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.DataType data_type = 6;</code>
     *
     * @param value The dataType to set.
     * @return This builder for chaining.
     */
    public Builder setDataType(com.google.cloud.datalabeling.v1beta1.DataType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      dataType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The data type of this instruction.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.DataType data_type = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDataType() {
      bitField0_ = (bitField0_ & ~0x00000020);
      dataType_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.datalabeling.v1beta1.CsvInstruction csvInstruction_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.CsvInstruction,
            com.google.cloud.datalabeling.v1beta1.CsvInstruction.Builder,
            com.google.cloud.datalabeling.v1beta1.CsvInstructionOrBuilder>
        csvInstructionBuilder_;
    /**
     *
     *
     * <pre>
     * Deprecated: this instruction format is not supported any more.
     * Instruction from a CSV file, such as for classification task.
     * The CSV file should have exact two columns, in the following format:
     * * The first column is labeled data, such as an image reference, text.
     * * The second column is comma separated labels associated with data.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.CsvInstruction csv_instruction = 7 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.datalabeling.v1beta1.Instruction.csv_instruction is deprecated. See
     *     google/cloud/datalabeling/v1beta1/instruction.proto;l=64
     * @return Whether the csvInstruction field is set.
     */
    @java.lang.Deprecated
    public boolean hasCsvInstruction() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Deprecated: this instruction format is not supported any more.
     * Instruction from a CSV file, such as for classification task.
     * The CSV file should have exact two columns, in the following format:
     * * The first column is labeled data, such as an image reference, text.
     * * The second column is comma separated labels associated with data.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.CsvInstruction csv_instruction = 7 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.datalabeling.v1beta1.Instruction.csv_instruction is deprecated. See
     *     google/cloud/datalabeling/v1beta1/instruction.proto;l=64
     * @return The csvInstruction.
     */
    @java.lang.Deprecated
    public com.google.cloud.datalabeling.v1beta1.CsvInstruction getCsvInstruction() {
      if (csvInstructionBuilder_ == null) {
        return csvInstruction_ == null
            ? com.google.cloud.datalabeling.v1beta1.CsvInstruction.getDefaultInstance()
            : csvInstruction_;
      } else {
        return csvInstructionBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated: this instruction format is not supported any more.
     * Instruction from a CSV file, such as for classification task.
     * The CSV file should have exact two columns, in the following format:
     * * The first column is labeled data, such as an image reference, text.
     * * The second column is comma separated labels associated with data.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.CsvInstruction csv_instruction = 7 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setCsvInstruction(com.google.cloud.datalabeling.v1beta1.CsvInstruction value) {
      if (csvInstructionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        csvInstruction_ = value;
      } else {
        csvInstructionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: this instruction format is not supported any more.
     * Instruction from a CSV file, such as for classification task.
     * The CSV file should have exact two columns, in the following format:
     * * The first column is labeled data, such as an image reference, text.
     * * The second column is comma separated labels associated with data.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.CsvInstruction csv_instruction = 7 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setCsvInstruction(
        com.google.cloud.datalabeling.v1beta1.CsvInstruction.Builder builderForValue) {
      if (csvInstructionBuilder_ == null) {
        csvInstruction_ = builderForValue.build();
      } else {
        csvInstructionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: this instruction format is not supported any more.
     * Instruction from a CSV file, such as for classification task.
     * The CSV file should have exact two columns, in the following format:
     * * The first column is labeled data, such as an image reference, text.
     * * The second column is comma separated labels associated with data.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.CsvInstruction csv_instruction = 7 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder mergeCsvInstruction(com.google.cloud.datalabeling.v1beta1.CsvInstruction value) {
      if (csvInstructionBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && csvInstruction_ != null
            && csvInstruction_
                != com.google.cloud.datalabeling.v1beta1.CsvInstruction.getDefaultInstance()) {
          getCsvInstructionBuilder().mergeFrom(value);
        } else {
          csvInstruction_ = value;
        }
      } else {
        csvInstructionBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: this instruction format is not supported any more.
     * Instruction from a CSV file, such as for classification task.
     * The CSV file should have exact two columns, in the following format:
     * * The first column is labeled data, such as an image reference, text.
     * * The second column is comma separated labels associated with data.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.CsvInstruction csv_instruction = 7 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder clearCsvInstruction() {
      bitField0_ = (bitField0_ & ~0x00000040);
      csvInstruction_ = null;
      if (csvInstructionBuilder_ != null) {
        csvInstructionBuilder_.dispose();
        csvInstructionBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated: this instruction format is not supported any more.
     * Instruction from a CSV file, such as for classification task.
     * The CSV file should have exact two columns, in the following format:
     * * The first column is labeled data, such as an image reference, text.
     * * The second column is comma separated labels associated with data.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.CsvInstruction csv_instruction = 7 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.datalabeling.v1beta1.CsvInstruction.Builder getCsvInstructionBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getCsvInstructionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Deprecated: this instruction format is not supported any more.
     * Instruction from a CSV file, such as for classification task.
     * The CSV file should have exact two columns, in the following format:
     * * The first column is labeled data, such as an image reference, text.
     * * The second column is comma separated labels associated with data.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.CsvInstruction csv_instruction = 7 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.datalabeling.v1beta1.CsvInstructionOrBuilder
        getCsvInstructionOrBuilder() {
      if (csvInstructionBuilder_ != null) {
        return csvInstructionBuilder_.getMessageOrBuilder();
      } else {
        return csvInstruction_ == null
            ? com.google.cloud.datalabeling.v1beta1.CsvInstruction.getDefaultInstance()
            : csvInstruction_;
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated: this instruction format is not supported any more.
     * Instruction from a CSV file, such as for classification task.
     * The CSV file should have exact two columns, in the following format:
     * * The first column is labeled data, such as an image reference, text.
     * * The second column is comma separated labels associated with data.
     * </pre>
     *
     * <code>
     * .google.cloud.datalabeling.v1beta1.CsvInstruction csv_instruction = 7 [deprecated = true];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.CsvInstruction,
            com.google.cloud.datalabeling.v1beta1.CsvInstruction.Builder,
            com.google.cloud.datalabeling.v1beta1.CsvInstructionOrBuilder>
        getCsvInstructionFieldBuilder() {
      if (csvInstructionBuilder_ == null) {
        csvInstructionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.CsvInstruction,
                com.google.cloud.datalabeling.v1beta1.CsvInstruction.Builder,
                com.google.cloud.datalabeling.v1beta1.CsvInstructionOrBuilder>(
                getCsvInstruction(), getParentForChildren(), isClean());
        csvInstruction_ = null;
      }
      return csvInstructionBuilder_;
    }

    private com.google.cloud.datalabeling.v1beta1.PdfInstruction pdfInstruction_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.PdfInstruction,
            com.google.cloud.datalabeling.v1beta1.PdfInstruction.Builder,
            com.google.cloud.datalabeling.v1beta1.PdfInstructionOrBuilder>
        pdfInstructionBuilder_;
    /**
     *
     *
     * <pre>
     * Instruction from a PDF document. The PDF should be in a Cloud Storage
     * bucket.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.PdfInstruction pdf_instruction = 9;</code>
     *
     * @return Whether the pdfInstruction field is set.
     */
    public boolean hasPdfInstruction() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Instruction from a PDF document. The PDF should be in a Cloud Storage
     * bucket.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.PdfInstruction pdf_instruction = 9;</code>
     *
     * @return The pdfInstruction.
     */
    public com.google.cloud.datalabeling.v1beta1.PdfInstruction getPdfInstruction() {
      if (pdfInstructionBuilder_ == null) {
        return pdfInstruction_ == null
            ? com.google.cloud.datalabeling.v1beta1.PdfInstruction.getDefaultInstance()
            : pdfInstruction_;
      } else {
        return pdfInstructionBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Instruction from a PDF document. The PDF should be in a Cloud Storage
     * bucket.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.PdfInstruction pdf_instruction = 9;</code>
     */
    public Builder setPdfInstruction(com.google.cloud.datalabeling.v1beta1.PdfInstruction value) {
      if (pdfInstructionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pdfInstruction_ = value;
      } else {
        pdfInstructionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Instruction from a PDF document. The PDF should be in a Cloud Storage
     * bucket.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.PdfInstruction pdf_instruction = 9;</code>
     */
    public Builder setPdfInstruction(
        com.google.cloud.datalabeling.v1beta1.PdfInstruction.Builder builderForValue) {
      if (pdfInstructionBuilder_ == null) {
        pdfInstruction_ = builderForValue.build();
      } else {
        pdfInstructionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Instruction from a PDF document. The PDF should be in a Cloud Storage
     * bucket.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.PdfInstruction pdf_instruction = 9;</code>
     */
    public Builder mergePdfInstruction(com.google.cloud.datalabeling.v1beta1.PdfInstruction value) {
      if (pdfInstructionBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && pdfInstruction_ != null
            && pdfInstruction_
                != com.google.cloud.datalabeling.v1beta1.PdfInstruction.getDefaultInstance()) {
          getPdfInstructionBuilder().mergeFrom(value);
        } else {
          pdfInstruction_ = value;
        }
      } else {
        pdfInstructionBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Instruction from a PDF document. The PDF should be in a Cloud Storage
     * bucket.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.PdfInstruction pdf_instruction = 9;</code>
     */
    public Builder clearPdfInstruction() {
      bitField0_ = (bitField0_ & ~0x00000080);
      pdfInstruction_ = null;
      if (pdfInstructionBuilder_ != null) {
        pdfInstructionBuilder_.dispose();
        pdfInstructionBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Instruction from a PDF document. The PDF should be in a Cloud Storage
     * bucket.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.PdfInstruction pdf_instruction = 9;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.PdfInstruction.Builder getPdfInstructionBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getPdfInstructionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Instruction from a PDF document. The PDF should be in a Cloud Storage
     * bucket.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.PdfInstruction pdf_instruction = 9;</code>
     */
    public com.google.cloud.datalabeling.v1beta1.PdfInstructionOrBuilder
        getPdfInstructionOrBuilder() {
      if (pdfInstructionBuilder_ != null) {
        return pdfInstructionBuilder_.getMessageOrBuilder();
      } else {
        return pdfInstruction_ == null
            ? com.google.cloud.datalabeling.v1beta1.PdfInstruction.getDefaultInstance()
            : pdfInstruction_;
      }
    }
    /**
     *
     *
     * <pre>
     * Instruction from a PDF document. The PDF should be in a Cloud Storage
     * bucket.
     * </pre>
     *
     * <code>.google.cloud.datalabeling.v1beta1.PdfInstruction pdf_instruction = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.datalabeling.v1beta1.PdfInstruction,
            com.google.cloud.datalabeling.v1beta1.PdfInstruction.Builder,
            com.google.cloud.datalabeling.v1beta1.PdfInstructionOrBuilder>
        getPdfInstructionFieldBuilder() {
      if (pdfInstructionBuilder_ == null) {
        pdfInstructionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.datalabeling.v1beta1.PdfInstruction,
                com.google.cloud.datalabeling.v1beta1.PdfInstruction.Builder,
                com.google.cloud.datalabeling.v1beta1.PdfInstructionOrBuilder>(
                getPdfInstruction(), getParentForChildren(), isClean());
        pdfInstruction_ = null;
      }
      return pdfInstructionBuilder_;
    }

    private com.google.protobuf.LazyStringList blockingResources_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureBlockingResourcesIsMutable() {
      if (!((bitField0_ & 0x00000100) != 0)) {
        blockingResources_ = new com.google.protobuf.LazyStringArrayList(blockingResources_);
        bitField0_ |= 0x00000100;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of any related resources that are blocking changes
     * to the instruction.
     * </pre>
     *
     * <code>repeated string blocking_resources = 10;</code>
     *
     * @return A list containing the blockingResources.
     */
    public com.google.protobuf.ProtocolStringList getBlockingResourcesList() {
      return blockingResources_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of any related resources that are blocking changes
     * to the instruction.
     * </pre>
     *
     * <code>repeated string blocking_resources = 10;</code>
     *
     * @return The count of blockingResources.
     */
    public int getBlockingResourcesCount() {
      return blockingResources_.size();
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of any related resources that are blocking changes
     * to the instruction.
     * </pre>
     *
     * <code>repeated string blocking_resources = 10;</code>
     *
     * @param index The index of the element to return.
     * @return The blockingResources at the given index.
     */
    public java.lang.String getBlockingResources(int index) {
      return blockingResources_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of any related resources that are blocking changes
     * to the instruction.
     * </pre>
     *
     * <code>repeated string blocking_resources = 10;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the blockingResources at the given index.
     */
    public com.google.protobuf.ByteString getBlockingResourcesBytes(int index) {
      return blockingResources_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of any related resources that are blocking changes
     * to the instruction.
     * </pre>
     *
     * <code>repeated string blocking_resources = 10;</code>
     *
     * @param index The index to set the value at.
     * @param value The blockingResources to set.
     * @return This builder for chaining.
     */
    public Builder setBlockingResources(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureBlockingResourcesIsMutable();
      blockingResources_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of any related resources that are blocking changes
     * to the instruction.
     * </pre>
     *
     * <code>repeated string blocking_resources = 10;</code>
     *
     * @param value The blockingResources to add.
     * @return This builder for chaining.
     */
    public Builder addBlockingResources(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureBlockingResourcesIsMutable();
      blockingResources_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of any related resources that are blocking changes
     * to the instruction.
     * </pre>
     *
     * <code>repeated string blocking_resources = 10;</code>
     *
     * @param values The blockingResources to add.
     * @return This builder for chaining.
     */
    public Builder addAllBlockingResources(java.lang.Iterable<java.lang.String> values) {
      ensureBlockingResourcesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, blockingResources_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of any related resources that are blocking changes
     * to the instruction.
     * </pre>
     *
     * <code>repeated string blocking_resources = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBlockingResources() {
      blockingResources_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The names of any related resources that are blocking changes
     * to the instruction.
     * </pre>
     *
     * <code>repeated string blocking_resources = 10;</code>
     *
     * @param value The bytes of the blockingResources to add.
     * @return This builder for chaining.
     */
    public Builder addBlockingResourcesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureBlockingResourcesIsMutable();
      blockingResources_.add(value);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.datalabeling.v1beta1.Instruction)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.datalabeling.v1beta1.Instruction)
  private static final com.google.cloud.datalabeling.v1beta1.Instruction DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.datalabeling.v1beta1.Instruction();
  }

  public static com.google.cloud.datalabeling.v1beta1.Instruction getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Instruction> PARSER =
      new com.google.protobuf.AbstractParser<Instruction>() {
        @java.lang.Override
        public Instruction parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Instruction> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Instruction> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.datalabeling.v1beta1.Instruction getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
